/*
 * Copyright (C) 2023, KylinSoft Co., Ltd.
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 3, or (at your option)
 * any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, see <http://www.gnu.org/licenses/>.
 *
**/
#ifndef ADDLANGUAGEDIALOG_H
#define ADDLANGUAGEDIALOG_H

#include <QDialog>
#include <QStandardItemModel>
#include "kwidget.h"
#include "ksearchlineedit.h"

namespace Ui {
class AddLanguageDialog;
}

using namespace kdk;

class AddLanguageDialog : public QDialog
{
    Q_OBJECT

public:
    explicit AddLanguageDialog(QWidget *parent = nullptr);
    ~AddLanguageDialog();
    void initCompleter();
    void addRow(const QString &languageName);

public:
    static const QList<QPair<QString, QPair<QString, QString>>> supportedLanguageList;
    void initDict();
    QString chineseToPinyin(const QString &words);
    QString removeDigital(QString input);

protected:
    void showEvent(QShowEvent *e);

Q_SIGNALS:
    void addShowLanguage(QStringList selectedLanguageList);

private:
    Ui::AddLanguageDialog *ui;
//    LanguageInfo *languageInfo = nullptr;
//    QMap<QString, QString> availableLangMap;
//    QMap<QString, QString> installedLangMap;
    QStandardItemModel *mode = nullptr;
    kdk::KSearchLineEdit *mSearchLineEdit = nullptr;
    QHash<uint, QString> dict = {};
    const QString kDictFile = ":/dpinyin.dict";
};

#endif // ADDLANGUAGEDIALOG_H
