/*
 * Copyright (C) 2023, KylinSoft Co., Ltd.
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 3, or (at your option)
 * any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, see <http://www.gnu.org/licenses/>.
 *
**/
#ifndef ABOUTUI_H
#define ABOUTUI_H

#include <QObject>
#include <QWidget>
#include <QHBoxLayout>

#include "HpQRCodeInterface.h"
#include "ukcccommon.h"
#include "hostnamedialog.h"
#include "privacydialog.h"
#include "statusdialog.h"
#include "shell/interface.h"
#include "titlelabel.h"
#include "fixlabel.h"
#include "lightlabel.h"
#include "kswitchbutton.h"
#ifdef KY_SDK_SYSINFO
#include <kysdk/kysdk-system/libkysysinfo.h>
#endif
#include <kborderlessbutton.h>

using namespace ukcc;
using namespace kdk;

class AboutUi : public QWidget
{
    Q_OBJECT
public:
    explicit AboutUi(QWidget *parent = nullptr);

    void initUi();
    void initCopyRightName();
    QFrame *initHoldUi();
    QFrame *initActiveUi();
    QFrame *initPrivacyUi();
    QFrame *initInfoBtnUi();
    void initSearchText();
    void setComponent();

    QPushButton *getActivationBtn() {return mActivationBtn;}
    QPushButton *getHpBtn() {return mHpBtn;}
    QPushButton *getEducateBtn() {return mEducateBtn;}

    KSwitchButton *getPriBtn() {return mPriBtn;}

    KBorderlessButton *getTrialBtn() {return mTrialBtn;}
    KBorderlessButton *getAgreeBtn() {return mAgreeBtn;}

    QLabel *getLogo() {return mLogoLabel;}
    QLabel *getAndLabel() {return mAndLabel;}

    LightLabel *getVersion() {return mVersionLabel_2;}
    LightLabel *getBuild() {return mVersionNumberLabel_2;}
    LightLabel *getPatchVersion() {return mPatchVersionLabel_2;}
    LightLabel *getDesktopEnv() {return mDesktopLabel_2;}
    LightLabel *getUserName() {return mUsernameLabel_2;}
    LightLabel *getKerner() {return mKernelLabel_2;}
    LightLabel *getCpuInfo() {return mCpuLabel_2;}
    LightLabel *getHostName() {return mHostNameLabel_2;}
    LightLabel *getMemeory() {return mMemoryLabel_2;}
    LightLabel *getActiveStatus() {return mStatusLabel_2;}
    LightLabel *getDiskContent() {return mDiskLabel_2;}
    LightLabel *getInstallDate() {return mInstallDateLabel_2;}
    LightLabel *getUpgradeDate() {return mUpgradeDateLabel_2;}
    LightLabel *getEditHost() {return mHostNameLabel_3;}

    FixLabel *getSequence() {return mSequenceLabel_1;}
    KBorderlessButton *getSequenceContent() {return mSequenceLabel_2;}
    FixLabel *getDiskLabel() {return mDiskLabel_1;}

    QFrame *getBuildFrame() {return mVersionNumberFrame;}
    QFrame *getPatchFrame() {return mPatchVersionFrame;}
    QFrame *getActivaFrame() {return mActivationFrame;}
    QFrame *getDiskFrame() {return mDiskFrame;}
    QFrame *getInstallDateFrame() {return mInstallDateFrame;}
    QFrame *getUpgradeDateFrame() {return mUpgradeDateFrame;}

    QHBoxLayout *getDiskLayout() {return mDiskLayout;}


private:
    QFrame *createFrame(FixLabel *label_1, LightLabel *label_2, LightLabel *label_3 = nullptr);
    void setShape(QFrame *frame, QFrame::Shape shape);
    QPixmap loadSvg(const QString &path, int width, int height);

private:
    QFrame *mHoldWidget;
    QWidget *mQrCodeWidget;

    TitleLabel *mTitleLabel;
    TitleLabel *mPriTitleLabel;
    TitleLabel *mHoldTitleLabel;

    QFrame *mInformationFrame;
    QFrame *mActivationFrame;
    QFrame *mVersionFrame;
    QFrame *mVersionNumFrame;
    QFrame *mVersionNumberFrame;
    QFrame *mPatchVersionFrame;
    QFrame *mInstallDateFrame;
    QFrame *mUpgradeDateFrame;
    QFrame *mInterVersionFrame;
    QFrame *mHostNameFrame;
    QFrame *mKernelFrame;
    QFrame *mCpuFrame;
    QFrame *mMemoryFrame;
    QFrame *mDiskFrame;
    QFrame *mDesktopFrame;
    QFrame *mUsernameFrame;
    QFrame *mPrivacyFrame;
    QFrame *mBtnFrame;

    QHBoxLayout *mDiskLayout;

    FixLabel *mLogoLabel;
    FixLabel *mVersionLabel_1;
    FixLabel *mVersionNumLabel_1;
    FixLabel *mVersionNumberLabel_1;
    FixLabel *mPatchVersionLabel_1;
    FixLabel *mInstallDateLabel_1;
    FixLabel *mUpgradeDateLabel_1;
    FixLabel *mInterVersionLabel_1;
    FixLabel *mHostNameLabel_1;
    FixLabel *mKernelLabel_1;
    FixLabel *mCpuLabel_1;
    FixLabel *mMemoryLabel_1;
    FixLabel *mDiskLabel_1;
    FixLabel *mDesktopLabel_1;
    FixLabel *mUsernameLabel_1;
    LightLabel *mVersionLabel_2;
    LightLabel *mVersionNumLabel_2;
    LightLabel *mVersionNumberLabel_2;
    LightLabel *mPatchVersionLabel_2;
    LightLabel *mInstallDateLabel_2;
    LightLabel *mUpgradeDateLabel_2;
    LightLabel *mInterVersionLabel_2;
    LightLabel *mHostNameLabel_2;
    LightLabel *mHostNameLabel_3;
    LightLabel *mKernelLabel_2;
    LightLabel *mCpuLabel_2;
    LightLabel *mMemoryLabel_2;
    LightLabel *mDiskLabel_2;
    LightLabel *mDesktopLabel_2;
    LightLabel *mUsernameLabel_2;


    FixLabel *mStatusLabel_1;
    LightLabel *mStatusLabel_2;
    FixLabel *mSequenceLabel_1;
    KBorderlessButton *mSequenceLabel_2;
    FixLabel *mTrialLabel;
    FixLabel *mAndLabel;
    FixLabel *mAgreeLabel;
    QLabel *mHpLabel;
    FixLabel *mEducateIconLabel;
    QLabel *mEducateLabel;
    FixLabel *mTipLabel;

    QPushButton *mActivationBtn;
    QPushButton *mHpBtn;
    QPushButton *mEducateBtn;
    KSwitchButton *mPriBtn;

    KBorderlessButton *mTrialBtn;
    KBorderlessButton *mAgreeBtn;

    QSpacerItem *item;

    hp::QRCodeInterface *app; //hp插件

    QString mCopyRightName;
    QString mCopyRightYear;

};

#endif // ABOUTUI_H
