/*
 * Copyright (C) 2023, KylinSoft Co., Ltd.
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 3, or (at your option)
 * any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, see <http://www.gnu.org/licenses/>.
 *
**/

#include "listdelegate.h"

ListDelegate::ListDelegate(QObject *parent):QStyledItemDelegate(parent)
{

}

ListDelegate::~ListDelegate()
{

}

void ListDelegate::paint(QPainter *painter, const QStyleOptionViewItem &option, const QModelIndex &index) const
{
    QStyleOptionViewItem optionVI = option;
    if (option.state & QStyle::State_MouseOver) {
        optionVI.state &= (~QStyle::State_MouseOver);
    }
    QStyledItemDelegate::paint(painter, optionVI, index);
}
