## TFSA-2022-163: Segfault in `CompositeTensorVariantToComponents`

### CVE Number
CVE-2022-41909

### Impact
An input `encoded` that is not a valid `CompositeTensorVariant` tensor will trigger a segfault in [`tf.raw_ops.CompositeTensorVariantToComponents`](https://github.com/tensorflow/tensorflow/blob/master/tensorflow/python/lib/core/py_func.cc).

```python
import tensorflow as tf

encode = tf.raw_ops.EmptyTensorList(element_dtype=tf.int32, element_shape=[10, 15], max_num_elements=2)
meta= ""
component=[tf.int32]

print(tf.raw_ops.CompositeTensorVariantToComponents(encoded=encode,metadata=meta,Tcomponents=component))
```

### Patches
We have patched the issue in GitHub commits [bf594d08d377dc6a3354d9fdb494b32d45f91971](https://github.com/tensorflow/tensorflow/commit/bf594d08d377dc6a3354d9fdb494b32d45f91971) and [660ce5a89eb6766834bdc303d2ab3902aef99d3d](https://github.com/tensorflow/tensorflow/commit/660ce5a89eb6766834bdc303d2ab3902aef99d3d).

The fix will be included in TensorFlow 2.11. We will also cherrypick this commit on TensorFlow 2.10.1, 2.9.3, and TensorFlow 2.8.4, as these are also affected and still in supported range.


### For more information
Please consult [our security guide](https://github.com/tensorflow/tensorflow/blob/master/SECURITY.md) for more information regarding the security model and how to contact us with issues and questions.


### Attribution
This vulnerability has been reported by pattarakritr@smu.edu.sg
