## TFSA-2022-023: Integer overflow in TFLite array creation

### CVE Number
CVE-2022-23558

### Impact
An attacker can craft a TFLite model that would cause an integer overflow [in `TfLiteIntArrayCreate`](https://github.com/tensorflow/tensorflow/blob/ca6f96b62ad84207fbec580404eaa7dd7403a550/tensorflow/lite/c/common.c#L53-L60):

```cc
TfLiteIntArray* TfLiteIntArrayCreate(int size) {
  int alloc_size = TfLiteIntArrayGetSizeInBytes(size);
  // ...
  TfLiteIntArray* ret = (TfLiteIntArray*)malloc(alloc_size);
  // ...
}
```

The [`TfLiteIntArrayGetSizeInBytes`](https://github.com/tensorflow/tensorflow/blob/ca6f96b62ad84207fbec580404eaa7dd7403a550/tensorflow/lite/c/common.c#L24-L33) returns an `int` instead of a `size_t`:

```cc
int TfLiteIntArrayGetSizeInBytes(int size) {
  static TfLiteIntArray dummy;

  int computed_size = sizeof(dummy) + sizeof(dummy.data[0]) * size;
#if defined(_MSC_VER)
  // Context for why this is needed is in http://b/189926408#comment21
  computed_size -= sizeof(dummy.data[0]);
#endif
  return computed_size;
}
```

An attacker can control model inputs such that `computed_size` overflows the size of `int` datatype.

### Patches
We have patched the issue in GitHub commit [a1e1511dde36b3f8aa27a6ec630838e7ea40e091](https://github.com/tensorflow/tensorflow/commit/a1e1511dde36b3f8aa27a6ec630838e7ea40e091).

The fix will be included in TensorFlow 2.8.0. We will also cherrypick this commit on TensorFlow 2.7.1, TensorFlow 2.6.3, and TensorFlow 2.5.3, as these are also affected and still in supported range.

### For more information
Please consult [our security guide](https://github.com/tensorflow/tensorflow/blob/master/SECURITY.md) for more information regarding the security model and how to contact us with issues and questions.

### Attribution
This vulnerability has been reported by Wang Xuan of Qihoo 360 AIVul Team.
