## TFSA-2021-130: Reference binding to nullptr in `RaggedTensorToSparse`

### CVE Number
CVE-2021-37656

### Impact
An attacker can cause undefined behavior via binding a reference to null pointer
in `tf.raw_ops.RaggedTensorToSparse`:

```python
import tensorflow as tf

tf.raw_ops.RaggedTensorToSparse(
  rt_nested_splits=[[0, 38, 0]],
  rt_dense_values=[])
```

The
[implementation](https://github.com/tensorflow/tensorflow/blob/f24faa153ad31a4b51578f8181d3aaab77a1ddeb/tensorflow/core/kernels/ragged_tensor_to_sparse_kernel.cc#L30)
has an incomplete validation of the splits values: it does not check that they
are in increasing order.

### Patches
We have patched the issue in GitHub commit
[1071f554dbd09f7e101324d366eec5f4fe5a3ece](https://github.com/tensorflow/tensorflow/commit/1071f554dbd09f7e101324d366eec5f4fe5a3ece).

The fix will be included in TensorFlow 2.6.0. We will also cherrypick this
commit on TensorFlow 2.5.1, TensorFlow 2.4.3, and TensorFlow 2.3.4, as these are
also affected and still in supported range.

### For more information
Please consult [our security
guide](https://github.com/tensorflow/tensorflow/blob/master/SECURITY.md) for
more information regarding the security model and how to contact us with issues
and questions.

### Attribution
This vulnerability has been reported by members of the Aivul Team from Qihoo
360.
