<?php

/*
 * This file is part of the Symfony package.
 *
 * (c) Fabien Potencier <fabien@symfony.com>
 *
 * For the full copyright and license information, please view the LICENSE
 * file that was distributed with this source code.
 */

namespace Symfony\Component\Form\Tests\Extension\Validator\Type;

use Symfony\Component\Form\Extension\Core\Type\TimeType;

class TimeTypeValidatorExtensionTest extends BaseValidatorExtensionTestCase
{
    protected function createForm(array $options = [])
    {
        return $this->factory->create(TimeType::class, null, $options + ['widget' => 'choice']);
    }

    public function testInvalidMessage()
    {
        $form = $this->createForm();

        $this->assertSame('Please enter a valid time.', $form->getConfig()->getOption('invalid_message'));
    }
}
