use std::path::Path;

/// Loads CPU usage records from a CSV generated by the `src/ci/scripts/collect-cpu-stats.sh`
/// script.
pub fn load_cpu_usage(path: &Path) -> anyhow::Result<Vec<f64>> {
    let reader = csv::ReaderBuilder::new().flexible(true).from_path(path)?;

    let mut entries = vec![];
    for row in reader.into_records() {
        let row = row?;
        let cols = row.into_iter().collect::<Vec<&str>>();

        // The log might contain incomplete rows or some Python exception
        if cols.len() == 2 {
            if let Ok(idle) = cols[1].parse::<f64>() {
                entries.push(100.0 - idle);
            } else {
                eprintln!("Warning: cannot parse CPU CSV entry {}", cols[1]);
            }
        }
    }

    Ok(entries)
}
