# coding=utf-8
# --------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for license information.
# Code generated by Microsoft (R) Python Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is regenerated.
# --------------------------------------------------------------------------

from enum import Enum
from azure.core import CaseInsensitiveEnumMeta


class ActionType(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """Extensible enum. Indicates the action type. "Internal" refers to actions that are for internal
    only APIs.
    """

    INTERNAL = "Internal"
    """Actions are for internal-only APIs."""


class AlertRuleCreationProperties(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """The properties with which the alert rule resource was created."""

    CREATED_WITH_ACTION_GROUP = "CreatedWithActionGroup"
    """The alert rule was created with an action group."""
    NONE = "None"
    """The alert rule was created with no properties."""


class CreatedByType(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """The kind of entity that created the resource."""

    USER = "User"
    """The entity was created by a user."""
    APPLICATION = "Application"
    """The entity was created by an application."""
    MANAGED_IDENTITY = "ManagedIdentity"
    """The entity was created by a managed identity."""
    KEY = "Key"
    """The entity was created by a key."""


class DatabaseWatcherProvisioningState(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """The status of the last provisioning operation performed on the resource."""

    SUCCEEDED = "Succeeded"
    """Resource has been created."""
    FAILED = "Failed"
    """Resource creation failed."""
    CANCELED = "Canceled"
    """Resource creation was canceled."""


class KustoOfferingType(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """The type of Kusto offering."""

    ADX = "adx"
    """The Azure Data Explorer cluster Kusto offering."""
    FREE = "free"
    """The free Azure Data Explorer cluster Kusto offering."""
    FABRIC = "fabric"
    """The Fabric Real-Time Analytics Kusto offering."""


class ManagedServiceIdentityType(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """Type of managed service identity (where both SystemAssigned and UserAssigned types are
    allowed).
    """

    NONE = "None"
    """No managed identity."""
    SYSTEM_ASSIGNED = "SystemAssigned"
    """System assigned managed identity."""
    USER_ASSIGNED = "UserAssigned"
    """User assigned managed identity."""
    SYSTEM_AND_USER_ASSIGNED = "SystemAssigned, UserAssigned"
    """System and user assigned managed identity."""


class Origin(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """The intended executor of the operation; as in Resource Based Access Control (RBAC) and audit
    logs UX. Default value is "user,system".
    """

    USER = "user"
    """Indicates the operation is initiated by a user."""
    SYSTEM = "system"
    """Indicates the operation is initiated by a system."""
    USER_SYSTEM = "user,system"
    """Indicates the operation is initiated by a user or system."""


class ResourceProvisioningState(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """The provisioning state of a resource type."""

    SUCCEEDED = "Succeeded"
    """Resource has been created."""
    FAILED = "Failed"
    """Resource creation failed."""
    CANCELED = "Canceled"
    """Resource creation was canceled."""


class SharedPrivateLinkResourceStatus(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """Status of the shared private link resource. Can be Pending, Approved, Rejected or Disconnected."""

    PENDING = "Pending"
    """The shared private link connection request was not yet authorized by the resource owner."""
    APPROVED = "Approved"
    """The shared private link connection request was approved by the resource owner."""
    REJECTED = "Rejected"
    """The shared private link connection request was rejected by the resource owner."""
    DISCONNECTED = "Disconnected"
    """The shared private link connection request was disconnected by the resource owner."""


class TargetAuthenticationType(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """The type of authentication to use when connecting to a target."""

    AAD = "Aad"
    """The Azure Active Directory authentication."""
    SQL = "Sql"
    """The SQL password authentication."""


class ValidationStatus(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """Health validation status."""

    NOT_STARTED = "NotStarted"
    """Health validation has not started."""
    RUNNING = "Running"
    """Health validation is running."""
    SUCCEEDED = "Succeeded"
    """Health validation completed successfully."""
    FAILED = "Failed"
    """Health validation failed."""
    CANCELED = "Canceled"
    """Health validation was canceled."""
    TIMED_OUT = "TimedOut"
    """Health validation timed out."""


class WatcherStatus(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """The monitoring collection status of a watcher."""

    STARTING = "Starting"
    """Denotes the watcher is in a starting state."""
    RUNNING = "Running"
    """Denotes the watcher is in a running state."""
    STOPPING = "Stopping"
    """Denotes the watcher is in a stopping state."""
    STOPPED = "Stopped"
    """Denotes the watcher is in a stopped state."""
    DELETING = "Deleting"
    """Denotes the watcher is in a deleting state."""
