/*
! @file test_base.c
! @author Kyle Horne <horne.kyle@gmail.com>
! @version 0.2
!
! @section LICENSE
! BSD style license
!
! @section DESCRIPTION
! Test program for pcgns library
*/

#include <stdio.h>
#include <stdlib.h>

#include "pcgnslib.h"
#include "mpi.h"

#define cgp_doError {printf("Error at %s:%u\n",__FILE__, __LINE__); return 1;}

int main(int argc, char* argv[]) {
	int err;
	int comm_size;
	int comm_rank;
	MPI_Info info;
	int fn;
	int B;
	char basename[100];
	int cell_dim = 3;
	int phys_dim = 3;

	err = MPI_Init(&argc,&argv);
	if(err!=MPI_SUCCESS) cgp_doError;
	err = MPI_Comm_size(MPI_COMM_WORLD, &comm_size);
	if(err!=MPI_SUCCESS) cgp_doError;
	err = MPI_Comm_rank(MPI_COMM_WORLD, &comm_rank);
	if(err!=MPI_SUCCESS) cgp_doError;
	err = MPI_Info_create(&(info));
	if(err!=MPI_SUCCESS) cgp_doError;

	if (cgp_open("test_base.cgns", CG_MODE_WRITE, &fn) ||
	    cg_base_write(fn, "Base 1", cell_dim, phys_dim, &B) ||
	    cgp_close(fn))
	    cgp_error_exit();
	if (cgp_open("test_base.cgns", CG_MODE_READ, &fn) ||
	    cg_base_read(fn, B, basename, &cell_dim, &phys_dim) ||
	    cgp_close(fn))
	    cgp_error_exit();

	err = MPI_Finalize();
	if(err!=MPI_SUCCESS) cgp_doError;
	return err;
	}
