; NOTE: Assertions have been autogenerated by utils/update_llc_test_checks.py UTC_ARGS: --version 5
; RUN: llc -verify-machineinstrs -mcpu=pwr7 -mtriple=powerpc64-unknown-linux-gnu -mattr=-vsx < %s | FileCheck %s
; RUN: llc -verify-machineinstrs -mcpu=pwr7 -mtriple=powerpc64-unknown-linux-gnu -mattr=+vsx < %s | FileCheck %s -check-prefix=CHECK-VSX
target datalayout = "E-p:64:64:64-i1:8:8-i8:8:8-i16:16:16-i32:32:32-i64:64:64-f32:32:32-f64:64:64-f128:128:128-v128:128:128-n32:64"
target triple = "powerpc64-unknown-linux-gnu"

define double @foo_d_ll(ppc_fp128 %a, ppc_fp128 %b) #0 {
; CHECK-LABEL: foo_d_ll:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    fcpsgn 1, 3, 1
; CHECK-NEXT:    blr
;
; CHECK-VSX-LABEL: foo_d_ll:
; CHECK-VSX:       # %bb.0: # %entry
; CHECK-VSX-NEXT:    xscpsgndp 1, 3, 1
; CHECK-VSX-NEXT:    blr
entry:
  %call = tail call ppc_fp128 @copysignl(ppc_fp128 %a, ppc_fp128 %b) #0
  %conv = fptrunc ppc_fp128 %call to double
  ret double %conv
}

define double @foo_d_ll_freeze(ppc_fp128 %a, ppc_fp128 %b) #0 {
; CHECK-LABEL: foo_d_ll_freeze:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    fcpsgn 1, 3, 1
; CHECK-NEXT:    blr
;
; CHECK-VSX-LABEL: foo_d_ll_freeze:
; CHECK-VSX:       # %bb.0: # %entry
; CHECK-VSX-NEXT:    xscpsgndp 1, 3, 1
; CHECK-VSX-NEXT:    blr
entry:
  %call = tail call ppc_fp128 @copysignl(ppc_fp128 %a, ppc_fp128 %b) #0
  %freeze = freeze ppc_fp128 %call
  %conv = fptrunc ppc_fp128 %freeze to double
  ret double %conv
}

declare ppc_fp128 @copysignl(ppc_fp128, ppc_fp128) #0

define double @foo_dl(double %a, ppc_fp128 %b) #0 {
; CHECK-LABEL: foo_dl:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    fcpsgn 1, 2, 1
; CHECK-NEXT:    blr
;
; CHECK-VSX-LABEL: foo_dl:
; CHECK-VSX:       # %bb.0: # %entry
; CHECK-VSX-NEXT:    xscpsgndp 1, 2, 1
; CHECK-VSX-NEXT:    blr
entry:
  %conv = fptrunc ppc_fp128 %b to double
  %call = tail call double @copysign(double %a, double %conv) #0
  ret double %call
}

declare double @copysign(double, double) #0

define ppc_fp128 @foo_ll(double %a, ppc_fp128 %b) #0 {
; CHECK-LABEL: foo_ll:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    mflr 0
; CHECK-NEXT:    stdu 1, -112(1)
; CHECK-NEXT:    fmr 3, 2
; CHECK-NEXT:    addis 3, 2, .LCPI3_0@toc@ha
; CHECK-NEXT:    std 0, 128(1)
; CHECK-NEXT:    lfs 2, .LCPI3_0@toc@l(3)
; CHECK-NEXT:    bl copysignl
; CHECK-NEXT:    nop
; CHECK-NEXT:    addi 1, 1, 112
; CHECK-NEXT:    ld 0, 16(1)
; CHECK-NEXT:    mtlr 0
; CHECK-NEXT:    blr
;
; CHECK-VSX-LABEL: foo_ll:
; CHECK-VSX:       # %bb.0: # %entry
; CHECK-VSX-NEXT:    mflr 0
; CHECK-VSX-NEXT:    stdu 1, -112(1)
; CHECK-VSX-NEXT:    fmr 3, 2
; CHECK-VSX-NEXT:    xxlxor 2, 2, 2
; CHECK-VSX-NEXT:    std 0, 128(1)
; CHECK-VSX-NEXT:    bl copysignl
; CHECK-VSX-NEXT:    nop
; CHECK-VSX-NEXT:    addi 1, 1, 112
; CHECK-VSX-NEXT:    ld 0, 16(1)
; CHECK-VSX-NEXT:    mtlr 0
; CHECK-VSX-NEXT:    blr
entry:
  %conv = fpext double %a to ppc_fp128
  %call = tail call ppc_fp128 @copysignl(ppc_fp128 %conv, ppc_fp128 %b) #0
  ret ppc_fp128 %call
}

define ppc_fp128 @foo_ld(double %a, double %b) #0 {
; CHECK-LABEL: foo_ld:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    mflr 0
; CHECK-NEXT:    stdu 1, -112(1)
; CHECK-NEXT:    fmr 3, 2
; CHECK-NEXT:    addis 3, 2, .LCPI4_0@toc@ha
; CHECK-NEXT:    std 0, 128(1)
; CHECK-NEXT:    lfs 2, .LCPI4_0@toc@l(3)
; CHECK-NEXT:    bl copysignl
; CHECK-NEXT:    nop
; CHECK-NEXT:    addi 1, 1, 112
; CHECK-NEXT:    ld 0, 16(1)
; CHECK-NEXT:    mtlr 0
; CHECK-NEXT:    blr
;
; CHECK-VSX-LABEL: foo_ld:
; CHECK-VSX:       # %bb.0: # %entry
; CHECK-VSX-NEXT:    mflr 0
; CHECK-VSX-NEXT:    stdu 1, -112(1)
; CHECK-VSX-NEXT:    fmr 3, 2
; CHECK-VSX-NEXT:    xxlxor 2, 2, 2
; CHECK-VSX-NEXT:    std 0, 128(1)
; CHECK-VSX-NEXT:    bl copysignl
; CHECK-VSX-NEXT:    nop
; CHECK-VSX-NEXT:    addi 1, 1, 112
; CHECK-VSX-NEXT:    ld 0, 16(1)
; CHECK-VSX-NEXT:    mtlr 0
; CHECK-VSX-NEXT:    blr
entry:
  %conv = fpext double %a to ppc_fp128
  %conv1 = fpext double %b to ppc_fp128
  %call = tail call ppc_fp128 @copysignl(ppc_fp128 %conv, ppc_fp128 %conv1) #0
  ret ppc_fp128 %call
}

define ppc_fp128 @foo_lf(double %a, float %b) #0 {
; CHECK-LABEL: foo_lf:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    mflr 0
; CHECK-NEXT:    stdu 1, -112(1)
; CHECK-NEXT:    fmr 3, 2
; CHECK-NEXT:    addis 3, 2, .LCPI5_0@toc@ha
; CHECK-NEXT:    std 0, 128(1)
; CHECK-NEXT:    lfs 2, .LCPI5_0@toc@l(3)
; CHECK-NEXT:    bl copysignl
; CHECK-NEXT:    nop
; CHECK-NEXT:    addi 1, 1, 112
; CHECK-NEXT:    ld 0, 16(1)
; CHECK-NEXT:    mtlr 0
; CHECK-NEXT:    blr
;
; CHECK-VSX-LABEL: foo_lf:
; CHECK-VSX:       # %bb.0: # %entry
; CHECK-VSX-NEXT:    mflr 0
; CHECK-VSX-NEXT:    stdu 1, -112(1)
; CHECK-VSX-NEXT:    fmr 3, 2
; CHECK-VSX-NEXT:    xxlxor 2, 2, 2
; CHECK-VSX-NEXT:    std 0, 128(1)
; CHECK-VSX-NEXT:    bl copysignl
; CHECK-VSX-NEXT:    nop
; CHECK-VSX-NEXT:    addi 1, 1, 112
; CHECK-VSX-NEXT:    ld 0, 16(1)
; CHECK-VSX-NEXT:    mtlr 0
; CHECK-VSX-NEXT:    blr
entry:
  %conv = fpext double %a to ppc_fp128
  %conv1 = fpext float %b to ppc_fp128
  %call = tail call ppc_fp128 @copysignl(ppc_fp128 %conv, ppc_fp128 %conv1) #0
  ret ppc_fp128 %call
}

attributes #0 = { nounwind readnone }

