"""
/* linbox/algorithms/opencl-domain-setup.inl
 * Copyright (C) 2011-2012 Matthew Wezowicz
 *
 * Written by Matthew Wezowicz <mwezz@udel.edu>
 *
 * ========LICENCE========
 * This file is part of the library LinBox.
 * 
 * LinBox is free software: you can redistribute it and/or modify
 * it under the terms of the  GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 * 
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 * 
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA
 * ========LICENCE========
 *.
 */
"""

import string
import time

def parse_kernel(file_name, output):
    # Open the kernel file
    fp = open(file_name)

    # Begin parsing of the kernel file
    parsed = []

    # Search for the kernel name in the file
    # Once found generate the const char* kernel name line
    for line in fp.readlines():
        line = string.split(line)
        if(len(line) > 0 and line[0] == '__kernel'):
            parsed.append("const char*")
            temp = string.split(line[2],'(')
            parsed.append(temp[0])
            parsed.append("= {\n")
            break
    
    # Join the line with spaces
    parsed = string.join(parsed)

    # Write the const char* kernel name line to the header file
    output.write("\t")
    output.write(parsed)

    # Seek to beginning of the kernel file
    fp.seek(0,0)

    # Skip over the comment block at the beginning of the kernel file
    # Write rest of file to the const char* block
    for line in fp.readlines():
        temp = string.split(line)
        if(len(temp) > 0 and (temp[0] == '/*' or temp[0] == '*' or temp[0] == '*/' or temp[0][:2] == '//')):
            continue
        if(len(temp) == 0):
            continue
        output.write("\t\t\"")
        output.write(string.rstrip(line))
        output.write("\\n\"\n")

    # End const char* block
    output.write("\t};\n\n")

    # Close kernel file
    fp.close()

    return

def gen_timestamp():
    # Get the time
    timestruct = time.localtime()

    # Begin generating the timestamp string
    timestamp = ""
    if(timestruct.tm_mon < 10):
        timestamp = "0" + str(timestruct.tm_mon) + "/"
    else:
        timestamp = str(timestruct.tm_mon) + "/"

    if(timestruct.tm_mday < 10):
        timestamp += "0" + str(timestruct.tm_mday) + "/"
    else:
        timestamp += str(timestruct.tm_mday) + "/"

    timestamp += str(timestruct.tm_year) + " "

    if(timestruct.tm_hour < 10):
        timestamp += "0" + str(timestruct.tm_hour) + ":"
    else:
        timestamp += str(timestruct.tm_hour) + ":"

    if(timestruct.tm_min < 10):
        timestamp += "0" + str(timestruct.tm_min) + ":"
    else:
        timestamp += str(timestruct.tm_min) + ":"

    if(timestruct.tm_sec < 10):
        timestamp += "0" + str(timestruct.tm_sec)
    else:
        timestamp += str(timestruct.tm_sec)

    return timestamp

def main():
    # Open file containing list of all selected kernels
    fp = open("file-list.txt","r")

    # Create file to write the generated header into
    output = open("opencl-domain-kernels.inl","w")

    # Add standard comment block to
    output.write("/* linbox/algorithms/opencl-domain.h\n"
                 " * Copyright (C) 2012 Matthew Wezowicz\n"
                 " *\n"
                 " * Written by Matthew Wezowicz <mwezz@udel.edu>\n"
                 " *\n"
                 " * ========LICENCE========\n"
                 " * This file is part of the library LinBox.\n"
                 " *\n"
                 " * LinBox is free software: you can redistribute it and/or modify\n"
                 " * it under the terms of the  GNU Lesser General Public\n"
                 " * License as published by the Free Software Foundation; either\n"
                 " * version 2.1 of the License, or (at your option) any later version.\n"
                 " *\n"
                 " * This library is distributed in the hope that it will be useful,\n"
                 " * but WITHOUT ANY WARRANTY; without even the implied warranty of\n"
                 " * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU\n"
                 " * Lesser General Public License for more details.\n"
                 " *\n"
                 " * You should have received a copy of the GNU Lesser General Public\n"
                 " * License along with this library; if not, write to the Free Software\n"
                 " * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA\n"
                 " * ========LICENCE========\n"
                 " *.\n"
                 " */\n\n")

    # Add timestamp for generation
    output.write(" /*###---    Generated On     ---###*/\n")
    output.write(" /*###--- " + gen_timestamp() + " ---###*/\n\n")
    
    # Add header file lines
    output.write("#ifndef __LINBOX_opencl_matrix_domain_kernels_INL\n")
    output.write("#define __LINBOX_opencl_matrix_domain_kernels_INL\n\n")
    output.write("namespace LinBox{\n\n")

    # For every file in the file list generate a const char* and add to the header
    for file_name in fp.readlines():
        parse_kernel(string.rstrip(file_name),output)

    # Add end of header lines
    output.write("} // end of namespace LinBox\n\n")
    output.write("#endif // __LINBOX_opencl_matrix_domain_kernels_INL\n\n")
    output.write("// Local Variables:\n"
                 "// mode: C++\n"
                 "// tab-width: 4\n"
                 "// indent-tabs-mode: nil\n"
                 "// c-basic-offset: 4\n"
                 "// End:\n"
                 "// vim:sts=4:sw=4:ts=4:et:sr:cino=>s,f0,{0,g0,(0,\:0,t0,+0,=s\n")

    # Close the files
    fp.close()
    output.close()

    return

main()
