/*
 * SNMPStats Module  - Network Statistics
 *
 * Kamailio Server Net objects addition
 * Copyright (C) 2013 Edvina AB, Sollentuna, Sweden
 * Written by Olle E. Johansson
 *
 * This file is part of Kamailio, a free SIP server.
 *
 * SPDX-License-Identifier: GPL-2.0-or-later
 *
 * Kamailio is free software; you can redistribute it and/or modify it
 * under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version
 *
 * Kamailio is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301
 * USA
 *
 * Note: this file originally auto-generated by mib2c
 *
 */
/*!
 *\file
 * \brief Network statistics
 * \ingroup snmpstats
 * - Module: \ref snmpstats
 * \author oej
 */

#include <net-snmp/net-snmp-config.h>
#include <net-snmp/net-snmp-includes.h>
#include <net-snmp/agent/net-snmp-agent-includes.h>
#include "kamailioNet.h"

#include "snmpstats_globals.h"
#include "utilities.h"
#include "snmp_statistics.h"
#include "../../core/globals.h"
#include "../../core/tcp_options.h"

/** Initializes the kamailioNet module */
void init_kamailioNet(void)
{
	oid kamailioNetTcpConnEstablished_oid[] = {
			1, 3, 6, 1, 4, 1, 34352, 3, 1, 3, 1, 4, 1, 2, 1};
	oid kamailioNetTcpConnFailed_oid[] = {
			1, 3, 6, 1, 4, 1, 34352, 3, 1, 3, 1, 4, 1, 2, 2};
	oid kamailioNetTcpConnReset_oid[] = {
			1, 3, 6, 1, 4, 1, 34352, 3, 1, 3, 1, 4, 1, 2, 3};
	oid kamailioNetTcpConnSuccess_oid[] = {
			1, 3, 6, 1, 4, 1, 34352, 3, 1, 3, 1, 4, 1, 2, 4};
	oid kamailioNetTcpConnOpen_oid[] = {
			1, 3, 6, 1, 4, 1, 34352, 3, 1, 3, 1, 4, 1, 2, 5};
	oid kamailioNetTcpConnPassiveOpen_oid[] = {
			1, 3, 6, 1, 4, 1, 34352, 3, 1, 3, 1, 4, 1, 2, 6};
	oid kamailioNetTcpConnReject_oid[] = {
			1, 3, 6, 1, 4, 1, 34352, 3, 1, 3, 1, 4, 1, 2, 8};
	oid kamailioNetTcpEnabled_oid[] = {
			1, 3, 6, 1, 4, 1, 34352, 3, 1, 3, 1, 4, 1, 3, 1};
	oid kamailioNetTcpMaxConns_oid[] = {
			1, 3, 6, 1, 4, 1, 34352, 3, 1, 3, 1, 4, 1, 3, 2};
	oid kamailioNetTcpConnTimeout_oid[] = {
			1, 3, 6, 1, 4, 1, 34352, 3, 1, 3, 1, 4, 1, 3, 3};
	oid kamailioNetTcpSendTimeout_oid[] = {
			1, 3, 6, 1, 4, 1, 34352, 3, 1, 3, 1, 4, 1, 3, 4};
	oid kamailioNetTcpConnLifetime_oid[] = {
			1, 3, 6, 1, 4, 1, 34352, 3, 1, 3, 1, 4, 1, 3, 5};
	oid kamailioNetTcpNoConnect_oid[] = {
			1, 3, 6, 1, 4, 1, 34352, 3, 1, 3, 1, 4, 1, 3, 7};
	oid kamailioNetTcpFdCache_oid[] = {
			1, 3, 6, 1, 4, 1, 34352, 3, 1, 3, 1, 4, 1, 3, 8};
	oid kamailioNetTcpAsync_oid[] = {
			1, 3, 6, 1, 4, 1, 34352, 3, 1, 3, 1, 4, 1, 3, 9};
	oid kamailioNetTcpAsyncConnWait_oid[] = {
			1, 3, 6, 1, 4, 1, 34352, 3, 1, 3, 1, 4, 1, 3, 10};
	oid kamailioNetTcpAsyncConnWqMax_oid[] = {
			1, 3, 6, 1, 4, 1, 34352, 3, 1, 3, 1, 4, 1, 3, 11};
	oid kamailioNetTcpAsyncWqMax_oid[] = {
			1, 3, 6, 1, 4, 1, 34352, 3, 1, 3, 1, 4, 1, 3, 12};
	oid kamailioNetTcpRdBufSize_oid[] = {
			1, 3, 6, 1, 4, 1, 34352, 3, 1, 3, 1, 4, 1, 3, 13};
	oid kamailioNetTcpDeferAccept_oid[] = {
			1, 3, 6, 1, 4, 1, 34352, 3, 1, 3, 1, 4, 1, 3, 14};
	oid kamailioNetTcpDelayedAck_oid[] = {
			1, 3, 6, 1, 4, 1, 34352, 3, 1, 3, 1, 4, 1, 3, 15};
	oid kamailioNetTcpSynCnt_oid[] = {
			1, 3, 6, 1, 4, 1, 34352, 3, 1, 3, 1, 4, 1, 3, 16};
	oid kamailioNetTcpLinger_oid[] = {
			1, 3, 6, 1, 4, 1, 34352, 3, 1, 3, 1, 4, 1, 3, 17};
	oid kamailioNetTcpKeepAlive_oid[] = {
			1, 3, 6, 1, 4, 1, 34352, 3, 1, 3, 1, 4, 1, 3, 18};
	oid kamailioNetTcpKeepIdle_oid[] = {
			1, 3, 6, 1, 4, 1, 34352, 3, 1, 3, 1, 4, 1, 3, 19};
	oid kamailioNetTcpKeepIntvl_oid[] = {
			1, 3, 6, 1, 4, 1, 34352, 3, 1, 3, 1, 4, 1, 3, 20};
	oid kamailioNetTcpKeepCnt_oid[] = {
			1, 3, 6, 1, 4, 1, 34352, 3, 1, 3, 1, 4, 1, 3, 21};
	oid kamailioNetTcpCrlfPing_oid[] = {
			1, 3, 6, 1, 4, 1, 34352, 3, 1, 3, 1, 4, 1, 3, 22};
	oid kamailioNetTcpAcceptAliases_oid[] = {
			1, 3, 6, 1, 4, 1, 34352, 3, 1, 3, 1, 4, 1, 3, 23};
	oid kamailioNetTcpAcceptNoCl_oid[] = {
			1, 3, 6, 1, 4, 1, 34352, 3, 1, 3, 1, 4, 1, 3, 24};

	/* WebSockets */
	oid kamailioNetWsConnsActive_oid[] = {
			1, 3, 6, 1, 4, 1, 34352, 3, 1, 3, 1, 4, 2, 1, 1};
	oid kamailioNetWsConnsActiveMax_oid[] = {
			1, 3, 6, 1, 4, 1, 34352, 3, 1, 3, 1, 4, 2, 1, 2};
	oid kamailioNetWsConnsFailed_oid[] = {
			1, 3, 6, 1, 4, 1, 34352, 3, 1, 3, 1, 4, 2, 1, 3};
	oid kamailioNetWsConnsClosedLocal_oid[] = {
			1, 3, 6, 1, 4, 1, 34352, 3, 1, 3, 1, 4, 2, 1, 4};
	oid kamailioNetWsConnsClosedRemote_oid[] = {
			1, 3, 6, 1, 4, 1, 34352, 3, 1, 3, 1, 4, 2, 1, 5};
	oid kamailioNetWsFramesRx_oid[] = {
			1, 3, 6, 1, 4, 1, 34352, 3, 1, 3, 1, 4, 2, 1, 6};
	oid kamailioNetWsFramesTx_oid[] = {
			1, 3, 6, 1, 4, 1, 34352, 3, 1, 3, 1, 4, 2, 1, 7};
	oid kamailioNetWsHandshakeSuccess_oid[] = {
			1, 3, 6, 1, 4, 1, 34352, 3, 1, 3, 1, 4, 2, 1, 8};
	oid kamailioNetWsHandshakeFailed_oid[] = {
			1, 3, 6, 1, 4, 1, 34352, 3, 1, 3, 1, 4, 2, 1, 9};

	DEBUGMSGTL(("kamailioNet", "Initializing\n"));

	netsnmp_register_scalar(netsnmp_create_handler_registration(
			"kamailioNetTcpConnEstablished",
			handle_kamailioNetTcpConnEstablished,
			kamailioNetTcpConnEstablished_oid,
			OID_LENGTH(kamailioNetTcpConnEstablished_oid), HANDLER_CAN_RONLY));
	netsnmp_register_scalar(netsnmp_create_handler_registration(
			"kamailioNetTcpConnFailed", handle_kamailioNetTcpConnFailed,
			kamailioNetTcpConnFailed_oid,
			OID_LENGTH(kamailioNetTcpConnFailed_oid), HANDLER_CAN_RONLY));
	netsnmp_register_scalar(netsnmp_create_handler_registration(
			"kamailioNetTcpConnReset", handle_kamailioNetTcpConnReset,
			kamailioNetTcpConnReset_oid,
			OID_LENGTH(kamailioNetTcpConnReset_oid), HANDLER_CAN_RONLY));
	netsnmp_register_scalar(netsnmp_create_handler_registration(
			"kamailioNetTcpConnSuccess", handle_kamailioNetTcpConnSuccess,
			kamailioNetTcpConnSuccess_oid,
			OID_LENGTH(kamailioNetTcpConnSuccess_oid), HANDLER_CAN_RONLY));
	netsnmp_register_scalar(
			netsnmp_create_handler_registration("kamailioNetTcpConnOped",
					handle_kamailioNetTcpConnOpen, kamailioNetTcpConnOpen_oid,
					OID_LENGTH(kamailioNetTcpConnOpen_oid), HANDLER_CAN_RONLY));
	netsnmp_register_scalar(netsnmp_create_handler_registration(
			"kamailioNetTcpConnPassiveOpen",
			handle_kamailioNetTcpConnPassiveOpen,
			kamailioNetTcpConnPassiveOpen_oid,
			OID_LENGTH(kamailioNetTcpConnPassiveOpen_oid), HANDLER_CAN_RONLY));
	netsnmp_register_scalar(netsnmp_create_handler_registration(
			"kamailioNetTcpConnReject", handle_kamailioNetTcpConnReject,
			kamailioNetTcpConnReject_oid,
			OID_LENGTH(kamailioNetTcpConnReject_oid), HANDLER_CAN_RONLY));
	netsnmp_register_scalar(
			netsnmp_create_handler_registration("kamailioNetTcpEnabled",
					handle_kamailioNetTcpEnabled, kamailioNetTcpEnabled_oid,
					OID_LENGTH(kamailioNetTcpEnabled_oid), HANDLER_CAN_RONLY));
	netsnmp_register_scalar(
			netsnmp_create_handler_registration("kamailioNetTcpMaxConns",
					handle_kamailioNetTcpMaxConns, kamailioNetTcpMaxConns_oid,
					OID_LENGTH(kamailioNetTcpMaxConns_oid), HANDLER_CAN_RONLY));
	netsnmp_register_scalar(netsnmp_create_handler_registration(
			"kamailioNetTcpConnTimeout", handle_kamailioNetTcpConnTimeout,
			kamailioNetTcpConnTimeout_oid,
			OID_LENGTH(kamailioNetTcpConnTimeout_oid), HANDLER_CAN_RONLY));
	netsnmp_register_scalar(netsnmp_create_handler_registration(
			"kamailioNetTcpSendTimeout", handle_kamailioNetTcpSendTimeout,
			kamailioNetTcpSendTimeout_oid,
			OID_LENGTH(kamailioNetTcpSendTimeout_oid), HANDLER_CAN_RONLY));
	netsnmp_register_scalar(netsnmp_create_handler_registration(
			"kamailioNetTcpConnLifetime", handle_kamailioNetTcpConnLifetime,
			kamailioNetTcpConnLifetime_oid,
			OID_LENGTH(kamailioNetTcpConnLifetime_oid), HANDLER_CAN_RONLY));
	netsnmp_register_scalar(netsnmp_create_handler_registration(
			"kamailioNetTcpNoConnect", handle_kamailioNetTcpNoConnect,
			kamailioNetTcpNoConnect_oid,
			OID_LENGTH(kamailioNetTcpNoConnect_oid), HANDLER_CAN_RONLY));
	netsnmp_register_scalar(
			netsnmp_create_handler_registration("kamailioNetTcpFdCache",
					handle_kamailioNetTcpFdCache, kamailioNetTcpFdCache_oid,
					OID_LENGTH(kamailioNetTcpFdCache_oid), HANDLER_CAN_RONLY));
	netsnmp_register_scalar(
			netsnmp_create_handler_registration("kamailioNetTcpAsync",
					handle_kamailioNetTcpAsync, kamailioNetTcpAsync_oid,
					OID_LENGTH(kamailioNetTcpAsync_oid), HANDLER_CAN_RONLY));
	netsnmp_register_scalar(netsnmp_create_handler_registration(
			"kamailioNetTcpAsyncConnWait", handle_kamailioNetTcpAsyncConnWait,
			kamailioNetTcpAsyncConnWait_oid,
			OID_LENGTH(kamailioNetTcpAsyncConnWait_oid), HANDLER_CAN_RONLY));
	netsnmp_register_scalar(netsnmp_create_handler_registration(
			"kamailioNetTcpAsyncConnWqMax", handle_kamailioNetTcpAsyncConnWqMax,
			kamailioNetTcpAsyncConnWqMax_oid,
			OID_LENGTH(kamailioNetTcpAsyncConnWqMax_oid), HANDLER_CAN_RONLY));
	netsnmp_register_scalar(netsnmp_create_handler_registration(
			"kamailioNetTcpAsyncWqMax", handle_kamailioNetTcpAsyncWqMax,
			kamailioNetTcpAsyncWqMax_oid,
			OID_LENGTH(kamailioNetTcpAsyncWqMax_oid), HANDLER_CAN_RONLY));
	netsnmp_register_scalar(netsnmp_create_handler_registration(
			"kamailioNetTcpRdBufSize", handle_kamailioNetTcpRdBufSize,
			kamailioNetTcpRdBufSize_oid,
			OID_LENGTH(kamailioNetTcpRdBufSize_oid), HANDLER_CAN_RONLY));
	netsnmp_register_scalar(netsnmp_create_handler_registration(
			"kamailioNetTcpDeferAccept", handle_kamailioNetTcpDeferAccept,
			kamailioNetTcpDeferAccept_oid,
			OID_LENGTH(kamailioNetTcpDeferAccept_oid), HANDLER_CAN_RONLY));
	netsnmp_register_scalar(netsnmp_create_handler_registration(
			"kamailioNetTcpDelayedAck", handle_kamailioNetTcpDelayedAck,
			kamailioNetTcpDelayedAck_oid,
			OID_LENGTH(kamailioNetTcpDelayedAck_oid), HANDLER_CAN_RONLY));
	netsnmp_register_scalar(
			netsnmp_create_handler_registration("kamailioNetTcpSynCnt",
					handle_kamailioNetTcpSynCnt, kamailioNetTcpSynCnt_oid,
					OID_LENGTH(kamailioNetTcpSynCnt_oid), HANDLER_CAN_RONLY));
	netsnmp_register_scalar(
			netsnmp_create_handler_registration("kamailioNetTcpLinger",
					handle_kamailioNetTcpLinger, kamailioNetTcpLinger_oid,
					OID_LENGTH(kamailioNetTcpLinger_oid), HANDLER_CAN_RONLY));
	netsnmp_register_scalar(netsnmp_create_handler_registration(
			"kamailioNetTcpKeepAlive", handle_kamailioNetTcpKeepAlive,
			kamailioNetTcpKeepAlive_oid,
			OID_LENGTH(kamailioNetTcpKeepAlive_oid), HANDLER_CAN_RONLY));
	netsnmp_register_scalar(
			netsnmp_create_handler_registration("kamailioNetTcpKeepIdle",
					handle_kamailioNetTcpKeepIdle, kamailioNetTcpKeepIdle_oid,
					OID_LENGTH(kamailioNetTcpKeepIdle_oid), HANDLER_CAN_RONLY));
	netsnmp_register_scalar(netsnmp_create_handler_registration(
			"kamailioNetTcpKeepIntvl", handle_kamailioNetTcpKeepIntvl,
			kamailioNetTcpKeepIntvl_oid,
			OID_LENGTH(kamailioNetTcpKeepIntvl_oid), HANDLER_CAN_RONLY));
	netsnmp_register_scalar(
			netsnmp_create_handler_registration("kamailioNetTcpKeepCnt",
					handle_kamailioNetTcpKeepCnt, kamailioNetTcpKeepCnt_oid,
					OID_LENGTH(kamailioNetTcpKeepCnt_oid), HANDLER_CAN_RONLY));
	netsnmp_register_scalar(
			netsnmp_create_handler_registration("kamailioNetTcpCrlfPing",
					handle_kamailioNetTcpCrlfPing, kamailioNetTcpCrlfPing_oid,
					OID_LENGTH(kamailioNetTcpCrlfPing_oid), HANDLER_CAN_RONLY));
	netsnmp_register_scalar(netsnmp_create_handler_registration(
			"kamailioNetTcpAcceptAliases", handle_kamailioNetTcpAcceptAliases,
			kamailioNetTcpAcceptAliases_oid,
			OID_LENGTH(kamailioNetTcpAcceptAliases_oid), HANDLER_CAN_RONLY));
	netsnmp_register_scalar(netsnmp_create_handler_registration(
			"kamailioNetTcpAcceptNoCl", handle_kamailioNetTcpAcceptNoCl,
			kamailioNetTcpAcceptNoCl_oid,
			OID_LENGTH(kamailioNetTcpAcceptNoCl_oid), HANDLER_CAN_RONLY));
	netsnmp_register_scalar(netsnmp_create_handler_registration(
			"kamailioNetWsConnsActive", handle_kamailioNetWsConnsActive,
			kamailioNetWsConnsActive_oid,
			OID_LENGTH(kamailioNetWsConnsActive_oid), HANDLER_CAN_RONLY));
	netsnmp_register_scalar(netsnmp_create_handler_registration(
			"kamailioNetWsConnsActiveMax", handle_kamailioNetWsConnsActiveMax,
			kamailioNetWsConnsActiveMax_oid,
			OID_LENGTH(kamailioNetWsConnsActiveMax_oid), HANDLER_CAN_RONLY));
	netsnmp_register_scalar(netsnmp_create_handler_registration(
			"kamailioNetWsConnsFailed", handle_kamailioNetWsConnsFailed,
			kamailioNetWsConnsFailed_oid,
			OID_LENGTH(kamailioNetWsConnsFailed_oid), HANDLER_CAN_RONLY));
	netsnmp_register_scalar(netsnmp_create_handler_registration(
			"kamailioNetWsConnsClosedLocal",
			handle_kamailioNetWsConnsClosedLocal,
			kamailioNetWsConnsClosedLocal_oid,
			OID_LENGTH(kamailioNetWsConnsClosedLocal_oid), HANDLER_CAN_RONLY));
	netsnmp_register_scalar(netsnmp_create_handler_registration(
			"kamailioNetWsConnsClosedRemote",
			handle_kamailioNetWsConnsClosedRemote,
			kamailioNetWsConnsClosedRemote_oid,
			OID_LENGTH(kamailioNetWsConnsClosedRemote_oid), HANDLER_CAN_RONLY));
	netsnmp_register_scalar(
			netsnmp_create_handler_registration("kamailioNetWsFramesRx",
					handle_kamailioNetWsFramesRx, kamailioNetWsFramesRx_oid,
					OID_LENGTH(kamailioNetWsFramesRx_oid), HANDLER_CAN_RONLY));
	netsnmp_register_scalar(
			netsnmp_create_handler_registration("kamailioNetWsFramesTx",
					handle_kamailioNetWsFramesTx, kamailioNetWsFramesTx_oid,
					OID_LENGTH(kamailioNetWsFramesTx_oid), HANDLER_CAN_RONLY));
	netsnmp_register_scalar(netsnmp_create_handler_registration(
			"kamailioNetWsHandshakeSuccess",
			handle_kamailioNetWsHandshakeSuccess,
			kamailioNetWsHandshakeSuccess_oid,
			OID_LENGTH(kamailioNetWsHandshakeSuccess_oid), HANDLER_CAN_RONLY));
	netsnmp_register_scalar(netsnmp_create_handler_registration(
			"kamailioNetWsHandshakeFailed", handle_kamailioNetWsHandshakeFailed,
			kamailioNetWsHandshakeFailed_oid,
			OID_LENGTH(kamailioNetWsHandshakeFailed_oid), HANDLER_CAN_RONLY));
}

int handle_kamailioNetTcpConnEstablished(netsnmp_mib_handler *handler,
		netsnmp_handler_registration *reginfo,
		netsnmp_agent_request_info *reqinfo, netsnmp_request_info *requests)
{
	/* We are never called for a GETNEXT if it's registered as an
       "instance", as it's "magically" handled for us.  */

	/* an instance handler also only hands us one request at a time, so
       we don't need to loop over a list of requests; we'll only get one. */

	int datafield = get_statistic("established");

	switch(reqinfo->mode) {

		case MODE_GET:
			snmp_set_var_typed_value(requests->requestvb, ASN_COUNTER,
					(u_char *)&datafield, sizeof(int));
			break;


		default:
			/* we should never get here, so this is a really bad error */
			snmp_log(LOG_ERR,
					"unknown mode (%d) in "
					"handle_kamailioNetTcpConnEstablished\n",
					reqinfo->mode);
			return SNMP_ERR_GENERR;
	}

	return SNMP_ERR_NOERROR;
}
int handle_kamailioNetTcpConnFailed(netsnmp_mib_handler *handler,
		netsnmp_handler_registration *reginfo,
		netsnmp_agent_request_info *reqinfo, netsnmp_request_info *requests)
{

	int datafield = get_statistic("connect_failed");

	switch(reqinfo->mode) {

		case MODE_GET:
			snmp_set_var_typed_value(requests->requestvb, ASN_COUNTER,
					(u_char *)&datafield, sizeof(int));
			break;


		default:
			/* we should never get here, so this is a really bad error */
			snmp_log(LOG_ERR,
					"unknown mode (%d) in handle_kamailioNetTcpConnFailed\n",
					reqinfo->mode);
			return SNMP_ERR_GENERR;
	}

	return SNMP_ERR_NOERROR;
}
int handle_kamailioNetTcpConnReset(netsnmp_mib_handler *handler,
		netsnmp_handler_registration *reginfo,
		netsnmp_agent_request_info *reqinfo, netsnmp_request_info *requests)
{
	int datafield = get_statistic("con_reset");

	switch(reqinfo->mode) {

		case MODE_GET:
			snmp_set_var_typed_value(requests->requestvb, ASN_COUNTER,
					(u_char *)&datafield, sizeof(int));
			break;


		default:
			/* we should never get here, so this is a really bad error */
			snmp_log(LOG_ERR,
					"unknown mode (%d) in handle_kamailioNetTcpConnReset\n",
					reqinfo->mode);
			return SNMP_ERR_GENERR;
	}

	return SNMP_ERR_NOERROR;
}
int handle_kamailioNetTcpConnSuccess(netsnmp_mib_handler *handler,
		netsnmp_handler_registration *reginfo,
		netsnmp_agent_request_info *reqinfo, netsnmp_request_info *requests)
{

	int datafield = get_statistic("connect_success");

	switch(reqinfo->mode) {

		case MODE_GET:
			snmp_set_var_typed_value(requests->requestvb, ASN_COUNTER,
					(u_char *)&datafield, sizeof(int));
			break;


		default:
			/* we should never get here, so this is a really bad error */
			snmp_log(LOG_ERR,
					"unknown mode (%d) in handle_kamailioNetTcpConnSuccess\n",
					reqinfo->mode);
			return SNMP_ERR_GENERR;
	}

	return SNMP_ERR_NOERROR;
}
int handle_kamailioNetTcpConnOpen(netsnmp_mib_handler *handler,
		netsnmp_handler_registration *reginfo,
		netsnmp_agent_request_info *reqinfo, netsnmp_request_info *requests)
{
	int datafield = get_statistic("current_opened_connections");
	switch(reqinfo->mode) {

		case MODE_GET:
			snmp_set_var_typed_value(requests->requestvb, ASN_GAUGE,
					(u_char *)&datafield, sizeof(int));
			break;


		default:
			/* we should never get here, so this is a really bad error */
			snmp_log(LOG_ERR,
					"unknown mode (%d) in handle_kamailioNetTcpConnOpen\n",
					reqinfo->mode);
			return SNMP_ERR_GENERR;
	}

	return SNMP_ERR_NOERROR;
}
int handle_kamailioNetTcpConnPassiveOpen(netsnmp_mib_handler *handler,
		netsnmp_handler_registration *reginfo,
		netsnmp_agent_request_info *reqinfo, netsnmp_request_info *requests)
{
	int datafield = get_statistic("passive_open");

	switch(reqinfo->mode) {

		case MODE_GET:
			snmp_set_var_typed_value(requests->requestvb, ASN_COUNTER,
					(u_char *)&datafield, sizeof(int));
			break;


		default:
			/* we should never get here, so this is a really bad error */
			snmp_log(LOG_ERR,
					"unknown mode (%d) in "
					"handle_kamailioNetTcpConnPassiveOpen\n",
					reqinfo->mode);
			return SNMP_ERR_GENERR;
	}

	return SNMP_ERR_NOERROR;
}
int handle_kamailioNetTcpConnReject(netsnmp_mib_handler *handler,
		netsnmp_handler_registration *reginfo,
		netsnmp_agent_request_info *reqinfo, netsnmp_request_info *requests)
{
	/* We are never called for a GETNEXT if it's registered as an
       "instance", as it's "magically" handled for us.  */

	/* an instance handler also only hands us one request at a time, so
       we don't need to loop over a list of requests; we'll only get one. */
	int datafield = get_statistic("local_reject");

	switch(reqinfo->mode) {

		case MODE_GET:
			snmp_set_var_typed_value(requests->requestvb, ASN_COUNTER,
					(u_char *)&datafield, sizeof(int));
			break;


		default:
			/* we should never get here, so this is a really bad error */
			snmp_log(LOG_ERR,
					"unknown mode (%d) in handle_kamailioNetTcpConnReject\n",
					reqinfo->mode);
			return SNMP_ERR_GENERR;
	}

	return SNMP_ERR_NOERROR;
}
int handle_kamailioNetTcpEnabled(netsnmp_mib_handler *handler,
		netsnmp_handler_registration *reginfo,
		netsnmp_agent_request_info *reqinfo, netsnmp_request_info *requests)
{
	/* We are never called for a GETNEXT if it's registered as an
       "instance", as it's "magically" handled for us.  */

	/* an instance handler also only hands us one request at a time, so
       we don't need to loop over a list of requests; we'll only get one. */
	int enabled = (tcp_disable == 0);

	switch(reqinfo->mode) {

		case MODE_GET:
			snmp_set_var_typed_value(requests->requestvb, ASN_INTEGER,
					(u_char *)&enabled, sizeof(int));
			break;


		default:
			/* we should never get here, so this is a really bad error */
			snmp_log(LOG_ERR,
					"unknown mode (%d) in handle_kamailioNetTcpEnabled\n",
					reqinfo->mode);
			return SNMP_ERR_GENERR;
	}

	return SNMP_ERR_NOERROR;
}

int handle_kamailioNetTcpMaxConns(netsnmp_mib_handler *handler,
		netsnmp_handler_registration *reginfo,
		netsnmp_agent_request_info *reqinfo, netsnmp_request_info *requests)
{
	struct cfg_group_tcp t;
	unsigned int maxconn;

	tcp_options_get(&t);
	maxconn = t.max_connections;

	switch(reqinfo->mode) {

		case MODE_GET:
			snmp_set_var_typed_value(requests->requestvb, ASN_INTEGER,
					(u_char *)&maxconn, sizeof(int));
			break;


		default:
			/* we should never get here, so this is a really bad error */
			snmp_log(LOG_ERR,
					"unknown mode (%d) in handle_kamailioNetTcpMaxConns\n",
					reqinfo->mode);
			return SNMP_ERR_GENERR;
	}

	return SNMP_ERR_NOERROR;
}
int handle_kamailioNetTcpAsync(netsnmp_mib_handler *handler,
		netsnmp_handler_registration *reginfo,
		netsnmp_agent_request_info *reqinfo, netsnmp_request_info *requests)
{
	struct cfg_group_tcp t;
	unsigned int value;

	tcp_options_get(&t);
	value = t.async;
	/* We are never called for a GETNEXT if it's registered as an
       "instance", as it's "magically" handled for us.  */

	/* an instance handler also only hands us one request at a time, so
       we don't need to loop over a list of requests; we'll only get one. */

	switch(reqinfo->mode) {

		case MODE_GET:
			snmp_set_var_typed_value(requests->requestvb, ASN_INTEGER,
					(u_char *)&value, sizeof(int));
			break;


		default:
			/* we should never get here, so this is a really bad error */
			snmp_log(LOG_ERR,
					"unknown mode (%d) in handle_kamailioNetTcpAsync\n",
					reqinfo->mode);
			return SNMP_ERR_GENERR;
	}

	return SNMP_ERR_NOERROR;
}

int handle_kamailioNetTcpConnTimeout(netsnmp_mib_handler *handler,
		netsnmp_handler_registration *reginfo,
		netsnmp_agent_request_info *reqinfo, netsnmp_request_info *requests)
{
	struct cfg_group_tcp t;
	unsigned int value;

	tcp_options_get(&t);
	value = t.connect_timeout_s;

	switch(reqinfo->mode) {

		case MODE_GET:
			snmp_set_var_typed_value(requests->requestvb, ASN_INTEGER,
					(u_char *)&value, sizeof(int));
			break;


		default:
			/* we should never get here, so this is a really bad error */
			snmp_log(LOG_ERR,
					"unknown mode (%d) in handle_kamailioNetTcpConnTimeout\n",
					reqinfo->mode);
			return SNMP_ERR_GENERR;
	}

	return SNMP_ERR_NOERROR;
}
int handle_kamailioNetTcpSendTimeout(netsnmp_mib_handler *handler,
		netsnmp_handler_registration *reginfo,
		netsnmp_agent_request_info *reqinfo, netsnmp_request_info *requests)
{
	struct cfg_group_tcp t;
	unsigned int value;

	tcp_options_get(&t);
	value = t.send_timeout;

	switch(reqinfo->mode) {

		case MODE_GET:
			snmp_set_var_typed_value(requests->requestvb, ASN_INTEGER,
					(u_char *)&value, sizeof(int));
			break;


		default:
			/* we should never get here, so this is a really bad error */
			snmp_log(LOG_ERR,
					"unknown mode (%d) in handle_kamailioNetTcpSendTimeout\n",
					reqinfo->mode);
			return SNMP_ERR_GENERR;
	}

	return SNMP_ERR_NOERROR;
}
int handle_kamailioNetTcpConnLifetime(netsnmp_mib_handler *handler,
		netsnmp_handler_registration *reginfo,
		netsnmp_agent_request_info *reqinfo, netsnmp_request_info *requests)
{
	struct cfg_group_tcp t;
	unsigned int value;

	tcp_options_get(&t);
	value = t.con_lifetime;

	switch(reqinfo->mode) {

		case MODE_GET:
			snmp_set_var_typed_value(requests->requestvb, ASN_INTEGER,
					(u_char *)&value, sizeof(int));
			break;


		default:
			/* we should never get here, so this is a really bad error */
			snmp_log(LOG_ERR,
					"unknown mode (%d) in handle_kamailioNetTcpConnLifetime\n",
					reqinfo->mode);
			return SNMP_ERR_GENERR;
	}

	return SNMP_ERR_NOERROR;
}

int handle_kamailioNetTcpNoConnect(netsnmp_mib_handler *handler,
		netsnmp_handler_registration *reginfo,
		netsnmp_agent_request_info *reqinfo, netsnmp_request_info *requests)
{
	struct cfg_group_tcp t;
	unsigned int value;

	tcp_options_get(&t);
	value = t.no_connect;

	switch(reqinfo->mode) {

		case MODE_GET:
			snmp_set_var_typed_value(requests->requestvb, ASN_INTEGER,
					(u_char *)&value, sizeof(int));
			break;


		default:
			/* we should never get here, so this is a really bad error */
			snmp_log(LOG_ERR,
					"unknown mode (%d) in handle_kamailioNetTcpNoConnect\n",
					reqinfo->mode);
			return SNMP_ERR_GENERR;
	}

	return SNMP_ERR_NOERROR;
}
int handle_kamailioNetTcpFdCache(netsnmp_mib_handler *handler,
		netsnmp_handler_registration *reginfo,
		netsnmp_agent_request_info *reqinfo, netsnmp_request_info *requests)
{
	struct cfg_group_tcp t;
	unsigned int value;

	tcp_options_get(&t);
	value = t.con_lifetime;

	switch(reqinfo->mode) {

		case MODE_GET:
			snmp_set_var_typed_value(requests->requestvb, ASN_INTEGER,
					(u_char *)&value, sizeof(int));
			break;


		default:
			/* we should never get here, so this is a really bad error */
			snmp_log(LOG_ERR,
					"unknown mode (%d) in handle_kamailioNetTcpFdCache\n",
					reqinfo->mode);
			return SNMP_ERR_GENERR;
	}

	return SNMP_ERR_NOERROR;
}

int handle_kamailioNetTcpAsyncConnWait(netsnmp_mib_handler *handler,
		netsnmp_handler_registration *reginfo,
		netsnmp_agent_request_info *reqinfo, netsnmp_request_info *requests)
{
	struct cfg_group_tcp t;
	unsigned int value;

	tcp_options_get(&t);
	value = t.tcp_connect_wait;

	switch(reqinfo->mode) {

		case MODE_GET:
			snmp_set_var_typed_value(requests->requestvb, ASN_INTEGER,
					(u_char *)&value, sizeof(int));
			break;


		default:
			/* we should never get here, so this is a really bad error */
			snmp_log(LOG_ERR,
					"unknown mode (%d) in handle_kamailioNetTcpAsyncConnWait\n",
					reqinfo->mode);
			return SNMP_ERR_GENERR;
	}

	return SNMP_ERR_NOERROR;
}

int handle_kamailioNetTcpAsyncConnWqMax(netsnmp_mib_handler *handler,
		netsnmp_handler_registration *reginfo,
		netsnmp_agent_request_info *reqinfo, netsnmp_request_info *requests)
{
	struct cfg_group_tcp t;
	unsigned int value;

	tcp_options_get(&t);
	value = t.tcpconn_wq_max;

	switch(reqinfo->mode) {

		case MODE_GET:
			snmp_set_var_typed_value(requests->requestvb, ASN_INTEGER,
					(u_char *)&value, sizeof(int));
			break;


		default:
			/* we should never get here, so this is a really bad error */
			snmp_log(LOG_ERR,
					"unknown mode (%d) in "
					"handle_kamailioNetTcpAsyncConnWqMax\n",
					reqinfo->mode);
			return SNMP_ERR_GENERR;
	}

	return SNMP_ERR_NOERROR;
}

int handle_kamailioNetTcpAsyncWqMax(netsnmp_mib_handler *handler,
		netsnmp_handler_registration *reginfo,
		netsnmp_agent_request_info *reqinfo, netsnmp_request_info *requests)
{
	struct cfg_group_tcp t;
	unsigned int value;

	tcp_options_get(&t);
	value = t.tcp_wq_max;

	switch(reqinfo->mode) {

		case MODE_GET:
			snmp_set_var_typed_value(requests->requestvb, ASN_INTEGER,
					(u_char *)&value, sizeof(int));
			break;


		default:
			/* we should never get here, so this is a really bad error */
			snmp_log(LOG_ERR,
					"unknown mode (%d) in handle_kamailioNetTcpAsyncWqMax\n",
					reqinfo->mode);
			return SNMP_ERR_GENERR;
	}

	return SNMP_ERR_NOERROR;
}

int handle_kamailioNetTcpRdBufSize(netsnmp_mib_handler *handler,
		netsnmp_handler_registration *reginfo,
		netsnmp_agent_request_info *reqinfo, netsnmp_request_info *requests)
{
	struct cfg_group_tcp t;
	unsigned int value;

	tcp_options_get(&t);
	value = t.rd_buf_size;

	switch(reqinfo->mode) {

		case MODE_GET:
			snmp_set_var_typed_value(requests->requestvb, ASN_INTEGER,
					(u_char *)&value, sizeof(int));
			break;


		default:
			/* we should never get here, so this is a really bad error */
			snmp_log(LOG_ERR,
					"unknown mode (%d) in handle_kamailioNetTcpRdBufSize\n",
					reqinfo->mode);
			return SNMP_ERR_GENERR;
	}

	return SNMP_ERR_NOERROR;
}

int handle_kamailioNetTcpDeferAccept(netsnmp_mib_handler *handler,
		netsnmp_handler_registration *reginfo,
		netsnmp_agent_request_info *reqinfo, netsnmp_request_info *requests)
{
	struct cfg_group_tcp t;
	unsigned int value;

	tcp_options_get(&t);
	value = t.defer_accept;

	switch(reqinfo->mode) {

		case MODE_GET:
			snmp_set_var_typed_value(requests->requestvb, ASN_INTEGER,
					(u_char *)&value, sizeof(int));
			break;


		default:
			/* we should never get here, so this is a really bad error */
			snmp_log(LOG_ERR,
					"unknown mode (%d) in handle_kamailioNetTcpDeferAccept\n",
					reqinfo->mode);
			return SNMP_ERR_GENERR;
	}

	return SNMP_ERR_NOERROR;
}

int handle_kamailioNetTcpDelayedAck(netsnmp_mib_handler *handler,
		netsnmp_handler_registration *reginfo,
		netsnmp_agent_request_info *reqinfo, netsnmp_request_info *requests)
{
	struct cfg_group_tcp t;
	unsigned int value;

	tcp_options_get(&t);
	value = t.delayed_ack;

	switch(reqinfo->mode) {

		case MODE_GET:
			snmp_set_var_typed_value(requests->requestvb, ASN_INTEGER,
					(u_char *)&value, sizeof(int));
			break;


		default:
			/* we should never get here, so this is a really bad error */
			snmp_log(LOG_ERR,
					"unknown mode (%d) in handle_kamailioNetTcpDelayedAck\n",
					reqinfo->mode);
			return SNMP_ERR_GENERR;
	}

	return SNMP_ERR_NOERROR;
}

int handle_kamailioNetTcpSynCnt(netsnmp_mib_handler *handler,
		netsnmp_handler_registration *reginfo,
		netsnmp_agent_request_info *reqinfo, netsnmp_request_info *requests)
{
	struct cfg_group_tcp t;
	unsigned int value;

	tcp_options_get(&t);
	value = t.syncnt;

	switch(reqinfo->mode) {

		case MODE_GET:
			snmp_set_var_typed_value(requests->requestvb, ASN_INTEGER,
					(u_char *)&value, sizeof(int));
			break;


		default:
			/* we should never get here, so this is a really bad error */
			snmp_log(LOG_ERR,
					"unknown mode (%d) in handle_kamailioNetTcpSynCnt\n",
					reqinfo->mode);
			return SNMP_ERR_GENERR;
	}

	return SNMP_ERR_NOERROR;
}

int handle_kamailioNetTcpLinger(netsnmp_mib_handler *handler,
		netsnmp_handler_registration *reginfo,
		netsnmp_agent_request_info *reqinfo, netsnmp_request_info *requests)
{
	struct cfg_group_tcp t;
	unsigned int value;

	tcp_options_get(&t);
	value = t.linger2;

	switch(reqinfo->mode) {

		case MODE_GET:
			snmp_set_var_typed_value(requests->requestvb, ASN_INTEGER,
					(u_char *)&value, sizeof(int));
			break;


		default:
			/* we should never get here, so this is a really bad error */
			snmp_log(LOG_ERR,
					"unknown mode (%d) in handle_kamailioNetTcpLinger\n",
					reqinfo->mode);
			return SNMP_ERR_GENERR;
	}

	return SNMP_ERR_NOERROR;
}

int handle_kamailioNetTcpKeepAlive(netsnmp_mib_handler *handler,
		netsnmp_handler_registration *reginfo,
		netsnmp_agent_request_info *reqinfo, netsnmp_request_info *requests)
{
	struct cfg_group_tcp t;
	unsigned int value;

	tcp_options_get(&t);
	value = t.keepalive;

	switch(reqinfo->mode) {

		case MODE_GET:
			snmp_set_var_typed_value(requests->requestvb, ASN_INTEGER,
					(u_char *)&value, sizeof(int));
			break;


		default:
			/* we should never get here, so this is a really bad error */
			snmp_log(LOG_ERR,
					"unknown mode (%d) in handle_kamailioNetTcpKeepAlive\n",
					reqinfo->mode);
			return SNMP_ERR_GENERR;
	}

	return SNMP_ERR_NOERROR;
}
int handle_kamailioNetTcpKeepIdle(netsnmp_mib_handler *handler,
		netsnmp_handler_registration *reginfo,
		netsnmp_agent_request_info *reqinfo, netsnmp_request_info *requests)
{
	struct cfg_group_tcp t;
	unsigned int value;

	tcp_options_get(&t);
	value = t.keepidle;

	switch(reqinfo->mode) {

		case MODE_GET:
			snmp_set_var_typed_value(requests->requestvb, ASN_INTEGER,
					(u_char *)&value, sizeof(int));
			break;


		default:
			/* we should never get here, so this is a really bad error */
			snmp_log(LOG_ERR,
					"unknown mode (%d) in handle_kamailioNetTcpKeepIdle\n",
					reqinfo->mode);
			return SNMP_ERR_GENERR;
	}

	return SNMP_ERR_NOERROR;
}

int handle_kamailioNetTcpKeepIntvl(netsnmp_mib_handler *handler,
		netsnmp_handler_registration *reginfo,
		netsnmp_agent_request_info *reqinfo, netsnmp_request_info *requests)
{
	struct cfg_group_tcp t;
	unsigned int value;

	tcp_options_get(&t);
	value = t.keepintvl;

	switch(reqinfo->mode) {

		case MODE_GET:
			snmp_set_var_typed_value(requests->requestvb, ASN_INTEGER,
					(u_char *)&value, sizeof(int));
			break;


		default:
			/* we should never get here, so this is a really bad error */
			snmp_log(LOG_ERR,
					"unknown mode (%d) in handle_kamailioNetTcpKeepIntvl\n",
					reqinfo->mode);
			return SNMP_ERR_GENERR;
	}

	return SNMP_ERR_NOERROR;
}

int handle_kamailioNetTcpKeepCnt(netsnmp_mib_handler *handler,
		netsnmp_handler_registration *reginfo,
		netsnmp_agent_request_info *reqinfo, netsnmp_request_info *requests)
{
	struct cfg_group_tcp t;
	unsigned int value;

	tcp_options_get(&t);
	value = t.keepcnt;

	switch(reqinfo->mode) {

		case MODE_GET:
			snmp_set_var_typed_value(requests->requestvb, ASN_INTEGER,
					(u_char *)&value, sizeof(int));
			break;


		default:
			/* we should never get here, so this is a really bad error */
			snmp_log(LOG_ERR,
					"unknown mode (%d) in handle_kamailioNetTcpKeepCnt\n",
					reqinfo->mode);
			return SNMP_ERR_GENERR;
	}

	return SNMP_ERR_NOERROR;
}

int handle_kamailioNetTcpCrlfPing(netsnmp_mib_handler *handler,
		netsnmp_handler_registration *reginfo,
		netsnmp_agent_request_info *reqinfo, netsnmp_request_info *requests)
{
	struct cfg_group_tcp t;
	unsigned int value;

	tcp_options_get(&t);
	value = t.crlf_ping;

	switch(reqinfo->mode) {

		case MODE_GET:
			snmp_set_var_typed_value(requests->requestvb, ASN_INTEGER,
					(u_char *)&value, sizeof(int));
			break;


		default:
			/* we should never get here, so this is a really bad error */
			snmp_log(LOG_ERR,
					"unknown mode (%d) in handle_kamailioNetTcpCrlfPing\n",
					reqinfo->mode);
			return SNMP_ERR_GENERR;
	}

	return SNMP_ERR_NOERROR;
}

int handle_kamailioNetTcpAcceptAliases(netsnmp_mib_handler *handler,
		netsnmp_handler_registration *reginfo,
		netsnmp_agent_request_info *reqinfo, netsnmp_request_info *requests)
{
	struct cfg_group_tcp t;
	unsigned int value;

	tcp_options_get(&t);
	value = t.accept_aliases;

	switch(reqinfo->mode) {

		case MODE_GET:
			snmp_set_var_typed_value(requests->requestvb, ASN_INTEGER,
					(u_char *)&value, sizeof(int));
			break;


		default:
			/* we should never get here, so this is a really bad error */
			snmp_log(LOG_ERR,
					"unknown mode (%d) in handle_kamailioNetTcpAcceptAliases\n",
					reqinfo->mode);
			return SNMP_ERR_GENERR;
	}

	return SNMP_ERR_NOERROR;
}

int handle_kamailioNetTcpAcceptNoCl(netsnmp_mib_handler *handler,
		netsnmp_handler_registration *reginfo,
		netsnmp_agent_request_info *reqinfo, netsnmp_request_info *requests)
{
	struct cfg_group_tcp t;
	unsigned int value;

	tcp_options_get(&t);
	value = t.accept_no_cl;

	switch(reqinfo->mode) {

		case MODE_GET:
			snmp_set_var_typed_value(requests->requestvb, ASN_INTEGER,
					(u_char *)&value, sizeof(int));
			break;


		default:
			/* we should never get here, so this is a really bad error */
			snmp_log(LOG_ERR,
					"unknown mode (%d) in handle_kamailioNetTcpAcceptNoCl\n",
					reqinfo->mode);
			return SNMP_ERR_GENERR;
	}

	return SNMP_ERR_NOERROR;
}

int handle_kamailioNetWsConnsActive(netsnmp_mib_handler *handler,
		netsnmp_handler_registration *reginfo,
		netsnmp_agent_request_info *reqinfo, netsnmp_request_info *requests)
{
	int datafield = get_statistic("ws_current_connections");

	switch(reqinfo->mode) {
		case MODE_GET:
			snmp_set_var_typed_value(requests->requestvb, ASN_GAUGE,
					(u_char *)&datafield, sizeof(int));
			break;


		default:
			/* we should never get here, so this is a really bad error */
			snmp_log(LOG_ERR,
					"unknown mode (%d) in handle_kamailioNetWsConnsActive\n",
					reqinfo->mode);
			return SNMP_ERR_GENERR;
	}

	return SNMP_ERR_NOERROR;
}
int handle_kamailioNetWsConnsActiveMax(netsnmp_mib_handler *handler,
		netsnmp_handler_registration *reginfo,
		netsnmp_agent_request_info *reqinfo, netsnmp_request_info *requests)
{
	int datafield = get_statistic("ws_max_concurrent_connections");

	switch(reqinfo->mode) {

		case MODE_GET:
			snmp_set_var_typed_value(requests->requestvb, ASN_GAUGE,
					(u_char *)&datafield, sizeof(int));
			break;


		default:
			/* we should never get here, so this is a really bad error */
			snmp_log(LOG_ERR,
					"unknown mode (%d) in handle_kamailioNetWsConnsActiveMax\n",
					reqinfo->mode);
			return SNMP_ERR_GENERR;
	}

	return SNMP_ERR_NOERROR;
}
int handle_kamailioNetWsConnsFailed(netsnmp_mib_handler *handler,
		netsnmp_handler_registration *reginfo,
		netsnmp_agent_request_info *reqinfo, netsnmp_request_info *requests)
{
	int datafield = get_statistic("ws_failed_connections");

	switch(reqinfo->mode) {

		case MODE_GET:
			snmp_set_var_typed_value(requests->requestvb, ASN_COUNTER,
					(u_char *)&datafield, sizeof(int));
			break;


		default:
			/* we should never get here, so this is a really bad error */
			snmp_log(LOG_ERR,
					"unknown mode (%d) in handle_kamailioNetWsConnsFailed\n",
					reqinfo->mode);
			return SNMP_ERR_GENERR;
	}

	return SNMP_ERR_NOERROR;
}
int handle_kamailioNetWsConnsClosedLocal(netsnmp_mib_handler *handler,
		netsnmp_handler_registration *reginfo,
		netsnmp_agent_request_info *reqinfo, netsnmp_request_info *requests)
{
	int datafield = get_statistic("ws_local_closed_connections");

	switch(reqinfo->mode) {

		case MODE_GET:
			snmp_set_var_typed_value(requests->requestvb, ASN_COUNTER,
					(u_char *)&datafield, sizeof(int));
			break;


		default:
			/* we should never get here, so this is a really bad error */
			snmp_log(LOG_ERR,
					"unknown mode (%d) in "
					"handle_kamailioNetWsConnsClosedLocal\n",
					reqinfo->mode);
			return SNMP_ERR_GENERR;
	}

	return SNMP_ERR_NOERROR;
}
int handle_kamailioNetWsConnsClosedRemote(netsnmp_mib_handler *handler,
		netsnmp_handler_registration *reginfo,
		netsnmp_agent_request_info *reqinfo, netsnmp_request_info *requests)
{
	int datafield = get_statistic("ws_remote_closed_connections");

	switch(reqinfo->mode) {

		case MODE_GET:
			snmp_set_var_typed_value(requests->requestvb, ASN_COUNTER,
					(u_char *)&datafield, sizeof(int));
			break;


		default:
			/* we should never get here, so this is a really bad error */
			snmp_log(LOG_ERR,
					"unknown mode (%d) in "
					"handle_kamailioNetWsConnsClosedRemote\n",
					reqinfo->mode);
			return SNMP_ERR_GENERR;
	}

	return SNMP_ERR_NOERROR;
}
int handle_kamailioNetWsFramesRx(netsnmp_mib_handler *handler,
		netsnmp_handler_registration *reginfo,
		netsnmp_agent_request_info *reqinfo, netsnmp_request_info *requests)
{
	int datafield = get_statistic("ws_received_frames");

	switch(reqinfo->mode) {

		case MODE_GET:
			snmp_set_var_typed_value(requests->requestvb, ASN_COUNTER,
					(u_char *)&datafield, sizeof(int));
			break;


		default:
			/* we should never get here, so this is a really bad error */
			snmp_log(LOG_ERR,
					"unknown mode (%d) in handle_kamailioNetWsFramesRx\n",
					reqinfo->mode);
			return SNMP_ERR_GENERR;
	}

	return SNMP_ERR_NOERROR;
}
int handle_kamailioNetWsFramesTx(netsnmp_mib_handler *handler,
		netsnmp_handler_registration *reginfo,
		netsnmp_agent_request_info *reqinfo, netsnmp_request_info *requests)
{
	int datafield = get_statistic("ws_transmitted_frames");

	switch(reqinfo->mode) {

		case MODE_GET:
			snmp_set_var_typed_value(requests->requestvb, ASN_COUNTER,
					(u_char *)&datafield, sizeof(int));
			break;


		default:
			/* we should never get here, so this is a really bad error */
			snmp_log(LOG_ERR,
					"unknown mode (%d) in handle_kamailioNetWsFramesTx\n",
					reqinfo->mode);
			return SNMP_ERR_GENERR;
	}

	return SNMP_ERR_NOERROR;
}
int handle_kamailioNetWsHandshakeSuccess(netsnmp_mib_handler *handler,
		netsnmp_handler_registration *reginfo,
		netsnmp_agent_request_info *reqinfo, netsnmp_request_info *requests)
{
	int datafield = get_statistic("ws_successful_handshakes");

	switch(reqinfo->mode) {

		case MODE_GET:
			snmp_set_var_typed_value(requests->requestvb, ASN_COUNTER,
					(u_char *)&datafield, sizeof(int));
			break;


		default:
			/* we should never get here, so this is a really bad error */
			snmp_log(LOG_ERR,
					"unknown mode (%d) in "
					"handle_kamailioNetWsHandshakeSuccess\n",
					reqinfo->mode);
			return SNMP_ERR_GENERR;
	}

	return SNMP_ERR_NOERROR;
}
int handle_kamailioNetWsHandshakeFailed(netsnmp_mib_handler *handler,
		netsnmp_handler_registration *reginfo,
		netsnmp_agent_request_info *reqinfo, netsnmp_request_info *requests)
{
	int datafield = get_statistic("ws_failed_handshakes");

	switch(reqinfo->mode) {

		case MODE_GET:
			snmp_set_var_typed_value(requests->requestvb, ASN_COUNTER,
					(u_char *)&datafield, sizeof(int));
			break;


		default:
			/* we should never get here, so this is a really bad error */
			snmp_log(LOG_ERR,
					"unknown mode (%d) in "
					"handle_kamailioNetWsHandshakeFailed\n",
					reqinfo->mode);
			return SNMP_ERR_GENERR;
	}

	return SNMP_ERR_NOERROR;
}
