# Microsoft.NET.Build.Containers 8.0.100

This version brings the following new features and enhancements:

* For .NET 8-targeting applications, the generated container user will not have root permissions by default. This is a breaking change from previous versions, but it is a more secure default. If you need to run your container as root, you can set the `ContainerUser` property to `root` in your project file. Note also that in .NET 8 several changes were made to the Microsoft .NET base images, like changing the default ASP.NET port to 8080, so applications newly-targeting .NET may have to adjust to these settings.
* Generated container images now default to using the `latest` tag instead of the value of the MSBuild `Version` property, to align with other container tooling. You can still override this behavior by setting the `ContainerTag` property in your project file.
* The `ContainerFamily` property was added to support choosing from different variants of image tags without needing to specify the entire base image. For example, to target Alpine Linux you can now set `ContainerFamily` to `alpine`.
* The generated images will now correctly set `User` and `ExposedPort` metadata based on well-known .NET Environment variables for these settings.
* We now support using base images that set `Entrypoint` instead of `Cmd`. The previous `ContainerEntrypoint` and `ContainerEntrypointArgs` properties are still supported, but will log a warning when used. You should now use `ContainerAppCommand` and `ContainerAppCommandArgs` instead to set the desired start application - these properties allow the tooling to select the proper app start command based on the base images' use of Entrypoint or Cmd. Thanks to @tmds for this functionality!
* We explicitly support using podman as a local destination for your containers. If `podman` is present on the system and `docker` is not, we will opt to use `podman` instead. If you'd like to make this behavior explicit you can set `LocalRegistry` to either `docker` or `podman`. Thanks to @tmds for this contribution!
* Permissions for files in the images not don't have the executable bit set unless it is necessary.
* Support for authenticating using Identity Token flows was added. This unblocks support for Azure Managed Identities, as well as all other registries where the result of `docker login <registry url>` is an Identity Token instead of an Access Token or Username/Password pair.
