// Licensed to the .NET Foundation under one or more agreements.
// The .NET Foundation licenses this file to you under the MIT license.

using Microsoft.EntityFrameworkCore.ChangeTracking.Internal;

namespace Microsoft.EntityFrameworkCore.ChangeTracking;

/// <summary>
///     Event arguments for events relating to tracked <see cref="EntityEntry" />s.
/// </summary>
/// <remarks>
///     See <see href="https://aka.ms/efcore-docs-entity-entries">Accessing tracked entities in EF Core</see> for more information and
///     examples.
/// </remarks>
public class EntityEntryEventArgs : EventArgs
{
    private readonly InternalEntityEntry _internalEntityEntry;

    /// <summary>
    ///     This is an internal API that supports the Entity Framework Core infrastructure and not subject to
    ///     the same compatibility standards as public APIs. It may be changed or removed without notice in
    ///     any release. You should only use it directly in your code with extreme caution and knowing that
    ///     doing so can result in application failures when updating to a new Entity Framework Core release.
    /// </summary>
    [EntityFrameworkInternal]
    public EntityEntryEventArgs(
        InternalEntityEntry internalEntityEntry)
        => _internalEntityEntry = internalEntityEntry;

    /// <summary>
    ///     The <see cref="EntityEntry" /> for the entity.
    /// </summary>
    [field: AllowNull, MaybeNull]
    public virtual EntityEntry Entry
        => field ??= new EntityEntry(_internalEntityEntry);
}
