#!/bin/sh
# SPDX-License-Identifier: BSD-2-Clause
# SPDX-FileCopyrightText: © 2024 Antoine Le Gonidec <vv221@dotslashplay.it>
set -o errexit

###
# Citizen Sleeper
###

script_version=20240530.1

PLAYIT_COMPATIBILITY_LEVEL='2.29'

GAME_ID='citizen-sleeper'
GAME_NAME='Citizen Sleeper'

ARCHIVE_BASE_1_NAME='setup_citizen_sleeper_1.4.6_(69854).exe'
ARCHIVE_BASE_1_MD5='ac9b59f393ca34a89a42ba510bbba4ab'
ARCHIVE_BASE_1_TYPE='innosetup'
ARCHIVE_BASE_1_SIZE='1170957'
ARCHIVE_BASE_1_VERSION='1.4.6-gog69854'
ARCHIVE_BASE_1_URL='https://www.gog.com/game/citizen_sleeper'

ARCHIVE_BASE_0_NAME='setup_citizen_sleeper_1.3.9_(65533).exe'
ARCHIVE_BASE_0_MD5='50b240a6cd4fb79096d6d5252daac6b7'
ARCHIVE_BASE_0_TYPE='innosetup'
ARCHIVE_BASE_0_SIZE='973177'
ARCHIVE_BASE_0_VERSION='1.3.9-gog65533'

UNITY3D_NAME='citizen sleeper'

CONTENT_PATH_DEFAULT='.'

WINE_PERSISTENT_DIRECTORIES='
users/${USER}/AppData/LocalLow/Jump Over the Age/Citizen Sleeper'

PACKAGES_LIST='
PKG_BIN
PKG_DATA'

PKG_DATA_ID="${GAME_ID}-data"
PKG_DATA_DESCRIPTION='data'

PKG_BIN_ARCH='64'
PKG_BIN_DEPS="$PKG_DATA_ID"

# Load common functions

PLAYIT_LIB_PATHS="
$PWD
${XDG_DATA_HOME:="${HOME}/.local/share"}/play.it
/usr/local/share/games/play.it
/usr/local/share/play.it
/usr/share/games/play.it
/usr/share/play.it"

if [ -z "$PLAYIT_LIB2" ]; then
	for playit_lib_path in $PLAYIT_LIB_PATHS; do
		if [ -e "${playit_lib_path}/libplayit2.sh" ]; then
			PLAYIT_LIB2="${playit_lib_path}/libplayit2.sh"
			break
		fi
	done
fi
if [ -z "$PLAYIT_LIB2" ]; then
	printf '\n\033[1;31mError:\033[0m\n'
	printf 'libplayit2.sh not found.\n'
	exit 1
fi
. "$PLAYIT_LIB2"

# Extract game data

archive_extraction_default

# Include game data

content_inclusion_icons 'PKG_DATA'
content_inclusion_default

# Write launchers

launchers_generation 'PKG_BIN'

# Build packages

packages_generation
print_instructions

# Clean up

rm --recursive "$PLAYIT_WORKDIR"

exit 0
