/*
 * Copyright (C) 2025 Apple Inc. All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 *
 * THIS SOFTWARE IS PROVIDED BY APPLE INC. AND ITS CONTRIBUTORS ``AS IS''
 * AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO,
 * THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR
 * PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL APPLE INC. OR ITS CONTRIBUTORS
 * BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR
 * CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF
 * SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS
 * INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN
 * CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE)
 * ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF
 * THE POSSIBILITY OF SUCH DAMAGE.
 */

#include "config.h"
#include "MediaSamplesBlock.h"

#if USE(AVFOUNDATION)
#include "CMUtilities.h"
#include "MediaSampleAVFObjC.h"
#include <CoreMedia/CMFormatDescription.h>

#include <pal/cf/CoreMediaSoftLink.h>
#endif

namespace WebCore {

RefPtr<MediaSample> MediaSamplesBlock::toMediaSample(const MediaSample* referenceSample) const
{
#if USE(AVFOUNDATION)
    RetainPtr cmSample = referenceSample ? referenceSample->platformSample().cmSampleBuffer() : nullptr;
    RetainPtr description = cmSample ? PAL::CMSampleBufferGetFormatDescription(cmSample.get()) : nullptr;
    auto result = toCMSampleBuffer(*this, description.get());
    ASSERT(!!result);
    return result ? RefPtr { MediaSampleAVFObjC::create(result->get(), trackID()) } : nullptr;
#else
    UNUSED_PARAM(referenceSample);
    ASSERT_NOT_REACHED();
    return nullptr;
#endif
}

UniqueRef<MediaSamplesBlock> MediaSamplesBlock::fromMediaSample(const MediaSample& sample, const TrackInfo* trackInfo)
{
#if USE(AVFOUNDATION)
    RetainPtr cmSampleBuffer = sample.platformSample().cmSampleBuffer();
    return samplesBlockFromCMSampleBuffer(cmSampleBuffer.get(), trackInfo);
#else
    UNUSED_PARAM(sample);
    UNUSED_PARAM(trackInfo);
    ASSERT_NOT_REACHED();
    return makeUniqueRef<MediaSamplesBlock>();
#endif
}

} // namespace WebCore
