/*
 * Copyright (c) 2016, 2023, Oracle and/or its affiliates. All rights reserved.
 * DO NOT ALTER OR REMOVE COPYRIGHT NOTICES OR THIS FILE HEADER.
 *
 * This code is free software; you can redistribute it and/or modify it
 * under the terms of the GNU General Public License version 2 only, as
 * published by the Free Software Foundation.
 *
 * This code is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
 * FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License
 * version 2 for more details (a copy is included in the LICENSE file that
 * accompanied this code).
 *
 * You should have received a copy of the GNU General Public License version
 * 2 along with this work; if not, write to the Free Software Foundation,
 * Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
 *
 * Please contact Oracle, 500 Oracle Parkway, Redwood Shores, CA 94065 USA
 * or visit www.oracle.com if you need additional information or have any
 * questions.
 */

/*
 * @test
 * @requires vm.flavor == "minimal"
 * @requires vm.flagless
 * @library /test/lib
 * @run main/othervm JMX
 */

import jdk.test.lib.JDKToolFinder;
import jdk.test.lib.process.OutputAnalyzer;
import jdk.test.lib.process.ProcessTools;

public class JMX {

    public static void main(String args[]) throws Exception {
        ProcessBuilder pb;

        pb = ProcessTools.createLimitedTestJavaProcessBuilder("-minimal", "-XX:+ManagementServer", "-version");
        new OutputAnalyzer(pb.start())
                .shouldContain("ManagementServer is not supported in this VM.")
                .shouldHaveExitValue(1);

        pb = ProcessTools.createLimitedTestJavaProcessBuilder("-minimal", "-Dcom.sun.management ", "-version");
        new OutputAnalyzer(pb.start())
                .shouldContain("-Dcom.sun.management is not supported in this VM.")
                .shouldHaveExitValue(1);

        pb.command(new String[] { JDKToolFinder.getJDKTool("jcmd"), "-l"});
        new OutputAnalyzer(pb.start())
                .shouldNotMatch("^" + Long.toString(ProcessTools.getProcessId()) + "\\s+.*$");
    }
}
