/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.reasoner.rulesys;

import java.util.Iterator;
import org.apache.jena.graph.Factory;
import org.apache.jena.graph.Graph;
import org.apache.jena.graph.Node;
import org.apache.jena.graph.Triple;
import org.apache.jena.reasoner.BaseInfGraph;
import org.apache.jena.reasoner.Derivation;
import org.apache.jena.reasoner.FGraph;
import org.apache.jena.reasoner.Finder;
import org.apache.jena.reasoner.FinderUtil;
import org.apache.jena.reasoner.Reasoner;
import org.apache.jena.reasoner.ReasonerException;
import org.apache.jena.reasoner.TriplePattern;
import org.apache.jena.reasoner.rulesys.BackwardRuleInfGraphI;
import org.apache.jena.reasoner.rulesys.BindingEnvironment;
import org.apache.jena.reasoner.rulesys.Builtin;
import org.apache.jena.reasoner.rulesys.ClauseEntry;
import org.apache.jena.reasoner.rulesys.Functor;
import org.apache.jena.reasoner.rulesys.Rule;
import org.apache.jena.reasoner.rulesys.impl.BBRuleContext;
import org.apache.jena.reasoner.rulesys.impl.BindingVector;
import org.apache.jena.reasoner.rulesys.impl.LPBRuleEngine;
import org.apache.jena.reasoner.rulesys.impl.LPRuleStore;
import org.apache.jena.reasoner.rulesys.impl.TempNodeCache;
import org.apache.jena.util.OneToManyMap;
import org.apache.jena.util.iterator.ExtendedIterator;
import org.apache.jena.util.iterator.NullIterator;
import org.apache.jena.util.iterator.UniqueFilter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LPBackwardRuleInfGraph
extends BaseInfGraph
implements BackwardRuleInfGraphI {
    protected LPBRuleEngine engine;
    protected OneToManyMap<Triple, Derivation> derivations;
    protected FGraph fschema;
    protected FGraph fdeductions;
    protected Finder dataFind;
    protected TempNodeCache tempNodecache;
    static Logger logger = LoggerFactory.getLogger(LPBackwardRuleInfGraph.class);

    public LPBackwardRuleInfGraph(Reasoner reasoner, LPRuleStore ruleStore, Graph data, Graph schema) {
        super(data, reasoner);
        if (schema != null) {
            this.fschema = new FGraph(schema);
        }
        this.engine = new LPBRuleEngine(this, ruleStore);
        this.tempNodecache = new TempNodeCache(this);
    }

    @Override
    public Graph getSchemaGraph() {
        return this.fschema.getGraph();
    }

    @Override
    public synchronized void prepare() {
        if (this.isPrepared()) {
            return;
        }
        this.fdeductions = new FGraph(Factory.createGraphMem());
        this.extractAxioms();
        this.dataFind = this.fdata;
        if (this.fdeductions != null) {
            this.dataFind = FinderUtil.cascade(this.dataFind, this.fdeductions);
        }
        if (this.fschema != null) {
            this.dataFind = FinderUtil.cascade(this.dataFind, this.fschema);
        }
        this.setPreparedState(true);
    }

    @Override
    public synchronized void rebind(Graph data) {
        this.engine.checkSafeToUpdate();
        this.fdata = new FGraph(data);
        this.setPreparedState(false);
    }

    @Override
    public synchronized void rebind() {
        ++this.version;
        this.engine.checkSafeToUpdate();
        this.setPreparedState(false);
    }

    @Override
    public synchronized void reset() {
        ++this.version;
        this.engine.checkSafeToUpdate();
        this.engine.reset();
    }

    @Override
    public synchronized ExtendedIterator<Triple> findWithContinuation(TriplePattern pattern, Finder continuation) {
        this.checkOpen();
        this.requirePrepared();
        ExtendedIterator<Triple> result = this.engine.find(pattern).filterKeep(new UniqueFilter());
        if (continuation != null) {
            result = result.andThen(continuation.find(pattern));
        }
        return result.filterDrop(Functor.acceptFilter);
    }

    @Override
    public ExtendedIterator<Triple> graphBaseFind(Node subject, Node property, Node object) {
        return this.findWithContinuation(new TriplePattern(subject, property, object), null);
    }

    @Override
    public ExtendedIterator<Triple> find(TriplePattern pattern) {
        return this.findWithContinuation(pattern, null);
    }

    @Override
    public synchronized void performAdd(Triple t) {
        ++this.version;
        this.engine.checkSafeToUpdate();
        this.fdata.getGraph().add(t);
        this.setPreparedState(false);
    }

    @Override
    public synchronized void performDelete(Triple t) {
        ++this.version;
        this.engine.checkSafeToUpdate();
        this.fdata.getGraph().delete(t);
        this.setPreparedState(false);
    }

    public void setTabled(Node predicate) {
        this.engine.tablePredicate(predicate);
        if (this.isTraceOn()) {
            logger.info("LP TABLE " + predicate);
        }
    }

    @Override
    public void setDerivationLogging(boolean recordDerivations) {
        this.engine.setDerivationLogging(recordDerivations);
        this.derivations = recordDerivations ? new OneToManyMap() : null;
    }

    @Override
    public Iterator<Derivation> getDerivation(Triple t) {
        if (this.derivations == null) {
            return new NullIterator<Derivation>();
        }
        return this.derivations.getAll(t);
    }

    public void setTraceOn(boolean state) {
        this.engine.setTraceOn(state);
    }

    public boolean isTraceOn() {
        return this.engine.isTraceOn();
    }

    @Override
    public void logDerivation(Triple t, Derivation derivation) {
        this.derivations.put(t, derivation);
    }

    @Override
    public ExtendedIterator<Triple> findDataMatches(TriplePattern pattern) {
        return this.dataFind.find(pattern);
    }

    @Override
    public boolean processBuiltin(ClauseEntry clause, Rule rule, BindingEnvironment env) {
        throw new ReasonerException("Internal error in FBLP rule engine, incorrect invocation of building in rule " + rule);
    }

    @Override
    public void silentAdd(Triple t) {
        this.fdeductions.getGraph().add(t);
    }

    @Override
    public Node getTemp(Node instance, Node prop, Node pclass) {
        return this.tempNodecache.getTemp(instance, prop, pclass);
    }

    protected void extractAxioms() {
        Graph axioms = this.fdeductions.getGraph();
        BBRuleContext contextForBuiltins = null;
        for (Rule rule : this.engine.getRuleStore().getAllRules()) {
            if (rule.bodyLength() != 0) continue;
            for (int j = 0; j < rule.headLength(); ++j) {
                Functor f;
                Builtin implementation;
                ClauseEntry axiom = rule.getHeadElement(j);
                if (axiom instanceof TriplePattern) {
                    axioms.add(((TriplePattern)axiom).asTriple());
                    continue;
                }
                if (!(axiom instanceof Functor)) continue;
                if (contextForBuiltins == null) {
                    contextForBuiltins = new BBRuleContext(this);
                }
                if ((implementation = (f = (Functor)axiom).getImplementor()) == null) {
                    throw new ReasonerException("Attempted to invoke undefined functor: " + f);
                }
                Node[] args = f.getArgs();
                contextForBuiltins.setEnv(new BindingVector(args));
                contextForBuiltins.setRule(rule);
                implementation.headAction(args, args.length, contextForBuiltins);
            }
        }
    }
}

