/*
 * Copyright (C) 2017  Advanced Micro Devices, Inc.
 *
 * Permission is hereby granted, free of charge, to any person obtaining a
 * copy of this software and associated documentation files (the "Software"),
 * to deal in the Software without restriction, including without limitation
 * the rights to use, copy, modify, merge, publish, distribute, sublicense,
 * and/or sell copies of the Software, and to permit persons to whom the
 * Software is furnished to do so, subject to the following conditions:
 *
 * The above copyright notice and this permission notice shall be included
 * in all copies or substantial portions of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS
 * OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT.  IN NO EVENT SHALL
 * THE COPYRIGHT HOLDER(S) BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER IN
 * AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN
 * CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE.
 */
#ifndef _dce_12_0_SH_MASK_HEADER
#define _dce_12_0_SH_MASK_HEADER


// addressBlock: dce_dc_dispdec_VGA_MEM_WRITE_PAGE_ADDR
//dispdec_VGA_MEM_WRITE_PAGE_ADDR
#define dispdec_VGA_MEM_WRITE_PAGE_ADDR__VGA_MEM_WRITE_PAGE0_ADDR__SHIFT                                      0x0
#define dispdec_VGA_MEM_WRITE_PAGE_ADDR__VGA_MEM_WRITE_PAGE1_ADDR__SHIFT                                      0x10
#define dispdec_VGA_MEM_WRITE_PAGE_ADDR__VGA_MEM_WRITE_PAGE0_ADDR_MASK                                        0x000003FFL
#define dispdec_VGA_MEM_WRITE_PAGE_ADDR__VGA_MEM_WRITE_PAGE1_ADDR_MASK                                        0x03FF0000L


// addressBlock: dce_dc_dispdec_VGA_MEM_READ_PAGE_ADDR
//dispdec_VGA_MEM_READ_PAGE_ADDR
#define dispdec_VGA_MEM_READ_PAGE_ADDR__VGA_MEM_READ_PAGE0_ADDR__SHIFT                                        0x0
#define dispdec_VGA_MEM_READ_PAGE_ADDR__VGA_MEM_READ_PAGE1_ADDR__SHIFT                                        0x10
#define dispdec_VGA_MEM_READ_PAGE_ADDR__VGA_MEM_READ_PAGE0_ADDR_MASK                                          0x000003FFL
#define dispdec_VGA_MEM_READ_PAGE_ADDR__VGA_MEM_READ_PAGE1_ADDR_MASK                                          0x03FF0000L


// addressBlock: dce_dc_dc_perfmon0_dispdec
//DC_PERFMON0_PERFCOUNTER_CNTL
#define DC_PERFMON0_PERFCOUNTER_CNTL__PERFCOUNTER_EVENT_SEL__SHIFT                                            0x0
#define DC_PERFMON0_PERFCOUNTER_CNTL__PERFCOUNTER_CVALUE_SEL__SHIFT                                           0x9
#define DC_PERFMON0_PERFCOUNTER_CNTL__PERFCOUNTER_INC_MODE__SHIFT                                             0xc
#define DC_PERFMON0_PERFCOUNTER_CNTL__PERFCOUNTER_HW_CNTL_SEL__SHIFT                                          0xf
#define DC_PERFMON0_PERFCOUNTER_CNTL__PERFCOUNTER_RUNEN_MODE__SHIFT                                           0x10
#define DC_PERFMON0_PERFCOUNTER_CNTL__PERFCOUNTER_CNTOFF_SEL__SHIFT                                           0x11
#define DC_PERFMON0_PERFCOUNTER_CNTL__PERFCOUNTER_CNTOFF_START_DIS__SHIFT                                     0x16
#define DC_PERFMON0_PERFCOUNTER_CNTL__PERFCOUNTER_RESTART_EN__SHIFT                                           0x17
#define DC_PERFMON0_PERFCOUNTER_CNTL__PERFCOUNTER_INT_EN__SHIFT                                               0x18
#define DC_PERFMON0_PERFCOUNTER_CNTL__PERFCOUNTER_OFF_MASK__SHIFT                                             0x19
#define DC_PERFMON0_PERFCOUNTER_CNTL__PERFCOUNTER_ACTIVE__SHIFT                                               0x1a
#define DC_PERFMON0_PERFCOUNTER_CNTL__PERFCOUNTER_INT_TYPE__SHIFT                                             0x1b
#define DC_PERFMON0_PERFCOUNTER_CNTL__PERFCOUNTER_CNTL_SEL__SHIFT                                             0x1d
#define DC_PERFMON0_PERFCOUNTER_CNTL__PERFCOUNTER_EVENT_SEL_MASK                                              0x000001FFL
#define DC_PERFMON0_PERFCOUNTER_CNTL__PERFCOUNTER_CVALUE_SEL_MASK                                             0x00000E00L
#define DC_PERFMON0_PERFCOUNTER_CNTL__PERFCOUNTER_INC_MODE_MASK                                               0x00007000L
#define DC_PERFMON0_PERFCOUNTER_CNTL__PERFCOUNTER_HW_CNTL_SEL_MASK                                            0x00008000L
#define DC_PERFMON0_PERFCOUNTER_CNTL__PERFCOUNTER_RUNEN_MODE_MASK                                             0x00010000L
#define DC_PERFMON0_PERFCOUNTER_CNTL__PERFCOUNTER_CNTOFF_SEL_MASK                                             0x003E0000L
#define DC_PERFMON0_PERFCOUNTER_CNTL__PERFCOUNTER_CNTOFF_START_DIS_MASK                                       0x00400000L
#define DC_PERFMON0_PERFCOUNTER_CNTL__PERFCOUNTER_RESTART_EN_MASK                                             0x00800000L
#define DC_PERFMON0_PERFCOUNTER_CNTL__PERFCOUNTER_INT_EN_MASK                                                 0x01000000L
#define DC_PERFMON0_PERFCOUNTER_CNTL__PERFCOUNTER_OFF_MASK_MASK                                               0x02000000L
#define DC_PERFMON0_PERFCOUNTER_CNTL__PERFCOUNTER_ACTIVE_MASK                                                 0x04000000L
#define DC_PERFMON0_PERFCOUNTER_CNTL__PERFCOUNTER_INT_TYPE_MASK                                               0x08000000L
#define DC_PERFMON0_PERFCOUNTER_CNTL__PERFCOUNTER_CNTL_SEL_MASK                                               0xE0000000L
//DC_PERFMON0_PERFCOUNTER_CNTL2
#define DC_PERFMON0_PERFCOUNTER_CNTL2__PERFCOUNTER_COUNTED_VALUE_TYPE__SHIFT                                  0x0
#define DC_PERFMON0_PERFCOUNTER_CNTL2__PERFCOUNTER_HW_STOP1_SEL__SHIFT                                        0x2
#define DC_PERFMON0_PERFCOUNTER_CNTL2__PERFCOUNTER_HW_STOP2_SEL__SHIFT                                        0x3
#define DC_PERFMON0_PERFCOUNTER_CNTL2__PERFCOUNTER_CNTL2_SEL__SHIFT                                           0x1d
#define DC_PERFMON0_PERFCOUNTER_CNTL2__PERFCOUNTER_COUNTED_VALUE_TYPE_MASK                                    0x00000003L
#define DC_PERFMON0_PERFCOUNTER_CNTL2__PERFCOUNTER_HW_STOP1_SEL_MASK                                          0x00000004L
#define DC_PERFMON0_PERFCOUNTER_CNTL2__PERFCOUNTER_HW_STOP2_SEL_MASK                                          0x00000008L
#define DC_PERFMON0_PERFCOUNTER_CNTL2__PERFCOUNTER_CNTL2_SEL_MASK                                             0xE0000000L
//DC_PERFMON0_PERFCOUNTER_STATE
#define DC_PERFMON0_PERFCOUNTER_STATE__PERFCOUNTER_CNT0_STATE__SHIFT                                          0x0
#define DC_PERFMON0_PERFCOUNTER_STATE__PERFCOUNTER_STATE_SEL0__SHIFT                                          0x2
#define DC_PERFMON0_PERFCOUNTER_STATE__PERFCOUNTER_CNT1_STATE__SHIFT                                          0x4
#define DC_PERFMON0_PERFCOUNTER_STATE__PERFCOUNTER_STATE_SEL1__SHIFT                                          0x6
#define DC_PERFMON0_PERFCOUNTER_STATE__PERFCOUNTER_CNT2_STATE__SHIFT                                          0x8
#define DC_PERFMON0_PERFCOUNTER_STATE__PERFCOUNTER_STATE_SEL2__SHIFT                                          0xa
#define DC_PERFMON0_PERFCOUNTER_STATE__PERFCOUNTER_CNT3_STATE__SHIFT                                          0xc
#define DC_PERFMON0_PERFCOUNTER_STATE__PERFCOUNTER_STATE_SEL3__SHIFT                                          0xe
#define DC_PERFMON0_PERFCOUNTER_STATE__PERFCOUNTER_CNT4_STATE__SHIFT                                          0x10
#define DC_PERFMON0_PERFCOUNTER_STATE__PERFCOUNTER_STATE_SEL4__SHIFT                                          0x12
#define DC_PERFMON0_PERFCOUNTER_STATE__PERFCOUNTER_CNT5_STATE__SHIFT                                          0x14
#define DC_PERFMON0_PERFCOUNTER_STATE__PERFCOUNTER_STATE_SEL5__SHIFT                                          0x16
#define DC_PERFMON0_PERFCOUNTER_STATE__PERFCOUNTER_CNT6_STATE__SHIFT                                          0x18
#define DC_PERFMON0_PERFCOUNTER_STATE__PERFCOUNTER_STATE_SEL6__SHIFT                                          0x1a
#define DC_PERFMON0_PERFCOUNTER_STATE__PERFCOUNTER_CNT7_STATE__SHIFT                                          0x1c
#define DC_PERFMON0_PERFCOUNTER_STATE__PERFCOUNTER_STATE_SEL7__SHIFT                                          0x1e
#define DC_PERFMON0_PERFCOUNTER_STATE__PERFCOUNTER_CNT0_STATE_MASK                                            0x00000003L
#define DC_PERFMON0_PERFCOUNTER_STATE__PERFCOUNTER_STATE_SEL0_MASK                                            0x00000004L
#define DC_PERFMON0_PERFCOUNTER_STATE__PERFCOUNTER_CNT1_STATE_MASK                                            0x00000030L
#define DC_PERFMON0_PERFCOUNTER_STATE__PERFCOUNTER_STATE_SEL1_MASK                                            0x00000040L
#define DC_PERFMON0_PERFCOUNTER_STATE__PERFCOUNTER_CNT2_STATE_MASK                                            0x00000300L
#define DC_PERFMON0_PERFCOUNTER_STATE__PERFCOUNTER_STATE_SEL2_MASK                                            0x00000400L
#define DC_PERFMON0_PERFCOUNTER_STATE__PERFCOUNTER_CNT3_STATE_MASK                                            0x00003000L
#define DC_PERFMON0_PERFCOUNTER_STATE__PERFCOUNTER_STATE_SEL3_MASK                                            0x00004000L
#define DC_PERFMON0_PERFCOUNTER_STATE__PERFCOUNTER_CNT4_STATE_MASK                                            0x00030000L
#define DC_PERFMON0_PERFCOUNTER_STATE__PERFCOUNTER_STATE_SEL4_MASK                                            0x00040000L
#define DC_PERFMON0_PERFCOUNTER_STATE__PERFCOUNTER_CNT5_STATE_MASK                                            0x00300000L
#define DC_PERFMON0_PERFCOUNTER_STATE__PERFCOUNTER_STATE_SEL5_MASK                                            0x00400000L
#define DC_PERFMON0_PERFCOUNTER_STATE__PERFCOUNTER_CNT6_STATE_MASK                                            0x03000000L
#define DC_PERFMON0_PERFCOUNTER_STATE__PERFCOUNTER_STATE_SEL6_MASK                                            0x04000000L
#define DC_PERFMON0_PERFCOUNTER_STATE__PERFCOUNTER_CNT7_STATE_MASK                                            0x30000000L
#define DC_PERFMON0_PERFCOUNTER_STATE__PERFCOUNTER_STATE_SEL7_MASK                                            0x40000000L
//DC_PERFMON0_PERFMON_CNTL
#define DC_PERFMON0_PERFMON_CNTL__PERFMON_STATE__SHIFT                                                        0x0
#define DC_PERFMON0_PERFMON_CNTL__PERFMON_RPT_COUNT__SHIFT                                                    0x8
#define DC_PERFMON0_PERFMON_CNTL__PERFMON_CNTOFF_AND_OR__SHIFT                                                0x1c
#define DC_PERFMON0_PERFMON_CNTL__PERFMON_CNTOFF_INT_EN__SHIFT                                                0x1d
#define DC_PERFMON0_PERFMON_CNTL__PERFMON_CNTOFF_INT_STATUS__SHIFT                                            0x1e
#define DC_PERFMON0_PERFMON_CNTL__PERFMON_CNTOFF_INT_ACK__SHIFT                                               0x1f
#define DC_PERFMON0_PERFMON_CNTL__PERFMON_STATE_MASK                                                          0x00000003L
#define DC_PERFMON0_PERFMON_CNTL__PERFMON_RPT_COUNT_MASK                                                      0x0FFFFF00L
#define DC_PERFMON0_PERFMON_CNTL__PERFMON_CNTOFF_AND_OR_MASK                                                  0x10000000L
#define DC_PERFMON0_PERFMON_CNTL__PERFMON_CNTOFF_INT_EN_MASK                                                  0x20000000L
#define DC_PERFMON0_PERFMON_CNTL__PERFMON_CNTOFF_INT_STATUS_MASK                                              0x40000000L
#define DC_PERFMON0_PERFMON_CNTL__PERFMON_CNTOFF_INT_ACK_MASK                                                 0x80000000L
//DC_PERFMON0_PERFMON_CNTL2
#define DC_PERFMON0_PERFMON_CNTL2__PERFMON_CNTOFF_INT_TYPE__SHIFT                                             0x0
#define DC_PERFMON0_PERFMON_CNTL2__PERFMON_CLK_ENABLE__SHIFT                                                  0x1
#define DC_PERFMON0_PERFMON_CNTL2__PERFMON_RUN_ENABLE_START_SEL__SHIFT                                        0x2
#define DC_PERFMON0_PERFMON_CNTL2__PERFMON_RUN_ENABLE_STOP_SEL__SHIFT                                         0xa
#define DC_PERFMON0_PERFMON_CNTL2__PERFMON_CNTOFF_INT_TYPE_MASK                                               0x00000001L
#define DC_PERFMON0_PERFMON_CNTL2__PERFMON_CLK_ENABLE_MASK                                                    0x00000002L
#define DC_PERFMON0_PERFMON_CNTL2__PERFMON_RUN_ENABLE_START_SEL_MASK                                          0x000003FCL
#define DC_PERFMON0_PERFMON_CNTL2__PERFMON_RUN_ENABLE_STOP_SEL_MASK                                           0x0003FC00L
//DC_PERFMON0_PERFMON_CVALUE_INT_MISC
#define DC_PERFMON0_PERFMON_CVALUE_INT_MISC__PERFCOUNTER_INT0_STATUS__SHIFT                                   0x0
#define DC_PERFMON0_PERFMON_CVALUE_INT_MISC__PERFCOUNTER_INT1_STATUS__SHIFT                                   0x1
#define DC_PERFMON0_PERFMON_CVALUE_INT_MISC__PERFCOUNTER_INT2_STATUS__SHIFT                                   0x2
#define DC_PERFMON0_PERFMON_CVALUE_INT_MISC__PERFCOUNTER_INT3_STATUS__SHIFT                                   0x3
#define DC_PERFMON0_PERFMON_CVALUE_INT_MISC__PERFCOUNTER_INT4_STATUS__SHIFT                                   0x4
#define DC_PERFMON0_PERFMON_CVALUE_INT_MISC__PERFCOUNTER_INT5_STATUS__SHIFT                                   0x5
#define DC_PERFMON0_PERFMON_CVALUE_INT_MISC__PERFCOUNTER_INT6_STATUS__SHIFT                                   0x6
#define DC_PERFMON0_PERFMON_CVALUE_INT_MISC__PERFCOUNTER_INT7_STATUS__SHIFT                                   0x7
#define DC_PERFMON0_PERFMON_CVALUE_INT_MISC__PERFCOUNTER_INT0_ACK__SHIFT                                      0x8
#define DC_PERFMON0_PERFMON_CVALUE_INT_MISC__PERFCOUNTER_INT1_ACK__SHIFT                                      0x9
#define DC_PERFMON0_PERFMON_CVALUE_INT_MISC__PERFCOUNTER_INT2_ACK__SHIFT                                      0xa
#define DC_PERFMON0_PERFMON_CVALUE_INT_MISC__PERFCOUNTER_INT3_ACK__SHIFT                                      0xb
#define DC_PERFMON0_PERFMON_CVALUE_INT_MISC__PERFCOUNTER_INT4_ACK__SHIFT                                      0xc
#define DC_PERFMON0_PERFMON_CVALUE_INT_MISC__PERFCOUNTER_INT5_ACK__SHIFT                                      0xd
#define DC_PERFMON0_PERFMON_CVALUE_INT_MISC__PERFCOUNTER_INT6_ACK__SHIFT                                      0xe
#define DC_PERFMON0_PERFMON_CVALUE_INT_MISC__PERFCOUNTER_INT7_ACK__SHIFT                                      0xf
#define DC_PERFMON0_PERFMON_CVALUE_INT_MISC__PERFMON_CVALUE_HI__SHIFT                                         0x10
#define DC_PERFMON0_PERFMON_CVALUE_INT_MISC__PERFCOUNTER_INT0_STATUS_MASK                                     0x00000001L
#define DC_PERFMON0_PERFMON_CVALUE_INT_MISC__PERFCOUNTER_INT1_STATUS_MASK                                     0x00000002L
#define DC_PERFMON0_PERFMON_CVALUE_INT_MISC__PERFCOUNTER_INT2_STATUS_MASK                                     0x00000004L
#define DC_PERFMON0_PERFMON_CVALUE_INT_MISC__PERFCOUNTER_INT3_STATUS_MASK                                     0x00000008L
#define DC_PERFMON0_PERFMON_CVALUE_INT_MISC__PERFCOUNTER_INT4_STATUS_MASK                                     0x00000010L
#define DC_PERFMON0_PERFMON_CVALUE_INT_MISC__PERFCOUNTER_INT5_STATUS_MASK                                     0x00000020L
#define DC_PERFMON0_PERFMON_CVALUE_INT_MISC__PERFCOUNTER_INT6_STATUS_MASK                                     0x00000040L
#define DC_PERFMON0_PERFMON_CVALUE_INT_MISC__PERFCOUNTER_INT7_STATUS_MASK                                     0x00000080L
#define DC_PERFMON0_PERFMON_CVALUE_INT_MISC__PERFCOUNTER_INT0_ACK_MASK                                        0x00000100L
#define DC_PERFMON0_PERFMON_CVALUE_INT_MISC__PERFCOUNTER_INT1_ACK_MASK                                        0x00000200L
#define DC_PERFMON0_PERFMON_CVALUE_INT_MISC__PERFCOUNTER_INT2_ACK_MASK                                        0x00000400L
#define DC_PERFMON0_PERFMON_CVALUE_INT_MISC__PERFCOUNTER_INT3_ACK_MASK                                        0x00000800L
#define DC_PERFMON0_PERFMON_CVALUE_INT_MISC__PERFCOUNTER_INT4_ACK_MASK                                        0x00001000L
#define DC_PERFMON0_PERFMON_CVALUE_INT_MISC__PERFCOUNTER_INT5_ACK_MASK                                        0x00002000L
#define DC_PERFMON0_PERFMON_CVALUE_INT_MISC__PERFCOUNTER_INT6_ACK_MASK                                        0x00004000L
#define DC_PERFMON0_PERFMON_CVALUE_INT_MISC__PERFCOUNTER_INT7_ACK_MASK                                        0x00008000L
#define DC_PERFMON0_PERFMON_CVALUE_INT_MISC__PERFMON_CVALUE_HI_MASK                                           0xFFFF0000L
//DC_PERFMON0_PERFMON_CVALUE_LOW
#define DC_PERFMON0_PERFMON_CVALUE_LOW__PERFMON_CVALUE_LOW__SHIFT                                             0x0
#define DC_PERFMON0_PERFMON_CVALUE_LOW__PERFMON_CVALUE_LOW_MASK                                               0xFFFFFFFFL
//DC_PERFMON0_PERFMON_HI
#define DC_PERFMON0_PERFMON_HI__PERFMON_HI__SHIFT                                                             0x0
#define DC_PERFMON0_PERFMON_HI__PERFMON_READ_SEL__SHIFT                                                       0x1d
#define DC_PERFMON0_PERFMON_HI__PERFMON_HI_MASK                                                               0x0000FFFFL
#define DC_PERFMON0_PERFMON_HI__PERFMON_READ_SEL_MASK                                                         0xE0000000L
//DC_PERFMON0_PERFMON_LOW
#define DC_PERFMON0_PERFMON_LOW__PERFMON_LOW__SHIFT                                                           0x0
#define DC_PERFMON0_PERFMON_LOW__PERFMON_LOW_MASK                                                             0xFFFFFFFFL


// addressBlock: dce_dc_dc_perfmon13_dispdec
//DC_PERFMON13_PERFCOUNTER_CNTL
#define DC_PERFMON13_PERFCOUNTER_CNTL__PERFCOUNTER_EVENT_SEL__SHIFT                                           0x0
#define DC_PERFMON13_PERFCOUNTER_CNTL__PERFCOUNTER_CVALUE_SEL__SHIFT                                          0x9
#define DC_PERFMON13_PERFCOUNTER_CNTL__PERFCOUNTER_INC_MODE__SHIFT                                            0xc
#define DC_PERFMON13_PERFCOUNTER_CNTL__PERFCOUNTER_HW_CNTL_SEL__SHIFT                                         0xf
#define DC_PERFMON13_PERFCOUNTER_CNTL__PERFCOUNTER_RUNEN_MODE__SHIFT                                          0x10
#define DC_PERFMON13_PERFCOUNTER_CNTL__PERFCOUNTER_CNTOFF_SEL__SHIFT                                          0x11
#define DC_PERFMON13_PERFCOUNTER_CNTL__PERFCOUNTER_CNTOFF_START_DIS__SHIFT                                    0x16
#define DC_PERFMON13_PERFCOUNTER_CNTL__PERFCOUNTER_RESTART_EN__SHIFT                                          0x17
#define DC_PERFMON13_PERFCOUNTER_CNTL__PERFCOUNTER_INT_EN__SHIFT                                              0x18
#define DC_PERFMON13_PERFCOUNTER_CNTL__PERFCOUNTER_OFF_MASK__SHIFT                                            0x19
#define DC_PERFMON13_PERFCOUNTER_CNTL__PERFCOUNTER_ACTIVE__SHIFT                                              0x1a
#define DC_PERFMON13_PERFCOUNTER_CNTL__PERFCOUNTER_INT_TYPE__SHIFT                                            0x1b
#define DC_PERFMON13_PERFCOUNTER_CNTL__PERFCOUNTER_CNTL_SEL__SHIFT                                            0x1d
#define DC_PERFMON13_PERFCOUNTER_CNTL__PERFCOUNTER_EVENT_SEL_MASK                                             0x000001FFL
#define DC_PERFMON13_PERFCOUNTER_CNTL__PERFCOUNTER_CVALUE_SEL_MASK                                            0x00000E00L
#define DC_PERFMON13_PERFCOUNTER_CNTL__PERFCOUNTER_INC_MODE_MASK                                              0x00007000L
#define DC_PERFMON13_PERFCOUNTER_CNTL__PERFCOUNTER_HW_CNTL_SEL_MASK                                           0x00008000L
#define DC_PERFMON13_PERFCOUNTER_CNTL__PERFCOUNTER_RUNEN_MODE_MASK                                            0x00010000L
#define DC_PERFMON13_PERFCOUNTER_CNTL__PERFCOUNTER_CNTOFF_SEL_MASK                                            0x003E0000L
#define DC_PERFMON13_PERFCOUNTER_CNTL__PERFCOUNTER_CNTOFF_START_DIS_MASK                                      0x00400000L
#define DC_PERFMON13_PERFCOUNTER_CNTL__PERFCOUNTER_RESTART_EN_MASK                                            0x00800000L
#define DC_PERFMON13_PERFCOUNTER_CNTL__PERFCOUNTER_INT_EN_MASK                                                0x01000000L
#define DC_PERFMON13_PERFCOUNTER_CNTL__PERFCOUNTER_OFF_MASK_MASK                                              0x02000000L
#define DC_PERFMON13_PERFCOUNTER_CNTL__PERFCOUNTER_ACTIVE_MASK                                                0x04000000L
#define DC_PERFMON13_PERFCOUNTER_CNTL__PERFCOUNTER_INT_TYPE_MASK                                              0x08000000L
#define DC_PERFMON13_PERFCOUNTER_CNTL__PERFCOUNTER_CNTL_SEL_MASK                                              0xE0000000L
//DC_PERFMON13_PERFCOUNTER_CNTL2
#define DC_PERFMON13_PERFCOUNTER_CNTL2__PERFCOUNTER_COUNTED_VALUE_TYPE__SHIFT                                 0x0
#define DC_PERFMON13_PERFCOUNTER_CNTL2__PERFCOUNTER_HW_STOP1_SEL__SHIFT                                       0x2
#define DC_PERFMON13_PERFCOUNTER_CNTL2__PERFCOUNTER_HW_STOP2_SEL__SHIFT                                       0x3
#define DC_PERFMON13_PERFCOUNTER_CNTL2__PERFCOUNTER_CNTL2_SEL__SHIFT                                          0x1d
#define DC_PERFMON13_PERFCOUNTER_CNTL2__PERFCOUNTER_COUNTED_VALUE_TYPE_MASK                                   0x00000003L
#define DC_PERFMON13_PERFCOUNTER_CNTL2__PERFCOUNTER_HW_STOP1_SEL_MASK                                         0x00000004L
#define DC_PERFMON13_PERFCOUNTER_CNTL2__PERFCOUNTER_HW_STOP2_SEL_MASK                                         0x00000008L
#define DC_PERFMON13_PERFCOUNTER_CNTL2__PERFCOUNTER_CNTL2_SEL_MASK                                            0xE0000000L
//DC_PERFMON13_PERFCOUNTER_STATE
#define DC_PERFMON13_PERFCOUNTER_STATE__PERFCOUNTER_CNT0_STATE__SHIFT                                         0x0
#define DC_PERFMON13_PERFCOUNTER_STATE__PERFCOUNTER_STATE_SEL0__SHIFT                                         0x2
#define DC_PERFMON13_PERFCOUNTER_STATE__PERFCOUNTER_CNT1_STATE__SHIFT                                         0x4
#define DC_PERFMON13_PERFCOUNTER_STATE__PERFCOUNTER_STATE_SEL1__SHIFT                                         0x6
#define DC_PERFMON13_PERFCOUNTER_STATE__PERFCOUNTER_CNT2_STATE__SHIFT                                         0x8
#define DC_PERFMON13_PERFCOUNTER_STATE__PERFCOUNTER_STATE_SEL2__SHIFT                                         0xa
#define DC_PERFMON13_PERFCOUNTER_STATE__PERFCOUNTER_CNT3_STATE__SHIFT                                         0xc
#define DC_PERFMON13_PERFCOUNTER_STATE__PERFCOUNTER_STATE_SEL3__SHIFT                                         0xe
#define DC_PERFMON13_PERFCOUNTER_STATE__PERFCOUNTER_CNT4_STATE__SHIFT                                         0x10
#define DC_PERFMON13_PERFCOUNTER_STATE__PERFCOUNTER_STATE_SEL4__SHIFT                                         0x12
#define DC_PERFMON13_PERFCOUNTER_STATE__PERFCOUNTER_CNT5_STATE__SHIFT                                         0x14
#define DC_PERFMON13_PERFCOUNTER_STATE__PERFCOUNTER_STATE_SEL5__SHIFT                                         0x16
#define DC_PERFMON13_PERFCOUNTER_STATE__PERFCOUNTER_CNT6_STATE__SHIFT                                         0x18
#define DC_PERFMON13_PERFCOUNTER_STATE__PERFCOUNTER_STATE_SEL6__SHIFT                                         0x1a
#define DC_PERFMON13_PERFCOUNTER_STATE__PERFCOUNTER_CNT7_STATE__SHIFT                                         0x1c
#define DC_PERFMON13_PERFCOUNTER_STATE__PERFCOUNTER_STATE_SEL7__SHIFT                                         0x1e
#define DC_PERFMON13_PERFCOUNTER_STATE__PERFCOUNTER_CNT0_STATE_MASK                                           0x00000003L
#define DC_PERFMON13_PERFCOUNTER_STATE__PERFCOUNTER_STATE_SEL0_MASK                                           0x00000004L
#define DC_PERFMON13_PERFCOUNTER_STATE__PERFCOUNTER_CNT1_STATE_MASK                                           0x00000030L
#define DC_PERFMON13_PERFCOUNTER_STATE__PERFCOUNTER_STATE_SEL1_MASK                                           0x00000040L
#define DC_PERFMON13_PERFCOUNTER_STATE__PERFCOUNTER_CNT2_STATE_MASK                                           0x00000300L
#define DC_PERFMON13_PERFCOUNTER_STATE__PERFCOUNTER_STATE_SEL2_MASK                                           0x00000400L
#define DC_PERFMON13_PERFCOUNTER_STATE__PERFCOUNTER_CNT3_STATE_MASK                                           0x00003000L
#define DC_PERFMON13_PERFCOUNTER_STATE__PERFCOUNTER_STATE_SEL3_MASK                                           0x00004000L
#define DC_PERFMON13_PERFCOUNTER_STATE__PERFCOUNTER_CNT4_STATE_MASK                                           0x00030000L
#define DC_PERFMON13_PERFCOUNTER_STATE__PERFCOUNTER_STATE_SEL4_MASK                                           0x00040000L
#define DC_PERFMON13_PERFCOUNTER_STATE__PERFCOUNTER_CNT5_STATE_MASK                                           0x00300000L
#define DC_PERFMON13_PERFCOUNTER_STATE__PERFCOUNTER_STATE_SEL5_MASK                                           0x00400000L
#define DC_PERFMON13_PERFCOUNTER_STATE__PERFCOUNTER_CNT6_STATE_MASK                                           0x03000000L
#define DC_PERFMON13_PERFCOUNTER_STATE__PERFCOUNTER_STATE_SEL6_MASK                                           0x04000000L
#define DC_PERFMON13_PERFCOUNTER_STATE__PERFCOUNTER_CNT7_STATE_MASK                                           0x30000000L
#define DC_PERFMON13_PERFCOUNTER_STATE__PERFCOUNTER_STATE_SEL7_MASK                                           0x40000000L
//DC_PERFMON13_PERFMON_CNTL
#define DC_PERFMON13_PERFMON_CNTL__PERFMON_STATE__SHIFT                                                       0x0
#define DC_PERFMON13_PERFMON_CNTL__PERFMON_RPT_COUNT__SHIFT                                                   0x8
#define DC_PERFMON13_PERFMON_CNTL__PERFMON_CNTOFF_AND_OR__SHIFT                                               0x1c
#define DC_PERFMON13_PERFMON_CNTL__PERFMON_CNTOFF_INT_EN__SHIFT                                               0x1d
#define DC_PERFMON13_PERFMON_CNTL__PERFMON_CNTOFF_INT_STATUS__SHIFT                                           0x1e
#define DC_PERFMON13_PERFMON_CNTL__PERFMON_CNTOFF_INT_ACK__SHIFT                                              0x1f
#define DC_PERFMON13_PERFMON_CNTL__PERFMON_STATE_MASK                                                         0x00000003L
#define DC_PERFMON13_PERFMON_CNTL__PERFMON_RPT_COUNT_MASK                                                     0x0FFFFF00L
#define DC_PERFMON13_PERFMON_CNTL__PERFMON_CNTOFF_AND_OR_MASK                                                 0x10000000L
#define DC_PERFMON13_PERFMON_CNTL__PERFMON_CNTOFF_INT_EN_MASK                                                 0x20000000L
#define DC_PERFMON13_PERFMON_CNTL__PERFMON_CNTOFF_INT_STATUS_MASK                                             0x40000000L
#define DC_PERFMON13_PERFMON_CNTL__PERFMON_CNTOFF_INT_ACK_MASK                                                0x80000000L
//DC_PERFMON13_PERFMON_CNTL2
#define DC_PERFMON13_PERFMON_CNTL2__PERFMON_CNTOFF_INT_TYPE__SHIFT                                            0x0
#define DC_PERFMON13_PERFMON_CNTL2__PERFMON_CLK_ENABLE__SHIFT                                                 0x1
#define DC_PERFMON13_PERFMON_CNTL2__PERFMON_RUN_ENABLE_START_SEL__SHIFT                                       0x2
#define DC_PERFMON13_PERFMON_CNTL2__PERFMON_RUN_ENABLE_STOP_SEL__SHIFT                                        0xa
#define DC_PERFMON13_PERFMON_CNTL2__PERFMON_CNTOFF_INT_TYPE_MASK                                              0x00000001L
#define DC_PERFMON13_PERFMON_CNTL2__PERFMON_CLK_ENABLE_MASK                                                   0x00000002L
#define DC_PERFMON13_PERFMON_CNTL2__PERFMON_RUN_ENABLE_START_SEL_MASK                                         0x000003FCL
#define DC_PERFMON13_PERFMON_CNTL2__PERFMON_RUN_ENABLE_STOP_SEL_MASK                                          0x0003FC00L
//DC_PERFMON13_PERFMON_CVALUE_INT_MISC
#define DC_PERFMON13_PERFMON_CVALUE_INT_MISC__PERFCOUNTER_INT0_STATUS__SHIFT                                  0x0
#define DC_PERFMON13_PERFMON_CVALUE_INT_MISC__PERFCOUNTER_INT1_STATUS__SHIFT                                  0x1
#define DC_PERFMON13_PERFMON_CVALUE_INT_MISC__PERFCOUNTER_INT2_STATUS__SHIFT                                  0x2
#define DC_PERFMON13_PERFMON_CVALUE_INT_MISC__PERFCOUNTER_INT3_STATUS__SHIFT                                  0x3
#define DC_PERFMON13_PERFMON_CVALUE_INT_MISC__PERFCOUNTER_INT4_STATUS__SHIFT                                  0x4
#define DC_PERFMON13_PERFMON_CVALUE_INT_MISC__PERFCOUNTER_INT5_STATUS__SHIFT                                  0x5
#define DC_PERFMON13_PERFMON_CVALUE_INT_MISC__PERFCOUNTER_INT6_STATUS__SHIFT                                  0x6
#define DC_PERFMON13_PERFMON_CVALUE_INT_MISC__PERFCOUNTER_INT7_STATUS__SHIFT                                  0x7
#define DC_PERFMON13_PERFMON_CVALUE_INT_MISC__PERFCOUNTER_INT0_ACK__SHIFT                                     0x8
#define DC_PERFMON13_PERFMON_CVALUE_INT_MISC__PERFCOUNTER_INT1_ACK__SHIFT                                     0x9
#define DC_PERFMON13_PERFMON_CVALUE_INT_MISC__PERFCOUNTER_INT2_ACK__SHIFT                                     0xa
#define DC_PERFMON13_PERFMON_CVALUE_INT_MISC__PERFCOUNTER_INT3_ACK__SHIFT                                     0xb
#define DC_PERFMON13_PERFMON_CVALUE_INT_MISC__PERFCOUNTER_INT4_ACK__SHIFT                                     0xc
#define DC_PERFMON13_PERFMON_CVALUE_INT_MISC__PERFCOUNTER_INT5_ACK__SHIFT                                     0xd
#define DC_PERFMON13_PERFMON_CVALUE_INT_MISC__PERFCOUNTER_INT6_ACK__SHIFT                                     0xe
#define DC_PERFMON13_PERFMON_CVALUE_INT_MISC__PERFCOUNTER_INT7_ACK__SHIFT                                     0xf
#define DC_PERFMON13_PERFMON_CVALUE_INT_MISC__PERFMON_CVALUE_HI__SHIFT                                        0x10
#define DC_PERFMON13_PERFMON_CVALUE_INT_MISC__PERFCOUNTER_INT0_STATUS_MASK                                    0x00000001L
#define DC_PERFMON13_PERFMON_CVALUE_INT_MISC__PERFCOUNTER_INT1_STATUS_MASK                                    0x00000002L
#define DC_PERFMON13_PERFMON_CVALUE_INT_MISC__PERFCOUNTER_INT2_STATUS_MASK                                    0x00000004L
#define DC_PERFMON13_PERFMON_CVALUE_INT_MISC__PERFCOUNTER_INT3_STATUS_MASK                                    0x00000008L
#define DC_PERFMON13_PERFMON_CVALUE_INT_MISC__PERFCOUNTER_INT4_STATUS_MASK                                    0x00000010L
#define DC_PERFMON13_PERFMON_CVALUE_INT_MISC__PERFCOUNTER_INT5_STATUS_MASK                                    0x00000020L
#define DC_PERFMON13_PERFMON_CVALUE_INT_MISC__PERFCOUNTER_INT6_STATUS_MASK                                    0x00000040L
#define DC_PERFMON13_PERFMON_CVALUE_INT_MISC__PERFCOUNTER_INT7_STATUS_MASK                                    0x00000080L
#define DC_PERFMON13_PERFMON_CVALUE_INT_MISC__PERFCOUNTER_INT0_ACK_MASK                                       0x00000100L
#define DC_PERFMON13_PERFMON_CVALUE_INT_MISC__PERFCOUNTER_INT1_ACK_MASK                                       0x00000200L
#define DC_PERFMON13_PERFMON_CVALUE_INT_MISC__PERFCOUNTER_INT2_ACK_MASK                                       0x00000400L
#define DC_PERFMON13_PERFMON_CVALUE_INT_MISC__PERFCOUNTER_INT3_ACK_MASK                                       0x00000800L
#define DC_PERFMON13_PERFMON_CVALUE_INT_MISC__PERFCOUNTER_INT4_ACK_MASK                                       0x00001000L
#define DC_PERFMON13_PERFMON_CVALUE_INT_MISC__PERFCOUNTER_INT5_ACK_MASK                                       0x00002000L
#define DC_PERFMON13_PERFMON_CVALUE_INT_MISC__PERFCOUNTER_INT6_ACK_MASK                                       0x00004000L
#define DC_PERFMON13_PERFMON_CVALUE_INT_MISC__PERFCOUNTER_INT7_ACK_MASK                                       0x00008000L
#define DC_PERFMON13_PERFMON_CVALUE_INT_MISC__PERFMON_CVALUE_HI_MASK                                          0xFFFF0000L
//DC_PERFMON13_PERFMON_CVALUE_LOW
#define DC_PERFMON13_PERFMON_CVALUE_LOW__PERFMON_CVALUE_LOW__SHIFT                                            0x0
#define DC_PERFMON13_PERFMON_CVALUE_LOW__PERFMON_CVALUE_LOW_MASK                                              0xFFFFFFFFL
//DC_PERFMON13_PERFMON_HI
#define DC_PERFMON13_PERFMON_HI__PERFMON_HI__SHIFT                                                            0x0
#define DC_PERFMON13_PERFMON_HI__PERFMON_READ_SEL__SHIFT                                                      0x1d
#define DC_PERFMON13_PERFMON_HI__PERFMON_HI_MASK                                                              0x0000FFFFL
#define DC_PERFMON13_PERFMON_HI__PERFMON_READ_SEL_MASK                                                        0xE0000000L
//DC_PERFMON13_PERFMON_LOW
#define DC_PERFMON13_PERFMON_LOW__PERFMON_LOW__SHIFT                                                          0x0
#define DC_PERFMON13_PERFMON_LOW__PERFMON_LOW_MASK                                                            0xFFFFFFFFL


// addressBlock: dce_dc_dc_displaypllregs_dispdec
//PPLL_VREG_CFG
#define PPLL_VREG_CFG__pw_pc_bleeder_ac__SHIFT                                                                0x0
#define PPLL_VREG_CFG__pw_pc_bleeder_en__SHIFT                                                                0x1
#define PPLL_VREG_CFG__pw_pc_is_1p2__SHIFT                                                                    0x2
#define PPLL_VREG_CFG__pw_pc_reg_obs_sel__SHIFT                                                               0x3
#define PPLL_VREG_CFG__pw_pc_reg_on_mode__SHIFT                                                               0x5
#define PPLL_VREG_CFG__pw_pc_rlad_tap_sel__SHIFT                                                              0x7
#define PPLL_VREG_CFG__pw_pc_reg_off_hi__SHIFT                                                                0xb
#define PPLL_VREG_CFG__pw_pc_reg_off_lo__SHIFT                                                                0xc
#define PPLL_VREG_CFG__pw_pc_scale_driver__SHIFT                                                              0xd
#define PPLL_VREG_CFG__pw_pc_sel_bump__SHIFT                                                                  0xf
#define PPLL_VREG_CFG__pw_pc_sel_rladder_x__SHIFT                                                             0x10
#define PPLL_VREG_CFG__pw_pc_short_rc_filt_x__SHIFT                                                           0x11
#define PPLL_VREG_CFG__pw_pc_vref_pwr_on__SHIFT                                                               0x12
#define PPLL_VREG_CFG__pw_pc_dpll_cfg_2__SHIFT                                                                0x14
#define PPLL_VREG_CFG__pw_pc_bleeder_ac_MASK                                                                  0x00000001L
#define PPLL_VREG_CFG__pw_pc_bleeder_en_MASK                                                                  0x00000002L
#define PPLL_VREG_CFG__pw_pc_is_1p2_MASK                                                                      0x00000004L
#define PPLL_VREG_CFG__pw_pc_reg_obs_sel_MASK                                                                 0x00000018L
#define PPLL_VREG_CFG__pw_pc_reg_on_mode_MASK                                                                 0x00000060L
#define PPLL_VREG_CFG__pw_pc_rlad_tap_sel_MASK                                                                0x00000780L
#define PPLL_VREG_CFG__pw_pc_reg_off_hi_MASK                                                                  0x00000800L
#define PPLL_VREG_CFG__pw_pc_reg_off_lo_MASK                                                                  0x00001000L
#define PPLL_VREG_CFG__pw_pc_scale_driver_MASK                                                                0x00006000L
#define PPLL_VREG_CFG__pw_pc_sel_bump_MASK                                                                    0x00008000L
#define PPLL_VREG_CFG__pw_pc_sel_rladder_x_MASK                                                               0x00010000L
#define PPLL_VREG_CFG__pw_pc_short_rc_filt_x_MASK                                                             0x00020000L
#define PPLL_VREG_CFG__pw_pc_vref_pwr_on_MASK                                                                 0x00040000L
#define PPLL_VREG_CFG__pw_pc_dpll_cfg_2_MASK                                                                  0x0FF00000L
//PPLL_MODE_CNTL
#define PPLL_MODE_CNTL__pw_pc_refclk_gate_dis__SHIFT                                                          0x0
#define PPLL_MODE_CNTL__pw_pc_multi_phase_en__SHIFT                                                           0x8
#define PPLL_MODE_CNTL__reg_tmg_pwr_state__SHIFT                                                              0x10
#define PPLL_MODE_CNTL__pw_pc_refclk_gate_dis_MASK                                                            0x00000001L
#define PPLL_MODE_CNTL__pw_pc_multi_phase_en_MASK                                                             0x00000F00L
#define PPLL_MODE_CNTL__reg_tmg_pwr_state_MASK                                                                0x00030000L
//PPLL_FREQ_CTRL0
#define PPLL_FREQ_CTRL0__reg_tmg_fcw0_frac__SHIFT                                                             0x0
#define PPLL_FREQ_CTRL0__reg_tmg_fcw0_int__SHIFT                                                              0x10
#define PPLL_FREQ_CTRL0__reg_tmg_fcw0_frac_MASK                                                               0x0000FFFFL
#define PPLL_FREQ_CTRL0__reg_tmg_fcw0_int_MASK                                                                0x01FF0000L
//PPLL_FREQ_CTRL1
#define PPLL_FREQ_CTRL1__reg_tmg_fcw1_frac__SHIFT                                                             0x0
#define PPLL_FREQ_CTRL1__reg_tmg_fcw1_int__SHIFT                                                              0x10
#define PPLL_FREQ_CTRL1__reg_tmg_fcw1_frac_MASK                                                               0x0000FFFFL
#define PPLL_FREQ_CTRL1__reg_tmg_fcw1_int_MASK                                                                0x01FF0000L
//PPLL_FREQ_CTRL2
#define PPLL_FREQ_CTRL2__reg_tmg_fcw_denom__SHIFT                                                             0x0
#define PPLL_FREQ_CTRL2__reg_tmg_fcw_slew_frac__SHIFT                                                         0x10
#define PPLL_FREQ_CTRL2__reg_tmg_fcw_denom_MASK                                                               0x0000FFFFL
#define PPLL_FREQ_CTRL2__reg_tmg_fcw_slew_frac_MASK                                                           0xFFFF0000L
//PPLL_FREQ_CTRL3
#define PPLL_FREQ_CTRL3__reg_tmg_refclk_div__SHIFT                                                            0x0
#define PPLL_FREQ_CTRL3__reg_tmg_vco_pre_div__SHIFT                                                           0x3
#define PPLL_FREQ_CTRL3__reg_tmg_fracn_en__SHIFT                                                              0x6
#define PPLL_FREQ_CTRL3__reg_tmg_ssc_en__SHIFT                                                                0x8
#define PPLL_FREQ_CTRL3__reg_tmg_fcw_sel__SHIFT                                                               0xa
#define PPLL_FREQ_CTRL3__reg_tmg_freq_jump_en__SHIFT                                                          0xc
#define PPLL_FREQ_CTRL3__reg_tmg_tdc_resol__SHIFT                                                             0x10
#define PPLL_FREQ_CTRL3__pw_pc_dpll_cfg_1__SHIFT                                                              0x18
#define PPLL_FREQ_CTRL3__reg_tmg_refclk_div_MASK                                                              0x00000003L
#define PPLL_FREQ_CTRL3__reg_tmg_vco_pre_div_MASK                                                             0x00000018L
#define PPLL_FREQ_CTRL3__reg_tmg_fracn_en_MASK                                                                0x00000040L
#define PPLL_FREQ_CTRL3__reg_tmg_ssc_en_MASK                                                                  0x00000100L
#define PPLL_FREQ_CTRL3__reg_tmg_fcw_sel_MASK                                                                 0x00000400L
#define PPLL_FREQ_CTRL3__reg_tmg_freq_jump_en_MASK                                                            0x00001000L
#define PPLL_FREQ_CTRL3__reg_tmg_tdc_resol_MASK                                                               0x00FF0000L
#define PPLL_FREQ_CTRL3__pw_pc_dpll_cfg_1_MASK                                                                0xFF000000L
//PPLL_BW_CTRL_COARSE
#define PPLL_BW_CTRL_COARSE__reg_tmg_gi_crse_mant__SHIFT                                                      0x0
#define PPLL_BW_CTRL_COARSE__reg_tmg_gi_crse_exp__SHIFT                                                       0x2
#define PPLL_BW_CTRL_COARSE__reg_tmg_gp_crse_mant__SHIFT                                                      0x7
#define PPLL_BW_CTRL_COARSE__reg_tmg_gp_crse_exp__SHIFT                                                       0xc
#define PPLL_BW_CTRL_COARSE__reg_tmg_nctl_crse_res__SHIFT                                                     0x11
#define PPLL_BW_CTRL_COARSE__reg_tmg_nctl_crse_frac_res__SHIFT                                                0x18
#define PPLL_BW_CTRL_COARSE__reg_tmg_gi_crse_mant_MASK                                                        0x00000003L
#define PPLL_BW_CTRL_COARSE__reg_tmg_gi_crse_exp_MASK                                                         0x0000003CL
#define PPLL_BW_CTRL_COARSE__reg_tmg_gp_crse_mant_MASK                                                        0x00000780L
#define PPLL_BW_CTRL_COARSE__reg_tmg_gp_crse_exp_MASK                                                         0x0000F000L
#define PPLL_BW_CTRL_COARSE__reg_tmg_nctl_crse_res_MASK                                                       0x007E0000L
#define PPLL_BW_CTRL_COARSE__reg_tmg_nctl_crse_frac_res_MASK                                                  0x03000000L
//PPLL_BW_CTRL_FINE
#define PPLL_BW_CTRL_FINE__pw_pc_dpll_cfg_3__SHIFT                                                            0x0
#define PPLL_BW_CTRL_FINE__pw_pc_dpll_cfg_3_MASK                                                              0x000003FFL
//PPLL_CAL_CTRL
#define PPLL_CAL_CTRL__pw_pc_bypass_freq_lock__SHIFT                                                          0x0
#define PPLL_CAL_CTRL__pw_pc_tdc_cal_en__SHIFT                                                                0x1
#define PPLL_CAL_CTRL__pw_pc_tdc_cal_ctrl__SHIFT                                                              0x3
#define PPLL_CAL_CTRL__pw_pc_meas_win_sel__SHIFT                                                              0x9
#define PPLL_CAL_CTRL__pw_pc_kdco_cal_dis__SHIFT                                                              0xb
#define PPLL_CAL_CTRL__pw_pc_kdco_ratio__SHIFT                                                                0xd
#define PPLL_CAL_CTRL__pw_pc_kdco_incr_cal_dis__SHIFT                                                         0x16
#define PPLL_CAL_CTRL__pw_pc_nctl_adj_dis__SHIFT                                                              0x17
#define PPLL_CAL_CTRL__pw_pc_refclk_rate__SHIFT                                                               0x18
#define PPLL_CAL_CTRL__pw_pc_bypass_freq_lock_MASK                                                            0x00000001L
#define PPLL_CAL_CTRL__pw_pc_tdc_cal_en_MASK                                                                  0x00000002L
#define PPLL_CAL_CTRL__pw_pc_tdc_cal_ctrl_MASK                                                                0x000001F8L
#define PPLL_CAL_CTRL__pw_pc_meas_win_sel_MASK                                                                0x00000600L
#define PPLL_CAL_CTRL__pw_pc_kdco_cal_dis_MASK                                                                0x00000800L
#define PPLL_CAL_CTRL__pw_pc_kdco_ratio_MASK                                                                  0x001FE000L
#define PPLL_CAL_CTRL__pw_pc_kdco_incr_cal_dis_MASK                                                           0x00400000L
#define PPLL_CAL_CTRL__pw_pc_nctl_adj_dis_MASK                                                                0x00800000L
#define PPLL_CAL_CTRL__pw_pc_refclk_rate_MASK                                                                 0xFF000000L
//PPLL_LOOP_CTRL
#define PPLL_LOOP_CTRL__pw_pc_fbdiv_mask_en__SHIFT                                                            0x0
#define PPLL_LOOP_CTRL__pw_pc_fb_slip_dis__SHIFT                                                              0x2
#define PPLL_LOOP_CTRL__pw_pc_clk_tdc_sel__SHIFT                                                              0x4
#define PPLL_LOOP_CTRL__pw_pc_clk_nctl_sel__SHIFT                                                             0x7
#define PPLL_LOOP_CTRL__pw_pc_sig_del_patt_sel__SHIFT                                                         0xa
#define PPLL_LOOP_CTRL__pw_pc_nctl_sig_del_dis__SHIFT                                                         0xc
#define PPLL_LOOP_CTRL__pw_pc_fbclk_track_refclk__SHIFT                                                       0xe
#define PPLL_LOOP_CTRL__pw_pc_prbs_en__SHIFT                                                                  0x10
#define PPLL_LOOP_CTRL__pw_pc_tdc_clk_gate_en__SHIFT                                                          0x12
#define PPLL_LOOP_CTRL__pw_pc_phase_offset__SHIFT                                                             0x14
#define PPLL_LOOP_CTRL__pw_pc_fbdiv_mask_en_MASK                                                              0x00000001L
#define PPLL_LOOP_CTRL__pw_pc_fb_slip_dis_MASK                                                                0x00000004L
#define PPLL_LOOP_CTRL__pw_pc_clk_tdc_sel_MASK                                                                0x00000030L
#define PPLL_LOOP_CTRL__pw_pc_clk_nctl_sel_MASK                                                               0x00000180L
#define PPLL_LOOP_CTRL__pw_pc_sig_del_patt_sel_MASK                                                           0x00000400L
#define PPLL_LOOP_CTRL__pw_pc_nctl_sig_del_dis_MASK                                                           0x00001000L
#define PPLL_LOOP_CTRL__pw_pc_fbclk_track_refclk_MASK                                                         0x00004000L
#define PPLL_LOOP_CTRL__pw_pc_prbs_en_MASK                                                                    0x00010000L
#define PPLL_LOOP_CTRL__pw_pc_tdc_clk_gate_en_MASK                                                            0x00040000L
#define PPLL_LOOP_CTRL__pw_pc_phase_offset_MASK                                                               0x07F00000L
//PPLL_REFCLK_CNTL
#define PPLL_REFCLK_CNTL__regs_pw_refclk0_recv_en__SHIFT                                                      0x0
#define PPLL_REFCLK_CNTL__regs_pw_refclk1_recv_en__SHIFT                                                      0x1
#define PPLL_REFCLK_CNTL__regs_pw_refclk2_recv_en__SHIFT                                                      0x2
#define PPLL_REFCLK_CNTL__regs_pw_refclk3_recv_en__SHIFT                                                      0x3
#define PPLL_REFCLK_CNTL__regs_pw_refclk0_recv_sel__SHIFT                                                     0x8
#define PPLL_REFCLK_CNTL__regs_pw_refclk1_recv_sel__SHIFT                                                     0x9
#define PPLL_REFCLK_CNTL__regs_pw_refclk2_recv_sel__SHIFT                                                     0xa
#define PPLL_REFCLK_CNTL__regs_pw_refclk3_recv_sel__SHIFT                                                     0xb
#define PPLL_REFCLK_CNTL__regs_pw_refdivsrc__SHIFT                                                            0xe
#define PPLL_REFCLK_CNTL__regs_pw_ref2core_sel__SHIFT                                                         0x10
#define PPLL_REFCLK_CNTL__regs_pw_refclk0_recv_en_MASK                                                        0x00000001L
#define PPLL_REFCLK_CNTL__regs_pw_refclk1_recv_en_MASK                                                        0x00000002L
#define PPLL_REFCLK_CNTL__regs_pw_refclk2_recv_en_MASK                                                        0x00000004L
#define PPLL_REFCLK_CNTL__regs_pw_refclk3_recv_en_MASK                                                        0x00000008L
#define PPLL_REFCLK_CNTL__regs_pw_refclk0_recv_sel_MASK                                                       0x00000100L
#define PPLL_REFCLK_CNTL__regs_pw_refclk1_recv_sel_MASK                                                       0x00000200L
#define PPLL_REFCLK_CNTL__regs_pw_refclk2_recv_sel_MASK                                                       0x00000400L
#define PPLL_REFCLK_CNTL__regs_pw_refclk3_recv_sel_MASK                                                       0x00000800L
#define PPLL_REFCLK_CNTL__regs_pw_refdivsrc_MASK                                                              0x0000C000L
#define PPLL_REFCLK_CNTL__regs_pw_ref2core_sel_MASK                                                           0x00010000L
//PPLL_CLKOUT_CNTL
#define PPLL_CLKOUT_CNTL__regs_pw_pixclk_pre_pdivsel__SHIFT                                                   0x8
#define PPLL_CLKOUT_CNTL__regs_pw_pixclk_pdivsel__SHIFT                                                       0x9
#define PPLL_CLKOUT_CNTL__regs_pw_dvoclk_pre_pdivsel__SHIFT                                                   0xa
#define PPLL_CLKOUT_CNTL__regs_pw_dvoclk_pdivsel__SHIFT                                                       0xb
#define PPLL_CLKOUT_CNTL__regs_pw_idclk_en__SHIFT                                                             0xc
#define PPLL_CLKOUT_CNTL__regs_pw_idclk_pre_pdivsel__SHIFT                                                    0xd
#define PPLL_CLKOUT_CNTL__regs_pw_idclk_pdivsel__SHIFT                                                        0xe
#define PPLL_CLKOUT_CNTL__regs_pw_idclk_obs_sel__SHIFT                                                        0xf
#define PPLL_CLKOUT_CNTL__regs_pw_refclk_sel__SHIFT                                                           0x10
#define PPLL_CLKOUT_CNTL__regs_cc_resetb__SHIFT                                                               0x14
#define PPLL_CLKOUT_CNTL__regs_pw_pixclk_pre_pdivsel_MASK                                                     0x00000100L
#define PPLL_CLKOUT_CNTL__regs_pw_pixclk_pdivsel_MASK                                                         0x00000200L
#define PPLL_CLKOUT_CNTL__regs_pw_dvoclk_pre_pdivsel_MASK                                                     0x00000400L
#define PPLL_CLKOUT_CNTL__regs_pw_dvoclk_pdivsel_MASK                                                         0x00000800L
#define PPLL_CLKOUT_CNTL__regs_pw_idclk_en_MASK                                                               0x00001000L
#define PPLL_CLKOUT_CNTL__regs_pw_idclk_pre_pdivsel_MASK                                                      0x00002000L
#define PPLL_CLKOUT_CNTL__regs_pw_idclk_pdivsel_MASK                                                          0x00004000L
#define PPLL_CLKOUT_CNTL__regs_pw_idclk_obs_sel_MASK                                                          0x00008000L
#define PPLL_CLKOUT_CNTL__regs_pw_refclk_sel_MASK                                                             0x00030000L
#define PPLL_CLKOUT_CNTL__regs_cc_resetb_MASK                                                                 0x00100000L
//PPLL_DFT_CNTL
#define PPLL_DFT_CNTL__regs_pw_obs_en__SHIFT                                                                  0x0
#define PPLL_DFT_CNTL__regs_pw_obs_div_sel_1__SHIFT                                                           0x1
#define PPLL_DFT_CNTL__regs_pw_obs_clk_sel_1__SHIFT                                                           0x4
#define PPLL_DFT_CNTL__regs_pw_obs_clk_sel_2__SHIFT                                                           0x8
#define PPLL_DFT_CNTL__regs_pw_obs_sel__SHIFT                                                                 0xc
#define PPLL_DFT_CNTL__regs_pw_obs_en_MASK                                                                    0x00000001L
#define PPLL_DFT_CNTL__regs_pw_obs_div_sel_1_MASK                                                             0x00000006L
#define PPLL_DFT_CNTL__regs_pw_obs_clk_sel_1_MASK                                                             0x000000F0L
#define PPLL_DFT_CNTL__regs_pw_obs_clk_sel_2_MASK                                                             0x00000F00L
#define PPLL_DFT_CNTL__regs_pw_obs_sel_MASK                                                                   0x00003000L
//PPLL_ANALOG_CNTL
#define PPLL_ANALOG_CNTL__regs_pw_spare__SHIFT                                                                0x0
#define PPLL_ANALOG_CNTL__regs_pw_spare_MASK                                                                  0x000000FFL
//PPLL_POSTDIV
#define PPLL_POSTDIV__reg_tmg_postdiv__SHIFT                                                                  0x8
#define PPLL_POSTDIV__reg_tmg_pixclk_pdiv2__SHIFT                                                             0xc
#define PPLL_POSTDIV__reg_tmg_postdiv_MASK                                                                    0x00000F00L
#define PPLL_POSTDIV__reg_tmg_pixclk_pdiv2_MASK                                                               0x00001000L
//PPLL_OBSERVE0
#define PPLL_OBSERVE0__pw_pc_lock_det_tdc_steps__SHIFT                                                        0x0
#define PPLL_OBSERVE0__pw_pc_clear_sticky_lock__SHIFT                                                         0x6
#define PPLL_OBSERVE0__pw_pc_lock_det_dis__SHIFT                                                              0x8
#define PPLL_OBSERVE0__pw_pc_dco_cfg__SHIFT                                                                   0xa
#define PPLL_OBSERVE0__pw_pc_anaobs_sel__SHIFT                                                                0x15
#define PPLL_OBSERVE0__pw_pc_lock_det_tdc_steps_MASK                                                          0x0000001FL
#define PPLL_OBSERVE0__pw_pc_clear_sticky_lock_MASK                                                           0x00000040L
#define PPLL_OBSERVE0__pw_pc_lock_det_dis_MASK                                                                0x00000100L
#define PPLL_OBSERVE0__pw_pc_dco_cfg_MASK                                                                     0x0003FC00L
#define PPLL_OBSERVE0__pw_pc_anaobs_sel_MASK                                                                  0x00E00000L
//PPLL_OBSERVE1
#define PPLL_OBSERVE1__pw_pc_digobs_sel__SHIFT                                                                0x0
#define PPLL_OBSERVE1__pw_pc_digobs_trig_sel__SHIFT                                                           0x5
#define PPLL_OBSERVE1__pw_pc_digobs_div__SHIFT                                                                0xa
#define PPLL_OBSERVE1__pw_pc_digobs_trig_div__SHIFT                                                           0xc
#define PPLL_OBSERVE1__reg_tmg_lock_timer__SHIFT                                                              0x10
#define PPLL_OBSERVE1__pw_pc_digobs_sel_MASK                                                                  0x0000000FL
#define PPLL_OBSERVE1__pw_pc_digobs_trig_sel_MASK                                                             0x000001E0L
#define PPLL_OBSERVE1__pw_pc_digobs_div_MASK                                                                  0x00000C00L
#define PPLL_OBSERVE1__pw_pc_digobs_trig_div_MASK                                                             0x00003000L
#define PPLL_OBSERVE1__reg_tmg_lock_timer_MASK                                                                0x3FFF0000L
//PPLL_UPDATE_CNTL
#define PPLL_UPDATE_CNTL__reg_tmg_PLL_UPDATE_LOCK__SHIFT                                                      0x2
#define PPLL_UPDATE_CNTL__reg_tmg_PLL_UPDATE_POINT__SHIFT                                                     0x3
#define PPLL_UPDATE_CNTL__tmg_reg_UPDATE_PENDING__SHIFT                                                       0x8
#define PPLL_UPDATE_CNTL__pc_pw_pll_rdy__SHIFT                                                                0x9
#define PPLL_UPDATE_CNTL__TieLow1__SHIFT                                                                      0x10
#define PPLL_UPDATE_CNTL__reg_tmg_PLL_UPDATE_LOCK_MASK                                                        0x00000004L
#define PPLL_UPDATE_CNTL__reg_tmg_PLL_UPDATE_POINT_MASK                                                       0x00000008L
#define PPLL_UPDATE_CNTL__tmg_reg_UPDATE_PENDING_MASK                                                         0x00000100L
#define PPLL_UPDATE_CNTL__pc_pw_pll_rdy_MASK                                                                  0x00000200L
#define PPLL_UPDATE_CNTL__TieLow1_MASK                                                                        0x00010000L
//PPLL_OBSERVE0_OUT
#define PPLL_OBSERVE0_OUT__disppll_core_obsout__SHIFT                                                         0x0
#define PPLL_OBSERVE0_OUT__disppll_core_obsout_MASK                                                           0xFFFFFFFFL


// addressBlock: dce_dc_dccg_pll0_dispdec
//PLL_MACRO_CNTL_RESERVED0
#define PLL_MACRO_CNTL_RESERVED0__PLL_MACRO_CNTL_RESERVED__SHIFT                                              0x0
#define PLL_MACRO_CNTL_RESERVED0__PLL_MACRO_CNTL_RESERVED_MASK                                                0xFFFFFFFFL
//PLL_MACRO_CNTL_RESERVED1
#define PLL_MACRO_CNTL_RESERVED1__PLL_MACRO_CNTL_RESERVED__SHIFT                                              0x0
#define PLL_MACRO_CNTL_RESERVED1__PLL_MACRO_CNTL_RESERVED_MASK                                                0xFFFFFFFFL
//PLL_MACRO_CNTL_RESERVED2
#define PLL_MACRO_CNTL_RESERVED2__PLL_MACRO_CNTL_RESERVED__SHIFT                                              0x0
#define PLL_MACRO_CNTL_RESERVED2__PLL_MACRO_CNTL_RESERVED_MASK                                                0xFFFFFFFFL
//PLL_MACRO_CNTL_RESERVED3
#define PLL_MACRO_CNTL_RESERVED3__PLL_MACRO_CNTL_RESERVED__SHIFT                                              0x0
#define PLL_MACRO_CNTL_RESERVED3__PLL_MACRO_CNTL_RESERVED_MASK                                                0xFFFFFFFFL
//PLL_MACRO_CNTL_RESERVED4
#define PLL_MACRO_CNTL_RESERVED4__PLL_MACRO_CNTL_RESERVED__SHIFT                                              0x0
#define PLL_MACRO_CNTL_RESERVED4__PLL_MACRO_CNTL_RESERVED_MASK                                                0xFFFFFFFFL
//PLL_MACRO_CNTL_RESERVED5
#define PLL_MACRO_CNTL_RESERVED5__PLL_MACRO_CNTL_RESERVED__SHIFT                                              0x0
#define PLL_MACRO_CNTL_RESERVED5__PLL_MACRO_CNTL_RESERVED_MASK                                                0xFFFFFFFFL
//PLL_MACRO_CNTL_RESERVED6
#define PLL_MACRO_CNTL_RESERVED6__PLL_MACRO_CNTL_RESERVED__SHIFT                                              0x0
#define PLL_MACRO_CNTL_RESERVED6__PLL_MACRO_CNTL_RESERVED_MASK                                                0xFFFFFFFFL
//PLL_MACRO_CNTL_RESERVED7
#define PLL_MACRO_CNTL_RESERVED7__PLL_MACRO_CNTL_RESERVED__SHIFT                                              0x0
#define PLL_MACRO_CNTL_RESERVED7__PLL_MACRO_CNTL_RESERVED_MASK                                                0xFFFFFFFFL
//PLL_MACRO_CNTL_RESERVED8
#define PLL_MACRO_CNTL_RESERVED8__PLL_MACRO_CNTL_RESERVED__SHIFT                                              0x0
#define PLL_MACRO_CNTL_RESERVED8__PLL_MACRO_CNTL_RESERVED_MASK                                                0xFFFFFFFFL
//PLL_MACRO_CNTL_RESERVED9
#define PLL_MACRO_CNTL_RESERVED9__PLL_MACRO_CNTL_RESERVED__SHIFT                                              0x0
#define PLL_MACRO_CNTL_RESERVED9__PLL_MACRO_CNTL_RESERVED_MASK                                                0xFFFFFFFFL
//PLL_MACRO_CNTL_RESERVED10
#define PLL_MACRO_CNTL_RESERVED10__PLL_MACRO_CNTL_RESERVED__SHIFT                                             0x0
#define PLL_MACRO_CNTL_RESERVED10__PLL_MACRO_CNTL_RESERVED_MASK                                               0xFFFFFFFFL
//PLL_MACRO_CNTL_RESERVED11
#define PLL_MACRO_CNTL_RESERVED11__PLL_MACRO_CNTL_RESERVED__SHIFT                                             0x0
#define PLL_MACRO_CNTL_RESERVED11__PLL_MACRO_CNTL_RESERVED_MASK                                               0xFFFFFFFFL
//PLL_MACRO_CNTL_RESERVED12
#define PLL_MACRO_CNTL_RESERVED12__PLL_MACRO_CNTL_RESERVED__SHIFT                                             0x0
#define PLL_MACRO_CNTL_RESERVED12__PLL_MACRO_CNTL_RESERVED_MASK                                               0xFFFFFFFFL
//PLL_MACRO_CNTL_RESERVED13
#define PLL_MACRO_CNTL_RESERVED13__PLL_MACRO_CNTL_RESERVED__SHIFT                                             0x0
#define PLL_MACRO_CNTL_RESERVED13__PLL_MACRO_CNTL_RESERVED_MASK                                               0xFFFFFFFFL
//PLL_MACRO_CNTL_RESERVED14
#define PLL_MACRO_CNTL_RESERVED14__PLL_MACRO_CNTL_RESERVED__SHIFT                                             0x0
#define PLL_MACRO_CNTL_RESERVED14__PLL_MACRO_CNTL_RESERVED_MASK                                               0xFFFFFFFFL
//PLL_MACRO_CNTL_RESERVED15
#define PLL_MACRO_CNTL_RESERVED15__PLL_MACRO_CNTL_RESERVED__SHIFT                                             0x0
#define PLL_MACRO_CNTL_RESERVED15__PLL_MACRO_CNTL_RESERVED_MASK                                               0xFFFFFFFFL
//PLL_MACRO_CNTL_RESERVED16
#define PLL_MACRO_CNTL_RESERVED16__PLL_MACRO_CNTL_RESERVED__SHIFT                                             0x0
#define PLL_MACRO_CNTL_RESERVED16__PLL_MACRO_CNTL_RESERVED_MASK                                               0xFFFFFFFFL
//PLL_MACRO_CNTL_RESERVED17
#define PLL_MACRO_CNTL_RESERVED17__PLL_MACRO_CNTL_RESERVED__SHIFT                                             0x0
#define PLL_MACRO_CNTL_RESERVED17__PLL_MACRO_CNTL_RESERVED_MASK                                               0xFFFFFFFFL
//PLL_MACRO_CNTL_RESERVED18
#define PLL_MACRO_CNTL_RESERVED18__PLL_MACRO_CNTL_RESERVED__SHIFT                                             0x0
#define PLL_MACRO_CNTL_RESERVED18__PLL_MACRO_CNTL_RESERVED_MASK                                               0xFFFFFFFFL
//PLL_MACRO_CNTL_RESERVED19
#define PLL_MACRO_CNTL_RESERVED19__PLL_MACRO_CNTL_RESERVED__SHIFT                                             0x0
#define PLL_MACRO_CNTL_RESERVED19__PLL_MACRO_CNTL_RESERVED_MASK                                               0xFFFFFFFFL
//PLL_MACRO_CNTL_RESERVED20
#define PLL_MACRO_CNTL_RESERVED20__PLL_MACRO_CNTL_RESERVED__SHIFT                                             0x0
#define PLL_MACRO_CNTL_RESERVED20__PLL_MACRO_CNTL_RESERVED_MASK                                               0xFFFFFFFFL
//PLL_MACRO_CNTL_RESERVED21
#define PLL_MACRO_CNTL_RESERVED21__PLL_MACRO_CNTL_RESERVED__SHIFT                                             0x0
#define PLL_MACRO_CNTL_RESERVED21__PLL_MACRO_CNTL_RESERVED_MASK                                               0xFFFFFFFFL
//PLL_MACRO_CNTL_RESERVED22
#define PLL_MACRO_CNTL_RESERVED22__PLL_MACRO_CNTL_RESERVED__SHIFT                                             0x0
#define PLL_MACRO_CNTL_RESERVED22__PLL_MACRO_CNTL_RESERVED_MASK                                               0xFFFFFFFFL
//PLL_MACRO_CNTL_RESERVED23
#define PLL_MACRO_CNTL_RESERVED23__PLL_MACRO_CNTL_RESERVED__SHIFT                                             0x0
#define PLL_MACRO_CNTL_RESERVED23__PLL_MACRO_CNTL_RESERVED_MASK                                               0xFFFFFFFFL
//PLL_MACRO_CNTL_RESERVED24
#define PLL_MACRO_CNTL_RESERVED24__PLL_MACRO_CNTL_RESERVED__SHIFT                                             0x0
#define PLL_MACRO_CNTL_RESERVED24__PLL_MACRO_CNTL_RESERVED_MASK                                               0xFFFFFFFFL
//PLL_MACRO_CNTL_RESERVED25
#define PLL_MACRO_CNTL_RESERVED25__PLL_MACRO_CNTL_RESERVED__SHIFT                                             0x0
#define PLL_MACRO_CNTL_RESERVED25__PLL_MACRO_CNTL_RESERVED_MASK                                               0xFFFFFFFFL
//PLL_MACRO_CNTL_RESERVED26
#define PLL_MACRO_CNTL_RESERVED26__PLL_MACRO_CNTL_RESERVED__SHIFT                                             0x0
#define PLL_MACRO_CNTL_RESERVED26__PLL_MACRO_CNTL_RESERVED_MASK                                               0xFFFFFFFFL
//PLL_MACRO_CNTL_RESERVED27
#define PLL_MACRO_CNTL_RESERVED27__PLL_MACRO_CNTL_RESERVED__SHIFT                                             0x0
#define PLL_MACRO_CNTL_RESERVED27__PLL_MACRO_CNTL_RESERVED_MASK                                               0xFFFFFFFFL
//PLL_MACRO_CNTL_RESERVED28
#define PLL_MACRO_CNTL_RESERVED28__PLL_MACRO_CNTL_RESERVED__SHIFT                                             0x0
#define PLL_MACRO_CNTL_RESERVED28__PLL_MACRO_CNTL_RESERVED_MASK                                               0xFFFFFFFFL
//PLL_MACRO_CNTL_RESERVED29
#define PLL_MACRO_CNTL_RESERVED29__PLL_MACRO_CNTL_RESERVED__SHIFT                                             0x0
#define PLL_MACRO_CNTL_RESERVED29__PLL_MACRO_CNTL_RESERVED_MASK                                               0xFFFFFFFFL
//PLL_MACRO_CNTL_RESERVED30
#define PLL_MACRO_CNTL_RESERVED30__PLL_MACRO_CNTL_RESERVED__SHIFT                                             0x0
#define PLL_MACRO_CNTL_RESERVED30__PLL_MACRO_CNTL_RESERVED_MASK                                               0xFFFFFFFFL
//PLL_MACRO_CNTL_RESERVED31
#define PLL_MACRO_CNTL_RESERVED31__PLL_MACRO_CNTL_RESERVED__SHIFT                                             0x0
#define PLL_MACRO_CNTL_RESERVED31__PLL_MACRO_CNTL_RESERVED_MASK                                               0xFFFFFFFFL
//PLL_MACRO_CNTL_RESERVED32
#define PLL_MACRO_CNTL_RESERVED32__PLL_MACRO_CNTL_RESERVED__SHIFT                                             0x0
#define PLL_MACRO_CNTL_RESERVED32__PLL_MACRO_CNTL_RESERVED_MASK                                               0xFFFFFFFFL
//PLL_MACRO_CNTL_RESERVED33
#define PLL_MACRO_CNTL_RESERVED33__PLL_MACRO_CNTL_RESERVED__SHIFT                                             0x0
#define PLL_MACRO_CNTL_RESERVED33__PLL_MACRO_CNTL_RESERVED_MASK                                               0xFFFFFFFFL
//PLL_MACRO_CNTL_RESERVED34
#define PLL_MACRO_CNTL_RESERVED34__PLL_MACRO_CNTL_RESERVED__SHIFT                                             0x0
#define PLL_MACRO_CNTL_RESERVED34__PLL_MACRO_CNTL_RESERVED_MASK                                               0xFFFFFFFFL
//PLL_MACRO_CNTL_RESERVED35
#define PLL_MACRO_CNTL_RESERVED35__PLL_MACRO_CNTL_RESERVED__SHIFT                                             0x0
#define PLL_MACRO_CNTL_RESERVED35__PLL_MACRO_CNTL_RESERVED_MASK                                               0xFFFFFFFFL
//PLL_MACRO_CNTL_RESERVED36
#define PLL_MACRO_CNTL_RESERVED36__PLL_MACRO_CNTL_RESERVED__SHIFT                                             0x0
#define PLL_MACRO_CNTL_RESERVED36__PLL_MACRO_CNTL_RESERVED_MASK                                               0xFFFFFFFFL
//PLL_MACRO_CNTL_RESERVED37
#define PLL_MACRO_CNTL_RESERVED37__PLL_MACRO_CNTL_RESERVED__SHIFT                                             0x0
#define PLL_MACRO_CNTL_RESERVED37__PLL_MACRO_CNTL_RESERVED_MASK                                               0xFFFFFFFFL
//PLL_MACRO_CNTL_RESERVED38
#define PLL_MACRO_CNTL_RESERVED38__PLL_MACRO_CNTL_RESERVED__SHIFT                                             0x0
#define PLL_MACRO_CNTL_RESERVED38__PLL_MACRO_CNTL_RESERVED_MASK                                               0xFFFFFFFFL
//PLL_MACRO_CNTL_RESERVED39
#define PLL_MACRO_CNTL_RESERVED39__PLL_MACRO_CNTL_RESERVED__SHIFT                                             0x0
#define PLL_MACRO_CNTL_RESERVED39__PLL_MACRO_CNTL_RESERVED_MASK                                               0xFFFFFFFFL
//PLL_MACRO_CNTL_RESERVED40
#define PLL_MACRO_CNTL_RESERVED40__PLL_MACRO_CNTL_RESERVED__SHIFT                                             0x0
#define PLL_MACRO_CNTL_RESERVED40__PLL_MACRO_CNTL_RESERVED_MASK                                               0xFFFFFFFFL
//PLL_MACRO_CNTL_RESERVED41
#define PLL_MACRO_CNTL_RESERVED41__PLL_MACRO_CNTL_RESERVED__SHIFT                                             0x0
#define PLL_MACRO_CNTL_RESERVED41__PLL_MACRO_CNTL_RESERVED_MASK                                               0xFFFFFFFFL


// addressBlock: dce_dc_dc_perfmon1_dispdec
//DC_PERFMON1_PERFCOUNTER_CNTL
#define DC_PERFMON1_PERFCOUNTER_CNTL__PERFCOUNTER_EVENT_SEL__SHIFT                                            0x0
#define DC_PERFMON1_PERFCOUNTER_CNTL__PERFCOUNTER_CVALUE_SEL__SHIFT                                           0x9
#define DC_PERFMON1_PERFCOUNTER_CNTL__PERFCOUNTER_INC_MODE__SHIFT                                             0xc
#define DC_PERFMON1_PERFCOUNTER_CNTL__PERFCOUNTER_HW_CNTL_SEL__SHIFT                                          0xf
#define DC_PERFMON1_PERFCOUNTER_CNTL__PERFCOUNTER_RUNEN_MODE__SHIFT                                           0x10
#define DC_PERFMON1_PERFCOUNTER_CNTL__PERFCOUNTER_CNTOFF_SEL__SHIFT                                           0x11
#define DC_PERFMON1_PERFCOUNTER_CNTL__PERFCOUNTER_CNTOFF_START_DIS__SHIFT                                     0x16
#define DC_PERFMON1_PERFCOUNTER_CNTL__PERFCOUNTER_RESTART_EN__SHIFT                                           0x17
#define DC_PERFMON1_PERFCOUNTER_CNTL__PERFCOUNTER_INT_EN__SHIFT                                               0x18
#define DC_PERFMON1_PERFCOUNTER_CNTL__PERFCOUNTER_OFF_MASK__SHIFT                                             0x19
#define DC_PERFMON1_PERFCOUNTER_CNTL__PERFCOUNTER_ACTIVE__SHIFT                                               0x1a
#define DC_PERFMON1_PERFCOUNTER_CNTL__PERFCOUNTER_INT_TYPE__SHIFT                                             0x1b
#define DC_PERFMON1_PERFCOUNTER_CNTL__PERFCOUNTER_CNTL_SEL__SHIFT                                             0x1d
#define DC_PERFMON1_PERFCOUNTER_CNTL__PERFCOUNTER_EVENT_SEL_MASK                                              0x000001FFL
#define DC_PERFMON1_PERFCOUNTER_CNTL__PERFCOUNTER_CVALUE_SEL_MASK                                             0x00000E00L
#define DC_PERFMON1_PERFCOUNTER_CNTL__PERFCOUNTER_INC_MODE_MASK                                               0x00007000L
#define DC_PERFMON1_PERFCOUNTER_CNTL__PERFCOUNTER_HW_CNTL_SEL_MASK                                            0x00008000L
#define DC_PERFMON1_PERFCOUNTER_CNTL__PERFCOUNTER_RUNEN_MODE_MASK                                             0x00010000L
#define DC_PERFMON1_PERFCOUNTER_CNTL__PERFCOUNTER_CNTOFF_SEL_MASK                                             0x003E0000L
#define DC_PERFMON1_PERFCOUNTER_CNTL__PERFCOUNTER_CNTOFF_START_DIS_MASK                                       0x00400000L
#define DC_PERFMON1_PERFCOUNTER_CNTL__PERFCOUNTER_RESTART_EN_MASK                                             0x00800000L
#define DC_PERFMON1_PERFCOUNTER_CNTL__PERFCOUNTER_INT_EN_MASK                                                 0x01000000L
#define DC_PERFMON1_PERFCOUNTER_CNTL__PERFCOUNTER_OFF_MASK_MASK                                               0x02000000L
#define DC_PERFMON1_PERFCOUNTER_CNTL__PERFCOUNTER_ACTIVE_MASK                                                 0x04000000L
#define DC_PERFMON1_PERFCOUNTER_CNTL__PERFCOUNTER_INT_TYPE_MASK                                               0x08000000L
#define DC_PERFMON1_PERFCOUNTER_CNTL__PERFCOUNTER_CNTL_SEL_MASK                                               0xE0000000L
//DC_PERFMON1_PERFCOUNTER_CNTL2
#define DC_PERFMON1_PERFCOUNTER_CNTL2__PERFCOUNTER_COUNTED_VALUE_TYPE__SHIFT                                  0x0
#define DC_PERFMON1_PERFCOUNTER_CNTL2__PERFCOUNTER_HW_STOP1_SEL__SHIFT                                        0x2
#define DC_PERFMON1_PERFCOUNTER_CNTL2__PERFCOUNTER_HW_STOP2_SEL__SHIFT                                        0x3
#define DC_PERFMON1_PERFCOUNTER_CNTL2__PERFCOUNTER_CNTL2_SEL__SHIFT                                           0x1d
#define DC_PERFMON1_PERFCOUNTER_CNTL2__PERFCOUNTER_COUNTED_VALUE_TYPE_MASK                                    0x00000003L
#define DC_PERFMON1_PERFCOUNTER_CNTL2__PERFCOUNTER_HW_STOP1_SEL_MASK                                          0x00000004L
#define DC_PERFMON1_PERFCOUNTER_CNTL2__PERFCOUNTER_HW_STOP2_SEL_MASK                                          0x00000008L
#define DC_PERFMON1_PERFCOUNTER_CNTL2__PERFCOUNTER_CNTL2_SEL_MASK                                             0xE0000000L
//DC_PERFMON1_PERFCOUNTER_STATE
#define DC_PERFMON1_PERFCOUNTER_STATE__PERFCOUNTER_CNT0_STATE__SHIFT                                          0x0
#define DC_PERFMON1_PERFCOUNTER_STATE__PERFCOUNTER_STATE_SEL0__SHIFT                                          0x2
#define DC_PERFMON1_PERFCOUNTER_STATE__PERFCOUNTER_CNT1_STATE__SHIFT                                          0x4
#define DC_PERFMON1_PERFCOUNTER_STATE__PERFCOUNTER_STATE_SEL1__SHIFT                                          0x6
#define DC_PERFMON1_PERFCOUNTER_STATE__PERFCOUNTER_CNT2_STATE__SHIFT                                          0x8
#define DC_PERFMON1_PERFCOUNTER_STATE__PERFCOUNTER_STATE_SEL2__SHIFT                                          0xa
#define DC_PERFMON1_PERFCOUNTER_STATE__PERFCOUNTER_CNT3_STATE__SHIFT                                          0xc
#define DC_PERFMON1_PERFCOUNTER_STATE__PERFCOUNTER_STATE_SEL3__SHIFT                                          0xe
#define DC_PERFMON1_PERFCOUNTER_STATE__PERFCOUNTER_CNT4_STATE__SHIFT                                          0x10
#define DC_PERFMON1_PERFCOUNTER_STATE__PERFCOUNTER_STATE_SEL4__SHIFT                                          0x12
#define DC_PERFMON1_PERFCOUNTER_STATE__PERFCOUNTER_CNT5_STATE__SHIFT                                          0x14
#define DC_PERFMON1_PERFCOUNTER_STATE__PERFCOUNTER_STATE_SEL5__SHIFT                                          0x16
#define DC_PERFMON1_PERFCOUNTER_STATE__PERFCOUNTER_CNT6_STATE__SHIFT                                          0x18
#define DC_PERFMON1_PERFCOUNTER_STATE__PERFCOUNTER_STATE_SEL6__SHIFT                                          0x1a
#define DC_PERFMON1_PERFCOUNTER_STATE__PERFCOUNTER_CNT7_STATE__SHIFT                                          0x1c
#define DC_PERFMON1_PERFCOUNTER_STATE__PERFCOUNTER_STATE_SEL7__SHIFT                                          0x1e
#define DC_PERFMON1_PERFCOUNTER_STATE__PERFCOUNTER_CNT0_STATE_MASK                                            0x00000003L
#define DC_PERFMON1_PERFCOUNTER_STATE__PERFCOUNTER_STATE_SEL0_MASK                                            0x00000004L
#define DC_PERFMON1_PERFCOUNTER_STATE__PERFCOUNTER_CNT1_STATE_MASK                                            0x00000030L
#define DC_PERFMON1_PERFCOUNTER_STATE__PERFCOUNTER_STATE_SEL1_MASK                                            0x00000040L
#define DC_PERFMON1_PERFCOUNTER_STATE__PERFCOUNTER_CNT2_STATE_MASK                                            0x00000300L
#define DC_PERFMON1_PERFCOUNTER_STATE__PERFCOUNTER_STATE_SEL2_MASK                                            0x00000400L
#define DC_PERFMON1_PERFCOUNTER_STATE__PERFCOUNTER_CNT3_STATE_MASK                                            0x00003000L
#define DC_PERFMON1_PERFCOUNTER_STATE__PERFCOUNTER_STATE_SEL3_MASK                                            0x00004000L
#define DC_PERFMON1_PERFCOUNTER_STATE__PERFCOUNTER_CNT4_STATE_MASK                                            0x00030000L
#define DC_PERFMON1_PERFCOUNTER_STATE__PERFCOUNTER_STATE_SEL4_MASK                                            0x00040000L
#define DC_PERFMON1_PERFCOUNTER_STATE__PERFCOUNTER_CNT5_STATE_MASK                                            0x00300000L
#define DC_PERFMON1_PERFCOUNTER_STATE__PERFCOUNTER_STATE_SEL5_MASK                                            0x00400000L
#define DC_PERFMON1_PERFCOUNTER_STATE__PERFCOUNTER_CNT6_STATE_MASK                                            0x03000000L
#define DC_PERFMON1_PERFCOUNTER_STATE__PERFCOUNTER_STATE_SEL6_MASK                                            0x04000000L
#define DC_PERFMON1_PERFCOUNTER_STATE__PERFCOUNTER_CNT7_STATE_MASK                                            0x30000000L
#define DC_PERFMON1_PERFCOUNTER_STATE__PERFCOUNTER_STATE_SEL7_MASK                                            0x40000000L
//DC_PERFMON1_PERFMON_CNTL
#define DC_PERFMON1_PERFMON_CNTL__PERFMON_STATE__SHIFT                                                        0x0
#define DC_PERFMON1_PERFMON_CNTL__PERFMON_RPT_COUNT__SHIFT                                                    0x8
#define DC_PERFMON1_PERFMON_CNTL__PERFMON_CNTOFF_AND_OR__SHIFT                                                0x1c
#define DC_PERFMON1_PERFMON_CNTL__PERFMON_CNTOFF_INT_EN__SHIFT                                                0x1d
#define DC_PERFMON1_PERFMON_CNTL__PERFMON_CNTOFF_INT_STATUS__SHIFT                                            0x1e
#define DC_PERFMON1_PERFMON_CNTL__PERFMON_CNTOFF_INT_ACK__SHIFT                                               0x1f
#define DC_PERFMON1_PERFMON_CNTL__PERFMON_STATE_MASK                                                          0x00000003L
#define DC_PERFMON1_PERFMON_CNTL__PERFMON_RPT_COUNT_MASK                                                      0x0FFFFF00L
#define DC_PERFMON1_PERFMON_CNTL__PERFMON_CNTOFF_AND_OR_MASK                                                  0x10000000L
#define DC_PERFMON1_PERFMON_CNTL__PERFMON_CNTOFF_INT_EN_MASK                                                  0x20000000L
#define DC_PERFMON1_PERFMON_CNTL__PERFMON_CNTOFF_INT_STATUS_MASK                                              0x40000000L
#define DC_PERFMON1_PERFMON_CNTL__PERFMON_CNTOFF_INT_ACK_MASK                                                 0x80000000L
//DC_PERFMON1_PERFMON_CNTL2
#define DC_PERFMON1_PERFMON_CNTL2__PERFMON_CNTOFF_INT_TYPE__SHIFT                                             0x0
#define DC_PERFMON1_PERFMON_CNTL2__PERFMON_CLK_ENABLE__SHIFT                                                  0x1
#define DC_PERFMON1_PERFMON_CNTL2__PERFMON_RUN_ENABLE_START_SEL__SHIFT                                        0x2
#define DC_PERFMON1_PERFMON_CNTL2__PERFMON_RUN_ENABLE_STOP_SEL__SHIFT                                         0xa
#define DC_PERFMON1_PERFMON_CNTL2__PERFMON_CNTOFF_INT_TYPE_MASK                                               0x00000001L
#define DC_PERFMON1_PERFMON_CNTL2__PERFMON_CLK_ENABLE_MASK                                                    0x00000002L
#define DC_PERFMON1_PERFMON_CNTL2__PERFMON_RUN_ENABLE_START_SEL_MASK                                          0x000003FCL
#define DC_PERFMON1_PERFMON_CNTL2__PERFMON_RUN_ENABLE_STOP_SEL_MASK                                           0x0003FC00L
//DC_PERFMON1_PERFMON_CVALUE_INT_MISC
#define DC_PERFMON1_PERFMON_CVALUE_INT_MISC__PERFCOUNTER_INT0_STATUS__SHIFT                                   0x0
#define DC_PERFMON1_PERFMON_CVALUE_INT_MISC__PERFCOUNTER_INT1_STATUS__SHIFT                                   0x1
#define DC_PERFMON1_PERFMON_CVALUE_INT_MISC__PERFCOUNTER_INT2_STATUS__SHIFT                                   0x2
#define DC_PERFMON1_PERFMON_CVALUE_INT_MISC__PERFCOUNTER_INT3_STATUS__SHIFT                                   0x3
#define DC_PERFMON1_PERFMON_CVALUE_INT_MISC__PERFCOUNTER_INT4_STATUS__SHIFT                                   0x4
#define DC_PERFMON1_PERFMON_CVALUE_INT_MISC__PERFCOUNTER_INT5_STATUS__SHIFT                                   0x5
#define DC_PERFMON1_PERFMON_CVALUE_INT_MISC__PERFCOUNTER_INT6_STATUS__SHIFT                                   0x6
#define DC_PERFMON1_PERFMON_CVALUE_INT_MISC__PERFCOUNTER_INT7_STATUS__SHIFT                                   0x7
#define DC_PERFMON1_PERFMON_CVALUE_INT_MISC__PERFCOUNTER_INT0_ACK__SHIFT                                      0x8
#define DC_PERFMON1_PERFMON_CVALUE_INT_MISC__PERFCOUNTER_INT1_ACK__SHIFT                                      0x9
#define DC_PERFMON1_PERFMON_CVALUE_INT_MISC__PERFCOUNTER_INT2_ACK__SHIFT                                      0xa
#define DC_PERFMON1_PERFMON_CVALUE_INT_MISC__PERFCOUNTER_INT3_ACK__SHIFT                                      0xb
#define DC_PERFMON1_PERFMON_CVALUE_INT_MISC__PERFCOUNTER_INT4_ACK__SHIFT                                      0xc
#define DC_PERFMON1_PERFMON_CVALUE_INT_MISC__PERFCOUNTER_INT5_ACK__SHIFT                                      0xd
#define DC_PERFMON1_PERFMON_CVALUE_INT_MISC__PERFCOUNTER_INT6_ACK__SHIFT                                      0xe
#define DC_PERFMON1_PERFMON_CVALUE_INT_MISC__PERFCOUNTER_INT7_ACK__SHIFT                                      0xf
#define DC_PERFMON1_PERFMON_CVALUE_INT_MISC__PERFMON_CVALUE_HI__SHIFT                                         0x10
#define DC_PERFMON1_PERFMON_CVALUE_INT_MISC__PERFCOUNTER_INT0_STATUS_MASK                                     0x00000001L
#define DC_PERFMON1_PERFMON_CVALUE_INT_MISC__PERFCOUNTER_INT1_STATUS_MASK                                     0x00000002L
#define DC_PERFMON1_PERFMON_CVALUE_INT_MISC__PERFCOUNTER_INT2_STATUS_MASK                                     0x00000004L
#define DC_PERFMON1_PERFMON_CVALUE_INT_MISC__PERFCOUNTER_INT3_STATUS_MASK                                     0x00000008L
#define DC_PERFMON1_PERFMON_CVALUE_INT_MISC__PERFCOUNTER_INT4_STATUS_MASK                                     0x00000010L
#define DC_PERFMON1_PERFMON_CVALUE_INT_MISC__PERFCOUNTER_INT5_STATUS_MASK                                     0x00000020L
#define DC_PERFMON1_PERFMON_CVALUE_INT_MISC__PERFCOUNTER_INT6_STATUS_MASK                                     0x00000040L
#define DC_PERFMON1_PERFMON_CVALUE_INT_MISC__PERFCOUNTER_INT7_STATUS_MASK                                     0x00000080L
#define DC_PERFMON1_PERFMON_CVALUE_INT_MISC__PERFCOUNTER_INT0_ACK_MASK                                        0x00000100L
#define DC_PERFMON1_PERFMON_CVALUE_INT_MISC__PERFCOUNTER_INT1_ACK_MASK                                        0x00000200L
#define DC_PERFMON1_PERFMON_CVALUE_INT_MISC__PERFCOUNTER_INT2_ACK_MASK                                        0x00000400L
#define DC_PERFMON1_PERFMON_CVALUE_INT_MISC__PERFCOUNTER_INT3_ACK_MASK                                        0x00000800L
#define DC_PERFMON1_PERFMON_CVALUE_INT_MISC__PERFCOUNTER_INT4_ACK_MASK                                        0x00001000L
#define DC_PERFMON1_PERFMON_CVALUE_INT_MISC__PERFCOUNTER_INT5_ACK_MASK                                        0x00002000L
#define DC_PERFMON1_PERFMON_CVALUE_INT_MISC__PERFCOUNTER_INT6_ACK_MASK                                        0x00004000L
#define DC_PERFMON1_PERFMON_CVALUE_INT_MISC__PERFCOUNTER_INT7_ACK_MASK                                        0x00008000L
#define DC_PERFMON1_PERFMON_CVALUE_INT_MISC__PERFMON_CVALUE_HI_MASK                                           0xFFFF0000L
//DC_PERFMON1_PERFMON_CVALUE_LOW
#define DC_PERFMON1_PERFMON_CVALUE_LOW__PERFMON_CVALUE_LOW__SHIFT                                             0x0
#define DC_PERFMON1_PERFMON_CVALUE_LOW__PERFMON_CVALUE_LOW_MASK                                               0xFFFFFFFFL
//DC_PERFMON1_PERFMON_HI
#define DC_PERFMON1_PERFMON_HI__PERFMON_HI__SHIFT                                                             0x0
#define DC_PERFMON1_PERFMON_HI__PERFMON_READ_SEL__SHIFT                                                       0x1d
#define DC_PERFMON1_PERFMON_HI__PERFMON_HI_MASK                                                               0x0000FFFFL
#define DC_PERFMON1_PERFMON_HI__PERFMON_READ_SEL_MASK                                                         0xE0000000L
//DC_PERFMON1_PERFMON_LOW
#define DC_PERFMON1_PERFMON_LOW__PERFMON_LOW__SHIFT                                                           0x0
#define DC_PERFMON1_PERFMON_LOW__PERFMON_LOW_MASK                                                             0xFFFFFFFFL


// addressBlock: dce_dc_mcif_wb0_dispdec
//MCIF_WB0_MCIF_WB_BUFMGR_SW_CONTROL
#define MCIF_WB0_MCIF_WB_BUFMGR_SW_CONTROL__MCIF_WB_BUFMGR_ENABLE__SHIFT                                      0x0
#define MCIF_WB0_MCIF_WB_BUFMGR_SW_CONTROL__MCIF_WB_BUF_DUALSIZE_REQ__SHIFT                                   0x1
#define MCIF_WB0_MCIF_WB_BUFMGR_SW_CONTROL__MCIF_WB_BUFMGR_SW_INT_EN__SHIFT                                   0x4
#define MCIF_WB0_MCIF_WB_BUFMGR_SW_CONTROL__MCIF_WB_BUFMGR_SW_INT_ACK__SHIFT                                  0x5
#define MCIF_WB0_MCIF_WB_BUFMGR_SW_CONTROL__MCIF_WB_BUFMGR_SW_SLICE_INT_EN__SHIFT                             0x6
#define MCIF_WB0_MCIF_WB_BUFMGR_SW_CONTROL__MCIF_WB_BUFMGR_SW_OVERRUN_INT_EN__SHIFT                           0x7
#define MCIF_WB0_MCIF_WB_BUFMGR_SW_CONTROL__MCIF_WB_BUFMGR_SW_LOCK__SHIFT                                     0x8
#define MCIF_WB0_MCIF_WB_BUFMGR_SW_CONTROL__MCIF_WB_P_VMID__SHIFT                                             0x10
#define MCIF_WB0_MCIF_WB_BUFMGR_SW_CONTROL__MCIF_WB_BUF_ADDR_FENCE_EN__SHIFT                                  0x18
#define MCIF_WB0_MCIF_WB_BUFMGR_SW_CONTROL__MCIF_WB_BUFMGR_ENABLE_MASK                                        0x00000001L
#define MCIF_WB0_MCIF_WB_BUFMGR_SW_CONTROL__MCIF_WB_BUF_DUALSIZE_REQ_MASK                                     0x00000002L
#define MCIF_WB0_MCIF_WB_BUFMGR_SW_CONTROL__MCIF_WB_BUFMGR_SW_INT_EN_MASK                                     0x00000010L
#define MCIF_WB0_MCIF_WB_BUFMGR_SW_CONTROL__MCIF_WB_BUFMGR_SW_INT_ACK_MASK                                    0x00000020L
#define MCIF_WB0_MCIF_WB_BUFMGR_SW_CONTROL__MCIF_WB_BUFMGR_SW_SLICE_INT_EN_MASK                               0x00000040L
#define MCIF_WB0_MCIF_WB_BUFMGR_SW_CONTROL__MCIF_WB_BUFMGR_SW_OVERRUN_INT_EN_MASK                             0x00000080L
#define MCIF_WB0_MCIF_WB_BUFMGR_SW_CONTROL__MCIF_WB_BUFMGR_SW_LOCK_MASK                                       0x00000F00L
#define MCIF_WB0_MCIF_WB_BUFMGR_SW_CONTROL__MCIF_WB_P_VMID_MASK                                               0x000F0000L
#define MCIF_WB0_MCIF_WB_BUFMGR_SW_CONTROL__MCIF_WB_BUF_ADDR_FENCE_EN_MASK                                    0x01000000L
//MCIF_WB0_MCIF_WB_BUFMGR_CUR_LINE_R
#define MCIF_WB0_MCIF_WB_BUFMGR_CUR_LINE_R__MCIF_WB_BUFMGR_CUR_LINE_R__SHIFT                                  0x0
#define MCIF_WB0_MCIF_WB_BUFMGR_CUR_LINE_R__MCIF_WB_BUFMGR_CUR_LINE_R_MASK                                    0x00001FFFL
//MCIF_WB0_MCIF_WB_BUFMGR_STATUS
#define MCIF_WB0_MCIF_WB_BUFMGR_STATUS__MCIF_WB_BUFMGR_VCE_INT_STATUS__SHIFT                                  0x0
#define MCIF_WB0_MCIF_WB_BUFMGR_STATUS__MCIF_WB_BUFMGR_SW_INT_STATUS__SHIFT                                   0x1
#define MCIF_WB0_MCIF_WB_BUFMGR_STATUS__MCIF_WB_BUFMGR_SW_OVERRUN_INT_STATUS__SHIFT                           0x2
#define MCIF_WB0_MCIF_WB_BUFMGR_STATUS__MCIF_WB_BUFMGR_CUR_BUF__SHIFT                                         0x4
#define MCIF_WB0_MCIF_WB_BUFMGR_STATUS__MCIF_WB_BUF_DUALSIZE_STATUS__SHIFT                                    0x7
#define MCIF_WB0_MCIF_WB_BUFMGR_STATUS__MCIF_WB_BUFMGR_BUFTAG__SHIFT                                          0x8
#define MCIF_WB0_MCIF_WB_BUFMGR_STATUS__MCIF_WB_BUFMGR_CUR_LINE_L__SHIFT                                      0xc
#define MCIF_WB0_MCIF_WB_BUFMGR_STATUS__MCIF_WB_BUFMGR_NEXT_BUF__SHIFT                                        0x1c
#define MCIF_WB0_MCIF_WB_BUFMGR_STATUS__MCIF_WB_BUFMGR_VCE_INT_STATUS_MASK                                    0x00000001L
#define MCIF_WB0_MCIF_WB_BUFMGR_STATUS__MCIF_WB_BUFMGR_SW_INT_STATUS_MASK                                     0x00000002L
#define MCIF_WB0_MCIF_WB_BUFMGR_STATUS__MCIF_WB_BUFMGR_SW_OVERRUN_INT_STATUS_MASK                             0x00000004L
#define MCIF_WB0_MCIF_WB_BUFMGR_STATUS__MCIF_WB_BUFMGR_CUR_BUF_MASK                                           0x00000070L
#define MCIF_WB0_MCIF_WB_BUFMGR_STATUS__MCIF_WB_BUF_DUALSIZE_STATUS_MASK                                      0x00000080L
#define MCIF_WB0_MCIF_WB_BUFMGR_STATUS__MCIF_WB_BUFMGR_BUFTAG_MASK                                            0x00000F00L
#define MCIF_WB0_MCIF_WB_BUFMGR_STATUS__MCIF_WB_BUFMGR_CUR_LINE_L_MASK                                        0x01FFF000L
#define MCIF_WB0_MCIF_WB_BUFMGR_STATUS__MCIF_WB_BUFMGR_NEXT_BUF_MASK                                          0x70000000L
//MCIF_WB0_MCIF_WB_BUF_PITCH
#define MCIF_WB0_MCIF_WB_BUF_PITCH__MCIF_WB_BUF_LUMA_PITCH__SHIFT                                             0x8
#define MCIF_WB0_MCIF_WB_BUF_PITCH__MCIF_WB_BUF_CHROMA_PITCH__SHIFT                                           0x18
#define MCIF_WB0_MCIF_WB_BUF_PITCH__MCIF_WB_BUF_LUMA_PITCH_MASK                                               0x0000FF00L
#define MCIF_WB0_MCIF_WB_BUF_PITCH__MCIF_WB_BUF_CHROMA_PITCH_MASK                                             0xFF000000L
//MCIF_WB0_MCIF_WB_BUF_1_STATUS
#define MCIF_WB0_MCIF_WB_BUF_1_STATUS__MCIF_WB_BUF_1_ACTIVE__SHIFT                                            0x0
#define MCIF_WB0_MCIF_WB_BUF_1_STATUS__MCIF_WB_BUF_1_SW_LOCKED__SHIFT                                         0x1
#define MCIF_WB0_MCIF_WB_BUF_1_STATUS__MCIF_WB_BUF_1_VCE_LOCKED__SHIFT                                        0x2
#define MCIF_WB0_MCIF_WB_BUF_1_STATUS__MCIF_WB_BUF_1_OVERFLOW__SHIFT                                          0x3
#define MCIF_WB0_MCIF_WB_BUF_1_STATUS__MCIF_WB_BUF_1_DISABLE__SHIFT                                           0x4
#define MCIF_WB0_MCIF_WB_BUF_1_STATUS__MCIF_WB_BUF_1_MODE__SHIFT                                              0x5
#define MCIF_WB0_MCIF_WB_BUF_1_STATUS__MCIF_WB_BUF_1_BUFTAG__SHIFT                                            0x8
#define MCIF_WB0_MCIF_WB_BUF_1_STATUS__MCIF_WB_BUF_1_NXT_BUF__SHIFT                                           0xc
#define MCIF_WB0_MCIF_WB_BUF_1_STATUS__MCIF_WB_BUF_1_FIELD__SHIFT                                             0xf
#define MCIF_WB0_MCIF_WB_BUF_1_STATUS__MCIF_WB_BUF_1_CUR_LINE_L__SHIFT                                        0x10
#define MCIF_WB0_MCIF_WB_BUF_1_STATUS__MCIF_WB_BUF_1_LONG_LINE_ERROR__SHIFT                                   0x1d
#define MCIF_WB0_MCIF_WB_BUF_1_STATUS__MCIF_WB_BUF_1_SHORT_LINE_ERROR__SHIFT                                  0x1e
#define MCIF_WB0_MCIF_WB_BUF_1_STATUS__MCIF_WB_BUF_1_FRAME_LENGTH_ERROR__SHIFT                                0x1f
#define MCIF_WB0_MCIF_WB_BUF_1_STATUS__MCIF_WB_BUF_1_ACTIVE_MASK                                              0x00000001L
#define MCIF_WB0_MCIF_WB_BUF_1_STATUS__MCIF_WB_BUF_1_SW_LOCKED_MASK                                           0x00000002L
#define MCIF_WB0_MCIF_WB_BUF_1_STATUS__MCIF_WB_BUF_1_VCE_LOCKED_MASK                                          0x00000004L
#define MCIF_WB0_MCIF_WB_BUF_1_STATUS__MCIF_WB_BUF_1_OVERFLOW_MASK                                            0x00000008L
#define MCIF_WB0_MCIF_WB_BUF_1_STATUS__MCIF_WB_BUF_1_DISABLE_MASK                                             0x00000010L
#define MCIF_WB0_MCIF_WB_BUF_1_STATUS__MCIF_WB_BUF_1_MODE_MASK                                                0x000000E0L
#define MCIF_WB0_MCIF_WB_BUF_1_STATUS__MCIF_WB_BUF_1_BUFTAG_MASK                                              0x00000F00L
#define MCIF_WB0_MCIF_WB_BUF_1_STATUS__MCIF_WB_BUF_1_NXT_BUF_MASK                                             0x00007000L
#define MCIF_WB0_MCIF_WB_BUF_1_STATUS__MCIF_WB_BUF_1_FIELD_MASK                                               0x00008000L
#define MCIF_WB0_MCIF_WB_BUF_1_STATUS__MCIF_WB_BUF_1_CUR_LINE_L_MASK                                          0x1FFF0000L
#define MCIF_WB0_MCIF_WB_BUF_1_STATUS__MCIF_WB_BUF_1_LONG_LINE_ERROR_MASK                                     0x20000000L
#define MCIF_WB0_MCIF_WB_BUF_1_STATUS__MCIF_WB_BUF_1_SHORT_LINE_ERROR_MASK                                    0x40000000L
#define MCIF_WB0_MCIF_WB_BUF_1_STATUS__MCIF_WB_BUF_1_FRAME_LENGTH_ERROR_MASK                                  0x80000000L
//MCIF_WB0_MCIF_WB_BUF_1_STATUS2
#define MCIF_WB0_MCIF_WB_BUF_1_STATUS2__MCIF_WB_BUF_1_CUR_LINE_R__SHIFT                                       0x0
#define MCIF_WB0_MCIF_WB_BUF_1_STATUS2__MCIF_WB_BUF_1_NEW_CONTENT__SHIFT                                      0xd
#define MCIF_WB0_MCIF_WB_BUF_1_STATUS2__MCIF_WB_BUF_1_COLOR_DEPTH__SHIFT                                      0xe
#define MCIF_WB0_MCIF_WB_BUF_1_STATUS2__MCIF_WB_BUF_1_Y_OVERRUN__SHIFT                                        0x11
#define MCIF_WB0_MCIF_WB_BUF_1_STATUS2__MCIF_WB_BUF_1_C_OVERRUN__SHIFT                                        0x12
#define MCIF_WB0_MCIF_WB_BUF_1_STATUS2__MCIF_WB_BUF_1_CUR_LINE_R_MASK                                         0x00001FFFL
#define MCIF_WB0_MCIF_WB_BUF_1_STATUS2__MCIF_WB_BUF_1_NEW_CONTENT_MASK                                        0x00002000L
#define MCIF_WB0_MCIF_WB_BUF_1_STATUS2__MCIF_WB_BUF_1_COLOR_DEPTH_MASK                                        0x00004000L
#define MCIF_WB0_MCIF_WB_BUF_1_STATUS2__MCIF_WB_BUF_1_Y_OVERRUN_MASK                                          0x00020000L
#define MCIF_WB0_MCIF_WB_BUF_1_STATUS2__MCIF_WB_BUF_1_C_OVERRUN_MASK                                          0x00040000L
//MCIF_WB0_MCIF_WB_BUF_2_STATUS
#define MCIF_WB0_MCIF_WB_BUF_2_STATUS__MCIF_WB_BUF_2_ACTIVE__SHIFT                                            0x0
#define MCIF_WB0_MCIF_WB_BUF_2_STATUS__MCIF_WB_BUF_2_SW_LOCKED__SHIFT                                         0x1
#define MCIF_WB0_MCIF_WB_BUF_2_STATUS__MCIF_WB_BUF_2_VCE_LOCKED__SHIFT                                        0x2
#define MCIF_WB0_MCIF_WB_BUF_2_STATUS__MCIF_WB_BUF_2_OVERFLOW__SHIFT                                          0x3
#define MCIF_WB0_MCIF_WB_BUF_2_STATUS__MCIF_WB_BUF_2_DISABLE__SHIFT                                           0x4
#define MCIF_WB0_MCIF_WB_BUF_2_STATUS__MCIF_WB_BUF_2_MODE__SHIFT                                              0x5
#define MCIF_WB0_MCIF_WB_BUF_2_STATUS__MCIF_WB_BUF_2_BUFTAG__SHIFT                                            0x8
#define MCIF_WB0_MCIF_WB_BUF_2_STATUS__MCIF_WB_BUF_2_NXT_BUF__SHIFT                                           0xc
#define MCIF_WB0_MCIF_WB_BUF_2_STATUS__MCIF_WB_BUF_2_FIELD__SHIFT                                             0xf
#define MCIF_WB0_MCIF_WB_BUF_2_STATUS__MCIF_WB_BUF_2_CUR_LINE_L__SHIFT                                        0x10
#define MCIF_WB0_MCIF_WB_BUF_2_STATUS__MCIF_WB_BUF_2_LONG_LINE_ERROR__SHIFT                                   0x1d
#define MCIF_WB0_MCIF_WB_BUF_2_STATUS__MCIF_WB_BUF_2_SHORT_LINE_ERROR__SHIFT                                  0x1e
#define MCIF_WB0_MCIF_WB_BUF_2_STATUS__MCIF_WB_BUF_2_FRAME_LENGTH_ERROR__SHIFT                                0x1f
#define MCIF_WB0_MCIF_WB_BUF_2_STATUS__MCIF_WB_BUF_2_ACTIVE_MASK                                              0x00000001L
#define MCIF_WB0_MCIF_WB_BUF_2_STATUS__MCIF_WB_BUF_2_SW_LOCKED_MASK                                           0x00000002L
#define MCIF_WB0_MCIF_WB_BUF_2_STATUS__MCIF_WB_BUF_2_VCE_LOCKED_MASK                                          0x00000004L
#define MCIF_WB0_MCIF_WB_BUF_2_STATUS__MCIF_WB_BUF_2_OVERFLOW_MASK                                            0x00000008L
#define MCIF_WB0_MCIF_WB_BUF_2_STATUS__MCIF_WB_BUF_2_DISABLE_MASK                                             0x00000010L
#define MCIF_WB0_MCIF_WB_BUF_2_STATUS__MCIF_WB_BUF_2_MODE_MASK                                                0x000000E0L
#define MCIF_WB0_MCIF_WB_BUF_2_STATUS__MCIF_WB_BUF_2_BUFTAG_MASK                                              0x00000F00L
#define MCIF_WB0_MCIF_WB_BUF_2_STATUS__MCIF_WB_BUF_2_NXT_BUF_MASK                                             0x00007000L
#define MCIF_WB0_MCIF_WB_BUF_2_STATUS__MCIF_WB_BUF_2_FIELD_MASK                                               0x00008000L
#define MCIF_WB0_MCIF_WB_BUF_2_STATUS__MCIF_WB_BUF_2_CUR_LINE_L_MASK                                          0x1FFF0000L
#define MCIF_WB0_MCIF_WB_BUF_2_STATUS__MCIF_WB_BUF_2_LONG_LINE_ERROR_MASK                                     0x20000000L
#define MCIF_WB0_MCIF_WB_BUF_2_STATUS__MCIF_WB_BUF_2_SHORT_LINE_ERROR_MASK                                    0x40000000L
#define MCIF_WB0_MCIF_WB_BUF_2_STATUS__MCIF_WB_BUF_2_FRAME_LENGTH_ERROR_MASK                                  0x80000000L
//MCIF_WB0_MCIF_WB_BUF_2_STATUS2
#define MCIF_WB0_MCIF_WB_BUF_2_STATUS2__MCIF_WB_BUF_2_CUR_LINE_R__SHIFT                                       0x0
#define MCIF_WB0_MCIF_WB_BUF_2_STATUS2__MCIF_WB_BUF_2_NEW_CONTENT__SHIFT                                      0xd
#define MCIF_WB0_MCIF_WB_BUF_2_STATUS2__MCIF_WB_BUF_2_COLOR_DEPTH__SHIFT                                      0xe
#define MCIF_WB0_MCIF_WB_BUF_2_STATUS2__MCIF_WB_BUF_2_Y_OVERRUN__SHIFT                                        0x11
#define MCIF_WB0_MCIF_WB_BUF_2_STATUS2__MCIF_WB_BUF_2_C_OVERRUN__SHIFT                                        0x12
#define MCIF_WB0_MCIF_WB_BUF_2_STATUS2__MCIF_WB_BUF_2_CUR_LINE_R_MASK                                         0x00001FFFL
#define MCIF_WB0_MCIF_WB_BUF_2_STATUS2__MCIF_WB_BUF_2_NEW_CONTENT_MASK                                        0x00002000L
#define MCIF_WB0_MCIF_WB_BUF_2_STATUS2__MCIF_WB_BUF_2_COLOR_DEPTH_MASK                                        0x00004000L
#define MCIF_WB0_MCIF_WB_BUF_2_STATUS2__MCIF_WB_BUF_2_Y_OVERRUN_MASK                                          0x00020000L
#define MCIF_WB0_MCIF_WB_BUF_2_STATUS2__MCIF_WB_BUF_2_C_OVERRUN_MASK                                          0x00040000L
//MCIF_WB0_MCIF_WB_BUF_3_STATUS
#define MCIF_WB0_MCIF_WB_BUF_3_STATUS__MCIF_WB_BUF_3_ACTIVE__SHIFT                                            0x0
#define MCIF_WB0_MCIF_WB_BUF_3_STATUS__MCIF_WB_BUF_3_SW_LOCKED__SHIFT                                         0x1
#define MCIF_WB0_MCIF_WB_BUF_3_STATUS__MCIF_WB_BUF_3_VCE_LOCKED__SHIFT                                        0x2
#define MCIF_WB0_MCIF_WB_BUF_3_STATUS__MCIF_WB_BUF_3_OVERFLOW__SHIFT                                          0x3
#define MCIF_WB0_MCIF_WB_BUF_3_STATUS__MCIF_WB_BUF_3_DISABLE__SHIFT                                           0x4
#define MCIF_WB0_MCIF_WB_BUF_3_STATUS__MCIF_WB_BUF_3_MODE__SHIFT                                              0x5
#define MCIF_WB0_MCIF_WB_BUF_3_STATUS__MCIF_WB_BUF_3_BUFTAG__SHIFT                                            0x8
#define MCIF_WB0_MCIF_WB_BUF_3_STATUS__MCIF_WB_BUF_3_NXT_BUF__SHIFT                                           0xc
#define MCIF_WB0_MCIF_WB_BUF_3_STATUS__MCIF_WB_BUF_3_FIELD__SHIFT                                             0xf
#define MCIF_WB0_MCIF_WB_BUF_3_STATUS__MCIF_WB_BUF_3_CUR_LINE_L__SHIFT                                        0x10
#define MCIF_WB0_MCIF_WB_BUF_3_STATUS__MCIF_WB_BUF_3_LONG_LINE_ERROR__SHIFT                                   0x1d
#define MCIF_WB0_MCIF_WB_BUF_3_STATUS__MCIF_WB_BUF_3_SHORT_LINE_ERROR__SHIFT                                  0x1e
#define MCIF_WB0_MCIF_WB_BUF_3_STATUS__MCIF_WB_BUF_3_FRAME_LENGTH_ERROR__SHIFT                                0x1f
#define MCIF_WB0_MCIF_WB_BUF_3_STATUS__MCIF_WB_BUF_3_ACTIVE_MASK                                              0x00000001L
#define MCIF_WB0_MCIF_WB_BUF_3_STATUS__MCIF_WB_BUF_3_SW_LOCKED_MASK                                           0x00000002L
#define MCIF_WB0_MCIF_WB_BUF_3_STATUS__MCIF_WB_BUF_3_VCE_LOCKED_MASK                                          0x00000004L
#define MCIF_WB0_MCIF_WB_BUF_3_STATUS__MCIF_WB_BUF_3_OVERFLOW_MASK                                            0x00000008L
#define MCIF_WB0_MCIF_WB_BUF_3_STATUS__MCIF_WB_BUF_3_DISABLE_MASK                                             0x00000010L
#define MCIF_WB0_MCIF_WB_BUF_3_STATUS__MCIF_WB_BUF_3_MODE_MASK                                                0x000000E0L
#define MCIF_WB0_MCIF_WB_BUF_3_STATUS__MCIF_WB_BUF_3_BUFTAG_MASK                                              0x00000F00L
#define MCIF_WB0_MCIF_WB_BUF_3_STATUS__MCIF_WB_BUF_3_NXT_BUF_MASK                                             0x00007000L
#define MCIF_WB0_MCIF_WB_BUF_3_STATUS__MCIF_WB_BUF_3_FIELD_MASK                                               0x00008000L
#define MCIF_WB0_MCIF_WB_BUF_3_STATUS__MCIF_WB_BUF_3_CUR_LINE_L_MASK                                          0x1FFF0000L
#define MCIF_WB0_MCIF_WB_BUF_3_STATUS__MCIF_WB_BUF_3_LONG_LINE_ERROR_MASK                                     0x20000000L
#define MCIF_WB0_MCIF_WB_BUF_3_STATUS__MCIF_WB_BUF_3_SHORT_LINE_ERROR_MASK                                    0x40000000L
#define MCIF_WB0_MCIF_WB_BUF_3_STATUS__MCIF_WB_BUF_3_FRAME_LENGTH_ERROR_MASK                                  0x80000000L
//MCIF_WB0_MCIF_WB_BUF_3_STATUS2
#define MCIF_WB0_MCIF_WB_BUF_3_STATUS2__MCIF_WB_BUF_3_CUR_LINE_R__SHIFT                                       0x0
#define MCIF_WB0_MCIF_WB_BUF_3_STATUS2__MCIF_WB_BUF_3_NEW_CONTENT__SHIFT                                      0xd
#define MCIF_WB0_MCIF_WB_BUF_3_STATUS2__MCIF_WB_BUF_3_COLOR_DEPTH__SHIFT                                      0xe
#define MCIF_WB0_MCIF_WB_BUF_3_STATUS2__MCIF_WB_BUF_3_Y_OVERRUN__SHIFT                                        0x11
#define MCIF_WB0_MCIF_WB_BUF_3_STATUS2__MCIF_WB_BUF_3_C_OVERRUN__SHIFT                                        0x12
#define MCIF_WB0_MCIF_WB_BUF_3_STATUS2__MCIF_WB_BUF_3_CUR_LINE_R_MASK                                         0x00001FFFL
#define MCIF_WB0_MCIF_WB_BUF_3_STATUS2__MCIF_WB_BUF_3_NEW_CONTENT_MASK                                        0x00002000L
#define MCIF_WB0_MCIF_WB_BUF_3_STATUS2__MCIF_WB_BUF_3_COLOR_DEPTH_MASK                                        0x00004000L
#define MCIF_WB0_MCIF_WB_BUF_3_STATUS2__MCIF_WB_BUF_3_Y_OVERRUN_MASK                                          0x00020000L
#define MCIF_WB0_MCIF_WB_BUF_3_STATUS2__MCIF_WB_BUF_3_C_OVERRUN_MASK                                          0x00040000L
//MCIF_WB0_MCIF_WB_BUF_4_STATUS
#define MCIF_WB0_MCIF_WB_BUF_4_STATUS__MCIF_WB_BUF_4_ACTIVE__SHIFT                                            0x0
#define MCIF_WB0_MCIF_WB_BUF_4_STATUS__MCIF_WB_BUF_4_SW_LOCKED__SHIFT                                         0x1
#define MCIF_WB0_MCIF_WB_BUF_4_STATUS__MCIF_WB_BUF_4_VCE_LOCKED__SHIFT                                        0x2
#define MCIF_WB0_MCIF_WB_BUF_4_STATUS__MCIF_WB_BUF_4_OVERFLOW__SHIFT                                          0x3
#define MCIF_WB0_MCIF_WB_BUF_4_STATUS__MCIF_WB_BUF_4_DISABLE__SHIFT                                           0x4
#define MCIF_WB0_MCIF_WB_BUF_4_STATUS__MCIF_WB_BUF_4_MODE__SHIFT                                              0x5
#define MCIF_WB0_MCIF_WB_BUF_4_STATUS__MCIF_WB_BUF_4_BUFTAG__SHIFT                                            0x8
#define MCIF_WB0_MCIF_WB_BUF_4_STATUS__MCIF_WB_BUF_4_NXT_BUF__SHIFT                                           0xc
#define MCIF_WB0_MCIF_WB_BUF_4_STATUS__MCIF_WB_BUF_4_FIELD__SHIFT                                             0xf
#define MCIF_WB0_MCIF_WB_BUF_4_STATUS__MCIF_WB_BUF_4_CUR_LINE_L__SHIFT                                        0x10
#define MCIF_WB0_MCIF_WB_BUF_4_STATUS__MCIF_WB_BUF_4_LONG_LINE_ERROR__SHIFT                                   0x1d
#define MCIF_WB0_MCIF_WB_BUF_4_STATUS__MCIF_WB_BUF_4_SHORT_LINE_ERROR__SHIFT                                  0x1e
#define MCIF_WB0_MCIF_WB_BUF_4_STATUS__MCIF_WB_BUF_4_FRAME_LENGTH_ERROR__SHIFT                                0x1f
#define MCIF_WB0_MCIF_WB_BUF_4_STATUS__MCIF_WB_BUF_4_ACTIVE_MASK                                              0x00000001L
#define MCIF_WB0_MCIF_WB_BUF_4_STATUS__MCIF_WB_BUF_4_SW_LOCKED_MASK                                           0x00000002L
#define MCIF_WB0_MCIF_WB_BUF_4_STATUS__MCIF_WB_BUF_4_VCE_LOCKED_MASK                                          0x00000004L
#define MCIF_WB0_MCIF_WB_BUF_4_STATUS__MCIF_WB_BUF_4_OVERFLOW_MASK                                            0x00000008L
#define MCIF_WB0_MCIF_WB_BUF_4_STATUS__MCIF_WB_BUF_4_DISABLE_MASK                                             0x00000010L
#define MCIF_WB0_MCIF_WB_BUF_4_STATUS__MCIF_WB_BUF_4_MODE_MASK                                                0x000000E0L
#define MCIF_WB0_MCIF_WB_BUF_4_STATUS__MCIF_WB_BUF_4_BUFTAG_MASK                                              0x00000F00L
#define MCIF_WB0_MCIF_WB_BUF_4_STATUS__MCIF_WB_BUF_4_NXT_BUF_MASK                                             0x00007000L
#define MCIF_WB0_MCIF_WB_BUF_4_STATUS__MCIF_WB_BUF_4_FIELD_MASK                                               0x00008000L
#define MCIF_WB0_MCIF_WB_BUF_4_STATUS__MCIF_WB_BUF_4_CUR_LINE_L_MASK                                          0x1FFF0000L
#define MCIF_WB0_MCIF_WB_BUF_4_STATUS__MCIF_WB_BUF_4_LONG_LINE_ERROR_MASK                                     0x20000000L
#define MCIF_WB0_MCIF_WB_BUF_4_STATUS__MCIF_WB_BUF_4_SHORT_LINE_ERROR_MASK                                    0x40000000L
#define MCIF_WB0_MCIF_WB_BUF_4_STATUS__MCIF_WB_BUF_4_FRAME_LENGTH_ERROR_MASK                                  0x80000000L
//MCIF_WB0_MCIF_WB_BUF_4_STATUS2
#define MCIF_WB0_MCIF_WB_BUF_4_STATUS2__MCIF_WB_BUF_4_CUR_LINE_R__SHIFT                                       0x0
#define MCIF_WB0_MCIF_WB_BUF_4_STATUS2__MCIF_WB_BUF_4_NEW_CONTENT__SHIFT                                      0xd
#define MCIF_WB0_MCIF_WB_BUF_4_STATUS2__MCIF_WB_BUF_4_COLOR_DEPTH__SHIFT                                      0xe
#define MCIF_WB0_MCIF_WB_BUF_4_STATUS2__MCIF_WB_BUF_4_Y_OVERRUN__SHIFT                                        0x11
#define MCIF_WB0_MCIF_WB_BUF_4_STATUS2__MCIF_WB_BUF_4_C_OVERRUN__SHIFT                                        0x12
#define MCIF_WB0_MCIF_WB_BUF_4_STATUS2__MCIF_WB_BUF_4_CUR_LINE_R_MASK                                         0x00001FFFL
#define MCIF_WB0_MCIF_WB_BUF_4_STATUS2__MCIF_WB_BUF_4_NEW_CONTENT_MASK                                        0x00002000L
#define MCIF_WB0_MCIF_WB_BUF_4_STATUS2__MCIF_WB_BUF_4_COLOR_DEPTH_MASK                                        0x00004000L
#define MCIF_WB0_MCIF_WB_BUF_4_STATUS2__MCIF_WB_BUF_4_Y_OVERRUN_MASK                                          0x00020000L
#define MCIF_WB0_MCIF_WB_BUF_4_STATUS2__MCIF_WB_BUF_4_C_OVERRUN_MASK                                          0x00040000L
//MCIF_WB0_MCIF_WB_ARBITRATION_CONTROL
#define MCIF_WB0_MCIF_WB_ARBITRATION_CONTROL__MCIF_WB_CLIENT_ARBITRATION_SLICE__SHIFT                         0x0
#define MCIF_WB0_MCIF_WB_ARBITRATION_CONTROL__MCIF_WB_TIME_PER_PIXEL__SHIFT                                   0x16
#define MCIF_WB0_MCIF_WB_ARBITRATION_CONTROL__MCIF_WB_CLIENT_ARBITRATION_SLICE_MASK                           0x00000003L
#define MCIF_WB0_MCIF_WB_ARBITRATION_CONTROL__MCIF_WB_TIME_PER_PIXEL_MASK                                     0xFFC00000L
//MCIF_WB0_MCIF_WB_SCLK_CHANGE
#define MCIF_WB0_MCIF_WB_SCLK_CHANGE__WM_CHANGE_ACK_FORCE_ON__SHIFT                                           0x0
#define MCIF_WB0_MCIF_WB_SCLK_CHANGE__MCIF_WB_CLI_WATERMARK_MASK__SHIFT                                       0x1
#define MCIF_WB0_MCIF_WB_SCLK_CHANGE__WM_CHANGE_ACK_FORCE_ON_MASK                                             0x00000001L
#define MCIF_WB0_MCIF_WB_SCLK_CHANGE__MCIF_WB_CLI_WATERMARK_MASK_MASK                                         0x0000000EL
//MCIF_WB0_MCIF_WB_BUF_1_ADDR_Y
#define MCIF_WB0_MCIF_WB_BUF_1_ADDR_Y__MCIF_WB_BUF_1_ADDR_Y__SHIFT                                            0x0
#define MCIF_WB0_MCIF_WB_BUF_1_ADDR_Y__MCIF_WB_BUF_1_ADDR_Y_MASK                                              0xFFFFFFFFL
//MCIF_WB0_MCIF_WB_BUF_1_ADDR_Y_OFFSET
#define MCIF_WB0_MCIF_WB_BUF_1_ADDR_Y_OFFSET__MCIF_WB_BUF_1_ADDR_Y_OFFSET__SHIFT                              0x0
#define MCIF_WB0_MCIF_WB_BUF_1_ADDR_Y_OFFSET__MCIF_WB_BUF_1_ADDR_Y_OFFSET_MASK                                0x0003FFFFL
//MCIF_WB0_MCIF_WB_BUF_1_ADDR_C
#define MCIF_WB0_MCIF_WB_BUF_1_ADDR_C__MCIF_WB_BUF_1_ADDR_C__SHIFT                                            0x0
#define MCIF_WB0_MCIF_WB_BUF_1_ADDR_C__MCIF_WB_BUF_1_ADDR_C_MASK                                              0xFFFFFFFFL
//MCIF_WB0_MCIF_WB_BUF_1_ADDR_C_OFFSET
#define MCIF_WB0_MCIF_WB_BUF_1_ADDR_C_OFFSET__MCIF_WB_BUF_1_ADDR_C_OFFSET__SHIFT                              0x0
#define MCIF_WB0_MCIF_WB_BUF_1_ADDR_C_OFFSET__MCIF_WB_BUF_1_ADDR_C_OFFSET_MASK                                0x0003FFFFL
//MCIF_WB0_MCIF_WB_BUF_2_ADDR_Y
#define MCIF_WB0_MCIF_WB_BUF_2_ADDR_Y__MCIF_WB_BUF_2_ADDR_Y__SHIFT                                            0x0
#define MCIF_WB0_MCIF_WB_BUF_2_ADDR_Y__MCIF_WB_BUF_2_ADDR_Y_MASK                                              0xFFFFFFFFL
//MCIF_WB0_MCIF_WB_BUF_2_ADDR_Y_OFFSET
#define MCIF_WB0_MCIF_WB_BUF_2_ADDR_Y_OFFSET__MCIF_WB_BUF_2_ADDR_Y_OFFSET__SHIFT                              0x0
#define MCIF_WB0_MCIF_WB_BUF_2_ADDR_Y_OFFSET__MCIF_WB_BUF_2_ADDR_Y_OFFSET_MASK                                0x0003FFFFL
//MCIF_WB0_MCIF_WB_BUF_2_ADDR_C
#define MCIF_WB0_MCIF_WB_BUF_2_ADDR_C__MCIF_WB_BUF_2_ADDR_C__SHIFT                                            0x0
#define MCIF_WB0_MCIF_WB_BUF_2_ADDR_C__MCIF_WB_BUF_2_ADDR_C_MASK                                              0xFFFFFFFFL
//MCIF_WB0_MCIF_WB_BUF_2_ADDR_C_OFFSET
#define MCIF_WB0_MCIF_WB_BUF_2_ADDR_C_OFFSET__MCIF_WB_BUF_2_ADDR_C_OFFSET__SHIFT                              0x0
#define MCIF_WB0_MCIF_WB_BUF_2_ADDR_C_OFFSET__MCIF_WB_BUF_2_ADDR_C_OFFSET_MASK                                0x0003FFFFL
//MCIF_WB0_MCIF_WB_BUF_3_ADDR_Y
#define MCIF_WB0_MCIF_WB_BUF_3_ADDR_Y__MCIF_WB_BUF_3_ADDR_Y__SHIFT                                            0x0
#define MCIF_WB0_MCIF_WB_BUF_3_ADDR_Y__MCIF_WB_BUF_3_ADDR_Y_MASK                                              0xFFFFFFFFL
//MCIF_WB0_MCIF_WB_BUF_3_ADDR_Y_OFFSET
#define MCIF_WB0_MCIF_WB_BUF_3_ADDR_Y_OFFSET__MCIF_WB_BUF_3_ADDR_Y_OFFSET__SHIFT                              0x0
#define MCIF_WB0_MCIF_WB_BUF_3_ADDR_Y_OFFSET__MCIF_WB_BUF_3_ADDR_Y_OFFSET_MASK                                0x0003FFFFL
//MCIF_WB0_MCIF_WB_BUF_3_ADDR_C
#define MCIF_WB0_MCIF_WB_BUF_3_ADDR_C__MCIF_WB_BUF_3_ADDR_C__SHIFT                                            0x0
#define MCIF_WB0_MCIF_WB_BUF_3_ADDR_C__MCIF_WB_BUF_3_ADDR_C_MASK                                              0xFFFFFFFFL
//MCIF_WB0_MCIF_WB_BUF_3_ADDR_C_OFFSET
#define MCIF_WB0_MCIF_WB_BUF_3_ADDR_C_OFFSET__MCIF_WB_BUF_3_ADDR_C_OFFSET__SHIFT                              0x0
#define MCIF_WB0_MCIF_WB_BUF_3_ADDR_C_OFFSET__MCIF_WB_BUF_3_ADDR_C_OFFSET_MASK                                0x0003FFFFL
//MCIF_WB0_MCIF_WB_BUF_4_ADDR_Y
#define MCIF_WB0_MCIF_WB_BUF_4_ADDR_Y__MCIF_WB_BUF_4_ADDR_Y__SHIFT                                            0x0
#define MCIF_WB0_MCIF_WB_BUF_4_ADDR_Y__MCIF_WB_BUF_4_ADDR_Y_MASK                                              0xFFFFFFFFL
//MCIF_WB0_MCIF_WB_BUF_4_ADDR_Y_OFFSET
#define MCIF_WB0_MCIF_WB_BUF_4_ADDR_Y_OFFSET__MCIF_WB_BUF_4_ADDR_Y_OFFSET__SHIFT                              0x0
#define MCIF_WB0_MCIF_WB_BUF_4_ADDR_Y_OFFSET__MCIF_WB_BUF_4_ADDR_Y_OFFSET_MASK                                0x0003FFFFL
//MCIF_WB0_MCIF_WB_BUF_4_ADDR_C
#define MCIF_WB0_MCIF_WB_BUF_4_ADDR_C__MCIF_WB_BUF_4_ADDR_C__SHIFT                                            0x0
#define MCIF_WB0_MCIF_WB_BUF_4_ADDR_C__MCIF_WB_BUF_4_ADDR_C_MASK                                              0xFFFFFFFFL
//MCIF_WB0_MCIF_WB_BUF_4_ADDR_C_OFFSET
#define MCIF_WB0_MCIF_WB_BUF_4_ADDR_C_OFFSET__MCIF_WB_BUF_4_ADDR_C_OFFSET__SHIFT                              0x0
#define MCIF_WB0_MCIF_WB_BUF_4_ADDR_C_OFFSET__MCIF_WB_BUF_4_ADDR_C_OFFSET_MASK                                0x0003FFFFL
//MCIF_WB0_MCIF_WB_BUFMGR_VCE_CONTROL
#define MCIF_WB0_MCIF_WB_BUFMGR_VCE_CONTROL__MCIF_WB_BUFMGR_VCE_LOCK_IGNORE__SHIFT                            0x0
#define MCIF_WB0_MCIF_WB_BUFMGR_VCE_CONTROL__MCIF_WB_BUFMGR_VCE_INT_EN__SHIFT                                 0x4
#define MCIF_WB0_MCIF_WB_BUFMGR_VCE_CONTROL__MCIF_WB_BUFMGR_VCE_INT_ACK__SHIFT                                0x5
#define MCIF_WB0_MCIF_WB_BUFMGR_VCE_CONTROL__MCIF_WB_BUFMGR_VCE_SLICE_INT_EN__SHIFT                           0x6
#define MCIF_WB0_MCIF_WB_BUFMGR_VCE_CONTROL__MCIF_WB_BUFMGR_VCE_LOCK__SHIFT                                   0x8
#define MCIF_WB0_MCIF_WB_BUFMGR_VCE_CONTROL__MCIF_WB_BUFMGR_SLICE_SIZE__SHIFT                                 0x10
#define MCIF_WB0_MCIF_WB_BUFMGR_VCE_CONTROL__MCIF_WB_BUFMGR_VCE_LOCK_IGNORE_MASK                              0x00000001L
#define MCIF_WB0_MCIF_WB_BUFMGR_VCE_CONTROL__MCIF_WB_BUFMGR_VCE_INT_EN_MASK                                   0x00000010L
#define MCIF_WB0_MCIF_WB_BUFMGR_VCE_CONTROL__MCIF_WB_BUFMGR_VCE_INT_ACK_MASK                                  0x00000020L
#define MCIF_WB0_MCIF_WB_BUFMGR_VCE_CONTROL__MCIF_WB_BUFMGR_VCE_SLICE_INT_EN_MASK                             0x00000040L
#define MCIF_WB0_MCIF_WB_BUFMGR_VCE_CONTROL__MCIF_WB_BUFMGR_VCE_LOCK_MASK                                     0x00000F00L
#define MCIF_WB0_MCIF_WB_BUFMGR_VCE_CONTROL__MCIF_WB_BUFMGR_SLICE_SIZE_MASK                                   0x1FFF0000L
//MCIF_WB0_MCIF_WB_NB_PSTATE_LATENCY_WATERMARK
#define MCIF_WB0_MCIF_WB_NB_PSTATE_LATENCY_WATERMARK__NB_PSTATE_CHANGE_REFRESH_WATERMARK__SHIFT               0x0
#define MCIF_WB0_MCIF_WB_NB_PSTATE_LATENCY_WATERMARK__NB_PSTATE_CHANGE_REFRESH_WATERMARK_MASK                 0x0001FFFFL
//MCIF_WB0_MCIF_WB_NB_PSTATE_CONTROL
#define MCIF_WB0_MCIF_WB_NB_PSTATE_CONTROL__NB_PSTATE_CHANGE_URGENT_DURING_REQUEST__SHIFT                     0x0
#define MCIF_WB0_MCIF_WB_NB_PSTATE_CONTROL__NB_PSTATE_CHANGE_FORCE_ON__SHIFT                                  0x1
#define MCIF_WB0_MCIF_WB_NB_PSTATE_CONTROL__NB_PSTATE_ALLOW_FOR_URGENT__SHIFT                                 0x2
#define MCIF_WB0_MCIF_WB_NB_PSTATE_CONTROL__NB_PSTATE_CHANGE_WATERMARK_MASK__SHIFT                            0x4
#define MCIF_WB0_MCIF_WB_NB_PSTATE_CONTROL__NB_PSTATE_CHANGE_URGENT_DURING_REQUEST_MASK                       0x00000001L
#define MCIF_WB0_MCIF_WB_NB_PSTATE_CONTROL__NB_PSTATE_CHANGE_FORCE_ON_MASK                                    0x00000002L
#define MCIF_WB0_MCIF_WB_NB_PSTATE_CONTROL__NB_PSTATE_ALLOW_FOR_URGENT_MASK                                   0x00000004L
#define MCIF_WB0_MCIF_WB_NB_PSTATE_CONTROL__NB_PSTATE_CHANGE_WATERMARK_MASK_MASK                              0x00000070L
//MCIF_WB0_MCIF_WB_WATERMARK
#define MCIF_WB0_MCIF_WB_WATERMARK__MCIF_WB_CLI_WATERMARK__SHIFT                                              0x0
#define MCIF_WB0_MCIF_WB_WATERMARK__MCIF_WB_CLI_WATERMARK_MASK                                                0x0000FFFFL
//MCIF_WB0_MCIF_WB_CLOCK_GATER_CONTROL
#define MCIF_WB0_MCIF_WB_CLOCK_GATER_CONTROL__MCIF_WB_CLI_CLOCK_GATER_OVERRIDE__SHIFT                         0x0
#define MCIF_WB0_MCIF_WB_CLOCK_GATER_CONTROL__MCIF_WB_CLI_CLOCK_GATER_OVERRIDE_MASK                           0x00000001L
//MCIF_WB0_MCIF_WB_WARM_UP_CNTL
#define MCIF_WB0_MCIF_WB_WARM_UP_CNTL__MCIF_WB_PITCH_SIZE_WARMUP__SHIFT                                       0x8
#define MCIF_WB0_MCIF_WB_WARM_UP_CNTL__MCIF_WB_PITCH_SIZE_WARMUP_MASK                                         0x0000FF00L
//MCIF_WB0_MCIF_WB_SELF_REFRESH_CONTROL
#define MCIF_WB0_MCIF_WB_SELF_REFRESH_CONTROL__DIS_REFRESH_UNDER_NBPREQ__SHIFT                                0x0
#define MCIF_WB0_MCIF_WB_SELF_REFRESH_CONTROL__PERFRAME_SELF_REFRESH__SHIFT                                   0x1
#define MCIF_WB0_MCIF_WB_SELF_REFRESH_CONTROL__DIS_REFRESH_UNDER_NBPREQ_MASK                                  0x00000001L
#define MCIF_WB0_MCIF_WB_SELF_REFRESH_CONTROL__PERFRAME_SELF_REFRESH_MASK                                     0x00000002L
//MCIF_WB0_MULTI_LEVEL_QOS_CTRL
#define MCIF_WB0_MULTI_LEVEL_QOS_CTRL__MAX_SCALED_TIME_TO_URGENT__SHIFT                                       0x0
#define MCIF_WB0_MULTI_LEVEL_QOS_CTRL__MAX_SCALED_TIME_TO_URGENT_MASK                                         0x003FFFFFL
//MCIF_WB0_MCIF_WB_BUF_LUMA_SIZE
#define MCIF_WB0_MCIF_WB_BUF_LUMA_SIZE__MCIF_WB_BUF_LUMA_SIZE__SHIFT                                          0x0
#define MCIF_WB0_MCIF_WB_BUF_LUMA_SIZE__MCIF_WB_BUF_LUMA_SIZE_MASK                                            0x000FFFFFL
//MCIF_WB0_MCIF_WB_BUF_CHROMA_SIZE
#define MCIF_WB0_MCIF_WB_BUF_CHROMA_SIZE__MCIF_WB_BUF_CHROMA_SIZE__SHIFT                                      0x0
#define MCIF_WB0_MCIF_WB_BUF_CHROMA_SIZE__MCIF_WB_BUF_CHROMA_SIZE_MASK                                        0x000FFFFFL


// addressBlock: dce_dc_mcif_wb1_dispdec
//MCIF_WB1_MCIF_WB_BUFMGR_SW_CONTROL
#define MCIF_WB1_MCIF_WB_BUFMGR_SW_CONTROL__MCIF_WB_BUFMGR_ENABLE__SHIFT                                      0x0
#define MCIF_WB1_MCIF_WB_BUFMGR_SW_CONTROL__MCIF_WB_BUF_DUALSIZE_REQ__SHIFT                                   0x1
#define MCIF_WB1_MCIF_WB_BUFMGR_SW_CONTROL__MCIF_WB_BUFMGR_SW_INT_EN__SHIFT                                   0x4
#define MCIF_WB1_MCIF_WB_BUFMGR_SW_CONTROL__MCIF_WB_BUFMGR_SW_INT_ACK__SHIFT                                  0x5
#define MCIF_WB1_MCIF_WB_BUFMGR_SW_CONTROL__MCIF_WB_BUFMGR_SW_SLICE_INT_EN__SHIFT                             0x6
#define MCIF_WB1_MCIF_WB_BUFMGR_SW_CONTROL__MCIF_WB_BUFMGR_SW_OVERRUN_INT_EN__SHIFT                           0x7
#define MCIF_WB1_MCIF_WB_BUFMGR_SW_CONTROL__MCIF_WB_BUFMGR_SW_LOCK__SHIFT                                     0x8
#define MCIF_WB1_MCIF_WB_BUFMGR_SW_CONTROL__MCIF_WB_P_VMID__SHIFT                                             0x10
#define MCIF_WB1_MCIF_WB_BUFMGR_SW_CONTROL__MCIF_WB_BUF_ADDR_FENCE_EN__SHIFT                                  0x18
#define MCIF_WB1_MCIF_WB_BUFMGR_SW_CONTROL__MCIF_WB_BUFMGR_ENABLE_MASK                                        0x00000001L
#define MCIF_WB1_MCIF_WB_BUFMGR_SW_CONTROL__MCIF_WB_BUF_DUALSIZE_REQ_MASK                                     0x00000002L
#define MCIF_WB1_MCIF_WB_BUFMGR_SW_CONTROL__MCIF_WB_BUFMGR_SW_INT_EN_MASK                                     0x00000010L
#define MCIF_WB1_MCIF_WB_BUFMGR_SW_CONTROL__MCIF_WB_BUFMGR_SW_INT_ACK_MASK                                    0x00000020L
#define MCIF_WB1_MCIF_WB_BUFMGR_SW_CONTROL__MCIF_WB_BUFMGR_SW_SLICE_INT_EN_MASK                               0x00000040L
#define MCIF_WB1_MCIF_WB_BUFMGR_SW_CONTROL__MCIF_WB_BUFMGR_SW_OVERRUN_INT_EN_MASK                             0x00000080L
#define MCIF_WB1_MCIF_WB_BUFMGR_SW_CONTROL__MCIF_WB_BUFMGR_SW_LOCK_MASK                                       0x00000F00L
#define MCIF_WB1_MCIF_WB_BUFMGR_SW_CONTROL__MCIF_WB_P_VMID_MASK                                               0x000F0000L
#define MCIF_WB1_MCIF_WB_BUFMGR_SW_CONTROL__MCIF_WB_BUF_ADDR_FENCE_EN_MASK                                    0x01000000L
//MCIF_WB1_MCIF_WB_BUFMGR_CUR_LINE_R
#define MCIF_WB1_MCIF_WB_BUFMGR_CUR_LINE_R__MCIF_WB_BUFMGR_CUR_LINE_R__SHIFT                                  0x0
#define MCIF_WB1_MCIF_WB_BUFMGR_CUR_LINE_R__MCIF_WB_BUFMGR_CUR_LINE_R_MASK                                    0x00001FFFL
//MCIF_WB1_MCIF_WB_BUFMGR_STATUS
#define MCIF_WB1_MCIF_WB_BUFMGR_STATUS__MCIF_WB_BUFMGR_VCE_INT_STATUS__SHIFT                                  0x0
#define MCIF_WB1_MCIF_WB_BUFMGR_STATUS__MCIF_WB_BUFMGR_SW_INT_STATUS__SHIFT                                   0x1
#define MCIF_WB1_MCIF_WB_BUFMGR_STATUS__MCIF_WB_BUFMGR_SW_OVERRUN_INT_STATUS__SHIFT                           0x2
#define MCIF_WB1_MCIF_WB_BUFMGR_STATUS__MCIF_WB_BUFMGR_CUR_BUF__SHIFT                                         0x4
#define MCIF_WB1_MCIF_WB_BUFMGR_STATUS__MCIF_WB_BUF_DUALSIZE_STATUS__SHIFT                                    0x7
#define MCIF_WB1_MCIF_WB_BUFMGR_STATUS__MCIF_WB_BUFMGR_BUFTAG__SHIFT                                          0x8
#define MCIF_WB1_MCIF_WB_BUFMGR_STATUS__MCIF_WB_BUFMGR_CUR_LINE_L__SHIFT                                      0xc
#define MCIF_WB1_MCIF_WB_BUFMGR_STATUS__MCIF_WB_BUFMGR_NEXT_BUF__SHIFT                                        0x1c
#define MCIF_WB1_MCIF_WB_BUFMGR_STATUS__MCIF_WB_BUFMGR_VCE_INT_STATUS_MASK                                    0x00000001L
#define MCIF_WB1_MCIF_WB_BUFMGR_STATUS__MCIF_WB_BUFMGR_SW_INT_STATUS_MASK                                     0x00000002L
#define MCIF_WB1_MCIF_WB_BUFMGR_STATUS__MCIF_WB_BUFMGR_SW_OVERRUN_INT_STATUS_MASK                             0x00000004L
#define MCIF_WB1_MCIF_WB_BUFMGR_STATUS__MCIF_WB_BUFMGR_CUR_BUF_MASK                                           0x00000070L
#define MCIF_WB1_MCIF_WB_BUFMGR_STATUS__MCIF_WB_BUF_DUALSIZE_STATUS_MASK                                      0x00000080L
#define MCIF_WB1_MCIF_WB_BUFMGR_STATUS__MCIF_WB_BUFMGR_BUFTAG_MASK                                            0x00000F00L
#define MCIF_WB1_MCIF_WB_BUFMGR_STATUS__MCIF_WB_BUFMGR_CUR_LINE_L_MASK                                        0x01FFF000L
#define MCIF_WB1_MCIF_WB_BUFMGR_STATUS__MCIF_WB_BUFMGR_NEXT_BUF_MASK                                          0x70000000L
//MCIF_WB1_MCIF_WB_BUF_PITCH
#define MCIF_WB1_MCIF_WB_BUF_PITCH__MCIF_WB_BUF_LUMA_PITCH__SHIFT                                             0x8
#define MCIF_WB1_MCIF_WB_BUF_PITCH__MCIF_WB_BUF_CHROMA_PITCH__SHIFT                                           0x18
#define MCIF_WB1_MCIF_WB_BUF_PITCH__MCIF_WB_BUF_LUMA_PITCH_MASK                                               0x0000FF00L
#define MCIF_WB1_MCIF_WB_BUF_PITCH__MCIF_WB_BUF_CHROMA_PITCH_MASK                                             0xFF000000L
//MCIF_WB1_MCIF_WB_BUF_1_STATUS
#define MCIF_WB1_MCIF_WB_BUF_1_STATUS__MCIF_WB_BUF_1_ACTIVE__SHIFT                                            0x0
#define MCIF_WB1_MCIF_WB_BUF_1_STATUS__MCIF_WB_BUF_1_SW_LOCKED__SHIFT                                         0x1
#define MCIF_WB1_MCIF_WB_BUF_1_STATUS__MCIF_WB_BUF_1_VCE_LOCKED__SHIFT                                        0x2
#define MCIF_WB1_MCIF_WB_BUF_1_STATUS__MCIF_WB_BUF_1_OVERFLOW__SHIFT                                          0x3
#define MCIF_WB1_MCIF_WB_BUF_1_STATUS__MCIF_WB_BUF_1_DISABLE__SHIFT                                           0x4
#define MCIF_WB1_MCIF_WB_BUF_1_STATUS__MCIF_WB_BUF_1_MODE__SHIFT                                              0x5
#define MCIF_WB1_MCIF_WB_BUF_1_STATUS__MCIF_WB_BUF_1_BUFTAG__SHIFT                                            0x8
#define MCIF_WB1_MCIF_WB_BUF_1_STATUS__MCIF_WB_BUF_1_NXT_BUF__SHIFT                                           0xc
#define MCIF_WB1_MCIF_WB_BUF_1_STATUS__MCIF_WB_BUF_1_FIELD__SHIFT                                             0xf
#define MCIF_WB1_MCIF_WB_BUF_1_STATUS__MCIF_WB_BUF_1_CUR_LINE_L__SHIFT                                        0x10
#define MCIF_WB1_MCIF_WB_BUF_1_STATUS__MCIF_WB_BUF_1_LONG_LINE_ERROR__SHIFT                                   0x1d
#define MCIF_WB1_MCIF_WB_BUF_1_STATUS__MCIF_WB_BUF_1_SHORT_LINE_ERROR__SHIFT                                  0x1e
#define MCIF_WB1_MCIF_WB_BUF_1_STATUS__MCIF_WB_BUF_1_FRAME_LENGTH_ERROR__SHIFT                                0x1f
#define MCIF_WB1_MCIF_WB_BUF_1_STATUS__MCIF_WB_BUF_1_ACTIVE_MASK                                              0x00000001L
#define MCIF_WB1_MCIF_WB_BUF_1_STATUS__MCIF_WB_BUF_1_SW_LOCKED_MASK                                           0x00000002L
#define MCIF_WB1_MCIF_WB_BUF_1_STATUS__MCIF_WB_BUF_1_VCE_LOCKED_MASK                                          0x00000004L
#define MCIF_WB1_MCIF_WB_BUF_1_STATUS__MCIF_WB_BUF_1_OVERFLOW_MASK                                            0x00000008L
#define MCIF_WB1_MCIF_WB_BUF_1_STATUS__MCIF_WB_BUF_1_DISABLE_MASK                                             0x00000010L
#define MCIF_WB1_MCIF_WB_BUF_1_STATUS__MCIF_WB_BUF_1_MODE_MASK                                                0x000000E0L
#define MCIF_WB1_MCIF_WB_BUF_1_STATUS__MCIF_WB_BUF_1_BUFTAG_MASK                                              0x00000F00L
#define MCIF_WB1_MCIF_WB_BUF_1_STATUS__MCIF_WB_BUF_1_NXT_BUF_MASK                                             0x00007000L
#define MCIF_WB1_MCIF_WB_BUF_1_STATUS__MCIF_WB_BUF_1_FIELD_MASK                                               0x00008000L
#define MCIF_WB1_MCIF_WB_BUF_1_STATUS__MCIF_WB_BUF_1_CUR_LINE_L_MASK                                          0x1FFF0000L
#define MCIF_WB1_MCIF_WB_BUF_1_STATUS__MCIF_WB_BUF_1_LONG_LINE_ERROR_MASK                                     0x20000000L
#define MCIF_WB1_MCIF_WB_BUF_1_STATUS__MCIF_WB_BUF_1_SHORT_LINE_ERROR_MASK                                    0x40000000L
#define MCIF_WB1_MCIF_WB_BUF_1_STATUS__MCIF_WB_BUF_1_FRAME_LENGTH_ERROR_MASK                                  0x80000000L
//MCIF_WB1_MCIF_WB_BUF_1_STATUS2
#define MCIF_WB1_MCIF_WB_BUF_1_STATUS2__MCIF_WB_BUF_1_CUR_LINE_R__SHIFT                                       0x0
#define MCIF_WB1_MCIF_WB_BUF_1_STATUS2__MCIF_WB_BUF_1_NEW_CONTENT__SHIFT                                      0xd
#define MCIF_WB1_MCIF_WB_BUF_1_STATUS2__MCIF_WB_BUF_1_COLOR_DEPTH__SHIFT                                      0xe
#define MCIF_WB1_MCIF_WB_BUF_1_STATUS2__MCIF_WB_BUF_1_Y_OVERRUN__SHIFT                                        0x11
#define MCIF_WB1_MCIF_WB_BUF_1_STATUS2__MCIF_WB_BUF_1_C_OVERRUN__SHIFT                                        0x12
#define MCIF_WB1_MCIF_WB_BUF_1_STATUS2__MCIF_WB_BUF_1_CUR_LINE_R_MASK                                         0x00001FFFL
#define MCIF_WB1_MCIF_WB_BUF_1_STATUS2__MCIF_WB_BUF_1_NEW_CONTENT_MASK                                        0x00002000L
#define MCIF_WB1_MCIF_WB_BUF_1_STATUS2__MCIF_WB_BUF_1_COLOR_DEPTH_MASK                                        0x00004000L
#define MCIF_WB1_MCIF_WB_BUF_1_STATUS2__MCIF_WB_BUF_1_Y_OVERRUN_MASK                                          0x00020000L
#define MCIF_WB1_MCIF_WB_BUF_1_STATUS2__MCIF_WB_BUF_1_C_OVERRUN_MASK                                          0x00040000L
//MCIF_WB1_MCIF_WB_BUF_2_STATUS
#define MCIF_WB1_MCIF_WB_BUF_2_STATUS__MCIF_WB_BUF_2_ACTIVE__SHIFT                                            0x0
#define MCIF_WB1_MCIF_WB_BUF_2_STATUS__MCIF_WB_BUF_2_SW_LOCKED__SHIFT                                         0x1
#define MCIF_WB1_MCIF_WB_BUF_2_STATUS__MCIF_WB_BUF_2_VCE_LOCKED__SHIFT                                        0x2
#define MCIF_WB1_MCIF_WB_BUF_2_STATUS__MCIF_WB_BUF_2_OVERFLOW__SHIFT                                          0x3
#define MCIF_WB1_MCIF_WB_BUF_2_STATUS__MCIF_WB_BUF_2_DISABLE__SHIFT                                           0x4
#define MCIF_WB1_MCIF_WB_BUF_2_STATUS__MCIF_WB_BUF_2_MODE__SHIFT                                              0x5
#define MCIF_WB1_MCIF_WB_BUF_2_STATUS__MCIF_WB_BUF_2_BUFTAG__SHIFT                                            0x8
#define MCIF_WB1_MCIF_WB_BUF_2_STATUS__MCIF_WB_BUF_2_NXT_BUF__SHIFT                                           0xc
#define MCIF_WB1_MCIF_WB_BUF_2_STATUS__MCIF_WB_BUF_2_FIELD__SHIFT                                             0xf
#define MCIF_WB1_MCIF_WB_BUF_2_STATUS__MCIF_WB_BUF_2_CUR_LINE_L__SHIFT                                        0x10
#define MCIF_WB1_MCIF_WB_BUF_2_STATUS__MCIF_WB_BUF_2_LONG_LINE_ERROR__SHIFT                                   0x1d
#define MCIF_WB1_MCIF_WB_BUF_2_STATUS__MCIF_WB_BUF_2_SHORT_LINE_ERROR__SHIFT                                  0x1e
#define MCIF_WB1_MCIF_WB_BUF_2_STATUS__MCIF_WB_BUF_2_FRAME_LENGTH_ERROR__SHIFT                                0x1f
#define MCIF_WB1_MCIF_WB_BUF_2_STATUS__MCIF_WB_BUF_2_ACTIVE_MASK                                              0x00000001L
#define MCIF_WB1_MCIF_WB_BUF_2_STATUS__MCIF_WB_BUF_2_SW_LOCKED_MASK                                           0x00000002L
#define MCIF_WB1_MCIF_WB_BUF_2_STATUS__MCIF_WB_BUF_2_VCE_LOCKED_MASK                                          0x00000004L
#define MCIF_WB1_MCIF_WB_BUF_2_STATUS__MCIF_WB_BUF_2_OVERFLOW_MASK                                            0x00000008L
#define MCIF_WB1_MCIF_WB_BUF_2_STATUS__MCIF_WB_BUF_2_DISABLE_MASK                                             0x00000010L
#define MCIF_WB1_MCIF_WB_BUF_2_STATUS__MCIF_WB_BUF_2_MODE_MASK                                                0x000000E0L
#define MCIF_WB1_MCIF_WB_BUF_2_STATUS__MCIF_WB_BUF_2_BUFTAG_MASK                                              0x00000F00L
#define MCIF_WB1_MCIF_WB_BUF_2_STATUS__MCIF_WB_BUF_2_NXT_BUF_MASK                                             0x00007000L
#define MCIF_WB1_MCIF_WB_BUF_2_STATUS__MCIF_WB_BUF_2_FIELD_MASK                                               0x00008000L
#define MCIF_WB1_MCIF_WB_BUF_2_STATUS__MCIF_WB_BUF_2_CUR_LINE_L_MASK                                          0x1FFF0000L
#define MCIF_WB1_MCIF_WB_BUF_2_STATUS__MCIF_WB_BUF_2_LONG_LINE_ERROR_MASK                                     0x20000000L
#define MCIF_WB1_MCIF_WB_BUF_2_STATUS__MCIF_WB_BUF_2_SHORT_LINE_ERROR_MASK                                    0x40000000L
#define MCIF_WB1_MCIF_WB_BUF_2_STATUS__MCIF_WB_BUF_2_FRAME_LENGTH_ERROR_MASK                                  0x80000000L
//MCIF_WB1_MCIF_WB_BUF_2_STATUS2
#define MCIF_WB1_MCIF_WB_BUF_2_STATUS2__MCIF_WB_BUF_2_CUR_LINE_R__SHIFT                                       0x0
#define MCIF_WB1_MCIF_WB_BUF_2_STATUS2__MCIF_WB_BUF_2_NEW_CONTENT__SHIFT                                      0xd
#define MCIF_WB1_MCIF_WB_BUF_2_STATUS2__MCIF_WB_BUF_2_COLOR_DEPTH__SHIFT                                      0xe
#define MCIF_WB1_MCIF_WB_BUF_2_STATUS2__MCIF_WB_BUF_2_Y_OVERRUN__SHIFT                                        0x11
#define MCIF_WB1_MCIF_WB_BUF_2_STATUS2__MCIF_WB_BUF_2_C_OVERRUN__SHIFT                                        0x12
#define MCIF_WB1_MCIF_WB_BUF_2_STATUS2__MCIF_WB_BUF_2_CUR_LINE_R_MASK                                         0x00001FFFL
#define MCIF_WB1_MCIF_WB_BUF_2_STATUS2__MCIF_WB_BUF_2_NEW_CONTENT_MASK                                        0x00002000L
#define MCIF_WB1_MCIF_WB_BUF_2_STATUS2__MCIF_WB_BUF_2_COLOR_DEPTH_MASK                                        0x00004000L
#define MCIF_WB1_MCIF_WB_BUF_2_STATUS2__MCIF_WB_BUF_2_Y_OVERRUN_MASK                                          0x00020000L
#define MCIF_WB1_MCIF_WB_BUF_2_STATUS2__MCIF_WB_BUF_2_C_OVERRUN_MASK                                          0x00040000L
//MCIF_WB1_MCIF_WB_BUF_3_STATUS
#define MCIF_WB1_MCIF_WB_BUF_3_STATUS__MCIF_WB_BUF_3_ACTIVE__SHIFT                                            0x0
#define MCIF_WB1_MCIF_WB_BUF_3_STATUS__MCIF_WB_BUF_3_SW_LOCKED__SHIFT                                         0x1
#define MCIF_WB1_MCIF_WB_BUF_3_STATUS__MCIF_WB_BUF_3_VCE_LOCKED__SHIFT                                        0x2
#define MCIF_WB1_MCIF_WB_BUF_3_STATUS__MCIF_WB_BUF_3_OVERFLOW__SHIFT                                          0x3
#define MCIF_WB1_MCIF_WB_BUF_3_STATUS__MCIF_WB_BUF_3_DISABLE__SHIFT                                           0x4
#define MCIF_WB1_MCIF_WB_BUF_3_STATUS__MCIF_WB_BUF_3_MODE__SHIFT                                              0x5
#define MCIF_WB1_MCIF_WB_BUF_3_STATUS__MCIF_WB_BUF_3_BUFTAG__SHIFT                                            0x8
#define MCIF_WB1_MCIF_WB_BUF_3_STATUS__MCIF_WB_BUF_3_NXT_BUF__SHIFT                                           0xc
#define MCIF_WB1_MCIF_WB_BUF_3_STATUS__MCIF_WB_BUF_3_FIELD__SHIFT                                             0xf
#define MCIF_WB1_MCIF_WB_BUF_3_STATUS__MCIF_WB_BUF_3_CUR_LINE_L__SHIFT                                        0x10
#define MCIF_WB1_MCIF_WB_BUF_3_STATUS__MCIF_WB_BUF_3_LONG_LINE_ERROR__SHIFT                                   0x1d
#define MCIF_WB1_MCIF_WB_BUF_3_STATUS__MCIF_WB_BUF_3_SHORT_LINE_ERROR__SHIFT                                  0x1e
#define MCIF_WB1_MCIF_WB_BUF_3_STATUS__MCIF_WB_BUF_3_FRAME_LENGTH_ERROR__SHIFT                                0x1f
#define MCIF_WB1_MCIF_WB_BUF_3_STATUS__MCIF_WB_BUF_3_ACTIVE_MASK                                              0x00000001L
#define MCIF_WB1_MCIF_WB_BUF_3_STATUS__MCIF_WB_BUF_3_SW_LOCKED_MASK                                           0x00000002L
#define MCIF_WB1_MCIF_WB_BUF_3_STATUS__MCIF_WB_BUF_3_VCE_LOCKED_MASK                                          0x00000004L
#define MCIF_WB1_MCIF_WB_BUF_3_STATUS__MCIF_WB_BUF_3_OVERFLOW_MASK                                            0x00000008L
#define MCIF_WB1_MCIF_WB_BUF_3_STATUS__MCIF_WB_BUF_3_DISABLE_MASK                                             0x00000010L
#define MCIF_WB1_MCIF_WB_BUF_3_STATUS__MCIF_WB_BUF_3_MODE_MASK                                                0x000000E0L
#define MCIF_WB1_MCIF_WB_BUF_3_STATUS__MCIF_WB_BUF_3_BUFTAG_MASK                                              0x00000F00L
#define MCIF_WB1_MCIF_WB_BUF_3_STATUS__MCIF_WB_BUF_3_NXT_BUF_MASK                                             0x00007000L
#define MCIF_WB1_MCIF_WB_BUF_3_STATUS__MCIF_WB_BUF_3_FIELD_MASK                                               0x00008000L
#define MCIF_WB1_MCIF_WB_BUF_3_STATUS__MCIF_WB_BUF_3_CUR_LINE_L_MASK                                          0x1FFF0000L
#define MCIF_WB1_MCIF_WB_BUF_3_STATUS__MCIF_WB_BUF_3_LONG_LINE_ERROR_MASK                                     0x20000000L
#define MCIF_WB1_MCIF_WB_BUF_3_STATUS__MCIF_WB_BUF_3_SHORT_LINE_ERROR_MASK                                    0x40000000L
#define MCIF_WB1_MCIF_WB_BUF_3_STATUS__MCIF_WB_BUF_3_FRAME_LENGTH_ERROR_MASK                                  0x80000000L
//MCIF_WB1_MCIF_WB_BUF_3_STATUS2
#define MCIF_WB1_MCIF_WB_BUF_3_STATUS2__MCIF_WB_BUF_3_CUR_LINE_R__SHIFT                                       0x0
#define MCIF_WB1_MCIF_WB_BUF_3_STATUS2__MCIF_WB_BUF_3_NEW_CONTENT__SHIFT                                      0xd
#define MCIF_WB1_MCIF_WB_BUF_3_STATUS2__MCIF_WB_BUF_3_COLOR_DEPTH__SHIFT                                      0xe
#define MCIF_WB1_MCIF_WB_BUF_3_STATUS2__MCIF_WB_BUF_3_Y_OVERRUN__SHIFT                                        0x11
#define MCIF_WB1_MCIF_WB_BUF_3_STATUS2__MCIF_WB_BUF_3_C_OVERRUN__SHIFT                                        0x12
#define MCIF_WB1_MCIF_WB_BUF_3_STATUS2__MCIF_WB_BUF_3_CUR_LINE_R_MASK                                         0x00001FFFL
#define MCIF_WB1_MCIF_WB_BUF_3_STATUS2__MCIF_WB_BUF_3_NEW_CONTENT_MASK                                        0x00002000L
#define MCIF_WB1_MCIF_WB_BUF_3_STATUS2__MCIF_WB_BUF_3_COLOR_DEPTH_MASK                                        0x00004000L
#define MCIF_WB1_MCIF_WB_BUF_3_STATUS2__MCIF_WB_BUF_3_Y_OVERRUN_MASK                                          0x00020000L
#define MCIF_WB1_MCIF_WB_BUF_3_STATUS2__MCIF_WB_BUF_3_C_OVERRUN_MASK                                          0x00040000L
//MCIF_WB1_MCIF_WB_BUF_4_STATUS
#define MCIF_WB1_MCIF_WB_BUF_4_STATUS__MCIF_WB_BUF_4_ACTIVE__SHIFT                                            0x0
#define MCIF_WB1_MCIF_WB_BUF_4_STATUS__MCIF_WB_BUF_4_SW_LOCKED__SHIFT                                         0x1
#define MCIF_WB1_MCIF_WB_BUF_4_STATUS__MCIF_WB_BUF_4_VCE_LOCKED__SHIFT                                        0x2
#define MCIF_WB1_MCIF_WB_BUF_4_STATUS__MCIF_WB_BUF_4_OVERFLOW__SHIFT                                          0x3
#define MCIF_WB1_MCIF_WB_BUF_4_STATUS__MCIF_WB_BUF_4_DISABLE__SHIFT                                           0x4
#define MCIF_WB1_MCIF_WB_BUF_4_STATUS__MCIF_WB_BUF_4_MODE__SHIFT                                              0x5
#define MCIF_WB1_MCIF_WB_BUF_4_STATUS__MCIF_WB_BUF_4_BUFTAG__SHIFT                                            0x8
#define MCIF_WB1_MCIF_WB_BUF_4_STATUS__MCIF_WB_BUF_4_NXT_BUF__SHIFT                                           0xc
#define MCIF_WB1_MCIF_WB_BUF_4_STATUS__MCIF_WB_BUF_4_FIELD__SHIFT                                             0xf
#define MCIF_WB1_MCIF_WB_BUF_4_STATUS__MCIF_WB_BUF_4_CUR_LINE_L__SHIFT                                        0x10
#define MCIF_WB1_MCIF_WB_BUF_4_STATUS__MCIF_WB_BUF_4_LONG_LINE_ERROR__SHIFT                                   0x1d
#define MCIF_WB1_MCIF_WB_BUF_4_STATUS__MCIF_WB_BUF_4_SHORT_LINE_ERROR__SHIFT                                  0x1e
#define MCIF_WB1_MCIF_WB_BUF_4_STATUS__MCIF_WB_BUF_4_FRAME_LENGTH_ERROR__SHIFT                                0x1f
#define MCIF_WB1_MCIF_WB_BUF_4_STATUS__MCIF_WB_BUF_4_ACTIVE_MASK                                              0x00000001L
#define MCIF_WB1_MCIF_WB_BUF_4_STATUS__MCIF_WB_BUF_4_SW_LOCKED_MASK                                           0x00000002L
#define MCIF_WB1_MCIF_WB_BUF_4_STATUS__MCIF_WB_BUF_4_VCE_LOCKED_MASK                                          0x00000004L
#define MCIF_WB1_MCIF_WB_BUF_4_STATUS__MCIF_WB_BUF_4_OVERFLOW_MASK                                            0x00000008L
#define MCIF_WB1_MCIF_WB_BUF_4_STATUS__MCIF_WB_BUF_4_DISABLE_MASK                                             0x00000010L
#define MCIF_WB1_MCIF_WB_BUF_4_STATUS__MCIF_WB_BUF_4_MODE_MASK                                                0x000000E0L
#define MCIF_WB1_MCIF_WB_BUF_4_STATUS__MCIF_WB_BUF_4_BUFTAG_MASK                                              0x00000F00L
#define MCIF_WB1_MCIF_WB_BUF_4_STATUS__MCIF_WB_BUF_4_NXT_BUF_MASK                                             0x00007000L
#define MCIF_WB1_MCIF_WB_BUF_4_STATUS__MCIF_WB_BUF_4_FIELD_MASK                                               0x00008000L
#define MCIF_WB1_MCIF_WB_BUF_4_STATUS__MCIF_WB_BUF_4_CUR_LINE_L_MASK                                          0x1FFF0000L
#define MCIF_WB1_MCIF_WB_BUF_4_STATUS__MCIF_WB_BUF_4_LONG_LINE_ERROR_MASK                                     0x20000000L
#define MCIF_WB1_MCIF_WB_BUF_4_STATUS__MCIF_WB_BUF_4_SHORT_LINE_ERROR_MASK                                    0x40000000L
#define MCIF_WB1_MCIF_WB_BUF_4_STATUS__MCIF_WB_BUF_4_FRAME_LENGTH_ERROR_MASK                                  0x80000000L
//MCIF_WB1_MCIF_WB_BUF_4_STATUS2
#define MCIF_WB1_MCIF_WB_BUF_4_STATUS2__MCIF_WB_BUF_4_CUR_LINE_R__SHIFT                                       0x0
#define MCIF_WB1_MCIF_WB_BUF_4_STATUS2__MCIF_WB_BUF_4_NEW_CONTENT__SHIFT                                      0xd
#define MCIF_WB1_MCIF_WB_BUF_4_STATUS2__MCIF_WB_BUF_4_COLOR_DEPTH__SHIFT                                      0xe
#define MCIF_WB1_MCIF_WB_BUF_4_STATUS2__MCIF_WB_BUF_4_Y_OVERRUN__SHIFT                                        0x11
#define MCIF_WB1_MCIF_WB_BUF_4_STATUS2__MCIF_WB_BUF_4_C_OVERRUN__SHIFT                                        0x12
#define MCIF_WB1_MCIF_WB_BUF_4_STATUS2__MCIF_WB_BUF_4_CUR_LINE_R_MASK                                         0x00001FFFL
#define MCIF_WB1_MCIF_WB_BUF_4_STATUS2__MCIF_WB_BUF_4_NEW_CONTENT_MASK                                        0x00002000L
#define MCIF_WB1_MCIF_WB_BUF_4_STATUS2__MCIF_WB_BUF_4_COLOR_DEPTH_MASK                                        0x00004000L
#define MCIF_WB1_MCIF_WB_BUF_4_STATUS2__MCIF_WB_BUF_4_Y_OVERRUN_MASK                                          0x00020000L
#define MCIF_WB1_MCIF_WB_BUF_4_STATUS2__MCIF_WB_BUF_4_C_OVERRUN_MASK                                          0x00040000L
//MCIF_WB1_MCIF_WB_ARBITRATION_CONTROL
#define MCIF_WB1_MCIF_WB_ARBITRATION_CONTROL__MCIF_WB_CLIENT_ARBITRATION_SLICE__SHIFT                         0x0
#define MCIF_WB1_MCIF_WB_ARBITRATION_CONTROL__MCIF_WB_TIME_PER_PIXEL__SHIFT                                   0x16
#define MCIF_WB1_MCIF_WB_ARBITRATION_CONTROL__MCIF_WB_CLIENT_ARBITRATION_SLICE_MASK                           0x00000003L
#define MCIF_WB1_MCIF_WB_ARBITRATION_CONTROL__MCIF_WB_TIME_PER_PIXEL_MASK                                     0xFFC00000L
//MCIF_WB1_MCIF_WB_SCLK_CHANGE
#define MCIF_WB1_MCIF_WB_SCLK_CHANGE__WM_CHANGE_ACK_FORCE_ON__SHIFT                                           0x0
#define MCIF_WB1_MCIF_WB_SCLK_CHANGE__MCIF_WB_CLI_WATERMARK_MASK__SHIFT                                       0x1
#define MCIF_WB1_MCIF_WB_SCLK_CHANGE__WM_CHANGE_ACK_FORCE_ON_MASK                                             0x00000001L
#define MCIF_WB1_MCIF_WB_SCLK_CHANGE__MCIF_WB_CLI_WATERMARK_MASK_MASK                                         0x0000000EL
//MCIF_WB1_MCIF_WB_BUF_1_ADDR_Y
#define MCIF_WB1_MCIF_WB_BUF_1_ADDR_Y__MCIF_WB_BUF_1_ADDR_Y__SHIFT                                            0x0
#define MCIF_WB1_MCIF_WB_BUF_1_ADDR_Y__MCIF_WB_BUF_1_ADDR_Y_MASK                                              0xFFFFFFFFL
//MCIF_WB1_MCIF_WB_BUF_1_ADDR_Y_OFFSET
#define MCIF_WB1_MCIF_WB_BUF_1_ADDR_Y_OFFSET__MCIF_WB_BUF_1_ADDR_Y_OFFSET__SHIFT                              0x0
#define MCIF_WB1_MCIF_WB_BUF_1_ADDR_Y_OFFSET__MCIF_WB_BUF_1_ADDR_Y_OFFSET_MASK                                0x0003FFFFL
//MCIF_WB1_MCIF_WB_BUF_1_ADDR_C
#define MCIF_WB1_MCIF_WB_BUF_1_ADDR_C__MCIF_WB_BUF_1_ADDR_C__SHIFT                                            0x0
#define MCIF_WB1_MCIF_WB_BUF_1_ADDR_C__MCIF_WB_BUF_1_ADDR_C_MASK                                              0xFFFFFFFFL
//MCIF_WB1_MCIF_WB_BUF_1_ADDR_C_OFFSET
#define MCIF_WB1_MCIF_WB_BUF_1_ADDR_C_OFFSET__MCIF_WB_BUF_1_ADDR_C_OFFSET__SHIFT                              0x0
#define MCIF_WB1_MCIF_WB_BUF_1_ADDR_C_OFFSET__MCIF_WB_BUF_1_ADDR_C_OFFSET_MASK                                0x0003FFFFL
//MCIF_WB1_MCIF_WB_BUF_2_ADDR_Y
#define MCIF_WB1_MCIF_WB_BUF_2_ADDR_Y__MCIF_WB_BUF_2_ADDR_Y__SHIFT                                            0x0
#define MCIF_WB1_MCIF_WB_BUF_2_ADDR_Y__MCIF_WB_BUF_2_ADDR_Y_MASK                                              0xFFFFFFFFL
//MCIF_WB1_MCIF_WB_BUF_2_ADDR_Y_OFFSET
#define MCIF_WB1_MCIF_WB_BUF_2_ADDR_Y_OFFSET__MCIF_WB_BUF_2_ADDR_Y_OFFSET__SHIFT                              0x0
#define MCIF_WB1_MCIF_WB_BUF_2_ADDR_Y_OFFSET__MCIF_WB_BUF_2_ADDR_Y_OFFSET_MASK                                0x0003FFFFL
//MCIF_WB1_MCIF_WB_BUF_2_ADDR_C
#define MCIF_WB1_MCIF_WB_BUF_2_ADDR_C__MCIF_WB_BUF_2_ADDR_C__SHIFT                                            0x0
#define MCIF_WB1_MCIF_WB_BUF_2_ADDR_C__MCIF_WB_BUF_2_ADDR_C_MASK                                              0xFFFFFFFFL
//MCIF_WB1_MCIF_WB_BUF_2_ADDR_C_OFFSET
#define MCIF_WB1_MCIF_WB_BUF_2_ADDR_C_OFFSET__MCIF_WB_BUF_2_ADDR_C_OFFSET__SHIFT                              0x0
#define MCIF_WB1_MCIF_WB_BUF_2_ADDR_C_OFFSET__MCIF_WB_BUF_2_ADDR_C_OFFSET_MASK                                0x0003FFFFL
//MCIF_WB1_MCIF_WB_BUF_3_ADDR_Y
#define MCIF_WB1_MCIF_WB_BUF_3_ADDR_Y__MCIF_WB_BUF_3_ADDR_Y__SHIFT                                            0x0
#define MCIF_WB1_MCIF_WB_BUF_3_ADDR_Y__MCIF_WB_BUF_3_ADDR_Y_MASK                                              0xFFFFFFFFL
//MCIF_WB1_MCIF_WB_BUF_3_ADDR_Y_OFFSET
#define MCIF_WB1_MCIF_WB_BUF_3_ADDR_Y_OFFSET__MCIF_WB_BUF_3_ADDR_Y_OFFSET__SHIFT                              0x0
#define MCIF_WB1_MCIF_WB_BUF_3_ADDR_Y_OFFSET__MCIF_WB_BUF_3_ADDR_Y_OFFSET_MASK                                0x0003FFFFL
//MCIF_WB1_MCIF_WB_BUF_3_ADDR_C
#define MCIF_WB1_MCIF_WB_BUF_3_ADDR_C__MCIF_WB_BUF_3_ADDR_C__SHIFT                                            0x0
#define MCIF_WB1_MCIF_WB_BUF_3_ADDR_C__MCIF_WB_BUF_3_ADDR_C_MASK                                              0xFFFFFFFFL
//MCIF_WB1_MCIF_WB_BUF_3_ADDR_C_OFFSET
#define MCIF_WB1_MCIF_WB_BUF_3_ADDR_C_OFFSET__MCIF_WB_BUF_3_ADDR_C_OFFSET__SHIFT                              0x0
#define MCIF_WB1_MCIF_WB_BUF_3_ADDR_C_OFFSET__MCIF_WB_BUF_3_ADDR_C_OFFSET_MASK                                0x0003FFFFL
//MCIF_WB1_MCIF_WB_BUF_4_ADDR_Y
#define MCIF_WB1_MCIF_WB_BUF_4_ADDR_Y__MCIF_WB_BUF_4_ADDR_Y__SHIFT                                            0x0
#define MCIF_WB1_MCIF_WB_BUF_4_ADDR_Y__MCIF_WB_BUF_4_ADDR_Y_MASK                                              0xFFFFFFFFL
//MCIF_WB1_MCIF_WB_BUF_4_ADDR_Y_OFFSET
#define MCIF_WB1_MCIF_WB_BUF_4_ADDR_Y_OFFSET__MCIF_WB_BUF_4_ADDR_Y_OFFSET__SHIFT                              0x0
#define MCIF_WB1_MCIF_WB_BUF_4_ADDR_Y_OFFSET__MCIF_WB_BUF_4_ADDR_Y_OFFSET_MASK                                0x0003FFFFL
//MCIF_WB1_MCIF_WB_BUF_4_ADDR_C
#define MCIF_WB1_MCIF_WB_BUF_4_ADDR_C__MCIF_WB_BUF_4_ADDR_C__SHIFT                                            0x0
#define MCIF_WB1_MCIF_WB_BUF_4_ADDR_C__MCIF_WB_BUF_4_ADDR_C_MASK                                              0xFFFFFFFFL
//MCIF_WB1_MCIF_WB_BUF_4_ADDR_C_OFFSET
#define MCIF_WB1_MCIF_WB_BUF_4_ADDR_C_OFFSET__MCIF_WB_BUF_4_ADDR_C_OFFSET__SHIFT                              0x0
#define MCIF_WB1_MCIF_WB_BUF_4_ADDR_C_OFFSET__MCIF_WB_BUF_4_ADDR_C_OFFSET_MASK                                0x0003FFFFL
//MCIF_WB1_MCIF_WB_BUFMGR_VCE_CONTROL
#define MCIF_WB1_MCIF_WB_BUFMGR_VCE_CONTROL__MCIF_WB_BUFMGR_VCE_LOCK_IGNORE__SHIFT                            0x0
#define MCIF_WB1_MCIF_WB_BUFMGR_VCE_CONTROL__MCIF_WB_BUFMGR_VCE_INT_EN__SHIFT                                 0x4
#define MCIF_WB1_MCIF_WB_BUFMGR_VCE_CONTROL__MCIF_WB_BUFMGR_VCE_INT_ACK__SHIFT                                0x5
#define MCIF_WB1_MCIF_WB_BUFMGR_VCE_CONTROL__MCIF_WB_BUFMGR_VCE_SLICE_INT_EN__SHIFT                           0x6
#define MCIF_WB1_MCIF_WB_BUFMGR_VCE_CONTROL__MCIF_WB_BUFMGR_VCE_LOCK__SHIFT                                   0x8
#define MCIF_WB1_MCIF_WB_BUFMGR_VCE_CONTROL__MCIF_WB_BUFMGR_SLICE_SIZE__SHIFT                                 0x10
#define MCIF_WB1_MCIF_WB_BUFMGR_VCE_CONTROL__MCIF_WB_BUFMGR_VCE_LOCK_IGNORE_MASK                              0x00000001L
#define MCIF_WB1_MCIF_WB_BUFMGR_VCE_CONTROL__MCIF_WB_BUFMGR_VCE_INT_EN_MASK                                   0x00000010L
#define MCIF_WB1_MCIF_WB_BUFMGR_VCE_CONTROL__MCIF_WB_BUFMGR_VCE_INT_ACK_MASK                                  0x00000020L
#define MCIF_WB1_MCIF_WB_BUFMGR_VCE_CONTROL__MCIF_WB_BUFMGR_VCE_SLICE_INT_EN_MASK                             0x00000040L
#define MCIF_WB1_MCIF_WB_BUFMGR_VCE_CONTROL__MCIF_WB_BUFMGR_VCE_LOCK_MASK                                     0x00000F00L
#define MCIF_WB1_MCIF_WB_BUFMGR_VCE_CONTROL__MCIF_WB_BUFMGR_SLICE_SIZE_MASK                                   0x1FFF0000L
//MCIF_WB1_MCIF_WB_NB_PSTATE_LATENCY_WATERMARK
#define MCIF_WB1_MCIF_WB_NB_PSTATE_LATENCY_WATERMARK__NB_PSTATE_CHANGE_REFRESH_WATERMARK__SHIFT               0x0
#define MCIF_WB1_MCIF_WB_NB_PSTATE_LATENCY_WATERMARK__NB_PSTATE_CHANGE_REFRESH_WATERMARK_MASK                 0x0001FFFFL
//MCIF_WB1_MCIF_WB_NB_PSTATE_CONTROL
#define MCIF_WB1_MCIF_WB_NB_PSTATE_CONTROL__NB_PSTATE_CHANGE_URGENT_DURING_REQUEST__SHIFT                     0x0
#define MCIF_WB1_MCIF_WB_NB_PSTATE_CONTROL__NB_PSTATE_CHANGE_FORCE_ON__SHIFT                                  0x1
#define MCIF_WB1_MCIF_WB_NB_PSTATE_CONTROL__NB_PSTATE_ALLOW_FOR_URGENT__SHIFT                                 0x2
#define MCIF_WB1_MCIF_WB_NB_PSTATE_CONTROL__NB_PSTATE_CHANGE_WATERMARK_MASK__SHIFT                            0x4
#define MCIF_WB1_MCIF_WB_NB_PSTATE_CONTROL__NB_PSTATE_CHANGE_URGENT_DURING_REQUEST_MASK                       0x00000001L
#define MCIF_WB1_MCIF_WB_NB_PSTATE_CONTROL__NB_PSTATE_CHANGE_FORCE_ON_MASK                                    0x00000002L
#define MCIF_WB1_MCIF_WB_NB_PSTATE_CONTROL__NB_PSTATE_ALLOW_FOR_URGENT_MASK                                   0x00000004L
#define MCIF_WB1_MCIF_WB_NB_PSTATE_CONTROL__NB_PSTATE_CHANGE_WATERMARK_MASK_MASK                              0x00000070L
//MCIF_WB1_MCIF_WB_WATERMARK
#define MCIF_WB1_MCIF_WB_WATERMARK__MCIF_WB_CLI_WATERMARK__SHIFT                                              0x0
#define MCIF_WB1_MCIF_WB_WATERMARK__MCIF_WB_CLI_WATERMARK_MASK                                                0x0000FFFFL
//MCIF_WB1_MCIF_WB_CLOCK_GATER_CONTROL
#define MCIF_WB1_MCIF_WB_CLOCK_GATER_CONTROL__MCIF_WB_CLI_CLOCK_GATER_OVERRIDE__SHIFT                         0x0
#define MCIF_WB1_MCIF_WB_CLOCK_GATER_CONTROL__MCIF_WB_CLI_CLOCK_GATER_OVERRIDE_MASK                           0x00000001L
//MCIF_WB1_MCIF_WB_WARM_UP_CNTL
#define MCIF_WB1_MCIF_WB_WARM_UP_CNTL__MCIF_WB_PITCH_SIZE_WARMUP__SHIFT                                       0x8
#define MCIF_WB1_MCIF_WB_WARM_UP_CNTL__MCIF_WB_PITCH_SIZE_WARMUP_MASK                                         0x0000FF00L
//MCIF_WB1_MCIF_WB_SELF_REFRESH_CONTROL
#define MCIF_WB1_MCIF_WB_SELF_REFRESH_CONTROL__DIS_REFRESH_UNDER_NBPREQ__SHIFT                                0x0
#define MCIF_WB1_MCIF_WB_SELF_REFRESH_CONTROL__PERFRAME_SELF_REFRESH__SHIFT                                   0x1
#define MCIF_WB1_MCIF_WB_SELF_REFRESH_CONTROL__DIS_REFRESH_UNDER_NBPREQ_MASK                                  0x00000001L
#define MCIF_WB1_MCIF_WB_SELF_REFRESH_CONTROL__PERFRAME_SELF_REFRESH_MASK                                     0x00000002L
//MCIF_WB1_MULTI_LEVEL_QOS_CTRL
#define MCIF_WB1_MULTI_LEVEL_QOS_CTRL__MAX_SCALED_TIME_TO_URGENT__SHIFT                                       0x0
#define MCIF_WB1_MULTI_LEVEL_QOS_CTRL__MAX_SCALED_TIME_TO_URGENT_MASK                                         0x003FFFFFL
//MCIF_WB1_MCIF_WB_BUF_LUMA_SIZE
#define MCIF_WB1_MCIF_WB_BUF_LUMA_SIZE__MCIF_WB_BUF_LUMA_SIZE__SHIFT                                          0x0
#define MCIF_WB1_MCIF_WB_BUF_LUMA_SIZE__MCIF_WB_BUF_LUMA_SIZE_MASK                                            0x000FFFFFL
//MCIF_WB1_MCIF_WB_BUF_CHROMA_SIZE
#define MCIF_WB1_MCIF_WB_BUF_CHROMA_SIZE__MCIF_WB_BUF_CHROMA_SIZE__SHIFT                                      0x0
#define MCIF_WB1_MCIF_WB_BUF_CHROMA_SIZE__MCIF_WB_BUF_CHROMA_SIZE_MASK                                        0x000FFFFFL


// addressBlock: dce_dc_mcif_wb2_dispdec
//MCIF_WB2_MCIF_WB_BUFMGR_SW_CONTROL
#define MCIF_WB2_MCIF_WB_BUFMGR_SW_CONTROL__MCIF_WB_BUFMGR_ENABLE__SHIFT                                      0x0
#define MCIF_WB2_MCIF_WB_BUFMGR_SW_CONTROL__MCIF_WB_BUF_DUALSIZE_REQ__SHIFT                                   0x1
#define MCIF_WB2_MCIF_WB_BUFMGR_SW_CONTROL__MCIF_WB_BUFMGR_SW_INT_EN__SHIFT                                   0x4
#define MCIF_WB2_MCIF_WB_BUFMGR_SW_CONTROL__MCIF_WB_BUFMGR_SW_INT_ACK__SHIFT                                  0x5
#define MCIF_WB2_MCIF_WB_BUFMGR_SW_CONTROL__MCIF_WB_BUFMGR_SW_SLICE_INT_EN__SHIFT                             0x6
#define MCIF_WB2_MCIF_WB_BUFMGR_SW_CONTROL__MCIF_WB_BUFMGR_SW_OVERRUN_INT_EN__SHIFT                           0x7
#define MCIF_WB2_MCIF_WB_BUFMGR_SW_CONTROL__MCIF_WB_BUFMGR_SW_LOCK__SHIFT                                     0x8
#define MCIF_WB2_MCIF_WB_BUFMGR_SW_CONTROL__MCIF_WB_P_VMID__SHIFT                                             0x10
#define MCIF_WB2_MCIF_WB_BUFMGR_SW_CONTROL__MCIF_WB_BUF_ADDR_FENCE_EN__SHIFT                                  0x18
#define MCIF_WB2_MCIF_WB_BUFMGR_SW_CONTROL__MCIF_WB_BUFMGR_ENABLE_MASK                                        0x00000001L
#define MCIF_WB2_MCIF_WB_BUFMGR_SW_CONTROL__MCIF_WB_BUF_DUALSIZE_REQ_MASK                                     0x00000002L
#define MCIF_WB2_MCIF_WB_BUFMGR_SW_CONTROL__MCIF_WB_BUFMGR_SW_INT_EN_MASK                                     0x00000010L
#define MCIF_WB2_MCIF_WB_BUFMGR_SW_CONTROL__MCIF_WB_BUFMGR_SW_INT_ACK_MASK                                    0x00000020L
#define MCIF_WB2_MCIF_WB_BUFMGR_SW_CONTROL__MCIF_WB_BUFMGR_SW_SLICE_INT_EN_MASK                               0x00000040L
#define MCIF_WB2_MCIF_WB_BUFMGR_SW_CONTROL__MCIF_WB_BUFMGR_SW_OVERRUN_INT_EN_MASK                             0x00000080L
#define MCIF_WB2_MCIF_WB_BUFMGR_SW_CONTROL__MCIF_WB_BUFMGR_SW_LOCK_MASK                                       0x00000F00L
#define MCIF_WB2_MCIF_WB_BUFMGR_SW_CONTROL__MCIF_WB_P_VMID_MASK                                               0x000F0000L
#define MCIF_WB2_MCIF_WB_BUFMGR_SW_CONTROL__MCIF_WB_BUF_ADDR_FENCE_EN_MASK                                    0x01000000L
//MCIF_WB2_MCIF_WB_BUFMGR_CUR_LINE_R
#define MCIF_WB2_MCIF_WB_BUFMGR_CUR_LINE_R__MCIF_WB_BUFMGR_CUR_LINE_R__SHIFT                                  0x0
#define MCIF_WB2_MCIF_WB_BUFMGR_CUR_LINE_R__MCIF_WB_BUFMGR_CUR_LINE_R_MASK                                    0x00001FFFL
//MCIF_WB2_MCIF_WB_BUFMGR_STATUS
#define MCIF_WB2_MCIF_WB_BUFMGR_STATUS__MCIF_WB_BUFMGR_VCE_INT_STATUS__SHIFT                                  0x0
#define MCIF_WB2_MCIF_WB_BUFMGR_STATUS__MCIF_WB_BUFMGR_SW_INT_STATUS__SHIFT                                   0x1
#define MCIF_WB2_MCIF_WB_BUFMGR_STATUS__MCIF_WB_BUFMGR_SW_OVERRUN_INT_STATUS__SHIFT                           0x2
#define MCIF_WB2_MCIF_WB_BUFMGR_STATUS__MCIF_WB_BUFMGR_CUR_BUF__SHIFT                                         0x4
#define MCIF_WB2_MCIF_WB_BUFMGR_STATUS__MCIF_WB_BUF_DUALSIZE_STATUS__SHIFT                                    0x7
#define MCIF_WB2_MCIF_WB_BUFMGR_STATUS__MCIF_WB_BUFMGR_BUFTAG__SHIFT                                          0x8
#define MCIF_WB2_MCIF_WB_BUFMGR_STATUS__MCIF_WB_BUFMGR_CUR_LINE_L__SHIFT                                      0xc
#define MCIF_WB2_MCIF_WB_BUFMGR_STATUS__MCIF_WB_BUFMGR_NEXT_BUF__SHIFT                                        0x1c
#define MCIF_WB2_MCIF_WB_BUFMGR_STATUS__MCIF_WB_BUFMGR_VCE_INT_STATUS_MASK                                    0x00000001L
#define MCIF_WB2_MCIF_WB_BUFMGR_STATUS__MCIF_WB_BUFMGR_SW_INT_STATUS_MASK                                     0x00000002L
#define MCIF_WB2_MCIF_WB_BUFMGR_STATUS__MCIF_WB_BUFMGR_SW_OVERRUN_INT_STATUS_MASK                             0x00000004L
#define MCIF_WB2_MCIF_WB_BUFMGR_STATUS__MCIF_WB_BUFMGR_CUR_BUF_MASK                                           0x00000070L
#define MCIF_WB2_MCIF_WB_BUFMGR_STATUS__MCIF_WB_BUF_DUALSIZE_STATUS_MASK                                      0x00000080L
#define MCIF_WB2_MCIF_WB_BUFMGR_STATUS__MCIF_WB_BUFMGR_BUFTAG_MASK                                            0x00000F00L
#define MCIF_WB2_MCIF_WB_BUFMGR_STATUS__MCIF_WB_BUFMGR_CUR_LINE_L_MASK                                        0x01FFF000L
#define MCIF_WB2_MCIF_WB_BUFMGR_STATUS__MCIF_WB_BUFMGR_NEXT_BUF_MASK                                          0x70000000L
//MCIF_WB2_MCIF_WB_BUF_PITCH
#define MCIF_WB2_MCIF_WB_BUF_PITCH__MCIF_WB_BUF_LUMA_PITCH__SHIFT                                             0x8
#define MCIF_WB2_MCIF_WB_BUF_PITCH__MCIF_WB_BUF_CHROMA_PITCH__SHIFT                                           0x18
#define MCIF_WB2_MCIF_WB_BUF_PITCH__MCIF_WB_BUF_LUMA_PITCH_MASK                                               0x0000FF00L
#define MCIF_WB2_MCIF_WB_BUF_PITCH__MCIF_WB_BUF_CHROMA_PITCH_MASK                                             0xFF000000L
//MCIF_WB2_MCIF_WB_BUF_1_STATUS
#define MCIF_WB2_MCIF_WB_BUF_1_STATUS__MCIF_WB_BUF_1_ACTIVE__SHIFT                                            0x0
#define MCIF_WB2_MCIF_WB_BUF_1_STATUS__MCIF_WB_BUF_1_SW_LOCKED__SHIFT                                         0x1
#define MCIF_WB2_MCIF_WB_BUF_1_STATUS__MCIF_WB_BUF_1_VCE_LOCKED__SHIFT                                        0x2
#define MCIF_WB2_MCIF_WB_BUF_1_STATUS__MCIF_WB_BUF_1_OVERFLOW__SHIFT                                          0x3
#define MCIF_WB2_MCIF_WB_BUF_1_STATUS__MCIF_WB_BUF_1_DISABLE__SHIFT                                           0x4
#define MCIF_WB2_MCIF_WB_BUF_1_STATUS__MCIF_WB_BUF_1_MODE__SHIFT                                              0x5
#define MCIF_WB2_MCIF_WB_BUF_1_STATUS__MCIF_WB_BUF_1_BUFTAG__SHIFT                                            0x8
#define MCIF_WB2_MCIF_WB_BUF_1_STATUS__MCIF_WB_BUF_1_NXT_BUF__SHIFT                                           0xc
#define MCIF_WB2_MCIF_WB_BUF_1_STATUS__MCIF_WB_BUF_1_FIELD__SHIFT                                             0xf
#define MCIF_WB2_MCIF_WB_BUF_1_STATUS__MCIF_WB_BUF_1_CUR_LINE_L__SHIFT                                        0x10
#define MCIF_WB2_MCIF_WB_BUF_1_STATUS__MCIF_WB_BUF_1_LONG_LINE_ERROR__SHIFT                                   0x1d
#define MCIF_WB2_MCIF_WB_BUF_1_STATUS__MCIF_WB_BUF_1_SHORT_LINE_ERROR__SHIFT                                  0x1e
#define MCIF_WB2_MCIF_WB_BUF_1_STATUS__MCIF_WB_BUF_1_FRAME_LENGTH_ERROR__SHIFT                                0x1f
#define MCIF_WB2_MCIF_WB_BUF_1_STATUS__MCIF_WB_BUF_1_ACTIVE_MASK                                              0x00000001L
#define MCIF_WB2_MCIF_WB_BUF_1_STATUS__MCIF_WB_BUF_1_SW_LOCKED_MASK                                           0x00000002L
#define MCIF_WB2_MCIF_WB_BUF_1_STATUS__MCIF_WB_BUF_1_VCE_LOCKED_MASK                                          0x00000004L
#define MCIF_WB2_MCIF_WB_BUF_1_STATUS__MCIF_WB_BUF_1_OVERFLOW_MASK                                            0x00000008L
#define MCIF_WB2_MCIF_WB_BUF_1_STATUS__MCIF_WB_BUF_1_DISABLE_MASK                                             0x00000010L
#define MCIF_WB2_MCIF_WB_BUF_1_STATUS__MCIF_WB_BUF_1_MODE_MASK                                                0x000000E0L
#define MCIF_WB2_MCIF_WB_BUF_1_STATUS__MCIF_WB_BUF_1_BUFTAG_MASK                                              0x00000F00L
#define MCIF_WB2_MCIF_WB_BUF_1_STATUS__MCIF_WB_BUF_1_NXT_BUF_MASK                                             0x00007000L
#define MCIF_WB2_MCIF_WB_BUF_1_STATUS__MCIF_WB_BUF_1_FIELD_MASK                                               0x00008000L
#define MCIF_WB2_MCIF_WB_BUF_1_STATUS__MCIF_WB_BUF_1_CUR_LINE_L_MASK                                          0x1FFF0000L
#define MCIF_WB2_MCIF_WB_BUF_1_STATUS__MCIF_WB_BUF_1_LONG_LINE_ERROR_MASK                                     0x20000000L
#define MCIF_WB2_MCIF_WB_BUF_1_STATUS__MCIF_WB_BUF_1_SHORT_LINE_ERROR_MASK                                    0x40000000L
#define MCIF_WB2_MCIF_WB_BUF_1_STATUS__MCIF_WB_BUF_1_FRAME_LENGTH_ERROR_MASK                                  0x80000000L
//MCIF_WB2_MCIF_WB_BUF_1_STATUS2
#define MCIF_WB2_MCIF_WB_BUF_1_STATUS2__MCIF_WB_BUF_1_CUR_LINE_R__SHIFT                                       0x0
#define MCIF_WB2_MCIF_WB_BUF_1_STATUS2__MCIF_WB_BUF_1_NEW_CONTENT__SHIFT                                      0xd
#define MCIF_WB2_MCIF_WB_BUF_1_STATUS2__MCIF_WB_BUF_1_COLOR_DEPTH__SHIFT                                      0xe
#define MCIF_WB2_MCIF_WB_BUF_1_STATUS2__MCIF_WB_BUF_1_Y_OVERRUN__SHIFT                                        0x11
#define MCIF_WB2_MCIF_WB_BUF_1_STATUS2__MCIF_WB_BUF_1_C_OVERRUN__SHIFT                                        0x12
#define MCIF_WB2_MCIF_WB_BUF_1_STATUS2__MCIF_WB_BUF_1_CUR_LINE_R_MASK                                         0x00001FFFL
#define MCIF_WB2_MCIF_WB_BUF_1_STATUS2__MCIF_WB_BUF_1_NEW_CONTENT_MASK                                        0x00002000L
#define MCIF_WB2_MCIF_WB_BUF_1_STATUS2__MCIF_WB_BUF_1_COLOR_DEPTH_MASK                                        0x00004000L
#define MCIF_WB2_MCIF_WB_BUF_1_STATUS2__MCIF_WB_BUF_1_Y_OVERRUN_MASK                                          0x00020000L
#define MCIF_WB2_MCIF_WB_BUF_1_STATUS2__MCIF_WB_BUF_1_C_OVERRUN_MASK                                          0x00040000L
//MCIF_WB2_MCIF_WB_BUF_2_STATUS
#define MCIF_WB2_MCIF_WB_BUF_2_STATUS__MCIF_WB_BUF_2_ACTIVE__SHIFT                                            0x0
#define MCIF_WB2_MCIF_WB_BUF_2_STATUS__MCIF_WB_BUF_2_SW_LOCKED__SHIFT                                         0x1
#define MCIF_WB2_MCIF_WB_BUF_2_STATUS__MCIF_WB_BUF_2_VCE_LOCKED__SHIFT                                        0x2
#define MCIF_WB2_MCIF_WB_BUF_2_STATUS__MCIF_WB_BUF_2_OVERFLOW__SHIFT                                          0x3
#define MCIF_WB2_MCIF_WB_BUF_2_STATUS__MCIF_WB_BUF_2_DISABLE__SHIFT                                           0x4
#define MCIF_WB2_MCIF_WB_BUF_2_STATUS__MCIF_WB_BUF_2_MODE__SHIFT                                              0x5
#define MCIF_WB2_MCIF_WB_BUF_2_STATUS__MCIF_WB_BUF_2_BUFTAG__SHIFT                                            0x8
#define MCIF_WB2_MCIF_WB_BUF_2_STATUS__MCIF_WB_BUF_2_NXT_BUF__SHIFT                                           0xc
#define MCIF_WB2_MCIF_WB_BUF_2_STATUS__MCIF_WB_BUF_2_FIELD__SHIFT                                             0xf
#define MCIF_WB2_MCIF_WB_BUF_2_STATUS__MCIF_WB_BUF_2_CUR_LINE_L__SHIFT                                        0x10
#define MCIF_WB2_MCIF_WB_BUF_2_STATUS__MCIF_WB_BUF_2_LONG_LINE_ERROR__SHIFT                                   0x1d
#define MCIF_WB2_MCIF_WB_BUF_2_STATUS__MCIF_WB_BUF_2_SHORT_LINE_ERROR__SHIFT                                  0x1e
#define MCIF_WB2_MCIF_WB_BUF_2_STATUS__MCIF_WB_BUF_2_FRAME_LENGTH_ERROR__SHIFT                                0x1f
#define MCIF_WB2_MCIF_WB_BUF_2_STATUS__MCIF_WB_BUF_2_ACTIVE_MASK                                              0x00000001L
#define MCIF_WB2_MCIF_WB_BUF_2_STATUS__MCIF_WB_BUF_2_SW_LOCKED_MASK                                           0x00000002L
#define MCIF_WB2_MCIF_WB_BUF_2_STATUS__MCIF_WB_BUF_2_VCE_LOCKED_MASK                                          0x00000004L
#define MCIF_WB2_MCIF_WB_BUF_2_STATUS__MCIF_WB_BUF_2_OVERFLOW_MASK                                            0x00000008L
#define MCIF_WB2_MCIF_WB_BUF_2_STATUS__MCIF_WB_BUF_2_DISABLE_MASK                                             0x00000010L
#define MCIF_WB2_MCIF_WB_BUF_2_STATUS__MCIF_WB_BUF_2_MODE_MASK                                                0x000000E0L
#define MCIF_WB2_MCIF_WB_BUF_2_STATUS__MCIF_WB_BUF_2_BUFTAG_MASK                                              0x00000F00L
#define MCIF_WB2_MCIF_WB_BUF_2_STATUS__MCIF_WB_BUF_2_NXT_BUF_MASK                                             0x00007000L
#define MCIF_WB2_MCIF_WB_BUF_2_STATUS__MCIF_WB_BUF_2_FIELD_MASK                                               0x00008000L
#define MCIF_WB2_MCIF_WB_BUF_2_STATUS__MCIF_WB_BUF_2_CUR_LINE_L_MASK                                          0x1FFF0000L
#define MCIF_WB2_MCIF_WB_BUF_2_STATUS__MCIF_WB_BUF_2_LONG_LINE_ERROR_MASK                                     0x20000000L
#define MCIF_WB2_MCIF_WB_BUF_2_STATUS__MCIF_WB_BUF_2_SHORT_LINE_ERROR_MASK                                    0x40000000L
#define MCIF_WB2_MCIF_WB_BUF_2_STATUS__MCIF_WB_BUF_2_FRAME_LENGTH_ERROR_MASK                                  0x80000000L
//MCIF_WB2_MCIF_WB_BUF_2_STATUS2
#define MCIF_WB2_MCIF_WB_BUF_2_STATUS2__MCIF_WB_BUF_2_CUR_LINE_R__SHIFT                                       0x0
#define MCIF_WB2_MCIF_WB_BUF_2_STATUS2__MCIF_WB_BUF_2_NEW_CONTENT__SHIFT                                      0xd
#define MCIF_WB2_MCIF_WB_BUF_2_STATUS2__MCIF_WB_BUF_2_COLOR_DEPTH__SHIFT                                      0xe
#define MCIF_WB2_MCIF_WB_BUF_2_STATUS2__MCIF_WB_BUF_2_Y_OVERRUN__SHIFT                                        0x11
#define MCIF_WB2_MCIF_WB_BUF_2_STATUS2__MCIF_WB_BUF_2_C_OVERRUN__SHIFT                                        0x12
#define MCIF_WB2_MCIF_WB_BUF_2_STATUS2__MCIF_WB_BUF_2_CUR_LINE_R_MASK                                         0x00001FFFL
#define MCIF_WB2_MCIF_WB_BUF_2_STATUS2__MCIF_WB_BUF_2_NEW_CONTENT_MASK                                        0x00002000L
#define MCIF_WB2_MCIF_WB_BUF_2_STATUS2__MCIF_WB_BUF_2_COLOR_DEPTH_MASK                                        0x00004000L
#define MCIF_WB2_MCIF_WB_BUF_2_STATUS2__MCIF_WB_BUF_2_Y_OVERRUN_MASK                                          0x00020000L
#define MCIF_WB2_MCIF_WB_BUF_2_STATUS2__MCIF_WB_BUF_2_C_OVERRUN_MASK                                          0x00040000L
//MCIF_WB2_MCIF_WB_BUF_3_STATUS
#define MCIF_WB2_MCIF_WB_BUF_3_STATUS__MCIF_WB_BUF_3_ACTIVE__SHIFT                                            0x0
#define MCIF_WB2_MCIF_WB_BUF_3_STATUS__MCIF_WB_BUF_3_SW_LOCKED__SHIFT                                         0x1
#define MCIF_WB2_MCIF_WB_BUF_3_STATUS__MCIF_WB_BUF_3_VCE_LOCKED__SHIFT                                        0x2
#define MCIF_WB2_MCIF_WB_BUF_3_STATUS__MCIF_WB_BUF_3_OVERFLOW__SHIFT                                          0x3
#define MCIF_WB2_MCIF_WB_BUF_3_STATUS__MCIF_WB_BUF_3_DISABLE__SHIFT                                           0x4
#define MCIF_WB2_MCIF_WB_BUF_3_STATUS__MCIF_WB_BUF_3_MODE__SHIFT                                              0x5
#define MCIF_WB2_MCIF_WB_BUF_3_STATUS__MCIF_WB_BUF_3_BUFTAG__SHIFT                                            0x8
#define MCIF_WB2_MCIF_WB_BUF_3_STATUS__MCIF_WB_BUF_3_NXT_BUF__SHIFT                                           0xc
#define MCIF_WB2_MCIF_WB_BUF_3_STATUS__MCIF_WB_BUF_3_FIELD__SHIFT                                             0xf
#define MCIF_WB2_MCIF_WB_BUF_3_STATUS__MCIF_WB_BUF_3_CUR_LINE_L__SHIFT                                        0x10
#define MCIF_WB2_MCIF_WB_BUF_3_STATUS__MCIF_WB_BUF_3_LONG_LINE_ERROR__SHIFT                                   0x1d
#define MCIF_WB2_MCIF_WB_BUF_3_STATUS__MCIF_WB_BUF_3_SHORT_LINE_ERROR__SHIFT                                  0x1e
#define MCIF_WB2_MCIF_WB_BUF_3_STATUS__MCIF_WB_BUF_3_FRAME_LENGTH_ERROR__SHIFT                                0x1f
#define MCIF_WB2_MCIF_WB_BUF_3_STATUS__MCIF_WB_BUF_3_ACTIVE_MASK                                              0x00000001L
#define MCIF_WB2_MCIF_WB_BUF_3_STATUS__MCIF_WB_BUF_3_SW_LOCKED_MASK                                           0x00000002L
#define MCIF_WB2_MCIF_WB_BUF_3_STATUS__MCIF_WB_BUF_3_VCE_LOCKED_MASK                                          0x00000004L
#define MCIF_WB2_MCIF_WB_BUF_3_STATUS__MCIF_WB_BUF_3_OVERFLOW_MASK                                            0x00000008L
#define MCIF_WB2_MCIF_WB_BUF_3_STATUS__MCIF_WB_BUF_3_DISABLE_MASK                                             0x00000010L
#define MCIF_WB2_MCIF_WB_BUF_3_STATUS__MCIF_WB_BUF_3_MODE_MASK                                                0x000000E0L
#define MCIF_WB2_MCIF_WB_BUF_3_STATUS__MCIF_WB_BUF_3_BUFTAG_MASK                                              0x00000F00L
#define MCIF_WB2_MCIF_WB_BUF_3_STATUS__MCIF_WB_BUF_3_NXT_BUF_MASK                                             0x00007000L
#define MCIF_WB2_MCIF_WB_BUF_3_STATUS__MCIF_WB_BUF_3_FIELD_MASK                                               0x00008000L
#define MCIF_WB2_MCIF_WB_BUF_3_STATUS__MCIF_WB_BUF_3_CUR_LINE_L_MASK                                          0x1FFF0000L
#define MCIF_WB2_MCIF_WB_BUF_3_STATUS__MCIF_WB_BUF_3_LONG_LINE_ERROR_MASK                                     0x20000000L
#define MCIF_WB2_MCIF_WB_BUF_3_STATUS__MCIF_WB_BUF_3_SHORT_LINE_ERROR_MASK                                    0x40000000L
#define MCIF_WB2_MCIF_WB_BUF_3_STATUS__MCIF_WB_BUF_3_FRAME_LENGTH_ERROR_MASK                                  0x80000000L
//MCIF_WB2_MCIF_WB_BUF_3_STATUS2
#define MCIF_WB2_MCIF_WB_BUF_3_STATUS2__MCIF_WB_BUF_3_CUR_LINE_R__SHIFT                                       0x0
#define MCIF_WB2_MCIF_WB_BUF_3_STATUS2__MCIF_WB_BUF_3_NEW_CONTENT__SHIFT                                      0xd
#define MCIF_WB2_MCIF_WB_BUF_3_STATUS2__MCIF_WB_BUF_3_COLOR_DEPTH__SHIFT                                      0xe
#define MCIF_WB2_MCIF_WB_BUF_3_STATUS2__MCIF_WB_BUF_3_Y_OVERRUN__SHIFT                                        0x11
#define MCIF_WB2_MCIF_WB_BUF_3_STATUS2__MCIF_WB_BUF_3_C_OVERRUN__SHIFT                                        0x12
#define MCIF_WB2_MCIF_WB_BUF_3_STATUS2__MCIF_WB_BUF_3_CUR_LINE_R_MASK                                         0x00001FFFL
#define MCIF_WB2_MCIF_WB_BUF_3_STATUS2__MCIF_WB_BUF_3_NEW_CONTENT_MASK                                        0x00002000L
#define MCIF_WB2_MCIF_WB_BUF_3_STATUS2__MCIF_WB_BUF_3_COLOR_DEPTH_MASK                                        0x00004000L
#define MCIF_WB2_MCIF_WB_BUF_3_STATUS2__MCIF_WB_BUF_3_Y_OVERRUN_MASK                                          0x00020000L
#define MCIF_WB2_MCIF_WB_BUF_3_STATUS2__MCIF_WB_BUF_3_C_OVERRUN_MASK                                          0x00040000L
//MCIF_WB2_MCIF_WB_BUF_4_STATUS
#define MCIF_WB2_MCIF_WB_BUF_4_STATUS__MCIF_WB_BUF_4_ACTIVE__SHIFT                                            0x0
#define MCIF_WB2_MCIF_WB_BUF_4_STATUS__MCIF_WB_BUF_4_SW_LOCKED__SHIFT                                         0x1
#define MCIF_WB2_MCIF_WB_BUF_4_STATUS__MCIF_WB_BUF_4_VCE_LOCKED__SHIFT                                        0x2
#define MCIF_WB2_MCIF_WB_BUF_4_STATUS__MCIF_WB_BUF_4_OVERFLOW__SHIFT                                          0x3
#define MCIF_WB2_MCIF_WB_BUF_4_STATUS__MCIF_WB_BUF_4_DISABLE__SHIFT                                           0x4
#define MCIF_WB2_MCIF_WB_BUF_4_STATUS__MCIF_WB_BUF_4_MODE__SHIFT                                              0x5
#define MCIF_WB2_MCIF_WB_BUF_4_STATUS__MCIF_WB_BUF_4_BUFTAG__SHIFT                                            0x8
#define MCIF_WB2_MCIF_WB_BUF_4_STATUS__MCIF_WB_BUF_4_NXT_BUF__SHIFT                                           0xc
#define MCIF_WB2_MCIF_WB_BUF_4_STATUS__MCIF_WB_BUF_4_FIELD__SHIFT                                             0xf
#define MCIF_WB2_MCIF_WB_BUF_4_STATUS__MCIF_WB_BUF_4_CUR_LINE_L__SHIFT                                        0x10
#define MCIF_WB2_MCIF_WB_BUF_4_STATUS__MCIF_WB_BUF_4_LONG_LINE_ERROR__SHIFT                                   0x1d
#define MCIF_WB2_MCIF_WB_BUF_4_STATUS__MCIF_WB_BUF_4_SHORT_LINE_ERROR__SHIFT                                  0x1e
#define MCIF_WB2_MCIF_WB_BUF_4_STATUS__MCIF_WB_BUF_4_FRAME_LENGTH_ERROR__SHIFT                                0x1f
#define MCIF_WB2_MCIF_WB_BUF_4_STATUS__MCIF_WB_BUF_4_ACTIVE_MASK                                              0x00000001L
#define MCIF_WB2_MCIF_WB_BUF_4_STATUS__MCIF_WB_BUF_4_SW_LOCKED_MASK                                           0x00000002L
#define MCIF_WB2_MCIF_WB_BUF_4_STATUS__MCIF_WB_BUF_4_VCE_LOCKED_MASK                                          0x00000004L
#define MCIF_WB2_MCIF_WB_BUF_4_STATUS__MCIF_WB_BUF_4_OVERFLOW_MASK                                            0x00000008L
#define MCIF_WB2_MCIF_WB_BUF_4_STATUS__MCIF_WB_BUF_4_DISABLE_MASK                                             0x00000010L
#define MCIF_WB2_MCIF_WB_BUF_4_STATUS__MCIF_WB_BUF_4_MODE_MASK                                                0x000000E0L
#define MCIF_WB2_MCIF_WB_BUF_4_STATUS__MCIF_WB_BUF_4_BUFTAG_MASK                                              0x00000F00L
#define MCIF_WB2_MCIF_WB_BUF_4_STATUS__MCIF_WB_BUF_4_NXT_BUF_MASK                                             0x00007000L
#define MCIF_WB2_MCIF_WB_BUF_4_STATUS__MCIF_WB_BUF_4_FIELD_MASK                                               0x00008000L
#define MCIF_WB2_MCIF_WB_BUF_4_STATUS__MCIF_WB_BUF_4_CUR_LINE_L_MASK                                          0x1FFF0000L
#define MCIF_WB2_MCIF_WB_BUF_4_STATUS__MCIF_WB_BUF_4_LONG_LINE_ERROR_MASK                                     0x20000000L
#define MCIF_WB2_MCIF_WB_BUF_4_STATUS__MCIF_WB_BUF_4_SHORT_LINE_ERROR_MASK                                    0x40000000L
#define MCIF_WB2_MCIF_WB_BUF_4_STATUS__MCIF_WB_BUF_4_FRAME_LENGTH_ERROR_MASK                                  0x80000000L
//MCIF_WB2_MCIF_WB_BUF_4_STATUS2
#define MCIF_WB2_MCIF_WB_BUF_4_STATUS2__MCIF_WB_BUF_4_CUR_LINE_R__SHIFT                                       0x0
#define MCIF_WB2_MCIF_WB_BUF_4_STATUS2__MCIF_WB_BUF_4_NEW_CONTENT__SHIFT                                      0xd
#define MCIF_WB2_MCIF_WB_BUF_4_STATUS2__MCIF_WB_BUF_4_COLOR_DEPTH__SHIFT                                      0xe
#define MCIF_WB2_MCIF_WB_BUF_4_STATUS2__MCIF_WB_BUF_4_Y_OVERRUN__SHIFT                                        0x11
#define MCIF_WB2_MCIF_WB_BUF_4_STATUS2__MCIF_WB_BUF_4_C_OVERRUN__SHIFT                                        0x12
#define MCIF_WB2_MCIF_WB_BUF_4_STATUS2__MCIF_WB_BUF_4_CUR_LINE_R_MASK                                         0x00001FFFL
#define MCIF_WB2_MCIF_WB_BUF_4_STATUS2__MCIF_WB_BUF_4_NEW_CONTENT_MASK                                        0x00002000L
#define MCIF_WB2_MCIF_WB_BUF_4_STATUS2__MCIF_WB_BUF_4_COLOR_DEPTH_MASK                                        0x00004000L
#define MCIF_WB2_MCIF_WB_BUF_4_STATUS2__MCIF_WB_BUF_4_Y_OVERRUN_MASK                                          0x00020000L
#define MCIF_WB2_MCIF_WB_BUF_4_STATUS2__MCIF_WB_BUF_4_C_OVERRUN_MASK                                          0x00040000L
//MCIF_WB2_MCIF_WB_ARBITRATION_CONTROL
#define MCIF_WB2_MCIF_WB_ARBITRATION_CONTROL__MCIF_WB_CLIENT_ARBITRATION_SLICE__SHIFT                         0x0
#define MCIF_WB2_MCIF_WB_ARBITRATION_CONTROL__MCIF_WB_TIME_PER_PIXEL__SHIFT                                   0x16
#define MCIF_WB2_MCIF_WB_ARBITRATION_CONTROL__MCIF_WB_CLIENT_ARBITRATION_SLICE_MASK                           0x00000003L
#define MCIF_WB2_MCIF_WB_ARBITRATION_CONTROL__MCIF_WB_TIME_PER_PIXEL_MASK                                     0xFFC00000L
//MCIF_WB2_MCIF_WB_SCLK_CHANGE
#define MCIF_WB2_MCIF_WB_SCLK_CHANGE__WM_CHANGE_ACK_FORCE_ON__SHIFT                                           0x0
#define MCIF_WB2_MCIF_WB_SCLK_CHANGE__MCIF_WB_CLI_WATERMARK_MASK__SHIFT                                       0x1
#define MCIF_WB2_MCIF_WB_SCLK_CHANGE__WM_CHANGE_ACK_FORCE_ON_MASK                                             0x00000001L
#define MCIF_WB2_MCIF_WB_SCLK_CHANGE__MCIF_WB_CLI_WATERMARK_MASK_MASK                                         0x0000000EL
//MCIF_WB2_MCIF_WB_BUF_1_ADDR_Y
#define MCIF_WB2_MCIF_WB_BUF_1_ADDR_Y__MCIF_WB_BUF_1_ADDR_Y__SHIFT                                            0x0
#define MCIF_WB2_MCIF_WB_BUF_1_ADDR_Y__MCIF_WB_BUF_1_ADDR_Y_MASK                                              0xFFFFFFFFL
//MCIF_WB2_MCIF_WB_BUF_1_ADDR_Y_OFFSET
#define MCIF_WB2_MCIF_WB_BUF_1_ADDR_Y_OFFSET__MCIF_WB_BUF_1_ADDR_Y_OFFSET__SHIFT                              0x0
#define MCIF_WB2_MCIF_WB_BUF_1_ADDR_Y_OFFSET__MCIF_WB_BUF_1_ADDR_Y_OFFSET_MASK                                0x0003FFFFL
//MCIF_WB2_MCIF_WB_BUF_1_ADDR_C
#define MCIF_WB2_MCIF_WB_BUF_1_ADDR_C__MCIF_WB_BUF_1_ADDR_C__SHIFT                                            0x0
#define MCIF_WB2_MCIF_WB_BUF_1_ADDR_C__MCIF_WB_BUF_1_ADDR_C_MASK                                              0xFFFFFFFFL
//MCIF_WB2_MCIF_WB_BUF_1_ADDR_C_OFFSET
#define MCIF_WB2_MCIF_WB_BUF_1_ADDR_C_OFFSET__MCIF_WB_BUF_1_ADDR_C_OFFSET__SHIFT                              0x0
#define MCIF_WB2_MCIF_WB_BUF_1_ADDR_C_OFFSET__MCIF_WB_BUF_1_ADDR_C_OFFSET_MASK                                0x0003FFFFL
//MCIF_WB2_MCIF_WB_BUF_2_ADDR_Y
#define MCIF_WB2_MCIF_WB_BUF_2_ADDR_Y__MCIF_WB_BUF_2_ADDR_Y__SHIFT                                            0x0
#define MCIF_WB2_MCIF_WB_BUF_2_ADDR_Y__MCIF_WB_BUF_2_ADDR_Y_MASK                                              0xFFFFFFFFL
//MCIF_WB2_MCIF_WB_BUF_2_ADDR_Y_OFFSET
#define MCIF_WB2_MCIF_WB_BUF_2_ADDR_Y_OFFSET__MCIF_WB_BUF_2_ADDR_Y_OFFSET__SHIFT                              0x0
#define MCIF_WB2_MCIF_WB_BUF_2_ADDR_Y_OFFSET__MCIF_WB_BUF_2_ADDR_Y_OFFSET_MASK                                0x0003FFFFL
//MCIF_WB2_MCIF_WB_BUF_2_ADDR_C
#define MCIF_WB2_MCIF_WB_BUF_2_ADDR_C__MCIF_WB_BUF_2_ADDR_C__SHIFT                                            0x0
#define MCIF_WB2_MCIF_WB_BUF_2_ADDR_C__MCIF_WB_BUF_2_ADDR_C_MASK                                              0xFFFFFFFFL
//MCIF_WB2_MCIF_WB_BUF_2_ADDR_C_OFFSET
#define MCIF_WB2_MCIF_WB_BUF_2_ADDR_C_OFFSET__MCIF_WB_BUF_2_ADDR_C_OFFSET__SHIFT                              0x0
#define MCIF_WB2_MCIF_WB_BUF_2_ADDR_C_OFFSET__MCIF_WB_BUF_2_ADDR_C_OFFSET_MASK                                0x0003FFFFL
//MCIF_WB2_MCIF_WB_BUF_3_ADDR_Y
#define MCIF_WB2_MCIF_WB_BUF_3_ADDR_Y__MCIF_WB_BUF_3_ADDR_Y__SHIFT                                            0x0
#define MCIF_WB2_MCIF_WB_BUF_3_ADDR_Y__MCIF_WB_BUF_3_ADDR_Y_MASK                                              0xFFFFFFFFL
//MCIF_WB2_MCIF_WB_BUF_3_ADDR_Y_OFFSET
#define MCIF_WB2_MCIF_WB_BUF_3_ADDR_Y_OFFSET__MCIF_WB_BUF_3_ADDR_Y_OFFSET__SHIFT                              0x0
#define MCIF_WB2_MCIF_WB_BUF_3_ADDR_Y_OFFSET__MCIF_WB_BUF_3_ADDR_Y_OFFSET_MASK                                0x0003FFFFL
//MCIF_WB2_MCIF_WB_BUF_3_ADDR_C
#define MCIF_WB2_MCIF_WB_BUF_3_ADDR_C__MCIF_WB_BUF_3_ADDR_C__SHIFT                                            0x0
#define MCIF_WB2_MCIF_WB_BUF_3_ADDR_C__MCIF_WB_BUF_3_ADDR_C_MASK                                              0xFFFFFFFFL
//MCIF_WB2_MCIF_WB_BUF_3_ADDR_C_OFFSET
#define MCIF_WB2_MCIF_WB_BUF_3_ADDR_C_OFFSET__MCIF_WB_BUF_3_ADDR_C_OFFSET__SHIFT                              0x0
#define MCIF_WB2_MCIF_WB_BUF_3_ADDR_C_OFFSET__MCIF_WB_BUF_3_ADDR_C_OFFSET_MASK                                0x0003FFFFL
//MCIF_WB2_MCIF_WB_BUF_4_ADDR_Y
#define MCIF_WB2_MCIF_WB_BUF_4_ADDR_Y__MCIF_WB_BUF_4_ADDR_Y__SHIFT                                            0x0
#define MCIF_WB2_MCIF_WB_BUF_4_ADDR_Y__MCIF_WB_BUF_4_ADDR_Y_MASK                                              0xFFFFFFFFL
//MCIF_WB2_MCIF_WB_BUF_4_ADDR_Y_OFFSET
#define MCIF_WB2_MCIF_WB_BUF_4_ADDR_Y_OFFSET__MCIF_WB_BUF_4_ADDR_Y_OFFSET__SHIFT                              0x0
#define MCIF_WB2_MCIF_WB_BUF_4_ADDR_Y_OFFSET__MCIF_WB_BUF_4_ADDR_Y_OFFSET_MASK                                0x0003FFFFL
//MCIF_WB2_MCIF_WB_BUF_4_ADDR_C
#define MCIF_WB2_MCIF_WB_BUF_4_ADDR_C__MCIF_WB_BUF_4_ADDR_C__SHIFT                                            0x0
#define MCIF_WB2_MCIF_WB_BUF_4_ADDR_C__MCIF_WB_BUF_4_ADDR_C_MASK                                              0xFFFFFFFFL
//MCIF_WB2_MCIF_WB_BUF_4_ADDR_C_OFFSET
#define MCIF_WB2_MCIF_WB_BUF_4_ADDR_C_OFFSET__MCIF_WB_BUF_4_ADDR_C_OFFSET__SHIFT                              0x0
#define MCIF_WB2_MCIF_WB_BUF_4_ADDR_C_OFFSET__MCIF_WB_BUF_4_ADDR_C_OFFSET_MASK                                0x0003FFFFL
//MCIF_WB2_MCIF_WB_BUFMGR_VCE_CONTROL
#define MCIF_WB2_MCIF_WB_BUFMGR_VCE_CONTROL__MCIF_WB_BUFMGR_VCE_LOCK_IGNORE__SHIFT                            0x0
#define MCIF_WB2_MCIF_WB_BUFMGR_VCE_CONTROL__MCIF_WB_BUFMGR_VCE_INT_EN__SHIFT                                 0x4
#define MCIF_WB2_MCIF_WB_BUFMGR_VCE_CONTROL__MCIF_WB_BUFMGR_VCE_INT_ACK__SHIFT                                0x5
#define MCIF_WB2_MCIF_WB_BUFMGR_VCE_CONTROL__MCIF_WB_BUFMGR_VCE_SLICE_INT_EN__SHIFT                           0x6
#define MCIF_WB2_MCIF_WB_BUFMGR_VCE_CONTROL__MCIF_WB_BUFMGR_VCE_LOCK__SHIFT                                   0x8
#define MCIF_WB2_MCIF_WB_BUFMGR_VCE_CONTROL__MCIF_WB_BUFMGR_SLICE_SIZE__SHIFT                                 0x10
#define MCIF_WB2_MCIF_WB_BUFMGR_VCE_CONTROL__MCIF_WB_BUFMGR_VCE_LOCK_IGNORE_MASK                              0x00000001L
#define MCIF_WB2_MCIF_WB_BUFMGR_VCE_CONTROL__MCIF_WB_BUFMGR_VCE_INT_EN_MASK                                   0x00000010L
#define MCIF_WB2_MCIF_WB_BUFMGR_VCE_CONTROL__MCIF_WB_BUFMGR_VCE_INT_ACK_MASK                                  0x00000020L
#define MCIF_WB2_MCIF_WB_BUFMGR_VCE_CONTROL__MCIF_WB_BUFMGR_VCE_SLICE_INT_EN_MASK                             0x00000040L
#define MCIF_WB2_MCIF_WB_BUFMGR_VCE_CONTROL__MCIF_WB_BUFMGR_VCE_LOCK_MASK                                     0x00000F00L
#define MCIF_WB2_MCIF_WB_BUFMGR_VCE_CONTROL__MCIF_WB_BUFMGR_SLICE_SIZE_MASK                                   0x1FFF0000L
//MCIF_WB2_MCIF_WB_NB_PSTATE_LATENCY_WATERMARK
#define MCIF_WB2_MCIF_WB_NB_PSTATE_LATENCY_WATERMARK__NB_PSTATE_CHANGE_REFRESH_WATERMARK__SHIFT               0x0
#define MCIF_WB2_MCIF_WB_NB_PSTATE_LATENCY_WATERMARK__NB_PSTATE_CHANGE_REFRESH_WATERMARK_MASK                 0x0001FFFFL
//MCIF_WB2_MCIF_WB_NB_PSTATE_CONTROL
#define MCIF_WB2_MCIF_WB_NB_PSTATE_CONTROL__NB_PSTATE_CHANGE_URGENT_DURING_REQUEST__SHIFT                     0x0
#define MCIF_WB2_MCIF_WB_NB_PSTATE_CONTROL__NB_PSTATE_CHANGE_FORCE_ON__SHIFT                                  0x1
#define MCIF_WB2_MCIF_WB_NB_PSTATE_CONTROL__NB_PSTATE_ALLOW_FOR_URGENT__SHIFT                                 0x2
#define MCIF_WB2_MCIF_WB_NB_PSTATE_CONTROL__NB_PSTATE_CHANGE_WATERMARK_MASK__SHIFT                            0x4
#define MCIF_WB2_MCIF_WB_NB_PSTATE_CONTROL__NB_PSTATE_CHANGE_URGENT_DURING_REQUEST_MASK                       0x00000001L
#define MCIF_WB2_MCIF_WB_NB_PSTATE_CONTROL__NB_PSTATE_CHANGE_FORCE_ON_MASK                                    0x00000002L
#define MCIF_WB2_MCIF_WB_NB_PSTATE_CONTROL__NB_PSTATE_ALLOW_FOR_URGENT_MASK                                   0x00000004L
#define MCIF_WB2_MCIF_WB_NB_PSTATE_CONTROL__NB_PSTATE_CHANGE_WATERMARK_MASK_MASK                              0x00000070L
//MCIF_WB2_MCIF_WB_WATERMARK
#define MCIF_WB2_MCIF_WB_WATERMARK__MCIF_WB_CLI_WATERMARK__SHIFT                                              0x0
#define MCIF_WB2_MCIF_WB_WATERMARK__MCIF_WB_CLI_WATERMARK_MASK                                                0x0000FFFFL
//MCIF_WB2_MCIF_WB_CLOCK_GATER_CONTROL
#define MCIF_WB2_MCIF_WB_CLOCK_GATER_CONTROL__MCIF_WB_CLI_CLOCK_GATER_OVERRIDE__SHIFT                         0x0
#define MCIF_WB2_MCIF_WB_CLOCK_GATER_CONTROL__MCIF_WB_CLI_CLOCK_GATER_OVERRIDE_MASK                           0x00000001L
//MCIF_WB2_MCIF_WB_WARM_UP_CNTL
#define MCIF_WB2_MCIF_WB_WARM_UP_CNTL__MCIF_WB_PITCH_SIZE_WARMUP__SHIFT                                       0x8
#define MCIF_WB2_MCIF_WB_WARM_UP_CNTL__MCIF_WB_PITCH_SIZE_WARMUP_MASK                                         0x0000FF00L
//MCIF_WB2_MCIF_WB_SELF_REFRESH_CONTROL
#define MCIF_WB2_MCIF_WB_SELF_REFRESH_CONTROL__DIS_REFRESH_UNDER_NBPREQ__SHIFT                                0x0
#define MCIF_WB2_MCIF_WB_SELF_REFRESH_CONTROL__PERFRAME_SELF_REFRESH__SHIFT                                   0x1
#define MCIF_WB2_MCIF_WB_SELF_REFRESH_CONTROL__DIS_REFRESH_UNDER_NBPREQ_MASK                                  0x00000001L
#define MCIF_WB2_MCIF_WB_SELF_REFRESH_CONTROL__PERFRAME_SELF_REFRESH_MASK                                     0x00000002L
//MCIF_WB2_MULTI_LEVEL_QOS_CTRL
#define MCIF_WB2_MULTI_LEVEL_QOS_CTRL__MAX_SCALED_TIME_TO_URGENT__SHIFT                                       0x0
#define MCIF_WB2_MULTI_LEVEL_QOS_CTRL__MAX_SCALED_TIME_TO_URGENT_MASK                                         0x003FFFFFL
//MCIF_WB2_MCIF_WB_BUF_LUMA_SIZE
#define MCIF_WB2_MCIF_WB_BUF_LUMA_SIZE__MCIF_WB_BUF_LUMA_SIZE__SHIFT                                          0x0
#define MCIF_WB2_MCIF_WB_BUF_LUMA_SIZE__MCIF_WB_BUF_LUMA_SIZE_MASK                                            0x000FFFFFL
//MCIF_WB2_MCIF_WB_BUF_CHROMA_SIZE
#define MCIF_WB2_MCIF_WB_BUF_CHROMA_SIZE__MCIF_WB_BUF_CHROMA_SIZE__SHIFT                                      0x0
#define MCIF_WB2_MCIF_WB_BUF_CHROMA_SIZE__MCIF_WB_BUF_CHROMA_SIZE_MASK                                        0x000FFFFFL


// addressBlock: dce_dc_cwb0_dispdec
//CWB0_CWB_CTRL
#define CWB0_CWB_CTRL__CWB_EN__SHIFT                                                                          0x0
#define CWB0_CWB_CTRL__CWB_OUTPUT_COLOR_DEPTH__SHIFT                                                          0x2
#define CWB0_CWB_CTRL__CWB_ZERO_PADDING_MODE__SHIFT                                                           0x4
#define CWB0_CWB_CTRL__CWB_CB_CR_SWAP__SHIFT                                                                  0x6
#define CWB0_CWB_CTRL__CWB_422MODE_LUMA_CHROMA_SWAP__SHIFT                                                    0x7
#define CWB0_CWB_CTRL__CWB_444MODE_ROUNDING_EN__SHIFT                                                         0x8
#define CWB0_CWB_CTRL__CWB_PACK_FMT_SEL__SHIFT                                                                0xa
#define CWB0_CWB_CTRL__CWB_EN_MASK                                                                            0x00000001L
#define CWB0_CWB_CTRL__CWB_OUTPUT_COLOR_DEPTH_MASK                                                            0x0000000CL
#define CWB0_CWB_CTRL__CWB_ZERO_PADDING_MODE_MASK                                                             0x00000010L
#define CWB0_CWB_CTRL__CWB_CB_CR_SWAP_MASK                                                                    0x00000040L
#define CWB0_CWB_CTRL__CWB_422MODE_LUMA_CHROMA_SWAP_MASK                                                      0x00000080L
#define CWB0_CWB_CTRL__CWB_444MODE_ROUNDING_EN_MASK                                                           0x00000100L
#define CWB0_CWB_CTRL__CWB_PACK_FMT_SEL_MASK                                                                  0x00000400L
//CWB0_CWB_FENCE_PAR0
#define CWB0_CWB_FENCE_PAR0__CWB_OUTPUT_LINE_WIDTH__SHIFT                                                     0x0
#define CWB0_CWB_FENCE_PAR0__CWB_ERROR_LINE_WIDTH__SHIFT                                                      0x10
#define CWB0_CWB_FENCE_PAR0__CWB_OUTPUT_LINE_WIDTH_MASK                                                       0x00001FFFL
#define CWB0_CWB_FENCE_PAR0__CWB_ERROR_LINE_WIDTH_MASK                                                        0x1FFF0000L
//CWB0_CWB_FENCE_PAR1
#define CWB0_CWB_FENCE_PAR1__CWB_OUTPUT_LINES_PER_FRAME__SHIFT                                                0x0
#define CWB0_CWB_FENCE_PAR1__CWB_EOF_TO_SOF_SPACING__SHIFT                                                    0x10
#define CWB0_CWB_FENCE_PAR1__CWB_OUTPUT_LINES_PER_FRAME_MASK                                                  0x00001FFFL
#define CWB0_CWB_FENCE_PAR1__CWB_EOF_TO_SOF_SPACING_MASK                                                      0x003F0000L
//CWB0_CWB_CRC_CTRL
#define CWB0_CWB_CRC_CTRL__CWB_CRC_EN__SHIFT                                                                  0x0
#define CWB0_CWB_CRC_CTRL__CWB_CRC_CONT_EN__SHIFT                                                             0x2
#define CWB0_CWB_CRC_CTRL__CWB_CRC_SRC_SEL__SHIFT                                                             0x6
#define CWB0_CWB_CRC_CTRL__CWB_CRC_EN_MASK                                                                    0x00000001L
#define CWB0_CWB_CRC_CTRL__CWB_CRC_CONT_EN_MASK                                                               0x00000004L
#define CWB0_CWB_CRC_CTRL__CWB_CRC_SRC_SEL_MASK                                                               0x00000040L
//CWB0_CWB_CRC_RED_GREEN_MASK
#define CWB0_CWB_CRC_RED_GREEN_MASK__CWB_CRC_RED_MASK__SHIFT                                                  0x0
#define CWB0_CWB_CRC_RED_GREEN_MASK__CWB_CRC_GREEN_MASK__SHIFT                                                0x10
#define CWB0_CWB_CRC_RED_GREEN_MASK__CWB_CRC_RED_MASK_MASK                                                    0x0000FFFFL
#define CWB0_CWB_CRC_RED_GREEN_MASK__CWB_CRC_GREEN_MASK_MASK                                                  0xFFFF0000L
//CWB0_CWB_CRC_BLUE_MASK
#define CWB0_CWB_CRC_BLUE_MASK__CWB_CRC_BLUE_MASK__SHIFT                                                      0x0
#define CWB0_CWB_CRC_BLUE_MASK__CWB_CRC_BLUE_MASK_MASK                                                        0x0000FFFFL
//CWB0_CWB_CRC_RED_GREEN_RESULT
#define CWB0_CWB_CRC_RED_GREEN_RESULT__CWB_CRC_RED_RESULT__SHIFT                                              0x0
#define CWB0_CWB_CRC_RED_GREEN_RESULT__CWB_CRC_GREEN_RESULT__SHIFT                                            0x10
#define CWB0_CWB_CRC_RED_GREEN_RESULT__CWB_CRC_RED_RESULT_MASK                                                0x0000FFFFL
#define CWB0_CWB_CRC_RED_GREEN_RESULT__CWB_CRC_GREEN_RESULT_MASK                                              0xFFFF0000L
//CWB0_CWB_CRC_BLUE_RESULT
#define CWB0_CWB_CRC_BLUE_RESULT__CWB_CRC_BLUE_RESULT__SHIFT                                                  0x0
#define CWB0_CWB_CRC_BLUE_RESULT__CWB_CRC_COUNT__SHIFT                                                        0x10
#define CWB0_CWB_CRC_BLUE_RESULT__CWB_CRC_BLUE_RESULT_MASK                                                    0x0000FFFFL
#define CWB0_CWB_CRC_BLUE_RESULT__CWB_CRC_COUNT_MASK                                                          0x000F0000L


// addressBlock: dce_dc_cwb1_dispdec
//CWB1_CWB_CTRL
#define CWB1_CWB_CTRL__CWB_EN__SHIFT                                                                          0x0
#define CWB1_CWB_CTRL__CWB_OUTPUT_COLOR_DEPTH__SHIFT                                                          0x2
#define CWB1_CWB_CTRL__CWB_ZERO_PADDING_MODE__SHIFT                                                           0x4
#define CWB1_CWB_CTRL__CWB_CB_CR_SWAP__SHIFT                                                                  0x6
#define CWB1_CWB_CTRL__CWB_422MODE_LUMA_CHROMA_SWAP__SHIFT                                                    0x7
#define CWB1_CWB_CTRL__CWB_444MODE_ROUNDING_EN__SHIFT                                                         0x8
#define CWB1_CWB_CTRL__CWB_PACK_FMT_SEL__SHIFT                                                                0xa
#define CWB1_CWB_CTRL__CWB_EN_MASK                                                                            0x00000001L
#define CWB1_CWB_CTRL__CWB_OUTPUT_COLOR_DEPTH_MASK                                                            0x0000000CL
#define CWB1_CWB_CTRL__CWB_ZERO_PADDING_MODE_MASK                                                             0x00000010L
#define CWB1_CWB_CTRL__CWB_CB_CR_SWAP_MASK                                                                    0x00000040L
#define CWB1_CWB_CTRL__CWB_422MODE_LUMA_CHROMA_SWAP_MASK                                                      0x00000080L
#define CWB1_CWB_CTRL__CWB_444MODE_ROUNDING_EN_MASK                                                           0x00000100L
#define CWB1_CWB_CTRL__CWB_PACK_FMT_SEL_MASK                                                                  0x00000400L
//CWB1_CWB_FENCE_PAR0
#define CWB1_CWB_FENCE_PAR0__CWB_OUTPUT_LINE_WIDTH__SHIFT                                                     0x0
#define CWB1_CWB_FENCE_PAR0__CWB_ERROR_LINE_WIDTH__SHIFT                                                      0x10
#define CWB1_CWB_FENCE_PAR0__CWB_OUTPUT_LINE_WIDTH_MASK                                                       0x00001FFFL
#define CWB1_CWB_FENCE_PAR0__CWB_ERROR_LINE_WIDTH_MASK                                                        0x1FFF0000L
//CWB1_CWB_FENCE_PAR1
#define CWB1_CWB_FENCE_PAR1__CWB_OUTPUT_LINES_PER_FRAME__SHIFT                                                0x0
#define CWB1_CWB_FENCE_PAR1__CWB_EOF_TO_SOF_SPACING__SHIFT                                                    0x10
#define CWB1_CWB_FENCE_PAR1__CWB_OUTPUT_LINES_PER_FRAME_MASK                                                  0x00001FFFL
#define CWB1_CWB_FENCE_PAR1__CWB_EOF_TO_SOF_SPACING_MASK                                                      0x003F0000L
//CWB1_CWB_CRC_CTRL
#define CWB1_CWB_CRC_CTRL__CWB_CRC_EN__SHIFT                                                                  0x0
#define CWB1_CWB_CRC_CTRL__CWB_CRC_CONT_EN__SHIFT                                                             0x2
#define CWB1_CWB_CRC_CTRL__CWB_CRC_SRC_SEL__SHIFT                                                             0x6
#define CWB1_CWB_CRC_CTRL__CWB_CRC_EN_MASK                                                                    0x00000001L
#define CWB1_CWB_CRC_CTRL__CWB_CRC_CONT_EN_MASK                                                               0x00000004L
#define CWB1_CWB_CRC_CTRL__CWB_CRC_SRC_SEL_MASK                                                               0x00000040L
//CWB1_CWB_CRC_RED_GREEN_MASK
#define CWB1_CWB_CRC_RED_GREEN_MASK__CWB_CRC_RED_MASK__SHIFT                                                  0x0
#define CWB1_CWB_CRC_RED_GREEN_MASK__CWB_CRC_GREEN_MASK__SHIFT                                                0x10
#define CWB1_CWB_CRC_RED_GREEN_MASK__CWB_CRC_RED_MASK_MASK                                                    0x0000FFFFL
#define CWB1_CWB_CRC_RED_GREEN_MASK__CWB_CRC_GREEN_MASK_MASK                                                  0xFFFF0000L
//CWB1_CWB_CRC_BLUE_MASK
#define CWB1_CWB_CRC_BLUE_MASK__CWB_CRC_BLUE_MASK__SHIFT                                                      0x0
#define CWB1_CWB_CRC_BLUE_MASK__CWB_CRC_BLUE_MASK_MASK                                                        0x0000FFFFL
//CWB1_CWB_CRC_RED_GREEN_RESULT
#define CWB1_CWB_CRC_RED_GREEN_RESULT__CWB_CRC_RED_RESULT__SHIFT                                              0x0
#define CWB1_CWB_CRC_RED_GREEN_RESULT__CWB_CRC_GREEN_RESULT__SHIFT                                            0x10
#define CWB1_CWB_CRC_RED_GREEN_RESULT__CWB_CRC_RED_RESULT_MASK                                                0x0000FFFFL
#define CWB1_CWB_CRC_RED_GREEN_RESULT__CWB_CRC_GREEN_RESULT_MASK                                              0xFFFF0000L
//CWB1_CWB_CRC_BLUE_RESULT
#define CWB1_CWB_CRC_BLUE_RESULT__CWB_CRC_BLUE_RESULT__SHIFT                                                  0x0
#define CWB1_CWB_CRC_BLUE_RESULT__CWB_CRC_COUNT__SHIFT                                                        0x10
#define CWB1_CWB_CRC_BLUE_RESULT__CWB_CRC_BLUE_RESULT_MASK                                                    0x0000FFFFL
#define CWB1_CWB_CRC_BLUE_RESULT__CWB_CRC_COUNT_MASK                                                          0x000F0000L


// addressBlock: dce_dc_dc_perfmon9_dispdec
//DC_PERFMON9_PERFCOUNTER_CNTL
#define DC_PERFMON9_PERFCOUNTER_CNTL__PERFCOUNTER_EVENT_SEL__SHIFT                                            0x0
#define DC_PERFMON9_PERFCOUNTER_CNTL__PERFCOUNTER_CVALUE_SEL__SHIFT                                           0x9
#define DC_PERFMON9_PERFCOUNTER_CNTL__PERFCOUNTER_INC_MODE__SHIFT                                             0xc
#define DC_PERFMON9_PERFCOUNTER_CNTL__PERFCOUNTER_HW_CNTL_SEL__SHIFT                                          0xf
#define DC_PERFMON9_PERFCOUNTER_CNTL__PERFCOUNTER_RUNEN_MODE__SHIFT                                           0x10
#define DC_PERFMON9_PERFCOUNTER_CNTL__PERFCOUNTER_CNTOFF_SEL__SHIFT                                           0x11
#define DC_PERFMON9_PERFCOUNTER_CNTL__PERFCOUNTER_CNTOFF_START_DIS__SHIFT                                     0x16
#define DC_PERFMON9_PERFCOUNTER_CNTL__PERFCOUNTER_RESTART_EN__SHIFT                                           0x17
#define DC_PERFMON9_PERFCOUNTER_CNTL__PERFCOUNTER_INT_EN__SHIFT                                               0x18
#define DC_PERFMON9_PERFCOUNTER_CNTL__PERFCOUNTER_OFF_MASK__SHIFT                                             0x19
#define DC_PERFMON9_PERFCOUNTER_CNTL__PERFCOUNTER_ACTIVE__SHIFT                                               0x1a
#define DC_PERFMON9_PERFCOUNTER_CNTL__PERFCOUNTER_INT_TYPE__SHIFT                                             0x1b
#define DC_PERFMON9_PERFCOUNTER_CNTL__PERFCOUNTER_CNTL_SEL__SHIFT                                             0x1d
#define DC_PERFMON9_PERFCOUNTER_CNTL__PERFCOUNTER_EVENT_SEL_MASK                                              0x000001FFL
#define DC_PERFMON9_PERFCOUNTER_CNTL__PERFCOUNTER_CVALUE_SEL_MASK                                             0x00000E00L
#define DC_PERFMON9_PERFCOUNTER_CNTL__PERFCOUNTER_INC_MODE_MASK                                               0x00007000L
#define DC_PERFMON9_PERFCOUNTER_CNTL__PERFCOUNTER_HW_CNTL_SEL_MASK                                            0x00008000L
#define DC_PERFMON9_PERFCOUNTER_CNTL__PERFCOUNTER_RUNEN_MODE_MASK                                             0x00010000L
#define DC_PERFMON9_PERFCOUNTER_CNTL__PERFCOUNTER_CNTOFF_SEL_MASK                                             0x003E0000L
#define DC_PERFMON9_PERFCOUNTER_CNTL__PERFCOUNTER_CNTOFF_START_DIS_MASK                                       0x00400000L
#define DC_PERFMON9_PERFCOUNTER_CNTL__PERFCOUNTER_RESTART_EN_MASK                                             0x00800000L
#define DC_PERFMON9_PERFCOUNTER_CNTL__PERFCOUNTER_INT_EN_MASK                                                 0x01000000L
#define DC_PERFMON9_PERFCOUNTER_CNTL__PERFCOUNTER_OFF_MASK_MASK                                               0x02000000L
#define DC_PERFMON9_PERFCOUNTER_CNTL__PERFCOUNTER_ACTIVE_MASK                                                 0x04000000L
#define DC_PERFMON9_PERFCOUNTER_CNTL__PERFCOUNTER_INT_TYPE_MASK                                               0x08000000L
#define DC_PERFMON9_PERFCOUNTER_CNTL__PERFCOUNTER_CNTL_SEL_MASK                                               0xE0000000L
//DC_PERFMON9_PERFCOUNTER_CNTL2
#define DC_PERFMON9_PERFCOUNTER_CNTL2__PERFCOUNTER_COUNTED_VALUE_TYPE__SHIFT                                  0x0
#define DC_PERFMON9_PERFCOUNTER_CNTL2__PERFCOUNTER_HW_STOP1_SEL__SHIFT                                        0x2
#define DC_PERFMON9_PERFCOUNTER_CNTL2__PERFCOUNTER_HW_STOP2_SEL__SHIFT                                        0x3
#define DC_PERFMON9_PERFCOUNTER_CNTL2__PERFCOUNTER_CNTL2_SEL__SHIFT                                           0x1d
#define DC_PERFMON9_PERFCOUNTER_CNTL2__PERFCOUNTER_COUNTED_VALUE_TYPE_MASK                                    0x00000003L
#define DC_PERFMON9_PERFCOUNTER_CNTL2__PERFCOUNTER_HW_STOP1_SEL_MASK                                          0x00000004L
#define DC_PERFMON9_PERFCOUNTER_CNTL2__PERFCOUNTER_HW_STOP2_SEL_MASK                                          0x00000008L
#define DC_PERFMON9_PERFCOUNTER_CNTL2__PERFCOUNTER_CNTL2_SEL_MASK                                             0xE0000000L
//DC_PERFMON9_PERFCOUNTER_STATE
#define DC_PERFMON9_PERFCOUNTER_STATE__PERFCOUNTER_CNT0_STATE__SHIFT                                          0x0
#define DC_PERFMON9_PERFCOUNTER_STATE__PERFCOUNTER_STATE_SEL0__SHIFT                                          0x2
#define DC_PERFMON9_PERFCOUNTER_STATE__PERFCOUNTER_CNT1_STATE__SHIFT                                          0x4
#define DC_PERFMON9_PERFCOUNTER_STATE__PERFCOUNTER_STATE_SEL1__SHIFT                                          0x6
#define DC_PERFMON9_PERFCOUNTER_STATE__PERFCOUNTER_CNT2_STATE__SHIFT                                          0x8
#define DC_PERFMON9_PERFCOUNTER_STATE__PERFCOUNTER_STATE_SEL2__SHIFT                                          0xa
#define DC_PERFMON9_PERFCOUNTER_STATE__PERFCOUNTER_CNT3_STATE__SHIFT                                          0xc
#define DC_PERFMON9_PERFCOUNTER_STATE__PERFCOUNTER_STATE_SEL3__SHIFT                                          0xe
#define DC_PERFMON9_PERFCOUNTER_STATE__PERFCOUNTER_CNT4_STATE__SHIFT                                          0x10
#define DC_PERFMON9_PERFCOUNTER_STATE__PERFCOUNTER_STATE_SEL4__SHIFT                                          0x12
#define DC_PERFMON9_PERFCOUNTER_STATE__PERFCOUNTER_CNT5_STATE__SHIFT                                          0x14
#define DC_PERFMON9_PERFCOUNTER_STATE__PERFCOUNTER_STATE_SEL5__SHIFT                                          0x16
#define DC_PERFMON9_PERFCOUNTER_STATE__PERFCOUNTER_CNT6_STATE__SHIFT                                          0x18
#define DC_PERFMON9_PERFCOUNTER_STATE__PERFCOUNTER_STATE_SEL6__SHIFT                                          0x1a
#define DC_PERFMON9_PERFCOUNTER_STATE__PERFCOUNTER_CNT7_STATE__SHIFT                                          0x1c
#define DC_PERFMON9_PERFCOUNTER_STATE__PERFCOUNTER_STATE_SEL7__SHIFT                                          0x1e
#define DC_PERFMON9_PERFCOUNTER_STATE__PERFCOUNTER_CNT0_STATE_MASK                                            0x00000003L
#define DC_PERFMON9_PERFCOUNTER_STATE__PERFCOUNTER_STATE_SEL0_MASK                                            0x00000004L
#define DC_PERFMON9_PERFCOUNTER_STATE__PERFCOUNTER_CNT1_STATE_MASK                                            0x00000030L
#define DC_PERFMON9_PERFCOUNTER_STATE__PERFCOUNTER_STATE_SEL1_MASK                                            0x00000040L
#define DC_PERFMON9_PERFCOUNTER_STATE__PERFCOUNTER_CNT2_STATE_MASK                                            0x00000300L
#define DC_PERFMON9_PERFCOUNTER_STATE__PERFCOUNTER_STATE_SEL2_MASK                                            0x00000400L
#define DC_PERFMON9_PERFCOUNTER_STATE__PERFCOUNTER_CNT3_STATE_MASK                                            0x00003000L
#define DC_PERFMON9_PERFCOUNTER_STATE__PERFCOUNTER_STATE_SEL3_MASK                                            0x00004000L
#define DC_PERFMON9_PERFCOUNTER_STATE__PERFCOUNTER_CNT4_STATE_MASK                                            0x00030000L
#define DC_PERFMON9_PERFCOUNTER_STATE__PERFCOUNTER_STATE_SEL4_MASK                                            0x00040000L
#define DC_PERFMON9_PERFCOUNTER_STATE__PERFCOUNTER_CNT5_STATE_MASK                                            0x00300000L
#define DC_PERFMON9_PERFCOUNTER_STATE__PERFCOUNTER_STATE_SEL5_MASK                                            0x00400000L
#define DC_PERFMON9_PERFCOUNTER_STATE__PERFCOUNTER_CNT6_STATE_MASK                                            0x03000000L
#define DC_PERFMON9_PERFCOUNTER_STATE__PERFCOUNTER_STATE_SEL6_MASK                                            0x04000000L
#define DC_PERFMON9_PERFCOUNTER_STATE__PERFCOUNTER_CNT7_STATE_MASK                                            0x30000000L
#define DC_PERFMON9_PERFCOUNTER_STATE__PERFCOUNTER_STATE_SEL7_MASK                                            0x40000000L
//DC_PERFMON9_PERFMON_CNTL
#define DC_PERFMON9_PERFMON_CNTL__PERFMON_STATE__SHIFT                                                        0x0
#define DC_PERFMON9_PERFMON_CNTL__PERFMON_RPT_COUNT__SHIFT                                                    0x8
#define DC_PERFMON9_PERFMON_CNTL__PERFMON_CNTOFF_AND_OR__SHIFT                                                0x1c
#define DC_PERFMON9_PERFMON_CNTL__PERFMON_CNTOFF_INT_EN__SHIFT                                                0x1d
#define DC_PERFMON9_PERFMON_CNTL__PERFMON_CNTOFF_INT_STATUS__SHIFT                                            0x1e
#define DC_PERFMON9_PERFMON_CNTL__PERFMON_CNTOFF_INT_ACK__SHIFT                                               0x1f
#define DC_PERFMON9_PERFMON_CNTL__PERFMON_STATE_MASK                                                          0x00000003L
#define DC_PERFMON9_PERFMON_CNTL__PERFMON_RPT_COUNT_MASK                                                      0x0FFFFF00L
#define DC_PERFMON9_PERFMON_CNTL__PERFMON_CNTOFF_AND_OR_MASK                                                  0x10000000L
#define DC_PERFMON9_PERFMON_CNTL__PERFMON_CNTOFF_INT_EN_MASK                                                  0x20000000L
#define DC_PERFMON9_PERFMON_CNTL__PERFMON_CNTOFF_INT_STATUS_MASK                                              0x40000000L
#define DC_PERFMON9_PERFMON_CNTL__PERFMON_CNTOFF_INT_ACK_MASK                                                 0x80000000L
//DC_PERFMON9_PERFMON_CNTL2
#define DC_PERFMON9_PERFMON_CNTL2__PERFMON_CNTOFF_INT_TYPE__SHIFT                                             0x0
#define DC_PERFMON9_PERFMON_CNTL2__PERFMON_CLK_ENABLE__SHIFT                                                  0x1
#define DC_PERFMON9_PERFMON_CNTL2__PERFMON_RUN_ENABLE_START_SEL__SHIFT                                        0x2
#define DC_PERFMON9_PERFMON_CNTL2__PERFMON_RUN_ENABLE_STOP_SEL__SHIFT                                         0xa
#define DC_PERFMON9_PERFMON_CNTL2__PERFMON_CNTOFF_INT_TYPE_MASK                                               0x00000001L
#define DC_PERFMON9_PERFMON_CNTL2__PERFMON_CLK_ENABLE_MASK                                                    0x00000002L
#define DC_PERFMON9_PERFMON_CNTL2__PERFMON_RUN_ENABLE_START_SEL_MASK                                          0x000003FCL
#define DC_PERFMON9_PERFMON_CNTL2__PERFMON_RUN_ENABLE_STOP_SEL_MASK                                           0x0003FC00L
//DC_PERFMON9_PERFMON_CVALUE_INT_MISC
#define DC_PERFMON9_PERFMON_CVALUE_INT_MISC__PERFCOUNTER_INT0_STATUS__SHIFT                                   0x0
#define DC_PERFMON9_PERFMON_CVALUE_INT_MISC__PERFCOUNTER_INT1_STATUS__SHIFT                                   0x1
#define DC_PERFMON9_PERFMON_CVALUE_INT_MISC__PERFCOUNTER_INT2_STATUS__SHIFT                                   0x2
#define DC_PERFMON9_PERFMON_CVALUE_INT_MISC__PERFCOUNTER_INT3_STATUS__SHIFT                                   0x3
#define DC_PERFMON9_PERFMON_CVALUE_INT_MISC__PERFCOUNTER_INT4_STATUS__SHIFT                                   0x4
#define DC_PERFMON9_PERFMON_CVALUE_INT_MISC__PERFCOUNTER_INT5_STATUS__SHIFT                                   0x5
#define DC_PERFMON9_PERFMON_CVALUE_INT_MISC__PERFCOUNTER_INT6_STATUS__SHIFT                                   0x6
#define DC_PERFMON9_PERFMON_CVALUE_INT_MISC__PERFCOUNTER_INT7_STATUS__SHIFT                                   0x7
#define DC_PERFMON9_PERFMON_CVALUE_INT_MISC__PERFCOUNTER_INT0_ACK__SHIFT                                      0x8
#define DC_PERFMON9_PERFMON_CVALUE_INT_MISC__PERFCOUNTER_INT1_ACK__SHIFT                                      0x9
#define DC_PERFMON9_PERFMON_CVALUE_INT_MISC__PERFCOUNTER_INT2_ACK__SHIFT                                      0xa
#define DC_PERFMON9_PERFMON_CVALUE_INT_MISC__PERFCOUNTER_INT3_ACK__SHIFT                                      0xb
#define DC_PERFMON9_PERFMON_CVALUE_INT_MISC__PERFCOUNTER_INT4_ACK__SHIFT                                      0xc
#define DC_PERFMON9_PERFMON_CVALUE_INT_MISC__PERFCOUNTER_INT5_ACK__SHIFT                                      0xd
#define DC_PERFMON9_PERFMON_CVALUE_INT_MISC__PERFCOUNTER_INT6_ACK__SHIFT                                      0xe
#define DC_PERFMON9_PERFMON_CVALUE_INT_MISC__PERFCOUNTER_INT7_ACK__SHIFT                                      0xf
#define DC_PERFMON9_PERFMON_CVALUE_INT_MISC__PERFMON_CVALUE_HI__SHIFT                                         0x10
#define DC_PERFMON9_PERFMON_CVALUE_INT_MISC__PERFCOUNTER_INT0_STATUS_MASK                                     0x00000001L
#define DC_PERFMON9_PERFMON_CVALUE_INT_MISC__PERFCOUNTER_INT1_STATUS_MASK                                     0x00000002L
#define DC_PERFMON9_PERFMON_CVALUE_INT_MISC__PERFCOUNTER_INT2_STATUS_MASK                                     0x00000004L
#define DC_PERFMON9_PERFMON_CVALUE_INT_MISC__PERFCOUNTER_INT3_STATUS_MASK                                     0x00000008L
#define DC_PERFMON9_PERFMON_CVALUE_INT_MISC__PERFCOUNTER_INT4_STATUS_MASK                                     0x00000010L
#define DC_PERFMON9_PERFMON_CVALUE_INT_MISC__PERFCOUNTER_INT5_STATUS_MASK                                     0x00000020L
#define DC_PERFMON9_PERFMON_CVALUE_INT_MISC__PERFCOUNTER_INT6_STATUS_MASK                                     0x00000040L
#define DC_PERFMON9_PERFMON_CVALUE_INT_MISC__PERFCOUNTER_INT7_STATUS_MASK                                     0x00000080L
#define DC_PERFMON9_PERFMON_CVALUE_INT_MISC__PERFCOUNTER_INT0_ACK_MASK                                        0x00000100L
#define DC_PERFMON9_PERFMON_CVALUE_INT_MISC__PERFCOUNTER_INT1_ACK_MASK                                        0x00000200L
#define DC_PERFMON9_PERFMON_CVALUE_INT_MISC__PERFCOUNTER_INT2_ACK_MASK                                        0x00000400L
#define DC_PERFMON9_PERFMON_CVALUE_INT_MISC__PERFCOUNTER_INT3_ACK_MASK                                        0x00000800L
#define DC_PERFMON9_PERFMON_CVALUE_INT_MISC__PERFCOUNTER_INT4_ACK_MASK                                        0x00001000L
#define DC_PERFMON9_PERFMON_CVALUE_INT_MISC__PERFCOUNTER_INT5_ACK_MASK                                        0x00002000L
#define DC_PERFMON9_PERFMON_CVALUE_INT_MISC__PERFCOUNTER_INT6_ACK_MASK                                        0x00004000L
#define DC_PERFMON9_PERFMON_CVALUE_INT_MISC__PERFCOUNTER_INT7_ACK_MASK                                        0x00008000L
#define DC_PERFMON9_PERFMON_CVALUE_INT_MISC__PERFMON_CVALUE_HI_MASK                                           0xFFFF0000L
//DC_PERFMON9_PERFMON_CVALUE_LOW
#define DC_PERFMON9_PERFMON_CVALUE_LOW__PERFMON_CVALUE_LOW__SHIFT                                             0x0
#define DC_PERFMON9_PERFMON_CVALUE_LOW__PERFMON_CVALUE_LOW_MASK                                               0xFFFFFFFFL
//DC_PERFMON9_PERFMON_HI
#define DC_PERFMON9_PERFMON_HI__PERFMON_HI__SHIFT                                                             0x0
#define DC_PERFMON9_PERFMON_HI__PERFMON_READ_SEL__SHIFT                                                       0x1d
#define DC_PERFMON9_PERFMON_HI__PERFMON_HI_MASK                                                               0x0000FFFFL
#define DC_PERFMON9_PERFMON_HI__PERFMON_READ_SEL_MASK                                                         0xE0000000L
//DC_PERFMON9_PERFMON_LOW
#define DC_PERFMON9_PERFMON_LOW__PERFMON_LOW__SHIFT                                                           0x0
#define DC_PERFMON9_PERFMON_LOW__PERFMON_LOW_MASK                                                             0xFFFFFFFFL


// addressBlock: dce_dc_dispdec
//VGA_MEM_WRITE_PAGE_ADDR
#define VGA_MEM_WRITE_PAGE_ADDR__VGA_MEM_WRITE_PAGE0_ADDR__SHIFT                                              0x0
#define VGA_MEM_WRITE_PAGE_ADDR__VGA_MEM_WRITE_PAGE1_ADDR__SHIFT                                              0x10
#define VGA_MEM_WRITE_PAGE_ADDR__VGA_MEM_WRITE_PAGE0_ADDR_MASK                                                0x000003FFL
#define VGA_MEM_WRITE_PAGE_ADDR__VGA_MEM_WRITE_PAGE1_ADDR_MASK                                                0x03FF0000L
//VGA_MEM_READ_PAGE_ADDR
#define VGA_MEM_READ_PAGE_ADDR__VGA_MEM_READ_PAGE0_ADDR__SHIFT                                                0x0
#define VGA_MEM_READ_PAGE_ADDR__VGA_MEM_READ_PAGE1_ADDR__SHIFT                                                0x10
#define VGA_MEM_READ_PAGE_ADDR__VGA_MEM_READ_PAGE0_ADDR_MASK                                                  0x000003FFL
#define VGA_MEM_READ_PAGE_ADDR__VGA_MEM_READ_PAGE1_ADDR_MASK                                                  0x03FF0000L
//VGA_RENDER_CONTROL
#define VGA_RENDER_CONTROL__VGA_BLINK_RATE__SHIFT                                                             0x0
#define VGA_RENDER_CONTROL__VGA_BLINK_MODE__SHIFT                                                             0x5
#define VGA_RENDER_CONTROL__VGA_CURSOR_BLINK_INVERT__SHIFT                                                    0x7
#define VGA_RENDER_CONTROL__VGA_EXTD_ADDR_COUNT_ENABLE__SHIFT                                                 0x8
#define VGA_RENDER_CONTROL__VGA_VSTATUS_CNTL__SHIFT                                                           0x10
#define VGA_RENDER_CONTROL__VGA_LOCK_8DOT__SHIFT                                                              0x18
#define VGA_RENDER_CONTROL__VGAREG_LINECMP_COMPATIBILITY_SEL__SHIFT                                           0x19
#define VGA_RENDER_CONTROL__VGA_BLINK_RATE_MASK                                                               0x0000001FL
#define VGA_RENDER_CONTROL__VGA_BLINK_MODE_MASK                                                               0x00000060L
#define VGA_RENDER_CONTROL__VGA_CURSOR_BLINK_INVERT_MASK                                                      0x00000080L
#define VGA_RENDER_CONTROL__VGA_EXTD_ADDR_COUNT_ENABLE_MASK                                                   0x00000100L
#define VGA_RENDER_CONTROL__VGA_VSTATUS_CNTL_MASK                                                             0x00030000L
#define VGA_RENDER_CONTROL__VGA_LOCK_8DOT_MASK                                                                0x01000000L
#define VGA_RENDER_CONTROL__VGAREG_LINECMP_COMPATIBILITY_SEL_MASK                                             0x02000000L
//VGA_SEQUENCER_RESET_CONTROL
#define VGA_SEQUENCER_RESET_CONTROL__D1_BLANK_DISPLAY_WHEN_SEQUENCER_RESET__SHIFT                             0x0
#define VGA_SEQUENCER_RESET_CONTROL__D2_BLANK_DISPLAY_WHEN_SEQUENCER_RESET__SHIFT                             0x1
#define VGA_SEQUENCER_RESET_CONTROL__D3_BLANK_DISPLAY_WHEN_SEQUENCER_RESET__SHIFT                             0x2
#define VGA_SEQUENCER_RESET_CONTROL__D4_BLANK_DISPLAY_WHEN_SEQUENCER_RESET__SHIFT                             0x3
#define VGA_SEQUENCER_RESET_CONTROL__D5_BLANK_DISPLAY_WHEN_SEQUENCER_RESET__SHIFT                             0x4
#define VGA_SEQUENCER_RESET_CONTROL__D6_BLANK_DISPLAY_WHEN_SEQUENCER_RESET__SHIFT                             0x5
#define VGA_SEQUENCER_RESET_CONTROL__D1_DISABLE_SYNCS_AND_DE_WHEN_SEQUENCER_RESET__SHIFT                      0x8
#define VGA_SEQUENCER_RESET_CONTROL__D2_DISABLE_SYNCS_AND_DE_WHEN_SEQUENCER_RESET__SHIFT                      0x9
#define VGA_SEQUENCER_RESET_CONTROL__D3_DISABLE_SYNCS_AND_DE_WHEN_SEQUENCER_RESET__SHIFT                      0xa
#define VGA_SEQUENCER_RESET_CONTROL__D4_DISABLE_SYNCS_AND_DE_WHEN_SEQUENCER_RESET__SHIFT                      0xb
#define VGA_SEQUENCER_RESET_CONTROL__D5_DISABLE_SYNCS_AND_DE_WHEN_SEQUENCER_RESET__SHIFT                      0xc
#define VGA_SEQUENCER_RESET_CONTROL__D6_DISABLE_SYNCS_AND_DE_WHEN_SEQUENCER_RESET__SHIFT                      0xd
#define VGA_SEQUENCER_RESET_CONTROL__VGA_MODE_AUTO_TRIGGER_ENABLE__SHIFT                                      0x10
#define VGA_SEQUENCER_RESET_CONTROL__VGA_MODE_AUTO_TRIGGER_REGISTER_SELECT__SHIFT                             0x11
#define VGA_SEQUENCER_RESET_CONTROL__VGA_MODE_AUTO_TRIGGER_INDEX_SELECT__SHIFT                                0x12
#define VGA_SEQUENCER_RESET_CONTROL__D1_BLANK_DISPLAY_WHEN_SEQUENCER_RESET_MASK                               0x00000001L
#define VGA_SEQUENCER_RESET_CONTROL__D2_BLANK_DISPLAY_WHEN_SEQUENCER_RESET_MASK                               0x00000002L
#define VGA_SEQUENCER_RESET_CONTROL__D3_BLANK_DISPLAY_WHEN_SEQUENCER_RESET_MASK                               0x00000004L
#define VGA_SEQUENCER_RESET_CONTROL__D4_BLANK_DISPLAY_WHEN_SEQUENCER_RESET_MASK                               0x00000008L
#define VGA_SEQUENCER_RESET_CONTROL__D5_BLANK_DISPLAY_WHEN_SEQUENCER_RESET_MASK                               0x00000010L
#define VGA_SEQUENCER_RESET_CONTROL__D6_BLANK_DISPLAY_WHEN_SEQUENCER_RESET_MASK                               0x00000020L
#define VGA_SEQUENCER_RESET_CONTROL__D1_DISABLE_SYNCS_AND_DE_WHEN_SEQUENCER_RESET_MASK                        0x00000100L
#define VGA_SEQUENCER_RESET_CONTROL__D2_DISABLE_SYNCS_AND_DE_WHEN_SEQUENCER_RESET_MASK                        0x00000200L
#define VGA_SEQUENCER_RESET_CONTROL__D3_DISABLE_SYNCS_AND_DE_WHEN_SEQUENCER_RESET_MASK                        0x00000400L
#define VGA_SEQUENCER_RESET_CONTROL__D4_DISABLE_SYNCS_AND_DE_WHEN_SEQUENCER_RESET_MASK                        0x00000800L
#define VGA_SEQUENCER_RESET_CONTROL__D5_DISABLE_SYNCS_AND_DE_WHEN_SEQUENCER_RESET_MASK                        0x00001000L
#define VGA_SEQUENCER_RESET_CONTROL__D6_DISABLE_SYNCS_AND_DE_WHEN_SEQUENCER_RESET_MASK                        0x00002000L
#define VGA_SEQUENCER_RESET_CONTROL__VGA_MODE_AUTO_TRIGGER_ENABLE_MASK                                        0x00010000L
#define VGA_SEQUENCER_RESET_CONTROL__VGA_MODE_AUTO_TRIGGER_REGISTER_SELECT_MASK                               0x00020000L
#define VGA_SEQUENCER_RESET_CONTROL__VGA_MODE_AUTO_TRIGGER_INDEX_SELECT_MASK                                  0x00FC0000L
//VGA_MODE_CONTROL
#define VGA_MODE_CONTROL__VGA_ATI_LINEAR__SHIFT                                                               0x0
#define VGA_MODE_CONTROL__VGA_LUT_PALETTE_UPDATE_MODE__SHIFT                                                  0x4
#define VGA_MODE_CONTROL__VGA_128K_APERTURE_PAGING__SHIFT                                                     0x8
#define VGA_MODE_CONTROL__VGA_TEXT_132_COLUMNS_EN__SHIFT                                                      0x10
#define VGA_MODE_CONTROL__VGA_DEEP_SLEEP_FORCE_EXIT__SHIFT                                                    0x18
#define VGA_MODE_CONTROL__VGA_ATI_LINEAR_MASK                                                                 0x00000001L
#define VGA_MODE_CONTROL__VGA_LUT_PALETTE_UPDATE_MODE_MASK                                                    0x00000030L
#define VGA_MODE_CONTROL__VGA_128K_APERTURE_PAGING_MASK                                                       0x00000100L
#define VGA_MODE_CONTROL__VGA_TEXT_132_COLUMNS_EN_MASK                                                        0x00010000L
#define VGA_MODE_CONTROL__VGA_DEEP_SLEEP_FORCE_EXIT_MASK                                                      0x01000000L
//VGA_SURFACE_PITCH_SELECT
#define VGA_SURFACE_PITCH_SELECT__VGA_SURFACE_PITCH_SELECT__SHIFT                                             0x0
#define VGA_SURFACE_PITCH_SELECT__VGA_SURFACE_HEIGHT_SELECT__SHIFT                                            0x8
#define VGA_SURFACE_PITCH_SELECT__VGA_SURFACE_PITCH_SELECT_MASK                                               0x00000003L
#define VGA_SURFACE_PITCH_SELECT__VGA_SURFACE_HEIGHT_SELECT_MASK                                              0x00000300L
//VGA_MEMORY_BASE_ADDRESS
#define VGA_MEMORY_BASE_ADDRESS__VGA_MEMORY_BASE_ADDRESS__SHIFT                                               0x0
#define VGA_MEMORY_BASE_ADDRESS__VGA_MEMORY_BASE_ADDRESS_MASK                                                 0xFFFFFFFFL
//VGA_DISPBUF1_SURFACE_ADDR
#define VGA_DISPBUF1_SURFACE_ADDR__VGA_DISPBUF1_SURFACE_ADDR__SHIFT                                           0x0
#define VGA_DISPBUF1_SURFACE_ADDR__VGA_DISPBUF1_SURFACE_ADDR_MASK                                             0x01FFFFFFL
//VGA_DISPBUF2_SURFACE_ADDR
#define VGA_DISPBUF2_SURFACE_ADDR__VGA_DISPBUF2_SURFACE_ADDR__SHIFT                                           0x0
#define VGA_DISPBUF2_SURFACE_ADDR__VGA_DISPBUF2_SURFACE_ADDR_MASK                                             0x01FFFFFFL
//VGA_MEMORY_BASE_ADDRESS_HIGH
#define VGA_MEMORY_BASE_ADDRESS_HIGH__VGA_MEMORY_BASE_ADDRESS_HIGH__SHIFT                                     0x0
#define VGA_MEMORY_BASE_ADDRESS_HIGH__VGA_MEMORY_BASE_ADDRESS_HIGH_MASK                                       0x000000FFL
//VGA_HDP_CONTROL
#define VGA_HDP_CONTROL__VGA_MEM_PAGE_SELECT_EN__SHIFT                                                        0x0
#define VGA_HDP_CONTROL__VGA_MEMORY_DISABLE__SHIFT                                                            0x4
#define VGA_HDP_CONTROL__VGA_RBBM_LOCK_DISABLE__SHIFT                                                         0x8
#define VGA_HDP_CONTROL__VGA_SOFT_RESET__SHIFT                                                                0x10
#define VGA_HDP_CONTROL__VGA_TEST_RESET_CONTROL__SHIFT                                                        0x18
#define VGA_HDP_CONTROL__VGA_MEM_PAGE_SELECT_EN_MASK                                                          0x00000001L
#define VGA_HDP_CONTROL__VGA_MEMORY_DISABLE_MASK                                                              0x00000010L
#define VGA_HDP_CONTROL__VGA_RBBM_LOCK_DISABLE_MASK                                                           0x00000100L
#define VGA_HDP_CONTROL__VGA_SOFT_RESET_MASK                                                                  0x00010000L
#define VGA_HDP_CONTROL__VGA_TEST_RESET_CONTROL_MASK                                                          0x01000000L
//VGA_CACHE_CONTROL
#define VGA_CACHE_CONTROL__VGA_WRITE_THROUGH_CACHE_DIS__SHIFT                                                 0x0
#define VGA_CACHE_CONTROL__VGA_READ_CACHE_DISABLE__SHIFT                                                      0x8
#define VGA_CACHE_CONTROL__VGA_READ_BUFFER_INVALIDATE__SHIFT                                                  0x10
#define VGA_CACHE_CONTROL__VGA_DCCIF_W256ONLY__SHIFT                                                          0x14
#define VGA_CACHE_CONTROL__VGA_DCCIF_WC_TIMEOUT__SHIFT                                                        0x18
#define VGA_CACHE_CONTROL__VGA_WRITE_THROUGH_CACHE_DIS_MASK                                                   0x00000001L
#define VGA_CACHE_CONTROL__VGA_READ_CACHE_DISABLE_MASK                                                        0x00000100L
#define VGA_CACHE_CONTROL__VGA_READ_BUFFER_INVALIDATE_MASK                                                    0x00010000L
#define VGA_CACHE_CONTROL__VGA_DCCIF_W256ONLY_MASK                                                            0x00100000L
#define VGA_CACHE_CONTROL__VGA_DCCIF_WC_TIMEOUT_MASK                                                          0x3F000000L
//D1VGA_CONTROL
#define D1VGA_CONTROL__D1VGA_MODE_ENABLE__SHIFT                                                               0x0
#define D1VGA_CONTROL__D1VGA_TIMING_SELECT__SHIFT                                                             0x8
#define D1VGA_CONTROL__D1VGA_SYNC_POLARITY_SELECT__SHIFT                                                      0x9
#define D1VGA_CONTROL__D1VGA_OVERSCAN_COLOR_EN__SHIFT                                                         0x10
#define D1VGA_CONTROL__D1VGA_ROTATE__SHIFT                                                                    0x18
#define D1VGA_CONTROL__D1VGA_MODE_ENABLE_MASK                                                                 0x00000001L
#define D1VGA_CONTROL__D1VGA_TIMING_SELECT_MASK                                                               0x00000100L
#define D1VGA_CONTROL__D1VGA_SYNC_POLARITY_SELECT_MASK                                                        0x00000200L
#define D1VGA_CONTROL__D1VGA_OVERSCAN_COLOR_EN_MASK                                                           0x00010000L
#define D1VGA_CONTROL__D1VGA_ROTATE_MASK                                                                      0x03000000L
//D2VGA_CONTROL
#define D2VGA_CONTROL__D2VGA_MODE_ENABLE__SHIFT                                                               0x0
#define D2VGA_CONTROL__D2VGA_TIMING_SELECT__SHIFT                                                             0x8
#define D2VGA_CONTROL__D2VGA_SYNC_POLARITY_SELECT__SHIFT                                                      0x9
#define D2VGA_CONTROL__D2VGA_OVERSCAN_COLOR_EN__SHIFT                                                         0x10
#define D2VGA_CONTROL__D2VGA_ROTATE__SHIFT                                                                    0x18
#define D2VGA_CONTROL__D2VGA_MODE_ENABLE_MASK                                                                 0x00000001L
#define D2VGA_CONTROL__D2VGA_TIMING_SELECT_MASK                                                               0x00000100L
#define D2VGA_CONTROL__D2VGA_SYNC_POLARITY_SELECT_MASK                                                        0x00000200L
#define D2VGA_CONTROL__D2VGA_OVERSCAN_COLOR_EN_MASK                                                           0x00010000L
#define D2VGA_CONTROL__D2VGA_ROTATE_MASK                                                                      0x03000000L
//VGA_STATUS
#define VGA_STATUS__VGA_MEM_ACCESS_STATUS__SHIFT                                                              0x0
#define VGA_STATUS__VGA_REG_ACCESS_STATUS__SHIFT                                                              0x1
#define VGA_STATUS__VGA_DISPLAY_SWITCH_STATUS__SHIFT                                                          0x2
#define VGA_STATUS__VGA_MODE_AUTO_TRIGGER_STATUS__SHIFT                                                       0x3
#define VGA_STATUS__VGA_MEM_ACCESS_STATUS_MASK                                                                0x00000001L
#define VGA_STATUS__VGA_REG_ACCESS_STATUS_MASK                                                                0x00000002L
#define VGA_STATUS__VGA_DISPLAY_SWITCH_STATUS_MASK                                                            0x00000004L
#define VGA_STATUS__VGA_MODE_AUTO_TRIGGER_STATUS_MASK                                                         0x00000008L
//VGA_INTERRUPT_CONTROL
#define VGA_INTERRUPT_CONTROL__VGA_MEM_ACCESS_INT_MASK__SHIFT                                                 0x0
#define VGA_INTERRUPT_CONTROL__VGA_REG_ACCESS_INT_MASK__SHIFT                                                 0x8
#define VGA_INTERRUPT_CONTROL__VGA_DISPLAY_SWITCH_INT_MASK__SHIFT                                             0x10
#define VGA_INTERRUPT_CONTROL__VGA_MODE_AUTO_TRIGGER_INT_MASK__SHIFT                                          0x18
#define VGA_INTERRUPT_CONTROL__VGA_MEM_ACCESS_INT_MASK_MASK                                                   0x00000001L
#define VGA_INTERRUPT_CONTROL__VGA_REG_ACCESS_INT_MASK_MASK                                                   0x00000100L
#define VGA_INTERRUPT_CONTROL__VGA_DISPLAY_SWITCH_INT_MASK_MASK                                               0x00010000L
#define VGA_INTERRUPT_CONTROL__VGA_MODE_AUTO_TRIGGER_INT_MASK_MASK                                            0x01000000L
//VGA_STATUS_CLEAR
#define VGA_STATUS_CLEAR__VGA_MEM_ACCESS_INT_CLEAR__SHIFT                                                     0x0
#define VGA_STATUS_CLEAR__VGA_REG_ACCESS_INT_CLEAR__SHIFT                                                     0x8
#define VGA_STATUS_CLEAR__VGA_DISPLAY_SWITCH_INT_CLEAR__SHIFT                                                 0x10
#define VGA_STATUS_CLEAR__VGA_MODE_AUTO_TRIGGER_INT_CLEAR__SHIFT                                              0x18
#define VGA_STATUS_CLEAR__VGA_MEM_ACCESS_INT_CLEAR_MASK                                                       0x00000001L
#define VGA_STATUS_CLEAR__VGA_REG_ACCESS_INT_CLEAR_MASK                                                       0x00000100L
#define VGA_STATUS_CLEAR__VGA_DISPLAY_SWITCH_INT_CLEAR_MASK                                                   0x00010000L
#define VGA_STATUS_CLEAR__VGA_MODE_AUTO_TRIGGER_INT_CLEAR_MASK                                                0x01000000L
//VGA_INTERRUPT_STATUS
#define VGA_INTERRUPT_STATUS__VGA_MEM_ACCESS_INT_STATUS__SHIFT                                                0x0
#define VGA_INTERRUPT_STATUS__VGA_REG_ACCESS_INT_STATUS__SHIFT                                                0x1
#define VGA_INTERRUPT_STATUS__VGA_DISPLAY_SWITCH_INT_STATUS__SHIFT                                            0x2
#define VGA_INTERRUPT_STATUS__VGA_MODE_AUTO_TRIGGER_INT_STATUS__SHIFT                                         0x3
#define VGA_INTERRUPT_STATUS__VGA_MEM_ACCESS_INT_STATUS_MASK                                                  0x00000001L
#define VGA_INTERRUPT_STATUS__VGA_REG_ACCESS_INT_STATUS_MASK                                                  0x00000002L
#define VGA_INTERRUPT_STATUS__VGA_DISPLAY_SWITCH_INT_STATUS_MASK                                              0x00000004L
#define VGA_INTERRUPT_STATUS__VGA_MODE_AUTO_TRIGGER_INT_STATUS_MASK                                           0x00000008L
//VGA_MAIN_CONTROL
#define VGA_MAIN_CONTROL__VGA_CRTC_TIMEOUT__SHIFT                                                             0x0
#define VGA_MAIN_CONTROL__VGA_RENDER_TIMEOUT_COUNT__SHIFT                                                     0x3
#define VGA_MAIN_CONTROL__VGA_VIRTUAL_VERTICAL_RETRACE_DURATION__SHIFT                                        0x5
#define VGA_MAIN_CONTROL__VGA_READBACK_VGA_VSTATUS_SOURCE_SELECT__SHIFT                                       0x8
#define VGA_MAIN_CONTROL__VGA_MC_WRITE_CLEAN_WAIT_DELAY__SHIFT                                                0xc
#define VGA_MAIN_CONTROL__VGA_READBACK_NO_DISPLAY_SOURCE_SELECT__SHIFT                                        0x10
#define VGA_MAIN_CONTROL__VGA_READBACK_CRT_INTR_SOURCE_SELECT__SHIFT                                          0x18
#define VGA_MAIN_CONTROL__VGA_READBACK_SENSE_SWITCH_SELECT__SHIFT                                             0x1a
#define VGA_MAIN_CONTROL__VGA_EXTERNAL_DAC_SENSE__SHIFT                                                       0x1d
#define VGA_MAIN_CONTROL__VGA_MAIN_TEST_VSTATUS_NO_DISPLAY_CRTC_TIMEOUT__SHIFT                                0x1f
#define VGA_MAIN_CONTROL__VGA_CRTC_TIMEOUT_MASK                                                               0x00000003L
#define VGA_MAIN_CONTROL__VGA_RENDER_TIMEOUT_COUNT_MASK                                                       0x00000018L
#define VGA_MAIN_CONTROL__VGA_VIRTUAL_VERTICAL_RETRACE_DURATION_MASK                                          0x000000E0L
#define VGA_MAIN_CONTROL__VGA_READBACK_VGA_VSTATUS_SOURCE_SELECT_MASK                                         0x00000300L
#define VGA_MAIN_CONTROL__VGA_MC_WRITE_CLEAN_WAIT_DELAY_MASK                                                  0x0000F000L
#define VGA_MAIN_CONTROL__VGA_READBACK_NO_DISPLAY_SOURCE_SELECT_MASK                                          0x00030000L
#define VGA_MAIN_CONTROL__VGA_READBACK_CRT_INTR_SOURCE_SELECT_MASK                                            0x03000000L
#define VGA_MAIN_CONTROL__VGA_READBACK_SENSE_SWITCH_SELECT_MASK                                               0x04000000L
#define VGA_MAIN_CONTROL__VGA_EXTERNAL_DAC_SENSE_MASK                                                         0x20000000L
#define VGA_MAIN_CONTROL__VGA_MAIN_TEST_VSTATUS_NO_DISPLAY_CRTC_TIMEOUT_MASK                                  0x80000000L
//VGA_TEST_CONTROL
#define VGA_TEST_CONTROL__VGA_TEST_ENABLE__SHIFT                                                              0x0
#define VGA_TEST_CONTROL__VGA_TEST_RENDER_START__SHIFT                                                        0x8
#define VGA_TEST_CONTROL__VGA_TEST_RENDER_DONE__SHIFT                                                         0x10
#define VGA_TEST_CONTROL__VGA_TEST_RENDER_DISPBUF_SELECT__SHIFT                                               0x18
#define VGA_TEST_CONTROL__VGA_TEST_ENABLE_MASK                                                                0x00000001L
#define VGA_TEST_CONTROL__VGA_TEST_RENDER_START_MASK                                                          0x00000100L
#define VGA_TEST_CONTROL__VGA_TEST_RENDER_DONE_MASK                                                           0x00010000L
#define VGA_TEST_CONTROL__VGA_TEST_RENDER_DISPBUF_SELECT_MASK                                                 0x01000000L
//VGA_QOS_CTRL
#define VGA_QOS_CTRL__VGA_READ_QOS__SHIFT                                                                     0x0
#define VGA_QOS_CTRL__VGA_WRITE_QOS__SHIFT                                                                    0x4
#define VGA_QOS_CTRL__VGA_READ_QOS_MASK                                                                       0x0000000FL
#define VGA_QOS_CTRL__VGA_WRITE_QOS_MASK                                                                      0x000000F0L
//CRTC8_IDX
#define CRTC8_IDX__VCRTC_IDX__SHIFT                                                                           0x0
#define CRTC8_IDX__VCRTC_IDX_MASK                                                                             0x3FL
//CRTC8_DATA
#define CRTC8_DATA__VCRTC_DATA__SHIFT                                                                         0x0
#define CRTC8_DATA__VCRTC_DATA_MASK                                                                           0xFFL
//GENFC_WT
#define GENFC_WT__VSYNC_SEL_W__SHIFT                                                                          0x3
#define GENFC_WT__VSYNC_SEL_W_MASK                                                                            0x08L
//GENS1
#define GENS1__NO_DISPLAY__SHIFT                                                                              0x0
#define GENS1__VGA_VSTATUS__SHIFT                                                                             0x3
#define GENS1__PIXEL_READ_BACK__SHIFT                                                                         0x4
#define GENS1__NO_DISPLAY_MASK                                                                                0x01L
#define GENS1__VGA_VSTATUS_MASK                                                                               0x08L
#define GENS1__PIXEL_READ_BACK_MASK                                                                           0x30L
//ATTRDW
#define ATTRDW__ATTR_DATA__SHIFT                                                                              0x0
#define ATTRDW__ATTR_DATA_MASK                                                                                0xFFL
//ATTRX
#define ATTRX__ATTR_IDX__SHIFT                                                                                0x0
#define ATTRX__ATTR_PAL_RW_ENB__SHIFT                                                                         0x5
#define ATTRX__ATTR_IDX_MASK                                                                                  0x1FL
#define ATTRX__ATTR_PAL_RW_ENB_MASK                                                                           0x20L
//ATTRDR
#define ATTRDR__ATTR_DATA__SHIFT                                                                              0x0
#define ATTRDR__ATTR_DATA_MASK                                                                                0xFFL
//GENMO_WT
#define GENMO_WT__GENMO_MONO_ADDRESS_B__SHIFT                                                                 0x0
#define GENMO_WT__VGA_RAM_EN__SHIFT                                                                           0x1
#define GENMO_WT__VGA_CKSEL__SHIFT                                                                            0x2
#define GENMO_WT__ODD_EVEN_MD_PGSEL__SHIFT                                                                    0x5
#define GENMO_WT__VGA_HSYNC_POL__SHIFT                                                                        0x6
#define GENMO_WT__VGA_VSYNC_POL__SHIFT                                                                        0x7
#define GENMO_WT__GENMO_MONO_ADDRESS_B_MASK                                                                   0x01L
#define GENMO_WT__VGA_RAM_EN_MASK                                                                             0x02L
#define GENMO_WT__VGA_CKSEL_MASK                                                                              0x0CL
#define GENMO_WT__ODD_EVEN_MD_PGSEL_MASK                                                                      0x20L
#define GENMO_WT__VGA_HSYNC_POL_MASK                                                                          0x40L
#define GENMO_WT__VGA_VSYNC_POL_MASK                                                                          0x80L
//GENS0
#define GENS0__SENSE_SWITCH__SHIFT                                                                            0x4
#define GENS0__CRT_INTR__SHIFT                                                                                0x7
#define GENS0__SENSE_SWITCH_MASK                                                                              0x10L
#define GENS0__CRT_INTR_MASK                                                                                  0x80L
//GENENB
#define GENENB__BLK_IO_BASE__SHIFT                                                                            0x0
#define GENENB__BLK_IO_BASE_MASK                                                                              0xFFL
//SEQ8_IDX
#define SEQ8_IDX__SEQ_IDX__SHIFT                                                                              0x0
#define SEQ8_IDX__SEQ_IDX_MASK                                                                                0x07L
//SEQ8_DATA
#define SEQ8_DATA__SEQ_DATA__SHIFT                                                                            0x0
#define SEQ8_DATA__SEQ_DATA_MASK                                                                              0xFFL
//DAC_MASK
#define DAC_MASK__DAC_MASK__SHIFT                                                                             0x0
#define DAC_MASK__DAC_MASK_MASK                                                                               0xFFL
//DAC_R_INDEX
#define DAC_R_INDEX__DAC_R_INDEX__SHIFT                                                                       0x0
#define DAC_R_INDEX__DAC_R_INDEX_MASK                                                                         0xFFL
//DAC_W_INDEX
#define DAC_W_INDEX__DAC_W_INDEX__SHIFT                                                                       0x0
#define DAC_W_INDEX__DAC_W_INDEX_MASK                                                                         0xFFL
//DAC_DATA
#define DAC_DATA__DAC_DATA__SHIFT                                                                             0x0
#define DAC_DATA__DAC_DATA_MASK                                                                               0x3FL
//GENFC_RD
#define GENFC_RD__VSYNC_SEL_R__SHIFT                                                                          0x3
#define GENFC_RD__VSYNC_SEL_R_MASK                                                                            0x08L
//GENMO_RD
#define GENMO_RD__GENMO_MONO_ADDRESS_B__SHIFT                                                                 0x0
#define GENMO_RD__VGA_RAM_EN__SHIFT                                                                           0x1
#define GENMO_RD__VGA_CKSEL__SHIFT                                                                            0x2
#define GENMO_RD__ODD_EVEN_MD_PGSEL__SHIFT                                                                    0x5
#define GENMO_RD__VGA_HSYNC_POL__SHIFT                                                                        0x6
#define GENMO_RD__VGA_VSYNC_POL__SHIFT                                                                        0x7
#define GENMO_RD__GENMO_MONO_ADDRESS_B_MASK                                                                   0x01L
#define GENMO_RD__VGA_RAM_EN_MASK                                                                             0x02L
#define GENMO_RD__VGA_CKSEL_MASK                                                                              0x0CL
#define GENMO_RD__ODD_EVEN_MD_PGSEL_MASK                                                                      0x20L
#define GENMO_RD__VGA_HSYNC_POL_MASK                                                                          0x40L
#define GENMO_RD__VGA_VSYNC_POL_MASK                                                                          0x80L
//GRPH8_IDX
#define GRPH8_IDX__GRPH_IDX__SHIFT                                                                            0x0
#define GRPH8_IDX__GRPH_IDX_MASK                                                                              0x0FL
//GRPH8_DATA
#define GRPH8_DATA__GRPH_DATA__SHIFT                                                                          0x0
#define GRPH8_DATA__GRPH_DATA_MASK                                                                            0xFFL
//CRTC8_IDX_1
#define CRTC8_IDX_1__VCRTC_IDX__SHIFT                                                                         0x0
#define CRTC8_IDX_1__VCRTC_IDX_MASK                                                                           0x3FL
//CRTC8_DATA_1
#define CRTC8_DATA_1__VCRTC_DATA__SHIFT                                                                       0x0
#define CRTC8_DATA_1__VCRTC_DATA_MASK                                                                         0xFFL
//GENFC_WT_1
#define GENFC_WT_1__VSYNC_SEL_W__SHIFT                                                                        0x3
#define GENFC_WT_1__VSYNC_SEL_W_MASK                                                                          0x08L
//GENS1_1
#define GENS1_1__NO_DISPLAY__SHIFT                                                                            0x0
#define GENS1_1__VGA_VSTATUS__SHIFT                                                                           0x3
#define GENS1_1__PIXEL_READ_BACK__SHIFT                                                                       0x4
#define GENS1_1__NO_DISPLAY_MASK                                                                              0x01L
#define GENS1_1__VGA_VSTATUS_MASK                                                                             0x08L
#define GENS1_1__PIXEL_READ_BACK_MASK                                                                         0x30L
//D3VGA_CONTROL
#define D3VGA_CONTROL__D3VGA_MODE_ENABLE__SHIFT                                                               0x0
#define D3VGA_CONTROL__D3VGA_TIMING_SELECT__SHIFT                                                             0x8
#define D3VGA_CONTROL__D3VGA_SYNC_POLARITY_SELECT__SHIFT                                                      0x9
#define D3VGA_CONTROL__D3VGA_OVERSCAN_COLOR_EN__SHIFT                                                         0x10
#define D3VGA_CONTROL__D3VGA_ROTATE__SHIFT                                                                    0x18
#define D3VGA_CONTROL__D3VGA_MODE_ENABLE_MASK                                                                 0x00000001L
#define D3VGA_CONTROL__D3VGA_TIMING_SELECT_MASK                                                               0x00000100L
#define D3VGA_CONTROL__D3VGA_SYNC_POLARITY_SELECT_MASK                                                        0x00000200L
#define D3VGA_CONTROL__D3VGA_OVERSCAN_COLOR_EN_MASK                                                           0x00010000L
#define D3VGA_CONTROL__D3VGA_ROTATE_MASK                                                                      0x03000000L
//D4VGA_CONTROL
#define D4VGA_CONTROL__D4VGA_MODE_ENABLE__SHIFT                                                               0x0
#define D4VGA_CONTROL__D4VGA_TIMING_SELECT__SHIFT                                                             0x8
#define D4VGA_CONTROL__D4VGA_SYNC_POLARITY_SELECT__SHIFT                                                      0x9
#define D4VGA_CONTROL__D4VGA_OVERSCAN_COLOR_EN__SHIFT                                                         0x10
#define D4VGA_CONTROL__D4VGA_ROTATE__SHIFT                                                                    0x18
#define D4VGA_CONTROL__D4VGA_MODE_ENABLE_MASK                                                                 0x00000001L
#define D4VGA_CONTROL__D4VGA_TIMING_SELECT_MASK                                                               0x00000100L
#define D4VGA_CONTROL__D4VGA_SYNC_POLARITY_SELECT_MASK                                                        0x00000200L
#define D4VGA_CONTROL__D4VGA_OVERSCAN_COLOR_EN_MASK                                                           0x00010000L
#define D4VGA_CONTROL__D4VGA_ROTATE_MASK                                                                      0x03000000L
//D5VGA_CONTROL
#define D5VGA_CONTROL__D5VGA_MODE_ENABLE__SHIFT                                                               0x0
#define D5VGA_CONTROL__D5VGA_TIMING_SELECT__SHIFT                                                             0x8
#define D5VGA_CONTROL__D5VGA_SYNC_POLARITY_SELECT__SHIFT                                                      0x9
#define D5VGA_CONTROL__D5VGA_OVERSCAN_COLOR_EN__SHIFT                                                         0x10
#define D5VGA_CONTROL__D5VGA_ROTATE__SHIFT                                                                    0x18
#define D5VGA_CONTROL__D5VGA_MODE_ENABLE_MASK                                                                 0x00000001L
#define D5VGA_CONTROL__D5VGA_TIMING_SELECT_MASK                                                               0x00000100L
#define D5VGA_CONTROL__D5VGA_SYNC_POLARITY_SELECT_MASK                                                        0x00000200L
#define D5VGA_CONTROL__D5VGA_OVERSCAN_COLOR_EN_MASK                                                           0x00010000L
#define D5VGA_CONTROL__D5VGA_ROTATE_MASK                                                                      0x03000000L
//D6VGA_CONTROL
#define D6VGA_CONTROL__D6VGA_MODE_ENABLE__SHIFT                                                               0x0
#define D6VGA_CONTROL__D6VGA_TIMING_SELECT__SHIFT                                                             0x8
#define D6VGA_CONTROL__D6VGA_SYNC_POLARITY_SELECT__SHIFT                                                      0x9
#define D6VGA_CONTROL__D6VGA_OVERSCAN_COLOR_EN__SHIFT                                                         0x10
#define D6VGA_CONTROL__D6VGA_ROTATE__SHIFT                                                                    0x18
#define D6VGA_CONTROL__D6VGA_MODE_ENABLE_MASK                                                                 0x00000001L
#define D6VGA_CONTROL__D6VGA_TIMING_SELECT_MASK                                                               0x00000100L
#define D6VGA_CONTROL__D6VGA_SYNC_POLARITY_SELECT_MASK                                                        0x00000200L
#define D6VGA_CONTROL__D6VGA_OVERSCAN_COLOR_EN_MASK                                                           0x00010000L
#define D6VGA_CONTROL__D6VGA_ROTATE_MASK                                                                      0x03000000L
//VGA_SOURCE_SELECT
#define VGA_SOURCE_SELECT__VGA_SOURCE_SEL_A__SHIFT                                                            0x0
#define VGA_SOURCE_SELECT__VGA_SOURCE_SEL_B__SHIFT                                                            0x8
#define VGA_SOURCE_SELECT__VGA_SOURCE_SEL_A_MASK                                                              0x00000007L
#define VGA_SOURCE_SELECT__VGA_SOURCE_SEL_B_MASK                                                              0x00000700L
//PHYPLLA_PIXCLK_RESYNC_CNTL
#define PHYPLLA_PIXCLK_RESYNC_CNTL__PHYPLLA_PIXCLK_RESYNC_ENABLE__SHIFT                                       0x0
#define PHYPLLA_PIXCLK_RESYNC_CNTL__PHYPLLA_DCCG_DEEP_COLOR_CNTL__SHIFT                                       0x4
#define PHYPLLA_PIXCLK_RESYNC_CNTL__PHYPLLA_PIXCLK_ENABLE__SHIFT                                              0x8
#define PHYPLLA_PIXCLK_RESYNC_CNTL__PHYPLLA_PIXCLK_DOUBLE_RATE_ENABLE__SHIFT                                  0x9
#define PHYPLLA_PIXCLK_RESYNC_CNTL__PHYPLLA_PIXCLK_RESYNC_ENABLE_MASK                                         0x00000001L
#define PHYPLLA_PIXCLK_RESYNC_CNTL__PHYPLLA_DCCG_DEEP_COLOR_CNTL_MASK                                         0x00000030L
#define PHYPLLA_PIXCLK_RESYNC_CNTL__PHYPLLA_PIXCLK_ENABLE_MASK                                                0x00000100L
#define PHYPLLA_PIXCLK_RESYNC_CNTL__PHYPLLA_PIXCLK_DOUBLE_RATE_ENABLE_MASK                                    0x00000200L
//PHYPLLB_PIXCLK_RESYNC_CNTL
#define PHYPLLB_PIXCLK_RESYNC_CNTL__PHYPLLB_PIXCLK_RESYNC_ENABLE__SHIFT                                       0x0
#define PHYPLLB_PIXCLK_RESYNC_CNTL__PHYPLLB_DCCG_DEEP_COLOR_CNTL__SHIFT                                       0x4
#define PHYPLLB_PIXCLK_RESYNC_CNTL__PHYPLLB_PIXCLK_ENABLE__SHIFT                                              0x8
#define PHYPLLB_PIXCLK_RESYNC_CNTL__PHYPLLB_PIXCLK_DOUBLE_RATE_ENABLE__SHIFT                                  0x9
#define PHYPLLB_PIXCLK_RESYNC_CNTL__PHYPLLB_PIXCLK_RESYNC_ENABLE_MASK                                         0x00000001L
#define PHYPLLB_PIXCLK_RESYNC_CNTL__PHYPLLB_DCCG_DEEP_COLOR_CNTL_MASK                                         0x00000030L
#define PHYPLLB_PIXCLK_RESYNC_CNTL__PHYPLLB_PIXCLK_ENABLE_MASK                                                0x00000100L
#define PHYPLLB_PIXCLK_RESYNC_CNTL__PHYPLLB_PIXCLK_DOUBLE_RATE_ENABLE_MASK                                    0x00000200L
//PHYPLLC_PIXCLK_RESYNC_CNTL
#define PHYPLLC_PIXCLK_RESYNC_CNTL__PHYPLLC_PIXCLK_RESYNC_ENABLE__SHIFT                                       0x0
#define PHYPLLC_PIXCLK_RESYNC_CNTL__PHYPLLC_DCCG_DEEP_COLOR_CNTL__SHIFT                                       0x4
#define PHYPLLC_PIXCLK_RESYNC_CNTL__PHYPLLC_PIXCLK_ENABLE__SHIFT                                              0x8
#define PHYPLLC_PIXCLK_RESYNC_CNTL__PHYPLLC_PIXCLK_DOUBLE_RATE_ENABLE__SHIFT                                  0x9
#define PHYPLLC_PIXCLK_RESYNC_CNTL__PHYPLLC_PIXCLK_RESYNC_ENABLE_MASK                                         0x00000001L
#define PHYPLLC_PIXCLK_RESYNC_CNTL__PHYPLLC_DCCG_DEEP_COLOR_CNTL_MASK                                         0x00000030L
#define PHYPLLC_PIXCLK_RESYNC_CNTL__PHYPLLC_PIXCLK_ENABLE_MASK                                                0x00000100L
#define PHYPLLC_PIXCLK_RESYNC_CNTL__PHYPLLC_PIXCLK_DOUBLE_RATE_ENABLE_MASK                                    0x00000200L
//PHYPLLD_PIXCLK_RESYNC_CNTL
#define PHYPLLD_PIXCLK_RESYNC_CNTL__PHYPLLD_PIXCLK_RESYNC_ENABLE__SHIFT                                       0x0
#define PHYPLLD_PIXCLK_RESYNC_CNTL__PHYPLLD_DCCG_DEEP_COLOR_CNTL__SHIFT                                       0x4
#define PHYPLLD_PIXCLK_RESYNC_CNTL__PHYPLLD_PIXCLK_ENABLE__SHIFT                                              0x8
#define PHYPLLD_PIXCLK_RESYNC_CNTL__PHYPLLD_PIXCLK_DOUBLE_RATE_ENABLE__SHIFT                                  0x9
#define PHYPLLD_PIXCLK_RESYNC_CNTL__PHYPLLD_PIXCLK_RESYNC_ENABLE_MASK                                         0x00000001L
#define PHYPLLD_PIXCLK_RESYNC_CNTL__PHYPLLD_DCCG_DEEP_COLOR_CNTL_MASK                                         0x00000030L
#define PHYPLLD_PIXCLK_RESYNC_CNTL__PHYPLLD_PIXCLK_ENABLE_MASK                                                0x00000100L
#define PHYPLLD_PIXCLK_RESYNC_CNTL__PHYPLLD_PIXCLK_DOUBLE_RATE_ENABLE_MASK                                    0x00000200L
//DCFEV0_CRTC_PIXEL_RATE_CNTL
#define DCFEV0_CRTC_PIXEL_RATE_CNTL__DCFEV0_CRTC_PIXEL_RATE_SOURCE__SHIFT                                     0x0
#define DCFEV0_CRTC_PIXEL_RATE_CNTL__DCFEV0_CRTC_PHYPLL_PIXEL_RATE_SOURCE__SHIFT                              0x8
#define DCFEV0_CRTC_PIXEL_RATE_CNTL__DCFEV0_CRTC_PIXEL_RATE_PLL_SOURCE__SHIFT                                 0xf
#define DCFEV0_CRTC_PIXEL_RATE_CNTL__DCFEV0_CRTC_PIXEL_RATE_SOURCE_MASK                                       0x00000003L
#define DCFEV0_CRTC_PIXEL_RATE_CNTL__DCFEV0_CRTC_PHYPLL_PIXEL_RATE_SOURCE_MASK                                0x00000700L
#define DCFEV0_CRTC_PIXEL_RATE_CNTL__DCFEV0_CRTC_PIXEL_RATE_PLL_SOURCE_MASK                                   0x00008000L
//DCFEV1_CRTC_PIXEL_RATE_CNTL
#define DCFEV1_CRTC_PIXEL_RATE_CNTL__DCFEV1_CRTC_PIXEL_RATE_SOURCE__SHIFT                                     0x0
#define DCFEV1_CRTC_PIXEL_RATE_CNTL__DCFEV1_CRTC_PHYPLL_PIXEL_RATE_SOURCE__SHIFT                              0x8
#define DCFEV1_CRTC_PIXEL_RATE_CNTL__DCFEV1_CRTC_PIXEL_RATE_PLL_SOURCE__SHIFT                                 0xf
#define DCFEV1_CRTC_PIXEL_RATE_CNTL__DCFEV1_CRTC_PIXEL_RATE_SOURCE_MASK                                       0x00000003L
#define DCFEV1_CRTC_PIXEL_RATE_CNTL__DCFEV1_CRTC_PHYPLL_PIXEL_RATE_SOURCE_MASK                                0x00000700L
#define DCFEV1_CRTC_PIXEL_RATE_CNTL__DCFEV1_CRTC_PIXEL_RATE_PLL_SOURCE_MASK                                   0x00008000L
//SYMCLKLPA_CLOCK_ENABLE
#define SYMCLKLPA_CLOCK_ENABLE__SYMCLKLPA_CLOCK_ENABLE__SHIFT                                                 0x0
#define SYMCLKLPA_CLOCK_ENABLE__SYMCLKLPA_FE_FORCE_EN__SHIFT                                                  0x4
#define SYMCLKLPA_CLOCK_ENABLE__SYMCLKLPA_FE_FORCE_SRC__SHIFT                                                 0x8
#define SYMCLKLPA_CLOCK_ENABLE__SYMCLKLPA_CLOCK_ENABLE_MASK                                                   0x00000001L
#define SYMCLKLPA_CLOCK_ENABLE__SYMCLKLPA_FE_FORCE_EN_MASK                                                    0x00000010L
#define SYMCLKLPA_CLOCK_ENABLE__SYMCLKLPA_FE_FORCE_SRC_MASK                                                   0x00000700L
//SYMCLKLPB_CLOCK_ENABLE
#define SYMCLKLPB_CLOCK_ENABLE__SYMCLKLPB_CLOCK_ENABLE__SHIFT                                                 0x0
#define SYMCLKLPB_CLOCK_ENABLE__SYMCLKLPB_FE_FORCE_EN__SHIFT                                                  0x4
#define SYMCLKLPB_CLOCK_ENABLE__SYMCLKLPB_FE_FORCE_SRC__SHIFT                                                 0x8
#define SYMCLKLPB_CLOCK_ENABLE__SYMCLKLPB_CLOCK_ENABLE_MASK                                                   0x00000001L
#define SYMCLKLPB_CLOCK_ENABLE__SYMCLKLPB_FE_FORCE_EN_MASK                                                    0x00000010L
#define SYMCLKLPB_CLOCK_ENABLE__SYMCLKLPB_FE_FORCE_SRC_MASK                                                   0x00000700L
//DPREFCLK_CGTT_BLK_CTRL_REG
#define DPREFCLK_CGTT_BLK_CTRL_REG__DPREFCLK_TURN_ON_DELAY__SHIFT                                             0x0
#define DPREFCLK_CGTT_BLK_CTRL_REG__DPREFCLK_TURN_OFF_DELAY__SHIFT                                            0x4
#define DPREFCLK_CGTT_BLK_CTRL_REG__DPREFCLK_TURN_ON_DELAY_MASK                                               0x0000000FL
#define DPREFCLK_CGTT_BLK_CTRL_REG__DPREFCLK_TURN_OFF_DELAY_MASK                                              0x00000FF0L
//REFCLK_CNTL
#define REFCLK_CNTL__REFCLK_CLOCK_EN__SHIFT                                                                   0x0
#define REFCLK_CNTL__REFCLK_SRC_SEL__SHIFT                                                                    0x1
#define REFCLK_CNTL__REFCLK_CLOCK_EN_MASK                                                                     0x00000001L
#define REFCLK_CNTL__REFCLK_SRC_SEL_MASK                                                                      0x00000002L
//MIPI_CLK_CNTL
#define MIPI_CLK_CNTL__DSICLK_CLOCK_ENABLE__SHIFT                                                             0x0
#define MIPI_CLK_CNTL__BYTECLK_CLOCK_ENABLE__SHIFT                                                            0x1
#define MIPI_CLK_CNTL__ESCCLK_CLOCK_ENABLE__SHIFT                                                             0x2
#define MIPI_CLK_CNTL__DSICLK_CLOCK_ENABLE_MASK                                                               0x00000001L
#define MIPI_CLK_CNTL__BYTECLK_CLOCK_ENABLE_MASK                                                              0x00000002L
#define MIPI_CLK_CNTL__ESCCLK_CLOCK_ENABLE_MASK                                                               0x00000004L
//REFCLK_CGTT_BLK_CTRL_REG
#define REFCLK_CGTT_BLK_CTRL_REG__REFCLK_TURN_ON_DELAY__SHIFT                                                 0x0
#define REFCLK_CGTT_BLK_CTRL_REG__REFCLK_TURN_OFF_DELAY__SHIFT                                                0x4
#define REFCLK_CGTT_BLK_CTRL_REG__REFCLK_TURN_ON_DELAY_MASK                                                   0x0000000FL
#define REFCLK_CGTT_BLK_CTRL_REG__REFCLK_TURN_OFF_DELAY_MASK                                                  0x00000FF0L
//PHYPLLE_PIXCLK_RESYNC_CNTL
#define PHYPLLE_PIXCLK_RESYNC_CNTL__PHYPLLE_PIXCLK_RESYNC_ENABLE__SHIFT                                       0x0
#define PHYPLLE_PIXCLK_RESYNC_CNTL__PHYPLLE_DCCG_DEEP_COLOR_CNTL__SHIFT                                       0x4
#define PHYPLLE_PIXCLK_RESYNC_CNTL__PHYPLLE_PIXCLK_ENABLE__SHIFT                                              0x8
#define PHYPLLE_PIXCLK_RESYNC_CNTL__PHYPLLE_PIXCLK_DOUBLE_RATE_ENABLE__SHIFT                                  0x9
#define PHYPLLE_PIXCLK_RESYNC_CNTL__PHYPLLE_PIXCLK_RESYNC_ENABLE_MASK                                         0x00000001L
#define PHYPLLE_PIXCLK_RESYNC_CNTL__PHYPLLE_DCCG_DEEP_COLOR_CNTL_MASK                                         0x00000030L
#define PHYPLLE_PIXCLK_RESYNC_CNTL__PHYPLLE_PIXCLK_ENABLE_MASK                                                0x00000100L
#define PHYPLLE_PIXCLK_RESYNC_CNTL__PHYPLLE_PIXCLK_DOUBLE_RATE_ENABLE_MASK                                    0x00000200L
//DCCG_PERFMON_CNTL2
#define DCCG_PERFMON_CNTL2__DCCG_PERF_DSICLK_ENABLE__SHIFT                                                    0x0
#define DCCG_PERFMON_CNTL2__DCCG_PERF_REFCLK_ENABLE__SHIFT                                                    0x1
#define DCCG_PERFMON_CNTL2__DCCG_PERF_PIXCLK1_ENABLE__SHIFT                                                   0x2
#define DCCG_PERFMON_CNTL2__DCCG_PERF_PIXCLK2_ENABLE__SHIFT                                                   0x3
#define DCCG_PERFMON_CNTL2__DCCG_PERF_UNIPHYC_PIXCLK_ENABLE__SHIFT                                            0x4
#define DCCG_PERFMON_CNTL2__DCCG_PERF_UNIPHYD_PIXCLK_ENABLE__SHIFT                                            0x5
#define DCCG_PERFMON_CNTL2__DCCG_PERF_UNIPHYE_PIXCLK_ENABLE__SHIFT                                            0x6
#define DCCG_PERFMON_CNTL2__DCCG_PERF_UNIPHYF_PIXCLK_ENABLE__SHIFT                                            0x7
#define DCCG_PERFMON_CNTL2__DCCG_PERF_UNIPHYG_PIXCLK_ENABLE__SHIFT                                            0x8
#define DCCG_PERFMON_CNTL2__DCCG_PERF_DSICLK_ENABLE_MASK                                                      0x00000001L
#define DCCG_PERFMON_CNTL2__DCCG_PERF_REFCLK_ENABLE_MASK                                                      0x00000002L
#define DCCG_PERFMON_CNTL2__DCCG_PERF_PIXCLK1_ENABLE_MASK                                                     0x00000004L
#define DCCG_PERFMON_CNTL2__DCCG_PERF_PIXCLK2_ENABLE_MASK                                                     0x00000008L
#define DCCG_PERFMON_CNTL2__DCCG_PERF_UNIPHYC_PIXCLK_ENABLE_MASK                                              0x00000010L
#define DCCG_PERFMON_CNTL2__DCCG_PERF_UNIPHYD_PIXCLK_ENABLE_MASK                                              0x00000020L
#define DCCG_PERFMON_CNTL2__DCCG_PERF_UNIPHYE_PIXCLK_ENABLE_MASK                                              0x00000040L
#define DCCG_PERFMON_CNTL2__DCCG_PERF_UNIPHYF_PIXCLK_ENABLE_MASK                                              0x00000080L
#define DCCG_PERFMON_CNTL2__DCCG_PERF_UNIPHYG_PIXCLK_ENABLE_MASK                                              0x00000100L
//DSICLK_CGTT_BLK_CTRL_REG
#define DSICLK_CGTT_BLK_CTRL_REG__DSICLK_TURN_ON_DELAY__SHIFT                                                 0x0
#define DSICLK_CGTT_BLK_CTRL_REG__DSICLK_TURN_OFF_DELAY__SHIFT                                                0x4
#define DSICLK_CGTT_BLK_CTRL_REG__DSICLK_TURN_ON_DELAY_MASK                                                   0x0000000FL
#define DSICLK_CGTT_BLK_CTRL_REG__DSICLK_TURN_OFF_DELAY_MASK                                                  0x00000FF0L
//DCCG_CBUS_WRCMD_DELAY
#define DCCG_CBUS_WRCMD_DELAY__CBUS_PLL_WRCMD_DELAY__SHIFT                                                    0x0
#define DCCG_CBUS_WRCMD_DELAY__CBUS_PLL_WRCMD_DELAY_MASK                                                      0x0000000FL
//DC_PINSTRAPS
#define DC_PINSTRAPS__DC_PINSTRAPS_AUDIO__SHIFT                                                               0xe
#define DC_PINSTRAPS__DC_PINSTRAPS_AUDIO_MASK                                                                 0x0000C000L
//CC_DC_MISC_STRAPS
#define CC_DC_MISC_STRAPS__HDMI_DISABLE__SHIFT                                                                0x6
#define CC_DC_MISC_STRAPS__AUDIO_STREAM_NUMBER__SHIFT                                                         0x8
#define CC_DC_MISC_STRAPS__HDMI_DISABLE_MASK                                                                  0x00000040L
#define CC_DC_MISC_STRAPS__AUDIO_STREAM_NUMBER_MASK                                                           0x00000700L
//DCCG_DS_DTO_INCR
#define DCCG_DS_DTO_INCR__DCCG_DS_DTO_INCR__SHIFT                                                             0x0
#define DCCG_DS_DTO_INCR__DCCG_DS_DTO_INCR_MASK                                                               0xFFFFFFFFL
//DCCG_DS_DTO_MODULO
#define DCCG_DS_DTO_MODULO__DCCG_DS_DTO_MODULO__SHIFT                                                         0x0
#define DCCG_DS_DTO_MODULO__DCCG_DS_DTO_MODULO_MASK                                                           0xFFFFFFFFL
//DCCG_DS_CNTL
#define DCCG_DS_CNTL__DCCG_DS_ENABLE__SHIFT                                                                   0x0
#define DCCG_DS_CNTL__DCCG_DS_REF_SRC__SHIFT                                                                  0x4
#define DCCG_DS_CNTL__DCCG_DS_HW_CAL_ENABLE__SHIFT                                                            0x8
#define DCCG_DS_CNTL__DCCG_DS_ENABLED_STATUS__SHIFT                                                           0x9
#define DCCG_DS_CNTL__DCCG_DS_XTALIN_RATE_DIV__SHIFT                                                          0x10
#define DCCG_DS_CNTL__DCCG_DS_JITTER_REMOVE_DIS__SHIFT                                                        0x18
#define DCCG_DS_CNTL__DCCG_DS_DELAY_XTAL_SEL__SHIFT                                                           0x19
#define DCCG_DS_CNTL__DCCG_DS_ENABLE_MASK                                                                     0x00000001L
#define DCCG_DS_CNTL__DCCG_DS_REF_SRC_MASK                                                                    0x00000030L
#define DCCG_DS_CNTL__DCCG_DS_HW_CAL_ENABLE_MASK                                                              0x00000100L
#define DCCG_DS_CNTL__DCCG_DS_ENABLED_STATUS_MASK                                                             0x00000200L
#define DCCG_DS_CNTL__DCCG_DS_XTALIN_RATE_DIV_MASK                                                            0x00030000L
#define DCCG_DS_CNTL__DCCG_DS_JITTER_REMOVE_DIS_MASK                                                          0x01000000L
#define DCCG_DS_CNTL__DCCG_DS_DELAY_XTAL_SEL_MASK                                                             0x02000000L
//DCCG_DS_HW_CAL_INTERVAL
#define DCCG_DS_HW_CAL_INTERVAL__DCCG_DS_HW_CAL_INTERVAL__SHIFT                                               0x0
#define DCCG_DS_HW_CAL_INTERVAL__DCCG_DS_HW_CAL_INTERVAL_MASK                                                 0xFFFFFFFFL
//SYMCLKG_CLOCK_ENABLE
#define SYMCLKG_CLOCK_ENABLE__SYMCLKG_CLOCK_ENABLE__SHIFT                                                     0x0
#define SYMCLKG_CLOCK_ENABLE__SYMCLKG_FE_FORCE_EN__SHIFT                                                      0x4
#define SYMCLKG_CLOCK_ENABLE__SYMCLKG_FE_FORCE_SRC__SHIFT                                                     0x8
#define SYMCLKG_CLOCK_ENABLE__SYMCLKG_CLOCK_ENABLE_MASK                                                       0x00000001L
#define SYMCLKG_CLOCK_ENABLE__SYMCLKG_FE_FORCE_EN_MASK                                                        0x00000010L
#define SYMCLKG_CLOCK_ENABLE__SYMCLKG_FE_FORCE_SRC_MASK                                                       0x00000700L
//DPREFCLK_CNTL
#define DPREFCLK_CNTL__DPREFCLK_SRC_SEL__SHIFT                                                                0x0
#define DPREFCLK_CNTL__UNB_DB_CLK_ENABLE__SHIFT                                                               0x8
#define DPREFCLK_CNTL__DPREFCLK_SRC_SEL_MASK                                                                  0x00000007L
#define DPREFCLK_CNTL__UNB_DB_CLK_ENABLE_MASK                                                                 0x00000100L
//AOMCLK0_CNTL
#define AOMCLK0_CNTL__AOMCLK0_CLOCK_EN__SHIFT                                                                 0x0
#define AOMCLK0_CNTL__AOMCLK0_CLOCK_EN_MASK                                                                   0x00000001L
//AOMCLK1_CNTL
#define AOMCLK1_CNTL__AOMCLK1_CLOCK_EN__SHIFT                                                                 0x0
#define AOMCLK1_CNTL__AOMCLK1_CLOCK_EN_MASK                                                                   0x00000001L
//AOMCLK2_CNTL
#define AOMCLK2_CNTL__AOMCLK2_CLOCK_EN__SHIFT                                                                 0x0
#define AOMCLK2_CNTL__AOMCLK2_CLOCK_EN_MASK                                                                   0x00000001L
//DCCG_AUDIO_DTO2_PHASE
#define DCCG_AUDIO_DTO2_PHASE__DCCG_AUDIO_DTO2_PHASE__SHIFT                                                   0x0
#define DCCG_AUDIO_DTO2_PHASE__DCCG_AUDIO_DTO2_PHASE_MASK                                                     0xFFFFFFFFL
//DCCG_AUDIO_DTO2_MODULO
#define DCCG_AUDIO_DTO2_MODULO__DCCG_AUDIO_DTO2_MODULO__SHIFT                                                 0x0
#define DCCG_AUDIO_DTO2_MODULO__DCCG_AUDIO_DTO2_MODULO_MASK                                                   0xFFFFFFFFL
//DCE_VERSION
#define DCE_VERSION__MAJOR_VERSION__SHIFT                                                                     0x0
#define DCE_VERSION__MINOR_VERSION__SHIFT                                                                     0x8
#define DCE_VERSION__MAJOR_VERSION_MASK                                                                       0x000000FFL
#define DCE_VERSION__MINOR_VERSION_MASK                                                                       0x0000FF00L
//PHYPLLG_PIXCLK_RESYNC_CNTL
#define PHYPLLG_PIXCLK_RESYNC_CNTL__PHYPLLG_PIXCLK_RESYNC_ENABLE__SHIFT                                       0x0
#define PHYPLLG_PIXCLK_RESYNC_CNTL__PHYPLLG_DCCG_DEEP_COLOR_CNTL__SHIFT                                       0x4
#define PHYPLLG_PIXCLK_RESYNC_CNTL__PHYPLLG_PIXCLK_ENABLE__SHIFT                                              0x8
#define PHYPLLG_PIXCLK_RESYNC_CNTL__PHYPLLG_PIXCLK_DOUBLE_RATE_ENABLE__SHIFT                                  0x9
#define PHYPLLG_PIXCLK_RESYNC_CNTL__PHYPLLG_PIXCLK_RESYNC_ENABLE_MASK                                         0x00000001L
#define PHYPLLG_PIXCLK_RESYNC_CNTL__PHYPLLG_DCCG_DEEP_COLOR_CNTL_MASK                                         0x00000030L
#define PHYPLLG_PIXCLK_RESYNC_CNTL__PHYPLLG_PIXCLK_ENABLE_MASK                                                0x00000100L
#define PHYPLLG_PIXCLK_RESYNC_CNTL__PHYPLLG_PIXCLK_DOUBLE_RATE_ENABLE_MASK                                    0x00000200L
//DCCG_GTC_CNTL
#define DCCG_GTC_CNTL__DCCG_GTC_ENABLE__SHIFT                                                                 0x0
#define DCCG_GTC_CNTL__DCCG_GTC_ENABLE_MASK                                                                   0x00000001L
//DCCG_GTC_DTO_INCR
#define DCCG_GTC_DTO_INCR__DCCG_GTC_DTO_INCR__SHIFT                                                           0x0
#define DCCG_GTC_DTO_INCR__DCCG_GTC_DTO_INCR_MASK                                                             0xFFFFFFFFL
//DCCG_GTC_DTO_MODULO
#define DCCG_GTC_DTO_MODULO__DCCG_GTC_DTO_MODULO__SHIFT                                                       0x0
#define DCCG_GTC_DTO_MODULO__DCCG_GTC_DTO_MODULO_MASK                                                         0xFFFFFFFFL
//DCCG_GTC_CURRENT
#define DCCG_GTC_CURRENT__DCCG_GTC_CURRENT__SHIFT                                                             0x0
#define DCCG_GTC_CURRENT__DCCG_GTC_CURRENT_MASK                                                               0xFFFFFFFFL
//DENTIST_DISPCLK_CNTL
#define DENTIST_DISPCLK_CNTL__DENTIST_DISPCLK_WDIVIDER__SHIFT                                                 0x0
#define DENTIST_DISPCLK_CNTL__DENTIST_DISPCLK_RDIVIDER__SHIFT                                                 0x8
#define DENTIST_DISPCLK_CNTL__DENTIST_DISPCLK_CHG_MODE__SHIFT                                                 0xf
#define DENTIST_DISPCLK_CNTL__DENTIST_DISPCLK_CHGTOG__SHIFT                                                   0x11
#define DENTIST_DISPCLK_CNTL__DENTIST_DISPCLK_DONETOG__SHIFT                                                  0x12
#define DENTIST_DISPCLK_CNTL__DENTIST_DISPCLK_CHG_DONE__SHIFT                                                 0x13
#define DENTIST_DISPCLK_CNTL__DENTIST_DPREFCLK_CHG_DONE__SHIFT                                                0x14
#define DENTIST_DISPCLK_CNTL__DENTIST_DPREFCLK_CHGTOG__SHIFT                                                  0x15
#define DENTIST_DISPCLK_CNTL__DENTIST_DPREFCLK_DONETOG__SHIFT                                                 0x16
#define DENTIST_DISPCLK_CNTL__DENTIST_DPREFCLK_WDIVIDER__SHIFT                                                0x18
#define DENTIST_DISPCLK_CNTL__DENTIST_DISPCLK_WDIVIDER_MASK                                                   0x0000007FL
#define DENTIST_DISPCLK_CNTL__DENTIST_DISPCLK_RDIVIDER_MASK                                                   0x00007F00L
#define DENTIST_DISPCLK_CNTL__DENTIST_DISPCLK_CHG_MODE_MASK                                                   0x00018000L
#define DENTIST_DISPCLK_CNTL__DENTIST_DISPCLK_CHGTOG_MASK                                                     0x00020000L
#define DENTIST_DISPCLK_CNTL__DENTIST_DISPCLK_DONETOG_MASK                                                    0x00040000L
#define DENTIST_DISPCLK_CNTL__DENTIST_DISPCLK_CHG_DONE_MASK                                                   0x00080000L
#define DENTIST_DISPCLK_CNTL__DENTIST_DPREFCLK_CHG_DONE_MASK                                                  0x00100000L
#define DENTIST_DISPCLK_CNTL__DENTIST_DPREFCLK_CHGTOG_MASK                                                    0x00200000L
#define DENTIST_DISPCLK_CNTL__DENTIST_DPREFCLK_DONETOG_MASK                                                   0x00400000L
#define DENTIST_DISPCLK_CNTL__DENTIST_DPREFCLK_WDIVIDER_MASK                                                  0x7F000000L
//MIPI_DTO_CNTL
#define MIPI_DTO_CNTL__MIPI_DTO_ENABLE__SHIFT                                                                 0x0
#define MIPI_DTO_CNTL__MIPI_DTO_ENABLE_MASK                                                                   0x00000001L
//MIPI_DTO_PHASE
#define MIPI_DTO_PHASE__MIPI_DTO_PHASE__SHIFT                                                                 0x0
#define MIPI_DTO_PHASE__MIPI_DTO_PHASE_MASK                                                                   0xFFFFFFFFL
//MIPI_DTO_MODULO
#define MIPI_DTO_MODULO__MIPI_DTO_MODULO__SHIFT                                                               0x0
#define MIPI_DTO_MODULO__MIPI_DTO_MODULO_MASK                                                                 0xFFFFFFFFL
//DAC_CLK_ENABLE
#define DAC_CLK_ENABLE__DACA_CLK_ENABLE__SHIFT                                                                0x0
#define DAC_CLK_ENABLE__DACB_CLK_ENABLE__SHIFT                                                                0x4
#define DAC_CLK_ENABLE__DACA_CLK_ENABLE_MASK                                                                  0x00000001L
#define DAC_CLK_ENABLE__DACB_CLK_ENABLE_MASK                                                                  0x00000010L
//DVO_CLK_ENABLE
#define DVO_CLK_ENABLE__DVO_CLK_ENABLE__SHIFT                                                                 0x0
#define DVO_CLK_ENABLE__DVO_CLK_ENABLE_MASK                                                                   0x00000001L
//AVSYNC_COUNTER_WRITE
#define AVSYNC_COUNTER_WRITE__AVSYNC_COUNTER_WRVALUE__SHIFT                                                   0x0
#define AVSYNC_COUNTER_WRITE__AVSYNC_COUNTER_WRVALUE_MASK                                                     0xFFFFFFFFL
//AVSYNC_COUNTER_CONTROL
#define AVSYNC_COUNTER_CONTROL__AVSYNC_COUNTER_ENABLE__SHIFT                                                  0x0
#define AVSYNC_COUNTER_CONTROL__AVSYNC_COUNTER_ENABLE_MASK                                                    0x00000001L
//DMCU_SMU_INTERRUPT_CNTL
#define DMCU_SMU_INTERRUPT_CNTL__DMCU_SMU_STATIC_SCREEN_INT__SHIFT                                            0x0
#define DMCU_SMU_INTERRUPT_CNTL__DMCU_SMU_STATIC_SCREEN_STATUS__SHIFT                                         0x10
#define DMCU_SMU_INTERRUPT_CNTL__DMCU_SMU_STATIC_SCREEN_INT_MASK                                              0x00000001L
#define DMCU_SMU_INTERRUPT_CNTL__DMCU_SMU_STATIC_SCREEN_STATUS_MASK                                           0xFFFF0000L
//SMU_CONTROL
#define SMU_CONTROL__DISPLAY0_FORCE_VBI__SHIFT                                                                0x0
#define SMU_CONTROL__DISPLAY1_FORCE_VBI__SHIFT                                                                0x1
#define SMU_CONTROL__DISPLAY2_FORCE_VBI__SHIFT                                                                0x2
#define SMU_CONTROL__DISPLAY3_FORCE_VBI__SHIFT                                                                0x3
#define SMU_CONTROL__DISPLAY4_FORCE_VBI__SHIFT                                                                0x4
#define SMU_CONTROL__DISPLAY5_FORCE_VBI__SHIFT                                                                0x5
#define SMU_CONTROL__DISPLAY_V0_FORCE_VBI__SHIFT                                                              0x6
#define SMU_CONTROL__DISPLAY_V1_FORCE_VBI__SHIFT                                                              0x7
#define SMU_CONTROL__MCIF_WB_FORCE_VBI__SHIFT                                                                 0x8
#define SMU_CONTROL__DISPLAY0_FORCE_VBI_MASK                                                                  0x00000001L
#define SMU_CONTROL__DISPLAY1_FORCE_VBI_MASK                                                                  0x00000002L
#define SMU_CONTROL__DISPLAY2_FORCE_VBI_MASK                                                                  0x00000004L
#define SMU_CONTROL__DISPLAY3_FORCE_VBI_MASK                                                                  0x00000008L
#define SMU_CONTROL__DISPLAY4_FORCE_VBI_MASK                                                                  0x00000010L
#define SMU_CONTROL__DISPLAY5_FORCE_VBI_MASK                                                                  0x00000020L
#define SMU_CONTROL__DISPLAY_V0_FORCE_VBI_MASK                                                                0x00000040L
#define SMU_CONTROL__DISPLAY_V1_FORCE_VBI_MASK                                                                0x00000080L
#define SMU_CONTROL__MCIF_WB_FORCE_VBI_MASK                                                                   0x00000100L
//SMU_INTERRUPT_CONTROL
#define SMU_INTERRUPT_CONTROL__DC_SMU_INT_ENABLE__SHIFT                                                       0x0
#define SMU_INTERRUPT_CONTROL__DC_SMU_INT_STATUS__SHIFT                                                       0x4
#define SMU_INTERRUPT_CONTROL__DC_SMU_INT_EVENT__SHIFT                                                        0x10
#define SMU_INTERRUPT_CONTROL__DC_SMU_INT_ENABLE_MASK                                                         0x00000001L
#define SMU_INTERRUPT_CONTROL__DC_SMU_INT_STATUS_MASK                                                         0x00000010L
#define SMU_INTERRUPT_CONTROL__DC_SMU_INT_EVENT_MASK                                                          0xFFFF0000L
//AVSYNC_COUNTER_READ
#define AVSYNC_COUNTER_READ__AVSYNC_COUNTER_RDVALUE__SHIFT                                                    0x0
#define AVSYNC_COUNTER_READ__AVSYNC_COUNTER_RDVALUE_MASK                                                      0xFFFFFFFFL
//MILLISECOND_TIME_BASE_DIV
#define MILLISECOND_TIME_BASE_DIV__MILLISECOND_TIME_BASE_DIV__SHIFT                                           0x0
#define MILLISECOND_TIME_BASE_DIV__MILLISECOND_TIME_BASE_CLOCK_SOURCE_SEL__SHIFT                              0x14
#define MILLISECOND_TIME_BASE_DIV__MILLISECOND_TIME_BASE_DIV_MASK                                             0x0001FFFFL
#define MILLISECOND_TIME_BASE_DIV__MILLISECOND_TIME_BASE_CLOCK_SOURCE_SEL_MASK                                0x00100000L
//DISPCLK_FREQ_CHANGE_CNTL
#define DISPCLK_FREQ_CHANGE_CNTL__DISPCLK_STEP_DELAY__SHIFT                                                   0x0
#define DISPCLK_FREQ_CHANGE_CNTL__DISPCLK_STEP_SIZE__SHIFT                                                    0x10
#define DISPCLK_FREQ_CHANGE_CNTL__DISPCLK_FREQ_RAMP_DONE__SHIFT                                               0x14
#define DISPCLK_FREQ_CHANGE_CNTL__DISPCLK_MAX_ERRDET_CYCLES__SHIFT                                            0x19
#define DISPCLK_FREQ_CHANGE_CNTL__DCCG_FIFO_ERRDET_RESET__SHIFT                                               0x1c
#define DISPCLK_FREQ_CHANGE_CNTL__DCCG_FIFO_ERRDET_STATE__SHIFT                                               0x1d
#define DISPCLK_FREQ_CHANGE_CNTL__DCCG_FIFO_ERRDET_OVR_EN__SHIFT                                              0x1e
#define DISPCLK_FREQ_CHANGE_CNTL__DISPCLK_CHG_FWD_CORR_DISABLE__SHIFT                                         0x1f
#define DISPCLK_FREQ_CHANGE_CNTL__DISPCLK_STEP_DELAY_MASK                                                     0x00003FFFL
#define DISPCLK_FREQ_CHANGE_CNTL__DISPCLK_STEP_SIZE_MASK                                                      0x000F0000L
#define DISPCLK_FREQ_CHANGE_CNTL__DISPCLK_FREQ_RAMP_DONE_MASK                                                 0x00100000L
#define DISPCLK_FREQ_CHANGE_CNTL__DISPCLK_MAX_ERRDET_CYCLES_MASK                                              0x0E000000L
#define DISPCLK_FREQ_CHANGE_CNTL__DCCG_FIFO_ERRDET_RESET_MASK                                                 0x10000000L
#define DISPCLK_FREQ_CHANGE_CNTL__DCCG_FIFO_ERRDET_STATE_MASK                                                 0x20000000L
#define DISPCLK_FREQ_CHANGE_CNTL__DCCG_FIFO_ERRDET_OVR_EN_MASK                                                0x40000000L
#define DISPCLK_FREQ_CHANGE_CNTL__DISPCLK_CHG_FWD_CORR_DISABLE_MASK                                           0x80000000L
//DC_MEM_GLOBAL_PWR_REQ_CNTL
#define DC_MEM_GLOBAL_PWR_REQ_CNTL__DC_MEM_GLOBAL_PWR_REQ_DIS__SHIFT                                          0x0
#define DC_MEM_GLOBAL_PWR_REQ_CNTL__DC_MEM_GLOBAL_PWR_REQ_DIS_MASK                                            0x00000001L
//DCCG_PERFMON_CNTL
#define DCCG_PERFMON_CNTL__DCCG_PERF_DISPCLK_ENABLE__SHIFT                                                    0x0
#define DCCG_PERFMON_CNTL__DCCG_PERF_DPREFCLK_ENABLE__SHIFT                                                   0x1
#define DCCG_PERFMON_CNTL__DCCG_PERF_UNIPHYA_PIXCLK_ENABLE__SHIFT                                             0x2
#define DCCG_PERFMON_CNTL__DCCG_PERF_UNIPHYB_PIXCLK_ENABLE__SHIFT                                             0x3
#define DCCG_PERFMON_CNTL__DCCG_PERF_PIXCLK0_ENABLE__SHIFT                                                    0x4
#define DCCG_PERFMON_CNTL__DCCG_PERF_RUN__SHIFT                                                               0x5
#define DCCG_PERFMON_CNTL__DCCG_PERF_MODE_VSYNC__SHIFT                                                        0x6
#define DCCG_PERFMON_CNTL__DCCG_PERF_MODE_HSYNC__SHIFT                                                        0x7
#define DCCG_PERFMON_CNTL__DCCG_PERF_CRTC_SEL__SHIFT                                                          0x8
#define DCCG_PERFMON_CNTL__DCCG_PERF_XTALIN_PULSE_DIV__SHIFT                                                  0xb
#define DCCG_PERFMON_CNTL__DCCG_PERF_DISPCLK_ENABLE_MASK                                                      0x00000001L
#define DCCG_PERFMON_CNTL__DCCG_PERF_DPREFCLK_ENABLE_MASK                                                     0x00000002L
#define DCCG_PERFMON_CNTL__DCCG_PERF_UNIPHYA_PIXCLK_ENABLE_MASK                                               0x00000004L
#define DCCG_PERFMON_CNTL__DCCG_PERF_UNIPHYB_PIXCLK_ENABLE_MASK                                               0x00000008L
#define DCCG_PERFMON_CNTL__DCCG_PERF_PIXCLK0_ENABLE_MASK                                                      0x00000010L
#define DCCG_PERFMON_CNTL__DCCG_PERF_RUN_MASK                                                                 0x00000020L
#define DCCG_PERFMON_CNTL__DCCG_PERF_MODE_VSYNC_MASK                                                          0x00000040L
#define DCCG_PERFMON_CNTL__DCCG_PERF_MODE_HSYNC_MASK                                                          0x00000080L
#define DCCG_PERFMON_CNTL__DCCG_PERF_CRTC_SEL_MASK                                                            0x00000700L
#define DCCG_PERFMON_CNTL__DCCG_PERF_XTALIN_PULSE_DIV_MASK                                                    0xFFFFF800L
//DCCG_GATE_DISABLE_CNTL
#define DCCG_GATE_DISABLE_CNTL__DISPCLK_DCCG_GATE_DISABLE__SHIFT                                              0x0
#define DCCG_GATE_DISABLE_CNTL__DISPCLK_R_DCCG_GATE_DISABLE__SHIFT                                            0x1
#define DCCG_GATE_DISABLE_CNTL__SCLK_GATE_DISABLE__SHIFT                                                      0x2
#define DCCG_GATE_DISABLE_CNTL__DPREFCLK_GATE_DISABLE__SHIFT                                                  0x3
#define DCCG_GATE_DISABLE_CNTL__DACACLK_GATE_DISABLE__SHIFT                                                   0x4
#define DCCG_GATE_DISABLE_CNTL__DACBCLK_GATE_DISABLE__SHIFT                                                   0x5
#define DCCG_GATE_DISABLE_CNTL__DVOACLK_GATE_DISABLE__SHIFT                                                   0x6
#define DCCG_GATE_DISABLE_CNTL__DPREFCLK_R_DCCG_GATE_DISABLE__SHIFT                                           0x8
#define DCCG_GATE_DISABLE_CNTL__AOMCLK0_GATE_DISABLE__SHIFT                                                   0x11
#define DCCG_GATE_DISABLE_CNTL__AOMCLK1_GATE_DISABLE__SHIFT                                                   0x12
#define DCCG_GATE_DISABLE_CNTL__AOMCLK2_GATE_DISABLE__SHIFT                                                   0x13
#define DCCG_GATE_DISABLE_CNTL__AUDIO_DTO2_CLK_GATE_DISABLE__SHIFT                                            0x15
#define DCCG_GATE_DISABLE_CNTL__DPREFCLK_GTC_GATE_DISABLE__SHIFT                                              0x16
#define DCCG_GATE_DISABLE_CNTL__UNB_DB_CLK_GATE_DISABLE__SHIFT                                                0x17
#define DCCG_GATE_DISABLE_CNTL__REFCLK_GATE_DISABLE__SHIFT                                                    0x1a
#define DCCG_GATE_DISABLE_CNTL__REFCLK_R_DIG_GATE_DISABLE__SHIFT                                              0x1b
#define DCCG_GATE_DISABLE_CNTL__DSICLK_GATE_DISABLE__SHIFT                                                    0x1c
#define DCCG_GATE_DISABLE_CNTL__BYTECLK_GATE_DISABLE__SHIFT                                                   0x1d
#define DCCG_GATE_DISABLE_CNTL__ESCCLK_GATE_DISABLE__SHIFT                                                    0x1e
#define DCCG_GATE_DISABLE_CNTL__DISPCLK_DCCG_GATE_DISABLE_MASK                                                0x00000001L
#define DCCG_GATE_DISABLE_CNTL__DISPCLK_R_DCCG_GATE_DISABLE_MASK                                              0x00000002L
#define DCCG_GATE_DISABLE_CNTL__SCLK_GATE_DISABLE_MASK                                                        0x00000004L
#define DCCG_GATE_DISABLE_CNTL__DPREFCLK_GATE_DISABLE_MASK                                                    0x00000008L
#define DCCG_GATE_DISABLE_CNTL__DACACLK_GATE_DISABLE_MASK                                                     0x00000010L
#define DCCG_GATE_DISABLE_CNTL__DACBCLK_GATE_DISABLE_MASK                                                     0x00000020L
#define DCCG_GATE_DISABLE_CNTL__DVOACLK_GATE_DISABLE_MASK                                                     0x00000040L
#define DCCG_GATE_DISABLE_CNTL__DPREFCLK_R_DCCG_GATE_DISABLE_MASK                                             0x00000100L
#define DCCG_GATE_DISABLE_CNTL__AOMCLK0_GATE_DISABLE_MASK                                                     0x00020000L
#define DCCG_GATE_DISABLE_CNTL__AOMCLK1_GATE_DISABLE_MASK                                                     0x00040000L
#define DCCG_GATE_DISABLE_CNTL__AOMCLK2_GATE_DISABLE_MASK                                                     0x00080000L
#define DCCG_GATE_DISABLE_CNTL__AUDIO_DTO2_CLK_GATE_DISABLE_MASK                                              0x00200000L
#define DCCG_GATE_DISABLE_CNTL__DPREFCLK_GTC_GATE_DISABLE_MASK                                                0x00400000L
#define DCCG_GATE_DISABLE_CNTL__UNB_DB_CLK_GATE_DISABLE_MASK                                                  0x00800000L
#define DCCG_GATE_DISABLE_CNTL__REFCLK_GATE_DISABLE_MASK                                                      0x04000000L
#define DCCG_GATE_DISABLE_CNTL__REFCLK_R_DIG_GATE_DISABLE_MASK                                                0x08000000L
#define DCCG_GATE_DISABLE_CNTL__DSICLK_GATE_DISABLE_MASK                                                      0x10000000L
#define DCCG_GATE_DISABLE_CNTL__BYTECLK_GATE_DISABLE_MASK                                                     0x20000000L
#define DCCG_GATE_DISABLE_CNTL__ESCCLK_GATE_DISABLE_MASK                                                      0x40000000L
//DISPCLK_CGTT_BLK_CTRL_REG
#define DISPCLK_CGTT_BLK_CTRL_REG__DISPCLK_TURN_ON_DELAY__SHIFT                                               0x0
#define DISPCLK_CGTT_BLK_CTRL_REG__DISPCLK_TURN_OFF_DELAY__SHIFT                                              0x4
#define DISPCLK_CGTT_BLK_CTRL_REG__DISPCLK_TURN_ON_DELAY_MASK                                                 0x0000000FL
#define DISPCLK_CGTT_BLK_CTRL_REG__DISPCLK_TURN_OFF_DELAY_MASK                                                0x00000FF0L
//SCLK_CGTT_BLK_CTRL_REG
#define SCLK_CGTT_BLK_CTRL_REG__SCLK_TURN_ON_DELAY__SHIFT                                                     0x0
#define SCLK_CGTT_BLK_CTRL_REG__SCLK_TURN_OFF_DELAY__SHIFT                                                    0x4
#define SCLK_CGTT_BLK_CTRL_REG__CGTT_SCLK_OVERRIDE__SHIFT                                                     0xc
#define SCLK_CGTT_BLK_CTRL_REG__SCLK_TURN_ON_DELAY_MASK                                                       0x0000000FL
#define SCLK_CGTT_BLK_CTRL_REG__SCLK_TURN_OFF_DELAY_MASK                                                      0x00000FF0L
#define SCLK_CGTT_BLK_CTRL_REG__CGTT_SCLK_OVERRIDE_MASK                                                       0x00001000L
//DCCG_CAC_STATUS
#define DCCG_CAC_STATUS__CAC_STATUS_RDDATA__SHIFT                                                             0x0
#define DCCG_CAC_STATUS__CAC_STATUS_RDDATA_MASK                                                               0xFFFFFFFFL
//PIXCLK1_RESYNC_CNTL
#define PIXCLK1_RESYNC_CNTL__PIXCLK1_RESYNC_ENABLE__SHIFT                                                     0x0
#define PIXCLK1_RESYNC_CNTL__DCCG_DEEP_COLOR_CNTL1__SHIFT                                                     0x4
#define PIXCLK1_RESYNC_CNTL__PIXCLK1_RESYNC_ENABLE_MASK                                                       0x00000001L
#define PIXCLK1_RESYNC_CNTL__DCCG_DEEP_COLOR_CNTL1_MASK                                                       0x00000030L
//PIXCLK2_RESYNC_CNTL
#define PIXCLK2_RESYNC_CNTL__PIXCLK2_RESYNC_ENABLE__SHIFT                                                     0x0
#define PIXCLK2_RESYNC_CNTL__DCCG_DEEP_COLOR_CNTL2__SHIFT                                                     0x4
#define PIXCLK2_RESYNC_CNTL__PIXCLK2_RESYNC_ENABLE_MASK                                                       0x00000001L
#define PIXCLK2_RESYNC_CNTL__DCCG_DEEP_COLOR_CNTL2_MASK                                                       0x00000030L
//PIXCLK0_RESYNC_CNTL
#define PIXCLK0_RESYNC_CNTL__PIXCLK0_RESYNC_ENABLE__SHIFT                                                     0x0
#define PIXCLK0_RESYNC_CNTL__DCCG_DEEP_COLOR_CNTL0__SHIFT                                                     0x4
#define PIXCLK0_RESYNC_CNTL__PIXCLK0_RESYNC_ENABLE_MASK                                                       0x00000001L
#define PIXCLK0_RESYNC_CNTL__DCCG_DEEP_COLOR_CNTL0_MASK                                                       0x00000030L
//MICROSECOND_TIME_BASE_DIV
#define MICROSECOND_TIME_BASE_DIV__MICROSECOND_TIME_BASE_DIV__SHIFT                                           0x0
#define MICROSECOND_TIME_BASE_DIV__XTAL_REF_DIV__SHIFT                                                        0x8
#define MICROSECOND_TIME_BASE_DIV__XTAL_REF_SEL__SHIFT                                                        0x10
#define MICROSECOND_TIME_BASE_DIV__XTAL_REF_CLOCK_SOURCE_SEL__SHIFT                                           0x11
#define MICROSECOND_TIME_BASE_DIV__MICROSECOND_TIME_BASE_CLOCK_SOURCE_SEL__SHIFT                              0x14
#define MICROSECOND_TIME_BASE_DIV__MICROSECOND_TIME_BASE_DIV_MASK                                             0x0000007FL
#define MICROSECOND_TIME_BASE_DIV__XTAL_REF_DIV_MASK                                                          0x00007F00L
#define MICROSECOND_TIME_BASE_DIV__XTAL_REF_SEL_MASK                                                          0x00010000L
#define MICROSECOND_TIME_BASE_DIV__XTAL_REF_CLOCK_SOURCE_SEL_MASK                                             0x00020000L
#define MICROSECOND_TIME_BASE_DIV__MICROSECOND_TIME_BASE_CLOCK_SOURCE_SEL_MASK                                0x00100000L
//DCCG_GATE_DISABLE_CNTL2
#define DCCG_GATE_DISABLE_CNTL2__SYMCLKA_FE_GATE_DISABLE__SHIFT                                               0x0
#define DCCG_GATE_DISABLE_CNTL2__SYMCLKB_FE_GATE_DISABLE__SHIFT                                               0x1
#define DCCG_GATE_DISABLE_CNTL2__SYMCLKC_FE_GATE_DISABLE__SHIFT                                               0x2
#define DCCG_GATE_DISABLE_CNTL2__SYMCLKD_FE_GATE_DISABLE__SHIFT                                               0x3
#define DCCG_GATE_DISABLE_CNTL2__SYMCLKE_FE_GATE_DISABLE__SHIFT                                               0x4
#define DCCG_GATE_DISABLE_CNTL2__SYMCLKF_FE_GATE_DISABLE__SHIFT                                               0x5
#define DCCG_GATE_DISABLE_CNTL2__SYMCLKG_FE_GATE_DISABLE__SHIFT                                               0x6
#define DCCG_GATE_DISABLE_CNTL2__SYMCLKLPA_FE_GATE_DISABLE__SHIFT                                             0x8
#define DCCG_GATE_DISABLE_CNTL2__SYMCLKLPB_FE_GATE_DISABLE__SHIFT                                             0x9
#define DCCG_GATE_DISABLE_CNTL2__SYMCLKA_GATE_DISABLE__SHIFT                                                  0x10
#define DCCG_GATE_DISABLE_CNTL2__SYMCLKB_GATE_DISABLE__SHIFT                                                  0x11
#define DCCG_GATE_DISABLE_CNTL2__SYMCLKC_GATE_DISABLE__SHIFT                                                  0x12
#define DCCG_GATE_DISABLE_CNTL2__SYMCLKD_GATE_DISABLE__SHIFT                                                  0x13
#define DCCG_GATE_DISABLE_CNTL2__SYMCLKE_GATE_DISABLE__SHIFT                                                  0x14
#define DCCG_GATE_DISABLE_CNTL2__SYMCLKF_GATE_DISABLE__SHIFT                                                  0x15
#define DCCG_GATE_DISABLE_CNTL2__SYMCLKG_GATE_DISABLE__SHIFT                                                  0x16
#define DCCG_GATE_DISABLE_CNTL2__SYMCLKLPA_GATE_DISABLE__SHIFT                                                0x18
#define DCCG_GATE_DISABLE_CNTL2__SYMCLKLPB_GATE_DISABLE__SHIFT                                                0x19
#define DCCG_GATE_DISABLE_CNTL2__SYMCLKA_FE_GATE_DISABLE_MASK                                                 0x00000001L
#define DCCG_GATE_DISABLE_CNTL2__SYMCLKB_FE_GATE_DISABLE_MASK                                                 0x00000002L
#define DCCG_GATE_DISABLE_CNTL2__SYMCLKC_FE_GATE_DISABLE_MASK                                                 0x00000004L
#define DCCG_GATE_DISABLE_CNTL2__SYMCLKD_FE_GATE_DISABLE_MASK                                                 0x00000008L
#define DCCG_GATE_DISABLE_CNTL2__SYMCLKE_FE_GATE_DISABLE_MASK                                                 0x00000010L
#define DCCG_GATE_DISABLE_CNTL2__SYMCLKF_FE_GATE_DISABLE_MASK                                                 0x00000020L
#define DCCG_GATE_DISABLE_CNTL2__SYMCLKG_FE_GATE_DISABLE_MASK                                                 0x00000040L
#define DCCG_GATE_DISABLE_CNTL2__SYMCLKLPA_FE_GATE_DISABLE_MASK                                               0x00000100L
#define DCCG_GATE_DISABLE_CNTL2__SYMCLKLPB_FE_GATE_DISABLE_MASK                                               0x00000200L
#define DCCG_GATE_DISABLE_CNTL2__SYMCLKA_GATE_DISABLE_MASK                                                    0x00010000L
#define DCCG_GATE_DISABLE_CNTL2__SYMCLKB_GATE_DISABLE_MASK                                                    0x00020000L
#define DCCG_GATE_DISABLE_CNTL2__SYMCLKC_GATE_DISABLE_MASK                                                    0x00040000L
#define DCCG_GATE_DISABLE_CNTL2__SYMCLKD_GATE_DISABLE_MASK                                                    0x00080000L
#define DCCG_GATE_DISABLE_CNTL2__SYMCLKE_GATE_DISABLE_MASK                                                    0x00100000L
#define DCCG_GATE_DISABLE_CNTL2__SYMCLKF_GATE_DISABLE_MASK                                                    0x00200000L
#define DCCG_GATE_DISABLE_CNTL2__SYMCLKG_GATE_DISABLE_MASK                                                    0x00400000L
#define DCCG_GATE_DISABLE_CNTL2__SYMCLKLPA_GATE_DISABLE_MASK                                                  0x01000000L
#define DCCG_GATE_DISABLE_CNTL2__SYMCLKLPB_GATE_DISABLE_MASK                                                  0x02000000L
//SYMCLK_CGTT_BLK_CTRL_REG
#define SYMCLK_CGTT_BLK_CTRL_REG__SYMCLK_TURN_ON_DELAY__SHIFT                                                 0x0
#define SYMCLK_CGTT_BLK_CTRL_REG__SYMCLK_TURN_OFF_DELAY__SHIFT                                                0x4
#define SYMCLK_CGTT_BLK_CTRL_REG__SYMCLK_TURN_ON_DELAY_MASK                                                   0x0000000FL
#define SYMCLK_CGTT_BLK_CTRL_REG__SYMCLK_TURN_OFF_DELAY_MASK                                                  0x00000FF0L
//PHYPLLF_PIXCLK_RESYNC_CNTL
#define PHYPLLF_PIXCLK_RESYNC_CNTL__PHYPLLF_PIXCLK_RESYNC_ENABLE__SHIFT                                       0x0
#define PHYPLLF_PIXCLK_RESYNC_CNTL__PHYPLLF_DCCG_DEEP_COLOR_CNTL__SHIFT                                       0x4
#define PHYPLLF_PIXCLK_RESYNC_CNTL__PHYPLLF_PIXCLK_ENABLE__SHIFT                                              0x8
#define PHYPLLF_PIXCLK_RESYNC_CNTL__PHYPLLF_PIXCLK_DOUBLE_RATE_ENABLE__SHIFT                                  0x9
#define PHYPLLF_PIXCLK_RESYNC_CNTL__PHYPLLF_PIXCLK_RESYNC_ENABLE_MASK                                         0x00000001L
#define PHYPLLF_PIXCLK_RESYNC_CNTL__PHYPLLF_DCCG_DEEP_COLOR_CNTL_MASK                                         0x00000030L
#define PHYPLLF_PIXCLK_RESYNC_CNTL__PHYPLLF_PIXCLK_ENABLE_MASK                                                0x00000100L
#define PHYPLLF_PIXCLK_RESYNC_CNTL__PHYPLLF_PIXCLK_DOUBLE_RATE_ENABLE_MASK                                    0x00000200L
//DCCG_DISP_CNTL_REG
#define DCCG_DISP_CNTL_REG__ALLOW_SR_ON_TRANS_REQ__SHIFT                                                      0x8
#define DCCG_DISP_CNTL_REG__ALLOW_SR_ON_TRANS_REQ_MASK                                                        0x00000100L
//CRTC0_PIXEL_RATE_CNTL
#define CRTC0_PIXEL_RATE_CNTL__CRTC0_PIXEL_RATE_SOURCE__SHIFT                                                 0x0
#define CRTC0_PIXEL_RATE_CNTL__DP_DTO0_ENABLE__SHIFT                                                          0x4
#define CRTC0_PIXEL_RATE_CNTL__DP_DTO0_DS_DISABLE__SHIFT                                                      0x5
#define CRTC0_PIXEL_RATE_CNTL__CRTC0_ADD_PIXEL__SHIFT                                                         0x8
#define CRTC0_PIXEL_RATE_CNTL__CRTC0_DROP_PIXEL__SHIFT                                                        0x9
#define CRTC0_PIXEL_RATE_CNTL__CRTC0_DISPOUT_HALF_RATE_EN__SHIFT                                              0xb
#define CRTC0_PIXEL_RATE_CNTL__CRTC0_DISPOUT_FIFO_ERROR__SHIFT                                                0xe
#define CRTC0_PIXEL_RATE_CNTL__CRTC0_DISPOUT_ERROR_COUNT__SHIFT                                               0x10
#define CRTC0_PIXEL_RATE_CNTL__CRTC0_PIXEL_RATE_SOURCE_MASK                                                   0x00000003L
#define CRTC0_PIXEL_RATE_CNTL__DP_DTO0_ENABLE_MASK                                                            0x00000010L
#define CRTC0_PIXEL_RATE_CNTL__DP_DTO0_DS_DISABLE_MASK                                                        0x00000020L
#define CRTC0_PIXEL_RATE_CNTL__CRTC0_ADD_PIXEL_MASK                                                           0x00000100L
#define CRTC0_PIXEL_RATE_CNTL__CRTC0_DROP_PIXEL_MASK                                                          0x00000200L
#define CRTC0_PIXEL_RATE_CNTL__CRTC0_DISPOUT_HALF_RATE_EN_MASK                                                0x00000800L
#define CRTC0_PIXEL_RATE_CNTL__CRTC0_DISPOUT_FIFO_ERROR_MASK                                                  0x0000C000L
#define CRTC0_PIXEL_RATE_CNTL__CRTC0_DISPOUT_ERROR_COUNT_MASK                                                 0x0FFF0000L
//DP_DTO0_PHASE
#define DP_DTO0_PHASE__DP_DTO0_PHASE__SHIFT                                                                   0x0
#define DP_DTO0_PHASE__DP_DTO0_PHASE_MASK                                                                     0xFFFFFFFFL
//DP_DTO0_MODULO
#define DP_DTO0_MODULO__DP_DTO0_MODULO__SHIFT                                                                 0x0
#define DP_DTO0_MODULO__DP_DTO0_MODULO_MASK                                                                   0xFFFFFFFFL
//CRTC0_PHYPLL_PIXEL_RATE_CNTL
#define CRTC0_PHYPLL_PIXEL_RATE_CNTL__CRTC0_PHYPLL_PIXEL_RATE_SOURCE__SHIFT                                   0x0
#define CRTC0_PHYPLL_PIXEL_RATE_CNTL__CRTC0_PIXEL_RATE_PLL_SOURCE__SHIFT                                      0x4
#define CRTC0_PHYPLL_PIXEL_RATE_CNTL__CRTC0_PHYPLL_PIXEL_RATE_SOURCE_MASK                                     0x00000007L
#define CRTC0_PHYPLL_PIXEL_RATE_CNTL__CRTC0_PIXEL_RATE_PLL_SOURCE_MASK                                        0x00000010L
//CRTC1_PIXEL_RATE_CNTL
#define CRTC1_PIXEL_RATE_CNTL__CRTC1_PIXEL_RATE_SOURCE__SHIFT                                                 0x0
#define CRTC1_PIXEL_RATE_CNTL__DP_DTO1_ENABLE__SHIFT                                                          0x4
#define CRTC1_PIXEL_RATE_CNTL__DP_DTO1_DS_DISABLE__SHIFT                                                      0x5
#define CRTC1_PIXEL_RATE_CNTL__CRTC1_ADD_PIXEL__SHIFT                                                         0x8
#define CRTC1_PIXEL_RATE_CNTL__CRTC1_DROP_PIXEL__SHIFT                                                        0x9
#define CRTC1_PIXEL_RATE_CNTL__CRTC1_DISPOUT_HALF_RATE_EN__SHIFT                                              0xb
#define CRTC1_PIXEL_RATE_CNTL__CRTC1_DISPOUT_FIFO_ERROR__SHIFT                                                0xe
#define CRTC1_PIXEL_RATE_CNTL__CRTC1_DISPOUT_ERROR_COUNT__SHIFT                                               0x10
#define CRTC1_PIXEL_RATE_CNTL__CRTC1_PIXEL_RATE_SOURCE_MASK                                                   0x00000003L
#define CRTC1_PIXEL_RATE_CNTL__DP_DTO1_ENABLE_MASK                                                            0x00000010L
#define CRTC1_PIXEL_RATE_CNTL__DP_DTO1_DS_DISABLE_MASK                                                        0x00000020L
#define CRTC1_PIXEL_RATE_CNTL__CRTC1_ADD_PIXEL_MASK                                                           0x00000100L
#define CRTC1_PIXEL_RATE_CNTL__CRTC1_DROP_PIXEL_MASK                                                          0x00000200L
#define CRTC1_PIXEL_RATE_CNTL__CRTC1_DISPOUT_HALF_RATE_EN_MASK                                                0x00000800L
#define CRTC1_PIXEL_RATE_CNTL__CRTC1_DISPOUT_FIFO_ERROR_MASK                                                  0x0000C000L
#define CRTC1_PIXEL_RATE_CNTL__CRTC1_DISPOUT_ERROR_COUNT_MASK                                                 0x0FFF0000L
//DP_DTO1_PHASE
#define DP_DTO1_PHASE__DP_DTO1_PHASE__SHIFT                                                                   0x0
#define DP_DTO1_PHASE__DP_DTO1_PHASE_MASK                                                                     0xFFFFFFFFL
//DP_DTO1_MODULO
#define DP_DTO1_MODULO__DP_DTO1_MODULO__SHIFT                                                                 0x0
#define DP_DTO1_MODULO__DP_DTO1_MODULO_MASK                                                                   0xFFFFFFFFL
//CRTC1_PHYPLL_PIXEL_RATE_CNTL
#define CRTC1_PHYPLL_PIXEL_RATE_CNTL__CRTC1_PHYPLL_PIXEL_RATE_SOURCE__SHIFT                                   0x0
#define CRTC1_PHYPLL_PIXEL_RATE_CNTL__CRTC1_PIXEL_RATE_PLL_SOURCE__SHIFT                                      0x4
#define CRTC1_PHYPLL_PIXEL_RATE_CNTL__CRTC1_PHYPLL_PIXEL_RATE_SOURCE_MASK                                     0x00000007L
#define CRTC1_PHYPLL_PIXEL_RATE_CNTL__CRTC1_PIXEL_RATE_PLL_SOURCE_MASK                                        0x00000010L
//CRTC2_PIXEL_RATE_CNTL
#define CRTC2_PIXEL_RATE_CNTL__CRTC2_PIXEL_RATE_SOURCE__SHIFT                                                 0x0
#define CRTC2_PIXEL_RATE_CNTL__DP_DTO2_ENABLE__SHIFT                                                          0x4
#define CRTC2_PIXEL_RATE_CNTL__DP_DTO2_DS_DISABLE__SHIFT                                                      0x5
#define CRTC2_PIXEL_RATE_CNTL__CRTC2_ADD_PIXEL__SHIFT                                                         0x8
#define CRTC2_PIXEL_RATE_CNTL__CRTC2_DROP_PIXEL__SHIFT                                                        0x9
#define CRTC2_PIXEL_RATE_CNTL__CRTC2_DISPOUT_HALF_RATE_EN__SHIFT                                              0xb
#define CRTC2_PIXEL_RATE_CNTL__CRTC2_DISPOUT_FIFO_ERROR__SHIFT                                                0xe
#define CRTC2_PIXEL_RATE_CNTL__CRTC2_DISPOUT_ERROR_COUNT__SHIFT                                               0x10
#define CRTC2_PIXEL_RATE_CNTL__CRTC2_PIXEL_RATE_SOURCE_MASK                                                   0x00000003L
#define CRTC2_PIXEL_RATE_CNTL__DP_DTO2_ENABLE_MASK                                                            0x00000010L
#define CRTC2_PIXEL_RATE_CNTL__DP_DTO2_DS_DISABLE_MASK                                                        0x00000020L
#define CRTC2_PIXEL_RATE_CNTL__CRTC2_ADD_PIXEL_MASK                                                           0x00000100L
#define CRTC2_PIXEL_RATE_CNTL__CRTC2_DROP_PIXEL_MASK                                                          0x00000200L
#define CRTC2_PIXEL_RATE_CNTL__CRTC2_DISPOUT_HALF_RATE_EN_MASK                                                0x00000800L
#define CRTC2_PIXEL_RATE_CNTL__CRTC2_DISPOUT_FIFO_ERROR_MASK                                                  0x0000C000L
#define CRTC2_PIXEL_RATE_CNTL__CRTC2_DISPOUT_ERROR_COUNT_MASK                                                 0x0FFF0000L
//DP_DTO2_PHASE
#define DP_DTO2_PHASE__DP_DTO2_PHASE__SHIFT                                                                   0x0
#define DP_DTO2_PHASE__DP_DTO2_PHASE_MASK                                                                     0xFFFFFFFFL
//DP_DTO2_MODULO
#define DP_DTO2_MODULO__DP_DTO2_MODULO__SHIFT                                                                 0x0
#define DP_DTO2_MODULO__DP_DTO2_MODULO_MASK                                                                   0xFFFFFFFFL
//CRTC2_PHYPLL_PIXEL_RATE_CNTL
#define CRTC2_PHYPLL_PIXEL_RATE_CNTL__CRTC2_PHYPLL_PIXEL_RATE_SOURCE__SHIFT                                   0x0
#define CRTC2_PHYPLL_PIXEL_RATE_CNTL__CRTC2_PIXEL_RATE_PLL_SOURCE__SHIFT                                      0x4
#define CRTC2_PHYPLL_PIXEL_RATE_CNTL__CRTC2_PHYPLL_PIXEL_RATE_SOURCE_MASK                                     0x00000007L
#define CRTC2_PHYPLL_PIXEL_RATE_CNTL__CRTC2_PIXEL_RATE_PLL_SOURCE_MASK                                        0x00000010L
//CRTC3_PIXEL_RATE_CNTL
#define CRTC3_PIXEL_RATE_CNTL__CRTC3_PIXEL_RATE_SOURCE__SHIFT                                                 0x0
#define CRTC3_PIXEL_RATE_CNTL__DP_DTO3_ENABLE__SHIFT                                                          0x4
#define CRTC3_PIXEL_RATE_CNTL__DP_DTO3_DS_DISABLE__SHIFT                                                      0x5
#define CRTC3_PIXEL_RATE_CNTL__CRTC3_ADD_PIXEL__SHIFT                                                         0x8
#define CRTC3_PIXEL_RATE_CNTL__CRTC3_DROP_PIXEL__SHIFT                                                        0x9
#define CRTC3_PIXEL_RATE_CNTL__CRTC3_DISPOUT_HALF_RATE_EN__SHIFT                                              0xb
#define CRTC3_PIXEL_RATE_CNTL__CRTC3_DISPOUT_FIFO_ERROR__SHIFT                                                0xe
#define CRTC3_PIXEL_RATE_CNTL__CRTC3_DISPOUT_ERROR_COUNT__SHIFT                                               0x10
#define CRTC3_PIXEL_RATE_CNTL__CRTC3_PIXEL_RATE_SOURCE_MASK                                                   0x00000003L
#define CRTC3_PIXEL_RATE_CNTL__DP_DTO3_ENABLE_MASK                                                            0x00000010L
#define CRTC3_PIXEL_RATE_CNTL__DP_DTO3_DS_DISABLE_MASK                                                        0x00000020L
#define CRTC3_PIXEL_RATE_CNTL__CRTC3_ADD_PIXEL_MASK                                                           0x00000100L
#define CRTC3_PIXEL_RATE_CNTL__CRTC3_DROP_PIXEL_MASK                                                          0x00000200L
#define CRTC3_PIXEL_RATE_CNTL__CRTC3_DISPOUT_HALF_RATE_EN_MASK                                                0x00000800L
#define CRTC3_PIXEL_RATE_CNTL__CRTC3_DISPOUT_FIFO_ERROR_MASK                                                  0x0000C000L
#define CRTC3_PIXEL_RATE_CNTL__CRTC3_DISPOUT_ERROR_COUNT_MASK                                                 0x0FFF0000L
//DP_DTO3_PHASE
#define DP_DTO3_PHASE__DP_DTO3_PHASE__SHIFT                                                                   0x0
#define DP_DTO3_PHASE__DP_DTO3_PHASE_MASK                                                                     0xFFFFFFFFL
//DP_DTO3_MODULO
#define DP_DTO3_MODULO__DP_DTO3_MODULO__SHIFT                                                                 0x0
#define DP_DTO3_MODULO__DP_DTO3_MODULO_MASK                                                                   0xFFFFFFFFL
//CRTC3_PHYPLL_PIXEL_RATE_CNTL
#define CRTC3_PHYPLL_PIXEL_RATE_CNTL__CRTC3_PHYPLL_PIXEL_RATE_SOURCE__SHIFT                                   0x0
#define CRTC3_PHYPLL_PIXEL_RATE_CNTL__CRTC3_PIXEL_RATE_PLL_SOURCE__SHIFT                                      0x4
#define CRTC3_PHYPLL_PIXEL_RATE_CNTL__CRTC3_PHYPLL_PIXEL_RATE_SOURCE_MASK                                     0x00000007L
#define CRTC3_PHYPLL_PIXEL_RATE_CNTL__CRTC3_PIXEL_RATE_PLL_SOURCE_MASK                                        0x00000010L
//CRTC4_PIXEL_RATE_CNTL
#define CRTC4_PIXEL_RATE_CNTL__CRTC4_PIXEL_RATE_SOURCE__SHIFT                                                 0x0
#define CRTC4_PIXEL_RATE_CNTL__DP_DTO4_ENABLE__SHIFT                                                          0x4
#define CRTC4_PIXEL_RATE_CNTL__DP_DTO4_DS_DISABLE__SHIFT                                                      0x5
#define CRTC4_PIXEL_RATE_CNTL__CRTC4_ADD_PIXEL__SHIFT                                                         0x8
#define CRTC4_PIXEL_RATE_CNTL__CRTC4_DROP_PIXEL__SHIFT                                                        0x9
#define CRTC4_PIXEL_RATE_CNTL__CRTC4_DISPOUT_HALF_RATE_EN__SHIFT                                              0xb
#define CRTC4_PIXEL_RATE_CNTL__CRTC4_DISPOUT_FIFO_ERROR__SHIFT                                                0xe
#define CRTC4_PIXEL_RATE_CNTL__CRTC4_DISPOUT_ERROR_COUNT__SHIFT                                               0x10
#define CRTC4_PIXEL_RATE_CNTL__CRTC4_PIXEL_RATE_SOURCE_MASK                                                   0x00000003L
#define CRTC4_PIXEL_RATE_CNTL__DP_DTO4_ENABLE_MASK                                                            0x00000010L
#define CRTC4_PIXEL_RATE_CNTL__DP_DTO4_DS_DISABLE_MASK                                                        0x00000020L
#define CRTC4_PIXEL_RATE_CNTL__CRTC4_ADD_PIXEL_MASK                                                           0x00000100L
#define CRTC4_PIXEL_RATE_CNTL__CRTC4_DROP_PIXEL_MASK                                                          0x00000200L
#define CRTC4_PIXEL_RATE_CNTL__CRTC4_DISPOUT_HALF_RATE_EN_MASK                                                0x00000800L
#define CRTC4_PIXEL_RATE_CNTL__CRTC4_DISPOUT_FIFO_ERROR_MASK                                                  0x0000C000L
#define CRTC4_PIXEL_RATE_CNTL__CRTC4_DISPOUT_ERROR_COUNT_MASK                                                 0x0FFF0000L
//DP_DTO4_PHASE
#define DP_DTO4_PHASE__DP_DTO4_PHASE__SHIFT                                                                   0x0
#define DP_DTO4_PHASE__DP_DTO4_PHASE_MASK                                                                     0xFFFFFFFFL
//DP_DTO4_MODULO
#define DP_DTO4_MODULO__DP_DTO4_MODULO__SHIFT                                                                 0x0
#define DP_DTO4_MODULO__DP_DTO4_MODULO_MASK                                                                   0xFFFFFFFFL
//CRTC4_PHYPLL_PIXEL_RATE_CNTL
#define CRTC4_PHYPLL_PIXEL_RATE_CNTL__CRTC4_PHYPLL_PIXEL_RATE_SOURCE__SHIFT                                   0x0
#define CRTC4_PHYPLL_PIXEL_RATE_CNTL__CRTC4_PIXEL_RATE_PLL_SOURCE__SHIFT                                      0x4
#define CRTC4_PHYPLL_PIXEL_RATE_CNTL__CRTC4_PHYPLL_PIXEL_RATE_SOURCE_MASK                                     0x00000007L
#define CRTC4_PHYPLL_PIXEL_RATE_CNTL__CRTC4_PIXEL_RATE_PLL_SOURCE_MASK                                        0x00000010L
//CRTC5_PIXEL_RATE_CNTL
#define CRTC5_PIXEL_RATE_CNTL__CRTC5_PIXEL_RATE_SOURCE__SHIFT                                                 0x0
#define CRTC5_PIXEL_RATE_CNTL__DP_DTO5_ENABLE__SHIFT                                                          0x4
#define CRTC5_PIXEL_RATE_CNTL__DP_DTO5_DS_DISABLE__SHIFT                                                      0x5
#define CRTC5_PIXEL_RATE_CNTL__CRTC5_ADD_PIXEL__SHIFT                                                         0x8
#define CRTC5_PIXEL_RATE_CNTL__CRTC5_DROP_PIXEL__SHIFT                                                        0x9
#define CRTC5_PIXEL_RATE_CNTL__CRTC5_DISPOUT_HALF_RATE_EN__SHIFT                                              0xb
#define CRTC5_PIXEL_RATE_CNTL__CRTC5_DISPOUT_FIFO_ERROR__SHIFT                                                0xe
#define CRTC5_PIXEL_RATE_CNTL__CRTC5_DISPOUT_ERROR_COUNT__SHIFT                                               0x10
#define CRTC5_PIXEL_RATE_CNTL__CRTC5_PIXEL_RATE_SOURCE_MASK                                                   0x00000003L
#define CRTC5_PIXEL_RATE_CNTL__DP_DTO5_ENABLE_MASK                                                            0x00000010L
#define CRTC5_PIXEL_RATE_CNTL__DP_DTO5_DS_DISABLE_MASK                                                        0x00000020L
#define CRTC5_PIXEL_RATE_CNTL__CRTC5_ADD_PIXEL_MASK                                                           0x00000100L
#define CRTC5_PIXEL_RATE_CNTL__CRTC5_DROP_PIXEL_MASK                                                          0x00000200L
#define CRTC5_PIXEL_RATE_CNTL__CRTC5_DISPOUT_HALF_RATE_EN_MASK                                                0x00000800L
#define CRTC5_PIXEL_RATE_CNTL__CRTC5_DISPOUT_FIFO_ERROR_MASK                                                  0x0000C000L
#define CRTC5_PIXEL_RATE_CNTL__CRTC5_DISPOUT_ERROR_COUNT_MASK                                                 0x0FFF0000L
//DP_DTO5_PHASE
#define DP_DTO5_PHASE__DP_DTO5_PHASE__SHIFT                                                                   0x0
#define DP_DTO5_PHASE__DP_DTO5_PHASE_MASK                                                                     0xFFFFFFFFL
//DP_DTO5_MODULO
#define DP_DTO5_MODULO__DP_DTO5_MODULO__SHIFT                                                                 0x0
#define DP_DTO5_MODULO__DP_DTO5_MODULO_MASK                                                                   0xFFFFFFFFL
//CRTC5_PHYPLL_PIXEL_RATE_CNTL
#define CRTC5_PHYPLL_PIXEL_RATE_CNTL__CRTC5_PHYPLL_PIXEL_RATE_SOURCE__SHIFT                                   0x0
#define CRTC5_PHYPLL_PIXEL_RATE_CNTL__CRTC5_PIXEL_RATE_PLL_SOURCE__SHIFT                                      0x4
#define CRTC5_PHYPLL_PIXEL_RATE_CNTL__CRTC5_PHYPLL_PIXEL_RATE_SOURCE_MASK                                     0x00000007L
#define CRTC5_PHYPLL_PIXEL_RATE_CNTL__CRTC5_PIXEL_RATE_PLL_SOURCE_MASK                                        0x00000010L
//DCCG_SOFT_RESET
#define DCCG_SOFT_RESET__REFCLK_SOFT_RESET__SHIFT                                                             0x0
#define DCCG_SOFT_RESET__PCIE_REFCLK_SOFT_RESET__SHIFT                                                        0x1
#define DCCG_SOFT_RESET__SOFT_RESET_DVO__SHIFT                                                                0x2
#define DCCG_SOFT_RESET__DVO_ENABLE_RST__SHIFT                                                                0x3
#define DCCG_SOFT_RESET__AUDIO_DTO2_CLK_SOFT_RESET__SHIFT                                                     0x4
#define DCCG_SOFT_RESET__DPREFCLK_SOFT_RESET__SHIFT                                                           0x8
#define DCCG_SOFT_RESET__AMCLK0_SOFT_RESET__SHIFT                                                             0xc
#define DCCG_SOFT_RESET__AMCLK1_SOFT_RESET__SHIFT                                                             0xd
#define DCCG_SOFT_RESET__P0PLL_CFG_IF_SOFT_RESET__SHIFT                                                       0xe
#define DCCG_SOFT_RESET__P1PLL_CFG_IF_SOFT_RESET__SHIFT                                                       0xf
#define DCCG_SOFT_RESET__P2PLL_CFG_IF_SOFT_RESET__SHIFT                                                       0x10
#define DCCG_SOFT_RESET__A0PLL_CFG_IF_SOFT_RESET__SHIFT                                                       0x11
#define DCCG_SOFT_RESET__A1PLL_CFG_IF_SOFT_RESET__SHIFT                                                       0x12
#define DCCG_SOFT_RESET__C0PLL_CFG_IF_SOFT_RESET__SHIFT                                                       0x13
#define DCCG_SOFT_RESET__C1PLL_CFG_IF_SOFT_RESET__SHIFT                                                       0x14
#define DCCG_SOFT_RESET__C2PLL_CFG_IF_SOFT_RESET__SHIFT                                                       0x15
#define DCCG_SOFT_RESET__REFCLK_SOFT_RESET_MASK                                                               0x00000001L
#define DCCG_SOFT_RESET__PCIE_REFCLK_SOFT_RESET_MASK                                                          0x00000002L
#define DCCG_SOFT_RESET__SOFT_RESET_DVO_MASK                                                                  0x00000004L
#define DCCG_SOFT_RESET__DVO_ENABLE_RST_MASK                                                                  0x00000008L
#define DCCG_SOFT_RESET__AUDIO_DTO2_CLK_SOFT_RESET_MASK                                                       0x00000010L
#define DCCG_SOFT_RESET__DPREFCLK_SOFT_RESET_MASK                                                             0x00000100L
#define DCCG_SOFT_RESET__AMCLK0_SOFT_RESET_MASK                                                               0x00001000L
#define DCCG_SOFT_RESET__AMCLK1_SOFT_RESET_MASK                                                               0x00002000L
#define DCCG_SOFT_RESET__P0PLL_CFG_IF_SOFT_RESET_MASK                                                         0x00004000L
#define DCCG_SOFT_RESET__P1PLL_CFG_IF_SOFT_RESET_MASK                                                         0x00008000L
#define DCCG_SOFT_RESET__P2PLL_CFG_IF_SOFT_RESET_MASK                                                         0x00010000L
#define DCCG_SOFT_RESET__A0PLL_CFG_IF_SOFT_RESET_MASK                                                         0x00020000L
#define DCCG_SOFT_RESET__A1PLL_CFG_IF_SOFT_RESET_MASK                                                         0x00040000L
#define DCCG_SOFT_RESET__C0PLL_CFG_IF_SOFT_RESET_MASK                                                         0x00080000L
#define DCCG_SOFT_RESET__C1PLL_CFG_IF_SOFT_RESET_MASK                                                         0x00100000L
#define DCCG_SOFT_RESET__C2PLL_CFG_IF_SOFT_RESET_MASK                                                         0x00200000L
//SYMCLKA_CLOCK_ENABLE
#define SYMCLKA_CLOCK_ENABLE__SYMCLKA_CLOCK_ENABLE__SHIFT                                                     0x0
#define SYMCLKA_CLOCK_ENABLE__SYMCLKA_FE_FORCE_EN__SHIFT                                                      0x4
#define SYMCLKA_CLOCK_ENABLE__SYMCLKA_FE_FORCE_SRC__SHIFT                                                     0x8
#define SYMCLKA_CLOCK_ENABLE__SYMCLKA_CLOCK_ENABLE_MASK                                                       0x00000001L
#define SYMCLKA_CLOCK_ENABLE__SYMCLKA_FE_FORCE_EN_MASK                                                        0x00000010L
#define SYMCLKA_CLOCK_ENABLE__SYMCLKA_FE_FORCE_SRC_MASK                                                       0x00000700L
//SYMCLKB_CLOCK_ENABLE
#define SYMCLKB_CLOCK_ENABLE__SYMCLKB_CLOCK_ENABLE__SHIFT                                                     0x0
#define SYMCLKB_CLOCK_ENABLE__SYMCLKB_FE_FORCE_EN__SHIFT                                                      0x4
#define SYMCLKB_CLOCK_ENABLE__SYMCLKB_FE_FORCE_SRC__SHIFT                                                     0x8
#define SYMCLKB_CLOCK_ENABLE__SYMCLKB_CLOCK_ENABLE_MASK                                                       0x00000001L
#define SYMCLKB_CLOCK_ENABLE__SYMCLKB_FE_FORCE_EN_MASK                                                        0x00000010L
#define SYMCLKB_CLOCK_ENABLE__SYMCLKB_FE_FORCE_SRC_MASK                                                       0x00000700L
//SYMCLKC_CLOCK_ENABLE
#define SYMCLKC_CLOCK_ENABLE__SYMCLKC_CLOCK_ENABLE__SHIFT                                                     0x0
#define SYMCLKC_CLOCK_ENABLE__SYMCLKC_FE_FORCE_EN__SHIFT                                                      0x4
#define SYMCLKC_CLOCK_ENABLE__SYMCLKC_FE_FORCE_SRC__SHIFT                                                     0x8
#define SYMCLKC_CLOCK_ENABLE__SYMCLKC_CLOCK_ENABLE_MASK                                                       0x00000001L
#define SYMCLKC_CLOCK_ENABLE__SYMCLKC_FE_FORCE_EN_MASK                                                        0x00000010L
#define SYMCLKC_CLOCK_ENABLE__SYMCLKC_FE_FORCE_SRC_MASK                                                       0x00000700L
//SYMCLKD_CLOCK_ENABLE
#define SYMCLKD_CLOCK_ENABLE__SYMCLKD_CLOCK_ENABLE__SHIFT                                                     0x0
#define SYMCLKD_CLOCK_ENABLE__SYMCLKD_FE_FORCE_EN__SHIFT                                                      0x4
#define SYMCLKD_CLOCK_ENABLE__SYMCLKD_FE_FORCE_SRC__SHIFT                                                     0x8
#define SYMCLKD_CLOCK_ENABLE__SYMCLKD_CLOCK_ENABLE_MASK                                                       0x00000001L
#define SYMCLKD_CLOCK_ENABLE__SYMCLKD_FE_FORCE_EN_MASK                                                        0x00000010L
#define SYMCLKD_CLOCK_ENABLE__SYMCLKD_FE_FORCE_SRC_MASK                                                       0x00000700L
//SYMCLKE_CLOCK_ENABLE
#define SYMCLKE_CLOCK_ENABLE__SYMCLKE_CLOCK_ENABLE__SHIFT                                                     0x0
#define SYMCLKE_CLOCK_ENABLE__SYMCLKE_FE_FORCE_EN__SHIFT                                                      0x4
#define SYMCLKE_CLOCK_ENABLE__SYMCLKE_FE_FORCE_SRC__SHIFT                                                     0x8
#define SYMCLKE_CLOCK_ENABLE__SYMCLKE_CLOCK_ENABLE_MASK                                                       0x00000001L
#define SYMCLKE_CLOCK_ENABLE__SYMCLKE_FE_FORCE_EN_MASK                                                        0x00000010L
#define SYMCLKE_CLOCK_ENABLE__SYMCLKE_FE_FORCE_SRC_MASK                                                       0x00000700L
//SYMCLKF_CLOCK_ENABLE
#define SYMCLKF_CLOCK_ENABLE__SYMCLKF_CLOCK_ENABLE__SHIFT                                                     0x0
#define SYMCLKF_CLOCK_ENABLE__SYMCLKF_FE_FORCE_EN__SHIFT                                                      0x4
#define SYMCLKF_CLOCK_ENABLE__SYMCLKF_FE_FORCE_SRC__SHIFT                                                     0x8
#define SYMCLKF_CLOCK_ENABLE__SYMCLKF_CLOCK_ENABLE_MASK                                                       0x00000001L
#define SYMCLKF_CLOCK_ENABLE__SYMCLKF_FE_FORCE_EN_MASK                                                        0x00000010L
#define SYMCLKF_CLOCK_ENABLE__SYMCLKF_FE_FORCE_SRC_MASK                                                       0x00000700L
//DVOACLKD_CNTL
#define DVOACLKD_CNTL__DVOACLKD_FINE_SKEW_CNTL__SHIFT                                                         0x0
#define DVOACLKD_CNTL__DVOACLKD_COARSE_SKEW_CNTL__SHIFT                                                       0x8
#define DVOACLKD_CNTL__DVOACLKD_FINE_ADJUST_EN__SHIFT                                                         0x10
#define DVOACLKD_CNTL__DVOACLKD_COARSE_ADJUST_EN__SHIFT                                                       0x11
#define DVOACLKD_CNTL__DVOACLKD_IN_PHASE__SHIFT                                                               0x12
#define DVOACLKD_CNTL__DVOACLKD_FINE_SKEW_CNTL_MASK                                                           0x00000007L
#define DVOACLKD_CNTL__DVOACLKD_COARSE_SKEW_CNTL_MASK                                                         0x00001F00L
#define DVOACLKD_CNTL__DVOACLKD_FINE_ADJUST_EN_MASK                                                           0x00010000L
#define DVOACLKD_CNTL__DVOACLKD_COARSE_ADJUST_EN_MASK                                                         0x00020000L
#define DVOACLKD_CNTL__DVOACLKD_IN_PHASE_MASK                                                                 0x00040000L
//DVOACLKC_MVP_CNTL
#define DVOACLKC_MVP_CNTL__DVOACLKC_MVP_FINE_SKEW_CNTL__SHIFT                                                 0x0
#define DVOACLKC_MVP_CNTL__DVOACLKC_MVP_COARSE_SKEW_CNTL__SHIFT                                               0x8
#define DVOACLKC_MVP_CNTL__DVOACLKC_MVP_FINE_ADJUST_EN__SHIFT                                                 0x10
#define DVOACLKC_MVP_CNTL__DVOACLKC_MVP_COARSE_ADJUST_EN__SHIFT                                               0x11
#define DVOACLKC_MVP_CNTL__DVOACLKC_MVP_IN_PHASE__SHIFT                                                       0x12
#define DVOACLKC_MVP_CNTL__DVOACLKC_MVP_SKEW_PHASE_OVERRIDE__SHIFT                                            0x14
#define DVOACLKC_MVP_CNTL__MVP_CLK_A_SRC_SEL__SHIFT                                                           0x18
#define DVOACLKC_MVP_CNTL__MVP_CLK_B_SRC_SEL__SHIFT                                                           0x1c
#define DVOACLKC_MVP_CNTL__DVOACLKC_MVP_FINE_SKEW_CNTL_MASK                                                   0x00000007L
#define DVOACLKC_MVP_CNTL__DVOACLKC_MVP_COARSE_SKEW_CNTL_MASK                                                 0x00001F00L
#define DVOACLKC_MVP_CNTL__DVOACLKC_MVP_FINE_ADJUST_EN_MASK                                                   0x00010000L
#define DVOACLKC_MVP_CNTL__DVOACLKC_MVP_COARSE_ADJUST_EN_MASK                                                 0x00020000L
#define DVOACLKC_MVP_CNTL__DVOACLKC_MVP_IN_PHASE_MASK                                                         0x00040000L
#define DVOACLKC_MVP_CNTL__DVOACLKC_MVP_SKEW_PHASE_OVERRIDE_MASK                                              0x00100000L
#define DVOACLKC_MVP_CNTL__MVP_CLK_A_SRC_SEL_MASK                                                             0x03000000L
#define DVOACLKC_MVP_CNTL__MVP_CLK_B_SRC_SEL_MASK                                                             0x30000000L
//DVOACLKC_CNTL
#define DVOACLKC_CNTL__DVOACLKC_FINE_SKEW_CNTL__SHIFT                                                         0x0
#define DVOACLKC_CNTL__DVOACLKC_COARSE_SKEW_CNTL__SHIFT                                                       0x8
#define DVOACLKC_CNTL__DVOACLKC_FINE_ADJUST_EN__SHIFT                                                         0x10
#define DVOACLKC_CNTL__DVOACLKC_COARSE_ADJUST_EN__SHIFT                                                       0x11
#define DVOACLKC_CNTL__DVOACLKC_IN_PHASE__SHIFT                                                               0x12
#define DVOACLKC_CNTL__DVOACLKC_FINE_SKEW_CNTL_MASK                                                           0x00000007L
#define DVOACLKC_CNTL__DVOACLKC_COARSE_SKEW_CNTL_MASK                                                         0x00001F00L
#define DVOACLKC_CNTL__DVOACLKC_FINE_ADJUST_EN_MASK                                                           0x00010000L
#define DVOACLKC_CNTL__DVOACLKC_COARSE_ADJUST_EN_MASK                                                         0x00020000L
#define DVOACLKC_CNTL__DVOACLKC_IN_PHASE_MASK                                                                 0x00040000L
//DCCG_AUDIO_DTO_SOURCE
#define DCCG_AUDIO_DTO_SOURCE__DCCG_AUDIO_DTO0_SOURCE_SEL__SHIFT                                              0x0
#define DCCG_AUDIO_DTO_SOURCE__DCCG_AUDIO_DTO_SEL__SHIFT                                                      0x4
#define DCCG_AUDIO_DTO_SOURCE__DCCG_AUDIO_DTO2_SOURCE_SEL__SHIFT                                              0xc
#define DCCG_AUDIO_DTO_SOURCE__DCCG_AUDIO_DTO2_CLOCK_EN__SHIFT                                                0x10
#define DCCG_AUDIO_DTO_SOURCE__DCCG_AUDIO_DTO2_USE_512FBR_DTO__SHIFT                                          0x14
#define DCCG_AUDIO_DTO_SOURCE__DCCG_AUDIO_DTO0_USE_512FBR_DTO__SHIFT                                          0x18
#define DCCG_AUDIO_DTO_SOURCE__DCCG_AUDIO_DTO1_USE_512FBR_DTO__SHIFT                                          0x1c
#define DCCG_AUDIO_DTO_SOURCE__DCCG_AUDIO_DTO0_SOURCE_SEL_MASK                                                0x00000007L
#define DCCG_AUDIO_DTO_SOURCE__DCCG_AUDIO_DTO_SEL_MASK                                                        0x00000030L
#define DCCG_AUDIO_DTO_SOURCE__DCCG_AUDIO_DTO2_SOURCE_SEL_MASK                                                0x00003000L
#define DCCG_AUDIO_DTO_SOURCE__DCCG_AUDIO_DTO2_CLOCK_EN_MASK                                                  0x00010000L
#define DCCG_AUDIO_DTO_SOURCE__DCCG_AUDIO_DTO2_USE_512FBR_DTO_MASK                                            0x00100000L
#define DCCG_AUDIO_DTO_SOURCE__DCCG_AUDIO_DTO0_USE_512FBR_DTO_MASK                                            0x01000000L
#define DCCG_AUDIO_DTO_SOURCE__DCCG_AUDIO_DTO1_USE_512FBR_DTO_MASK                                            0x10000000L
//DCCG_AUDIO_DTO0_PHASE
#define DCCG_AUDIO_DTO0_PHASE__DCCG_AUDIO_DTO0_PHASE__SHIFT                                                   0x0
#define DCCG_AUDIO_DTO0_PHASE__DCCG_AUDIO_DTO0_PHASE_MASK                                                     0xFFFFFFFFL
//DCCG_AUDIO_DTO0_MODULE
#define DCCG_AUDIO_DTO0_MODULE__DCCG_AUDIO_DTO0_MODULE__SHIFT                                                 0x0
#define DCCG_AUDIO_DTO0_MODULE__DCCG_AUDIO_DTO0_MODULE_MASK                                                   0xFFFFFFFFL
//DCCG_AUDIO_DTO1_PHASE
#define DCCG_AUDIO_DTO1_PHASE__DCCG_AUDIO_DTO1_PHASE__SHIFT                                                   0x0
#define DCCG_AUDIO_DTO1_PHASE__DCCG_AUDIO_DTO1_PHASE_MASK                                                     0xFFFFFFFFL
//DCCG_AUDIO_DTO1_MODULE
#define DCCG_AUDIO_DTO1_MODULE__DCCG_AUDIO_DTO1_MODULE__SHIFT                                                 0x0
#define DCCG_AUDIO_DTO1_MODULE__DCCG_AUDIO_DTO1_MODULE_MASK                                                   0xFFFFFFFFL
//DCCG_TEST_CLK_SEL
#define DCCG_TEST_CLK_SEL__DCCG_TEST_CLK_GENERICA_SEL__SHIFT                                                  0x0
#define DCCG_TEST_CLK_SEL__DCCG_TEST_CLK_GENERICA_INV__SHIFT                                                  0xc
#define DCCG_TEST_CLK_SEL__DCCG_TEST_CLK_GENERICB_SEL__SHIFT                                                  0x10
#define DCCG_TEST_CLK_SEL__DCCG_TEST_CLK_GENERICB_INV__SHIFT                                                  0x1c
#define DCCG_TEST_CLK_SEL__DCCG_TEST_CLK_GENERICA_SEL_MASK                                                    0x000001FFL
#define DCCG_TEST_CLK_SEL__DCCG_TEST_CLK_GENERICA_INV_MASK                                                    0x00001000L
#define DCCG_TEST_CLK_SEL__DCCG_TEST_CLK_GENERICB_SEL_MASK                                                    0x01FF0000L
#define DCCG_TEST_CLK_SEL__DCCG_TEST_CLK_GENERICB_INV_MASK                                                    0x10000000L
//FBC_CNTL
#define FBC_CNTL__FBC_GRPH_COMP_EN__SHIFT                                                                     0x0
#define FBC_CNTL__FBC_SRC_SEL__SHIFT                                                                          0x1
#define FBC_CNTL__FBC_COMP_CLK_GATE_EN__SHIFT                                                                 0x8
#define FBC_CNTL__FBC_DECOMP_CLK_GATE_EN__SHIFT                                                               0xa
#define FBC_CNTL__FBC_COHERENCY_MODE__SHIFT                                                                   0x10
#define FBC_CNTL__FBC_DS_ALLOW_DIS__SHIFT                                                                     0x18
#define FBC_CNTL__FBC_SOFT_COMPRESS_EN__SHIFT                                                                 0x19
#define FBC_CNTL__FBC_QOS_LEVEL__SHIFT                                                                        0x1a
#define FBC_CNTL__FBC_EN__SHIFT                                                                               0x1f
#define FBC_CNTL__FBC_GRPH_COMP_EN_MASK                                                                       0x00000001L
#define FBC_CNTL__FBC_SRC_SEL_MASK                                                                            0x0000000EL
#define FBC_CNTL__FBC_COMP_CLK_GATE_EN_MASK                                                                   0x00000100L
#define FBC_CNTL__FBC_DECOMP_CLK_GATE_EN_MASK                                                                 0x00000400L
#define FBC_CNTL__FBC_COHERENCY_MODE_MASK                                                                     0x00030000L
#define FBC_CNTL__FBC_DS_ALLOW_DIS_MASK                                                                       0x01000000L
#define FBC_CNTL__FBC_SOFT_COMPRESS_EN_MASK                                                                   0x02000000L
#define FBC_CNTL__FBC_QOS_LEVEL_MASK                                                                          0x3C000000L
#define FBC_CNTL__FBC_EN_MASK                                                                                 0x80000000L
//FBC_IDLE_FORCE_CLEAR_MASK
#define FBC_IDLE_FORCE_CLEAR_MASK__FBC_IDLE_FORCE_CLEAR_MASK__SHIFT                                           0x0
#define FBC_IDLE_FORCE_CLEAR_MASK__FBC_IDLE_FORCE_CLEAR_MASK_MASK                                             0xFFFFFFFFL
//FBC_START_STOP_DELAY
#define FBC_START_STOP_DELAY__FBC_DECOMP_START_DELAY__SHIFT                                                   0x0
#define FBC_START_STOP_DELAY__FBC_DECOMP_STOP_DELAY__SHIFT                                                    0x7
#define FBC_START_STOP_DELAY__FBC_COMP_START_DELAY__SHIFT                                                     0x8
#define FBC_START_STOP_DELAY__FBC_DECOMP_START_DELAY_MASK                                                     0x0000001FL
#define FBC_START_STOP_DELAY__FBC_DECOMP_STOP_DELAY_MASK                                                      0x00000080L
#define FBC_START_STOP_DELAY__FBC_COMP_START_DELAY_MASK                                                       0x00001F00L
//FBC_COMP_CNTL
#define FBC_COMP_CNTL__FBC_MIN_COMPRESSION__SHIFT                                                             0x0
#define FBC_COMP_CNTL__FBC_DEPTH_MONO08_EN__SHIFT                                                             0x10
#define FBC_COMP_CNTL__FBC_DEPTH_MONO16_EN__SHIFT                                                             0x11
#define FBC_COMP_CNTL__FBC_DEPTH_RGB04_EN__SHIFT                                                              0x12
#define FBC_COMP_CNTL__FBC_DEPTH_RGB08_EN__SHIFT                                                              0x13
#define FBC_COMP_CNTL__FBC_DEPTH_RGB16_EN__SHIFT                                                              0x14
#define FBC_COMP_CNTL__FBC_MIN_COMPRESSION_MASK                                                               0x0000000FL
#define FBC_COMP_CNTL__FBC_DEPTH_MONO08_EN_MASK                                                               0x00010000L
#define FBC_COMP_CNTL__FBC_DEPTH_MONO16_EN_MASK                                                               0x00020000L
#define FBC_COMP_CNTL__FBC_DEPTH_RGB04_EN_MASK                                                                0x00040000L
#define FBC_COMP_CNTL__FBC_DEPTH_RGB08_EN_MASK                                                                0x00080000L
#define FBC_COMP_CNTL__FBC_DEPTH_RGB16_EN_MASK                                                                0x00100000L
//FBC_COMP_MODE
#define FBC_COMP_MODE__FBC_RLE_EN__SHIFT                                                                      0x0
#define FBC_COMP_MODE__FBC_DPCM4_RGB_EN__SHIFT                                                                0x8
#define FBC_COMP_MODE__FBC_DPCM8_RGB_EN__SHIFT                                                                0x9
#define FBC_COMP_MODE__FBC_DPCM4_YUV_EN__SHIFT                                                                0xa
#define FBC_COMP_MODE__FBC_DPCM8_YUV_EN__SHIFT                                                                0xb
#define FBC_COMP_MODE__FBC_IND_EN__SHIFT                                                                      0x10
#define FBC_COMP_MODE__FBC_RLE_EN_MASK                                                                        0x00000001L
#define FBC_COMP_MODE__FBC_DPCM4_RGB_EN_MASK                                                                  0x00000100L
#define FBC_COMP_MODE__FBC_DPCM8_RGB_EN_MASK                                                                  0x00000200L
#define FBC_COMP_MODE__FBC_DPCM4_YUV_EN_MASK                                                                  0x00000400L
#define FBC_COMP_MODE__FBC_DPCM8_YUV_EN_MASK                                                                  0x00000800L
#define FBC_COMP_MODE__FBC_IND_EN_MASK                                                                        0x00010000L
//FBC_IND_LUT0
#define FBC_IND_LUT0__FBC_IND_LUT0__SHIFT                                                                     0x0
#define FBC_IND_LUT0__FBC_IND_LUT0_MASK                                                                       0xFFFFFFFFL
//FBC_IND_LUT1
#define FBC_IND_LUT1__FBC_IND_LUT1__SHIFT                                                                     0x0
#define FBC_IND_LUT1__FBC_IND_LUT1_MASK                                                                       0xFFFFFFFFL
//FBC_IND_LUT2
#define FBC_IND_LUT2__FBC_IND_LUT2__SHIFT                                                                     0x0
#define FBC_IND_LUT2__FBC_IND_LUT2_MASK                                                                       0xFFFFFFFFL
//FBC_IND_LUT3
#define FBC_IND_LUT3__FBC_IND_LUT3__SHIFT                                                                     0x0
#define FBC_IND_LUT3__FBC_IND_LUT3_MASK                                                                       0xFFFFFFFFL
//FBC_IND_LUT4
#define FBC_IND_LUT4__FBC_IND_LUT4__SHIFT                                                                     0x0
#define FBC_IND_LUT4__FBC_IND_LUT4_MASK                                                                       0xFFFFFFFFL
//FBC_IND_LUT5
#define FBC_IND_LUT5__FBC_IND_LUT5__SHIFT                                                                     0x0
#define FBC_IND_LUT5__FBC_IND_LUT5_MASK                                                                       0xFFFFFFFFL
//FBC_IND_LUT6
#define FBC_IND_LUT6__FBC_IND_LUT6__SHIFT                                                                     0x0
#define FBC_IND_LUT6__FBC_IND_LUT6_MASK                                                                       0xFFFFFFFFL
//FBC_IND_LUT7
#define FBC_IND_LUT7__FBC_IND_LUT7__SHIFT                                                                     0x0
#define FBC_IND_LUT7__FBC_IND_LUT7_MASK                                                                       0xFFFFFFFFL
//FBC_IND_LUT8
#define FBC_IND_LUT8__FBC_IND_LUT8__SHIFT                                                                     0x0
#define FBC_IND_LUT8__FBC_IND_LUT8_MASK                                                                       0xFFFFFFFFL
//FBC_IND_LUT9
#define FBC_IND_LUT9__FBC_IND_LUT9__SHIFT                                                                     0x0
#define FBC_IND_LUT9__FBC_IND_LUT9_MASK                                                                       0xFFFFFFFFL
//FBC_IND_LUT10
#define FBC_IND_LUT10__FBC_IND_LUT10__SHIFT                                                                   0x0
#define FBC_IND_LUT10__FBC_IND_LUT10_MASK                                                                     0xFFFFFFFFL
//FBC_IND_LUT11
#define FBC_IND_LUT11__FBC_IND_LUT11__SHIFT                                                                   0x0
#define FBC_IND_LUT11__FBC_IND_LUT11_MASK                                                                     0xFFFFFFFFL
//FBC_IND_LUT12
#define FBC_IND_LUT12__FBC_IND_LUT12__SHIFT                                                                   0x0
#define FBC_IND_LUT12__FBC_IND_LUT12_MASK                                                                     0xFFFFFFFFL
//FBC_IND_LUT13
#define FBC_IND_LUT13__FBC_IND_LUT13__SHIFT                                                                   0x0
#define FBC_IND_LUT13__FBC_IND_LUT13_MASK                                                                     0xFFFFFFFFL
//FBC_IND_LUT14
#define FBC_IND_LUT14__FBC_IND_LUT14__SHIFT                                                                   0x0
#define FBC_IND_LUT14__FBC_IND_LUT14_MASK                                                                     0xFFFFFFFFL
//FBC_IND_LUT15
#define FBC_IND_LUT15__FBC_IND_LUT15__SHIFT                                                                   0x0
#define FBC_IND_LUT15__FBC_IND_LUT15_MASK                                                                     0xFFFFFFFFL
//FBC_CSM_REGION_OFFSET_01
#define FBC_CSM_REGION_OFFSET_01__FBC_CSM_REGION_OFFSET_0__SHIFT                                              0x0
#define FBC_CSM_REGION_OFFSET_01__FBC_CSM_REGION_OFFSET_1__SHIFT                                              0x10
#define FBC_CSM_REGION_OFFSET_01__FBC_CSM_REGION_OFFSET_0_MASK                                                0x00000FFFL
#define FBC_CSM_REGION_OFFSET_01__FBC_CSM_REGION_OFFSET_1_MASK                                                0x0FFF0000L
//FBC_CSM_REGION_OFFSET_23
#define FBC_CSM_REGION_OFFSET_23__FBC_CSM_REGION_OFFSET_2__SHIFT                                              0x0
#define FBC_CSM_REGION_OFFSET_23__FBC_CSM_REGION_OFFSET_3__SHIFT                                              0x10
#define FBC_CSM_REGION_OFFSET_23__FBC_CSM_REGION_OFFSET_2_MASK                                                0x00000FFFL
#define FBC_CSM_REGION_OFFSET_23__FBC_CSM_REGION_OFFSET_3_MASK                                                0x0FFF0000L
//FBC_CLIENT_REGION_MASK
#define FBC_CLIENT_REGION_MASK__FBC_MEMORY_REGION_MASK__SHIFT                                                 0x10
#define FBC_CLIENT_REGION_MASK__FBC_MEMORY_REGION_MASK_MASK                                                   0x000F0000L
//FBC_DEBUG_COMP
#define FBC_DEBUG_COMP__FBC_COMP_SWAP__SHIFT                                                                  0x0
#define FBC_DEBUG_COMP__FBC_COMP_RSIZE__SHIFT                                                                 0x3
#define FBC_DEBUG_COMP__FBC_COMP_BUSY_HYSTERESIS__SHIFT                                                       0x4
#define FBC_DEBUG_COMP__FBC_COMP_CLK_CNTL__SHIFT                                                              0x8
#define FBC_DEBUG_COMP__FBC_COMP_PRIVILEGED_ACCESS_ENABLE__SHIFT                                              0xa
#define FBC_DEBUG_COMP__FBC_COMP_ADDRESS_TRANSLATION_ENABLE__SHIFT                                            0xb
#define FBC_DEBUG_COMP__FBC_COMP_SWAP_MASK                                                                    0x00000003L
#define FBC_DEBUG_COMP__FBC_COMP_RSIZE_MASK                                                                   0x00000008L
#define FBC_DEBUG_COMP__FBC_COMP_BUSY_HYSTERESIS_MASK                                                         0x000000F0L
#define FBC_DEBUG_COMP__FBC_COMP_CLK_CNTL_MASK                                                                0x00000300L
#define FBC_DEBUG_COMP__FBC_COMP_PRIVILEGED_ACCESS_ENABLE_MASK                                                0x00000400L
#define FBC_DEBUG_COMP__FBC_COMP_ADDRESS_TRANSLATION_ENABLE_MASK                                              0x00000800L
//FBC_MISC
#define FBC_MISC__FBC_DECOMPRESS_ERROR__SHIFT                                                                 0x0
#define FBC_MISC__FBC_STOP_ON_ERROR__SHIFT                                                                    0x2
#define FBC_MISC__FBC_INVALIDATE_ON_ERROR__SHIFT                                                              0x3
#define FBC_MISC__FBC_ERROR_PIXEL__SHIFT                                                                      0x4
#define FBC_MISC__FBC_DIVIDE_X__SHIFT                                                                         0x8
#define FBC_MISC__FBC_DIVIDE_Y__SHIFT                                                                         0xa
#define FBC_MISC__FBC_RSM_WRITE_VALUE__SHIFT                                                                  0xb
#define FBC_MISC__FBC_RSM_UNCOMP_DATA_IMMEDIATELY__SHIFT                                                      0xc
#define FBC_MISC__FBC_STOP_ON_HFLIP_EVENT__SHIFT                                                              0xd
#define FBC_MISC__FBC_STOP_COMP_ON_INVALIDATE__SHIFT                                                          0xe
#define FBC_MISC__FBC_DECOMPRESS_ERROR_CLEAR__SHIFT                                                           0x10
#define FBC_MISC__FBC_RESET_AT_ENABLE__SHIFT                                                                  0x14
#define FBC_MISC__FBC_RESET_AT_DISABLE__SHIFT                                                                 0x15
#define FBC_MISC__FBC_SLOW_REQ_INTERVAL__SHIFT                                                                0x18
#define FBC_MISC__FBC_FORCE_DECOMPRESSOR_EN__SHIFT                                                            0x1f
#define FBC_MISC__FBC_DECOMPRESS_ERROR_MASK                                                                   0x00000003L
#define FBC_MISC__FBC_STOP_ON_ERROR_MASK                                                                      0x00000004L
#define FBC_MISC__FBC_INVALIDATE_ON_ERROR_MASK                                                                0x00000008L
#define FBC_MISC__FBC_ERROR_PIXEL_MASK                                                                        0x000000F0L
#define FBC_MISC__FBC_DIVIDE_X_MASK                                                                           0x00000300L
#define FBC_MISC__FBC_DIVIDE_Y_MASK                                                                           0x00000400L
#define FBC_MISC__FBC_RSM_WRITE_VALUE_MASK                                                                    0x00000800L
#define FBC_MISC__FBC_RSM_UNCOMP_DATA_IMMEDIATELY_MASK                                                        0x00001000L
#define FBC_MISC__FBC_STOP_ON_HFLIP_EVENT_MASK                                                                0x00002000L
#define FBC_MISC__FBC_STOP_COMP_ON_INVALIDATE_MASK                                                            0x00004000L
#define FBC_MISC__FBC_DECOMPRESS_ERROR_CLEAR_MASK                                                             0x00010000L
#define FBC_MISC__FBC_RESET_AT_ENABLE_MASK                                                                    0x00100000L
#define FBC_MISC__FBC_RESET_AT_DISABLE_MASK                                                                   0x00200000L
#define FBC_MISC__FBC_SLOW_REQ_INTERVAL_MASK                                                                  0x1F000000L
#define FBC_MISC__FBC_FORCE_DECOMPRESSOR_EN_MASK                                                              0x80000000L
//FBC_STATUS
#define FBC_STATUS__FBC_ENABLE_STATUS__SHIFT                                                                  0x0
#define FBC_STATUS__FBC_ENABLE_STATUS_SW__SHIFT                                                               0x4
#define FBC_STATUS__FBC_COMPRESSION_ENABLE_STATUS__SHIFT                                                      0x8
#define FBC_STATUS__FBC_DECOMPRESSION_ENABLE_STATUS__SHIFT                                                    0xc
#define FBC_STATUS__FBC_ENABLE_STATUS_MASK                                                                    0x00000001L
#define FBC_STATUS__FBC_ENABLE_STATUS_SW_MASK                                                                 0x00000010L
#define FBC_STATUS__FBC_COMPRESSION_ENABLE_STATUS_MASK                                                        0x00000100L
#define FBC_STATUS__FBC_DECOMPRESSION_ENABLE_STATUS_MASK                                                      0x00001000L
//FBC_ALPHA_CNTL
#define FBC_ALPHA_CNTL__FBC_ALPHA_COMP_EN__SHIFT                                                              0x0
#define FBC_ALPHA_CNTL__FBC_FORCE_COPY_TO_COMP_BUF__SHIFT                                                     0x4
#define FBC_ALPHA_CNTL__FBC_ZERO_ALPHA_CHUNK_SKIP_EN__SHIFT                                                   0x8
#define FBC_ALPHA_CNTL__FBC_ALPHA_COMP_EN_MASK                                                                0x00000001L
#define FBC_ALPHA_CNTL__FBC_FORCE_COPY_TO_COMP_BUF_MASK                                                       0x00000010L
#define FBC_ALPHA_CNTL__FBC_ZERO_ALPHA_CHUNK_SKIP_EN_MASK                                                     0x00000100L
//FBC_ALPHA_RGB_OVERRIDE
#define FBC_ALPHA_RGB_OVERRIDE__FBC_ZERO_ALPHA_R_VAL__SHIFT                                                   0x0
#define FBC_ALPHA_RGB_OVERRIDE__FBC_ZERO_ALPHA_G_VAL__SHIFT                                                   0xc
#define FBC_ALPHA_RGB_OVERRIDE__FBC_ZERO_ALPHA_B_VAL__SHIFT                                                   0x18
#define FBC_ALPHA_RGB_OVERRIDE__FBC_ZERO_ALPHA_R_VAL_MASK                                                     0x000000FFL
#define FBC_ALPHA_RGB_OVERRIDE__FBC_ZERO_ALPHA_G_VAL_MASK                                                     0x000FF000L
#define FBC_ALPHA_RGB_OVERRIDE__FBC_ZERO_ALPHA_B_VAL_MASK                                                     0xFF000000L
//PIPE0_PG_CONFIG
#define PIPE0_PG_CONFIG__PIPE0_POWER_FORCEON__SHIFT                                                           0x0
#define PIPE0_PG_CONFIG__PIPE0_POWER_FORCEON_MASK                                                             0x00000001L
//PIPE0_PG_ENABLE
#define PIPE0_PG_ENABLE__PIPE0_POWER_GATE__SHIFT                                                              0x0
#define PIPE0_PG_ENABLE__PIPE0_POWER_GATE_MASK                                                                0x00000001L
//PIPE0_PG_STATUS
#define PIPE0_PG_STATUS__PIPE0_DESIRED_PWR_STATE__SHIFT                                                       0x1c
#define PIPE0_PG_STATUS__PIPE0_PGFSM_PWR_STATUS__SHIFT                                                        0x1e
#define PIPE0_PG_STATUS__PIPE0_DESIRED_PWR_STATE_MASK                                                         0x10000000L
#define PIPE0_PG_STATUS__PIPE0_PGFSM_PWR_STATUS_MASK                                                          0xC0000000L
//PIPE1_PG_CONFIG
#define PIPE1_PG_CONFIG__PIPE1_POWER_FORCEON__SHIFT                                                           0x0
#define PIPE1_PG_CONFIG__PIPE1_POWER_FORCEON_MASK                                                             0x00000001L
//PIPE1_PG_ENABLE
#define PIPE1_PG_ENABLE__PIPE1_POWER_GATE__SHIFT                                                              0x0
#define PIPE1_PG_ENABLE__PIPE1_POWER_GATE_MASK                                                                0x00000001L
//PIPE1_PG_STATUS
#define PIPE1_PG_STATUS__PIPE1_DESIRED_PWR_STATE__SHIFT                                                       0x1c
#define PIPE1_PG_STATUS__PIPE1_PGFSM_PWR_STATUS__SHIFT                                                        0x1e
#define PIPE1_PG_STATUS__PIPE1_DESIRED_PWR_STATE_MASK                                                         0x10000000L
#define PIPE1_PG_STATUS__PIPE1_PGFSM_PWR_STATUS_MASK                                                          0xC0000000L
//PIPE2_PG_CONFIG
#define PIPE2_PG_CONFIG__PIPE2_POWER_FORCEON__SHIFT                                                           0x0
#define PIPE2_PG_CONFIG__PIPE2_POWER_FORCEON_MASK                                                             0x00000001L
//PIPE2_PG_ENABLE
#define PIPE2_PG_ENABLE__PIPE2_POWER_GATE__SHIFT                                                              0x0
#define PIPE2_PG_ENABLE__PIPE2_POWER_GATE_MASK                                                                0x00000001L
//PIPE2_PG_STATUS
#define PIPE2_PG_STATUS__PIPE2_DESIRED_PWR_STATE__SHIFT                                                       0x1c
#define PIPE2_PG_STATUS__PIPE2_PGFSM_PWR_STATUS__SHIFT                                                        0x1e
#define PIPE2_PG_STATUS__PIPE2_DESIRED_PWR_STATE_MASK                                                         0x10000000L
#define PIPE2_PG_STATUS__PIPE2_PGFSM_PWR_STATUS_MASK                                                          0xC0000000L
//PIPE3_PG_CONFIG
#define PIPE3_PG_CONFIG__PIPE3_POWER_FORCEON__SHIFT                                                           0x0
#define PIPE3_PG_CONFIG__PIPE3_POWER_FORCEON_MASK                                                             0x00000001L
//PIPE3_PG_ENABLE
#define PIPE3_PG_ENABLE__PIPE3_POWER_GATE__SHIFT                                                              0x0
#define PIPE3_PG_ENABLE__PIPE3_POWER_GATE_MASK                                                                0x00000001L
//PIPE3_PG_STATUS
#define PIPE3_PG_STATUS__PIPE3_DESIRED_PWR_STATE__SHIFT                                                       0x1c
#define PIPE3_PG_STATUS__PIPE3_PGFSM_PWR_STATUS__SHIFT                                                        0x1e
#define PIPE3_PG_STATUS__PIPE3_DESIRED_PWR_STATE_MASK                                                         0x10000000L
#define PIPE3_PG_STATUS__PIPE3_PGFSM_PWR_STATUS_MASK                                                          0xC0000000L
//PIPE4_PG_CONFIG
#define PIPE4_PG_CONFIG__PIPE4_POWER_FORCEON__SHIFT                                                           0x0
#define PIPE4_PG_CONFIG__PIPE4_POWER_FORCEON_MASK                                                             0x00000001L
//PIPE4_PG_ENABLE
#define PIPE4_PG_ENABLE__PIPE4_POWER_GATE__SHIFT                                                              0x0
#define PIPE4_PG_ENABLE__PIPE4_POWER_GATE_MASK                                                                0x00000001L
//PIPE4_PG_STATUS
#define PIPE4_PG_STATUS__PIPE4_DESIRED_PWR_STATE__SHIFT                                                       0x1c
#define PIPE4_PG_STATUS__PIPE4_PGFSM_PWR_STATUS__SHIFT                                                        0x1e
#define PIPE4_PG_STATUS__PIPE4_DESIRED_PWR_STATE_MASK                                                         0x10000000L
#define PIPE4_PG_STATUS__PIPE4_PGFSM_PWR_STATUS_MASK                                                          0xC0000000L
//PIPE5_PG_CONFIG
#define PIPE5_PG_CONFIG__PIPE5_POWER_FORCEON__SHIFT                                                           0x0
#define PIPE5_PG_CONFIG__PIPE5_POWER_FORCEON_MASK                                                             0x00000001L
//PIPE5_PG_ENABLE
#define PIPE5_PG_ENABLE__PIPE5_POWER_GATE__SHIFT                                                              0x0
#define PIPE5_PG_ENABLE__PIPE5_POWER_GATE_MASK                                                                0x00000001L
//PIPE5_PG_STATUS
#define PIPE5_PG_STATUS__PIPE5_DESIRED_PWR_STATE__SHIFT                                                       0x1c
#define PIPE5_PG_STATUS__PIPE5_PGFSM_PWR_STATUS__SHIFT                                                        0x1e
#define PIPE5_PG_STATUS__PIPE5_DESIRED_PWR_STATE_MASK                                                         0x10000000L
#define PIPE5_PG_STATUS__PIPE5_PGFSM_PWR_STATUS_MASK                                                          0xC0000000L
//DSI_PG_CONFIG
#define DSI_PG_CONFIG__DSI_POWER_FORCEON__SHIFT                                                               0x0
#define DSI_PG_CONFIG__DSI_POWER_FORCEON_MASK                                                                 0x00000001L
//DSI_PG_ENABLE
#define DSI_PG_ENABLE__DSI_POWER_GATE__SHIFT                                                                  0x0
#define DSI_PG_ENABLE__DSI_POWER_GATE_MASK                                                                    0x00000001L
//DSI_PG_STATUS
#define DSI_PG_STATUS__DSI_DESIRED_PWR_STATE__SHIFT                                                           0x1c
#define DSI_PG_STATUS__DSI_PGFSM_PWR_STATUS__SHIFT                                                            0x1e
#define DSI_PG_STATUS__DSI_DESIRED_PWR_STATE_MASK                                                             0x10000000L
#define DSI_PG_STATUS__DSI_PGFSM_PWR_STATUS_MASK                                                              0xC0000000L
//DCFEV0_PG_CONFIG
#define DCFEV0_PG_CONFIG__DCFEV0_POWER_FORCEON__SHIFT                                                         0x0
#define DCFEV0_PG_CONFIG__DCFEV0_POWER_FORCEON_MASK                                                           0x00000001L
//DCFEV0_PG_ENABLE
#define DCFEV0_PG_ENABLE__DCFEV0_POWER_GATE__SHIFT                                                            0x0
#define DCFEV0_PG_ENABLE__DCFEV0_POWER_GATE_MASK                                                              0x00000001L
//DCFEV0_PG_STATUS
#define DCFEV0_PG_STATUS__DCFEV0_DESIRED_PWR_STATE__SHIFT                                                     0x1c
#define DCFEV0_PG_STATUS__DCFEV0_PGFSM_PWR_STATUS__SHIFT                                                      0x1e
#define DCFEV0_PG_STATUS__DCFEV0_DESIRED_PWR_STATE_MASK                                                       0x10000000L
#define DCFEV0_PG_STATUS__DCFEV0_PGFSM_PWR_STATUS_MASK                                                        0xC0000000L
//DCPG_INTERRUPT_STATUS
#define DCPG_INTERRUPT_STATUS__DCFE0_POWER_UP_INT_OCCURRED__SHIFT                                             0x0
#define DCPG_INTERRUPT_STATUS__DCFE0_POWER_DOWN_INT_OCCURRED__SHIFT                                           0x1
#define DCPG_INTERRUPT_STATUS__DCFE1_POWER_UP_INT_OCCURRED__SHIFT                                             0x2
#define DCPG_INTERRUPT_STATUS__DCFE1_POWER_DOWN_INT_OCCURRED__SHIFT                                           0x3
#define DCPG_INTERRUPT_STATUS__DCFE2_POWER_UP_INT_OCCURRED__SHIFT                                             0x4
#define DCPG_INTERRUPT_STATUS__DCFE2_POWER_DOWN_INT_OCCURRED__SHIFT                                           0x5
#define DCPG_INTERRUPT_STATUS__DCFE3_POWER_UP_INT_OCCURRED__SHIFT                                             0x6
#define DCPG_INTERRUPT_STATUS__DCFE3_POWER_DOWN_INT_OCCURRED__SHIFT                                           0x7
#define DCPG_INTERRUPT_STATUS__DCFE4_POWER_UP_INT_OCCURRED__SHIFT                                             0x8
#define DCPG_INTERRUPT_STATUS__DCFE4_POWER_DOWN_INT_OCCURRED__SHIFT                                           0x9
#define DCPG_INTERRUPT_STATUS__DCFE5_POWER_UP_INT_OCCURRED__SHIFT                                             0xa
#define DCPG_INTERRUPT_STATUS__DCFE5_POWER_DOWN_INT_OCCURRED__SHIFT                                           0xb
#define DCPG_INTERRUPT_STATUS__DCFEV0_POWER_UP_INT_OCCURRED__SHIFT                                            0xc
#define DCPG_INTERRUPT_STATUS__DCFEV0_POWER_DOWN_INT_OCCURRED__SHIFT                                          0xd
#define DCPG_INTERRUPT_STATUS__DSI_POWER_UP_INT_OCCURRED__SHIFT                                               0xe
#define DCPG_INTERRUPT_STATUS__DSI_POWER_DOWN_INT_OCCURRED__SHIFT                                             0xf
#define DCPG_INTERRUPT_STATUS__DCFEV1_POWER_UP_INT_OCCURRED__SHIFT                                            0x10
#define DCPG_INTERRUPT_STATUS__DCFEV1_POWER_DOWN_INT_OCCURRED__SHIFT                                          0x11
#define DCPG_INTERRUPT_STATUS__DCFE0_POWER_UP_INT_OCCURRED_MASK                                               0x00000001L
#define DCPG_INTERRUPT_STATUS__DCFE0_POWER_DOWN_INT_OCCURRED_MASK                                             0x00000002L
#define DCPG_INTERRUPT_STATUS__DCFE1_POWER_UP_INT_OCCURRED_MASK                                               0x00000004L
#define DCPG_INTERRUPT_STATUS__DCFE1_POWER_DOWN_INT_OCCURRED_MASK                                             0x00000008L
#define DCPG_INTERRUPT_STATUS__DCFE2_POWER_UP_INT_OCCURRED_MASK                                               0x00000010L
#define DCPG_INTERRUPT_STATUS__DCFE2_POWER_DOWN_INT_OCCURRED_MASK                                             0x00000020L
#define DCPG_INTERRUPT_STATUS__DCFE3_POWER_UP_INT_OCCURRED_MASK                                               0x00000040L
#define DCPG_INTERRUPT_STATUS__DCFE3_POWER_DOWN_INT_OCCURRED_MASK                                             0x00000080L
#define DCPG_INTERRUPT_STATUS__DCFE4_POWER_UP_INT_OCCURRED_MASK                                               0x00000100L
#define DCPG_INTERRUPT_STATUS__DCFE4_POWER_DOWN_INT_OCCURRED_MASK                                             0x00000200L
#define DCPG_INTERRUPT_STATUS__DCFE5_POWER_UP_INT_OCCURRED_MASK                                               0x00000400L
#define DCPG_INTERRUPT_STATUS__DCFE5_POWER_DOWN_INT_OCCURRED_MASK                                             0x00000800L
#define DCPG_INTERRUPT_STATUS__DCFEV0_POWER_UP_INT_OCCURRED_MASK                                              0x00001000L
#define DCPG_INTERRUPT_STATUS__DCFEV0_POWER_DOWN_INT_OCCURRED_MASK                                            0x00002000L
#define DCPG_INTERRUPT_STATUS__DSI_POWER_UP_INT_OCCURRED_MASK                                                 0x00004000L
#define DCPG_INTERRUPT_STATUS__DSI_POWER_DOWN_INT_OCCURRED_MASK                                               0x00008000L
#define DCPG_INTERRUPT_STATUS__DCFEV1_POWER_UP_INT_OCCURRED_MASK                                              0x00010000L
#define DCPG_INTERRUPT_STATUS__DCFEV1_POWER_DOWN_INT_OCCURRED_MASK                                            0x00020000L
//DCPG_INTERRUPT_CONTROL
#define DCPG_INTERRUPT_CONTROL__DCFE0_POWER_UP_INT_MASK__SHIFT                                                0x0
#define DCPG_INTERRUPT_CONTROL__DCFE0_POWER_UP_INT_CLEAR__SHIFT                                               0x1
#define DCPG_INTERRUPT_CONTROL__DCFE0_POWER_DOWN_INT_MASK__SHIFT                                              0x2
#define DCPG_INTERRUPT_CONTROL__DCFE0_POWER_DOWN_INT_CLEAR__SHIFT                                             0x3
#define DCPG_INTERRUPT_CONTROL__DCFE1_POWER_UP_INT_MASK__SHIFT                                                0x4
#define DCPG_INTERRUPT_CONTROL__DCFE1_POWER_UP_INT_CLEAR__SHIFT                                               0x5
#define DCPG_INTERRUPT_CONTROL__DCFE1_POWER_DOWN_INT_MASK__SHIFT                                              0x6
#define DCPG_INTERRUPT_CONTROL__DCFE1_POWER_DOWN_INT_CLEAR__SHIFT                                             0x7
#define DCPG_INTERRUPT_CONTROL__DCFE2_POWER_UP_INT_MASK__SHIFT                                                0x8
#define DCPG_INTERRUPT_CONTROL__DCFE2_POWER_UP_INT_CLEAR__SHIFT                                               0x9
#define DCPG_INTERRUPT_CONTROL__DCFE2_POWER_DOWN_INT_MASK__SHIFT                                              0xa
#define DCPG_INTERRUPT_CONTROL__DCFE2_POWER_DOWN_INT_CLEAR__SHIFT                                             0xb
#define DCPG_INTERRUPT_CONTROL__DCFE3_POWER_UP_INT_MASK__SHIFT                                                0xc
#define DCPG_INTERRUPT_CONTROL__DCFE3_POWER_UP_INT_CLEAR__SHIFT                                               0xd
#define DCPG_INTERRUPT_CONTROL__DCFE3_POWER_DOWN_INT_MASK__SHIFT                                              0xe
#define DCPG_INTERRUPT_CONTROL__DCFE3_POWER_DOWN_INT_CLEAR__SHIFT                                             0xf
#define DCPG_INTERRUPT_CONTROL__DCFE4_POWER_UP_INT_MASK__SHIFT                                                0x10
#define DCPG_INTERRUPT_CONTROL__DCFE4_POWER_UP_INT_CLEAR__SHIFT                                               0x11
#define DCPG_INTERRUPT_CONTROL__DCFE4_POWER_DOWN_INT_MASK__SHIFT                                              0x12
#define DCPG_INTERRUPT_CONTROL__DCFE4_POWER_DOWN_INT_CLEAR__SHIFT                                             0x13
#define DCPG_INTERRUPT_CONTROL__DCFE5_POWER_UP_INT_MASK__SHIFT                                                0x14
#define DCPG_INTERRUPT_CONTROL__DCFE5_POWER_UP_INT_CLEAR__SHIFT                                               0x15
#define DCPG_INTERRUPT_CONTROL__DCFE5_POWER_DOWN_INT_MASK__SHIFT                                              0x16
#define DCPG_INTERRUPT_CONTROL__DCFE5_POWER_DOWN_INT_CLEAR__SHIFT                                             0x17
#define DCPG_INTERRUPT_CONTROL__DCFEV0_POWER_UP_INT_MASK__SHIFT                                               0x18
#define DCPG_INTERRUPT_CONTROL__DCFEV0_POWER_UP_INT_CLEAR__SHIFT                                              0x19
#define DCPG_INTERRUPT_CONTROL__DCFEV0_POWER_DOWN_INT_MASK__SHIFT                                             0x1a
#define DCPG_INTERRUPT_CONTROL__DCFEV0_POWER_DOWN_INT_CLEAR__SHIFT                                            0x1b
#define DCPG_INTERRUPT_CONTROL__DSI_POWER_UP_INT_MASK__SHIFT                                                  0x1c
#define DCPG_INTERRUPT_CONTROL__DSI_POWER_UP_INT_CLEAR__SHIFT                                                 0x1d
#define DCPG_INTERRUPT_CONTROL__DSI_POWER_DOWN_INT_MASK__SHIFT                                                0x1e
#define DCPG_INTERRUPT_CONTROL__DSI_POWER_DOWN_INT_CLEAR__SHIFT                                               0x1f
#define DCPG_INTERRUPT_CONTROL__DCFE0_POWER_UP_INT_MASK_MASK                                                  0x00000001L
#define DCPG_INTERRUPT_CONTROL__DCFE0_POWER_UP_INT_CLEAR_MASK                                                 0x00000002L
#define DCPG_INTERRUPT_CONTROL__DCFE0_POWER_DOWN_INT_MASK_MASK                                                0x00000004L
#define DCPG_INTERRUPT_CONTROL__DCFE0_POWER_DOWN_INT_CLEAR_MASK                                               0x00000008L
#define DCPG_INTERRUPT_CONTROL__DCFE1_POWER_UP_INT_MASK_MASK                                                  0x00000010L
#define DCPG_INTERRUPT_CONTROL__DCFE1_POWER_UP_INT_CLEAR_MASK                                                 0x00000020L
#define DCPG_INTERRUPT_CONTROL__DCFE1_POWER_DOWN_INT_MASK_MASK                                                0x00000040L
#define DCPG_INTERRUPT_CONTROL__DCFE1_POWER_DOWN_INT_CLEAR_MASK                                               0x00000080L
#define DCPG_INTERRUPT_CONTROL__DCFE2_POWER_UP_INT_MASK_MASK                                                  0x00000100L
#define DCPG_INTERRUPT_CONTROL__DCFE2_POWER_UP_INT_CLEAR_MASK                                                 0x00000200L
#define DCPG_INTERRUPT_CONTROL__DCFE2_POWER_DOWN_INT_MASK_MASK                                                0x00000400L
#define DCPG_INTERRUPT_CONTROL__DCFE2_POWER_DOWN_INT_CLEAR_MASK                                               0x00000800L
#define DCPG_INTERRUPT_CONTROL__DCFE3_POWER_UP_INT_MASK_MASK                                                  0x00001000L
#define DCPG_INTERRUPT_CONTROL__DCFE3_POWER_UP_INT_CLEAR_MASK                                                 0x00002000L
#define DCPG_INTERRUPT_CONTROL__DCFE3_POWER_DOWN_INT_MASK_MASK                                                0x00004000L
#define DCPG_INTERRUPT_CONTROL__DCFE3_POWER_DOWN_INT_CLEAR_MASK                                               0x00008000L
#define DCPG_INTERRUPT_CONTROL__DCFE4_POWER_UP_INT_MASK_MASK                                                  0x00010000L
#define DCPG_INTERRUPT_CONTROL__DCFE4_POWER_UP_INT_CLEAR_MASK                                                 0x00020000L
#define DCPG_INTERRUPT_CONTROL__DCFE4_POWER_DOWN_INT_MASK_MASK                                                0x00040000L
#define DCPG_INTERRUPT_CONTROL__DCFE4_POWER_DOWN_INT_CLEAR_MASK                                               0x00080000L
#define DCPG_INTERRUPT_CONTROL__DCFE5_POWER_UP_INT_MASK_MASK                                                  0x00100000L
#define DCPG_INTERRUPT_CONTROL__DCFE5_POWER_UP_INT_CLEAR_MASK                                                 0x00200000L
#define DCPG_INTERRUPT_CONTROL__DCFE5_POWER_DOWN_INT_MASK_MASK                                                0x00400000L
#define DCPG_INTERRUPT_CONTROL__DCFE5_POWER_DOWN_INT_CLEAR_MASK                                               0x00800000L
#define DCPG_INTERRUPT_CONTROL__DCFEV0_POWER_UP_INT_MASK_MASK                                                 0x01000000L
#define DCPG_INTERRUPT_CONTROL__DCFEV0_POWER_UP_INT_CLEAR_MASK                                                0x02000000L
#define DCPG_INTERRUPT_CONTROL__DCFEV0_POWER_DOWN_INT_MASK_MASK                                               0x04000000L
#define DCPG_INTERRUPT_CONTROL__DCFEV0_POWER_DOWN_INT_CLEAR_MASK                                              0x08000000L
#define DCPG_INTERRUPT_CONTROL__DSI_POWER_UP_INT_MASK_MASK                                                    0x10000000L
#define DCPG_INTERRUPT_CONTROL__DSI_POWER_UP_INT_CLEAR_MASK                                                   0x20000000L
#define DCPG_INTERRUPT_CONTROL__DSI_POWER_DOWN_INT_MASK_MASK                                                  0x40000000L
#define DCPG_INTERRUPT_CONTROL__DSI_POWER_DOWN_INT_CLEAR_MASK                                                 0x80000000L
//DCPG_INTERRUPT_CONTROL2
#define DCPG_INTERRUPT_CONTROL2__DCFEV1_POWER_UP_INT_MASK__SHIFT                                              0x18
#define DCPG_INTERRUPT_CONTROL2__DCFEV1_POWER_UP_INT_CLEAR__SHIFT                                             0x19
#define DCPG_INTERRUPT_CONTROL2__DCFEV1_POWER_DOWN_INT_MASK__SHIFT                                            0x1a
#define DCPG_INTERRUPT_CONTROL2__DCFEV1_POWER_DOWN_INT_CLEAR__SHIFT                                           0x1b
#define DCPG_INTERRUPT_CONTROL2__DCFEV1_POWER_UP_INT_MASK_MASK                                                0x01000000L
#define DCPG_INTERRUPT_CONTROL2__DCFEV1_POWER_UP_INT_CLEAR_MASK                                               0x02000000L
#define DCPG_INTERRUPT_CONTROL2__DCFEV1_POWER_DOWN_INT_MASK_MASK                                              0x04000000L
#define DCPG_INTERRUPT_CONTROL2__DCFEV1_POWER_DOWN_INT_CLEAR_MASK                                             0x08000000L
//DCFEV1_PG_CONFIG
#define DCFEV1_PG_CONFIG__DCFEV1_POWER_FORCEON__SHIFT                                                         0x0
#define DCFEV1_PG_CONFIG__DCFEV1_POWER_FORCEON_MASK                                                           0x00000001L
//DCFEV1_PG_ENABLE
#define DCFEV1_PG_ENABLE__DCFEV1_POWER_GATE__SHIFT                                                            0x0
#define DCFEV1_PG_ENABLE__DCFEV1_POWER_GATE_MASK                                                              0x00000001L
//DCFEV1_PG_STATUS
#define DCFEV1_PG_STATUS__DCFEV1_DESIRED_PWR_STATE__SHIFT                                                     0x1c
#define DCFEV1_PG_STATUS__DCFEV1_PGFSM_PWR_STATUS__SHIFT                                                      0x1e
#define DCFEV1_PG_STATUS__DCFEV1_DESIRED_PWR_STATE_MASK                                                       0x10000000L
#define DCFEV1_PG_STATUS__DCFEV1_PGFSM_PWR_STATUS_MASK                                                        0xC0000000L
//DC_IP_REQUEST_CNTL
#define DC_IP_REQUEST_CNTL__IP_REQUEST_EN__SHIFT                                                              0x0
#define DC_IP_REQUEST_CNTL__IP_REQUEST_EN_MASK                                                                0x00000001L
//DC_PGCNTL_STATUS_REG
//DMIFV_STATUS
#define DMIFV_STATUS__DMIFV_MC_SEND_ON_IDLE__SHIFT                                                            0x0
#define DMIFV_STATUS__DMIFV_CLEAR_MC_SEND_ON_IDLE__SHIFT                                                      0x8
#define DMIFV_STATUS__DMIFV_MC_SEND_ON_IDLE_MASK                                                              0x0000000FL
#define DMIFV_STATUS__DMIFV_CLEAR_MC_SEND_ON_IDLE_MASK                                                        0x00000F00L
//DMIF_CONTROL
#define DMIF_CONTROL__DMIF_BUFF_SIZE__SHIFT                                                                   0x0
#define DMIF_CONTROL__DMIF_GROUP_REQUESTS_IN_CHUNK__SHIFT                                                     0x2
#define DMIF_CONTROL__DMIF_DISABLE_EARLY_RECEIVED_LEVEL_COUNT__SHIFT                                          0x4
#define DMIF_CONTROL__DMIF_REQ_BURST_SIZE__SHIFT                                                              0x8
#define DMIF_CONTROL__DMIF_UNDERFLOW_RECOVERY_EN__SHIFT                                                       0xb
#define DMIF_CONTROL__DMIF_FORCE_TOTAL_REQ_BURST_SIZE__SHIFT                                                  0xc
#define DMIF_CONTROL__DMIF_MAX_TOTAL_OUTSTANDING_CHUNK_REQUESTS__SHIFT                                        0x11
#define DMIF_CONTROL__DMIF_DELAY_ARBITRATION__SHIFT                                                           0x18
#define DMIF_CONTROL__DMIF_CHUNK_BUFF_MARGIN__SHIFT                                                           0x1d
#define DMIF_CONTROL__DMIF_PSTATE_URGENT_DISABLE__SHIFT                                                       0x1f
#define DMIF_CONTROL__DMIF_BUFF_SIZE_MASK                                                                     0x00000003L
#define DMIF_CONTROL__DMIF_GROUP_REQUESTS_IN_CHUNK_MASK                                                       0x00000004L
#define DMIF_CONTROL__DMIF_DISABLE_EARLY_RECEIVED_LEVEL_COUNT_MASK                                            0x00000010L
#define DMIF_CONTROL__DMIF_REQ_BURST_SIZE_MASK                                                                0x00000700L
#define DMIF_CONTROL__DMIF_UNDERFLOW_RECOVERY_EN_MASK                                                         0x00000800L
#define DMIF_CONTROL__DMIF_FORCE_TOTAL_REQ_BURST_SIZE_MASK                                                    0x0001F000L
#define DMIF_CONTROL__DMIF_MAX_TOTAL_OUTSTANDING_CHUNK_REQUESTS_MASK                                          0x007E0000L
#define DMIF_CONTROL__DMIF_DELAY_ARBITRATION_MASK                                                             0x1F000000L
#define DMIF_CONTROL__DMIF_CHUNK_BUFF_MARGIN_MASK                                                             0x60000000L
#define DMIF_CONTROL__DMIF_PSTATE_URGENT_DISABLE_MASK                                                         0x80000000L
//DMIF_STATUS
#define DMIF_STATUS__DMIF_MC_SEND_ON_IDLE__SHIFT                                                              0x0
#define DMIF_STATUS__DMIF_CLEAR_MC_SEND_ON_IDLE__SHIFT                                                        0x8
#define DMIF_STATUS__DMIF_MC_LATENCY_COUNTER_ENABLE__SHIFT                                                    0xf
#define DMIF_STATUS__DMIF_MC_LATENCY_COUNTER_URGENT_ONLY__SHIFT                                               0x10
#define DMIF_STATUS__DMIF_PIPE_EN_FBC_CHUNK_TRACKER__SHIFT                                                    0x11
#define DMIF_STATUS__DMIF_MC_LATENCY_COUNTER_SOURCE_SELECT__SHIFT                                             0x14
#define DMIF_STATUS__DMIF_PERFORMANCE_COUNTER_SOURCE_SELECT__SHIFT                                            0x18
#define DMIF_STATUS__DMIF_UNDERFLOW__SHIFT                                                                    0x1c
#define DMIF_STATUS__DMIF_MC_LATENCY_TAP_POINT__SHIFT                                                         0x1d
#define DMIF_STATUS__DMIF_MC_LATENCY_REQ_TYPE__SHIFT                                                          0x1f
#define DMIF_STATUS__DMIF_MC_SEND_ON_IDLE_MASK                                                                0x0000003FL
#define DMIF_STATUS__DMIF_CLEAR_MC_SEND_ON_IDLE_MASK                                                          0x00003F00L
#define DMIF_STATUS__DMIF_MC_LATENCY_COUNTER_ENABLE_MASK                                                      0x00008000L
#define DMIF_STATUS__DMIF_MC_LATENCY_COUNTER_URGENT_ONLY_MASK                                                 0x00010000L
#define DMIF_STATUS__DMIF_PIPE_EN_FBC_CHUNK_TRACKER_MASK                                                      0x000E0000L
#define DMIF_STATUS__DMIF_MC_LATENCY_COUNTER_SOURCE_SELECT_MASK                                               0x00F00000L
#define DMIF_STATUS__DMIF_PERFORMANCE_COUNTER_SOURCE_SELECT_MASK                                              0x0F000000L
#define DMIF_STATUS__DMIF_UNDERFLOW_MASK                                                                      0x10000000L
#define DMIF_STATUS__DMIF_MC_LATENCY_TAP_POINT_MASK                                                           0x60000000L
#define DMIF_STATUS__DMIF_MC_LATENCY_REQ_TYPE_MASK                                                            0x80000000L
//DMIF_ARBITRATION_CONTROL
#define DMIF_ARBITRATION_CONTROL__DMIF_ARBITRATION_REFERENCE_CLOCK_PERIOD__SHIFT                              0x0
#define DMIF_ARBITRATION_CONTROL__PIPE_SWITCH_EFFICIENCY_WEIGHT__SHIFT                                        0x10
#define DMIF_ARBITRATION_CONTROL__DMIF_ARBITRATION_REFERENCE_CLOCK_PERIOD_MASK                                0x0000FFFFL
#define DMIF_ARBITRATION_CONTROL__PIPE_SWITCH_EFFICIENCY_WEIGHT_MASK                                          0xFFFF0000L
//PIPE0_ARBITRATION_CONTROL3
#define PIPE0_ARBITRATION_CONTROL3__EFFICIENCY_WEIGHT__SHIFT                                                  0x0
#define PIPE0_ARBITRATION_CONTROL3__EFFICIENCY_WEIGHT_MASK                                                    0x0000FFFFL
//PIPE1_ARBITRATION_CONTROL3
#define PIPE1_ARBITRATION_CONTROL3__EFFICIENCY_WEIGHT__SHIFT                                                  0x0
#define PIPE1_ARBITRATION_CONTROL3__EFFICIENCY_WEIGHT_MASK                                                    0x0000FFFFL
//PIPE2_ARBITRATION_CONTROL3
#define PIPE2_ARBITRATION_CONTROL3__EFFICIENCY_WEIGHT__SHIFT                                                  0x0
#define PIPE2_ARBITRATION_CONTROL3__EFFICIENCY_WEIGHT_MASK                                                    0x0000FFFFL
//PIPE3_ARBITRATION_CONTROL3
#define PIPE3_ARBITRATION_CONTROL3__EFFICIENCY_WEIGHT__SHIFT                                                  0x0
#define PIPE3_ARBITRATION_CONTROL3__EFFICIENCY_WEIGHT_MASK                                                    0x0000FFFFL
//PIPE4_ARBITRATION_CONTROL3
#define PIPE4_ARBITRATION_CONTROL3__EFFICIENCY_WEIGHT__SHIFT                                                  0x0
#define PIPE4_ARBITRATION_CONTROL3__EFFICIENCY_WEIGHT_MASK                                                    0x0000FFFFL
//PIPE5_ARBITRATION_CONTROL3
#define PIPE5_ARBITRATION_CONTROL3__EFFICIENCY_WEIGHT__SHIFT                                                  0x0
#define PIPE5_ARBITRATION_CONTROL3__EFFICIENCY_WEIGHT_MASK                                                    0x0000FFFFL
//DMIF_P_VMID
#define DMIF_P_VMID__P_VMID_PIPE0__SHIFT                                                                      0x0
#define DMIF_P_VMID__P_VMID_PIPE1__SHIFT                                                                      0x4
#define DMIF_P_VMID__P_VMID_PIPE2__SHIFT                                                                      0x8
#define DMIF_P_VMID__P_VMID_PIPE3__SHIFT                                                                      0xc
#define DMIF_P_VMID__P_VMID_PIPE4__SHIFT                                                                      0x10
#define DMIF_P_VMID__P_VMID_PIPE5__SHIFT                                                                      0x14
#define DMIF_P_VMID__P_VMID_PIPE6__SHIFT                                                                      0x18
#define DMIF_P_VMID__P_VMID_PIPE7__SHIFT                                                                      0x1c
#define DMIF_P_VMID__P_VMID_PIPE0_MASK                                                                        0x0000000FL
#define DMIF_P_VMID__P_VMID_PIPE1_MASK                                                                        0x000000F0L
#define DMIF_P_VMID__P_VMID_PIPE2_MASK                                                                        0x00000F00L
#define DMIF_P_VMID__P_VMID_PIPE3_MASK                                                                        0x0000F000L
#define DMIF_P_VMID__P_VMID_PIPE4_MASK                                                                        0x000F0000L
#define DMIF_P_VMID__P_VMID_PIPE5_MASK                                                                        0x00F00000L
#define DMIF_P_VMID__P_VMID_PIPE6_MASK                                                                        0x0F000000L
#define DMIF_P_VMID__P_VMID_PIPE7_MASK                                                                        0xF0000000L
//DMIF_ADDR_CALC
#define DMIF_ADDR_CALC__ADDR_CONFIG_PIPE_INTERLEAVE_SIZE__SHIFT                                               0x3
#define DMIF_ADDR_CALC__ADDR_CONFIG_ROW_SIZE__SHIFT                                                           0x1c
#define DMIF_ADDR_CALC__ADDR_CONFIG_PIPE_INTERLEAVE_SIZE_MASK                                                 0x00000038L
#define DMIF_ADDR_CALC__ADDR_CONFIG_ROW_SIZE_MASK                                                             0x30000000L
//DMIF_STATUS2
#define DMIF_STATUS2__DMIF_PIPE0_DISPCLK_STATUS__SHIFT                                                        0x0
#define DMIF_STATUS2__DMIF_PIPE1_DISPCLK_STATUS__SHIFT                                                        0x1
#define DMIF_STATUS2__DMIF_PIPE2_DISPCLK_STATUS__SHIFT                                                        0x2
#define DMIF_STATUS2__DMIF_PIPE3_DISPCLK_STATUS__SHIFT                                                        0x3
#define DMIF_STATUS2__DMIF_PIPE4_DISPCLK_STATUS__SHIFT                                                        0x4
#define DMIF_STATUS2__DMIF_PIPE5_DISPCLK_STATUS__SHIFT                                                        0x5
#define DMIF_STATUS2__DMIF_CHUNK_TRACKER_SCLK_STATUS__SHIFT                                                   0x8
#define DMIF_STATUS2__DMIF_FBC_TRACKER_SCLK_STATUS__SHIFT                                                     0x9
#define DMIF_STATUS2__DMIF_PIPE0_DISPCLK_STATUS_MASK                                                          0x00000001L
#define DMIF_STATUS2__DMIF_PIPE1_DISPCLK_STATUS_MASK                                                          0x00000002L
#define DMIF_STATUS2__DMIF_PIPE2_DISPCLK_STATUS_MASK                                                          0x00000004L
#define DMIF_STATUS2__DMIF_PIPE3_DISPCLK_STATUS_MASK                                                          0x00000008L
#define DMIF_STATUS2__DMIF_PIPE4_DISPCLK_STATUS_MASK                                                          0x00000010L
#define DMIF_STATUS2__DMIF_PIPE5_DISPCLK_STATUS_MASK                                                          0x00000020L
#define DMIF_STATUS2__DMIF_CHUNK_TRACKER_SCLK_STATUS_MASK                                                     0x00000100L
#define DMIF_STATUS2__DMIF_FBC_TRACKER_SCLK_STATUS_MASK                                                       0x00000200L
//PIPE0_MAX_REQUESTS
#define PIPE0_MAX_REQUESTS__MAX_REQUESTS__SHIFT                                                               0x0
#define PIPE0_MAX_REQUESTS__MAX_REQUESTS_MASK                                                                 0x000003FFL
//PIPE1_MAX_REQUESTS
#define PIPE1_MAX_REQUESTS__MAX_REQUESTS__SHIFT                                                               0x0
#define PIPE1_MAX_REQUESTS__MAX_REQUESTS_MASK                                                                 0x000003FFL
//PIPE2_MAX_REQUESTS
#define PIPE2_MAX_REQUESTS__MAX_REQUESTS__SHIFT                                                               0x0
#define PIPE2_MAX_REQUESTS__MAX_REQUESTS_MASK                                                                 0x000003FFL
//PIPE3_MAX_REQUESTS
#define PIPE3_MAX_REQUESTS__MAX_REQUESTS__SHIFT                                                               0x0
#define PIPE3_MAX_REQUESTS__MAX_REQUESTS_MASK                                                                 0x000003FFL
//PIPE4_MAX_REQUESTS
#define PIPE4_MAX_REQUESTS__MAX_REQUESTS__SHIFT                                                               0x0
#define PIPE4_MAX_REQUESTS__MAX_REQUESTS_MASK                                                                 0x000003FFL
//PIPE5_MAX_REQUESTS
#define PIPE5_MAX_REQUESTS__MAX_REQUESTS__SHIFT                                                               0x0
#define PIPE5_MAX_REQUESTS__MAX_REQUESTS_MASK                                                                 0x000003FFL
//LOW_POWER_TILING_CONTROL
#define LOW_POWER_TILING_CONTROL__LOW_POWER_TILING_ENABLE__SHIFT                                              0x0
#define LOW_POWER_TILING_CONTROL__LOW_POWER_TILING_MODE__SHIFT                                                0x3
#define LOW_POWER_TILING_CONTROL__LOW_POWER_TILING_NUM_PIPES__SHIFT                                           0x5
#define LOW_POWER_TILING_CONTROL__LOW_POWER_TILING_NUM_BANKS__SHIFT                                           0x8
#define LOW_POWER_TILING_CONTROL__LOW_POWER_TILING_PIPE_INTERLEAVE_SIZE__SHIFT                                0xb
#define LOW_POWER_TILING_CONTROL__LOW_POWER_TILING_ROW_SIZE__SHIFT                                            0xc
#define LOW_POWER_TILING_CONTROL__LOW_POWER_TILING_ROWS_PER_CHAN__SHIFT                                       0x10
#define LOW_POWER_TILING_CONTROL__LOW_POWER_TILING_ENABLE_MASK                                                0x00000001L
#define LOW_POWER_TILING_CONTROL__LOW_POWER_TILING_MODE_MASK                                                  0x00000018L
#define LOW_POWER_TILING_CONTROL__LOW_POWER_TILING_NUM_PIPES_MASK                                             0x000000E0L
#define LOW_POWER_TILING_CONTROL__LOW_POWER_TILING_NUM_BANKS_MASK                                             0x00000700L
#define LOW_POWER_TILING_CONTROL__LOW_POWER_TILING_PIPE_INTERLEAVE_SIZE_MASK                                  0x00000800L
#define LOW_POWER_TILING_CONTROL__LOW_POWER_TILING_ROW_SIZE_MASK                                              0x00007000L
#define LOW_POWER_TILING_CONTROL__LOW_POWER_TILING_ROWS_PER_CHAN_MASK                                         0x0FFF0000L
//MCIF_CONTROL
#define MCIF_CONTROL__MCIF_MC_LATENCY_COUNTER_ENABLE__SHIFT                                                   0x1e
#define MCIF_CONTROL__MCIF_MC_LATENCY_COUNTER_URGENT_ONLY__SHIFT                                              0x1f
#define MCIF_CONTROL__MCIF_MC_LATENCY_COUNTER_ENABLE_MASK                                                     0x40000000L
#define MCIF_CONTROL__MCIF_MC_LATENCY_COUNTER_URGENT_ONLY_MASK                                                0x80000000L
//MCIF_WRITE_COMBINE_CONTROL
#define MCIF_WRITE_COMBINE_CONTROL__MCIF_WRITE_COMBINE_TIMEOUT__SHIFT                                         0x0
#define MCIF_WRITE_COMBINE_CONTROL__MCIF_WRITE_COMBINE_TIMEOUT_MASK                                           0x000003FFL
//MCIF_PHASE0_OUTSTANDING_COUNTER
#define MCIF_PHASE0_OUTSTANDING_COUNTER__MCIF_PHASE0_OUTSTANDING_COUNTER__SHIFT                               0x0
#define MCIF_PHASE0_OUTSTANDING_COUNTER__MCIF_PHASE0_OUTSTANDING_COUNTER_MASK                                 0x07FFFFFFL
//CC_DC_PIPE_DIS
#define CC_DC_PIPE_DIS__DC_PIPE_DIS__SHIFT                                                                    0x1
#define CC_DC_PIPE_DIS__DC_UNDERLAY_PIPE_DIS__SHIFT                                                           0x10
#define CC_DC_PIPE_DIS__DC_PIPE_DIS_MASK                                                                      0x0000007EL
#define CC_DC_PIPE_DIS__DC_UNDERLAY_PIPE_DIS_MASK                                                             0x003F0000L
//SMU_WM_CONTROL
#define SMU_WM_CONTROL__DMIF_WM_CHG_SEL__SHIFT                                                                0x0
#define SMU_WM_CONTROL__DMIF_WM_CHG_REQ__SHIFT                                                                0x2
#define SMU_WM_CONTROL__DMIF_WM_CHG_ACK_INT_DIS__SHIFT                                                        0x10
#define SMU_WM_CONTROL__DMIF_WM_CHG_ACK_INT_STATUS__SHIFT                                                     0x11
#define SMU_WM_CONTROL__MCIF_WB_WM_CHG_SEL__SHIFT                                                             0x14
#define SMU_WM_CONTROL__MCIF_WB_WM_CHG_REQ__SHIFT                                                             0x16
#define SMU_WM_CONTROL__MCIF_WB_WM_CHG_ACK_INT_DIS__SHIFT                                                     0x18
#define SMU_WM_CONTROL__MCIF_WB_WM_CHG_ACK_INT_STATUS__SHIFT                                                  0x19
#define SMU_WM_CONTROL__DMIF_WM_CHG_SEL_MASK                                                                  0x00000003L
#define SMU_WM_CONTROL__DMIF_WM_CHG_REQ_MASK                                                                  0x00000004L
#define SMU_WM_CONTROL__DMIF_WM_CHG_ACK_INT_DIS_MASK                                                          0x00010000L
#define SMU_WM_CONTROL__DMIF_WM_CHG_ACK_INT_STATUS_MASK                                                       0x00020000L
#define SMU_WM_CONTROL__MCIF_WB_WM_CHG_SEL_MASK                                                               0x00300000L
#define SMU_WM_CONTROL__MCIF_WB_WM_CHG_REQ_MASK                                                               0x00400000L
#define SMU_WM_CONTROL__MCIF_WB_WM_CHG_ACK_INT_DIS_MASK                                                       0x01000000L
#define SMU_WM_CONTROL__MCIF_WB_WM_CHG_ACK_INT_STATUS_MASK                                                    0x02000000L
//RBBMIF_TIMEOUT
#define RBBMIF_TIMEOUT__RBBMIF_TIMEOUT_DELAY__SHIFT                                                           0x0
#define RBBMIF_TIMEOUT__RBBMIF_TIMEOUT_TO_REQ_HOLD__SHIFT                                                     0x14
#define RBBMIF_TIMEOUT__RBBMIF_TIMEOUT_DELAY_MASK                                                             0x000FFFFFL
#define RBBMIF_TIMEOUT__RBBMIF_TIMEOUT_TO_REQ_HOLD_MASK                                                       0xFFF00000L
//RBBMIF_STATUS
#define RBBMIF_STATUS__RBBMIF_TIMEOUT_CLIENTS_DEC__SHIFT                                                      0x0
#define RBBMIF_STATUS__RBBMIF_TIMEOUT_OP__SHIFT                                                               0x1c
#define RBBMIF_STATUS__RBBMIF_TIMEOUT_RDWR_STATUS__SHIFT                                                      0x1d
#define RBBMIF_STATUS__RBBMIF_TIMEOUT_ACK__SHIFT                                                              0x1e
#define RBBMIF_STATUS__RBBMIF_TIMEOUT_MASK__SHIFT                                                             0x1f
#define RBBMIF_STATUS__RBBMIF_TIMEOUT_CLIENTS_DEC_MASK                                                        0x0000FFFFL
#define RBBMIF_STATUS__RBBMIF_TIMEOUT_OP_MASK                                                                 0x10000000L
#define RBBMIF_STATUS__RBBMIF_TIMEOUT_RDWR_STATUS_MASK                                                        0x20000000L
#define RBBMIF_STATUS__RBBMIF_TIMEOUT_ACK_MASK                                                                0x40000000L
#define RBBMIF_STATUS__RBBMIF_TIMEOUT_MASK_MASK                                                               0x80000000L
//RBBMIF_TIMEOUT_DIS
#define RBBMIF_TIMEOUT_DIS__CLIENT0_TIMEOUT_DIS__SHIFT                                                        0x0
#define RBBMIF_TIMEOUT_DIS__CLIENT1_TIMEOUT_DIS__SHIFT                                                        0x1
#define RBBMIF_TIMEOUT_DIS__CLIENT2_TIMEOUT_DIS__SHIFT                                                        0x2
#define RBBMIF_TIMEOUT_DIS__CLIENT3_TIMEOUT_DIS__SHIFT                                                        0x3
#define RBBMIF_TIMEOUT_DIS__CLIENT4_TIMEOUT_DIS__SHIFT                                                        0x4
#define RBBMIF_TIMEOUT_DIS__CLIENT5_TIMEOUT_DIS__SHIFT                                                        0x5
#define RBBMIF_TIMEOUT_DIS__CLIENT6_TIMEOUT_DIS__SHIFT                                                        0x6
#define RBBMIF_TIMEOUT_DIS__CLIENT7_TIMEOUT_DIS__SHIFT                                                        0x7
#define RBBMIF_TIMEOUT_DIS__CLIENT8_TIMEOUT_DIS__SHIFT                                                        0x8
#define RBBMIF_TIMEOUT_DIS__CLIENT9_TIMEOUT_DIS__SHIFT                                                        0x9
#define RBBMIF_TIMEOUT_DIS__CLIENT10_TIMEOUT_DIS__SHIFT                                                       0xa
#define RBBMIF_TIMEOUT_DIS__CLIENT11_TIMEOUT_DIS__SHIFT                                                       0xb
#define RBBMIF_TIMEOUT_DIS__CLIENT12_TIMEOUT_DIS__SHIFT                                                       0xc
#define RBBMIF_TIMEOUT_DIS__CLIENT13_TIMEOUT_DIS__SHIFT                                                       0xd
#define RBBMIF_TIMEOUT_DIS__CLIENT14_TIMEOUT_DIS__SHIFT                                                       0xe
#define RBBMIF_TIMEOUT_DIS__CLIENT15_TIMEOUT_DIS__SHIFT                                                       0xf
#define RBBMIF_TIMEOUT_DIS__CLIENT0_TIMEOUT_DIS_MASK                                                          0x00000001L
#define RBBMIF_TIMEOUT_DIS__CLIENT1_TIMEOUT_DIS_MASK                                                          0x00000002L
#define RBBMIF_TIMEOUT_DIS__CLIENT2_TIMEOUT_DIS_MASK                                                          0x00000004L
#define RBBMIF_TIMEOUT_DIS__CLIENT3_TIMEOUT_DIS_MASK                                                          0x00000008L
#define RBBMIF_TIMEOUT_DIS__CLIENT4_TIMEOUT_DIS_MASK                                                          0x00000010L
#define RBBMIF_TIMEOUT_DIS__CLIENT5_TIMEOUT_DIS_MASK                                                          0x00000020L
#define RBBMIF_TIMEOUT_DIS__CLIENT6_TIMEOUT_DIS_MASK                                                          0x00000040L
#define RBBMIF_TIMEOUT_DIS__CLIENT7_TIMEOUT_DIS_MASK                                                          0x00000080L
#define RBBMIF_TIMEOUT_DIS__CLIENT8_TIMEOUT_DIS_MASK                                                          0x00000100L
#define RBBMIF_TIMEOUT_DIS__CLIENT9_TIMEOUT_DIS_MASK                                                          0x00000200L
#define RBBMIF_TIMEOUT_DIS__CLIENT10_TIMEOUT_DIS_MASK                                                         0x00000400L
#define RBBMIF_TIMEOUT_DIS__CLIENT11_TIMEOUT_DIS_MASK                                                         0x00000800L
#define RBBMIF_TIMEOUT_DIS__CLIENT12_TIMEOUT_DIS_MASK                                                         0x00001000L
#define RBBMIF_TIMEOUT_DIS__CLIENT13_TIMEOUT_DIS_MASK                                                         0x00002000L
#define RBBMIF_TIMEOUT_DIS__CLIENT14_TIMEOUT_DIS_MASK                                                         0x00004000L
#define RBBMIF_TIMEOUT_DIS__CLIENT15_TIMEOUT_DIS_MASK                                                         0x00008000L
//DCI_MEM_PWR_STATUS
#define DCI_MEM_PWR_STATUS__DMIF_RDREQ_MEM1_PWR_STATE__SHIFT                                                  0x0
#define DCI_MEM_PWR_STATUS__VGA_MEM_PWR_STATE__SHIFT                                                          0x8
#define DCI_MEM_PWR_STATUS__DMCU_ERAM_MEM_PWR_STATE__SHIFT                                                    0x9
#define DCI_MEM_PWR_STATUS__DMCU_IRAM_MEM_PWR_STATE__SHIFT                                                    0xb
#define DCI_MEM_PWR_STATUS__FBC_MEM_PWR_STATE__SHIFT                                                          0xc
#define DCI_MEM_PWR_STATUS__DMIF_CURSOR_MEM_PWR_STATE__SHIFT                                                  0x10
#define DCI_MEM_PWR_STATUS__DMIF_CURSOR_RD_REQ_MEM_PWR_STATE__SHIFT                                           0x12
#define DCI_MEM_PWR_STATUS__VIP_MEM_PWR_STATE__SHIFT                                                          0x16
#define DCI_MEM_PWR_STATUS__DMIF0_ASYNC_MEM_PWR_STATE__SHIFT                                                  0x18
#define DCI_MEM_PWR_STATUS__DMIF0_DATA_MEM_PWR_STATE__SHIFT                                                   0x1a
#define DCI_MEM_PWR_STATUS__DMIF0_CHUNK_MEM_PWR_STATE__SHIFT                                                  0x1c
#define DCI_MEM_PWR_STATUS__DMIF_RDREQ_MEM1_PWR_STATE_MASK                                                    0x00000003L
#define DCI_MEM_PWR_STATUS__VGA_MEM_PWR_STATE_MASK                                                            0x00000100L
#define DCI_MEM_PWR_STATUS__DMCU_ERAM_MEM_PWR_STATE_MASK                                                      0x00000600L
#define DCI_MEM_PWR_STATUS__DMCU_IRAM_MEM_PWR_STATE_MASK                                                      0x00000800L
#define DCI_MEM_PWR_STATUS__FBC_MEM_PWR_STATE_MASK                                                            0x00003000L
#define DCI_MEM_PWR_STATUS__DMIF_CURSOR_MEM_PWR_STATE_MASK                                                    0x00030000L
#define DCI_MEM_PWR_STATUS__DMIF_CURSOR_RD_REQ_MEM_PWR_STATE_MASK                                             0x000C0000L
#define DCI_MEM_PWR_STATUS__VIP_MEM_PWR_STATE_MASK                                                            0x00400000L
#define DCI_MEM_PWR_STATUS__DMIF0_ASYNC_MEM_PWR_STATE_MASK                                                    0x03000000L
#define DCI_MEM_PWR_STATUS__DMIF0_DATA_MEM_PWR_STATE_MASK                                                     0x0C000000L
#define DCI_MEM_PWR_STATUS__DMIF0_CHUNK_MEM_PWR_STATE_MASK                                                    0x10000000L
//DCI_MEM_PWR_STATUS2
#define DCI_MEM_PWR_STATUS2__DMIF1_ASYNC_MEM_PWR_STATE__SHIFT                                                 0x0
#define DCI_MEM_PWR_STATUS2__DMIF1_DATA_MEM_PWR_STATE__SHIFT                                                  0x2
#define DCI_MEM_PWR_STATUS2__DMIF1_CHUNK_MEM_PWR_STATE__SHIFT                                                 0x4
#define DCI_MEM_PWR_STATUS2__DMIF2_ASYNC_MEM_PWR_STATE__SHIFT                                                 0x5
#define DCI_MEM_PWR_STATUS2__DMIF2_DATA_MEM_PWR_STATE__SHIFT                                                  0x7
#define DCI_MEM_PWR_STATUS2__DMIF2_CHUNK_MEM_PWR_STATE__SHIFT                                                 0x9
#define DCI_MEM_PWR_STATUS2__DMIF3_ASYNC_MEM_PWR_STATE__SHIFT                                                 0xa
#define DCI_MEM_PWR_STATUS2__DMIF3_DATA_MEM_PWR_STATE__SHIFT                                                  0xc
#define DCI_MEM_PWR_STATUS2__DMIF3_CHUNK_MEM_PWR_STATE__SHIFT                                                 0xe
#define DCI_MEM_PWR_STATUS2__DMIF4_ASYNC_MEM_PWR_STATE__SHIFT                                                 0xf
#define DCI_MEM_PWR_STATUS2__DMIF4_DATA_MEM_PWR_STATE__SHIFT                                                  0x11
#define DCI_MEM_PWR_STATUS2__DMIF4_CHUNK_MEM_PWR_STATE__SHIFT                                                 0x13
#define DCI_MEM_PWR_STATUS2__DMIF5_ASYNC_MEM_PWR_STATE__SHIFT                                                 0x14
#define DCI_MEM_PWR_STATUS2__DMIF5_DATA_MEM_PWR_STATE__SHIFT                                                  0x16
#define DCI_MEM_PWR_STATUS2__DMIF5_CHUNK_MEM_PWR_STATE__SHIFT                                                 0x18
#define DCI_MEM_PWR_STATUS2__DMIF1_ASYNC_MEM_PWR_STATE_MASK                                                   0x00000003L
#define DCI_MEM_PWR_STATUS2__DMIF1_DATA_MEM_PWR_STATE_MASK                                                    0x0000000CL
#define DCI_MEM_PWR_STATUS2__DMIF1_CHUNK_MEM_PWR_STATE_MASK                                                   0x00000010L
#define DCI_MEM_PWR_STATUS2__DMIF2_ASYNC_MEM_PWR_STATE_MASK                                                   0x00000060L
#define DCI_MEM_PWR_STATUS2__DMIF2_DATA_MEM_PWR_STATE_MASK                                                    0x00000180L
#define DCI_MEM_PWR_STATUS2__DMIF2_CHUNK_MEM_PWR_STATE_MASK                                                   0x00000200L
#define DCI_MEM_PWR_STATUS2__DMIF3_ASYNC_MEM_PWR_STATE_MASK                                                   0x00000C00L
#define DCI_MEM_PWR_STATUS2__DMIF3_DATA_MEM_PWR_STATE_MASK                                                    0x00003000L
#define DCI_MEM_PWR_STATUS2__DMIF3_CHUNK_MEM_PWR_STATE_MASK                                                   0x00004000L
#define DCI_MEM_PWR_STATUS2__DMIF4_ASYNC_MEM_PWR_STATE_MASK                                                   0x00018000L
#define DCI_MEM_PWR_STATUS2__DMIF4_DATA_MEM_PWR_STATE_MASK                                                    0x00060000L
#define DCI_MEM_PWR_STATUS2__DMIF4_CHUNK_MEM_PWR_STATE_MASK                                                   0x00080000L
#define DCI_MEM_PWR_STATUS2__DMIF5_ASYNC_MEM_PWR_STATE_MASK                                                   0x00300000L
#define DCI_MEM_PWR_STATUS2__DMIF5_DATA_MEM_PWR_STATE_MASK                                                    0x00C00000L
#define DCI_MEM_PWR_STATUS2__DMIF5_CHUNK_MEM_PWR_STATE_MASK                                                   0x01000000L
//DCI_CLK_CNTL
#define DCI_CLK_CNTL__DCI_TEST_CLK_SEL__SHIFT                                                                 0x0
#define DCI_CLK_CNTL__DISPCLK_R_DCI_GATE_DIS__SHIFT                                                           0x5
#define DCI_CLK_CNTL__DISPCLK_M_GATE_DIS__SHIFT                                                               0x6
#define DCI_CLK_CNTL__SCLK_G_STREAM_AZ_GATE_DIS__SHIFT                                                        0x7
#define DCI_CLK_CNTL__SCLK_R_AZ_GATE_DIS__SHIFT                                                               0x8
#define DCI_CLK_CNTL__DISPCLK_G_FBC_GATE_DIS__SHIFT                                                           0x9
#define DCI_CLK_CNTL__DISPCLK_G_DMIFV1_L_GATE_DIS__SHIFT                                                      0xa
#define DCI_CLK_CNTL__DISPCLK_G_VGA_GATE_DIS__SHIFT                                                           0xb
#define DCI_CLK_CNTL__DISPCLK_G_DMIFV1_C_GATE_DIS__SHIFT                                                      0xc
#define DCI_CLK_CNTL__DISPCLK_G_VIP_GATE_DIS__SHIFT                                                           0xd
#define DCI_CLK_CNTL__VPCLK_POL__SHIFT                                                                        0xe
#define DCI_CLK_CNTL__DISPCLK_G_DMCU_GATE_DIS__SHIFT                                                          0xf
#define DCI_CLK_CNTL__DISPCLK_G_DMIF0_GATE_DIS__SHIFT                                                         0x10
#define DCI_CLK_CNTL__DISPCLK_G_DMIF1_GATE_DIS__SHIFT                                                         0x11
#define DCI_CLK_CNTL__DISPCLK_G_DMIF2_GATE_DIS__SHIFT                                                         0x12
#define DCI_CLK_CNTL__DISPCLK_G_DMIF3_GATE_DIS__SHIFT                                                         0x13
#define DCI_CLK_CNTL__DISPCLK_G_DMIF4_GATE_DIS__SHIFT                                                         0x14
#define DCI_CLK_CNTL__DISPCLK_G_DMIF5_GATE_DIS__SHIFT                                                         0x15
#define DCI_CLK_CNTL__DCEFCLK_G_DMIF_FBCTRK_GATE_DIS__SHIFT                                                   0x16
#define DCI_CLK_CNTL__DCEFCLK_G_DMIFTRK_GATE_DIS__SHIFT                                                       0x17
#define DCI_CLK_CNTL__SCLK_G_CNTL_AZ_GATE_DIS__SHIFT                                                          0x18
#define DCI_CLK_CNTL__DISPCLK_G_DMIFV0_L_GATE_DIS__SHIFT                                                      0x19
#define DCI_CLK_CNTL__DISPCLK_G_DMIFV0_C_GATE_DIS__SHIFT                                                      0x1a
#define DCI_CLK_CNTL__DCI_PG_TEST_CLK_SEL__SHIFT                                                              0x1b
#define DCI_CLK_CNTL__DCI_TEST_CLK_SEL_MASK                                                                   0x0000001FL
#define DCI_CLK_CNTL__DISPCLK_R_DCI_GATE_DIS_MASK                                                             0x00000020L
#define DCI_CLK_CNTL__DISPCLK_M_GATE_DIS_MASK                                                                 0x00000040L
#define DCI_CLK_CNTL__SCLK_G_STREAM_AZ_GATE_DIS_MASK                                                          0x00000080L
#define DCI_CLK_CNTL__SCLK_R_AZ_GATE_DIS_MASK                                                                 0x00000100L
#define DCI_CLK_CNTL__DISPCLK_G_FBC_GATE_DIS_MASK                                                             0x00000200L
#define DCI_CLK_CNTL__DISPCLK_G_DMIFV1_L_GATE_DIS_MASK                                                        0x00000400L
#define DCI_CLK_CNTL__DISPCLK_G_VGA_GATE_DIS_MASK                                                             0x00000800L
#define DCI_CLK_CNTL__DISPCLK_G_DMIFV1_C_GATE_DIS_MASK                                                        0x00001000L
#define DCI_CLK_CNTL__DISPCLK_G_VIP_GATE_DIS_MASK                                                             0x00002000L
#define DCI_CLK_CNTL__VPCLK_POL_MASK                                                                          0x00004000L
#define DCI_CLK_CNTL__DISPCLK_G_DMCU_GATE_DIS_MASK                                                            0x00008000L
#define DCI_CLK_CNTL__DISPCLK_G_DMIF0_GATE_DIS_MASK                                                           0x00010000L
#define DCI_CLK_CNTL__DISPCLK_G_DMIF1_GATE_DIS_MASK                                                           0x00020000L
#define DCI_CLK_CNTL__DISPCLK_G_DMIF2_GATE_DIS_MASK                                                           0x00040000L
#define DCI_CLK_CNTL__DISPCLK_G_DMIF3_GATE_DIS_MASK                                                           0x00080000L
#define DCI_CLK_CNTL__DISPCLK_G_DMIF4_GATE_DIS_MASK                                                           0x00100000L
#define DCI_CLK_CNTL__DISPCLK_G_DMIF5_GATE_DIS_MASK                                                           0x00200000L
#define DCI_CLK_CNTL__DCEFCLK_G_DMIF_FBCTRK_GATE_DIS_MASK                                                     0x00400000L
#define DCI_CLK_CNTL__DCEFCLK_G_DMIFTRK_GATE_DIS_MASK                                                         0x00800000L
#define DCI_CLK_CNTL__SCLK_G_CNTL_AZ_GATE_DIS_MASK                                                            0x01000000L
#define DCI_CLK_CNTL__DISPCLK_G_DMIFV0_L_GATE_DIS_MASK                                                        0x02000000L
#define DCI_CLK_CNTL__DISPCLK_G_DMIFV0_C_GATE_DIS_MASK                                                        0x04000000L
#define DCI_CLK_CNTL__DCI_PG_TEST_CLK_SEL_MASK                                                                0xF8000000L
//DCI_CLK_CNTL2
#define DCI_CLK_CNTL2__DISPCLK_G_MCIF_DWB_GATE_DIS__SHIFT                                                     0x0
#define DCI_CLK_CNTL2__SCLK_G_MCIF_DWB_GATE_DIS__SHIFT                                                        0x1
#define DCI_CLK_CNTL2__DISPCLK_G_MCIF_CWB0_GATE_DIS__SHIFT                                                    0x2
#define DCI_CLK_CNTL2__SCLK_G_MCIF_CWB0_GATE_DIS__SHIFT                                                       0x3
#define DCI_CLK_CNTL2__DISPCLK_G_MCIF_CWB1_GATE_DIS__SHIFT                                                    0x4
#define DCI_CLK_CNTL2__DCEFCLK_GATE_DIS__SHIFT                                                                0x5
#define DCI_CLK_CNTL2__DCEFCLK_TURN_ON_DELAY__SHIFT                                                           0x8
#define DCI_CLK_CNTL2__DCEFCLK_TURN_OFF_DELAY__SHIFT                                                          0xc
#define DCI_CLK_CNTL2__CGTT_DCEFCLK_OVERRIDE__SHIFT                                                           0x14
#define DCI_CLK_CNTL2__SCLK_G_MCIF_CWB1_GATE_DIS__SHIFT                                                       0x1f
#define DCI_CLK_CNTL2__DISPCLK_G_MCIF_DWB_GATE_DIS_MASK                                                       0x00000001L
#define DCI_CLK_CNTL2__SCLK_G_MCIF_DWB_GATE_DIS_MASK                                                          0x00000002L
#define DCI_CLK_CNTL2__DISPCLK_G_MCIF_CWB0_GATE_DIS_MASK                                                      0x00000004L
#define DCI_CLK_CNTL2__SCLK_G_MCIF_CWB0_GATE_DIS_MASK                                                         0x00000008L
#define DCI_CLK_CNTL2__DISPCLK_G_MCIF_CWB1_GATE_DIS_MASK                                                      0x00000010L
#define DCI_CLK_CNTL2__DCEFCLK_GATE_DIS_MASK                                                                  0x00000020L
#define DCI_CLK_CNTL2__DCEFCLK_TURN_ON_DELAY_MASK                                                             0x00000F00L
#define DCI_CLK_CNTL2__DCEFCLK_TURN_OFF_DELAY_MASK                                                            0x000FF000L
#define DCI_CLK_CNTL2__CGTT_DCEFCLK_OVERRIDE_MASK                                                             0x00100000L
#define DCI_CLK_CNTL2__SCLK_G_MCIF_CWB1_GATE_DIS_MASK                                                         0x80000000L
//DCI_MEM_PWR_CNTL
#define DCI_MEM_PWR_CNTL__DMIF_RDREQ_MEM_PWR_FORCE__SHIFT                                                     0x0
#define DCI_MEM_PWR_CNTL__DMIF_RDREQ_MEM_PWR_DIS__SHIFT                                                       0x2
#define DCI_MEM_PWR_CNTL__VGA_MEM_PWR_FORCE__SHIFT                                                            0x7
#define DCI_MEM_PWR_CNTL__VGA_MEM_PWR_DIS__SHIFT                                                              0x8
#define DCI_MEM_PWR_CNTL__DMCU_ERAM_MEM_PWR_FORCE__SHIFT                                                      0x9
#define DCI_MEM_PWR_CNTL__DMCU_ERAM_MEM_PWR_DIS__SHIFT                                                        0xb
#define DCI_MEM_PWR_CNTL__DMCU_IRAM_MEM_PWR_FORCE__SHIFT                                                      0xc
#define DCI_MEM_PWR_CNTL__DMCU_IRAM_MEM_PWR_DIS__SHIFT                                                        0xd
#define DCI_MEM_PWR_CNTL__FBC_MEM_PWR_FORCE__SHIFT                                                            0xe
#define DCI_MEM_PWR_CNTL__FBC_MEM_PWR_DIS__SHIFT                                                              0x10
#define DCI_MEM_PWR_CNTL__MCIF_DWB_MEM_PWR_FORCE__SHIFT                                                       0x14
#define DCI_MEM_PWR_CNTL__MCIF_DWB_MEM_PWR_DIS__SHIFT                                                         0x16
#define DCI_MEM_PWR_CNTL__MCIF_CWB0_MEM_PWR_FORCE__SHIFT                                                      0x17
#define DCI_MEM_PWR_CNTL__MCIF_CWB0_MEM_PWR_DIS__SHIFT                                                        0x19
#define DCI_MEM_PWR_CNTL__MCIF_CWB1_MEM_PWR_FORCE__SHIFT                                                      0x1a
#define DCI_MEM_PWR_CNTL__MCIF_CWB1_MEM_PWR_DIS__SHIFT                                                        0x1c
#define DCI_MEM_PWR_CNTL__VIP_MEM_PWR_FORCE__SHIFT                                                            0x1d
#define DCI_MEM_PWR_CNTL__VIP_MEM_PWR_DIS__SHIFT                                                              0x1e
#define DCI_MEM_PWR_CNTL__DMIF_RDREQ_MEM_PWR_FORCE_MASK                                                       0x00000003L
#define DCI_MEM_PWR_CNTL__DMIF_RDREQ_MEM_PWR_DIS_MASK                                                         0x00000004L
#define DCI_MEM_PWR_CNTL__VGA_MEM_PWR_FORCE_MASK                                                              0x00000080L
#define DCI_MEM_PWR_CNTL__VGA_MEM_PWR_DIS_MASK                                                                0x00000100L
#define DCI_MEM_PWR_CNTL__DMCU_ERAM_MEM_PWR_FORCE_MASK                                                        0x00000600L
#define DCI_MEM_PWR_CNTL__DMCU_ERAM_MEM_PWR_DIS_MASK                                                          0x00000800L
#define DCI_MEM_PWR_CNTL__DMCU_IRAM_MEM_PWR_FORCE_MASK                                                        0x00001000L
#define DCI_MEM_PWR_CNTL__DMCU_IRAM_MEM_PWR_DIS_MASK                                                          0x00002000L
#define DCI_MEM_PWR_CNTL__FBC_MEM_PWR_FORCE_MASK                                                              0x0000C000L
#define DCI_MEM_PWR_CNTL__FBC_MEM_PWR_DIS_MASK                                                                0x00010000L
#define DCI_MEM_PWR_CNTL__MCIF_DWB_MEM_PWR_FORCE_MASK                                                         0x00300000L
#define DCI_MEM_PWR_CNTL__MCIF_DWB_MEM_PWR_DIS_MASK                                                           0x00400000L
#define DCI_MEM_PWR_CNTL__MCIF_CWB0_MEM_PWR_FORCE_MASK                                                        0x01800000L
#define DCI_MEM_PWR_CNTL__MCIF_CWB0_MEM_PWR_DIS_MASK                                                          0x02000000L
#define DCI_MEM_PWR_CNTL__MCIF_CWB1_MEM_PWR_FORCE_MASK                                                        0x0C000000L
#define DCI_MEM_PWR_CNTL__MCIF_CWB1_MEM_PWR_DIS_MASK                                                          0x10000000L
#define DCI_MEM_PWR_CNTL__VIP_MEM_PWR_FORCE_MASK                                                              0x20000000L
#define DCI_MEM_PWR_CNTL__VIP_MEM_PWR_DIS_MASK                                                                0x40000000L
//DCI_MEM_PWR_CNTL2
#define DCI_MEM_PWR_CNTL2__DMIF0_ASYNC_MEM_PWR_FORCE__SHIFT                                                   0x0
#define DCI_MEM_PWR_CNTL2__DMIF0_ASYNC_MEM_PWR_DIS__SHIFT                                                     0x2
#define DCI_MEM_PWR_CNTL2__DMIF0_DATA_MEM_PWR_FORCE__SHIFT                                                    0x3
#define DCI_MEM_PWR_CNTL2__DMIF0_DATA_MEM_PWR_DIS__SHIFT                                                      0x5
#define DCI_MEM_PWR_CNTL2__DMIF0_CHUNK_MEM_PWR_FORCE__SHIFT                                                   0x6
#define DCI_MEM_PWR_CNTL2__DMIF0_CHUNK_MEM_PWR_DIS__SHIFT                                                     0x7
#define DCI_MEM_PWR_CNTL2__DMIF1_ASYNC_MEM_PWR_FORCE__SHIFT                                                   0x8
#define DCI_MEM_PWR_CNTL2__DMIF1_ASYNC_MEM_PWR_DIS__SHIFT                                                     0xa
#define DCI_MEM_PWR_CNTL2__DMIF1_DATA_MEM_PWR_FORCE__SHIFT                                                    0xb
#define DCI_MEM_PWR_CNTL2__DMIF1_DATA_MEM_PWR_DIS__SHIFT                                                      0xd
#define DCI_MEM_PWR_CNTL2__DMIF1_CHUNK_MEM_PWR_FORCE__SHIFT                                                   0xe
#define DCI_MEM_PWR_CNTL2__DMIF1_CHUNK_MEM_PWR_DIS__SHIFT                                                     0xf
#define DCI_MEM_PWR_CNTL2__DMIF2_ASYNC_MEM_PWR_FORCE__SHIFT                                                   0x10
#define DCI_MEM_PWR_CNTL2__DMIF2_ASYNC_MEM_PWR_DIS__SHIFT                                                     0x12
#define DCI_MEM_PWR_CNTL2__DMIF2_DATA_MEM_PWR_FORCE__SHIFT                                                    0x13
#define DCI_MEM_PWR_CNTL2__DMIF2_DATA_MEM_PWR_DIS__SHIFT                                                      0x15
#define DCI_MEM_PWR_CNTL2__DMIF2_CHUNK_MEM_PWR_FORCE__SHIFT                                                   0x16
#define DCI_MEM_PWR_CNTL2__DMIF2_CHUNK_MEM_PWR_DIS__SHIFT                                                     0x17
#define DCI_MEM_PWR_CNTL2__DMIF3_ASYNC_MEM_PWR_FORCE__SHIFT                                                   0x18
#define DCI_MEM_PWR_CNTL2__DMIF3_ASYNC_MEM_PWR_DIS__SHIFT                                                     0x1a
#define DCI_MEM_PWR_CNTL2__DMIF3_DATA_MEM_PWR_FORCE__SHIFT                                                    0x1b
#define DCI_MEM_PWR_CNTL2__DMIF3_DATA_MEM_PWR_DIS__SHIFT                                                      0x1d
#define DCI_MEM_PWR_CNTL2__DMIF3_CHUNK_MEM_PWR_FORCE__SHIFT                                                   0x1e
#define DCI_MEM_PWR_CNTL2__DMIF3_CHUNK_MEM_PWR_DIS__SHIFT                                                     0x1f
#define DCI_MEM_PWR_CNTL2__DMIF0_ASYNC_MEM_PWR_FORCE_MASK                                                     0x00000003L
#define DCI_MEM_PWR_CNTL2__DMIF0_ASYNC_MEM_PWR_DIS_MASK                                                       0x00000004L
#define DCI_MEM_PWR_CNTL2__DMIF0_DATA_MEM_PWR_FORCE_MASK                                                      0x00000018L
#define DCI_MEM_PWR_CNTL2__DMIF0_DATA_MEM_PWR_DIS_MASK                                                        0x00000020L
#define DCI_MEM_PWR_CNTL2__DMIF0_CHUNK_MEM_PWR_FORCE_MASK                                                     0x00000040L
#define DCI_MEM_PWR_CNTL2__DMIF0_CHUNK_MEM_PWR_DIS_MASK                                                       0x00000080L
#define DCI_MEM_PWR_CNTL2__DMIF1_ASYNC_MEM_PWR_FORCE_MASK                                                     0x00000300L
#define DCI_MEM_PWR_CNTL2__DMIF1_ASYNC_MEM_PWR_DIS_MASK                                                       0x00000400L
#define DCI_MEM_PWR_CNTL2__DMIF1_DATA_MEM_PWR_FORCE_MASK                                                      0x00001800L
#define DCI_MEM_PWR_CNTL2__DMIF1_DATA_MEM_PWR_DIS_MASK                                                        0x00002000L
#define DCI_MEM_PWR_CNTL2__DMIF1_CHUNK_MEM_PWR_FORCE_MASK                                                     0x00004000L
#define DCI_MEM_PWR_CNTL2__DMIF1_CHUNK_MEM_PWR_DIS_MASK                                                       0x00008000L
#define DCI_MEM_PWR_CNTL2__DMIF2_ASYNC_MEM_PWR_FORCE_MASK                                                     0x00030000L
#define DCI_MEM_PWR_CNTL2__DMIF2_ASYNC_MEM_PWR_DIS_MASK                                                       0x00040000L
#define DCI_MEM_PWR_CNTL2__DMIF2_DATA_MEM_PWR_FORCE_MASK                                                      0x00180000L
#define DCI_MEM_PWR_CNTL2__DMIF2_DATA_MEM_PWR_DIS_MASK                                                        0x00200000L
#define DCI_MEM_PWR_CNTL2__DMIF2_CHUNK_MEM_PWR_FORCE_MASK                                                     0x00400000L
#define DCI_MEM_PWR_CNTL2__DMIF2_CHUNK_MEM_PWR_DIS_MASK                                                       0x00800000L
#define DCI_MEM_PWR_CNTL2__DMIF3_ASYNC_MEM_PWR_FORCE_MASK                                                     0x03000000L
#define DCI_MEM_PWR_CNTL2__DMIF3_ASYNC_MEM_PWR_DIS_MASK                                                       0x04000000L
#define DCI_MEM_PWR_CNTL2__DMIF3_DATA_MEM_PWR_FORCE_MASK                                                      0x18000000L
#define DCI_MEM_PWR_CNTL2__DMIF3_DATA_MEM_PWR_DIS_MASK                                                        0x20000000L
#define DCI_MEM_PWR_CNTL2__DMIF3_CHUNK_MEM_PWR_FORCE_MASK                                                     0x40000000L
#define DCI_MEM_PWR_CNTL2__DMIF3_CHUNK_MEM_PWR_DIS_MASK                                                       0x80000000L
//DCI_MEM_PWR_CNTL3
#define DCI_MEM_PWR_CNTL3__DMIF4_ASYNC_MEM_PWR_FORCE__SHIFT                                                   0x0
#define DCI_MEM_PWR_CNTL3__DMIF4_ASYNC_MEM_PWR_DIS__SHIFT                                                     0x2
#define DCI_MEM_PWR_CNTL3__DMIF4_DATA_MEM_PWR_FORCE__SHIFT                                                    0x3
#define DCI_MEM_PWR_CNTL3__DMIF4_DATA_MEM_PWR_DIS__SHIFT                                                      0x5
#define DCI_MEM_PWR_CNTL3__DMIF4_CHUNK_MEM_PWR_FORCE__SHIFT                                                   0x6
#define DCI_MEM_PWR_CNTL3__DMIF4_CHUNK_MEM_PWR_DIS__SHIFT                                                     0x7
#define DCI_MEM_PWR_CNTL3__DMIF5_ASYNC_MEM_PWR_FORCE__SHIFT                                                   0x8
#define DCI_MEM_PWR_CNTL3__DMIF5_ASYNC_MEM_PWR_DIS__SHIFT                                                     0xa
#define DCI_MEM_PWR_CNTL3__DMIF5_DATA_MEM_PWR_FORCE__SHIFT                                                    0xb
#define DCI_MEM_PWR_CNTL3__DMIF5_DATA_MEM_PWR_DIS__SHIFT                                                      0xd
#define DCI_MEM_PWR_CNTL3__DMIF5_CHUNK_MEM_PWR_FORCE__SHIFT                                                   0xe
#define DCI_MEM_PWR_CNTL3__DMIF5_CHUNK_MEM_PWR_DIS__SHIFT                                                     0xf
#define DCI_MEM_PWR_CNTL3__DMIF_RDREQ_MEM_PWR_MODE_SEL__SHIFT                                                 0x10
#define DCI_MEM_PWR_CNTL3__DMIF_ASYNC_MEM_PWR_MODE_SEL__SHIFT                                                 0x12
#define DCI_MEM_PWR_CNTL3__DMIF_DATA_MEM_PWR_MODE_SEL__SHIFT                                                  0x14
#define DCI_MEM_PWR_CNTL3__DMCU_ERAM_MEM_PWR_MODE_SEL__SHIFT                                                  0x16
#define DCI_MEM_PWR_CNTL3__FBC_MEM_PWR_MODE_SEL__SHIFT                                                        0x17
#define DCI_MEM_PWR_CNTL3__MCIF_CWB0_MEM_PWR_MODE_SEL__SHIFT                                                  0x19
#define DCI_MEM_PWR_CNTL3__MCIF_CWB1_MEM_PWR_MODE_SEL__SHIFT                                                  0x1b
#define DCI_MEM_PWR_CNTL3__MCIF_DWB_MEM_PWR_MODE_SEL__SHIFT                                                   0x1d
#define DCI_MEM_PWR_CNTL3__DMIF4_ASYNC_MEM_PWR_FORCE_MASK                                                     0x00000003L
#define DCI_MEM_PWR_CNTL3__DMIF4_ASYNC_MEM_PWR_DIS_MASK                                                       0x00000004L
#define DCI_MEM_PWR_CNTL3__DMIF4_DATA_MEM_PWR_FORCE_MASK                                                      0x00000018L
#define DCI_MEM_PWR_CNTL3__DMIF4_DATA_MEM_PWR_DIS_MASK                                                        0x00000020L
#define DCI_MEM_PWR_CNTL3__DMIF4_CHUNK_MEM_PWR_FORCE_MASK                                                     0x00000040L
#define DCI_MEM_PWR_CNTL3__DMIF4_CHUNK_MEM_PWR_DIS_MASK                                                       0x00000080L
#define DCI_MEM_PWR_CNTL3__DMIF5_ASYNC_MEM_PWR_FORCE_MASK                                                     0x00000300L
#define DCI_MEM_PWR_CNTL3__DMIF5_ASYNC_MEM_PWR_DIS_MASK                                                       0x00000400L
#define DCI_MEM_PWR_CNTL3__DMIF5_DATA_MEM_PWR_FORCE_MASK                                                      0x00001800L
#define DCI_MEM_PWR_CNTL3__DMIF5_DATA_MEM_PWR_DIS_MASK                                                        0x00002000L
#define DCI_MEM_PWR_CNTL3__DMIF5_CHUNK_MEM_PWR_FORCE_MASK                                                     0x00004000L
#define DCI_MEM_PWR_CNTL3__DMIF5_CHUNK_MEM_PWR_DIS_MASK                                                       0x00008000L
#define DCI_MEM_PWR_CNTL3__DMIF_RDREQ_MEM_PWR_MODE_SEL_MASK                                                   0x00030000L
#define DCI_MEM_PWR_CNTL3__DMIF_ASYNC_MEM_PWR_MODE_SEL_MASK                                                   0x000C0000L
#define DCI_MEM_PWR_CNTL3__DMIF_DATA_MEM_PWR_MODE_SEL_MASK                                                    0x00300000L
#define DCI_MEM_PWR_CNTL3__DMCU_ERAM_MEM_PWR_MODE_SEL_MASK                                                    0x00400000L
#define DCI_MEM_PWR_CNTL3__FBC_MEM_PWR_MODE_SEL_MASK                                                          0x01800000L
#define DCI_MEM_PWR_CNTL3__MCIF_CWB0_MEM_PWR_MODE_SEL_MASK                                                    0x06000000L
#define DCI_MEM_PWR_CNTL3__MCIF_CWB1_MEM_PWR_MODE_SEL_MASK                                                    0x18000000L
#define DCI_MEM_PWR_CNTL3__MCIF_DWB_MEM_PWR_MODE_SEL_MASK                                                     0x60000000L
//PIPE0_DMIF_BUFFER_CONTROL
#define PIPE0_DMIF_BUFFER_CONTROL__DMIF_BUFFERS_ALLOCATED__SHIFT                                              0x0
#define PIPE0_DMIF_BUFFER_CONTROL__DMIF_BUFFERS_ALLOCATION_COMPLETED__SHIFT                                   0x4
#define PIPE0_DMIF_BUFFER_CONTROL__DMIF_BUFFERS_ALLOCATED_MASK                                                0x00000007L
#define PIPE0_DMIF_BUFFER_CONTROL__DMIF_BUFFERS_ALLOCATION_COMPLETED_MASK                                     0x00000010L
//PIPE1_DMIF_BUFFER_CONTROL
#define PIPE1_DMIF_BUFFER_CONTROL__DMIF_BUFFERS_ALLOCATED__SHIFT                                              0x0
#define PIPE1_DMIF_BUFFER_CONTROL__DMIF_BUFFERS_ALLOCATION_COMPLETED__SHIFT                                   0x4
#define PIPE1_DMIF_BUFFER_CONTROL__DMIF_BUFFERS_ALLOCATED_MASK                                                0x00000007L
#define PIPE1_DMIF_BUFFER_CONTROL__DMIF_BUFFERS_ALLOCATION_COMPLETED_MASK                                     0x00000010L
//PIPE2_DMIF_BUFFER_CONTROL
#define PIPE2_DMIF_BUFFER_CONTROL__DMIF_BUFFERS_ALLOCATED__SHIFT                                              0x0
#define PIPE2_DMIF_BUFFER_CONTROL__DMIF_BUFFERS_ALLOCATION_COMPLETED__SHIFT                                   0x4
#define PIPE2_DMIF_BUFFER_CONTROL__DMIF_BUFFERS_ALLOCATED_MASK                                                0x00000007L
#define PIPE2_DMIF_BUFFER_CONTROL__DMIF_BUFFERS_ALLOCATION_COMPLETED_MASK                                     0x00000010L
//PIPE3_DMIF_BUFFER_CONTROL
#define PIPE3_DMIF_BUFFER_CONTROL__DMIF_BUFFERS_ALLOCATED__SHIFT                                              0x0
#define PIPE3_DMIF_BUFFER_CONTROL__DMIF_BUFFERS_ALLOCATION_COMPLETED__SHIFT                                   0x4
#define PIPE3_DMIF_BUFFER_CONTROL__DMIF_BUFFERS_ALLOCATED_MASK                                                0x00000007L
#define PIPE3_DMIF_BUFFER_CONTROL__DMIF_BUFFERS_ALLOCATION_COMPLETED_MASK                                     0x00000010L
//PIPE4_DMIF_BUFFER_CONTROL
#define PIPE4_DMIF_BUFFER_CONTROL__DMIF_BUFFERS_ALLOCATED__SHIFT                                              0x0
#define PIPE4_DMIF_BUFFER_CONTROL__DMIF_BUFFERS_ALLOCATION_COMPLETED__SHIFT                                   0x4
#define PIPE4_DMIF_BUFFER_CONTROL__DMIF_BUFFERS_ALLOCATED_MASK                                                0x00000007L
#define PIPE4_DMIF_BUFFER_CONTROL__DMIF_BUFFERS_ALLOCATION_COMPLETED_MASK                                     0x00000010L
//PIPE5_DMIF_BUFFER_CONTROL
#define PIPE5_DMIF_BUFFER_CONTROL__DMIF_BUFFERS_ALLOCATED__SHIFT                                              0x0
#define PIPE5_DMIF_BUFFER_CONTROL__DMIF_BUFFERS_ALLOCATION_COMPLETED__SHIFT                                   0x4
#define PIPE5_DMIF_BUFFER_CONTROL__DMIF_BUFFERS_ALLOCATED_MASK                                                0x00000007L
#define PIPE5_DMIF_BUFFER_CONTROL__DMIF_BUFFERS_ALLOCATION_COMPLETED_MASK                                     0x00000010L
//RBBMIF_STATUS_FLAG
#define RBBMIF_STATUS_FLAG__RBBMIF_STATE__SHIFT                                                               0x0
#define RBBMIF_STATUS_FLAG__RBBMIF_READ_TIMEOUT__SHIFT                                                        0x4
#define RBBMIF_STATUS_FLAG__RBBMIF_FIFO_EMPTY__SHIFT                                                          0x5
#define RBBMIF_STATUS_FLAG__RBBMIF_FIFO_FULL__SHIFT                                                           0x6
#define RBBMIF_STATUS_FLAG__RBBMIF_INVALID_ACCESS_FLAG__SHIFT                                                 0x8
#define RBBMIF_STATUS_FLAG__RBBMIF_INVALID_ACCESS_TYPE__SHIFT                                                 0x9
#define RBBMIF_STATUS_FLAG__RBBMIF_INVALID_ACCESS_ADDR__SHIFT                                                 0x10
#define RBBMIF_STATUS_FLAG__RBBMIF_STATE_MASK                                                                 0x00000003L
#define RBBMIF_STATUS_FLAG__RBBMIF_READ_TIMEOUT_MASK                                                          0x00000010L
#define RBBMIF_STATUS_FLAG__RBBMIF_FIFO_EMPTY_MASK                                                            0x00000020L
#define RBBMIF_STATUS_FLAG__RBBMIF_FIFO_FULL_MASK                                                             0x00000040L
#define RBBMIF_STATUS_FLAG__RBBMIF_INVALID_ACCESS_FLAG_MASK                                                   0x00000100L
#define RBBMIF_STATUS_FLAG__RBBMIF_INVALID_ACCESS_TYPE_MASK                                                   0x00000E00L
#define RBBMIF_STATUS_FLAG__RBBMIF_INVALID_ACCESS_ADDR_MASK                                                   0xFFFF0000L
//DCI_SOFT_RESET
#define DCI_SOFT_RESET__VGA_SOFT_RESET__SHIFT                                                                 0x0
#define DCI_SOFT_RESET__VIP_SOFT_RESET__SHIFT                                                                 0x1
#define DCI_SOFT_RESET__MCIF_SOFT_RESET__SHIFT                                                                0x2
#define DCI_SOFT_RESET__FBC_SOFT_RESET__SHIFT                                                                 0x3
#define DCI_SOFT_RESET__DMIF0_SOFT_RESET__SHIFT                                                               0x4
#define DCI_SOFT_RESET__DMIF1_SOFT_RESET__SHIFT                                                               0x5
#define DCI_SOFT_RESET__DMIF2_SOFT_RESET__SHIFT                                                               0x6
#define DCI_SOFT_RESET__DMIF3_SOFT_RESET__SHIFT                                                               0x7
#define DCI_SOFT_RESET__DMIF4_SOFT_RESET__SHIFT                                                               0x8
#define DCI_SOFT_RESET__DMIF5_SOFT_RESET__SHIFT                                                               0x9
#define DCI_SOFT_RESET__DCFEV0_L_SOFT_RESET__SHIFT                                                            0xa
#define DCI_SOFT_RESET__DCFEV0_C_SOFT_RESET__SHIFT                                                            0xb
#define DCI_SOFT_RESET__DCFEV1_L_SOFT_RESET__SHIFT                                                            0xc
#define DCI_SOFT_RESET__DCFEV1_C_SOFT_RESET__SHIFT                                                            0xd
#define DCI_SOFT_RESET__DMIFARB_SOFT_RESET__SHIFT                                                             0xe
#define DCI_SOFT_RESET__DCHUB_SOFT_RESET__SHIFT                                                               0xf
#define DCI_SOFT_RESET__MCIF_DWB_SOFT_RESET__SHIFT                                                            0x10
#define DCI_SOFT_RESET__MCIF_CWB0_SOFT_RESET__SHIFT                                                           0x11
#define DCI_SOFT_RESET__MCIF_CWB1_SOFT_RESET__SHIFT                                                           0x12
#define DCI_SOFT_RESET__MCIF_WB_SOFT_RESET__SHIFT                                                             0x13
#define DCI_SOFT_RESET__VGA_SOFT_RESET_MASK                                                                   0x00000001L
#define DCI_SOFT_RESET__VIP_SOFT_RESET_MASK                                                                   0x00000002L
#define DCI_SOFT_RESET__MCIF_SOFT_RESET_MASK                                                                  0x00000004L
#define DCI_SOFT_RESET__FBC_SOFT_RESET_MASK                                                                   0x00000008L
#define DCI_SOFT_RESET__DMIF0_SOFT_RESET_MASK                                                                 0x00000010L
#define DCI_SOFT_RESET__DMIF1_SOFT_RESET_MASK                                                                 0x00000020L
#define DCI_SOFT_RESET__DMIF2_SOFT_RESET_MASK                                                                 0x00000040L
#define DCI_SOFT_RESET__DMIF3_SOFT_RESET_MASK                                                                 0x00000080L
#define DCI_SOFT_RESET__DMIF4_SOFT_RESET_MASK                                                                 0x00000100L
#define DCI_SOFT_RESET__DMIF5_SOFT_RESET_MASK                                                                 0x00000200L
#define DCI_SOFT_RESET__DCFEV0_L_SOFT_RESET_MASK                                                              0x00000400L
#define DCI_SOFT_RESET__DCFEV0_C_SOFT_RESET_MASK                                                              0x00000800L
#define DCI_SOFT_RESET__DCFEV1_L_SOFT_RESET_MASK                                                              0x00001000L
#define DCI_SOFT_RESET__DCFEV1_C_SOFT_RESET_MASK                                                              0x00002000L
#define DCI_SOFT_RESET__DMIFARB_SOFT_RESET_MASK                                                               0x00004000L
#define DCI_SOFT_RESET__DCHUB_SOFT_RESET_MASK                                                                 0x00008000L
#define DCI_SOFT_RESET__MCIF_DWB_SOFT_RESET_MASK                                                              0x00010000L
#define DCI_SOFT_RESET__MCIF_CWB0_SOFT_RESET_MASK                                                             0x00020000L
#define DCI_SOFT_RESET__MCIF_CWB1_SOFT_RESET_MASK                                                             0x00040000L
#define DCI_SOFT_RESET__MCIF_WB_SOFT_RESET_MASK                                                               0x00080000L
//DMIF_URG_OVERRIDE
#define DMIF_URG_OVERRIDE__DMIF_URG_OVERRIDE_EN__SHIFT                                                        0x0
#define DMIF_URG_OVERRIDE__DMIF_URG_OVERRIDE_LEVEL__SHIFT                                                     0x4
#define DMIF_URG_OVERRIDE__DMIF_URG_OVERRIDE_EN_MASK                                                          0x00000001L
#define DMIF_URG_OVERRIDE__DMIF_URG_OVERRIDE_LEVEL_MASK                                                       0x000000F0L
//PIPE6_ARBITRATION_CONTROL3
#define PIPE6_ARBITRATION_CONTROL3__EFFICIENCY_WEIGHT__SHIFT                                                  0x0
#define PIPE6_ARBITRATION_CONTROL3__EFFICIENCY_WEIGHT_MASK                                                    0x0000FFFFL
//PIPE7_ARBITRATION_CONTROL3
#define PIPE7_ARBITRATION_CONTROL3__EFFICIENCY_WEIGHT__SHIFT                                                  0x0
#define PIPE7_ARBITRATION_CONTROL3__EFFICIENCY_WEIGHT_MASK                                                    0x0000FFFFL
//PIPE6_MAX_REQUESTS
#define PIPE6_MAX_REQUESTS__MAX_REQUESTS__SHIFT                                                               0x0
#define PIPE6_MAX_REQUESTS__MAX_REQUESTS_MASK                                                                 0x000003FFL
//PIPE7_MAX_REQUESTS
#define PIPE7_MAX_REQUESTS__MAX_REQUESTS__SHIFT                                                               0x0
#define PIPE7_MAX_REQUESTS__MAX_REQUESTS_MASK                                                                 0x000003FFL
//DVMM_REG_RD_STATUS
#define DVMM_REG_RD_STATUS__DVMM_REG_RD_STATUS__SHIFT                                                         0x0
#define DVMM_REG_RD_STATUS__DVMM_REG_RD_STATUS_MASK                                                           0x00000001L
//DVMM_REG_RD_DATA
#define DVMM_REG_RD_DATA__DVMM_REG_RD_DATA__SHIFT                                                             0x0
#define DVMM_REG_RD_DATA__DVMM_REG_RD_DATA_MASK                                                               0xFFFFFFFFL
//DVMM_PTE_REQ
#define DVMM_PTE_REQ__MAX_PTEREQ_TO_ISSUE__SHIFT                                                              0x0
#define DVMM_PTE_REQ__HFLIP_PTEREQ_PER_CHUNK_INT__SHIFT                                                       0x8
#define DVMM_PTE_REQ__HFLIP_PTEREQ_PER_CHUNK_MULTIPLIER__SHIFT                                                0x10
#define DVMM_PTE_REQ__MAX_PTEREQ_TO_ISSUE_MASK                                                                0x000000FFL
#define DVMM_PTE_REQ__HFLIP_PTEREQ_PER_CHUNK_INT_MASK                                                         0x0000FF00L
#define DVMM_PTE_REQ__HFLIP_PTEREQ_PER_CHUNK_MULTIPLIER_MASK                                                  0x003F0000L
//DVMM_CNTL
#define DVMM_CNTL__PDE_CACHE_INVALIDATE_CNTL__SHIFT                                                           0x0
#define DVMM_CNTL__FORCE_SYSTEM_ACCESS_MODE__SHIFT                                                            0x7
#define DVMM_CNTL__OVERRIDE_SNOOP__SHIFT                                                                      0x11
#define DVMM_CNTL__ENABLE_PDE_INVALIDATE__SHIFT                                                               0x12
#define DVMM_CNTL__PDE_CACHE_INVALIDATE_CNTL_MASK                                                             0x00000003L
#define DVMM_CNTL__FORCE_SYSTEM_ACCESS_MODE_MASK                                                              0x00000080L
#define DVMM_CNTL__OVERRIDE_SNOOP_MASK                                                                        0x00020000L
#define DVMM_CNTL__ENABLE_PDE_INVALIDATE_MASK                                                                 0x00040000L
//DVMM_FAULT_STATUS
#define DVMM_FAULT_STATUS__DVMM_FAULT_STATUS__SHIFT                                                           0x0
#define DVMM_FAULT_STATUS__DVMM_FAULT_STATUS_MASK                                                             0xFFFFFFFFL
//DVMM_FAULT_ADDR
#define DVMM_FAULT_ADDR__DVMM_FAULT_ADDR__SHIFT                                                               0x0
#define DVMM_FAULT_ADDR__DVMM_FAULT_ADDR_MASK                                                                 0xFFFFFFFFL
//FMON_CTRL
#define FMON_CTRL__FMON_START__SHIFT                                                                          0x0
#define FMON_CTRL__FMON_MODE__SHIFT                                                                           0x1
#define FMON_CTRL__FMON_PSTATE_IGNORE__SHIFT                                                                  0x4
#define FMON_CTRL__FMON_STATUS_IGNORE__SHIFT                                                                  0x5
#define FMON_CTRL__FMON_URG_MODE_GREATER__SHIFT                                                               0x6
#define FMON_CTRL__FMON_FILTER_UID_EN__SHIFT                                                                  0x7
#define FMON_CTRL__FMON_STATE__SHIFT                                                                          0x8
#define FMON_CTRL__FMON_URG_THRESHOLD__SHIFT                                                                  0xc
#define FMON_CTRL__FMON_FILTER_UID__SHIFT                                                                     0x10
#define FMON_CTRL__FMON_SOF_SEL__SHIFT                                                                        0x18
#define FMON_CTRL__FMON_START_MASK                                                                            0x00000001L
#define FMON_CTRL__FMON_MODE_MASK                                                                             0x00000006L
#define FMON_CTRL__FMON_PSTATE_IGNORE_MASK                                                                    0x00000010L
#define FMON_CTRL__FMON_STATUS_IGNORE_MASK                                                                    0x00000020L
#define FMON_CTRL__FMON_URG_MODE_GREATER_MASK                                                                 0x00000040L
#define FMON_CTRL__FMON_FILTER_UID_EN_MASK                                                                    0x00000080L
#define FMON_CTRL__FMON_STATE_MASK                                                                            0x00000300L
#define FMON_CTRL__FMON_URG_THRESHOLD_MASK                                                                    0x0000F000L
#define FMON_CTRL__FMON_FILTER_UID_MASK                                                                       0x001F0000L
#define FMON_CTRL__FMON_SOF_SEL_MASK                                                                          0x07000000L
//DVMM_PTE_PGMEM_CONTROL
#define DVMM_PTE_PGMEM_CONTROL__DVMM_PTE0_MEM_PWR_FORCE__SHIFT                                                0x0
#define DVMM_PTE_PGMEM_CONTROL__DVMM_PTE0_MEM_PWR_DIS__SHIFT                                                  0x2
#define DVMM_PTE_PGMEM_CONTROL__DVMM_PTE1_MEM_PWR_FORCE__SHIFT                                                0x3
#define DVMM_PTE_PGMEM_CONTROL__DVMM_PTE1_MEM_PWR_DIS__SHIFT                                                  0x5
#define DVMM_PTE_PGMEM_CONTROL__DVMM_PTE2_MEM_PWR_FORCE__SHIFT                                                0x6
#define DVMM_PTE_PGMEM_CONTROL__DVMM_PTE2_MEM_PWR_DIS__SHIFT                                                  0x8
#define DVMM_PTE_PGMEM_CONTROL__DVMM_PTE3_MEM_PWR_FORCE__SHIFT                                                0x9
#define DVMM_PTE_PGMEM_CONTROL__DVMM_PTE3_MEM_PWR_DIS__SHIFT                                                  0xb
#define DVMM_PTE_PGMEM_CONTROL__DVMM_PTE4_MEM_PWR_FORCE__SHIFT                                                0xc
#define DVMM_PTE_PGMEM_CONTROL__DVMM_PTE4_MEM_PWR_DIS__SHIFT                                                  0xe
#define DVMM_PTE_PGMEM_CONTROL__DVMM_PTE5_MEM_PWR_FORCE__SHIFT                                                0xf
#define DVMM_PTE_PGMEM_CONTROL__DVMM_PTE5_MEM_PWR_DIS__SHIFT                                                  0x11
#define DVMM_PTE_PGMEM_CONTROL__DVMM_PTE6_MEM_PWR_FORCE__SHIFT                                                0x12
#define DVMM_PTE_PGMEM_CONTROL__DVMM_PTE6_MEM_PWR_DIS__SHIFT                                                  0x14
#define DVMM_PTE_PGMEM_CONTROL__DVMM_PTE7_MEM_PWR_FORCE__SHIFT                                                0x15
#define DVMM_PTE_PGMEM_CONTROL__DVMM_PTE7_MEM_PWR_DIS__SHIFT                                                  0x17
#define DVMM_PTE_PGMEM_CONTROL__DVMM_PTE_MEM_PWR_MODE_SEL__SHIFT                                              0x18
#define DVMM_PTE_PGMEM_CONTROL__DVMM_PTE0_MEM_PWR_FORCE_MASK                                                  0x00000003L
#define DVMM_PTE_PGMEM_CONTROL__DVMM_PTE0_MEM_PWR_DIS_MASK                                                    0x00000004L
#define DVMM_PTE_PGMEM_CONTROL__DVMM_PTE1_MEM_PWR_FORCE_MASK                                                  0x00000018L
#define DVMM_PTE_PGMEM_CONTROL__DVMM_PTE1_MEM_PWR_DIS_MASK                                                    0x00000020L
#define DVMM_PTE_PGMEM_CONTROL__DVMM_PTE2_MEM_PWR_FORCE_MASK                                                  0x000000C0L
#define DVMM_PTE_PGMEM_CONTROL__DVMM_PTE2_MEM_PWR_DIS_MASK                                                    0x00000100L
#define DVMM_PTE_PGMEM_CONTROL__DVMM_PTE3_MEM_PWR_FORCE_MASK                                                  0x00000600L
#define DVMM_PTE_PGMEM_CONTROL__DVMM_PTE3_MEM_PWR_DIS_MASK                                                    0x00000800L
#define DVMM_PTE_PGMEM_CONTROL__DVMM_PTE4_MEM_PWR_FORCE_MASK                                                  0x00003000L
#define DVMM_PTE_PGMEM_CONTROL__DVMM_PTE4_MEM_PWR_DIS_MASK                                                    0x00004000L
#define DVMM_PTE_PGMEM_CONTROL__DVMM_PTE5_MEM_PWR_FORCE_MASK                                                  0x00018000L
#define DVMM_PTE_PGMEM_CONTROL__DVMM_PTE5_MEM_PWR_DIS_MASK                                                    0x00020000L
#define DVMM_PTE_PGMEM_CONTROL__DVMM_PTE6_MEM_PWR_FORCE_MASK                                                  0x000C0000L
#define DVMM_PTE_PGMEM_CONTROL__DVMM_PTE6_MEM_PWR_DIS_MASK                                                    0x00100000L
#define DVMM_PTE_PGMEM_CONTROL__DVMM_PTE7_MEM_PWR_FORCE_MASK                                                  0x00600000L
#define DVMM_PTE_PGMEM_CONTROL__DVMM_PTE7_MEM_PWR_DIS_MASK                                                    0x00800000L
#define DVMM_PTE_PGMEM_CONTROL__DVMM_PTE_MEM_PWR_MODE_SEL_MASK                                                0x03000000L
//DVMM_PTE_PGMEM_STATE
#define DVMM_PTE_PGMEM_STATE__DVMM_PIPE0_PTE_PGMEM_STATE__SHIFT                                               0x0
#define DVMM_PTE_PGMEM_STATE__DVMM_PIPE1_PTE_PGMEM_STATE__SHIFT                                               0x2
#define DVMM_PTE_PGMEM_STATE__DVMM_PIPE2_PTE_PGMEM_STATE__SHIFT                                               0x4
#define DVMM_PTE_PGMEM_STATE__DVMM_PIPE3_PTE_PGMEM_STATE__SHIFT                                               0x6
#define DVMM_PTE_PGMEM_STATE__DVMM_PIPE4_PTE_PGMEM_STATE__SHIFT                                               0x8
#define DVMM_PTE_PGMEM_STATE__DVMM_PIPE5_PTE_PGMEM_STATE__SHIFT                                               0xa
#define DVMM_PTE_PGMEM_STATE__DVMM_PIPE6_PTE_PGMEM_STATE__SHIFT                                               0xc
#define DVMM_PTE_PGMEM_STATE__DVMM_PIPE7_PTE_PGMEM_STATE__SHIFT                                               0xe
#define DVMM_PTE_PGMEM_STATE__DVMM_PIPE0_PTE_PGMEM_STATE_MASK                                                 0x00000003L
#define DVMM_PTE_PGMEM_STATE__DVMM_PIPE1_PTE_PGMEM_STATE_MASK                                                 0x0000000CL
#define DVMM_PTE_PGMEM_STATE__DVMM_PIPE2_PTE_PGMEM_STATE_MASK                                                 0x00000030L
#define DVMM_PTE_PGMEM_STATE__DVMM_PIPE3_PTE_PGMEM_STATE_MASK                                                 0x000000C0L
#define DVMM_PTE_PGMEM_STATE__DVMM_PIPE4_PTE_PGMEM_STATE_MASK                                                 0x00000300L
#define DVMM_PTE_PGMEM_STATE__DVMM_PIPE5_PTE_PGMEM_STATE_MASK                                                 0x00000C00L
#define DVMM_PTE_PGMEM_STATE__DVMM_PIPE6_PTE_PGMEM_STATE_MASK                                                 0x00003000L
#define DVMM_PTE_PGMEM_STATE__DVMM_PIPE7_PTE_PGMEM_STATE_MASK                                                 0x0000C000L
//MCIF_PHASE1_OUTSTANDING_COUNTER
#define MCIF_PHASE1_OUTSTANDING_COUNTER__MCIF_PHASE1_OUTSTANDING_COUNTER__SHIFT                               0x0
#define MCIF_PHASE1_OUTSTANDING_COUNTER__MCIF_PHASE1_OUTSTANDING_COUNTER_MASK                                 0x07FFFFFFL
//MCIF_PHASE2_OUTSTANDING_COUNTER
#define MCIF_PHASE2_OUTSTANDING_COUNTER__MCIF_PHASE2_OUTSTANDING_COUNTER__SHIFT                               0x0
#define MCIF_PHASE2_OUTSTANDING_COUNTER__MCIF_PHASE2_OUTSTANDING_COUNTER_MASK                                 0x07FFFFFFL
//MCIF_WB_PHASE0_OUTSTANDING_COUNTER
#define MCIF_WB_PHASE0_OUTSTANDING_COUNTER__MCIF_WB_PHASE0_OUTSTANDING_COUNTER__SHIFT                         0x0
#define MCIF_WB_PHASE0_OUTSTANDING_COUNTER__MCIF_WB_PHASE0_OUTSTANDING_COUNTER_MASK                           0x07FFFFFFL
//MCIF_WB_PHASE1_OUTSTANDING_COUNTER
#define MCIF_WB_PHASE1_OUTSTANDING_COUNTER__MCIF_WB_PHASE1_OUTSTANDING_COUNTER__SHIFT                         0x0
#define MCIF_WB_PHASE1_OUTSTANDING_COUNTER__MCIF_WB_PHASE1_OUTSTANDING_COUNTER_MASK                           0x07FFFFFFL
//DCI_MEM_PWR_CNTL4
#define DCI_MEM_PWR_CNTL4__MCIF_DWB_LUMA_MEM_EN_NUM__SHIFT                                                    0x0
#define DCI_MEM_PWR_CNTL4__MCIF_DWB_CHROMA_MEM_EN_NUM__SHIFT                                                  0x1
#define DCI_MEM_PWR_CNTL4__MCIF_CWB0_LUMA_MEM_EN_NUM__SHIFT                                                   0x2
#define DCI_MEM_PWR_CNTL4__MCIF_CWB0_CHROMA_MEM_EN_NUM__SHIFT                                                 0x3
#define DCI_MEM_PWR_CNTL4__MCIF_CWB1_LUMA_MEM_EN_NUM__SHIFT                                                   0x4
#define DCI_MEM_PWR_CNTL4__MCIF_CWB1_CHROMA_MEM_EN_NUM__SHIFT                                                 0x5
#define DCI_MEM_PWR_CNTL4__DMIF_CURSOR_MEM_PWR_FORCE__SHIFT                                                   0x6
#define DCI_MEM_PWR_CNTL4__DMIF_CURSOR_MEM_PWR_DIS__SHIFT                                                     0x8
#define DCI_MEM_PWR_CNTL4__DMIF_CURSOR_RD_REQ_MEM_PWR_FORCE__SHIFT                                            0x9
#define DCI_MEM_PWR_CNTL4__DMIF_CURSOR_RD_REQ_MEM_PWR_DIS__SHIFT                                              0xb
#define DCI_MEM_PWR_CNTL4__DMIF_CURSOR_RD_REQ_MEM_PWR_MODE_SEL__SHIFT                                         0xc
#define DCI_MEM_PWR_CNTL4__MCIF_DWB_LUMA_MEM_EN_NUM_MASK                                                      0x00000001L
#define DCI_MEM_PWR_CNTL4__MCIF_DWB_CHROMA_MEM_EN_NUM_MASK                                                    0x00000002L
#define DCI_MEM_PWR_CNTL4__MCIF_CWB0_LUMA_MEM_EN_NUM_MASK                                                     0x00000004L
#define DCI_MEM_PWR_CNTL4__MCIF_CWB0_CHROMA_MEM_EN_NUM_MASK                                                   0x00000008L
#define DCI_MEM_PWR_CNTL4__MCIF_CWB1_LUMA_MEM_EN_NUM_MASK                                                     0x00000010L
#define DCI_MEM_PWR_CNTL4__MCIF_CWB1_CHROMA_MEM_EN_NUM_MASK                                                   0x00000020L
#define DCI_MEM_PWR_CNTL4__DMIF_CURSOR_MEM_PWR_FORCE_MASK                                                     0x000000C0L
#define DCI_MEM_PWR_CNTL4__DMIF_CURSOR_MEM_PWR_DIS_MASK                                                       0x00000100L
#define DCI_MEM_PWR_CNTL4__DMIF_CURSOR_RD_REQ_MEM_PWR_FORCE_MASK                                              0x00000600L
#define DCI_MEM_PWR_CNTL4__DMIF_CURSOR_RD_REQ_MEM_PWR_DIS_MASK                                                0x00000800L
#define DCI_MEM_PWR_CNTL4__DMIF_CURSOR_RD_REQ_MEM_PWR_MODE_SEL_MASK                                           0x00003000L
//MCIF_WB_MISC_CTRL
#define MCIF_WB_MISC_CTRL__MCIFWB_WR_COMBINE_TIMEOUT_THRESH__SHIFT                                            0x0
#define MCIF_WB_MISC_CTRL__MCIF_WB_SOCCLK_DS_ENABLE__SHIFT                                                    0x10
#define MCIF_WB_MISC_CTRL__MCIFWB_WR_COMBINE_TIMEOUT_THRESH_MASK                                              0x000003FFL
#define MCIF_WB_MISC_CTRL__MCIF_WB_SOCCLK_DS_ENABLE_MASK                                                      0x00010000L
//DCI_MEM_PWR_STATUS3
#define DCI_MEM_PWR_STATUS3__MCIF_DWB_LUMA_MEM0_PWR_STATE__SHIFT                                              0x0
#define DCI_MEM_PWR_STATUS3__MCIF_DWB_LUMA_MEM1_PWR_STATE__SHIFT                                              0x2
#define DCI_MEM_PWR_STATUS3__MCIF_DWB_CHROMA_MEM0_PWR_STATE__SHIFT                                            0x4
#define DCI_MEM_PWR_STATUS3__MCIF_DWB_CHROMA_MEM1_PWR_STATE__SHIFT                                            0x6
#define DCI_MEM_PWR_STATUS3__MCIF_CWB0_LUMA_MEM0_PWR_STATE__SHIFT                                             0x8
#define DCI_MEM_PWR_STATUS3__MCIF_CWB0_LUMA_MEM1_PWR_STATE__SHIFT                                             0xa
#define DCI_MEM_PWR_STATUS3__MCIF_CWB0_CHROMA_MEM0_PWR_STATE__SHIFT                                           0xc
#define DCI_MEM_PWR_STATUS3__MCIF_CWB0_CHROMA_MEM1_PWR_STATE__SHIFT                                           0xe
#define DCI_MEM_PWR_STATUS3__MCIF_CWB1_LUMA_MEM0_PWR_STATE__SHIFT                                             0x10
#define DCI_MEM_PWR_STATUS3__MCIF_CWB1_LUMA_MEM1_PWR_STATE__SHIFT                                             0x12
#define DCI_MEM_PWR_STATUS3__MCIF_CWB1_CHROMA_MEM0_PWR_STATE__SHIFT                                           0x14
#define DCI_MEM_PWR_STATUS3__MCIF_CWB1_CHROMA_MEM1_PWR_STATE__SHIFT                                           0x16
#define DCI_MEM_PWR_STATUS3__MCIF_DWB_LUMA_MEM0_PWR_STATE_MASK                                                0x00000003L
#define DCI_MEM_PWR_STATUS3__MCIF_DWB_LUMA_MEM1_PWR_STATE_MASK                                                0x0000000CL
#define DCI_MEM_PWR_STATUS3__MCIF_DWB_CHROMA_MEM0_PWR_STATE_MASK                                              0x00000030L
#define DCI_MEM_PWR_STATUS3__MCIF_DWB_CHROMA_MEM1_PWR_STATE_MASK                                              0x000000C0L
#define DCI_MEM_PWR_STATUS3__MCIF_CWB0_LUMA_MEM0_PWR_STATE_MASK                                               0x00000300L
#define DCI_MEM_PWR_STATUS3__MCIF_CWB0_LUMA_MEM1_PWR_STATE_MASK                                               0x00000C00L
#define DCI_MEM_PWR_STATUS3__MCIF_CWB0_CHROMA_MEM0_PWR_STATE_MASK                                             0x00003000L
#define DCI_MEM_PWR_STATUS3__MCIF_CWB0_CHROMA_MEM1_PWR_STATE_MASK                                             0x0000C000L
#define DCI_MEM_PWR_STATUS3__MCIF_CWB1_LUMA_MEM0_PWR_STATE_MASK                                               0x00030000L
#define DCI_MEM_PWR_STATUS3__MCIF_CWB1_LUMA_MEM1_PWR_STATE_MASK                                               0x000C0000L
#define DCI_MEM_PWR_STATUS3__MCIF_CWB1_CHROMA_MEM0_PWR_STATE_MASK                                             0x00300000L
#define DCI_MEM_PWR_STATUS3__MCIF_CWB1_CHROMA_MEM1_PWR_STATE_MASK                                             0x00C00000L
//DMIF_CURSOR_CONTROL
#define DMIF_CURSOR_CONTROL__ADDRESS_TRANSLATION_ENABLE__SHIFT                                                0x4
#define DMIF_CURSOR_CONTROL__PRIVILEGED_ACCESS_ENABLE__SHIFT                                                  0x8
#define DMIF_CURSOR_CONTROL__LOW_READ_URG_LEVEL__SHIFT                                                        0x10
#define DMIF_CURSOR_CONTROL__DMIF_CURSOR_MC_LATENCY_COUNTER_ENABLE__SHIFT                                     0x1e
#define DMIF_CURSOR_CONTROL__DMIF_CURSOR_MC_LATENCY_COUNTER_URGENT_ONLY__SHIFT                                0x1f
#define DMIF_CURSOR_CONTROL__ADDRESS_TRANSLATION_ENABLE_MASK                                                  0x00000010L
#define DMIF_CURSOR_CONTROL__PRIVILEGED_ACCESS_ENABLE_MASK                                                    0x00000100L
#define DMIF_CURSOR_CONTROL__LOW_READ_URG_LEVEL_MASK                                                          0x00FF0000L
#define DMIF_CURSOR_CONTROL__DMIF_CURSOR_MC_LATENCY_COUNTER_ENABLE_MASK                                       0x40000000L
#define DMIF_CURSOR_CONTROL__DMIF_CURSOR_MC_LATENCY_COUNTER_URGENT_ONLY_MASK                                  0x80000000L
//DMIF_CURSOR_MEM_CONTROL
#define DMIF_CURSOR_MEM_CONTROL__DMIF_CURSOR_MEM_CACHE_MODE_DIS__SHIFT                                        0x0
#define DMIF_CURSOR_MEM_CONTROL__DMIF_CURSOR_MEM_CACHE_MODE__SHIFT                                            0x4
#define DMIF_CURSOR_MEM_CONTROL__DMIF_CURSOR_MEM_CACHE_SIZE__SHIFT                                            0x8
#define DMIF_CURSOR_MEM_CONTROL__DMIF_CURSOR_MEM_CACHE_PIPE__SHIFT                                            0x10
#define DMIF_CURSOR_MEM_CONTROL__DMIF_CURSOR_MEM_CACHE_TYPE__SHIFT                                            0x13
#define DMIF_CURSOR_MEM_CONTROL__DMIF_CURSOR_MEM_CACHE_MODE_DIS_MASK                                          0x00000001L
#define DMIF_CURSOR_MEM_CONTROL__DMIF_CURSOR_MEM_CACHE_MODE_MASK                                              0x00000030L
#define DMIF_CURSOR_MEM_CONTROL__DMIF_CURSOR_MEM_CACHE_SIZE_MASK                                              0x0000FF00L
#define DMIF_CURSOR_MEM_CONTROL__DMIF_CURSOR_MEM_CACHE_PIPE_MASK                                              0x00070000L
#define DMIF_CURSOR_MEM_CONTROL__DMIF_CURSOR_MEM_CACHE_TYPE_MASK                                              0x00180000L
//DCHUB_FB_LOCATION
#define DCHUB_FB_LOCATION__FB_BASE__SHIFT                                                                     0x0
#define DCHUB_FB_LOCATION__FB_TOP__SHIFT                                                                      0x10
#define DCHUB_FB_LOCATION__FB_BASE_MASK                                                                       0x0000FFFFL
#define DCHUB_FB_LOCATION__FB_TOP_MASK                                                                        0xFFFF0000L
//DCHUB_FB_OFFSET
#define DCHUB_FB_OFFSET__FB_OFFSET__SHIFT                                                                     0x0
#define DCHUB_FB_OFFSET__FB_OFFSET_MASK                                                                       0x003FFFFFL
//DCHUB_AGP_BASE
#define DCHUB_AGP_BASE__AGP_BASE__SHIFT                                                                       0x0
#define DCHUB_AGP_BASE__AGP_BASE_MASK                                                                         0x003FFFFFL
//DCHUB_AGP_BOT
#define DCHUB_AGP_BOT__AGP_BOT__SHIFT                                                                         0x0
#define DCHUB_AGP_BOT__AGP_BOT_MASK                                                                           0x0003FFFFL
//DCHUB_AGP_TOP
#define DCHUB_AGP_TOP__AGP_TOP__SHIFT                                                                         0x0
#define DCHUB_AGP_TOP__AGP_TOP_MASK                                                                           0x0003FFFFL
//DCHUB_DRAM_APER_BASE
#define DCHUB_DRAM_APER_BASE__BASE__SHIFT                                                                     0x0
#define DCHUB_DRAM_APER_BASE__LOCK_DCHUB_DRAM_REGS__SHIFT                                                     0x1c
#define DCHUB_DRAM_APER_BASE__BASE_MASK                                                                       0x00FFFFFFL
#define DCHUB_DRAM_APER_BASE__LOCK_DCHUB_DRAM_REGS_MASK                                                       0x10000000L
//DCHUB_DRAM_APER_DEF
#define DCHUB_DRAM_APER_DEF__DEF__SHIFT                                                                       0x0
#define DCHUB_DRAM_APER_DEF__DEF_MASK                                                                         0xFFFFFFFFL
//DCHUB_DRAM_APER_TOP
#define DCHUB_DRAM_APER_TOP__TOP__SHIFT                                                                       0x0
#define DCHUB_DRAM_APER_TOP__TOP_MASK                                                                         0x00FFFFFFL
//DCHUB_CONTROL_STATUS
#define DCHUB_CONTROL_STATUS__NO_OUTSTANDING_REQ__SHIFT                                                       0x0
#define DCHUB_CONTROL_STATUS__SDP_PORT_STATUS__SHIFT                                                          0x4
#define DCHUB_CONTROL_STATUS__SDP_DATA_RESPONSE_STATUS__SHIFT                                                 0x6
#define DCHUB_CONTROL_STATUS__SDP_REQ_CREDIT_ERROR__SHIFT                                                     0x9
#define DCHUB_CONTROL_STATUS__SDP_DATA_RESPONSE_STATUS_CLEAR__SHIFT                                           0xc
#define DCHUB_CONTROL_STATUS__SDP_REQ_CREDIT_ERROR_CLEAR__SHIFT                                               0xd
#define DCHUB_CONTROL_STATUS__FLUSH_REQ_CREDIT_EN__SHIFT                                                      0x10
#define DCHUB_CONTROL_STATUS__REQ_CREDIT_EN__SHIFT                                                            0x11
#define DCHUB_CONTROL_STATUS__DCE_PORT_CONTROL__SHIFT                                                         0x12
#define DCHUB_CONTROL_STATUS__SDP_CREDIT_DISCONNECT_DELAY__SHIFT                                              0x14
#define DCHUB_CONTROL_STATUS__NO_OUTSTANDING_REQ_MASK                                                         0x00000001L
#define DCHUB_CONTROL_STATUS__SDP_PORT_STATUS_MASK                                                            0x00000030L
#define DCHUB_CONTROL_STATUS__SDP_DATA_RESPONSE_STATUS_MASK                                                   0x000001C0L
#define DCHUB_CONTROL_STATUS__SDP_REQ_CREDIT_ERROR_MASK                                                       0x00000200L
#define DCHUB_CONTROL_STATUS__SDP_DATA_RESPONSE_STATUS_CLEAR_MASK                                             0x00001000L
#define DCHUB_CONTROL_STATUS__SDP_REQ_CREDIT_ERROR_CLEAR_MASK                                                 0x00002000L
#define DCHUB_CONTROL_STATUS__FLUSH_REQ_CREDIT_EN_MASK                                                        0x00010000L
#define DCHUB_CONTROL_STATUS__REQ_CREDIT_EN_MASK                                                              0x00020000L
#define DCHUB_CONTROL_STATUS__DCE_PORT_CONTROL_MASK                                                           0x00040000L
#define DCHUB_CONTROL_STATUS__SDP_CREDIT_DISCONNECT_DELAY_MASK                                                0x03F00000L
//WB_ENABLE
#define WB_ENABLE__WB_ENABLE__SHIFT                                                                           0x0
#define WB_ENABLE__WB_ENABLE_MASK                                                                             0x00000001L
//WB_EC_CONFIG
#define WB_EC_CONFIG__DISPCLK_R_WB_GATE_DIS__SHIFT                                                            0x0
#define WB_EC_CONFIG__DISPCLK_G_WB_GATE_DIS__SHIFT                                                            0x1
#define WB_EC_CONFIG__DISPCLK_G_WBSCL_GATE_DIS__SHIFT                                                         0x2
#define WB_EC_CONFIG__WB_TEST_CLK_SEL__SHIFT                                                                  0x3
#define WB_EC_CONFIG__WB_LB_LS_DIS__SHIFT                                                                     0x7
#define WB_EC_CONFIG__WB_LB_SD_DIS__SHIFT                                                                     0x8
#define WB_EC_CONFIG__WB_LUT_LS_DIS__SHIFT                                                                    0x9
#define WB_EC_CONFIG__WBSCL_LB_MEM_PWR_MODE_SEL__SHIFT                                                        0xc
#define WB_EC_CONFIG__WBSCL_LB_MEM_PWR_DIS__SHIFT                                                             0xe
#define WB_EC_CONFIG__WBSCL_LB_MEM_PWR_FORCE__SHIFT                                                           0xf
#define WB_EC_CONFIG__WBSCL_LB_MEM_PWR_STATE_SM__SHIFT                                                        0x11
#define WB_EC_CONFIG__WBSCL_LB_MEM_PWR_STATE_BG__SHIFT                                                        0x13
#define WB_EC_CONFIG__WBSCL_LB_MEM_PWR_STATE__SHIFT                                                           0x15
#define WB_EC_CONFIG__WB_RAM_PW_SAVE_MODE__SHIFT                                                              0x17
#define WB_EC_CONFIG__LB_MEM_PWR_STATE_SM__SHIFT                                                              0x18
#define WB_EC_CONFIG__LB_MEM_PWR_STATE_BG__SHIFT                                                              0x1a
#define WB_EC_CONFIG__LB_MEM_PWR_STATE__SHIFT                                                                 0x1c
#define WB_EC_CONFIG__LUT_MEM_PWR_STATE__SHIFT                                                                0x1e
#define WB_EC_CONFIG__DISPCLK_R_WB_GATE_DIS_MASK                                                              0x00000001L
#define WB_EC_CONFIG__DISPCLK_G_WB_GATE_DIS_MASK                                                              0x00000002L
#define WB_EC_CONFIG__DISPCLK_G_WBSCL_GATE_DIS_MASK                                                           0x00000004L
#define WB_EC_CONFIG__WB_TEST_CLK_SEL_MASK                                                                    0x00000078L
#define WB_EC_CONFIG__WB_LB_LS_DIS_MASK                                                                       0x00000080L
#define WB_EC_CONFIG__WB_LB_SD_DIS_MASK                                                                       0x00000100L
#define WB_EC_CONFIG__WB_LUT_LS_DIS_MASK                                                                      0x00000200L
#define WB_EC_CONFIG__WBSCL_LB_MEM_PWR_MODE_SEL_MASK                                                          0x00003000L
#define WB_EC_CONFIG__WBSCL_LB_MEM_PWR_DIS_MASK                                                               0x00004000L
#define WB_EC_CONFIG__WBSCL_LB_MEM_PWR_FORCE_MASK                                                             0x00018000L
#define WB_EC_CONFIG__WBSCL_LB_MEM_PWR_STATE_SM_MASK                                                          0x00060000L
#define WB_EC_CONFIG__WBSCL_LB_MEM_PWR_STATE_BG_MASK                                                          0x00180000L
#define WB_EC_CONFIG__WBSCL_LB_MEM_PWR_STATE_MASK                                                             0x00600000L
#define WB_EC_CONFIG__WB_RAM_PW_SAVE_MODE_MASK                                                                0x00800000L
#define WB_EC_CONFIG__LB_MEM_PWR_STATE_SM_MASK                                                                0x03000000L
#define WB_EC_CONFIG__LB_MEM_PWR_STATE_BG_MASK                                                                0x0C000000L
#define WB_EC_CONFIG__LB_MEM_PWR_STATE_MASK                                                                   0x30000000L
#define WB_EC_CONFIG__LUT_MEM_PWR_STATE_MASK                                                                  0xC0000000L
//CNV_MODE
#define CNV_MODE__CNV_FRAME_CAPTURE_RATE__SHIFT                                                               0x8
#define CNV_MODE__CNV_WINDOW_CROP_EN__SHIFT                                                                   0xc
#define CNV_MODE__CNV_STEREO_TYPE__SHIFT                                                                      0xd
#define CNV_MODE__CNV_INTERLACED_MODE__SHIFT                                                                  0xf
#define CNV_MODE__CNV_EYE_SELECTION__SHIFT                                                                    0x10
#define CNV_MODE__CNV_STEREO_POLARITY__SHIFT                                                                  0x12
#define CNV_MODE__CNV_INTERLACED_FIELD_ORDER__SHIFT                                                           0x13
#define CNV_MODE__CNV_STEREO_SPLIT__SHIFT                                                                     0x14
#define CNV_MODE__CNV_NEW_CONTENT__SHIFT                                                                      0x18
#define CNV_MODE__CNV_FRAME_CAPTURE_EN__SHIFT                                                                 0x1f
#define CNV_MODE__CNV_FRAME_CAPTURE_RATE_MASK                                                                 0x00000300L
#define CNV_MODE__CNV_WINDOW_CROP_EN_MASK                                                                     0x00001000L
#define CNV_MODE__CNV_STEREO_TYPE_MASK                                                                        0x00006000L
#define CNV_MODE__CNV_INTERLACED_MODE_MASK                                                                    0x00008000L
#define CNV_MODE__CNV_EYE_SELECTION_MASK                                                                      0x00030000L
#define CNV_MODE__CNV_STEREO_POLARITY_MASK                                                                    0x00040000L
#define CNV_MODE__CNV_INTERLACED_FIELD_ORDER_MASK                                                             0x00080000L
#define CNV_MODE__CNV_STEREO_SPLIT_MASK                                                                       0x00100000L
#define CNV_MODE__CNV_NEW_CONTENT_MASK                                                                        0x01000000L
#define CNV_MODE__CNV_FRAME_CAPTURE_EN_MASK                                                                   0x80000000L
//CNV_WINDOW_START
#define CNV_WINDOW_START__CNV_WINDOW_START_X__SHIFT                                                           0x0
#define CNV_WINDOW_START__CNV_WINDOW_START_Y__SHIFT                                                           0x10
#define CNV_WINDOW_START__CNV_WINDOW_START_X_MASK                                                             0x00000FFFL
#define CNV_WINDOW_START__CNV_WINDOW_START_Y_MASK                                                             0x0FFF0000L
//CNV_WINDOW_SIZE
#define CNV_WINDOW_SIZE__CNV_WINDOW_WIDTH__SHIFT                                                              0x0
#define CNV_WINDOW_SIZE__CNV_WINDOW_HEIGHT__SHIFT                                                             0x10
#define CNV_WINDOW_SIZE__CNV_WINDOW_WIDTH_MASK                                                                0x00000FFFL
#define CNV_WINDOW_SIZE__CNV_WINDOW_HEIGHT_MASK                                                               0x0FFF0000L
//CNV_UPDATE
#define CNV_UPDATE__CNV_UPDATE_PENDING__SHIFT                                                                 0x0
#define CNV_UPDATE__CNV_UPDATE_TAKEN__SHIFT                                                                   0x8
#define CNV_UPDATE__CNV_UPDATE_LOCK__SHIFT                                                                    0x10
#define CNV_UPDATE__CNV_UPDATE_PENDING_MASK                                                                   0x00000001L
#define CNV_UPDATE__CNV_UPDATE_TAKEN_MASK                                                                     0x00000100L
#define CNV_UPDATE__CNV_UPDATE_LOCK_MASK                                                                      0x00010000L
//CNV_SOURCE_SIZE
#define CNV_SOURCE_SIZE__CNV_SOURCE_WIDTH__SHIFT                                                              0x0
#define CNV_SOURCE_SIZE__CNV_SOURCE_HEIGHT__SHIFT                                                             0x10
#define CNV_SOURCE_SIZE__CNV_SOURCE_WIDTH_MASK                                                                0x00007FFFL
#define CNV_SOURCE_SIZE__CNV_SOURCE_HEIGHT_MASK                                                               0x7FFF0000L
//CNV_CSC_CONTROL
#define CNV_CSC_CONTROL__CNV_CSC_BYPASS__SHIFT                                                                0x0
#define CNV_CSC_CONTROL__CNV_CSC_BYPASS_MASK                                                                  0x00000001L
//CNV_CSC_C11_C12
#define CNV_CSC_C11_C12__CNV_CSC_C11__SHIFT                                                                   0x0
#define CNV_CSC_C11_C12__CNV_CSC_C12__SHIFT                                                                   0x10
#define CNV_CSC_C11_C12__CNV_CSC_C11_MASK                                                                     0x00001FFFL
#define CNV_CSC_C11_C12__CNV_CSC_C12_MASK                                                                     0x1FFF0000L
//CNV_CSC_C13_C14
#define CNV_CSC_C13_C14__CNV_CSC_C13__SHIFT                                                                   0x0
#define CNV_CSC_C13_C14__CNV_CSC_C14__SHIFT                                                                   0x10
#define CNV_CSC_C13_C14__CNV_CSC_C13_MASK                                                                     0x00001FFFL
#define CNV_CSC_C13_C14__CNV_CSC_C14_MASK                                                                     0x7FFF0000L
//CNV_CSC_C21_C22
#define CNV_CSC_C21_C22__CNV_CSC_C21__SHIFT                                                                   0x0
#define CNV_CSC_C21_C22__CNV_CSC_C22__SHIFT                                                                   0x10
#define CNV_CSC_C21_C22__CNV_CSC_C21_MASK                                                                     0x00001FFFL
#define CNV_CSC_C21_C22__CNV_CSC_C22_MASK                                                                     0x1FFF0000L
//CNV_CSC_C23_C24
#define CNV_CSC_C23_C24__CNV_CSC_C23__SHIFT                                                                   0x0
#define CNV_CSC_C23_C24__CNV_CSC_C24__SHIFT                                                                   0x10
#define CNV_CSC_C23_C24__CNV_CSC_C23_MASK                                                                     0x00001FFFL
#define CNV_CSC_C23_C24__CNV_CSC_C24_MASK                                                                     0x7FFF0000L
//CNV_CSC_C31_C32
#define CNV_CSC_C31_C32__CNV_CSC_C31__SHIFT                                                                   0x0
#define CNV_CSC_C31_C32__CNV_CSC_C32__SHIFT                                                                   0x10
#define CNV_CSC_C31_C32__CNV_CSC_C31_MASK                                                                     0x00001FFFL
#define CNV_CSC_C31_C32__CNV_CSC_C32_MASK                                                                     0x1FFF0000L
//CNV_CSC_C33_C34
#define CNV_CSC_C33_C34__CNV_CSC_C33__SHIFT                                                                   0x0
#define CNV_CSC_C33_C34__CNV_CSC_C34__SHIFT                                                                   0x10
#define CNV_CSC_C33_C34__CNV_CSC_C33_MASK                                                                     0x00001FFFL
#define CNV_CSC_C33_C34__CNV_CSC_C34_MASK                                                                     0x7FFF0000L
//CNV_CSC_ROUND_OFFSET_R
#define CNV_CSC_ROUND_OFFSET_R__CNV_CSC_ROUND_OFFSET_R__SHIFT                                                 0x0
#define CNV_CSC_ROUND_OFFSET_R__CNV_CSC_ROUND_OFFSET_R_MASK                                                   0x0000FFFFL
//CNV_CSC_ROUND_OFFSET_G
#define CNV_CSC_ROUND_OFFSET_G__CNV_CSC_ROUND_OFFSET_G__SHIFT                                                 0x0
#define CNV_CSC_ROUND_OFFSET_G__CNV_CSC_ROUND_OFFSET_G_MASK                                                   0x0000FFFFL
//CNV_CSC_ROUND_OFFSET_B
#define CNV_CSC_ROUND_OFFSET_B__CNV_CSC_ROUND_OFFSET_B__SHIFT                                                 0x0
#define CNV_CSC_ROUND_OFFSET_B__CNV_CSC_ROUND_OFFSET_B_MASK                                                   0x0000FFFFL
//CNV_CSC_CLAMP_R
#define CNV_CSC_CLAMP_R__CNV_CSC_CLAMP_UPPER_R__SHIFT                                                         0x0
#define CNV_CSC_CLAMP_R__CNV_CSC_CLAMP_LOWER_R__SHIFT                                                         0x10
#define CNV_CSC_CLAMP_R__CNV_CSC_CLAMP_UPPER_R_MASK                                                           0x0000FFFFL
#define CNV_CSC_CLAMP_R__CNV_CSC_CLAMP_LOWER_R_MASK                                                           0xFFFF0000L
//CNV_CSC_CLAMP_G
#define CNV_CSC_CLAMP_G__CNV_CSC_CLAMP_UPPER_G__SHIFT                                                         0x0
#define CNV_CSC_CLAMP_G__CNV_CSC_CLAMP_LOWER_G__SHIFT                                                         0x10
#define CNV_CSC_CLAMP_G__CNV_CSC_CLAMP_UPPER_G_MASK                                                           0x0000FFFFL
#define CNV_CSC_CLAMP_G__CNV_CSC_CLAMP_LOWER_G_MASK                                                           0xFFFF0000L
//CNV_CSC_CLAMP_B
#define CNV_CSC_CLAMP_B__CNV_CSC_CLAMP_UPPER_B__SHIFT                                                         0x0
#define CNV_CSC_CLAMP_B__CNV_CSC_CLAMP_LOWER_B__SHIFT                                                         0x10
#define CNV_CSC_CLAMP_B__CNV_CSC_CLAMP_UPPER_B_MASK                                                           0x0000FFFFL
#define CNV_CSC_CLAMP_B__CNV_CSC_CLAMP_LOWER_B_MASK                                                           0xFFFF0000L
//CNV_TEST_CNTL
#define CNV_TEST_CNTL__CNV_TEST_CRC_EN__SHIFT                                                                 0x4
#define CNV_TEST_CNTL__CNV_TEST_CRC_CONT_EN__SHIFT                                                            0x8
#define CNV_TEST_CNTL__CNV_TEST_CRC_DE_ONLY__SHIFT                                                            0x10
#define CNV_TEST_CNTL__CNV_TEST_CRC_EN_MASK                                                                   0x00000010L
#define CNV_TEST_CNTL__CNV_TEST_CRC_CONT_EN_MASK                                                              0x00000100L
#define CNV_TEST_CNTL__CNV_TEST_CRC_DE_ONLY_MASK                                                              0x00010000L
//CNV_TEST_CRC_RED
#define CNV_TEST_CRC_RED__CNV_TEST_CRC_RED_MASK__SHIFT                                                        0x4
#define CNV_TEST_CRC_RED__CNV_TEST_CRC_SIG_RED__SHIFT                                                         0x10
#define CNV_TEST_CRC_RED__CNV_TEST_CRC_RED_MASK_MASK                                                          0x0000FFF0L
#define CNV_TEST_CRC_RED__CNV_TEST_CRC_SIG_RED_MASK                                                           0xFFFF0000L
//CNV_TEST_CRC_GREEN
#define CNV_TEST_CRC_GREEN__CNV_TEST_CRC_GREEN_MASK__SHIFT                                                    0x4
#define CNV_TEST_CRC_GREEN__CNV_TEST_CRC_SIG_GREEN__SHIFT                                                     0x10
#define CNV_TEST_CRC_GREEN__CNV_TEST_CRC_GREEN_MASK_MASK                                                      0x0000FFF0L
#define CNV_TEST_CRC_GREEN__CNV_TEST_CRC_SIG_GREEN_MASK                                                       0xFFFF0000L
//CNV_TEST_CRC_BLUE
#define CNV_TEST_CRC_BLUE__CNV_TEST_CRC_BLUE_MASK__SHIFT                                                      0x4
#define CNV_TEST_CRC_BLUE__CNV_TEST_CRC_SIG_BLUE__SHIFT                                                       0x10
#define CNV_TEST_CRC_BLUE__CNV_TEST_CRC_BLUE_MASK_MASK                                                        0x0000FFF0L
#define CNV_TEST_CRC_BLUE__CNV_TEST_CRC_SIG_BLUE_MASK                                                         0xFFFF0000L
//CNV_INPUT_SELECT
#define CNV_INPUT_SELECT__CNV_INPUT_SRC_SELECT__SHIFT                                                         0x0
#define CNV_INPUT_SELECT__CNV_INPUT_PIPE_SELECT__SHIFT                                                        0x2
#define CNV_INPUT_SELECT__CNV_INPUT_SRC_SELECT_MASK                                                           0x00000003L
#define CNV_INPUT_SELECT__CNV_INPUT_PIPE_SELECT_MASK                                                          0x0000001CL
//WB_SOFT_RESET
#define WB_SOFT_RESET__WB_SOFT_RESET__SHIFT                                                                   0x0
#define WB_SOFT_RESET__WB_SOFT_RESET_MASK                                                                     0x00000001L
//WB_WARM_UP_MODE_CTL1
#define WB_WARM_UP_MODE_CTL1__WIDTH_WARMUP__SHIFT                                                             0x0
#define WB_WARM_UP_MODE_CTL1__HEIGHT_WARMUP__SHIFT                                                            0x10
#define WB_WARM_UP_MODE_CTL1__GMC_WARM_UP_ENABLE__SHIFT                                                       0x1f
#define WB_WARM_UP_MODE_CTL1__WIDTH_WARMUP_MASK                                                               0x00007FFFL
#define WB_WARM_UP_MODE_CTL1__HEIGHT_WARMUP_MASK                                                              0x7FFF0000L
#define WB_WARM_UP_MODE_CTL1__GMC_WARM_UP_ENABLE_MASK                                                         0x80000000L
//WB_WARM_UP_MODE_CTL2
#define WB_WARM_UP_MODE_CTL2__DATA_VALUE_WARMUP__SHIFT                                                        0x0
#define WB_WARM_UP_MODE_CTL2__MODE_WARMUP__SHIFT                                                              0x8
#define WB_WARM_UP_MODE_CTL2__DATA_VALUE_WARMUP_MASK                                                          0x000000FFL
#define WB_WARM_UP_MODE_CTL2__MODE_WARMUP_MASK                                                                0x00000100L
//WBSCL_COEF_RAM_SELECT
#define WBSCL_COEF_RAM_SELECT__WBSCL_COEF_RAM_TAP_PAIR_IDX__SHIFT                                             0x0
#define WBSCL_COEF_RAM_SELECT__WBSCL_COEF_RAM_PHASE__SHIFT                                                    0x8
#define WBSCL_COEF_RAM_SELECT__WBSCL_COEF_RAM_FILTER_TYPE__SHIFT                                              0x10
#define WBSCL_COEF_RAM_SELECT__WBSCL_COEF_RAM_TAP_PAIR_IDX_MASK                                               0x00000007L
#define WBSCL_COEF_RAM_SELECT__WBSCL_COEF_RAM_PHASE_MASK                                                      0x00000F00L
#define WBSCL_COEF_RAM_SELECT__WBSCL_COEF_RAM_FILTER_TYPE_MASK                                                0x00030000L
//WBSCL_COEF_RAM_TAP_DATA
#define WBSCL_COEF_RAM_TAP_DATA__WBSCL_COEF_RAM_EVEN_TAP_COEF__SHIFT                                          0x0
#define WBSCL_COEF_RAM_TAP_DATA__WBSCL_COEF_RAM_EVEN_TAP_COEF_EN__SHIFT                                       0xf
#define WBSCL_COEF_RAM_TAP_DATA__WBSCL_COEF_RAM_ODD_TAP_COEF__SHIFT                                           0x10
#define WBSCL_COEF_RAM_TAP_DATA__WBSCL_COEF_RAM_ODD_TAP_COEF_EN__SHIFT                                        0x1f
#define WBSCL_COEF_RAM_TAP_DATA__WBSCL_COEF_RAM_EVEN_TAP_COEF_MASK                                            0x00003FFFL
#define WBSCL_COEF_RAM_TAP_DATA__WBSCL_COEF_RAM_EVEN_TAP_COEF_EN_MASK                                         0x00008000L
#define WBSCL_COEF_RAM_TAP_DATA__WBSCL_COEF_RAM_ODD_TAP_COEF_MASK                                             0x3FFF0000L
#define WBSCL_COEF_RAM_TAP_DATA__WBSCL_COEF_RAM_ODD_TAP_COEF_EN_MASK                                          0x80000000L
//WBSCL_MODE
#define WBSCL_MODE__WBSCL_MODE__SHIFT                                                                         0x0
#define WBSCL_MODE__WBSCL_MODE_MASK                                                                           0x00000003L
//WBSCL_TAP_CONTROL
#define WBSCL_TAP_CONTROL__WBSCL_V_NUM_OF_TAPS_Y_RGB__SHIFT                                                   0x0
#define WBSCL_TAP_CONTROL__WBSCL_V_NUM_OF_TAPS_CBCR__SHIFT                                                    0x4
#define WBSCL_TAP_CONTROL__WBSCL_H_NUM_OF_TAPS_Y_RGB__SHIFT                                                   0x8
#define WBSCL_TAP_CONTROL__WBSCL_H_NUM_OF_TAPS_CBCR__SHIFT                                                    0xc
#define WBSCL_TAP_CONTROL__WBSCL_V_NUM_OF_TAPS_Y_RGB_MASK                                                     0x0000000FL
#define WBSCL_TAP_CONTROL__WBSCL_V_NUM_OF_TAPS_CBCR_MASK                                                      0x000000F0L
#define WBSCL_TAP_CONTROL__WBSCL_H_NUM_OF_TAPS_Y_RGB_MASK                                                     0x00000F00L
#define WBSCL_TAP_CONTROL__WBSCL_H_NUM_OF_TAPS_CBCR_MASK                                                      0x0000F000L
//WBSCL_DEST_SIZE
#define WBSCL_DEST_SIZE__WBSCL_DEST_HEIGHT__SHIFT                                                             0x0
#define WBSCL_DEST_SIZE__WBSCL_DEST_WIDTH__SHIFT                                                              0x10
#define WBSCL_DEST_SIZE__WBSCL_DEST_HEIGHT_MASK                                                               0x00007FFFL
#define WBSCL_DEST_SIZE__WBSCL_DEST_WIDTH_MASK                                                                0x7FFF0000L
//WBSCL_HORZ_FILTER_SCALE_RATIO
#define WBSCL_HORZ_FILTER_SCALE_RATIO__WBSCL_H_SCALE_RATIO__SHIFT                                             0x0
#define WBSCL_HORZ_FILTER_SCALE_RATIO__WBSCL_H_SCALE_RATIO_MASK                                               0x07FFFFFFL
//WBSCL_HORZ_FILTER_INIT_Y_RGB
#define WBSCL_HORZ_FILTER_INIT_Y_RGB__WBSCL_H_INIT_FRAC_Y_RGB__SHIFT                                          0x0
#define WBSCL_HORZ_FILTER_INIT_Y_RGB__WBSCL_H_INIT_INT_Y_RGB__SHIFT                                           0x18
#define WBSCL_HORZ_FILTER_INIT_Y_RGB__WBSCL_H_INIT_FRAC_Y_RGB_MASK                                            0x00FFFFFFL
#define WBSCL_HORZ_FILTER_INIT_Y_RGB__WBSCL_H_INIT_INT_Y_RGB_MASK                                             0x1F000000L
//WBSCL_HORZ_FILTER_INIT_CBCR
#define WBSCL_HORZ_FILTER_INIT_CBCR__WBSCL_H_INIT_FRAC_CBCR__SHIFT                                            0x0
#define WBSCL_HORZ_FILTER_INIT_CBCR__WBSCL_H_INIT_INT_CBCR__SHIFT                                             0x18
#define WBSCL_HORZ_FILTER_INIT_CBCR__WBSCL_H_INIT_FRAC_CBCR_MASK                                              0x00FFFFFFL
#define WBSCL_HORZ_FILTER_INIT_CBCR__WBSCL_H_INIT_INT_CBCR_MASK                                               0x1F000000L
//WBSCL_VERT_FILTER_SCALE_RATIO
#define WBSCL_VERT_FILTER_SCALE_RATIO__WBSCL_V_SCALE_RATIO__SHIFT                                             0x0
#define WBSCL_VERT_FILTER_SCALE_RATIO__WBSCL_V_SCALE_RATIO_MASK                                               0x07FFFFFFL
//WBSCL_VERT_FILTER_INIT_Y_RGB
#define WBSCL_VERT_FILTER_INIT_Y_RGB__WBSCL_V_INIT_FRAC_Y_RGB__SHIFT                                          0x0
#define WBSCL_VERT_FILTER_INIT_Y_RGB__WBSCL_V_INIT_INT_Y_RGB__SHIFT                                           0x18
#define WBSCL_VERT_FILTER_INIT_Y_RGB__WBSCL_V_INIT_FRAC_Y_RGB_MASK                                            0x00FFFFFFL
#define WBSCL_VERT_FILTER_INIT_Y_RGB__WBSCL_V_INIT_INT_Y_RGB_MASK                                             0x1F000000L
//WBSCL_VERT_FILTER_INIT_CBCR
#define WBSCL_VERT_FILTER_INIT_CBCR__WBSCL_V_INIT_FRAC_CBCR__SHIFT                                            0x0
#define WBSCL_VERT_FILTER_INIT_CBCR__WBSCL_V_INIT_INT_CBCR__SHIFT                                             0x18
#define WBSCL_VERT_FILTER_INIT_CBCR__WBSCL_V_INIT_FRAC_CBCR_MASK                                              0x00FFFFFFL
#define WBSCL_VERT_FILTER_INIT_CBCR__WBSCL_V_INIT_INT_CBCR_MASK                                               0x1F000000L
//WBSCL_ROUND_OFFSET
#define WBSCL_ROUND_OFFSET__WBSCL_ROUND_OFFSET_Y_RGB__SHIFT                                                   0x0
#define WBSCL_ROUND_OFFSET__WBSCL_ROUND_OFFSET_CBCR__SHIFT                                                    0x10
#define WBSCL_ROUND_OFFSET__WBSCL_ROUND_OFFSET_Y_RGB_MASK                                                     0x0000FFFFL
#define WBSCL_ROUND_OFFSET__WBSCL_ROUND_OFFSET_CBCR_MASK                                                      0xFFFF0000L
//WBSCL_CLAMP
#define WBSCL_CLAMP__WBSCL_CLAMP_UPPER_Y_RGB__SHIFT                                                           0x0
#define WBSCL_CLAMP__WBSCL_CLAMP_LOWER_Y_RGB__SHIFT                                                           0x8
#define WBSCL_CLAMP__WBSCL_CLAMP_UPPER_CBCR__SHIFT                                                            0x10
#define WBSCL_CLAMP__WBSCL_CLAMP_LOWER_CBCR__SHIFT                                                            0x18
#define WBSCL_CLAMP__WBSCL_CLAMP_UPPER_Y_RGB_MASK                                                             0x000000FFL
#define WBSCL_CLAMP__WBSCL_CLAMP_LOWER_Y_RGB_MASK                                                             0x0000FF00L
#define WBSCL_CLAMP__WBSCL_CLAMP_UPPER_CBCR_MASK                                                              0x00FF0000L
#define WBSCL_CLAMP__WBSCL_CLAMP_LOWER_CBCR_MASK                                                              0xFF000000L
//WBSCL_OVERFLOW_STATUS
#define WBSCL_OVERFLOW_STATUS__WBSCL_DATA_OVERFLOW_FLAG__SHIFT                                                0x0
#define WBSCL_OVERFLOW_STATUS__WBSCL_DATA_OVERFLOW_ACK__SHIFT                                                 0x8
#define WBSCL_OVERFLOW_STATUS__WBSCL_DATA_OVERFLOW_MASK__SHIFT                                                0xc
#define WBSCL_OVERFLOW_STATUS__WBSCL_DATA_OVERFLOW_INT_STATUS__SHIFT                                          0x10
#define WBSCL_OVERFLOW_STATUS__WBSCL_DATA_OVERFLOW_INT_TYPE__SHIFT                                            0x14
#define WBSCL_OVERFLOW_STATUS__WBSCL_DATA_OVERFLOW_FLAG_MASK                                                  0x00000001L
#define WBSCL_OVERFLOW_STATUS__WBSCL_DATA_OVERFLOW_ACK_MASK                                                   0x00000100L
#define WBSCL_OVERFLOW_STATUS__WBSCL_DATA_OVERFLOW_MASK_MASK                                                  0x00001000L
#define WBSCL_OVERFLOW_STATUS__WBSCL_DATA_OVERFLOW_INT_STATUS_MASK                                            0x00010000L
#define WBSCL_OVERFLOW_STATUS__WBSCL_DATA_OVERFLOW_INT_TYPE_MASK                                              0x00100000L
//WBSCL_COEF_RAM_CONFLICT_STATUS
#define WBSCL_COEF_RAM_CONFLICT_STATUS__WBSCL_HOST_CONFLICT_FLAG__SHIFT                                       0x0
#define WBSCL_COEF_RAM_CONFLICT_STATUS__WBSCL_HOST_CONFLICT_ACK__SHIFT                                        0x8
#define WBSCL_COEF_RAM_CONFLICT_STATUS__WBSCL_HOST_CONFLICT_MASK__SHIFT                                       0xc
#define WBSCL_COEF_RAM_CONFLICT_STATUS__WBSCL_HOST_CONFLICT_INT_STATUS__SHIFT                                 0x10
#define WBSCL_COEF_RAM_CONFLICT_STATUS__WBSCL_HOST_CONFLICT_INT_TYPE__SHIFT                                   0x14
#define WBSCL_COEF_RAM_CONFLICT_STATUS__WBSCL_HOST_CONFLICT_FLAG_MASK                                         0x00000001L
#define WBSCL_COEF_RAM_CONFLICT_STATUS__WBSCL_HOST_CONFLICT_ACK_MASK                                          0x00000100L
#define WBSCL_COEF_RAM_CONFLICT_STATUS__WBSCL_HOST_CONFLICT_MASK_MASK                                         0x00001000L
#define WBSCL_COEF_RAM_CONFLICT_STATUS__WBSCL_HOST_CONFLICT_INT_STATUS_MASK                                   0x00010000L
#define WBSCL_COEF_RAM_CONFLICT_STATUS__WBSCL_HOST_CONFLICT_INT_TYPE_MASK                                     0x00100000L
//WBSCL_OUTSIDE_PIX_STRATEGY
#define WBSCL_OUTSIDE_PIX_STRATEGY__WBSCL_OUTSIDE_PIX_STRATEGY__SHIFT                                         0x0
#define WBSCL_OUTSIDE_PIX_STRATEGY__WBSCL_BLACK_COLOR_B_CB__SHIFT                                             0x8
#define WBSCL_OUTSIDE_PIX_STRATEGY__WBSCL_BLACK_COLOR_G_Y__SHIFT                                              0x10
#define WBSCL_OUTSIDE_PIX_STRATEGY__WBSCL_BLACK_COLOR_R_CR__SHIFT                                             0x18
#define WBSCL_OUTSIDE_PIX_STRATEGY__WBSCL_OUTSIDE_PIX_STRATEGY_MASK                                           0x00000001L
#define WBSCL_OUTSIDE_PIX_STRATEGY__WBSCL_BLACK_COLOR_B_CB_MASK                                               0x0000FF00L
#define WBSCL_OUTSIDE_PIX_STRATEGY__WBSCL_BLACK_COLOR_G_Y_MASK                                                0x00FF0000L
#define WBSCL_OUTSIDE_PIX_STRATEGY__WBSCL_BLACK_COLOR_R_CR_MASK                                               0xFF000000L
//WBSCL_TEST_CNTL
#define WBSCL_TEST_CNTL__WBSCL_TEST_CRC_EN__SHIFT                                                             0x4
#define WBSCL_TEST_CNTL__WBSCL_TEST_CRC_CONT_EN__SHIFT                                                        0x8
#define WBSCL_TEST_CNTL__WBSCL_TEST_CRC_DE_ONLY__SHIFT                                                        0x10
#define WBSCL_TEST_CNTL__WBSCL_TEST_CRC_EN_MASK                                                               0x00000010L
#define WBSCL_TEST_CNTL__WBSCL_TEST_CRC_CONT_EN_MASK                                                          0x00000100L
#define WBSCL_TEST_CNTL__WBSCL_TEST_CRC_DE_ONLY_MASK                                                          0x00010000L
//WBSCL_TEST_CRC_RED
#define WBSCL_TEST_CRC_RED__WBSCL_TEST_CRC_RED_MASK__SHIFT                                                    0x8
#define WBSCL_TEST_CRC_RED__WBSCL_TEST_CRC_SIG_RED__SHIFT                                                     0x10
#define WBSCL_TEST_CRC_RED__WBSCL_TEST_CRC_RED_MASK_MASK                                                      0x0000FF00L
#define WBSCL_TEST_CRC_RED__WBSCL_TEST_CRC_SIG_RED_MASK                                                       0xFFFF0000L
//WBSCL_TEST_CRC_GREEN
#define WBSCL_TEST_CRC_GREEN__WBSCL_TEST_CRC_GREEN_MASK__SHIFT                                                0x0
#define WBSCL_TEST_CRC_GREEN__WBSCL_TEST_CRC_SIG_GREEN__SHIFT                                                 0x10
#define WBSCL_TEST_CRC_GREEN__WBSCL_TEST_CRC_GREEN_MASK_MASK                                                  0x0000FFFFL
#define WBSCL_TEST_CRC_GREEN__WBSCL_TEST_CRC_SIG_GREEN_MASK                                                   0xFFFF0000L
//WBSCL_TEST_CRC_BLUE
#define WBSCL_TEST_CRC_BLUE__WBSCL_TEST_CRC_BLUE_MASK__SHIFT                                                  0x8
#define WBSCL_TEST_CRC_BLUE__WBSCL_TEST_CRC_SIG_BLUE__SHIFT                                                   0x10
#define WBSCL_TEST_CRC_BLUE__WBSCL_TEST_CRC_BLUE_MASK_MASK                                                    0x0000FF00L
#define WBSCL_TEST_CRC_BLUE__WBSCL_TEST_CRC_SIG_BLUE_MASK                                                     0xFFFF0000L
//WBSCL_BACKPRESSURE_CNT_EN
#define WBSCL_BACKPRESSURE_CNT_EN__WBSCL_BACKPRESSURE_CNT_EN__SHIFT                                           0x0
#define WBSCL_BACKPRESSURE_CNT_EN__WBSCL_BACKPRESSURE_CNT_EN_MASK                                             0x00000001L
//WB_MCIF_BACKPRESSURE_CNT
#define WB_MCIF_BACKPRESSURE_CNT__WB_MCIF_Y_MAX_BACKPRESSURE__SHIFT                                           0x0
#define WB_MCIF_BACKPRESSURE_CNT__WB_MCIF_C_MAX_BACKPRESSURE__SHIFT                                           0x10
#define WB_MCIF_BACKPRESSURE_CNT__WB_MCIF_Y_MAX_BACKPRESSURE_MASK                                             0x0000FFFFL
#define WB_MCIF_BACKPRESSURE_CNT__WB_MCIF_C_MAX_BACKPRESSURE_MASK                                             0xFFFF0000L
//WBSCL_RAM_SHUTDOWN
#define WBSCL_RAM_SHUTDOWN__WBSCL_RAM_SHUTDOWN_SEL__SHIFT                                                     0x0
#define WBSCL_RAM_SHUTDOWN__WBSCL_RAM_SHUTDOWN_SEL_MASK                                                       0x00000003L
//DMCU_CTRL
#define DMCU_CTRL__RESET_UC__SHIFT                                                                            0x0
#define DMCU_CTRL__IGNORE_PWRMGT__SHIFT                                                                       0x1
#define DMCU_CTRL__DISABLE_IRQ_TO_UC__SHIFT                                                                   0x2
#define DMCU_CTRL__DISABLE_XIRQ_TO_UC__SHIFT                                                                  0x3
#define DMCU_CTRL__DMCU_ENABLE__SHIFT                                                                         0x4
#define DMCU_CTRL__DMCU_DYN_CLK_GATING_EN__SHIFT                                                              0x8
#define DMCU_CTRL__UC_REG_RD_TIMEOUT__SHIFT                                                                   0x10
#define DMCU_CTRL__RESET_UC_MASK                                                                              0x00000001L
#define DMCU_CTRL__IGNORE_PWRMGT_MASK                                                                         0x00000002L
#define DMCU_CTRL__DISABLE_IRQ_TO_UC_MASK                                                                     0x00000004L
#define DMCU_CTRL__DISABLE_XIRQ_TO_UC_MASK                                                                    0x00000008L
#define DMCU_CTRL__DMCU_ENABLE_MASK                                                                           0x00000010L
#define DMCU_CTRL__DMCU_DYN_CLK_GATING_EN_MASK                                                                0x00000100L
#define DMCU_CTRL__UC_REG_RD_TIMEOUT_MASK                                                                     0xFFFF0000L
//DMCU_STATUS
#define DMCU_STATUS__UC_IN_RESET__SHIFT                                                                       0x0
#define DMCU_STATUS__UC_IN_WAIT_MODE__SHIFT                                                                   0x1
#define DMCU_STATUS__UC_IN_STOP_MODE__SHIFT                                                                   0x2
#define DMCU_STATUS__UC_IN_RESET_MASK                                                                         0x00000001L
#define DMCU_STATUS__UC_IN_WAIT_MODE_MASK                                                                     0x00000002L
#define DMCU_STATUS__UC_IN_STOP_MODE_MASK                                                                     0x00000004L
//DMCU_PC_START_ADDR
#define DMCU_PC_START_ADDR__PC_START_ADDR_LSB__SHIFT                                                          0x0
#define DMCU_PC_START_ADDR__PC_START_ADDR_MSB__SHIFT                                                          0x8
#define DMCU_PC_START_ADDR__PC_START_ADDR_LSB_MASK                                                            0x000000FFL
#define DMCU_PC_START_ADDR__PC_START_ADDR_MSB_MASK                                                            0x0000FF00L
//DMCU_FW_START_ADDR
#define DMCU_FW_START_ADDR__FW_START_ADDR_LSB__SHIFT                                                          0x0
#define DMCU_FW_START_ADDR__FW_START_ADDR_MSB__SHIFT                                                          0x8
#define DMCU_FW_START_ADDR__FW_START_ADDR_LSB_MASK                                                            0x000000FFL
#define DMCU_FW_START_ADDR__FW_START_ADDR_MSB_MASK                                                            0x0000FF00L
//DMCU_FW_END_ADDR
#define DMCU_FW_END_ADDR__FW_END_ADDR_LSB__SHIFT                                                              0x0
#define DMCU_FW_END_ADDR__FW_END_ADDR_MSB__SHIFT                                                              0x8
#define DMCU_FW_END_ADDR__FW_END_ADDR_LSB_MASK                                                                0x000000FFL
#define DMCU_FW_END_ADDR__FW_END_ADDR_MSB_MASK                                                                0x0000FF00L
//DMCU_FW_ISR_START_ADDR
#define DMCU_FW_ISR_START_ADDR__FW_ISR_START_ADDR_LSB__SHIFT                                                  0x0
#define DMCU_FW_ISR_START_ADDR__FW_ISR_START_ADDR_MSB__SHIFT                                                  0x8
#define DMCU_FW_ISR_START_ADDR__FW_ISR_START_ADDR_LSB_MASK                                                    0x000000FFL
#define DMCU_FW_ISR_START_ADDR__FW_ISR_START_ADDR_MSB_MASK                                                    0x0000FF00L
//DMCU_FW_CS_HI
#define DMCU_FW_CS_HI__FW_CHECKSUM_HI__SHIFT                                                                  0x0
#define DMCU_FW_CS_HI__FW_CHECKSUM_HI_MASK                                                                    0xFFFFFFFFL
//DMCU_FW_CS_LO
#define DMCU_FW_CS_LO__FW_CHECKSUM_LO__SHIFT                                                                  0x0
#define DMCU_FW_CS_LO__FW_CHECKSUM_LO_MASK                                                                    0xFFFFFFFFL
//DMCU_RAM_ACCESS_CTRL
#define DMCU_RAM_ACCESS_CTRL__ERAM_WR_ADDR_AUTO_INC__SHIFT                                                    0x0
#define DMCU_RAM_ACCESS_CTRL__ERAM_RD_ADDR_AUTO_INC__SHIFT                                                    0x1
#define DMCU_RAM_ACCESS_CTRL__IRAM_WR_ADDR_AUTO_INC__SHIFT                                                    0x2
#define DMCU_RAM_ACCESS_CTRL__IRAM_RD_ADDR_AUTO_INC__SHIFT                                                    0x3
#define DMCU_RAM_ACCESS_CTRL__ERAM_HOST_ACCESS_EN__SHIFT                                                      0x4
#define DMCU_RAM_ACCESS_CTRL__IRAM_HOST_ACCESS_EN__SHIFT                                                      0x5
#define DMCU_RAM_ACCESS_CTRL__ERAM_WR_ADDR_AUTO_INC_MASK                                                      0x00000001L
#define DMCU_RAM_ACCESS_CTRL__ERAM_RD_ADDR_AUTO_INC_MASK                                                      0x00000002L
#define DMCU_RAM_ACCESS_CTRL__IRAM_WR_ADDR_AUTO_INC_MASK                                                      0x00000004L
#define DMCU_RAM_ACCESS_CTRL__IRAM_RD_ADDR_AUTO_INC_MASK                                                      0x00000008L
#define DMCU_RAM_ACCESS_CTRL__ERAM_HOST_ACCESS_EN_MASK                                                        0x00000010L
#define DMCU_RAM_ACCESS_CTRL__IRAM_HOST_ACCESS_EN_MASK                                                        0x00000020L
//DMCU_ERAM_WR_CTRL
#define DMCU_ERAM_WR_CTRL__ERAM_WR_ADDR__SHIFT                                                                0x0
#define DMCU_ERAM_WR_CTRL__ERAM_WR_BE__SHIFT                                                                  0x10
#define DMCU_ERAM_WR_CTRL__ERAM_WR_BYTE_MODE__SHIFT                                                           0x14
#define DMCU_ERAM_WR_CTRL__ERAM_WR_ADDR_MASK                                                                  0x0000FFFFL
#define DMCU_ERAM_WR_CTRL__ERAM_WR_BE_MASK                                                                    0x000F0000L
#define DMCU_ERAM_WR_CTRL__ERAM_WR_BYTE_MODE_MASK                                                             0x00100000L
//DMCU_ERAM_WR_DATA
#define DMCU_ERAM_WR_DATA__ERAM_WR_DATA__SHIFT                                                                0x0
#define DMCU_ERAM_WR_DATA__ERAM_WR_DATA_MASK                                                                  0xFFFFFFFFL
//DMCU_ERAM_RD_CTRL
#define DMCU_ERAM_RD_CTRL__ERAM_RD_ADDR__SHIFT                                                                0x0
#define DMCU_ERAM_RD_CTRL__ERAM_RD_BE__SHIFT                                                                  0x10
#define DMCU_ERAM_RD_CTRL__ERAM_RD_BYTE_MODE__SHIFT                                                           0x14
#define DMCU_ERAM_RD_CTRL__ERAM_RD_ADDR_MASK                                                                  0x0000FFFFL
#define DMCU_ERAM_RD_CTRL__ERAM_RD_BE_MASK                                                                    0x000F0000L
#define DMCU_ERAM_RD_CTRL__ERAM_RD_BYTE_MODE_MASK                                                             0x00100000L
//DMCU_ERAM_RD_DATA
#define DMCU_ERAM_RD_DATA__ERAM_RD_DATA__SHIFT                                                                0x0
#define DMCU_ERAM_RD_DATA__ERAM_RD_DATA_MASK                                                                  0xFFFFFFFFL
//DMCU_IRAM_WR_CTRL
#define DMCU_IRAM_WR_CTRL__IRAM_WR_ADDR__SHIFT                                                                0x0
#define DMCU_IRAM_WR_CTRL__IRAM_WR_ADDR_MASK                                                                  0x000003FFL
//DMCU_IRAM_WR_DATA
#define DMCU_IRAM_WR_DATA__IRAM_WR_DATA__SHIFT                                                                0x0
#define DMCU_IRAM_WR_DATA__IRAM_WR_DATA_MASK                                                                  0x000000FFL
//DMCU_IRAM_RD_CTRL
#define DMCU_IRAM_RD_CTRL__IRAM_RD_ADDR__SHIFT                                                                0x0
#define DMCU_IRAM_RD_CTRL__IRAM_RD_ADDR_MASK                                                                  0x000003FFL
//DMCU_IRAM_RD_DATA
#define DMCU_IRAM_RD_DATA__IRAM_RD_DATA__SHIFT                                                                0x0
#define DMCU_IRAM_RD_DATA__IRAM_RD_DATA_MASK                                                                  0x000000FFL
//DMCU_EVENT_TRIGGER
#define DMCU_EVENT_TRIGGER__GEN_SW_INT_TO_UC__SHIFT                                                           0x0
#define DMCU_EVENT_TRIGGER__UC_INTERNAL_INT_CODE__SHIFT                                                       0x10
#define DMCU_EVENT_TRIGGER__GEN_UC_INTERNAL_INT_TO_HOST__SHIFT                                                0x17
#define DMCU_EVENT_TRIGGER__GEN_SW_INT_TO_UC_MASK                                                             0x00000001L
#define DMCU_EVENT_TRIGGER__UC_INTERNAL_INT_CODE_MASK                                                         0x007F0000L
#define DMCU_EVENT_TRIGGER__GEN_UC_INTERNAL_INT_TO_HOST_MASK                                                  0x00800000L
//DMCU_UC_INTERNAL_INT_STATUS
#define DMCU_UC_INTERNAL_INT_STATUS__UC_INT_IRQ_N_PIN__SHIFT                                                  0x0
#define DMCU_UC_INTERNAL_INT_STATUS__UC_INT_XIRQ_N_PIN__SHIFT                                                 0x1
#define DMCU_UC_INTERNAL_INT_STATUS__UC_INT_SOFTWARE_INTERRUPT__SHIFT                                         0x2
#define DMCU_UC_INTERNAL_INT_STATUS__UC_INT_ILLEGAL_OPCODE_TRAP__SHIFT                                        0x3
#define DMCU_UC_INTERNAL_INT_STATUS__UC_INT_TIMER_OUTPUT_COMPARE_4__SHIFT                                     0x4
#define DMCU_UC_INTERNAL_INT_STATUS__UC_INT_TIMER_OUTPUT_COMPARE_3__SHIFT                                     0x5
#define DMCU_UC_INTERNAL_INT_STATUS__UC_INT_TIMER_OUTPUT_COMPARE_2__SHIFT                                     0x6
#define DMCU_UC_INTERNAL_INT_STATUS__UC_INT_TIMER_OUTPUT_COMPARE_1__SHIFT                                     0x7
#define DMCU_UC_INTERNAL_INT_STATUS__UC_INT_TIMER_OVERFLOW__SHIFT                                             0x8
#define DMCU_UC_INTERNAL_INT_STATUS__UC_INT_REAL_TIME_INTERRUPT__SHIFT                                        0x9
#define DMCU_UC_INTERNAL_INT_STATUS__UC_INT_TIMER_INPUT_CAPTURE_4_OUTPUT_COMPARE_5__SHIFT                     0xa
#define DMCU_UC_INTERNAL_INT_STATUS__UC_INT_TIMER_INPUT_CAPTURE_3__SHIFT                                      0xb
#define DMCU_UC_INTERNAL_INT_STATUS__UC_INT_TIMER_INPUT_CAPTURE_2__SHIFT                                      0xc
#define DMCU_UC_INTERNAL_INT_STATUS__UC_INT_TIMER_INPUT_CAPTURE_1__SHIFT                                      0xd
#define DMCU_UC_INTERNAL_INT_STATUS__UC_INT_PULSE_ACCUMULATOR_INPUT_EDGE__SHIFT                               0xe
#define DMCU_UC_INTERNAL_INT_STATUS__UC_INT_PULSE_ACCUMULATOR_OVERFLOW__SHIFT                                 0xf
#define DMCU_UC_INTERNAL_INT_STATUS__UC_INT_IRQ_N_PIN_MASK                                                    0x00000001L
#define DMCU_UC_INTERNAL_INT_STATUS__UC_INT_XIRQ_N_PIN_MASK                                                   0x00000002L
#define DMCU_UC_INTERNAL_INT_STATUS__UC_INT_SOFTWARE_INTERRUPT_MASK                                           0x00000004L
#define DMCU_UC_INTERNAL_INT_STATUS__UC_INT_ILLEGAL_OPCODE_TRAP_MASK                                          0x00000008L
#define DMCU_UC_INTERNAL_INT_STATUS__UC_INT_TIMER_OUTPUT_COMPARE_4_MASK                                       0x00000010L
#define DMCU_UC_INTERNAL_INT_STATUS__UC_INT_TIMER_OUTPUT_COMPARE_3_MASK                                       0x00000020L
#define DMCU_UC_INTERNAL_INT_STATUS__UC_INT_TIMER_OUTPUT_COMPARE_2_MASK                                       0x00000040L
#define DMCU_UC_INTERNAL_INT_STATUS__UC_INT_TIMER_OUTPUT_COMPARE_1_MASK                                       0x00000080L
#define DMCU_UC_INTERNAL_INT_STATUS__UC_INT_TIMER_OVERFLOW_MASK                                               0x00000100L
#define DMCU_UC_INTERNAL_INT_STATUS__UC_INT_REAL_TIME_INTERRUPT_MASK                                          0x00000200L
#define DMCU_UC_INTERNAL_INT_STATUS__UC_INT_TIMER_INPUT_CAPTURE_4_OUTPUT_COMPARE_5_MASK                       0x00000400L
#define DMCU_UC_INTERNAL_INT_STATUS__UC_INT_TIMER_INPUT_CAPTURE_3_MASK                                        0x00000800L
#define DMCU_UC_INTERNAL_INT_STATUS__UC_INT_TIMER_INPUT_CAPTURE_2_MASK                                        0x00001000L
#define DMCU_UC_INTERNAL_INT_STATUS__UC_INT_TIMER_INPUT_CAPTURE_1_MASK                                        0x00002000L
#define DMCU_UC_INTERNAL_INT_STATUS__UC_INT_PULSE_ACCUMULATOR_INPUT_EDGE_MASK                                 0x00004000L
#define DMCU_UC_INTERNAL_INT_STATUS__UC_INT_PULSE_ACCUMULATOR_OVERFLOW_MASK                                   0x00008000L
//DMCU_SS_INTERRUPT_CNTL_STATUS
#define DMCU_SS_INTERRUPT_CNTL_STATUS__STATIC_SCREEN1_INT_STATUS__SHIFT                                       0xd
#define DMCU_SS_INTERRUPT_CNTL_STATUS__STATIC_SCREEN1_INT_OCCURRED__SHIFT                                     0xe
#define DMCU_SS_INTERRUPT_CNTL_STATUS__STATIC_SCREEN1_INT_CLEAR__SHIFT                                        0xe
#define DMCU_SS_INTERRUPT_CNTL_STATUS__STATIC_SCREEN2_INT_STATUS__SHIFT                                       0xf
#define DMCU_SS_INTERRUPT_CNTL_STATUS__STATIC_SCREEN2_INT_OCCURRED__SHIFT                                     0x10
#define DMCU_SS_INTERRUPT_CNTL_STATUS__STATIC_SCREEN2_INT_CLEAR__SHIFT                                        0x10
#define DMCU_SS_INTERRUPT_CNTL_STATUS__STATIC_SCREEN3_INT_STATUS__SHIFT                                       0x11
#define DMCU_SS_INTERRUPT_CNTL_STATUS__STATIC_SCREEN3_INT_OCCURRED__SHIFT                                     0x12
#define DMCU_SS_INTERRUPT_CNTL_STATUS__STATIC_SCREEN3_INT_CLEAR__SHIFT                                        0x12
#define DMCU_SS_INTERRUPT_CNTL_STATUS__STATIC_SCREEN4_INT_STATUS__SHIFT                                       0x13
#define DMCU_SS_INTERRUPT_CNTL_STATUS__STATIC_SCREEN4_INT_OCCURRED__SHIFT                                     0x14
#define DMCU_SS_INTERRUPT_CNTL_STATUS__STATIC_SCREEN4_INT_CLEAR__SHIFT                                        0x14
#define DMCU_SS_INTERRUPT_CNTL_STATUS__STATIC_SCREEN5_INT_STATUS__SHIFT                                       0x15
#define DMCU_SS_INTERRUPT_CNTL_STATUS__STATIC_SCREEN5_INT_OCCURRED__SHIFT                                     0x16
#define DMCU_SS_INTERRUPT_CNTL_STATUS__STATIC_SCREEN5_INT_CLEAR__SHIFT                                        0x16
#define DMCU_SS_INTERRUPT_CNTL_STATUS__STATIC_SCREEN6_INT_STATUS__SHIFT                                       0x17
#define DMCU_SS_INTERRUPT_CNTL_STATUS__STATIC_SCREEN6_INT_OCCURRED__SHIFT                                     0x18
#define DMCU_SS_INTERRUPT_CNTL_STATUS__STATIC_SCREEN6_INT_CLEAR__SHIFT                                        0x18
#define DMCU_SS_INTERRUPT_CNTL_STATUS__STATIC_SCREEN1_INT_STATUS_MASK                                         0x00002000L
#define DMCU_SS_INTERRUPT_CNTL_STATUS__STATIC_SCREEN1_INT_OCCURRED_MASK                                       0x00004000L
#define DMCU_SS_INTERRUPT_CNTL_STATUS__STATIC_SCREEN1_INT_CLEAR_MASK                                          0x00004000L
#define DMCU_SS_INTERRUPT_CNTL_STATUS__STATIC_SCREEN2_INT_STATUS_MASK                                         0x00008000L
#define DMCU_SS_INTERRUPT_CNTL_STATUS__STATIC_SCREEN2_INT_OCCURRED_MASK                                       0x00010000L
#define DMCU_SS_INTERRUPT_CNTL_STATUS__STATIC_SCREEN2_INT_CLEAR_MASK                                          0x00010000L
#define DMCU_SS_INTERRUPT_CNTL_STATUS__STATIC_SCREEN3_INT_STATUS_MASK                                         0x00020000L
#define DMCU_SS_INTERRUPT_CNTL_STATUS__STATIC_SCREEN3_INT_OCCURRED_MASK                                       0x00040000L
#define DMCU_SS_INTERRUPT_CNTL_STATUS__STATIC_SCREEN3_INT_CLEAR_MASK                                          0x00040000L
#define DMCU_SS_INTERRUPT_CNTL_STATUS__STATIC_SCREEN4_INT_STATUS_MASK                                         0x00080000L
#define DMCU_SS_INTERRUPT_CNTL_STATUS__STATIC_SCREEN4_INT_OCCURRED_MASK                                       0x00100000L
#define DMCU_SS_INTERRUPT_CNTL_STATUS__STATIC_SCREEN4_INT_CLEAR_MASK                                          0x00100000L
#define DMCU_SS_INTERRUPT_CNTL_STATUS__STATIC_SCREEN5_INT_STATUS_MASK                                         0x00200000L
#define DMCU_SS_INTERRUPT_CNTL_STATUS__STATIC_SCREEN5_INT_OCCURRED_MASK                                       0x00400000L
#define DMCU_SS_INTERRUPT_CNTL_STATUS__STATIC_SCREEN5_INT_CLEAR_MASK                                          0x00400000L
#define DMCU_SS_INTERRUPT_CNTL_STATUS__STATIC_SCREEN6_INT_STATUS_MASK                                         0x00800000L
#define DMCU_SS_INTERRUPT_CNTL_STATUS__STATIC_SCREEN6_INT_OCCURRED_MASK                                       0x01000000L
#define DMCU_SS_INTERRUPT_CNTL_STATUS__STATIC_SCREEN6_INT_CLEAR_MASK                                          0x01000000L
//DMCU_INTERRUPT_STATUS
#define DMCU_INTERRUPT_STATUS__ABM1_HG_READY_INT_OCCURRED__SHIFT                                              0x0
#define DMCU_INTERRUPT_STATUS__ABM1_HG_READY_INT_CLEAR__SHIFT                                                 0x0
#define DMCU_INTERRUPT_STATUS__ABM1_LS_READY_INT_OCCURRED__SHIFT                                              0x1
#define DMCU_INTERRUPT_STATUS__ABM1_LS_READY_INT_CLEAR__SHIFT                                                 0x1
#define DMCU_INTERRUPT_STATUS__ABM1_BL_UPDATE_INT_OCCURRED__SHIFT                                             0x2
#define DMCU_INTERRUPT_STATUS__ABM1_BL_UPDATE_INT_CLEAR__SHIFT                                                0x2
#define DMCU_INTERRUPT_STATUS__MCP_INT_OCCURRED__SHIFT                                                        0x3
#define DMCU_INTERRUPT_STATUS__DCPG_IHC_DSI_POWER_UP_INT_OCCURRED__SHIFT                                      0x4
#define DMCU_INTERRUPT_STATUS__DCPG_IHC_DSI_POWER_UP_INT_CLEAR__SHIFT                                         0x4
#define DMCU_INTERRUPT_STATUS__DCPG_IHC_DSI_POWER_DOWN_INT_OCCURRED__SHIFT                                    0x5
#define DMCU_INTERRUPT_STATUS__DCPG_IHC_DSI_POWER_DOWN_INT_CLEAR__SHIFT                                       0x5
#define DMCU_INTERRUPT_STATUS__EXTERNAL_SW_INT_OCCURRED__SHIFT                                                0x8
#define DMCU_INTERRUPT_STATUS__EXTERNAL_SW_INT_CLEAR__SHIFT                                                   0x8
#define DMCU_INTERRUPT_STATUS__SCP_INT_OCCURRED__SHIFT                                                        0x9
#define DMCU_INTERRUPT_STATUS__UC_INTERNAL_INT_OCCURRED__SHIFT                                                0xa
#define DMCU_INTERRUPT_STATUS__UC_INTERNAL_INT_CLEAR__SHIFT                                                   0xa
#define DMCU_INTERRUPT_STATUS__UC_REG_RD_TIMEOUT_INT_OCCURRED__SHIFT                                          0xb
#define DMCU_INTERRUPT_STATUS__UC_REG_RD_TIMEOUT_INT_CLEAR__SHIFT                                             0xb
#define DMCU_INTERRUPT_STATUS__DCPG_IHC_DCFE0_POWER_UP_INT_OCCURRED__SHIFT                                    0xc
#define DMCU_INTERRUPT_STATUS__DCPG_IHC_DCFE0_POWER_UP_INT_CLEAR__SHIFT                                       0xc
#define DMCU_INTERRUPT_STATUS__DCPG_IHC_DCFE1_POWER_UP_INT_OCCURRED__SHIFT                                    0xd
#define DMCU_INTERRUPT_STATUS__DCPG_IHC_DCFE1_POWER_UP_INT_CLEAR__SHIFT                                       0xd
#define DMCU_INTERRUPT_STATUS__DCPG_IHC_DCFE2_POWER_UP_INT_OCCURRED__SHIFT                                    0xe
#define DMCU_INTERRUPT_STATUS__DCPG_IHC_DCFE2_POWER_UP_INT_CLEAR__SHIFT                                       0xe
#define DMCU_INTERRUPT_STATUS__DCPG_IHC_DCFE3_POWER_UP_INT_OCCURRED__SHIFT                                    0xf
#define DMCU_INTERRUPT_STATUS__DCPG_IHC_DCFE3_POWER_UP_INT_CLEAR__SHIFT                                       0xf
#define DMCU_INTERRUPT_STATUS__DCPG_IHC_DCFE4_POWER_UP_INT_OCCURRED__SHIFT                                    0x10
#define DMCU_INTERRUPT_STATUS__DCPG_IHC_DCFE4_POWER_UP_INT_CLEAR__SHIFT                                       0x10
#define DMCU_INTERRUPT_STATUS__DCPG_IHC_DCFE5_POWER_UP_INT_OCCURRED__SHIFT                                    0x11
#define DMCU_INTERRUPT_STATUS__DCPG_IHC_DCFE5_POWER_UP_INT_CLEAR__SHIFT                                       0x11
#define DMCU_INTERRUPT_STATUS__DCPG_IHC_DCFE0_POWER_DOWN_INT_OCCURRED__SHIFT                                  0x12
#define DMCU_INTERRUPT_STATUS__DCPG_IHC_DCFE0_POWER_DOWN_INT_CLEAR__SHIFT                                     0x12
#define DMCU_INTERRUPT_STATUS__DCPG_IHC_DCFE1_POWER_DOWN_INT_OCCURRED__SHIFT                                  0x13
#define DMCU_INTERRUPT_STATUS__DCPG_IHC_DCFE1_POWER_DOWN_INT_CLEAR__SHIFT                                     0x13
#define DMCU_INTERRUPT_STATUS__DCPG_IHC_DCFE2_POWER_DOWN_INT_OCCURRED__SHIFT                                  0x14
#define DMCU_INTERRUPT_STATUS__DCPG_IHC_DCFE2_POWER_DOWN_INT_CLEAR__SHIFT                                     0x14
#define DMCU_INTERRUPT_STATUS__DCPG_IHC_DCFE3_POWER_DOWN_INT_OCCURRED__SHIFT                                  0x15
#define DMCU_INTERRUPT_STATUS__DCPG_IHC_DCFE3_POWER_DOWN_INT_CLEAR__SHIFT                                     0x15
#define DMCU_INTERRUPT_STATUS__DCPG_IHC_DCFE4_POWER_DOWN_INT_OCCURRED__SHIFT                                  0x16
#define DMCU_INTERRUPT_STATUS__DCPG_IHC_DCFE4_POWER_DOWN_INT_CLEAR__SHIFT                                     0x16
#define DMCU_INTERRUPT_STATUS__DCPG_IHC_DCFE5_POWER_DOWN_INT_OCCURRED__SHIFT                                  0x17
#define DMCU_INTERRUPT_STATUS__DCPG_IHC_DCFE5_POWER_DOWN_INT_CLEAR__SHIFT                                     0x17
#define DMCU_INTERRUPT_STATUS__VBLANK1_INT_OCCURRED__SHIFT                                                    0x18
#define DMCU_INTERRUPT_STATUS__VBLANK1_INT_CLEAR__SHIFT                                                       0x18
#define DMCU_INTERRUPT_STATUS__VBLANK2_INT_OCCURRED__SHIFT                                                    0x19
#define DMCU_INTERRUPT_STATUS__VBLANK2_INT_CLEAR__SHIFT                                                       0x19
#define DMCU_INTERRUPT_STATUS__VBLANK3_INT_OCCURRED__SHIFT                                                    0x1a
#define DMCU_INTERRUPT_STATUS__VBLANK3_INT_CLEAR__SHIFT                                                       0x1a
#define DMCU_INTERRUPT_STATUS__VBLANK4_INT_OCCURRED__SHIFT                                                    0x1b
#define DMCU_INTERRUPT_STATUS__VBLANK4_INT_CLEAR__SHIFT                                                       0x1b
#define DMCU_INTERRUPT_STATUS__VBLANK5_INT_OCCURRED__SHIFT                                                    0x1c
#define DMCU_INTERRUPT_STATUS__VBLANK5_INT_CLEAR__SHIFT                                                       0x1c
#define DMCU_INTERRUPT_STATUS__VBLANK6_INT_OCCURRED__SHIFT                                                    0x1d
#define DMCU_INTERRUPT_STATUS__VBLANK6_INT_CLEAR__SHIFT                                                       0x1d
#define DMCU_INTERRUPT_STATUS__ABM1_HG_READY_INT_OCCURRED_MASK                                                0x00000001L
#define DMCU_INTERRUPT_STATUS__ABM1_HG_READY_INT_CLEAR_MASK                                                   0x00000001L
#define DMCU_INTERRUPT_STATUS__ABM1_LS_READY_INT_OCCURRED_MASK                                                0x00000002L
#define DMCU_INTERRUPT_STATUS__ABM1_LS_READY_INT_CLEAR_MASK                                                   0x00000002L
#define DMCU_INTERRUPT_STATUS__ABM1_BL_UPDATE_INT_OCCURRED_MASK                                               0x00000004L
#define DMCU_INTERRUPT_STATUS__ABM1_BL_UPDATE_INT_CLEAR_MASK                                                  0x00000004L
#define DMCU_INTERRUPT_STATUS__MCP_INT_OCCURRED_MASK                                                          0x00000008L
#define DMCU_INTERRUPT_STATUS__DCPG_IHC_DSI_POWER_UP_INT_OCCURRED_MASK                                        0x00000010L
#define DMCU_INTERRUPT_STATUS__DCPG_IHC_DSI_POWER_UP_INT_CLEAR_MASK                                           0x00000010L
#define DMCU_INTERRUPT_STATUS__DCPG_IHC_DSI_POWER_DOWN_INT_OCCURRED_MASK                                      0x00000020L
#define DMCU_INTERRUPT_STATUS__DCPG_IHC_DSI_POWER_DOWN_INT_CLEAR_MASK                                         0x00000020L
#define DMCU_INTERRUPT_STATUS__EXTERNAL_SW_INT_OCCURRED_MASK                                                  0x00000100L
#define DMCU_INTERRUPT_STATUS__EXTERNAL_SW_INT_CLEAR_MASK                                                     0x00000100L
#define DMCU_INTERRUPT_STATUS__SCP_INT_OCCURRED_MASK                                                          0x00000200L
#define DMCU_INTERRUPT_STATUS__UC_INTERNAL_INT_OCCURRED_MASK                                                  0x00000400L
#define DMCU_INTERRUPT_STATUS__UC_INTERNAL_INT_CLEAR_MASK                                                     0x00000400L
#define DMCU_INTERRUPT_STATUS__UC_REG_RD_TIMEOUT_INT_OCCURRED_MASK                                            0x00000800L
#define DMCU_INTERRUPT_STATUS__UC_REG_RD_TIMEOUT_INT_CLEAR_MASK                                               0x00000800L
#define DMCU_INTERRUPT_STATUS__DCPG_IHC_DCFE0_POWER_UP_INT_OCCURRED_MASK                                      0x00001000L
#define DMCU_INTERRUPT_STATUS__DCPG_IHC_DCFE0_POWER_UP_INT_CLEAR_MASK                                         0x00001000L
#define DMCU_INTERRUPT_STATUS__DCPG_IHC_DCFE1_POWER_UP_INT_OCCURRED_MASK                                      0x00002000L
#define DMCU_INTERRUPT_STATUS__DCPG_IHC_DCFE1_POWER_UP_INT_CLEAR_MASK                                         0x00002000L
#define DMCU_INTERRUPT_STATUS__DCPG_IHC_DCFE2_POWER_UP_INT_OCCURRED_MASK                                      0x00004000L
#define DMCU_INTERRUPT_STATUS__DCPG_IHC_DCFE2_POWER_UP_INT_CLEAR_MASK                                         0x00004000L
#define DMCU_INTERRUPT_STATUS__DCPG_IHC_DCFE3_POWER_UP_INT_OCCURRED_MASK                                      0x00008000L
#define DMCU_INTERRUPT_STATUS__DCPG_IHC_DCFE3_POWER_UP_INT_CLEAR_MASK                                         0x00008000L
#define DMCU_INTERRUPT_STATUS__DCPG_IHC_DCFE4_POWER_UP_INT_OCCURRED_MASK                                      0x00010000L
#define DMCU_INTERRUPT_STATUS__DCPG_IHC_DCFE4_POWER_UP_INT_CLEAR_MASK                                         0x00010000L
#define DMCU_INTERRUPT_STATUS__DCPG_IHC_DCFE5_POWER_UP_INT_OCCURRED_MASK                                      0x00020000L
#define DMCU_INTERRUPT_STATUS__DCPG_IHC_DCFE5_POWER_UP_INT_CLEAR_MASK                                         0x00020000L
#define DMCU_INTERRUPT_STATUS__DCPG_IHC_DCFE0_POWER_DOWN_INT_OCCURRED_MASK                                    0x00040000L
#define DMCU_INTERRUPT_STATUS__DCPG_IHC_DCFE0_POWER_DOWN_INT_CLEAR_MASK                                       0x00040000L
#define DMCU_INTERRUPT_STATUS__DCPG_IHC_DCFE1_POWER_DOWN_INT_OCCURRED_MASK                                    0x00080000L
#define DMCU_INTERRUPT_STATUS__DCPG_IHC_DCFE1_POWER_DOWN_INT_CLEAR_MASK                                       0x00080000L
#define DMCU_INTERRUPT_STATUS__DCPG_IHC_DCFE2_POWER_DOWN_INT_OCCURRED_MASK                                    0x00100000L
#define DMCU_INTERRUPT_STATUS__DCPG_IHC_DCFE2_POWER_DOWN_INT_CLEAR_MASK                                       0x00100000L
#define DMCU_INTERRUPT_STATUS__DCPG_IHC_DCFE3_POWER_DOWN_INT_OCCURRED_MASK                                    0x00200000L
#define DMCU_INTERRUPT_STATUS__DCPG_IHC_DCFE3_POWER_DOWN_INT_CLEAR_MASK                                       0x00200000L
#define DMCU_INTERRUPT_STATUS__DCPG_IHC_DCFE4_POWER_DOWN_INT_OCCURRED_MASK                                    0x00400000L
#define DMCU_INTERRUPT_STATUS__DCPG_IHC_DCFE4_POWER_DOWN_INT_CLEAR_MASK                                       0x00400000L
#define DMCU_INTERRUPT_STATUS__DCPG_IHC_DCFE5_POWER_DOWN_INT_OCCURRED_MASK                                    0x00800000L
#define DMCU_INTERRUPT_STATUS__DCPG_IHC_DCFE5_POWER_DOWN_INT_CLEAR_MASK                                       0x00800000L
#define DMCU_INTERRUPT_STATUS__VBLANK1_INT_OCCURRED_MASK                                                      0x01000000L
#define DMCU_INTERRUPT_STATUS__VBLANK1_INT_CLEAR_MASK                                                         0x01000000L
#define DMCU_INTERRUPT_STATUS__VBLANK2_INT_OCCURRED_MASK                                                      0x02000000L
#define DMCU_INTERRUPT_STATUS__VBLANK2_INT_CLEAR_MASK                                                         0x02000000L
#define DMCU_INTERRUPT_STATUS__VBLANK3_INT_OCCURRED_MASK                                                      0x04000000L
#define DMCU_INTERRUPT_STATUS__VBLANK3_INT_CLEAR_MASK                                                         0x04000000L
#define DMCU_INTERRUPT_STATUS__VBLANK4_INT_OCCURRED_MASK                                                      0x08000000L
#define DMCU_INTERRUPT_STATUS__VBLANK4_INT_CLEAR_MASK                                                         0x08000000L
#define DMCU_INTERRUPT_STATUS__VBLANK5_INT_OCCURRED_MASK                                                      0x10000000L
#define DMCU_INTERRUPT_STATUS__VBLANK5_INT_CLEAR_MASK                                                         0x10000000L
#define DMCU_INTERRUPT_STATUS__VBLANK6_INT_OCCURRED_MASK                                                      0x20000000L
#define DMCU_INTERRUPT_STATUS__VBLANK6_INT_CLEAR_MASK                                                         0x20000000L
//DMCU_INTERRUPT_TO_HOST_EN_MASK
#define DMCU_INTERRUPT_TO_HOST_EN_MASK__ABM1_HG_READY_INT_MASK__SHIFT                                         0x0
#define DMCU_INTERRUPT_TO_HOST_EN_MASK__ABM1_LS_READY_INT_MASK__SHIFT                                         0x1
#define DMCU_INTERRUPT_TO_HOST_EN_MASK__ABM1_BL_UPDATE_INT_MASK__SHIFT                                        0x2
#define DMCU_INTERRUPT_TO_HOST_EN_MASK__SCP_INT_MASK__SHIFT                                                   0x9
#define DMCU_INTERRUPT_TO_HOST_EN_MASK__UC_INTERNAL_INT_MASK__SHIFT                                           0xa
#define DMCU_INTERRUPT_TO_HOST_EN_MASK__UC_REG_RD_TIMEOUT_INT_MASK__SHIFT                                     0xb
#define DMCU_INTERRUPT_TO_HOST_EN_MASK__ABM1_HG_READY_INT_MASK_MASK                                           0x00000001L
#define DMCU_INTERRUPT_TO_HOST_EN_MASK__ABM1_LS_READY_INT_MASK_MASK                                           0x00000002L
#define DMCU_INTERRUPT_TO_HOST_EN_MASK__ABM1_BL_UPDATE_INT_MASK_MASK                                          0x00000004L
#define DMCU_INTERRUPT_TO_HOST_EN_MASK__SCP_INT_MASK_MASK                                                     0x00000200L
#define DMCU_INTERRUPT_TO_HOST_EN_MASK__UC_INTERNAL_INT_MASK_MASK                                             0x00000400L
#define DMCU_INTERRUPT_TO_HOST_EN_MASK__UC_REG_RD_TIMEOUT_INT_MASK_MASK                                       0x00000800L
//DMCU_INTERRUPT_TO_UC_EN_MASK
#define DMCU_INTERRUPT_TO_UC_EN_MASK__ABM1_HG_READY_INT_TO_UC_EN__SHIFT                                       0x0
#define DMCU_INTERRUPT_TO_UC_EN_MASK__ABM1_LS_READY_INT_TO_UC_EN__SHIFT                                       0x1
#define DMCU_INTERRUPT_TO_UC_EN_MASK__ABM1_BL_UPDATE_INT_TO_UC_EN__SHIFT                                      0x2
#define DMCU_INTERRUPT_TO_UC_EN_MASK__MCP_INT_TO_UC_EN__SHIFT                                                 0x3
#define DMCU_INTERRUPT_TO_UC_EN_MASK__DCPG_IHC_DSI_POWER_UP_INT_TO_UC_EN__SHIFT                               0x4
#define DMCU_INTERRUPT_TO_UC_EN_MASK__DCPG_IHC_DSI_POWER_DOWN_INT_TO_UC_EN__SHIFT                             0x5
#define DMCU_INTERRUPT_TO_UC_EN_MASK__STATIC_SCREEN1_INT_TO_UC_EN__SHIFT                                      0x6
#define DMCU_INTERRUPT_TO_UC_EN_MASK__STATIC_SCREEN2_INT_TO_UC_EN__SHIFT                                      0x7
#define DMCU_INTERRUPT_TO_UC_EN_MASK__EXTERNAL_SW_INT_TO_UC_EN__SHIFT                                         0x8
#define DMCU_INTERRUPT_TO_UC_EN_MASK__STATIC_SCREEN3_INT_TO_UC_EN__SHIFT                                      0x9
#define DMCU_INTERRUPT_TO_UC_EN_MASK__STATIC_SCREEN4_INT_TO_UC_EN__SHIFT                                      0xa
#define DMCU_INTERRUPT_TO_UC_EN_MASK__STATIC_SCREEN5_INT_TO_UC_EN__SHIFT                                      0xb
#define DMCU_INTERRUPT_TO_UC_EN_MASK__DCPG_IHC_DCFE0_POWER_UP_INT_TO_UC_EN__SHIFT                             0xc
#define DMCU_INTERRUPT_TO_UC_EN_MASK__DCPG_IHC_DCFE1_POWER_UP_INT_TO_UC_EN__SHIFT                             0xd
#define DMCU_INTERRUPT_TO_UC_EN_MASK__DCPG_IHC_DCFE2_POWER_UP_INT_TO_UC_EN__SHIFT                             0xe
#define DMCU_INTERRUPT_TO_UC_EN_MASK__DCPG_IHC_DCFE3_POWER_UP_INT_TO_UC_EN__SHIFT                             0xf
#define DMCU_INTERRUPT_TO_UC_EN_MASK__DCPG_IHC_DCFE4_POWER_UP_INT_TO_UC_EN__SHIFT                             0x10
#define DMCU_INTERRUPT_TO_UC_EN_MASK__DCPG_IHC_DCFE5_POWER_UP_INT_TO_UC_EN__SHIFT                             0x11
#define DMCU_INTERRUPT_TO_UC_EN_MASK__DCPG_IHC_DCFE0_POWER_DOWN_INT_TO_UC_EN__SHIFT                           0x12
#define DMCU_INTERRUPT_TO_UC_EN_MASK__DCPG_IHC_DCFE1_POWER_DOWN_INT_TO_UC_EN__SHIFT                           0x13
#define DMCU_INTERRUPT_TO_UC_EN_MASK__DCPG_IHC_DCFE2_POWER_DOWN_INT_TO_UC_EN__SHIFT                           0x14
#define DMCU_INTERRUPT_TO_UC_EN_MASK__DCPG_IHC_DCFE3_POWER_DOWN_INT_TO_UC_EN__SHIFT                           0x15
#define DMCU_INTERRUPT_TO_UC_EN_MASK__DCPG_IHC_DCFE4_POWER_DOWN_INT_TO_UC_EN__SHIFT                           0x16
#define DMCU_INTERRUPT_TO_UC_EN_MASK__DCPG_IHC_DCFE5_POWER_DOWN_INT_TO_UC_EN__SHIFT                           0x17
#define DMCU_INTERRUPT_TO_UC_EN_MASK__VBLANK1_INT_TO_UC_EN__SHIFT                                             0x18
#define DMCU_INTERRUPT_TO_UC_EN_MASK__VBLANK2_INT_TO_UC_EN__SHIFT                                             0x19
#define DMCU_INTERRUPT_TO_UC_EN_MASK__VBLANK3_INT_TO_UC_EN__SHIFT                                             0x1a
#define DMCU_INTERRUPT_TO_UC_EN_MASK__VBLANK4_INT_TO_UC_EN__SHIFT                                             0x1b
#define DMCU_INTERRUPT_TO_UC_EN_MASK__VBLANK5_INT_TO_UC_EN__SHIFT                                             0x1c
#define DMCU_INTERRUPT_TO_UC_EN_MASK__VBLANK6_INT_TO_UC_EN__SHIFT                                             0x1d
#define DMCU_INTERRUPT_TO_UC_EN_MASK__STATIC_SCREEN6_INT_TO_UC_EN__SHIFT                                      0x1e
#define DMCU_INTERRUPT_TO_UC_EN_MASK__ABM1_HG_READY_INT_TO_UC_EN_MASK                                         0x00000001L
#define DMCU_INTERRUPT_TO_UC_EN_MASK__ABM1_LS_READY_INT_TO_UC_EN_MASK                                         0x00000002L
#define DMCU_INTERRUPT_TO_UC_EN_MASK__ABM1_BL_UPDATE_INT_TO_UC_EN_MASK                                        0x00000004L
#define DMCU_INTERRUPT_TO_UC_EN_MASK__MCP_INT_TO_UC_EN_MASK                                                   0x00000008L
#define DMCU_INTERRUPT_TO_UC_EN_MASK__DCPG_IHC_DSI_POWER_UP_INT_TO_UC_EN_MASK                                 0x00000010L
#define DMCU_INTERRUPT_TO_UC_EN_MASK__DCPG_IHC_DSI_POWER_DOWN_INT_TO_UC_EN_MASK                               0x00000020L
#define DMCU_INTERRUPT_TO_UC_EN_MASK__STATIC_SCREEN1_INT_TO_UC_EN_MASK                                        0x00000040L
#define DMCU_INTERRUPT_TO_UC_EN_MASK__STATIC_SCREEN2_INT_TO_UC_EN_MASK                                        0x00000080L
#define DMCU_INTERRUPT_TO_UC_EN_MASK__EXTERNAL_SW_INT_TO_UC_EN_MASK                                           0x00000100L
#define DMCU_INTERRUPT_TO_UC_EN_MASK__STATIC_SCREEN3_INT_TO_UC_EN_MASK                                        0x00000200L
#define DMCU_INTERRUPT_TO_UC_EN_MASK__STATIC_SCREEN4_INT_TO_UC_EN_MASK                                        0x00000400L
#define DMCU_INTERRUPT_TO_UC_EN_MASK__STATIC_SCREEN5_INT_TO_UC_EN_MASK                                        0x00000800L
#define DMCU_INTERRUPT_TO_UC_EN_MASK__DCPG_IHC_DCFE0_POWER_UP_INT_TO_UC_EN_MASK                               0x00001000L
#define DMCU_INTERRUPT_TO_UC_EN_MASK__DCPG_IHC_DCFE1_POWER_UP_INT_TO_UC_EN_MASK                               0x00002000L
#define DMCU_INTERRUPT_TO_UC_EN_MASK__DCPG_IHC_DCFE2_POWER_UP_INT_TO_UC_EN_MASK                               0x00004000L
#define DMCU_INTERRUPT_TO_UC_EN_MASK__DCPG_IHC_DCFE3_POWER_UP_INT_TO_UC_EN_MASK                               0x00008000L
#define DMCU_INTERRUPT_TO_UC_EN_MASK__DCPG_IHC_DCFE4_POWER_UP_INT_TO_UC_EN_MASK                               0x00010000L
#define DMCU_INTERRUPT_TO_UC_EN_MASK__DCPG_IHC_DCFE5_POWER_UP_INT_TO_UC_EN_MASK                               0x00020000L
#define DMCU_INTERRUPT_TO_UC_EN_MASK__DCPG_IHC_DCFE0_POWER_DOWN_INT_TO_UC_EN_MASK                             0x00040000L
#define DMCU_INTERRUPT_TO_UC_EN_MASK__DCPG_IHC_DCFE1_POWER_DOWN_INT_TO_UC_EN_MASK                             0x00080000L
#define DMCU_INTERRUPT_TO_UC_EN_MASK__DCPG_IHC_DCFE2_POWER_DOWN_INT_TO_UC_EN_MASK                             0x00100000L
#define DMCU_INTERRUPT_TO_UC_EN_MASK__DCPG_IHC_DCFE3_POWER_DOWN_INT_TO_UC_EN_MASK                             0x00200000L
#define DMCU_INTERRUPT_TO_UC_EN_MASK__DCPG_IHC_DCFE4_POWER_DOWN_INT_TO_UC_EN_MASK                             0x00400000L
#define DMCU_INTERRUPT_TO_UC_EN_MASK__DCPG_IHC_DCFE5_POWER_DOWN_INT_TO_UC_EN_MASK                             0x00800000L
#define DMCU_INTERRUPT_TO_UC_EN_MASK__VBLANK1_INT_TO_UC_EN_MASK                                               0x01000000L
#define DMCU_INTERRUPT_TO_UC_EN_MASK__VBLANK2_INT_TO_UC_EN_MASK                                               0x02000000L
#define DMCU_INTERRUPT_TO_UC_EN_MASK__VBLANK3_INT_TO_UC_EN_MASK                                               0x04000000L
#define DMCU_INTERRUPT_TO_UC_EN_MASK__VBLANK4_INT_TO_UC_EN_MASK                                               0x08000000L
#define DMCU_INTERRUPT_TO_UC_EN_MASK__VBLANK5_INT_TO_UC_EN_MASK                                               0x10000000L
#define DMCU_INTERRUPT_TO_UC_EN_MASK__VBLANK6_INT_TO_UC_EN_MASK                                               0x20000000L
#define DMCU_INTERRUPT_TO_UC_EN_MASK__STATIC_SCREEN6_INT_TO_UC_EN_MASK                                        0x40000000L
//DMCU_INTERRUPT_TO_UC_XIRQ_IRQ_SEL
#define DMCU_INTERRUPT_TO_UC_XIRQ_IRQ_SEL__ABM1_HG_READY_INT_XIRQ_IRQ_SEL__SHIFT                              0x0
#define DMCU_INTERRUPT_TO_UC_XIRQ_IRQ_SEL__ABM1_LS_READY_INT_XIRQ_IRQ_SEL__SHIFT                              0x1
#define DMCU_INTERRUPT_TO_UC_XIRQ_IRQ_SEL__ABM1_BL_UPDATE_INT_XIRQ_IRQ_SEL__SHIFT                             0x2
#define DMCU_INTERRUPT_TO_UC_XIRQ_IRQ_SEL__MCP_INT_XIRQ_IRQ_SEL__SHIFT                                        0x3
#define DMCU_INTERRUPT_TO_UC_XIRQ_IRQ_SEL__DCPG_IHC_DSI_POWER_UP_INT_XIRQ_IRQ_SEL__SHIFT                      0x4
#define DMCU_INTERRUPT_TO_UC_XIRQ_IRQ_SEL__DCPG_IHC_DSI_POWER_DOWN_INT_XIRQ_IRQ_SEL__SHIFT                    0x5
#define DMCU_INTERRUPT_TO_UC_XIRQ_IRQ_SEL__STATIC_SCREEN1_INT_XIRQ_IRQ_SEL__SHIFT                             0x6
#define DMCU_INTERRUPT_TO_UC_XIRQ_IRQ_SEL__STATIC_SCREEN2_INT_XIRQ_IRQ_SEL__SHIFT                             0x7
#define DMCU_INTERRUPT_TO_UC_XIRQ_IRQ_SEL__EXTERNAL_SW_INT_XIRQ_IRQ_SEL__SHIFT                                0x8
#define DMCU_INTERRUPT_TO_UC_XIRQ_IRQ_SEL__STATIC_SCREEN3_INT_XIRQ_IRQ_SEL__SHIFT                             0x9
#define DMCU_INTERRUPT_TO_UC_XIRQ_IRQ_SEL__STATIC_SCREEN4_INT_XIRQ_IRQ_SEL__SHIFT                             0xa
#define DMCU_INTERRUPT_TO_UC_XIRQ_IRQ_SEL__STATIC_SCREEN5_INT_XIRQ_IRQ_SEL__SHIFT                             0xb
#define DMCU_INTERRUPT_TO_UC_XIRQ_IRQ_SEL__DCPG_IHC_DCFE0_POWER_UP_INT_XIRQ_IRQ_SEL__SHIFT                    0xc
#define DMCU_INTERRUPT_TO_UC_XIRQ_IRQ_SEL__DCPG_IHC_DCFE1_POWER_UP_INT_XIRQ_IRQ_SEL__SHIFT                    0xd
#define DMCU_INTERRUPT_TO_UC_XIRQ_IRQ_SEL__DCPG_IHC_DCFE2_POWER_UP_INT_XIRQ_IRQ_SEL__SHIFT                    0xe
#define DMCU_INTERRUPT_TO_UC_XIRQ_IRQ_SEL__DCPG_IHC_DCFE3_POWER_UP_INT_XIRQ_IRQ_SEL__SHIFT                    0xf
#define DMCU_INTERRUPT_TO_UC_XIRQ_IRQ_SEL__DCPG_IHC_DCFE4_POWER_UP_INT_XIRQ_IRQ_SEL__SHIFT                    0x10
#define DMCU_INTERRUPT_TO_UC_XIRQ_IRQ_SEL__DCPG_IHC_DCFE5_POWER_UP_INT_XIRQ_IRQ_SEL__SHIFT                    0x11
#define DMCU_INTERRUPT_TO_UC_XIRQ_IRQ_SEL__DCPG_IHC_DCFE0_POWER_DOWN_INT_XIRQ_IRQ_SEL__SHIFT                  0x12
#define DMCU_INTERRUPT_TO_UC_XIRQ_IRQ_SEL__DCPG_IHC_DCFE1_POWER_DOWN_INT_XIRQ_IRQ_SEL__SHIFT                  0x13
#define DMCU_INTERRUPT_TO_UC_XIRQ_IRQ_SEL__DCPG_IHC_DCFE2_POWER_DOWN_INT_XIRQ_IRQ_SEL__SHIFT                  0x14
#define DMCU_INTERRUPT_TO_UC_XIRQ_IRQ_SEL__DCPG_IHC_DCFE3_POWER_DOWN_INT_XIRQ_IRQ_SEL__SHIFT                  0x15
#define DMCU_INTERRUPT_TO_UC_XIRQ_IRQ_SEL__DCPG_IHC_DCFE4_POWER_DOWN_INT_XIRQ_IRQ_SEL__SHIFT                  0x16
#define DMCU_INTERRUPT_TO_UC_XIRQ_IRQ_SEL__DCPG_IHC_DCFE5_POWER_DOWN_INT_XIRQ_IRQ_SEL__SHIFT                  0x17
#define DMCU_INTERRUPT_TO_UC_XIRQ_IRQ_SEL__VBLANK1_INT_XIRQ_IRQ_SEL__SHIFT                                    0x18
#define DMCU_INTERRUPT_TO_UC_XIRQ_IRQ_SEL__VBLANK2_INT_XIRQ_IRQ_SEL__SHIFT                                    0x19
#define DMCU_INTERRUPT_TO_UC_XIRQ_IRQ_SEL__VBLANK3_INT_XIRQ_IRQ_SEL__SHIFT                                    0x1a
#define DMCU_INTERRUPT_TO_UC_XIRQ_IRQ_SEL__VBLANK4_INT_XIRQ_IRQ_SEL__SHIFT                                    0x1b
#define DMCU_INTERRUPT_TO_UC_XIRQ_IRQ_SEL__VBLANK5_INT_XIRQ_IRQ_SEL__SHIFT                                    0x1c
#define DMCU_INTERRUPT_TO_UC_XIRQ_IRQ_SEL__VBLANK6_INT_XIRQ_IRQ_SEL__SHIFT                                    0x1d
#define DMCU_INTERRUPT_TO_UC_XIRQ_IRQ_SEL__STATIC_SCREEN6_INT_XIRQ_IRQ_SEL__SHIFT                             0x1e
#define DMCU_INTERRUPT_TO_UC_XIRQ_IRQ_SEL__ABM1_HG_READY_INT_XIRQ_IRQ_SEL_MASK                                0x00000001L
#define DMCU_INTERRUPT_TO_UC_XIRQ_IRQ_SEL__ABM1_LS_READY_INT_XIRQ_IRQ_SEL_MASK                                0x00000002L
#define DMCU_INTERRUPT_TO_UC_XIRQ_IRQ_SEL__ABM1_BL_UPDATE_INT_XIRQ_IRQ_SEL_MASK                               0x00000004L
#define DMCU_INTERRUPT_TO_UC_XIRQ_IRQ_SEL__MCP_INT_XIRQ_IRQ_SEL_MASK                                          0x00000008L
#define DMCU_INTERRUPT_TO_UC_XIRQ_IRQ_SEL__DCPG_IHC_DSI_POWER_UP_INT_XIRQ_IRQ_SEL_MASK                        0x00000010L
#define DMCU_INTERRUPT_TO_UC_XIRQ_IRQ_SEL__DCPG_IHC_DSI_POWER_DOWN_INT_XIRQ_IRQ_SEL_MASK                      0x00000020L
#define DMCU_INTERRUPT_TO_UC_XIRQ_IRQ_SEL__STATIC_SCREEN1_INT_XIRQ_IRQ_SEL_MASK                               0x00000040L
#define DMCU_INTERRUPT_TO_UC_XIRQ_IRQ_SEL__STATIC_SCREEN2_INT_XIRQ_IRQ_SEL_MASK                               0x00000080L
#define DMCU_INTERRUPT_TO_UC_XIRQ_IRQ_SEL__EXTERNAL_SW_INT_XIRQ_IRQ_SEL_MASK                                  0x00000100L
#define DMCU_INTERRUPT_TO_UC_XIRQ_IRQ_SEL__STATIC_SCREEN3_INT_XIRQ_IRQ_SEL_MASK                               0x00000200L
#define DMCU_INTERRUPT_TO_UC_XIRQ_IRQ_SEL__STATIC_SCREEN4_INT_XIRQ_IRQ_SEL_MASK                               0x00000400L
#define DMCU_INTERRUPT_TO_UC_XIRQ_IRQ_SEL__STATIC_SCREEN5_INT_XIRQ_IRQ_SEL_MASK                               0x00000800L
#define DMCU_INTERRUPT_TO_UC_XIRQ_IRQ_SEL__DCPG_IHC_DCFE0_POWER_UP_INT_XIRQ_IRQ_SEL_MASK                      0x00001000L
#define DMCU_INTERRUPT_TO_UC_XIRQ_IRQ_SEL__DCPG_IHC_DCFE1_POWER_UP_INT_XIRQ_IRQ_SEL_MASK                      0x00002000L
#define DMCU_INTERRUPT_TO_UC_XIRQ_IRQ_SEL__DCPG_IHC_DCFE2_POWER_UP_INT_XIRQ_IRQ_SEL_MASK                      0x00004000L
#define DMCU_INTERRUPT_TO_UC_XIRQ_IRQ_SEL__DCPG_IHC_DCFE3_POWER_UP_INT_XIRQ_IRQ_SEL_MASK                      0x00008000L
#define DMCU_INTERRUPT_TO_UC_XIRQ_IRQ_SEL__DCPG_IHC_DCFE4_POWER_UP_INT_XIRQ_IRQ_SEL_MASK                      0x00010000L
#define DMCU_INTERRUPT_TO_UC_XIRQ_IRQ_SEL__DCPG_IHC_DCFE5_POWER_UP_INT_XIRQ_IRQ_SEL_MASK                      0x00020000L
#define DMCU_INTERRUPT_TO_UC_XIRQ_IRQ_SEL__DCPG_IHC_DCFE0_POWER_DOWN_INT_XIRQ_IRQ_SEL_MASK                    0x00040000L
#define DMCU_INTERRUPT_TO_UC_XIRQ_IRQ_SEL__DCPG_IHC_DCFE1_POWER_DOWN_INT_XIRQ_IRQ_SEL_MASK                    0x00080000L
#define DMCU_INTERRUPT_TO_UC_XIRQ_IRQ_SEL__DCPG_IHC_DCFE2_POWER_DOWN_INT_XIRQ_IRQ_SEL_MASK                    0x00100000L
#define DMCU_INTERRUPT_TO_UC_XIRQ_IRQ_SEL__DCPG_IHC_DCFE3_POWER_DOWN_INT_XIRQ_IRQ_SEL_MASK                    0x00200000L
#define DMCU_INTERRUPT_TO_UC_XIRQ_IRQ_SEL__DCPG_IHC_DCFE4_POWER_DOWN_INT_XIRQ_IRQ_SEL_MASK                    0x00400000L
#define DMCU_INTERRUPT_TO_UC_XIRQ_IRQ_SEL__DCPG_IHC_DCFE5_POWER_DOWN_INT_XIRQ_IRQ_SEL_MASK                    0x00800000L
#define DMCU_INTERRUPT_TO_UC_XIRQ_IRQ_SEL__VBLANK1_INT_XIRQ_IRQ_SEL_MASK                                      0x01000000L
#define DMCU_INTERRUPT_TO_UC_XIRQ_IRQ_SEL__VBLANK2_INT_XIRQ_IRQ_SEL_MASK                                      0x02000000L
#define DMCU_INTERRUPT_TO_UC_XIRQ_IRQ_SEL__VBLANK3_INT_XIRQ_IRQ_SEL_MASK                                      0x04000000L
#define DMCU_INTERRUPT_TO_UC_XIRQ_IRQ_SEL__VBLANK4_INT_XIRQ_IRQ_SEL_MASK                                      0x08000000L
#define DMCU_INTERRUPT_TO_UC_XIRQ_IRQ_SEL__VBLANK5_INT_XIRQ_IRQ_SEL_MASK                                      0x10000000L
#define DMCU_INTERRUPT_TO_UC_XIRQ_IRQ_SEL__VBLANK6_INT_XIRQ_IRQ_SEL_MASK                                      0x20000000L
#define DMCU_INTERRUPT_TO_UC_XIRQ_IRQ_SEL__STATIC_SCREEN6_INT_XIRQ_IRQ_SEL_MASK                               0x40000000L
//DC_DMCU_SCRATCH
#define DC_DMCU_SCRATCH__DMCU_SCRATCH__SHIFT                                                                  0x0
#define DC_DMCU_SCRATCH__DMCU_SCRATCH_MASK                                                                    0xFFFFFFFFL
//DMCU_INT_CNT
#define DMCU_INT_CNT__DMCU_ABM1_HG_READY_INT_CNT__SHIFT                                                       0x0
#define DMCU_INT_CNT__DMCU_ABM1_LS_READY_INT_CNT__SHIFT                                                       0x8
#define DMCU_INT_CNT__DMCU_ABM1_BL_UPDATE_INT_CNT__SHIFT                                                      0x10
#define DMCU_INT_CNT__DMCU_ABM1_HG_READY_INT_CNT_MASK                                                         0x000000FFL
#define DMCU_INT_CNT__DMCU_ABM1_LS_READY_INT_CNT_MASK                                                         0x0000FF00L
#define DMCU_INT_CNT__DMCU_ABM1_BL_UPDATE_INT_CNT_MASK                                                        0x00FF0000L
//DMCU_FW_CHECKSUM_SMPL_BYTE_POS
#define DMCU_FW_CHECKSUM_SMPL_BYTE_POS__DMCU_FW_CHECKSUM_LO_SMPL_BYTE_POS__SHIFT                              0x0
#define DMCU_FW_CHECKSUM_SMPL_BYTE_POS__DMCU_FW_CHECKSUM_HI_SMPL_BYTE_POS__SHIFT                              0x2
#define DMCU_FW_CHECKSUM_SMPL_BYTE_POS__DMCU_FW_CHECKSUM_LO_SMPL_BYTE_POS_MASK                                0x00000003L
#define DMCU_FW_CHECKSUM_SMPL_BYTE_POS__DMCU_FW_CHECKSUM_HI_SMPL_BYTE_POS_MASK                                0x0000000CL
//DMCU_UC_CLK_GATING_CNTL
#define DMCU_UC_CLK_GATING_CNTL__UC_IRAM_RD_DELAY__SHIFT                                                      0x0
#define DMCU_UC_CLK_GATING_CNTL__UC_ERAM_RD_DELAY__SHIFT                                                      0x8
#define DMCU_UC_CLK_GATING_CNTL__UC_RBBM_RD_CLK_GATING_EN__SHIFT                                              0x10
#define DMCU_UC_CLK_GATING_CNTL__UC_IRAM_RD_DELAY_MASK                                                        0x00000007L
#define DMCU_UC_CLK_GATING_CNTL__UC_ERAM_RD_DELAY_MASK                                                        0x00000700L
#define DMCU_UC_CLK_GATING_CNTL__UC_RBBM_RD_CLK_GATING_EN_MASK                                                0x00010000L
//MASTER_COMM_DATA_REG1
#define MASTER_COMM_DATA_REG1__MASTER_COMM_DATA_REG1_BYTE0__SHIFT                                             0x0
#define MASTER_COMM_DATA_REG1__MASTER_COMM_DATA_REG1_BYTE1__SHIFT                                             0x8
#define MASTER_COMM_DATA_REG1__MASTER_COMM_DATA_REG1_BYTE2__SHIFT                                             0x10
#define MASTER_COMM_DATA_REG1__MASTER_COMM_DATA_REG1_BYTE3__SHIFT                                             0x18
#define MASTER_COMM_DATA_REG1__MASTER_COMM_DATA_REG1_BYTE0_MASK                                               0x000000FFL
#define MASTER_COMM_DATA_REG1__MASTER_COMM_DATA_REG1_BYTE1_MASK                                               0x0000FF00L
#define MASTER_COMM_DATA_REG1__MASTER_COMM_DATA_REG1_BYTE2_MASK                                               0x00FF0000L
#define MASTER_COMM_DATA_REG1__MASTER_COMM_DATA_REG1_BYTE3_MASK                                               0xFF000000L
//MASTER_COMM_DATA_REG2
#define MASTER_COMM_DATA_REG2__MASTER_COMM_DATA_REG2_BYTE0__SHIFT                                             0x0
#define MASTER_COMM_DATA_REG2__MASTER_COMM_DATA_REG2_BYTE1__SHIFT                                             0x8
#define MASTER_COMM_DATA_REG2__MASTER_COMM_DATA_REG2_BYTE2__SHIFT                                             0x10
#define MASTER_COMM_DATA_REG2__MASTER_COMM_DATA_REG2_BYTE3__SHIFT                                             0x18
#define MASTER_COMM_DATA_REG2__MASTER_COMM_DATA_REG2_BYTE0_MASK                                               0x000000FFL
#define MASTER_COMM_DATA_REG2__MASTER_COMM_DATA_REG2_BYTE1_MASK                                               0x0000FF00L
#define MASTER_COMM_DATA_REG2__MASTER_COMM_DATA_REG2_BYTE2_MASK                                               0x00FF0000L
#define MASTER_COMM_DATA_REG2__MASTER_COMM_DATA_REG2_BYTE3_MASK                                               0xFF000000L
//MASTER_COMM_DATA_REG3
#define MASTER_COMM_DATA_REG3__MASTER_COMM_DATA_REG3_BYTE0__SHIFT                                             0x0
#define MASTER_COMM_DATA_REG3__MASTER_COMM_DATA_REG3_BYTE1__SHIFT                                             0x8
#define MASTER_COMM_DATA_REG3__MASTER_COMM_DATA_REG3_BYTE2__SHIFT                                             0x10
#define MASTER_COMM_DATA_REG3__MASTER_COMM_DATA_REG3_BYTE3__SHIFT                                             0x18
#define MASTER_COMM_DATA_REG3__MASTER_COMM_DATA_REG3_BYTE0_MASK                                               0x000000FFL
#define MASTER_COMM_DATA_REG3__MASTER_COMM_DATA_REG3_BYTE1_MASK                                               0x0000FF00L
#define MASTER_COMM_DATA_REG3__MASTER_COMM_DATA_REG3_BYTE2_MASK                                               0x00FF0000L
#define MASTER_COMM_DATA_REG3__MASTER_COMM_DATA_REG3_BYTE3_MASK                                               0xFF000000L
//MASTER_COMM_CMD_REG
#define MASTER_COMM_CMD_REG__MASTER_COMM_CMD_REG_BYTE0__SHIFT                                                 0x0
#define MASTER_COMM_CMD_REG__MASTER_COMM_CMD_REG_BYTE1__SHIFT                                                 0x8
#define MASTER_COMM_CMD_REG__MASTER_COMM_CMD_REG_BYTE2__SHIFT                                                 0x10
#define MASTER_COMM_CMD_REG__MASTER_COMM_CMD_REG_BYTE3__SHIFT                                                 0x18
#define MASTER_COMM_CMD_REG__MASTER_COMM_CMD_REG_BYTE0_MASK                                                   0x000000FFL
#define MASTER_COMM_CMD_REG__MASTER_COMM_CMD_REG_BYTE1_MASK                                                   0x0000FF00L
#define MASTER_COMM_CMD_REG__MASTER_COMM_CMD_REG_BYTE2_MASK                                                   0x00FF0000L
#define MASTER_COMM_CMD_REG__MASTER_COMM_CMD_REG_BYTE3_MASK                                                   0xFF000000L
//MASTER_COMM_CNTL_REG
#define MASTER_COMM_CNTL_REG__MASTER_COMM_INTERRUPT__SHIFT                                                    0x0
#define MASTER_COMM_CNTL_REG__MASTER_COMM_INTERRUPT_MASK                                                      0x00000001L
//SLAVE_COMM_DATA_REG1
#define SLAVE_COMM_DATA_REG1__SLAVE_COMM_DATA_REG1_BYTE0__SHIFT                                               0x0
#define SLAVE_COMM_DATA_REG1__SLAVE_COMM_DATA_REG1_BYTE1__SHIFT                                               0x8
#define SLAVE_COMM_DATA_REG1__SLAVE_COMM_DATA_REG1_BYTE2__SHIFT                                               0x10
#define SLAVE_COMM_DATA_REG1__SLAVE_COMM_DATA_REG1_BYTE3__SHIFT                                               0x18
#define SLAVE_COMM_DATA_REG1__SLAVE_COMM_DATA_REG1_BYTE0_MASK                                                 0x000000FFL
#define SLAVE_COMM_DATA_REG1__SLAVE_COMM_DATA_REG1_BYTE1_MASK                                                 0x0000FF00L
#define SLAVE_COMM_DATA_REG1__SLAVE_COMM_DATA_REG1_BYTE2_MASK                                                 0x00FF0000L
#define SLAVE_COMM_DATA_REG1__SLAVE_COMM_DATA_REG1_BYTE3_MASK                                                 0xFF000000L
//SLAVE_COMM_DATA_REG2
#define SLAVE_COMM_DATA_REG2__SLAVE_COMM_DATA_REG2_BYTE0__SHIFT                                               0x0
#define SLAVE_COMM_DATA_REG2__SLAVE_COMM_DATA_REG2_BYTE1__SHIFT                                               0x8
#define SLAVE_COMM_DATA_REG2__SLAVE_COMM_DATA_REG2_BYTE2__SHIFT                                               0x10
#define SLAVE_COMM_DATA_REG2__SLAVE_COMM_DATA_REG2_BYTE3__SHIFT                                               0x18
#define SLAVE_COMM_DATA_REG2__SLAVE_COMM_DATA_REG2_BYTE0_MASK                                                 0x000000FFL
#define SLAVE_COMM_DATA_REG2__SLAVE_COMM_DATA_REG2_BYTE1_MASK                                                 0x0000FF00L
#define SLAVE_COMM_DATA_REG2__SLAVE_COMM_DATA_REG2_BYTE2_MASK                                                 0x00FF0000L
#define SLAVE_COMM_DATA_REG2__SLAVE_COMM_DATA_REG2_BYTE3_MASK                                                 0xFF000000L
//SLAVE_COMM_DATA_REG3
#define SLAVE_COMM_DATA_REG3__SLAVE_COMM_DATA_REG3_BYTE0__SHIFT                                               0x0
#define SLAVE_COMM_DATA_REG3__SLAVE_COMM_DATA_REG3_BYTE1__SHIFT                                               0x8
#define SLAVE_COMM_DATA_REG3__SLAVE_COMM_DATA_REG3_BYTE2__SHIFT                                               0x10
#define SLAVE_COMM_DATA_REG3__SLAVE_COMM_DATA_REG3_BYTE3__SHIFT                                               0x18
#define SLAVE_COMM_DATA_REG3__SLAVE_COMM_DATA_REG3_BYTE0_MASK                                                 0x000000FFL
#define SLAVE_COMM_DATA_REG3__SLAVE_COMM_DATA_REG3_BYTE1_MASK                                                 0x0000FF00L
#define SLAVE_COMM_DATA_REG3__SLAVE_COMM_DATA_REG3_BYTE2_MASK                                                 0x00FF0000L
#define SLAVE_COMM_DATA_REG3__SLAVE_COMM_DATA_REG3_BYTE3_MASK                                                 0xFF000000L
//SLAVE_COMM_CMD_REG
#define SLAVE_COMM_CMD_REG__SLAVE_COMM_CMD_REG_BYTE0__SHIFT                                                   0x0
#define SLAVE_COMM_CMD_REG__SLAVE_COMM_CMD_REG_BYTE1__SHIFT                                                   0x8
#define SLAVE_COMM_CMD_REG__SLAVE_COMM_CMD_REG_BYTE2__SHIFT                                                   0x10
#define SLAVE_COMM_CMD_REG__SLAVE_COMM_CMD_REG_BYTE3__SHIFT                                                   0x18
#define SLAVE_COMM_CMD_REG__SLAVE_COMM_CMD_REG_BYTE0_MASK                                                     0x000000FFL
#define SLAVE_COMM_CMD_REG__SLAVE_COMM_CMD_REG_BYTE1_MASK                                                     0x0000FF00L
#define SLAVE_COMM_CMD_REG__SLAVE_COMM_CMD_REG_BYTE2_MASK                                                     0x00FF0000L
#define SLAVE_COMM_CMD_REG__SLAVE_COMM_CMD_REG_BYTE3_MASK                                                     0xFF000000L
//SLAVE_COMM_CNTL_REG
#define SLAVE_COMM_CNTL_REG__SLAVE_COMM_INTERRUPT__SHIFT                                                      0x0
#define SLAVE_COMM_CNTL_REG__COMM_PORT_MSG_TO_HOST_IN_PROGRESS__SHIFT                                         0x8
#define SLAVE_COMM_CNTL_REG__SLAVE_COMM_INTERRUPT_MASK                                                        0x00000001L
#define SLAVE_COMM_CNTL_REG__COMM_PORT_MSG_TO_HOST_IN_PROGRESS_MASK                                           0x00000100L
//BL1_PWM_AMBIENT_LIGHT_LEVEL
#define BL1_PWM_AMBIENT_LIGHT_LEVEL__BL1_PWM_AMBIENT_LIGHT_LEVEL__SHIFT                                       0x0
#define BL1_PWM_AMBIENT_LIGHT_LEVEL__BL1_PWM_AMBIENT_LIGHT_LEVEL_MASK                                         0x0001FFFFL
//BL1_PWM_USER_LEVEL
#define BL1_PWM_USER_LEVEL__BL1_PWM_USER_LEVEL__SHIFT                                                         0x0
#define BL1_PWM_USER_LEVEL__BL1_PWM_USER_LEVEL_MASK                                                           0x0001FFFFL
//BL1_PWM_TARGET_ABM_LEVEL
#define BL1_PWM_TARGET_ABM_LEVEL__BL1_PWM_TARGET_ABM_LEVEL__SHIFT                                             0x0
#define BL1_PWM_TARGET_ABM_LEVEL__BL1_PWM_TARGET_ABM_LEVEL_MASK                                               0x0001FFFFL
//BL1_PWM_CURRENT_ABM_LEVEL
#define BL1_PWM_CURRENT_ABM_LEVEL__BL1_PWM_CURRENT_ABM_LEVEL__SHIFT                                           0x0
#define BL1_PWM_CURRENT_ABM_LEVEL__BL1_PWM_CURRENT_ABM_LEVEL_MASK                                             0x0001FFFFL
//BL1_PWM_FINAL_DUTY_CYCLE
#define BL1_PWM_FINAL_DUTY_CYCLE__BL1_PWM_FINAL_DUTY_CYCLE__SHIFT                                             0x0
#define BL1_PWM_FINAL_DUTY_CYCLE__BL1_PWM_FINAL_DUTY_CYCLE_MASK                                               0x0001FFFFL
//BL1_PWM_MINIMUM_DUTY_CYCLE
#define BL1_PWM_MINIMUM_DUTY_CYCLE__BL1_PWM_MINIMUM_DUTY_CYCLE__SHIFT                                         0x0
#define BL1_PWM_MINIMUM_DUTY_CYCLE__BL1_PWM_MINIMUM_DUTY_CYCLE_MASK                                           0x0001FFFFL
//BL1_PWM_ABM_CNTL
#define BL1_PWM_ABM_CNTL__BL1_PWM_USE_ABM_EN__SHIFT                                                           0x0
#define BL1_PWM_ABM_CNTL__BL1_PWM_USE_AMBIENT_LEVEL_EN__SHIFT                                                 0x1
#define BL1_PWM_ABM_CNTL__BL1_PWM_AUTO_UPDATE_CURRENT_ABM_LEVEL_EN__SHIFT                                     0x2
#define BL1_PWM_ABM_CNTL__BL1_PWM_AUTO_CALC_FINAL_DUTY_CYCLE_EN__SHIFT                                        0x3
#define BL1_PWM_ABM_CNTL__BL1_PWM_AUTO_UPDATE_CURRENT_ABM_STEP_SIZE__SHIFT                                    0x10
#define BL1_PWM_ABM_CNTL__BL1_PWM_USE_ABM_EN_MASK                                                             0x00000001L
#define BL1_PWM_ABM_CNTL__BL1_PWM_USE_AMBIENT_LEVEL_EN_MASK                                                   0x00000002L
#define BL1_PWM_ABM_CNTL__BL1_PWM_AUTO_UPDATE_CURRENT_ABM_LEVEL_EN_MASK                                       0x00000004L
#define BL1_PWM_ABM_CNTL__BL1_PWM_AUTO_CALC_FINAL_DUTY_CYCLE_EN_MASK                                          0x00000008L
#define BL1_PWM_ABM_CNTL__BL1_PWM_AUTO_UPDATE_CURRENT_ABM_STEP_SIZE_MASK                                      0xFFFF0000L
//BL1_PWM_BL_UPDATE_SAMPLE_RATE
#define BL1_PWM_BL_UPDATE_SAMPLE_RATE__BL1_PWM_BL_UPDATE_SAMPLE_RATE_COUNT_EN__SHIFT                          0x0
#define BL1_PWM_BL_UPDATE_SAMPLE_RATE__BL1_PWM_BL_UPDATE_RESET_SAMPLE_RATE_FRAME_COUNTER__SHIFT               0x1
#define BL1_PWM_BL_UPDATE_SAMPLE_RATE__BL1_PWM_BL_UPDATE_SAMPLE_RATE_FRAME_COUNT__SHIFT                       0x8
#define BL1_PWM_BL_UPDATE_SAMPLE_RATE__BL1_PWM_BL_UPDATE_INITIAL_SAMPLE_RATE_COUNT_VALUE_WHEN_RESET__SHIFT    0x10
#define BL1_PWM_BL_UPDATE_SAMPLE_RATE__ABM1_HGLS_REG_LOCK__SHIFT                                              0x1f
#define BL1_PWM_BL_UPDATE_SAMPLE_RATE__BL1_PWM_BL_UPDATE_SAMPLE_RATE_COUNT_EN_MASK                            0x00000001L
#define BL1_PWM_BL_UPDATE_SAMPLE_RATE__BL1_PWM_BL_UPDATE_RESET_SAMPLE_RATE_FRAME_COUNTER_MASK                 0x00000002L
#define BL1_PWM_BL_UPDATE_SAMPLE_RATE__BL1_PWM_BL_UPDATE_SAMPLE_RATE_FRAME_COUNT_MASK                         0x0000FF00L
#define BL1_PWM_BL_UPDATE_SAMPLE_RATE__BL1_PWM_BL_UPDATE_INITIAL_SAMPLE_RATE_COUNT_VALUE_WHEN_RESET_MASK      0x00FF0000L
#define BL1_PWM_BL_UPDATE_SAMPLE_RATE__ABM1_HGLS_REG_LOCK_MASK                                                0x80000000L
//BL1_PWM_GRP2_REG_LOCK
#define BL1_PWM_GRP2_REG_LOCK__BL1_PWM_GRP2_REG_LOCK__SHIFT                                                   0x0
#define BL1_PWM_GRP2_REG_LOCK__BL1_PWM_GRP2_REG_UPDATE_PENDING__SHIFT                                         0x8
#define BL1_PWM_GRP2_REG_LOCK__BL1_PWM_GRP2_UPDATE_AT_FRAME_START__SHIFT                                      0x10
#define BL1_PWM_GRP2_REG_LOCK__BL1_PWM_GRP2_FRAME_START_DISP_SEL__SHIFT                                       0x11
#define BL1_PWM_GRP2_REG_LOCK__BL1_PWM_GRP2_READBACK_DB_REG_VALUE_EN__SHIFT                                   0x18
#define BL1_PWM_GRP2_REG_LOCK__BL1_PWM_GRP2_IGNORE_MASTER_LOCK_EN__SHIFT                                      0x1f
#define BL1_PWM_GRP2_REG_LOCK__BL1_PWM_GRP2_REG_LOCK_MASK                                                     0x00000001L
#define BL1_PWM_GRP2_REG_LOCK__BL1_PWM_GRP2_REG_UPDATE_PENDING_MASK                                           0x00000100L
#define BL1_PWM_GRP2_REG_LOCK__BL1_PWM_GRP2_UPDATE_AT_FRAME_START_MASK                                        0x00010000L
#define BL1_PWM_GRP2_REG_LOCK__BL1_PWM_GRP2_FRAME_START_DISP_SEL_MASK                                         0x000E0000L
#define BL1_PWM_GRP2_REG_LOCK__BL1_PWM_GRP2_READBACK_DB_REG_VALUE_EN_MASK                                     0x01000000L
#define BL1_PWM_GRP2_REG_LOCK__BL1_PWM_GRP2_IGNORE_MASTER_LOCK_EN_MASK                                        0x80000000L
//DMCU_INTERRUPT_TO_UC_EN_MASK_1
#define DMCU_INTERRUPT_TO_UC_EN_MASK_1__DCPG_IHC_DCFEV0_POWER_UP_INT_TO_UC_EN__SHIFT                          0x0
#define DMCU_INTERRUPT_TO_UC_EN_MASK_1__DCPG_IHC_DCFEV0_POWER_DOWN_INT_TO_UC_EN__SHIFT                        0x1
#define DMCU_INTERRUPT_TO_UC_EN_MASK_1__DCFEV0_VBLANK_INT_TO_UC_EN__SHIFT                                     0x2
#define DMCU_INTERRUPT_TO_UC_EN_MASK_1__DCPG_IHC_DCFEV1_POWER_UP_INT_TO_UC_EN__SHIFT                          0x3
#define DMCU_INTERRUPT_TO_UC_EN_MASK_1__DCPG_IHC_DCFEV1_POWER_DOWN_INT_TO_UC_EN__SHIFT                        0x4
#define DMCU_INTERRUPT_TO_UC_EN_MASK_1__DCFEV1_VBLANK_INT_TO_UC_EN__SHIFT                                     0x5
#define DMCU_INTERRUPT_TO_UC_EN_MASK_1__CRTC0_RANGE_TIMING_UPDATE_INT_TO_UC_EN__SHIFT                         0x6
#define DMCU_INTERRUPT_TO_UC_EN_MASK_1__CRTC1_RANGE_TIMING_UPDATE_INT_TO_UC_EN__SHIFT                         0x7
#define DMCU_INTERRUPT_TO_UC_EN_MASK_1__CRTC2_RANGE_TIMING_UPDATE_INT_TO_UC_EN__SHIFT                         0x8
#define DMCU_INTERRUPT_TO_UC_EN_MASK_1__CRTC3_RANGE_TIMING_UPDATE_INT_TO_UC_EN__SHIFT                         0x9
#define DMCU_INTERRUPT_TO_UC_EN_MASK_1__CRTC4_RANGE_TIMING_UPDATE_INT_TO_UC_EN__SHIFT                         0xa
#define DMCU_INTERRUPT_TO_UC_EN_MASK_1__CRTC5_RANGE_TIMING_UPDATE_INT_TO_UC_EN__SHIFT                         0xb
#define DMCU_INTERRUPT_TO_UC_EN_MASK_1__DMCU_GENERIC_INT_TO_UC_EN__SHIFT                                      0xd
#define DMCU_INTERRUPT_TO_UC_EN_MASK_1__DCPG_IHC_DCFEV0_POWER_UP_INT_TO_UC_EN_MASK                            0x00000001L
#define DMCU_INTERRUPT_TO_UC_EN_MASK_1__DCPG_IHC_DCFEV0_POWER_DOWN_INT_TO_UC_EN_MASK                          0x00000002L
#define DMCU_INTERRUPT_TO_UC_EN_MASK_1__DCFEV0_VBLANK_INT_TO_UC_EN_MASK                                       0x00000004L
#define DMCU_INTERRUPT_TO_UC_EN_MASK_1__DCPG_IHC_DCFEV1_POWER_UP_INT_TO_UC_EN_MASK                            0x00000008L
#define DMCU_INTERRUPT_TO_UC_EN_MASK_1__DCPG_IHC_DCFEV1_POWER_DOWN_INT_TO_UC_EN_MASK                          0x00000010L
#define DMCU_INTERRUPT_TO_UC_EN_MASK_1__DCFEV1_VBLANK_INT_TO_UC_EN_MASK                                       0x00000020L
#define DMCU_INTERRUPT_TO_UC_EN_MASK_1__CRTC0_RANGE_TIMING_UPDATE_INT_TO_UC_EN_MASK                           0x00000040L
#define DMCU_INTERRUPT_TO_UC_EN_MASK_1__CRTC1_RANGE_TIMING_UPDATE_INT_TO_UC_EN_MASK                           0x00000080L
#define DMCU_INTERRUPT_TO_UC_EN_MASK_1__CRTC2_RANGE_TIMING_UPDATE_INT_TO_UC_EN_MASK                           0x00000100L
#define DMCU_INTERRUPT_TO_UC_EN_MASK_1__CRTC3_RANGE_TIMING_UPDATE_INT_TO_UC_EN_MASK                           0x00000200L
#define DMCU_INTERRUPT_TO_UC_EN_MASK_1__CRTC4_RANGE_TIMING_UPDATE_INT_TO_UC_EN_MASK                           0x00000400L
#define DMCU_INTERRUPT_TO_UC_EN_MASK_1__CRTC5_RANGE_TIMING_UPDATE_INT_TO_UC_EN_MASK                           0x00000800L
#define DMCU_INTERRUPT_TO_UC_EN_MASK_1__DMCU_GENERIC_INT_TO_UC_EN_MASK                                        0x00002000L
//DMCU_INTERRUPT_TO_UC_XIRQ_IRQ_SEL_1
#define DMCU_INTERRUPT_TO_UC_XIRQ_IRQ_SEL_1__DCPG_IHC_DCFEV0_POWER_UP_INT_XIRQ_IRQ_SEL__SHIFT                 0x0
#define DMCU_INTERRUPT_TO_UC_XIRQ_IRQ_SEL_1__DCPG_IHC_DCFEV0_POWER_DOWN_INT_XIRQ_IRQ_SEL__SHIFT               0x1
#define DMCU_INTERRUPT_TO_UC_XIRQ_IRQ_SEL_1__DCFEV0_VBLANK_INT_XIRQ_IRQ_SEL__SHIFT                            0x2
#define DMCU_INTERRUPT_TO_UC_XIRQ_IRQ_SEL_1__DCPG_IHC_DCFEV1_POWER_UP_INT_XIRQ_IRQ_SEL__SHIFT                 0x3
#define DMCU_INTERRUPT_TO_UC_XIRQ_IRQ_SEL_1__DCPG_IHC_DCFEV1_POWER_DOWN_INT_XIRQ_IRQ_SEL__SHIFT               0x4
#define DMCU_INTERRUPT_TO_UC_XIRQ_IRQ_SEL_1__DCFEV1_VBLANK_INT_XIRQ_IRQ_SEL__SHIFT                            0x5
#define DMCU_INTERRUPT_TO_UC_XIRQ_IRQ_SEL_1__CRTC0_RANGE_TIMING_UPDATE_INT_XIRQ_IRQ_SEL__SHIFT                0x6
#define DMCU_INTERRUPT_TO_UC_XIRQ_IRQ_SEL_1__CRTC1_RANGE_TIMING_UPDATE_INT_XIRQ_IRQ_SEL__SHIFT                0x7
#define DMCU_INTERRUPT_TO_UC_XIRQ_IRQ_SEL_1__CRTC2_RANGE_TIMING_UPDATE_INT_XIRQ_IRQ_SEL__SHIFT                0x8
#define DMCU_INTERRUPT_TO_UC_XIRQ_IRQ_SEL_1__CRTC3_RANGE_TIMING_UPDATE_INT_XIRQ_IRQ_SEL__SHIFT                0x9
#define DMCU_INTERRUPT_TO_UC_XIRQ_IRQ_SEL_1__CRTC4_RANGE_TIMING_UPDATE_INT_XIRQ_IRQ_SEL__SHIFT                0xa
#define DMCU_INTERRUPT_TO_UC_XIRQ_IRQ_SEL_1__CRTC5_RANGE_TIMING_UPDATE_INT_XIRQ_IRQ_SEL__SHIFT                0xb
#define DMCU_INTERRUPT_TO_UC_XIRQ_IRQ_SEL_1__DMCU_GENERIC_INT_XIRQ_IRQ_SEL__SHIFT                             0xd
#define DMCU_INTERRUPT_TO_UC_XIRQ_IRQ_SEL_1__DCPG_IHC_DCFEV0_POWER_UP_INT_XIRQ_IRQ_SEL_MASK                   0x00000001L
#define DMCU_INTERRUPT_TO_UC_XIRQ_IRQ_SEL_1__DCPG_IHC_DCFEV0_POWER_DOWN_INT_XIRQ_IRQ_SEL_MASK                 0x00000002L
#define DMCU_INTERRUPT_TO_UC_XIRQ_IRQ_SEL_1__DCFEV0_VBLANK_INT_XIRQ_IRQ_SEL_MASK                              0x00000004L
#define DMCU_INTERRUPT_TO_UC_XIRQ_IRQ_SEL_1__DCPG_IHC_DCFEV1_POWER_UP_INT_XIRQ_IRQ_SEL_MASK                   0x00000008L
#define DMCU_INTERRUPT_TO_UC_XIRQ_IRQ_SEL_1__DCPG_IHC_DCFEV1_POWER_DOWN_INT_XIRQ_IRQ_SEL_MASK                 0x00000010L
#define DMCU_INTERRUPT_TO_UC_XIRQ_IRQ_SEL_1__DCFEV1_VBLANK_INT_XIRQ_IRQ_SEL_MASK                              0x00000020L
#define DMCU_INTERRUPT_TO_UC_XIRQ_IRQ_SEL_1__CRTC0_RANGE_TIMING_UPDATE_INT_XIRQ_IRQ_SEL_MASK                  0x00000040L
#define DMCU_INTERRUPT_TO_UC_XIRQ_IRQ_SEL_1__CRTC1_RANGE_TIMING_UPDATE_INT_XIRQ_IRQ_SEL_MASK                  0x00000080L
#define DMCU_INTERRUPT_TO_UC_XIRQ_IRQ_SEL_1__CRTC2_RANGE_TIMING_UPDATE_INT_XIRQ_IRQ_SEL_MASK                  0x00000100L
#define DMCU_INTERRUPT_TO_UC_XIRQ_IRQ_SEL_1__CRTC3_RANGE_TIMING_UPDATE_INT_XIRQ_IRQ_SEL_MASK                  0x00000200L
#define DMCU_INTERRUPT_TO_UC_XIRQ_IRQ_SEL_1__CRTC4_RANGE_TIMING_UPDATE_INT_XIRQ_IRQ_SEL_MASK                  0x00000400L
#define DMCU_INTERRUPT_TO_UC_XIRQ_IRQ_SEL_1__CRTC5_RANGE_TIMING_UPDATE_INT_XIRQ_IRQ_SEL_MASK                  0x00000800L
#define DMCU_INTERRUPT_TO_UC_XIRQ_IRQ_SEL_1__DMCU_GENERIC_INT_XIRQ_IRQ_SEL_MASK                               0x00002000L
//DMCU_INTERRUPT_STATUS_1
#define DMCU_INTERRUPT_STATUS_1__DCPG_IHC_DCFEV0_POWER_UP_INT_OCCURRED__SHIFT                                 0x0
#define DMCU_INTERRUPT_STATUS_1__DCPG_IHC_DCFEV0_POWER_UP_INT_CLEAR__SHIFT                                    0x0
#define DMCU_INTERRUPT_STATUS_1__DCPG_IHC_DCFEV1_POWER_UP_INT_OCCURRED__SHIFT                                 0x1
#define DMCU_INTERRUPT_STATUS_1__DCPG_IHC_DCFEV1_POWER_UP_INT_CLEAR__SHIFT                                    0x1
#define DMCU_INTERRUPT_STATUS_1__DCPG_IHC_DCFEV0_POWER_DOWN_INT_OCCURRED__SHIFT                               0x2
#define DMCU_INTERRUPT_STATUS_1__DCPG_IHC_DCFEV0_POWER_DOWN_INT_CLEAR__SHIFT                                  0x2
#define DMCU_INTERRUPT_STATUS_1__DCPG_IHC_DCFEV1_POWER_DOWN_INT_OCCURRED__SHIFT                               0x3
#define DMCU_INTERRUPT_STATUS_1__DCPG_IHC_DCFEV1_POWER_DOWN_INT_CLEAR__SHIFT                                  0x3
#define DMCU_INTERRUPT_STATUS_1__DCFEV0_VBLANK_INT_OCCURRED__SHIFT                                            0x4
#define DMCU_INTERRUPT_STATUS_1__DCFEV0_VBLANK_INT_CLEAR__SHIFT                                               0x4
#define DMCU_INTERRUPT_STATUS_1__DCFEV1_VBLANK_INT_OCCURRED__SHIFT                                            0x5
#define DMCU_INTERRUPT_STATUS_1__DCFEV1_VBLANK_INT_CLEAR__SHIFT                                               0x5
#define DMCU_INTERRUPT_STATUS_1__CRTC0_RANGE_TIMING_UPDATE_OCCURRED__SHIFT                                    0x6
#define DMCU_INTERRUPT_STATUS_1__CRTC0_RANGE_TIMING_UPDATE_CLEAR__SHIFT                                       0x6
#define DMCU_INTERRUPT_STATUS_1__CRTC1_RANGE_TIMING_UPDATE_OCCURRED__SHIFT                                    0x7
#define DMCU_INTERRUPT_STATUS_1__CRTC1_RANGE_TIMING_UPDATE_CLEAR__SHIFT                                       0x7
#define DMCU_INTERRUPT_STATUS_1__CRTC2_RANGE_TIMING_UPDATE_OCCURRED__SHIFT                                    0x8
#define DMCU_INTERRUPT_STATUS_1__CRTC2_RANGE_TIMING_UPDATE_CLEAR__SHIFT                                       0x8
#define DMCU_INTERRUPT_STATUS_1__CRTC3_RANGE_TIMING_UPDATE_OCCURRED__SHIFT                                    0x9
#define DMCU_INTERRUPT_STATUS_1__CRTC3_RANGE_TIMING_UPDATE_CLEAR__SHIFT                                       0x9
#define DMCU_INTERRUPT_STATUS_1__CRTC4_RANGE_TIMING_UPDATE_OCCURRED__SHIFT                                    0xa
#define DMCU_INTERRUPT_STATUS_1__CRTC4_RANGE_TIMING_UPDATE_CLEAR__SHIFT                                       0xa
#define DMCU_INTERRUPT_STATUS_1__CRTC5_RANGE_TIMING_UPDATE_OCCURRED__SHIFT                                    0xb
#define DMCU_INTERRUPT_STATUS_1__CRTC5_RANGE_TIMING_UPDATE_CLEAR__SHIFT                                       0xb
#define DMCU_INTERRUPT_STATUS_1__DMCU_GENERIC_INTERRUPT_OCCURRED__SHIFT                                       0xd
#define DMCU_INTERRUPT_STATUS_1__DMCU_GENERIC_INTERRUPT_CLEAR__SHIFT                                          0xd
#define DMCU_INTERRUPT_STATUS_1__DCPG_IHC_DCFEV0_POWER_UP_INT_OCCURRED_MASK                                   0x00000001L
#define DMCU_INTERRUPT_STATUS_1__DCPG_IHC_DCFEV0_POWER_UP_INT_CLEAR_MASK                                      0x00000001L
#define DMCU_INTERRUPT_STATUS_1__DCPG_IHC_DCFEV1_POWER_UP_INT_OCCURRED_MASK                                   0x00000002L
#define DMCU_INTERRUPT_STATUS_1__DCPG_IHC_DCFEV1_POWER_UP_INT_CLEAR_MASK                                      0x00000002L
#define DMCU_INTERRUPT_STATUS_1__DCPG_IHC_DCFEV0_POWER_DOWN_INT_OCCURRED_MASK                                 0x00000004L
#define DMCU_INTERRUPT_STATUS_1__DCPG_IHC_DCFEV0_POWER_DOWN_INT_CLEAR_MASK                                    0x00000004L
#define DMCU_INTERRUPT_STATUS_1__DCPG_IHC_DCFEV1_POWER_DOWN_INT_OCCURRED_MASK                                 0x00000008L
#define DMCU_INTERRUPT_STATUS_1__DCPG_IHC_DCFEV1_POWER_DOWN_INT_CLEAR_MASK                                    0x00000008L
#define DMCU_INTERRUPT_STATUS_1__DCFEV0_VBLANK_INT_OCCURRED_MASK                                              0x00000010L
#define DMCU_INTERRUPT_STATUS_1__DCFEV0_VBLANK_INT_CLEAR_MASK                                                 0x00000010L
#define DMCU_INTERRUPT_STATUS_1__DCFEV1_VBLANK_INT_OCCURRED_MASK                                              0x00000020L
#define DMCU_INTERRUPT_STATUS_1__DCFEV1_VBLANK_INT_CLEAR_MASK                                                 0x00000020L
#define DMCU_INTERRUPT_STATUS_1__CRTC0_RANGE_TIMING_UPDATE_OCCURRED_MASK                                      0x00000040L
#define DMCU_INTERRUPT_STATUS_1__CRTC0_RANGE_TIMING_UPDATE_CLEAR_MASK                                         0x00000040L
#define DMCU_INTERRUPT_STATUS_1__CRTC1_RANGE_TIMING_UPDATE_OCCURRED_MASK                                      0x00000080L
#define DMCU_INTERRUPT_STATUS_1__CRTC1_RANGE_TIMING_UPDATE_CLEAR_MASK                                         0x00000080L
#define DMCU_INTERRUPT_STATUS_1__CRTC2_RANGE_TIMING_UPDATE_OCCURRED_MASK                                      0x00000100L
#define DMCU_INTERRUPT_STATUS_1__CRTC2_RANGE_TIMING_UPDATE_CLEAR_MASK                                         0x00000100L
#define DMCU_INTERRUPT_STATUS_1__CRTC3_RANGE_TIMING_UPDATE_OCCURRED_MASK                                      0x00000200L
#define DMCU_INTERRUPT_STATUS_1__CRTC3_RANGE_TIMING_UPDATE_CLEAR_MASK                                         0x00000200L
#define DMCU_INTERRUPT_STATUS_1__CRTC4_RANGE_TIMING_UPDATE_OCCURRED_MASK                                      0x00000400L
#define DMCU_INTERRUPT_STATUS_1__CRTC4_RANGE_TIMING_UPDATE_CLEAR_MASK                                         0x00000400L
#define DMCU_INTERRUPT_STATUS_1__CRTC5_RANGE_TIMING_UPDATE_OCCURRED_MASK                                      0x00000800L
#define DMCU_INTERRUPT_STATUS_1__CRTC5_RANGE_TIMING_UPDATE_CLEAR_MASK                                         0x00000800L
#define DMCU_INTERRUPT_STATUS_1__DMCU_GENERIC_INTERRUPT_OCCURRED_MASK                                         0x00002000L
#define DMCU_INTERRUPT_STATUS_1__DMCU_GENERIC_INTERRUPT_CLEAR_MASK                                            0x00002000L
//DMCU_DPRX_INTERRUPT_STATUS1
#define DMCU_DPRX_INTERRUPT_STATUS1__DPRX_SD0P0_MSA_RECEIVED_INT_OCCURRED__SHIFT                              0x0
#define DMCU_DPRX_INTERRUPT_STATUS1__DPRX_SD0P0_MSA_RECEIVED_INT_CLEAR__SHIFT                                 0x0
#define DMCU_DPRX_INTERRUPT_STATUS1__DPRX_SD0P0_VBID_VID_STREAM_STATUS_TOGGLED_INT_OCCURRED__SHIFT            0x1
#define DMCU_DPRX_INTERRUPT_STATUS1__DPRX_SD0P0_VBID_VID_STREAM_STATUS_TOGGLED_INT_CLEAR__SHIFT               0x1
#define DMCU_DPRX_INTERRUPT_STATUS1__DPRX_SD0P0_VERTICAL_INT0_OCCURRED__SHIFT                                 0x2
#define DMCU_DPRX_INTERRUPT_STATUS1__DPRX_SD0P0_VERTICAL_INT0_CLEAR__SHIFT                                    0x2
#define DMCU_DPRX_INTERRUPT_STATUS1__DPRX_SD0P0_VERTICAL_INT1_OCCURRED__SHIFT                                 0x3
#define DMCU_DPRX_INTERRUPT_STATUS1__DPRX_SD0P0_VERTICAL_INT1_CLEAR__SHIFT                                    0x3
#define DMCU_DPRX_INTERRUPT_STATUS1__DPRX_SD0P0_SDP_RECEIVED_INT_OCCURRED__SHIFT                              0x4
#define DMCU_DPRX_INTERRUPT_STATUS1__DPRX_SD0P0_SDP_RECEIVED_INT_CLEAR__SHIFT                                 0x4
#define DMCU_DPRX_INTERRUPT_STATUS1__DPRX_SD1P0_MSA_RECEIVED_INT_OCCURRED__SHIFT                              0x5
#define DMCU_DPRX_INTERRUPT_STATUS1__DPRX_SD1P0_MSA_RECEIVED_INT_CLEAR__SHIFT                                 0x5
#define DMCU_DPRX_INTERRUPT_STATUS1__DPRX_SD1P0_VBID_VID_STREAM_STATUS_TOGGLED_INT_OCCURRED__SHIFT            0x6
#define DMCU_DPRX_INTERRUPT_STATUS1__DPRX_SD1P0_VBID_VID_STREAM_STATUS_TOGGLED_INT_CLEAR__SHIFT               0x6
#define DMCU_DPRX_INTERRUPT_STATUS1__DPRX_SD1P0_VERTICAL_INT0_OCCURRED__SHIFT                                 0x7
#define DMCU_DPRX_INTERRUPT_STATUS1__DPRX_SD1P0_VERTICAL_INT0_CLEAR__SHIFT                                    0x7
#define DMCU_DPRX_INTERRUPT_STATUS1__DPRX_SD1P0_VERTICAL_INT1_OCCURRED__SHIFT                                 0x8
#define DMCU_DPRX_INTERRUPT_STATUS1__DPRX_SD1P0_VERTICAL_INT1_CLEAR__SHIFT                                    0x8
#define DMCU_DPRX_INTERRUPT_STATUS1__DPRX_SD1P0_SDP_RECEIVED_INT_OCCURRED__SHIFT                              0x9
#define DMCU_DPRX_INTERRUPT_STATUS1__DPRX_SD1P0_SDP_RECEIVED_INT_CLEAR__SHIFT                                 0x9
#define DMCU_DPRX_INTERRUPT_STATUS1__DPRX_DPHY_P0_BS_INTERVAL_ERROR_THRESH_EXCEEDED_INT_OCCURRED__SHIFT       0xa
#define DMCU_DPRX_INTERRUPT_STATUS1__DPRX_DPHY_P0_BS_INTERVAL_ERROR_THRESH_EXCEEDED_INT_CLEAR__SHIFT          0xa
#define DMCU_DPRX_INTERRUPT_STATUS1__DPRX_DPHY_P0_SR_INTERVAL_ERROR_THRESH_EXCEEDED_INT_OCCURRED__SHIFT       0xb
#define DMCU_DPRX_INTERRUPT_STATUS1__DPRX_DPHY_P0_SR_INTERVAL_ERROR_THRESH_EXCEEDED_INT_CLEAR__SHIFT          0xb
#define DMCU_DPRX_INTERRUPT_STATUS1__DPRX_DPHY_P0_SYMBOL_ERROR_THRESH_EXCEEDED_INT_OCCURRED__SHIFT            0xc
#define DMCU_DPRX_INTERRUPT_STATUS1__DPRX_DPHY_P0_SYMBOL_ERROR_THRESH_EXCEEDED_INT_CLEAR__SHIFT               0xc
#define DMCU_DPRX_INTERRUPT_STATUS1__DPRX_DPHY_P0_DISPARITY_ERROR_THRESH_EXCEEDED_INT_OCCURRED__SHIFT         0xd
#define DMCU_DPRX_INTERRUPT_STATUS1__DPRX_DPHY_P0_DISPARITY_ERROR_THRESH_EXCEEDED_INT_CLEAR__SHIFT            0xd
#define DMCU_DPRX_INTERRUPT_STATUS1__DPRX_DPHY_P0_TRAINING_ERROR_THRESH_EXCEEDED_INT_OCCURRED__SHIFT          0xe
#define DMCU_DPRX_INTERRUPT_STATUS1__DPRX_DPHY_P0_TRAINING_ERROR_THRESH_EXCEEDED_INT_CLEAR__SHIFT             0xe
#define DMCU_DPRX_INTERRUPT_STATUS1__DPRX_DPHY_P0_TEST_PATTERN_ERROR_THRESH_EXCEEDED_INT_OCCURRED__SHIFT      0xf
#define DMCU_DPRX_INTERRUPT_STATUS1__DPRX_DPHY_P0_TEST_PATTERN_ERROR_THRESH_EXCEEDED_INT_CLEAR__SHIFT         0xf
#define DMCU_DPRX_INTERRUPT_STATUS1__DPRX_DPHY_P0_ECF_ERROR_THRESH_EXCEEDED_INT_OCCURRED__SHIFT               0x10
#define DMCU_DPRX_INTERRUPT_STATUS1__DPRX_DPHY_P0_ECF_ERROR_THRESH_EXCEEDED_INT_CLEAR__SHIFT                  0x10
#define DMCU_DPRX_INTERRUPT_STATUS1__DPRX_DPHY_P0_DETECT_SR_LOCK_INT_OCCURRED__SHIFT                          0x11
#define DMCU_DPRX_INTERRUPT_STATUS1__DPRX_DPHY_P0_DETECT_SR_LOCK_INT_CLEAR__SHIFT                             0x11
#define DMCU_DPRX_INTERRUPT_STATUS1__DPRX_DPHY_P0_LOSS_OF_ALIGN_INT_OCCURRED__SHIFT                           0x12
#define DMCU_DPRX_INTERRUPT_STATUS1__DPRX_DPHY_P0_LOSS_OF_ALIGN_INT_CLEAR__SHIFT                              0x12
#define DMCU_DPRX_INTERRUPT_STATUS1__DPRX_DPHY_P0_LOSS_OF_DESKEW_INT_OCCURRED__SHIFT                          0x13
#define DMCU_DPRX_INTERRUPT_STATUS1__DPRX_DPHY_P0_LOSS_OF_DESKEW_INT_CLEAR__SHIFT                             0x13
#define DMCU_DPRX_INTERRUPT_STATUS1__DPRX_DPHY_P0_EXCESSIVE_ERROR_INT_OCCURRED__SHIFT                         0x14
#define DMCU_DPRX_INTERRUPT_STATUS1__DPRX_DPHY_P0_EXCESSIVE_ERROR_INT_CLEAR__SHIFT                            0x14
#define DMCU_DPRX_INTERRUPT_STATUS1__DPRX_DPHY_P0_DESKEW_FIFO_OVERFLOW_INT_OCCURRED__SHIFT                    0x15
#define DMCU_DPRX_INTERRUPT_STATUS1__DPRX_DPHY_P0_DESKEW_FIFO_OVERFLOW_INT_CLEAR__SHIFT                       0x15
#define DMCU_DPRX_INTERRUPT_STATUS1__DPRX_AUX_P0_AUX_INT_OCCURRED__SHIFT                                      0x16
#define DMCU_DPRX_INTERRUPT_STATUS1__DPRX_AUX_P0_AUX_INT_CLEAR__SHIFT                                         0x16
#define DMCU_DPRX_INTERRUPT_STATUS1__DPRX_AUX_P0_I2C_INT_OCCURRED__SHIFT                                      0x17
#define DMCU_DPRX_INTERRUPT_STATUS1__DPRX_AUX_P0_I2C_INT_CLEAR__SHIFT                                         0x17
#define DMCU_DPRX_INTERRUPT_STATUS1__DPRX_AUX_P0_CPU_INT_OCCURRED__SHIFT                                      0x18
#define DMCU_DPRX_INTERRUPT_STATUS1__DPRX_AUX_P0_CPU_INT_CLEAR__SHIFT                                         0x18
#define DMCU_DPRX_INTERRUPT_STATUS1__DPRX_AUX_P0_MSG1_TIMEOUT_INT_OCCURRED__SHIFT                             0x19
#define DMCU_DPRX_INTERRUPT_STATUS1__DPRX_AUX_P0_MSG1_TIMEOUT_INT_CLEAR__SHIFT                                0x19
#define DMCU_DPRX_INTERRUPT_STATUS1__DPRX_AUX_P0_MSG2_TIMEOUT_INT_OCCURRED__SHIFT                             0x1a
#define DMCU_DPRX_INTERRUPT_STATUS1__DPRX_AUX_P0_MSG2_TIMEOUT_INT_CLEAR__SHIFT                                0x1a
#define DMCU_DPRX_INTERRUPT_STATUS1__DPRX_AUX_P0_MSG3_TIMEOUT_INT_OCCURRED__SHIFT                             0x1b
#define DMCU_DPRX_INTERRUPT_STATUS1__DPRX_AUX_P0_MSG3_TIMEOUT_INT_CLEAR__SHIFT                                0x1b
#define DMCU_DPRX_INTERRUPT_STATUS1__DPRX_AUX_P0_MSG4_TIMEOUT_INT_OCCURRED__SHIFT                             0x1c
#define DMCU_DPRX_INTERRUPT_STATUS1__DPRX_AUX_P0_MSG4_TIMEOUT_INT_CLEAR__SHIFT                                0x1c
#define DMCU_DPRX_INTERRUPT_STATUS1__DPRX_SD0P0_MSA_RECEIVED_INT_OCCURRED_MASK                                0x00000001L
#define DMCU_DPRX_INTERRUPT_STATUS1__DPRX_SD0P0_MSA_RECEIVED_INT_CLEAR_MASK                                   0x00000001L
#define DMCU_DPRX_INTERRUPT_STATUS1__DPRX_SD0P0_VBID_VID_STREAM_STATUS_TOGGLED_INT_OCCURRED_MASK              0x00000002L
#define DMCU_DPRX_INTERRUPT_STATUS1__DPRX_SD0P0_VBID_VID_STREAM_STATUS_TOGGLED_INT_CLEAR_MASK                 0x00000002L
#define DMCU_DPRX_INTERRUPT_STATUS1__DPRX_SD0P0_VERTICAL_INT0_OCCURRED_MASK                                   0x00000004L
#define DMCU_DPRX_INTERRUPT_STATUS1__DPRX_SD0P0_VERTICAL_INT0_CLEAR_MASK                                      0x00000004L
#define DMCU_DPRX_INTERRUPT_STATUS1__DPRX_SD0P0_VERTICAL_INT1_OCCURRED_MASK                                   0x00000008L
#define DMCU_DPRX_INTERRUPT_STATUS1__DPRX_SD0P0_VERTICAL_INT1_CLEAR_MASK                                      0x00000008L
#define DMCU_DPRX_INTERRUPT_STATUS1__DPRX_SD0P0_SDP_RECEIVED_INT_OCCURRED_MASK                                0x00000010L
#define DMCU_DPRX_INTERRUPT_STATUS1__DPRX_SD0P0_SDP_RECEIVED_INT_CLEAR_MASK                                   0x00000010L
#define DMCU_DPRX_INTERRUPT_STATUS1__DPRX_SD1P0_MSA_RECEIVED_INT_OCCURRED_MASK                                0x00000020L
#define DMCU_DPRX_INTERRUPT_STATUS1__DPRX_SD1P0_MSA_RECEIVED_INT_CLEAR_MASK                                   0x00000020L
#define DMCU_DPRX_INTERRUPT_STATUS1__DPRX_SD1P0_VBID_VID_STREAM_STATUS_TOGGLED_INT_OCCURRED_MASK              0x00000040L
#define DMCU_DPRX_INTERRUPT_STATUS1__DPRX_SD1P0_VBID_VID_STREAM_STATUS_TOGGLED_INT_CLEAR_MASK                 0x00000040L
#define DMCU_DPRX_INTERRUPT_STATUS1__DPRX_SD1P0_VERTICAL_INT0_OCCURRED_MASK                                   0x00000080L
#define DMCU_DPRX_INTERRUPT_STATUS1__DPRX_SD1P0_VERTICAL_INT0_CLEAR_MASK                                      0x00000080L
#define DMCU_DPRX_INTERRUPT_STATUS1__DPRX_SD1P0_VERTICAL_INT1_OCCURRED_MASK                                   0x00000100L
#define DMCU_DPRX_INTERRUPT_STATUS1__DPRX_SD1P0_VERTICAL_INT1_CLEAR_MASK                                      0x00000100L
#define DMCU_DPRX_INTERRUPT_STATUS1__DPRX_SD1P0_SDP_RECEIVED_INT_OCCURRED_MASK                                0x00000200L
#define DMCU_DPRX_INTERRUPT_STATUS1__DPRX_SD1P0_SDP_RECEIVED_INT_CLEAR_MASK                                   0x00000200L
#define DMCU_DPRX_INTERRUPT_STATUS1__DPRX_DPHY_P0_BS_INTERVAL_ERROR_THRESH_EXCEEDED_INT_OCCURRED_MASK         0x00000400L
#define DMCU_DPRX_INTERRUPT_STATUS1__DPRX_DPHY_P0_BS_INTERVAL_ERROR_THRESH_EXCEEDED_INT_CLEAR_MASK            0x00000400L
#define DMCU_DPRX_INTERRUPT_STATUS1__DPRX_DPHY_P0_SR_INTERVAL_ERROR_THRESH_EXCEEDED_INT_OCCURRED_MASK         0x00000800L
#define DMCU_DPRX_INTERRUPT_STATUS1__DPRX_DPHY_P0_SR_INTERVAL_ERROR_THRESH_EXCEEDED_INT_CLEAR_MASK            0x00000800L
#define DMCU_DPRX_INTERRUPT_STATUS1__DPRX_DPHY_P0_SYMBOL_ERROR_THRESH_EXCEEDED_INT_OCCURRED_MASK              0x00001000L
#define DMCU_DPRX_INTERRUPT_STATUS1__DPRX_DPHY_P0_SYMBOL_ERROR_THRESH_EXCEEDED_INT_CLEAR_MASK                 0x00001000L
#define DMCU_DPRX_INTERRUPT_STATUS1__DPRX_DPHY_P0_DISPARITY_ERROR_THRESH_EXCEEDED_INT_OCCURRED_MASK           0x00002000L
#define DMCU_DPRX_INTERRUPT_STATUS1__DPRX_DPHY_P0_DISPARITY_ERROR_THRESH_EXCEEDED_INT_CLEAR_MASK              0x00002000L
#define DMCU_DPRX_INTERRUPT_STATUS1__DPRX_DPHY_P0_TRAINING_ERROR_THRESH_EXCEEDED_INT_OCCURRED_MASK            0x00004000L
#define DMCU_DPRX_INTERRUPT_STATUS1__DPRX_DPHY_P0_TRAINING_ERROR_THRESH_EXCEEDED_INT_CLEAR_MASK               0x00004000L
#define DMCU_DPRX_INTERRUPT_STATUS1__DPRX_DPHY_P0_TEST_PATTERN_ERROR_THRESH_EXCEEDED_INT_OCCURRED_MASK        0x00008000L
#define DMCU_DPRX_INTERRUPT_STATUS1__DPRX_DPHY_P0_TEST_PATTERN_ERROR_THRESH_EXCEEDED_INT_CLEAR_MASK           0x00008000L
#define DMCU_DPRX_INTERRUPT_STATUS1__DPRX_DPHY_P0_ECF_ERROR_THRESH_EXCEEDED_INT_OCCURRED_MASK                 0x00010000L
#define DMCU_DPRX_INTERRUPT_STATUS1__DPRX_DPHY_P0_ECF_ERROR_THRESH_EXCEEDED_INT_CLEAR_MASK                    0x00010000L
#define DMCU_DPRX_INTERRUPT_STATUS1__DPRX_DPHY_P0_DETECT_SR_LOCK_INT_OCCURRED_MASK                            0x00020000L
#define DMCU_DPRX_INTERRUPT_STATUS1__DPRX_DPHY_P0_DETECT_SR_LOCK_INT_CLEAR_MASK                               0x00020000L
#define DMCU_DPRX_INTERRUPT_STATUS1__DPRX_DPHY_P0_LOSS_OF_ALIGN_INT_OCCURRED_MASK                             0x00040000L
#define DMCU_DPRX_INTERRUPT_STATUS1__DPRX_DPHY_P0_LOSS_OF_ALIGN_INT_CLEAR_MASK                                0x00040000L
#define DMCU_DPRX_INTERRUPT_STATUS1__DPRX_DPHY_P0_LOSS_OF_DESKEW_INT_OCCURRED_MASK                            0x00080000L
#define DMCU_DPRX_INTERRUPT_STATUS1__DPRX_DPHY_P0_LOSS_OF_DESKEW_INT_CLEAR_MASK                               0x00080000L
#define DMCU_DPRX_INTERRUPT_STATUS1__DPRX_DPHY_P0_EXCESSIVE_ERROR_INT_OCCURRED_MASK                           0x00100000L
#define DMCU_DPRX_INTERRUPT_STATUS1__DPRX_DPHY_P0_EXCESSIVE_ERROR_INT_CLEAR_MASK                              0x00100000L
#define DMCU_DPRX_INTERRUPT_STATUS1__DPRX_DPHY_P0_DESKEW_FIFO_OVERFLOW_INT_OCCURRED_MASK                      0x00200000L
#define DMCU_DPRX_INTERRUPT_STATUS1__DPRX_DPHY_P0_DESKEW_FIFO_OVERFLOW_INT_CLEAR_MASK                         0x00200000L
#define DMCU_DPRX_INTERRUPT_STATUS1__DPRX_AUX_P0_AUX_INT_OCCURRED_MASK                                        0x00400000L
#define DMCU_DPRX_INTERRUPT_STATUS1__DPRX_AUX_P0_AUX_INT_CLEAR_MASK                                           0x00400000L
#define DMCU_DPRX_INTERRUPT_STATUS1__DPRX_AUX_P0_I2C_INT_OCCURRED_MASK                                        0x00800000L
#define DMCU_DPRX_INTERRUPT_STATUS1__DPRX_AUX_P0_I2C_INT_CLEAR_MASK                                           0x00800000L
#define DMCU_DPRX_INTERRUPT_STATUS1__DPRX_AUX_P0_CPU_INT_OCCURRED_MASK                                        0x01000000L
#define DMCU_DPRX_INTERRUPT_STATUS1__DPRX_AUX_P0_CPU_INT_CLEAR_MASK                                           0x01000000L
#define DMCU_DPRX_INTERRUPT_STATUS1__DPRX_AUX_P0_MSG1_TIMEOUT_INT_OCCURRED_MASK                               0x02000000L
#define DMCU_DPRX_INTERRUPT_STATUS1__DPRX_AUX_P0_MSG1_TIMEOUT_INT_CLEAR_MASK                                  0x02000000L
#define DMCU_DPRX_INTERRUPT_STATUS1__DPRX_AUX_P0_MSG2_TIMEOUT_INT_OCCURRED_MASK                               0x04000000L
#define DMCU_DPRX_INTERRUPT_STATUS1__DPRX_AUX_P0_MSG2_TIMEOUT_INT_CLEAR_MASK                                  0x04000000L
#define DMCU_DPRX_INTERRUPT_STATUS1__DPRX_AUX_P0_MSG3_TIMEOUT_INT_OCCURRED_MASK                               0x08000000L
#define DMCU_DPRX_INTERRUPT_STATUS1__DPRX_AUX_P0_MSG3_TIMEOUT_INT_CLEAR_MASK                                  0x08000000L
#define DMCU_DPRX_INTERRUPT_STATUS1__DPRX_AUX_P0_MSG4_TIMEOUT_INT_OCCURRED_MASK                               0x10000000L
#define DMCU_DPRX_INTERRUPT_STATUS1__DPRX_AUX_P0_MSG4_TIMEOUT_INT_CLEAR_MASK                                  0x10000000L
//DMCU_DPRX_INTERRUPT_TO_UC_EN_MASK1
#define DMCU_DPRX_INTERRUPT_TO_UC_EN_MASK1__DPRX_SD0P0_MSA_RECEIVED_INT_TO_UC_EN__SHIFT                       0x0
#define DMCU_DPRX_INTERRUPT_TO_UC_EN_MASK1__DPRX_SD0P0_VBID_VID_STREAM_STATUS_TOGGLED_INT_TO_UC_EN__SHIFT     0x1
#define DMCU_DPRX_INTERRUPT_TO_UC_EN_MASK1__DPRX_SD0P0_VERTICAL_INT0_TO_UC_EN__SHIFT                          0x2
#define DMCU_DPRX_INTERRUPT_TO_UC_EN_MASK1__DPRX_SD0P0_VERTICAL_INT1_TO_UC_EN__SHIFT                          0x3
#define DMCU_DPRX_INTERRUPT_TO_UC_EN_MASK1__DPRX_SD0P0_SDP_RECEIVED_INT_TO_UC_EN__SHIFT                       0x4
#define DMCU_DPRX_INTERRUPT_TO_UC_EN_MASK1__DPRX_SD1P0_MSA_RECEIVED_INT_TO_UC_EN__SHIFT                       0x5
#define DMCU_DPRX_INTERRUPT_TO_UC_EN_MASK1__DPRX_SD1P0_VBID_VID_STREAM_STATUS_TOGGLED_INT_TO_UC_EN__SHIFT     0x6
#define DMCU_DPRX_INTERRUPT_TO_UC_EN_MASK1__DPRX_SD1P0_VERTICAL_INT0_TO_UC_EN__SHIFT                          0x7
#define DMCU_DPRX_INTERRUPT_TO_UC_EN_MASK1__DPRX_SD1P0_VERTICAL_INT1_TO_UC_EN__SHIFT                          0x8
#define DMCU_DPRX_INTERRUPT_TO_UC_EN_MASK1__DPRX_SD1P0_SDP_RECEIVED_INT_TO_UC_EN__SHIFT                       0x9
#define DMCU_DPRX_INTERRUPT_TO_UC_EN_MASK1__DPRX_DPHY_P0_BS_INTERVAL_ERROR_THRESH_EXCEEDED_INT_TO_UC_EN__SHIFT  0xa
#define DMCU_DPRX_INTERRUPT_TO_UC_EN_MASK1__DPRX_DPHY_P0_SR_INTERVAL_ERROR_THRESH_EXCEEDED_INT_TO_UC_EN__SHIFT  0xb
#define DMCU_DPRX_INTERRUPT_TO_UC_EN_MASK1__DPRX_DPHY_P0_SYMBOL_ERROR_THRESH_EXCEEDED_INT_TO_UC_EN__SHIFT     0xc
#define DMCU_DPRX_INTERRUPT_TO_UC_EN_MASK1__DPRX_DPHY_P0_DISPARITY_ERROR_THRESH_EXCEEDED_INT_TO_UC_EN__SHIFT  0xd
#define DMCU_DPRX_INTERRUPT_TO_UC_EN_MASK1__DPRX_DPHY_P0_TRAINING_ERROR_THRESH_EXCEEDED_INT_TO_UC_EN__SHIFT   0xe
#define DMCU_DPRX_INTERRUPT_TO_UC_EN_MASK1__DPRX_DPHY_P0_TEST_PATTERN_ERROR_THRESH_EXCEEDED_INT_TO_UC_EN__SHIFT  0xf
#define DMCU_DPRX_INTERRUPT_TO_UC_EN_MASK1__DPRX_DPHY_P0_ECF_ERROR_THRESH_EXCEEDED_INT_TO_UC_EN__SHIFT        0x10
#define DMCU_DPRX_INTERRUPT_TO_UC_EN_MASK1__DPRX_DPHY_P0_DETECT_SR_LOCK_INT_TO_UC_EN__SHIFT                   0x11
#define DMCU_DPRX_INTERRUPT_TO_UC_EN_MASK1__DPRX_DPHY_P0_LOSS_OF_ALIGN_INT_TO_UC_EN__SHIFT                    0x12
#define DMCU_DPRX_INTERRUPT_TO_UC_EN_MASK1__DPRX_DPHY_P0_LOSS_OF_DESKEW_INT_TO_UC_EN__SHIFT                   0x13
#define DMCU_DPRX_INTERRUPT_TO_UC_EN_MASK1__DPRX_DPHY_P0_EXCESSIVE_ERROR_INT_TO_UC_EN__SHIFT                  0x14
#define DMCU_DPRX_INTERRUPT_TO_UC_EN_MASK1__DPRX_DPHY_P0_DESKEW_FIFO_OVERFLOW_INT_TO_UC_EN__SHIFT             0x15
#define DMCU_DPRX_INTERRUPT_TO_UC_EN_MASK1__DPRX_AUX_P0_AUX_INT_TO_UC_EN__SHIFT                               0x16
#define DMCU_DPRX_INTERRUPT_TO_UC_EN_MASK1__DPRX_AUX_P0_I2C_INT_TO_UC_EN__SHIFT                               0x17
#define DMCU_DPRX_INTERRUPT_TO_UC_EN_MASK1__DPRX_AUX_P0_CPU_INT_TO_UC_EN__SHIFT                               0x18
#define DMCU_DPRX_INTERRUPT_TO_UC_EN_MASK1__DPRX_AUX_P0_MSG1_TIMEOUT_INT_TO_UC_EN__SHIFT                      0x19
#define DMCU_DPRX_INTERRUPT_TO_UC_EN_MASK1__DPRX_AUX_P0_MSG2_TIMEOUT_INT_TO_UC_EN__SHIFT                      0x1a
#define DMCU_DPRX_INTERRUPT_TO_UC_EN_MASK1__DPRX_AUX_P0_MSG3_TIMEOUT_INT_TO_UC_EN__SHIFT                      0x1b
#define DMCU_DPRX_INTERRUPT_TO_UC_EN_MASK1__DPRX_AUX_P0_MSG4_TIMEOUT_INT_TO_UC_EN__SHIFT                      0x1c
#define DMCU_DPRX_INTERRUPT_TO_UC_EN_MASK1__DPRX_SD0P0_MSA_RECEIVED_INT_TO_UC_EN_MASK                         0x00000001L
#define DMCU_DPRX_INTERRUPT_TO_UC_EN_MASK1__DPRX_SD0P0_VBID_VID_STREAM_STATUS_TOGGLED_INT_TO_UC_EN_MASK       0x00000002L
#define DMCU_DPRX_INTERRUPT_TO_UC_EN_MASK1__DPRX_SD0P0_VERTICAL_INT0_TO_UC_EN_MASK                            0x00000004L
#define DMCU_DPRX_INTERRUPT_TO_UC_EN_MASK1__DPRX_SD0P0_VERTICAL_INT1_TO_UC_EN_MASK                            0x00000008L
#define DMCU_DPRX_INTERRUPT_TO_UC_EN_MASK1__DPRX_SD0P0_SDP_RECEIVED_INT_TO_UC_EN_MASK                         0x00000010L
#define DMCU_DPRX_INTERRUPT_TO_UC_EN_MASK1__DPRX_SD1P0_MSA_RECEIVED_INT_TO_UC_EN_MASK                         0x00000020L
#define DMCU_DPRX_INTERRUPT_TO_UC_EN_MASK1__DPRX_SD1P0_VBID_VID_STREAM_STATUS_TOGGLED_INT_TO_UC_EN_MASK       0x00000040L
#define DMCU_DPRX_INTERRUPT_TO_UC_EN_MASK1__DPRX_SD1P0_VERTICAL_INT0_TO_UC_EN_MASK                            0x00000080L
#define DMCU_DPRX_INTERRUPT_TO_UC_EN_MASK1__DPRX_SD1P0_VERTICAL_INT1_TO_UC_EN_MASK                            0x00000100L
#define DMCU_DPRX_INTERRUPT_TO_UC_EN_MASK1__DPRX_SD1P0_SDP_RECEIVED_INT_TO_UC_EN_MASK                         0x00000200L
#define DMCU_DPRX_INTERRUPT_TO_UC_EN_MASK1__DPRX_DPHY_P0_BS_INTERVAL_ERROR_THRESH_EXCEEDED_INT_TO_UC_EN_MASK  0x00000400L
#define DMCU_DPRX_INTERRUPT_TO_UC_EN_MASK1__DPRX_DPHY_P0_SR_INTERVAL_ERROR_THRESH_EXCEEDED_INT_TO_UC_EN_MASK  0x00000800L
#define DMCU_DPRX_INTERRUPT_TO_UC_EN_MASK1__DPRX_DPHY_P0_SYMBOL_ERROR_THRESH_EXCEEDED_INT_TO_UC_EN_MASK       0x00001000L
#define DMCU_DPRX_INTERRUPT_TO_UC_EN_MASK1__DPRX_DPHY_P0_DISPARITY_ERROR_THRESH_EXCEEDED_INT_TO_UC_EN_MASK    0x00002000L
#define DMCU_DPRX_INTERRUPT_TO_UC_EN_MASK1__DPRX_DPHY_P0_TRAINING_ERROR_THRESH_EXCEEDED_INT_TO_UC_EN_MASK     0x00004000L
#define DMCU_DPRX_INTERRUPT_TO_UC_EN_MASK1__DPRX_DPHY_P0_TEST_PATTERN_ERROR_THRESH_EXCEEDED_INT_TO_UC_EN_MASK  0x00008000L
#define DMCU_DPRX_INTERRUPT_TO_UC_EN_MASK1__DPRX_DPHY_P0_ECF_ERROR_THRESH_EXCEEDED_INT_TO_UC_EN_MASK          0x00010000L
#define DMCU_DPRX_INTERRUPT_TO_UC_EN_MASK1__DPRX_DPHY_P0_DETECT_SR_LOCK_INT_TO_UC_EN_MASK                     0x00020000L
#define DMCU_DPRX_INTERRUPT_TO_UC_EN_MASK1__DPRX_DPHY_P0_LOSS_OF_ALIGN_INT_TO_UC_EN_MASK                      0x00040000L
#define DMCU_DPRX_INTERRUPT_TO_UC_EN_MASK1__DPRX_DPHY_P0_LOSS_OF_DESKEW_INT_TO_UC_EN_MASK                     0x00080000L
#define DMCU_DPRX_INTERRUPT_TO_UC_EN_MASK1__DPRX_DPHY_P0_EXCESSIVE_ERROR_INT_TO_UC_EN_MASK                    0x00100000L
#define DMCU_DPRX_INTERRUPT_TO_UC_EN_MASK1__DPRX_DPHY_P0_DESKEW_FIFO_OVERFLOW_INT_TO_UC_EN_MASK               0x00200000L
#define DMCU_DPRX_INTERRUPT_TO_UC_EN_MASK1__DPRX_AUX_P0_AUX_INT_TO_UC_EN_MASK                                 0x00400000L
#define DMCU_DPRX_INTERRUPT_TO_UC_EN_MASK1__DPRX_AUX_P0_I2C_INT_TO_UC_EN_MASK                                 0x00800000L
#define DMCU_DPRX_INTERRUPT_TO_UC_EN_MASK1__DPRX_AUX_P0_CPU_INT_TO_UC_EN_MASK                                 0x01000000L
#define DMCU_DPRX_INTERRUPT_TO_UC_EN_MASK1__DPRX_AUX_P0_MSG1_TIMEOUT_INT_TO_UC_EN_MASK                        0x02000000L
#define DMCU_DPRX_INTERRUPT_TO_UC_EN_MASK1__DPRX_AUX_P0_MSG2_TIMEOUT_INT_TO_UC_EN_MASK                        0x04000000L
#define DMCU_DPRX_INTERRUPT_TO_UC_EN_MASK1__DPRX_AUX_P0_MSG3_TIMEOUT_INT_TO_UC_EN_MASK                        0x08000000L
#define DMCU_DPRX_INTERRUPT_TO_UC_EN_MASK1__DPRX_AUX_P0_MSG4_TIMEOUT_INT_TO_UC_EN_MASK                        0x10000000L
//DMCU_DPRX_INTERRUPT_TO_UC_XIRQ_IRQ_SEL1
#define DMCU_DPRX_INTERRUPT_TO_UC_XIRQ_IRQ_SEL1__DPRX_SD0P0_MSA_RECEIVED_INT_XIRQ_IRQ_SEL__SHIFT              0x0
#define DMCU_DPRX_INTERRUPT_TO_UC_XIRQ_IRQ_SEL1__DPRX_SD0P0_VBID_VID_STREAM_STATUS_TOGGLED_INT_XIRQ_IRQ_SEL__SHIFT  0x1
#define DMCU_DPRX_INTERRUPT_TO_UC_XIRQ_IRQ_SEL1__DPRX_SD0P0_VERTICAL_INT0_XIRQ_IRQ_SEL__SHIFT                 0x2
#define DMCU_DPRX_INTERRUPT_TO_UC_XIRQ_IRQ_SEL1__DPRX_SD0P0_VERTICAL_INT1_XIRQ_IRQ_SEL__SHIFT                 0x3
#define DMCU_DPRX_INTERRUPT_TO_UC_XIRQ_IRQ_SEL1__DPRX_SD0P0_SDP_RECEIVED_INT_XIRQ_IRQ_SEL__SHIFT              0x4
#define DMCU_DPRX_INTERRUPT_TO_UC_XIRQ_IRQ_SEL1__DPRX_SD1P0_MSA_RECEIVED_INT_XIRQ_IRQ_SEL__SHIFT              0x5
#define DMCU_DPRX_INTERRUPT_TO_UC_XIRQ_IRQ_SEL1__DPRX_SD1P0_VBID_VID_STREAM_STATUS_TOGGLED_INT_XIRQ_IRQ_SEL__SHIFT  0x6
#define DMCU_DPRX_INTERRUPT_TO_UC_XIRQ_IRQ_SEL1__DPRX_SD1P0_VERTICAL_INT0_XIRQ_IRQ_SEL__SHIFT                 0x7
#define DMCU_DPRX_INTERRUPT_TO_UC_XIRQ_IRQ_SEL1__DPRX_SD1P0_VERTICAL_INT1_XIRQ_IRQ_SEL__SHIFT                 0x8
#define DMCU_DPRX_INTERRUPT_TO_UC_XIRQ_IRQ_SEL1__DPRX_SD1P0_SDP_RECEIVED_INT_XIRQ_IRQ_SEL__SHIFT              0x9
#define DMCU_DPRX_INTERRUPT_TO_UC_XIRQ_IRQ_SEL1__DPRX_DPHY_P0_BS_INTERVAL_ERROR_THRESH_EXCEEDED_INT_XIRQ_IRQ_SEL__SHIFT  0xa
#define DMCU_DPRX_INTERRUPT_TO_UC_XIRQ_IRQ_SEL1__DPRX_DPHY_P0_SR_INTERVAL_ERROR_THRESH_EXCEEDED_INT_XIRQ_IRQ_SEL__SHIFT  0xb
#define DMCU_DPRX_INTERRUPT_TO_UC_XIRQ_IRQ_SEL1__DPRX_DPHY_P0_SYMBOL_ERROR_THRESH_EXCEEDED_INT_XIRQ_IRQ_SEL__SHIFT  0xc
#define DMCU_DPRX_INTERRUPT_TO_UC_XIRQ_IRQ_SEL1__DPRX_DPHY_P0_DISPARITY_ERROR_THRESH_EXCEEDED_INT_XIRQ_IRQ_SEL__SHIFT  0xd
#define DMCU_DPRX_INTERRUPT_TO_UC_XIRQ_IRQ_SEL1__DPRX_DPHY_P0_TRAINING_ERROR_THRESH_EXCEEDED_INT_XIRQ_IRQ_SEL__SHIFT  0xe
#define DMCU_DPRX_INTERRUPT_TO_UC_XIRQ_IRQ_SEL1__DPRX_DPHY_P0_TEST_PATTERN_ERROR_THRESH_EXCEEDED_INT_XIRQ_IRQ_SEL__SHIFT  0xf
#define DMCU_DPRX_INTERRUPT_TO_UC_XIRQ_IRQ_SEL1__DPRX_DPHY_P0_ECF_ERROR_THRESH_EXCEEDED_INT_XIRQ_IRQ_SEL__SHIFT  0x10
#define DMCU_DPRX_INTERRUPT_TO_UC_XIRQ_IRQ_SEL1__DPRX_DPHY_P0_DETECT_SR_LOCK_INT_XIRQ_IRQ_SEL__SHIFT          0x11
#define DMCU_DPRX_INTERRUPT_TO_UC_XIRQ_IRQ_SEL1__DPRX_DPHY_P0_LOSS_OF_ALIGN_INT_XIRQ_IRQ_SEL__SHIFT           0x12
#define DMCU_DPRX_INTERRUPT_TO_UC_XIRQ_IRQ_SEL1__DPRX_DPHY_P0_LOSS_OF_DESKEW_INT_XIRQ_IRQ_SEL__SHIFT          0x13
#define DMCU_DPRX_INTERRUPT_TO_UC_XIRQ_IRQ_SEL1__DPRX_DPHY_P0_EXCESSIVE_ERROR_INT_XIRQ_IRQ_SEL__SHIFT         0x14
#define DMCU_DPRX_INTERRUPT_TO_UC_XIRQ_IRQ_SEL1__DPRX_DPHY_P0_DESKEW_FIFO_OVERFLOW_INT_XIRQ_IRQ_SEL__SHIFT    0x15
#define DMCU_DPRX_INTERRUPT_TO_UC_XIRQ_IRQ_SEL1__DPRX_AUX_P0_AUX_INT_XIRQ_IRQ_SEL__SHIFT                      0x16
#define DMCU_DPRX_INTERRUPT_TO_UC_XIRQ_IRQ_SEL1__DPRX_AUX_P0_I2C_INT_XIRQ_IRQ_SEL__SHIFT                      0x17
#define DMCU_DPRX_INTERRUPT_TO_UC_XIRQ_IRQ_SEL1__DPRX_AUX_P0_CPU_INT_XIRQ_IRQ_SEL__SHIFT                      0x18
#define DMCU_DPRX_INTERRUPT_TO_UC_XIRQ_IRQ_SEL1__DPRX_AUX_P0_MSG1_TIMEOUT_INT_XIRQ_IRQ_SEL__SHIFT             0x19
#define DMCU_DPRX_INTERRUPT_TO_UC_XIRQ_IRQ_SEL1__DPRX_AUX_P0_MSG2_TIMEOUT_INT_XIRQ_IRQ_SEL__SHIFT             0x1a
#define DMCU_DPRX_INTERRUPT_TO_UC_XIRQ_IRQ_SEL1__DPRX_AUX_P0_MSG3_TIMEOUT_INT_XIRQ_IRQ_SEL__SHIFT             0x1b
#define DMCU_DPRX_INTERRUPT_TO_UC_XIRQ_IRQ_SEL1__DPRX_AUX_P0_MSG4_TIMEOUT_INT_XIRQ_IRQ_SEL__SHIFT             0x1c
#define DMCU_DPRX_INTERRUPT_TO_UC_XIRQ_IRQ_SEL1__DPRX_SD0P0_MSA_RECEIVED_INT_XIRQ_IRQ_SEL_MASK                0x00000001L
#define DMCU_DPRX_INTERRUPT_TO_UC_XIRQ_IRQ_SEL1__DPRX_SD0P0_VBID_VID_STREAM_STATUS_TOGGLED_INT_XIRQ_IRQ_SEL_MASK  0x00000002L
#define DMCU_DPRX_INTERRUPT_TO_UC_XIRQ_IRQ_SEL1__DPRX_SD0P0_VERTICAL_INT0_XIRQ_IRQ_SEL_MASK                   0x00000004L
#define DMCU_DPRX_INTERRUPT_TO_UC_XIRQ_IRQ_SEL1__DPRX_SD0P0_VERTICAL_INT1_XIRQ_IRQ_SEL_MASK                   0x00000008L
#define DMCU_DPRX_INTERRUPT_TO_UC_XIRQ_IRQ_SEL1__DPRX_SD0P0_SDP_RECEIVED_INT_XIRQ_IRQ_SEL_MASK                0x00000010L
#define DMCU_DPRX_INTERRUPT_TO_UC_XIRQ_IRQ_SEL1__DPRX_SD1P0_MSA_RECEIVED_INT_XIRQ_IRQ_SEL_MASK                0x00000020L
#define DMCU_DPRX_INTERRUPT_TO_UC_XIRQ_IRQ_SEL1__DPRX_SD1P0_VBID_VID_STREAM_STATUS_TOGGLED_INT_XIRQ_IRQ_SEL_MASK  0x00000040L
#define DMCU_DPRX_INTERRUPT_TO_UC_XIRQ_IRQ_SEL1__DPRX_SD1P0_VERTICAL_INT0_XIRQ_IRQ_SEL_MASK                   0x00000080L
#define DMCU_DPRX_INTERRUPT_TO_UC_XIRQ_IRQ_SEL1__DPRX_SD1P0_VERTICAL_INT1_XIRQ_IRQ_SEL_MASK                   0x00000100L
#define DMCU_DPRX_INTERRUPT_TO_UC_XIRQ_IRQ_SEL1__DPRX_SD1P0_SDP_RECEIVED_INT_XIRQ_IRQ_SEL_MASK                0x00000200L
#define DMCU_DPRX_INTERRUPT_TO_UC_XIRQ_IRQ_SEL1__DPRX_DPHY_P0_BS_INTERVAL_ERROR_THRESH_EXCEEDED_INT_XIRQ_IRQ_SEL_MASK  0x00000400L
#define DMCU_DPRX_INTERRUPT_TO_UC_XIRQ_IRQ_SEL1__DPRX_DPHY_P0_SR_INTERVAL_ERROR_THRESH_EXCEEDED_INT_XIRQ_IRQ_SEL_MASK  0x00000800L
#define DMCU_DPRX_INTERRUPT_TO_UC_XIRQ_IRQ_SEL1__DPRX_DPHY_P0_SYMBOL_ERROR_THRESH_EXCEEDED_INT_XIRQ_IRQ_SEL_MASK  0x00001000L
#define DMCU_DPRX_INTERRUPT_TO_UC_XIRQ_IRQ_SEL1__DPRX_DPHY_P0_DISPARITY_ERROR_THRESH_EXCEEDED_INT_XIRQ_IRQ_SEL_MASK  0x00002000L
#define DMCU_DPRX_INTERRUPT_TO_UC_XIRQ_IRQ_SEL1__DPRX_DPHY_P0_TRAINING_ERROR_THRESH_EXCEEDED_INT_XIRQ_IRQ_SEL_MASK  0x00004000L
#define DMCU_DPRX_INTERRUPT_TO_UC_XIRQ_IRQ_SEL1__DPRX_DPHY_P0_TEST_PATTERN_ERROR_THRESH_EXCEEDED_INT_XIRQ_IRQ_SEL_MASK  0x00008000L
#define DMCU_DPRX_INTERRUPT_TO_UC_XIRQ_IRQ_SEL1__DPRX_DPHY_P0_ECF_ERROR_THRESH_EXCEEDED_INT_XIRQ_IRQ_SEL_MASK  0x00010000L
#define DMCU_DPRX_INTERRUPT_TO_UC_XIRQ_IRQ_SEL1__DPRX_DPHY_P0_DETECT_SR_LOCK_INT_XIRQ_IRQ_SEL_MASK            0x00020000L
#define DMCU_DPRX_INTERRUPT_TO_UC_XIRQ_IRQ_SEL1__DPRX_DPHY_P0_LOSS_OF_ALIGN_INT_XIRQ_IRQ_SEL_MASK             0x00040000L
#define DMCU_DPRX_INTERRUPT_TO_UC_XIRQ_IRQ_SEL1__DPRX_DPHY_P0_LOSS_OF_DESKEW_INT_XIRQ_IRQ_SEL_MASK            0x00080000L
#define DMCU_DPRX_INTERRUPT_TO_UC_XIRQ_IRQ_SEL1__DPRX_DPHY_P0_EXCESSIVE_ERROR_INT_XIRQ_IRQ_SEL_MASK           0x00100000L
#define DMCU_DPRX_INTERRUPT_TO_UC_XIRQ_IRQ_SEL1__DPRX_DPHY_P0_DESKEW_FIFO_OVERFLOW_INT_XIRQ_IRQ_SEL_MASK      0x00200000L
#define DMCU_DPRX_INTERRUPT_TO_UC_XIRQ_IRQ_SEL1__DPRX_AUX_P0_AUX_INT_XIRQ_IRQ_SEL_MASK                        0x00400000L
#define DMCU_DPRX_INTERRUPT_TO_UC_XIRQ_IRQ_SEL1__DPRX_AUX_P0_I2C_INT_XIRQ_IRQ_SEL_MASK                        0x00800000L
#define DMCU_DPRX_INTERRUPT_TO_UC_XIRQ_IRQ_SEL1__DPRX_AUX_P0_CPU_INT_XIRQ_IRQ_SEL_MASK                        0x01000000L
#define DMCU_DPRX_INTERRUPT_TO_UC_XIRQ_IRQ_SEL1__DPRX_AUX_P0_MSG1_TIMEOUT_INT_XIRQ_IRQ_SEL_MASK               0x02000000L
#define DMCU_DPRX_INTERRUPT_TO_UC_XIRQ_IRQ_SEL1__DPRX_AUX_P0_MSG2_TIMEOUT_INT_XIRQ_IRQ_SEL_MASK               0x04000000L
#define DMCU_DPRX_INTERRUPT_TO_UC_XIRQ_IRQ_SEL1__DPRX_AUX_P0_MSG3_TIMEOUT_INT_XIRQ_IRQ_SEL_MASK               0x08000000L
#define DMCU_DPRX_INTERRUPT_TO_UC_XIRQ_IRQ_SEL1__DPRX_AUX_P0_MSG4_TIMEOUT_INT_XIRQ_IRQ_SEL_MASK               0x10000000L
//DC_ABM1_CNTL
#define DC_ABM1_CNTL__ABM1_EN__SHIFT                                                                          0x0
#define DC_ABM1_CNTL__ABM1_SOURCE_SELECT__SHIFT                                                               0x8
#define DC_ABM1_CNTL__ABM1_BLANK_MODE_SUPPORT_ENABLE__SHIFT                                                   0x1f
#define DC_ABM1_CNTL__ABM1_EN_MASK                                                                            0x00000001L
#define DC_ABM1_CNTL__ABM1_SOURCE_SELECT_MASK                                                                 0x00000700L
#define DC_ABM1_CNTL__ABM1_BLANK_MODE_SUPPORT_ENABLE_MASK                                                     0x80000000L
//DC_ABM1_IPCSC_COEFF_SEL
#define DC_ABM1_IPCSC_COEFF_SEL__ABM1_IPCSC_COEFF_SEL_B__SHIFT                                                0x0
#define DC_ABM1_IPCSC_COEFF_SEL__ABM1_IPCSC_COEFF_SEL_G__SHIFT                                                0x8
#define DC_ABM1_IPCSC_COEFF_SEL__ABM1_IPCSC_COEFF_SEL_R__SHIFT                                                0x10
#define DC_ABM1_IPCSC_COEFF_SEL__ABM1_HGLS_REG_LOCK__SHIFT                                                    0x1f
#define DC_ABM1_IPCSC_COEFF_SEL__ABM1_IPCSC_COEFF_SEL_B_MASK                                                  0x0000000FL
#define DC_ABM1_IPCSC_COEFF_SEL__ABM1_IPCSC_COEFF_SEL_G_MASK                                                  0x00000F00L
#define DC_ABM1_IPCSC_COEFF_SEL__ABM1_IPCSC_COEFF_SEL_R_MASK                                                  0x000F0000L
#define DC_ABM1_IPCSC_COEFF_SEL__ABM1_HGLS_REG_LOCK_MASK                                                      0x80000000L
//DC_ABM1_ACE_OFFSET_SLOPE_0
#define DC_ABM1_ACE_OFFSET_SLOPE_0__ABM1_ACE_SLOPE_0__SHIFT                                                   0x0
#define DC_ABM1_ACE_OFFSET_SLOPE_0__ABM1_ACE_OFFSET_0__SHIFT                                                  0x10
#define DC_ABM1_ACE_OFFSET_SLOPE_0__ABM1_ACE_LOCK__SHIFT                                                      0x1f
#define DC_ABM1_ACE_OFFSET_SLOPE_0__ABM1_ACE_SLOPE_0_MASK                                                     0x00007FFFL
#define DC_ABM1_ACE_OFFSET_SLOPE_0__ABM1_ACE_OFFSET_0_MASK                                                    0x07FF0000L
#define DC_ABM1_ACE_OFFSET_SLOPE_0__ABM1_ACE_LOCK_MASK                                                        0x80000000L
//DC_ABM1_ACE_OFFSET_SLOPE_1
#define DC_ABM1_ACE_OFFSET_SLOPE_1__ABM1_ACE_SLOPE_1__SHIFT                                                   0x0
#define DC_ABM1_ACE_OFFSET_SLOPE_1__ABM1_ACE_OFFSET_1__SHIFT                                                  0x10
#define DC_ABM1_ACE_OFFSET_SLOPE_1__ABM1_ACE_LOCK__SHIFT                                                      0x1f
#define DC_ABM1_ACE_OFFSET_SLOPE_1__ABM1_ACE_SLOPE_1_MASK                                                     0x00007FFFL
#define DC_ABM1_ACE_OFFSET_SLOPE_1__ABM1_ACE_OFFSET_1_MASK                                                    0x07FF0000L
#define DC_ABM1_ACE_OFFSET_SLOPE_1__ABM1_ACE_LOCK_MASK                                                        0x80000000L
//DC_ABM1_ACE_OFFSET_SLOPE_2
#define DC_ABM1_ACE_OFFSET_SLOPE_2__ABM1_ACE_SLOPE_2__SHIFT                                                   0x0
#define DC_ABM1_ACE_OFFSET_SLOPE_2__ABM1_ACE_OFFSET_2__SHIFT                                                  0x10
#define DC_ABM1_ACE_OFFSET_SLOPE_2__ABM1_ACE_LOCK__SHIFT                                                      0x1f
#define DC_ABM1_ACE_OFFSET_SLOPE_2__ABM1_ACE_SLOPE_2_MASK                                                     0x00007FFFL
#define DC_ABM1_ACE_OFFSET_SLOPE_2__ABM1_ACE_OFFSET_2_MASK                                                    0x07FF0000L
#define DC_ABM1_ACE_OFFSET_SLOPE_2__ABM1_ACE_LOCK_MASK                                                        0x80000000L
//DC_ABM1_ACE_OFFSET_SLOPE_3
#define DC_ABM1_ACE_OFFSET_SLOPE_3__ABM1_ACE_SLOPE_3__SHIFT                                                   0x0
#define DC_ABM1_ACE_OFFSET_SLOPE_3__ABM1_ACE_OFFSET_3__SHIFT                                                  0x10
#define DC_ABM1_ACE_OFFSET_SLOPE_3__ABM1_ACE_LOCK__SHIFT                                                      0x1f
#define DC_ABM1_ACE_OFFSET_SLOPE_3__ABM1_ACE_SLOPE_3_MASK                                                     0x00007FFFL
#define DC_ABM1_ACE_OFFSET_SLOPE_3__ABM1_ACE_OFFSET_3_MASK                                                    0x07FF0000L
#define DC_ABM1_ACE_OFFSET_SLOPE_3__ABM1_ACE_LOCK_MASK                                                        0x80000000L
//DC_ABM1_ACE_OFFSET_SLOPE_4
#define DC_ABM1_ACE_OFFSET_SLOPE_4__ABM1_ACE_SLOPE_4__SHIFT                                                   0x0
#define DC_ABM1_ACE_OFFSET_SLOPE_4__ABM1_ACE_OFFSET_4__SHIFT                                                  0x10
#define DC_ABM1_ACE_OFFSET_SLOPE_4__ABM1_ACE_LOCK__SHIFT                                                      0x1f
#define DC_ABM1_ACE_OFFSET_SLOPE_4__ABM1_ACE_SLOPE_4_MASK                                                     0x00007FFFL
#define DC_ABM1_ACE_OFFSET_SLOPE_4__ABM1_ACE_OFFSET_4_MASK                                                    0x07FF0000L
#define DC_ABM1_ACE_OFFSET_SLOPE_4__ABM1_ACE_LOCK_MASK                                                        0x80000000L
//DC_ABM1_ACE_THRES_12
#define DC_ABM1_ACE_THRES_12__ABM1_ACE_THRES_1__SHIFT                                                         0x0
#define DC_ABM1_ACE_THRES_12__ABM1_ACE_THRES_2__SHIFT                                                         0x10
#define DC_ABM1_ACE_THRES_12__ABM1_ACE_LOCK__SHIFT                                                            0x1f
#define DC_ABM1_ACE_THRES_12__ABM1_ACE_THRES_1_MASK                                                           0x000003FFL
#define DC_ABM1_ACE_THRES_12__ABM1_ACE_THRES_2_MASK                                                           0x03FF0000L
#define DC_ABM1_ACE_THRES_12__ABM1_ACE_LOCK_MASK                                                              0x80000000L
//DC_ABM1_ACE_THRES_34
#define DC_ABM1_ACE_THRES_34__ABM1_ACE_THRES_3__SHIFT                                                         0x0
#define DC_ABM1_ACE_THRES_34__ABM1_ACE_THRES_4__SHIFT                                                         0x10
#define DC_ABM1_ACE_THRES_34__ABM1_ACE_IGNORE_MASTER_LOCK_EN__SHIFT                                           0x1c
#define DC_ABM1_ACE_THRES_34__ABM1_ACE_READBACK_DB_REG_VALUE_EN__SHIFT                                        0x1d
#define DC_ABM1_ACE_THRES_34__ABM1_ACE_DBUF_REG_UPDATE_PENDING__SHIFT                                         0x1e
#define DC_ABM1_ACE_THRES_34__ABM1_ACE_LOCK__SHIFT                                                            0x1f
#define DC_ABM1_ACE_THRES_34__ABM1_ACE_THRES_3_MASK                                                           0x000003FFL
#define DC_ABM1_ACE_THRES_34__ABM1_ACE_THRES_4_MASK                                                           0x03FF0000L
#define DC_ABM1_ACE_THRES_34__ABM1_ACE_IGNORE_MASTER_LOCK_EN_MASK                                             0x10000000L
#define DC_ABM1_ACE_THRES_34__ABM1_ACE_READBACK_DB_REG_VALUE_EN_MASK                                          0x20000000L
#define DC_ABM1_ACE_THRES_34__ABM1_ACE_DBUF_REG_UPDATE_PENDING_MASK                                           0x40000000L
#define DC_ABM1_ACE_THRES_34__ABM1_ACE_LOCK_MASK                                                              0x80000000L
//DC_ABM1_ACE_CNTL_MISC
#define DC_ABM1_ACE_CNTL_MISC__ABM1_ACE_REG_WR_MISSED_FRAME__SHIFT                                            0x0
#define DC_ABM1_ACE_CNTL_MISC__ABM1_ACE_REG_WR_MISSED_FRAME_CLEAR__SHIFT                                      0x8
#define DC_ABM1_ACE_CNTL_MISC__ABM1_ACE_REG_WR_MISSED_FRAME_MASK                                              0x00000001L
#define DC_ABM1_ACE_CNTL_MISC__ABM1_ACE_REG_WR_MISSED_FRAME_CLEAR_MASK                                        0x00000100L
//DMCU_PERFMON_INTERRUPT_STATUS5
#define DMCU_PERFMON_INTERRUPT_STATUS5__DCFEV0_PERFMON_COUNTER0_INT_OCCURRED__SHIFT                           0x0
#define DMCU_PERFMON_INTERRUPT_STATUS5__DCFEV0_PERFMON_COUNTER0_INT_CLEAR__SHIFT                              0x0
#define DMCU_PERFMON_INTERRUPT_STATUS5__DCFEV0_PERFMON_COUNTER1_INT_OCCURRED__SHIFT                           0x1
#define DMCU_PERFMON_INTERRUPT_STATUS5__DCFEV0_PERFMON_COUNTER1_INT_CLEAR__SHIFT                              0x1
#define DMCU_PERFMON_INTERRUPT_STATUS5__DCFEV0_PERFMON_COUNTER2_INT_OCCURRED__SHIFT                           0x2
#define DMCU_PERFMON_INTERRUPT_STATUS5__DCFEV0_PERFMON_COUNTER2_INT_CLEAR__SHIFT                              0x2
#define DMCU_PERFMON_INTERRUPT_STATUS5__DCFEV0_PERFMON_COUNTER3_INT_OCCURRED__SHIFT                           0x3
#define DMCU_PERFMON_INTERRUPT_STATUS5__DCFEV0_PERFMON_COUNTER3_INT_CLEAR__SHIFT                              0x3
#define DMCU_PERFMON_INTERRUPT_STATUS5__DCFEV0_PERFMON_COUNTER4_INT_OCCURRED__SHIFT                           0x4
#define DMCU_PERFMON_INTERRUPT_STATUS5__DCFEV0_PERFMON_COUNTER4_INT_CLEAR__SHIFT                              0x4
#define DMCU_PERFMON_INTERRUPT_STATUS5__DCFEV0_PERFMON_COUNTER5_INT_OCCURRED__SHIFT                           0x5
#define DMCU_PERFMON_INTERRUPT_STATUS5__DCFEV0_PERFMON_COUNTER5_INT_CLEAR__SHIFT                              0x5
#define DMCU_PERFMON_INTERRUPT_STATUS5__DCFEV0_PERFMON_COUNTER6_INT_OCCURRED__SHIFT                           0x6
#define DMCU_PERFMON_INTERRUPT_STATUS5__DCFEV0_PERFMON_COUNTER6_INT_CLEAR__SHIFT                              0x6
#define DMCU_PERFMON_INTERRUPT_STATUS5__DCFEV0_PERFMON_COUNTER7_INT_OCCURRED__SHIFT                           0x7
#define DMCU_PERFMON_INTERRUPT_STATUS5__DCFEV0_PERFMON_COUNTER7_INT_CLEAR__SHIFT                              0x7
#define DMCU_PERFMON_INTERRUPT_STATUS5__DCFEV1_PERFMON_COUNTER0_INT_OCCURRED__SHIFT                           0x8
#define DMCU_PERFMON_INTERRUPT_STATUS5__DCFEV1_PERFMON_COUNTER0_INT_CLEAR__SHIFT                              0x8
#define DMCU_PERFMON_INTERRUPT_STATUS5__DCFEV1_PERFMON_COUNTER1_INT_OCCURRED__SHIFT                           0x9
#define DMCU_PERFMON_INTERRUPT_STATUS5__DCFEV1_PERFMON_COUNTER1_INT_CLEAR__SHIFT                              0x9
#define DMCU_PERFMON_INTERRUPT_STATUS5__DCFEV1_PERFMON_COUNTER2_INT_OCCURRED__SHIFT                           0xa
#define DMCU_PERFMON_INTERRUPT_STATUS5__DCFEV1_PERFMON_COUNTER2_INT_CLEAR__SHIFT                              0xa
#define DMCU_PERFMON_INTERRUPT_STATUS5__DCFEV1_PERFMON_COUNTER3_INT_OCCURRED__SHIFT                           0xb
#define DMCU_PERFMON_INTERRUPT_STATUS5__DCFEV1_PERFMON_COUNTER3_INT_CLEAR__SHIFT                              0xb
#define DMCU_PERFMON_INTERRUPT_STATUS5__DCFEV1_PERFMON_COUNTER4_INT_OCCURRED__SHIFT                           0xc
#define DMCU_PERFMON_INTERRUPT_STATUS5__DCFEV1_PERFMON_COUNTER4_INT_CLEAR__SHIFT                              0xc
#define DMCU_PERFMON_INTERRUPT_STATUS5__DCFEV1_PERFMON_COUNTER5_INT_OCCURRED__SHIFT                           0xd
#define DMCU_PERFMON_INTERRUPT_STATUS5__DCFEV1_PERFMON_COUNTER5_INT_CLEAR__SHIFT                              0xd
#define DMCU_PERFMON_INTERRUPT_STATUS5__DCFEV1_PERFMON_COUNTER6_INT_OCCURRED__SHIFT                           0xe
#define DMCU_PERFMON_INTERRUPT_STATUS5__DCFEV1_PERFMON_COUNTER6_INT_CLEAR__SHIFT                              0xe
#define DMCU_PERFMON_INTERRUPT_STATUS5__DCFEV1_PERFMON_COUNTER7_INT_OCCURRED__SHIFT                           0xf
#define DMCU_PERFMON_INTERRUPT_STATUS5__DCFEV1_PERFMON_COUNTER7_INT_CLEAR__SHIFT                              0xf
#define DMCU_PERFMON_INTERRUPT_STATUS5__DCFEV0_PERFMON_COUNTER_OFF_INT_OCCURRED__SHIFT                        0x10
#define DMCU_PERFMON_INTERRUPT_STATUS5__DCFEV0_PERFMON_COUNTER_OFF_INT_CLEAR__SHIFT                           0x10
#define DMCU_PERFMON_INTERRUPT_STATUS5__DCFEV1_PERFMON_COUNTER_OFF_INT_OCCURRED__SHIFT                        0x11
#define DMCU_PERFMON_INTERRUPT_STATUS5__DCFEV1_PERFMON_COUNTER_OFF_INT_CLEAR__SHIFT                           0x11
#define DMCU_PERFMON_INTERRUPT_STATUS5__DCFEV0_PERFMON_COUNTER0_INT_OCCURRED_MASK                             0x00000001L
#define DMCU_PERFMON_INTERRUPT_STATUS5__DCFEV0_PERFMON_COUNTER0_INT_CLEAR_MASK                                0x00000001L
#define DMCU_PERFMON_INTERRUPT_STATUS5__DCFEV0_PERFMON_COUNTER1_INT_OCCURRED_MASK                             0x00000002L
#define DMCU_PERFMON_INTERRUPT_STATUS5__DCFEV0_PERFMON_COUNTER1_INT_CLEAR_MASK                                0x00000002L
#define DMCU_PERFMON_INTERRUPT_STATUS5__DCFEV0_PERFMON_COUNTER2_INT_OCCURRED_MASK                             0x00000004L
#define DMCU_PERFMON_INTERRUPT_STATUS5__DCFEV0_PERFMON_COUNTER2_INT_CLEAR_MASK                                0x00000004L
#define DMCU_PERFMON_INTERRUPT_STATUS5__DCFEV0_PERFMON_COUNTER3_INT_OCCURRED_MASK                             0x00000008L
#define DMCU_PERFMON_INTERRUPT_STATUS5__DCFEV0_PERFMON_COUNTER3_INT_CLEAR_MASK                                0x00000008L
#define DMCU_PERFMON_INTERRUPT_STATUS5__DCFEV0_PERFMON_COUNTER4_INT_OCCURRED_MASK                             0x00000010L
#define DMCU_PERFMON_INTERRUPT_STATUS5__DCFEV0_PERFMON_COUNTER4_INT_CLEAR_MASK                                0x00000010L
#define DMCU_PERFMON_INTERRUPT_STATUS5__DCFEV0_PERFMON_COUNTER5_INT_OCCURRED_MASK                             0x00000020L
#define DMCU_PERFMON_INTERRUPT_STATUS5__DCFEV0_PERFMON_COUNTER5_INT_CLEAR_MASK                                0x00000020L
#define DMCU_PERFMON_INTERRUPT_STATUS5__DCFEV0_PERFMON_COUNTER6_INT_OCCURRED_MASK                             0x00000040L
#define DMCU_PERFMON_INTERRUPT_STATUS5__DCFEV0_PERFMON_COUNTER6_INT_CLEAR_MASK                                0x00000040L
#define DMCU_PERFMON_INTERRUPT_STATUS5__DCFEV0_PERFMON_COUNTER7_INT_OCCURRED_MASK                             0x00000080L
#define DMCU_PERFMON_INTERRUPT_STATUS5__DCFEV0_PERFMON_COUNTER7_INT_CLEAR_MASK                                0x00000080L
#define DMCU_PERFMON_INTERRUPT_STATUS5__DCFEV1_PERFMON_COUNTER0_INT_OCCURRED_MASK                             0x00000100L
#define DMCU_PERFMON_INTERRUPT_STATUS5__DCFEV1_PERFMON_COUNTER0_INT_CLEAR_MASK                                0x00000100L
#define DMCU_PERFMON_INTERRUPT_STATUS5__DCFEV1_PERFMON_COUNTER1_INT_OCCURRED_MASK                             0x00000200L
#define DMCU_PERFMON_INTERRUPT_STATUS5__DCFEV1_PERFMON_COUNTER1_INT_CLEAR_MASK                                0x00000200L
#define DMCU_PERFMON_INTERRUPT_STATUS5__DCFEV1_PERFMON_COUNTER2_INT_OCCURRED_MASK                             0x00000400L
#define DMCU_PERFMON_INTERRUPT_STATUS5__DCFEV1_PERFMON_COUNTER2_INT_CLEAR_MASK                                0x00000400L
#define DMCU_PERFMON_INTERRUPT_STATUS5__DCFEV1_PERFMON_COUNTER3_INT_OCCURRED_MASK                             0x00000800L
#define DMCU_PERFMON_INTERRUPT_STATUS5__DCFEV1_PERFMON_COUNTER3_INT_CLEAR_MASK                                0x00000800L
#define DMCU_PERFMON_INTERRUPT_STATUS5__DCFEV1_PERFMON_COUNTER4_INT_OCCURRED_MASK                             0x00001000L
#define DMCU_PERFMON_INTERRUPT_STATUS5__DCFEV1_PERFMON_COUNTER4_INT_CLEAR_MASK                                0x00001000L
#define DMCU_PERFMON_INTERRUPT_STATUS5__DCFEV1_PERFMON_COUNTER5_INT_OCCURRED_MASK                             0x00002000L
#define DMCU_PERFMON_INTERRUPT_STATUS5__DCFEV1_PERFMON_COUNTER5_INT_CLEAR_MASK                                0x00002000L
#define DMCU_PERFMON_INTERRUPT_STATUS5__DCFEV1_PERFMON_COUNTER6_INT_OCCURRED_MASK                             0x00004000L
#define DMCU_PERFMON_INTERRUPT_STATUS5__DCFEV1_PERFMON_COUNTER6_INT_CLEAR_MASK                                0x00004000L
#define DMCU_PERFMON_INTERRUPT_STATUS5__DCFEV1_PERFMON_COUNTER7_INT_OCCURRED_MASK                             0x00008000L
#define DMCU_PERFMON_INTERRUPT_STATUS5__DCFEV1_PERFMON_COUNTER7_INT_CLEAR_MASK                                0x00008000L
#define DMCU_PERFMON_INTERRUPT_STATUS5__DCFEV0_PERFMON_COUNTER_OFF_INT_OCCURRED_MASK                          0x00010000L
#define DMCU_PERFMON_INTERRUPT_STATUS5__DCFEV0_PERFMON_COUNTER_OFF_INT_CLEAR_MASK                             0x00010000L
#define DMCU_PERFMON_INTERRUPT_STATUS5__DCFEV1_PERFMON_COUNTER_OFF_INT_OCCURRED_MASK                          0x00020000L
#define DMCU_PERFMON_INTERRUPT_STATUS5__DCFEV1_PERFMON_COUNTER_OFF_INT_CLEAR_MASK                             0x00020000L
//DMCU_PERFMON_INTERRUPT_TO_UC_EN_MASK5
#define DMCU_PERFMON_INTERRUPT_TO_UC_EN_MASK5__DCFEV0_PERFMON_COUNTER0_INT_TO_UC_EN__SHIFT                    0x0
#define DMCU_PERFMON_INTERRUPT_TO_UC_EN_MASK5__DCFEV0_PERFMON_COUNTER1_INT_TO_UC_EN__SHIFT                    0x1
#define DMCU_PERFMON_INTERRUPT_TO_UC_EN_MASK5__DCFEV0_PERFMON_COUNTER2_INT_TO_UC_EN__SHIFT                    0x2
#define DMCU_PERFMON_INTERRUPT_TO_UC_EN_MASK5__DCFEV0_PERFMON_COUNTER3_INT_TO_UC_EN__SHIFT                    0x3
#define DMCU_PERFMON_INTERRUPT_TO_UC_EN_MASK5__DCFEV0_PERFMON_COUNTER4_INT_TO_UC_EN__SHIFT                    0x4
#define DMCU_PERFMON_INTERRUPT_TO_UC_EN_MASK5__DCFEV0_PERFMON_COUNTER5_INT_TO_UC_EN__SHIFT                    0x5
#define DMCU_PERFMON_INTERRUPT_TO_UC_EN_MASK5__DCFEV0_PERFMON_COUNTER6_INT_TO_UC_EN__SHIFT                    0x6
#define DMCU_PERFMON_INTERRUPT_TO_UC_EN_MASK5__DCFEV0_PERFMON_COUNTER7_INT_TO_UC_EN__SHIFT                    0x7
#define DMCU_PERFMON_INTERRUPT_TO_UC_EN_MASK5__DCFEV0_PERFMON_COUNTER_OFF_INT_TO_UC_EN__SHIFT                 0x8
#define DMCU_PERFMON_INTERRUPT_TO_UC_EN_MASK5__DCFEV1_PERFMON_COUNTER0_INT_TO_UC_EN__SHIFT                    0x9
#define DMCU_PERFMON_INTERRUPT_TO_UC_EN_MASK5__DCFEV1_PERFMON_COUNTER1_INT_TO_UC_EN__SHIFT                    0xa
#define DMCU_PERFMON_INTERRUPT_TO_UC_EN_MASK5__DCFEV1_PERFMON_COUNTER2_INT_TO_UC_EN__SHIFT                    0xb
#define DMCU_PERFMON_INTERRUPT_TO_UC_EN_MASK5__DCFEV1_PERFMON_COUNTER3_INT_TO_UC_EN__SHIFT                    0xc
#define DMCU_PERFMON_INTERRUPT_TO_UC_EN_MASK5__DCFEV1_PERFMON_COUNTER4_INT_TO_UC_EN__SHIFT                    0xd
#define DMCU_PERFMON_INTERRUPT_TO_UC_EN_MASK5__DCFEV1_PERFMON_COUNTER5_INT_TO_UC_EN__SHIFT                    0xe
#define DMCU_PERFMON_INTERRUPT_TO_UC_EN_MASK5__DCFEV1_PERFMON_COUNTER6_INT_TO_UC_EN__SHIFT                    0xf
#define DMCU_PERFMON_INTERRUPT_TO_UC_EN_MASK5__DCFEV1_PERFMON_COUNTER7_INT_TO_UC_EN__SHIFT                    0x10
#define DMCU_PERFMON_INTERRUPT_TO_UC_EN_MASK5__DCFEV1_PERFMON_COUNTER_OFF_INT_TO_UC_EN__SHIFT                 0x11
#define DMCU_PERFMON_INTERRUPT_TO_UC_EN_MASK5__DCFEV0_PERFMON_COUNTER0_INT_TO_UC_EN_MASK                      0x00000001L
#define DMCU_PERFMON_INTERRUPT_TO_UC_EN_MASK5__DCFEV0_PERFMON_COUNTER1_INT_TO_UC_EN_MASK                      0x00000002L
#define DMCU_PERFMON_INTERRUPT_TO_UC_EN_MASK5__DCFEV0_PERFMON_COUNTER2_INT_TO_UC_EN_MASK                      0x00000004L
#define DMCU_PERFMON_INTERRUPT_TO_UC_EN_MASK5__DCFEV0_PERFMON_COUNTER3_INT_TO_UC_EN_MASK                      0x00000008L
#define DMCU_PERFMON_INTERRUPT_TO_UC_EN_MASK5__DCFEV0_PERFMON_COUNTER4_INT_TO_UC_EN_MASK                      0x00000010L
#define DMCU_PERFMON_INTERRUPT_TO_UC_EN_MASK5__DCFEV0_PERFMON_COUNTER5_INT_TO_UC_EN_MASK                      0x00000020L
#define DMCU_PERFMON_INTERRUPT_TO_UC_EN_MASK5__DCFEV0_PERFMON_COUNTER6_INT_TO_UC_EN_MASK                      0x00000040L
#define DMCU_PERFMON_INTERRUPT_TO_UC_EN_MASK5__DCFEV0_PERFMON_COUNTER7_INT_TO_UC_EN_MASK                      0x00000080L
#define DMCU_PERFMON_INTERRUPT_TO_UC_EN_MASK5__DCFEV0_PERFMON_COUNTER_OFF_INT_TO_UC_EN_MASK                   0x00000100L
#define DMCU_PERFMON_INTERRUPT_TO_UC_EN_MASK5__DCFEV1_PERFMON_COUNTER0_INT_TO_UC_EN_MASK                      0x00000200L
#define DMCU_PERFMON_INTERRUPT_TO_UC_EN_MASK5__DCFEV1_PERFMON_COUNTER1_INT_TO_UC_EN_MASK                      0x00000400L
#define DMCU_PERFMON_INTERRUPT_TO_UC_EN_MASK5__DCFEV1_PERFMON_COUNTER2_INT_TO_UC_EN_MASK                      0x00000800L
#define DMCU_PERFMON_INTERRUPT_TO_UC_EN_MASK5__DCFEV1_PERFMON_COUNTER3_INT_TO_UC_EN_MASK                      0x00001000L
#define DMCU_PERFMON_INTERRUPT_TO_UC_EN_MASK5__DCFEV1_PERFMON_COUNTER4_INT_TO_UC_EN_MASK                      0x00002000L
#define DMCU_PERFMON_INTERRUPT_TO_UC_EN_MASK5__DCFEV1_PERFMON_COUNTER5_INT_TO_UC_EN_MASK                      0x00004000L
#define DMCU_PERFMON_INTERRUPT_TO_UC_EN_MASK5__DCFEV1_PERFMON_COUNTER6_INT_TO_UC_EN_MASK                      0x00008000L
#define DMCU_PERFMON_INTERRUPT_TO_UC_EN_MASK5__DCFEV1_PERFMON_COUNTER7_INT_TO_UC_EN_MASK                      0x00010000L
#define DMCU_PERFMON_INTERRUPT_TO_UC_EN_MASK5__DCFEV1_PERFMON_COUNTER_OFF_INT_TO_UC_EN_MASK                   0x00020000L
//DMCU_PERFMON_INTERRUPT_STATUS1
#define DMCU_PERFMON_INTERRUPT_STATUS1__DCI_PERFMON_COUNTER0_INT_OCCURRED__SHIFT                              0x0
#define DMCU_PERFMON_INTERRUPT_STATUS1__DCI_PERFMON_COUNTER0_INT_CLEAR__SHIFT                                 0x0
#define DMCU_PERFMON_INTERRUPT_STATUS1__DCI_PERFMON_COUNTER1_INT_OCCURRED__SHIFT                              0x1
#define DMCU_PERFMON_INTERRUPT_STATUS1__DCI_PERFMON_COUNTER1_INT_CLEAR__SHIFT                                 0x1
#define DMCU_PERFMON_INTERRUPT_STATUS1__DCI_PERFMON_COUNTER2_INT_OCCURRED__SHIFT                              0x2
#define DMCU_PERFMON_INTERRUPT_STATUS1__DCI_PERFMON_COUNTER2_INT_CLEAR__SHIFT                                 0x2
#define DMCU_PERFMON_INTERRUPT_STATUS1__DCI_PERFMON_COUNTER3_INT_OCCURRED__SHIFT                              0x3
#define DMCU_PERFMON_INTERRUPT_STATUS1__DCI_PERFMON_COUNTER3_INT_CLEAR__SHIFT                                 0x3
#define DMCU_PERFMON_INTERRUPT_STATUS1__DCI_PERFMON_COUNTER4_INT_OCCURRED__SHIFT                              0x4
#define DMCU_PERFMON_INTERRUPT_STATUS1__DCI_PERFMON_COUNTER4_INT_CLEAR__SHIFT                                 0x4
#define DMCU_PERFMON_INTERRUPT_STATUS1__DCI_PERFMON_COUNTER5_INT_OCCURRED__SHIFT                              0x5
#define DMCU_PERFMON_INTERRUPT_STATUS1__DCI_PERFMON_COUNTER5_INT_CLEAR__SHIFT                                 0x5
#define DMCU_PERFMON_INTERRUPT_STATUS1__DCI_PERFMON_COUNTER6_INT_OCCURRED__SHIFT                              0x6
#define DMCU_PERFMON_INTERRUPT_STATUS1__DCI_PERFMON_COUNTER6_INT_CLEAR__SHIFT                                 0x6
#define DMCU_PERFMON_INTERRUPT_STATUS1__DCI_PERFMON_COUNTER7_INT_OCCURRED__SHIFT                              0x7
#define DMCU_PERFMON_INTERRUPT_STATUS1__DCI_PERFMON_COUNTER7_INT_CLEAR__SHIFT                                 0x7
#define DMCU_PERFMON_INTERRUPT_STATUS1__DCO_PERFMON_COUNTER0_INT_OCCURRED__SHIFT                              0x8
#define DMCU_PERFMON_INTERRUPT_STATUS1__DCO_PERFMON_COUNTER0_INT_CLEAR__SHIFT                                 0x8
#define DMCU_PERFMON_INTERRUPT_STATUS1__DCO_PERFMON_COUNTER1_INT_OCCURRED__SHIFT                              0x9
#define DMCU_PERFMON_INTERRUPT_STATUS1__DCO_PERFMON_COUNTER1_INT_CLEAR__SHIFT                                 0x9
#define DMCU_PERFMON_INTERRUPT_STATUS1__DCO_PERFMON_COUNTER2_INT_OCCURRED__SHIFT                              0xa
#define DMCU_PERFMON_INTERRUPT_STATUS1__DCO_PERFMON_COUNTER2_INT_CLEAR__SHIFT                                 0xa
#define DMCU_PERFMON_INTERRUPT_STATUS1__DCO_PERFMON_COUNTER3_INT_OCCURRED__SHIFT                              0xb
#define DMCU_PERFMON_INTERRUPT_STATUS1__DCO_PERFMON_COUNTER3_INT_CLEAR__SHIFT                                 0xb
#define DMCU_PERFMON_INTERRUPT_STATUS1__DCO_PERFMON_COUNTER4_INT_OCCURRED__SHIFT                              0xc
#define DMCU_PERFMON_INTERRUPT_STATUS1__DCO_PERFMON_COUNTER4_INT_CLEAR__SHIFT                                 0xc
#define DMCU_PERFMON_INTERRUPT_STATUS1__DCO_PERFMON_COUNTER5_INT_OCCURRED__SHIFT                              0xd
#define DMCU_PERFMON_INTERRUPT_STATUS1__DCO_PERFMON_COUNTER5_INT_CLEAR__SHIFT                                 0xd
#define DMCU_PERFMON_INTERRUPT_STATUS1__DCO_PERFMON_COUNTER6_INT_OCCURRED__SHIFT                              0xe
#define DMCU_PERFMON_INTERRUPT_STATUS1__DCO_PERFMON_COUNTER6_INT_CLEAR__SHIFT                                 0xe
#define DMCU_PERFMON_INTERRUPT_STATUS1__DCO_PERFMON_COUNTER7_INT_OCCURRED__SHIFT                              0xf
#define DMCU_PERFMON_INTERRUPT_STATUS1__DCO_PERFMON_COUNTER7_INT_CLEAR__SHIFT                                 0xf
#define DMCU_PERFMON_INTERRUPT_STATUS1__DCCG_PERFMON_COUNTER0_INT_OCCURRED__SHIFT                             0x10
#define DMCU_PERFMON_INTERRUPT_STATUS1__DCCG_PERFMON_COUNTER0_INT_CLEAR__SHIFT                                0x10
#define DMCU_PERFMON_INTERRUPT_STATUS1__DCCG_PERFMON_COUNTER1_INT_OCCURRED__SHIFT                             0x11
#define DMCU_PERFMON_INTERRUPT_STATUS1__DCCG_PERFMON_COUNTER1_INT_CLEAR__SHIFT                                0x11
#define DMCU_PERFMON_INTERRUPT_STATUS1__DCCG_PERFMON_COUNTER2_INT_OCCURRED__SHIFT                             0x12
#define DMCU_PERFMON_INTERRUPT_STATUS1__DCCG_PERFMON_COUNTER2_INT_CLEAR__SHIFT                                0x12
#define DMCU_PERFMON_INTERRUPT_STATUS1__DCCG_PERFMON_COUNTER3_INT_OCCURRED__SHIFT                             0x13
#define DMCU_PERFMON_INTERRUPT_STATUS1__DCCG_PERFMON_COUNTER3_INT_CLEAR__SHIFT                                0x13
#define DMCU_PERFMON_INTERRUPT_STATUS1__DCCG_PERFMON_COUNTER4_INT_OCCURRED__SHIFT                             0x14
#define DMCU_PERFMON_INTERRUPT_STATUS1__DCCG_PERFMON_COUNTER4_INT_CLEAR__SHIFT                                0x14
#define DMCU_PERFMON_INTERRUPT_STATUS1__DCCG_PERFMON_COUNTER5_INT_OCCURRED__SHIFT                             0x15
#define DMCU_PERFMON_INTERRUPT_STATUS1__DCCG_PERFMON_COUNTER5_INT_CLEAR__SHIFT                                0x15
#define DMCU_PERFMON_INTERRUPT_STATUS1__DCCG_PERFMON_COUNTER6_INT_OCCURRED__SHIFT                             0x16
#define DMCU_PERFMON_INTERRUPT_STATUS1__DCCG_PERFMON_COUNTER6_INT_CLEAR__SHIFT                                0x16
#define DMCU_PERFMON_INTERRUPT_STATUS1__DCCG_PERFMON_COUNTER7_INT_OCCURRED__SHIFT                             0x17
#define DMCU_PERFMON_INTERRUPT_STATUS1__DCCG_PERFMON_COUNTER7_INT_CLEAR__SHIFT                                0x17
#define DMCU_PERFMON_INTERRUPT_STATUS1__DCI_PERFMON_COUNTER_OFF_INT_OCCURRED__SHIFT                           0x18
#define DMCU_PERFMON_INTERRUPT_STATUS1__DCI_PERFMON_COUNTER_OFF_INT_CLEAR__SHIFT                              0x18
#define DMCU_PERFMON_INTERRUPT_STATUS1__DCO_PERFMON_COUNTER_OFF_INT_OCCURRED__SHIFT                           0x19
#define DMCU_PERFMON_INTERRUPT_STATUS1__DCO_PERFMON_COUNTER_OFF_INT_CLEAR__SHIFT                              0x19
#define DMCU_PERFMON_INTERRUPT_STATUS1__DCCG_PERFMON_COUNTER_OFF_INT_OCCURRED__SHIFT                          0x1a
#define DMCU_PERFMON_INTERRUPT_STATUS1__DCCG_PERFMON_COUNTER_OFF_INT_CLEAR__SHIFT                             0x1a
#define DMCU_PERFMON_INTERRUPT_STATUS1__DCI_PERFMON_COUNTER0_INT_OCCURRED_MASK                                0x00000001L
#define DMCU_PERFMON_INTERRUPT_STATUS1__DCI_PERFMON_COUNTER0_INT_CLEAR_MASK                                   0x00000001L
#define DMCU_PERFMON_INTERRUPT_STATUS1__DCI_PERFMON_COUNTER1_INT_OCCURRED_MASK                                0x00000002L
#define DMCU_PERFMON_INTERRUPT_STATUS1__DCI_PERFMON_COUNTER1_INT_CLEAR_MASK                                   0x00000002L
#define DMCU_PERFMON_INTERRUPT_STATUS1__DCI_PERFMON_COUNTER2_INT_OCCURRED_MASK                                0x00000004L
#define DMCU_PERFMON_INTERRUPT_STATUS1__DCI_PERFMON_COUNTER2_INT_CLEAR_MASK                                   0x00000004L
#define DMCU_PERFMON_INTERRUPT_STATUS1__DCI_PERFMON_COUNTER3_INT_OCCURRED_MASK                                0x00000008L
#define DMCU_PERFMON_INTERRUPT_STATUS1__DCI_PERFMON_COUNTER3_INT_CLEAR_MASK                                   0x00000008L
#define DMCU_PERFMON_INTERRUPT_STATUS1__DCI_PERFMON_COUNTER4_INT_OCCURRED_MASK                                0x00000010L
#define DMCU_PERFMON_INTERRUPT_STATUS1__DCI_PERFMON_COUNTER4_INT_CLEAR_MASK                                   0x00000010L
#define DMCU_PERFMON_INTERRUPT_STATUS1__DCI_PERFMON_COUNTER5_INT_OCCURRED_MASK                                0x00000020L
#define DMCU_PERFMON_INTERRUPT_STATUS1__DCI_PERFMON_COUNTER5_INT_CLEAR_MASK                                   0x00000020L
#define DMCU_PERFMON_INTERRUPT_STATUS1__DCI_PERFMON_COUNTER6_INT_OCCURRED_MASK                                0x00000040L
#define DMCU_PERFMON_INTERRUPT_STATUS1__DCI_PERFMON_COUNTER6_INT_CLEAR_MASK                                   0x00000040L
#define DMCU_PERFMON_INTERRUPT_STATUS1__DCI_PERFMON_COUNTER7_INT_OCCURRED_MASK                                0x00000080L
#define DMCU_PERFMON_INTERRUPT_STATUS1__DCI_PERFMON_COUNTER7_INT_CLEAR_MASK                                   0x00000080L
#define DMCU_PERFMON_INTERRUPT_STATUS1__DCO_PERFMON_COUNTER0_INT_OCCURRED_MASK                                0x00000100L
#define DMCU_PERFMON_INTERRUPT_STATUS1__DCO_PERFMON_COUNTER0_INT_CLEAR_MASK                                   0x00000100L
#define DMCU_PERFMON_INTERRUPT_STATUS1__DCO_PERFMON_COUNTER1_INT_OCCURRED_MASK                                0x00000200L
#define DMCU_PERFMON_INTERRUPT_STATUS1__DCO_PERFMON_COUNTER1_INT_CLEAR_MASK                                   0x00000200L
#define DMCU_PERFMON_INTERRUPT_STATUS1__DCO_PERFMON_COUNTER2_INT_OCCURRED_MASK                                0x00000400L
#define DMCU_PERFMON_INTERRUPT_STATUS1__DCO_PERFMON_COUNTER2_INT_CLEAR_MASK                                   0x00000400L
#define DMCU_PERFMON_INTERRUPT_STATUS1__DCO_PERFMON_COUNTER3_INT_OCCURRED_MASK                                0x00000800L
#define DMCU_PERFMON_INTERRUPT_STATUS1__DCO_PERFMON_COUNTER3_INT_CLEAR_MASK                                   0x00000800L
#define DMCU_PERFMON_INTERRUPT_STATUS1__DCO_PERFMON_COUNTER4_INT_OCCURRED_MASK                                0x00001000L
#define DMCU_PERFMON_INTERRUPT_STATUS1__DCO_PERFMON_COUNTER4_INT_CLEAR_MASK                                   0x00001000L
#define DMCU_PERFMON_INTERRUPT_STATUS1__DCO_PERFMON_COUNTER5_INT_OCCURRED_MASK                                0x00002000L
#define DMCU_PERFMON_INTERRUPT_STATUS1__DCO_PERFMON_COUNTER5_INT_CLEAR_MASK                                   0x00002000L
#define DMCU_PERFMON_INTERRUPT_STATUS1__DCO_PERFMON_COUNTER6_INT_OCCURRED_MASK                                0x00004000L
#define DMCU_PERFMON_INTERRUPT_STATUS1__DCO_PERFMON_COUNTER6_INT_CLEAR_MASK                                   0x00004000L
#define DMCU_PERFMON_INTERRUPT_STATUS1__DCO_PERFMON_COUNTER7_INT_OCCURRED_MASK                                0x00008000L
#define DMCU_PERFMON_INTERRUPT_STATUS1__DCO_PERFMON_COUNTER7_INT_CLEAR_MASK                                   0x00008000L
#define DMCU_PERFMON_INTERRUPT_STATUS1__DCCG_PERFMON_COUNTER0_INT_OCCURRED_MASK                               0x00010000L
#define DMCU_PERFMON_INTERRUPT_STATUS1__DCCG_PERFMON_COUNTER0_INT_CLEAR_MASK                                  0x00010000L
#define DMCU_PERFMON_INTERRUPT_STATUS1__DCCG_PERFMON_COUNTER1_INT_OCCURRED_MASK                               0x00020000L
#define DMCU_PERFMON_INTERRUPT_STATUS1__DCCG_PERFMON_COUNTER1_INT_CLEAR_MASK                                  0x00020000L
#define DMCU_PERFMON_INTERRUPT_STATUS1__DCCG_PERFMON_COUNTER2_INT_OCCURRED_MASK                               0x00040000L
#define DMCU_PERFMON_INTERRUPT_STATUS1__DCCG_PERFMON_COUNTER2_INT_CLEAR_MASK                                  0x00040000L
#define DMCU_PERFMON_INTERRUPT_STATUS1__DCCG_PERFMON_COUNTER3_INT_OCCURRED_MASK                               0x00080000L
#define DMCU_PERFMON_INTERRUPT_STATUS1__DCCG_PERFMON_COUNTER3_INT_CLEAR_MASK                                  0x00080000L
#define DMCU_PERFMON_INTERRUPT_STATUS1__DCCG_PERFMON_COUNTER4_INT_OCCURRED_MASK                               0x00100000L
#define DMCU_PERFMON_INTERRUPT_STATUS1__DCCG_PERFMON_COUNTER4_INT_CLEAR_MASK                                  0x00100000L
#define DMCU_PERFMON_INTERRUPT_STATUS1__DCCG_PERFMON_COUNTER5_INT_OCCURRED_MASK                               0x00200000L
#define DMCU_PERFMON_INTERRUPT_STATUS1__DCCG_PERFMON_COUNTER5_INT_CLEAR_MASK                                  0x00200000L
#define DMCU_PERFMON_INTERRUPT_STATUS1__DCCG_PERFMON_COUNTER6_INT_OCCURRED_MASK                               0x00400000L
#define DMCU_PERFMON_INTERRUPT_STATUS1__DCCG_PERFMON_COUNTER6_INT_CLEAR_MASK                                  0x00400000L
#define DMCU_PERFMON_INTERRUPT_STATUS1__DCCG_PERFMON_COUNTER7_INT_OCCURRED_MASK                               0x00800000L
#define DMCU_PERFMON_INTERRUPT_STATUS1__DCCG_PERFMON_COUNTER7_INT_CLEAR_MASK                                  0x00800000L
#define DMCU_PERFMON_INTERRUPT_STATUS1__DCI_PERFMON_COUNTER_OFF_INT_OCCURRED_MASK                             0x01000000L
#define DMCU_PERFMON_INTERRUPT_STATUS1__DCI_PERFMON_COUNTER_OFF_INT_CLEAR_MASK                                0x01000000L
#define DMCU_PERFMON_INTERRUPT_STATUS1__DCO_PERFMON_COUNTER_OFF_INT_OCCURRED_MASK                             0x02000000L
#define DMCU_PERFMON_INTERRUPT_STATUS1__DCO_PERFMON_COUNTER_OFF_INT_CLEAR_MASK                                0x02000000L
#define DMCU_PERFMON_INTERRUPT_STATUS1__DCCG_PERFMON_COUNTER_OFF_INT_OCCURRED_MASK                            0x04000000L
#define DMCU_PERFMON_INTERRUPT_STATUS1__DCCG_PERFMON_COUNTER_OFF_INT_CLEAR_MASK                               0x04000000L
//DMCU_PERFMON_INTERRUPT_STATUS2
#define DMCU_PERFMON_INTERRUPT_STATUS2__DCFE0_PERFMON_COUNTER0_INT_OCCURRED__SHIFT                            0x0
#define DMCU_PERFMON_INTERRUPT_STATUS2__DCFE0_PERFMON_COUNTER0_INT_CLEAR__SHIFT                               0x0
#define DMCU_PERFMON_INTERRUPT_STATUS2__DCFE0_PERFMON_COUNTER1_INT_OCCURRED__SHIFT                            0x1
#define DMCU_PERFMON_INTERRUPT_STATUS2__DCFE0_PERFMON_COUNTER1_INT_CLEAR__SHIFT                               0x1
#define DMCU_PERFMON_INTERRUPT_STATUS2__DCFE0_PERFMON_COUNTER2_INT_OCCURRED__SHIFT                            0x2
#define DMCU_PERFMON_INTERRUPT_STATUS2__DCFE0_PERFMON_COUNTER2_INT_CLEAR__SHIFT                               0x2
#define DMCU_PERFMON_INTERRUPT_STATUS2__DCFE0_PERFMON_COUNTER3_INT_OCCURRED__SHIFT                            0x3
#define DMCU_PERFMON_INTERRUPT_STATUS2__DCFE0_PERFMON_COUNTER3_INT_CLEAR__SHIFT                               0x3
#define DMCU_PERFMON_INTERRUPT_STATUS2__DCFE0_PERFMON_COUNTER4_INT_OCCURRED__SHIFT                            0x4
#define DMCU_PERFMON_INTERRUPT_STATUS2__DCFE0_PERFMON_COUNTER4_INT_CLEAR__SHIFT                               0x4
#define DMCU_PERFMON_INTERRUPT_STATUS2__DCFE0_PERFMON_COUNTER5_INT_OCCURRED__SHIFT                            0x5
#define DMCU_PERFMON_INTERRUPT_STATUS2__DCFE0_PERFMON_COUNTER5_INT_CLEAR__SHIFT                               0x5
#define DMCU_PERFMON_INTERRUPT_STATUS2__DCFE0_PERFMON_COUNTER6_INT_OCCURRED__SHIFT                            0x6
#define DMCU_PERFMON_INTERRUPT_STATUS2__DCFE0_PERFMON_COUNTER6_INT_CLEAR__SHIFT                               0x6
#define DMCU_PERFMON_INTERRUPT_STATUS2__DCFE0_PERFMON_COUNTER7_INT_OCCURRED__SHIFT                            0x7
#define DMCU_PERFMON_INTERRUPT_STATUS2__DCFE0_PERFMON_COUNTER7_INT_CLEAR__SHIFT                               0x7
#define DMCU_PERFMON_INTERRUPT_STATUS2__DCFE1_PERFMON_COUNTER0_INT_OCCURRED__SHIFT                            0x8
#define DMCU_PERFMON_INTERRUPT_STATUS2__DCFE1_PERFMON_COUNTER0_INT_CLEAR__SHIFT                               0x8
#define DMCU_PERFMON_INTERRUPT_STATUS2__DCFE1_PERFMON_COUNTER1_INT_OCCURRED__SHIFT                            0x9
#define DMCU_PERFMON_INTERRUPT_STATUS2__DCFE1_PERFMON_COUNTER1_INT_CLEAR__SHIFT                               0x9
#define DMCU_PERFMON_INTERRUPT_STATUS2__DCFE1_PERFMON_COUNTER2_INT_OCCURRED__SHIFT                            0xa
#define DMCU_PERFMON_INTERRUPT_STATUS2__DCFE1_PERFMON_COUNTER2_INT_CLEAR__SHIFT                               0xa
#define DMCU_PERFMON_INTERRUPT_STATUS2__DCFE1_PERFMON_COUNTER3_INT_OCCURRED__SHIFT                            0xb
#define DMCU_PERFMON_INTERRUPT_STATUS2__DCFE1_PERFMON_COUNTER3_INT_CLEAR__SHIFT                               0xb
#define DMCU_PERFMON_INTERRUPT_STATUS2__DCFE1_PERFMON_COUNTER4_INT_OCCURRED__SHIFT                            0xc
#define DMCU_PERFMON_INTERRUPT_STATUS2__DCFE1_PERFMON_COUNTER4_INT_CLEAR__SHIFT                               0xc
#define DMCU_PERFMON_INTERRUPT_STATUS2__DCFE1_PERFMON_COUNTER5_INT_OCCURRED__SHIFT                            0xd
#define DMCU_PERFMON_INTERRUPT_STATUS2__DCFE1_PERFMON_COUNTER5_INT_CLEAR__SHIFT                               0xd
#define DMCU_PERFMON_INTERRUPT_STATUS2__DCFE1_PERFMON_COUNTER6_INT_OCCURRED__SHIFT                            0xe
#define DMCU_PERFMON_INTERRUPT_STATUS2__DCFE1_PERFMON_COUNTER6_INT_CLEAR__SHIFT                               0xe
#define DMCU_PERFMON_INTERRUPT_STATUS2__DCFE1_PERFMON_COUNTER7_INT_OCCURRED__SHIFT                            0xf
#define DMCU_PERFMON_INTERRUPT_STATUS2__DCFE1_PERFMON_COUNTER7_INT_CLEAR__SHIFT                               0xf
#define DMCU_PERFMON_INTERRUPT_STATUS2__DCFE2_PERFMON_COUNTER0_INT_OCCURRED__SHIFT                            0x10
#define DMCU_PERFMON_INTERRUPT_STATUS2__DCFE2_PERFMON_COUNTER0_INT_CLEAR__SHIFT                               0x10
#define DMCU_PERFMON_INTERRUPT_STATUS2__DCFE2_PERFMON_COUNTER1_INT_OCCURRED__SHIFT                            0x11
#define DMCU_PERFMON_INTERRUPT_STATUS2__DCFE2_PERFMON_COUNTER1_INT_CLEAR__SHIFT                               0x11
#define DMCU_PERFMON_INTERRUPT_STATUS2__DCFE2_PERFMON_COUNTER2_INT_OCCURRED__SHIFT                            0x12
#define DMCU_PERFMON_INTERRUPT_STATUS2__DCFE2_PERFMON_COUNTER2_INT_CLEAR__SHIFT                               0x12
#define DMCU_PERFMON_INTERRUPT_STATUS2__DCFE2_PERFMON_COUNTER3_INT_OCCURRED__SHIFT                            0x13
#define DMCU_PERFMON_INTERRUPT_STATUS2__DCFE2_PERFMON_COUNTER3_INT_CLEAR__SHIFT                               0x13
#define DMCU_PERFMON_INTERRUPT_STATUS2__DCFE2_PERFMON_COUNTER4_INT_OCCURRED__SHIFT                            0x14
#define DMCU_PERFMON_INTERRUPT_STATUS2__DCFE2_PERFMON_COUNTER4_INT_CLEAR__SHIFT                               0x14
#define DMCU_PERFMON_INTERRUPT_STATUS2__DCFE2_PERFMON_COUNTER5_INT_OCCURRED__SHIFT                            0x15
#define DMCU_PERFMON_INTERRUPT_STATUS2__DCFE2_PERFMON_COUNTER5_INT_CLEAR__SHIFT                               0x15
#define DMCU_PERFMON_INTERRUPT_STATUS2__DCFE2_PERFMON_COUNTER6_INT_OCCURRED__SHIFT                            0x16
#define DMCU_PERFMON_INTERRUPT_STATUS2__DCFE2_PERFMON_COUNTER6_INT_CLEAR__SHIFT                               0x16
#define DMCU_PERFMON_INTERRUPT_STATUS2__DCFE2_PERFMON_COUNTER7_INT_OCCURRED__SHIFT                            0x17
#define DMCU_PERFMON_INTERRUPT_STATUS2__DCFE2_PERFMON_COUNTER7_INT_CLEAR__SHIFT                               0x17
#define DMCU_PERFMON_INTERRUPT_STATUS2__DCFE0_PERFMON_COUNTER_OFF_INT_OCCURRED__SHIFT                         0x18
#define DMCU_PERFMON_INTERRUPT_STATUS2__DCFE0_PERFMON_COUNTER_OFF_INT_CLEAR__SHIFT                            0x18
#define DMCU_PERFMON_INTERRUPT_STATUS2__DCFE1_PERFMON_COUNTER_OFF_INT_OCCURRED__SHIFT                         0x19
#define DMCU_PERFMON_INTERRUPT_STATUS2__DCFE1_PERFMON_COUNTER_OFF_INT_CLEAR__SHIFT                            0x19
#define DMCU_PERFMON_INTERRUPT_STATUS2__DCFE2_PERFMON_COUNTER_OFF_INT_OCCURRED__SHIFT                         0x1a
#define DMCU_PERFMON_INTERRUPT_STATUS2__DCFE2_PERFMON_COUNTER_OFF_INT_CLEAR__SHIFT                            0x1a
#define DMCU_PERFMON_INTERRUPT_STATUS2__DCFE0_PERFMON_COUNTER0_INT_OCCURRED_MASK                              0x00000001L
#define DMCU_PERFMON_INTERRUPT_STATUS2__DCFE0_PERFMON_COUNTER0_INT_CLEAR_MASK                                 0x00000001L
#define DMCU_PERFMON_INTERRUPT_STATUS2__DCFE0_PERFMON_COUNTER1_INT_OCCURRED_MASK                              0x00000002L
#define DMCU_PERFMON_INTERRUPT_STATUS2__DCFE0_PERFMON_COUNTER1_INT_CLEAR_MASK                                 0x00000002L
#define DMCU_PERFMON_INTERRUPT_STATUS2__DCFE0_PERFMON_COUNTER2_INT_OCCURRED_MASK                              0x00000004L
#define DMCU_PERFMON_INTERRUPT_STATUS2__DCFE0_PERFMON_COUNTER2_INT_CLEAR_MASK                                 0x00000004L
#define DMCU_PERFMON_INTERRUPT_STATUS2__DCFE0_PERFMON_COUNTER3_INT_OCCURRED_MASK                              0x00000008L
#define DMCU_PERFMON_INTERRUPT_STATUS2__DCFE0_PERFMON_COUNTER3_INT_CLEAR_MASK                                 0x00000008L
#define DMCU_PERFMON_INTERRUPT_STATUS2__DCFE0_PERFMON_COUNTER4_INT_OCCURRED_MASK                              0x00000010L
#define DMCU_PERFMON_INTERRUPT_STATUS2__DCFE0_PERFMON_COUNTER4_INT_CLEAR_MASK                                 0x00000010L
#define DMCU_PERFMON_INTERRUPT_STATUS2__DCFE0_PERFMON_COUNTER5_INT_OCCURRED_MASK                              0x00000020L
#define DMCU_PERFMON_INTERRUPT_STATUS2__DCFE0_PERFMON_COUNTER5_INT_CLEAR_MASK                                 0x00000020L
#define DMCU_PERFMON_INTERRUPT_STATUS2__DCFE0_PERFMON_COUNTER6_INT_OCCURRED_MASK                              0x00000040L
#define DMCU_PERFMON_INTERRUPT_STATUS2__DCFE0_PERFMON_COUNTER6_INT_CLEAR_MASK                                 0x00000040L
#define DMCU_PERFMON_INTERRUPT_STATUS2__DCFE0_PERFMON_COUNTER7_INT_OCCURRED_MASK                              0x00000080L
#define DMCU_PERFMON_INTERRUPT_STATUS2__DCFE0_PERFMON_COUNTER7_INT_CLEAR_MASK                                 0x00000080L
#define DMCU_PERFMON_INTERRUPT_STATUS2__DCFE1_PERFMON_COUNTER0_INT_OCCURRED_MASK                              0x00000100L
#define DMCU_PERFMON_INTERRUPT_STATUS2__DCFE1_PERFMON_COUNTER0_INT_CLEAR_MASK                                 0x00000100L
#define DMCU_PERFMON_INTERRUPT_STATUS2__DCFE1_PERFMON_COUNTER1_INT_OCCURRED_MASK                              0x00000200L
#define DMCU_PERFMON_INTERRUPT_STATUS2__DCFE1_PERFMON_COUNTER1_INT_CLEAR_MASK                                 0x00000200L
#define DMCU_PERFMON_INTERRUPT_STATUS2__DCFE1_PERFMON_COUNTER2_INT_OCCURRED_MASK                              0x00000400L
#define DMCU_PERFMON_INTERRUPT_STATUS2__DCFE1_PERFMON_COUNTER2_INT_CLEAR_MASK                                 0x00000400L
#define DMCU_PERFMON_INTERRUPT_STATUS2__DCFE1_PERFMON_COUNTER3_INT_OCCURRED_MASK                              0x00000800L
#define DMCU_PERFMON_INTERRUPT_STATUS2__DCFE1_PERFMON_COUNTER3_INT_CLEAR_MASK                                 0x00000800L
#define DMCU_PERFMON_INTERRUPT_STATUS2__DCFE1_PERFMON_COUNTER4_INT_OCCURRED_MASK                              0x00001000L
#define DMCU_PERFMON_INTERRUPT_STATUS2__DCFE1_PERFMON_COUNTER4_INT_CLEAR_MASK                                 0x00001000L
#define DMCU_PERFMON_INTERRUPT_STATUS2__DCFE1_PERFMON_COUNTER5_INT_OCCURRED_MASK                              0x00002000L
#define DMCU_PERFMON_INTERRUPT_STATUS2__DCFE1_PERFMON_COUNTER5_INT_CLEAR_MASK                                 0x00002000L
#define DMCU_PERFMON_INTERRUPT_STATUS2__DCFE1_PERFMON_COUNTER6_INT_OCCURRED_MASK                              0x00004000L
#define DMCU_PERFMON_INTERRUPT_STATUS2__DCFE1_PERFMON_COUNTER6_INT_CLEAR_MASK                                 0x00004000L
#define DMCU_PERFMON_INTERRUPT_STATUS2__DCFE1_PERFMON_COUNTER7_INT_OCCURRED_MASK                              0x00008000L
#define DMCU_PERFMON_INTERRUPT_STATUS2__DCFE1_PERFMON_COUNTER7_INT_CLEAR_MASK                                 0x00008000L
#define DMCU_PERFMON_INTERRUPT_STATUS2__DCFE2_PERFMON_COUNTER0_INT_OCCURRED_MASK                              0x00010000L
#define DMCU_PERFMON_INTERRUPT_STATUS2__DCFE2_PERFMON_COUNTER0_INT_CLEAR_MASK                                 0x00010000L
#define DMCU_PERFMON_INTERRUPT_STATUS2__DCFE2_PERFMON_COUNTER1_INT_OCCURRED_MASK                              0x00020000L
#define DMCU_PERFMON_INTERRUPT_STATUS2__DCFE2_PERFMON_COUNTER1_INT_CLEAR_MASK                                 0x00020000L
#define DMCU_PERFMON_INTERRUPT_STATUS2__DCFE2_PERFMON_COUNTER2_INT_OCCURRED_MASK                              0x00040000L
#define DMCU_PERFMON_INTERRUPT_STATUS2__DCFE2_PERFMON_COUNTER2_INT_CLEAR_MASK                                 0x00040000L
#define DMCU_PERFMON_INTERRUPT_STATUS2__DCFE2_PERFMON_COUNTER3_INT_OCCURRED_MASK                              0x00080000L
#define DMCU_PERFMON_INTERRUPT_STATUS2__DCFE2_PERFMON_COUNTER3_INT_CLEAR_MASK                                 0x00080000L
#define DMCU_PERFMON_INTERRUPT_STATUS2__DCFE2_PERFMON_COUNTER4_INT_OCCURRED_MASK                              0x00100000L
#define DMCU_PERFMON_INTERRUPT_STATUS2__DCFE2_PERFMON_COUNTER4_INT_CLEAR_MASK                                 0x00100000L
#define DMCU_PERFMON_INTERRUPT_STATUS2__DCFE2_PERFMON_COUNTER5_INT_OCCURRED_MASK                              0x00200000L
#define DMCU_PERFMON_INTERRUPT_STATUS2__DCFE2_PERFMON_COUNTER5_INT_CLEAR_MASK                                 0x00200000L
#define DMCU_PERFMON_INTERRUPT_STATUS2__DCFE2_PERFMON_COUNTER6_INT_OCCURRED_MASK                              0x00400000L
#define DMCU_PERFMON_INTERRUPT_STATUS2__DCFE2_PERFMON_COUNTER6_INT_CLEAR_MASK                                 0x00400000L
#define DMCU_PERFMON_INTERRUPT_STATUS2__DCFE2_PERFMON_COUNTER7_INT_OCCURRED_MASK                              0x00800000L
#define DMCU_PERFMON_INTERRUPT_STATUS2__DCFE2_PERFMON_COUNTER7_INT_CLEAR_MASK                                 0x00800000L
#define DMCU_PERFMON_INTERRUPT_STATUS2__DCFE0_PERFMON_COUNTER_OFF_INT_OCCURRED_MASK                           0x01000000L
#define DMCU_PERFMON_INTERRUPT_STATUS2__DCFE0_PERFMON_COUNTER_OFF_INT_CLEAR_MASK                              0x01000000L
#define DMCU_PERFMON_INTERRUPT_STATUS2__DCFE1_PERFMON_COUNTER_OFF_INT_OCCURRED_MASK                           0x02000000L
#define DMCU_PERFMON_INTERRUPT_STATUS2__DCFE1_PERFMON_COUNTER_OFF_INT_CLEAR_MASK                              0x02000000L
#define DMCU_PERFMON_INTERRUPT_STATUS2__DCFE2_PERFMON_COUNTER_OFF_INT_OCCURRED_MASK                           0x04000000L
#define DMCU_PERFMON_INTERRUPT_STATUS2__DCFE2_PERFMON_COUNTER_OFF_INT_CLEAR_MASK                              0x04000000L
//DMCU_PERFMON_INTERRUPT_STATUS3
#define DMCU_PERFMON_INTERRUPT_STATUS3__DCFE3_PERFMON_COUNTER0_INT_OCCURRED__SHIFT                            0x0
#define DMCU_PERFMON_INTERRUPT_STATUS3__DCFE3_PERFMON_COUNTER0_INT_CLEAR__SHIFT                               0x0
#define DMCU_PERFMON_INTERRUPT_STATUS3__DCFE3_PERFMON_COUNTER1_INT_OCCURRED__SHIFT                            0x1
#define DMCU_PERFMON_INTERRUPT_STATUS3__DCFE3_PERFMON_COUNTER1_INT_CLEAR__SHIFT                               0x1
#define DMCU_PERFMON_INTERRUPT_STATUS3__DCFE3_PERFMON_COUNTER2_INT_OCCURRED__SHIFT                            0x2
#define DMCU_PERFMON_INTERRUPT_STATUS3__DCFE3_PERFMON_COUNTER2_INT_CLEAR__SHIFT                               0x2
#define DMCU_PERFMON_INTERRUPT_STATUS3__DCFE3_PERFMON_COUNTER3_INT_OCCURRED__SHIFT                            0x3
#define DMCU_PERFMON_INTERRUPT_STATUS3__DCFE3_PERFMON_COUNTER3_INT_CLEAR__SHIFT                               0x3
#define DMCU_PERFMON_INTERRUPT_STATUS3__DCFE3_PERFMON_COUNTER4_INT_OCCURRED__SHIFT                            0x4
#define DMCU_PERFMON_INTERRUPT_STATUS3__DCFE3_PERFMON_COUNTER4_INT_CLEAR__SHIFT                               0x4
#define DMCU_PERFMON_INTERRUPT_STATUS3__DCFE3_PERFMON_COUNTER5_INT_OCCURRED__SHIFT                            0x5
#define DMCU_PERFMON_INTERRUPT_STATUS3__DCFE3_PERFMON_COUNTER5_INT_CLEAR__SHIFT                               0x5
#define DMCU_PERFMON_INTERRUPT_STATUS3__DCFE3_PERFMON_COUNTER6_INT_OCCURRED__SHIFT                            0x6
#define DMCU_PERFMON_INTERRUPT_STATUS3__DCFE3_PERFMON_COUNTER6_INT_CLEAR__SHIFT                               0x6
#define DMCU_PERFMON_INTERRUPT_STATUS3__DCFE3_PERFMON_COUNTER7_INT_OCCURRED__SHIFT                            0x7
#define DMCU_PERFMON_INTERRUPT_STATUS3__DCFE3_PERFMON_COUNTER7_INT_CLEAR__SHIFT                               0x7
#define DMCU_PERFMON_INTERRUPT_STATUS3__DCFE4_PERFMON_COUNTER0_INT_OCCURRED__SHIFT                            0x8
#define DMCU_PERFMON_INTERRUPT_STATUS3__DCFE4_PERFMON_COUNTER0_INT_CLEAR__SHIFT                               0x8
#define DMCU_PERFMON_INTERRUPT_STATUS3__DCFE4_PERFMON_COUNTER1_INT_OCCURRED__SHIFT                            0x9
#define DMCU_PERFMON_INTERRUPT_STATUS3__DCFE4_PERFMON_COUNTER1_INT_CLEAR__SHIFT                               0x9
#define DMCU_PERFMON_INTERRUPT_STATUS3__DCFE4_PERFMON_COUNTER2_INT_OCCURRED__SHIFT                            0xa
#define DMCU_PERFMON_INTERRUPT_STATUS3__DCFE4_PERFMON_COUNTER2_INT_CLEAR__SHIFT                               0xa
#define DMCU_PERFMON_INTERRUPT_STATUS3__DCFE4_PERFMON_COUNTER3_INT_OCCURRED__SHIFT                            0xb
#define DMCU_PERFMON_INTERRUPT_STATUS3__DCFE4_PERFMON_COUNTER3_INT_CLEAR__SHIFT                               0xb
#define DMCU_PERFMON_INTERRUPT_STATUS3__DCFE4_PERFMON_COUNTER4_INT_OCCURRED__SHIFT                            0xc
#define DMCU_PERFMON_INTERRUPT_STATUS3__DCFE4_PERFMON_COUNTER4_INT_CLEAR__SHIFT                               0xc
#define DMCU_PERFMON_INTERRUPT_STATUS3__DCFE4_PERFMON_COUNTER5_INT_OCCURRED__SHIFT                            0xd
#define DMCU_PERFMON_INTERRUPT_STATUS3__DCFE4_PERFMON_COUNTER5_INT_CLEAR__SHIFT                               0xd
#define DMCU_PERFMON_INTERRUPT_STATUS3__DCFE4_PERFMON_COUNTER6_INT_OCCURRED__SHIFT                            0xe
#define DMCU_PERFMON_INTERRUPT_STATUS3__DCFE4_PERFMON_COUNTER6_INT_CLEAR__SHIFT                               0xe
#define DMCU_PERFMON_INTERRUPT_STATUS3__DCFE4_PERFMON_COUNTER7_INT_OCCURRED__SHIFT                            0xf
#define DMCU_PERFMON_INTERRUPT_STATUS3__DCFE4_PERFMON_COUNTER7_INT_CLEAR__SHIFT                               0xf
#define DMCU_PERFMON_INTERRUPT_STATUS3__DCFE5_PERFMON_COUNTER0_INT_OCCURRED__SHIFT                            0x10
#define DMCU_PERFMON_INTERRUPT_STATUS3__DCFE5_PERFMON_COUNTER0_INT_CLEAR__SHIFT                               0x10
#define DMCU_PERFMON_INTERRUPT_STATUS3__DCFE5_PERFMON_COUNTER1_INT_OCCURRED__SHIFT                            0x11
#define DMCU_PERFMON_INTERRUPT_STATUS3__DCFE5_PERFMON_COUNTER1_INT_CLEAR__SHIFT                               0x11
#define DMCU_PERFMON_INTERRUPT_STATUS3__DCFE5_PERFMON_COUNTER2_INT_OCCURRED__SHIFT                            0x12
#define DMCU_PERFMON_INTERRUPT_STATUS3__DCFE5_PERFMON_COUNTER2_INT_CLEAR__SHIFT                               0x12
#define DMCU_PERFMON_INTERRUPT_STATUS3__DCFE5_PERFMON_COUNTER3_INT_OCCURRED__SHIFT                            0x13
#define DMCU_PERFMON_INTERRUPT_STATUS3__DCFE5_PERFMON_COUNTER3_INT_CLEAR__SHIFT                               0x13
#define DMCU_PERFMON_INTERRUPT_STATUS3__DCFE5_PERFMON_COUNTER4_INT_OCCURRED__SHIFT                            0x14
#define DMCU_PERFMON_INTERRUPT_STATUS3__DCFE5_PERFMON_COUNTER4_INT_CLEAR__SHIFT                               0x14
#define DMCU_PERFMON_INTERRUPT_STATUS3__DCFE5_PERFMON_COUNTER5_INT_OCCURRED__SHIFT                            0x15
#define DMCU_PERFMON_INTERRUPT_STATUS3__DCFE5_PERFMON_COUNTER5_INT_CLEAR__SHIFT                               0x15
#define DMCU_PERFMON_INTERRUPT_STATUS3__DCFE5_PERFMON_COUNTER6_INT_OCCURRED__SHIFT                            0x16
#define DMCU_PERFMON_INTERRUPT_STATUS3__DCFE5_PERFMON_COUNTER6_INT_CLEAR__SHIFT                               0x16
#define DMCU_PERFMON_INTERRUPT_STATUS3__DCFE5_PERFMON_COUNTER7_INT_OCCURRED__SHIFT                            0x17
#define DMCU_PERFMON_INTERRUPT_STATUS3__DCFE5_PERFMON_COUNTER7_INT_CLEAR__SHIFT                               0x17
#define DMCU_PERFMON_INTERRUPT_STATUS3__DCFE3_PERFMON_COUNTER_OFF_INT_OCCURRED__SHIFT                         0x18
#define DMCU_PERFMON_INTERRUPT_STATUS3__DCFE3_PERFMON_COUNTER_OFF_INT_CLEAR__SHIFT                            0x18
#define DMCU_PERFMON_INTERRUPT_STATUS3__DCFE4_PERFMON_COUNTER_OFF_INT_OCCURRED__SHIFT                         0x19
#define DMCU_PERFMON_INTERRUPT_STATUS3__DCFE4_PERFMON_COUNTER_OFF_INT_CLEAR__SHIFT                            0x19
#define DMCU_PERFMON_INTERRUPT_STATUS3__DCFE5_PERFMON_COUNTER_OFF_INT_OCCURRED__SHIFT                         0x1a
#define DMCU_PERFMON_INTERRUPT_STATUS3__DCFE5_PERFMON_COUNTER_OFF_INT_CLEAR__SHIFT                            0x1a
#define DMCU_PERFMON_INTERRUPT_STATUS3__DCFE3_PERFMON_COUNTER0_INT_OCCURRED_MASK                              0x00000001L
#define DMCU_PERFMON_INTERRUPT_STATUS3__DCFE3_PERFMON_COUNTER0_INT_CLEAR_MASK                                 0x00000001L
#define DMCU_PERFMON_INTERRUPT_STATUS3__DCFE3_PERFMON_COUNTER1_INT_OCCURRED_MASK                              0x00000002L
#define DMCU_PERFMON_INTERRUPT_STATUS3__DCFE3_PERFMON_COUNTER1_INT_CLEAR_MASK                                 0x00000002L
#define DMCU_PERFMON_INTERRUPT_STATUS3__DCFE3_PERFMON_COUNTER2_INT_OCCURRED_MASK                              0x00000004L
#define DMCU_PERFMON_INTERRUPT_STATUS3__DCFE3_PERFMON_COUNTER2_INT_CLEAR_MASK                                 0x00000004L
#define DMCU_PERFMON_INTERRUPT_STATUS3__DCFE3_PERFMON_COUNTER3_INT_OCCURRED_MASK                              0x00000008L
#define DMCU_PERFMON_INTERRUPT_STATUS3__DCFE3_PERFMON_COUNTER3_INT_CLEAR_MASK                                 0x00000008L
#define DMCU_PERFMON_INTERRUPT_STATUS3__DCFE3_PERFMON_COUNTER4_INT_OCCURRED_MASK                              0x00000010L
#define DMCU_PERFMON_INTERRUPT_STATUS3__DCFE3_PERFMON_COUNTER4_INT_CLEAR_MASK                                 0x00000010L
#define DMCU_PERFMON_INTERRUPT_STATUS3__DCFE3_PERFMON_COUNTER5_INT_OCCURRED_MASK                              0x00000020L
#define DMCU_PERFMON_INTERRUPT_STATUS3__DCFE3_PERFMON_COUNTER5_INT_CLEAR_MASK                                 0x00000020L
#define DMCU_PERFMON_INTERRUPT_STATUS3__DCFE3_PERFMON_COUNTER6_INT_OCCURRED_MASK                              0x00000040L
#define DMCU_PERFMON_INTERRUPT_STATUS3__DCFE3_PERFMON_COUNTER6_INT_CLEAR_MASK                                 0x00000040L
#define DMCU_PERFMON_INTERRUPT_STATUS3__DCFE3_PERFMON_COUNTER7_INT_OCCURRED_MASK                              0x00000080L
#define DMCU_PERFMON_INTERRUPT_STATUS3__DCFE3_PERFMON_COUNTER7_INT_CLEAR_MASK                                 0x00000080L
#define DMCU_PERFMON_INTERRUPT_STATUS3__DCFE4_PERFMON_COUNTER0_INT_OCCURRED_MASK                              0x00000100L
#define DMCU_PERFMON_INTERRUPT_STATUS3__DCFE4_PERFMON_COUNTER0_INT_CLEAR_MASK                                 0x00000100L
#define DMCU_PERFMON_INTERRUPT_STATUS3__DCFE4_PERFMON_COUNTER1_INT_OCCURRED_MASK                              0x00000200L
#define DMCU_PERFMON_INTERRUPT_STATUS3__DCFE4_PERFMON_COUNTER1_INT_CLEAR_MASK                                 0x00000200L
#define DMCU_PERFMON_INTERRUPT_STATUS3__DCFE4_PERFMON_COUNTER2_INT_OCCURRED_MASK                              0x00000400L
#define DMCU_PERFMON_INTERRUPT_STATUS3__DCFE4_PERFMON_COUNTER2_INT_CLEAR_MASK                                 0x00000400L
#define DMCU_PERFMON_INTERRUPT_STATUS3__DCFE4_PERFMON_COUNTER3_INT_OCCURRED_MASK                              0x00000800L
#define DMCU_PERFMON_INTERRUPT_STATUS3__DCFE4_PERFMON_COUNTER3_INT_CLEAR_MASK                                 0x00000800L
#define DMCU_PERFMON_INTERRUPT_STATUS3__DCFE4_PERFMON_COUNTER4_INT_OCCURRED_MASK                              0x00001000L
#define DMCU_PERFMON_INTERRUPT_STATUS3__DCFE4_PERFMON_COUNTER4_INT_CLEAR_MASK                                 0x00001000L
#define DMCU_PERFMON_INTERRUPT_STATUS3__DCFE4_PERFMON_COUNTER5_INT_OCCURRED_MASK                              0x00002000L
#define DMCU_PERFMON_INTERRUPT_STATUS3__DCFE4_PERFMON_COUNTER5_INT_CLEAR_MASK                                 0x00002000L
#define DMCU_PERFMON_INTERRUPT_STATUS3__DCFE4_PERFMON_COUNTER6_INT_OCCURRED_MASK                              0x00004000L
#define DMCU_PERFMON_INTERRUPT_STATUS3__DCFE4_PERFMON_COUNTER6_INT_CLEAR_MASK                                 0x00004000L
#define DMCU_PERFMON_INTERRUPT_STATUS3__DCFE4_PERFMON_COUNTER7_INT_OCCURRED_MASK                              0x00008000L
#define DMCU_PERFMON_INTERRUPT_STATUS3__DCFE4_PERFMON_COUNTER7_INT_CLEAR_MASK                                 0x00008000L
#define DMCU_PERFMON_INTERRUPT_STATUS3__DCFE5_PERFMON_COUNTER0_INT_OCCURRED_MASK                              0x00010000L
#define DMCU_PERFMON_INTERRUPT_STATUS3__DCFE5_PERFMON_COUNTER0_INT_CLEAR_MASK                                 0x00010000L
#define DMCU_PERFMON_INTERRUPT_STATUS3__DCFE5_PERFMON_COUNTER1_INT_OCCURRED_MASK                              0x00020000L
#define DMCU_PERFMON_INTERRUPT_STATUS3__DCFE5_PERFMON_COUNTER1_INT_CLEAR_MASK                                 0x00020000L
#define DMCU_PERFMON_INTERRUPT_STATUS3__DCFE5_PERFMON_COUNTER2_INT_OCCURRED_MASK                              0x00040000L
#define DMCU_PERFMON_INTERRUPT_STATUS3__DCFE5_PERFMON_COUNTER2_INT_CLEAR_MASK                                 0x00040000L
#define DMCU_PERFMON_INTERRUPT_STATUS3__DCFE5_PERFMON_COUNTER3_INT_OCCURRED_MASK                              0x00080000L
#define DMCU_PERFMON_INTERRUPT_STATUS3__DCFE5_PERFMON_COUNTER3_INT_CLEAR_MASK                                 0x00080000L
#define DMCU_PERFMON_INTERRUPT_STATUS3__DCFE5_PERFMON_COUNTER4_INT_OCCURRED_MASK                              0x00100000L
#define DMCU_PERFMON_INTERRUPT_STATUS3__DCFE5_PERFMON_COUNTER4_INT_CLEAR_MASK                                 0x00100000L
#define DMCU_PERFMON_INTERRUPT_STATUS3__DCFE5_PERFMON_COUNTER5_INT_OCCURRED_MASK                              0x00200000L
#define DMCU_PERFMON_INTERRUPT_STATUS3__DCFE5_PERFMON_COUNTER5_INT_CLEAR_MASK                                 0x00200000L
#define DMCU_PERFMON_INTERRUPT_STATUS3__DCFE5_PERFMON_COUNTER6_INT_OCCURRED_MASK                              0x00400000L
#define DMCU_PERFMON_INTERRUPT_STATUS3__DCFE5_PERFMON_COUNTER6_INT_CLEAR_MASK                                 0x00400000L
#define DMCU_PERFMON_INTERRUPT_STATUS3__DCFE5_PERFMON_COUNTER7_INT_OCCURRED_MASK                              0x00800000L
#define DMCU_PERFMON_INTERRUPT_STATUS3__DCFE5_PERFMON_COUNTER7_INT_CLEAR_MASK                                 0x00800000L
#define DMCU_PERFMON_INTERRUPT_STATUS3__DCFE3_PERFMON_COUNTER_OFF_INT_OCCURRED_MASK                           0x01000000L
#define DMCU_PERFMON_INTERRUPT_STATUS3__DCFE3_PERFMON_COUNTER_OFF_INT_CLEAR_MASK                              0x01000000L
#define DMCU_PERFMON_INTERRUPT_STATUS3__DCFE4_PERFMON_COUNTER_OFF_INT_OCCURRED_MASK                           0x02000000L
#define DMCU_PERFMON_INTERRUPT_STATUS3__DCFE4_PERFMON_COUNTER_OFF_INT_CLEAR_MASK                              0x02000000L
#define DMCU_PERFMON_INTERRUPT_STATUS3__DCFE5_PERFMON_COUNTER_OFF_INT_OCCURRED_MASK                           0x04000000L
#define DMCU_PERFMON_INTERRUPT_STATUS3__DCFE5_PERFMON_COUNTER_OFF_INT_CLEAR_MASK                              0x04000000L
//DMCU_PERFMON_INTERRUPT_STATUS4
#define DMCU_PERFMON_INTERRUPT_STATUS4__WB_PERFMON_COUNTER0_INT_OCCURRED__SHIFT                               0x0
#define DMCU_PERFMON_INTERRUPT_STATUS4__WB_PERFMON_COUNTER0_INT_CLEAR__SHIFT                                  0x0
#define DMCU_PERFMON_INTERRUPT_STATUS4__WB_PERFMON_COUNTER1_INT_OCCURRED__SHIFT                               0x1
#define DMCU_PERFMON_INTERRUPT_STATUS4__WB_PERFMON_COUNTER1_INT_CLEAR__SHIFT                                  0x1
#define DMCU_PERFMON_INTERRUPT_STATUS4__WB_PERFMON_COUNTER2_INT_OCCURRED__SHIFT                               0x2
#define DMCU_PERFMON_INTERRUPT_STATUS4__WB_PERFMON_COUNTER2_INT_CLEAR__SHIFT                                  0x2
#define DMCU_PERFMON_INTERRUPT_STATUS4__WB_PERFMON_COUNTER3_INT_OCCURRED__SHIFT                               0x3
#define DMCU_PERFMON_INTERRUPT_STATUS4__WB_PERFMON_COUNTER3_INT_CLEAR__SHIFT                                  0x3
#define DMCU_PERFMON_INTERRUPT_STATUS4__WB_PERFMON_COUNTER4_INT_OCCURRED__SHIFT                               0x4
#define DMCU_PERFMON_INTERRUPT_STATUS4__WB_PERFMON_COUNTER4_INT_CLEAR__SHIFT                                  0x4
#define DMCU_PERFMON_INTERRUPT_STATUS4__WB_PERFMON_COUNTER5_INT_OCCURRED__SHIFT                               0x5
#define DMCU_PERFMON_INTERRUPT_STATUS4__WB_PERFMON_COUNTER5_INT_CLEAR__SHIFT                                  0x5
#define DMCU_PERFMON_INTERRUPT_STATUS4__WB_PERFMON_COUNTER6_INT_OCCURRED__SHIFT                               0x6
#define DMCU_PERFMON_INTERRUPT_STATUS4__WB_PERFMON_COUNTER6_INT_CLEAR__SHIFT                                  0x6
#define DMCU_PERFMON_INTERRUPT_STATUS4__WB_PERFMON_COUNTER7_INT_OCCURRED__SHIFT                               0x7
#define DMCU_PERFMON_INTERRUPT_STATUS4__WB_PERFMON_COUNTER7_INT_CLEAR__SHIFT                                  0x7
#define DMCU_PERFMON_INTERRUPT_STATUS4__DCRX_PERFMON_COUNTER0_INT_OCCURRED__SHIFT                             0x8
#define DMCU_PERFMON_INTERRUPT_STATUS4__DCRX_PERFMON_COUNTER0_INT_CLEAR__SHIFT                                0x8
#define DMCU_PERFMON_INTERRUPT_STATUS4__DCRX_PERFMON_COUNTER1_INT_OCCURRED__SHIFT                             0x9
#define DMCU_PERFMON_INTERRUPT_STATUS4__DCRX_PERFMON_COUNTER1_INT_CLEAR__SHIFT                                0x9
#define DMCU_PERFMON_INTERRUPT_STATUS4__DCRX_PERFMON_COUNTER2_INT_OCCURRED__SHIFT                             0xa
#define DMCU_PERFMON_INTERRUPT_STATUS4__DCRX_PERFMON_COUNTER2_INT_CLEAR__SHIFT                                0xa
#define DMCU_PERFMON_INTERRUPT_STATUS4__DCRX_PERFMON_COUNTER3_INT_OCCURRED__SHIFT                             0xb
#define DMCU_PERFMON_INTERRUPT_STATUS4__DCRX_PERFMON_COUNTER3_INT_CLEAR__SHIFT                                0xb
#define DMCU_PERFMON_INTERRUPT_STATUS4__DCRX_PERFMON_COUNTER4_INT_OCCURRED__SHIFT                             0xc
#define DMCU_PERFMON_INTERRUPT_STATUS4__DCRX_PERFMON_COUNTER4_INT_CLEAR__SHIFT                                0xc
#define DMCU_PERFMON_INTERRUPT_STATUS4__DCRX_PERFMON_COUNTER5_INT_OCCURRED__SHIFT                             0xd
#define DMCU_PERFMON_INTERRUPT_STATUS4__DCRX_PERFMON_COUNTER5_INT_CLEAR__SHIFT                                0xd
#define DMCU_PERFMON_INTERRUPT_STATUS4__DCRX_PERFMON_COUNTER6_INT_OCCURRED__SHIFT                             0xe
#define DMCU_PERFMON_INTERRUPT_STATUS4__DCRX_PERFMON_COUNTER6_INT_CLEAR__SHIFT                                0xe
#define DMCU_PERFMON_INTERRUPT_STATUS4__DCRX_PERFMON_COUNTER7_INT_OCCURRED__SHIFT                             0xf
#define DMCU_PERFMON_INTERRUPT_STATUS4__DCRX_PERFMON_COUNTER7_INT_CLEAR__SHIFT                                0xf
#define DMCU_PERFMON_INTERRUPT_STATUS4__DCCG_PERFMON2_COUNTER0_INT_OCCURRED__SHIFT                            0x10
#define DMCU_PERFMON_INTERRUPT_STATUS4__DCCG_PERFMON2_COUNTER0_INT_CLEAR__SHIFT                               0x10
#define DMCU_PERFMON_INTERRUPT_STATUS4__DCCG_PERFMON2_COUNTER1_INT_OCCURRED__SHIFT                            0x11
#define DMCU_PERFMON_INTERRUPT_STATUS4__DCCG_PERFMON2_COUNTER1_INT_CLEAR__SHIFT                               0x11
#define DMCU_PERFMON_INTERRUPT_STATUS4__DCCG_PERFMON2_COUNTER2_INT_OCCURRED__SHIFT                            0x12
#define DMCU_PERFMON_INTERRUPT_STATUS4__DCCG_PERFMON2_COUNTER2_INT_CLEAR__SHIFT                               0x12
#define DMCU_PERFMON_INTERRUPT_STATUS4__DCCG_PERFMON2_COUNTER3_INT_OCCURRED__SHIFT                            0x13
#define DMCU_PERFMON_INTERRUPT_STATUS4__DCCG_PERFMON2_COUNTER3_INT_CLEAR__SHIFT                               0x13
#define DMCU_PERFMON_INTERRUPT_STATUS4__DCCG_PERFMON2_COUNTER4_INT_OCCURRED__SHIFT                            0x14
#define DMCU_PERFMON_INTERRUPT_STATUS4__DCCG_PERFMON2_COUNTER4_INT_CLEAR__SHIFT                               0x14
#define DMCU_PERFMON_INTERRUPT_STATUS4__DCCG_PERFMON2_COUNTER5_INT_OCCURRED__SHIFT                            0x15
#define DMCU_PERFMON_INTERRUPT_STATUS4__DCCG_PERFMON2_COUNTER5_INT_CLEAR__SHIFT                               0x15
#define DMCU_PERFMON_INTERRUPT_STATUS4__DCCG_PERFMON2_COUNTER6_INT_OCCURRED__SHIFT                            0x16
#define DMCU_PERFMON_INTERRUPT_STATUS4__DCCG_PERFMON2_COUNTER6_INT_CLEAR__SHIFT                               0x16
#define DMCU_PERFMON_INTERRUPT_STATUS4__DCCG_PERFMON2_COUNTER7_INT_OCCURRED__SHIFT                            0x17
#define DMCU_PERFMON_INTERRUPT_STATUS4__DCCG_PERFMON2_COUNTER7_INT_CLEAR__SHIFT                               0x17
#define DMCU_PERFMON_INTERRUPT_STATUS4__WB_PERFMON_COUNTER_OFF_INT_OCCURRED__SHIFT                            0x18
#define DMCU_PERFMON_INTERRUPT_STATUS4__WB_PERFMON_COUNTER_OFF_INT_CLEAR__SHIFT                               0x18
#define DMCU_PERFMON_INTERRUPT_STATUS4__DCRX_PERFMON_COUNTER_OFF_INT_OCCURRED__SHIFT                          0x19
#define DMCU_PERFMON_INTERRUPT_STATUS4__DCRX_PERFMON_COUNTER_OFF_INT_CLEAR__SHIFT                             0x19
#define DMCU_PERFMON_INTERRUPT_STATUS4__DCCG_PERFMON2_COUNTER_OFF_INT_OCCURRED__SHIFT                         0x1a
#define DMCU_PERFMON_INTERRUPT_STATUS4__DCCG_PERFMON2_COUNTER_OFF_INT_CLEAR__SHIFT                            0x1a
#define DMCU_PERFMON_INTERRUPT_STATUS4__WB_PERFMON_COUNTER0_INT_OCCURRED_MASK                                 0x00000001L
#define DMCU_PERFMON_INTERRUPT_STATUS4__WB_PERFMON_COUNTER0_INT_CLEAR_MASK                                    0x00000001L
#define DMCU_PERFMON_INTERRUPT_STATUS4__WB_PERFMON_COUNTER1_INT_OCCURRED_MASK                                 0x00000002L
#define DMCU_PERFMON_INTERRUPT_STATUS4__WB_PERFMON_COUNTER1_INT_CLEAR_MASK                                    0x00000002L
#define DMCU_PERFMON_INTERRUPT_STATUS4__WB_PERFMON_COUNTER2_INT_OCCURRED_MASK                                 0x00000004L
#define DMCU_PERFMON_INTERRUPT_STATUS4__WB_PERFMON_COUNTER2_INT_CLEAR_MASK                                    0x00000004L
#define DMCU_PERFMON_INTERRUPT_STATUS4__WB_PERFMON_COUNTER3_INT_OCCURRED_MASK                                 0x00000008L
#define DMCU_PERFMON_INTERRUPT_STATUS4__WB_PERFMON_COUNTER3_INT_CLEAR_MASK                                    0x00000008L
#define DMCU_PERFMON_INTERRUPT_STATUS4__WB_PERFMON_COUNTER4_INT_OCCURRED_MASK                                 0x00000010L
#define DMCU_PERFMON_INTERRUPT_STATUS4__WB_PERFMON_COUNTER4_INT_CLEAR_MASK                                    0x00000010L
#define DMCU_PERFMON_INTERRUPT_STATUS4__WB_PERFMON_COUNTER5_INT_OCCURRED_MASK                                 0x00000020L
#define DMCU_PERFMON_INTERRUPT_STATUS4__WB_PERFMON_COUNTER5_INT_CLEAR_MASK                                    0x00000020L
#define DMCU_PERFMON_INTERRUPT_STATUS4__WB_PERFMON_COUNTER6_INT_OCCURRED_MASK                                 0x00000040L
#define DMCU_PERFMON_INTERRUPT_STATUS4__WB_PERFMON_COUNTER6_INT_CLEAR_MASK                                    0x00000040L
#define DMCU_PERFMON_INTERRUPT_STATUS4__WB_PERFMON_COUNTER7_INT_OCCURRED_MASK                                 0x00000080L
#define DMCU_PERFMON_INTERRUPT_STATUS4__WB_PERFMON_COUNTER7_INT_CLEAR_MASK                                    0x00000080L
#define DMCU_PERFMON_INTERRUPT_STATUS4__DCRX_PERFMON_COUNTER0_INT_OCCURRED_MASK                               0x00000100L
#define DMCU_PERFMON_INTERRUPT_STATUS4__DCRX_PERFMON_COUNTER0_INT_CLEAR_MASK                                  0x00000100L
#define DMCU_PERFMON_INTERRUPT_STATUS4__DCRX_PERFMON_COUNTER1_INT_OCCURRED_MASK                               0x00000200L
#define DMCU_PERFMON_INTERRUPT_STATUS4__DCRX_PERFMON_COUNTER1_INT_CLEAR_MASK                                  0x00000200L
#define DMCU_PERFMON_INTERRUPT_STATUS4__DCRX_PERFMON_COUNTER2_INT_OCCURRED_MASK                               0x00000400L
#define DMCU_PERFMON_INTERRUPT_STATUS4__DCRX_PERFMON_COUNTER2_INT_CLEAR_MASK                                  0x00000400L
#define DMCU_PERFMON_INTERRUPT_STATUS4__DCRX_PERFMON_COUNTER3_INT_OCCURRED_MASK                               0x00000800L
#define DMCU_PERFMON_INTERRUPT_STATUS4__DCRX_PERFMON_COUNTER3_INT_CLEAR_MASK                                  0x00000800L
#define DMCU_PERFMON_INTERRUPT_STATUS4__DCRX_PERFMON_COUNTER4_INT_OCCURRED_MASK                               0x00001000L
#define DMCU_PERFMON_INTERRUPT_STATUS4__DCRX_PERFMON_COUNTER4_INT_CLEAR_MASK                                  0x00001000L
#define DMCU_PERFMON_INTERRUPT_STATUS4__DCRX_PERFMON_COUNTER5_INT_OCCURRED_MASK                               0x00002000L
#define DMCU_PERFMON_INTERRUPT_STATUS4__DCRX_PERFMON_COUNTER5_INT_CLEAR_MASK                                  0x00002000L
#define DMCU_PERFMON_INTERRUPT_STATUS4__DCRX_PERFMON_COUNTER6_INT_OCCURRED_MASK                               0x00004000L
#define DMCU_PERFMON_INTERRUPT_STATUS4__DCRX_PERFMON_COUNTER6_INT_CLEAR_MASK                                  0x00004000L
#define DMCU_PERFMON_INTERRUPT_STATUS4__DCRX_PERFMON_COUNTER7_INT_OCCURRED_MASK                               0x00008000L
#define DMCU_PERFMON_INTERRUPT_STATUS4__DCRX_PERFMON_COUNTER7_INT_CLEAR_MASK                                  0x00008000L
#define DMCU_PERFMON_INTERRUPT_STATUS4__DCCG_PERFMON2_COUNTER0_INT_OCCURRED_MASK                              0x00010000L
#define DMCU_PERFMON_INTERRUPT_STATUS4__DCCG_PERFMON2_COUNTER0_INT_CLEAR_MASK                                 0x00010000L
#define DMCU_PERFMON_INTERRUPT_STATUS4__DCCG_PERFMON2_COUNTER1_INT_OCCURRED_MASK                              0x00020000L
#define DMCU_PERFMON_INTERRUPT_STATUS4__DCCG_PERFMON2_COUNTER1_INT_CLEAR_MASK                                 0x00020000L
#define DMCU_PERFMON_INTERRUPT_STATUS4__DCCG_PERFMON2_COUNTER2_INT_OCCURRED_MASK                              0x00040000L
#define DMCU_PERFMON_INTERRUPT_STATUS4__DCCG_PERFMON2_COUNTER2_INT_CLEAR_MASK                                 0x00040000L
#define DMCU_PERFMON_INTERRUPT_STATUS4__DCCG_PERFMON2_COUNTER3_INT_OCCURRED_MASK                              0x00080000L
#define DMCU_PERFMON_INTERRUPT_STATUS4__DCCG_PERFMON2_COUNTER3_INT_CLEAR_MASK                                 0x00080000L
#define DMCU_PERFMON_INTERRUPT_STATUS4__DCCG_PERFMON2_COUNTER4_INT_OCCURRED_MASK                              0x00100000L
#define DMCU_PERFMON_INTERRUPT_STATUS4__DCCG_PERFMON2_COUNTER4_INT_CLEAR_MASK                                 0x00100000L
#define DMCU_PERFMON_INTERRUPT_STATUS4__DCCG_PERFMON2_COUNTER5_INT_OCCURRED_MASK                              0x00200000L
#define DMCU_PERFMON_INTERRUPT_STATUS4__DCCG_PERFMON2_COUNTER5_INT_CLEAR_MASK                                 0x00200000L
#define DMCU_PERFMON_INTERRUPT_STATUS4__DCCG_PERFMON2_COUNTER6_INT_OCCURRED_MASK                              0x00400000L
#define DMCU_PERFMON_INTERRUPT_STATUS4__DCCG_PERFMON2_COUNTER6_INT_CLEAR_MASK                                 0x00400000L
#define DMCU_PERFMON_INTERRUPT_STATUS4__DCCG_PERFMON2_COUNTER7_INT_OCCURRED_MASK                              0x00800000L
#define DMCU_PERFMON_INTERRUPT_STATUS4__DCCG_PERFMON2_COUNTER7_INT_CLEAR_MASK                                 0x00800000L
#define DMCU_PERFMON_INTERRUPT_STATUS4__WB_PERFMON_COUNTER_OFF_INT_OCCURRED_MASK                              0x01000000L
#define DMCU_PERFMON_INTERRUPT_STATUS4__WB_PERFMON_COUNTER_OFF_INT_CLEAR_MASK                                 0x01000000L
#define DMCU_PERFMON_INTERRUPT_STATUS4__DCRX_PERFMON_COUNTER_OFF_INT_OCCURRED_MASK                            0x02000000L
#define DMCU_PERFMON_INTERRUPT_STATUS4__DCRX_PERFMON_COUNTER_OFF_INT_CLEAR_MASK                               0x02000000L
#define DMCU_PERFMON_INTERRUPT_STATUS4__DCCG_PERFMON2_COUNTER_OFF_INT_OCCURRED_MASK                           0x04000000L
#define DMCU_PERFMON_INTERRUPT_STATUS4__DCCG_PERFMON2_COUNTER_OFF_INT_CLEAR_MASK                              0x04000000L
//DC_ABM1_HGLS_REG_READ_PROGRESS
#define DC_ABM1_HGLS_REG_READ_PROGRESS__ABM1_HG_REG_READ_IN_PROGRESS__SHIFT                                   0x0
#define DC_ABM1_HGLS_REG_READ_PROGRESS__ABM1_LS_REG_READ_IN_PROGRESS__SHIFT                                   0x1
#define DC_ABM1_HGLS_REG_READ_PROGRESS__ABM1_BL_REG_READ_IN_PROGRESS__SHIFT                                   0x2
#define DC_ABM1_HGLS_REG_READ_PROGRESS__ABM1_HG_REG_READ_MISSED_FRAME__SHIFT                                  0x8
#define DC_ABM1_HGLS_REG_READ_PROGRESS__ABM1_LS_REG_READ_MISSED_FRAME__SHIFT                                  0x9
#define DC_ABM1_HGLS_REG_READ_PROGRESS__ABM1_BL_REG_READ_MISSED_FRAME__SHIFT                                  0xa
#define DC_ABM1_HGLS_REG_READ_PROGRESS__ABM1_HG_REG_READ_MISSED_FRAME_CLEAR__SHIFT                            0x10
#define DC_ABM1_HGLS_REG_READ_PROGRESS__ABM1_LS_REG_READ_MISSED_FRAME_CLEAR__SHIFT                            0x18
#define DC_ABM1_HGLS_REG_READ_PROGRESS__ABM1_BL_REG_READ_MISSED_FRAME_CLEAR__SHIFT                            0x1f
#define DC_ABM1_HGLS_REG_READ_PROGRESS__ABM1_HG_REG_READ_IN_PROGRESS_MASK                                     0x00000001L
#define DC_ABM1_HGLS_REG_READ_PROGRESS__ABM1_LS_REG_READ_IN_PROGRESS_MASK                                     0x00000002L
#define DC_ABM1_HGLS_REG_READ_PROGRESS__ABM1_BL_REG_READ_IN_PROGRESS_MASK                                     0x00000004L
#define DC_ABM1_HGLS_REG_READ_PROGRESS__ABM1_HG_REG_READ_MISSED_FRAME_MASK                                    0x00000100L
#define DC_ABM1_HGLS_REG_READ_PROGRESS__ABM1_LS_REG_READ_MISSED_FRAME_MASK                                    0x00000200L
#define DC_ABM1_HGLS_REG_READ_PROGRESS__ABM1_BL_REG_READ_MISSED_FRAME_MASK                                    0x00000400L
#define DC_ABM1_HGLS_REG_READ_PROGRESS__ABM1_HG_REG_READ_MISSED_FRAME_CLEAR_MASK                              0x00010000L
#define DC_ABM1_HGLS_REG_READ_PROGRESS__ABM1_LS_REG_READ_MISSED_FRAME_CLEAR_MASK                              0x01000000L
#define DC_ABM1_HGLS_REG_READ_PROGRESS__ABM1_BL_REG_READ_MISSED_FRAME_CLEAR_MASK                              0x80000000L
//DC_ABM1_HG_MISC_CTRL
#define DC_ABM1_HG_MISC_CTRL__ABM1_HG_NUM_OF_BINS_SEL__SHIFT                                                  0x0
#define DC_ABM1_HG_MISC_CTRL__ABM1_HG_VMAX_SEL__SHIFT                                                         0x8
#define DC_ABM1_HG_MISC_CTRL__ABM1_HG_FINE_MODE_BIN_SEL__SHIFT                                                0xc
#define DC_ABM1_HG_MISC_CTRL__ABM1_HG_BIN_BITWIDTH_SIZE_SEL__SHIFT                                            0x10
#define DC_ABM1_HG_MISC_CTRL__ABM1_OVR_SCAN_PIXEL_PROCESS_EN__SHIFT                                           0x14
#define DC_ABM1_HG_MISC_CTRL__ABM1_DBUF_HGLS_READBACK_DB_REG_VALUE_EN__SHIFT                                  0x17
#define DC_ABM1_HG_MISC_CTRL__ABM1_DBUF_HGLS_REG_FRAME_START_DISP_SEL__SHIFT                                  0x18
#define DC_ABM1_HG_MISC_CTRL__ABM1_DBUF_HGLS_REG_UPDATE_AT_FRAME_START__SHIFT                                 0x1c
#define DC_ABM1_HG_MISC_CTRL__ABM1_HGLS_IGNORE_MASTER_LOCK_EN__SHIFT                                          0x1d
#define DC_ABM1_HG_MISC_CTRL__ABM1_DBUF_HGLS_REG_UPDATE_PENDING__SHIFT                                        0x1e
#define DC_ABM1_HG_MISC_CTRL__ABM1_HGLS_REG_LOCK__SHIFT                                                       0x1f
#define DC_ABM1_HG_MISC_CTRL__ABM1_HG_NUM_OF_BINS_SEL_MASK                                                    0x00000003L
#define DC_ABM1_HG_MISC_CTRL__ABM1_HG_VMAX_SEL_MASK                                                           0x00000100L
#define DC_ABM1_HG_MISC_CTRL__ABM1_HG_FINE_MODE_BIN_SEL_MASK                                                  0x00001000L
#define DC_ABM1_HG_MISC_CTRL__ABM1_HG_BIN_BITWIDTH_SIZE_SEL_MASK                                              0x00030000L
#define DC_ABM1_HG_MISC_CTRL__ABM1_OVR_SCAN_PIXEL_PROCESS_EN_MASK                                             0x00100000L
#define DC_ABM1_HG_MISC_CTRL__ABM1_DBUF_HGLS_READBACK_DB_REG_VALUE_EN_MASK                                    0x00800000L
#define DC_ABM1_HG_MISC_CTRL__ABM1_DBUF_HGLS_REG_FRAME_START_DISP_SEL_MASK                                    0x07000000L
#define DC_ABM1_HG_MISC_CTRL__ABM1_DBUF_HGLS_REG_UPDATE_AT_FRAME_START_MASK                                   0x10000000L
#define DC_ABM1_HG_MISC_CTRL__ABM1_HGLS_IGNORE_MASTER_LOCK_EN_MASK                                            0x20000000L
#define DC_ABM1_HG_MISC_CTRL__ABM1_DBUF_HGLS_REG_UPDATE_PENDING_MASK                                          0x40000000L
#define DC_ABM1_HG_MISC_CTRL__ABM1_HGLS_REG_LOCK_MASK                                                         0x80000000L
//DC_ABM1_LS_SUM_OF_LUMA
#define DC_ABM1_LS_SUM_OF_LUMA__ABM1_LS_SUM_OF_LUMA__SHIFT                                                    0x0
#define DC_ABM1_LS_SUM_OF_LUMA__ABM1_LS_SUM_OF_LUMA_MASK                                                      0xFFFFFFFFL
//DC_ABM1_LS_MIN_MAX_LUMA
#define DC_ABM1_LS_MIN_MAX_LUMA__ABM1_LS_MIN_LUMA__SHIFT                                                      0x0
#define DC_ABM1_LS_MIN_MAX_LUMA__ABM1_LS_MAX_LUMA__SHIFT                                                      0x10
#define DC_ABM1_LS_MIN_MAX_LUMA__ABM1_LS_MIN_LUMA_MASK                                                        0x000003FFL
#define DC_ABM1_LS_MIN_MAX_LUMA__ABM1_LS_MAX_LUMA_MASK                                                        0x03FF0000L
//DC_ABM1_LS_FILTERED_MIN_MAX_LUMA
#define DC_ABM1_LS_FILTERED_MIN_MAX_LUMA__ABM1_LS_FILTERED_MIN_LUMA__SHIFT                                    0x0
#define DC_ABM1_LS_FILTERED_MIN_MAX_LUMA__ABM1_LS_FILTERED_MAX_LUMA__SHIFT                                    0x10
#define DC_ABM1_LS_FILTERED_MIN_MAX_LUMA__ABM1_LS_FILTERED_MIN_LUMA_MASK                                      0x000003FFL
#define DC_ABM1_LS_FILTERED_MIN_MAX_LUMA__ABM1_LS_FILTERED_MAX_LUMA_MASK                                      0x03FF0000L
//DC_ABM1_LS_PIXEL_COUNT
#define DC_ABM1_LS_PIXEL_COUNT__ABM1_LS_PIXEL_COUNT__SHIFT                                                    0x0
#define DC_ABM1_LS_PIXEL_COUNT__ABM1_LS_PIXEL_COUNT_MASK                                                      0x00FFFFFFL
//DC_ABM1_LS_OVR_SCAN_BIN
#define DC_ABM1_LS_OVR_SCAN_BIN__ABM1_LS_OVR_SCAN_BIN__SHIFT                                                  0x0
#define DC_ABM1_LS_OVR_SCAN_BIN__ABM1_LS_OVR_SCAN_BIN_MASK                                                    0x00FFFFFFL
//DC_ABM1_LS_MIN_MAX_PIXEL_VALUE_THRES
#define DC_ABM1_LS_MIN_MAX_PIXEL_VALUE_THRES__ABM1_LS_MIN_PIXEL_VALUE_THRES__SHIFT                            0x0
#define DC_ABM1_LS_MIN_MAX_PIXEL_VALUE_THRES__ABM1_LS_MAX_PIXEL_VALUE_THRES__SHIFT                            0x10
#define DC_ABM1_LS_MIN_MAX_PIXEL_VALUE_THRES__ABM1_HGLS_REG_LOCK__SHIFT                                       0x1f
#define DC_ABM1_LS_MIN_MAX_PIXEL_VALUE_THRES__ABM1_LS_MIN_PIXEL_VALUE_THRES_MASK                              0x000003FFL
#define DC_ABM1_LS_MIN_MAX_PIXEL_VALUE_THRES__ABM1_LS_MAX_PIXEL_VALUE_THRES_MASK                              0x03FF0000L
#define DC_ABM1_LS_MIN_MAX_PIXEL_VALUE_THRES__ABM1_HGLS_REG_LOCK_MASK                                         0x80000000L
//DC_ABM1_LS_MIN_PIXEL_VALUE_COUNT
#define DC_ABM1_LS_MIN_PIXEL_VALUE_COUNT__ABM1_LS_MIN_PIXEL_VALUE_COUNT__SHIFT                                0x0
#define DC_ABM1_LS_MIN_PIXEL_VALUE_COUNT__ABM1_LS_MIN_PIXEL_VALUE_COUNT_MASK                                  0x00FFFFFFL
//DC_ABM1_LS_MAX_PIXEL_VALUE_COUNT
#define DC_ABM1_LS_MAX_PIXEL_VALUE_COUNT__ABM1_LS_MAX_PIXEL_VALUE_COUNT__SHIFT                                0x0
#define DC_ABM1_LS_MAX_PIXEL_VALUE_COUNT__ABM1_LS_MAX_PIXEL_VALUE_COUNT_MASK                                  0x00FFFFFFL
//DC_ABM1_HG_SAMPLE_RATE
#define DC_ABM1_HG_SAMPLE_RATE__ABM1_HG_SAMPLE_RATE_COUNT_EN__SHIFT                                           0x0
#define DC_ABM1_HG_SAMPLE_RATE__ABM1_HG_RESET_SAMPLE_RATE_FRAME_COUNTER__SHIFT                                0x1
#define DC_ABM1_HG_SAMPLE_RATE__ABM1_HG_SAMPLE_RATE_FRAME_COUNT__SHIFT                                        0x8
#define DC_ABM1_HG_SAMPLE_RATE__ABM1_HG_INITIAL_SAMPLE_RATE_COUNT_VALUE_WHEN_RESET__SHIFT                     0x10
#define DC_ABM1_HG_SAMPLE_RATE__ABM1_HGLS_REG_LOCK__SHIFT                                                     0x1f
#define DC_ABM1_HG_SAMPLE_RATE__ABM1_HG_SAMPLE_RATE_COUNT_EN_MASK                                             0x00000001L
#define DC_ABM1_HG_SAMPLE_RATE__ABM1_HG_RESET_SAMPLE_RATE_FRAME_COUNTER_MASK                                  0x00000002L
#define DC_ABM1_HG_SAMPLE_RATE__ABM1_HG_SAMPLE_RATE_FRAME_COUNT_MASK                                          0x0000FF00L
#define DC_ABM1_HG_SAMPLE_RATE__ABM1_HG_INITIAL_SAMPLE_RATE_COUNT_VALUE_WHEN_RESET_MASK                       0x00FF0000L
#define DC_ABM1_HG_SAMPLE_RATE__ABM1_HGLS_REG_LOCK_MASK                                                       0x80000000L
//DC_ABM1_LS_SAMPLE_RATE
#define DC_ABM1_LS_SAMPLE_RATE__ABM1_LS_SAMPLE_RATE_COUNT_EN__SHIFT                                           0x0
#define DC_ABM1_LS_SAMPLE_RATE__ABM1_LS_RESET_SAMPLE_RATE_FRAME_COUNTER__SHIFT                                0x1
#define DC_ABM1_LS_SAMPLE_RATE__ABM1_LS_SAMPLE_RATE_FRAME_COUNT__SHIFT                                        0x8
#define DC_ABM1_LS_SAMPLE_RATE__ABM1_LS_INITIAL_SAMPLE_RATE_COUNT_VALUE_WHEN_RESET__SHIFT                     0x10
#define DC_ABM1_LS_SAMPLE_RATE__ABM1_HGLS_REG_LOCK__SHIFT                                                     0x1f
#define DC_ABM1_LS_SAMPLE_RATE__ABM1_LS_SAMPLE_RATE_COUNT_EN_MASK                                             0x00000001L
#define DC_ABM1_LS_SAMPLE_RATE__ABM1_LS_RESET_SAMPLE_RATE_FRAME_COUNTER_MASK                                  0x00000002L
#define DC_ABM1_LS_SAMPLE_RATE__ABM1_LS_SAMPLE_RATE_FRAME_COUNT_MASK                                          0x0000FF00L
#define DC_ABM1_LS_SAMPLE_RATE__ABM1_LS_INITIAL_SAMPLE_RATE_COUNT_VALUE_WHEN_RESET_MASK                       0x00FF0000L
#define DC_ABM1_LS_SAMPLE_RATE__ABM1_HGLS_REG_LOCK_MASK                                                       0x80000000L
//DC_ABM1_HG_BIN_1_32_SHIFT_FLAG
#define DC_ABM1_HG_BIN_1_32_SHIFT_FLAG__ABM1_HG_BIN_1_32_SHIFT_FLAG__SHIFT                                    0x0
#define DC_ABM1_HG_BIN_1_32_SHIFT_FLAG__ABM1_HG_BIN_1_32_SHIFT_FLAG_MASK                                      0xFFFFFFFFL
//DC_ABM1_HG_BIN_1_8_SHIFT_INDEX
#define DC_ABM1_HG_BIN_1_8_SHIFT_INDEX__ABM1_HG_BIN_1_8_SHIFT_INDEX__SHIFT                                    0x0
#define DC_ABM1_HG_BIN_1_8_SHIFT_INDEX__ABM1_HG_BIN_1_8_SHIFT_INDEX_MASK                                      0xFFFFFFFFL
//DC_ABM1_HG_BIN_9_16_SHIFT_INDEX
#define DC_ABM1_HG_BIN_9_16_SHIFT_INDEX__ABM1_HG_BIN_9_16_SHIFT_INDEX__SHIFT                                  0x0
#define DC_ABM1_HG_BIN_9_16_SHIFT_INDEX__ABM1_HG_BIN_9_16_SHIFT_INDEX_MASK                                    0xFFFFFFFFL
//DC_ABM1_HG_BIN_17_24_SHIFT_INDEX
#define DC_ABM1_HG_BIN_17_24_SHIFT_INDEX__ABM1_HG_BIN_17_24_SHIFT_INDEX__SHIFT                                0x0
#define DC_ABM1_HG_BIN_17_24_SHIFT_INDEX__ABM1_HG_BIN_17_24_SHIFT_INDEX_MASK                                  0xFFFFFFFFL
//DC_ABM1_HG_BIN_25_32_SHIFT_INDEX
#define DC_ABM1_HG_BIN_25_32_SHIFT_INDEX__ABM1_HG_BIN_25_32_SHIFT_INDEX__SHIFT                                0x0
#define DC_ABM1_HG_BIN_25_32_SHIFT_INDEX__ABM1_HG_BIN_25_32_SHIFT_INDEX_MASK                                  0xFFFFFFFFL
//DC_ABM1_HG_RESULT_1
#define DC_ABM1_HG_RESULT_1__ABM1_HG_RESULT_1__SHIFT                                                          0x0
#define DC_ABM1_HG_RESULT_1__ABM1_HG_RESULT_1_MASK                                                            0xFFFFFFFFL
//DC_ABM1_HG_RESULT_2
#define DC_ABM1_HG_RESULT_2__ABM1_HG_RESULT_2__SHIFT                                                          0x0
#define DC_ABM1_HG_RESULT_2__ABM1_HG_RESULT_2_MASK                                                            0xFFFFFFFFL
//DC_ABM1_HG_RESULT_3
#define DC_ABM1_HG_RESULT_3__ABM1_HG_RESULT_3__SHIFT                                                          0x0
#define DC_ABM1_HG_RESULT_3__ABM1_HG_RESULT_3_MASK                                                            0xFFFFFFFFL
//DC_ABM1_HG_RESULT_4
#define DC_ABM1_HG_RESULT_4__ABM1_HG_RESULT_4__SHIFT                                                          0x0
#define DC_ABM1_HG_RESULT_4__ABM1_HG_RESULT_4_MASK                                                            0xFFFFFFFFL
//DC_ABM1_HG_RESULT_5
#define DC_ABM1_HG_RESULT_5__ABM1_HG_RESULT_5__SHIFT                                                          0x0
#define DC_ABM1_HG_RESULT_5__ABM1_HG_RESULT_5_MASK                                                            0xFFFFFFFFL
//DC_ABM1_HG_RESULT_6
#define DC_ABM1_HG_RESULT_6__ABM1_HG_RESULT_6__SHIFT                                                          0x0
#define DC_ABM1_HG_RESULT_6__ABM1_HG_RESULT_6_MASK                                                            0xFFFFFFFFL
//DC_ABM1_HG_RESULT_7
#define DC_ABM1_HG_RESULT_7__ABM1_HG_RESULT_7__SHIFT                                                          0x0
#define DC_ABM1_HG_RESULT_7__ABM1_HG_RESULT_7_MASK                                                            0xFFFFFFFFL
//DC_ABM1_HG_RESULT_8
#define DC_ABM1_HG_RESULT_8__ABM1_HG_RESULT_8__SHIFT                                                          0x0
#define DC_ABM1_HG_RESULT_8__ABM1_HG_RESULT_8_MASK                                                            0xFFFFFFFFL
//DC_ABM1_HG_RESULT_9
#define DC_ABM1_HG_RESULT_9__ABM1_HG_RESULT_9__SHIFT                                                          0x0
#define DC_ABM1_HG_RESULT_9__ABM1_HG_RESULT_9_MASK                                                            0xFFFFFFFFL
//DC_ABM1_HG_RESULT_10
#define DC_ABM1_HG_RESULT_10__ABM1_HG_RESULT_10__SHIFT                                                        0x0
#define DC_ABM1_HG_RESULT_10__ABM1_HG_RESULT_10_MASK                                                          0xFFFFFFFFL
//DC_ABM1_HG_RESULT_11
#define DC_ABM1_HG_RESULT_11__ABM1_HG_RESULT_11__SHIFT                                                        0x0
#define DC_ABM1_HG_RESULT_11__ABM1_HG_RESULT_11_MASK                                                          0xFFFFFFFFL
//DC_ABM1_HG_RESULT_12
#define DC_ABM1_HG_RESULT_12__ABM1_HG_RESULT_12__SHIFT                                                        0x0
#define DC_ABM1_HG_RESULT_12__ABM1_HG_RESULT_12_MASK                                                          0xFFFFFFFFL
//DC_ABM1_HG_RESULT_13
#define DC_ABM1_HG_RESULT_13__ABM1_HG_RESULT_13__SHIFT                                                        0x0
#define DC_ABM1_HG_RESULT_13__ABM1_HG_RESULT_13_MASK                                                          0xFFFFFFFFL
//DC_ABM1_HG_RESULT_14
#define DC_ABM1_HG_RESULT_14__ABM1_HG_RESULT_14__SHIFT                                                        0x0
#define DC_ABM1_HG_RESULT_14__ABM1_HG_RESULT_14_MASK                                                          0xFFFFFFFFL
//DC_ABM1_HG_RESULT_15
#define DC_ABM1_HG_RESULT_15__ABM1_HG_RESULT_15__SHIFT                                                        0x0
#define DC_ABM1_HG_RESULT_15__ABM1_HG_RESULT_15_MASK                                                          0xFFFFFFFFL
//DC_ABM1_HG_RESULT_16
#define DC_ABM1_HG_RESULT_16__ABM1_HG_RESULT_16__SHIFT                                                        0x0
#define DC_ABM1_HG_RESULT_16__ABM1_HG_RESULT_16_MASK                                                          0xFFFFFFFFL
//DC_ABM1_HG_RESULT_17
#define DC_ABM1_HG_RESULT_17__ABM1_HG_RESULT_17__SHIFT                                                        0x0
#define DC_ABM1_HG_RESULT_17__ABM1_HG_RESULT_17_MASK                                                          0xFFFFFFFFL
//DC_ABM1_HG_RESULT_18
#define DC_ABM1_HG_RESULT_18__ABM1_HG_RESULT_18__SHIFT                                                        0x0
#define DC_ABM1_HG_RESULT_18__ABM1_HG_RESULT_18_MASK                                                          0xFFFFFFFFL
//DC_ABM1_HG_RESULT_19
#define DC_ABM1_HG_RESULT_19__ABM1_HG_RESULT_19__SHIFT                                                        0x0
#define DC_ABM1_HG_RESULT_19__ABM1_HG_RESULT_19_MASK                                                          0xFFFFFFFFL
//DC_ABM1_HG_RESULT_20
#define DC_ABM1_HG_RESULT_20__ABM1_HG_RESULT_20__SHIFT                                                        0x0
#define DC_ABM1_HG_RESULT_20__ABM1_HG_RESULT_20_MASK                                                          0xFFFFFFFFL
//DC_ABM1_HG_RESULT_21
#define DC_ABM1_HG_RESULT_21__ABM1_HG_RESULT_21__SHIFT                                                        0x0
#define DC_ABM1_HG_RESULT_21__ABM1_HG_RESULT_21_MASK                                                          0xFFFFFFFFL
//DC_ABM1_HG_RESULT_22
#define DC_ABM1_HG_RESULT_22__ABM1_HG_RESULT_22__SHIFT                                                        0x0
#define DC_ABM1_HG_RESULT_22__ABM1_HG_RESULT_22_MASK                                                          0xFFFFFFFFL
//DC_ABM1_HG_RESULT_23
#define DC_ABM1_HG_RESULT_23__ABM1_HG_RESULT_23__SHIFT                                                        0x0
#define DC_ABM1_HG_RESULT_23__ABM1_HG_RESULT_23_MASK                                                          0xFFFFFFFFL
//DC_ABM1_HG_RESULT_24
#define DC_ABM1_HG_RESULT_24__ABM1_HG_RESULT_24__SHIFT                                                        0x0
#define DC_ABM1_HG_RESULT_24__ABM1_HG_RESULT_24_MASK                                                          0xFFFFFFFFL
//DMCU_PERFMON_INTERRUPT_TO_UC_XIRQ_IRQ_SEL5
#define DMCU_PERFMON_INTERRUPT_TO_UC_XIRQ_IRQ_SEL5__DCFEV0_PERFMON_COUNTER0_INT_XIRQ_IRQ_SEL__SHIFT           0x0
#define DMCU_PERFMON_INTERRUPT_TO_UC_XIRQ_IRQ_SEL5__DCFEV0_PERFMON_COUNTER1_INT_XIRQ_IRQ_SEL__SHIFT           0x1
#define DMCU_PERFMON_INTERRUPT_TO_UC_XIRQ_IRQ_SEL5__DCFEV0_PERFMON_COUNTER2_INT_XIRQ_IRQ_SEL__SHIFT           0x2
#define DMCU_PERFMON_INTERRUPT_TO_UC_XIRQ_IRQ_SEL5__DCFEV0_PERFMON_COUNTER3_INT_XIRQ_IRQ_SEL__SHIFT           0x3
#define DMCU_PERFMON_INTERRUPT_TO_UC_XIRQ_IRQ_SEL5__DCFEV0_PERFMON_COUNTER4_INT_XIRQ_IRQ_SEL__SHIFT           0x4
#define DMCU_PERFMON_INTERRUPT_TO_UC_XIRQ_IRQ_SEL5__DCFEV0_PERFMON_COUNTER5_INT_XIRQ_IRQ_SEL__SHIFT           0x5
#define DMCU_PERFMON_INTERRUPT_TO_UC_XIRQ_IRQ_SEL5__DCFEV0_PERFMON_COUNTER6_INT_XIRQ_IRQ_SEL__SHIFT           0x6
#define DMCU_PERFMON_INTERRUPT_TO_UC_XIRQ_IRQ_SEL5__DCFEV0_PERFMON_COUNTER7_INT_XIRQ_IRQ_SEL__SHIFT           0x7
#define DMCU_PERFMON_INTERRUPT_TO_UC_XIRQ_IRQ_SEL5__DCFEV0_PERFMON_COUNTER_OFF_INT_XIRQ_IRQ_SEL__SHIFT        0x8
#define DMCU_PERFMON_INTERRUPT_TO_UC_XIRQ_IRQ_SEL5__DCFEV1_PERFMON_COUNTER0_INT_XIRQ_IRQ_SEL__SHIFT           0x9
#define DMCU_PERFMON_INTERRUPT_TO_UC_XIRQ_IRQ_SEL5__DCFEV1_PERFMON_COUNTER1_INT_XIRQ_IRQ_SEL__SHIFT           0xa
#define DMCU_PERFMON_INTERRUPT_TO_UC_XIRQ_IRQ_SEL5__DCFEV1_PERFMON_COUNTER2_INT_XIRQ_IRQ_SEL__SHIFT           0xb
#define DMCU_PERFMON_INTERRUPT_TO_UC_XIRQ_IRQ_SEL5__DCFEV1_PERFMON_COUNTER3_INT_XIRQ_IRQ_SEL__SHIFT           0xc
#define DMCU_PERFMON_INTERRUPT_TO_UC_XIRQ_IRQ_SEL5__DCFEV1_PERFMON_COUNTER4_INT_XIRQ_IRQ_SEL__SHIFT           0xd
#define DMCU_PERFMON_INTERRUPT_TO_UC_XIRQ_IRQ_SEL5__DCFEV1_PERFMON_COUNTER5_INT_XIRQ_IRQ_SEL__SHIFT           0xe
#define DMCU_PERFMON_INTERRUPT_TO_UC_XIRQ_IRQ_SEL5__DCFEV1_PERFMON_COUNTER6_INT_XIRQ_IRQ_SEL__SHIFT           0xf
#define DMCU_PERFMON_INTERRUPT_TO_UC_XIRQ_IRQ_SEL5__DCFEV1_PERFMON_COUNTER7_INT_XIRQ_IRQ_SEL__SHIFT           0x10
#define DMCU_PERFMON_INTERRUPT_TO_UC_XIRQ_IRQ_SEL5__DCFEV1_PERFMON_COUNTER_OFF_INT_XIRQ_IRQ_SEL__SHIFT        0x11
#define DMCU_PERFMON_INTERRUPT_TO_UC_XIRQ_IRQ_SEL5__DCFEV0_PERFMON_COUNTER0_INT_XIRQ_IRQ_SEL_MASK             0x00000001L
#define DMCU_PERFMON_INTERRUPT_TO_UC_XIRQ_IRQ_SEL5__DCFEV0_PERFMON_COUNTER1_INT_XIRQ_IRQ_SEL_MASK             0x00000002L
#define DMCU_PERFMON_INTERRUPT_TO_UC_XIRQ_IRQ_SEL5__DCFEV0_PERFMON_COUNTER2_INT_XIRQ_IRQ_SEL_MASK             0x00000004L
#define DMCU_PERFMON_INTERRUPT_TO_UC_XIRQ_IRQ_SEL5__DCFEV0_PERFMON_COUNTER3_INT_XIRQ_IRQ_SEL_MASK             0x00000008L
#define DMCU_PERFMON_INTERRUPT_TO_UC_XIRQ_IRQ_SEL5__DCFEV0_PERFMON_COUNTER4_INT_XIRQ_IRQ_SEL_MASK             0x00000010L
#define DMCU_PERFMON_INTERRUPT_TO_UC_XIRQ_IRQ_SEL5__DCFEV0_PERFMON_COUNTER5_INT_XIRQ_IRQ_SEL_MASK             0x00000020L
#define DMCU_PERFMON_INTERRUPT_TO_UC_XIRQ_IRQ_SEL5__DCFEV0_PERFMON_COUNTER6_INT_XIRQ_IRQ_SEL_MASK             0x00000040L
#define DMCU_PERFMON_INTERRUPT_TO_UC_XIRQ_IRQ_SEL5__DCFEV0_PERFMON_COUNTER7_INT_XIRQ_IRQ_SEL_MASK             0x00000080L
#define DMCU_PERFMON_INTERRUPT_TO_UC_XIRQ_IRQ_SEL5__DCFEV0_PERFMON_COUNTER_OFF_INT_XIRQ_IRQ_SEL_MASK          0x00000100L
#define DMCU_PERFMON_INTERRUPT_TO_UC_XIRQ_IRQ_SEL5__DCFEV1_PERFMON_COUNTER0_INT_XIRQ_IRQ_SEL_MASK             0x00000200L
#define DMCU_PERFMON_INTERRUPT_TO_UC_XIRQ_IRQ_SEL5__DCFEV1_PERFMON_COUNTER1_INT_XIRQ_IRQ_SEL_MASK             0x00000400L
#define DMCU_PERFMON_INTERRUPT_TO_UC_XIRQ_IRQ_SEL5__DCFEV1_PERFMON_COUNTER2_INT_XIRQ_IRQ_SEL_MASK             0x00000800L
#define DMCU_PERFMON_INTERRUPT_TO_UC_XIRQ_IRQ_SEL5__DCFEV1_PERFMON_COUNTER3_INT_XIRQ_IRQ_SEL_MASK             0x00001000L
#define DMCU_PERFMON_INTERRUPT_TO_UC_XIRQ_IRQ_SEL5__DCFEV1_PERFMON_COUNTER4_INT_XIRQ_IRQ_SEL_MASK             0x00002000L
#define DMCU_PERFMON_INTERRUPT_TO_UC_XIRQ_IRQ_SEL5__DCFEV1_PERFMON_COUNTER5_INT_XIRQ_IRQ_SEL_MASK             0x00004000L
#define DMCU_PERFMON_INTERRUPT_TO_UC_XIRQ_IRQ_SEL5__DCFEV1_PERFMON_COUNTER6_INT_XIRQ_IRQ_SEL_MASK             0x00008000L
#define DMCU_PERFMON_INTERRUPT_TO_UC_XIRQ_IRQ_SEL5__DCFEV1_PERFMON_COUNTER7_INT_XIRQ_IRQ_SEL_MASK             0x00010000L
#define DMCU_PERFMON_INTERRUPT_TO_UC_XIRQ_IRQ_SEL5__DCFEV1_PERFMON_COUNTER_OFF_INT_XIRQ_IRQ_SEL_MASK          0x00020000L
//DMCU_PERFMON_INTERRUPT_TO_UC_EN_MASK1
#define DMCU_PERFMON_INTERRUPT_TO_UC_EN_MASK1__DCI_PERFMON_COUNTER0_INT_TO_UC_EN__SHIFT                       0x0
#define DMCU_PERFMON_INTERRUPT_TO_UC_EN_MASK1__DCI_PERFMON_COUNTER1_INT_TO_UC_EN__SHIFT                       0x1
#define DMCU_PERFMON_INTERRUPT_TO_UC_EN_MASK1__DCI_PERFMON_COUNTER2_INT_TO_UC_EN__SHIFT                       0x2
#define DMCU_PERFMON_INTERRUPT_TO_UC_EN_MASK1__DCI_PERFMON_COUNTER3_INT_TO_UC_EN__SHIFT                       0x3
#define DMCU_PERFMON_INTERRUPT_TO_UC_EN_MASK1__DCI_PERFMON_COUNTER4_INT_TO_UC_EN__SHIFT                       0x4
#define DMCU_PERFMON_INTERRUPT_TO_UC_EN_MASK1__DCI_PERFMON_COUNTER5_INT_TO_UC_EN__SHIFT                       0x5
#define DMCU_PERFMON_INTERRUPT_TO_UC_EN_MASK1__DCI_PERFMON_COUNTER6_INT_TO_UC_EN__SHIFT                       0x6
#define DMCU_PERFMON_INTERRUPT_TO_UC_EN_MASK1__DCI_PERFMON_COUNTER7_INT_TO_UC_EN__SHIFT                       0x7
#define DMCU_PERFMON_INTERRUPT_TO_UC_EN_MASK1__DCO_PERFMON_COUNTER0_INT_TO_UC_EN__SHIFT                       0x8
#define DMCU_PERFMON_INTERRUPT_TO_UC_EN_MASK1__DCO_PERFMON_COUNTER1_INT_TO_UC_EN__SHIFT                       0x9
#define DMCU_PERFMON_INTERRUPT_TO_UC_EN_MASK1__DCO_PERFMON_COUNTER2_INT_TO_UC_EN__SHIFT                       0xa
#define DMCU_PERFMON_INTERRUPT_TO_UC_EN_MASK1__DCO_PERFMON_COUNTER3_INT_TO_UC_EN__SHIFT                       0xb
#define DMCU_PERFMON_INTERRUPT_TO_UC_EN_MASK1__DCO_PERFMON_COUNTER4_INT_TO_UC_EN__SHIFT                       0xc
#define DMCU_PERFMON_INTERRUPT_TO_UC_EN_MASK1__DCO_PERFMON_COUNTER5_INT_TO_UC_EN__SHIFT                       0xd
#define DMCU_PERFMON_INTERRUPT_TO_UC_EN_MASK1__DCO_PERFMON_COUNTER6_INT_TO_UC_EN__SHIFT                       0xe
#define DMCU_PERFMON_INTERRUPT_TO_UC_EN_MASK1__DCO_PERFMON_COUNTER7_INT_TO_UC_EN__SHIFT                       0xf
#define DMCU_PERFMON_INTERRUPT_TO_UC_EN_MASK1__DCCG_PERFMON_COUNTER0_INT_TO_UC_EN__SHIFT                      0x10
#define DMCU_PERFMON_INTERRUPT_TO_UC_EN_MASK1__DCCG_PERFMON_COUNTER1_INT_TO_UC_EN__SHIFT                      0x11
#define DMCU_PERFMON_INTERRUPT_TO_UC_EN_MASK1__DCCG_PERFMON_COUNTER2_INT_TO_UC_EN__SHIFT                      0x12
#define DMCU_PERFMON_INTERRUPT_TO_UC_EN_MASK1__DCCG_PERFMON_COUNTER3_INT_TO_UC_EN__SHIFT                      0x13
#define DMCU_PERFMON_INTERRUPT_TO_UC_EN_MASK1__DCCG_PERFMON_COUNTER4_INT_TO_UC_EN__SHIFT                      0x14
#define DMCU_PERFMON_INTERRUPT_TO_UC_EN_MASK1__DCCG_PERFMON_COUNTER5_INT_TO_UC_EN__SHIFT                      0x15
#define DMCU_PERFMON_INTERRUPT_TO_UC_EN_MASK1__DCCG_PERFMON_COUNTER6_INT_TO_UC_EN__SHIFT                      0x16
#define DMCU_PERFMON_INTERRUPT_TO_UC_EN_MASK1__DCCG_PERFMON_COUNTER7_INT_TO_UC_EN__SHIFT                      0x17
#define DMCU_PERFMON_INTERRUPT_TO_UC_EN_MASK1__DCI_PERFMON_COUNTER_OFF_INT_TO_UC_EN__SHIFT                    0x18
#define DMCU_PERFMON_INTERRUPT_TO_UC_EN_MASK1__DCO_PERFMON_COUNTER_OFF_INT_TO_UC_EN__SHIFT                    0x19
#define DMCU_PERFMON_INTERRUPT_TO_UC_EN_MASK1__DCCG_PERFMON_COUNTER_OFF_INT_TO_UC_EN__SHIFT                   0x1a
#define DMCU_PERFMON_INTERRUPT_TO_UC_EN_MASK1__DCI_PERFMON_COUNTER0_INT_TO_UC_EN_MASK                         0x00000001L
#define DMCU_PERFMON_INTERRUPT_TO_UC_EN_MASK1__DCI_PERFMON_COUNTER1_INT_TO_UC_EN_MASK                         0x00000002L
#define DMCU_PERFMON_INTERRUPT_TO_UC_EN_MASK1__DCI_PERFMON_COUNTER2_INT_TO_UC_EN_MASK                         0x00000004L
#define DMCU_PERFMON_INTERRUPT_TO_UC_EN_MASK1__DCI_PERFMON_COUNTER3_INT_TO_UC_EN_MASK                         0x00000008L
#define DMCU_PERFMON_INTERRUPT_TO_UC_EN_MASK1__DCI_PERFMON_COUNTER4_INT_TO_UC_EN_MASK                         0x00000010L
#define DMCU_PERFMON_INTERRUPT_TO_UC_EN_MASK1__DCI_PERFMON_COUNTER5_INT_TO_UC_EN_MASK                         0x00000020L
#define DMCU_PERFMON_INTERRUPT_TO_UC_EN_MASK1__DCI_PERFMON_COUNTER6_INT_TO_UC_EN_MASK                         0x00000040L
#define DMCU_PERFMON_INTERRUPT_TO_UC_EN_MASK1__DCI_PERFMON_COUNTER7_INT_TO_UC_EN_MASK                         0x00000080L
#define DMCU_PERFMON_INTERRUPT_TO_UC_EN_MASK1__DCO_PERFMON_COUNTER0_INT_TO_UC_EN_MASK                         0x00000100L
#define DMCU_PERFMON_INTERRUPT_TO_UC_EN_MASK1__DCO_PERFMON_COUNTER1_INT_TO_UC_EN_MASK                         0x00000200L
#define DMCU_PERFMON_INTERRUPT_TO_UC_EN_MASK1__DCO_PERFMON_COUNTER2_INT_TO_UC_EN_MASK                         0x00000400L
#define DMCU_PERFMON_INTERRUPT_TO_UC_EN_MASK1__DCO_PERFMON_COUNTER3_INT_TO_UC_EN_MASK                         0x00000800L
#define DMCU_PERFMON_INTERRUPT_TO_UC_EN_MASK1__DCO_PERFMON_COUNTER4_INT_TO_UC_EN_MASK                         0x00001000L
#define DMCU_PERFMON_INTERRUPT_TO_UC_EN_MASK1__DCO_PERFMON_COUNTER5_INT_TO_UC_EN_MASK                         0x00002000L
#define DMCU_PERFMON_INTERRUPT_TO_UC_EN_MASK1__DCO_PERFMON_COUNTER6_INT_TO_UC_EN_MASK                         0x00004000L
#define DMCU_PERFMON_INTERRUPT_TO_UC_EN_MASK1__DCO_PERFMON_COUNTER7_INT_TO_UC_EN_MASK                         0x00008000L
#define DMCU_PERFMON_INTERRUPT_TO_UC_EN_MASK1__DCCG_PERFMON_COUNTER0_INT_TO_UC_EN_MASK                        0x00010000L
#define DMCU_PERFMON_INTERRUPT_TO_UC_EN_MASK1__DCCG_PERFMON_COUNTER1_INT_TO_UC_EN_MASK                        0x00020000L
#define DMCU_PERFMON_INTERRUPT_TO_UC_EN_MASK1__DCCG_PERFMON_COUNTER2_INT_TO_UC_EN_MASK                        0x00040000L
#define DMCU_PERFMON_INTERRUPT_TO_UC_EN_MASK1__DCCG_PERFMON_COUNTER3_INT_TO_UC_EN_MASK                        0x00080000L
#define DMCU_PERFMON_INTERRUPT_TO_UC_EN_MASK1__DCCG_PERFMON_COUNTER4_INT_TO_UC_EN_MASK                        0x00100000L
#define DMCU_PERFMON_INTERRUPT_TO_UC_EN_MASK1__DCCG_PERFMON_COUNTER5_INT_TO_UC_EN_MASK                        0x00200000L
#define DMCU_PERFMON_INTERRUPT_TO_UC_EN_MASK1__DCCG_PERFMON_COUNTER6_INT_TO_UC_EN_MASK                        0x00400000L
#define DMCU_PERFMON_INTERRUPT_TO_UC_EN_MASK1__DCCG_PERFMON_COUNTER7_INT_TO_UC_EN_MASK                        0x00800000L
#define DMCU_PERFMON_INTERRUPT_TO_UC_EN_MASK1__DCI_PERFMON_COUNTER_OFF_INT_TO_UC_EN_MASK                      0x01000000L
#define DMCU_PERFMON_INTERRUPT_TO_UC_EN_MASK1__DCO_PERFMON_COUNTER_OFF_INT_TO_UC_EN_MASK                      0x02000000L
#define DMCU_PERFMON_INTERRUPT_TO_UC_EN_MASK1__DCCG_PERFMON_COUNTER_OFF_INT_TO_UC_EN_MASK                     0x04000000L
//DMCU_PERFMON_INTERRUPT_TO_UC_EN_MASK2
#define DMCU_PERFMON_INTERRUPT_TO_UC_EN_MASK2__DCFE0_PERFMON_COUNTER0_INT_TO_UC_EN__SHIFT                     0x0
#define DMCU_PERFMON_INTERRUPT_TO_UC_EN_MASK2__DCFE0_PERFMON_COUNTER1_INT_TO_UC_EN__SHIFT                     0x1
#define DMCU_PERFMON_INTERRUPT_TO_UC_EN_MASK2__DCFE0_PERFMON_COUNTER2_INT_TO_UC_EN__SHIFT                     0x2
#define DMCU_PERFMON_INTERRUPT_TO_UC_EN_MASK2__DCFE0_PERFMON_COUNTER3_INT_TO_UC_EN__SHIFT                     0x3
#define DMCU_PERFMON_INTERRUPT_TO_UC_EN_MASK2__DCFE0_PERFMON_COUNTER4_INT_TO_UC_EN__SHIFT                     0x4
#define DMCU_PERFMON_INTERRUPT_TO_UC_EN_MASK2__DCFE0_PERFMON_COUNTER5_INT_TO_UC_EN__SHIFT                     0x5
#define DMCU_PERFMON_INTERRUPT_TO_UC_EN_MASK2__DCFE0_PERFMON_COUNTER6_INT_TO_UC_EN__SHIFT                     0x6
#define DMCU_PERFMON_INTERRUPT_TO_UC_EN_MASK2__DCFE0_PERFMON_COUNTER7_INT_TO_UC_EN__SHIFT                     0x7
#define DMCU_PERFMON_INTERRUPT_TO_UC_EN_MASK2__DCFE1_PERFMON_COUNTER0_INT_TO_UC_EN__SHIFT                     0x8
#define DMCU_PERFMON_INTERRUPT_TO_UC_EN_MASK2__DCFE1_PERFMON_COUNTER1_INT_TO_UC_EN__SHIFT                     0x9
#define DMCU_PERFMON_INTERRUPT_TO_UC_EN_MASK2__DCFE1_PERFMON_COUNTER2_INT_TO_UC_EN__SHIFT                     0xa
#define DMCU_PERFMON_INTERRUPT_TO_UC_EN_MASK2__DCFE1_PERFMON_COUNTER3_INT_TO_UC_EN__SHIFT                     0xb
#define DMCU_PERFMON_INTERRUPT_TO_UC_EN_MASK2__DCFE1_PERFMON_COUNTER4_INT_TO_UC_EN__SHIFT                     0xc
#define DMCU_PERFMON_INTERRUPT_TO_UC_EN_MASK2__DCFE1_PERFMON_COUNTER5_INT_TO_UC_EN__SHIFT                     0xd
#define DMCU_PERFMON_INTERRUPT_TO_UC_EN_MASK2__DCFE1_PERFMON_COUNTER6_INT_TO_UC_EN__SHIFT                     0xe
#define DMCU_PERFMON_INTERRUPT_TO_UC_EN_MASK2__DCFE1_PERFMON_COUNTER7_INT_TO_UC_EN__SHIFT                     0xf
#define DMCU_PERFMON_INTERRUPT_TO_UC_EN_MASK2__DCFE2_PERFMON_COUNTER0_INT_TO_UC_EN__SHIFT                     0x10
#define DMCU_PERFMON_INTERRUPT_TO_UC_EN_MASK2__DCFE2_PERFMON_COUNTER1_INT_TO_UC_EN__SHIFT                     0x11
#define DMCU_PERFMON_INTERRUPT_TO_UC_EN_MASK2__DCFE2_PERFMON_COUNTER2_INT_TO_UC_EN__SHIFT                     0x12
#define DMCU_PERFMON_INTERRUPT_TO_UC_EN_MASK2__DCFE2_PERFMON_COUNTER3_INT_TO_UC_EN__SHIFT                     0x13
#define DMCU_PERFMON_INTERRUPT_TO_UC_EN_MASK2__DCFE2_PERFMON_COUNTER4_INT_TO_UC_EN__SHIFT                     0x14
#define DMCU_PERFMON_INTERRUPT_TO_UC_EN_MASK2__DCFE2_PERFMON_COUNTER5_INT_TO_UC_EN__SHIFT                     0x15
#define DMCU_PERFMON_INTERRUPT_TO_UC_EN_MASK2__DCFE2_PERFMON_COUNTER6_INT_TO_UC_EN__SHIFT                     0x16
#define DMCU_PERFMON_INTERRUPT_TO_UC_EN_MASK2__DCFE2_PERFMON_COUNTER7_INT_TO_UC_EN__SHIFT                     0x17
#define DMCU_PERFMON_INTERRUPT_TO_UC_EN_MASK2__DCFE0_PERFMON_COUNTER_OFF_INT_TO_UC_EN__SHIFT                  0x18
#define DMCU_PERFMON_INTERRUPT_TO_UC_EN_MASK2__DCFE1_PERFMON_COUNTER_OFF_INT_TO_UC_EN__SHIFT                  0x19
#define DMCU_PERFMON_INTERRUPT_TO_UC_EN_MASK2__DCFE2_PERFMON_COUNTER_OFF_INT_TO_UC_EN__SHIFT                  0x1a
#define DMCU_PERFMON_INTERRUPT_TO_UC_EN_MASK2__DCFE0_PERFMON_COUNTER0_INT_TO_UC_EN_MASK                       0x00000001L
#define DMCU_PERFMON_INTERRUPT_TO_UC_EN_MASK2__DCFE0_PERFMON_COUNTER1_INT_TO_UC_EN_MASK                       0x00000002L
#define DMCU_PERFMON_INTERRUPT_TO_UC_EN_MASK2__DCFE0_PERFMON_COUNTER2_INT_TO_UC_EN_MASK                       0x00000004L
#define DMCU_PERFMON_INTERRUPT_TO_UC_EN_MASK2__DCFE0_PERFMON_COUNTER3_INT_TO_UC_EN_MASK                       0x00000008L
#define DMCU_PERFMON_INTERRUPT_TO_UC_EN_MASK2__DCFE0_PERFMON_COUNTER4_INT_TO_UC_EN_MASK                       0x00000010L
#define DMCU_PERFMON_INTERRUPT_TO_UC_EN_MASK2__DCFE0_PERFMON_COUNTER5_INT_TO_UC_EN_MASK                       0x00000020L
#define DMCU_PERFMON_INTERRUPT_TO_UC_EN_MASK2__DCFE0_PERFMON_COUNTER6_INT_TO_UC_EN_MASK                       0x00000040L
#define DMCU_PERFMON_INTERRUPT_TO_UC_EN_MASK2__DCFE0_PERFMON_COUNTER7_INT_TO_UC_EN_MASK                       0x00000080L
#define DMCU_PERFMON_INTERRUPT_TO_UC_EN_MASK2__DCFE1_PERFMON_COUNTER0_INT_TO_UC_EN_MASK                       0x00000100L
#define DMCU_PERFMON_INTERRUPT_TO_UC_EN_MASK2__DCFE1_PERFMON_COUNTER1_INT_TO_UC_EN_MASK                       0x00000200L
#define DMCU_PERFMON_INTERRUPT_TO_UC_EN_MASK2__DCFE1_PERFMON_COUNTER2_INT_TO_UC_EN_MASK                       0x00000400L
#define DMCU_PERFMON_INTERRUPT_TO_UC_EN_MASK2__DCFE1_PERFMON_COUNTER3_INT_TO_UC_EN_MASK                       0x00000800L
#define DMCU_PERFMON_INTERRUPT_TO_UC_EN_MASK2__DCFE1_PERFMON_COUNTER4_INT_TO_UC_EN_MASK                       0x00001000L
#define DMCU_PERFMON_INTERRUPT_TO_UC_EN_MASK2__DCFE1_PERFMON_COUNTER5_INT_TO_UC_EN_MASK                       0x00002000L
#define DMCU_PERFMON_INTERRUPT_TO_UC_EN_MASK2__DCFE1_PERFMON_COUNTER6_INT_TO_UC_EN_MASK                       0x00004000L
#define DMCU_PERFMON_INTERRUPT_TO_UC_EN_MASK2__DCFE1_PERFMON_COUNTER7_INT_TO_UC_EN_MASK                       0x00008000L
#define DMCU_PERFMON_INTERRUPT_TO_UC_EN_MASK2__DCFE2_PERFMON_COUNTER0_INT_TO_UC_EN_MASK                       0x00010000L
#define DMCU_PERFMON_INTERRUPT_TO_UC_EN_MASK2__DCFE2_PERFMON_COUNTER1_INT_TO_UC_EN_MASK                       0x00020000L
#define DMCU_PERFMON_INTERRUPT_TO_UC_EN_MASK2__DCFE2_PERFMON_COUNTER2_INT_TO_UC_EN_MASK                       0x00040000L
#define DMCU_PERFMON_INTERRUPT_TO_UC_EN_MASK2__DCFE2_PERFMON_COUNTER3_INT_TO_UC_EN_MASK                       0x00080000L
#define DMCU_PERFMON_INTERRUPT_TO_UC_EN_MASK2__DCFE2_PERFMON_COUNTER4_INT_TO_UC_EN_MASK                       0x00100000L
#define DMCU_PERFMON_INTERRUPT_TO_UC_EN_MASK2__DCFE2_PERFMON_COUNTER5_INT_TO_UC_EN_MASK                       0x00200000L
#define DMCU_PERFMON_INTERRUPT_TO_UC_EN_MASK2__DCFE2_PERFMON_COUNTER6_INT_TO_UC_EN_MASK                       0x00400000L
#define DMCU_PERFMON_INTERRUPT_TO_UC_EN_MASK2__DCFE2_PERFMON_COUNTER7_INT_TO_UC_EN_MASK                       0x00800000L
#define DMCU_PERFMON_INTERRUPT_TO_UC_EN_MASK2__DCFE0_PERFMON_COUNTER_OFF_INT_TO_UC_EN_MASK                    0x01000000L
#define DMCU_PERFMON_INTERRUPT_TO_UC_EN_MASK2__DCFE1_PERFMON_COUNTER_OFF_INT_TO_UC_EN_MASK                    0x02000000L
#define DMCU_PERFMON_INTERRUPT_TO_UC_EN_MASK2__DCFE2_PERFMON_COUNTER_OFF_INT_TO_UC_EN_MASK                    0x04000000L
//DMCU_PERFMON_INTERRUPT_TO_UC_EN_MASK3
#define DMCU_PERFMON_INTERRUPT_TO_UC_EN_MASK3__DCFE3_PERFMON_COUNTER0_INT_TO_UC_EN__SHIFT                     0x0
#define DMCU_PERFMON_INTERRUPT_TO_UC_EN_MASK3__DCFE3_PERFMON_COUNTER1_INT_TO_UC_EN__SHIFT                     0x1
#define DMCU_PERFMON_INTERRUPT_TO_UC_EN_MASK3__DCFE3_PERFMON_COUNTER2_INT_TO_UC_EN__SHIFT                     0x2
#define DMCU_PERFMON_INTERRUPT_TO_UC_EN_MASK3__DCFE3_PERFMON_COUNTER3_INT_TO_UC_EN__SHIFT                     0x3
#define DMCU_PERFMON_INTERRUPT_TO_UC_EN_MASK3__DCFE3_PERFMON_COUNTER4_INT_TO_UC_EN__SHIFT                     0x4
#define DMCU_PERFMON_INTERRUPT_TO_UC_EN_MASK3__DCFE3_PERFMON_COUNTER5_INT_TO_UC_EN__SHIFT                     0x5
#define DMCU_PERFMON_INTERRUPT_TO_UC_EN_MASK3__DCFE3_PERFMON_COUNTER6_INT_TO_UC_EN__SHIFT                     0x6
#define DMCU_PERFMON_INTERRUPT_TO_UC_EN_MASK3__DCFE3_PERFMON_COUNTER7_INT_TO_UC_EN__SHIFT                     0x7
#define DMCU_PERFMON_INTERRUPT_TO_UC_EN_MASK3__DCFE4_PERFMON_COUNTER0_INT_TO_UC_EN__SHIFT                     0x8
#define DMCU_PERFMON_INTERRUPT_TO_UC_EN_MASK3__DCFE4_PERFMON_COUNTER1_INT_TO_UC_EN__SHIFT                     0x9
#define DMCU_PERFMON_INTERRUPT_TO_UC_EN_MASK3__DCFE4_PERFMON_COUNTER2_INT_TO_UC_EN__SHIFT                     0xa
#define DMCU_PERFMON_INTERRUPT_TO_UC_EN_MASK3__DCFE4_PERFMON_COUNTER3_INT_TO_UC_EN__SHIFT                     0xb
#define DMCU_PERFMON_INTERRUPT_TO_UC_EN_MASK3__DCFE4_PERFMON_COUNTER4_INT_TO_UC_EN__SHIFT                     0xc
#define DMCU_PERFMON_INTERRUPT_TO_UC_EN_MASK3__DCFE4_PERFMON_COUNTER5_INT_TO_UC_EN__SHIFT                     0xd
#define DMCU_PERFMON_INTERRUPT_TO_UC_EN_MASK3__DCFE4_PERFMON_COUNTER6_INT_TO_UC_EN__SHIFT                     0xe
#define DMCU_PERFMON_INTERRUPT_TO_UC_EN_MASK3__DCFE4_PERFMON_COUNTER7_INT_TO_UC_EN__SHIFT                     0xf
#define DMCU_PERFMON_INTERRUPT_TO_UC_EN_MASK3__DCFE5_PERFMON_COUNTER0_INT_TO_UC_EN__SHIFT                     0x10
#define DMCU_PERFMON_INTERRUPT_TO_UC_EN_MASK3__DCFE5_PERFMON_COUNTER1_INT_TO_UC_EN__SHIFT                     0x11
#define DMCU_PERFMON_INTERRUPT_TO_UC_EN_MASK3__DCFE5_PERFMON_COUNTER2_INT_TO_UC_EN__SHIFT                     0x12
#define DMCU_PERFMON_INTERRUPT_TO_UC_EN_MASK3__DCFE5_PERFMON_COUNTER3_INT_TO_UC_EN__SHIFT                     0x13
#define DMCU_PERFMON_INTERRUPT_TO_UC_EN_MASK3__DCFE5_PERFMON_COUNTER4_INT_TO_UC_EN__SHIFT                     0x14
#define DMCU_PERFMON_INTERRUPT_TO_UC_EN_MASK3__DCFE5_PERFMON_COUNTER5_INT_TO_UC_EN__SHIFT                     0x15
#define DMCU_PERFMON_INTERRUPT_TO_UC_EN_MASK3__DCFE5_PERFMON_COUNTER6_INT_TO_UC_EN__SHIFT                     0x16
#define DMCU_PERFMON_INTERRUPT_TO_UC_EN_MASK3__DCFE5_PERFMON_COUNTER7_INT_TO_UC_EN__SHIFT                     0x17
#define DMCU_PERFMON_INTERRUPT_TO_UC_EN_MASK3__DCFE3_PERFMON_COUNTER_OFF_INT_TO_UC_EN__SHIFT                  0x18
#define DMCU_PERFMON_INTERRUPT_TO_UC_EN_MASK3__DCFE4_PERFMON_COUNTER_OFF_INT_TO_UC_EN__SHIFT                  0x19
#define DMCU_PERFMON_INTERRUPT_TO_UC_EN_MASK3__DCFE5_PERFMON_COUNTER_OFF_INT_TO_UC_EN__SHIFT                  0x1a
#define DMCU_PERFMON_INTERRUPT_TO_UC_EN_MASK3__DCFE3_PERFMON_COUNTER0_INT_TO_UC_EN_MASK                       0x00000001L
#define DMCU_PERFMON_INTERRUPT_TO_UC_EN_MASK3__DCFE3_PERFMON_COUNTER1_INT_TO_UC_EN_MASK                       0x00000002L
#define DMCU_PERFMON_INTERRUPT_TO_UC_EN_MASK3__DCFE3_PERFMON_COUNTER2_INT_TO_UC_EN_MASK                       0x00000004L
#define DMCU_PERFMON_INTERRUPT_TO_UC_EN_MASK3__DCFE3_PERFMON_COUNTER3_INT_TO_UC_EN_MASK                       0x00000008L
#define DMCU_PERFMON_INTERRUPT_TO_UC_EN_MASK3__DCFE3_PERFMON_COUNTER4_INT_TO_UC_EN_MASK                       0x00000010L
#define DMCU_PERFMON_INTERRUPT_TO_UC_EN_MASK3__DCFE3_PERFMON_COUNTER5_INT_TO_UC_EN_MASK                       0x00000020L
#define DMCU_PERFMON_INTERRUPT_TO_UC_EN_MASK3__DCFE3_PERFMON_COUNTER6_INT_TO_UC_EN_MASK                       0x00000040L
#define DMCU_PERFMON_INTERRUPT_TO_UC_EN_MASK3__DCFE3_PERFMON_COUNTER7_INT_TO_UC_EN_MASK                       0x00000080L
#define DMCU_PERFMON_INTERRUPT_TO_UC_EN_MASK3__DCFE4_PERFMON_COUNTER0_INT_TO_UC_EN_MASK                       0x00000100L
#define DMCU_PERFMON_INTERRUPT_TO_UC_EN_MASK3__DCFE4_PERFMON_COUNTER1_INT_TO_UC_EN_MASK                       0x00000200L
#define DMCU_PERFMON_INTERRUPT_TO_UC_EN_MASK3__DCFE4_PERFMON_COUNTER2_INT_TO_UC_EN_MASK                       0x00000400L
#define DMCU_PERFMON_INTERRUPT_TO_UC_EN_MASK3__DCFE4_PERFMON_COUNTER3_INT_TO_UC_EN_MASK                       0x00000800L
#define DMCU_PERFMON_INTERRUPT_TO_UC_EN_MASK3__DCFE4_PERFMON_COUNTER4_INT_TO_UC_EN_MASK                       0x00001000L
#define DMCU_PERFMON_INTERRUPT_TO_UC_EN_MASK3__DCFE4_PERFMON_COUNTER5_INT_TO_UC_EN_MASK                       0x00002000L
#define DMCU_PERFMON_INTERRUPT_TO_UC_EN_MASK3__DCFE4_PERFMON_COUNTER6_INT_TO_UC_EN_MASK                       0x00004000L
#define DMCU_PERFMON_INTERRUPT_TO_UC_EN_MASK3__DCFE4_PERFMON_COUNTER7_INT_TO_UC_EN_MASK                       0x00008000L
#define DMCU_PERFMON_INTERRUPT_TO_UC_EN_MASK3__DCFE5_PERFMON_COUNTER0_INT_TO_UC_EN_MASK                       0x00010000L
#define DMCU_PERFMON_INTERRUPT_TO_UC_EN_MASK3__DCFE5_PERFMON_COUNTER1_INT_TO_UC_EN_MASK                       0x00020000L
#define DMCU_PERFMON_INTERRUPT_TO_UC_EN_MASK3__DCFE5_PERFMON_COUNTER2_INT_TO_UC_EN_MASK                       0x00040000L
#define DMCU_PERFMON_INTERRUPT_TO_UC_EN_MASK3__DCFE5_PERFMON_COUNTER3_INT_TO_UC_EN_MASK                       0x00080000L
#define DMCU_PERFMON_INTERRUPT_TO_UC_EN_MASK3__DCFE5_PERFMON_COUNTER4_INT_TO_UC_EN_MASK                       0x00100000L
#define DMCU_PERFMON_INTERRUPT_TO_UC_EN_MASK3__DCFE5_PERFMON_COUNTER5_INT_TO_UC_EN_MASK                       0x00200000L
#define DMCU_PERFMON_INTERRUPT_TO_UC_EN_MASK3__DCFE5_PERFMON_COUNTER6_INT_TO_UC_EN_MASK                       0x00400000L
#define DMCU_PERFMON_INTERRUPT_TO_UC_EN_MASK3__DCFE5_PERFMON_COUNTER7_INT_TO_UC_EN_MASK                       0x00800000L
#define DMCU_PERFMON_INTERRUPT_TO_UC_EN_MASK3__DCFE3_PERFMON_COUNTER_OFF_INT_TO_UC_EN_MASK                    0x01000000L
#define DMCU_PERFMON_INTERRUPT_TO_UC_EN_MASK3__DCFE4_PERFMON_COUNTER_OFF_INT_TO_UC_EN_MASK                    0x02000000L
#define DMCU_PERFMON_INTERRUPT_TO_UC_EN_MASK3__DCFE5_PERFMON_COUNTER_OFF_INT_TO_UC_EN_MASK                    0x04000000L
//DMCU_PERFMON_INTERRUPT_TO_UC_EN_MASK4
#define DMCU_PERFMON_INTERRUPT_TO_UC_EN_MASK4__WB_PERFMON_COUNTER0_INT_TO_UC_EN__SHIFT                        0x0
#define DMCU_PERFMON_INTERRUPT_TO_UC_EN_MASK4__WB_PERFMON_COUNTER1_INT_TO_UC_EN__SHIFT                        0x1
#define DMCU_PERFMON_INTERRUPT_TO_UC_EN_MASK4__WB_PERFMON_COUNTER2_INT_TO_UC_EN__SHIFT                        0x2
#define DMCU_PERFMON_INTERRUPT_TO_UC_EN_MASK4__WB_PERFMON_COUNTER3_INT_TO_UC_EN__SHIFT                        0x3
#define DMCU_PERFMON_INTERRUPT_TO_UC_EN_MASK4__WB_PERFMON_COUNTER4_INT_TO_UC_EN__SHIFT                        0x4
#define DMCU_PERFMON_INTERRUPT_TO_UC_EN_MASK4__WB_PERFMON_COUNTER5_INT_TO_UC_EN__SHIFT                        0x5
#define DMCU_PERFMON_INTERRUPT_TO_UC_EN_MASK4__WB_PERFMON_COUNTER6_INT_TO_UC_EN__SHIFT                        0x6
#define DMCU_PERFMON_INTERRUPT_TO_UC_EN_MASK4__WB_PERFMON_COUNTER7_INT_TO_UC_EN__SHIFT                        0x7
#define DMCU_PERFMON_INTERRUPT_TO_UC_EN_MASK4__DCRX_PERFMON_COUNTER0_INT_TO_UC_EN__SHIFT                      0x8
#define DMCU_PERFMON_INTERRUPT_TO_UC_EN_MASK4__DCRX_PERFMON_COUNTER1_INT_TO_UC_EN__SHIFT                      0x9
#define DMCU_PERFMON_INTERRUPT_TO_UC_EN_MASK4__DCRX_PERFMON_COUNTER2_INT_TO_UC_EN__SHIFT                      0xa
#define DMCU_PERFMON_INTERRUPT_TO_UC_EN_MASK4__DCRX_PERFMON_COUNTER3_INT_TO_UC_EN__SHIFT                      0xb
#define DMCU_PERFMON_INTERRUPT_TO_UC_EN_MASK4__DCRX_PERFMON_COUNTER4_INT_TO_UC_EN__SHIFT                      0xc
#define DMCU_PERFMON_INTERRUPT_TO_UC_EN_MASK4__DCRX_PERFMON_COUNTER5_INT_TO_UC_EN__SHIFT                      0xd
#define DMCU_PERFMON_INTERRUPT_TO_UC_EN_MASK4__DCRX_PERFMON_COUNTER6_INT_TO_UC_EN__SHIFT                      0xe
#define DMCU_PERFMON_INTERRUPT_TO_UC_EN_MASK4__DCRX_PERFMON_COUNTER7_INT_TO_UC_EN__SHIFT                      0xf
#define DMCU_PERFMON_INTERRUPT_TO_UC_EN_MASK4__DCCG_PERFMON2_COUNTER0_INT_TO_UC_EN__SHIFT                     0x10
#define DMCU_PERFMON_INTERRUPT_TO_UC_EN_MASK4__DCCG_PERFMON2_COUNTER1_INT_TO_UC_EN__SHIFT                     0x11
#define DMCU_PERFMON_INTERRUPT_TO_UC_EN_MASK4__DCCG_PERFMON2_COUNTER2_INT_TO_UC_EN__SHIFT                     0x12
#define DMCU_PERFMON_INTERRUPT_TO_UC_EN_MASK4__DCCG_PERFMON2_COUNTER3_INT_TO_UC_EN__SHIFT                     0x13
#define DMCU_PERFMON_INTERRUPT_TO_UC_EN_MASK4__DCCG_PERFMON2_COUNTER4_INT_TO_UC_EN__SHIFT                     0x14
#define DMCU_PERFMON_INTERRUPT_TO_UC_EN_MASK4__DCCG_PERFMON2_COUNTER5_INT_TO_UC_EN__SHIFT                     0x15
#define DMCU_PERFMON_INTERRUPT_TO_UC_EN_MASK4__DCCG_PERFMON2_COUNTER6_INT_TO_UC_EN__SHIFT                     0x16
#define DMCU_PERFMON_INTERRUPT_TO_UC_EN_MASK4__DCCG_PERFMON2_COUNTER7_INT_TO_UC_EN__SHIFT                     0x17
#define DMCU_PERFMON_INTERRUPT_TO_UC_EN_MASK4__WB_PERFMON_COUNTER_OFF_INT_TO_UC_EN__SHIFT                     0x18
#define DMCU_PERFMON_INTERRUPT_TO_UC_EN_MASK4__DCRX_PERFMON_COUNTER_OFF_INT_TO_UC_EN__SHIFT                   0x19
#define DMCU_PERFMON_INTERRUPT_TO_UC_EN_MASK4__DCCG_PERFMON2_COUNTER_OFF_INT_TO_UC_EN__SHIFT                  0x1a
#define DMCU_PERFMON_INTERRUPT_TO_UC_EN_MASK4__WB_PERFMON_COUNTER0_INT_TO_UC_EN_MASK                          0x00000001L
#define DMCU_PERFMON_INTERRUPT_TO_UC_EN_MASK4__WB_PERFMON_COUNTER1_INT_TO_UC_EN_MASK                          0x00000002L
#define DMCU_PERFMON_INTERRUPT_TO_UC_EN_MASK4__WB_PERFMON_COUNTER2_INT_TO_UC_EN_MASK                          0x00000004L
#define DMCU_PERFMON_INTERRUPT_TO_UC_EN_MASK4__WB_PERFMON_COUNTER3_INT_TO_UC_EN_MASK                          0x00000008L
#define DMCU_PERFMON_INTERRUPT_TO_UC_EN_MASK4__WB_PERFMON_COUNTER4_INT_TO_UC_EN_MASK                          0x00000010L
#define DMCU_PERFMON_INTERRUPT_TO_UC_EN_MASK4__WB_PERFMON_COUNTER5_INT_TO_UC_EN_MASK                          0x00000020L
#define DMCU_PERFMON_INTERRUPT_TO_UC_EN_MASK4__WB_PERFMON_COUNTER6_INT_TO_UC_EN_MASK                          0x00000040L
#define DMCU_PERFMON_INTERRUPT_TO_UC_EN_MASK4__WB_PERFMON_COUNTER7_INT_TO_UC_EN_MASK                          0x00000080L
#define DMCU_PERFMON_INTERRUPT_TO_UC_EN_MASK4__DCRX_PERFMON_COUNTER0_INT_TO_UC_EN_MASK                        0x00000100L
#define DMCU_PERFMON_INTERRUPT_TO_UC_EN_MASK4__DCRX_PERFMON_COUNTER1_INT_TO_UC_EN_MASK                        0x00000200L
#define DMCU_PERFMON_INTERRUPT_TO_UC_EN_MASK4__DCRX_PERFMON_COUNTER2_INT_TO_UC_EN_MASK                        0x00000400L
#define DMCU_PERFMON_INTERRUPT_TO_UC_EN_MASK4__DCRX_PERFMON_COUNTER3_INT_TO_UC_EN_MASK                        0x00000800L
#define DMCU_PERFMON_INTERRUPT_TO_UC_EN_MASK4__DCRX_PERFMON_COUNTER4_INT_TO_UC_EN_MASK                        0x00001000L
#define DMCU_PERFMON_INTERRUPT_TO_UC_EN_MASK4__DCRX_PERFMON_COUNTER5_INT_TO_UC_EN_MASK                        0x00002000L
#define DMCU_PERFMON_INTERRUPT_TO_UC_EN_MASK4__DCRX_PERFMON_COUNTER6_INT_TO_UC_EN_MASK                        0x00004000L
#define DMCU_PERFMON_INTERRUPT_TO_UC_EN_MASK4__DCRX_PERFMON_COUNTER7_INT_TO_UC_EN_MASK                        0x00008000L
#define DMCU_PERFMON_INTERRUPT_TO_UC_EN_MASK4__DCCG_PERFMON2_COUNTER0_INT_TO_UC_EN_MASK                       0x00010000L
#define DMCU_PERFMON_INTERRUPT_TO_UC_EN_MASK4__DCCG_PERFMON2_COUNTER1_INT_TO_UC_EN_MASK                       0x00020000L
#define DMCU_PERFMON_INTERRUPT_TO_UC_EN_MASK4__DCCG_PERFMON2_COUNTER2_INT_TO_UC_EN_MASK                       0x00040000L
#define DMCU_PERFMON_INTERRUPT_TO_UC_EN_MASK4__DCCG_PERFMON2_COUNTER3_INT_TO_UC_EN_MASK                       0x00080000L
#define DMCU_PERFMON_INTERRUPT_TO_UC_EN_MASK4__DCCG_PERFMON2_COUNTER4_INT_TO_UC_EN_MASK                       0x00100000L
#define DMCU_PERFMON_INTERRUPT_TO_UC_EN_MASK4__DCCG_PERFMON2_COUNTER5_INT_TO_UC_EN_MASK                       0x00200000L
#define DMCU_PERFMON_INTERRUPT_TO_UC_EN_MASK4__DCCG_PERFMON2_COUNTER6_INT_TO_UC_EN_MASK                       0x00400000L
#define DMCU_PERFMON_INTERRUPT_TO_UC_EN_MASK4__DCCG_PERFMON2_COUNTER7_INT_TO_UC_EN_MASK                       0x00800000L
#define DMCU_PERFMON_INTERRUPT_TO_UC_EN_MASK4__WB_PERFMON_COUNTER_OFF_INT_TO_UC_EN_MASK                       0x01000000L
#define DMCU_PERFMON_INTERRUPT_TO_UC_EN_MASK4__DCRX_PERFMON_COUNTER_OFF_INT_TO_UC_EN_MASK                     0x02000000L
#define DMCU_PERFMON_INTERRUPT_TO_UC_EN_MASK4__DCCG_PERFMON2_COUNTER_OFF_INT_TO_UC_EN_MASK                    0x04000000L
//DMCU_PERFMON_INTERRUPT_TO_UC_XIRQ_IRQ_SEL1
#define DMCU_PERFMON_INTERRUPT_TO_UC_XIRQ_IRQ_SEL1__DCI_PERFMON_COUNTER0_INT_XIRQ_IRQ_SEL__SHIFT              0x0
#define DMCU_PERFMON_INTERRUPT_TO_UC_XIRQ_IRQ_SEL1__DCI_PERFMON_COUNTER1_INT_XIRQ_IRQ_SEL__SHIFT              0x1
#define DMCU_PERFMON_INTERRUPT_TO_UC_XIRQ_IRQ_SEL1__DCI_PERFMON_COUNTER2_INT_XIRQ_IRQ_SEL__SHIFT              0x2
#define DMCU_PERFMON_INTERRUPT_TO_UC_XIRQ_IRQ_SEL1__DCI_PERFMON_COUNTER3_INT_XIRQ_IRQ_SEL__SHIFT              0x3
#define DMCU_PERFMON_INTERRUPT_TO_UC_XIRQ_IRQ_SEL1__DCI_PERFMON_COUNTER4_INT_XIRQ_IRQ_SEL__SHIFT              0x4
#define DMCU_PERFMON_INTERRUPT_TO_UC_XIRQ_IRQ_SEL1__DCI_PERFMON_COUNTER5_INT_XIRQ_IRQ_SEL__SHIFT              0x5
#define DMCU_PERFMON_INTERRUPT_TO_UC_XIRQ_IRQ_SEL1__DCI_PERFMON_COUNTER6_INT_XIRQ_IRQ_SEL__SHIFT              0x6
#define DMCU_PERFMON_INTERRUPT_TO_UC_XIRQ_IRQ_SEL1__DCI_PERFMON_COUNTER7_INT_XIRQ_IRQ_SEL__SHIFT              0x7
#define DMCU_PERFMON_INTERRUPT_TO_UC_XIRQ_IRQ_SEL1__DCO_PERFMON_COUNTER0_INT_XIRQ_IRQ_SEL__SHIFT              0x8
#define DMCU_PERFMON_INTERRUPT_TO_UC_XIRQ_IRQ_SEL1__DCO_PERFMON_COUNTER1_INT_XIRQ_IRQ_SEL__SHIFT              0x9
#define DMCU_PERFMON_INTERRUPT_TO_UC_XIRQ_IRQ_SEL1__DCO_PERFMON_COUNTER2_INT_XIRQ_IRQ_SEL__SHIFT              0xa
#define DMCU_PERFMON_INTERRUPT_TO_UC_XIRQ_IRQ_SEL1__DCO_PERFMON_COUNTER3_INT_XIRQ_IRQ_SEL__SHIFT              0xb
#define DMCU_PERFMON_INTERRUPT_TO_UC_XIRQ_IRQ_SEL1__DCO_PERFMON_COUNTER4_INT_XIRQ_IRQ_SEL__SHIFT              0xc
#define DMCU_PERFMON_INTERRUPT_TO_UC_XIRQ_IRQ_SEL1__DCO_PERFMON_COUNTER5_INT_XIRQ_IRQ_SEL__SHIFT              0xd
#define DMCU_PERFMON_INTERRUPT_TO_UC_XIRQ_IRQ_SEL1__DCO_PERFMON_COUNTER6_INT_XIRQ_IRQ_SEL__SHIFT              0xe
#define DMCU_PERFMON_INTERRUPT_TO_UC_XIRQ_IRQ_SEL1__DCO_PERFMON_COUNTER7_INT_XIRQ_IRQ_SEL__SHIFT              0xf
#define DMCU_PERFMON_INTERRUPT_TO_UC_XIRQ_IRQ_SEL1__DCCG_PERFMON_COUNTER0_INT_XIRQ_IRQ_SEL__SHIFT             0x10
#define DMCU_PERFMON_INTERRUPT_TO_UC_XIRQ_IRQ_SEL1__DCCG_PERFMON_COUNTER1_INT_XIRQ_IRQ_SEL__SHIFT             0x11
#define DMCU_PERFMON_INTERRUPT_TO_UC_XIRQ_IRQ_SEL1__DCCG_PERFMON_COUNTER2_INT_XIRQ_IRQ_SEL__SHIFT             0x12
#define DMCU_PERFMON_INTERRUPT_TO_UC_XIRQ_IRQ_SEL1__DCCG_PERFMON_COUNTER3_INT_XIRQ_IRQ_SEL__SHIFT             0x13
#define DMCU_PERFMON_INTERRUPT_TO_UC_XIRQ_IRQ_SEL1__DCCG_PERFMON_COUNTER4_INT_XIRQ_IRQ_SEL__SHIFT             0x14
#define DMCU_PERFMON_INTERRUPT_TO_UC_XIRQ_IRQ_SEL1__DCCG_PERFMON_COUNTER5_INT_XIRQ_IRQ_SEL__SHIFT             0x15
#define DMCU_PERFMON_INTERRUPT_TO_UC_XIRQ_IRQ_SEL1__DCCG_PERFMON_COUNTER6_INT_XIRQ_IRQ_SEL__SHIFT             0x16
#define DMCU_PERFMON_INTERRUPT_TO_UC_XIRQ_IRQ_SEL1__DCCG_PERFMON_COUNTER7_INT_XIRQ_IRQ_SEL__SHIFT             0x17
#define DMCU_PERFMON_INTERRUPT_TO_UC_XIRQ_IRQ_SEL1__DCI_PERFMON_COUNTER_OFF_INT_XIRQ_IRQ_SEL__SHIFT           0x18
#define DMCU_PERFMON_INTERRUPT_TO_UC_XIRQ_IRQ_SEL1__DCO_PERFMON_COUNTER_OFF_INT_XIRQ_IRQ_SEL__SHIFT           0x19
#define DMCU_PERFMON_INTERRUPT_TO_UC_XIRQ_IRQ_SEL1__DCCG_PERFMON_COUNTER_OFF_INT_XIRQ_IRQ_SEL__SHIFT          0x1a
#define DMCU_PERFMON_INTERRUPT_TO_UC_XIRQ_IRQ_SEL1__DCI_PERFMON_COUNTER0_INT_XIRQ_IRQ_SEL_MASK                0x00000001L
#define DMCU_PERFMON_INTERRUPT_TO_UC_XIRQ_IRQ_SEL1__DCI_PERFMON_COUNTER1_INT_XIRQ_IRQ_SEL_MASK                0x00000002L
#define DMCU_PERFMON_INTERRUPT_TO_UC_XIRQ_IRQ_SEL1__DCI_PERFMON_COUNTER2_INT_XIRQ_IRQ_SEL_MASK                0x00000004L
#define DMCU_PERFMON_INTERRUPT_TO_UC_XIRQ_IRQ_SEL1__DCI_PERFMON_COUNTER3_INT_XIRQ_IRQ_SEL_MASK                0x00000008L
#define DMCU_PERFMON_INTERRUPT_TO_UC_XIRQ_IRQ_SEL1__DCI_PERFMON_COUNTER4_INT_XIRQ_IRQ_SEL_MASK                0x00000010L
#define DMCU_PERFMON_INTERRUPT_TO_UC_XIRQ_IRQ_SEL1__DCI_PERFMON_COUNTER5_INT_XIRQ_IRQ_SEL_MASK                0x00000020L
#define DMCU_PERFMON_INTERRUPT_TO_UC_XIRQ_IRQ_SEL1__DCI_PERFMON_COUNTER6_INT_XIRQ_IRQ_SEL_MASK                0x00000040L
#define DMCU_PERFMON_INTERRUPT_TO_UC_XIRQ_IRQ_SEL1__DCI_PERFMON_COUNTER7_INT_XIRQ_IRQ_SEL_MASK                0x00000080L
#define DMCU_PERFMON_INTERRUPT_TO_UC_XIRQ_IRQ_SEL1__DCO_PERFMON_COUNTER0_INT_XIRQ_IRQ_SEL_MASK                0x00000100L
#define DMCU_PERFMON_INTERRUPT_TO_UC_XIRQ_IRQ_SEL1__DCO_PERFMON_COUNTER1_INT_XIRQ_IRQ_SEL_MASK                0x00000200L
#define DMCU_PERFMON_INTERRUPT_TO_UC_XIRQ_IRQ_SEL1__DCO_PERFMON_COUNTER2_INT_XIRQ_IRQ_SEL_MASK                0x00000400L
#define DMCU_PERFMON_INTERRUPT_TO_UC_XIRQ_IRQ_SEL1__DCO_PERFMON_COUNTER3_INT_XIRQ_IRQ_SEL_MASK                0x00000800L
#define DMCU_PERFMON_INTERRUPT_TO_UC_XIRQ_IRQ_SEL1__DCO_PERFMON_COUNTER4_INT_XIRQ_IRQ_SEL_MASK                0x00001000L
#define DMCU_PERFMON_INTERRUPT_TO_UC_XIRQ_IRQ_SEL1__DCO_PERFMON_COUNTER5_INT_XIRQ_IRQ_SEL_MASK                0x00002000L
#define DMCU_PERFMON_INTERRUPT_TO_UC_XIRQ_IRQ_SEL1__DCO_PERFMON_COUNTER6_INT_XIRQ_IRQ_SEL_MASK                0x00004000L
#define DMCU_PERFMON_INTERRUPT_TO_UC_XIRQ_IRQ_SEL1__DCO_PERFMON_COUNTER7_INT_XIRQ_IRQ_SEL_MASK                0x00008000L
#define DMCU_PERFMON_INTERRUPT_TO_UC_XIRQ_IRQ_SEL1__DCCG_PERFMON_COUNTER0_INT_XIRQ_IRQ_SEL_MASK               0x00010000L
#define DMCU_PERFMON_INTERRUPT_TO_UC_XIRQ_IRQ_SEL1__DCCG_PERFMON_COUNTER1_INT_XIRQ_IRQ_SEL_MASK               0x00020000L
#define DMCU_PERFMON_INTERRUPT_TO_UC_XIRQ_IRQ_SEL1__DCCG_PERFMON_COUNTER2_INT_XIRQ_IRQ_SEL_MASK               0x00040000L
#define DMCU_PERFMON_INTERRUPT_TO_UC_XIRQ_IRQ_SEL1__DCCG_PERFMON_COUNTER3_INT_XIRQ_IRQ_SEL_MASK               0x00080000L
#define DMCU_PERFMON_INTERRUPT_TO_UC_XIRQ_IRQ_SEL1__DCCG_PERFMON_COUNTER4_INT_XIRQ_IRQ_SEL_MASK               0x00100000L
#define DMCU_PERFMON_INTERRUPT_TO_UC_XIRQ_IRQ_SEL1__DCCG_PERFMON_COUNTER5_INT_XIRQ_IRQ_SEL_MASK               0x00200000L
#define DMCU_PERFMON_INTERRUPT_TO_UC_XIRQ_IRQ_SEL1__DCCG_PERFMON_COUNTER6_INT_XIRQ_IRQ_SEL_MASK               0x00400000L
#define DMCU_PERFMON_INTERRUPT_TO_UC_XIRQ_IRQ_SEL1__DCCG_PERFMON_COUNTER7_INT_XIRQ_IRQ_SEL_MASK               0x00800000L
#define DMCU_PERFMON_INTERRUPT_TO_UC_XIRQ_IRQ_SEL1__DCI_PERFMON_COUNTER_OFF_INT_XIRQ_IRQ_SEL_MASK             0x01000000L
#define DMCU_PERFMON_INTERRUPT_TO_UC_XIRQ_IRQ_SEL1__DCO_PERFMON_COUNTER_OFF_INT_XIRQ_IRQ_SEL_MASK             0x02000000L
#define DMCU_PERFMON_INTERRUPT_TO_UC_XIRQ_IRQ_SEL1__DCCG_PERFMON_COUNTER_OFF_INT_XIRQ_IRQ_SEL_MASK            0x04000000L
//DMCU_PERFMON_INTERRUPT_TO_UC_XIRQ_IRQ_SEL2
#define DMCU_PERFMON_INTERRUPT_TO_UC_XIRQ_IRQ_SEL2__DCFE0_PERFMON_COUNTER0_INT_XIRQ_IRQ_SEL__SHIFT            0x0
#define DMCU_PERFMON_INTERRUPT_TO_UC_XIRQ_IRQ_SEL2__DCFE0_PERFMON_COUNTER1_INT_XIRQ_IRQ_SEL__SHIFT            0x1
#define DMCU_PERFMON_INTERRUPT_TO_UC_XIRQ_IRQ_SEL2__DCFE0_PERFMON_COUNTER2_INT_XIRQ_IRQ_SEL__SHIFT            0x2
#define DMCU_PERFMON_INTERRUPT_TO_UC_XIRQ_IRQ_SEL2__DCFE0_PERFMON_COUNTER3_INT_XIRQ_IRQ_SEL__SHIFT            0x3
#define DMCU_PERFMON_INTERRUPT_TO_UC_XIRQ_IRQ_SEL2__DCFE0_PERFMON_COUNTER4_INT_XIRQ_IRQ_SEL__SHIFT            0x4
#define DMCU_PERFMON_INTERRUPT_TO_UC_XIRQ_IRQ_SEL2__DCFE0_PERFMON_COUNTER5_INT_XIRQ_IRQ_SEL__SHIFT            0x5
#define DMCU_PERFMON_INTERRUPT_TO_UC_XIRQ_IRQ_SEL2__DCFE0_PERFMON_COUNTER6_INT_XIRQ_IRQ_SEL__SHIFT            0x6
#define DMCU_PERFMON_INTERRUPT_TO_UC_XIRQ_IRQ_SEL2__DCFE0_PERFMON_COUNTER7_INT_XIRQ_IRQ_SEL__SHIFT            0x7
#define DMCU_PERFMON_INTERRUPT_TO_UC_XIRQ_IRQ_SEL2__DCFE1_PERFMON_COUNTER0_INT_XIRQ_IRQ_SEL__SHIFT            0x8
#define DMCU_PERFMON_INTERRUPT_TO_UC_XIRQ_IRQ_SEL2__DCFE1_PERFMON_COUNTER1_INT_XIRQ_IRQ_SEL__SHIFT            0x9
#define DMCU_PERFMON_INTERRUPT_TO_UC_XIRQ_IRQ_SEL2__DCFE1_PERFMON_COUNTER2_INT_XIRQ_IRQ_SEL__SHIFT            0xa
#define DMCU_PERFMON_INTERRUPT_TO_UC_XIRQ_IRQ_SEL2__DCFE1_PERFMON_COUNTER3_INT_XIRQ_IRQ_SEL__SHIFT            0xb
#define DMCU_PERFMON_INTERRUPT_TO_UC_XIRQ_IRQ_SEL2__DCFE1_PERFMON_COUNTER4_INT_XIRQ_IRQ_SEL__SHIFT            0xc
#define DMCU_PERFMON_INTERRUPT_TO_UC_XIRQ_IRQ_SEL2__DCFE1_PERFMON_COUNTER5_INT_XIRQ_IRQ_SEL__SHIFT            0xd
#define DMCU_PERFMON_INTERRUPT_TO_UC_XIRQ_IRQ_SEL2__DCFE1_PERFMON_COUNTER6_INT_XIRQ_IRQ_SEL__SHIFT            0xe
#define DMCU_PERFMON_INTERRUPT_TO_UC_XIRQ_IRQ_SEL2__DCFE1_PERFMON_COUNTER7_INT_XIRQ_IRQ_SEL__SHIFT            0xf
#define DMCU_PERFMON_INTERRUPT_TO_UC_XIRQ_IRQ_SEL2__DCFE2_PERFMON_COUNTER0_INT_XIRQ_IRQ_SEL__SHIFT            0x10
#define DMCU_PERFMON_INTERRUPT_TO_UC_XIRQ_IRQ_SEL2__DCFE2_PERFMON_COUNTER1_INT_XIRQ_IRQ_SEL__SHIFT            0x11
#define DMCU_PERFMON_INTERRUPT_TO_UC_XIRQ_IRQ_SEL2__DCFE2_PERFMON_COUNTER2_INT_XIRQ_IRQ_SEL__SHIFT            0x12
#define DMCU_PERFMON_INTERRUPT_TO_UC_XIRQ_IRQ_SEL2__DCFE2_PERFMON_COUNTER3_INT_XIRQ_IRQ_SEL__SHIFT            0x13
#define DMCU_PERFMON_INTERRUPT_TO_UC_XIRQ_IRQ_SEL2__DCFE2_PERFMON_COUNTER4_INT_XIRQ_IRQ_SEL__SHIFT            0x14
#define DMCU_PERFMON_INTERRUPT_TO_UC_XIRQ_IRQ_SEL2__DCFE2_PERFMON_COUNTER5_INT_XIRQ_IRQ_SEL__SHIFT            0x15
#define DMCU_PERFMON_INTERRUPT_TO_UC_XIRQ_IRQ_SEL2__DCFE2_PERFMON_COUNTER6_INT_XIRQ_IRQ_SEL__SHIFT            0x16
#define DMCU_PERFMON_INTERRUPT_TO_UC_XIRQ_IRQ_SEL2__DCFE2_PERFMON_COUNTER7_INT_XIRQ_IRQ_SEL__SHIFT            0x17
#define DMCU_PERFMON_INTERRUPT_TO_UC_XIRQ_IRQ_SEL2__DCFE0_PERFMON_COUNTER_OFF_INT_XIRQ_IRQ_SEL__SHIFT         0x18
#define DMCU_PERFMON_INTERRUPT_TO_UC_XIRQ_IRQ_SEL2__DCFE1_PERFMON_COUNTER_OFF_INT_XIRQ_IRQ_SEL__SHIFT         0x19
#define DMCU_PERFMON_INTERRUPT_TO_UC_XIRQ_IRQ_SEL2__DCFE2_PERFMON_COUNTER_OFF_INT_XIRQ_IRQ_SEL__SHIFT         0x1a
#define DMCU_PERFMON_INTERRUPT_TO_UC_XIRQ_IRQ_SEL2__DCFE0_PERFMON_COUNTER0_INT_XIRQ_IRQ_SEL_MASK              0x00000001L
#define DMCU_PERFMON_INTERRUPT_TO_UC_XIRQ_IRQ_SEL2__DCFE0_PERFMON_COUNTER1_INT_XIRQ_IRQ_SEL_MASK              0x00000002L
#define DMCU_PERFMON_INTERRUPT_TO_UC_XIRQ_IRQ_SEL2__DCFE0_PERFMON_COUNTER2_INT_XIRQ_IRQ_SEL_MASK              0x00000004L
#define DMCU_PERFMON_INTERRUPT_TO_UC_XIRQ_IRQ_SEL2__DCFE0_PERFMON_COUNTER3_INT_XIRQ_IRQ_SEL_MASK              0x00000008L
#define DMCU_PERFMON_INTERRUPT_TO_UC_XIRQ_IRQ_SEL2__DCFE0_PERFMON_COUNTER4_INT_XIRQ_IRQ_SEL_MASK              0x00000010L
#define DMCU_PERFMON_INTERRUPT_TO_UC_XIRQ_IRQ_SEL2__DCFE0_PERFMON_COUNTER5_INT_XIRQ_IRQ_SEL_MASK              0x00000020L
#define DMCU_PERFMON_INTERRUPT_TO_UC_XIRQ_IRQ_SEL2__DCFE0_PERFMON_COUNTER6_INT_XIRQ_IRQ_SEL_MASK              0x00000040L
#define DMCU_PERFMON_INTERRUPT_TO_UC_XIRQ_IRQ_SEL2__DCFE0_PERFMON_COUNTER7_INT_XIRQ_IRQ_SEL_MASK              0x00000080L
#define DMCU_PERFMON_INTERRUPT_TO_UC_XIRQ_IRQ_SEL2__DCFE1_PERFMON_COUNTER0_INT_XIRQ_IRQ_SEL_MASK              0x00000100L
#define DMCU_PERFMON_INTERRUPT_TO_UC_XIRQ_IRQ_SEL2__DCFE1_PERFMON_COUNTER1_INT_XIRQ_IRQ_SEL_MASK              0x00000200L
#define DMCU_PERFMON_INTERRUPT_TO_UC_XIRQ_IRQ_SEL2__DCFE1_PERFMON_COUNTER2_INT_XIRQ_IRQ_SEL_MASK              0x00000400L
#define DMCU_PERFMON_INTERRUPT_TO_UC_XIRQ_IRQ_SEL2__DCFE1_PERFMON_COUNTER3_INT_XIRQ_IRQ_SEL_MASK              0x00000800L
#define DMCU_PERFMON_INTERRUPT_TO_UC_XIRQ_IRQ_SEL2__DCFE1_PERFMON_COUNTER4_INT_XIRQ_IRQ_SEL_MASK              0x00001000L
#define DMCU_PERFMON_INTERRUPT_TO_UC_XIRQ_IRQ_SEL2__DCFE1_PERFMON_COUNTER5_INT_XIRQ_IRQ_SEL_MASK              0x00002000L
#define DMCU_PERFMON_INTERRUPT_TO_UC_XIRQ_IRQ_SEL2__DCFE1_PERFMON_COUNTER6_INT_XIRQ_IRQ_SEL_MASK              0x00004000L
#define DMCU_PERFMON_INTERRUPT_TO_UC_XIRQ_IRQ_SEL2__DCFE1_PERFMON_COUNTER7_INT_XIRQ_IRQ_SEL_MASK              0x00008000L
#define DMCU_PERFMON_INTERRUPT_TO_UC_XIRQ_IRQ_SEL2__DCFE2_PERFMON_COUNTER0_INT_XIRQ_IRQ_SEL_MASK              0x00010000L
#define DMCU_PERFMON_INTERRUPT_TO_UC_XIRQ_IRQ_SEL2__DCFE2_PERFMON_COUNTER1_INT_XIRQ_IRQ_SEL_MASK              0x00020000L
#define DMCU_PERFMON_INTERRUPT_TO_UC_XIRQ_IRQ_SEL2__DCFE2_PERFMON_COUNTER2_INT_XIRQ_IRQ_SEL_MASK              0x00040000L
#define DMCU_PERFMON_INTERRUPT_TO_UC_XIRQ_IRQ_SEL2__DCFE2_PERFMON_COUNTER3_INT_XIRQ_IRQ_SEL_MASK              0x00080000L
#define DMCU_PERFMON_INTERRUPT_TO_UC_XIRQ_IRQ_SEL2__DCFE2_PERFMON_COUNTER4_INT_XIRQ_IRQ_SEL_MASK              0x00100000L
#define DMCU_PERFMON_INTERRUPT_TO_UC_XIRQ_IRQ_SEL2__DCFE2_PERFMON_COUNTER5_INT_XIRQ_IRQ_SEL_MASK              0x00200000L
#define DMCU_PERFMON_INTERRUPT_TO_UC_XIRQ_IRQ_SEL2__DCFE2_PERFMON_COUNTER6_INT_XIRQ_IRQ_SEL_MASK              0x00400000L
#define DMCU_PERFMON_INTERRUPT_TO_UC_XIRQ_IRQ_SEL2__DCFE2_PERFMON_COUNTER7_INT_XIRQ_IRQ_SEL_MASK              0x00800000L
#define DMCU_PERFMON_INTERRUPT_TO_UC_XIRQ_IRQ_SEL2__DCFE0_PERFMON_COUNTER_OFF_INT_XIRQ_IRQ_SEL_MASK           0x01000000L
#define DMCU_PERFMON_INTERRUPT_TO_UC_XIRQ_IRQ_SEL2__DCFE1_PERFMON_COUNTER_OFF_INT_XIRQ_IRQ_SEL_MASK           0x02000000L
#define DMCU_PERFMON_INTERRUPT_TO_UC_XIRQ_IRQ_SEL2__DCFE2_PERFMON_COUNTER_OFF_INT_XIRQ_IRQ_SEL_MASK           0x04000000L
//DMCU_PERFMON_INTERRUPT_TO_UC_XIRQ_IRQ_SEL3
#define DMCU_PERFMON_INTERRUPT_TO_UC_XIRQ_IRQ_SEL3__DCFE3_PERFMON_COUNTER0_INT_XIRQ_IRQ_SEL__SHIFT            0x0
#define DMCU_PERFMON_INTERRUPT_TO_UC_XIRQ_IRQ_SEL3__DCFE3_PERFMON_COUNTER1_INT_XIRQ_IRQ_SEL__SHIFT            0x1
#define DMCU_PERFMON_INTERRUPT_TO_UC_XIRQ_IRQ_SEL3__DCFE3_PERFMON_COUNTER2_INT_XIRQ_IRQ_SEL__SHIFT            0x2
#define DMCU_PERFMON_INTERRUPT_TO_UC_XIRQ_IRQ_SEL3__DCFE3_PERFMON_COUNTER3_INT_XIRQ_IRQ_SEL__SHIFT            0x3
#define DMCU_PERFMON_INTERRUPT_TO_UC_XIRQ_IRQ_SEL3__DCFE3_PERFMON_COUNTER4_INT_XIRQ_IRQ_SEL__SHIFT            0x4
#define DMCU_PERFMON_INTERRUPT_TO_UC_XIRQ_IRQ_SEL3__DCFE3_PERFMON_COUNTER5_INT_XIRQ_IRQ_SEL__SHIFT            0x5
#define DMCU_PERFMON_INTERRUPT_TO_UC_XIRQ_IRQ_SEL3__DCFE3_PERFMON_COUNTER6_INT_XIRQ_IRQ_SEL__SHIFT            0x6
#define DMCU_PERFMON_INTERRUPT_TO_UC_XIRQ_IRQ_SEL3__DCFE3_PERFMON_COUNTER7_INT_XIRQ_IRQ_SEL__SHIFT            0x7
#define DMCU_PERFMON_INTERRUPT_TO_UC_XIRQ_IRQ_SEL3__DCFE4_PERFMON_COUNTER0_INT_XIRQ_IRQ_SEL__SHIFT            0x8
#define DMCU_PERFMON_INTERRUPT_TO_UC_XIRQ_IRQ_SEL3__DCFE4_PERFMON_COUNTER1_INT_XIRQ_IRQ_SEL__SHIFT            0x9
#define DMCU_PERFMON_INTERRUPT_TO_UC_XIRQ_IRQ_SEL3__DCFE4_PERFMON_COUNTER2_INT_XIRQ_IRQ_SEL__SHIFT            0xa
#define DMCU_PERFMON_INTERRUPT_TO_UC_XIRQ_IRQ_SEL3__DCFE4_PERFMON_COUNTER3_INT_XIRQ_IRQ_SEL__SHIFT            0xb
#define DMCU_PERFMON_INTERRUPT_TO_UC_XIRQ_IRQ_SEL3__DCFE4_PERFMON_COUNTER4_INT_XIRQ_IRQ_SEL__SHIFT            0xc
#define DMCU_PERFMON_INTERRUPT_TO_UC_XIRQ_IRQ_SEL3__DCFE4_PERFMON_COUNTER5_INT_XIRQ_IRQ_SEL__SHIFT            0xd
#define DMCU_PERFMON_INTERRUPT_TO_UC_XIRQ_IRQ_SEL3__DCFE4_PERFMON_COUNTER6_INT_XIRQ_IRQ_SEL__SHIFT            0xe
#define DMCU_PERFMON_INTERRUPT_TO_UC_XIRQ_IRQ_SEL3__DCFE4_PERFMON_COUNTER7_INT_XIRQ_IRQ_SEL__SHIFT            0xf
#define DMCU_PERFMON_INTERRUPT_TO_UC_XIRQ_IRQ_SEL3__DCFE5_PERFMON_COUNTER0_INT_XIRQ_IRQ_SEL__SHIFT            0x10
#define DMCU_PERFMON_INTERRUPT_TO_UC_XIRQ_IRQ_SEL3__DCFE5_PERFMON_COUNTER1_INT_XIRQ_IRQ_SEL__SHIFT            0x11
#define DMCU_PERFMON_INTERRUPT_TO_UC_XIRQ_IRQ_SEL3__DCFE5_PERFMON_COUNTER2_INT_XIRQ_IRQ_SEL__SHIFT            0x12
#define DMCU_PERFMON_INTERRUPT_TO_UC_XIRQ_IRQ_SEL3__DCFE5_PERFMON_COUNTER3_INT_XIRQ_IRQ_SEL__SHIFT            0x13
#define DMCU_PERFMON_INTERRUPT_TO_UC_XIRQ_IRQ_SEL3__DCFE5_PERFMON_COUNTER4_INT_XIRQ_IRQ_SEL__SHIFT            0x14
#define DMCU_PERFMON_INTERRUPT_TO_UC_XIRQ_IRQ_SEL3__DCFE5_PERFMON_COUNTER5_INT_XIRQ_IRQ_SEL__SHIFT            0x15
#define DMCU_PERFMON_INTERRUPT_TO_UC_XIRQ_IRQ_SEL3__DCFE5_PERFMON_COUNTER6_INT_XIRQ_IRQ_SEL__SHIFT            0x16
#define DMCU_PERFMON_INTERRUPT_TO_UC_XIRQ_IRQ_SEL3__DCFE5_PERFMON_COUNTER7_INT_XIRQ_IRQ_SEL__SHIFT            0x17
#define DMCU_PERFMON_INTERRUPT_TO_UC_XIRQ_IRQ_SEL3__DCFE3_PERFMON_COUNTER_OFF_INT_XIRQ_IRQ_SEL__SHIFT         0x18
#define DMCU_PERFMON_INTERRUPT_TO_UC_XIRQ_IRQ_SEL3__DCFE4_PERFMON_COUNTER_OFF_INT_XIRQ_IRQ_SEL__SHIFT         0x19
#define DMCU_PERFMON_INTERRUPT_TO_UC_XIRQ_IRQ_SEL3__DCFE5_PERFMON_COUNTER_OFF_INT_XIRQ_IRQ_SEL__SHIFT         0x1a
#define DMCU_PERFMON_INTERRUPT_TO_UC_XIRQ_IRQ_SEL3__DCFE3_PERFMON_COUNTER0_INT_XIRQ_IRQ_SEL_MASK              0x00000001L
#define DMCU_PERFMON_INTERRUPT_TO_UC_XIRQ_IRQ_SEL3__DCFE3_PERFMON_COUNTER1_INT_XIRQ_IRQ_SEL_MASK              0x00000002L
#define DMCU_PERFMON_INTERRUPT_TO_UC_XIRQ_IRQ_SEL3__DCFE3_PERFMON_COUNTER2_INT_XIRQ_IRQ_SEL_MASK              0x00000004L
#define DMCU_PERFMON_INTERRUPT_TO_UC_XIRQ_IRQ_SEL3__DCFE3_PERFMON_COUNTER3_INT_XIRQ_IRQ_SEL_MASK              0x00000008L
#define DMCU_PERFMON_INTERRUPT_TO_UC_XIRQ_IRQ_SEL3__DCFE3_PERFMON_COUNTER4_INT_XIRQ_IRQ_SEL_MASK              0x00000010L
#define DMCU_PERFMON_INTERRUPT_TO_UC_XIRQ_IRQ_SEL3__DCFE3_PERFMON_COUNTER5_INT_XIRQ_IRQ_SEL_MASK              0x00000020L
#define DMCU_PERFMON_INTERRUPT_TO_UC_XIRQ_IRQ_SEL3__DCFE3_PERFMON_COUNTER6_INT_XIRQ_IRQ_SEL_MASK              0x00000040L
#define DMCU_PERFMON_INTERRUPT_TO_UC_XIRQ_IRQ_SEL3__DCFE3_PERFMON_COUNTER7_INT_XIRQ_IRQ_SEL_MASK              0x00000080L
#define DMCU_PERFMON_INTERRUPT_TO_UC_XIRQ_IRQ_SEL3__DCFE4_PERFMON_COUNTER0_INT_XIRQ_IRQ_SEL_MASK              0x00000100L
#define DMCU_PERFMON_INTERRUPT_TO_UC_XIRQ_IRQ_SEL3__DCFE4_PERFMON_COUNTER1_INT_XIRQ_IRQ_SEL_MASK              0x00000200L
#define DMCU_PERFMON_INTERRUPT_TO_UC_XIRQ_IRQ_SEL3__DCFE4_PERFMON_COUNTER2_INT_XIRQ_IRQ_SEL_MASK              0x00000400L
#define DMCU_PERFMON_INTERRUPT_TO_UC_XIRQ_IRQ_SEL3__DCFE4_PERFMON_COUNTER3_INT_XIRQ_IRQ_SEL_MASK              0x00000800L
#define DMCU_PERFMON_INTERRUPT_TO_UC_XIRQ_IRQ_SEL3__DCFE4_PERFMON_COUNTER4_INT_XIRQ_IRQ_SEL_MASK              0x00001000L
#define DMCU_PERFMON_INTERRUPT_TO_UC_XIRQ_IRQ_SEL3__DCFE4_PERFMON_COUNTER5_INT_XIRQ_IRQ_SEL_MASK              0x00002000L
#define DMCU_PERFMON_INTERRUPT_TO_UC_XIRQ_IRQ_SEL3__DCFE4_PERFMON_COUNTER6_INT_XIRQ_IRQ_SEL_MASK              0x00004000L
#define DMCU_PERFMON_INTERRUPT_TO_UC_XIRQ_IRQ_SEL3__DCFE4_PERFMON_COUNTER7_INT_XIRQ_IRQ_SEL_MASK              0x00008000L
#define DMCU_PERFMON_INTERRUPT_TO_UC_XIRQ_IRQ_SEL3__DCFE5_PERFMON_COUNTER0_INT_XIRQ_IRQ_SEL_MASK              0x00010000L
#define DMCU_PERFMON_INTERRUPT_TO_UC_XIRQ_IRQ_SEL3__DCFE5_PERFMON_COUNTER1_INT_XIRQ_IRQ_SEL_MASK              0x00020000L
#define DMCU_PERFMON_INTERRUPT_TO_UC_XIRQ_IRQ_SEL3__DCFE5_PERFMON_COUNTER2_INT_XIRQ_IRQ_SEL_MASK              0x00040000L
#define DMCU_PERFMON_INTERRUPT_TO_UC_XIRQ_IRQ_SEL3__DCFE5_PERFMON_COUNTER3_INT_XIRQ_IRQ_SEL_MASK              0x00080000L
#define DMCU_PERFMON_INTERRUPT_TO_UC_XIRQ_IRQ_SEL3__DCFE5_PERFMON_COUNTER4_INT_XIRQ_IRQ_SEL_MASK              0x00100000L
#define DMCU_PERFMON_INTERRUPT_TO_UC_XIRQ_IRQ_SEL3__DCFE5_PERFMON_COUNTER5_INT_XIRQ_IRQ_SEL_MASK              0x00200000L
#define DMCU_PERFMON_INTERRUPT_TO_UC_XIRQ_IRQ_SEL3__DCFE5_PERFMON_COUNTER6_INT_XIRQ_IRQ_SEL_MASK              0x00400000L
#define DMCU_PERFMON_INTERRUPT_TO_UC_XIRQ_IRQ_SEL3__DCFE5_PERFMON_COUNTER7_INT_XIRQ_IRQ_SEL_MASK              0x00800000L
#define DMCU_PERFMON_INTERRUPT_TO_UC_XIRQ_IRQ_SEL3__DCFE3_PERFMON_COUNTER_OFF_INT_XIRQ_IRQ_SEL_MASK           0x01000000L
#define DMCU_PERFMON_INTERRUPT_TO_UC_XIRQ_IRQ_SEL3__DCFE4_PERFMON_COUNTER_OFF_INT_XIRQ_IRQ_SEL_MASK           0x02000000L
#define DMCU_PERFMON_INTERRUPT_TO_UC_XIRQ_IRQ_SEL3__DCFE5_PERFMON_COUNTER_OFF_INT_XIRQ_IRQ_SEL_MASK           0x04000000L
//DMCU_PERFMON_INTERRUPT_TO_UC_XIRQ_IRQ_SEL4
#define DMCU_PERFMON_INTERRUPT_TO_UC_XIRQ_IRQ_SEL4__WB_PERFMON_COUNTER0_INT_XIRQ_IRQ_SEL__SHIFT               0x0
#define DMCU_PERFMON_INTERRUPT_TO_UC_XIRQ_IRQ_SEL4__WB_PERFMON_COUNTER1_INT_XIRQ_IRQ_SEL__SHIFT               0x1
#define DMCU_PERFMON_INTERRUPT_TO_UC_XIRQ_IRQ_SEL4__WB_PERFMON_COUNTER2_INT_XIRQ_IRQ_SEL__SHIFT               0x2
#define DMCU_PERFMON_INTERRUPT_TO_UC_XIRQ_IRQ_SEL4__WB_PERFMON_COUNTER3_INT_XIRQ_IRQ_SEL__SHIFT               0x3
#define DMCU_PERFMON_INTERRUPT_TO_UC_XIRQ_IRQ_SEL4__WB_PERFMON_COUNTER4_INT_XIRQ_IRQ_SEL__SHIFT               0x4
#define DMCU_PERFMON_INTERRUPT_TO_UC_XIRQ_IRQ_SEL4__WB_PERFMON_COUNTER5_INT_XIRQ_IRQ_SEL__SHIFT               0x5
#define DMCU_PERFMON_INTERRUPT_TO_UC_XIRQ_IRQ_SEL4__WB_PERFMON_COUNTER6_INT_XIRQ_IRQ_SEL__SHIFT               0x6
#define DMCU_PERFMON_INTERRUPT_TO_UC_XIRQ_IRQ_SEL4__WB_PERFMON_COUNTER7_INT_XIRQ_IRQ_SEL__SHIFT               0x7
#define DMCU_PERFMON_INTERRUPT_TO_UC_XIRQ_IRQ_SEL4__DCRX_PERFMON_COUNTER0_INT_XIRQ_IRQ_SEL__SHIFT             0x8
#define DMCU_PERFMON_INTERRUPT_TO_UC_XIRQ_IRQ_SEL4__DCRX_PERFMON_COUNTER1_INT_XIRQ_IRQ_SEL__SHIFT             0x9
#define DMCU_PERFMON_INTERRUPT_TO_UC_XIRQ_IRQ_SEL4__DCRX_PERFMON_COUNTER2_INT_XIRQ_IRQ_SEL__SHIFT             0xa
#define DMCU_PERFMON_INTERRUPT_TO_UC_XIRQ_IRQ_SEL4__DCRX_PERFMON_COUNTER3_INT_XIRQ_IRQ_SEL__SHIFT             0xb
#define DMCU_PERFMON_INTERRUPT_TO_UC_XIRQ_IRQ_SEL4__DCRX_PERFMON_COUNTER4_INT_XIRQ_IRQ_SEL__SHIFT             0xc
#define DMCU_PERFMON_INTERRUPT_TO_UC_XIRQ_IRQ_SEL4__DCRX_PERFMON_COUNTER5_INT_XIRQ_IRQ_SEL__SHIFT             0xd
#define DMCU_PERFMON_INTERRUPT_TO_UC_XIRQ_IRQ_SEL4__DCRX_PERFMON_COUNTER6_INT_XIRQ_IRQ_SEL__SHIFT             0xe
#define DMCU_PERFMON_INTERRUPT_TO_UC_XIRQ_IRQ_SEL4__DCRX_PERFMON_COUNTER7_INT_XIRQ_IRQ_SEL__SHIFT             0xf
#define DMCU_PERFMON_INTERRUPT_TO_UC_XIRQ_IRQ_SEL4__DCCG_PERFMON2_COUNTER0_INT_XIRQ_IRQ_SEL__SHIFT            0x10
#define DMCU_PERFMON_INTERRUPT_TO_UC_XIRQ_IRQ_SEL4__DCCG_PERFMON2_COUNTER1_INT_XIRQ_IRQ_SEL__SHIFT            0x11
#define DMCU_PERFMON_INTERRUPT_TO_UC_XIRQ_IRQ_SEL4__DCCG_PERFMON2_COUNTER2_INT_XIRQ_IRQ_SEL__SHIFT            0x12
#define DMCU_PERFMON_INTERRUPT_TO_UC_XIRQ_IRQ_SEL4__DCCG_PERFMON2_COUNTER3_INT_XIRQ_IRQ_SEL__SHIFT            0x13
#define DMCU_PERFMON_INTERRUPT_TO_UC_XIRQ_IRQ_SEL4__DCCG_PERFMON2_COUNTER4_INT_XIRQ_IRQ_SEL__SHIFT            0x14
#define DMCU_PERFMON_INTERRUPT_TO_UC_XIRQ_IRQ_SEL4__DCCG_PERFMON2_COUNTER5_INT_XIRQ_IRQ_SEL__SHIFT            0x15
#define DMCU_PERFMON_INTERRUPT_TO_UC_XIRQ_IRQ_SEL4__DCCG_PERFMON2_COUNTER6_INT_XIRQ_IRQ_SEL__SHIFT            0x16
#define DMCU_PERFMON_INTERRUPT_TO_UC_XIRQ_IRQ_SEL4__DCCG_PERFMON2_COUNTER7_INT_XIRQ_IRQ_SEL__SHIFT            0x17
#define DMCU_PERFMON_INTERRUPT_TO_UC_XIRQ_IRQ_SEL4__WB_PERFMON_COUNTER_OFF_INT_XIRQ_IRQ_SEL__SHIFT            0x18
#define DMCU_PERFMON_INTERRUPT_TO_UC_XIRQ_IRQ_SEL4__DCRX_PERFMON_COUNTER_OFF_INT_XIRQ_IRQ_SEL__SHIFT          0x19
#define DMCU_PERFMON_INTERRUPT_TO_UC_XIRQ_IRQ_SEL4__DCCG_PERFMON2_COUNTER_OFF_INT_XIRQ_IRQ_SEL__SHIFT         0x1a
#define DMCU_PERFMON_INTERRUPT_TO_UC_XIRQ_IRQ_SEL4__WB_PERFMON_COUNTER0_INT_XIRQ_IRQ_SEL_MASK                 0x00000001L
#define DMCU_PERFMON_INTERRUPT_TO_UC_XIRQ_IRQ_SEL4__WB_PERFMON_COUNTER1_INT_XIRQ_IRQ_SEL_MASK                 0x00000002L
#define DMCU_PERFMON_INTERRUPT_TO_UC_XIRQ_IRQ_SEL4__WB_PERFMON_COUNTER2_INT_XIRQ_IRQ_SEL_MASK                 0x00000004L
#define DMCU_PERFMON_INTERRUPT_TO_UC_XIRQ_IRQ_SEL4__WB_PERFMON_COUNTER3_INT_XIRQ_IRQ_SEL_MASK                 0x00000008L
#define DMCU_PERFMON_INTERRUPT_TO_UC_XIRQ_IRQ_SEL4__WB_PERFMON_COUNTER4_INT_XIRQ_IRQ_SEL_MASK                 0x00000010L
#define DMCU_PERFMON_INTERRUPT_TO_UC_XIRQ_IRQ_SEL4__WB_PERFMON_COUNTER5_INT_XIRQ_IRQ_SEL_MASK                 0x00000020L
#define DMCU_PERFMON_INTERRUPT_TO_UC_XIRQ_IRQ_SEL4__WB_PERFMON_COUNTER6_INT_XIRQ_IRQ_SEL_MASK                 0x00000040L
#define DMCU_PERFMON_INTERRUPT_TO_UC_XIRQ_IRQ_SEL4__WB_PERFMON_COUNTER7_INT_XIRQ_IRQ_SEL_MASK                 0x00000080L
#define DMCU_PERFMON_INTERRUPT_TO_UC_XIRQ_IRQ_SEL4__DCRX_PERFMON_COUNTER0_INT_XIRQ_IRQ_SEL_MASK               0x00000100L
#define DMCU_PERFMON_INTERRUPT_TO_UC_XIRQ_IRQ_SEL4__DCRX_PERFMON_COUNTER1_INT_XIRQ_IRQ_SEL_MASK               0x00000200L
#define DMCU_PERFMON_INTERRUPT_TO_UC_XIRQ_IRQ_SEL4__DCRX_PERFMON_COUNTER2_INT_XIRQ_IRQ_SEL_MASK               0x00000400L
#define DMCU_PERFMON_INTERRUPT_TO_UC_XIRQ_IRQ_SEL4__DCRX_PERFMON_COUNTER3_INT_XIRQ_IRQ_SEL_MASK               0x00000800L
#define DMCU_PERFMON_INTERRUPT_TO_UC_XIRQ_IRQ_SEL4__DCRX_PERFMON_COUNTER4_INT_XIRQ_IRQ_SEL_MASK               0x00001000L
#define DMCU_PERFMON_INTERRUPT_TO_UC_XIRQ_IRQ_SEL4__DCRX_PERFMON_COUNTER5_INT_XIRQ_IRQ_SEL_MASK               0x00002000L
#define DMCU_PERFMON_INTERRUPT_TO_UC_XIRQ_IRQ_SEL4__DCRX_PERFMON_COUNTER6_INT_XIRQ_IRQ_SEL_MASK               0x00004000L
#define DMCU_PERFMON_INTERRUPT_TO_UC_XIRQ_IRQ_SEL4__DCRX_PERFMON_COUNTER7_INT_XIRQ_IRQ_SEL_MASK               0x00008000L
#define DMCU_PERFMON_INTERRUPT_TO_UC_XIRQ_IRQ_SEL4__DCCG_PERFMON2_COUNTER0_INT_XIRQ_IRQ_SEL_MASK              0x00010000L
#define DMCU_PERFMON_INTERRUPT_TO_UC_XIRQ_IRQ_SEL4__DCCG_PERFMON2_COUNTER1_INT_XIRQ_IRQ_SEL_MASK              0x00020000L
#define DMCU_PERFMON_INTERRUPT_TO_UC_XIRQ_IRQ_SEL4__DCCG_PERFMON2_COUNTER2_INT_XIRQ_IRQ_SEL_MASK              0x00040000L
#define DMCU_PERFMON_INTERRUPT_TO_UC_XIRQ_IRQ_SEL4__DCCG_PERFMON2_COUNTER3_INT_XIRQ_IRQ_SEL_MASK              0x00080000L
#define DMCU_PERFMON_INTERRUPT_TO_UC_XIRQ_IRQ_SEL4__DCCG_PERFMON2_COUNTER4_INT_XIRQ_IRQ_SEL_MASK              0x00100000L
#define DMCU_PERFMON_INTERRUPT_TO_UC_XIRQ_IRQ_SEL4__DCCG_PERFMON2_COUNTER5_INT_XIRQ_IRQ_SEL_MASK              0x00200000L
#define DMCU_PERFMON_INTERRUPT_TO_UC_XIRQ_IRQ_SEL4__DCCG_PERFMON2_COUNTER6_INT_XIRQ_IRQ_SEL_MASK              0x00400000L
#define DMCU_PERFMON_INTERRUPT_TO_UC_XIRQ_IRQ_SEL4__DCCG_PERFMON2_COUNTER7_INT_XIRQ_IRQ_SEL_MASK              0x00800000L
#define DMCU_PERFMON_INTERRUPT_TO_UC_XIRQ_IRQ_SEL4__WB_PERFMON_COUNTER_OFF_INT_XIRQ_IRQ_SEL_MASK              0x01000000L
#define DMCU_PERFMON_INTERRUPT_TO_UC_XIRQ_IRQ_SEL4__DCRX_PERFMON_COUNTER_OFF_INT_XIRQ_IRQ_SEL_MASK            0x02000000L
#define DMCU_PERFMON_INTERRUPT_TO_UC_XIRQ_IRQ_SEL4__DCCG_PERFMON2_COUNTER_OFF_INT_XIRQ_IRQ_SEL_MASK           0x04000000L
//DC_ABM1_OVERSCAN_PIXEL_VALUE
#define DC_ABM1_OVERSCAN_PIXEL_VALUE__ABM1_OVERSCAN_R_PIXEL_VALUE__SHIFT                                      0x0
#define DC_ABM1_OVERSCAN_PIXEL_VALUE__ABM1_OVERSCAN_G_PIXEL_VALUE__SHIFT                                      0xa
#define DC_ABM1_OVERSCAN_PIXEL_VALUE__ABM1_OVERSCAN_B_PIXEL_VALUE__SHIFT                                      0x14
#define DC_ABM1_OVERSCAN_PIXEL_VALUE__ABM1_OVERSCAN_R_PIXEL_VALUE_MASK                                        0x000003FFL
#define DC_ABM1_OVERSCAN_PIXEL_VALUE__ABM1_OVERSCAN_G_PIXEL_VALUE_MASK                                        0x000FFC00L
#define DC_ABM1_OVERSCAN_PIXEL_VALUE__ABM1_OVERSCAN_B_PIXEL_VALUE_MASK                                        0x3FF00000L
//DC_ABM1_BL_MASTER_LOCK
#define DC_ABM1_BL_MASTER_LOCK__ABM1_BL_MASTER_LOCK__SHIFT                                                    0x1f
#define DC_ABM1_BL_MASTER_LOCK__ABM1_BL_MASTER_LOCK_MASK                                                      0x80000000L
//AZALIA_CONTROLLER_CLOCK_GATING
#define AZALIA_CONTROLLER_CLOCK_GATING__ENABLE_CLOCK_GATING__SHIFT                                            0x0
#define AZALIA_CONTROLLER_CLOCK_GATING__CLOCK_ON_STATE__SHIFT                                                 0x4
#define AZALIA_CONTROLLER_CLOCK_GATING__ENABLE_CLOCK_GATING_MASK                                              0x00000001L
#define AZALIA_CONTROLLER_CLOCK_GATING__CLOCK_ON_STATE_MASK                                                   0x00000010L
//AZALIA_AUDIO_DTO
#define AZALIA_AUDIO_DTO__AZALIA_AUDIO_DTO_PHASE__SHIFT                                                       0x0
#define AZALIA_AUDIO_DTO__AZALIA_AUDIO_DTO_MODULE__SHIFT                                                      0x10
#define AZALIA_AUDIO_DTO__AZALIA_AUDIO_DTO_PHASE_MASK                                                         0x0000FFFFL
#define AZALIA_AUDIO_DTO__AZALIA_AUDIO_DTO_MODULE_MASK                                                        0xFFFF0000L
//AZALIA_AUDIO_DTO_CONTROL
#define AZALIA_AUDIO_DTO_CONTROL__AZALIA_AUDIO_FORCE_DTO__SHIFT                                               0x8
#define AZALIA_AUDIO_DTO_CONTROL__AZALIA_AUDIO_FORCE_DTO_MASK                                                 0x00000300L
//AZALIA_SOCCLK_CONTROL
#define AZALIA_SOCCLK_CONTROL__AUDIO_STREAM_SOCCLK_DEEP_SLEEP_EXIT_EN__SHIFT                                  0x1
#define AZALIA_SOCCLK_CONTROL__AUDIO_STREAM_SOCCLK_DEEP_SLEEP_EXIT_EN_MASK                                    0x00000002L
//AZALIA_UNDERFLOW_FILLER_SAMPLE
#define AZALIA_UNDERFLOW_FILLER_SAMPLE__AZALIA_UNDERFLOW_FILLER_SAMPLE__SHIFT                                 0x0
#define AZALIA_UNDERFLOW_FILLER_SAMPLE__AZALIA_UNDERFLOW_FILLER_SAMPLE_MASK                                   0xFFFFFFFFL
//AZALIA_DATA_DMA_CONTROL
#define AZALIA_DATA_DMA_CONTROL__DATA_DMA_NON_SNOOP__SHIFT                                                    0x0
#define AZALIA_DATA_DMA_CONTROL__INPUT_DATA_DMA_NON_SNOOP__SHIFT                                              0x2
#define AZALIA_DATA_DMA_CONTROL__DATA_DMA_ISOCHRONOUS__SHIFT                                                  0x4
#define AZALIA_DATA_DMA_CONTROL__INPUT_DATA_DMA_ISOCHRONOUS__SHIFT                                            0x6
#define AZALIA_DATA_DMA_CONTROL__AZALIA_IOC_GENERATION_METHOD__SHIFT                                          0x10
#define AZALIA_DATA_DMA_CONTROL__AZALIA_UNDERFLOW_CONTROL__SHIFT                                              0x11
#define AZALIA_DATA_DMA_CONTROL__DATA_DMA_NON_SNOOP_MASK                                                      0x00000003L
#define AZALIA_DATA_DMA_CONTROL__INPUT_DATA_DMA_NON_SNOOP_MASK                                                0x0000000CL
#define AZALIA_DATA_DMA_CONTROL__DATA_DMA_ISOCHRONOUS_MASK                                                    0x00000030L
#define AZALIA_DATA_DMA_CONTROL__INPUT_DATA_DMA_ISOCHRONOUS_MASK                                              0x000000C0L
#define AZALIA_DATA_DMA_CONTROL__AZALIA_IOC_GENERATION_METHOD_MASK                                            0x00010000L
#define AZALIA_DATA_DMA_CONTROL__AZALIA_UNDERFLOW_CONTROL_MASK                                                0x00020000L
//AZALIA_BDL_DMA_CONTROL
#define AZALIA_BDL_DMA_CONTROL__BDL_DMA_NON_SNOOP__SHIFT                                                      0x0
#define AZALIA_BDL_DMA_CONTROL__INPUT_BDL_DMA_NON_SNOOP__SHIFT                                                0x2
#define AZALIA_BDL_DMA_CONTROL__BDL_DMA_ISOCHRONOUS__SHIFT                                                    0x4
#define AZALIA_BDL_DMA_CONTROL__INPUT_BDL_DMA_ISOCHRONOUS__SHIFT                                              0x6
#define AZALIA_BDL_DMA_CONTROL__BDL_DMA_NON_SNOOP_MASK                                                        0x00000003L
#define AZALIA_BDL_DMA_CONTROL__INPUT_BDL_DMA_NON_SNOOP_MASK                                                  0x0000000CL
#define AZALIA_BDL_DMA_CONTROL__BDL_DMA_ISOCHRONOUS_MASK                                                      0x00000030L
#define AZALIA_BDL_DMA_CONTROL__INPUT_BDL_DMA_ISOCHRONOUS_MASK                                                0x000000C0L
//AZALIA_RIRB_AND_DP_CONTROL
#define AZALIA_RIRB_AND_DP_CONTROL__RIRB_NON_SNOOP__SHIFT                                                     0x0
#define AZALIA_RIRB_AND_DP_CONTROL__DP_DMA_NON_SNOOP__SHIFT                                                   0x4
#define AZALIA_RIRB_AND_DP_CONTROL__DP_UPDATE_FREQ_DIVIDER__SHIFT                                             0x5
#define AZALIA_RIRB_AND_DP_CONTROL__RIRB_NON_SNOOP_MASK                                                       0x00000001L
#define AZALIA_RIRB_AND_DP_CONTROL__DP_DMA_NON_SNOOP_MASK                                                     0x00000010L
#define AZALIA_RIRB_AND_DP_CONTROL__DP_UPDATE_FREQ_DIVIDER_MASK                                               0x000001E0L
//AZALIA_CORB_DMA_CONTROL
#define AZALIA_CORB_DMA_CONTROL__CORB_DMA_NON_SNOOP__SHIFT                                                    0x0
#define AZALIA_CORB_DMA_CONTROL__CORB_DMA_ISOCHRONOUS__SHIFT                                                  0x4
#define AZALIA_CORB_DMA_CONTROL__CORB_DMA_NON_SNOOP_MASK                                                      0x00000001L
#define AZALIA_CORB_DMA_CONTROL__CORB_DMA_ISOCHRONOUS_MASK                                                    0x00000010L
//AZALIA_APPLICATION_POSITION_IN_CYCLIC_BUFFER
#define AZALIA_APPLICATION_POSITION_IN_CYCLIC_BUFFER__APPLICATION_POSITION_IN_CYCLIC_BUFFER__SHIFT            0x0
#define AZALIA_APPLICATION_POSITION_IN_CYCLIC_BUFFER__APPLICATION_POSITION_IN_CYCLIC_BUFFER_MASK              0xFFFFFFFFL
//AZALIA_CYCLIC_BUFFER_SYNC
#define AZALIA_CYCLIC_BUFFER_SYNC__CYCLIC_BUFFER_SYNC_ENABLE__SHIFT                                           0x0
#define AZALIA_CYCLIC_BUFFER_SYNC__CYCLIC_BUFFER_SYNC_ENABLE_MASK                                             0x00000001L
//AZALIA_GLOBAL_CAPABILITIES
#define AZALIA_GLOBAL_CAPABILITIES__NUMBER_OF_SERIAL_DATA_OUTPUT_SIGNALS__SHIFT                               0x1
#define AZALIA_GLOBAL_CAPABILITIES__NUMBER_OF_SERIAL_DATA_OUTPUT_SIGNALS_MASK                                 0x00000006L
//AZALIA_OUTPUT_PAYLOAD_CAPABILITY
#define AZALIA_OUTPUT_PAYLOAD_CAPABILITY__OUTPUT_PAYLOAD_CAPABILITY__SHIFT                                    0x0
#define AZALIA_OUTPUT_PAYLOAD_CAPABILITY__OUTSTRMPAY__SHIFT                                                   0x10
#define AZALIA_OUTPUT_PAYLOAD_CAPABILITY__OUTPUT_PAYLOAD_CAPABILITY_MASK                                      0x0000FFFFL
#define AZALIA_OUTPUT_PAYLOAD_CAPABILITY__OUTSTRMPAY_MASK                                                     0xFFFF0000L
//AZALIA_OUTPUT_STREAM_ARBITER_CONTROL
#define AZALIA_OUTPUT_STREAM_ARBITER_CONTROL__LATENCY_HIDING_LEVEL__SHIFT                                     0x0
#define AZALIA_OUTPUT_STREAM_ARBITER_CONTROL__SYS_MEM_ACTIVE_ENABLE__SHIFT                                    0x8
#define AZALIA_OUTPUT_STREAM_ARBITER_CONTROL__INPUT_LATENCY_HIDING_LEVEL__SHIFT                               0x10
#define AZALIA_OUTPUT_STREAM_ARBITER_CONTROL__LATENCY_HIDING_LEVEL_MASK                                       0x000000FFL
#define AZALIA_OUTPUT_STREAM_ARBITER_CONTROL__SYS_MEM_ACTIVE_ENABLE_MASK                                      0x00000100L
#define AZALIA_OUTPUT_STREAM_ARBITER_CONTROL__INPUT_LATENCY_HIDING_LEVEL_MASK                                 0x00FF0000L
//AZALIA_INPUT_PAYLOAD_CAPABILITY
#define AZALIA_INPUT_PAYLOAD_CAPABILITY__INPUT_PAYLOAD_CAPABILITY__SHIFT                                      0x0
#define AZALIA_INPUT_PAYLOAD_CAPABILITY__INSTRMPAY__SHIFT                                                     0x10
#define AZALIA_INPUT_PAYLOAD_CAPABILITY__INPUT_PAYLOAD_CAPABILITY_MASK                                        0x0000FFFFL
#define AZALIA_INPUT_PAYLOAD_CAPABILITY__INSTRMPAY_MASK                                                       0xFFFF0000L
//AZALIA_INPUT_CRC0_CONTROL0
#define AZALIA_INPUT_CRC0_CONTROL0__INPUT_CRC_EN__SHIFT                                                       0x0
#define AZALIA_INPUT_CRC0_CONTROL0__INPUT_CRC_BLOCK_MODE__SHIFT                                               0x4
#define AZALIA_INPUT_CRC0_CONTROL0__INPUT_CRC_INSTANCE_SEL__SHIFT                                             0x8
#define AZALIA_INPUT_CRC0_CONTROL0__INPUT_CRC_EN_MASK                                                         0x00000001L
#define AZALIA_INPUT_CRC0_CONTROL0__INPUT_CRC_BLOCK_MODE_MASK                                                 0x00000010L
#define AZALIA_INPUT_CRC0_CONTROL0__INPUT_CRC_INSTANCE_SEL_MASK                                               0x00000700L
//AZALIA_INPUT_CRC0_CONTROL1
#define AZALIA_INPUT_CRC0_CONTROL1__INPUT_CRC_BLOCK_SIZE__SHIFT                                               0x0
#define AZALIA_INPUT_CRC0_CONTROL1__INPUT_CRC_BLOCK_SIZE_MASK                                                 0xFFFFFFFFL
//AZALIA_INPUT_CRC0_CONTROL2
#define AZALIA_INPUT_CRC0_CONTROL2__INPUT_CRC_BLOCK_ITERATION__SHIFT                                          0x0
#define AZALIA_INPUT_CRC0_CONTROL2__INPUT_CRC_BLOCK_ITERATION_MASK                                            0x0000FFFFL
//AZALIA_INPUT_CRC0_CONTROL3
#define AZALIA_INPUT_CRC0_CONTROL3__INPUT_CRC_COMPLETE__SHIFT                                                 0x0
#define AZALIA_INPUT_CRC0_CONTROL3__INPUT_CRC_BLOCK_COMPLETE_PHASE__SHIFT                                     0x4
#define AZALIA_INPUT_CRC0_CONTROL3__INPUT_CRC_CHANNEL_RESULT_SEL__SHIFT                                       0x8
#define AZALIA_INPUT_CRC0_CONTROL3__INPUT_CRC_COMPLETE_MASK                                                   0x00000001L
#define AZALIA_INPUT_CRC0_CONTROL3__INPUT_CRC_BLOCK_COMPLETE_PHASE_MASK                                       0x00000010L
#define AZALIA_INPUT_CRC0_CONTROL3__INPUT_CRC_CHANNEL_RESULT_SEL_MASK                                         0x00000700L
//AZALIA_INPUT_CRC0_RESULT
#define AZALIA_INPUT_CRC0_RESULT__INPUT_CRC_RESULT__SHIFT                                                     0x0
#define AZALIA_INPUT_CRC0_RESULT__INPUT_CRC_RESULT_MASK                                                       0xFFFFFFFFL
//AZALIA_INPUT_CRC1_CONTROL0
#define AZALIA_INPUT_CRC1_CONTROL0__INPUT_CRC_EN__SHIFT                                                       0x0
#define AZALIA_INPUT_CRC1_CONTROL0__INPUT_CRC_BLOCK_MODE__SHIFT                                               0x4
#define AZALIA_INPUT_CRC1_CONTROL0__INPUT_CRC_INSTANCE_SEL__SHIFT                                             0x8
#define AZALIA_INPUT_CRC1_CONTROL0__INPUT_CRC_EN_MASK                                                         0x00000001L
#define AZALIA_INPUT_CRC1_CONTROL0__INPUT_CRC_BLOCK_MODE_MASK                                                 0x00000010L
#define AZALIA_INPUT_CRC1_CONTROL0__INPUT_CRC_INSTANCE_SEL_MASK                                               0x00000700L
//AZALIA_INPUT_CRC1_CONTROL1
#define AZALIA_INPUT_CRC1_CONTROL1__INPUT_CRC_BLOCK_SIZE__SHIFT                                               0x0
#define AZALIA_INPUT_CRC1_CONTROL1__INPUT_CRC_BLOCK_SIZE_MASK                                                 0xFFFFFFFFL
//AZALIA_INPUT_CRC1_CONTROL2
#define AZALIA_INPUT_CRC1_CONTROL2__INPUT_CRC_BLOCK_ITERATION__SHIFT                                          0x0
#define AZALIA_INPUT_CRC1_CONTROL2__INPUT_CRC_BLOCK_ITERATION_MASK                                            0x0000FFFFL
//AZALIA_INPUT_CRC1_CONTROL3
#define AZALIA_INPUT_CRC1_CONTROL3__INPUT_CRC_COMPLETE__SHIFT                                                 0x0
#define AZALIA_INPUT_CRC1_CONTROL3__INPUT_CRC_BLOCK_COMPLETE_PHASE__SHIFT                                     0x4
#define AZALIA_INPUT_CRC1_CONTROL3__INPUT_CRC_CHANNEL_RESULT_SEL__SHIFT                                       0x8
#define AZALIA_INPUT_CRC1_CONTROL3__INPUT_CRC_COMPLETE_MASK                                                   0x00000001L
#define AZALIA_INPUT_CRC1_CONTROL3__INPUT_CRC_BLOCK_COMPLETE_PHASE_MASK                                       0x00000010L
#define AZALIA_INPUT_CRC1_CONTROL3__INPUT_CRC_CHANNEL_RESULT_SEL_MASK                                         0x00000700L
//AZALIA_INPUT_CRC1_RESULT
#define AZALIA_INPUT_CRC1_RESULT__INPUT_CRC_RESULT__SHIFT                                                     0x0
#define AZALIA_INPUT_CRC1_RESULT__INPUT_CRC_RESULT_MASK                                                       0xFFFFFFFFL
//AZALIA_CRC0_CONTROL0
#define AZALIA_CRC0_CONTROL0__CRC_EN__SHIFT                                                                   0x0
#define AZALIA_CRC0_CONTROL0__CRC_BLOCK_MODE__SHIFT                                                           0x4
#define AZALIA_CRC0_CONTROL0__CRC_INSTANCE_SEL__SHIFT                                                         0x8
#define AZALIA_CRC0_CONTROL0__CRC_SOURCE_SEL__SHIFT                                                           0xc
#define AZALIA_CRC0_CONTROL0__CRC_EN_MASK                                                                     0x00000001L
#define AZALIA_CRC0_CONTROL0__CRC_BLOCK_MODE_MASK                                                             0x00000010L
#define AZALIA_CRC0_CONTROL0__CRC_INSTANCE_SEL_MASK                                                           0x00000700L
#define AZALIA_CRC0_CONTROL0__CRC_SOURCE_SEL_MASK                                                             0x00001000L
//AZALIA_CRC0_CONTROL1
#define AZALIA_CRC0_CONTROL1__CRC_BLOCK_SIZE__SHIFT                                                           0x0
#define AZALIA_CRC0_CONTROL1__CRC_BLOCK_SIZE_MASK                                                             0xFFFFFFFFL
//AZALIA_CRC0_CONTROL2
#define AZALIA_CRC0_CONTROL2__CRC_BLOCK_ITERATION__SHIFT                                                      0x0
#define AZALIA_CRC0_CONTROL2__CRC_BLOCK_ITERATION_MASK                                                        0x0000FFFFL
//AZALIA_CRC0_CONTROL3
#define AZALIA_CRC0_CONTROL3__CRC_COMPLETE__SHIFT                                                             0x0
#define AZALIA_CRC0_CONTROL3__CRC_BLOCK_COMPLETE_PHASE__SHIFT                                                 0x4
#define AZALIA_CRC0_CONTROL3__CRC_CHANNEL_RESULT_SEL__SHIFT                                                   0x8
#define AZALIA_CRC0_CONTROL3__CRC_COMPLETE_MASK                                                               0x00000001L
#define AZALIA_CRC0_CONTROL3__CRC_BLOCK_COMPLETE_PHASE_MASK                                                   0x00000010L
#define AZALIA_CRC0_CONTROL3__CRC_CHANNEL_RESULT_SEL_MASK                                                     0x00000700L
//AZALIA_CRC0_RESULT
#define AZALIA_CRC0_RESULT__CRC_RESULT__SHIFT                                                                 0x0
#define AZALIA_CRC0_RESULT__CRC_RESULT_MASK                                                                   0xFFFFFFFFL
//AZALIA_CRC1_CONTROL0
#define AZALIA_CRC1_CONTROL0__CRC_EN__SHIFT                                                                   0x0
#define AZALIA_CRC1_CONTROL0__CRC_BLOCK_MODE__SHIFT                                                           0x4
#define AZALIA_CRC1_CONTROL0__CRC_INSTANCE_SEL__SHIFT                                                         0x8
#define AZALIA_CRC1_CONTROL0__CRC_SOURCE_SEL__SHIFT                                                           0xc
#define AZALIA_CRC1_CONTROL0__CRC_EN_MASK                                                                     0x00000001L
#define AZALIA_CRC1_CONTROL0__CRC_BLOCK_MODE_MASK                                                             0x00000010L
#define AZALIA_CRC1_CONTROL0__CRC_INSTANCE_SEL_MASK                                                           0x00000700L
#define AZALIA_CRC1_CONTROL0__CRC_SOURCE_SEL_MASK                                                             0x00001000L
//AZALIA_CRC1_CONTROL1
#define AZALIA_CRC1_CONTROL1__CRC_BLOCK_SIZE__SHIFT                                                           0x0
#define AZALIA_CRC1_CONTROL1__CRC_BLOCK_SIZE_MASK                                                             0xFFFFFFFFL
//AZALIA_CRC1_CONTROL2
#define AZALIA_CRC1_CONTROL2__CRC_BLOCK_ITERATION__SHIFT                                                      0x0
#define AZALIA_CRC1_CONTROL2__CRC_BLOCK_ITERATION_MASK                                                        0x0000FFFFL
//AZALIA_CRC1_CONTROL3
#define AZALIA_CRC1_CONTROL3__CRC_COMPLETE__SHIFT                                                             0x0
#define AZALIA_CRC1_CONTROL3__CRC_BLOCK_COMPLETE_PHASE__SHIFT                                                 0x4
#define AZALIA_CRC1_CONTROL3__CRC_CHANNEL_RESULT_SEL__SHIFT                                                   0x8
#define AZALIA_CRC1_CONTROL3__CRC_COMPLETE_MASK                                                               0x00000001L
#define AZALIA_CRC1_CONTROL3__CRC_BLOCK_COMPLETE_PHASE_MASK                                                   0x00000010L
#define AZALIA_CRC1_CONTROL3__CRC_CHANNEL_RESULT_SEL_MASK                                                     0x00000700L
//AZALIA_CRC1_RESULT
#define AZALIA_CRC1_RESULT__CRC_RESULT__SHIFT                                                                 0x0
#define AZALIA_CRC1_RESULT__CRC_RESULT_MASK                                                                   0xFFFFFFFFL
//AZALIA_MEM_PWR_CTRL
#define AZALIA_MEM_PWR_CTRL__AZ_MEM_PWR_FORCE__SHIFT                                                          0x0
#define AZALIA_MEM_PWR_CTRL__AZ_MEM_PWR_DIS__SHIFT                                                            0x2
#define AZALIA_MEM_PWR_CTRL__AZ_INPUT_STREAM0_MEM_PWR_FORCE__SHIFT                                            0x3
#define AZALIA_MEM_PWR_CTRL__AZ_INPUT_STREAM0_MEM_PWR_DIS__SHIFT                                              0x5
#define AZALIA_MEM_PWR_CTRL__AZ_INPUT_STREAM1_MEM_PWR_FORCE__SHIFT                                            0x6
#define AZALIA_MEM_PWR_CTRL__AZ_INPUT_STREAM1_MEM_PWR_DIS__SHIFT                                              0x8
#define AZALIA_MEM_PWR_CTRL__AZ_INPUT_STREAM2_MEM_PWR_FORCE__SHIFT                                            0x9
#define AZALIA_MEM_PWR_CTRL__AZ_INPUT_STREAM2_MEM_PWR_DIS__SHIFT                                              0xb
#define AZALIA_MEM_PWR_CTRL__AZ_INPUT_STREAM3_MEM_PWR_FORCE__SHIFT                                            0xc
#define AZALIA_MEM_PWR_CTRL__AZ_INPUT_STREAM3_MEM_PWR_DIS__SHIFT                                              0xe
#define AZALIA_MEM_PWR_CTRL__AZ_INPUT_STREAM4_MEM_PWR_FORCE__SHIFT                                            0xf
#define AZALIA_MEM_PWR_CTRL__AZ_INPUT_STREAM4_MEM_PWR_DIS__SHIFT                                              0x11
#define AZALIA_MEM_PWR_CTRL__AZ_INPUT_STREAM5_MEM_PWR_FORCE__SHIFT                                            0x12
#define AZALIA_MEM_PWR_CTRL__AZ_INPUT_STREAM5_MEM_PWR_DIS__SHIFT                                              0x14
#define AZALIA_MEM_PWR_CTRL__AZ_MEM_PWR_MODE_SEL__SHIFT                                                       0x1c
#define AZALIA_MEM_PWR_CTRL__AZ_MEM_PWR_FORCE_MASK                                                            0x00000003L
#define AZALIA_MEM_PWR_CTRL__AZ_MEM_PWR_DIS_MASK                                                              0x00000004L
#define AZALIA_MEM_PWR_CTRL__AZ_INPUT_STREAM0_MEM_PWR_FORCE_MASK                                              0x00000018L
#define AZALIA_MEM_PWR_CTRL__AZ_INPUT_STREAM0_MEM_PWR_DIS_MASK                                                0x00000020L
#define AZALIA_MEM_PWR_CTRL__AZ_INPUT_STREAM1_MEM_PWR_FORCE_MASK                                              0x000000C0L
#define AZALIA_MEM_PWR_CTRL__AZ_INPUT_STREAM1_MEM_PWR_DIS_MASK                                                0x00000100L
#define AZALIA_MEM_PWR_CTRL__AZ_INPUT_STREAM2_MEM_PWR_FORCE_MASK                                              0x00000600L
#define AZALIA_MEM_PWR_CTRL__AZ_INPUT_STREAM2_MEM_PWR_DIS_MASK                                                0x00000800L
#define AZALIA_MEM_PWR_CTRL__AZ_INPUT_STREAM3_MEM_PWR_FORCE_MASK                                              0x00003000L
#define AZALIA_MEM_PWR_CTRL__AZ_INPUT_STREAM3_MEM_PWR_DIS_MASK                                                0x00004000L
#define AZALIA_MEM_PWR_CTRL__AZ_INPUT_STREAM4_MEM_PWR_FORCE_MASK                                              0x00018000L
#define AZALIA_MEM_PWR_CTRL__AZ_INPUT_STREAM4_MEM_PWR_DIS_MASK                                                0x00020000L
#define AZALIA_MEM_PWR_CTRL__AZ_INPUT_STREAM5_MEM_PWR_FORCE_MASK                                              0x000C0000L
#define AZALIA_MEM_PWR_CTRL__AZ_INPUT_STREAM5_MEM_PWR_DIS_MASK                                                0x00100000L
#define AZALIA_MEM_PWR_CTRL__AZ_MEM_PWR_MODE_SEL_MASK                                                         0x30000000L
//AZALIA_MEM_PWR_STATUS
#define AZALIA_MEM_PWR_STATUS__AZ_MEM_PWR_STATE__SHIFT                                                        0x0
#define AZALIA_MEM_PWR_STATUS__AZ_INPUT_STREAM0_MEM_PWR_STATE__SHIFT                                          0x2
#define AZALIA_MEM_PWR_STATUS__AZ_INPUT_STREAM1_MEM_PWR_STATE__SHIFT                                          0x4
#define AZALIA_MEM_PWR_STATUS__AZ_INPUT_STREAM2_MEM_PWR_STATE__SHIFT                                          0x6
#define AZALIA_MEM_PWR_STATUS__AZ_INPUT_STREAM3_MEM_PWR_STATE__SHIFT                                          0x8
#define AZALIA_MEM_PWR_STATUS__AZ_INPUT_STREAM4_MEM_PWR_STATE__SHIFT                                          0xa
#define AZALIA_MEM_PWR_STATUS__AZ_INPUT_STREAM5_MEM_PWR_STATE__SHIFT                                          0xc
#define AZALIA_MEM_PWR_STATUS__AZ_MEM_PWR_STATE_MASK                                                          0x00000003L
#define AZALIA_MEM_PWR_STATUS__AZ_INPUT_STREAM0_MEM_PWR_STATE_MASK                                            0x0000000CL
#define AZALIA_MEM_PWR_STATUS__AZ_INPUT_STREAM1_MEM_PWR_STATE_MASK                                            0x00000030L
#define AZALIA_MEM_PWR_STATUS__AZ_INPUT_STREAM2_MEM_PWR_STATE_MASK                                            0x000000C0L
#define AZALIA_MEM_PWR_STATUS__AZ_INPUT_STREAM3_MEM_PWR_STATE_MASK                                            0x00000300L
#define AZALIA_MEM_PWR_STATUS__AZ_INPUT_STREAM4_MEM_PWR_STATE_MASK                                            0x00000C00L
#define AZALIA_MEM_PWR_STATUS__AZ_INPUT_STREAM5_MEM_PWR_STATE_MASK                                            0x00003000L
//AZALIA_F0_CODEC_ROOT_PARAMETER_VENDOR_AND_DEVICE_ID
#define AZALIA_F0_CODEC_ROOT_PARAMETER_VENDOR_AND_DEVICE_ID__AZALIA_CODEC_ROOT_PARAMETER_VENDOR_AND_DEVICE_ID__SHIFT  0x0
#define AZALIA_F0_CODEC_ROOT_PARAMETER_VENDOR_AND_DEVICE_ID__AZALIA_CODEC_ROOT_PARAMETER_VENDOR_AND_DEVICE_ID_MASK  0xFFFFFFFFL
//AZALIA_F0_CODEC_ROOT_PARAMETER_REVISION_ID
#define AZALIA_F0_CODEC_ROOT_PARAMETER_REVISION_ID__AZALIA_CODEC_ROOT_PARAMETER_REVISION_ID__SHIFT            0x0
#define AZALIA_F0_CODEC_ROOT_PARAMETER_REVISION_ID__AZALIA_CODEC_ROOT_PARAMETER_REVISION_ID_MASK              0xFFFFFFFFL
//AZALIA_F0_CODEC_CHANNEL_COUNT_CONTROL
#define AZALIA_F0_CODEC_CHANNEL_COUNT_CONTROL__HBR_CHANNEL_COUNT__SHIFT                                       0x0
#define AZALIA_F0_CODEC_CHANNEL_COUNT_CONTROL__COMPRESSED_CHANNEL_COUNT__SHIFT                                0x4
#define AZALIA_F0_CODEC_CHANNEL_COUNT_CONTROL__HBR_CHANNEL_COUNT_MASK                                         0x00000007L
#define AZALIA_F0_CODEC_CHANNEL_COUNT_CONTROL__COMPRESSED_CHANNEL_COUNT_MASK                                  0x00000070L
//AZALIA_F0_CODEC_RESYNC_FIFO_CONTROL
#define AZALIA_F0_CODEC_RESYNC_FIFO_CONTROL__RESYNC_FIFO_STARTUP_KEEPOUT_WINDOW__SHIFT                        0x0
#define AZALIA_F0_CODEC_RESYNC_FIFO_CONTROL__RESYNC_FIFO_STARTUP_KEEPOUT_WINDOW_MASK                          0x0000003FL
//AZALIA_F0_CODEC_FUNCTION_PARAMETER_GROUP_TYPE
#define AZALIA_F0_CODEC_FUNCTION_PARAMETER_GROUP_TYPE__AZALIA_CODEC_FUNCTION_PARAMETER_GROUP_TYPE__SHIFT      0x0
#define AZALIA_F0_CODEC_FUNCTION_PARAMETER_GROUP_TYPE__AZALIA_CODEC_FUNCTION_PARAMETER_GROUP_TYPE_MASK        0xFFFFFFFFL
//AZALIA_F0_CODEC_FUNCTION_PARAMETER_SUPPORTED_SIZE_RATES
#define AZALIA_F0_CODEC_FUNCTION_PARAMETER_SUPPORTED_SIZE_RATES__AUDIO_RATE_CAPABILITIES__SHIFT               0x0
#define AZALIA_F0_CODEC_FUNCTION_PARAMETER_SUPPORTED_SIZE_RATES__AUDIO_BIT_CAPABILITIES__SHIFT                0x10
#define AZALIA_F0_CODEC_FUNCTION_PARAMETER_SUPPORTED_SIZE_RATES__AUDIO_RATE_CAPABILITIES_MASK                 0x00000FFFL
#define AZALIA_F0_CODEC_FUNCTION_PARAMETER_SUPPORTED_SIZE_RATES__AUDIO_BIT_CAPABILITIES_MASK                  0x001F0000L
//AZALIA_F0_CODEC_FUNCTION_PARAMETER_STREAM_FORMATS
#define AZALIA_F0_CODEC_FUNCTION_PARAMETER_STREAM_FORMATS__AZALIA_CODEC_FUNCTION_PARAMETER_STREAM_FORMATS__SHIFT  0x0
#define AZALIA_F0_CODEC_FUNCTION_PARAMETER_STREAM_FORMATS__AZALIA_CODEC_FUNCTION_PARAMETER_STREAM_FORMATS_MASK  0xFFFFFFFFL
//AZALIA_F0_CODEC_FUNCTION_PARAMETER_POWER_STATES
#define AZALIA_F0_CODEC_FUNCTION_PARAMETER_POWER_STATES__AZALIA_CODEC_FUNCTION_PARAMETER_POWER_STATES__SHIFT  0x0
#define AZALIA_F0_CODEC_FUNCTION_PARAMETER_POWER_STATES__CLKSTOP__SHIFT                                       0x1e
#define AZALIA_F0_CODEC_FUNCTION_PARAMETER_POWER_STATES__EPSS__SHIFT                                          0x1f
#define AZALIA_F0_CODEC_FUNCTION_PARAMETER_POWER_STATES__AZALIA_CODEC_FUNCTION_PARAMETER_POWER_STATES_MASK    0x3FFFFFFFL
#define AZALIA_F0_CODEC_FUNCTION_PARAMETER_POWER_STATES__CLKSTOP_MASK                                         0x40000000L
#define AZALIA_F0_CODEC_FUNCTION_PARAMETER_POWER_STATES__EPSS_MASK                                            0x80000000L
//AZALIA_F0_CODEC_FUNCTION_CONTROL_POWER_STATE
#define AZALIA_F0_CODEC_FUNCTION_CONTROL_POWER_STATE__POWER_STATE_SET__SHIFT                                  0x0
#define AZALIA_F0_CODEC_FUNCTION_CONTROL_POWER_STATE__POWER_STATE_ACT__SHIFT                                  0x4
#define AZALIA_F0_CODEC_FUNCTION_CONTROL_POWER_STATE__CLKSTOPOK__SHIFT                                        0x9
#define AZALIA_F0_CODEC_FUNCTION_CONTROL_POWER_STATE__POWER_STATE_SETTINGS_RESET__SHIFT                       0xa
#define AZALIA_F0_CODEC_FUNCTION_CONTROL_POWER_STATE__POWER_STATE_SET_MASK                                    0x0000000FL
#define AZALIA_F0_CODEC_FUNCTION_CONTROL_POWER_STATE__POWER_STATE_ACT_MASK                                    0x000000F0L
#define AZALIA_F0_CODEC_FUNCTION_CONTROL_POWER_STATE__CLKSTOPOK_MASK                                          0x00000200L
#define AZALIA_F0_CODEC_FUNCTION_CONTROL_POWER_STATE__POWER_STATE_SETTINGS_RESET_MASK                         0x00000400L
//AZALIA_F0_CODEC_FUNCTION_CONTROL_RESET
#define AZALIA_F0_CODEC_FUNCTION_CONTROL_RESET__CODEC_RESET__SHIFT                                            0x0
#define AZALIA_F0_CODEC_FUNCTION_CONTROL_RESET__CODEC_RESET_MASK                                              0x00000001L
//AZALIA_F0_CODEC_FUNCTION_CONTROL_RESPONSE_SUBSYSTEM_ID
#define AZALIA_F0_CODEC_FUNCTION_CONTROL_RESPONSE_SUBSYSTEM_ID__SUBSYSTEM_ID_BYTE0__SHIFT                     0x0
#define AZALIA_F0_CODEC_FUNCTION_CONTROL_RESPONSE_SUBSYSTEM_ID__SUBSYSTEM_ID_BYTE1__SHIFT                     0x8
#define AZALIA_F0_CODEC_FUNCTION_CONTROL_RESPONSE_SUBSYSTEM_ID__SUBSYSTEM_ID_BYTE2__SHIFT                     0x10
#define AZALIA_F0_CODEC_FUNCTION_CONTROL_RESPONSE_SUBSYSTEM_ID__SUBSYSTEM_ID_BYTE3__SHIFT                     0x18
#define AZALIA_F0_CODEC_FUNCTION_CONTROL_RESPONSE_SUBSYSTEM_ID__SUBSYSTEM_ID_BYTE0_MASK                       0x000000FFL
#define AZALIA_F0_CODEC_FUNCTION_CONTROL_RESPONSE_SUBSYSTEM_ID__SUBSYSTEM_ID_BYTE1_MASK                       0x0000FF00L
#define AZALIA_F0_CODEC_FUNCTION_CONTROL_RESPONSE_SUBSYSTEM_ID__SUBSYSTEM_ID_BYTE2_MASK                       0x00FF0000L
#define AZALIA_F0_CODEC_FUNCTION_CONTROL_RESPONSE_SUBSYSTEM_ID__SUBSYSTEM_ID_BYTE3_MASK                       0xFF000000L
//AZALIA_F0_CODEC_FUNCTION_CONTROL_CONVERTER_SYNCHRONIZATION
#define AZALIA_F0_CODEC_FUNCTION_CONTROL_CONVERTER_SYNCHRONIZATION__CONVERTER_SYNCHRONIZATION__SHIFT          0x0
#define AZALIA_F0_CODEC_FUNCTION_CONTROL_CONVERTER_SYNCHRONIZATION__CONVERTER_SYNCHRONIZATION_MASK            0x000000FFL
//CC_RCU_DC_AUDIO_PORT_CONNECTIVITY
#define CC_RCU_DC_AUDIO_PORT_CONNECTIVITY__PORT_CONNECTIVITY__SHIFT                                           0x0
#define CC_RCU_DC_AUDIO_PORT_CONNECTIVITY__PORT_CONNECTIVITY_OVERRIDE_ENABLE__SHIFT                           0x4
#define CC_RCU_DC_AUDIO_PORT_CONNECTIVITY__PORT_CONNECTIVITY_MASK                                             0x00000007L
#define CC_RCU_DC_AUDIO_PORT_CONNECTIVITY__PORT_CONNECTIVITY_OVERRIDE_ENABLE_MASK                             0x00000010L
//CC_RCU_DC_AUDIO_INPUT_PORT_CONNECTIVITY
#define CC_RCU_DC_AUDIO_INPUT_PORT_CONNECTIVITY__INPUT_PORT_CONNECTIVITY__SHIFT                               0x0
#define CC_RCU_DC_AUDIO_INPUT_PORT_CONNECTIVITY__INPUT_PORT_CONNECTIVITY_OVERRIDE_ENABLE__SHIFT               0x4
#define CC_RCU_DC_AUDIO_INPUT_PORT_CONNECTIVITY__INPUT_PORT_CONNECTIVITY_MASK                                 0x00000007L
#define CC_RCU_DC_AUDIO_INPUT_PORT_CONNECTIVITY__INPUT_PORT_CONNECTIVITY_OVERRIDE_ENABLE_MASK                 0x00000010L
//AZALIA_F0_GTC_GROUP_OFFSET0
#define AZALIA_F0_GTC_GROUP_OFFSET0__GTC_GROUP_OFFSET0__SHIFT                                                 0x0
#define AZALIA_F0_GTC_GROUP_OFFSET0__GTC_GROUP_OFFSET0_MASK                                                   0xFFFFFFFFL
//AZALIA_F0_GTC_GROUP_OFFSET1
#define AZALIA_F0_GTC_GROUP_OFFSET1__GTC_GROUP_OFFSET1__SHIFT                                                 0x0
#define AZALIA_F0_GTC_GROUP_OFFSET1__GTC_GROUP_OFFSET1_MASK                                                   0xFFFFFFFFL
//AZALIA_F0_GTC_GROUP_OFFSET2
#define AZALIA_F0_GTC_GROUP_OFFSET2__GTC_GROUP_OFFSET2__SHIFT                                                 0x0
#define AZALIA_F0_GTC_GROUP_OFFSET2__GTC_GROUP_OFFSET2_MASK                                                   0xFFFFFFFFL
//AZALIA_F0_GTC_GROUP_OFFSET3
#define AZALIA_F0_GTC_GROUP_OFFSET3__GTC_GROUP_OFFSET3__SHIFT                                                 0x0
#define AZALIA_F0_GTC_GROUP_OFFSET3__GTC_GROUP_OFFSET3_MASK                                                   0xFFFFFFFFL
//AZALIA_F0_GTC_GROUP_OFFSET4
#define AZALIA_F0_GTC_GROUP_OFFSET4__GTC_GROUP_OFFSET4__SHIFT                                                 0x0
#define AZALIA_F0_GTC_GROUP_OFFSET4__GTC_GROUP_OFFSET4_MASK                                                   0xFFFFFFFFL
//AZALIA_F0_GTC_GROUP_OFFSET5
#define AZALIA_F0_GTC_GROUP_OFFSET5__GTC_GROUP_OFFSET5__SHIFT                                                 0x0
#define AZALIA_F0_GTC_GROUP_OFFSET5__GTC_GROUP_OFFSET5_MASK                                                   0xFFFFFFFFL
//AZALIA_F0_GTC_GROUP_OFFSET6
#define AZALIA_F0_GTC_GROUP_OFFSET6__GTC_GROUP_OFFSET6__SHIFT                                                 0x0
#define AZALIA_F0_GTC_GROUP_OFFSET6__GTC_GROUP_OFFSET6_MASK                                                   0xFFFFFFFFL
//REG_DC_AUDIO_PORT_CONNECTIVITY
#define REG_DC_AUDIO_PORT_CONNECTIVITY__REG_PORT_CONNECTIVITY__SHIFT                                          0x0
#define REG_DC_AUDIO_PORT_CONNECTIVITY__REG_PORT_CONNECTIVITY_OVERRIDE_ENABLE__SHIFT                          0x4
#define REG_DC_AUDIO_PORT_CONNECTIVITY__REG_PORT_CONNECTIVITY_MASK                                            0x00000007L
#define REG_DC_AUDIO_PORT_CONNECTIVITY__REG_PORT_CONNECTIVITY_OVERRIDE_ENABLE_MASK                            0x00000010L
//REG_DC_AUDIO_INPUT_PORT_CONNECTIVITY
#define REG_DC_AUDIO_INPUT_PORT_CONNECTIVITY__REG_INPUT_PORT_CONNECTIVITY__SHIFT                              0x0
#define REG_DC_AUDIO_INPUT_PORT_CONNECTIVITY__REG_INPUT_PORT_CONNECTIVITY_OVERRIDE_ENABLE__SHIFT              0x4
#define REG_DC_AUDIO_INPUT_PORT_CONNECTIVITY__REG_INPUT_PORT_CONNECTIVITY_MASK                                0x00000007L
#define REG_DC_AUDIO_INPUT_PORT_CONNECTIVITY__REG_INPUT_PORT_CONNECTIVITY_OVERRIDE_ENABLE_MASK                0x00000010L
//DAC_ENABLE
#define DAC_ENABLE__DAC_ENABLE__SHIFT                                                                         0x0
#define DAC_ENABLE__DAC_RESYNC_FIFO_ENABLE__SHIFT                                                             0x1
#define DAC_ENABLE__DAC_RESYNC_FIFO_POINTER_SKEW__SHIFT                                                       0x2
#define DAC_ENABLE__DAC_RESYNC_FIFO_ERROR__SHIFT                                                              0x4
#define DAC_ENABLE__DAC_RESYNC_FIFO_ERROR_ACK__SHIFT                                                          0x5
#define DAC_ENABLE__DAC_RESYNC_FIFO_TVOUT_SIM__SHIFT                                                          0x8
#define DAC_ENABLE__DAC_ENABLE_MASK                                                                           0x00000001L
#define DAC_ENABLE__DAC_RESYNC_FIFO_ENABLE_MASK                                                               0x00000002L
#define DAC_ENABLE__DAC_RESYNC_FIFO_POINTER_SKEW_MASK                                                         0x0000000CL
#define DAC_ENABLE__DAC_RESYNC_FIFO_ERROR_MASK                                                                0x00000010L
#define DAC_ENABLE__DAC_RESYNC_FIFO_ERROR_ACK_MASK                                                            0x00000020L
#define DAC_ENABLE__DAC_RESYNC_FIFO_TVOUT_SIM_MASK                                                            0x00000100L
//DAC_SOURCE_SELECT
#define DAC_SOURCE_SELECT__DAC_SOURCE_SELECT__SHIFT                                                           0x0
#define DAC_SOURCE_SELECT__DAC_TV_SELECT__SHIFT                                                               0x3
#define DAC_SOURCE_SELECT__DAC_SOURCE_SELECT_MASK                                                             0x00000007L
#define DAC_SOURCE_SELECT__DAC_TV_SELECT_MASK                                                                 0x00000008L
//DAC_CRC_EN
#define DAC_CRC_EN__DAC_CRC_EN__SHIFT                                                                         0x0
#define DAC_CRC_EN__DAC_CRC_CONT_EN__SHIFT                                                                    0x10
#define DAC_CRC_EN__DAC_CRC_EN_MASK                                                                           0x00000001L
#define DAC_CRC_EN__DAC_CRC_CONT_EN_MASK                                                                      0x00010000L
//DAC_CRC_CONTROL
#define DAC_CRC_CONTROL__DAC_CRC_FIELD__SHIFT                                                                 0x0
#define DAC_CRC_CONTROL__DAC_CRC_ONLY_BLANKB__SHIFT                                                           0x8
#define DAC_CRC_CONTROL__DAC_CRC_FIELD_MASK                                                                   0x00000001L
#define DAC_CRC_CONTROL__DAC_CRC_ONLY_BLANKB_MASK                                                             0x00000100L
//DAC_CRC_SIG_RGB_MASK
#define DAC_CRC_SIG_RGB_MASK__DAC_CRC_SIG_BLUE_MASK__SHIFT                                                    0x0
#define DAC_CRC_SIG_RGB_MASK__DAC_CRC_SIG_GREEN_MASK__SHIFT                                                   0xa
#define DAC_CRC_SIG_RGB_MASK__DAC_CRC_SIG_RED_MASK__SHIFT                                                     0x14
#define DAC_CRC_SIG_RGB_MASK__DAC_CRC_SIG_BLUE_MASK_MASK                                                      0x000003FFL
#define DAC_CRC_SIG_RGB_MASK__DAC_CRC_SIG_GREEN_MASK_MASK                                                     0x000FFC00L
#define DAC_CRC_SIG_RGB_MASK__DAC_CRC_SIG_RED_MASK_MASK                                                       0x3FF00000L
//DAC_CRC_SIG_CONTROL_MASK
#define DAC_CRC_SIG_CONTROL_MASK__DAC_CRC_SIG_CONTROL_MASK__SHIFT                                             0x0
#define DAC_CRC_SIG_CONTROL_MASK__DAC_CRC_SIG_CONTROL_MASK_MASK                                               0x0000003FL
//DAC_CRC_SIG_RGB
#define DAC_CRC_SIG_RGB__DAC_CRC_SIG_BLUE__SHIFT                                                              0x0
#define DAC_CRC_SIG_RGB__DAC_CRC_SIG_GREEN__SHIFT                                                             0xa
#define DAC_CRC_SIG_RGB__DAC_CRC_SIG_RED__SHIFT                                                               0x14
#define DAC_CRC_SIG_RGB__DAC_CRC_SIG_BLUE_MASK                                                                0x000003FFL
#define DAC_CRC_SIG_RGB__DAC_CRC_SIG_GREEN_MASK                                                               0x000FFC00L
#define DAC_CRC_SIG_RGB__DAC_CRC_SIG_RED_MASK                                                                 0x3FF00000L
//DAC_CRC_SIG_CONTROL
#define DAC_CRC_SIG_CONTROL__DAC_CRC_SIG_CONTROL__SHIFT                                                       0x0
#define DAC_CRC_SIG_CONTROL__DAC_CRC_SIG_CONTROL_MASK                                                         0x0000003FL
//DAC_SYNC_TRISTATE_CONTROL
#define DAC_SYNC_TRISTATE_CONTROL__DAC_HSYNCA_TRISTATE__SHIFT                                                 0x0
#define DAC_SYNC_TRISTATE_CONTROL__DAC_VSYNCA_TRISTATE__SHIFT                                                 0x8
#define DAC_SYNC_TRISTATE_CONTROL__DAC_SYNCA_TRISTATE__SHIFT                                                  0x10
#define DAC_SYNC_TRISTATE_CONTROL__DAC_HSYNCA_TRISTATE_MASK                                                   0x00000001L
#define DAC_SYNC_TRISTATE_CONTROL__DAC_VSYNCA_TRISTATE_MASK                                                   0x00000100L
#define DAC_SYNC_TRISTATE_CONTROL__DAC_SYNCA_TRISTATE_MASK                                                    0x00010000L
//DAC_STEREOSYNC_SELECT
#define DAC_STEREOSYNC_SELECT__DAC_STEREOSYNC_SELECT__SHIFT                                                   0x0
#define DAC_STEREOSYNC_SELECT__DAC_STEREOSYNC_SELECT_MASK                                                     0x00000007L
//DAC_AUTODETECT_CONTROL
#define DAC_AUTODETECT_CONTROL__DAC_AUTODETECT_MODE__SHIFT                                                    0x0
#define DAC_AUTODETECT_CONTROL__DAC_AUTODETECT_FRAME_TIME_COUNTER__SHIFT                                      0x8
#define DAC_AUTODETECT_CONTROL__DAC_AUTODETECT_CHECK_MASK__SHIFT                                              0x10
#define DAC_AUTODETECT_CONTROL__DAC_AUTODETECT_MODE_MASK                                                      0x00000003L
#define DAC_AUTODETECT_CONTROL__DAC_AUTODETECT_FRAME_TIME_COUNTER_MASK                                        0x0000FF00L
#define DAC_AUTODETECT_CONTROL__DAC_AUTODETECT_CHECK_MASK_MASK                                                0x00070000L
//DAC_AUTODETECT_CONTROL2
#define DAC_AUTODETECT_CONTROL2__DAC_AUTODETECT_POWERUP_COUNTER__SHIFT                                        0x0
#define DAC_AUTODETECT_CONTROL2__DAC_AUTODETECT_TESTMODE__SHIFT                                               0x8
#define DAC_AUTODETECT_CONTROL2__DAC_AUTODETECT_POWERUP_COUNTER_MASK                                          0x000000FFL
#define DAC_AUTODETECT_CONTROL2__DAC_AUTODETECT_TESTMODE_MASK                                                 0x00000100L
//DAC_AUTODETECT_CONTROL3
#define DAC_AUTODETECT_CONTROL3__DAC_AUTODET_COMPARATOR_IN_DELAY__SHIFT                                       0x0
#define DAC_AUTODETECT_CONTROL3__DAC_AUTODET_COMPARATOR_OUT_DELAY__SHIFT                                      0x8
#define DAC_AUTODETECT_CONTROL3__DAC_AUTODET_COMPARATOR_IN_DELAY_MASK                                         0x000000FFL
#define DAC_AUTODETECT_CONTROL3__DAC_AUTODET_COMPARATOR_OUT_DELAY_MASK                                        0x0000FF00L
//DAC_AUTODETECT_STATUS
#define DAC_AUTODETECT_STATUS__DAC_AUTODETECT_STATUS__SHIFT                                                   0x0
#define DAC_AUTODETECT_STATUS__DAC_AUTODETECT_CONNECT__SHIFT                                                  0x4
#define DAC_AUTODETECT_STATUS__DAC_AUTODETECT_RED_SENSE__SHIFT                                                0x8
#define DAC_AUTODETECT_STATUS__DAC_AUTODETECT_GREEN_SENSE__SHIFT                                              0x10
#define DAC_AUTODETECT_STATUS__DAC_AUTODETECT_BLUE_SENSE__SHIFT                                               0x18
#define DAC_AUTODETECT_STATUS__DAC_AUTODETECT_STATUS_MASK                                                     0x00000001L
#define DAC_AUTODETECT_STATUS__DAC_AUTODETECT_CONNECT_MASK                                                    0x00000010L
#define DAC_AUTODETECT_STATUS__DAC_AUTODETECT_RED_SENSE_MASK                                                  0x00000300L
#define DAC_AUTODETECT_STATUS__DAC_AUTODETECT_GREEN_SENSE_MASK                                                0x00030000L
#define DAC_AUTODETECT_STATUS__DAC_AUTODETECT_BLUE_SENSE_MASK                                                 0x03000000L
//DAC_AUTODETECT_INT_CONTROL
#define DAC_AUTODETECT_INT_CONTROL__DAC_AUTODETECT_ACK__SHIFT                                                 0x0
#define DAC_AUTODETECT_INT_CONTROL__DAC_AUTODETECT_INT_ENABLE__SHIFT                                          0x10
#define DAC_AUTODETECT_INT_CONTROL__DAC_AUTODETECT_ACK_MASK                                                   0x00000001L
#define DAC_AUTODETECT_INT_CONTROL__DAC_AUTODETECT_INT_ENABLE_MASK                                            0x00010000L
//DAC_FORCE_OUTPUT_CNTL
#define DAC_FORCE_OUTPUT_CNTL__DAC_FORCE_DATA_EN__SHIFT                                                       0x0
#define DAC_FORCE_OUTPUT_CNTL__DAC_FORCE_DATA_SEL__SHIFT                                                      0x8
#define DAC_FORCE_OUTPUT_CNTL__DAC_FORCE_DATA_ON_BLANKB_ONLY__SHIFT                                           0x18
#define DAC_FORCE_OUTPUT_CNTL__DAC_FORCE_DATA_EN_MASK                                                         0x00000001L
#define DAC_FORCE_OUTPUT_CNTL__DAC_FORCE_DATA_SEL_MASK                                                        0x00000700L
#define DAC_FORCE_OUTPUT_CNTL__DAC_FORCE_DATA_ON_BLANKB_ONLY_MASK                                             0x01000000L
//DAC_FORCE_DATA
#define DAC_FORCE_DATA__DAC_FORCE_DATA__SHIFT                                                                 0x0
#define DAC_FORCE_DATA__DAC_FORCE_DATA_MASK                                                                   0x000003FFL
//DAC_POWERDOWN
#define DAC_POWERDOWN__DAC_POWERDOWN__SHIFT                                                                   0x0
#define DAC_POWERDOWN__DAC_POWERDOWN_BLUE__SHIFT                                                              0x8
#define DAC_POWERDOWN__DAC_POWERDOWN_GREEN__SHIFT                                                             0x10
#define DAC_POWERDOWN__DAC_POWERDOWN_RED__SHIFT                                                               0x18
#define DAC_POWERDOWN__DAC_POWERDOWN_MASK                                                                     0x00000001L
#define DAC_POWERDOWN__DAC_POWERDOWN_BLUE_MASK                                                                0x00000100L
#define DAC_POWERDOWN__DAC_POWERDOWN_GREEN_MASK                                                               0x00010000L
#define DAC_POWERDOWN__DAC_POWERDOWN_RED_MASK                                                                 0x01000000L
//DAC_CONTROL
#define DAC_CONTROL__DAC_DFORCE_EN__SHIFT                                                                     0x0
#define DAC_CONTROL__DAC_TV_ENABLE__SHIFT                                                                     0x8
#define DAC_CONTROL__DAC_ZSCALE_SHIFT__SHIFT                                                                  0x10
#define DAC_CONTROL__DAC_DFORCE_EN_MASK                                                                       0x00000001L
#define DAC_CONTROL__DAC_TV_ENABLE_MASK                                                                       0x00000100L
#define DAC_CONTROL__DAC_ZSCALE_SHIFT_MASK                                                                    0x00010000L
//DAC_COMPARATOR_ENABLE
#define DAC_COMPARATOR_ENABLE__DAC_COMP_DDET_REF_EN__SHIFT                                                    0x0
#define DAC_COMPARATOR_ENABLE__DAC_COMP_SDET_REF_EN__SHIFT                                                    0x8
#define DAC_COMPARATOR_ENABLE__DAC_R_ASYNC_ENABLE__SHIFT                                                      0x10
#define DAC_COMPARATOR_ENABLE__DAC_G_ASYNC_ENABLE__SHIFT                                                      0x11
#define DAC_COMPARATOR_ENABLE__DAC_B_ASYNC_ENABLE__SHIFT                                                      0x12
#define DAC_COMPARATOR_ENABLE__DAC_COMP_DDET_REF_EN_MASK                                                      0x00000001L
#define DAC_COMPARATOR_ENABLE__DAC_COMP_SDET_REF_EN_MASK                                                      0x00000100L
#define DAC_COMPARATOR_ENABLE__DAC_R_ASYNC_ENABLE_MASK                                                        0x00010000L
#define DAC_COMPARATOR_ENABLE__DAC_G_ASYNC_ENABLE_MASK                                                        0x00020000L
#define DAC_COMPARATOR_ENABLE__DAC_B_ASYNC_ENABLE_MASK                                                        0x00040000L
//DAC_COMPARATOR_OUTPUT
#define DAC_COMPARATOR_OUTPUT__DAC_COMPARATOR_OUTPUT__SHIFT                                                   0x0
#define DAC_COMPARATOR_OUTPUT__DAC_COMPARATOR_OUTPUT_BLUE__SHIFT                                              0x1
#define DAC_COMPARATOR_OUTPUT__DAC_COMPARATOR_OUTPUT_GREEN__SHIFT                                             0x2
#define DAC_COMPARATOR_OUTPUT__DAC_COMPARATOR_OUTPUT_RED__SHIFT                                               0x3
#define DAC_COMPARATOR_OUTPUT__DAC_COMPARATOR_OUTPUT_MASK                                                     0x00000001L
#define DAC_COMPARATOR_OUTPUT__DAC_COMPARATOR_OUTPUT_BLUE_MASK                                                0x00000002L
#define DAC_COMPARATOR_OUTPUT__DAC_COMPARATOR_OUTPUT_GREEN_MASK                                               0x00000004L
#define DAC_COMPARATOR_OUTPUT__DAC_COMPARATOR_OUTPUT_RED_MASK                                                 0x00000008L
//DAC_PWR_CNTL
#define DAC_PWR_CNTL__DAC_BG_MODE__SHIFT                                                                      0x0
#define DAC_PWR_CNTL__DAC_PWRCNTL__SHIFT                                                                      0x10
#define DAC_PWR_CNTL__DAC_BG_MODE_MASK                                                                        0x00000003L
#define DAC_PWR_CNTL__DAC_PWRCNTL_MASK                                                                        0x00030000L
//DAC_DFT_CONFIG
#define DAC_DFT_CONFIG__DAC_DFT_CONFIG__SHIFT                                                                 0x0
#define DAC_DFT_CONFIG__DAC_DFT_CONFIG_MASK                                                                   0xFFFFFFFFL
//DAC_FIFO_STATUS
#define DAC_FIFO_STATUS__DAC_FIFO_USE_OVERWRITE_LEVEL__SHIFT                                                  0x1
#define DAC_FIFO_STATUS__DAC_FIFO_OVERWRITE_LEVEL__SHIFT                                                      0x2
#define DAC_FIFO_STATUS__DAC_FIFO_CAL_AVERAGE_LEVEL__SHIFT                                                    0xa
#define DAC_FIFO_STATUS__DAC_FIFO_MAXIMUM_LEVEL__SHIFT                                                        0x10
#define DAC_FIFO_STATUS__DAC_FIFO_MINIMUM_LEVEL__SHIFT                                                        0x16
#define DAC_FIFO_STATUS__DAC_FIFO_CALIBRATED__SHIFT                                                           0x1d
#define DAC_FIFO_STATUS__DAC_FIFO_FORCE_RECAL_AVERAGE__SHIFT                                                  0x1e
#define DAC_FIFO_STATUS__DAC_FIFO_FORCE_RECOMP_MINMAX__SHIFT                                                  0x1f
#define DAC_FIFO_STATUS__DAC_FIFO_USE_OVERWRITE_LEVEL_MASK                                                    0x00000002L
#define DAC_FIFO_STATUS__DAC_FIFO_OVERWRITE_LEVEL_MASK                                                        0x000000FCL
#define DAC_FIFO_STATUS__DAC_FIFO_CAL_AVERAGE_LEVEL_MASK                                                      0x0000FC00L
#define DAC_FIFO_STATUS__DAC_FIFO_MAXIMUM_LEVEL_MASK                                                          0x000F0000L
#define DAC_FIFO_STATUS__DAC_FIFO_MINIMUM_LEVEL_MASK                                                          0x03C00000L
#define DAC_FIFO_STATUS__DAC_FIFO_CALIBRATED_MASK                                                             0x20000000L
#define DAC_FIFO_STATUS__DAC_FIFO_FORCE_RECAL_AVERAGE_MASK                                                    0x40000000L
#define DAC_FIFO_STATUS__DAC_FIFO_FORCE_RECOMP_MINMAX_MASK                                                    0x80000000L
//DC_I2C_CONTROL
#define DC_I2C_CONTROL__DC_I2C_GO__SHIFT                                                                      0x0
#define DC_I2C_CONTROL__DC_I2C_SOFT_RESET__SHIFT                                                              0x1
#define DC_I2C_CONTROL__DC_I2C_SEND_RESET__SHIFT                                                              0x2
#define DC_I2C_CONTROL__DC_I2C_SW_STATUS_RESET__SHIFT                                                         0x3
#define DC_I2C_CONTROL__DC_I2C_DDC_SELECT__SHIFT                                                              0x8
#define DC_I2C_CONTROL__DC_I2C_TRANSACTION_COUNT__SHIFT                                                       0x14
#define DC_I2C_CONTROL__DC_I2C_GO_MASK                                                                        0x00000001L
#define DC_I2C_CONTROL__DC_I2C_SOFT_RESET_MASK                                                                0x00000002L
#define DC_I2C_CONTROL__DC_I2C_SEND_RESET_MASK                                                                0x00000004L
#define DC_I2C_CONTROL__DC_I2C_SW_STATUS_RESET_MASK                                                           0x00000008L
#define DC_I2C_CONTROL__DC_I2C_DDC_SELECT_MASK                                                                0x00000700L
#define DC_I2C_CONTROL__DC_I2C_TRANSACTION_COUNT_MASK                                                         0x00300000L
//DC_I2C_ARBITRATION
#define DC_I2C_ARBITRATION__DC_I2C_SW_PRIORITY__SHIFT                                                         0x0
#define DC_I2C_ARBITRATION__DC_I2C_REG_RW_CNTL_STATUS__SHIFT                                                  0x2
#define DC_I2C_ARBITRATION__DC_I2C_NO_QUEUED_SW_GO__SHIFT                                                     0x4
#define DC_I2C_ARBITRATION__DC_I2C_ABORT_HW_XFER__SHIFT                                                       0x8
#define DC_I2C_ARBITRATION__DC_I2C_ABORT_SW_XFER__SHIFT                                                       0xc
#define DC_I2C_ARBITRATION__DC_I2C_SW_USE_I2C_REG_REQ__SHIFT                                                  0x14
#define DC_I2C_ARBITRATION__DC_I2C_SW_DONE_USING_I2C_REG__SHIFT                                               0x15
#define DC_I2C_ARBITRATION__DC_I2C_DMCU_USE_I2C_REG_REQ__SHIFT                                                0x18
#define DC_I2C_ARBITRATION__DC_I2C_DMCU_DONE_USING_I2C_REG__SHIFT                                             0x19
#define DC_I2C_ARBITRATION__DC_I2C_SW_PRIORITY_MASK                                                           0x00000003L
#define DC_I2C_ARBITRATION__DC_I2C_REG_RW_CNTL_STATUS_MASK                                                    0x0000000CL
#define DC_I2C_ARBITRATION__DC_I2C_NO_QUEUED_SW_GO_MASK                                                       0x00000010L
#define DC_I2C_ARBITRATION__DC_I2C_ABORT_HW_XFER_MASK                                                         0x00000100L
#define DC_I2C_ARBITRATION__DC_I2C_ABORT_SW_XFER_MASK                                                         0x00001000L
#define DC_I2C_ARBITRATION__DC_I2C_SW_USE_I2C_REG_REQ_MASK                                                    0x00100000L
#define DC_I2C_ARBITRATION__DC_I2C_SW_DONE_USING_I2C_REG_MASK                                                 0x00200000L
#define DC_I2C_ARBITRATION__DC_I2C_DMCU_USE_I2C_REG_REQ_MASK                                                  0x01000000L
#define DC_I2C_ARBITRATION__DC_I2C_DMCU_DONE_USING_I2C_REG_MASK                                               0x02000000L
//DC_I2C_INTERRUPT_CONTROL
#define DC_I2C_INTERRUPT_CONTROL__DC_I2C_SW_DONE_INT__SHIFT                                                   0x0
#define DC_I2C_INTERRUPT_CONTROL__DC_I2C_SW_DONE_ACK__SHIFT                                                   0x1
#define DC_I2C_INTERRUPT_CONTROL__DC_I2C_SW_DONE_MASK__SHIFT                                                  0x2
#define DC_I2C_INTERRUPT_CONTROL__DC_I2C_DDC1_HW_DONE_INT__SHIFT                                              0x4
#define DC_I2C_INTERRUPT_CONTROL__DC_I2C_DDC1_HW_DONE_ACK__SHIFT                                              0x5
#define DC_I2C_INTERRUPT_CONTROL__DC_I2C_DDC1_HW_DONE_MASK__SHIFT                                             0x6
#define DC_I2C_INTERRUPT_CONTROL__DC_I2C_DDC2_HW_DONE_INT__SHIFT                                              0x8
#define DC_I2C_INTERRUPT_CONTROL__DC_I2C_DDC2_HW_DONE_ACK__SHIFT                                              0x9
#define DC_I2C_INTERRUPT_CONTROL__DC_I2C_DDC2_HW_DONE_MASK__SHIFT                                             0xa
#define DC_I2C_INTERRUPT_CONTROL__DC_I2C_DDC3_HW_DONE_INT__SHIFT                                              0xc
#define DC_I2C_INTERRUPT_CONTROL__DC_I2C_DDC3_HW_DONE_ACK__SHIFT                                              0xd
#define DC_I2C_INTERRUPT_CONTROL__DC_I2C_DDC3_HW_DONE_MASK__SHIFT                                             0xe
#define DC_I2C_INTERRUPT_CONTROL__DC_I2C_DDC4_HW_DONE_INT__SHIFT                                              0x10
#define DC_I2C_INTERRUPT_CONTROL__DC_I2C_DDC4_HW_DONE_ACK__SHIFT                                              0x11
#define DC_I2C_INTERRUPT_CONTROL__DC_I2C_DDC4_HW_DONE_MASK__SHIFT                                             0x12
#define DC_I2C_INTERRUPT_CONTROL__DC_I2C_DDC5_HW_DONE_INT__SHIFT                                              0x14
#define DC_I2C_INTERRUPT_CONTROL__DC_I2C_DDC5_HW_DONE_ACK__SHIFT                                              0x15
#define DC_I2C_INTERRUPT_CONTROL__DC_I2C_DDC5_HW_DONE_MASK__SHIFT                                             0x16
#define DC_I2C_INTERRUPT_CONTROL__DC_I2C_DDC6_HW_DONE_INT__SHIFT                                              0x18
#define DC_I2C_INTERRUPT_CONTROL__DC_I2C_DDC6_HW_DONE_ACK__SHIFT                                              0x19
#define DC_I2C_INTERRUPT_CONTROL__DC_I2C_DDC6_HW_DONE_MASK__SHIFT                                             0x1a
#define DC_I2C_INTERRUPT_CONTROL__DC_I2C_DDCVGA_HW_DONE_INT__SHIFT                                            0x1b
#define DC_I2C_INTERRUPT_CONTROL__DC_I2C_DDCVGA_HW_DONE_ACK__SHIFT                                            0x1c
#define DC_I2C_INTERRUPT_CONTROL__DC_I2C_DDCVGA_HW_DONE_MASK__SHIFT                                           0x1d
#define DC_I2C_INTERRUPT_CONTROL__DC_I2C_SW_DONE_INT_MASK                                                     0x00000001L
#define DC_I2C_INTERRUPT_CONTROL__DC_I2C_SW_DONE_ACK_MASK                                                     0x00000002L
#define DC_I2C_INTERRUPT_CONTROL__DC_I2C_SW_DONE_MASK_MASK                                                    0x00000004L
#define DC_I2C_INTERRUPT_CONTROL__DC_I2C_DDC1_HW_DONE_INT_MASK                                                0x00000010L
#define DC_I2C_INTERRUPT_CONTROL__DC_I2C_DDC1_HW_DONE_ACK_MASK                                                0x00000020L
#define DC_I2C_INTERRUPT_CONTROL__DC_I2C_DDC1_HW_DONE_MASK_MASK                                               0x00000040L
#define DC_I2C_INTERRUPT_CONTROL__DC_I2C_DDC2_HW_DONE_INT_MASK                                                0x00000100L
#define DC_I2C_INTERRUPT_CONTROL__DC_I2C_DDC2_HW_DONE_ACK_MASK                                                0x00000200L
#define DC_I2C_INTERRUPT_CONTROL__DC_I2C_DDC2_HW_DONE_MASK_MASK                                               0x00000400L
#define DC_I2C_INTERRUPT_CONTROL__DC_I2C_DDC3_HW_DONE_INT_MASK                                                0x00001000L
#define DC_I2C_INTERRUPT_CONTROL__DC_I2C_DDC3_HW_DONE_ACK_MASK                                                0x00002000L
#define DC_I2C_INTERRUPT_CONTROL__DC_I2C_DDC3_HW_DONE_MASK_MASK                                               0x00004000L
#define DC_I2C_INTERRUPT_CONTROL__DC_I2C_DDC4_HW_DONE_INT_MASK                                                0x00010000L
#define DC_I2C_INTERRUPT_CONTROL__DC_I2C_DDC4_HW_DONE_ACK_MASK                                                0x00020000L
#define DC_I2C_INTERRUPT_CONTROL__DC_I2C_DDC4_HW_DONE_MASK_MASK                                               0x00040000L
#define DC_I2C_INTERRUPT_CONTROL__DC_I2C_DDC5_HW_DONE_INT_MASK                                                0x00100000L
#define DC_I2C_INTERRUPT_CONTROL__DC_I2C_DDC5_HW_DONE_ACK_MASK                                                0x00200000L
#define DC_I2C_INTERRUPT_CONTROL__DC_I2C_DDC5_HW_DONE_MASK_MASK                                               0x00400000L
#define DC_I2C_INTERRUPT_CONTROL__DC_I2C_DDC6_HW_DONE_INT_MASK                                                0x01000000L
#define DC_I2C_INTERRUPT_CONTROL__DC_I2C_DDC6_HW_DONE_ACK_MASK                                                0x02000000L
#define DC_I2C_INTERRUPT_CONTROL__DC_I2C_DDC6_HW_DONE_MASK_MASK                                               0x04000000L
#define DC_I2C_INTERRUPT_CONTROL__DC_I2C_DDCVGA_HW_DONE_INT_MASK                                              0x08000000L
#define DC_I2C_INTERRUPT_CONTROL__DC_I2C_DDCVGA_HW_DONE_ACK_MASK                                              0x10000000L
#define DC_I2C_INTERRUPT_CONTROL__DC_I2C_DDCVGA_HW_DONE_MASK_MASK                                             0x20000000L
//DC_I2C_SW_STATUS
#define DC_I2C_SW_STATUS__DC_I2C_SW_STATUS__SHIFT                                                             0x0
#define DC_I2C_SW_STATUS__DC_I2C_SW_DONE__SHIFT                                                               0x2
#define DC_I2C_SW_STATUS__DC_I2C_SW_ABORTED__SHIFT                                                            0x4
#define DC_I2C_SW_STATUS__DC_I2C_SW_TIMEOUT__SHIFT                                                            0x5
#define DC_I2C_SW_STATUS__DC_I2C_SW_INTERRUPTED__SHIFT                                                        0x6
#define DC_I2C_SW_STATUS__DC_I2C_SW_BUFFER_OVERFLOW__SHIFT                                                    0x7
#define DC_I2C_SW_STATUS__DC_I2C_SW_STOPPED_ON_NACK__SHIFT                                                    0x8
#define DC_I2C_SW_STATUS__DC_I2C_SW_NACK0__SHIFT                                                              0xc
#define DC_I2C_SW_STATUS__DC_I2C_SW_NACK1__SHIFT                                                              0xd
#define DC_I2C_SW_STATUS__DC_I2C_SW_NACK2__SHIFT                                                              0xe
#define DC_I2C_SW_STATUS__DC_I2C_SW_NACK3__SHIFT                                                              0xf
#define DC_I2C_SW_STATUS__DC_I2C_SW_REQ__SHIFT                                                                0x12
#define DC_I2C_SW_STATUS__DC_I2C_SW_STATUS_MASK                                                               0x00000003L
#define DC_I2C_SW_STATUS__DC_I2C_SW_DONE_MASK                                                                 0x00000004L
#define DC_I2C_SW_STATUS__DC_I2C_SW_ABORTED_MASK                                                              0x00000010L
#define DC_I2C_SW_STATUS__DC_I2C_SW_TIMEOUT_MASK                                                              0x00000020L
#define DC_I2C_SW_STATUS__DC_I2C_SW_INTERRUPTED_MASK                                                          0x00000040L
#define DC_I2C_SW_STATUS__DC_I2C_SW_BUFFER_OVERFLOW_MASK                                                      0x00000080L
#define DC_I2C_SW_STATUS__DC_I2C_SW_STOPPED_ON_NACK_MASK                                                      0x00000100L
#define DC_I2C_SW_STATUS__DC_I2C_SW_NACK0_MASK                                                                0x00001000L
#define DC_I2C_SW_STATUS__DC_I2C_SW_NACK1_MASK                                                                0x00002000L
#define DC_I2C_SW_STATUS__DC_I2C_SW_NACK2_MASK                                                                0x00004000L
#define DC_I2C_SW_STATUS__DC_I2C_SW_NACK3_MASK                                                                0x00008000L
#define DC_I2C_SW_STATUS__DC_I2C_SW_REQ_MASK                                                                  0x00040000L
//DC_I2C_DDC1_HW_STATUS
#define DC_I2C_DDC1_HW_STATUS__DC_I2C_DDC1_HW_STATUS__SHIFT                                                   0x0
#define DC_I2C_DDC1_HW_STATUS__DC_I2C_DDC1_HW_DONE__SHIFT                                                     0x3
#define DC_I2C_DDC1_HW_STATUS__DC_I2C_DDC1_HW_REQ__SHIFT                                                      0x10
#define DC_I2C_DDC1_HW_STATUS__DC_I2C_DDC1_HW_URG__SHIFT                                                      0x11
#define DC_I2C_DDC1_HW_STATUS__DC_I2C_DDC1_EDID_DETECT_STATUS__SHIFT                                          0x14
#define DC_I2C_DDC1_HW_STATUS__DC_I2C_DDC1_EDID_DETECT_NUM_VALID_TRIES__SHIFT                                 0x18
#define DC_I2C_DDC1_HW_STATUS__DC_I2C_DDC1_EDID_DETECT_STATE__SHIFT                                           0x1c
#define DC_I2C_DDC1_HW_STATUS__DC_I2C_DDC1_HW_STATUS_MASK                                                     0x00000003L
#define DC_I2C_DDC1_HW_STATUS__DC_I2C_DDC1_HW_DONE_MASK                                                       0x00000008L
#define DC_I2C_DDC1_HW_STATUS__DC_I2C_DDC1_HW_REQ_MASK                                                        0x00010000L
#define DC_I2C_DDC1_HW_STATUS__DC_I2C_DDC1_HW_URG_MASK                                                        0x00020000L
#define DC_I2C_DDC1_HW_STATUS__DC_I2C_DDC1_EDID_DETECT_STATUS_MASK                                            0x00100000L
#define DC_I2C_DDC1_HW_STATUS__DC_I2C_DDC1_EDID_DETECT_NUM_VALID_TRIES_MASK                                   0x0F000000L
#define DC_I2C_DDC1_HW_STATUS__DC_I2C_DDC1_EDID_DETECT_STATE_MASK                                             0x70000000L
//DC_I2C_DDC2_HW_STATUS
#define DC_I2C_DDC2_HW_STATUS__DC_I2C_DDC2_HW_STATUS__SHIFT                                                   0x0
#define DC_I2C_DDC2_HW_STATUS__DC_I2C_DDC2_HW_DONE__SHIFT                                                     0x3
#define DC_I2C_DDC2_HW_STATUS__DC_I2C_DDC2_HW_REQ__SHIFT                                                      0x10
#define DC_I2C_DDC2_HW_STATUS__DC_I2C_DDC2_HW_URG__SHIFT                                                      0x11
#define DC_I2C_DDC2_HW_STATUS__DC_I2C_DDC2_EDID_DETECT_STATUS__SHIFT                                          0x14
#define DC_I2C_DDC2_HW_STATUS__DC_I2C_DDC2_EDID_DETECT_NUM_VALID_TRIES__SHIFT                                 0x18
#define DC_I2C_DDC2_HW_STATUS__DC_I2C_DDC2_EDID_DETECT_STATE__SHIFT                                           0x1c
#define DC_I2C_DDC2_HW_STATUS__DC_I2C_DDC2_HW_STATUS_MASK                                                     0x00000003L
#define DC_I2C_DDC2_HW_STATUS__DC_I2C_DDC2_HW_DONE_MASK                                                       0x00000008L
#define DC_I2C_DDC2_HW_STATUS__DC_I2C_DDC2_HW_REQ_MASK                                                        0x00010000L
#define DC_I2C_DDC2_HW_STATUS__DC_I2C_DDC2_HW_URG_MASK                                                        0x00020000L
#define DC_I2C_DDC2_HW_STATUS__DC_I2C_DDC2_EDID_DETECT_STATUS_MASK                                            0x00100000L
#define DC_I2C_DDC2_HW_STATUS__DC_I2C_DDC2_EDID_DETECT_NUM_VALID_TRIES_MASK                                   0x0F000000L
#define DC_I2C_DDC2_HW_STATUS__DC_I2C_DDC2_EDID_DETECT_STATE_MASK                                             0x70000000L
//DC_I2C_DDC3_HW_STATUS
#define DC_I2C_DDC3_HW_STATUS__DC_I2C_DDC3_HW_STATUS__SHIFT                                                   0x0
#define DC_I2C_DDC3_HW_STATUS__DC_I2C_DDC3_HW_DONE__SHIFT                                                     0x3
#define DC_I2C_DDC3_HW_STATUS__DC_I2C_DDC3_HW_REQ__SHIFT                                                      0x10
#define DC_I2C_DDC3_HW_STATUS__DC_I2C_DDC3_HW_URG__SHIFT                                                      0x11
#define DC_I2C_DDC3_HW_STATUS__DC_I2C_DDC3_EDID_DETECT_STATUS__SHIFT                                          0x14
#define DC_I2C_DDC3_HW_STATUS__DC_I2C_DDC3_EDID_DETECT_NUM_VALID_TRIES__SHIFT                                 0x18
#define DC_I2C_DDC3_HW_STATUS__DC_I2C_DDC3_EDID_DETECT_STATE__SHIFT                                           0x1c
#define DC_I2C_DDC3_HW_STATUS__DC_I2C_DDC3_HW_STATUS_MASK                                                     0x00000003L
#define DC_I2C_DDC3_HW_STATUS__DC_I2C_DDC3_HW_DONE_MASK                                                       0x00000008L
#define DC_I2C_DDC3_HW_STATUS__DC_I2C_DDC3_HW_REQ_MASK                                                        0x00010000L
#define DC_I2C_DDC3_HW_STATUS__DC_I2C_DDC3_HW_URG_MASK                                                        0x00020000L
#define DC_I2C_DDC3_HW_STATUS__DC_I2C_DDC3_EDID_DETECT_STATUS_MASK                                            0x00100000L
#define DC_I2C_DDC3_HW_STATUS__DC_I2C_DDC3_EDID_DETECT_NUM_VALID_TRIES_MASK                                   0x0F000000L
#define DC_I2C_DDC3_HW_STATUS__DC_I2C_DDC3_EDID_DETECT_STATE_MASK                                             0x70000000L
//DC_I2C_DDC4_HW_STATUS
#define DC_I2C_DDC4_HW_STATUS__DC_I2C_DDC4_HW_STATUS__SHIFT                                                   0x0
#define DC_I2C_DDC4_HW_STATUS__DC_I2C_DDC4_HW_DONE__SHIFT                                                     0x3
#define DC_I2C_DDC4_HW_STATUS__DC_I2C_DDC4_HW_REQ__SHIFT                                                      0x10
#define DC_I2C_DDC4_HW_STATUS__DC_I2C_DDC4_HW_URG__SHIFT                                                      0x11
#define DC_I2C_DDC4_HW_STATUS__DC_I2C_DDC4_EDID_DETECT_STATUS__SHIFT                                          0x14
#define DC_I2C_DDC4_HW_STATUS__DC_I2C_DDC4_EDID_DETECT_NUM_VALID_TRIES__SHIFT                                 0x18
#define DC_I2C_DDC4_HW_STATUS__DC_I2C_DDC4_EDID_DETECT_STATE__SHIFT                                           0x1c
#define DC_I2C_DDC4_HW_STATUS__DC_I2C_DDC4_HW_STATUS_MASK                                                     0x00000003L
#define DC_I2C_DDC4_HW_STATUS__DC_I2C_DDC4_HW_DONE_MASK                                                       0x00000008L
#define DC_I2C_DDC4_HW_STATUS__DC_I2C_DDC4_HW_REQ_MASK                                                        0x00010000L
#define DC_I2C_DDC4_HW_STATUS__DC_I2C_DDC4_HW_URG_MASK                                                        0x00020000L
#define DC_I2C_DDC4_HW_STATUS__DC_I2C_DDC4_EDID_DETECT_STATUS_MASK                                            0x00100000L
#define DC_I2C_DDC4_HW_STATUS__DC_I2C_DDC4_EDID_DETECT_NUM_VALID_TRIES_MASK                                   0x0F000000L
#define DC_I2C_DDC4_HW_STATUS__DC_I2C_DDC4_EDID_DETECT_STATE_MASK                                             0x70000000L
//DC_I2C_DDC5_HW_STATUS
#define DC_I2C_DDC5_HW_STATUS__DC_I2C_DDC5_HW_STATUS__SHIFT                                                   0x0
#define DC_I2C_DDC5_HW_STATUS__DC_I2C_DDC5_HW_DONE__SHIFT                                                     0x3
#define DC_I2C_DDC5_HW_STATUS__DC_I2C_DDC5_HW_REQ__SHIFT                                                      0x10
#define DC_I2C_DDC5_HW_STATUS__DC_I2C_DDC5_HW_URG__SHIFT                                                      0x11
#define DC_I2C_DDC5_HW_STATUS__DC_I2C_DDC5_EDID_DETECT_STATUS__SHIFT                                          0x14
#define DC_I2C_DDC5_HW_STATUS__DC_I2C_DDC5_EDID_DETECT_NUM_VALID_TRIES__SHIFT                                 0x18
#define DC_I2C_DDC5_HW_STATUS__DC_I2C_DDC5_EDID_DETECT_STATE__SHIFT                                           0x1c
#define DC_I2C_DDC5_HW_STATUS__DC_I2C_DDC5_HW_STATUS_MASK                                                     0x00000003L
#define DC_I2C_DDC5_HW_STATUS__DC_I2C_DDC5_HW_DONE_MASK                                                       0x00000008L
#define DC_I2C_DDC5_HW_STATUS__DC_I2C_DDC5_HW_REQ_MASK                                                        0x00010000L
#define DC_I2C_DDC5_HW_STATUS__DC_I2C_DDC5_HW_URG_MASK                                                        0x00020000L
#define DC_I2C_DDC5_HW_STATUS__DC_I2C_DDC5_EDID_DETECT_STATUS_MASK                                            0x00100000L
#define DC_I2C_DDC5_HW_STATUS__DC_I2C_DDC5_EDID_DETECT_NUM_VALID_TRIES_MASK                                   0x0F000000L
#define DC_I2C_DDC5_HW_STATUS__DC_I2C_DDC5_EDID_DETECT_STATE_MASK                                             0x70000000L
//DC_I2C_DDC6_HW_STATUS
#define DC_I2C_DDC6_HW_STATUS__DC_I2C_DDC6_HW_STATUS__SHIFT                                                   0x0
#define DC_I2C_DDC6_HW_STATUS__DC_I2C_DDC6_HW_DONE__SHIFT                                                     0x3
#define DC_I2C_DDC6_HW_STATUS__DC_I2C_DDC6_HW_REQ__SHIFT                                                      0x10
#define DC_I2C_DDC6_HW_STATUS__DC_I2C_DDC6_HW_URG__SHIFT                                                      0x11
#define DC_I2C_DDC6_HW_STATUS__DC_I2C_DDC6_EDID_DETECT_STATUS__SHIFT                                          0x14
#define DC_I2C_DDC6_HW_STATUS__DC_I2C_DDC6_EDID_DETECT_NUM_VALID_TRIES__SHIFT                                 0x18
#define DC_I2C_DDC6_HW_STATUS__DC_I2C_DDC6_EDID_DETECT_STATE__SHIFT                                           0x1c
#define DC_I2C_DDC6_HW_STATUS__DC_I2C_DDC6_HW_STATUS_MASK                                                     0x00000003L
#define DC_I2C_DDC6_HW_STATUS__DC_I2C_DDC6_HW_DONE_MASK                                                       0x00000008L
#define DC_I2C_DDC6_HW_STATUS__DC_I2C_DDC6_HW_REQ_MASK                                                        0x00010000L
#define DC_I2C_DDC6_HW_STATUS__DC_I2C_DDC6_HW_URG_MASK                                                        0x00020000L
#define DC_I2C_DDC6_HW_STATUS__DC_I2C_DDC6_EDID_DETECT_STATUS_MASK                                            0x00100000L
#define DC_I2C_DDC6_HW_STATUS__DC_I2C_DDC6_EDID_DETECT_NUM_VALID_TRIES_MASK                                   0x0F000000L
#define DC_I2C_DDC6_HW_STATUS__DC_I2C_DDC6_EDID_DETECT_STATE_MASK                                             0x70000000L
//DC_I2C_DDC1_SPEED
#define DC_I2C_DDC1_SPEED__DC_I2C_DDC1_THRESHOLD__SHIFT                                                       0x0
#define DC_I2C_DDC1_SPEED__DC_I2C_DDC1_DISABLE_FILTER_DURING_STALL__SHIFT                                     0x4
#define DC_I2C_DDC1_SPEED__DC_I2C_DDC1_START_STOP_TIMING_CNTL__SHIFT                                          0x8
#define DC_I2C_DDC1_SPEED__DC_I2C_DDC1_PRESCALE__SHIFT                                                        0x10
#define DC_I2C_DDC1_SPEED__DC_I2C_DDC1_THRESHOLD_MASK                                                         0x00000003L
#define DC_I2C_DDC1_SPEED__DC_I2C_DDC1_DISABLE_FILTER_DURING_STALL_MASK                                       0x00000010L
#define DC_I2C_DDC1_SPEED__DC_I2C_DDC1_START_STOP_TIMING_CNTL_MASK                                            0x00000300L
#define DC_I2C_DDC1_SPEED__DC_I2C_DDC1_PRESCALE_MASK                                                          0xFFFF0000L
//DC_I2C_DDC1_SETUP
#define DC_I2C_DDC1_SETUP__DC_I2C_DDC1_DATA_DRIVE_EN__SHIFT                                                   0x0
#define DC_I2C_DDC1_SETUP__DC_I2C_DDC1_DATA_DRIVE_SEL__SHIFT                                                  0x1
#define DC_I2C_DDC1_SETUP__DC_I2C_DDC1_EDID_DETECT_ENABLE__SHIFT                                              0x4
#define DC_I2C_DDC1_SETUP__DC_I2C_DDC1_EDID_DETECT_MODE__SHIFT                                                0x5
#define DC_I2C_DDC1_SETUP__DC_I2C_DDC1_ENABLE__SHIFT                                                          0x6
#define DC_I2C_DDC1_SETUP__DC_I2C_DDC1_CLK_DRIVE_EN__SHIFT                                                    0x7
#define DC_I2C_DDC1_SETUP__DC_I2C_DDC1_INTRA_BYTE_DELAY__SHIFT                                                0x8
#define DC_I2C_DDC1_SETUP__DC_I2C_DDC1_INTRA_TRANSACTION_DELAY__SHIFT                                         0x10
#define DC_I2C_DDC1_SETUP__DC_I2C_DDC1_TIME_LIMIT__SHIFT                                                      0x18
#define DC_I2C_DDC1_SETUP__DC_I2C_DDC1_DATA_DRIVE_EN_MASK                                                     0x00000001L
#define DC_I2C_DDC1_SETUP__DC_I2C_DDC1_DATA_DRIVE_SEL_MASK                                                    0x00000002L
#define DC_I2C_DDC1_SETUP__DC_I2C_DDC1_EDID_DETECT_ENABLE_MASK                                                0x00000010L
#define DC_I2C_DDC1_SETUP__DC_I2C_DDC1_EDID_DETECT_MODE_MASK                                                  0x00000020L
#define DC_I2C_DDC1_SETUP__DC_I2C_DDC1_ENABLE_MASK                                                            0x00000040L
#define DC_I2C_DDC1_SETUP__DC_I2C_DDC1_CLK_DRIVE_EN_MASK                                                      0x00000080L
#define DC_I2C_DDC1_SETUP__DC_I2C_DDC1_INTRA_BYTE_DELAY_MASK                                                  0x0000FF00L
#define DC_I2C_DDC1_SETUP__DC_I2C_DDC1_INTRA_TRANSACTION_DELAY_MASK                                           0x00FF0000L
#define DC_I2C_DDC1_SETUP__DC_I2C_DDC1_TIME_LIMIT_MASK                                                        0xFF000000L
//DC_I2C_DDC2_SPEED
#define DC_I2C_DDC2_SPEED__DC_I2C_DDC2_THRESHOLD__SHIFT                                                       0x0
#define DC_I2C_DDC2_SPEED__DC_I2C_DDC2_DISABLE_FILTER_DURING_STALL__SHIFT                                     0x4
#define DC_I2C_DDC2_SPEED__DC_I2C_DDC2_START_STOP_TIMING_CNTL__SHIFT                                          0x8
#define DC_I2C_DDC2_SPEED__DC_I2C_DDC2_PRESCALE__SHIFT                                                        0x10
#define DC_I2C_DDC2_SPEED__DC_I2C_DDC2_THRESHOLD_MASK                                                         0x00000003L
#define DC_I2C_DDC2_SPEED__DC_I2C_DDC2_DISABLE_FILTER_DURING_STALL_MASK                                       0x00000010L
#define DC_I2C_DDC2_SPEED__DC_I2C_DDC2_START_STOP_TIMING_CNTL_MASK                                            0x00000300L
#define DC_I2C_DDC2_SPEED__DC_I2C_DDC2_PRESCALE_MASK                                                          0xFFFF0000L
//DC_I2C_DDC2_SETUP
#define DC_I2C_DDC2_SETUP__DC_I2C_DDC2_DATA_DRIVE_EN__SHIFT                                                   0x0
#define DC_I2C_DDC2_SETUP__DC_I2C_DDC2_DATA_DRIVE_SEL__SHIFT                                                  0x1
#define DC_I2C_DDC2_SETUP__DC_I2C_DDC2_EDID_DETECT_ENABLE__SHIFT                                              0x4
#define DC_I2C_DDC2_SETUP__DC_I2C_DDC2_EDID_DETECT_MODE__SHIFT                                                0x5
#define DC_I2C_DDC2_SETUP__DC_I2C_DDC2_ENABLE__SHIFT                                                          0x6
#define DC_I2C_DDC2_SETUP__DC_I2C_DDC2_CLK_DRIVE_EN__SHIFT                                                    0x7
#define DC_I2C_DDC2_SETUP__DC_I2C_DDC2_INTRA_BYTE_DELAY__SHIFT                                                0x8
#define DC_I2C_DDC2_SETUP__DC_I2C_DDC2_INTRA_TRANSACTION_DELAY__SHIFT                                         0x10
#define DC_I2C_DDC2_SETUP__DC_I2C_DDC2_TIME_LIMIT__SHIFT                                                      0x18
#define DC_I2C_DDC2_SETUP__DC_I2C_DDC2_DATA_DRIVE_EN_MASK                                                     0x00000001L
#define DC_I2C_DDC2_SETUP__DC_I2C_DDC2_DATA_DRIVE_SEL_MASK                                                    0x00000002L
#define DC_I2C_DDC2_SETUP__DC_I2C_DDC2_EDID_DETECT_ENABLE_MASK                                                0x00000010L
#define DC_I2C_DDC2_SETUP__DC_I2C_DDC2_EDID_DETECT_MODE_MASK                                                  0x00000020L
#define DC_I2C_DDC2_SETUP__DC_I2C_DDC2_ENABLE_MASK                                                            0x00000040L
#define DC_I2C_DDC2_SETUP__DC_I2C_DDC2_CLK_DRIVE_EN_MASK                                                      0x00000080L
#define DC_I2C_DDC2_SETUP__DC_I2C_DDC2_INTRA_BYTE_DELAY_MASK                                                  0x0000FF00L
#define DC_I2C_DDC2_SETUP__DC_I2C_DDC2_INTRA_TRANSACTION_DELAY_MASK                                           0x00FF0000L
#define DC_I2C_DDC2_SETUP__DC_I2C_DDC2_TIME_LIMIT_MASK                                                        0xFF000000L
//DC_I2C_DDC3_SPEED
#define DC_I2C_DDC3_SPEED__DC_I2C_DDC3_THRESHOLD__SHIFT                                                       0x0
#define DC_I2C_DDC3_SPEED__DC_I2C_DDC3_DISABLE_FILTER_DURING_STALL__SHIFT                                     0x4
#define DC_I2C_DDC3_SPEED__DC_I2C_DDC3_START_STOP_TIMING_CNTL__SHIFT                                          0x8
#define DC_I2C_DDC3_SPEED__DC_I2C_DDC3_PRESCALE__SHIFT                                                        0x10
#define DC_I2C_DDC3_SPEED__DC_I2C_DDC3_THRESHOLD_MASK                                                         0x00000003L
#define DC_I2C_DDC3_SPEED__DC_I2C_DDC3_DISABLE_FILTER_DURING_STALL_MASK                                       0x00000010L
#define DC_I2C_DDC3_SPEED__DC_I2C_DDC3_START_STOP_TIMING_CNTL_MASK                                            0x00000300L
#define DC_I2C_DDC3_SPEED__DC_I2C_DDC3_PRESCALE_MASK                                                          0xFFFF0000L
//DC_I2C_DDC3_SETUP
#define DC_I2C_DDC3_SETUP__DC_I2C_DDC3_DATA_DRIVE_EN__SHIFT                                                   0x0
#define DC_I2C_DDC3_SETUP__DC_I2C_DDC3_DATA_DRIVE_SEL__SHIFT                                                  0x1
#define DC_I2C_DDC3_SETUP__DC_I2C_DDC3_EDID_DETECT_ENABLE__SHIFT                                              0x4
#define DC_I2C_DDC3_SETUP__DC_I2C_DDC3_EDID_DETECT_MODE__SHIFT                                                0x5
#define DC_I2C_DDC3_SETUP__DC_I2C_DDC3_ENABLE__SHIFT                                                          0x6
#define DC_I2C_DDC3_SETUP__DC_I2C_DDC3_CLK_DRIVE_EN__SHIFT                                                    0x7
#define DC_I2C_DDC3_SETUP__DC_I2C_DDC3_INTRA_BYTE_DELAY__SHIFT                                                0x8
#define DC_I2C_DDC3_SETUP__DC_I2C_DDC3_INTRA_TRANSACTION_DELAY__SHIFT                                         0x10
#define DC_I2C_DDC3_SETUP__DC_I2C_DDC3_TIME_LIMIT__SHIFT                                                      0x18
#define DC_I2C_DDC3_SETUP__DC_I2C_DDC3_DATA_DRIVE_EN_MASK                                                     0x00000001L
#define DC_I2C_DDC3_SETUP__DC_I2C_DDC3_DATA_DRIVE_SEL_MASK                                                    0x00000002L
#define DC_I2C_DDC3_SETUP__DC_I2C_DDC3_EDID_DETECT_ENABLE_MASK                                                0x00000010L
#define DC_I2C_DDC3_SETUP__DC_I2C_DDC3_EDID_DETECT_MODE_MASK                                                  0x00000020L
#define DC_I2C_DDC3_SETUP__DC_I2C_DDC3_ENABLE_MASK                                                            0x00000040L
#define DC_I2C_DDC3_SETUP__DC_I2C_DDC3_CLK_DRIVE_EN_MASK                                                      0x00000080L
#define DC_I2C_DDC3_SETUP__DC_I2C_DDC3_INTRA_BYTE_DELAY_MASK                                                  0x0000FF00L
#define DC_I2C_DDC3_SETUP__DC_I2C_DDC3_INTRA_TRANSACTION_DELAY_MASK                                           0x00FF0000L
#define DC_I2C_DDC3_SETUP__DC_I2C_DDC3_TIME_LIMIT_MASK                                                        0xFF000000L
//DC_I2C_DDC4_SPEED
#define DC_I2C_DDC4_SPEED__DC_I2C_DDC4_THRESHOLD__SHIFT                                                       0x0
#define DC_I2C_DDC4_SPEED__DC_I2C_DDC4_DISABLE_FILTER_DURING_STALL__SHIFT                                     0x4
#define DC_I2C_DDC4_SPEED__DC_I2C_DDC4_START_STOP_TIMING_CNTL__SHIFT                                          0x8
#define DC_I2C_DDC4_SPEED__DC_I2C_DDC4_PRESCALE__SHIFT                                                        0x10
#define DC_I2C_DDC4_SPEED__DC_I2C_DDC4_THRESHOLD_MASK                                                         0x00000003L
#define DC_I2C_DDC4_SPEED__DC_I2C_DDC4_DISABLE_FILTER_DURING_STALL_MASK                                       0x00000010L
#define DC_I2C_DDC4_SPEED__DC_I2C_DDC4_START_STOP_TIMING_CNTL_MASK                                            0x00000300L
#define DC_I2C_DDC4_SPEED__DC_I2C_DDC4_PRESCALE_MASK                                                          0xFFFF0000L
//DC_I2C_DDC4_SETUP
#define DC_I2C_DDC4_SETUP__DC_I2C_DDC4_DATA_DRIVE_EN__SHIFT                                                   0x0
#define DC_I2C_DDC4_SETUP__DC_I2C_DDC4_DATA_DRIVE_SEL__SHIFT                                                  0x1
#define DC_I2C_DDC4_SETUP__DC_I2C_DDC4_EDID_DETECT_ENABLE__SHIFT                                              0x4
#define DC_I2C_DDC4_SETUP__DC_I2C_DDC4_EDID_DETECT_MODE__SHIFT                                                0x5
#define DC_I2C_DDC4_SETUP__DC_I2C_DDC4_ENABLE__SHIFT                                                          0x6
#define DC_I2C_DDC4_SETUP__DC_I2C_DDC4_CLK_DRIVE_EN__SHIFT                                                    0x7
#define DC_I2C_DDC4_SETUP__DC_I2C_DDC4_INTRA_BYTE_DELAY__SHIFT                                                0x8
#define DC_I2C_DDC4_SETUP__DC_I2C_DDC4_INTRA_TRANSACTION_DELAY__SHIFT                                         0x10
#define DC_I2C_DDC4_SETUP__DC_I2C_DDC4_TIME_LIMIT__SHIFT                                                      0x18
#define DC_I2C_DDC4_SETUP__DC_I2C_DDC4_DATA_DRIVE_EN_MASK                                                     0x00000001L
#define DC_I2C_DDC4_SETUP__DC_I2C_DDC4_DATA_DRIVE_SEL_MASK                                                    0x00000002L
#define DC_I2C_DDC4_SETUP__DC_I2C_DDC4_EDID_DETECT_ENABLE_MASK                                                0x00000010L
#define DC_I2C_DDC4_SETUP__DC_I2C_DDC4_EDID_DETECT_MODE_MASK                                                  0x00000020L
#define DC_I2C_DDC4_SETUP__DC_I2C_DDC4_ENABLE_MASK                                                            0x00000040L
#define DC_I2C_DDC4_SETUP__DC_I2C_DDC4_CLK_DRIVE_EN_MASK                                                      0x00000080L
#define DC_I2C_DDC4_SETUP__DC_I2C_DDC4_INTRA_BYTE_DELAY_MASK                                                  0x0000FF00L
#define DC_I2C_DDC4_SETUP__DC_I2C_DDC4_INTRA_TRANSACTION_DELAY_MASK                                           0x00FF0000L
#define DC_I2C_DDC4_SETUP__DC_I2C_DDC4_TIME_LIMIT_MASK                                                        0xFF000000L
//DC_I2C_DDC5_SPEED
#define DC_I2C_DDC5_SPEED__DC_I2C_DDC5_THRESHOLD__SHIFT                                                       0x0
#define DC_I2C_DDC5_SPEED__DC_I2C_DDC5_DISABLE_FILTER_DURING_STALL__SHIFT                                     0x4
#define DC_I2C_DDC5_SPEED__DC_I2C_DDC5_START_STOP_TIMING_CNTL__SHIFT                                          0x8
#define DC_I2C_DDC5_SPEED__DC_I2C_DDC5_PRESCALE__SHIFT                                                        0x10
#define DC_I2C_DDC5_SPEED__DC_I2C_DDC5_THRESHOLD_MASK                                                         0x00000003L
#define DC_I2C_DDC5_SPEED__DC_I2C_DDC5_DISABLE_FILTER_DURING_STALL_MASK                                       0x00000010L
#define DC_I2C_DDC5_SPEED__DC_I2C_DDC5_START_STOP_TIMING_CNTL_MASK                                            0x00000300L
#define DC_I2C_DDC5_SPEED__DC_I2C_DDC5_PRESCALE_MASK                                                          0xFFFF0000L
//DC_I2C_DDC5_SETUP
#define DC_I2C_DDC5_SETUP__DC_I2C_DDC5_DATA_DRIVE_EN__SHIFT                                                   0x0
#define DC_I2C_DDC5_SETUP__DC_I2C_DDC5_DATA_DRIVE_SEL__SHIFT                                                  0x1
#define DC_I2C_DDC5_SETUP__DC_I2C_DDC5_EDID_DETECT_ENABLE__SHIFT                                              0x4
#define DC_I2C_DDC5_SETUP__DC_I2C_DDC5_EDID_DETECT_MODE__SHIFT                                                0x5
#define DC_I2C_DDC5_SETUP__DC_I2C_DDC5_ENABLE__SHIFT                                                          0x6
#define DC_I2C_DDC5_SETUP__DC_I2C_DDC5_CLK_DRIVE_EN__SHIFT                                                    0x7
#define DC_I2C_DDC5_SETUP__DC_I2C_DDC5_INTRA_BYTE_DELAY__SHIFT                                                0x8
#define DC_I2C_DDC5_SETUP__DC_I2C_DDC5_INTRA_TRANSACTION_DELAY__SHIFT                                         0x10
#define DC_I2C_DDC5_SETUP__DC_I2C_DDC5_TIME_LIMIT__SHIFT                                                      0x18
#define DC_I2C_DDC5_SETUP__DC_I2C_DDC5_DATA_DRIVE_EN_MASK                                                     0x00000001L
#define DC_I2C_DDC5_SETUP__DC_I2C_DDC5_DATA_DRIVE_SEL_MASK                                                    0x00000002L
#define DC_I2C_DDC5_SETUP__DC_I2C_DDC5_EDID_DETECT_ENABLE_MASK                                                0x00000010L
#define DC_I2C_DDC5_SETUP__DC_I2C_DDC5_EDID_DETECT_MODE_MASK                                                  0x00000020L
#define DC_I2C_DDC5_SETUP__DC_I2C_DDC5_ENABLE_MASK                                                            0x00000040L
#define DC_I2C_DDC5_SETUP__DC_I2C_DDC5_CLK_DRIVE_EN_MASK                                                      0x00000080L
#define DC_I2C_DDC5_SETUP__DC_I2C_DDC5_INTRA_BYTE_DELAY_MASK                                                  0x0000FF00L
#define DC_I2C_DDC5_SETUP__DC_I2C_DDC5_INTRA_TRANSACTION_DELAY_MASK                                           0x00FF0000L
#define DC_I2C_DDC5_SETUP__DC_I2C_DDC5_TIME_LIMIT_MASK                                                        0xFF000000L
//DC_I2C_DDC6_SPEED
#define DC_I2C_DDC6_SPEED__DC_I2C_DDC6_THRESHOLD__SHIFT                                                       0x0
#define DC_I2C_DDC6_SPEED__DC_I2C_DDC6_DISABLE_FILTER_DURING_STALL__SHIFT                                     0x4
#define DC_I2C_DDC6_SPEED__DC_I2C_DDC6_START_STOP_TIMING_CNTL__SHIFT                                          0x8
#define DC_I2C_DDC6_SPEED__DC_I2C_DDC6_PRESCALE__SHIFT                                                        0x10
#define DC_I2C_DDC6_SPEED__DC_I2C_DDC6_THRESHOLD_MASK                                                         0x00000003L
#define DC_I2C_DDC6_SPEED__DC_I2C_DDC6_DISABLE_FILTER_DURING_STALL_MASK                                       0x00000010L
#define DC_I2C_DDC6_SPEED__DC_I2C_DDC6_START_STOP_TIMING_CNTL_MASK                                            0x00000300L
#define DC_I2C_DDC6_SPEED__DC_I2C_DDC6_PRESCALE_MASK                                                          0xFFFF0000L
//DC_I2C_DDC6_SETUP
#define DC_I2C_DDC6_SETUP__DC_I2C_DDC6_DATA_DRIVE_EN__SHIFT                                                   0x0
#define DC_I2C_DDC6_SETUP__DC_I2C_DDC6_DATA_DRIVE_SEL__SHIFT                                                  0x1
#define DC_I2C_DDC6_SETUP__DC_I2C_DDC6_EDID_DETECT_ENABLE__SHIFT                                              0x4
#define DC_I2C_DDC6_SETUP__DC_I2C_DDC6_EDID_DETECT_MODE__SHIFT                                                0x5
#define DC_I2C_DDC6_SETUP__DC_I2C_DDC6_ENABLE__SHIFT                                                          0x6
#define DC_I2C_DDC6_SETUP__DC_I2C_DDC6_CLK_DRIVE_EN__SHIFT                                                    0x7
#define DC_I2C_DDC6_SETUP__DC_I2C_DDC6_INTRA_BYTE_DELAY__SHIFT                                                0x8
#define DC_I2C_DDC6_SETUP__DC_I2C_DDC6_INTRA_TRANSACTION_DELAY__SHIFT                                         0x10
#define DC_I2C_DDC6_SETUP__DC_I2C_DDC6_TIME_LIMIT__SHIFT                                                      0x18
#define DC_I2C_DDC6_SETUP__DC_I2C_DDC6_DATA_DRIVE_EN_MASK                                                     0x00000001L
#define DC_I2C_DDC6_SETUP__DC_I2C_DDC6_DATA_DRIVE_SEL_MASK                                                    0x00000002L
#define DC_I2C_DDC6_SETUP__DC_I2C_DDC6_EDID_DETECT_ENABLE_MASK                                                0x00000010L
#define DC_I2C_DDC6_SETUP__DC_I2C_DDC6_EDID_DETECT_MODE_MASK                                                  0x00000020L
#define DC_I2C_DDC6_SETUP__DC_I2C_DDC6_ENABLE_MASK                                                            0x00000040L
#define DC_I2C_DDC6_SETUP__DC_I2C_DDC6_CLK_DRIVE_EN_MASK                                                      0x00000080L
#define DC_I2C_DDC6_SETUP__DC_I2C_DDC6_INTRA_BYTE_DELAY_MASK                                                  0x0000FF00L
#define DC_I2C_DDC6_SETUP__DC_I2C_DDC6_INTRA_TRANSACTION_DELAY_MASK                                           0x00FF0000L
#define DC_I2C_DDC6_SETUP__DC_I2C_DDC6_TIME_LIMIT_MASK                                                        0xFF000000L
//DC_I2C_TRANSACTION0
#define DC_I2C_TRANSACTION0__DC_I2C_RW0__SHIFT                                                                0x0
#define DC_I2C_TRANSACTION0__DC_I2C_STOP_ON_NACK0__SHIFT                                                      0x8
#define DC_I2C_TRANSACTION0__DC_I2C_START0__SHIFT                                                             0xc
#define DC_I2C_TRANSACTION0__DC_I2C_STOP0__SHIFT                                                              0xd
#define DC_I2C_TRANSACTION0__DC_I2C_COUNT0__SHIFT                                                             0x10
#define DC_I2C_TRANSACTION0__DC_I2C_RW0_MASK                                                                  0x00000001L
#define DC_I2C_TRANSACTION0__DC_I2C_STOP_ON_NACK0_MASK                                                        0x00000100L
#define DC_I2C_TRANSACTION0__DC_I2C_START0_MASK                                                               0x00001000L
#define DC_I2C_TRANSACTION0__DC_I2C_STOP0_MASK                                                                0x00002000L
#define DC_I2C_TRANSACTION0__DC_I2C_COUNT0_MASK                                                               0x03FF0000L
//DC_I2C_TRANSACTION1
#define DC_I2C_TRANSACTION1__DC_I2C_RW1__SHIFT                                                                0x0
#define DC_I2C_TRANSACTION1__DC_I2C_STOP_ON_NACK1__SHIFT                                                      0x8
#define DC_I2C_TRANSACTION1__DC_I2C_START1__SHIFT                                                             0xc
#define DC_I2C_TRANSACTION1__DC_I2C_STOP1__SHIFT                                                              0xd
#define DC_I2C_TRANSACTION1__DC_I2C_COUNT1__SHIFT                                                             0x10
#define DC_I2C_TRANSACTION1__DC_I2C_RW1_MASK                                                                  0x00000001L
#define DC_I2C_TRANSACTION1__DC_I2C_STOP_ON_NACK1_MASK                                                        0x00000100L
#define DC_I2C_TRANSACTION1__DC_I2C_START1_MASK                                                               0x00001000L
#define DC_I2C_TRANSACTION1__DC_I2C_STOP1_MASK                                                                0x00002000L
#define DC_I2C_TRANSACTION1__DC_I2C_COUNT1_MASK                                                               0x03FF0000L
//DC_I2C_TRANSACTION2
#define DC_I2C_TRANSACTION2__DC_I2C_RW2__SHIFT                                                                0x0
#define DC_I2C_TRANSACTION2__DC_I2C_STOP_ON_NACK2__SHIFT                                                      0x8
#define DC_I2C_TRANSACTION2__DC_I2C_START2__SHIFT                                                             0xc
#define DC_I2C_TRANSACTION2__DC_I2C_STOP2__SHIFT                                                              0xd
#define DC_I2C_TRANSACTION2__DC_I2C_COUNT2__SHIFT                                                             0x10
#define DC_I2C_TRANSACTION2__DC_I2C_RW2_MASK                                                                  0x00000001L
#define DC_I2C_TRANSACTION2__DC_I2C_STOP_ON_NACK2_MASK                                                        0x00000100L
#define DC_I2C_TRANSACTION2__DC_I2C_START2_MASK                                                               0x00001000L
#define DC_I2C_TRANSACTION2__DC_I2C_STOP2_MASK                                                                0x00002000L
#define DC_I2C_TRANSACTION2__DC_I2C_COUNT2_MASK                                                               0x03FF0000L
//DC_I2C_TRANSACTION3
#define DC_I2C_TRANSACTION3__DC_I2C_RW3__SHIFT                                                                0x0
#define DC_I2C_TRANSACTION3__DC_I2C_STOP_ON_NACK3__SHIFT                                                      0x8
#define DC_I2C_TRANSACTION3__DC_I2C_START3__SHIFT                                                             0xc
#define DC_I2C_TRANSACTION3__DC_I2C_STOP3__SHIFT                                                              0xd
#define DC_I2C_TRANSACTION3__DC_I2C_COUNT3__SHIFT                                                             0x10
#define DC_I2C_TRANSACTION3__DC_I2C_RW3_MASK                                                                  0x00000001L
#define DC_I2C_TRANSACTION3__DC_I2C_STOP_ON_NACK3_MASK                                                        0x00000100L
#define DC_I2C_TRANSACTION3__DC_I2C_START3_MASK                                                               0x00001000L
#define DC_I2C_TRANSACTION3__DC_I2C_STOP3_MASK                                                                0x00002000L
#define DC_I2C_TRANSACTION3__DC_I2C_COUNT3_MASK                                                               0x03FF0000L
//DC_I2C_DATA
#define DC_I2C_DATA__DC_I2C_DATA_RW__SHIFT                                                                    0x0
#define DC_I2C_DATA__DC_I2C_DATA__SHIFT                                                                       0x8
#define DC_I2C_DATA__DC_I2C_INDEX__SHIFT                                                                      0x10
#define DC_I2C_DATA__DC_I2C_INDEX_WRITE__SHIFT                                                                0x1f
#define DC_I2C_DATA__DC_I2C_DATA_RW_MASK                                                                      0x00000001L
#define DC_I2C_DATA__DC_I2C_DATA_MASK                                                                         0x0000FF00L
#define DC_I2C_DATA__DC_I2C_INDEX_MASK                                                                        0x03FF0000L
#define DC_I2C_DATA__DC_I2C_INDEX_WRITE_MASK                                                                  0x80000000L
//DC_I2C_DDCVGA_HW_STATUS
#define DC_I2C_DDCVGA_HW_STATUS__DC_I2C_DDCVGA_HW_STATUS__SHIFT                                               0x0
#define DC_I2C_DDCVGA_HW_STATUS__DC_I2C_DDCVGA_HW_DONE__SHIFT                                                 0x3
#define DC_I2C_DDCVGA_HW_STATUS__DC_I2C_DDCVGA_HW_REQ__SHIFT                                                  0x10
#define DC_I2C_DDCVGA_HW_STATUS__DC_I2C_DDCVGA_HW_URG__SHIFT                                                  0x11
#define DC_I2C_DDCVGA_HW_STATUS__DC_I2C_DDCVGA_EDID_DETECT_STATUS__SHIFT                                      0x14
#define DC_I2C_DDCVGA_HW_STATUS__DC_I2C_DDCVGA_EDID_DETECT_NUM_VALID_TRIES__SHIFT                             0x18
#define DC_I2C_DDCVGA_HW_STATUS__DC_I2C_DDCVGA_EDID_DETECT_STATE__SHIFT                                       0x1c
#define DC_I2C_DDCVGA_HW_STATUS__DC_I2C_DDCVGA_HW_STATUS_MASK                                                 0x00000003L
#define DC_I2C_DDCVGA_HW_STATUS__DC_I2C_DDCVGA_HW_DONE_MASK                                                   0x00000008L
#define DC_I2C_DDCVGA_HW_STATUS__DC_I2C_DDCVGA_HW_REQ_MASK                                                    0x00010000L
#define DC_I2C_DDCVGA_HW_STATUS__DC_I2C_DDCVGA_HW_URG_MASK                                                    0x00020000L
#define DC_I2C_DDCVGA_HW_STATUS__DC_I2C_DDCVGA_EDID_DETECT_STATUS_MASK                                        0x00100000L
#define DC_I2C_DDCVGA_HW_STATUS__DC_I2C_DDCVGA_EDID_DETECT_NUM_VALID_TRIES_MASK                               0x0F000000L
#define DC_I2C_DDCVGA_HW_STATUS__DC_I2C_DDCVGA_EDID_DETECT_STATE_MASK                                         0x70000000L
//DC_I2C_DDCVGA_SPEED
#define DC_I2C_DDCVGA_SPEED__DC_I2C_DDCVGA_THRESHOLD__SHIFT                                                   0x0
#define DC_I2C_DDCVGA_SPEED__DC_I2C_DDCVGA_DISABLE_FILTER_DURING_STALL__SHIFT                                 0x4
#define DC_I2C_DDCVGA_SPEED__DC_I2C_DDCVGA_START_STOP_TIMING_CNTL__SHIFT                                      0x8
#define DC_I2C_DDCVGA_SPEED__DC_I2C_DDCVGA_PRESCALE__SHIFT                                                    0x10
#define DC_I2C_DDCVGA_SPEED__DC_I2C_DDCVGA_THRESHOLD_MASK                                                     0x00000003L
#define DC_I2C_DDCVGA_SPEED__DC_I2C_DDCVGA_DISABLE_FILTER_DURING_STALL_MASK                                   0x00000010L
#define DC_I2C_DDCVGA_SPEED__DC_I2C_DDCVGA_START_STOP_TIMING_CNTL_MASK                                        0x00000300L
#define DC_I2C_DDCVGA_SPEED__DC_I2C_DDCVGA_PRESCALE_MASK                                                      0xFFFF0000L
//DC_I2C_DDCVGA_SETUP
#define DC_I2C_DDCVGA_SETUP__DC_I2C_DDCVGA_DATA_DRIVE_EN__SHIFT                                               0x0
#define DC_I2C_DDCVGA_SETUP__DC_I2C_DDCVGA_DATA_DRIVE_SEL__SHIFT                                              0x1
#define DC_I2C_DDCVGA_SETUP__DC_I2C_DDCVGA_EDID_DETECT_ENABLE__SHIFT                                          0x4
#define DC_I2C_DDCVGA_SETUP__DC_I2C_DDCVGA_EDID_DETECT_MODE__SHIFT                                            0x5
#define DC_I2C_DDCVGA_SETUP__DC_I2C_DDCVGA_ENABLE__SHIFT                                                      0x6
#define DC_I2C_DDCVGA_SETUP__DC_I2C_DDCVGA_CLK_DRIVE_EN__SHIFT                                                0x7
#define DC_I2C_DDCVGA_SETUP__DC_I2C_DDCVGA_INTRA_BYTE_DELAY__SHIFT                                            0x8
#define DC_I2C_DDCVGA_SETUP__DC_I2C_DDCVGA_INTRA_TRANSACTION_DELAY__SHIFT                                     0x10
#define DC_I2C_DDCVGA_SETUP__DC_I2C_DDCVGA_TIME_LIMIT__SHIFT                                                  0x18
#define DC_I2C_DDCVGA_SETUP__DC_I2C_DDCVGA_DATA_DRIVE_EN_MASK                                                 0x00000001L
#define DC_I2C_DDCVGA_SETUP__DC_I2C_DDCVGA_DATA_DRIVE_SEL_MASK                                                0x00000002L
#define DC_I2C_DDCVGA_SETUP__DC_I2C_DDCVGA_EDID_DETECT_ENABLE_MASK                                            0x00000010L
#define DC_I2C_DDCVGA_SETUP__DC_I2C_DDCVGA_EDID_DETECT_MODE_MASK                                              0x00000020L
#define DC_I2C_DDCVGA_SETUP__DC_I2C_DDCVGA_ENABLE_MASK                                                        0x00000040L
#define DC_I2C_DDCVGA_SETUP__DC_I2C_DDCVGA_CLK_DRIVE_EN_MASK                                                  0x00000080L
#define DC_I2C_DDCVGA_SETUP__DC_I2C_DDCVGA_INTRA_BYTE_DELAY_MASK                                              0x0000FF00L
#define DC_I2C_DDCVGA_SETUP__DC_I2C_DDCVGA_INTRA_TRANSACTION_DELAY_MASK                                       0x00FF0000L
#define DC_I2C_DDCVGA_SETUP__DC_I2C_DDCVGA_TIME_LIMIT_MASK                                                    0xFF000000L
//DC_I2C_EDID_DETECT_CTRL
#define DC_I2C_EDID_DETECT_CTRL__DC_I2C_EDID_DETECT_WAIT_TIME__SHIFT                                          0x0
#define DC_I2C_EDID_DETECT_CTRL__DC_I2C_EDID_DETECT_NUM_TRIES_UNTIL_VALID__SHIFT                              0x14
#define DC_I2C_EDID_DETECT_CTRL__DC_I2C_EDID_DETECT_SEND_RESET__SHIFT                                         0x1c
#define DC_I2C_EDID_DETECT_CTRL__DC_I2C_EDID_DETECT_WAIT_TIME_MASK                                            0x0000FFFFL
#define DC_I2C_EDID_DETECT_CTRL__DC_I2C_EDID_DETECT_NUM_TRIES_UNTIL_VALID_MASK                                0x00F00000L
#define DC_I2C_EDID_DETECT_CTRL__DC_I2C_EDID_DETECT_SEND_RESET_MASK                                           0x10000000L
//DC_I2C_READ_REQUEST_INTERRUPT
#define DC_I2C_READ_REQUEST_INTERRUPT__DC_I2C_DDC1_READ_REQUEST_OCCURRED__SHIFT                               0x0
#define DC_I2C_READ_REQUEST_INTERRUPT__DC_I2C_DDC1_READ_REQUEST_INT__SHIFT                                    0x1
#define DC_I2C_READ_REQUEST_INTERRUPT__DC_I2C_DDC1_READ_REQUEST_ACK__SHIFT                                    0x2
#define DC_I2C_READ_REQUEST_INTERRUPT__DC_I2C_DDC1_READ_REQUEST_MASK__SHIFT                                   0x3
#define DC_I2C_READ_REQUEST_INTERRUPT__DC_I2C_DDC2_READ_REQUEST_OCCURRED__SHIFT                               0x4
#define DC_I2C_READ_REQUEST_INTERRUPT__DC_I2C_DDC2_READ_REQUEST_INT__SHIFT                                    0x5
#define DC_I2C_READ_REQUEST_INTERRUPT__DC_I2C_DDC2_READ_REQUEST_ACK__SHIFT                                    0x6
#define DC_I2C_READ_REQUEST_INTERRUPT__DC_I2C_DDC2_READ_REQUEST_MASK__SHIFT                                   0x7
#define DC_I2C_READ_REQUEST_INTERRUPT__DC_I2C_DDC3_READ_REQUEST_OCCURRED__SHIFT                               0x8
#define DC_I2C_READ_REQUEST_INTERRUPT__DC_I2C_DDC3_READ_REQUEST_INT__SHIFT                                    0x9
#define DC_I2C_READ_REQUEST_INTERRUPT__DC_I2C_DDC3_READ_REQUEST_ACK__SHIFT                                    0xa
#define DC_I2C_READ_REQUEST_INTERRUPT__DC_I2C_DDC3_READ_REQUEST_MASK__SHIFT                                   0xb
#define DC_I2C_READ_REQUEST_INTERRUPT__DC_I2C_DDC4_READ_REQUEST_OCCURRED__SHIFT                               0xc
#define DC_I2C_READ_REQUEST_INTERRUPT__DC_I2C_DDC4_READ_REQUEST_INT__SHIFT                                    0xd
#define DC_I2C_READ_REQUEST_INTERRUPT__DC_I2C_DDC4_READ_REQUEST_ACK__SHIFT                                    0xe
#define DC_I2C_READ_REQUEST_INTERRUPT__DC_I2C_DDC4_READ_REQUEST_MASK__SHIFT                                   0xf
#define DC_I2C_READ_REQUEST_INTERRUPT__DC_I2C_DDC5_READ_REQUEST_OCCURRED__SHIFT                               0x10
#define DC_I2C_READ_REQUEST_INTERRUPT__DC_I2C_DDC5_READ_REQUEST_INT__SHIFT                                    0x11
#define DC_I2C_READ_REQUEST_INTERRUPT__DC_I2C_DDC5_READ_REQUEST_ACK__SHIFT                                    0x12
#define DC_I2C_READ_REQUEST_INTERRUPT__DC_I2C_DDC5_READ_REQUEST_MASK__SHIFT                                   0x13
#define DC_I2C_READ_REQUEST_INTERRUPT__DC_I2C_DDC6_READ_REQUEST_OCCURRED__SHIFT                               0x14
#define DC_I2C_READ_REQUEST_INTERRUPT__DC_I2C_DDC6_READ_REQUEST_INT__SHIFT                                    0x15
#define DC_I2C_READ_REQUEST_INTERRUPT__DC_I2C_DDC6_READ_REQUEST_ACK__SHIFT                                    0x16
#define DC_I2C_READ_REQUEST_INTERRUPT__DC_I2C_DDC6_READ_REQUEST_MASK__SHIFT                                   0x17
#define DC_I2C_READ_REQUEST_INTERRUPT__DC_I2C_DDCVGA_READ_REQUEST_OCCURRED__SHIFT                             0x18
#define DC_I2C_READ_REQUEST_INTERRUPT__DC_I2C_DDCVGA_READ_REQUEST_INT__SHIFT                                  0x19
#define DC_I2C_READ_REQUEST_INTERRUPT__DC_I2C_DDCVGA_READ_REQUEST_ACK__SHIFT                                  0x1a
#define DC_I2C_READ_REQUEST_INTERRUPT__DC_I2C_DDCVGA_READ_REQUEST_MASK__SHIFT                                 0x1b
#define DC_I2C_READ_REQUEST_INTERRUPT__DC_I2C_DDC_READ_REQUEST_ACK_ENABLE__SHIFT                              0x1e
#define DC_I2C_READ_REQUEST_INTERRUPT__DC_I2C_DDC_READ_REQUEST_INT_TYPE__SHIFT                                0x1f
#define DC_I2C_READ_REQUEST_INTERRUPT__DC_I2C_DDC1_READ_REQUEST_OCCURRED_MASK                                 0x00000001L
#define DC_I2C_READ_REQUEST_INTERRUPT__DC_I2C_DDC1_READ_REQUEST_INT_MASK                                      0x00000002L
#define DC_I2C_READ_REQUEST_INTERRUPT__DC_I2C_DDC1_READ_REQUEST_ACK_MASK                                      0x00000004L
#define DC_I2C_READ_REQUEST_INTERRUPT__DC_I2C_DDC1_READ_REQUEST_MASK_MASK                                     0x00000008L
#define DC_I2C_READ_REQUEST_INTERRUPT__DC_I2C_DDC2_READ_REQUEST_OCCURRED_MASK                                 0x00000010L
#define DC_I2C_READ_REQUEST_INTERRUPT__DC_I2C_DDC2_READ_REQUEST_INT_MASK                                      0x00000020L
#define DC_I2C_READ_REQUEST_INTERRUPT__DC_I2C_DDC2_READ_REQUEST_ACK_MASK                                      0x00000040L
#define DC_I2C_READ_REQUEST_INTERRUPT__DC_I2C_DDC2_READ_REQUEST_MASK_MASK                                     0x00000080L
#define DC_I2C_READ_REQUEST_INTERRUPT__DC_I2C_DDC3_READ_REQUEST_OCCURRED_MASK                                 0x00000100L
#define DC_I2C_READ_REQUEST_INTERRUPT__DC_I2C_DDC3_READ_REQUEST_INT_MASK                                      0x00000200L
#define DC_I2C_READ_REQUEST_INTERRUPT__DC_I2C_DDC3_READ_REQUEST_ACK_MASK                                      0x00000400L
#define DC_I2C_READ_REQUEST_INTERRUPT__DC_I2C_DDC3_READ_REQUEST_MASK_MASK                                     0x00000800L
#define DC_I2C_READ_REQUEST_INTERRUPT__DC_I2C_DDC4_READ_REQUEST_OCCURRED_MASK                                 0x00001000L
#define DC_I2C_READ_REQUEST_INTERRUPT__DC_I2C_DDC4_READ_REQUEST_INT_MASK                                      0x00002000L
#define DC_I2C_READ_REQUEST_INTERRUPT__DC_I2C_DDC4_READ_REQUEST_ACK_MASK                                      0x00004000L
#define DC_I2C_READ_REQUEST_INTERRUPT__DC_I2C_DDC4_READ_REQUEST_MASK_MASK                                     0x00008000L
#define DC_I2C_READ_REQUEST_INTERRUPT__DC_I2C_DDC5_READ_REQUEST_OCCURRED_MASK                                 0x00010000L
#define DC_I2C_READ_REQUEST_INTERRUPT__DC_I2C_DDC5_READ_REQUEST_INT_MASK                                      0x00020000L
#define DC_I2C_READ_REQUEST_INTERRUPT__DC_I2C_DDC5_READ_REQUEST_ACK_MASK                                      0x00040000L
#define DC_I2C_READ_REQUEST_INTERRUPT__DC_I2C_DDC5_READ_REQUEST_MASK_MASK                                     0x00080000L
#define DC_I2C_READ_REQUEST_INTERRUPT__DC_I2C_DDC6_READ_REQUEST_OCCURRED_MASK                                 0x00100000L
#define DC_I2C_READ_REQUEST_INTERRUPT__DC_I2C_DDC6_READ_REQUEST_INT_MASK                                      0x00200000L
#define DC_I2C_READ_REQUEST_INTERRUPT__DC_I2C_DDC6_READ_REQUEST_ACK_MASK                                      0x00400000L
#define DC_I2C_READ_REQUEST_INTERRUPT__DC_I2C_DDC6_READ_REQUEST_MASK_MASK                                     0x00800000L
#define DC_I2C_READ_REQUEST_INTERRUPT__DC_I2C_DDCVGA_READ_REQUEST_OCCURRED_MASK                               0x01000000L
#define DC_I2C_READ_REQUEST_INTERRUPT__DC_I2C_DDCVGA_READ_REQUEST_INT_MASK                                    0x02000000L
#define DC_I2C_READ_REQUEST_INTERRUPT__DC_I2C_DDCVGA_READ_REQUEST_ACK_MASK                                    0x04000000L
#define DC_I2C_READ_REQUEST_INTERRUPT__DC_I2C_DDCVGA_READ_REQUEST_MASK_MASK                                   0x08000000L
#define DC_I2C_READ_REQUEST_INTERRUPT__DC_I2C_DDC_READ_REQUEST_ACK_ENABLE_MASK                                0x40000000L
#define DC_I2C_READ_REQUEST_INTERRUPT__DC_I2C_DDC_READ_REQUEST_INT_TYPE_MASK                                  0x80000000L
//GENERIC_I2C_CONTROL
#define GENERIC_I2C_CONTROL__GENERIC_I2C_GO__SHIFT                                                            0x0
#define GENERIC_I2C_CONTROL__GENERIC_I2C_SOFT_RESET__SHIFT                                                    0x1
#define GENERIC_I2C_CONTROL__GENERIC_I2C_SEND_RESET__SHIFT                                                    0x2
#define GENERIC_I2C_CONTROL__GENERIC_I2C_ENABLE__SHIFT                                                        0x3
#define GENERIC_I2C_CONTROL__GENERIC_I2C_GO_MASK                                                              0x00000001L
#define GENERIC_I2C_CONTROL__GENERIC_I2C_SOFT_RESET_MASK                                                      0x00000002L
#define GENERIC_I2C_CONTROL__GENERIC_I2C_SEND_RESET_MASK                                                      0x00000004L
#define GENERIC_I2C_CONTROL__GENERIC_I2C_ENABLE_MASK                                                          0x00000008L
//GENERIC_I2C_INTERRUPT_CONTROL
#define GENERIC_I2C_INTERRUPT_CONTROL__GENERIC_I2C_DONE_INT__SHIFT                                            0x0
#define GENERIC_I2C_INTERRUPT_CONTROL__GENERIC_I2C_DONE_ACK__SHIFT                                            0x1
#define GENERIC_I2C_INTERRUPT_CONTROL__GENERIC_I2C_DONE_MASK__SHIFT                                           0x2
#define GENERIC_I2C_INTERRUPT_CONTROL__GENERIC_I2C_DONE_INT_MASK                                              0x00000001L
#define GENERIC_I2C_INTERRUPT_CONTROL__GENERIC_I2C_DONE_ACK_MASK                                              0x00000002L
#define GENERIC_I2C_INTERRUPT_CONTROL__GENERIC_I2C_DONE_MASK_MASK                                             0x00000004L
//GENERIC_I2C_STATUS
#define GENERIC_I2C_STATUS__GENERIC_I2C_STATUS__SHIFT                                                         0x0
#define GENERIC_I2C_STATUS__GENERIC_I2C_DONE__SHIFT                                                           0x4
#define GENERIC_I2C_STATUS__GENERIC_I2C_ABORTED__SHIFT                                                        0x5
#define GENERIC_I2C_STATUS__GENERIC_I2C_TIMEOUT__SHIFT                                                        0x6
#define GENERIC_I2C_STATUS__GENERIC_I2C_STOPPED_ON_NACK__SHIFT                                                0x9
#define GENERIC_I2C_STATUS__GENERIC_I2C_NACK__SHIFT                                                           0xa
#define GENERIC_I2C_STATUS__GENERIC_I2C_STATUS_MASK                                                           0x0000000FL
#define GENERIC_I2C_STATUS__GENERIC_I2C_DONE_MASK                                                             0x00000010L
#define GENERIC_I2C_STATUS__GENERIC_I2C_ABORTED_MASK                                                          0x00000020L
#define GENERIC_I2C_STATUS__GENERIC_I2C_TIMEOUT_MASK                                                          0x00000040L
#define GENERIC_I2C_STATUS__GENERIC_I2C_STOPPED_ON_NACK_MASK                                                  0x00000200L
#define GENERIC_I2C_STATUS__GENERIC_I2C_NACK_MASK                                                             0x00000400L
//GENERIC_I2C_SPEED
#define GENERIC_I2C_SPEED__GENERIC_I2C_THRESHOLD__SHIFT                                                       0x0
#define GENERIC_I2C_SPEED__GENERIC_I2C_DISABLE_FILTER_DURING_STALL__SHIFT                                     0x4
#define GENERIC_I2C_SPEED__GENERIC_I2C_START_STOP_TIMING_CNTL__SHIFT                                          0x8
#define GENERIC_I2C_SPEED__GENERIC_I2C_PRESCALE__SHIFT                                                        0x10
#define GENERIC_I2C_SPEED__GENERIC_I2C_THRESHOLD_MASK                                                         0x00000003L
#define GENERIC_I2C_SPEED__GENERIC_I2C_DISABLE_FILTER_DURING_STALL_MASK                                       0x00000010L
#define GENERIC_I2C_SPEED__GENERIC_I2C_START_STOP_TIMING_CNTL_MASK                                            0x00000300L
#define GENERIC_I2C_SPEED__GENERIC_I2C_PRESCALE_MASK                                                          0xFFFF0000L
//GENERIC_I2C_SETUP
#define GENERIC_I2C_SETUP__GENERIC_I2C_DATA_DRIVE_EN__SHIFT                                                   0x0
#define GENERIC_I2C_SETUP__GENERIC_I2C_DATA_DRIVE_SEL__SHIFT                                                  0x1
#define GENERIC_I2C_SETUP__GENERIC_I2C_CLK_DRIVE_EN__SHIFT                                                    0x7
#define GENERIC_I2C_SETUP__GENERIC_I2C_INTRA_BYTE_DELAY__SHIFT                                                0x8
#define GENERIC_I2C_SETUP__GENERIC_I2C_TIME_LIMIT__SHIFT                                                      0x18
#define GENERIC_I2C_SETUP__GENERIC_I2C_DATA_DRIVE_EN_MASK                                                     0x00000001L
#define GENERIC_I2C_SETUP__GENERIC_I2C_DATA_DRIVE_SEL_MASK                                                    0x00000002L
#define GENERIC_I2C_SETUP__GENERIC_I2C_CLK_DRIVE_EN_MASK                                                      0x00000080L
#define GENERIC_I2C_SETUP__GENERIC_I2C_INTRA_BYTE_DELAY_MASK                                                  0x0000FF00L
#define GENERIC_I2C_SETUP__GENERIC_I2C_TIME_LIMIT_MASK                                                        0xFF000000L
//GENERIC_I2C_TRANSACTION
#define GENERIC_I2C_TRANSACTION__GENERIC_I2C_RW__SHIFT                                                        0x0
#define GENERIC_I2C_TRANSACTION__GENERIC_I2C_STOP_ON_NACK__SHIFT                                              0x8
#define GENERIC_I2C_TRANSACTION__GENERIC_I2C_ACK_ON_READ__SHIFT                                               0x9
#define GENERIC_I2C_TRANSACTION__GENERIC_I2C_START__SHIFT                                                     0xc
#define GENERIC_I2C_TRANSACTION__GENERIC_I2C_STOP__SHIFT                                                      0xd
#define GENERIC_I2C_TRANSACTION__GENERIC_I2C_COUNT__SHIFT                                                     0x10
#define GENERIC_I2C_TRANSACTION__GENERIC_I2C_RW_MASK                                                          0x00000001L
#define GENERIC_I2C_TRANSACTION__GENERIC_I2C_STOP_ON_NACK_MASK                                                0x00000100L
#define GENERIC_I2C_TRANSACTION__GENERIC_I2C_ACK_ON_READ_MASK                                                 0x00000200L
#define GENERIC_I2C_TRANSACTION__GENERIC_I2C_START_MASK                                                       0x00001000L
#define GENERIC_I2C_TRANSACTION__GENERIC_I2C_STOP_MASK                                                        0x00002000L
#define GENERIC_I2C_TRANSACTION__GENERIC_I2C_COUNT_MASK                                                       0x000F0000L
//GENERIC_I2C_DATA
#define GENERIC_I2C_DATA__GENERIC_I2C_DATA_RW__SHIFT                                                          0x0
#define GENERIC_I2C_DATA__GENERIC_I2C_DATA__SHIFT                                                             0x8
#define GENERIC_I2C_DATA__GENERIC_I2C_INDEX__SHIFT                                                            0x10
#define GENERIC_I2C_DATA__GENERIC_I2C_INDEX_WRITE__SHIFT                                                      0x1f
#define GENERIC_I2C_DATA__GENERIC_I2C_DATA_RW_MASK                                                            0x00000001L
#define GENERIC_I2C_DATA__GENERIC_I2C_DATA_MASK                                                               0x0000FF00L
#define GENERIC_I2C_DATA__GENERIC_I2C_INDEX_MASK                                                              0x000F0000L
#define GENERIC_I2C_DATA__GENERIC_I2C_INDEX_WRITE_MASK                                                        0x80000000L
//GENERIC_I2C_PIN_SELECTION
#define GENERIC_I2C_PIN_SELECTION__GENERIC_I2C_SCL_PIN_SEL__SHIFT                                             0x0
#define GENERIC_I2C_PIN_SELECTION__GENERIC_I2C_SDA_PIN_SEL__SHIFT                                             0x8
#define GENERIC_I2C_PIN_SELECTION__GENERIC_I2C_SCL_PIN_SEL_MASK                                               0x0000007FL
#define GENERIC_I2C_PIN_SELECTION__GENERIC_I2C_SDA_PIN_SEL_MASK                                               0x00007F00L
//DCO_SCRATCH0
#define DCO_SCRATCH0__DCO_SCRATCH0__SHIFT                                                                     0x0
#define DCO_SCRATCH0__DCO_SCRATCH0_MASK                                                                       0xFFFFFFFFL
//DCO_SCRATCH1
#define DCO_SCRATCH1__DCO_SCRATCH1__SHIFT                                                                     0x0
#define DCO_SCRATCH1__DCO_SCRATCH1_MASK                                                                       0xFFFFFFFFL
//DCO_SCRATCH2
#define DCO_SCRATCH2__DCO_SCRATCH2__SHIFT                                                                     0x0
#define DCO_SCRATCH2__DCO_SCRATCH2_MASK                                                                       0xFFFFFFFFL
//DCO_SCRATCH3
#define DCO_SCRATCH3__DCO_SCRATCH3__SHIFT                                                                     0x0
#define DCO_SCRATCH3__DCO_SCRATCH3_MASK                                                                       0xFFFFFFFFL
//DCO_SCRATCH4
#define DCO_SCRATCH4__DCO_SCRATCH4__SHIFT                                                                     0x0
#define DCO_SCRATCH4__DCO_SCRATCH4_MASK                                                                       0xFFFFFFFFL
//DCO_SCRATCH5
#define DCO_SCRATCH5__DCO_SCRATCH5__SHIFT                                                                     0x0
#define DCO_SCRATCH5__DCO_SCRATCH5_MASK                                                                       0xFFFFFFFFL
//DCO_SCRATCH6
#define DCO_SCRATCH6__DCO_SCRATCH6__SHIFT                                                                     0x0
#define DCO_SCRATCH6__DCO_SCRATCH6_MASK                                                                       0xFFFFFFFFL
//DCO_SCRATCH7
#define DCO_SCRATCH7__DCO_SCRATCH7__SHIFT                                                                     0x0
#define DCO_SCRATCH7__DCO_SCRATCH7_MASK                                                                       0xFFFFFFFFL
//DCE_VCE_CONTROL
#define DCE_VCE_CONTROL__DC_VCE_VIDEO_PIPE_SELECT__SHIFT                                                      0x0
#define DCE_VCE_CONTROL__DC_VCE_AUDIO_STREAM_SELECT__SHIFT                                                    0x4
#define DCE_VCE_CONTROL__DC_VCE_VIDEO_PIPE_SELECT_MASK                                                        0x00000007L
#define DCE_VCE_CONTROL__DC_VCE_AUDIO_STREAM_SELECT_MASK                                                      0x00000070L
//DISP_INTERRUPT_STATUS
#define DISP_INTERRUPT_STATUS__SCL_DISP1_MODE_CHANGE_INTERRUPT__SHIFT                                         0x0
#define DISP_INTERRUPT_STATUS__D1BLND_DATA_UNDERFLOW_INTERRUPT__SHIFT                                         0x1
#define DISP_INTERRUPT_STATUS__LB_D1_VLINE_INTERRUPT__SHIFT                                                   0x2
#define DISP_INTERRUPT_STATUS__LB_D1_VBLANK_INTERRUPT__SHIFT                                                  0x3
#define DISP_INTERRUPT_STATUS__CRTC1_SNAPSHOT_INTERRUPT__SHIFT                                                0x4
#define DISP_INTERRUPT_STATUS__CRTC1_FORCE_VSYNC_NEXT_LINE_INTERRUPT__SHIFT                                   0x5
#define DISP_INTERRUPT_STATUS__CRTC1_FORCE_COUNT_NOW_INTERRUPT__SHIFT                                         0x6
#define DISP_INTERRUPT_STATUS__CRTC1_TRIGA_INTERRUPT__SHIFT                                                   0x7
#define DISP_INTERRUPT_STATUS__CRTC1_TRIGB_INTERRUPT__SHIFT                                                   0x8
#define DISP_INTERRUPT_STATUS__CRTC1_VSYNC_NOM_INTERRUPT__SHIFT                                               0x9
#define DISP_INTERRUPT_STATUS__CRTC1_SET_V_TOTAL_MIN_EVENT_OCCURED_INT__SHIFT                                 0xa
#define DISP_INTERRUPT_STATUS__DIGA_DP_FAST_TRAINING_COMPLETE_INTERRUPT__SHIFT                                0xf
#define DISP_INTERRUPT_STATUS__DIGA_DP_VID_STREAM_DISABLE_INTERRUPT__SHIFT                                    0x10
#define DISP_INTERRUPT_STATUS__DC_HPD1_INTERRUPT__SHIFT                                                       0x11
#define DISP_INTERRUPT_STATUS__DC_HPD1_RX_INTERRUPT__SHIFT                                                    0x12
#define DISP_INTERRUPT_STATUS__AUX1_SW_DONE_INTERRUPT__SHIFT                                                  0x13
#define DISP_INTERRUPT_STATUS__AUX1_LS_DONE_INTERRUPT__SHIFT                                                  0x14
#define DISP_INTERRUPT_STATUS__DACA_AUTODETECT_INTERRUPT__SHIFT                                               0x16
#define DISP_INTERRUPT_STATUS__DACB_AUTODETECT_INTERRUPT__SHIFT                                               0x17
#define DISP_INTERRUPT_STATUS__DC_I2C_SW_DONE_INTERRUPT__SHIFT                                                0x18
#define DISP_INTERRUPT_STATUS__DC_I2C_HW_DONE_INTERRUPT__SHIFT                                                0x19
#define DISP_INTERRUPT_STATUS__DMCU_UC_INTERNAL_INT__SHIFT                                                    0x1a
#define DISP_INTERRUPT_STATUS__ABM1_HG_READY_INT__SHIFT                                                       0x1c
#define DISP_INTERRUPT_STATUS__ABM1_LS_READY_INT__SHIFT                                                       0x1d
#define DISP_INTERRUPT_STATUS__ABM1_BL_UPDATE_INT__SHIFT                                                      0x1e
#define DISP_INTERRUPT_STATUS__DISP_INTERRUPT_STATUS_CONTINUE__SHIFT                                          0x1f
#define DISP_INTERRUPT_STATUS__SCL_DISP1_MODE_CHANGE_INTERRUPT_MASK                                           0x00000001L
#define DISP_INTERRUPT_STATUS__D1BLND_DATA_UNDERFLOW_INTERRUPT_MASK                                           0x00000002L
#define DISP_INTERRUPT_STATUS__LB_D1_VLINE_INTERRUPT_MASK                                                     0x00000004L
#define DISP_INTERRUPT_STATUS__LB_D1_VBLANK_INTERRUPT_MASK                                                    0x00000008L
#define DISP_INTERRUPT_STATUS__CRTC1_SNAPSHOT_INTERRUPT_MASK                                                  0x00000010L
#define DISP_INTERRUPT_STATUS__CRTC1_FORCE_VSYNC_NEXT_LINE_INTERRUPT_MASK                                     0x00000020L
#define DISP_INTERRUPT_STATUS__CRTC1_FORCE_COUNT_NOW_INTERRUPT_MASK                                           0x00000040L
#define DISP_INTERRUPT_STATUS__CRTC1_TRIGA_INTERRUPT_MASK                                                     0x00000080L
#define DISP_INTERRUPT_STATUS__CRTC1_TRIGB_INTERRUPT_MASK                                                     0x00000100L
#define DISP_INTERRUPT_STATUS__CRTC1_VSYNC_NOM_INTERRUPT_MASK                                                 0x00000200L
#define DISP_INTERRUPT_STATUS__CRTC1_SET_V_TOTAL_MIN_EVENT_OCCURED_INT_MASK                                   0x00000400L
#define DISP_INTERRUPT_STATUS__DIGA_DP_FAST_TRAINING_COMPLETE_INTERRUPT_MASK                                  0x00008000L
#define DISP_INTERRUPT_STATUS__DIGA_DP_VID_STREAM_DISABLE_INTERRUPT_MASK                                      0x00010000L
#define DISP_INTERRUPT_STATUS__DC_HPD1_INTERRUPT_MASK                                                         0x00020000L
#define DISP_INTERRUPT_STATUS__DC_HPD1_RX_INTERRUPT_MASK                                                      0x00040000L
#define DISP_INTERRUPT_STATUS__AUX1_SW_DONE_INTERRUPT_MASK                                                    0x00080000L
#define DISP_INTERRUPT_STATUS__AUX1_LS_DONE_INTERRUPT_MASK                                                    0x00100000L
#define DISP_INTERRUPT_STATUS__DACA_AUTODETECT_INTERRUPT_MASK                                                 0x00400000L
#define DISP_INTERRUPT_STATUS__DACB_AUTODETECT_INTERRUPT_MASK                                                 0x00800000L
#define DISP_INTERRUPT_STATUS__DC_I2C_SW_DONE_INTERRUPT_MASK                                                  0x01000000L
#define DISP_INTERRUPT_STATUS__DC_I2C_HW_DONE_INTERRUPT_MASK                                                  0x02000000L
#define DISP_INTERRUPT_STATUS__DMCU_UC_INTERNAL_INT_MASK                                                      0x04000000L
#define DISP_INTERRUPT_STATUS__ABM1_HG_READY_INT_MASK                                                         0x10000000L
#define DISP_INTERRUPT_STATUS__ABM1_LS_READY_INT_MASK                                                         0x20000000L
#define DISP_INTERRUPT_STATUS__ABM1_BL_UPDATE_INT_MASK                                                        0x40000000L
#define DISP_INTERRUPT_STATUS__DISP_INTERRUPT_STATUS_CONTINUE_MASK                                            0x80000000L
//DISP_INTERRUPT_STATUS_CONTINUE
#define DISP_INTERRUPT_STATUS_CONTINUE__SCL_DISP2_MODE_CHANGE_INTERRUPT__SHIFT                                0x0
#define DISP_INTERRUPT_STATUS_CONTINUE__D2BLND_DATA_UNDERFLOW_INTERRUPT__SHIFT                                0x1
#define DISP_INTERRUPT_STATUS_CONTINUE__LB_D2_VLINE_INTERRUPT__SHIFT                                          0x2
#define DISP_INTERRUPT_STATUS_CONTINUE__LB_D2_VBLANK_INTERRUPT__SHIFT                                         0x3
#define DISP_INTERRUPT_STATUS_CONTINUE__CRTC2_SNAPSHOT_INTERRUPT__SHIFT                                       0x4
#define DISP_INTERRUPT_STATUS_CONTINUE__CRTC2_FORCE_VSYNC_NEXT_LINE_INTERRUPT__SHIFT                          0x5
#define DISP_INTERRUPT_STATUS_CONTINUE__CRTC2_FORCE_COUNT_NOW_INTERRUPT__SHIFT                                0x6
#define DISP_INTERRUPT_STATUS_CONTINUE__CRTC2_TRIGA_INTERRUPT__SHIFT                                          0x7
#define DISP_INTERRUPT_STATUS_CONTINUE__CRTC2_TRIGB_INTERRUPT__SHIFT                                          0x8
#define DISP_INTERRUPT_STATUS_CONTINUE__CRTC2_VSYNC_NOM_INTERRUPT__SHIFT                                      0x9
#define DISP_INTERRUPT_STATUS_CONTINUE__CRTC2_SET_V_TOTAL_MIN_EVENT_OCCURED_INT__SHIFT                        0xa
#define DISP_INTERRUPT_STATUS_CONTINUE__DIGB_DP_FAST_TRAINING_COMPLETE_INTERRUPT__SHIFT                       0xf
#define DISP_INTERRUPT_STATUS_CONTINUE__DIGB_DP_VID_STREAM_DISABLE_INTERRUPT__SHIFT                           0x10
#define DISP_INTERRUPT_STATUS_CONTINUE__DC_HPD2_INTERRUPT__SHIFT                                              0x11
#define DISP_INTERRUPT_STATUS_CONTINUE__DC_HPD2_RX_INTERRUPT__SHIFT                                           0x12
#define DISP_INTERRUPT_STATUS_CONTINUE__AUX2_SW_DONE_INTERRUPT__SHIFT                                         0x13
#define DISP_INTERRUPT_STATUS_CONTINUE__AUX2_LS_DONE_INTERRUPT__SHIFT                                         0x14
#define DISP_INTERRUPT_STATUS_CONTINUE__LB_D1_VLINE2_INTERRUPT__SHIFT                                         0x15
#define DISP_INTERRUPT_STATUS_CONTINUE__LB_D2_VLINE2_INTERRUPT__SHIFT                                         0x16
#define DISP_INTERRUPT_STATUS_CONTINUE__LB_D3_VLINE2_INTERRUPT__SHIFT                                         0x17
#define DISP_INTERRUPT_STATUS_CONTINUE__CRTC1_EXT_TIMING_SYNC_LOSS_INTERRUPT__SHIFT                           0x19
#define DISP_INTERRUPT_STATUS_CONTINUE__CRTC1_EXT_TIMING_SYNC_INTERRUPT__SHIFT                                0x1a
#define DISP_INTERRUPT_STATUS_CONTINUE__CRTC1_EXT_TIMING_SYNC_SIGNAL_INTERRUPT__SHIFT                         0x1b
#define DISP_INTERRUPT_STATUS_CONTINUE__CRTC1_VERTICAL_INTERRUPT0__SHIFT                                      0x1c
#define DISP_INTERRUPT_STATUS_CONTINUE__CRTC1_VERTICAL_INTERRUPT1__SHIFT                                      0x1d
#define DISP_INTERRUPT_STATUS_CONTINUE__CRTC1_VERTICAL_INTERRUPT2__SHIFT                                      0x1e
#define DISP_INTERRUPT_STATUS_CONTINUE__DISP_INTERRUPT_STATUS_CONTINUE2__SHIFT                                0x1f
#define DISP_INTERRUPT_STATUS_CONTINUE__SCL_DISP2_MODE_CHANGE_INTERRUPT_MASK                                  0x00000001L
#define DISP_INTERRUPT_STATUS_CONTINUE__D2BLND_DATA_UNDERFLOW_INTERRUPT_MASK                                  0x00000002L
#define DISP_INTERRUPT_STATUS_CONTINUE__LB_D2_VLINE_INTERRUPT_MASK                                            0x00000004L
#define DISP_INTERRUPT_STATUS_CONTINUE__LB_D2_VBLANK_INTERRUPT_MASK                                           0x00000008L
#define DISP_INTERRUPT_STATUS_CONTINUE__CRTC2_SNAPSHOT_INTERRUPT_MASK                                         0x00000010L
#define DISP_INTERRUPT_STATUS_CONTINUE__CRTC2_FORCE_VSYNC_NEXT_LINE_INTERRUPT_MASK                            0x00000020L
#define DISP_INTERRUPT_STATUS_CONTINUE__CRTC2_FORCE_COUNT_NOW_INTERRUPT_MASK                                  0x00000040L
#define DISP_INTERRUPT_STATUS_CONTINUE__CRTC2_TRIGA_INTERRUPT_MASK                                            0x00000080L
#define DISP_INTERRUPT_STATUS_CONTINUE__CRTC2_TRIGB_INTERRUPT_MASK                                            0x00000100L
#define DISP_INTERRUPT_STATUS_CONTINUE__CRTC2_VSYNC_NOM_INTERRUPT_MASK                                        0x00000200L
#define DISP_INTERRUPT_STATUS_CONTINUE__CRTC2_SET_V_TOTAL_MIN_EVENT_OCCURED_INT_MASK                          0x00000400L
#define DISP_INTERRUPT_STATUS_CONTINUE__DIGB_DP_FAST_TRAINING_COMPLETE_INTERRUPT_MASK                         0x00008000L
#define DISP_INTERRUPT_STATUS_CONTINUE__DIGB_DP_VID_STREAM_DISABLE_INTERRUPT_MASK                             0x00010000L
#define DISP_INTERRUPT_STATUS_CONTINUE__DC_HPD2_INTERRUPT_MASK                                                0x00020000L
#define DISP_INTERRUPT_STATUS_CONTINUE__DC_HPD2_RX_INTERRUPT_MASK                                             0x00040000L
#define DISP_INTERRUPT_STATUS_CONTINUE__AUX2_SW_DONE_INTERRUPT_MASK                                           0x00080000L
#define DISP_INTERRUPT_STATUS_CONTINUE__AUX2_LS_DONE_INTERRUPT_MASK                                           0x00100000L
#define DISP_INTERRUPT_STATUS_CONTINUE__LB_D1_VLINE2_INTERRUPT_MASK                                           0x00200000L
#define DISP_INTERRUPT_STATUS_CONTINUE__LB_D2_VLINE2_INTERRUPT_MASK                                           0x00400000L
#define DISP_INTERRUPT_STATUS_CONTINUE__LB_D3_VLINE2_INTERRUPT_MASK                                           0x00800000L
#define DISP_INTERRUPT_STATUS_CONTINUE__CRTC1_EXT_TIMING_SYNC_LOSS_INTERRUPT_MASK                             0x02000000L
#define DISP_INTERRUPT_STATUS_CONTINUE__CRTC1_EXT_TIMING_SYNC_INTERRUPT_MASK                                  0x04000000L
#define DISP_INTERRUPT_STATUS_CONTINUE__CRTC1_EXT_TIMING_SYNC_SIGNAL_INTERRUPT_MASK                           0x08000000L
#define DISP_INTERRUPT_STATUS_CONTINUE__CRTC1_VERTICAL_INTERRUPT0_MASK                                        0x10000000L
#define DISP_INTERRUPT_STATUS_CONTINUE__CRTC1_VERTICAL_INTERRUPT1_MASK                                        0x20000000L
#define DISP_INTERRUPT_STATUS_CONTINUE__CRTC1_VERTICAL_INTERRUPT2_MASK                                        0x40000000L
#define DISP_INTERRUPT_STATUS_CONTINUE__DISP_INTERRUPT_STATUS_CONTINUE2_MASK                                  0x80000000L
//DISP_INTERRUPT_STATUS_CONTINUE2
#define DISP_INTERRUPT_STATUS_CONTINUE2__SCL_DISP3_MODE_CHANGE_INTERRUPT__SHIFT                               0x0
#define DISP_INTERRUPT_STATUS_CONTINUE2__D3BLND_DATA_UNDERFLOW_INTERRUPT__SHIFT                               0x1
#define DISP_INTERRUPT_STATUS_CONTINUE2__LB_D3_VLINE_INTERRUPT__SHIFT                                         0x2
#define DISP_INTERRUPT_STATUS_CONTINUE2__LB_D3_VBLANK_INTERRUPT__SHIFT                                        0x3
#define DISP_INTERRUPT_STATUS_CONTINUE2__CRTC3_SNAPSHOT_INTERRUPT__SHIFT                                      0x4
#define DISP_INTERRUPT_STATUS_CONTINUE2__CRTC3_FORCE_VSYNC_NEXT_LINE_INTERRUPT__SHIFT                         0x5
#define DISP_INTERRUPT_STATUS_CONTINUE2__CRTC3_FORCE_COUNT_NOW_INTERRUPT__SHIFT                               0x6
#define DISP_INTERRUPT_STATUS_CONTINUE2__CRTC3_TRIGA_INTERRUPT__SHIFT                                         0x7
#define DISP_INTERRUPT_STATUS_CONTINUE2__CRTC3_TRIGB_INTERRUPT__SHIFT                                         0x8
#define DISP_INTERRUPT_STATUS_CONTINUE2__CRTC3_VSYNC_NOM_INTERRUPT__SHIFT                                     0x9
#define DISP_INTERRUPT_STATUS_CONTINUE2__CRTC3_SET_V_TOTAL_MIN_EVENT_OCCURED_INT__SHIFT                       0xa
#define DISP_INTERRUPT_STATUS_CONTINUE2__DIGC_DP_FAST_TRAINING_COMPLETE_INTERRUPT__SHIFT                      0xf
#define DISP_INTERRUPT_STATUS_CONTINUE2__DIGC_DP_VID_STREAM_DISABLE_INTERRUPT__SHIFT                          0x10
#define DISP_INTERRUPT_STATUS_CONTINUE2__DC_HPD3_INTERRUPT__SHIFT                                             0x11
#define DISP_INTERRUPT_STATUS_CONTINUE2__DC_HPD3_RX_INTERRUPT__SHIFT                                          0x12
#define DISP_INTERRUPT_STATUS_CONTINUE2__AUX3_SW_DONE_INTERRUPT__SHIFT                                        0x13
#define DISP_INTERRUPT_STATUS_CONTINUE2__AUX3_LS_DONE_INTERRUPT__SHIFT                                        0x14
#define DISP_INTERRUPT_STATUS_CONTINUE2__LB_D4_VLINE2_INTERRUPT__SHIFT                                        0x15
#define DISP_INTERRUPT_STATUS_CONTINUE2__LB_D5_VLINE2_INTERRUPT__SHIFT                                        0x16
#define DISP_INTERRUPT_STATUS_CONTINUE2__LB_D6_VLINE2_INTERRUPT__SHIFT                                        0x17
#define DISP_INTERRUPT_STATUS_CONTINUE2__CRTC2_EXT_TIMING_SYNC_LOSS_INTERRUPT__SHIFT                          0x19
#define DISP_INTERRUPT_STATUS_CONTINUE2__CRTC2_EXT_TIMING_SYNC_INTERRUPT__SHIFT                               0x1a
#define DISP_INTERRUPT_STATUS_CONTINUE2__CRTC2_EXT_TIMING_SYNC_SIGNAL_INTERRUPT__SHIFT                        0x1b
#define DISP_INTERRUPT_STATUS_CONTINUE2__CRTC2_VERTICAL_INTERRUPT0__SHIFT                                     0x1c
#define DISP_INTERRUPT_STATUS_CONTINUE2__CRTC2_VERTICAL_INTERRUPT1__SHIFT                                     0x1d
#define DISP_INTERRUPT_STATUS_CONTINUE2__CRTC2_VERTICAL_INTERRUPT2__SHIFT                                     0x1e
#define DISP_INTERRUPT_STATUS_CONTINUE2__DISP_INTERRUPT_STATUS_CONTINUE3__SHIFT                               0x1f
#define DISP_INTERRUPT_STATUS_CONTINUE2__SCL_DISP3_MODE_CHANGE_INTERRUPT_MASK                                 0x00000001L
#define DISP_INTERRUPT_STATUS_CONTINUE2__D3BLND_DATA_UNDERFLOW_INTERRUPT_MASK                                 0x00000002L
#define DISP_INTERRUPT_STATUS_CONTINUE2__LB_D3_VLINE_INTERRUPT_MASK                                           0x00000004L
#define DISP_INTERRUPT_STATUS_CONTINUE2__LB_D3_VBLANK_INTERRUPT_MASK                                          0x00000008L
#define DISP_INTERRUPT_STATUS_CONTINUE2__CRTC3_SNAPSHOT_INTERRUPT_MASK                                        0x00000010L
#define DISP_INTERRUPT_STATUS_CONTINUE2__CRTC3_FORCE_VSYNC_NEXT_LINE_INTERRUPT_MASK                           0x00000020L
#define DISP_INTERRUPT_STATUS_CONTINUE2__CRTC3_FORCE_COUNT_NOW_INTERRUPT_MASK                                 0x00000040L
#define DISP_INTERRUPT_STATUS_CONTINUE2__CRTC3_TRIGA_INTERRUPT_MASK                                           0x00000080L
#define DISP_INTERRUPT_STATUS_CONTINUE2__CRTC3_TRIGB_INTERRUPT_MASK                                           0x00000100L
#define DISP_INTERRUPT_STATUS_CONTINUE2__CRTC3_VSYNC_NOM_INTERRUPT_MASK                                       0x00000200L
#define DISP_INTERRUPT_STATUS_CONTINUE2__CRTC3_SET_V_TOTAL_MIN_EVENT_OCCURED_INT_MASK                         0x00000400L
#define DISP_INTERRUPT_STATUS_CONTINUE2__DIGC_DP_FAST_TRAINING_COMPLETE_INTERRUPT_MASK                        0x00008000L
#define DISP_INTERRUPT_STATUS_CONTINUE2__DIGC_DP_VID_STREAM_DISABLE_INTERRUPT_MASK                            0x00010000L
#define DISP_INTERRUPT_STATUS_CONTINUE2__DC_HPD3_INTERRUPT_MASK                                               0x00020000L
#define DISP_INTERRUPT_STATUS_CONTINUE2__DC_HPD3_RX_INTERRUPT_MASK                                            0x00040000L
#define DISP_INTERRUPT_STATUS_CONTINUE2__AUX3_SW_DONE_INTERRUPT_MASK                                          0x00080000L
#define DISP_INTERRUPT_STATUS_CONTINUE2__AUX3_LS_DONE_INTERRUPT_MASK                                          0x00100000L
#define DISP_INTERRUPT_STATUS_CONTINUE2__LB_D4_VLINE2_INTERRUPT_MASK                                          0x00200000L
#define DISP_INTERRUPT_STATUS_CONTINUE2__LB_D5_VLINE2_INTERRUPT_MASK                                          0x00400000L
#define DISP_INTERRUPT_STATUS_CONTINUE2__LB_D6_VLINE2_INTERRUPT_MASK                                          0x00800000L
#define DISP_INTERRUPT_STATUS_CONTINUE2__CRTC2_EXT_TIMING_SYNC_LOSS_INTERRUPT_MASK                            0x02000000L
#define DISP_INTERRUPT_STATUS_CONTINUE2__CRTC2_EXT_TIMING_SYNC_INTERRUPT_MASK                                 0x04000000L
#define DISP_INTERRUPT_STATUS_CONTINUE2__CRTC2_EXT_TIMING_SYNC_SIGNAL_INTERRUPT_MASK                          0x08000000L
#define DISP_INTERRUPT_STATUS_CONTINUE2__CRTC2_VERTICAL_INTERRUPT0_MASK                                       0x10000000L
#define DISP_INTERRUPT_STATUS_CONTINUE2__CRTC2_VERTICAL_INTERRUPT1_MASK                                       0x20000000L
#define DISP_INTERRUPT_STATUS_CONTINUE2__CRTC2_VERTICAL_INTERRUPT2_MASK                                       0x40000000L
#define DISP_INTERRUPT_STATUS_CONTINUE2__DISP_INTERRUPT_STATUS_CONTINUE3_MASK                                 0x80000000L
//DISP_INTERRUPT_STATUS_CONTINUE3
#define DISP_INTERRUPT_STATUS_CONTINUE3__SCL_DISP4_MODE_CHANGE_INTERRUPT__SHIFT                               0x0
#define DISP_INTERRUPT_STATUS_CONTINUE3__D4BLND_DATA_UNDERFLOW_INTERRUPT__SHIFT                               0x1
#define DISP_INTERRUPT_STATUS_CONTINUE3__LB_D4_VLINE_INTERRUPT__SHIFT                                         0x2
#define DISP_INTERRUPT_STATUS_CONTINUE3__LB_D4_VBLANK_INTERRUPT__SHIFT                                        0x3
#define DISP_INTERRUPT_STATUS_CONTINUE3__CRTC4_SNAPSHOT_INTERRUPT__SHIFT                                      0x4
#define DISP_INTERRUPT_STATUS_CONTINUE3__CRTC4_FORCE_VSYNC_NEXT_LINE_INTERRUPT__SHIFT                         0x5
#define DISP_INTERRUPT_STATUS_CONTINUE3__CRTC4_FORCE_COUNT_NOW_INTERRUPT__SHIFT                               0x6
#define DISP_INTERRUPT_STATUS_CONTINUE3__CRTC4_TRIGA_INTERRUPT__SHIFT                                         0x7
#define DISP_INTERRUPT_STATUS_CONTINUE3__CRTC4_TRIGB_INTERRUPT__SHIFT                                         0x8
#define DISP_INTERRUPT_STATUS_CONTINUE3__CRTC4_VSYNC_NOM_INTERRUPT__SHIFT                                     0x9
#define DISP_INTERRUPT_STATUS_CONTINUE3__CRTC4_SET_V_TOTAL_MIN_EVENT_OCCURED_INT__SHIFT                       0xa
#define DISP_INTERRUPT_STATUS_CONTINUE3__DIGD_DP_FAST_TRAINING_COMPLETE_INTERRUPT__SHIFT                      0xf
#define DISP_INTERRUPT_STATUS_CONTINUE3__DIGD_DP_VID_STREAM_DISABLE_INTERRUPT__SHIFT                          0x10
#define DISP_INTERRUPT_STATUS_CONTINUE3__DC_HPD4_INTERRUPT__SHIFT                                             0x11
#define DISP_INTERRUPT_STATUS_CONTINUE3__DC_HPD4_RX_INTERRUPT__SHIFT                                          0x12
#define DISP_INTERRUPT_STATUS_CONTINUE3__AUX4_SW_DONE_INTERRUPT__SHIFT                                        0x13
#define DISP_INTERRUPT_STATUS_CONTINUE3__AUX4_LS_DONE_INTERRUPT__SHIFT                                        0x14
#define DISP_INTERRUPT_STATUS_CONTINUE3__BUFMGR_IHIF_INTERRUPT__SHIFT                                         0x15
#define DISP_INTERRUPT_STATUS_CONTINUE3__WBSCL_HOST_CONFLICT_INTERRUPT__SHIFT                                 0x16
#define DISP_INTERRUPT_STATUS_CONTINUE3__WBSCL_DATA_OVERFLOW_INTERRUPT__SHIFT                                 0x17
#define DISP_INTERRUPT_STATUS_CONTINUE3__CRTC3_EXT_TIMING_SYNC_LOSS_INTERRUPT__SHIFT                          0x19
#define DISP_INTERRUPT_STATUS_CONTINUE3__CRTC3_EXT_TIMING_SYNC_INTERRUPT__SHIFT                               0x1a
#define DISP_INTERRUPT_STATUS_CONTINUE3__CRTC3_EXT_TIMING_SYNC_SIGNAL_INTERRUPT__SHIFT                        0x1b
#define DISP_INTERRUPT_STATUS_CONTINUE3__CRTC3_VERTICAL_INTERRUPT0__SHIFT                                     0x1c
#define DISP_INTERRUPT_STATUS_CONTINUE3__CRTC3_VERTICAL_INTERRUPT1__SHIFT                                     0x1d
#define DISP_INTERRUPT_STATUS_CONTINUE3__CRTC3_VERTICAL_INTERRUPT2__SHIFT                                     0x1e
#define DISP_INTERRUPT_STATUS_CONTINUE3__DISP_INTERRUPT_STATUS_CONTINUE4__SHIFT                               0x1f
#define DISP_INTERRUPT_STATUS_CONTINUE3__SCL_DISP4_MODE_CHANGE_INTERRUPT_MASK                                 0x00000001L
#define DISP_INTERRUPT_STATUS_CONTINUE3__D4BLND_DATA_UNDERFLOW_INTERRUPT_MASK                                 0x00000002L
#define DISP_INTERRUPT_STATUS_CONTINUE3__LB_D4_VLINE_INTERRUPT_MASK                                           0x00000004L
#define DISP_INTERRUPT_STATUS_CONTINUE3__LB_D4_VBLANK_INTERRUPT_MASK                                          0x00000008L
#define DISP_INTERRUPT_STATUS_CONTINUE3__CRTC4_SNAPSHOT_INTERRUPT_MASK                                        0x00000010L
#define DISP_INTERRUPT_STATUS_CONTINUE3__CRTC4_FORCE_VSYNC_NEXT_LINE_INTERRUPT_MASK                           0x00000020L
#define DISP_INTERRUPT_STATUS_CONTINUE3__CRTC4_FORCE_COUNT_NOW_INTERRUPT_MASK                                 0x00000040L
#define DISP_INTERRUPT_STATUS_CONTINUE3__CRTC4_TRIGA_INTERRUPT_MASK                                           0x00000080L
#define DISP_INTERRUPT_STATUS_CONTINUE3__CRTC4_TRIGB_INTERRUPT_MASK                                           0x00000100L
#define DISP_INTERRUPT_STATUS_CONTINUE3__CRTC4_VSYNC_NOM_INTERRUPT_MASK                                       0x00000200L
#define DISP_INTERRUPT_STATUS_CONTINUE3__CRTC4_SET_V_TOTAL_MIN_EVENT_OCCURED_INT_MASK                         0x00000400L
#define DISP_INTERRUPT_STATUS_CONTINUE3__DIGD_DP_FAST_TRAINING_COMPLETE_INTERRUPT_MASK                        0x00008000L
#define DISP_INTERRUPT_STATUS_CONTINUE3__DIGD_DP_VID_STREAM_DISABLE_INTERRUPT_MASK                            0x00010000L
#define DISP_INTERRUPT_STATUS_CONTINUE3__DC_HPD4_INTERRUPT_MASK                                               0x00020000L
#define DISP_INTERRUPT_STATUS_CONTINUE3__DC_HPD4_RX_INTERRUPT_MASK                                            0x00040000L
#define DISP_INTERRUPT_STATUS_CONTINUE3__AUX4_SW_DONE_INTERRUPT_MASK                                          0x00080000L
#define DISP_INTERRUPT_STATUS_CONTINUE3__AUX4_LS_DONE_INTERRUPT_MASK                                          0x00100000L
#define DISP_INTERRUPT_STATUS_CONTINUE3__BUFMGR_IHIF_INTERRUPT_MASK                                           0x00200000L
#define DISP_INTERRUPT_STATUS_CONTINUE3__WBSCL_HOST_CONFLICT_INTERRUPT_MASK                                   0x00400000L
#define DISP_INTERRUPT_STATUS_CONTINUE3__WBSCL_DATA_OVERFLOW_INTERRUPT_MASK                                   0x00800000L
#define DISP_INTERRUPT_STATUS_CONTINUE3__CRTC3_EXT_TIMING_SYNC_LOSS_INTERRUPT_MASK                            0x02000000L
#define DISP_INTERRUPT_STATUS_CONTINUE3__CRTC3_EXT_TIMING_SYNC_INTERRUPT_MASK                                 0x04000000L
#define DISP_INTERRUPT_STATUS_CONTINUE3__CRTC3_EXT_TIMING_SYNC_SIGNAL_INTERRUPT_MASK                          0x08000000L
#define DISP_INTERRUPT_STATUS_CONTINUE3__CRTC3_VERTICAL_INTERRUPT0_MASK                                       0x10000000L
#define DISP_INTERRUPT_STATUS_CONTINUE3__CRTC3_VERTICAL_INTERRUPT1_MASK                                       0x20000000L
#define DISP_INTERRUPT_STATUS_CONTINUE3__CRTC3_VERTICAL_INTERRUPT2_MASK                                       0x40000000L
#define DISP_INTERRUPT_STATUS_CONTINUE3__DISP_INTERRUPT_STATUS_CONTINUE4_MASK                                 0x80000000L
//DISP_INTERRUPT_STATUS_CONTINUE4
#define DISP_INTERRUPT_STATUS_CONTINUE4__SCL_DISP5_MODE_CHANGE_INTERRUPT__SHIFT                               0x0
#define DISP_INTERRUPT_STATUS_CONTINUE4__D5BLND_DATA_UNDERFLOW_INTERRUPT__SHIFT                               0x1
#define DISP_INTERRUPT_STATUS_CONTINUE4__LB_D5_VLINE_INTERRUPT__SHIFT                                         0x2
#define DISP_INTERRUPT_STATUS_CONTINUE4__LB_D5_VBLANK_INTERRUPT__SHIFT                                        0x3
#define DISP_INTERRUPT_STATUS_CONTINUE4__CRTC5_SNAPSHOT_INTERRUPT__SHIFT                                      0x4
#define DISP_INTERRUPT_STATUS_CONTINUE4__CRTC5_FORCE_VSYNC_NEXT_LINE_INTERRUPT__SHIFT                         0x5
#define DISP_INTERRUPT_STATUS_CONTINUE4__CRTC5_FORCE_COUNT_NOW_INTERRUPT__SHIFT                               0x6
#define DISP_INTERRUPT_STATUS_CONTINUE4__CRTC5_TRIGA_INTERRUPT__SHIFT                                         0x7
#define DISP_INTERRUPT_STATUS_CONTINUE4__CRTC5_TRIGB_INTERRUPT__SHIFT                                         0x8
#define DISP_INTERRUPT_STATUS_CONTINUE4__CRTC5_VSYNC_NOM_INTERRUPT__SHIFT                                     0x9
#define DISP_INTERRUPT_STATUS_CONTINUE4__CRTC5_SET_V_TOTAL_MIN_EVENT_OCCURED_INT__SHIFT                       0xa
#define DISP_INTERRUPT_STATUS_CONTINUE4__DIGE_DP_FAST_TRAINING_COMPLETE_INTERRUPT__SHIFT                      0xf
#define DISP_INTERRUPT_STATUS_CONTINUE4__DIGE_DP_VID_STREAM_DISABLE_INTERRUPT__SHIFT                          0x10
#define DISP_INTERRUPT_STATUS_CONTINUE4__DC_HPD5_INTERRUPT__SHIFT                                             0x11
#define DISP_INTERRUPT_STATUS_CONTINUE4__DC_HPD5_RX_INTERRUPT__SHIFT                                          0x12
#define DISP_INTERRUPT_STATUS_CONTINUE4__AUX5_SW_DONE_INTERRUPT__SHIFT                                        0x13
#define DISP_INTERRUPT_STATUS_CONTINUE4__AUX5_LS_DONE_INTERRUPT__SHIFT                                        0x14
#define DISP_INTERRUPT_STATUS_CONTINUE4__CRTC4_EXT_TIMING_SYNC_LOSS_INTERRUPT__SHIFT                          0x16
#define DISP_INTERRUPT_STATUS_CONTINUE4__CRTC4_EXT_TIMING_SYNC_INTERRUPT__SHIFT                               0x17
#define DISP_INTERRUPT_STATUS_CONTINUE4__CRTC4_EXT_TIMING_SYNC_SIGNAL_INTERRUPT__SHIFT                        0x18
#define DISP_INTERRUPT_STATUS_CONTINUE4__CRTC5_EXT_TIMING_SYNC_LOSS_INTERRUPT__SHIFT                          0x19
#define DISP_INTERRUPT_STATUS_CONTINUE4__CRTC5_EXT_TIMING_SYNC_INTERRUPT__SHIFT                               0x1a
#define DISP_INTERRUPT_STATUS_CONTINUE4__CRTC5_EXT_TIMING_SYNC_SIGNAL_INTERRUPT__SHIFT                        0x1b
#define DISP_INTERRUPT_STATUS_CONTINUE4__CRTC4_VERTICAL_INTERRUPT0__SHIFT                                     0x1c
#define DISP_INTERRUPT_STATUS_CONTINUE4__CRTC4_VERTICAL_INTERRUPT1__SHIFT                                     0x1d
#define DISP_INTERRUPT_STATUS_CONTINUE4__CRTC4_VERTICAL_INTERRUPT2__SHIFT                                     0x1e
#define DISP_INTERRUPT_STATUS_CONTINUE4__DISP_INTERRUPT_STATUS_CONTINUE5__SHIFT                               0x1f
#define DISP_INTERRUPT_STATUS_CONTINUE4__SCL_DISP5_MODE_CHANGE_INTERRUPT_MASK                                 0x00000001L
#define DISP_INTERRUPT_STATUS_CONTINUE4__D5BLND_DATA_UNDERFLOW_INTERRUPT_MASK                                 0x00000002L
#define DISP_INTERRUPT_STATUS_CONTINUE4__LB_D5_VLINE_INTERRUPT_MASK                                           0x00000004L
#define DISP_INTERRUPT_STATUS_CONTINUE4__LB_D5_VBLANK_INTERRUPT_MASK                                          0x00000008L
#define DISP_INTERRUPT_STATUS_CONTINUE4__CRTC5_SNAPSHOT_INTERRUPT_MASK                                        0x00000010L
#define DISP_INTERRUPT_STATUS_CONTINUE4__CRTC5_FORCE_VSYNC_NEXT_LINE_INTERRUPT_MASK                           0x00000020L
#define DISP_INTERRUPT_STATUS_CONTINUE4__CRTC5_FORCE_COUNT_NOW_INTERRUPT_MASK                                 0x00000040L
#define DISP_INTERRUPT_STATUS_CONTINUE4__CRTC5_TRIGA_INTERRUPT_MASK                                           0x00000080L
#define DISP_INTERRUPT_STATUS_CONTINUE4__CRTC5_TRIGB_INTERRUPT_MASK                                           0x00000100L
#define DISP_INTERRUPT_STATUS_CONTINUE4__CRTC5_VSYNC_NOM_INTERRUPT_MASK                                       0x00000200L
#define DISP_INTERRUPT_STATUS_CONTINUE4__CRTC5_SET_V_TOTAL_MIN_EVENT_OCCURED_INT_MASK                         0x00000400L
#define DISP_INTERRUPT_STATUS_CONTINUE4__DIGE_DP_FAST_TRAINING_COMPLETE_INTERRUPT_MASK                        0x00008000L
#define DISP_INTERRUPT_STATUS_CONTINUE4__DIGE_DP_VID_STREAM_DISABLE_INTERRUPT_MASK                            0x00010000L
#define DISP_INTERRUPT_STATUS_CONTINUE4__DC_HPD5_INTERRUPT_MASK                                               0x00020000L
#define DISP_INTERRUPT_STATUS_CONTINUE4__DC_HPD5_RX_INTERRUPT_MASK                                            0x00040000L
#define DISP_INTERRUPT_STATUS_CONTINUE4__AUX5_SW_DONE_INTERRUPT_MASK                                          0x00080000L
#define DISP_INTERRUPT_STATUS_CONTINUE4__AUX5_LS_DONE_INTERRUPT_MASK                                          0x00100000L
#define DISP_INTERRUPT_STATUS_CONTINUE4__CRTC4_EXT_TIMING_SYNC_LOSS_INTERRUPT_MASK                            0x00400000L
#define DISP_INTERRUPT_STATUS_CONTINUE4__CRTC4_EXT_TIMING_SYNC_INTERRUPT_MASK                                 0x00800000L
#define DISP_INTERRUPT_STATUS_CONTINUE4__CRTC4_EXT_TIMING_SYNC_SIGNAL_INTERRUPT_MASK                          0x01000000L
#define DISP_INTERRUPT_STATUS_CONTINUE4__CRTC5_EXT_TIMING_SYNC_LOSS_INTERRUPT_MASK                            0x02000000L
#define DISP_INTERRUPT_STATUS_CONTINUE4__CRTC5_EXT_TIMING_SYNC_INTERRUPT_MASK                                 0x04000000L
#define DISP_INTERRUPT_STATUS_CONTINUE4__CRTC5_EXT_TIMING_SYNC_SIGNAL_INTERRUPT_MASK                          0x08000000L
#define DISP_INTERRUPT_STATUS_CONTINUE4__CRTC4_VERTICAL_INTERRUPT0_MASK                                       0x10000000L
#define DISP_INTERRUPT_STATUS_CONTINUE4__CRTC4_VERTICAL_INTERRUPT1_MASK                                       0x20000000L
#define DISP_INTERRUPT_STATUS_CONTINUE4__CRTC4_VERTICAL_INTERRUPT2_MASK                                       0x40000000L
#define DISP_INTERRUPT_STATUS_CONTINUE4__DISP_INTERRUPT_STATUS_CONTINUE5_MASK                                 0x80000000L
//DISP_INTERRUPT_STATUS_CONTINUE5
#define DISP_INTERRUPT_STATUS_CONTINUE5__SCL_DISP6_MODE_CHANGE_INTERRUPT__SHIFT                               0x0
#define DISP_INTERRUPT_STATUS_CONTINUE5__D6BLND_DATA_UNDERFLOW_INTERRUPT__SHIFT                               0x1
#define DISP_INTERRUPT_STATUS_CONTINUE5__LB_D6_VLINE_INTERRUPT__SHIFT                                         0x2
#define DISP_INTERRUPT_STATUS_CONTINUE5__LB_D6_VBLANK_INTERRUPT__SHIFT                                        0x3
#define DISP_INTERRUPT_STATUS_CONTINUE5__CRTC6_SNAPSHOT_INTERRUPT__SHIFT                                      0x4
#define DISP_INTERRUPT_STATUS_CONTINUE5__CRTC6_FORCE_VSYNC_NEXT_LINE_INTERRUPT__SHIFT                         0x5
#define DISP_INTERRUPT_STATUS_CONTINUE5__CRTC6_FORCE_COUNT_NOW_INTERRUPT__SHIFT                               0x6
#define DISP_INTERRUPT_STATUS_CONTINUE5__CRTC6_TRIGA_INTERRUPT__SHIFT                                         0x7
#define DISP_INTERRUPT_STATUS_CONTINUE5__CRTC6_TRIGB_INTERRUPT__SHIFT                                         0x8
#define DISP_INTERRUPT_STATUS_CONTINUE5__CRTC6_VSYNC_NOM_INTERRUPT__SHIFT                                     0x9
#define DISP_INTERRUPT_STATUS_CONTINUE5__CRTC6_SET_V_TOTAL_MIN_EVENT_OCCURED_INT__SHIFT                       0xa
#define DISP_INTERRUPT_STATUS_CONTINUE5__DIGF_DP_FAST_TRAINING_COMPLETE_INTERRUPT__SHIFT                      0xf
#define DISP_INTERRUPT_STATUS_CONTINUE5__DIGF_DP_VID_STREAM_DISABLE_INTERRUPT__SHIFT                          0x10
#define DISP_INTERRUPT_STATUS_CONTINUE5__DC_HPD6_INTERRUPT__SHIFT                                             0x11
#define DISP_INTERRUPT_STATUS_CONTINUE5__DC_HPD6_RX_INTERRUPT__SHIFT                                          0x12
#define DISP_INTERRUPT_STATUS_CONTINUE5__AUX6_SW_DONE_INTERRUPT__SHIFT                                        0x13
#define DISP_INTERRUPT_STATUS_CONTINUE5__AUX6_LS_DONE_INTERRUPT__SHIFT                                        0x14
#define DISP_INTERRUPT_STATUS_CONTINUE5__CRTC6_EXT_TIMING_SYNC_LOSS_INTERRUPT__SHIFT                          0x16
#define DISP_INTERRUPT_STATUS_CONTINUE5__CRTC6_EXT_TIMING_SYNC_INTERRUPT__SHIFT                               0x17
#define DISP_INTERRUPT_STATUS_CONTINUE5__CRTC6_EXT_TIMING_SYNC_SIGNAL_INTERRUPT__SHIFT                        0x18
#define DISP_INTERRUPT_STATUS_CONTINUE5__CRTC5_VERTICAL_INTERRUPT0__SHIFT                                     0x19
#define DISP_INTERRUPT_STATUS_CONTINUE5__CRTC5_VERTICAL_INTERRUPT1__SHIFT                                     0x1a
#define DISP_INTERRUPT_STATUS_CONTINUE5__CRTC5_VERTICAL_INTERRUPT2__SHIFT                                     0x1b
#define DISP_INTERRUPT_STATUS_CONTINUE5__CRTC6_VERTICAL_INTERRUPT0__SHIFT                                     0x1c
#define DISP_INTERRUPT_STATUS_CONTINUE5__CRTC6_VERTICAL_INTERRUPT1__SHIFT                                     0x1d
#define DISP_INTERRUPT_STATUS_CONTINUE5__CRTC6_VERTICAL_INTERRUPT2__SHIFT                                     0x1e
#define DISP_INTERRUPT_STATUS_CONTINUE5__DISP_INTERRUPT_STATUS_CONTINUE6__SHIFT                               0x1f
#define DISP_INTERRUPT_STATUS_CONTINUE5__SCL_DISP6_MODE_CHANGE_INTERRUPT_MASK                                 0x00000001L
#define DISP_INTERRUPT_STATUS_CONTINUE5__D6BLND_DATA_UNDERFLOW_INTERRUPT_MASK                                 0x00000002L
#define DISP_INTERRUPT_STATUS_CONTINUE5__LB_D6_VLINE_INTERRUPT_MASK                                           0x00000004L
#define DISP_INTERRUPT_STATUS_CONTINUE5__LB_D6_VBLANK_INTERRUPT_MASK                                          0x00000008L
#define DISP_INTERRUPT_STATUS_CONTINUE5__CRTC6_SNAPSHOT_INTERRUPT_MASK                                        0x00000010L
#define DISP_INTERRUPT_STATUS_CONTINUE5__CRTC6_FORCE_VSYNC_NEXT_LINE_INTERRUPT_MASK                           0x00000020L
#define DISP_INTERRUPT_STATUS_CONTINUE5__CRTC6_FORCE_COUNT_NOW_INTERRUPT_MASK                                 0x00000040L
#define DISP_INTERRUPT_STATUS_CONTINUE5__CRTC6_TRIGA_INTERRUPT_MASK                                           0x00000080L
#define DISP_INTERRUPT_STATUS_CONTINUE5__CRTC6_TRIGB_INTERRUPT_MASK                                           0x00000100L
#define DISP_INTERRUPT_STATUS_CONTINUE5__CRTC6_VSYNC_NOM_INTERRUPT_MASK                                       0x00000200L
#define DISP_INTERRUPT_STATUS_CONTINUE5__CRTC6_SET_V_TOTAL_MIN_EVENT_OCCURED_INT_MASK                         0x00000400L
#define DISP_INTERRUPT_STATUS_CONTINUE5__DIGF_DP_FAST_TRAINING_COMPLETE_INTERRUPT_MASK                        0x00008000L
#define DISP_INTERRUPT_STATUS_CONTINUE5__DIGF_DP_VID_STREAM_DISABLE_INTERRUPT_MASK                            0x00010000L
#define DISP_INTERRUPT_STATUS_CONTINUE5__DC_HPD6_INTERRUPT_MASK                                               0x00020000L
#define DISP_INTERRUPT_STATUS_CONTINUE5__DC_HPD6_RX_INTERRUPT_MASK                                            0x00040000L
#define DISP_INTERRUPT_STATUS_CONTINUE5__AUX6_SW_DONE_INTERRUPT_MASK                                          0x00080000L
#define DISP_INTERRUPT_STATUS_CONTINUE5__AUX6_LS_DONE_INTERRUPT_MASK                                          0x00100000L
#define DISP_INTERRUPT_STATUS_CONTINUE5__CRTC6_EXT_TIMING_SYNC_LOSS_INTERRUPT_MASK                            0x00400000L
#define DISP_INTERRUPT_STATUS_CONTINUE5__CRTC6_EXT_TIMING_SYNC_INTERRUPT_MASK                                 0x00800000L
#define DISP_INTERRUPT_STATUS_CONTINUE5__CRTC6_EXT_TIMING_SYNC_SIGNAL_INTERRUPT_MASK                          0x01000000L
#define DISP_INTERRUPT_STATUS_CONTINUE5__CRTC5_VERTICAL_INTERRUPT0_MASK                                       0x02000000L
#define DISP_INTERRUPT_STATUS_CONTINUE5__CRTC5_VERTICAL_INTERRUPT1_MASK                                       0x04000000L
#define DISP_INTERRUPT_STATUS_CONTINUE5__CRTC5_VERTICAL_INTERRUPT2_MASK                                       0x08000000L
#define DISP_INTERRUPT_STATUS_CONTINUE5__CRTC6_VERTICAL_INTERRUPT0_MASK                                       0x10000000L
#define DISP_INTERRUPT_STATUS_CONTINUE5__CRTC6_VERTICAL_INTERRUPT1_MASK                                       0x20000000L
#define DISP_INTERRUPT_STATUS_CONTINUE5__CRTC6_VERTICAL_INTERRUPT2_MASK                                       0x40000000L
#define DISP_INTERRUPT_STATUS_CONTINUE5__DISP_INTERRUPT_STATUS_CONTINUE6_MASK                                 0x80000000L
//DISP_INTERRUPT_STATUS_CONTINUE6
#define DISP_INTERRUPT_STATUS_CONTINUE6__DCRX_PERFMON_COUNTER0_INTERRUPT__SHIFT                               0x0
#define DISP_INTERRUPT_STATUS_CONTINUE6__DCRX_PERFMON_COUNTER1_INTERRUPT__SHIFT                               0x1
#define DISP_INTERRUPT_STATUS_CONTINUE6__DCRX_PERFMON_COUNTER2_INTERRUPT__SHIFT                               0x2
#define DISP_INTERRUPT_STATUS_CONTINUE6__DCRX_PERFMON_COUNTER3_INTERRUPT__SHIFT                               0x3
#define DISP_INTERRUPT_STATUS_CONTINUE6__DCRX_PERFMON_COUNTER4_INTERRUPT__SHIFT                               0x4
#define DISP_INTERRUPT_STATUS_CONTINUE6__DCRX_PERFMON_COUNTER5_INTERRUPT__SHIFT                               0x5
#define DISP_INTERRUPT_STATUS_CONTINUE6__DCRX_PERFMON_COUNTER6_INTERRUPT__SHIFT                               0x6
#define DISP_INTERRUPT_STATUS_CONTINUE6__DCRX_PERFMON_COUNTER7_INTERRUPT__SHIFT                               0x7
#define DISP_INTERRUPT_STATUS_CONTINUE6__DCRX_PERFMON_COUNTER_OFF_INTERRUPT__SHIFT                            0x8
#define DISP_INTERRUPT_STATUS_CONTINUE6__BUFMGR_CWB0_IHIF_INTERRUPT__SHIFT                                    0x9
#define DISP_INTERRUPT_STATUS_CONTINUE6__BUFMGR_CWB1_IHIF_INTERRUPT__SHIFT                                    0xa
#define DISP_INTERRUPT_STATUS_CONTINUE6__DIGG_DP_FAST_TRAINING_COMPLETE_INTERRUPT__SHIFT                      0xf
#define DISP_INTERRUPT_STATUS_CONTINUE6__DIGG_DP_VID_STREAM_DISABLE_INTERRUPT__SHIFT                          0x10
#define DISP_INTERRUPT_STATUS_CONTINUE6__AUX1_GTC_SYNC_LOCK_DONE_INTERRUPT__SHIFT                             0x11
#define DISP_INTERRUPT_STATUS_CONTINUE6__AUX1_GTC_SYNC_ERROR_INTERRUPT__SHIFT                                 0x12
#define DISP_INTERRUPT_STATUS_CONTINUE6__AUX2_GTC_SYNC_LOCK_DONE_INTERRUPT__SHIFT                             0x13
#define DISP_INTERRUPT_STATUS_CONTINUE6__AUX2_GTC_SYNC_ERROR_INTERRUPT__SHIFT                                 0x14
#define DISP_INTERRUPT_STATUS_CONTINUE6__AUX3_GTC_SYNC_LOCK_DONE_INTERRUPT__SHIFT                             0x15
#define DISP_INTERRUPT_STATUS_CONTINUE6__AUX3_GTC_SYNC_ERROR_INTERRUPT__SHIFT                                 0x16
#define DISP_INTERRUPT_STATUS_CONTINUE6__AUX4_GTC_SYNC_LOCK_DONE_INTERRUPT__SHIFT                             0x17
#define DISP_INTERRUPT_STATUS_CONTINUE6__AUX4_GTC_SYNC_ERROR_INTERRUPT__SHIFT                                 0x18
#define DISP_INTERRUPT_STATUS_CONTINUE6__AUX5_GTC_SYNC_LOCK_DONE_INTERRUPT__SHIFT                             0x19
#define DISP_INTERRUPT_STATUS_CONTINUE6__AUX5_GTC_SYNC_ERROR_INTERRUPT__SHIFT                                 0x1a
#define DISP_INTERRUPT_STATUS_CONTINUE6__AUX6_GTC_SYNC_LOCK_DONE_INTERRUPT__SHIFT                             0x1b
#define DISP_INTERRUPT_STATUS_CONTINUE6__AUX6_GTC_SYNC_ERROR_INTERRUPT__SHIFT                                 0x1c
#define DISP_INTERRUPT_STATUS_CONTINUE6__DISP_INTERRUPT_STATUS_CONTINUE7__SHIFT                               0x1f
#define DISP_INTERRUPT_STATUS_CONTINUE6__DCRX_PERFMON_COUNTER0_INTERRUPT_MASK                                 0x00000001L
#define DISP_INTERRUPT_STATUS_CONTINUE6__DCRX_PERFMON_COUNTER1_INTERRUPT_MASK                                 0x00000002L
#define DISP_INTERRUPT_STATUS_CONTINUE6__DCRX_PERFMON_COUNTER2_INTERRUPT_MASK                                 0x00000004L
#define DISP_INTERRUPT_STATUS_CONTINUE6__DCRX_PERFMON_COUNTER3_INTERRUPT_MASK                                 0x00000008L
#define DISP_INTERRUPT_STATUS_CONTINUE6__DCRX_PERFMON_COUNTER4_INTERRUPT_MASK                                 0x00000010L
#define DISP_INTERRUPT_STATUS_CONTINUE6__DCRX_PERFMON_COUNTER5_INTERRUPT_MASK                                 0x00000020L
#define DISP_INTERRUPT_STATUS_CONTINUE6__DCRX_PERFMON_COUNTER6_INTERRUPT_MASK                                 0x00000040L
#define DISP_INTERRUPT_STATUS_CONTINUE6__DCRX_PERFMON_COUNTER7_INTERRUPT_MASK                                 0x00000080L
#define DISP_INTERRUPT_STATUS_CONTINUE6__DCRX_PERFMON_COUNTER_OFF_INTERRUPT_MASK                              0x00000100L
#define DISP_INTERRUPT_STATUS_CONTINUE6__BUFMGR_CWB0_IHIF_INTERRUPT_MASK                                      0x00000200L
#define DISP_INTERRUPT_STATUS_CONTINUE6__BUFMGR_CWB1_IHIF_INTERRUPT_MASK                                      0x00000400L
#define DISP_INTERRUPT_STATUS_CONTINUE6__DIGG_DP_FAST_TRAINING_COMPLETE_INTERRUPT_MASK                        0x00008000L
#define DISP_INTERRUPT_STATUS_CONTINUE6__DIGG_DP_VID_STREAM_DISABLE_INTERRUPT_MASK                            0x00010000L
#define DISP_INTERRUPT_STATUS_CONTINUE6__AUX1_GTC_SYNC_LOCK_DONE_INTERRUPT_MASK                               0x00020000L
#define DISP_INTERRUPT_STATUS_CONTINUE6__AUX1_GTC_SYNC_ERROR_INTERRUPT_MASK                                   0x00040000L
#define DISP_INTERRUPT_STATUS_CONTINUE6__AUX2_GTC_SYNC_LOCK_DONE_INTERRUPT_MASK                               0x00080000L
#define DISP_INTERRUPT_STATUS_CONTINUE6__AUX2_GTC_SYNC_ERROR_INTERRUPT_MASK                                   0x00100000L
#define DISP_INTERRUPT_STATUS_CONTINUE6__AUX3_GTC_SYNC_LOCK_DONE_INTERRUPT_MASK                               0x00200000L
#define DISP_INTERRUPT_STATUS_CONTINUE6__AUX3_GTC_SYNC_ERROR_INTERRUPT_MASK                                   0x00400000L
#define DISP_INTERRUPT_STATUS_CONTINUE6__AUX4_GTC_SYNC_LOCK_DONE_INTERRUPT_MASK                               0x00800000L
#define DISP_INTERRUPT_STATUS_CONTINUE6__AUX4_GTC_SYNC_ERROR_INTERRUPT_MASK                                   0x01000000L
#define DISP_INTERRUPT_STATUS_CONTINUE6__AUX5_GTC_SYNC_LOCK_DONE_INTERRUPT_MASK                               0x02000000L
#define DISP_INTERRUPT_STATUS_CONTINUE6__AUX5_GTC_SYNC_ERROR_INTERRUPT_MASK                                   0x04000000L
#define DISP_INTERRUPT_STATUS_CONTINUE6__AUX6_GTC_SYNC_LOCK_DONE_INTERRUPT_MASK                               0x08000000L
#define DISP_INTERRUPT_STATUS_CONTINUE6__AUX6_GTC_SYNC_ERROR_INTERRUPT_MASK                                   0x10000000L
#define DISP_INTERRUPT_STATUS_CONTINUE6__DISP_INTERRUPT_STATUS_CONTINUE7_MASK                                 0x80000000L
//DISP_INTERRUPT_STATUS_CONTINUE7
#define DISP_INTERRUPT_STATUS_CONTINUE7__DCCG_PERFMON_COUNTER0_INTERRUPT__SHIFT                               0x0
#define DISP_INTERRUPT_STATUS_CONTINUE7__DCCG_PERFMON_COUNTER1_INTERRUPT__SHIFT                               0x1
#define DISP_INTERRUPT_STATUS_CONTINUE7__DCCG_PERFMON_COUNTER2_INTERRUPT__SHIFT                               0x2
#define DISP_INTERRUPT_STATUS_CONTINUE7__DCCG_PERFMON_COUNTER3_INTERRUPT__SHIFT                               0x3
#define DISP_INTERRUPT_STATUS_CONTINUE7__DCCG_PERFMON_COUNTER4_INTERRUPT__SHIFT                               0x4
#define DISP_INTERRUPT_STATUS_CONTINUE7__DCCG_PERFMON_COUNTER5_INTERRUPT__SHIFT                               0x5
#define DISP_INTERRUPT_STATUS_CONTINUE7__DCCG_PERFMON_COUNTER6_INTERRUPT__SHIFT                               0x6
#define DISP_INTERRUPT_STATUS_CONTINUE7__DCCG_PERFMON_COUNTER7_INTERRUPT__SHIFT                               0x7
#define DISP_INTERRUPT_STATUS_CONTINUE7__DCCG_PERFMON_COUNTER_OFF_INTERRUPT__SHIFT                            0x8
#define DISP_INTERRUPT_STATUS_CONTINUE7__DCI_PERFMON_COUNTER0_INTERRUPT__SHIFT                                0x9
#define DISP_INTERRUPT_STATUS_CONTINUE7__DCI_PERFMON_COUNTER1_INTERRUPT__SHIFT                                0xa
#define DISP_INTERRUPT_STATUS_CONTINUE7__DCI_PERFMON_COUNTER2_INTERRUPT__SHIFT                                0xb
#define DISP_INTERRUPT_STATUS_CONTINUE7__DCI_PERFMON_COUNTER3_INTERRUPT__SHIFT                                0xc
#define DISP_INTERRUPT_STATUS_CONTINUE7__DCI_PERFMON_COUNTER4_INTERRUPT__SHIFT                                0xd
#define DISP_INTERRUPT_STATUS_CONTINUE7__DCI_PERFMON_COUNTER5_INTERRUPT__SHIFT                                0xe
#define DISP_INTERRUPT_STATUS_CONTINUE7__DCI_PERFMON_COUNTER6_INTERRUPT__SHIFT                                0xf
#define DISP_INTERRUPT_STATUS_CONTINUE7__DCI_PERFMON_COUNTER7_INTERRUPT__SHIFT                                0x10
#define DISP_INTERRUPT_STATUS_CONTINUE7__DCI_PERFMON_COUNTER_OFF_INTERRUPT__SHIFT                             0x11
#define DISP_INTERRUPT_STATUS_CONTINUE7__DCO_PERFMON_COUNTER0_INTERRUPT__SHIFT                                0x12
#define DISP_INTERRUPT_STATUS_CONTINUE7__DCO_PERFMON_COUNTER1_INTERRUPT__SHIFT                                0x13
#define DISP_INTERRUPT_STATUS_CONTINUE7__DCO_PERFMON_COUNTER2_INTERRUPT__SHIFT                                0x14
#define DISP_INTERRUPT_STATUS_CONTINUE7__DCO_PERFMON_COUNTER3_INTERRUPT__SHIFT                                0x15
#define DISP_INTERRUPT_STATUS_CONTINUE7__DCO_PERFMON_COUNTER4_INTERRUPT__SHIFT                                0x16
#define DISP_INTERRUPT_STATUS_CONTINUE7__DCO_PERFMON_COUNTER5_INTERRUPT__SHIFT                                0x17
#define DISP_INTERRUPT_STATUS_CONTINUE7__DCO_PERFMON_COUNTER6_INTERRUPT__SHIFT                                0x18
#define DISP_INTERRUPT_STATUS_CONTINUE7__DCO_PERFMON_COUNTER7_INTERRUPT__SHIFT                                0x19
#define DISP_INTERRUPT_STATUS_CONTINUE7__DCO_PERFMON_COUNTER_OFF_INTERRUPT__SHIFT                             0x1a
#define DISP_INTERRUPT_STATUS_CONTINUE7__WB_PERFMON_COUNTER0_INTERRUPT__SHIFT                                 0x1b
#define DISP_INTERRUPT_STATUS_CONTINUE7__WB_PERFMON_COUNTER1_INTERRUPT__SHIFT                                 0x1c
#define DISP_INTERRUPT_STATUS_CONTINUE7__WB_PERFMON_COUNTER2_INTERRUPT__SHIFT                                 0x1d
#define DISP_INTERRUPT_STATUS_CONTINUE7__WB_PERFMON_COUNTER3_INTERRUPT__SHIFT                                 0x1e
#define DISP_INTERRUPT_STATUS_CONTINUE7__DISP_INTERRUPT_STATUS_CONTINUE8__SHIFT                               0x1f
#define DISP_INTERRUPT_STATUS_CONTINUE7__DCCG_PERFMON_COUNTER0_INTERRUPT_MASK                                 0x00000001L
#define DISP_INTERRUPT_STATUS_CONTINUE7__DCCG_PERFMON_COUNTER1_INTERRUPT_MASK                                 0x00000002L
#define DISP_INTERRUPT_STATUS_CONTINUE7__DCCG_PERFMON_COUNTER2_INTERRUPT_MASK                                 0x00000004L
#define DISP_INTERRUPT_STATUS_CONTINUE7__DCCG_PERFMON_COUNTER3_INTERRUPT_MASK                                 0x00000008L
#define DISP_INTERRUPT_STATUS_CONTINUE7__DCCG_PERFMON_COUNTER4_INTERRUPT_MASK                                 0x00000010L
#define DISP_INTERRUPT_STATUS_CONTINUE7__DCCG_PERFMON_COUNTER5_INTERRUPT_MASK                                 0x00000020L
#define DISP_INTERRUPT_STATUS_CONTINUE7__DCCG_PERFMON_COUNTER6_INTERRUPT_MASK                                 0x00000040L
#define DISP_INTERRUPT_STATUS_CONTINUE7__DCCG_PERFMON_COUNTER7_INTERRUPT_MASK                                 0x00000080L
#define DISP_INTERRUPT_STATUS_CONTINUE7__DCCG_PERFMON_COUNTER_OFF_INTERRUPT_MASK                              0x00000100L
#define DISP_INTERRUPT_STATUS_CONTINUE7__DCI_PERFMON_COUNTER0_INTERRUPT_MASK                                  0x00000200L
#define DISP_INTERRUPT_STATUS_CONTINUE7__DCI_PERFMON_COUNTER1_INTERRUPT_MASK                                  0x00000400L
#define DISP_INTERRUPT_STATUS_CONTINUE7__DCI_PERFMON_COUNTER2_INTERRUPT_MASK                                  0x00000800L
#define DISP_INTERRUPT_STATUS_CONTINUE7__DCI_PERFMON_COUNTER3_INTERRUPT_MASK                                  0x00001000L
#define DISP_INTERRUPT_STATUS_CONTINUE7__DCI_PERFMON_COUNTER4_INTERRUPT_MASK                                  0x00002000L
#define DISP_INTERRUPT_STATUS_CONTINUE7__DCI_PERFMON_COUNTER5_INTERRUPT_MASK                                  0x00004000L
#define DISP_INTERRUPT_STATUS_CONTINUE7__DCI_PERFMON_COUNTER6_INTERRUPT_MASK                                  0x00008000L
#define DISP_INTERRUPT_STATUS_CONTINUE7__DCI_PERFMON_COUNTER7_INTERRUPT_MASK                                  0x00010000L
#define DISP_INTERRUPT_STATUS_CONTINUE7__DCI_PERFMON_COUNTER_OFF_INTERRUPT_MASK                               0x00020000L
#define DISP_INTERRUPT_STATUS_CONTINUE7__DCO_PERFMON_COUNTER0_INTERRUPT_MASK                                  0x00040000L
#define DISP_INTERRUPT_STATUS_CONTINUE7__DCO_PERFMON_COUNTER1_INTERRUPT_MASK                                  0x00080000L
#define DISP_INTERRUPT_STATUS_CONTINUE7__DCO_PERFMON_COUNTER2_INTERRUPT_MASK                                  0x00100000L
#define DISP_INTERRUPT_STATUS_CONTINUE7__DCO_PERFMON_COUNTER3_INTERRUPT_MASK                                  0x00200000L
#define DISP_INTERRUPT_STATUS_CONTINUE7__DCO_PERFMON_COUNTER4_INTERRUPT_MASK                                  0x00400000L
#define DISP_INTERRUPT_STATUS_CONTINUE7__DCO_PERFMON_COUNTER5_INTERRUPT_MASK                                  0x00800000L
#define DISP_INTERRUPT_STATUS_CONTINUE7__DCO_PERFMON_COUNTER6_INTERRUPT_MASK                                  0x01000000L
#define DISP_INTERRUPT_STATUS_CONTINUE7__DCO_PERFMON_COUNTER7_INTERRUPT_MASK                                  0x02000000L
#define DISP_INTERRUPT_STATUS_CONTINUE7__DCO_PERFMON_COUNTER_OFF_INTERRUPT_MASK                               0x04000000L
#define DISP_INTERRUPT_STATUS_CONTINUE7__WB_PERFMON_COUNTER0_INTERRUPT_MASK                                   0x08000000L
#define DISP_INTERRUPT_STATUS_CONTINUE7__WB_PERFMON_COUNTER1_INTERRUPT_MASK                                   0x10000000L
#define DISP_INTERRUPT_STATUS_CONTINUE7__WB_PERFMON_COUNTER2_INTERRUPT_MASK                                   0x20000000L
#define DISP_INTERRUPT_STATUS_CONTINUE7__WB_PERFMON_COUNTER3_INTERRUPT_MASK                                   0x40000000L
#define DISP_INTERRUPT_STATUS_CONTINUE7__DISP_INTERRUPT_STATUS_CONTINUE8_MASK                                 0x80000000L
//DISP_INTERRUPT_STATUS_CONTINUE8
#define DISP_INTERRUPT_STATUS_CONTINUE8__DCFE0_PERFMON_COUNTER0_INTERRUPT__SHIFT                              0x0
#define DISP_INTERRUPT_STATUS_CONTINUE8__DCFE0_PERFMON_COUNTER1_INTERRUPT__SHIFT                              0x1
#define DISP_INTERRUPT_STATUS_CONTINUE8__DCFE0_PERFMON_COUNTER2_INTERRUPT__SHIFT                              0x2
#define DISP_INTERRUPT_STATUS_CONTINUE8__DCFE0_PERFMON_COUNTER3_INTERRUPT__SHIFT                              0x3
#define DISP_INTERRUPT_STATUS_CONTINUE8__DCFE0_PERFMON_COUNTER4_INTERRUPT__SHIFT                              0x4
#define DISP_INTERRUPT_STATUS_CONTINUE8__DCFE0_PERFMON_COUNTER5_INTERRUPT__SHIFT                              0x5
#define DISP_INTERRUPT_STATUS_CONTINUE8__DCFE0_PERFMON_COUNTER6_INTERRUPT__SHIFT                              0x6
#define DISP_INTERRUPT_STATUS_CONTINUE8__DCFE0_PERFMON_COUNTER7_INTERRUPT__SHIFT                              0x7
#define DISP_INTERRUPT_STATUS_CONTINUE8__DCFE0_PERFMON_COUNTER_OFF_INTERRUPT__SHIFT                           0x8
#define DISP_INTERRUPT_STATUS_CONTINUE8__DCFE1_PERFMON_COUNTER0_INTERRUPT__SHIFT                              0x9
#define DISP_INTERRUPT_STATUS_CONTINUE8__DCFE1_PERFMON_COUNTER1_INTERRUPT__SHIFT                              0xa
#define DISP_INTERRUPT_STATUS_CONTINUE8__DCFE1_PERFMON_COUNTER2_INTERRUPT__SHIFT                              0xb
#define DISP_INTERRUPT_STATUS_CONTINUE8__DCFE1_PERFMON_COUNTER3_INTERRUPT__SHIFT                              0xc
#define DISP_INTERRUPT_STATUS_CONTINUE8__DCFE1_PERFMON_COUNTER4_INTERRUPT__SHIFT                              0xd
#define DISP_INTERRUPT_STATUS_CONTINUE8__DCFE1_PERFMON_COUNTER5_INTERRUPT__SHIFT                              0xe
#define DISP_INTERRUPT_STATUS_CONTINUE8__DCFE1_PERFMON_COUNTER6_INTERRUPT__SHIFT                              0xf
#define DISP_INTERRUPT_STATUS_CONTINUE8__DCFE1_PERFMON_COUNTER7_INTERRUPT__SHIFT                              0x10
#define DISP_INTERRUPT_STATUS_CONTINUE8__DCFE1_PERFMON_COUNTER_OFF_INTERRUPT__SHIFT                           0x11
#define DISP_INTERRUPT_STATUS_CONTINUE8__DCFE2_PERFMON_COUNTER0_INTERRUPT__SHIFT                              0x12
#define DISP_INTERRUPT_STATUS_CONTINUE8__DCFE2_PERFMON_COUNTER1_INTERRUPT__SHIFT                              0x13
#define DISP_INTERRUPT_STATUS_CONTINUE8__DCFE2_PERFMON_COUNTER2_INTERRUPT__SHIFT                              0x14
#define DISP_INTERRUPT_STATUS_CONTINUE8__DCFE2_PERFMON_COUNTER3_INTERRUPT__SHIFT                              0x15
#define DISP_INTERRUPT_STATUS_CONTINUE8__DCFE2_PERFMON_COUNTER4_INTERRUPT__SHIFT                              0x16
#define DISP_INTERRUPT_STATUS_CONTINUE8__DCFE2_PERFMON_COUNTER5_INTERRUPT__SHIFT                              0x17
#define DISP_INTERRUPT_STATUS_CONTINUE8__DCFE2_PERFMON_COUNTER6_INTERRUPT__SHIFT                              0x18
#define DISP_INTERRUPT_STATUS_CONTINUE8__DCFE2_PERFMON_COUNTER7_INTERRUPT__SHIFT                              0x19
#define DISP_INTERRUPT_STATUS_CONTINUE8__DCFE2_PERFMON_COUNTER_OFF_INTERRUPT__SHIFT                           0x1a
#define DISP_INTERRUPT_STATUS_CONTINUE8__WB_PERFMON_COUNTER4_INTERRUPT__SHIFT                                 0x1b
#define DISP_INTERRUPT_STATUS_CONTINUE8__WB_PERFMON_COUNTER5_INTERRUPT__SHIFT                                 0x1c
#define DISP_INTERRUPT_STATUS_CONTINUE8__WB_PERFMON_COUNTER6_INTERRUPT__SHIFT                                 0x1d
#define DISP_INTERRUPT_STATUS_CONTINUE8__WB_PERFMON_COUNTER7_INTERRUPT__SHIFT                                 0x1e
#define DISP_INTERRUPT_STATUS_CONTINUE8__DISP_INTERRUPT_STATUS_CONTINUE9__SHIFT                               0x1f
#define DISP_INTERRUPT_STATUS_CONTINUE8__DCFE0_PERFMON_COUNTER0_INTERRUPT_MASK                                0x00000001L
#define DISP_INTERRUPT_STATUS_CONTINUE8__DCFE0_PERFMON_COUNTER1_INTERRUPT_MASK                                0x00000002L
#define DISP_INTERRUPT_STATUS_CONTINUE8__DCFE0_PERFMON_COUNTER2_INTERRUPT_MASK                                0x00000004L
#define DISP_INTERRUPT_STATUS_CONTINUE8__DCFE0_PERFMON_COUNTER3_INTERRUPT_MASK                                0x00000008L
#define DISP_INTERRUPT_STATUS_CONTINUE8__DCFE0_PERFMON_COUNTER4_INTERRUPT_MASK                                0x00000010L
#define DISP_INTERRUPT_STATUS_CONTINUE8__DCFE0_PERFMON_COUNTER5_INTERRUPT_MASK                                0x00000020L
#define DISP_INTERRUPT_STATUS_CONTINUE8__DCFE0_PERFMON_COUNTER6_INTERRUPT_MASK                                0x00000040L
#define DISP_INTERRUPT_STATUS_CONTINUE8__DCFE0_PERFMON_COUNTER7_INTERRUPT_MASK                                0x00000080L
#define DISP_INTERRUPT_STATUS_CONTINUE8__DCFE0_PERFMON_COUNTER_OFF_INTERRUPT_MASK                             0x00000100L
#define DISP_INTERRUPT_STATUS_CONTINUE8__DCFE1_PERFMON_COUNTER0_INTERRUPT_MASK                                0x00000200L
#define DISP_INTERRUPT_STATUS_CONTINUE8__DCFE1_PERFMON_COUNTER1_INTERRUPT_MASK                                0x00000400L
#define DISP_INTERRUPT_STATUS_CONTINUE8__DCFE1_PERFMON_COUNTER2_INTERRUPT_MASK                                0x00000800L
#define DISP_INTERRUPT_STATUS_CONTINUE8__DCFE1_PERFMON_COUNTER3_INTERRUPT_MASK                                0x00001000L
#define DISP_INTERRUPT_STATUS_CONTINUE8__DCFE1_PERFMON_COUNTER4_INTERRUPT_MASK                                0x00002000L
#define DISP_INTERRUPT_STATUS_CONTINUE8__DCFE1_PERFMON_COUNTER5_INTERRUPT_MASK                                0x00004000L
#define DISP_INTERRUPT_STATUS_CONTINUE8__DCFE1_PERFMON_COUNTER6_INTERRUPT_MASK                                0x00008000L
#define DISP_INTERRUPT_STATUS_CONTINUE8__DCFE1_PERFMON_COUNTER7_INTERRUPT_MASK                                0x00010000L
#define DISP_INTERRUPT_STATUS_CONTINUE8__DCFE1_PERFMON_COUNTER_OFF_INTERRUPT_MASK                             0x00020000L
#define DISP_INTERRUPT_STATUS_CONTINUE8__DCFE2_PERFMON_COUNTER0_INTERRUPT_MASK                                0x00040000L
#define DISP_INTERRUPT_STATUS_CONTINUE8__DCFE2_PERFMON_COUNTER1_INTERRUPT_MASK                                0x00080000L
#define DISP_INTERRUPT_STATUS_CONTINUE8__DCFE2_PERFMON_COUNTER2_INTERRUPT_MASK                                0x00100000L
#define DISP_INTERRUPT_STATUS_CONTINUE8__DCFE2_PERFMON_COUNTER3_INTERRUPT_MASK                                0x00200000L
#define DISP_INTERRUPT_STATUS_CONTINUE8__DCFE2_PERFMON_COUNTER4_INTERRUPT_MASK                                0x00400000L
#define DISP_INTERRUPT_STATUS_CONTINUE8__DCFE2_PERFMON_COUNTER5_INTERRUPT_MASK                                0x00800000L
#define DISP_INTERRUPT_STATUS_CONTINUE8__DCFE2_PERFMON_COUNTER6_INTERRUPT_MASK                                0x01000000L
#define DISP_INTERRUPT_STATUS_CONTINUE8__DCFE2_PERFMON_COUNTER7_INTERRUPT_MASK                                0x02000000L
#define DISP_INTERRUPT_STATUS_CONTINUE8__DCFE2_PERFMON_COUNTER_OFF_INTERRUPT_MASK                             0x04000000L
#define DISP_INTERRUPT_STATUS_CONTINUE8__WB_PERFMON_COUNTER4_INTERRUPT_MASK                                   0x08000000L
#define DISP_INTERRUPT_STATUS_CONTINUE8__WB_PERFMON_COUNTER5_INTERRUPT_MASK                                   0x10000000L
#define DISP_INTERRUPT_STATUS_CONTINUE8__WB_PERFMON_COUNTER6_INTERRUPT_MASK                                   0x20000000L
#define DISP_INTERRUPT_STATUS_CONTINUE8__WB_PERFMON_COUNTER7_INTERRUPT_MASK                                   0x40000000L
#define DISP_INTERRUPT_STATUS_CONTINUE8__DISP_INTERRUPT_STATUS_CONTINUE9_MASK                                 0x80000000L
//DISP_INTERRUPT_STATUS_CONTINUE9
#define DISP_INTERRUPT_STATUS_CONTINUE9__DCFE3_PERFMON_COUNTER0_INTERRUPT__SHIFT                              0x0
#define DISP_INTERRUPT_STATUS_CONTINUE9__DCFE3_PERFMON_COUNTER1_INTERRUPT__SHIFT                              0x1
#define DISP_INTERRUPT_STATUS_CONTINUE9__DCFE3_PERFMON_COUNTER2_INTERRUPT__SHIFT                              0x2
#define DISP_INTERRUPT_STATUS_CONTINUE9__DCFE3_PERFMON_COUNTER3_INTERRUPT__SHIFT                              0x3
#define DISP_INTERRUPT_STATUS_CONTINUE9__DCFE3_PERFMON_COUNTER4_INTERRUPT__SHIFT                              0x4
#define DISP_INTERRUPT_STATUS_CONTINUE9__DCFE3_PERFMON_COUNTER5_INTERRUPT__SHIFT                              0x5
#define DISP_INTERRUPT_STATUS_CONTINUE9__DCFE3_PERFMON_COUNTER6_INTERRUPT__SHIFT                              0x6
#define DISP_INTERRUPT_STATUS_CONTINUE9__DCFE3_PERFMON_COUNTER7_INTERRUPT__SHIFT                              0x7
#define DISP_INTERRUPT_STATUS_CONTINUE9__DCFE3_PERFMON_COUNTER_OFF_INTERRUPT__SHIFT                           0x8
#define DISP_INTERRUPT_STATUS_CONTINUE9__DCFE4_PERFMON_COUNTER0_INTERRUPT__SHIFT                              0x9
#define DISP_INTERRUPT_STATUS_CONTINUE9__DCFE4_PERFMON_COUNTER1_INTERRUPT__SHIFT                              0xa
#define DISP_INTERRUPT_STATUS_CONTINUE9__DCFE4_PERFMON_COUNTER2_INTERRUPT__SHIFT                              0xb
#define DISP_INTERRUPT_STATUS_CONTINUE9__DCFE4_PERFMON_COUNTER3_INTERRUPT__SHIFT                              0xc
#define DISP_INTERRUPT_STATUS_CONTINUE9__DCFE4_PERFMON_COUNTER4_INTERRUPT__SHIFT                              0xd
#define DISP_INTERRUPT_STATUS_CONTINUE9__DCFE4_PERFMON_COUNTER5_INTERRUPT__SHIFT                              0xe
#define DISP_INTERRUPT_STATUS_CONTINUE9__DCFE4_PERFMON_COUNTER6_INTERRUPT__SHIFT                              0xf
#define DISP_INTERRUPT_STATUS_CONTINUE9__DCFE4_PERFMON_COUNTER7_INTERRUPT__SHIFT                              0x10
#define DISP_INTERRUPT_STATUS_CONTINUE9__DCFE4_PERFMON_COUNTER_OFF_INTERRUPT__SHIFT                           0x11
#define DISP_INTERRUPT_STATUS_CONTINUE9__DCFE5_PERFMON_COUNTER0_INTERRUPT__SHIFT                              0x12
#define DISP_INTERRUPT_STATUS_CONTINUE9__DCFE5_PERFMON_COUNTER1_INTERRUPT__SHIFT                              0x13
#define DISP_INTERRUPT_STATUS_CONTINUE9__DCFE5_PERFMON_COUNTER2_INTERRUPT__SHIFT                              0x14
#define DISP_INTERRUPT_STATUS_CONTINUE9__DCFE5_PERFMON_COUNTER3_INTERRUPT__SHIFT                              0x15
#define DISP_INTERRUPT_STATUS_CONTINUE9__DCFE5_PERFMON_COUNTER4_INTERRUPT__SHIFT                              0x16
#define DISP_INTERRUPT_STATUS_CONTINUE9__DCFE5_PERFMON_COUNTER5_INTERRUPT__SHIFT                              0x17
#define DISP_INTERRUPT_STATUS_CONTINUE9__DCFE5_PERFMON_COUNTER6_INTERRUPT__SHIFT                              0x18
#define DISP_INTERRUPT_STATUS_CONTINUE9__DCFE5_PERFMON_COUNTER7_INTERRUPT__SHIFT                              0x19
#define DISP_INTERRUPT_STATUS_CONTINUE9__DCFE5_PERFMON_COUNTER_OFF_INTERRUPT__SHIFT                           0x1a
#define DISP_INTERRUPT_STATUS_CONTINUE9__WB_PERFMON_COUNTER_OFF_INTERRUPT__SHIFT                              0x1b
#define DISP_INTERRUPT_STATUS_CONTINUE9__DISP_INTERRUPT_STATUS_CONTINUE10__SHIFT                              0x1f
#define DISP_INTERRUPT_STATUS_CONTINUE9__DCFE3_PERFMON_COUNTER0_INTERRUPT_MASK                                0x00000001L
#define DISP_INTERRUPT_STATUS_CONTINUE9__DCFE3_PERFMON_COUNTER1_INTERRUPT_MASK                                0x00000002L
#define DISP_INTERRUPT_STATUS_CONTINUE9__DCFE3_PERFMON_COUNTER2_INTERRUPT_MASK                                0x00000004L
#define DISP_INTERRUPT_STATUS_CONTINUE9__DCFE3_PERFMON_COUNTER3_INTERRUPT_MASK                                0x00000008L
#define DISP_INTERRUPT_STATUS_CONTINUE9__DCFE3_PERFMON_COUNTER4_INTERRUPT_MASK                                0x00000010L
#define DISP_INTERRUPT_STATUS_CONTINUE9__DCFE3_PERFMON_COUNTER5_INTERRUPT_MASK                                0x00000020L
#define DISP_INTERRUPT_STATUS_CONTINUE9__DCFE3_PERFMON_COUNTER6_INTERRUPT_MASK                                0x00000040L
#define DISP_INTERRUPT_STATUS_CONTINUE9__DCFE3_PERFMON_COUNTER7_INTERRUPT_MASK                                0x00000080L
#define DISP_INTERRUPT_STATUS_CONTINUE9__DCFE3_PERFMON_COUNTER_OFF_INTERRUPT_MASK                             0x00000100L
#define DISP_INTERRUPT_STATUS_CONTINUE9__DCFE4_PERFMON_COUNTER0_INTERRUPT_MASK                                0x00000200L
#define DISP_INTERRUPT_STATUS_CONTINUE9__DCFE4_PERFMON_COUNTER1_INTERRUPT_MASK                                0x00000400L
#define DISP_INTERRUPT_STATUS_CONTINUE9__DCFE4_PERFMON_COUNTER2_INTERRUPT_MASK                                0x00000800L
#define DISP_INTERRUPT_STATUS_CONTINUE9__DCFE4_PERFMON_COUNTER3_INTERRUPT_MASK                                0x00001000L
#define DISP_INTERRUPT_STATUS_CONTINUE9__DCFE4_PERFMON_COUNTER4_INTERRUPT_MASK                                0x00002000L
#define DISP_INTERRUPT_STATUS_CONTINUE9__DCFE4_PERFMON_COUNTER5_INTERRUPT_MASK                                0x00004000L
#define DISP_INTERRUPT_STATUS_CONTINUE9__DCFE4_PERFMON_COUNTER6_INTERRUPT_MASK                                0x00008000L
#define DISP_INTERRUPT_STATUS_CONTINUE9__DCFE4_PERFMON_COUNTER7_INTERRUPT_MASK                                0x00010000L
#define DISP_INTERRUPT_STATUS_CONTINUE9__DCFE4_PERFMON_COUNTER_OFF_INTERRUPT_MASK                             0x00020000L
#define DISP_INTERRUPT_STATUS_CONTINUE9__DCFE5_PERFMON_COUNTER0_INTERRUPT_MASK                                0x00040000L
#define DISP_INTERRUPT_STATUS_CONTINUE9__DCFE5_PERFMON_COUNTER1_INTERRUPT_MASK                                0x00080000L
#define DISP_INTERRUPT_STATUS_CONTINUE9__DCFE5_PERFMON_COUNTER2_INTERRUPT_MASK                                0x00100000L
#define DISP_INTERRUPT_STATUS_CONTINUE9__DCFE5_PERFMON_COUNTER3_INTERRUPT_MASK                                0x00200000L
#define DISP_INTERRUPT_STATUS_CONTINUE9__DCFE5_PERFMON_COUNTER4_INTERRUPT_MASK                                0x00400000L
#define DISP_INTERRUPT_STATUS_CONTINUE9__DCFE5_PERFMON_COUNTER5_INTERRUPT_MASK                                0x00800000L
#define DISP_INTERRUPT_STATUS_CONTINUE9__DCFE5_PERFMON_COUNTER6_INTERRUPT_MASK                                0x01000000L
#define DISP_INTERRUPT_STATUS_CONTINUE9__DCFE5_PERFMON_COUNTER7_INTERRUPT_MASK                                0x02000000L
#define DISP_INTERRUPT_STATUS_CONTINUE9__DCFE5_PERFMON_COUNTER_OFF_INTERRUPT_MASK                             0x04000000L
#define DISP_INTERRUPT_STATUS_CONTINUE9__WB_PERFMON_COUNTER_OFF_INTERRUPT_MASK                                0x08000000L
#define DISP_INTERRUPT_STATUS_CONTINUE9__DISP_INTERRUPT_STATUS_CONTINUE10_MASK                                0x80000000L
//DCO_MEM_PWR_STATUS
#define DCO_MEM_PWR_STATUS__I2C_MEM_PWR_STATE__SHIFT                                                          0x0
#define DCO_MEM_PWR_STATUS__MVP_MEM_PWR_STATE__SHIFT                                                          0x2
#define DCO_MEM_PWR_STATUS__DPA_MEM_PWR_STATE__SHIFT                                                          0x3
#define DCO_MEM_PWR_STATUS__DPB_MEM_PWR_STATE__SHIFT                                                          0x4
#define DCO_MEM_PWR_STATUS__DPC_MEM_PWR_STATE__SHIFT                                                          0x5
#define DCO_MEM_PWR_STATUS__DPD_MEM_PWR_STATE__SHIFT                                                          0x6
#define DCO_MEM_PWR_STATUS__DPE_MEM_PWR_STATE__SHIFT                                                          0x7
#define DCO_MEM_PWR_STATUS__DPF_MEM_PWR_STATE__SHIFT                                                          0x8
#define DCO_MEM_PWR_STATUS__DPG_MEM_PWR_STATE__SHIFT                                                          0x9
#define DCO_MEM_PWR_STATUS__HDMI0_MEM_PWR_STATE__SHIFT                                                        0xa
#define DCO_MEM_PWR_STATUS__HDMI1_MEM_PWR_STATE__SHIFT                                                        0xc
#define DCO_MEM_PWR_STATUS__HDMI2_MEM_PWR_STATE__SHIFT                                                        0xe
#define DCO_MEM_PWR_STATUS__HDMI3_MEM_PWR_STATE__SHIFT                                                        0x10
#define DCO_MEM_PWR_STATUS__HDMI4_MEM_PWR_STATE__SHIFT                                                        0x12
#define DCO_MEM_PWR_STATUS__HDMI5_MEM_PWR_STATE__SHIFT                                                        0x14
#define DCO_MEM_PWR_STATUS__HDMI6_MEM_PWR_STATE__SHIFT                                                        0x16
#define DCO_MEM_PWR_STATUS__I2C_MEM_PWR_STATE_MASK                                                            0x00000001L
#define DCO_MEM_PWR_STATUS__MVP_MEM_PWR_STATE_MASK                                                            0x00000004L
#define DCO_MEM_PWR_STATUS__DPA_MEM_PWR_STATE_MASK                                                            0x00000008L
#define DCO_MEM_PWR_STATUS__DPB_MEM_PWR_STATE_MASK                                                            0x00000010L
#define DCO_MEM_PWR_STATUS__DPC_MEM_PWR_STATE_MASK                                                            0x00000020L
#define DCO_MEM_PWR_STATUS__DPD_MEM_PWR_STATE_MASK                                                            0x00000040L
#define DCO_MEM_PWR_STATUS__DPE_MEM_PWR_STATE_MASK                                                            0x00000080L
#define DCO_MEM_PWR_STATUS__DPF_MEM_PWR_STATE_MASK                                                            0x00000100L
#define DCO_MEM_PWR_STATUS__DPG_MEM_PWR_STATE_MASK                                                            0x00000200L
#define DCO_MEM_PWR_STATUS__HDMI0_MEM_PWR_STATE_MASK                                                          0x00000C00L
#define DCO_MEM_PWR_STATUS__HDMI1_MEM_PWR_STATE_MASK                                                          0x00003000L
#define DCO_MEM_PWR_STATUS__HDMI2_MEM_PWR_STATE_MASK                                                          0x0000C000L
#define DCO_MEM_PWR_STATUS__HDMI3_MEM_PWR_STATE_MASK                                                          0x00030000L
#define DCO_MEM_PWR_STATUS__HDMI4_MEM_PWR_STATE_MASK                                                          0x000C0000L
#define DCO_MEM_PWR_STATUS__HDMI5_MEM_PWR_STATE_MASK                                                          0x00300000L
#define DCO_MEM_PWR_STATUS__HDMI6_MEM_PWR_STATE_MASK                                                          0x00C00000L
//DCO_MEM_PWR_CTRL
#define DCO_MEM_PWR_CTRL__I2C_LIGHT_SLEEP_FORCE__SHIFT                                                        0x0
#define DCO_MEM_PWR_CTRL__I2C_LIGHT_SLEEP_DIS__SHIFT                                                          0x1
#define DCO_MEM_PWR_CTRL__MVP_LIGHT_SLEEP_DIS__SHIFT                                                          0x3
#define DCO_MEM_PWR_CTRL__DPA_LIGHT_SLEEP_DIS__SHIFT                                                          0x4
#define DCO_MEM_PWR_CTRL__DPB_LIGHT_SLEEP_DIS__SHIFT                                                          0x5
#define DCO_MEM_PWR_CTRL__DPC_LIGHT_SLEEP_DIS__SHIFT                                                          0x6
#define DCO_MEM_PWR_CTRL__DPD_LIGHT_SLEEP_DIS__SHIFT                                                          0x7
#define DCO_MEM_PWR_CTRL__DPE_LIGHT_SLEEP_DIS__SHIFT                                                          0x8
#define DCO_MEM_PWR_CTRL__DPF_LIGHT_SLEEP_DIS__SHIFT                                                          0x9
#define DCO_MEM_PWR_CTRL__DPG_LIGHT_SLEEP_DIS__SHIFT                                                          0xa
#define DCO_MEM_PWR_CTRL__HDMI0_MEM_PWR_FORCE__SHIFT                                                          0xb
#define DCO_MEM_PWR_CTRL__HDMI0_MEM_PWR_DIS__SHIFT                                                            0xd
#define DCO_MEM_PWR_CTRL__HDMI1_MEM_PWR_FORCE__SHIFT                                                          0xe
#define DCO_MEM_PWR_CTRL__HDMI1_MEM_PWR_DIS__SHIFT                                                            0x10
#define DCO_MEM_PWR_CTRL__HDMI2_MEM_PWR_FORCE__SHIFT                                                          0x11
#define DCO_MEM_PWR_CTRL__HDMI2_MEM_PWR_DIS__SHIFT                                                            0x13
#define DCO_MEM_PWR_CTRL__HDMI3_MEM_PWR_FORCE__SHIFT                                                          0x14
#define DCO_MEM_PWR_CTRL__HDMI3_MEM_PWR_DIS__SHIFT                                                            0x16
#define DCO_MEM_PWR_CTRL__HDMI4_MEM_PWR_FORCE__SHIFT                                                          0x17
#define DCO_MEM_PWR_CTRL__HDMI4_MEM_PWR_DIS__SHIFT                                                            0x19
#define DCO_MEM_PWR_CTRL__HDMI5_MEM_PWR_FORCE__SHIFT                                                          0x1a
#define DCO_MEM_PWR_CTRL__HDMI5_MEM_PWR_DIS__SHIFT                                                            0x1c
#define DCO_MEM_PWR_CTRL__HDMI6_MEM_PWR_FORCE__SHIFT                                                          0x1d
#define DCO_MEM_PWR_CTRL__HDMI6_MEM_PWR_DIS__SHIFT                                                            0x1f
#define DCO_MEM_PWR_CTRL__I2C_LIGHT_SLEEP_FORCE_MASK                                                          0x00000001L
#define DCO_MEM_PWR_CTRL__I2C_LIGHT_SLEEP_DIS_MASK                                                            0x00000002L
#define DCO_MEM_PWR_CTRL__MVP_LIGHT_SLEEP_DIS_MASK                                                            0x00000008L
#define DCO_MEM_PWR_CTRL__DPA_LIGHT_SLEEP_DIS_MASK                                                            0x00000010L
#define DCO_MEM_PWR_CTRL__DPB_LIGHT_SLEEP_DIS_MASK                                                            0x00000020L
#define DCO_MEM_PWR_CTRL__DPC_LIGHT_SLEEP_DIS_MASK                                                            0x00000040L
#define DCO_MEM_PWR_CTRL__DPD_LIGHT_SLEEP_DIS_MASK                                                            0x00000080L
#define DCO_MEM_PWR_CTRL__DPE_LIGHT_SLEEP_DIS_MASK                                                            0x00000100L
#define DCO_MEM_PWR_CTRL__DPF_LIGHT_SLEEP_DIS_MASK                                                            0x00000200L
#define DCO_MEM_PWR_CTRL__DPG_LIGHT_SLEEP_DIS_MASK                                                            0x00000400L
#define DCO_MEM_PWR_CTRL__HDMI0_MEM_PWR_FORCE_MASK                                                            0x00001800L
#define DCO_MEM_PWR_CTRL__HDMI0_MEM_PWR_DIS_MASK                                                              0x00002000L
#define DCO_MEM_PWR_CTRL__HDMI1_MEM_PWR_FORCE_MASK                                                            0x0000C000L
#define DCO_MEM_PWR_CTRL__HDMI1_MEM_PWR_DIS_MASK                                                              0x00010000L
#define DCO_MEM_PWR_CTRL__HDMI2_MEM_PWR_FORCE_MASK                                                            0x00060000L
#define DCO_MEM_PWR_CTRL__HDMI2_MEM_PWR_DIS_MASK                                                              0x00080000L
#define DCO_MEM_PWR_CTRL__HDMI3_MEM_PWR_FORCE_MASK                                                            0x00300000L
#define DCO_MEM_PWR_CTRL__HDMI3_MEM_PWR_DIS_MASK                                                              0x00400000L
#define DCO_MEM_PWR_CTRL__HDMI4_MEM_PWR_FORCE_MASK                                                            0x01800000L
#define DCO_MEM_PWR_CTRL__HDMI4_MEM_PWR_DIS_MASK                                                              0x02000000L
#define DCO_MEM_PWR_CTRL__HDMI5_MEM_PWR_FORCE_MASK                                                            0x0C000000L
#define DCO_MEM_PWR_CTRL__HDMI5_MEM_PWR_DIS_MASK                                                              0x10000000L
#define DCO_MEM_PWR_CTRL__HDMI6_MEM_PWR_FORCE_MASK                                                            0x60000000L
#define DCO_MEM_PWR_CTRL__HDMI6_MEM_PWR_DIS_MASK                                                              0x80000000L
//DCO_MEM_PWR_CTRL2
#define DCO_MEM_PWR_CTRL2__HDMI_MEM_PWR_MODE_SEL__SHIFT                                                       0x0
#define DCO_MEM_PWR_CTRL2__DPLPA_LIGHT_SLEEP_DIS__SHIFT                                                       0x2
#define DCO_MEM_PWR_CTRL2__DPLPB_LIGHT_SLEEP_DIS__SHIFT                                                       0x3
#define DCO_MEM_PWR_CTRL2__HDMILP0_MEM_PWR_FORCE__SHIFT                                                       0x10
#define DCO_MEM_PWR_CTRL2__HDMILP0_MEM_PWR_DIS__SHIFT                                                         0x12
#define DCO_MEM_PWR_CTRL2__HDMILP1_MEM_PWR_FORCE__SHIFT                                                       0x13
#define DCO_MEM_PWR_CTRL2__HDMILP1_MEM_PWR_DIS__SHIFT                                                         0x15
#define DCO_MEM_PWR_CTRL2__HDMI_MEM_PWR_MODE_SEL_MASK                                                         0x00000003L
#define DCO_MEM_PWR_CTRL2__DPLPA_LIGHT_SLEEP_DIS_MASK                                                         0x00000004L
#define DCO_MEM_PWR_CTRL2__DPLPB_LIGHT_SLEEP_DIS_MASK                                                         0x00000008L
#define DCO_MEM_PWR_CTRL2__HDMILP0_MEM_PWR_FORCE_MASK                                                         0x00030000L
#define DCO_MEM_PWR_CTRL2__HDMILP0_MEM_PWR_DIS_MASK                                                           0x00040000L
#define DCO_MEM_PWR_CTRL2__HDMILP1_MEM_PWR_FORCE_MASK                                                         0x00180000L
#define DCO_MEM_PWR_CTRL2__HDMILP1_MEM_PWR_DIS_MASK                                                           0x00200000L
//DCO_CLK_CNTL
#define DCO_CLK_CNTL__DISPCLK_R_DCO_GATE_DIS__SHIFT                                                           0x5
#define DCO_CLK_CNTL__DISPCLK_G_ABM_GATE_DIS__SHIFT                                                           0x6
#define DCO_CLK_CNTL__DISPCLK_G_DVO_GATE_DIS__SHIFT                                                           0x7
#define DCO_CLK_CNTL__DISPCLK_G_DACA_GATE_DIS__SHIFT                                                          0x8
#define DCO_CLK_CNTL__DISPCLK_G_DACB_GATE_DIS__SHIFT                                                          0x9
#define DCO_CLK_CNTL__REFCLK_R_DCO_GATE_DIS__SHIFT                                                            0xa
#define DCO_CLK_CNTL__DISPCLK_G_FMT0_GATE_DIS__SHIFT                                                          0x10
#define DCO_CLK_CNTL__DISPCLK_G_FMT1_GATE_DIS__SHIFT                                                          0x11
#define DCO_CLK_CNTL__DISPCLK_G_FMT2_GATE_DIS__SHIFT                                                          0x12
#define DCO_CLK_CNTL__DISPCLK_G_FMT3_GATE_DIS__SHIFT                                                          0x13
#define DCO_CLK_CNTL__DISPCLK_G_FMT4_GATE_DIS__SHIFT                                                          0x14
#define DCO_CLK_CNTL__DISPCLK_G_FMT5_GATE_DIS__SHIFT                                                          0x15
#define DCO_CLK_CNTL__DISPCLK_G_DIGLPA_GATE_DIS__SHIFT                                                        0x16
#define DCO_CLK_CNTL__DISPCLK_G_DIGLPB_GATE_DIS__SHIFT                                                        0x17
#define DCO_CLK_CNTL__DISPCLK_G_DIGA_GATE_DIS__SHIFT                                                          0x18
#define DCO_CLK_CNTL__DISPCLK_G_DIGB_GATE_DIS__SHIFT                                                          0x19
#define DCO_CLK_CNTL__DISPCLK_G_DIGC_GATE_DIS__SHIFT                                                          0x1a
#define DCO_CLK_CNTL__DISPCLK_G_DIGD_GATE_DIS__SHIFT                                                          0x1b
#define DCO_CLK_CNTL__DISPCLK_G_DIGE_GATE_DIS__SHIFT                                                          0x1c
#define DCO_CLK_CNTL__DISPCLK_G_DIGF_GATE_DIS__SHIFT                                                          0x1d
#define DCO_CLK_CNTL__DISPCLK_G_DIGG_GATE_DIS__SHIFT                                                          0x1e
#define DCO_CLK_CNTL__DISPCLK_R_DCO_GATE_DIS_MASK                                                             0x00000020L
#define DCO_CLK_CNTL__DISPCLK_G_ABM_GATE_DIS_MASK                                                             0x00000040L
#define DCO_CLK_CNTL__DISPCLK_G_DVO_GATE_DIS_MASK                                                             0x00000080L
#define DCO_CLK_CNTL__DISPCLK_G_DACA_GATE_DIS_MASK                                                            0x00000100L
#define DCO_CLK_CNTL__DISPCLK_G_DACB_GATE_DIS_MASK                                                            0x00000200L
#define DCO_CLK_CNTL__REFCLK_R_DCO_GATE_DIS_MASK                                                              0x00000400L
#define DCO_CLK_CNTL__DISPCLK_G_FMT0_GATE_DIS_MASK                                                            0x00010000L
#define DCO_CLK_CNTL__DISPCLK_G_FMT1_GATE_DIS_MASK                                                            0x00020000L
#define DCO_CLK_CNTL__DISPCLK_G_FMT2_GATE_DIS_MASK                                                            0x00040000L
#define DCO_CLK_CNTL__DISPCLK_G_FMT3_GATE_DIS_MASK                                                            0x00080000L
#define DCO_CLK_CNTL__DISPCLK_G_FMT4_GATE_DIS_MASK                                                            0x00100000L
#define DCO_CLK_CNTL__DISPCLK_G_FMT5_GATE_DIS_MASK                                                            0x00200000L
#define DCO_CLK_CNTL__DISPCLK_G_DIGLPA_GATE_DIS_MASK                                                          0x00400000L
#define DCO_CLK_CNTL__DISPCLK_G_DIGLPB_GATE_DIS_MASK                                                          0x00800000L
#define DCO_CLK_CNTL__DISPCLK_G_DIGA_GATE_DIS_MASK                                                            0x01000000L
#define DCO_CLK_CNTL__DISPCLK_G_DIGB_GATE_DIS_MASK                                                            0x02000000L
#define DCO_CLK_CNTL__DISPCLK_G_DIGC_GATE_DIS_MASK                                                            0x04000000L
#define DCO_CLK_CNTL__DISPCLK_G_DIGD_GATE_DIS_MASK                                                            0x08000000L
#define DCO_CLK_CNTL__DISPCLK_G_DIGE_GATE_DIS_MASK                                                            0x10000000L
#define DCO_CLK_CNTL__DISPCLK_G_DIGF_GATE_DIS_MASK                                                            0x20000000L
#define DCO_CLK_CNTL__DISPCLK_G_DIGG_GATE_DIS_MASK                                                            0x40000000L
//DCO_POWER_MANAGEMENT_CNTL
#define DCO_POWER_MANAGEMENT_CNTL__PM_ASSERT_RESET__SHIFT                                                     0x0
#define DCO_POWER_MANAGEMENT_CNTL__PM_ALL_BUSY_OFF__SHIFT                                                     0x8
#define DCO_POWER_MANAGEMENT_CNTL__PM_ASSERT_RESET_MASK                                                       0x00000001L
#define DCO_POWER_MANAGEMENT_CNTL__PM_ALL_BUSY_OFF_MASK                                                       0x00000100L
//DIG_SOFT_RESET_2
#define DIG_SOFT_RESET_2__DIGLPA_FE_SOFT_RESET__SHIFT                                                         0x0
#define DIG_SOFT_RESET_2__DIGLPA_BE_SOFT_RESET__SHIFT                                                         0x1
#define DIG_SOFT_RESET_2__DIGLPB_FE_SOFT_RESET__SHIFT                                                         0x4
#define DIG_SOFT_RESET_2__DIGLPB_BE_SOFT_RESET__SHIFT                                                         0x5
#define DIG_SOFT_RESET_2__DIGLPA_FE_SOFT_RESET_MASK                                                           0x00000001L
#define DIG_SOFT_RESET_2__DIGLPA_BE_SOFT_RESET_MASK                                                           0x00000002L
#define DIG_SOFT_RESET_2__DIGLPB_FE_SOFT_RESET_MASK                                                           0x00000010L
#define DIG_SOFT_RESET_2__DIGLPB_BE_SOFT_RESET_MASK                                                           0x00000020L
//DCO_STEREOSYNC_SEL
#define DCO_STEREOSYNC_SEL__GENERICA_STEREOSYNC_SEL__SHIFT                                                    0x0
#define DCO_STEREOSYNC_SEL__GENERICB_STEREOSYNC_SEL__SHIFT                                                    0x10
#define DCO_STEREOSYNC_SEL__GENERICA_STEREOSYNC_SEL_MASK                                                      0x00000007L
#define DCO_STEREOSYNC_SEL__GENERICB_STEREOSYNC_SEL_MASK                                                      0x00070000L
//DCO_SOFT_RESET
#define DCO_SOFT_RESET__DACA_SOFT_RESET__SHIFT                                                                0x0
#define DCO_SOFT_RESET__I2S0_SPDIF0_SOFT_RESET__SHIFT                                                         0x4
#define DCO_SOFT_RESET__I2S1_SOFT_RESET__SHIFT                                                                0x5
#define DCO_SOFT_RESET__SPDIF1_SOFT_RESET__SHIFT                                                              0x6
#define DCO_SOFT_RESET__DB_CLK_SOFT_RESET__SHIFT                                                              0xc
#define DCO_SOFT_RESET__FMT0_SOFT_RESET__SHIFT                                                                0x10
#define DCO_SOFT_RESET__FMT1_SOFT_RESET__SHIFT                                                                0x11
#define DCO_SOFT_RESET__FMT2_SOFT_RESET__SHIFT                                                                0x12
#define DCO_SOFT_RESET__FMT3_SOFT_RESET__SHIFT                                                                0x13
#define DCO_SOFT_RESET__FMT4_SOFT_RESET__SHIFT                                                                0x14
#define DCO_SOFT_RESET__FMT5_SOFT_RESET__SHIFT                                                                0x15
#define DCO_SOFT_RESET__MVP_SOFT_RESET__SHIFT                                                                 0x18
#define DCO_SOFT_RESET__ABM_SOFT_RESET__SHIFT                                                                 0x19
#define DCO_SOFT_RESET__DVO_SOFT_RESET__SHIFT                                                                 0x1b
#define DCO_SOFT_RESET__DACA_SOFT_RESET_MASK                                                                  0x00000001L
#define DCO_SOFT_RESET__I2S0_SPDIF0_SOFT_RESET_MASK                                                           0x00000010L
#define DCO_SOFT_RESET__I2S1_SOFT_RESET_MASK                                                                  0x00000020L
#define DCO_SOFT_RESET__SPDIF1_SOFT_RESET_MASK                                                                0x00000040L
#define DCO_SOFT_RESET__DB_CLK_SOFT_RESET_MASK                                                                0x00001000L
#define DCO_SOFT_RESET__FMT0_SOFT_RESET_MASK                                                                  0x00010000L
#define DCO_SOFT_RESET__FMT1_SOFT_RESET_MASK                                                                  0x00020000L
#define DCO_SOFT_RESET__FMT2_SOFT_RESET_MASK                                                                  0x00040000L
#define DCO_SOFT_RESET__FMT3_SOFT_RESET_MASK                                                                  0x00080000L
#define DCO_SOFT_RESET__FMT4_SOFT_RESET_MASK                                                                  0x00100000L
#define DCO_SOFT_RESET__FMT5_SOFT_RESET_MASK                                                                  0x00200000L
#define DCO_SOFT_RESET__MVP_SOFT_RESET_MASK                                                                   0x01000000L
#define DCO_SOFT_RESET__ABM_SOFT_RESET_MASK                                                                   0x02000000L
#define DCO_SOFT_RESET__DVO_SOFT_RESET_MASK                                                                   0x08000000L
//DIG_SOFT_RESET
#define DIG_SOFT_RESET__DIGA_FE_SOFT_RESET__SHIFT                                                             0x0
#define DIG_SOFT_RESET__DIGA_BE_SOFT_RESET__SHIFT                                                             0x1
#define DIG_SOFT_RESET__DIGB_FE_SOFT_RESET__SHIFT                                                             0x4
#define DIG_SOFT_RESET__DIGB_BE_SOFT_RESET__SHIFT                                                             0x5
#define DIG_SOFT_RESET__DIGC_FE_SOFT_RESET__SHIFT                                                             0x8
#define DIG_SOFT_RESET__DIGC_BE_SOFT_RESET__SHIFT                                                             0x9
#define DIG_SOFT_RESET__DIGD_FE_SOFT_RESET__SHIFT                                                             0xc
#define DIG_SOFT_RESET__DIGD_BE_SOFT_RESET__SHIFT                                                             0xd
#define DIG_SOFT_RESET__DIGE_FE_SOFT_RESET__SHIFT                                                             0x10
#define DIG_SOFT_RESET__DIGE_BE_SOFT_RESET__SHIFT                                                             0x11
#define DIG_SOFT_RESET__DIGF_FE_SOFT_RESET__SHIFT                                                             0x14
#define DIG_SOFT_RESET__DIGF_BE_SOFT_RESET__SHIFT                                                             0x15
#define DIG_SOFT_RESET__DIGG_FE_SOFT_RESET__SHIFT                                                             0x18
#define DIG_SOFT_RESET__DIGG_BE_SOFT_RESET__SHIFT                                                             0x19
#define DIG_SOFT_RESET__DIGA_FE_SOFT_RESET_MASK                                                               0x00000001L
#define DIG_SOFT_RESET__DIGA_BE_SOFT_RESET_MASK                                                               0x00000002L
#define DIG_SOFT_RESET__DIGB_FE_SOFT_RESET_MASK                                                               0x00000010L
#define DIG_SOFT_RESET__DIGB_BE_SOFT_RESET_MASK                                                               0x00000020L
#define DIG_SOFT_RESET__DIGC_FE_SOFT_RESET_MASK                                                               0x00000100L
#define DIG_SOFT_RESET__DIGC_BE_SOFT_RESET_MASK                                                               0x00000200L
#define DIG_SOFT_RESET__DIGD_FE_SOFT_RESET_MASK                                                               0x00001000L
#define DIG_SOFT_RESET__DIGD_BE_SOFT_RESET_MASK                                                               0x00002000L
#define DIG_SOFT_RESET__DIGE_FE_SOFT_RESET_MASK                                                               0x00010000L
#define DIG_SOFT_RESET__DIGE_BE_SOFT_RESET_MASK                                                               0x00020000L
#define DIG_SOFT_RESET__DIGF_FE_SOFT_RESET_MASK                                                               0x00100000L
#define DIG_SOFT_RESET__DIGF_BE_SOFT_RESET_MASK                                                               0x00200000L
#define DIG_SOFT_RESET__DIGG_FE_SOFT_RESET_MASK                                                               0x01000000L
#define DIG_SOFT_RESET__DIGG_BE_SOFT_RESET_MASK                                                               0x02000000L
//DCO_MEM_PWR_STATUS1
#define DCO_MEM_PWR_STATUS1__DPLPA_MEM_PWR_STATE__SHIFT                                                       0x0
#define DCO_MEM_PWR_STATUS1__DPLPB_MEM_PWR_STATE__SHIFT                                                       0x1
#define DCO_MEM_PWR_STATUS1__HDMILP0_MEM_PWR_STATE__SHIFT                                                     0xa
#define DCO_MEM_PWR_STATUS1__HDMILP1_MEM_PWR_STATE__SHIFT                                                     0xc
#define DCO_MEM_PWR_STATUS1__DPLPA_MEM_PWR_STATE_MASK                                                         0x00000001L
#define DCO_MEM_PWR_STATUS1__DPLPB_MEM_PWR_STATE_MASK                                                         0x00000002L
#define DCO_MEM_PWR_STATUS1__HDMILP0_MEM_PWR_STATE_MASK                                                       0x00000C00L
#define DCO_MEM_PWR_STATUS1__HDMILP1_MEM_PWR_STATE_MASK                                                       0x00003000L
//DISP_INTERRUPT_STATUS_CONTINUE10
#define DISP_INTERRUPT_STATUS_CONTINUE10__DIGLPA_DP_FAST_TRAINING_COMPLETE_INTERRUPT__SHIFT                   0x4
#define DISP_INTERRUPT_STATUS_CONTINUE10__DIGLPA_DP_VID_STREAM_DISABLE_INTERRUPT__SHIFT                       0x5
#define DISP_INTERRUPT_STATUS_CONTINUE10__DIGLPB_DP_FAST_TRAINING_COMPLETE_INTERRUPT__SHIFT                   0xa
#define DISP_INTERRUPT_STATUS_CONTINUE10__DIGLPB_DP_VID_STREAM_DISABLE_INTERRUPT__SHIFT                       0xb
#define DISP_INTERRUPT_STATUS_CONTINUE10__DCCG_PERFMON2_COUNTER0_INTERRUPT__SHIFT                             0xc
#define DISP_INTERRUPT_STATUS_CONTINUE10__DCCG_PERFMON2_COUNTER1_INTERRUPT__SHIFT                             0xd
#define DISP_INTERRUPT_STATUS_CONTINUE10__DCCG_PERFMON2_COUNTER2_INTERRUPT__SHIFT                             0xe
#define DISP_INTERRUPT_STATUS_CONTINUE10__DCCG_PERFMON2_COUNTER3_INTERRUPT__SHIFT                             0xf
#define DISP_INTERRUPT_STATUS_CONTINUE10__DCCG_PERFMON2_COUNTER4_INTERRUPT__SHIFT                             0x10
#define DISP_INTERRUPT_STATUS_CONTINUE10__DCCG_PERFMON2_COUNTER5_INTERRUPT__SHIFT                             0x11
#define DISP_INTERRUPT_STATUS_CONTINUE10__DCCG_PERFMON2_COUNTER6_INTERRUPT__SHIFT                             0x12
#define DISP_INTERRUPT_STATUS_CONTINUE10__DCCG_PERFMON2_COUNTER7_INTERRUPT__SHIFT                             0x13
#define DISP_INTERRUPT_STATUS_CONTINUE10__DCCG_PERFMON2_COUNTER_OFF_INTERRUPT__SHIFT                          0x14
#define DISP_INTERRUPT_STATUS_CONTINUE10__CRTC1_RANGE_TIMING_UPDATE__SHIFT                                    0x16
#define DISP_INTERRUPT_STATUS_CONTINUE10__CRTC2_RANGE_TIMING_UPDATE__SHIFT                                    0x17
#define DISP_INTERRUPT_STATUS_CONTINUE10__CRTC3_RANGE_TIMING_UPDATE__SHIFT                                    0x18
#define DISP_INTERRUPT_STATUS_CONTINUE10__CRTC4_RANGE_TIMING_UPDATE__SHIFT                                    0x19
#define DISP_INTERRUPT_STATUS_CONTINUE10__CRTC5_RANGE_TIMING_UPDATE__SHIFT                                    0x1a
#define DISP_INTERRUPT_STATUS_CONTINUE10__CRTC6_RANGE_TIMING_UPDATE__SHIFT                                    0x1b
#define DISP_INTERRUPT_STATUS_CONTINUE10__DISP_INTERRUPT_STATUS_CONTINUE11__SHIFT                             0x1f
#define DISP_INTERRUPT_STATUS_CONTINUE10__DIGLPA_DP_FAST_TRAINING_COMPLETE_INTERRUPT_MASK                     0x00000010L
#define DISP_INTERRUPT_STATUS_CONTINUE10__DIGLPA_DP_VID_STREAM_DISABLE_INTERRUPT_MASK                         0x00000020L
#define DISP_INTERRUPT_STATUS_CONTINUE10__DIGLPB_DP_FAST_TRAINING_COMPLETE_INTERRUPT_MASK                     0x00000400L
#define DISP_INTERRUPT_STATUS_CONTINUE10__DIGLPB_DP_VID_STREAM_DISABLE_INTERRUPT_MASK                         0x00000800L
#define DISP_INTERRUPT_STATUS_CONTINUE10__DCCG_PERFMON2_COUNTER0_INTERRUPT_MASK                               0x00001000L
#define DISP_INTERRUPT_STATUS_CONTINUE10__DCCG_PERFMON2_COUNTER1_INTERRUPT_MASK                               0x00002000L
#define DISP_INTERRUPT_STATUS_CONTINUE10__DCCG_PERFMON2_COUNTER2_INTERRUPT_MASK                               0x00004000L
#define DISP_INTERRUPT_STATUS_CONTINUE10__DCCG_PERFMON2_COUNTER3_INTERRUPT_MASK                               0x00008000L
#define DISP_INTERRUPT_STATUS_CONTINUE10__DCCG_PERFMON2_COUNTER4_INTERRUPT_MASK                               0x00010000L
#define DISP_INTERRUPT_STATUS_CONTINUE10__DCCG_PERFMON2_COUNTER5_INTERRUPT_MASK                               0x00020000L
#define DISP_INTERRUPT_STATUS_CONTINUE10__DCCG_PERFMON2_COUNTER6_INTERRUPT_MASK                               0x00040000L
#define DISP_INTERRUPT_STATUS_CONTINUE10__DCCG_PERFMON2_COUNTER7_INTERRUPT_MASK                               0x00080000L
#define DISP_INTERRUPT_STATUS_CONTINUE10__DCCG_PERFMON2_COUNTER_OFF_INTERRUPT_MASK                            0x00100000L
#define DISP_INTERRUPT_STATUS_CONTINUE10__CRTC1_RANGE_TIMING_UPDATE_MASK                                      0x00400000L
#define DISP_INTERRUPT_STATUS_CONTINUE10__CRTC2_RANGE_TIMING_UPDATE_MASK                                      0x00800000L
#define DISP_INTERRUPT_STATUS_CONTINUE10__CRTC3_RANGE_TIMING_UPDATE_MASK                                      0x01000000L
#define DISP_INTERRUPT_STATUS_CONTINUE10__CRTC4_RANGE_TIMING_UPDATE_MASK                                      0x02000000L
#define DISP_INTERRUPT_STATUS_CONTINUE10__CRTC5_RANGE_TIMING_UPDATE_MASK                                      0x04000000L
#define DISP_INTERRUPT_STATUS_CONTINUE10__CRTC6_RANGE_TIMING_UPDATE_MASK                                      0x08000000L
#define DISP_INTERRUPT_STATUS_CONTINUE10__DISP_INTERRUPT_STATUS_CONTINUE11_MASK                               0x80000000L
//DCO_CLK_CNTL2
#define DCO_CLK_CNTL2__DCO_TEST_CLK_SEL__SHIFT                                                                0x0
#define DCO_CLK_CNTL2__SCLK_G_AFMTA_GATE_DIS__SHIFT                                                           0x7
#define DCO_CLK_CNTL2__SCLK_G_AFMTB_GATE_DIS__SHIFT                                                           0x8
#define DCO_CLK_CNTL2__SCLK_G_AFMTC_GATE_DIS__SHIFT                                                           0x9
#define DCO_CLK_CNTL2__SCLK_G_AFMTD_GATE_DIS__SHIFT                                                           0xa
#define DCO_CLK_CNTL2__SCLK_G_AFMTE_GATE_DIS__SHIFT                                                           0xb
#define DCO_CLK_CNTL2__SCLK_G_AFMTF_GATE_DIS__SHIFT                                                           0xc
#define DCO_CLK_CNTL2__SCLK_G_AFMTG_GATE_DIS__SHIFT                                                           0xd
#define DCO_CLK_CNTL2__SCLK_G_AFMTLPA_GATE_DIS__SHIFT                                                         0xf
#define DCO_CLK_CNTL2__SCLK_G_AFMTLPB_GATE_DIS__SHIFT                                                         0x10
#define DCO_CLK_CNTL2__SYMCLKA_FE_G_AFMT_GATE_DIS__SHIFT                                                      0x11
#define DCO_CLK_CNTL2__SYMCLKB_FE_G_AFMT_GATE_DIS__SHIFT                                                      0x12
#define DCO_CLK_CNTL2__SYMCLKC_FE_G_AFMT_GATE_DIS__SHIFT                                                      0x13
#define DCO_CLK_CNTL2__SYMCLKD_FE_G_AFMT_GATE_DIS__SHIFT                                                      0x14
#define DCO_CLK_CNTL2__SYMCLKE_FE_G_AFMT_GATE_DIS__SHIFT                                                      0x15
#define DCO_CLK_CNTL2__SYMCLKF_FE_G_AFMT_GATE_DIS__SHIFT                                                      0x16
#define DCO_CLK_CNTL2__SYMCLKG_FE_G_AFMT_GATE_DIS__SHIFT                                                      0x17
#define DCO_CLK_CNTL2__SYMCLKLPA_FE_G_AFMT_GATE_DIS__SHIFT                                                    0x19
#define DCO_CLK_CNTL2__SYMCLKLPB_FE_G_AFMT_GATE_DIS__SHIFT                                                    0x1a
#define DCO_CLK_CNTL2__DCO_TEST_CLK_SEL_MASK                                                                  0x0000007FL
#define DCO_CLK_CNTL2__SCLK_G_AFMTA_GATE_DIS_MASK                                                             0x00000080L
#define DCO_CLK_CNTL2__SCLK_G_AFMTB_GATE_DIS_MASK                                                             0x00000100L
#define DCO_CLK_CNTL2__SCLK_G_AFMTC_GATE_DIS_MASK                                                             0x00000200L
#define DCO_CLK_CNTL2__SCLK_G_AFMTD_GATE_DIS_MASK                                                             0x00000400L
#define DCO_CLK_CNTL2__SCLK_G_AFMTE_GATE_DIS_MASK                                                             0x00000800L
#define DCO_CLK_CNTL2__SCLK_G_AFMTF_GATE_DIS_MASK                                                             0x00001000L
#define DCO_CLK_CNTL2__SCLK_G_AFMTG_GATE_DIS_MASK                                                             0x00002000L
#define DCO_CLK_CNTL2__SCLK_G_AFMTLPA_GATE_DIS_MASK                                                           0x00008000L
#define DCO_CLK_CNTL2__SCLK_G_AFMTLPB_GATE_DIS_MASK                                                           0x00010000L
#define DCO_CLK_CNTL2__SYMCLKA_FE_G_AFMT_GATE_DIS_MASK                                                        0x00020000L
#define DCO_CLK_CNTL2__SYMCLKB_FE_G_AFMT_GATE_DIS_MASK                                                        0x00040000L
#define DCO_CLK_CNTL2__SYMCLKC_FE_G_AFMT_GATE_DIS_MASK                                                        0x00080000L
#define DCO_CLK_CNTL2__SYMCLKD_FE_G_AFMT_GATE_DIS_MASK                                                        0x00100000L
#define DCO_CLK_CNTL2__SYMCLKE_FE_G_AFMT_GATE_DIS_MASK                                                        0x00200000L
#define DCO_CLK_CNTL2__SYMCLKF_FE_G_AFMT_GATE_DIS_MASK                                                        0x00400000L
#define DCO_CLK_CNTL2__SYMCLKG_FE_G_AFMT_GATE_DIS_MASK                                                        0x00800000L
#define DCO_CLK_CNTL2__SYMCLKLPA_FE_G_AFMT_GATE_DIS_MASK                                                      0x02000000L
#define DCO_CLK_CNTL2__SYMCLKLPB_FE_G_AFMT_GATE_DIS_MASK                                                      0x04000000L
//DCO_CLK_CNTL3
#define DCO_CLK_CNTL3__SYMCLKA_FE_G_TMDS_GATE_DIS__SHIFT                                                      0x0
#define DCO_CLK_CNTL3__SYMCLKB_FE_G_TMDS_GATE_DIS__SHIFT                                                      0x1
#define DCO_CLK_CNTL3__SYMCLKC_FE_G_TMDS_GATE_DIS__SHIFT                                                      0x2
#define DCO_CLK_CNTL3__SYMCLKD_FE_G_TMDS_GATE_DIS__SHIFT                                                      0x3
#define DCO_CLK_CNTL3__SYMCLKE_FE_G_TMDS_GATE_DIS__SHIFT                                                      0x4
#define DCO_CLK_CNTL3__SYMCLKF_FE_G_TMDS_GATE_DIS__SHIFT                                                      0x5
#define DCO_CLK_CNTL3__SYMCLKG_FE_G_TMDS_GATE_DIS__SHIFT                                                      0x6
#define DCO_CLK_CNTL3__SYMCLKLPA_FE_G_TMDS_GATE_DIS__SHIFT                                                    0x8
#define DCO_CLK_CNTL3__SYMCLKLPB_FE_G_TMDS_GATE_DIS__SHIFT                                                    0x9
#define DCO_CLK_CNTL3__SYMCLKA_G_TMDS_GATE_DIS__SHIFT                                                         0xa
#define DCO_CLK_CNTL3__SYMCLKB_G_TMDS_GATE_DIS__SHIFT                                                         0xb
#define DCO_CLK_CNTL3__SYMCLKC_G_TMDS_GATE_DIS__SHIFT                                                         0xc
#define DCO_CLK_CNTL3__SYMCLKD_G_TMDS_GATE_DIS__SHIFT                                                         0xd
#define DCO_CLK_CNTL3__SYMCLKE_G_TMDS_GATE_DIS__SHIFT                                                         0xe
#define DCO_CLK_CNTL3__SYMCLKF_G_TMDS_GATE_DIS__SHIFT                                                         0xf
#define DCO_CLK_CNTL3__SYMCLKG_G_TMDS_GATE_DIS__SHIFT                                                         0x10
#define DCO_CLK_CNTL3__SYMCLKLPA_G_TMDS_GATE_DIS__SHIFT                                                       0x12
#define DCO_CLK_CNTL3__SYMCLKLPB_G_TMDS_GATE_DIS__SHIFT                                                       0x13
#define DCO_CLK_CNTL3__SYMCLKA_FE_G_TMDS_GATE_DIS_MASK                                                        0x00000001L
#define DCO_CLK_CNTL3__SYMCLKB_FE_G_TMDS_GATE_DIS_MASK                                                        0x00000002L
#define DCO_CLK_CNTL3__SYMCLKC_FE_G_TMDS_GATE_DIS_MASK                                                        0x00000004L
#define DCO_CLK_CNTL3__SYMCLKD_FE_G_TMDS_GATE_DIS_MASK                                                        0x00000008L
#define DCO_CLK_CNTL3__SYMCLKE_FE_G_TMDS_GATE_DIS_MASK                                                        0x00000010L
#define DCO_CLK_CNTL3__SYMCLKF_FE_G_TMDS_GATE_DIS_MASK                                                        0x00000020L
#define DCO_CLK_CNTL3__SYMCLKG_FE_G_TMDS_GATE_DIS_MASK                                                        0x00000040L
#define DCO_CLK_CNTL3__SYMCLKLPA_FE_G_TMDS_GATE_DIS_MASK                                                      0x00000100L
#define DCO_CLK_CNTL3__SYMCLKLPB_FE_G_TMDS_GATE_DIS_MASK                                                      0x00000200L
#define DCO_CLK_CNTL3__SYMCLKA_G_TMDS_GATE_DIS_MASK                                                           0x00000400L
#define DCO_CLK_CNTL3__SYMCLKB_G_TMDS_GATE_DIS_MASK                                                           0x00000800L
#define DCO_CLK_CNTL3__SYMCLKC_G_TMDS_GATE_DIS_MASK                                                           0x00001000L
#define DCO_CLK_CNTL3__SYMCLKD_G_TMDS_GATE_DIS_MASK                                                           0x00002000L
#define DCO_CLK_CNTL3__SYMCLKE_G_TMDS_GATE_DIS_MASK                                                           0x00004000L
#define DCO_CLK_CNTL3__SYMCLKF_G_TMDS_GATE_DIS_MASK                                                           0x00008000L
#define DCO_CLK_CNTL3__SYMCLKG_G_TMDS_GATE_DIS_MASK                                                           0x00010000L
#define DCO_CLK_CNTL3__SYMCLKLPA_G_TMDS_GATE_DIS_MASK                                                         0x00040000L
#define DCO_CLK_CNTL3__SYMCLKLPB_G_TMDS_GATE_DIS_MASK                                                         0x00080000L
//DCO_HDMI_RXSTATUS_TIMER_CONTROL
#define DCO_HDMI_RXSTATUS_TIMER_CONTROL__DCO_HDMI_RXSTATUS_TIMER_ENABLE__SHIFT                                0x0
#define DCO_HDMI_RXSTATUS_TIMER_CONTROL__DCO_HDMI_RXSTATUS_TIMER_TYPE__SHIFT                                  0x4
#define DCO_HDMI_RXSTATUS_TIMER_CONTROL__DCO_HDMI_RXSTATUS_TIMER_STATUS__SHIFT                                0x8
#define DCO_HDMI_RXSTATUS_TIMER_CONTROL__DCO_HDMI_RXSTATUS_TIMER_MASK__SHIFT                                  0xc
#define DCO_HDMI_RXSTATUS_TIMER_CONTROL__DCO_HDMI_RXSTATUS_TIMER_INTERVAL__SHIFT                              0x10
#define DCO_HDMI_RXSTATUS_TIMER_CONTROL__DCO_HDMI_RXSTATUS_TIMER_ENABLE_MASK                                  0x00000001L
#define DCO_HDMI_RXSTATUS_TIMER_CONTROL__DCO_HDMI_RXSTATUS_TIMER_TYPE_MASK                                    0x00000010L
#define DCO_HDMI_RXSTATUS_TIMER_CONTROL__DCO_HDMI_RXSTATUS_TIMER_STATUS_MASK                                  0x00000100L
#define DCO_HDMI_RXSTATUS_TIMER_CONTROL__DCO_HDMI_RXSTATUS_TIMER_MASK_MASK                                    0x00001000L
#define DCO_HDMI_RXSTATUS_TIMER_CONTROL__DCO_HDMI_RXSTATUS_TIMER_INTERVAL_MASK                                0x0FFF0000L
//DCO_PSP_INTERRUPT_STATUS
#define DCO_PSP_INTERRUPT_STATUS__DCO_PSP_INTERRUPT_STATUS__SHIFT                                             0x0
#define DCO_PSP_INTERRUPT_STATUS__DCO_PSP_INTERRUPT_MESSAGE__SHIFT                                            0x1
#define DCO_PSP_INTERRUPT_STATUS__DCO_PSP_INTERRUPT_STATUS_MASK                                               0x00000001L
#define DCO_PSP_INTERRUPT_STATUS__DCO_PSP_INTERRUPT_MESSAGE_MASK                                              0xFFFFFFFEL
//DCO_PSP_INTERRUPT_CLEAR
#define DCO_PSP_INTERRUPT_CLEAR__DCO_PSP_INTERRUPT_CLEAR__SHIFT                                               0x0
#define DCO_PSP_INTERRUPT_CLEAR__DCO_PSP_INTERRUPT_CLEAR_MASK                                                 0x00000001L
//DCO_GENERIC_INTERRUPT_MESSAGE
#define DCO_GENERIC_INTERRUPT_MESSAGE__DCO_GENERIC_INTERRUPT_STATUS__SHIFT                                    0x0
#define DCO_GENERIC_INTERRUPT_MESSAGE__DCO_GENERIC_INTERRUPT_MESSAGE__SHIFT                                   0x1
#define DCO_GENERIC_INTERRUPT_MESSAGE__DCO_GENERIC_INTERRUPT_STATUS_MASK                                      0x00000001L
#define DCO_GENERIC_INTERRUPT_MESSAGE__DCO_GENERIC_INTERRUPT_MESSAGE_MASK                                     0xFFFFFFFEL
//DCO_GENERIC_INTERRUPT_CLEAR
#define DCO_GENERIC_INTERRUPT_CLEAR__DCO_GENERIC_INTERRUPT_CLEAR__SHIFT                                       0x0
#define DCO_GENERIC_INTERRUPT_CLEAR__DCO_GENERIC_INTERRUPT_CLEAR_MASK                                         0x00000001L
//FMT_MEMORY0_CONTROL
#define FMT_MEMORY0_CONTROL__FMT420_MEM0_SOURCE_SEL__SHIFT                                                    0x0
#define FMT_MEMORY0_CONTROL__FMT420_MEM0_PWR_FORCE__SHIFT                                                     0x4
#define FMT_MEMORY0_CONTROL__FMT420_MEM0_PWR_DIS__SHIFT                                                       0x8
#define FMT_MEMORY0_CONTROL__FMT420_MEM0_PWR_STATE__SHIFT                                                     0xc
#define FMT_MEMORY0_CONTROL__FMT420_MEM0_SOURCE_SEL_MASK                                                      0x00000007L
#define FMT_MEMORY0_CONTROL__FMT420_MEM0_PWR_FORCE_MASK                                                       0x00000030L
#define FMT_MEMORY0_CONTROL__FMT420_MEM0_PWR_DIS_MASK                                                         0x00000100L
#define FMT_MEMORY0_CONTROL__FMT420_MEM0_PWR_STATE_MASK                                                       0x00003000L
//FMT_MEMORY1_CONTROL
#define FMT_MEMORY1_CONTROL__FMT420_MEM1_SOURCE_SEL__SHIFT                                                    0x0
#define FMT_MEMORY1_CONTROL__FMT420_MEM1_PWR_FORCE__SHIFT                                                     0x4
#define FMT_MEMORY1_CONTROL__FMT420_MEM1_PWR_DIS__SHIFT                                                       0x8
#define FMT_MEMORY1_CONTROL__FMT420_MEM1_PWR_STATE__SHIFT                                                     0xc
#define FMT_MEMORY1_CONTROL__FMT420_MEM1_SOURCE_SEL_MASK                                                      0x00000007L
#define FMT_MEMORY1_CONTROL__FMT420_MEM1_PWR_FORCE_MASK                                                       0x00000030L
#define FMT_MEMORY1_CONTROL__FMT420_MEM1_PWR_DIS_MASK                                                         0x00000100L
#define FMT_MEMORY1_CONTROL__FMT420_MEM1_PWR_STATE_MASK                                                       0x00003000L
//FMT_MEMORY2_CONTROL
#define FMT_MEMORY2_CONTROL__FMT420_MEM2_SOURCE_SEL__SHIFT                                                    0x0
#define FMT_MEMORY2_CONTROL__FMT420_MEM2_PWR_FORCE__SHIFT                                                     0x4
#define FMT_MEMORY2_CONTROL__FMT420_MEM2_PWR_DIS__SHIFT                                                       0x8
#define FMT_MEMORY2_CONTROL__FMT420_MEM2_PWR_STATE__SHIFT                                                     0xc
#define FMT_MEMORY2_CONTROL__FMT420_MEM2_SOURCE_SEL_MASK                                                      0x00000007L
#define FMT_MEMORY2_CONTROL__FMT420_MEM2_PWR_FORCE_MASK                                                       0x00000030L
#define FMT_MEMORY2_CONTROL__FMT420_MEM2_PWR_DIS_MASK                                                         0x00000100L
#define FMT_MEMORY2_CONTROL__FMT420_MEM2_PWR_STATE_MASK                                                       0x00003000L
//FMT_MEMORY3_CONTROL
#define FMT_MEMORY3_CONTROL__FMT420_MEM3_SOURCE_SEL__SHIFT                                                    0x0
#define FMT_MEMORY3_CONTROL__FMT420_MEM3_PWR_FORCE__SHIFT                                                     0x4
#define FMT_MEMORY3_CONTROL__FMT420_MEM3_PWR_DIS__SHIFT                                                       0x8
#define FMT_MEMORY3_CONTROL__FMT420_MEM3_PWR_STATE__SHIFT                                                     0xc
#define FMT_MEMORY3_CONTROL__FMT420_MEM3_SOURCE_SEL_MASK                                                      0x00000007L
#define FMT_MEMORY3_CONTROL__FMT420_MEM3_PWR_FORCE_MASK                                                       0x00000030L
#define FMT_MEMORY3_CONTROL__FMT420_MEM3_PWR_DIS_MASK                                                         0x00000100L
#define FMT_MEMORY3_CONTROL__FMT420_MEM3_PWR_STATE_MASK                                                       0x00003000L
//FMT_MEMORY4_CONTROL
#define FMT_MEMORY4_CONTROL__FMT420_MEM4_SOURCE_SEL__SHIFT                                                    0x0
#define FMT_MEMORY4_CONTROL__FMT420_MEM4_PWR_FORCE__SHIFT                                                     0x4
#define FMT_MEMORY4_CONTROL__FMT420_MEM4_PWR_DIS__SHIFT                                                       0x8
#define FMT_MEMORY4_CONTROL__FMT420_MEM4_PWR_STATE__SHIFT                                                     0xc
#define FMT_MEMORY4_CONTROL__FMT420_MEM4_SOURCE_SEL_MASK                                                      0x00000007L
#define FMT_MEMORY4_CONTROL__FMT420_MEM4_PWR_FORCE_MASK                                                       0x00000030L
#define FMT_MEMORY4_CONTROL__FMT420_MEM4_PWR_DIS_MASK                                                         0x00000100L
#define FMT_MEMORY4_CONTROL__FMT420_MEM4_PWR_STATE_MASK                                                       0x00003000L
//FMT_MEMORY5_CONTROL
#define FMT_MEMORY5_CONTROL__FMT420_MEM5_SOURCE_SEL__SHIFT                                                    0x0
#define FMT_MEMORY5_CONTROL__FMT420_MEM5_PWR_FORCE__SHIFT                                                     0x4
#define FMT_MEMORY5_CONTROL__FMT420_MEM5_PWR_DIS__SHIFT                                                       0x8
#define FMT_MEMORY5_CONTROL__FMT420_MEM5_PWR_STATE__SHIFT                                                     0xc
#define FMT_MEMORY5_CONTROL__FMT420_MEM5_SOURCE_SEL_MASK                                                      0x00000007L
#define FMT_MEMORY5_CONTROL__FMT420_MEM5_PWR_FORCE_MASK                                                       0x00000030L
#define FMT_MEMORY5_CONTROL__FMT420_MEM5_PWR_DIS_MASK                                                         0x00000100L
#define FMT_MEMORY5_CONTROL__FMT420_MEM5_PWR_STATE_MASK                                                       0x00003000L
//DISP_INTERRUPT_STATUS_CONTINUE11
#define DISP_INTERRUPT_STATUS_CONTINUE11__DCP0_xdma_vsync_flip_timeout_interrupt__SHIFT                       0x0
#define DISP_INTERRUPT_STATUS_CONTINUE11__DCP1_xdma_vsync_flip_timeout_interrupt__SHIFT                       0x1
#define DISP_INTERRUPT_STATUS_CONTINUE11__DCP2_xdma_vsync_flip_timeout_interrupt__SHIFT                       0x2
#define DISP_INTERRUPT_STATUS_CONTINUE11__DCP3_xdma_vsync_flip_timeout_interrupt__SHIFT                       0x3
#define DISP_INTERRUPT_STATUS_CONTINUE11__DCP4_xdma_vsync_flip_timeout_interrupt__SHIFT                       0x4
#define DISP_INTERRUPT_STATUS_CONTINUE11__DCP5_xdma_vsync_flip_timeout_interrupt__SHIFT                       0x5
#define DISP_INTERRUPT_STATUS_CONTINUE11__DCP0_xdma_vsync_flip_timeout_interrupt_MASK                         0x00000001L
#define DISP_INTERRUPT_STATUS_CONTINUE11__DCP1_xdma_vsync_flip_timeout_interrupt_MASK                         0x00000002L
#define DISP_INTERRUPT_STATUS_CONTINUE11__DCP2_xdma_vsync_flip_timeout_interrupt_MASK                         0x00000004L
#define DISP_INTERRUPT_STATUS_CONTINUE11__DCP3_xdma_vsync_flip_timeout_interrupt_MASK                         0x00000008L
#define DISP_INTERRUPT_STATUS_CONTINUE11__DCP4_xdma_vsync_flip_timeout_interrupt_MASK                         0x00000010L
#define DISP_INTERRUPT_STATUS_CONTINUE11__DCP5_xdma_vsync_flip_timeout_interrupt_MASK                         0x00000020L
//DC_GENERICA
#define DC_GENERICA__GENERICA_EN__SHIFT                                                                       0x0
#define DC_GENERICA__GENERICA_SEL__SHIFT                                                                      0x7
#define DC_GENERICA__GENERICA_UNIPHY_REFDIV_CLK_SEL__SHIFT                                                    0xc
#define DC_GENERICA__GENERICA_UNIPHY_FBDIV_CLK_SEL__SHIFT                                                     0x10
#define DC_GENERICA__GENERICA_UNIPHY_FBDIV_SSC_CLK_SEL__SHIFT                                                 0x14
#define DC_GENERICA__GENERICA_UNIPHY_FBDIV_CLK_DIV2_SEL__SHIFT                                                0x18
#define DC_GENERICA__GENERICA_EN_MASK                                                                         0x00000001L
#define DC_GENERICA__GENERICA_SEL_MASK                                                                        0x00000F80L
#define DC_GENERICA__GENERICA_UNIPHY_REFDIV_CLK_SEL_MASK                                                      0x0000F000L
#define DC_GENERICA__GENERICA_UNIPHY_FBDIV_CLK_SEL_MASK                                                       0x000F0000L
#define DC_GENERICA__GENERICA_UNIPHY_FBDIV_SSC_CLK_SEL_MASK                                                   0x00F00000L
#define DC_GENERICA__GENERICA_UNIPHY_FBDIV_CLK_DIV2_SEL_MASK                                                  0x0F000000L
//DC_GENERICB
#define DC_GENERICB__GENERICB_EN__SHIFT                                                                       0x0
#define DC_GENERICB__GENERICB_SEL__SHIFT                                                                      0x8
#define DC_GENERICB__GENERICB_UNIPHY_REFDIV_CLK_SEL__SHIFT                                                    0xc
#define DC_GENERICB__GENERICB_UNIPHY_FBDIV_CLK_SEL__SHIFT                                                     0x10
#define DC_GENERICB__GENERICB_UNIPHY_FBDIV_SSC_CLK_SEL__SHIFT                                                 0x14
#define DC_GENERICB__GENERICB_UNIPHY_FBDIV_CLK_DIV2_SEL__SHIFT                                                0x18
#define DC_GENERICB__GENERICB_EN_MASK                                                                         0x00000001L
#define DC_GENERICB__GENERICB_SEL_MASK                                                                        0x00000F00L
#define DC_GENERICB__GENERICB_UNIPHY_REFDIV_CLK_SEL_MASK                                                      0x0000F000L
#define DC_GENERICB__GENERICB_UNIPHY_FBDIV_CLK_SEL_MASK                                                       0x000F0000L
#define DC_GENERICB__GENERICB_UNIPHY_FBDIV_SSC_CLK_SEL_MASK                                                   0x00F00000L
#define DC_GENERICB__GENERICB_UNIPHY_FBDIV_CLK_DIV2_SEL_MASK                                                  0x0F000000L
//DC_PAD_EXTERN_SIG
#define DC_PAD_EXTERN_SIG__DC_PAD_EXTERN_SIG_SEL__SHIFT                                                       0x0
#define DC_PAD_EXTERN_SIG__MVP_PIXEL_SRC_STATUS__SHIFT                                                        0x4
#define DC_PAD_EXTERN_SIG__DC_PAD_EXTERN_SIG_SEL_MASK                                                         0x0000000FL
#define DC_PAD_EXTERN_SIG__MVP_PIXEL_SRC_STATUS_MASK                                                          0x00000030L
//DC_REF_CLK_CNTL
#define DC_REF_CLK_CNTL__HSYNCA_OUTPUT_SEL__SHIFT                                                             0x0
#define DC_REF_CLK_CNTL__GENLK_CLK_OUTPUT_SEL__SHIFT                                                          0x8
#define DC_REF_CLK_CNTL__HSYNCA_OUTPUT_SEL_MASK                                                               0x00000003L
#define DC_REF_CLK_CNTL__GENLK_CLK_OUTPUT_SEL_MASK                                                            0x00000300L
//DC_GPIO_DEBUG
#define DC_GPIO_DEBUG__DC_GPIO_VIP_DEBUG__SHIFT                                                               0x0
#define DC_GPIO_DEBUG__DC_GPIO_MACRO_DEBUG__SHIFT                                                             0x8
#define DC_GPIO_DEBUG__DC_GPIO_CHIP_DEBUG_OUT_PIN_SEL__SHIFT                                                  0x10
#define DC_GPIO_DEBUG__DC_GPIO_DEBUG_BUS_FLOP_EN__SHIFT                                                       0x11
#define DC_GPIO_DEBUG__DPRX_LOOPBACK_ENABLE__SHIFT                                                            0x1f
#define DC_GPIO_DEBUG__DC_GPIO_VIP_DEBUG_MASK                                                                 0x00000001L
#define DC_GPIO_DEBUG__DC_GPIO_MACRO_DEBUG_MASK                                                               0x00000300L
#define DC_GPIO_DEBUG__DC_GPIO_CHIP_DEBUG_OUT_PIN_SEL_MASK                                                    0x00010000L
#define DC_GPIO_DEBUG__DC_GPIO_DEBUG_BUS_FLOP_EN_MASK                                                         0x00020000L
#define DC_GPIO_DEBUG__DPRX_LOOPBACK_ENABLE_MASK                                                              0x80000000L
//UNIPHYA_LINK_CNTL
#define UNIPHYA_LINK_CNTL__UNIPHY_PFREQCHG__SHIFT                                                             0x0
#define UNIPHYA_LINK_CNTL__UNIPHY_PIXVLD_RESET__SHIFT                                                         0x4
#define UNIPHYA_LINK_CNTL__UNIPHY_MINIMUM_PIXVLD_LOW_DURATION__SHIFT                                          0x8
#define UNIPHYA_LINK_CNTL__UNIPHY_CHANNEL0_INVERT__SHIFT                                                      0xc
#define UNIPHYA_LINK_CNTL__UNIPHY_CHANNEL1_INVERT__SHIFT                                                      0xd
#define UNIPHYA_LINK_CNTL__UNIPHY_CHANNEL2_INVERT__SHIFT                                                      0xe
#define UNIPHYA_LINK_CNTL__UNIPHY_CHANNEL3_INVERT__SHIFT                                                      0xf
#define UNIPHYA_LINK_CNTL__UNIPHY_LANE_STAGGER_DELAY__SHIFT                                                   0x14
#define UNIPHYA_LINK_CNTL__UNIPHY_LINK_ENABLE_HPD_MASK__SHIFT                                                 0x18
#define UNIPHYA_LINK_CNTL__UNIPHY_PFREQCHG_MASK                                                               0x00000001L
#define UNIPHYA_LINK_CNTL__UNIPHY_PIXVLD_RESET_MASK                                                           0x00000010L
#define UNIPHYA_LINK_CNTL__UNIPHY_MINIMUM_PIXVLD_LOW_DURATION_MASK                                            0x00000700L
#define UNIPHYA_LINK_CNTL__UNIPHY_CHANNEL0_INVERT_MASK                                                        0x00001000L
#define UNIPHYA_LINK_CNTL__UNIPHY_CHANNEL1_INVERT_MASK                                                        0x00002000L
#define UNIPHYA_LINK_CNTL__UNIPHY_CHANNEL2_INVERT_MASK                                                        0x00004000L
#define UNIPHYA_LINK_CNTL__UNIPHY_CHANNEL3_INVERT_MASK                                                        0x00008000L
#define UNIPHYA_LINK_CNTL__UNIPHY_LANE_STAGGER_DELAY_MASK                                                     0x00700000L
#define UNIPHYA_LINK_CNTL__UNIPHY_LINK_ENABLE_HPD_MASK_MASK                                                   0x03000000L
//UNIPHYA_CHANNEL_XBAR_CNTL
#define UNIPHYA_CHANNEL_XBAR_CNTL__UNIPHY_CHANNEL0_XBAR_SOURCE__SHIFT                                         0x0
#define UNIPHYA_CHANNEL_XBAR_CNTL__UNIPHY_CHANNEL1_XBAR_SOURCE__SHIFT                                         0x8
#define UNIPHYA_CHANNEL_XBAR_CNTL__UNIPHY_CHANNEL2_XBAR_SOURCE__SHIFT                                         0x10
#define UNIPHYA_CHANNEL_XBAR_CNTL__UNIPHY_CHANNEL3_XBAR_SOURCE__SHIFT                                         0x18
#define UNIPHYA_CHANNEL_XBAR_CNTL__UNIPHY_LINK_ENABLE__SHIFT                                                  0x1c
#define UNIPHYA_CHANNEL_XBAR_CNTL__UNIPHY_CHANNEL0_XBAR_SOURCE_MASK                                           0x00000003L
#define UNIPHYA_CHANNEL_XBAR_CNTL__UNIPHY_CHANNEL1_XBAR_SOURCE_MASK                                           0x00000300L
#define UNIPHYA_CHANNEL_XBAR_CNTL__UNIPHY_CHANNEL2_XBAR_SOURCE_MASK                                           0x00030000L
#define UNIPHYA_CHANNEL_XBAR_CNTL__UNIPHY_CHANNEL3_XBAR_SOURCE_MASK                                           0x03000000L
#define UNIPHYA_CHANNEL_XBAR_CNTL__UNIPHY_LINK_ENABLE_MASK                                                    0x10000000L
//UNIPHYB_LINK_CNTL
#define UNIPHYB_LINK_CNTL__UNIPHY_PFREQCHG__SHIFT                                                             0x0
#define UNIPHYB_LINK_CNTL__UNIPHY_PIXVLD_RESET__SHIFT                                                         0x4
#define UNIPHYB_LINK_CNTL__UNIPHY_MINIMUM_PIXVLD_LOW_DURATION__SHIFT                                          0x8
#define UNIPHYB_LINK_CNTL__UNIPHY_CHANNEL0_INVERT__SHIFT                                                      0xc
#define UNIPHYB_LINK_CNTL__UNIPHY_CHANNEL1_INVERT__SHIFT                                                      0xd
#define UNIPHYB_LINK_CNTL__UNIPHY_CHANNEL2_INVERT__SHIFT                                                      0xe
#define UNIPHYB_LINK_CNTL__UNIPHY_CHANNEL3_INVERT__SHIFT                                                      0xf
#define UNIPHYB_LINK_CNTL__UNIPHY_LANE_STAGGER_DELAY__SHIFT                                                   0x14
#define UNIPHYB_LINK_CNTL__UNIPHY_LINK_ENABLE_HPD_MASK__SHIFT                                                 0x18
#define UNIPHYB_LINK_CNTL__UNIPHY_PFREQCHG_MASK                                                               0x00000001L
#define UNIPHYB_LINK_CNTL__UNIPHY_PIXVLD_RESET_MASK                                                           0x00000010L
#define UNIPHYB_LINK_CNTL__UNIPHY_MINIMUM_PIXVLD_LOW_DURATION_MASK                                            0x00000700L
#define UNIPHYB_LINK_CNTL__UNIPHY_CHANNEL0_INVERT_MASK                                                        0x00001000L
#define UNIPHYB_LINK_CNTL__UNIPHY_CHANNEL1_INVERT_MASK                                                        0x00002000L
#define UNIPHYB_LINK_CNTL__UNIPHY_CHANNEL2_INVERT_MASK                                                        0x00004000L
#define UNIPHYB_LINK_CNTL__UNIPHY_CHANNEL3_INVERT_MASK                                                        0x00008000L
#define UNIPHYB_LINK_CNTL__UNIPHY_LANE_STAGGER_DELAY_MASK                                                     0x00700000L
#define UNIPHYB_LINK_CNTL__UNIPHY_LINK_ENABLE_HPD_MASK_MASK                                                   0x03000000L
//UNIPHYB_CHANNEL_XBAR_CNTL
#define UNIPHYB_CHANNEL_XBAR_CNTL__UNIPHY_CHANNEL0_XBAR_SOURCE__SHIFT                                         0x0
#define UNIPHYB_CHANNEL_XBAR_CNTL__UNIPHY_CHANNEL1_XBAR_SOURCE__SHIFT                                         0x8
#define UNIPHYB_CHANNEL_XBAR_CNTL__UNIPHY_CHANNEL2_XBAR_SOURCE__SHIFT                                         0x10
#define UNIPHYB_CHANNEL_XBAR_CNTL__UNIPHY_CHANNEL3_XBAR_SOURCE__SHIFT                                         0x18
#define UNIPHYB_CHANNEL_XBAR_CNTL__UNIPHY_LINK_ENABLE__SHIFT                                                  0x1c
#define UNIPHYB_CHANNEL_XBAR_CNTL__UNIPHY_CHANNEL0_XBAR_SOURCE_MASK                                           0x00000003L
#define UNIPHYB_CHANNEL_XBAR_CNTL__UNIPHY_CHANNEL1_XBAR_SOURCE_MASK                                           0x00000300L
#define UNIPHYB_CHANNEL_XBAR_CNTL__UNIPHY_CHANNEL2_XBAR_SOURCE_MASK                                           0x00030000L
#define UNIPHYB_CHANNEL_XBAR_CNTL__UNIPHY_CHANNEL3_XBAR_SOURCE_MASK                                           0x03000000L
#define UNIPHYB_CHANNEL_XBAR_CNTL__UNIPHY_LINK_ENABLE_MASK                                                    0x10000000L
//UNIPHYC_LINK_CNTL
#define UNIPHYC_LINK_CNTL__UNIPHY_PFREQCHG__SHIFT                                                             0x0
#define UNIPHYC_LINK_CNTL__UNIPHY_PIXVLD_RESET__SHIFT                                                         0x4
#define UNIPHYC_LINK_CNTL__UNIPHY_MINIMUM_PIXVLD_LOW_DURATION__SHIFT                                          0x8
#define UNIPHYC_LINK_CNTL__UNIPHY_CHANNEL0_INVERT__SHIFT                                                      0xc
#define UNIPHYC_LINK_CNTL__UNIPHY_CHANNEL1_INVERT__SHIFT                                                      0xd
#define UNIPHYC_LINK_CNTL__UNIPHY_CHANNEL2_INVERT__SHIFT                                                      0xe
#define UNIPHYC_LINK_CNTL__UNIPHY_CHANNEL3_INVERT__SHIFT                                                      0xf
#define UNIPHYC_LINK_CNTL__UNIPHY_LANE_STAGGER_DELAY__SHIFT                                                   0x14
#define UNIPHYC_LINK_CNTL__UNIPHY_LINK_ENABLE_HPD_MASK__SHIFT                                                 0x18
#define UNIPHYC_LINK_CNTL__UNIPHY_PFREQCHG_MASK                                                               0x00000001L
#define UNIPHYC_LINK_CNTL__UNIPHY_PIXVLD_RESET_MASK                                                           0x00000010L
#define UNIPHYC_LINK_CNTL__UNIPHY_MINIMUM_PIXVLD_LOW_DURATION_MASK                                            0x00000700L
#define UNIPHYC_LINK_CNTL__UNIPHY_CHANNEL0_INVERT_MASK                                                        0x00001000L
#define UNIPHYC_LINK_CNTL__UNIPHY_CHANNEL1_INVERT_MASK                                                        0x00002000L
#define UNIPHYC_LINK_CNTL__UNIPHY_CHANNEL2_INVERT_MASK                                                        0x00004000L
#define UNIPHYC_LINK_CNTL__UNIPHY_CHANNEL3_INVERT_MASK                                                        0x00008000L
#define UNIPHYC_LINK_CNTL__UNIPHY_LANE_STAGGER_DELAY_MASK                                                     0x00700000L
#define UNIPHYC_LINK_CNTL__UNIPHY_LINK_ENABLE_HPD_MASK_MASK                                                   0x03000000L
//UNIPHYC_CHANNEL_XBAR_CNTL
#define UNIPHYC_CHANNEL_XBAR_CNTL__UNIPHY_CHANNEL0_XBAR_SOURCE__SHIFT                                         0x0
#define UNIPHYC_CHANNEL_XBAR_CNTL__UNIPHY_CHANNEL1_XBAR_SOURCE__SHIFT                                         0x8
#define UNIPHYC_CHANNEL_XBAR_CNTL__UNIPHY_CHANNEL2_XBAR_SOURCE__SHIFT                                         0x10
#define UNIPHYC_CHANNEL_XBAR_CNTL__UNIPHY_CHANNEL3_XBAR_SOURCE__SHIFT                                         0x18
#define UNIPHYC_CHANNEL_XBAR_CNTL__UNIPHY_LINK_ENABLE__SHIFT                                                  0x1c
#define UNIPHYC_CHANNEL_XBAR_CNTL__UNIPHY_CHANNEL0_XBAR_SOURCE_MASK                                           0x00000003L
#define UNIPHYC_CHANNEL_XBAR_CNTL__UNIPHY_CHANNEL1_XBAR_SOURCE_MASK                                           0x00000300L
#define UNIPHYC_CHANNEL_XBAR_CNTL__UNIPHY_CHANNEL2_XBAR_SOURCE_MASK                                           0x00030000L
#define UNIPHYC_CHANNEL_XBAR_CNTL__UNIPHY_CHANNEL3_XBAR_SOURCE_MASK                                           0x03000000L
#define UNIPHYC_CHANNEL_XBAR_CNTL__UNIPHY_LINK_ENABLE_MASK                                                    0x10000000L
//UNIPHYD_LINK_CNTL
#define UNIPHYD_LINK_CNTL__UNIPHY_PFREQCHG__SHIFT                                                             0x0
#define UNIPHYD_LINK_CNTL__UNIPHY_PIXVLD_RESET__SHIFT                                                         0x4
#define UNIPHYD_LINK_CNTL__UNIPHY_MINIMUM_PIXVLD_LOW_DURATION__SHIFT                                          0x8
#define UNIPHYD_LINK_CNTL__UNIPHY_CHANNEL0_INVERT__SHIFT                                                      0xc
#define UNIPHYD_LINK_CNTL__UNIPHY_CHANNEL1_INVERT__SHIFT                                                      0xd
#define UNIPHYD_LINK_CNTL__UNIPHY_CHANNEL2_INVERT__SHIFT                                                      0xe
#define UNIPHYD_LINK_CNTL__UNIPHY_CHANNEL3_INVERT__SHIFT                                                      0xf
#define UNIPHYD_LINK_CNTL__UNIPHY_LANE_STAGGER_DELAY__SHIFT                                                   0x14
#define UNIPHYD_LINK_CNTL__UNIPHY_LINK_ENABLE_HPD_MASK__SHIFT                                                 0x18
#define UNIPHYD_LINK_CNTL__UNIPHY_PFREQCHG_MASK                                                               0x00000001L
#define UNIPHYD_LINK_CNTL__UNIPHY_PIXVLD_RESET_MASK                                                           0x00000010L
#define UNIPHYD_LINK_CNTL__UNIPHY_MINIMUM_PIXVLD_LOW_DURATION_MASK                                            0x00000700L
#define UNIPHYD_LINK_CNTL__UNIPHY_CHANNEL0_INVERT_MASK                                                        0x00001000L
#define UNIPHYD_LINK_CNTL__UNIPHY_CHANNEL1_INVERT_MASK                                                        0x00002000L
#define UNIPHYD_LINK_CNTL__UNIPHY_CHANNEL2_INVERT_MASK                                                        0x00004000L
#define UNIPHYD_LINK_CNTL__UNIPHY_CHANNEL3_INVERT_MASK                                                        0x00008000L
#define UNIPHYD_LINK_CNTL__UNIPHY_LANE_STAGGER_DELAY_MASK                                                     0x00700000L
#define UNIPHYD_LINK_CNTL__UNIPHY_LINK_ENABLE_HPD_MASK_MASK                                                   0x03000000L
//UNIPHYD_CHANNEL_XBAR_CNTL
#define UNIPHYD_CHANNEL_XBAR_CNTL__UNIPHY_CHANNEL0_XBAR_SOURCE__SHIFT                                         0x0
#define UNIPHYD_CHANNEL_XBAR_CNTL__UNIPHY_CHANNEL1_XBAR_SOURCE__SHIFT                                         0x8
#define UNIPHYD_CHANNEL_XBAR_CNTL__UNIPHY_CHANNEL2_XBAR_SOURCE__SHIFT                                         0x10
#define UNIPHYD_CHANNEL_XBAR_CNTL__UNIPHY_CHANNEL3_XBAR_SOURCE__SHIFT                                         0x18
#define UNIPHYD_CHANNEL_XBAR_CNTL__UNIPHY_LINK_ENABLE__SHIFT                                                  0x1c
#define UNIPHYD_CHANNEL_XBAR_CNTL__UNIPHY_CHANNEL0_XBAR_SOURCE_MASK                                           0x00000003L
#define UNIPHYD_CHANNEL_XBAR_CNTL__UNIPHY_CHANNEL1_XBAR_SOURCE_MASK                                           0x00000300L
#define UNIPHYD_CHANNEL_XBAR_CNTL__UNIPHY_CHANNEL2_XBAR_SOURCE_MASK                                           0x00030000L
#define UNIPHYD_CHANNEL_XBAR_CNTL__UNIPHY_CHANNEL3_XBAR_SOURCE_MASK                                           0x03000000L
#define UNIPHYD_CHANNEL_XBAR_CNTL__UNIPHY_LINK_ENABLE_MASK                                                    0x10000000L
//UNIPHYE_LINK_CNTL
#define UNIPHYE_LINK_CNTL__UNIPHY_PFREQCHG__SHIFT                                                             0x0
#define UNIPHYE_LINK_CNTL__UNIPHY_PIXVLD_RESET__SHIFT                                                         0x4
#define UNIPHYE_LINK_CNTL__UNIPHY_MINIMUM_PIXVLD_LOW_DURATION__SHIFT                                          0x8
#define UNIPHYE_LINK_CNTL__UNIPHY_CHANNEL0_INVERT__SHIFT                                                      0xc
#define UNIPHYE_LINK_CNTL__UNIPHY_CHANNEL1_INVERT__SHIFT                                                      0xd
#define UNIPHYE_LINK_CNTL__UNIPHY_CHANNEL2_INVERT__SHIFT                                                      0xe
#define UNIPHYE_LINK_CNTL__UNIPHY_CHANNEL3_INVERT__SHIFT                                                      0xf
#define UNIPHYE_LINK_CNTL__UNIPHY_LANE_STAGGER_DELAY__SHIFT                                                   0x14
#define UNIPHYE_LINK_CNTL__UNIPHY_LINK_ENABLE_HPD_MASK__SHIFT                                                 0x18
#define UNIPHYE_LINK_CNTL__UNIPHY_PFREQCHG_MASK                                                               0x00000001L
#define UNIPHYE_LINK_CNTL__UNIPHY_PIXVLD_RESET_MASK                                                           0x00000010L
#define UNIPHYE_LINK_CNTL__UNIPHY_MINIMUM_PIXVLD_LOW_DURATION_MASK                                            0x00000700L
#define UNIPHYE_LINK_CNTL__UNIPHY_CHANNEL0_INVERT_MASK                                                        0x00001000L
#define UNIPHYE_LINK_CNTL__UNIPHY_CHANNEL1_INVERT_MASK                                                        0x00002000L
#define UNIPHYE_LINK_CNTL__UNIPHY_CHANNEL2_INVERT_MASK                                                        0x00004000L
#define UNIPHYE_LINK_CNTL__UNIPHY_CHANNEL3_INVERT_MASK                                                        0x00008000L
#define UNIPHYE_LINK_CNTL__UNIPHY_LANE_STAGGER_DELAY_MASK                                                     0x00700000L
#define UNIPHYE_LINK_CNTL__UNIPHY_LINK_ENABLE_HPD_MASK_MASK                                                   0x03000000L
//UNIPHYE_CHANNEL_XBAR_CNTL
#define UNIPHYE_CHANNEL_XBAR_CNTL__UNIPHY_CHANNEL0_XBAR_SOURCE__SHIFT                                         0x0
#define UNIPHYE_CHANNEL_XBAR_CNTL__UNIPHY_CHANNEL1_XBAR_SOURCE__SHIFT                                         0x8
#define UNIPHYE_CHANNEL_XBAR_CNTL__UNIPHY_CHANNEL2_XBAR_SOURCE__SHIFT                                         0x10
#define UNIPHYE_CHANNEL_XBAR_CNTL__UNIPHY_CHANNEL3_XBAR_SOURCE__SHIFT                                         0x18
#define UNIPHYE_CHANNEL_XBAR_CNTL__UNIPHY_LINK_ENABLE__SHIFT                                                  0x1c
#define UNIPHYE_CHANNEL_XBAR_CNTL__UNIPHY_CHANNEL0_XBAR_SOURCE_MASK                                           0x00000003L
#define UNIPHYE_CHANNEL_XBAR_CNTL__UNIPHY_CHANNEL1_XBAR_SOURCE_MASK                                           0x00000300L
#define UNIPHYE_CHANNEL_XBAR_CNTL__UNIPHY_CHANNEL2_XBAR_SOURCE_MASK                                           0x00030000L
#define UNIPHYE_CHANNEL_XBAR_CNTL__UNIPHY_CHANNEL3_XBAR_SOURCE_MASK                                           0x03000000L
#define UNIPHYE_CHANNEL_XBAR_CNTL__UNIPHY_LINK_ENABLE_MASK                                                    0x10000000L
//UNIPHYF_LINK_CNTL
#define UNIPHYF_LINK_CNTL__UNIPHY_PFREQCHG__SHIFT                                                             0x0
#define UNIPHYF_LINK_CNTL__UNIPHY_PIXVLD_RESET__SHIFT                                                         0x4
#define UNIPHYF_LINK_CNTL__UNIPHY_MINIMUM_PIXVLD_LOW_DURATION__SHIFT                                          0x8
#define UNIPHYF_LINK_CNTL__UNIPHY_CHANNEL0_INVERT__SHIFT                                                      0xc
#define UNIPHYF_LINK_CNTL__UNIPHY_CHANNEL1_INVERT__SHIFT                                                      0xd
#define UNIPHYF_LINK_CNTL__UNIPHY_CHANNEL2_INVERT__SHIFT                                                      0xe
#define UNIPHYF_LINK_CNTL__UNIPHY_CHANNEL3_INVERT__SHIFT                                                      0xf
#define UNIPHYF_LINK_CNTL__UNIPHY_LANE_STAGGER_DELAY__SHIFT                                                   0x14
#define UNIPHYF_LINK_CNTL__UNIPHY_LINK_ENABLE_HPD_MASK__SHIFT                                                 0x18
#define UNIPHYF_LINK_CNTL__UNIPHY_PFREQCHG_MASK                                                               0x00000001L
#define UNIPHYF_LINK_CNTL__UNIPHY_PIXVLD_RESET_MASK                                                           0x00000010L
#define UNIPHYF_LINK_CNTL__UNIPHY_MINIMUM_PIXVLD_LOW_DURATION_MASK                                            0x00000700L
#define UNIPHYF_LINK_CNTL__UNIPHY_CHANNEL0_INVERT_MASK                                                        0x00001000L
#define UNIPHYF_LINK_CNTL__UNIPHY_CHANNEL1_INVERT_MASK                                                        0x00002000L
#define UNIPHYF_LINK_CNTL__UNIPHY_CHANNEL2_INVERT_MASK                                                        0x00004000L
#define UNIPHYF_LINK_CNTL__UNIPHY_CHANNEL3_INVERT_MASK                                                        0x00008000L
#define UNIPHYF_LINK_CNTL__UNIPHY_LANE_STAGGER_DELAY_MASK                                                     0x00700000L
#define UNIPHYF_LINK_CNTL__UNIPHY_LINK_ENABLE_HPD_MASK_MASK                                                   0x03000000L
//UNIPHYF_CHANNEL_XBAR_CNTL
#define UNIPHYF_CHANNEL_XBAR_CNTL__UNIPHY_CHANNEL0_XBAR_SOURCE__SHIFT                                         0x0
#define UNIPHYF_CHANNEL_XBAR_CNTL__UNIPHY_CHANNEL1_XBAR_SOURCE__SHIFT                                         0x8
#define UNIPHYF_CHANNEL_XBAR_CNTL__UNIPHY_CHANNEL2_XBAR_SOURCE__SHIFT                                         0x10
#define UNIPHYF_CHANNEL_XBAR_CNTL__UNIPHY_CHANNEL3_XBAR_SOURCE__SHIFT                                         0x18
#define UNIPHYF_CHANNEL_XBAR_CNTL__UNIPHY_LINK_ENABLE__SHIFT                                                  0x1c
#define UNIPHYF_CHANNEL_XBAR_CNTL__UNIPHY_CHANNEL0_XBAR_SOURCE_MASK                                           0x00000003L
#define UNIPHYF_CHANNEL_XBAR_CNTL__UNIPHY_CHANNEL1_XBAR_SOURCE_MASK                                           0x00000300L
#define UNIPHYF_CHANNEL_XBAR_CNTL__UNIPHY_CHANNEL2_XBAR_SOURCE_MASK                                           0x00030000L
#define UNIPHYF_CHANNEL_XBAR_CNTL__UNIPHY_CHANNEL3_XBAR_SOURCE_MASK                                           0x03000000L
#define UNIPHYF_CHANNEL_XBAR_CNTL__UNIPHY_LINK_ENABLE_MASK                                                    0x10000000L
//UNIPHYG_LINK_CNTL
#define UNIPHYG_LINK_CNTL__UNIPHY_PFREQCHG__SHIFT                                                             0x0
#define UNIPHYG_LINK_CNTL__UNIPHY_PIXVLD_RESET__SHIFT                                                         0x4
#define UNIPHYG_LINK_CNTL__UNIPHY_MINIMUM_PIXVLD_LOW_DURATION__SHIFT                                          0x8
#define UNIPHYG_LINK_CNTL__UNIPHY_CHANNEL0_INVERT__SHIFT                                                      0xc
#define UNIPHYG_LINK_CNTL__UNIPHY_CHANNEL1_INVERT__SHIFT                                                      0xd
#define UNIPHYG_LINK_CNTL__UNIPHY_CHANNEL2_INVERT__SHIFT                                                      0xe
#define UNIPHYG_LINK_CNTL__UNIPHY_CHANNEL3_INVERT__SHIFT                                                      0xf
#define UNIPHYG_LINK_CNTL__UNIPHY_LANE_STAGGER_DELAY__SHIFT                                                   0x14
#define UNIPHYG_LINK_CNTL__UNIPHY_LINK_ENABLE_HPD_MASK__SHIFT                                                 0x18
#define UNIPHYG_LINK_CNTL__UNIPHY_PFREQCHG_MASK                                                               