message(STATUS "Note: the downloading server may only be avilable from 8:00AM-5:00PM (UTC+8), Mon-Fri (except public holidays in China)")

vcpkg_fail_port_install(ON_TARGET "OSX" "UWP" ON_ARCH "arm")
vcpkg_check_linkage(ONLY_DYNAMIC_LIBRARY)

vcpkg_download_distfile(ARCHIVE
	URLS "http://www.sfit.com.cn/DocumentDown/api_3/5_2_2/6.3.15_20190220.zip"
	FILENAME "6.3.15_20190220.zip"
	SHA512 e17bb9d7fdda85f944b241d7ecd6a3b6f7e145f1a9d39ad48b36aa015e7e8a1b599e0289c8c38ce0a84cc8426a374fd620b07815dc9b6083c562389867138577    
)

vcpkg_extract_source_archive_ex(
    OUT_SOURCE_PATH UNPACK_PATH
    ARCHIVE ${ARCHIVE}
    NO_REMOVE_ONE_LEVEL
)

if(VCPKG_TARGET_IS_WINDOWS AND VCPKG_TARGET_ARCHITECTURE STREQUAL "x86")
    set(ARCH_ARCHIVE "6.3.15_20190220_tradeapi_se_windows.zip")
    set(ARCH_ARCHIVE_DATACOLLECT "6.3.15_20190220_clientdll_windows.zip")
elseif(VCPKG_TARGET_IS_WINDOWS AND VCPKG_TARGET_ARCHITECTURE STREQUAL "x64")
    set(ARCH_ARCHIVE "6.3.15_20190220_tradeapi64_se_windows.zip")
    set(ARCH_ARCHIVE_DATACOLLECT "6.3.15_20190220_clientdll64_windows.zip")
elseif(VCPKG_TARGET_IS_LINUX AND VCPKG_TARGET_ARCHITECTURE STREQUAL "x64")
    set(ARCH_ARCHIVE "v6.3.15_20190220_api_tradeapi_se_linux64.tar")
    set(ARCH_ARCHIVE_DATACOLLECT "v6.3.15_20190220_api_clientdatacollectdll_linux64.tar")
else()
    message(FATAL_ERROR "${TARGET_TRIPLET} is not a supported platform" )
endif()

vcpkg_extract_source_archive_ex(
    OUT_SOURCE_PATH SOURCE_PATH
    ARCHIVE "${UNPACK_PATH}/${ARCH_ARCHIVE}"
)

file(INSTALL ${SOURCE_PATH}/ DESTINATION ${CURRENT_PACKAGES_DIR}/include FILES_MATCHING PATTERN "*.h")

if(VCPKG_TARGET_IS_WINDOWS)
    file(INSTALL ${SOURCE_PATH}/ DESTINATION ${CURRENT_PACKAGES_DIR}/lib FILES_MATCHING PATTERN "*.lib")
    file(INSTALL ${SOURCE_PATH}/ DESTINATION ${CURRENT_PACKAGES_DIR}/bin FILES_MATCHING PATTERN "*.dll")
    file(INSTALL ${SOURCE_PATH}/ DESTINATION ${CURRENT_PACKAGES_DIR}/debug/lib FILES_MATCHING PATTERN "*.lib")
    file(INSTALL ${SOURCE_PATH}/ DESTINATION ${CURRENT_PACKAGES_DIR}/debug/bin FILES_MATCHING PATTERN "*.dll")
elseif(VCPKG_TARGET_IS_LINUX)
    file(INSTALL ${SOURCE_PATH}/ DESTINATION ${CURRENT_PACKAGES_DIR}/lib FILES_MATCHING PATTERN "*.so")
    file(INSTALL ${SOURCE_PATH}/ DESTINATION ${CURRENT_PACKAGES_DIR}/debug/lib FILES_MATCHING PATTERN "*.so")
endif()

file(INSTALL ${SOURCE_PATH}/ DESTINATION ${CURRENT_PACKAGES_DIR}/share FILES_MATCHING PATTERN "*.xml")
file(INSTALL ${SOURCE_PATH}/ DESTINATION ${CURRENT_PACKAGES_DIR}/share FILES_MATCHING PATTERN "*.dtd")

if("datacollect" IN_LIST FEATURES)
    vcpkg_extract_source_archive_ex(
        OUT_SOURCE_PATH SOURCE_PATH_DATACOLLECT
        ARCHIVE "${UNPACK_PATH}/${ARCH_ARCHIVE_DATACOLLECT}"
    )
    file(INSTALL ${SOURCE_PATH_DATACOLLECT}/ DESTINATION ${CURRENT_PACKAGES_DIR}/include FILES_MATCHING PATTERN "*.h")

    if(VCPKG_TARGET_IS_WINDOWS)
        file(INSTALL ${SOURCE_PATH_DATACOLLECT}/ DESTINATION ${CURRENT_PACKAGES_DIR}/lib FILES_MATCHING PATTERN "*.lib")
        file(INSTALL ${SOURCE_PATH_DATACOLLECT}/ DESTINATION ${CURRENT_PACKAGES_DIR}/bin FILES_MATCHING PATTERN "*.dll")
        file(INSTALL ${SOURCE_PATH_DATACOLLECT}/ DESTINATION ${CURRENT_PACKAGES_DIR}/debug/lib FILES_MATCHING PATTERN "*.lib")
        file(INSTALL ${SOURCE_PATH_DATACOLLECT}/ DESTINATION ${CURRENT_PACKAGES_DIR}/debug/bin FILES_MATCHING PATTERN "*.dll")
    elseif(VCPKG_TARGET_IS_LINUX)
        file(INSTALL ${SOURCE_PATH_DATACOLLECT}/ DESTINATION ${CURRENT_PACKAGES_DIR}/lib FILES_MATCHING PATTERN "*.so")
        file(INSTALL ${SOURCE_PATH_DATACOLLECT}/ DESTINATION ${CURRENT_PACKAGES_DIR}/debug/lib FILES_MATCHING PATTERN "*.so")
    endif()
    
endif()

file(WRITE ${CURRENT_PACKAGES_DIR}/share/${PORT}/copyright "Copyright By Shanghai Futures Information Technology Co.,Ltd")
