vcpkg_from_bitbucket(
    OUT_SOURCE_PATH SOURCE_PATH
    REPO Pavel_Kisliak/BitSerializer
    REF 0.10
    SHA512 a8a5acf4f9cc83d3090a3b06efbca682f4e022b5206bc7859ba6738e4d49a7678aa55f431f1721d50b28d8bde126b672396baae27cbaa79f62e3dc237ae678e1
    HEAD_REF master
)

vcpkg_check_features(OUT_FEATURE_OPTIONS FEATURE_OPTIONS
    "cpprestjson-archive"  BUILD_CPPRESTJSON_ARCHIVE
    "rapidjson-archive"    BUILD_RAPIDJSON_ARCHIVE
    "pugixml-archive"      BUILD_PUGIXML_ARCHIVE
    "rapidyaml-archive"    BUILD_RAPIDYAML_ARCHIVE
)

vcpkg_configure_cmake(
    SOURCE_PATH ${SOURCE_PATH}
    PREFER_NINJA
    OPTIONS
        ${FEATURE_OPTIONS}
)
vcpkg_install_cmake()
vcpkg_fixup_cmake_targets(CONFIG_PATH share/bitserializer)

file(REMOVE_RECURSE ${CURRENT_PACKAGES_DIR}/lib ${CURRENT_PACKAGES_DIR}/debug)

# Handle copyright
file(INSTALL ${SOURCE_PATH}/license.txt DESTINATION ${CURRENT_PACKAGES_DIR}/share/${PORT} RENAME copyright)
