#ifndef WMGENERAL_H_INCLUDED
#define WMGENERAL_H_INCLUDED

#ifdef HAVE_CONFIG_H
/* Generated without include header guards */
# ifndef CONFIG_H_INCLUDED
#  include "config.h"
#  ifndef CONFIG_H_INCLUDED
#   define CONFIG_H_INCLUDED
#  endif	/* CONFIG_H_INCLUDED */
# endif	/* CONFIG_H_INCLUDED */
#endif	/* HAVE_CONFIG_H */

/* X11 includes */
#include <X11/X.h>
#include <X11/xpm.h>
#include <string.h>

  /***********/
 /* Defines */
/***********/

/* Configuration files */
#define MAINRC_FILE	"/etc/wmnutrc"
#define RC_FILE  	".wmnutrc"


#define MAX_MOUSE_REGION (8)

#define TYPE_NULL	0
#define TYPE_INT	1
#define TYPE_FLOAT	2
#define TYPE_STRING	3
#define TYPE_BOOL	4

  /************/
 /* Typedefs */
/************/

union var {
	int	*integer;
	float	*floater;
	char	*str;
	int	*boolean;
};

typedef struct {
	/*const*/ char *label;
	int	type;
	union var	var;
}rckeys;

typedef struct {
	Pixmap	pixmap;
	Pixmap	mask;
	XpmAttributes	attributes;
} XpmIcon;

  /*******************/
 /* Global variable */
/*******************/

extern Display	*display;

  /***********************/
 /* Function Prototypes */
/***********************/


extern void CleanHosts(void);
extern int AddHost(char *hostname);
extern void GetFirstHost(void);
extern int GetNextHost(void);
extern int GetPrevHost(void);

void AddMouseRegion(int index, int left, int top, int right, int bottom);
int  CheckMouseRegion(int x, int y);

void SetWindowName(char *name);
void openXwindow(int argc, char *argv[], char **, char *, int, int, int withdrawn);
void RedrawWindow(void);
void RedrawWindowXY(int x, int y);
void CheckX11Events(void);
void pressEvent(XButtonEvent *xev);

void copyXPMArea(int, int, int, int, int, int);
void copyXBMArea(int, int, int, int, int, int);
void setMaskXY(int, int);

void AddRcKey(rckeys *key, const char *label, int type, void *var);
void FreeRcKeyData(rckeys *key);
void FreeRcKeys(rckeys *key);	/* Free an array starting from given element and up to TYPE_NULL entry */
void ParseRCFile(const char *filename, rckeys *keys);
void ParseCMDLine(int argc, char *argv[]);
void LoadRCFile(rckeys *keys);
void ReloadRCFile(void);

  /************/
 /* Datadefs */
/************/
extern int	Alert;	/* Controls whether alert is sent to
			 * all users via wall: Off by default  */
/* base parameters */
extern char	*upshost;
extern int	Verbose;	/* 1 for verbose mode : displays NUT
				 * available features and base values */
extern int	CriticalLevel;
extern int	LowLevel;
extern float	BlinkRate;	/* blinks per second */
extern float	UpdateRate;	/* Number of updates per second */
extern int	Beep;	/* Controls beeping when you get to
			 * CriticalLevel: Off by default */
extern int	Volume;	/* ring bell at 50% volume */
extern int	UseLowColorPixmap;	/* Use a lower number of colors for the
					 * poor saps on 8-bit displays */
extern float	LAlertRate;	/* send alert every 5 minutes when Low */
extern float	CAlertRate;	/* send alert every 2 minutes when Critical */
extern int	WithDrawn;	/* start in withdrawn shape (for WindowMaker) */

#endif	/* WMGENERAL_H_INCLUDED */
