#include <signal.h>
#ifdef __wasilibc_unmodified_upstream
#include "syscall.h"
#endif

void __SIG_IGN(int sig) {
    // do nothing
}

_Noreturn
void __SIG_ERR(int sig) {
    __builtin_trap();
}

// This is emulated in the bottom end instead

void (*signal(int sig, void (*func)(int)))(int)
{
	struct sigaction sa_old, sa = { .sa_handler = func, .sa_flags = SA_RESTART };
	if (__sigaction(sig, &sa, &sa_old) < 0)
		return SIG_ERR;
	return sa_old.sa_handler;
}

weak_alias(signal, bsd_signal);
weak_alias(signal, __sysv_signal);