/* SPDX-License-Identifier: LGPL-2.1-or-later */
#pragma once

#include <syslog.h>

#if HAVE_LIBBPF

#include <bpf/bpf.h>    /* IWYU pragma: export */
#include <bpf/libbpf.h> /* IWYU pragma: export */

#include "bpf-compat.h" /* IWYU pragma: export */
#include "dlfcn-util.h"
#include "shared-forward.h"

extern DLSYM_PROTOTYPE(bpf_link__destroy);
extern DLSYM_PROTOTYPE(bpf_link__fd);
extern DLSYM_PROTOTYPE(bpf_link__open);
extern DLSYM_PROTOTYPE(bpf_link__pin);
extern DLSYM_PROTOTYPE(bpf_map__fd);
extern DLSYM_PROTOTYPE(bpf_map__name);
extern DLSYM_PROTOTYPE(bpf_map__set_inner_map_fd);
extern DLSYM_PROTOTYPE(bpf_map__set_max_entries);
extern DLSYM_PROTOTYPE(bpf_map__set_pin_path);
extern DLSYM_PROTOTYPE(bpf_map_delete_elem);
extern DLSYM_PROTOTYPE(bpf_map_get_fd_by_id);
extern DLSYM_PROTOTYPE(bpf_map_lookup_elem);
extern DLSYM_PROTOTYPE(bpf_map_update_elem);
/* The *_skeleton APIs are autogenerated by bpftool, the targets can be found
 * in ./build/src/core/bpf/socket-bind/socket-bind.skel.h */
extern DLSYM_PROTOTYPE(bpf_object__attach_skeleton);
extern DLSYM_PROTOTYPE(bpf_object__destroy_skeleton);
extern DLSYM_PROTOTYPE(bpf_object__detach_skeleton);
extern DLSYM_PROTOTYPE(bpf_object__load_skeleton);
extern DLSYM_PROTOTYPE(bpf_object__name);
extern DLSYM_PROTOTYPE(bpf_object__open_skeleton);
extern DLSYM_PROTOTYPE(bpf_object__pin_maps);
extern DLSYM_PROTOTYPE(bpf_program__attach);
extern DLSYM_PROTOTYPE(bpf_program__attach_cgroup);
extern DLSYM_PROTOTYPE(bpf_program__attach_lsm);
extern DLSYM_PROTOTYPE(bpf_program__name);
extern DLSYM_PROTOTYPE(libbpf_set_print);
extern DLSYM_PROTOTYPE(ring_buffer__epoll_fd);
extern DLSYM_PROTOTYPE(ring_buffer__free);
extern DLSYM_PROTOTYPE(ring_buffer__new);
extern DLSYM_PROTOTYPE(ring_buffer__poll);

/* libbpf sometimes returns error codes that make sense only in the kernel, like 524 for EOPNOTSUPP. Use
 * this helper instead of libbpf_get_error() to ensure some of the known ones are translated into errnos
 * we understand. */
int bpf_get_error_translated(const void *ptr);

#endif

int dlopen_bpf_full(int log_level);
static inline int dlopen_bpf(void) {
        return dlopen_bpf_full(LOG_DEBUG);
}
