/*
 * MOTIS API
 *
 * This is the MOTIS routing API.  Overview of MOTIS API versions:  MOTIS 0.x - deprecated/discontinued  MOTIS 2.x - current, providing:  * /api/v5/{plan,trip,stoptimes,map/trips} renamed METRO mode to SUBURBAN, AREAL_LIFT to AERIAL_LIFT; since MOTIS 2.5.0 * /api/v4/{plan,trip,stoptimes,map/trips} new displayName property, routeShortName only contains actual route short name from source; since MOTIS 2.2.0 * /api/v3/plan with correct maxTransfers API parameter (transfers actually corresponding to number of changes between transit legs (and not to number of transit legs), i.e. maxTransfers=0 returns direct public transit connections, as expected); since MOTIS 2.0.84  * /api/v2/{plan,trip} returns Google polylines with precision=6; since MOTIS 2.0.60 * /api/v1/{plan,trip} returns Google polylines with precision=7 (not defined for |longitude|>107) * /api/v1/_* all other endpoints  If you use the JS client lib https://www.npmjs.com/package/@motis-project/motis-client, endpoint versions will be taken into account automatically (i.e. the newest one available will be used). 
 *
 * The version of the OpenAPI document: v5
 * Contact: felix@triptix.tech
 * Generated by: https://openapi-generator.tech
 */

use crate::models;
use serde::{Deserialize, Serialize};

/// Alert : An alert, indicating some sort of incident in the public transit network.
#[derive(Clone, Default, Debug, PartialEq, Serialize, Deserialize)]
pub struct Alert {
    /// Time when the alert should be shown to the user. If missing, the alert will be shown as long as it appears in the feed. If multiple ranges are given, the alert will be shown during all of them. 
    #[serde(rename = "communicationPeriod", skip_serializing_if = "Option::is_none")]
    pub communication_period: Option<Vec<models::TimeRange>>,
    /// Time when the services are affected by the disruption mentioned in the alert.
    #[serde(rename = "impactPeriod", skip_serializing_if = "Option::is_none")]
    pub impact_period: Option<Vec<models::TimeRange>>,
    #[serde(rename = "cause", skip_serializing_if = "Option::is_none")]
    pub cause: Option<models::AlertCause>,
    /// Description of the cause of the alert that allows for agency-specific language; more specific than the Cause. 
    #[serde(rename = "causeDetail", skip_serializing_if = "Option::is_none")]
    pub cause_detail: Option<String>,
    #[serde(rename = "effect", skip_serializing_if = "Option::is_none")]
    pub effect: Option<models::AlertEffect>,
    /// Description of the effect of the alert that allows for agency-specific language; more specific than the Effect. 
    #[serde(rename = "effectDetail", skip_serializing_if = "Option::is_none")]
    pub effect_detail: Option<String>,
    /// The URL which provides additional information about the alert.
    #[serde(rename = "url", skip_serializing_if = "Option::is_none")]
    pub url: Option<String>,
    /// Header for the alert. This plain-text string will be highlighted, for example in boldface. 
    #[serde(rename = "headerText")]
    pub header_text: String,
    /// Description for the alert. This plain-text string will be formatted as the body of the alert (or shown on an explicit \"expand\" request by the user). The information in the description should add to the information of the header. 
    #[serde(rename = "descriptionText")]
    pub description_text: String,
    /// Text containing the alert's header to be used for text-to-speech implementations. This field is the text-to-speech version of header_text. It should contain the same information as headerText but formatted such that it can read as text-to-speech (for example, abbreviations removed, numbers spelled out, etc.) 
    #[serde(rename = "ttsHeaderText", skip_serializing_if = "Option::is_none")]
    pub tts_header_text: Option<String>,
    /// Text containing a description for the alert to be used for text-to-speech implementations. This field is the text-to-speech version of description_text. It should contain the same information as description_text but formatted such that it can be read as text-to-speech (for example, abbreviations removed, numbers spelled out, etc.) 
    #[serde(rename = "ttsDescriptionText", skip_serializing_if = "Option::is_none")]
    pub tts_description_text: Option<String>,
    /// Severity of the alert.
    #[serde(rename = "severityLevel", skip_serializing_if = "Option::is_none")]
    pub severity_level: Option<models::AlertSeverityLevel>,
    /// String containing an URL linking to an image.
    #[serde(rename = "imageUrl", skip_serializing_if = "Option::is_none")]
    pub image_url: Option<String>,
    /// IANA media type as to specify the type of image to be displayed. The type must start with \"image/\" 
    #[serde(rename = "imageMediaType", skip_serializing_if = "Option::is_none")]
    pub image_media_type: Option<String>,
    /// Text describing the appearance of the linked image in the image field (e.g., in case the image can't be displayed or the user can't see the image for accessibility reasons). See the HTML spec for alt image text. 
    #[serde(rename = "imageAlternativeText", skip_serializing_if = "Option::is_none")]
    pub image_alternative_text: Option<String>,
}

impl Alert {
    /// An alert, indicating some sort of incident in the public transit network.
    pub fn new(header_text: String, description_text: String) -> Alert {
        Alert {
            communication_period: None,
            impact_period: None,
            cause: None,
            cause_detail: None,
            effect: None,
            effect_detail: None,
            url: None,
            header_text,
            description_text,
            tts_header_text: None,
            tts_description_text: None,
            severity_level: None,
            image_url: None,
            image_media_type: None,
            image_alternative_text: None,
        }
    }
}

