% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/io.R
\name{url_destination}
\alias{url_destination}
\title{Get the final destination of a URL}
\usage{
url_destination(x, force = FALSE)
}
\arguments{
\item{x}{A character vector of URLs.}

\item{force}{By default, the query is cached in the current R session. To
bypass the cache, use \code{force = TRUE}.}
}
\value{
The final destination(s). If the URL returns a status code greater
than or equal to 400, it will throw an error.
}
\description{
If a URL is redirected, query the new location via \code{\link[=curlGetHeaders]{curlGetHeaders()}},
otherwise return the original URL.
}
\examples{
u = "https://tinytex.yihui.org"  # redirected to https://yihui.org/tinytex/
if (url_accessible(u)) url_destination(u)
}
