% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/games_howell_test.R
\name{games_howell_test}
\alias{games_howell_test}
\title{Games Howell Post-hoc Tests}
\usage{
games_howell_test(data, formula, conf.level = 0.95, detailed = FALSE)
}
\arguments{
\item{data}{a data.frame containing the variables in the formula.}

\item{formula}{a formula of the form \code{x ~ group} where \code{x} is a
numeric variable giving the data values and \code{group} is a factor with
one or multiple levels giving the corresponding groups. For example,
\code{formula = TP53 ~ cancer_group}.}

\item{conf.level}{confidence level of the interval.}

\item{detailed}{logical value. Default is FALSE. If TRUE, a detailed result is
shown.}
}
\value{
return a data frame with some of the following columns: \itemize{
 \item \code{.y.}: the y (outcome) variable used in the test. \item
 \code{group1,group2}: the compared groups in the pairwise tests. \item
 \code{n1,n2}: Sample counts. \item \code{estimate, conf.low, conf.high}:
 mean difference and its confidence intervals. \item \code{statistic}: Test
 statistic (t-value) used to compute the p-value. \item \code{df}: degrees of
 freedom calculated using Welch’s correction. \item \code{p.adj}: adjusted p-value using Tukey's method. \item
 \code{method}: the statistical test used to compare groups. \item
 \code{p.adj.signif}: the significance level of p-values. }

 The \strong{returned object has an attribute called args}, which is a list
 holding the test arguments.
}
\description{
Performs Games-Howell test, which is used to compare all possible
 combinations of group differences when the assumption of homogeneity of
 variances is violated. This post hoc test provides confidence intervals for
 the differences between group means and shows whether the differences are
 statistically significant.

 The test is based on Welch’s degrees of freedom correction and uses Tukey’s
 studentized range distribution for computing the p-values. The test compares
 the difference between each pair of means with appropriate adjustment for
 the multiple testing. So there is no need to apply additional p-value
 corrections.
}
\details{
The Games-Howell method is an improved version of the Tukey-Kramer
 method and is applicable in cases where the equivalence of variance
 assumption is violated. It is a t-test using Welch’s degree of freedom. This
 method uses a strategy for controlling the type I error for the entire
 comparison and is known to maintain the preset significance level even when
 the size of the sample is different. However, the smaller the number of
 samples in each group, the it is more tolerant the type I error control.
 Thus, this method can be applied when the number of samples is six or more.
}
\examples{
# Simple test
ToothGrowth \%>\% games_howell_test(len ~ dose)

# Grouped data
ToothGrowth \%>\%
  group_by(supp) \%>\%
  games_howell_test(len ~ dose)

}
\references{
\itemize{ \item Aaron Schlege,
 https://rpubs.com/aaronsc32/games-howell-test. \item Sangseok Lee, Dong Kyu
 Lee. What is the proper way to apply the multiple comparison test?. Korean J
 Anesthesiol. 2018;71(5):353-360. }
}
