% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/append_chunk.R
\name{prepend_chunks}
\alias{prepend_chunks}
\title{Prepend chunks to flextable content}
\usage{
prepend_chunks(x, ..., i = NULL, j = NULL, part = "body")
}
\arguments{
\item{x}{a 'flextable' object, see \link{flextable-package} to learn how to create
'flextable' object.}

\item{...}{chunks to be prepended, see \code{\link[=as_chunk]{as_chunk()}}, \code{\link[=gg_chunk]{gg_chunk()}} and other
chunk elements for paragraph.}

\item{i}{row selector, see section \emph{Row selection with the \code{i} parameter}
in <\code{\link[=flextable_selectors]{Selectors in flextable}}>.}

\item{j}{column selector, see section \emph{Column selection with the \code{j} parameter}
in <\code{\link[=flextable_selectors]{Selectors in flextable}}>.}

\item{part}{part selector, see section \emph{Part selection with the \code{part}
parameter} in <\code{\link[=flextable_selectors]{Selectors in flextable}}>.
Value 'all' is not allowed by the function.}
}
\description{
prepend chunks (for example chunk \code{\link[=as_chunk]{as_chunk()}})
in a flextable.
}
\examples{
x <- flextable(head(iris))
x <- prepend_chunks(
  x,
  i = 1, j = 1,
  colorize(as_b("Hello "), color = "red"),
  colorize(as_i("World"), color = "magenta")
)
x
}
\seealso{
Other functions for mixed content paragraphs: 
\code{\link{append_chunks}()},
\code{\link{as_paragraph}()},
\code{\link{compose}()}
}
\concept{functions for mixed content paragraphs}
