/*
 * Decompiled with CFR 0.152.
 */
package org.apache.webdav.lib;

import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Vector;
import org.apache.commons.httpclient.HttpState;

public class WebdavState
extends HttpState {
    private static final String[] EMPTY_ARRAY = new String[0];
    protected HashMap locks = new HashMap();
    protected ArrayList lockTokens = new ArrayList();

    public void addLock(String uri, String value) {
        if (value == null) {
            return;
        }
        if (this.lockTokens.contains(value)) {
            return;
        }
        this.locks.put(uri, value);
        this.lockTokens.add(value);
    }

    public void removeLock(String uri, String value) {
        this.locks.remove(uri);
        int i = this.lockTokens.indexOf(value);
        if (i != -1) {
            this.lockTokens.remove(i);
        }
    }

    public void removeLocks(String uri) {
        int i;
        String result = (String)this.locks.remove(uri);
        if (result != null && (i = this.lockTokens.indexOf(result)) != -1) {
            this.lockTokens.remove(i);
        }
    }

    public String getLock(String uri) {
        return (String)this.locks.get(uri);
    }

    public Enumeration getLocks(String uri) {
        Vector<String> result = new Vector<String>();
        String lockToken = this.getLock(uri);
        if (lockToken != null) {
            result.addElement(lockToken);
        }
        return result.elements();
    }

    public String[] getAllLocks(String uri) {
        return this.lockTokens.toArray(EMPTY_ARRAY);
    }
}

