import logging

import django.conf.urls
import django.views.generic.base
from django.urls import include, path, re_path

from mini_buildd import admin, api, config, views

LOG = logging.getLogger(__name__)

home_view = django.views.generic.base.RedirectView.as_view(url=config.URIS["events"]["view"].uri)


urlpatterns = [
    # Redirect
    path("", home_view),
    path("mini_buildd/", home_view),

    # /admin
    path(config.URIS["admin"]["view"].django(), admin.site.urls),

    # /accounts/
    path(config.URIS["accounts"]["register"].django(), views.AccountRegisterView.as_view(), name="register"),
    path(config.URIS["accounts"]["activate"].django() + "<uidb64>/<token>/", views.AccountActivateView.as_view(), name="activate"),
    path(config.URIS["accounts"]["profile"].django(), views.AccountProfileView.as_view(), name="profile"),
    path(config.URIS["accounts"]["null"].django(), views.AccountNullView.as_view(), name="null"),
    path(config.URIS["accounts"]["base"].django(), include("django.contrib.auth.urls")),

    # /mini_buildd/
    re_path(config.URIS["events"]["view"].django(), views.EventsView.as_view(), kwargs={"route": "events", "name": "events"}, name="events"),
    re_path(config.URIS["events"]["dir"].django(), views.DirView.as_view(), kwargs={"route": "events", "name": "events-dir"}, name="events-dir"),
    re_path(config.URIS["events"]["static"].django(), views.DefaultView.as_view(), name="events-static"),
    re_path(config.URIS["builds"]["dir"].django(), views.DirView.as_view(), kwargs={"route": "builds", "name": "builds-dir"}, name="builds-dir"),
    re_path(config.URIS["builds"]["static"].django(), views.DefaultView.as_view(), name="builds-static"),
    re_path(config.URIS["repositories"]["view"].django(), views.RepositoriesView.as_view(), kwargs={"route": "repositories", "name": "repositories"}, name="repositories"),
    re_path(config.URIS["repositories"]["dir"].django(), views.DirView.as_view(), kwargs={"route": "repositories", "name": "repositories-dir"}, name="repositories-dir"),
    re_path(config.URIS["repositories"]["static"].django(), views.DefaultView.as_view(), name="repositories-static"),
    path(config.URIS["builders"]["view"].django(), views.BuildersView.as_view(), kwargs={"route": "builders", "name": "builders"}, name="builders"),
    path(config.URIS["crontab"]["view"].django(), views.DefaultView.as_view(), kwargs={"route": "crontab", "name": "crontab"}, name="crontab"),
    path(config.URIS["api"]["view"].django(), views.DefaultView.as_view(), kwargs={"route": "api", "name": "api"}, name="api"),
    path(config.URIS["sitemap"]["view"].django(), views.DefaultView.as_view(), kwargs={"route": "sitemap", "name": "sitemap"}, name="sitemap"),
    path(config.URIS["manual"]["view"].django(), views.ManualView.as_view(), kwargs={"route": "manual", "name": "manual"}, name="manual"),
    path(config.URIS["manual"]["static"].django(), views.ManualView.as_view(), kwargs={"route": "manual", "name": "manual-static"}, name="manual-static"),
    path(config.URIS["setup"]["view"].django(), views.SetupView.as_view(), kwargs={"route": "setup", "name": "setup"}, name="setup"),
]

# /mini_buildd/api/<call>/
for _NAME, _CALL in api.CALLS.items():
    _uri = config.Uri(_CALL.uri())
    LOG.debug("Adding API route: %s: %s", _NAME, _uri)
    urlpatterns.append(path(_uri.django(), views.APIView.as_view(), kwargs={"call": _CALL}, name=f"apicall_{_NAME}"))

django.conf.urls.handler400 = views.ExceptionMiddleware.bad_request
django.conf.urls.handler403 = views.ExceptionMiddleware.permission_denied
django.conf.urls.handler404 = views.ExceptionMiddleware.page_not_found
django.conf.urls.handler500 = views.ExceptionMiddleware.server_error
