<head>
    <meta charset="UTF-8">
    <meta name="description" content="NVIDIA CUDA APIs supported by HIPIFY">
    <meta name="keywords" content="HIPIFY, HIP, ROCm, NVIDIA, CUDA, CUDA2HIP, hipification, hipify-clang, hipify-perl, FFT, cuFFT, cuFFTXt, hipFFT, hipFFTXt">
</head>

# CUFFT API supported by HIP


**Note\:** In the tables that follow the columns marked `A`, `D`, `C`, `R`, and `E` mean the following:
**A** - Added; **D** - Deprecated; **C** - Changed; **R** - Removed; **E** - Experimental

## **1. CUFFT Data types**

|**CUDA**|**A**|**D**|**C**|**R**|**HIP**|**A**|**D**|**C**|**R**|**E**|
|:--|:-:|:-:|:-:|:-:|:--|:-:|:-:|:-:|:-:|:-:|
|`CUFFT_ALLOC_FAILED`| | | | |`HIPFFT_ALLOC_FAILED`|1.7.0| | | | |
|`CUFFT_C2C`| | | | |`HIPFFT_C2C`|1.7.0| | | | |
|`CUFFT_C2R`| | | | |`HIPFFT_C2R`|1.7.0| | | | |
|`CUFFT_CB_LD_COMPLEX`| | | | |`HIPFFT_CB_LD_COMPLEX`|4.3.0| | | | |
|`CUFFT_CB_LD_COMPLEX_DOUBLE`| | | | |`HIPFFT_CB_LD_COMPLEX_DOUBLE`|4.3.0| | | | |
|`CUFFT_CB_LD_REAL`| | | | |`HIPFFT_CB_LD_REAL`|4.3.0| | | | |
|`CUFFT_CB_LD_REAL_DOUBLE`| | | | |`HIPFFT_CB_LD_REAL_DOUBLE`|4.3.0| | | | |
|`CUFFT_CB_ST_COMPLEX`| | | | |`HIPFFT_CB_ST_COMPLEX`|4.3.0| | | | |
|`CUFFT_CB_ST_COMPLEX_DOUBLE`| | | | |`HIPFFT_CB_ST_COMPLEX_DOUBLE`|4.3.0| | | | |
|`CUFFT_CB_ST_REAL`| | | | |`HIPFFT_CB_ST_REAL`|4.3.0| | | | |
|`CUFFT_CB_ST_REAL_DOUBLE`| | | | |`HIPFFT_CB_ST_REAL_DOUBLE`|4.3.0| | | | |
|`CUFFT_CB_UNDEFINED`| | | | |`HIPFFT_CB_UNDEFINED`|4.3.0| | | | |
|`CUFFT_COMPATIBILITY_DEFAULT`| | | | | | | | | | |
|`CUFFT_COMPATIBILITY_FFTW_PADDING`| | | | | | | | | | |
|`CUFFT_COPY_DEVICE_TO_DEVICE`| | | | |`HIPFFT_COPY_DEVICE_TO_DEVICE`|6.0.0| | | | |
|`CUFFT_COPY_DEVICE_TO_HOST`| | | | |`HIPFFT_COPY_DEVICE_TO_HOST`|6.0.0| | | | |
|`CUFFT_COPY_HOST_TO_DEVICE`| | | | |`HIPFFT_COPY_HOST_TO_DEVICE`|6.0.0| | | | |
|`CUFFT_COPY_UNDEFINED`| | | | |`HIPFFT_COPY_UNDEFINED`|6.0.0| | | | |
|`CUFFT_D2Z`| | | | |`HIPFFT_D2Z`|1.7.0| | | | |
|`CUFFT_EXEC_FAILED`| | | | |`HIPFFT_EXEC_FAILED`|1.7.0| | | | |
|`CUFFT_FORMAT_UNDEFINED`| | | | |`HIPFFT_FORMAT_UNDEFINED`|6.0.0| | | | |
|`CUFFT_FORWARD`| | | | |`HIPFFT_FORWARD`|1.7.0| | | | |
|`CUFFT_INCOMPLETE_PARAMETER_LIST`| | | | |`HIPFFT_INCOMPLETE_PARAMETER_LIST`|1.7.0| | | | |
|`CUFFT_INTERNAL_ERROR`| | | | |`HIPFFT_INTERNAL_ERROR`|1.7.0| | | | |
|`CUFFT_INVALID_DEVICE`| | | | |`HIPFFT_INVALID_DEVICE`|1.7.0| | | | |
|`CUFFT_INVALID_PLAN`| | | | |`HIPFFT_INVALID_PLAN`|1.7.0| | | | |
|`CUFFT_INVALID_SIZE`| | | | |`HIPFFT_INVALID_SIZE`|1.7.0| | | | |
|`CUFFT_INVALID_TYPE`| | | | |`HIPFFT_INVALID_TYPE`|1.7.0| | | | |
|`CUFFT_INVALID_VALUE`| | | | |`HIPFFT_INVALID_VALUE`|1.7.0| | | | |
|`CUFFT_INVERSE`| | | | |`HIPFFT_BACKWARD`|1.7.0| | | | |
|`CUFFT_LICENSE_ERROR`| | | | | | | | | | |
|`CUFFT_NOT_IMPLEMENTED`| | | | |`HIPFFT_NOT_IMPLEMENTED`|1.7.0| | | | |
|`CUFFT_NOT_SUPPORTED`|8.0| | | |`HIPFFT_NOT_SUPPORTED`|1.7.0| | | | |
|`CUFFT_NO_WORKSPACE`| | | | |`HIPFFT_NO_WORKSPACE`|1.7.0| | | | |
|`CUFFT_PARSE_ERROR`| | | | |`HIPFFT_PARSE_ERROR`|1.7.0| | | | |
|`CUFFT_QUERY_1D_FACTORS`| | | | | | | | | | |
|`CUFFT_QUERY_UNDEFINED`| | | | | | | | | | |
|`CUFFT_R2C`| | | | |`HIPFFT_R2C`|1.7.0| | | | |
|`CUFFT_SETUP_FAILED`| | | | |`HIPFFT_SETUP_FAILED`|1.7.0| | | | |
|`CUFFT_SUCCESS`| | | | |`HIPFFT_SUCCESS`|1.7.0| | | | |
|`CUFFT_UNALIGNED_DATA`| | | | |`HIPFFT_UNALIGNED_DATA`|1.7.0| | | | |
|`CUFFT_WORKAREA_MINIMAL`|9.2| | | | | | | | | |
|`CUFFT_WORKAREA_PERFORMANCE`| | | | | | | | | | |
|`CUFFT_WORKAREA_USER`|9.2| | | | | | | | | |
|`CUFFT_XT_FORMAT_1D_INPUT_SHUFFLED`| | | | |`HIPFFT_XT_FORMAT_1D_INPUT_SHUFFLED`|6.0.0| | | | |
|`CUFFT_XT_FORMAT_DISTRIBUTED_INPUT`|11.8| | | | | | | | | |
|`CUFFT_XT_FORMAT_DISTRIBUTED_OUTPUT`|11.8| | | | | | | | | |
|`CUFFT_XT_FORMAT_INPLACE`| | | | |`HIPFFT_XT_FORMAT_INPLACE`|6.0.0| | | | |
|`CUFFT_XT_FORMAT_INPLACE_SHUFFLED`| | | | |`HIPFFT_XT_FORMAT_INPLACE_SHUFFLED`|6.0.0| | | | |
|`CUFFT_XT_FORMAT_INPUT`| | | | |`HIPFFT_XT_FORMAT_INPUT`|6.0.0| | | | |
|`CUFFT_XT_FORMAT_OUTPUT`| | | | |`HIPFFT_XT_FORMAT_OUTPUT`|6.0.0| | | | |
|`CUFFT_Z2D`| | | | |`HIPFFT_Z2D`|1.7.0| | | | |
|`CUFFT_Z2Z`| | | | |`HIPFFT_Z2Z`|1.7.0| | | | |
|`MAX_CUFFT_ERROR`| | | | | | | | | | |
|`NVFFT_PLAN_PROPERTY_INT64_MAX_NUM_HOST_THREADS`|12.5| | | | | | | | | |
|`NVFFT_PLAN_PROPERTY_INT64_PATIENT_JIT`|12.4| | | | | | | | | |
|`cudaLibXtDesc`| | | | |`hipLibXtDesc`|6.0.0| | | | |
|`cudaLibXtDesc_t`| | | | |`hipLibXtDesc_t`|6.0.0| | | | |
|`cufftBox3d`|11.8| | | | | | | | | |
|`cufftBox3d_t`|11.8| | | | | | | | | |
|`cufftCompatibility`| | | | | | | | | | |
|`cufftCompatibility_t`| | | | | | | | | | |
|`cufftComplex`| | | | |`hipfftComplex`|1.7.0| | | | |
|`cufftDoubleComplex`| | | | |`hipfftDoubleComplex`|1.7.0| | | | |
|`cufftDoubleReal`| | | | |`hipfftDoubleReal`|1.7.0| | | | |
|`cufftHandle`| | | | |`hipfftHandle`|1.7.0| | | | |
|`cufftProperty`|12.4| | | | | | | | | |
|`cufftProperty_t`|12.4| | | | | | | | | |
|`cufftReal`| | | | |`hipfftReal`|1.7.0| | | | |
|`cufftResult`| | | | |`hipfftResult`|1.7.0| | | | |
|`cufftResult_t`| | | | |`hipfftResult_t`|1.7.0| | | | |
|`cufftType`| | | | |`hipfftType`|1.7.0| | | | |
|`cufftType_t`| | | | |`hipfftType_t`|1.7.0| | | | |
|`cufftXt1dFactors`| | | | | | | | | | |
|`cufftXt1dFactors_t`| | | | | | | | | | |
|`cufftXtCallbackType`| | | | |`hipfftXtCallbackType`|4.3.0| | | | |
|`cufftXtCallbackType_t`| | | | |`hipfftXtCallbackType_t`|4.3.0| | | | |
|`cufftXtCopyType`| | | | |`hipfftXtCopyType`|6.0.0| | | | |
|`cufftXtCopyType_t`| | | | |`hipfftXtCopyType_t`|6.0.0| | | | |
|`cufftXtQueryType`| | | | | | | | | | |
|`cufftXtQueryType_t`| | | | | | | | | | |
|`cufftXtSubFormat`| | | | |`hipfftXtSubFormat`|6.0.0| | | | |
|`cufftXtSubFormat_t`| | | | |`hipfftXtSubFormat_t`|6.0.0| | | | |
|`cufftXtWorkAreaPolicy`|9.2| | | | | | | | | |
|`cufftXtWorkAreaPolicy_t`|9.2| | | | | | | | | |

## **2. CUFFT API functions**

|**CUDA**|**A**|**D**|**C**|**R**|**HIP**|**A**|**D**|**C**|**R**|**E**|
|:--|:-:|:-:|:-:|:-:|:--|:-:|:-:|:-:|:-:|:-:|
|`cufftCallbackLoadC`| | | | |`hipfftCallbackLoadC`|4.3.0| | | | |
|`cufftCallbackLoadD`| | | | |`hipfftCallbackLoadD`|4.3.0| | | | |
|`cufftCallbackLoadR`| | | | |`hipfftCallbackLoadR`|4.3.0| | | | |
|`cufftCallbackLoadZ`| | | | |`hipfftCallbackLoadZ`|4.3.0| | | | |
|`cufftCallbackStoreC`| | | | |`hipfftCallbackStoreC`|4.3.0| | | | |
|`cufftCallbackStoreD`| | | | |`hipfftCallbackStoreD`|4.3.0| | | | |
|`cufftCallbackStoreR`| | | | |`hipfftCallbackStoreR`|4.3.0| | | | |
|`cufftCallbackStoreZ`| | | | |`hipfftCallbackStoreZ`|4.3.0| | | | |
|`cufftCreate`| | | | |`hipfftCreate`|1.7.0| | | | |
|`cufftDestroy`| | | | |`hipfftDestroy`|1.7.0| | | | |
|`cufftEstimate1d`| | | | |`hipfftEstimate1d`|1.7.0| | | | |
|`cufftEstimate2d`| | | | |`hipfftEstimate2d`|1.7.0| | | | |
|`cufftEstimate3d`| | | | |`hipfftEstimate3d`|1.7.0| | | | |
|`cufftEstimateMany`| | | | |`hipfftEstimateMany`|1.7.0| | | | |
|`cufftExecC2C`| | | | |`hipfftExecC2C`|1.7.0| | | | |
|`cufftExecC2R`| | | | |`hipfftExecC2R`|1.7.0| | | | |
|`cufftExecD2Z`| | | | |`hipfftExecD2Z`|1.7.0| | | | |
|`cufftExecR2C`| | | | |`hipfftExecR2C`|1.7.0| | | | |
|`cufftExecZ2D`| | | | |`hipfftExecZ2D`|1.7.0| | | | |
|`cufftExecZ2Z`| | | | |`hipfftExecZ2Z`|1.7.0| | | | |
|`cufftGetPlanPropertyInt64`|12.4| | | | | | | | | |
|`cufftGetProperty`|8.0| | | |`hipfftGetProperty`|2.6.0| | | | |
|`cufftGetSize`| | | | |`hipfftGetSize`|1.7.0| | | | |
|`cufftGetSize1d`| | | | |`hipfftGetSize1d`|1.7.0| | | | |
|`cufftGetSize2d`| | | | |`hipfftGetSize2d`|1.7.0| | | | |
|`cufftGetSize3d`| | | | |`hipfftGetSize3d`|1.7.0| | | | |
|`cufftGetSizeMany`| | | | |`hipfftGetSizeMany`|1.7.0| | | | |
|`cufftGetSizeMany64`|7.5| | | |`hipfftGetSizeMany64`|1.7.0| | | | |
|`cufftGetVersion`| | | | |`hipfftGetVersion`|1.7.0| | | | |
|`cufftMakePlan1d`| | | | |`hipfftMakePlan1d`|1.7.0| | | | |
|`cufftMakePlan2d`| | | | |`hipfftMakePlan2d`|1.7.0| | | | |
|`cufftMakePlan3d`| | | | |`hipfftMakePlan3d`|1.7.0| | | | |
|`cufftMakePlanMany`| | | | |`hipfftMakePlanMany`|1.7.0| | | | |
|`cufftMakePlanMany64`|7.5| | | |`hipfftMakePlanMany64`|1.7.0| | | | |
|`cufftPlan1d`| | | | |`hipfftPlan1d`|1.7.0| | | | |
|`cufftPlan2d`| | | | |`hipfftPlan2d`|1.7.0| | | | |
|`cufftPlan3d`| | | | |`hipfftPlan3d`|1.7.0| | | | |
|`cufftPlanMany`| | | | |`hipfftPlanMany`|1.7.0| | | | |
|`cufftResetPlanProperty`|12.4| | | | | | | | | |
|`cufftSetAutoAllocation`| | | | |`hipfftSetAutoAllocation`|1.7.0| | | | |
|`cufftSetPlanPropertyInt64`|12.4| | | | | | | | | |
|`cufftSetStream`| | | | |`hipfftSetStream`|1.7.0| | | | |
|`cufftSetWorkArea`| | | | |`hipfftSetWorkArea`|1.7.0| | | | |
|`cufftXtClearCallback`| | | | |`hipfftXtClearCallback`|4.3.0| | | | |
|`cufftXtExec`|8.0| | | |`hipfftXtExec`|5.6.0| | | | |
|`cufftXtExecDescriptor`|8.0| | | |`hipfftXtExecDescriptor`|6.0.0| | | | |
|`cufftXtExecDescriptorC2C`| | | | |`hipfftXtExecDescriptorC2C`|6.0.0| | | | |
|`cufftXtExecDescriptorC2R`| | | | |`hipfftXtExecDescriptorC2R`|6.0.0| | | | |
|`cufftXtExecDescriptorD2Z`| | | | |`hipfftXtExecDescriptorD2Z`|6.0.0| | | | |
|`cufftXtExecDescriptorR2C`| | | | |`hipfftXtExecDescriptorR2C`|6.0.0| | | | |
|`cufftXtExecDescriptorZ2D`| | | | |`hipfftXtExecDescriptorZ2D`|6.0.0| | | | |
|`cufftXtExecDescriptorZ2Z`| | | | |`hipfftXtExecDescriptorZ2Z`|6.0.0| | | | |
|`cufftXtFree`| | | | |`hipfftXtFree`|6.0.0| | | | |
|`cufftXtGetSizeMany`|8.0| | | |`hipfftXtGetSizeMany`|5.6.0| | | | |
|`cufftXtMakePlanMany`|8.0| | | |`hipfftXtMakePlanMany`|5.6.0| | | | |
|`cufftXtMalloc`| | | | |`hipfftXtMalloc`|6.0.0| | | | |
|`cufftXtMemcpy`| | | | |`hipfftXtMemcpy`|6.0.0| | | | |
|`cufftXtQueryPlan`| | | | | | | | | | |
|`cufftXtSetCallback`| | | | |`hipfftXtSetCallback`|4.3.0| | | | |
|`cufftXtSetCallbackSharedSize`| | | | |`hipfftXtSetCallbackSharedSize`|4.3.0| | | | |
|`cufftXtSetDistribution`|11.8| | | | | | | | | |
|`cufftXtSetGPUs`| | | | |`hipfftXtSetGPUs`|6.0.0| | | | |
|`cufftXtSetWorkArea`| | | | | | | | | | |
|`cufftXtSetWorkAreaPolicy`|9.2| | | | | | | | | |

