<!-- groonga-command -->
<!-- database: tokenizers_language_model_knn -->

# `TokenLanguageModelKNN`

```{versionadded} 15.1.8

```

```{note}
This is an experimental feature. Currently, this feature is still not stable.
```

## Summary

`TokenLanguageModelKNN` is a tokenizer that supports semantic search.

Semantic search uses the k-Nearest Neighbors (k-NN) algorithm.

To enable this tokenizer, register `language_model/knn` plugin by the following command:

```shell
plugin_register language_model/knn
```

## Syntax

`TokenLanguageModelKNN` requires two parameters:

```
TokenLanguageModelKNN("model", "hf:///path/to", "code_column", "column_name")
```

`TokenLanguageModelKNN` has one optional parameter.

```
TokenLanguageModelKNN("model", "hf:///path/to", "code_column", "column_name", "n_clusters", N_CLUSTERS)
```

## Usage

```{note}
This tokenizer can't be run with {doc}`../commands/tokenize` command.
```

This usage example shows how to set `TokenLanguageModelKNN` as `default_tokenizer`.

You need to register `language_model/knn` plugin at first:

<!-- groonga-command -->

```{include} ../../example/reference/tokenizers/language_model_knn/usage_register.md
plugin_register language_model/knn
```

Here is a schema definition and sample data.

Sample schema:

<!-- groonga-command -->

```{include} ../../example/reference/tokenizers/language_model_knn/usage_setup_schema.md
table_create --name Memos --flags TABLE_NO_KEY
column_create \
  --table Memos \
  --name content \
  --flags COLUMN_SCALAR \
  --type ShortText
```

Sample data:

<!-- groonga-command -->

```{include} ../../example/reference/tokenizers/language_model_knn/usage_setup_data.md
load --table Memos
[
{"content": "I am a boy."},
{"content": "This is an apple."},
{"content": "Groonga is a full text search engine."}
]
```

You need to store embedding information for each record. Here is how to create that column.

<!-- groonga-command -->

```{include} ../../example/reference/tokenizers/language_model_knn/column_create.md
column_create Memos embedding_code COLUMN_SCALAR ShortBinary
```

Create an index for semantic search.

Specify `TokenLanguageModelKNN` as the tokenizer.

<!-- groonga-command -->

```{include} ../../example/reference/tokenizers/language_model_knn/index_column_create.md
table_create Centroids TABLE_HASH_KEY ShortBinary \
  --default_tokenizer \
    'TokenLanguageModelKNN("model", "hf:///groonga/all-MiniLM-L6-v2-Q4_K_M-GGUF", \
                           "code_column", "embedding_code")'

column_create Centroids data_content COLUMN_INDEX Memos content
```

You can see that the embedding has been generated by fetching `Memos` table.
The generated bytecode is saved.

<!-- groonga-command -->

```{include} ../../example/reference/tokenizers/language_model_knn/select.md
select Memos
```

Users do not operate on this `embedding_code`. Groonga uses it internally for semantic search.

## Parameters

### Required parameters

#### `model`

Specify the language model to use.
You can specify a Hugging Face URI for `model`.

At the first index creation, it automatically downloads and places the model in the directory of Groonga's database.
After that, it uses the locally located model.

Example of URI: `hf:///groonga/all-MiniLM-L6-v2-Q4_K_M-GGUF` for `https://huggingface.co/groonga/all-MiniLM-L6-v2-Q4_K_M-GGUF`.

See also {doc}`../language_model` for language model.

#### `code_column`

Specify the column for storing the embedding.

Create a column in the table storing the searchable text and specify its column name.

### Optional parameter

#### `n_clusters`

Specify the number of clusters to use as indexes.
If not specified, an appropriate value will be set automatically.

Usually, no specification is necessary.

## See also

- {doc}`../language_model`
- {doc}`../commands/tokenize`
- {doc}`../functions/language_model_knn`
