// Copyright 2024 Google LLC
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//     http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Code generated by protoc-gen-go. DO NOT EDIT.
// versions:
// 	protoc-gen-go v1.34.1
// 	protoc        v4.25.3
// source: google/cloud/edgenetwork/v1/resources.proto

package edgenetworkpb

import (
	reflect "reflect"
	sync "sync"

	_ "google.golang.org/genproto/googleapis/api/annotations"
	protoreflect "google.golang.org/protobuf/reflect/protoreflect"
	protoimpl "google.golang.org/protobuf/runtime/protoimpl"
	timestamppb "google.golang.org/protobuf/types/known/timestamppb"
)

const (
	// Verify that this generated code is sufficiently up-to-date.
	_ = protoimpl.EnforceVersion(20 - protoimpl.MinVersion)
	// Verify that runtime/protoimpl is sufficiently up-to-date.
	_ = protoimpl.EnforceVersion(protoimpl.MaxVersion - 20)
)

// ResourceState describes the state the resource.
// A normal lifecycle of a new resource being created would be: PENDING ->
// PROVISIONING -> RUNNING. A normal lifecycle of an existing resource being
// deleted would be: RUNNING -> DELETING. Any failures during processing will
// result the resource to be in a SUSPENDED state.
type ResourceState int32

const (
	// Unspecified state.
	ResourceState_STATE_UNKNOWN ResourceState = 0
	// The resource is being prepared to be applied to the rack.
	ResourceState_STATE_PENDING ResourceState = 1
	// The resource has started being applied to the rack.
	ResourceState_STATE_PROVISIONING ResourceState = 2
	// The resource has been pushed to the rack.
	ResourceState_STATE_RUNNING ResourceState = 3
	// The resource failed to push to the rack.
	ResourceState_STATE_SUSPENDED ResourceState = 4
	// The resource is under deletion.
	ResourceState_STATE_DELETING ResourceState = 5
)

// Enum value maps for ResourceState.
var (
	ResourceState_name = map[int32]string{
		0: "STATE_UNKNOWN",
		1: "STATE_PENDING",
		2: "STATE_PROVISIONING",
		3: "STATE_RUNNING",
		4: "STATE_SUSPENDED",
		5: "STATE_DELETING",
	}
	ResourceState_value = map[string]int32{
		"STATE_UNKNOWN":      0,
		"STATE_PENDING":      1,
		"STATE_PROVISIONING": 2,
		"STATE_RUNNING":      3,
		"STATE_SUSPENDED":    4,
		"STATE_DELETING":     5,
	}
)

func (x ResourceState) Enum() *ResourceState {
	p := new(ResourceState)
	*p = x
	return p
}

func (x ResourceState) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (ResourceState) Descriptor() protoreflect.EnumDescriptor {
	return file_google_cloud_edgenetwork_v1_resources_proto_enumTypes[0].Descriptor()
}

func (ResourceState) Type() protoreflect.EnumType {
	return &file_google_cloud_edgenetwork_v1_resources_proto_enumTypes[0]
}

func (x ResourceState) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use ResourceState.Descriptor instead.
func (ResourceState) EnumDescriptor() ([]byte, []int) {
	return file_google_cloud_edgenetwork_v1_resources_proto_rawDescGZIP(), []int{0}
}

// Type of interconnect.
type Interconnect_InterconnectType int32

const (
	// Unspecified.
	Interconnect_INTERCONNECT_TYPE_UNSPECIFIED Interconnect_InterconnectType = 0
	// Dedicated Interconnect.
	Interconnect_DEDICATED Interconnect_InterconnectType = 1
)

// Enum value maps for Interconnect_InterconnectType.
var (
	Interconnect_InterconnectType_name = map[int32]string{
		0: "INTERCONNECT_TYPE_UNSPECIFIED",
		1: "DEDICATED",
	}
	Interconnect_InterconnectType_value = map[string]int32{
		"INTERCONNECT_TYPE_UNSPECIFIED": 0,
		"DEDICATED":                     1,
	}
)

func (x Interconnect_InterconnectType) Enum() *Interconnect_InterconnectType {
	p := new(Interconnect_InterconnectType)
	*p = x
	return p
}

func (x Interconnect_InterconnectType) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (Interconnect_InterconnectType) Descriptor() protoreflect.EnumDescriptor {
	return file_google_cloud_edgenetwork_v1_resources_proto_enumTypes[1].Descriptor()
}

func (Interconnect_InterconnectType) Type() protoreflect.EnumType {
	return &file_google_cloud_edgenetwork_v1_resources_proto_enumTypes[1]
}

func (x Interconnect_InterconnectType) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use Interconnect_InterconnectType.Descriptor instead.
func (Interconnect_InterconnectType) EnumDescriptor() ([]byte, []int) {
	return file_google_cloud_edgenetwork_v1_resources_proto_rawDescGZIP(), []int{3, 0}
}

// State enum for LACP link.
type InterconnectDiagnostics_LinkLACPStatus_State int32

const (
	// The default state indicating state is in unknown state.
	InterconnectDiagnostics_LinkLACPStatus_UNKNOWN InterconnectDiagnostics_LinkLACPStatus_State = 0
	// The link is configured and active within the bundle.
	InterconnectDiagnostics_LinkLACPStatus_ACTIVE InterconnectDiagnostics_LinkLACPStatus_State = 1
	// The link is not configured within the bundle, this means the rest of
	// the object should be empty.
	InterconnectDiagnostics_LinkLACPStatus_DETACHED InterconnectDiagnostics_LinkLACPStatus_State = 2
)

// Enum value maps for InterconnectDiagnostics_LinkLACPStatus_State.
var (
	InterconnectDiagnostics_LinkLACPStatus_State_name = map[int32]string{
		0: "UNKNOWN",
		1: "ACTIVE",
		2: "DETACHED",
	}
	InterconnectDiagnostics_LinkLACPStatus_State_value = map[string]int32{
		"UNKNOWN":  0,
		"ACTIVE":   1,
		"DETACHED": 2,
	}
)

func (x InterconnectDiagnostics_LinkLACPStatus_State) Enum() *InterconnectDiagnostics_LinkLACPStatus_State {
	p := new(InterconnectDiagnostics_LinkLACPStatus_State)
	*p = x
	return p
}

func (x InterconnectDiagnostics_LinkLACPStatus_State) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (InterconnectDiagnostics_LinkLACPStatus_State) Descriptor() protoreflect.EnumDescriptor {
	return file_google_cloud_edgenetwork_v1_resources_proto_enumTypes[2].Descriptor()
}

func (InterconnectDiagnostics_LinkLACPStatus_State) Type() protoreflect.EnumType {
	return &file_google_cloud_edgenetwork_v1_resources_proto_enumTypes[2]
}

func (x InterconnectDiagnostics_LinkLACPStatus_State) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use InterconnectDiagnostics_LinkLACPStatus_State.Descriptor instead.
func (InterconnectDiagnostics_LinkLACPStatus_State) EnumDescriptor() ([]byte, []int) {
	return file_google_cloud_edgenetwork_v1_resources_proto_rawDescGZIP(), []int{8, 2, 0}
}

// Status of the BGP peer: {UP, DOWN}
type RouterStatus_BgpPeerStatus_BgpStatus int32

const (
	// The default status indicating BGP session is in unknown state.
	RouterStatus_BgpPeerStatus_UNKNOWN RouterStatus_BgpPeerStatus_BgpStatus = 0
	// The UP status indicating BGP session is established.
	RouterStatus_BgpPeerStatus_UP RouterStatus_BgpPeerStatus_BgpStatus = 1
	// The DOWN state indicating BGP session is not established yet.
	RouterStatus_BgpPeerStatus_DOWN RouterStatus_BgpPeerStatus_BgpStatus = 2
)

// Enum value maps for RouterStatus_BgpPeerStatus_BgpStatus.
var (
	RouterStatus_BgpPeerStatus_BgpStatus_name = map[int32]string{
		0: "UNKNOWN",
		1: "UP",
		2: "DOWN",
	}
	RouterStatus_BgpPeerStatus_BgpStatus_value = map[string]int32{
		"UNKNOWN": 0,
		"UP":      1,
		"DOWN":    2,
	}
)

func (x RouterStatus_BgpPeerStatus_BgpStatus) Enum() *RouterStatus_BgpPeerStatus_BgpStatus {
	p := new(RouterStatus_BgpPeerStatus_BgpStatus)
	*p = x
	return p
}

func (x RouterStatus_BgpPeerStatus_BgpStatus) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (RouterStatus_BgpPeerStatus_BgpStatus) Descriptor() protoreflect.EnumDescriptor {
	return file_google_cloud_edgenetwork_v1_resources_proto_enumTypes[3].Descriptor()
}

func (RouterStatus_BgpPeerStatus_BgpStatus) Type() protoreflect.EnumType {
	return &file_google_cloud_edgenetwork_v1_resources_proto_enumTypes[3]
}

func (x RouterStatus_BgpPeerStatus_BgpStatus) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use RouterStatus_BgpPeerStatus_BgpStatus.Descriptor instead.
func (RouterStatus_BgpPeerStatus_BgpStatus) EnumDescriptor() ([]byte, []int) {
	return file_google_cloud_edgenetwork_v1_resources_proto_rawDescGZIP(), []int{9, 0, 0}
}

// A Google Edge Cloud zone.
type Zone struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The resource name of the zone.
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
	// Output only. The time when the zone was created.
	CreateTime *timestamppb.Timestamp `protobuf:"bytes,2,opt,name=create_time,json=createTime,proto3" json:"create_time,omitempty"`
	// Output only. The time when the zone was last updated.
	UpdateTime *timestamppb.Timestamp `protobuf:"bytes,3,opt,name=update_time,json=updateTime,proto3" json:"update_time,omitempty"`
	// Deprecated: not implemented.
	// Labels as key value pairs.
	//
	// Deprecated: Marked as deprecated in google/cloud/edgenetwork/v1/resources.proto.
	Labels map[string]string `protobuf:"bytes,4,rep,name=labels,proto3" json:"labels,omitempty" protobuf_key:"bytes,1,opt,name=key,proto3" protobuf_val:"bytes,2,opt,name=value,proto3"`
	// Deprecated: not implemented.
	// The deployment layout type.
	//
	// Deprecated: Marked as deprecated in google/cloud/edgenetwork/v1/resources.proto.
	LayoutName string `protobuf:"bytes,5,opt,name=layout_name,json=layoutName,proto3" json:"layout_name,omitempty"`
}

func (x *Zone) Reset() {
	*x = Zone{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_edgenetwork_v1_resources_proto_msgTypes[0]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *Zone) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*Zone) ProtoMessage() {}

func (x *Zone) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_edgenetwork_v1_resources_proto_msgTypes[0]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use Zone.ProtoReflect.Descriptor instead.
func (*Zone) Descriptor() ([]byte, []int) {
	return file_google_cloud_edgenetwork_v1_resources_proto_rawDescGZIP(), []int{0}
}

func (x *Zone) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

func (x *Zone) GetCreateTime() *timestamppb.Timestamp {
	if x != nil {
		return x.CreateTime
	}
	return nil
}

func (x *Zone) GetUpdateTime() *timestamppb.Timestamp {
	if x != nil {
		return x.UpdateTime
	}
	return nil
}

// Deprecated: Marked as deprecated in google/cloud/edgenetwork/v1/resources.proto.
func (x *Zone) GetLabels() map[string]string {
	if x != nil {
		return x.Labels
	}
	return nil
}

// Deprecated: Marked as deprecated in google/cloud/edgenetwork/v1/resources.proto.
func (x *Zone) GetLayoutName() string {
	if x != nil {
		return x.LayoutName
	}
	return ""
}

// Message describing Network object
type Network struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The canonical resource name of the network.
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
	// Output only. The time when the network was created.
	CreateTime *timestamppb.Timestamp `protobuf:"bytes,2,opt,name=create_time,json=createTime,proto3" json:"create_time,omitempty"`
	// Output only. The time when the network was last updated.
	UpdateTime *timestamppb.Timestamp `protobuf:"bytes,3,opt,name=update_time,json=updateTime,proto3" json:"update_time,omitempty"`
	// Labels associated with this resource.
	Labels map[string]string `protobuf:"bytes,4,rep,name=labels,proto3" json:"labels,omitempty" protobuf_key:"bytes,1,opt,name=key,proto3" protobuf_val:"bytes,2,opt,name=value,proto3"`
	// Optional. A free-text description of the resource. Max length 1024
	// characters.
	Description string `protobuf:"bytes,5,opt,name=description,proto3" json:"description,omitempty"`
	// IP (L3) MTU value of the network.
	// Valid values are: 1500 and 9000.
	// Default to 1500 if not set.
	Mtu int32 `protobuf:"varint,6,opt,name=mtu,proto3" json:"mtu,omitempty"`
}

func (x *Network) Reset() {
	*x = Network{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_edgenetwork_v1_resources_proto_msgTypes[1]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *Network) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*Network) ProtoMessage() {}

func (x *Network) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_edgenetwork_v1_resources_proto_msgTypes[1]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use Network.ProtoReflect.Descriptor instead.
func (*Network) Descriptor() ([]byte, []int) {
	return file_google_cloud_edgenetwork_v1_resources_proto_rawDescGZIP(), []int{1}
}

func (x *Network) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

func (x *Network) GetCreateTime() *timestamppb.Timestamp {
	if x != nil {
		return x.CreateTime
	}
	return nil
}

func (x *Network) GetUpdateTime() *timestamppb.Timestamp {
	if x != nil {
		return x.UpdateTime
	}
	return nil
}

func (x *Network) GetLabels() map[string]string {
	if x != nil {
		return x.Labels
	}
	return nil
}

func (x *Network) GetDescription() string {
	if x != nil {
		return x.Description
	}
	return ""
}

func (x *Network) GetMtu() int32 {
	if x != nil {
		return x.Mtu
	}
	return 0
}

// Message describing Subnet object
type Subnet struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The canonical resource name of the subnet.
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
	// Output only. The time when the subnet was created.
	CreateTime *timestamppb.Timestamp `protobuf:"bytes,2,opt,name=create_time,json=createTime,proto3" json:"create_time,omitempty"`
	// Output only. The time when the subnet was last updated.
	UpdateTime *timestamppb.Timestamp `protobuf:"bytes,3,opt,name=update_time,json=updateTime,proto3" json:"update_time,omitempty"`
	// Labels associated with this resource.
	Labels map[string]string `protobuf:"bytes,4,rep,name=labels,proto3" json:"labels,omitempty" protobuf_key:"bytes,1,opt,name=key,proto3" protobuf_val:"bytes,2,opt,name=value,proto3"`
	// Optional. A free-text description of the resource. Max length 1024
	// characters.
	Description string `protobuf:"bytes,5,opt,name=description,proto3" json:"description,omitempty"`
	// Required. The network that this subnetwork belongs to.
	Network string `protobuf:"bytes,6,opt,name=network,proto3" json:"network,omitempty"`
	// The ranges of ipv4 addresses that are owned by this subnetwork.
	Ipv4Cidr []string `protobuf:"bytes,7,rep,name=ipv4_cidr,json=ipv4Cidr,proto3" json:"ipv4_cidr,omitempty"`
	// The ranges of ipv6 addresses that are owned by this subnetwork.
	Ipv6Cidr []string `protobuf:"bytes,8,rep,name=ipv6_cidr,json=ipv6Cidr,proto3" json:"ipv6_cidr,omitempty"`
	// Optional. VLAN id provided by user. If not specified we assign one
	// automatically.
	VlanId int32 `protobuf:"varint,9,opt,name=vlan_id,json=vlanId,proto3" json:"vlan_id,omitempty"`
	// Output only. Current stage of the resource to the device by config push.
	State ResourceState `protobuf:"varint,10,opt,name=state,proto3,enum=google.cloud.edgenetwork.v1.ResourceState" json:"state,omitempty"`
}

func (x *Subnet) Reset() {
	*x = Subnet{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_edgenetwork_v1_resources_proto_msgTypes[2]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *Subnet) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*Subnet) ProtoMessage() {}

func (x *Subnet) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_edgenetwork_v1_resources_proto_msgTypes[2]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use Subnet.ProtoReflect.Descriptor instead.
func (*Subnet) Descriptor() ([]byte, []int) {
	return file_google_cloud_edgenetwork_v1_resources_proto_rawDescGZIP(), []int{2}
}

func (x *Subnet) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

func (x *Subnet) GetCreateTime() *timestamppb.Timestamp {
	if x != nil {
		return x.CreateTime
	}
	return nil
}

func (x *Subnet) GetUpdateTime() *timestamppb.Timestamp {
	if x != nil {
		return x.UpdateTime
	}
	return nil
}

func (x *Subnet) GetLabels() map[string]string {
	if x != nil {
		return x.Labels
	}
	return nil
}

func (x *Subnet) GetDescription() string {
	if x != nil {
		return x.Description
	}
	return ""
}

func (x *Subnet) GetNetwork() string {
	if x != nil {
		return x.Network
	}
	return ""
}

func (x *Subnet) GetIpv4Cidr() []string {
	if x != nil {
		return x.Ipv4Cidr
	}
	return nil
}

func (x *Subnet) GetIpv6Cidr() []string {
	if x != nil {
		return x.Ipv6Cidr
	}
	return nil
}

func (x *Subnet) GetVlanId() int32 {
	if x != nil {
		return x.VlanId
	}
	return 0
}

func (x *Subnet) GetState() ResourceState {
	if x != nil {
		return x.State
	}
	return ResourceState_STATE_UNKNOWN
}

// Message describing Interconnect object
type Interconnect struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The canonical resource name of the interconnect.
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
	// Output only. The time when the subnet was created.
	CreateTime *timestamppb.Timestamp `protobuf:"bytes,2,opt,name=create_time,json=createTime,proto3" json:"create_time,omitempty"`
	// Output only. The time when the subnet was last updated.
	UpdateTime *timestamppb.Timestamp `protobuf:"bytes,3,opt,name=update_time,json=updateTime,proto3" json:"update_time,omitempty"`
	// Labels associated with this resource.
	Labels map[string]string `protobuf:"bytes,4,rep,name=labels,proto3" json:"labels,omitempty" protobuf_key:"bytes,1,opt,name=key,proto3" protobuf_val:"bytes,2,opt,name=value,proto3"`
	// Optional. A free-text description of the resource. Max length 1024
	// characters.
	Description string `protobuf:"bytes,5,opt,name=description,proto3" json:"description,omitempty"`
	// Optional. Type of interconnect, which takes only the value 'DEDICATED' for
	// now.
	InterconnectType Interconnect_InterconnectType `protobuf:"varint,6,opt,name=interconnect_type,json=interconnectType,proto3,enum=google.cloud.edgenetwork.v1.Interconnect_InterconnectType" json:"interconnect_type,omitempty"`
	// Output only. Unique identifier for the link.
	Uuid string `protobuf:"bytes,7,opt,name=uuid,proto3" json:"uuid,omitempty"`
	// Output only. Cloud resource name of the switch device.
	DeviceCloudResourceName string `protobuf:"bytes,8,opt,name=device_cloud_resource_name,json=deviceCloudResourceName,proto3" json:"device_cloud_resource_name,omitempty"`
	// Output only. Physical ports (e.g., TenGigE0/0/0/1) that form the
	// interconnect.
	PhysicalPorts []string `protobuf:"bytes,9,rep,name=physical_ports,json=physicalPorts,proto3" json:"physical_ports,omitempty"`
}

func (x *Interconnect) Reset() {
	*x = Interconnect{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_edgenetwork_v1_resources_proto_msgTypes[3]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *Interconnect) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*Interconnect) ProtoMessage() {}

func (x *Interconnect) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_edgenetwork_v1_resources_proto_msgTypes[3]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use Interconnect.ProtoReflect.Descriptor instead.
func (*Interconnect) Descriptor() ([]byte, []int) {
	return file_google_cloud_edgenetwork_v1_resources_proto_rawDescGZIP(), []int{3}
}

func (x *Interconnect) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

func (x *Interconnect) GetCreateTime() *timestamppb.Timestamp {
	if x != nil {
		return x.CreateTime
	}
	return nil
}

func (x *Interconnect) GetUpdateTime() *timestamppb.Timestamp {
	if x != nil {
		return x.UpdateTime
	}
	return nil
}

func (x *Interconnect) GetLabels() map[string]string {
	if x != nil {
		return x.Labels
	}
	return nil
}

func (x *Interconnect) GetDescription() string {
	if x != nil {
		return x.Description
	}
	return ""
}

func (x *Interconnect) GetInterconnectType() Interconnect_InterconnectType {
	if x != nil {
		return x.InterconnectType
	}
	return Interconnect_INTERCONNECT_TYPE_UNSPECIFIED
}

func (x *Interconnect) GetUuid() string {
	if x != nil {
		return x.Uuid
	}
	return ""
}

func (x *Interconnect) GetDeviceCloudResourceName() string {
	if x != nil {
		return x.DeviceCloudResourceName
	}
	return ""
}

func (x *Interconnect) GetPhysicalPorts() []string {
	if x != nil {
		return x.PhysicalPorts
	}
	return nil
}

// Message describing InterconnectAttachment object
type InterconnectAttachment struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The canonical resource name of the interconnect attachment.
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
	// Output only. The time when the interconnect attachment was created.
	CreateTime *timestamppb.Timestamp `protobuf:"bytes,2,opt,name=create_time,json=createTime,proto3" json:"create_time,omitempty"`
	// Output only. The time when the interconnect attachment was last updated.
	UpdateTime *timestamppb.Timestamp `protobuf:"bytes,3,opt,name=update_time,json=updateTime,proto3" json:"update_time,omitempty"`
	// Labels associated with this resource.
	Labels map[string]string `protobuf:"bytes,4,rep,name=labels,proto3" json:"labels,omitempty" protobuf_key:"bytes,1,opt,name=key,proto3" protobuf_val:"bytes,2,opt,name=value,proto3"`
	// Optional. A free-text description of the resource. Max length 1024
	// characters.
	Description string `protobuf:"bytes,5,opt,name=description,proto3" json:"description,omitempty"`
	// Required. The canonical name of underlying Interconnect object that this
	// attachment's traffic will traverse through. The name is in the form of
	// `projects/{project}/locations/{location}/zones/{zone}/interconnects/{interconnect}`.
	Interconnect string `protobuf:"bytes,6,opt,name=interconnect,proto3" json:"interconnect,omitempty"`
	// Optional. The canonical Network name in the form of
	// `projects/{project}/locations/{location}/zones/{zone}/networks/{network}`.
	Network string `protobuf:"bytes,11,opt,name=network,proto3" json:"network,omitempty"`
	// Required. VLAN id provided by user. Must be site-wise unique.
	VlanId int32 `protobuf:"varint,8,opt,name=vlan_id,json=vlanId,proto3" json:"vlan_id,omitempty"`
	// IP (L3) MTU value of the virtual edge cloud.
	// Valid values are: 1500 and 9000.
	// Default to 1500 if not set.
	Mtu int32 `protobuf:"varint,9,opt,name=mtu,proto3" json:"mtu,omitempty"`
	// Output only. Current stage of the resource to the device by config push.
	State ResourceState `protobuf:"varint,10,opt,name=state,proto3,enum=google.cloud.edgenetwork.v1.ResourceState" json:"state,omitempty"`
}

func (x *InterconnectAttachment) Reset() {
	*x = InterconnectAttachment{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_edgenetwork_v1_resources_proto_msgTypes[4]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *InterconnectAttachment) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*InterconnectAttachment) ProtoMessage() {}

func (x *InterconnectAttachment) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_edgenetwork_v1_resources_proto_msgTypes[4]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use InterconnectAttachment.ProtoReflect.Descriptor instead.
func (*InterconnectAttachment) Descriptor() ([]byte, []int) {
	return file_google_cloud_edgenetwork_v1_resources_proto_rawDescGZIP(), []int{4}
}

func (x *InterconnectAttachment) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

func (x *InterconnectAttachment) GetCreateTime() *timestamppb.Timestamp {
	if x != nil {
		return x.CreateTime
	}
	return nil
}

func (x *InterconnectAttachment) GetUpdateTime() *timestamppb.Timestamp {
	if x != nil {
		return x.UpdateTime
	}
	return nil
}

func (x *InterconnectAttachment) GetLabels() map[string]string {
	if x != nil {
		return x.Labels
	}
	return nil
}

func (x *InterconnectAttachment) GetDescription() string {
	if x != nil {
		return x.Description
	}
	return ""
}

func (x *InterconnectAttachment) GetInterconnect() string {
	if x != nil {
		return x.Interconnect
	}
	return ""
}

func (x *InterconnectAttachment) GetNetwork() string {
	if x != nil {
		return x.Network
	}
	return ""
}

func (x *InterconnectAttachment) GetVlanId() int32 {
	if x != nil {
		return x.VlanId
	}
	return 0
}

func (x *InterconnectAttachment) GetMtu() int32 {
	if x != nil {
		return x.Mtu
	}
	return 0
}

func (x *InterconnectAttachment) GetState() ResourceState {
	if x != nil {
		return x.State
	}
	return ResourceState_STATE_UNKNOWN
}

// Message describing Router object
type Router struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The canonical resource name of the router.
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
	// Output only. The time when the router was created.
	CreateTime *timestamppb.Timestamp `protobuf:"bytes,2,opt,name=create_time,json=createTime,proto3" json:"create_time,omitempty"`
	// Output only. The time when the router was last updated.
	UpdateTime *timestamppb.Timestamp `protobuf:"bytes,3,opt,name=update_time,json=updateTime,proto3" json:"update_time,omitempty"`
	// Labels associated with this resource.
	Labels map[string]string `protobuf:"bytes,4,rep,name=labels,proto3" json:"labels,omitempty" protobuf_key:"bytes,1,opt,name=key,proto3" protobuf_val:"bytes,2,opt,name=value,proto3"`
	// Optional. A free-text description of the resource. Max length 1024
	// characters.
	Description string `protobuf:"bytes,5,opt,name=description,proto3" json:"description,omitempty"`
	// Required. The canonical name of the network to which this router belongs.
	// The name is in the form of
	// `projects/{project}/locations/{location}/zones/{zone}/networks/{network}`.
	Network string `protobuf:"bytes,6,opt,name=network,proto3" json:"network,omitempty"`
	// Router interfaces.
	Interface []*Router_Interface `protobuf:"bytes,7,rep,name=interface,proto3" json:"interface,omitempty"`
	// BGP peers.
	BgpPeer []*Router_BgpPeer `protobuf:"bytes,8,rep,name=bgp_peer,json=bgpPeer,proto3" json:"bgp_peer,omitempty"`
	// BGP information specific to this router.
	Bgp *Router_Bgp `protobuf:"bytes,9,opt,name=bgp,proto3" json:"bgp,omitempty"`
	// Output only. Current stage of the resource to the device by config push.
	State ResourceState `protobuf:"varint,10,opt,name=state,proto3,enum=google.cloud.edgenetwork.v1.ResourceState" json:"state,omitempty"`
	// Optional. A list of CIDRs in IP/Length format to advertise northbound as
	// static routes from this router.
	RouteAdvertisements []string `protobuf:"bytes,11,rep,name=route_advertisements,json=routeAdvertisements,proto3" json:"route_advertisements,omitempty"`
}

func (x *Router) Reset() {
	*x = Router{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_edgenetwork_v1_resources_proto_msgTypes[5]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *Router) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*Router) ProtoMessage() {}

func (x *Router) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_edgenetwork_v1_resources_proto_msgTypes[5]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use Router.ProtoReflect.Descriptor instead.
func (*Router) Descriptor() ([]byte, []int) {
	return file_google_cloud_edgenetwork_v1_resources_proto_rawDescGZIP(), []int{5}
}

func (x *Router) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

func (x *Router) GetCreateTime() *timestamppb.Timestamp {
	if x != nil {
		return x.CreateTime
	}
	return nil
}

func (x *Router) GetUpdateTime() *timestamppb.Timestamp {
	if x != nil {
		return x.UpdateTime
	}
	return nil
}

func (x *Router) GetLabels() map[string]string {
	if x != nil {
		return x.Labels
	}
	return nil
}

func (x *Router) GetDescription() string {
	if x != nil {
		return x.Description
	}
	return ""
}

func (x *Router) GetNetwork() string {
	if x != nil {
		return x.Network
	}
	return ""
}

func (x *Router) GetInterface() []*Router_Interface {
	if x != nil {
		return x.Interface
	}
	return nil
}

func (x *Router) GetBgpPeer() []*Router_BgpPeer {
	if x != nil {
		return x.BgpPeer
	}
	return nil
}

func (x *Router) GetBgp() *Router_Bgp {
	if x != nil {
		return x.Bgp
	}
	return nil
}

func (x *Router) GetState() ResourceState {
	if x != nil {
		return x.State
	}
	return ResourceState_STATE_UNKNOWN
}

func (x *Router) GetRouteAdvertisements() []string {
	if x != nil {
		return x.RouteAdvertisements
	}
	return nil
}

// LinkLayerAddress contains an IP address and corresponding link-layer address.
type LinkLayerAddress struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The MAC address of this neighbor.
	MacAddress string `protobuf:"bytes,1,opt,name=mac_address,json=macAddress,proto3" json:"mac_address,omitempty"`
	// The IP address of this neighbor.
	IpAddress string `protobuf:"bytes,2,opt,name=ip_address,json=ipAddress,proto3" json:"ip_address,omitempty"`
}

func (x *LinkLayerAddress) Reset() {
	*x = LinkLayerAddress{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_edgenetwork_v1_resources_proto_msgTypes[6]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *LinkLayerAddress) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*LinkLayerAddress) ProtoMessage() {}

func (x *LinkLayerAddress) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_edgenetwork_v1_resources_proto_msgTypes[6]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use LinkLayerAddress.ProtoReflect.Descriptor instead.
func (*LinkLayerAddress) Descriptor() ([]byte, []int) {
	return file_google_cloud_edgenetwork_v1_resources_proto_rawDescGZIP(), []int{6}
}

func (x *LinkLayerAddress) GetMacAddress() string {
	if x != nil {
		return x.MacAddress
	}
	return ""
}

func (x *LinkLayerAddress) GetIpAddress() string {
	if x != nil {
		return x.IpAddress
	}
	return ""
}

// SubnetStatus contains detailed and current technical information about this
// subnet resource.
type SubnetStatus struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The name of CCFE subnet resource.
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
	// BVI MAC address.
	MacAddress string `protobuf:"bytes,2,opt,name=mac_address,json=macAddress,proto3" json:"mac_address,omitempty"`
	// A list of LinkLayerAddress, describing the ip address and corresponding
	// link-layer address of the neighbors for this subnet.
	LinkLayerAddresses []*LinkLayerAddress `protobuf:"bytes,3,rep,name=link_layer_addresses,json=linkLayerAddresses,proto3" json:"link_layer_addresses,omitempty"`
}

func (x *SubnetStatus) Reset() {
	*x = SubnetStatus{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_edgenetwork_v1_resources_proto_msgTypes[7]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *SubnetStatus) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*SubnetStatus) ProtoMessage() {}

func (x *SubnetStatus) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_edgenetwork_v1_resources_proto_msgTypes[7]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use SubnetStatus.ProtoReflect.Descriptor instead.
func (*SubnetStatus) Descriptor() ([]byte, []int) {
	return file_google_cloud_edgenetwork_v1_resources_proto_rawDescGZIP(), []int{7}
}

func (x *SubnetStatus) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

func (x *SubnetStatus) GetMacAddress() string {
	if x != nil {
		return x.MacAddress
	}
	return ""
}

func (x *SubnetStatus) GetLinkLayerAddresses() []*LinkLayerAddress {
	if x != nil {
		return x.LinkLayerAddresses
	}
	return nil
}

// Diagnostics information about interconnect, contains detailed and current
// technical information about Google's side of the connection.
type InterconnectDiagnostics struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The MAC address of the Interconnect's bundle interface.
	MacAddress string `protobuf:"bytes,1,opt,name=mac_address,json=macAddress,proto3" json:"mac_address,omitempty"`
	// A list of LinkLayerAddress, describing the ip address and corresponding
	// link-layer address of the neighbors for this interconnect.
	LinkLayerAddresses []*LinkLayerAddress `protobuf:"bytes,2,rep,name=link_layer_addresses,json=linkLayerAddresses,proto3" json:"link_layer_addresses,omitempty"`
	// A list of LinkStatus objects, used to describe the status for each link on
	// the Interconnect.
	Links []*InterconnectDiagnostics_LinkStatus `protobuf:"bytes,3,rep,name=links,proto3" json:"links,omitempty"`
}

func (x *InterconnectDiagnostics) Reset() {
	*x = InterconnectDiagnostics{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_edgenetwork_v1_resources_proto_msgTypes[8]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *InterconnectDiagnostics) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*InterconnectDiagnostics) ProtoMessage() {}

func (x *InterconnectDiagnostics) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_edgenetwork_v1_resources_proto_msgTypes[8]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use InterconnectDiagnostics.ProtoReflect.Descriptor instead.
func (*InterconnectDiagnostics) Descriptor() ([]byte, []int) {
	return file_google_cloud_edgenetwork_v1_resources_proto_rawDescGZIP(), []int{8}
}

func (x *InterconnectDiagnostics) GetMacAddress() string {
	if x != nil {
		return x.MacAddress
	}
	return ""
}

func (x *InterconnectDiagnostics) GetLinkLayerAddresses() []*LinkLayerAddress {
	if x != nil {
		return x.LinkLayerAddresses
	}
	return nil
}

func (x *InterconnectDiagnostics) GetLinks() []*InterconnectDiagnostics_LinkStatus {
	if x != nil {
		return x.Links
	}
	return nil
}

// Describing the current status of a router.
type RouterStatus struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The canonical name of the network to which this router belongs.
	Network string `protobuf:"bytes,1,opt,name=network,proto3" json:"network,omitempty"`
	// A list of BgpPeerStatus objects, describing all BGP peers related to this
	// router.
	BgpPeerStatus []*RouterStatus_BgpPeerStatus `protobuf:"bytes,2,rep,name=bgp_peer_status,json=bgpPeerStatus,proto3" json:"bgp_peer_status,omitempty"`
}

func (x *RouterStatus) Reset() {
	*x = RouterStatus{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_edgenetwork_v1_resources_proto_msgTypes[9]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *RouterStatus) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*RouterStatus) ProtoMessage() {}

func (x *RouterStatus) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_edgenetwork_v1_resources_proto_msgTypes[9]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use RouterStatus.ProtoReflect.Descriptor instead.
func (*RouterStatus) Descriptor() ([]byte, []int) {
	return file_google_cloud_edgenetwork_v1_resources_proto_rawDescGZIP(), []int{9}
}

func (x *RouterStatus) GetNetwork() string {
	if x != nil {
		return x.Network
	}
	return ""
}

func (x *RouterStatus) GetBgpPeerStatus() []*RouterStatus_BgpPeerStatus {
	if x != nil {
		return x.BgpPeerStatus
	}
	return nil
}

// Router Interface defines the GDCE zone side layer-3 information for
// building the BGP session.
type Router_Interface struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Name of this interface entry. Unique within the Zones resource.
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
	// IP address and range of the interface.
	Ipv4Cidr string `protobuf:"bytes,3,opt,name=ipv4_cidr,json=ipv4Cidr,proto3" json:"ipv4_cidr,omitempty"`
	// IPv6 address and range of the interface.
	Ipv6Cidr string `protobuf:"bytes,6,opt,name=ipv6_cidr,json=ipv6Cidr,proto3" json:"ipv6_cidr,omitempty"`
	// The canonical name of the linked Interconnect attachment.
	LinkedInterconnectAttachment string `protobuf:"bytes,2,opt,name=linked_interconnect_attachment,json=linkedInterconnectAttachment,proto3" json:"linked_interconnect_attachment,omitempty"`
	// The canonical name of the subnetwork resource that this interface
	// belongs to.
	Subnetwork string `protobuf:"bytes,4,opt,name=subnetwork,proto3" json:"subnetwork,omitempty"`
	// Create loopback interface in the router when specified.
	// The number of IP addresses must match the number of TOR devices.
	LoopbackIpAddresses []string `protobuf:"bytes,5,rep,name=loopback_ip_addresses,json=loopbackIpAddresses,proto3" json:"loopback_ip_addresses,omitempty"`
}

func (x *Router_Interface) Reset() {
	*x = Router_Interface{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_edgenetwork_v1_resources_proto_msgTypes[15]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *Router_Interface) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*Router_Interface) ProtoMessage() {}

func (x *Router_Interface) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_edgenetwork_v1_resources_proto_msgTypes[15]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use Router_Interface.ProtoReflect.Descriptor instead.
func (*Router_Interface) Descriptor() ([]byte, []int) {
	return file_google_cloud_edgenetwork_v1_resources_proto_rawDescGZIP(), []int{5, 0}
}

func (x *Router_Interface) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

func (x *Router_Interface) GetIpv4Cidr() string {
	if x != nil {
		return x.Ipv4Cidr
	}
	return ""
}

func (x *Router_Interface) GetIpv6Cidr() string {
	if x != nil {
		return x.Ipv6Cidr
	}
	return ""
}

func (x *Router_Interface) GetLinkedInterconnectAttachment() string {
	if x != nil {
		return x.LinkedInterconnectAttachment
	}
	return ""
}

func (x *Router_Interface) GetSubnetwork() string {
	if x != nil {
		return x.Subnetwork
	}
	return ""
}

func (x *Router_Interface) GetLoopbackIpAddresses() []string {
	if x != nil {
		return x.LoopbackIpAddresses
	}
	return nil
}

// BGPPeer defines the peer side layer-3 information for building the BGP
// session.
type Router_BgpPeer struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Name of this BGP peer. Unique within the Zones resource.
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
	// Name of the RouterInterface the BGP peer is associated with.
	Interface string `protobuf:"bytes,2,opt,name=interface,proto3" json:"interface,omitempty"`
	// IP range of the interface within Google.
	InterfaceIpv4Cidr string `protobuf:"bytes,3,opt,name=interface_ipv4_cidr,json=interfaceIpv4Cidr,proto3" json:"interface_ipv4_cidr,omitempty"`
	// IPv6 range of the interface within Google.
	InterfaceIpv6Cidr string `protobuf:"bytes,7,opt,name=interface_ipv6_cidr,json=interfaceIpv6Cidr,proto3" json:"interface_ipv6_cidr,omitempty"`
	// IP range of the BGP interface outside Google.
	PeerIpv4Cidr string `protobuf:"bytes,4,opt,name=peer_ipv4_cidr,json=peerIpv4Cidr,proto3" json:"peer_ipv4_cidr,omitempty"`
	// IPv6 range of the BGP interface outside Google.
	PeerIpv6Cidr string `protobuf:"bytes,6,opt,name=peer_ipv6_cidr,json=peerIpv6Cidr,proto3" json:"peer_ipv6_cidr,omitempty"`
	// Peer BGP Autonomous System Number (ASN). Each BGP interface may use
	// a different value.
	PeerAsn uint32 `protobuf:"varint,5,opt,name=peer_asn,json=peerAsn,proto3" json:"peer_asn,omitempty"`
	// Output only. Local BGP Autonomous System Number (ASN).
	// This field is ST_NOT_REQUIRED because it stores private ASNs, which are
	// meaningless outside the zone in which they are being used.
	LocalAsn uint32 `protobuf:"varint,8,opt,name=local_asn,json=localAsn,proto3" json:"local_asn,omitempty"`
}

func (x *Router_BgpPeer) Reset() {
	*x = Router_BgpPeer{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_edgenetwork_v1_resources_proto_msgTypes[16]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *Router_BgpPeer) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*Router_BgpPeer) ProtoMessage() {}

func (x *Router_BgpPeer) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_edgenetwork_v1_resources_proto_msgTypes[16]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use Router_BgpPeer.ProtoReflect.Descriptor instead.
func (*Router_BgpPeer) Descriptor() ([]byte, []int) {
	return file_google_cloud_edgenetwork_v1_resources_proto_rawDescGZIP(), []int{5, 1}
}

func (x *Router_BgpPeer) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

func (x *Router_BgpPeer) GetInterface() string {
	if x != nil {
		return x.Interface
	}
	return ""
}

func (x *Router_BgpPeer) GetInterfaceIpv4Cidr() string {
	if x != nil {
		return x.InterfaceIpv4Cidr
	}
	return ""
}

func (x *Router_BgpPeer) GetInterfaceIpv6Cidr() string {
	if x != nil {
		return x.InterfaceIpv6Cidr
	}
	return ""
}

func (x *Router_BgpPeer) GetPeerIpv4Cidr() string {
	if x != nil {
		return x.PeerIpv4Cidr
	}
	return ""
}

func (x *Router_BgpPeer) GetPeerIpv6Cidr() string {
	if x != nil {
		return x.PeerIpv6Cidr
	}
	return ""
}

func (x *Router_BgpPeer) GetPeerAsn() uint32 {
	if x != nil {
		return x.PeerAsn
	}
	return 0
}

func (x *Router_BgpPeer) GetLocalAsn() uint32 {
	if x != nil {
		return x.LocalAsn
	}
	return 0
}

// BGP information specific to this router.
type Router_Bgp struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Locally assigned BGP ASN.
	Asn uint32 `protobuf:"varint,1,opt,name=asn,proto3" json:"asn,omitempty"`
	// The interval in seconds between BGP keepalive messages that are
	// sent to the peer. Default is 20 with value between 20 and 60.
	KeepaliveIntervalInSeconds uint32 `protobuf:"varint,2,opt,name=keepalive_interval_in_seconds,json=keepaliveIntervalInSeconds,proto3" json:"keepalive_interval_in_seconds,omitempty"`
}

func (x *Router_Bgp) Reset() {
	*x = Router_Bgp{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_edgenetwork_v1_resources_proto_msgTypes[17]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *Router_Bgp) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*Router_Bgp) ProtoMessage() {}

func (x *Router_Bgp) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_edgenetwork_v1_resources_proto_msgTypes[17]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use Router_Bgp.ProtoReflect.Descriptor instead.
func (*Router_Bgp) Descriptor() ([]byte, []int) {
	return file_google_cloud_edgenetwork_v1_resources_proto_rawDescGZIP(), []int{5, 2}
}

func (x *Router_Bgp) GetAsn() uint32 {
	if x != nil {
		return x.Asn
	}
	return 0
}

func (x *Router_Bgp) GetKeepaliveIntervalInSeconds() uint32 {
	if x != nil {
		return x.KeepaliveIntervalInSeconds
	}
	return 0
}

// Describing the status for each link on the Interconnect.
type InterconnectDiagnostics_LinkStatus struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The unique ID for this link assigned during turn up by Google.
	CircuitId string `protobuf:"bytes,1,opt,name=circuit_id,json=circuitId,proto3" json:"circuit_id,omitempty"`
	// Describing the state of a LACP link.
	LacpStatus *InterconnectDiagnostics_LinkLACPStatus `protobuf:"bytes,2,opt,name=lacp_status,json=lacpStatus,proto3" json:"lacp_status,omitempty"`
	// A list of LinkLLDPStatus objects, used to describe LLDP status of each
	// peer for each link on the Interconnect.
	LldpStatuses []*InterconnectDiagnostics_LinkLLDPStatus `protobuf:"bytes,3,rep,name=lldp_statuses,json=lldpStatuses,proto3" json:"lldp_statuses,omitempty"`
	// Packet counts specific statistics for this link.
	PacketCounts *InterconnectDiagnostics_PacketCounts `protobuf:"bytes,4,opt,name=packet_counts,json=packetCounts,proto3" json:"packet_counts,omitempty"`
}

func (x *InterconnectDiagnostics_LinkStatus) Reset() {
	*x = InterconnectDiagnostics_LinkStatus{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_edgenetwork_v1_resources_proto_msgTypes[19]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *InterconnectDiagnostics_LinkStatus) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*InterconnectDiagnostics_LinkStatus) ProtoMessage() {}

func (x *InterconnectDiagnostics_LinkStatus) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_edgenetwork_v1_resources_proto_msgTypes[19]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use InterconnectDiagnostics_LinkStatus.ProtoReflect.Descriptor instead.
func (*InterconnectDiagnostics_LinkStatus) Descriptor() ([]byte, []int) {
	return file_google_cloud_edgenetwork_v1_resources_proto_rawDescGZIP(), []int{8, 0}
}

func (x *InterconnectDiagnostics_LinkStatus) GetCircuitId() string {
	if x != nil {
		return x.CircuitId
	}
	return ""
}

func (x *InterconnectDiagnostics_LinkStatus) GetLacpStatus() *InterconnectDiagnostics_LinkLACPStatus {
	if x != nil {
		return x.LacpStatus
	}
	return nil
}

func (x *InterconnectDiagnostics_LinkStatus) GetLldpStatuses() []*InterconnectDiagnostics_LinkLLDPStatus {
	if x != nil {
		return x.LldpStatuses
	}
	return nil
}

func (x *InterconnectDiagnostics_LinkStatus) GetPacketCounts() *InterconnectDiagnostics_PacketCounts {
	if x != nil {
		return x.PacketCounts
	}
	return nil
}

// Containing a collection of interface-related statistics objects.
type InterconnectDiagnostics_PacketCounts struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The number of packets that are delivered.
	InboundUnicast int64 `protobuf:"varint,1,opt,name=inbound_unicast,json=inboundUnicast,proto3" json:"inbound_unicast,omitempty"`
	// The number of inbound packets that contained errors.
	InboundErrors int64 `protobuf:"varint,2,opt,name=inbound_errors,json=inboundErrors,proto3" json:"inbound_errors,omitempty"`
	// The number of inbound packets that were chosen to be discarded even
	// though no errors had been detected to prevent their being deliverable.
	InboundDiscards int64 `protobuf:"varint,3,opt,name=inbound_discards,json=inboundDiscards,proto3" json:"inbound_discards,omitempty"`
	// The total number of packets that are requested be transmitted.
	OutboundUnicast int64 `protobuf:"varint,4,opt,name=outbound_unicast,json=outboundUnicast,proto3" json:"outbound_unicast,omitempty"`
	// The number of outbound packets that could not be transmitted because of
	// errors.
	OutboundErrors int64 `protobuf:"varint,5,opt,name=outbound_errors,json=outboundErrors,proto3" json:"outbound_errors,omitempty"`
	// The number of outbound packets that were chosen to be discarded even
	// though no errors had been detected to prevent their being transmitted.
	OutboundDiscards int64 `protobuf:"varint,6,opt,name=outbound_discards,json=outboundDiscards,proto3" json:"outbound_discards,omitempty"`
}

func (x *InterconnectDiagnostics_PacketCounts) Reset() {
	*x = InterconnectDiagnostics_PacketCounts{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_edgenetwork_v1_resources_proto_msgTypes[20]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *InterconnectDiagnostics_PacketCounts) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*InterconnectDiagnostics_PacketCounts) ProtoMessage() {}

func (x *InterconnectDiagnostics_PacketCounts) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_edgenetwork_v1_resources_proto_msgTypes[20]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use InterconnectDiagnostics_PacketCounts.ProtoReflect.Descriptor instead.
func (*InterconnectDiagnostics_PacketCounts) Descriptor() ([]byte, []int) {
	return file_google_cloud_edgenetwork_v1_resources_proto_rawDescGZIP(), []int{8, 1}
}

func (x *InterconnectDiagnostics_PacketCounts) GetInboundUnicast() int64 {
	if x != nil {
		return x.InboundUnicast
	}
	return 0
}

func (x *InterconnectDiagnostics_PacketCounts) GetInboundErrors() int64 {
	if x != nil {
		return x.InboundErrors
	}
	return 0
}

func (x *InterconnectDiagnostics_PacketCounts) GetInboundDiscards() int64 {
	if x != nil {
		return x.InboundDiscards
	}
	return 0
}

func (x *InterconnectDiagnostics_PacketCounts) GetOutboundUnicast() int64 {
	if x != nil {
		return x.OutboundUnicast
	}
	return 0
}

func (x *InterconnectDiagnostics_PacketCounts) GetOutboundErrors() int64 {
	if x != nil {
		return x.OutboundErrors
	}
	return 0
}

func (x *InterconnectDiagnostics_PacketCounts) GetOutboundDiscards() int64 {
	if x != nil {
		return x.OutboundDiscards
	}
	return 0
}

// Describing the status of a LACP link.
type InterconnectDiagnostics_LinkLACPStatus struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The state of a LACP link.
	State InterconnectDiagnostics_LinkLACPStatus_State `protobuf:"varint,1,opt,name=state,proto3,enum=google.cloud.edgenetwork.v1.InterconnectDiagnostics_LinkLACPStatus_State" json:"state,omitempty"`
	// System ID of the port on Google's side of the LACP exchange.
	GoogleSystemId string `protobuf:"bytes,2,opt,name=google_system_id,json=googleSystemId,proto3" json:"google_system_id,omitempty"`
	// System ID of the port on the neighbor's side of the LACP exchange.
	NeighborSystemId string `protobuf:"bytes,3,opt,name=neighbor_system_id,json=neighborSystemId,proto3" json:"neighbor_system_id,omitempty"`
	// A true value indicates that the participant will allow the link to be
	// used as part of the aggregate.
	// A false value indicates the link should be used as an individual link.
	Aggregatable bool `protobuf:"varint,4,opt,name=aggregatable,proto3" json:"aggregatable,omitempty"`
	// If true, the participant is collecting incoming frames on the link,
	// otherwise false
	Collecting bool `protobuf:"varint,5,opt,name=collecting,proto3" json:"collecting,omitempty"`
	// When true, the participant is distributing outgoing frames; when false,
	// distribution is disabled
	Distributing bool `protobuf:"varint,6,opt,name=distributing,proto3" json:"distributing,omitempty"`
}

func (x *InterconnectDiagnostics_LinkLACPStatus) Reset() {
	*x = InterconnectDiagnostics_LinkLACPStatus{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_edgenetwork_v1_resources_proto_msgTypes[21]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *InterconnectDiagnostics_LinkLACPStatus) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*InterconnectDiagnostics_LinkLACPStatus) ProtoMessage() {}

func (x *InterconnectDiagnostics_LinkLACPStatus) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_edgenetwork_v1_resources_proto_msgTypes[21]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use InterconnectDiagnostics_LinkLACPStatus.ProtoReflect.Descriptor instead.
func (*InterconnectDiagnostics_LinkLACPStatus) Descriptor() ([]byte, []int) {
	return file_google_cloud_edgenetwork_v1_resources_proto_rawDescGZIP(), []int{8, 2}
}

func (x *InterconnectDiagnostics_LinkLACPStatus) GetState() InterconnectDiagnostics_LinkLACPStatus_State {
	if x != nil {
		return x.State
	}
	return InterconnectDiagnostics_LinkLACPStatus_UNKNOWN
}

func (x *InterconnectDiagnostics_LinkLACPStatus) GetGoogleSystemId() string {
	if x != nil {
		return x.GoogleSystemId
	}
	return ""
}

func (x *InterconnectDiagnostics_LinkLACPStatus) GetNeighborSystemId() string {
	if x != nil {
		return x.NeighborSystemId
	}
	return ""
}

func (x *InterconnectDiagnostics_LinkLACPStatus) GetAggregatable() bool {
	if x != nil {
		return x.Aggregatable
	}
	return false
}

func (x *InterconnectDiagnostics_LinkLACPStatus) GetCollecting() bool {
	if x != nil {
		return x.Collecting
	}
	return false
}

func (x *InterconnectDiagnostics_LinkLACPStatus) GetDistributing() bool {
	if x != nil {
		return x.Distributing
	}
	return false
}

// Describing a LLDP link.
type InterconnectDiagnostics_LinkLLDPStatus struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The peer system's administratively assigned name.
	PeerSystemName string `protobuf:"bytes,1,opt,name=peer_system_name,json=peerSystemName,proto3" json:"peer_system_name,omitempty"`
	// The textual description of the network entity of LLDP peer.
	PeerSystemDescription string `protobuf:"bytes,2,opt,name=peer_system_description,json=peerSystemDescription,proto3" json:"peer_system_description,omitempty"`
	// The peer chassis component of the endpoint identifier associated with the
	// transmitting LLDP agent.
	PeerChassisId string `protobuf:"bytes,3,opt,name=peer_chassis_id,json=peerChassisId,proto3" json:"peer_chassis_id,omitempty"`
	// The format and source of the peer chassis identifier string.
	PeerChassisIdType string `protobuf:"bytes,4,opt,name=peer_chassis_id_type,json=peerChassisIdType,proto3" json:"peer_chassis_id_type,omitempty"`
	// The port component of the endpoint identifier associated with the
	// transmitting LLDP agent. If the specified port is an IEEE 802.3 Repeater
	// port, then this TLV is optional.
	PeerPortId string `protobuf:"bytes,5,opt,name=peer_port_id,json=peerPortId,proto3" json:"peer_port_id,omitempty"`
	// The format and source of the peer port identifier string.
	PeerPortIdType string `protobuf:"bytes,6,opt,name=peer_port_id_type,json=peerPortIdType,proto3" json:"peer_port_id_type,omitempty"`
}

func (x *InterconnectDiagnostics_LinkLLDPStatus) Reset() {
	*x = InterconnectDiagnostics_LinkLLDPStatus{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_edgenetwork_v1_resources_proto_msgTypes[22]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *InterconnectDiagnostics_LinkLLDPStatus) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*InterconnectDiagnostics_LinkLLDPStatus) ProtoMessage() {}

func (x *InterconnectDiagnostics_LinkLLDPStatus) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_edgenetwork_v1_resources_proto_msgTypes[22]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use InterconnectDiagnostics_LinkLLDPStatus.ProtoReflect.Descriptor instead.
func (*InterconnectDiagnostics_LinkLLDPStatus) Descriptor() ([]byte, []int) {
	return file_google_cloud_edgenetwork_v1_resources_proto_rawDescGZIP(), []int{8, 3}
}

func (x *InterconnectDiagnostics_LinkLLDPStatus) GetPeerSystemName() string {
	if x != nil {
		return x.PeerSystemName
	}
	return ""
}

func (x *InterconnectDiagnostics_LinkLLDPStatus) GetPeerSystemDescription() string {
	if x != nil {
		return x.PeerSystemDescription
	}
	return ""
}

func (x *InterconnectDiagnostics_LinkLLDPStatus) GetPeerChassisId() string {
	if x != nil {
		return x.PeerChassisId
	}
	return ""
}

func (x *InterconnectDiagnostics_LinkLLDPStatus) GetPeerChassisIdType() string {
	if x != nil {
		return x.PeerChassisIdType
	}
	return ""
}

func (x *InterconnectDiagnostics_LinkLLDPStatus) GetPeerPortId() string {
	if x != nil {
		return x.PeerPortId
	}
	return ""
}

func (x *InterconnectDiagnostics_LinkLLDPStatus) GetPeerPortIdType() string {
	if x != nil {
		return x.PeerPortIdType
	}
	return ""
}

// Status of a BGP peer.
type RouterStatus_BgpPeerStatus struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Name of this BGP peer. Unique within the Routers resource.
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
	// IP address of the local BGP interface.
	IpAddress string `protobuf:"bytes,2,opt,name=ip_address,json=ipAddress,proto3" json:"ip_address,omitempty"`
	// IP address of the remote BGP interface.
	PeerIpAddress string `protobuf:"bytes,3,opt,name=peer_ip_address,json=peerIpAddress,proto3" json:"peer_ip_address,omitempty"`
	// The current status of BGP.
	Status RouterStatus_BgpPeerStatus_BgpStatus `protobuf:"varint,4,opt,name=status,proto3,enum=google.cloud.edgenetwork.v1.RouterStatus_BgpPeerStatus_BgpStatus" json:"status,omitempty"`
	// BGP state as specified in RFC1771.
	State string `protobuf:"bytes,5,opt,name=state,proto3" json:"state,omitempty"`
	// Time this session has been up.
	// Format:
	//
	//	14 years, 51 weeks, 6 days, 23 hours, 59 minutes, 59 seconds
	Uptime string `protobuf:"bytes,6,opt,name=uptime,proto3" json:"uptime,omitempty"`
	// Time this session has been up, in seconds.
	UptimeSeconds int64 `protobuf:"varint,7,opt,name=uptime_seconds,json=uptimeSeconds,proto3" json:"uptime_seconds,omitempty"`
	// A collection of counts for prefixes.
	PrefixCounter *RouterStatus_PrefixCounter `protobuf:"bytes,8,opt,name=prefix_counter,json=prefixCounter,proto3" json:"prefix_counter,omitempty"`
}

func (x *RouterStatus_BgpPeerStatus) Reset() {
	*x = RouterStatus_BgpPeerStatus{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_edgenetwork_v1_resources_proto_msgTypes[23]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *RouterStatus_BgpPeerStatus) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*RouterStatus_BgpPeerStatus) ProtoMessage() {}

func (x *RouterStatus_BgpPeerStatus) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_edgenetwork_v1_resources_proto_msgTypes[23]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use RouterStatus_BgpPeerStatus.ProtoReflect.Descriptor instead.
func (*RouterStatus_BgpPeerStatus) Descriptor() ([]byte, []int) {
	return file_google_cloud_edgenetwork_v1_resources_proto_rawDescGZIP(), []int{9, 0}
}

func (x *RouterStatus_BgpPeerStatus) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

func (x *RouterStatus_BgpPeerStatus) GetIpAddress() string {
	if x != nil {
		return x.IpAddress
	}
	return ""
}

func (x *RouterStatus_BgpPeerStatus) GetPeerIpAddress() string {
	if x != nil {
		return x.PeerIpAddress
	}
	return ""
}

func (x *RouterStatus_BgpPeerStatus) GetStatus() RouterStatus_BgpPeerStatus_BgpStatus {
	if x != nil {
		return x.Status
	}
	return RouterStatus_BgpPeerStatus_UNKNOWN
}

func (x *RouterStatus_BgpPeerStatus) GetState() string {
	if x != nil {
		return x.State
	}
	return ""
}

func (x *RouterStatus_BgpPeerStatus) GetUptime() string {
	if x != nil {
		return x.Uptime
	}
	return ""
}

func (x *RouterStatus_BgpPeerStatus) GetUptimeSeconds() int64 {
	if x != nil {
		return x.UptimeSeconds
	}
	return 0
}

func (x *RouterStatus_BgpPeerStatus) GetPrefixCounter() *RouterStatus_PrefixCounter {
	if x != nil {
		return x.PrefixCounter
	}
	return nil
}

// PrefixCounter contains a collection of prefixes related counts.
type RouterStatus_PrefixCounter struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Number of prefixes advertised.
	Advertised int64 `protobuf:"varint,1,opt,name=advertised,proto3" json:"advertised,omitempty"`
	// Number of prefixes denied.
	Denied int64 `protobuf:"varint,2,opt,name=denied,proto3" json:"denied,omitempty"`
	// Number of prefixes received.
	Received int64 `protobuf:"varint,3,opt,name=received,proto3" json:"received,omitempty"`
	// Number of prefixes sent.
	Sent int64 `protobuf:"varint,4,opt,name=sent,proto3" json:"sent,omitempty"`
	// Number of prefixes suppressed.
	Suppressed int64 `protobuf:"varint,5,opt,name=suppressed,proto3" json:"suppressed,omitempty"`
	// Number of prefixes withdrawn.
	Withdrawn int64 `protobuf:"varint,6,opt,name=withdrawn,proto3" json:"withdrawn,omitempty"`
}

func (x *RouterStatus_PrefixCounter) Reset() {
	*x = RouterStatus_PrefixCounter{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_edgenetwork_v1_resources_proto_msgTypes[24]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *RouterStatus_PrefixCounter) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*RouterStatus_PrefixCounter) ProtoMessage() {}

func (x *RouterStatus_PrefixCounter) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_edgenetwork_v1_resources_proto_msgTypes[24]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use RouterStatus_PrefixCounter.ProtoReflect.Descriptor instead.
func (*RouterStatus_PrefixCounter) Descriptor() ([]byte, []int) {
	return file_google_cloud_edgenetwork_v1_resources_proto_rawDescGZIP(), []int{9, 1}
}

func (x *RouterStatus_PrefixCounter) GetAdvertised() int64 {
	if x != nil {
		return x.Advertised
	}
	return 0
}

func (x *RouterStatus_PrefixCounter) GetDenied() int64 {
	if x != nil {
		return x.Denied
	}
	return 0
}

func (x *RouterStatus_PrefixCounter) GetReceived() int64 {
	if x != nil {
		return x.Received
	}
	return 0
}

func (x *RouterStatus_PrefixCounter) GetSent() int64 {
	if x != nil {
		return x.Sent
	}
	return 0
}

func (x *RouterStatus_PrefixCounter) GetSuppressed() int64 {
	if x != nil {
		return x.Suppressed
	}
	return 0
}

func (x *RouterStatus_PrefixCounter) GetWithdrawn() int64 {
	if x != nil {
		return x.Withdrawn
	}
	return 0
}

var File_google_cloud_edgenetwork_v1_resources_proto protoreflect.FileDescriptor

var file_google_cloud_edgenetwork_v1_resources_proto_rawDesc = []byte{
	0x0a, 0x2b, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2f, 0x65,
	0x64, 0x67, 0x65, 0x6e, 0x65, 0x74, 0x77, 0x6f, 0x72, 0x6b, 0x2f, 0x76, 0x31, 0x2f, 0x72, 0x65,
	0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x73, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x12, 0x1b, 0x67,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x65, 0x64, 0x67, 0x65,
	0x6e, 0x65, 0x74, 0x77, 0x6f, 0x72, 0x6b, 0x2e, 0x76, 0x31, 0x1a, 0x1f, 0x67, 0x6f, 0x6f, 0x67,
	0x6c, 0x65, 0x2f, 0x61, 0x70, 0x69, 0x2f, 0x66, 0x69, 0x65, 0x6c, 0x64, 0x5f, 0x62, 0x65, 0x68,
	0x61, 0x76, 0x69, 0x6f, 0x72, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x19, 0x67, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x2f, 0x61, 0x70, 0x69, 0x2f, 0x72, 0x65, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65,
	0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x1f, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x70,
	0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2f, 0x74, 0x69, 0x6d, 0x65, 0x73, 0x74, 0x61, 0x6d,
	0x70, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x22, 0xaa, 0x03, 0x0a, 0x04, 0x5a, 0x6f, 0x6e, 0x65,
	0x12, 0x17, 0x0a, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03,
	0xe0, 0x41, 0x02, 0x52, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x12, 0x40, 0x0a, 0x0b, 0x63, 0x72, 0x65,
	0x61, 0x74, 0x65, 0x5f, 0x74, 0x69, 0x6d, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1a,
	0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66,
	0x2e, 0x54, 0x69, 0x6d, 0x65, 0x73, 0x74, 0x61, 0x6d, 0x70, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x52,
	0x0a, 0x63, 0x72, 0x65, 0x61, 0x74, 0x65, 0x54, 0x69, 0x6d, 0x65, 0x12, 0x40, 0x0a, 0x0b, 0x75,
	0x70, 0x64, 0x61, 0x74, 0x65, 0x5f, 0x74, 0x69, 0x6d, 0x65, 0x18, 0x03, 0x20, 0x01, 0x28, 0x0b,
	0x32, 0x1a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62,
	0x75, 0x66, 0x2e, 0x54, 0x69, 0x6d, 0x65, 0x73, 0x74, 0x61, 0x6d, 0x70, 0x42, 0x03, 0xe0, 0x41,
	0x03, 0x52, 0x0a, 0x75, 0x70, 0x64, 0x61, 0x74, 0x65, 0x54, 0x69, 0x6d, 0x65, 0x12, 0x49, 0x0a,
	0x06, 0x6c, 0x61, 0x62, 0x65, 0x6c, 0x73, 0x18, 0x04, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x2d, 0x2e,
	0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x65, 0x64, 0x67,
	0x65, 0x6e, 0x65, 0x74, 0x77, 0x6f, 0x72, 0x6b, 0x2e, 0x76, 0x31, 0x2e, 0x5a, 0x6f, 0x6e, 0x65,
	0x2e, 0x4c, 0x61, 0x62, 0x65, 0x6c, 0x73, 0x45, 0x6e, 0x74, 0x72, 0x79, 0x42, 0x02, 0x18, 0x01,
	0x52, 0x06, 0x6c, 0x61, 0x62, 0x65, 0x6c, 0x73, 0x12, 0x23, 0x0a, 0x0b, 0x6c, 0x61, 0x79, 0x6f,
	0x75, 0x74, 0x5f, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x05, 0x20, 0x01, 0x28, 0x09, 0x42, 0x02, 0x18,
	0x01, 0x52, 0x0a, 0x6c, 0x61, 0x79, 0x6f, 0x75, 0x74, 0x4e, 0x61, 0x6d, 0x65, 0x1a, 0x39, 0x0a,
	0x0b, 0x4c, 0x61, 0x62, 0x65, 0x6c, 0x73, 0x45, 0x6e, 0x74, 0x72, 0x79, 0x12, 0x10, 0x0a, 0x03,
	0x6b, 0x65, 0x79, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x03, 0x6b, 0x65, 0x79, 0x12, 0x14,
	0x0a, 0x05, 0x76, 0x61, 0x6c, 0x75, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x52, 0x05, 0x76,
	0x61, 0x6c, 0x75, 0x65, 0x3a, 0x02, 0x38, 0x01, 0x3a, 0x5a, 0xea, 0x41, 0x57, 0x0a, 0x1f, 0x65,
	0x64, 0x67, 0x65, 0x6e, 0x65, 0x74, 0x77, 0x6f, 0x72, 0x6b, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x5a, 0x6f, 0x6e, 0x65, 0x12, 0x34,
	0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x73, 0x2f, 0x7b, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63,
	0x74, 0x7d, 0x2f, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x7b, 0x6c, 0x6f,
	0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x7d, 0x2f, 0x7a, 0x6f, 0x6e, 0x65, 0x73, 0x2f, 0x7b, 0x7a,
	0x6f, 0x6e, 0x65, 0x7d, 0x22, 0xd6, 0x03, 0x0a, 0x07, 0x4e, 0x65, 0x74, 0x77, 0x6f, 0x72, 0x6b,
	0x12, 0x17, 0x0a, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03,
	0xe0, 0x41, 0x02, 0x52, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x12, 0x40, 0x0a, 0x0b, 0x63, 0x72, 0x65,
	0x61, 0x74, 0x65, 0x5f, 0x74, 0x69, 0x6d, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1a,
	0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66,
	0x2e, 0x54, 0x69, 0x6d, 0x65, 0x73, 0x74, 0x61, 0x6d, 0x70, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x52,
	0x0a, 0x63, 0x72, 0x65, 0x61, 0x74, 0x65, 0x54, 0x69, 0x6d, 0x65, 0x12, 0x40, 0x0a, 0x0b, 0x75,
	0x70, 0x64, 0x61, 0x74, 0x65, 0x5f, 0x74, 0x69, 0x6d, 0x65, 0x18, 0x03, 0x20, 0x01, 0x28, 0x0b,
	0x32, 0x1a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62,
	0x75, 0x66, 0x2e, 0x54, 0x69, 0x6d, 0x65, 0x73, 0x74, 0x61, 0x6d, 0x70, 0x42, 0x03, 0xe0, 0x41,
	0x03, 0x52, 0x0a, 0x75, 0x70, 0x64, 0x61, 0x74, 0x65, 0x54, 0x69, 0x6d, 0x65, 0x12, 0x48, 0x0a,
	0x06, 0x6c, 0x61, 0x62, 0x65, 0x6c, 0x73, 0x18, 0x04, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x30, 0x2e,
	0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x65, 0x64, 0x67,
	0x65, 0x6e, 0x65, 0x74, 0x77, 0x6f, 0x72, 0x6b, 0x2e, 0x76, 0x31, 0x2e, 0x4e, 0x65, 0x74, 0x77,
	0x6f, 0x72, 0x6b, 0x2e, 0x4c, 0x61, 0x62, 0x65, 0x6c, 0x73, 0x45, 0x6e, 0x74, 0x72, 0x79, 0x52,
	0x06, 0x6c, 0x61, 0x62, 0x65, 0x6c, 0x73, 0x12, 0x25, 0x0a, 0x0b, 0x64, 0x65, 0x73, 0x63, 0x72,
	0x69, 0x70, 0x74, 0x69, 0x6f, 0x6e, 0x18, 0x05, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41,
	0x01, 0x52, 0x0b, 0x64, 0x65, 0x73, 0x63, 0x72, 0x69, 0x70, 0x74, 0x69, 0x6f, 0x6e, 0x12, 0x10,
	0x0a, 0x03, 0x6d, 0x74, 0x75, 0x18, 0x06, 0x20, 0x01, 0x28, 0x05, 0x52, 0x03, 0x6d, 0x74, 0x75,
	0x1a, 0x39, 0x0a, 0x0b, 0x4c, 0x61, 0x62, 0x65, 0x6c, 0x73, 0x45, 0x6e, 0x74, 0x72, 0x79, 0x12,
	0x10, 0x0a, 0x03, 0x6b, 0x65, 0x79, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x03, 0x6b, 0x65,
	0x79, 0x12, 0x14, 0x0a, 0x05, 0x76, 0x61, 0x6c, 0x75, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09,
	0x52, 0x05, 0x76, 0x61, 0x6c, 0x75, 0x65, 0x3a, 0x02, 0x38, 0x01, 0x3a, 0x70, 0xea, 0x41, 0x6d,
	0x0a, 0x22, 0x65, 0x64, 0x67, 0x65, 0x6e, 0x65, 0x74, 0x77, 0x6f, 0x72, 0x6b, 0x2e, 0x67, 0x6f,
	0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x4e, 0x65, 0x74,
	0x77, 0x6f, 0x72, 0x6b, 0x12, 0x47, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x73, 0x2f, 0x7b,
	0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x7d, 0x2f, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f,
	0x6e, 0x73, 0x2f, 0x7b, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x7d, 0x2f, 0x7a, 0x6f,
	0x6e, 0x65, 0x73, 0x2f, 0x7b, 0x7a, 0x6f, 0x6e, 0x65, 0x7d, 0x2f, 0x6e, 0x65, 0x74, 0x77, 0x6f,
	0x72, 0x6b, 0x73, 0x2f, 0x7b, 0x6e, 0x65, 0x74, 0x77, 0x6f, 0x72, 0x6b, 0x7d, 0x22, 0xa4, 0x05,
	0x0a, 0x06, 0x53, 0x75, 0x62, 0x6e, 0x65, 0x74, 0x12, 0x17, 0x0a, 0x04, 0x6e, 0x61, 0x6d, 0x65,
	0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x02, 0x52, 0x04, 0x6e, 0x61, 0x6d,
	0x65, 0x12, 0x40, 0x0a, 0x0b, 0x63, 0x72, 0x65, 0x61, 0x74, 0x65, 0x5f, 0x74, 0x69, 0x6d, 0x65,
	0x18, 0x02, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e,
	0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x54, 0x69, 0x6d, 0x65, 0x73, 0x74, 0x61,
	0x6d, 0x70, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x52, 0x0a, 0x63, 0x72, 0x65, 0x61, 0x74, 0x65, 0x54,
	0x69, 0x6d, 0x65, 0x12, 0x40, 0x0a, 0x0b, 0x75, 0x70, 0x64, 0x61, 0x74, 0x65, 0x5f, 0x74, 0x69,
	0x6d, 0x65, 0x18, 0x03, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x54, 0x69, 0x6d, 0x65, 0x73,
	0x74, 0x61, 0x6d, 0x70, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x52, 0x0a, 0x75, 0x70, 0x64, 0x61, 0x74,
	0x65, 0x54, 0x69, 0x6d, 0x65, 0x12, 0x47, 0x0a, 0x06, 0x6c, 0x61, 0x62, 0x65, 0x6c, 0x73, 0x18,
	0x04, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x2f, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63,
	0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x65, 0x64, 0x67, 0x65, 0x6e, 0x65, 0x74, 0x77, 0x6f, 0x72, 0x6b,
	0x2e, 0x76, 0x31, 0x2e, 0x53, 0x75, 0x62, 0x6e, 0x65, 0x74, 0x2e, 0x4c, 0x61, 0x62, 0x65, 0x6c,
	0x73, 0x45, 0x6e, 0x74, 0x72, 0x79, 0x52, 0x06, 0x6c, 0x61, 0x62, 0x65, 0x6c, 0x73, 0x12, 0x25,
	0x0a, 0x0b, 0x64, 0x65, 0x73, 0x63, 0x72, 0x69, 0x70, 0x74, 0x69, 0x6f, 0x6e, 0x18, 0x05, 0x20,
	0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x0b, 0x64, 0x65, 0x73, 0x63, 0x72, 0x69,
	0x70, 0x74, 0x69, 0x6f, 0x6e, 0x12, 0x44, 0x0a, 0x07, 0x6e, 0x65, 0x74, 0x77, 0x6f, 0x72, 0x6b,
	0x18, 0x06, 0x20, 0x01, 0x28, 0x09, 0x42, 0x2a, 0xe0, 0x41, 0x02, 0xfa, 0x41, 0x24, 0x0a, 0x22,
	0x65, 0x64, 0x67, 0x65, 0x6e, 0x65, 0x74, 0x77, 0x6f, 0x72, 0x6b, 0x2e, 0x67, 0x6f, 0x6f, 0x67,
	0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x4e, 0x65, 0x74, 0x77, 0x6f,
	0x72, 0x6b, 0x52, 0x07, 0x6e, 0x65, 0x74, 0x77, 0x6f, 0x72, 0x6b, 0x12, 0x1b, 0x0a, 0x09, 0x69,
	0x70, 0x76, 0x34, 0x5f, 0x63, 0x69, 0x64, 0x72, 0x18, 0x07, 0x20, 0x03, 0x28, 0x09, 0x52, 0x08,
	0x69, 0x70, 0x76, 0x34, 0x43, 0x69, 0x64, 0x72, 0x12, 0x1b, 0x0a, 0x09, 0x69, 0x70, 0x76, 0x36,
	0x5f, 0x63, 0x69, 0x64, 0x72, 0x18, 0x08, 0x20, 0x03, 0x28, 0x09, 0x52, 0x08, 0x69, 0x70, 0x76,
	0x36, 0x43, 0x69, 0x64, 0x72, 0x12, 0x1c, 0x0a, 0x07, 0x76, 0x6c, 0x61, 0x6e, 0x5f, 0x69, 0x64,
	0x18, 0x09, 0x20, 0x01, 0x28, 0x05, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x06, 0x76, 0x6c, 0x61,
	0x6e, 0x49, 0x64, 0x12, 0x45, 0x0a, 0x05, 0x73, 0x74, 0x61, 0x74, 0x65, 0x18, 0x0a, 0x20, 0x01,
	0x28, 0x0e, 0x32, 0x2a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75,
	0x64, 0x2e, 0x65, 0x64, 0x67, 0x65, 0x6e, 0x65, 0x74, 0x77, 0x6f, 0x72, 0x6b, 0x2e, 0x76, 0x31,
	0x2e, 0x52, 0x65, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x53, 0x74, 0x61, 0x74, 0x65, 0x42, 0x03,
	0xe0, 0x41, 0x03, 0x52, 0x05, 0x73, 0x74, 0x61, 0x74, 0x65, 0x1a, 0x39, 0x0a, 0x0b, 0x4c, 0x61,
	0x62, 0x65, 0x6c, 0x73, 0x45, 0x6e, 0x74, 0x72, 0x79, 0x12, 0x10, 0x0a, 0x03, 0x6b, 0x65, 0x79,
	0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x03, 0x6b, 0x65, 0x79, 0x12, 0x14, 0x0a, 0x05, 0x76,
	0x61, 0x6c, 0x75, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x52, 0x05, 0x76, 0x61, 0x6c, 0x75,
	0x65, 0x3a, 0x02, 0x38, 0x01, 0x3a, 0x6d, 0xea, 0x41, 0x6a, 0x0a, 0x21, 0x65, 0x64, 0x67, 0x65,
	0x6e, 0x65, 0x74, 0x77, 0x6f, 0x72, 0x6b, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70,
	0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x53, 0x75, 0x62, 0x6e, 0x65, 0x74, 0x12, 0x45, 0x70,
	0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x73, 0x2f, 0x7b, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74,
	0x7d, 0x2f, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x7b, 0x6c, 0x6f, 0x63,
	0x61, 0x74, 0x69, 0x6f, 0x6e, 0x7d, 0x2f, 0x7a, 0x6f, 0x6e, 0x65, 0x73, 0x2f, 0x7b, 0x7a, 0x6f,
	0x6e, 0x65, 0x7d, 0x2f, 0x73, 0x75, 0x62, 0x6e, 0x65, 0x74, 0x73, 0x2f, 0x7b, 0x73, 0x75, 0x62,
	0x6e, 0x65, 0x74, 0x7d, 0x22, 0x98, 0x06, 0x0a, 0x0c, 0x49, 0x6e, 0x74, 0x65, 0x72, 0x63, 0x6f,
	0x6e, 0x6e, 0x65, 0x63, 0x74, 0x12, 0x17, 0x0a, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x01, 0x20,
	0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x02, 0x52, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x12, 0x40,
	0x0a, 0x0b, 0x63, 0x72, 0x65, 0x61, 0x74, 0x65, 0x5f, 0x74, 0x69, 0x6d, 0x65, 0x18, 0x02, 0x20,
	0x01, 0x28, 0x0b, 0x32, 0x1a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f,
	0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x54, 0x69, 0x6d, 0x65, 0x73, 0x74, 0x61, 0x6d, 0x70, 0x42,
	0x03, 0xe0, 0x41, 0x03, 0x52, 0x0a, 0x63, 0x72, 0x65, 0x61, 0x74, 0x65, 0x54, 0x69, 0x6d, 0x65,
	0x12, 0x40, 0x0a, 0x0b, 0x75, 0x70, 0x64, 0x61, 0x74, 0x65, 0x5f, 0x74, 0x69, 0x6d, 0x65, 0x18,
	0x03, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70,
	0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x54, 0x69, 0x6d, 0x65, 0x73, 0x74, 0x61, 0x6d,
	0x70, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x52, 0x0a, 0x75, 0x70, 0x64, 0x61, 0x74, 0x65, 0x54, 0x69,
	0x6d, 0x65, 0x12, 0x4d, 0x0a, 0x06, 0x6c, 0x61, 0x62, 0x65, 0x6c, 0x73, 0x18, 0x04, 0x20, 0x03,
	0x28, 0x0b, 0x32, 0x35, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75,
	0x64, 0x2e, 0x65, 0x64, 0x67, 0x65, 0x6e, 0x65, 0x74, 0x77, 0x6f, 0x72, 0x6b, 0x2e, 0x76, 0x31,
	0x2e, 0x49, 0x6e, 0x74, 0x65, 0x72, 0x63, 0x6f, 0x6e, 0x6e, 0x65, 0x63, 0x74, 0x2e, 0x4c, 0x61,
	0x62, 0x65, 0x6c, 0x73, 0x45, 0x6e, 0x74, 0x72, 0x79, 0x52, 0x06, 0x6c, 0x61, 0x62, 0x65, 0x6c,
	0x73, 0x12, 0x25, 0x0a, 0x0b, 0x64, 0x65, 0x73, 0x63, 0x72, 0x69, 0x70, 0x74, 0x69, 0x6f, 0x6e,
	0x18, 0x05, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x0b, 0x64, 0x65, 0x73,
	0x63, 0x72, 0x69, 0x70, 0x74, 0x69, 0x6f, 0x6e, 0x12, 0x6c, 0x0a, 0x11, 0x69, 0x6e, 0x74, 0x65,
	0x72, 0x63, 0x6f, 0x6e, 0x6e, 0x65, 0x63, 0x74, 0x5f, 0x74, 0x79, 0x70, 0x65, 0x18, 0x06, 0x20,
	0x01, 0x28, 0x0e, 0x32, 0x3a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f,
	0x75, 0x64, 0x2e, 0x65, 0x64, 0x67, 0x65, 0x6e, 0x65, 0x74, 0x77, 0x6f, 0x72, 0x6b, 0x2e, 0x76,
	0x31, 0x2e, 0x49, 0x6e, 0x74, 0x65, 0x72, 0x63, 0x6f, 0x6e, 0x6e, 0x65, 0x63, 0x74, 0x2e, 0x49,
	0x6e, 0x74, 0x65, 0x72, 0x63, 0x6f, 0x6e, 0x6e, 0x65, 0x63, 0x74, 0x54, 0x79, 0x70, 0x65, 0x42,
	0x03, 0xe0, 0x41, 0x01, 0x52, 0x10, 0x69, 0x6e, 0x74, 0x65, 0x72, 0x63, 0x6f, 0x6e, 0x6e, 0x65,
	0x63, 0x74, 0x54, 0x79, 0x70, 0x65, 0x12, 0x17, 0x0a, 0x04, 0x75, 0x75, 0x69, 0x64, 0x18, 0x07,
	0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x52, 0x04, 0x75, 0x75, 0x69, 0x64, 0x12,
	0x40, 0x0a, 0x1a, 0x64, 0x65, 0x76, 0x69, 0x63, 0x65, 0x5f, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x5f,
	0x72, 0x65, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x5f, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x08, 0x20,
	0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x52, 0x17, 0x64, 0x65, 0x76, 0x69, 0x63, 0x65,
	0x43, 0x6c, 0x6f, 0x75, 0x64, 0x52, 0x65, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x4e, 0x61, 0x6d,
	0x65, 0x12, 0x2a, 0x0a, 0x0e, 0x70, 0x68, 0x79, 0x73, 0x69, 0x63, 0x61, 0x6c, 0x5f, 0x70, 0x6f,
	0x72, 0x74, 0x73, 0x18, 0x09, 0x20, 0x03, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x52, 0x0d,
	0x70, 0x68, 0x79, 0x73, 0x69, 0x63, 0x61, 0x6c, 0x50, 0x6f, 0x72, 0x74, 0x73, 0x1a, 0x39, 0x0a,
	0x0b, 0x4c, 0x61, 0x62, 0x65, 0x6c, 0x73, 0x45, 0x6e, 0x74, 0x72, 0x79, 0x12, 0x10, 0x0a, 0x03,
	0x6b, 0x65, 0x79, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x03, 0x6b, 0x65, 0x79, 0x12, 0x14,
	0x0a, 0x05, 0x76, 0x61, 0x6c, 0x75, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x52, 0x05, 0x76,
	0x61, 0x6c, 0x75, 0x65, 0x3a, 0x02, 0x38, 0x01, 0x22, 0x44, 0x0a, 0x10, 0x49, 0x6e, 0x74, 0x65,
	0x72, 0x63, 0x6f, 0x6e, 0x6e, 0x65, 0x63, 0x74, 0x54, 0x79, 0x70, 0x65, 0x12, 0x21, 0x0a, 0x1d,
	0x49, 0x4e, 0x54, 0x45, 0x52, 0x43, 0x4f, 0x4e, 0x4e, 0x45, 0x43, 0x54, 0x5f, 0x54, 0x59, 0x50,
	0x45, 0x5f, 0x55, 0x4e, 0x53, 0x50, 0x45, 0x43, 0x49, 0x46, 0x49, 0x45, 0x44, 0x10, 0x00, 0x12,
	0x0d, 0x0a, 0x09, 0x44, 0x45, 0x44, 0x49, 0x43, 0x41, 0x54, 0x45, 0x44, 0x10, 0x01, 0x3a, 0x7f,
	0xea, 0x41, 0x7c, 0x0a, 0x27, 0x65, 0x64, 0x67, 0x65, 0x6e, 0x65, 0x74, 0x77, 0x6f, 0x72, 0x6b,
	0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f,
	0x49, 0x6e, 0x74, 0x65, 0x72, 0x63, 0x6f, 0x6e, 0x6e, 0x65, 0x63, 0x74, 0x12, 0x51, 0x70, 0x72,
	0x6f, 0x6a, 0x65, 0x63, 0x74, 0x73, 0x2f, 0x7b, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x7d,
	0x2f, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x7b, 0x6c, 0x6f, 0x63, 0x61,
	0x74, 0x69, 0x6f, 0x6e, 0x7d, 0x2f, 0x7a, 0x6f, 0x6e, 0x65, 0x73, 0x2f, 0x7b, 0x7a, 0x6f, 0x6e,
	0x65, 0x7d, 0x2f, 0x69, 0x6e, 0x74, 0x65, 0x72, 0x63, 0x6f, 0x6e, 0x6e, 0x65, 0x63, 0x74, 0x73,
	0x2f, 0x7b, 0x69, 0x6e, 0x74, 0x65, 0x72, 0x63, 0x6f, 0x6e, 0x6e, 0x65, 0x63, 0x74, 0x7d, 0x22,
	0xa4, 0x06, 0x0a, 0x16, 0x49, 0x6e, 0x74, 0x65, 0x72, 0x63, 0x6f, 0x6e, 0x6e, 0x65, 0x63, 0x74,
	0x41, 0x74, 0x74, 0x61, 0x63, 0x68, 0x6d, 0x65, 0x6e, 0x74, 0x12, 0x17, 0x0a, 0x04, 0x6e, 0x61,
	0x6d, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x02, 0x52, 0x04, 0x6e,
	0x61, 0x6d, 0x65, 0x12, 0x40, 0x0a, 0x0b, 0x63, 0x72, 0x65, 0x61, 0x74, 0x65, 0x5f, 0x74, 0x69,
	0x6d, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x54, 0x69, 0x6d, 0x65, 0x73,
	0x74, 0x61, 0x6d, 0x70, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x52, 0x0a, 0x63, 0x72, 0x65, 0x61, 0x74,
	0x65, 0x54, 0x69, 0x6d, 0x65, 0x12, 0x40, 0x0a, 0x0b, 0x75, 0x70, 0x64, 0x61, 0x74, 0x65, 0x5f,
	0x74, 0x69, 0x6d, 0x65, 0x18, 0x03, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1a, 0x2e, 0x67, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x54, 0x69, 0x6d,
	0x65, 0x73, 0x74, 0x61, 0x6d, 0x70, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x52, 0x0a, 0x75, 0x70, 0x64,
	0x61, 0x74, 0x65, 0x54, 0x69, 0x6d, 0x65, 0x12, 0x57, 0x0a, 0x06, 0x6c, 0x61, 0x62, 0x65, 0x6c,
	0x73, 0x18, 0x04, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x3f, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65,
	0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x65, 0x64, 0x67, 0x65, 0x6e, 0x65, 0x74, 0x77, 0x6f,
	0x72, 0x6b, 0x2e, 0x76, 0x31, 0x2e, 0x49, 0x6e, 0x74, 0x65, 0x72, 0x63, 0x6f, 0x6e, 0x6e, 0x65,
	0x63, 0x74, 0x41, 0x74, 0x74, 0x61, 0x63, 0x68, 0x6d, 0x65, 0x6e, 0x74, 0x2e, 0x4c, 0x61, 0x62,
	0x65, 0x6c, 0x73, 0x45, 0x6e, 0x74, 0x72, 0x79, 0x52, 0x06, 0x6c, 0x61, 0x62, 0x65, 0x6c, 0x73,
	0x12, 0x25, 0x0a, 0x0b, 0x64, 0x65, 0x73, 0x63, 0x72, 0x69, 0x70, 0x74, 0x69, 0x6f, 0x6e, 0x18,
	0x05, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x0b, 0x64, 0x65, 0x73, 0x63,
	0x72, 0x69, 0x70, 0x74, 0x69, 0x6f, 0x6e, 0x12, 0x53, 0x0a, 0x0c, 0x69, 0x6e, 0x74, 0x65, 0x72,
	0x63, 0x6f, 0x6e, 0x6e, 0x65, 0x63, 0x74, 0x18, 0x06, 0x20, 0x01, 0x28, 0x09, 0x42, 0x2f, 0xe0,
	0x41, 0x02, 0xfa, 0x41, 0x29, 0x0a, 0x27, 0x65, 0x64, 0x67, 0x65, 0x6e, 0x65, 0x74, 0x77, 0x6f,
	0x72, 0x6b, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f,
	0x6d, 0x2f, 0x49, 0x6e, 0x74, 0x65, 0x72, 0x63, 0x6f, 0x6e, 0x6e, 0x65, 0x63, 0x74, 0x52, 0x0c,
	0x69, 0x6e, 0x74, 0x65, 0x72, 0x63, 0x6f, 0x6e, 0x6e, 0x65, 0x63, 0x74, 0x12, 0x44, 0x0a, 0x07,
	0x6e, 0x65, 0x74, 0x77, 0x6f, 0x72, 0x6b, 0x18, 0x0b, 0x20, 0x01, 0x28, 0x09, 0x42, 0x2a, 0xe0,
	0x41, 0x01, 0xfa, 0x41, 0x24, 0x0a, 0x22, 0x65, 0x64, 0x67, 0x65, 0x6e, 0x65, 0x74, 0x77, 0x6f,
	0x72, 0x6b, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f,
	0x6d, 0x2f, 0x4e, 0x65, 0x74, 0x77, 0x6f, 0x72, 0x6b, 0x52, 0x07, 0x6e, 0x65, 0x74, 0x77, 0x6f,
	0x72, 0x6b, 0x12, 0x1c, 0x0a, 0x07, 0x76, 0x6c, 0x61, 0x6e, 0x5f, 0x69, 0x64, 0x18, 0x08, 0x20,
	0x01, 0x28, 0x05, 0x42, 0x03, 0xe0, 0x41, 0x02, 0x52, 0x06, 0x76, 0x6c, 0x61, 0x6e, 0x49, 0x64,
	0x12, 0x10, 0x0a, 0x03, 0x6d, 0x74, 0x75, 0x18, 0x09, 0x20, 0x01, 0x28, 0x05, 0x52, 0x03, 0x6d,
	0x74, 0x75, 0x12, 0x45, 0x0a, 0x05, 0x73, 0x74, 0x61, 0x74, 0x65, 0x18, 0x0a, 0x20, 0x01, 0x28,
	0x0e, 0x32, 0x2a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64,
	0x2e, 0x65, 0x64, 0x67, 0x65, 0x6e, 0x65, 0x74, 0x77, 0x6f, 0x72, 0x6b, 0x2e, 0x76, 0x31, 0x2e,
	0x52, 0x65, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x53, 0x74, 0x61, 0x74, 0x65, 0x42, 0x03, 0xe0,
	0x41, 0x03, 0x52, 0x05, 0x73, 0x74, 0x61, 0x74, 0x65, 0x1a, 0x39, 0x0a, 0x0b, 0x4c, 0x61, 0x62,
	0x65, 0x6c, 0x73, 0x45, 0x6e, 0x74, 0x72, 0x79, 0x12, 0x10, 0x0a, 0x03, 0x6b, 0x65, 0x79, 0x18,
	0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x03, 0x6b, 0x65, 0x79, 0x12, 0x14, 0x0a, 0x05, 0x76, 0x61,
	0x6c, 0x75, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x52, 0x05, 0x76, 0x61, 0x6c, 0x75, 0x65,
	0x3a, 0x02, 0x38, 0x01, 0x3a, 0x9f, 0x01, 0xea, 0x41, 0x9b, 0x01, 0x0a, 0x31, 0x65, 0x64, 0x67,
	0x65, 0x6e, 0x65, 0x74, 0x77, 0x6f, 0x72, 0x6b, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61,
	0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x49, 0x6e, 0x74, 0x65, 0x72, 0x63, 0x6f, 0x6e,
	0x6e, 0x65, 0x63, 0x74, 0x41, 0x74, 0x74, 0x61, 0x63, 0x68, 0x6d, 0x65, 0x6e, 0x74, 0x12, 0x66,
	0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x73, 0x2f, 0x7b, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63,
	0x74, 0x7d, 0x2f, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x7b, 0x6c, 0x6f,
	0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x7d, 0x2f, 0x7a, 0x6f, 0x6e, 0x65, 0x73, 0x2f, 0x7b, 0x7a,
	0x6f, 0x6e, 0x65, 0x7d, 0x2f, 0x69, 0x6e, 0x74, 0x65, 0x72, 0x63, 0x6f, 0x6e, 0x6e, 0x65, 0x63,
	0x74, 0x41, 0x74, 0x74, 0x61, 0x63, 0x68, 0x6d, 0x65, 0x6e, 0x74, 0x73, 0x2f, 0x7b, 0x69, 0x6e,
	0x74, 0x65, 0x72, 0x63, 0x6f, 0x6e, 0x6e, 0x65, 0x63, 0x74, 0x5f, 0x61, 0x74, 0x74, 0x61, 0x63,
	0x68, 0x6d, 0x65, 0x6e, 0x74, 0x7d, 0x22, 0xcd, 0x0b, 0x0a, 0x06, 0x52, 0x6f, 0x75, 0x74, 0x65,
	0x72, 0x12, 0x17, 0x0a, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42,
	0x03, 0xe0, 0x41, 0x02, 0x52, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x12, 0x40, 0x0a, 0x0b, 0x63, 0x72,
	0x65, 0x61, 0x74, 0x65, 0x5f, 0x74, 0x69, 0x6d, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0b, 0x32,
	0x1a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75,
	0x66, 0x2e, 0x54, 0x69, 0x6d, 0x65, 0x73, 0x74, 0x61, 0x6d, 0x70, 0x42, 0x03, 0xe0, 0x41, 0x03,
	0x52, 0x0a, 0x63, 0x72, 0x65, 0x61, 0x74, 0x65, 0x54, 0x69, 0x6d, 0x65, 0x12, 0x40, 0x0a, 0x0b,
	0x75, 0x70, 0x64, 0x61, 0x74, 0x65, 0x5f, 0x74, 0x69, 0x6d, 0x65, 0x18, 0x03, 0x20, 0x01, 0x28,
	0x0b, 0x32, 0x1a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f,
	0x62, 0x75, 0x66, 0x2e, 0x54, 0x69, 0x6d, 0x65, 0x73, 0x74, 0x61, 0x6d, 0x70, 0x42, 0x03, 0xe0,
	0x41, 0x03, 0x52, 0x0a, 0x75, 0x70, 0x64, 0x61, 0x74, 0x65, 0x54, 0x69, 0x6d, 0x65, 0x12, 0x47,
	0x0a, 0x06, 0x6c, 0x61, 0x62, 0x65, 0x6c, 0x73, 0x18, 0x04, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x2f,
	0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x65, 0x64,
	0x67, 0x65, 0x6e, 0x65, 0x74, 0x77, 0x6f, 0x72, 0x6b, 0x2e, 0x76, 0x31, 0x2e, 0x52, 0x6f, 0x75,
	0x74, 0x65, 0x72, 0x2e, 0x4c, 0x61, 0x62, 0x65, 0x6c, 0x73, 0x45, 0x6e, 0x74, 0x72, 0x79, 0x52,
	0x06, 0x6c, 0x61, 0x62, 0x65, 0x6c, 0x73, 0x12, 0x25, 0x0a, 0x0b, 0x64, 0x65, 0x73, 0x63, 0x72,
	0x69, 0x70, 0x74, 0x69, 0x6f, 0x6e, 0x18, 0x05, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41,
	0x01, 0x52, 0x0b, 0x64, 0x65, 0x73, 0x63, 0x72, 0x69, 0x70, 0x74, 0x69, 0x6f, 0x6e, 0x12, 0x44,
	0x0a, 0x07, 0x6e, 0x65, 0x74, 0x77, 0x6f, 0x72, 0x6b, 0x18, 0x06, 0x20, 0x01, 0x28, 0x09, 0x42,
	0x2a, 0xe0, 0x41, 0x02, 0xfa, 0x41, 0x24, 0x0a, 0x22, 0x65, 0x64, 0x67, 0x65, 0x6e, 0x65, 0x74,
	0x77, 0x6f, 0x72, 0x6b, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e,
	0x63, 0x6f, 0x6d, 0x2f, 0x4e, 0x65, 0x74, 0x77, 0x6f, 0x72, 0x6b, 0x52, 0x07, 0x6e, 0x65, 0x74,
	0x77, 0x6f, 0x72, 0x6b, 0x12, 0x4b, 0x0a, 0x09, 0x69, 0x6e, 0x74, 0x65, 0x72, 0x66, 0x61, 0x63,
	0x65, 0x18, 0x07, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x2d, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65,
	0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x65, 0x64, 0x67, 0x65, 0x6e, 0x65, 0x74, 0x77, 0x6f,
	0x72, 0x6b, 0x2e, 0x76, 0x31, 0x2e, 0x52, 0x6f, 0x75, 0x74, 0x65, 0x72, 0x2e, 0x49, 0x6e, 0x74,
	0x65, 0x72, 0x66, 0x61, 0x63, 0x65, 0x52, 0x09, 0x69, 0x6e, 0x74, 0x65, 0x72, 0x66, 0x61, 0x63,
	0x65, 0x12, 0x46, 0x0a, 0x08, 0x62, 0x67, 0x70, 0x5f, 0x70, 0x65, 0x65, 0x72, 0x18, 0x08, 0x20,
	0x03, 0x28, 0x0b, 0x32, 0x2b, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f,
	0x75, 0x64, 0x2e, 0x65, 0x64, 0x67, 0x65, 0x6e, 0x65, 0x74, 0x77, 0x6f, 0x72, 0x6b, 0x2e, 0x76,
	0x31, 0x2e, 0x52, 0x6f, 0x75, 0x74, 0x65, 0x72, 0x2e, 0x42, 0x67, 0x70, 0x50, 0x65, 0x65, 0x72,
	0x52, 0x07, 0x62, 0x67, 0x70, 0x50, 0x65, 0x65, 0x72, 0x12, 0x39, 0x0a, 0x03, 0x62, 0x67, 0x70,
	0x18, 0x09, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x27, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e,
	0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x65, 0x64, 0x67, 0x65, 0x6e, 0x65, 0x74, 0x77, 0x6f, 0x72,
	0x6b, 0x2e, 0x76, 0x31, 0x2e, 0x52, 0x6f, 0x75, 0x74, 0x65, 0x72, 0x2e, 0x42, 0x67, 0x70, 0x52,
	0x03, 0x62, 0x67, 0x70, 0x12, 0x45, 0x0a, 0x05, 0x73, 0x74, 0x61, 0x74, 0x65, 0x18, 0x0a, 0x20,
	0x01, 0x28, 0x0e, 0x32, 0x2a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f,
	0x75, 0x64, 0x2e, 0x65, 0x64, 0x67, 0x65, 0x6e, 0x65, 0x74, 0x77, 0x6f, 0x72, 0x6b, 0x2e, 0x76,
	0x31, 0x2e, 0x52, 0x65, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x53, 0x74, 0x61, 0x74, 0x65, 0x42,
	0x03, 0xe0, 0x41, 0x03, 0x52, 0x05, 0x73, 0x74, 0x61, 0x74, 0x65, 0x12, 0x36, 0x0a, 0x14, 0x72,
	0x6f, 0x75, 0x74, 0x65, 0x5f, 0x61, 0x64, 0x76, 0x65, 0x72, 0x74, 0x69, 0x73, 0x65, 0x6d, 0x65,
	0x6e, 0x74, 0x73, 0x18, 0x0b, 0x20, 0x03, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x13,
	0x72, 0x6f, 0x75, 0x74, 0x65, 0x41, 0x64, 0x76, 0x65, 0x72, 0x74, 0x69, 0x73, 0x65, 0x6d, 0x65,
	0x6e, 0x74, 0x73, 0x1a, 0xf3, 0x01, 0x0a, 0x09, 0x49, 0x6e, 0x74, 0x65, 0x72, 0x66, 0x61, 0x63,
	0x65, 0x12, 0x12, 0x0a, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52,
	0x04, 0x6e, 0x61, 0x6d, 0x65, 0x12, 0x1b, 0x0a, 0x09, 0x69, 0x70, 0x76, 0x34, 0x5f, 0x63, 0x69,
	0x64, 0x72, 0x18, 0x03, 0x20, 0x01, 0x28, 0x09, 0x52, 0x08, 0x69, 0x70, 0x76, 0x34, 0x43, 0x69,
	0x64, 0x72, 0x12, 0x1b, 0x0a, 0x09, 0x69, 0x70, 0x76, 0x36, 0x5f, 0x63, 0x69, 0x64, 0x72, 0x18,
	0x06, 0x20, 0x01, 0x28, 0x09, 0x52, 0x08, 0x69, 0x70, 0x76, 0x36, 0x43, 0x69, 0x64, 0x72, 0x12,
	0x44, 0x0a, 0x1e, 0x6c, 0x69, 0x6e, 0x6b, 0x65, 0x64, 0x5f, 0x69, 0x6e, 0x74, 0x65, 0x72, 0x63,
	0x6f, 0x6e, 0x6e, 0x65, 0x63, 0x74, 0x5f, 0x61, 0x74, 0x74, 0x61, 0x63, 0x68, 0x6d, 0x65, 0x6e,
	0x74, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x52, 0x1c, 0x6c, 0x69, 0x6e, 0x6b, 0x65, 0x64, 0x49,
	0x6e, 0x74, 0x65, 0x72, 0x63, 0x6f, 0x6e, 0x6e, 0x65, 0x63, 0x74, 0x41, 0x74, 0x74, 0x61, 0x63,
	0x68, 0x6d, 0x65, 0x6e, 0x74, 0x12, 0x1e, 0x0a, 0x0a, 0x73, 0x75, 0x62, 0x6e, 0x65, 0x74, 0x77,
	0x6f, 0x72, 0x6b, 0x18, 0x04, 0x20, 0x01, 0x28, 0x09, 0x52, 0x0a, 0x73, 0x75, 0x62, 0x6e, 0x65,
	0x74, 0x77, 0x6f, 0x72, 0x6b, 0x12, 0x32, 0x0a, 0x15, 0x6c, 0x6f, 0x6f, 0x70, 0x62, 0x61, 0x63,
	0x6b, 0x5f, 0x69, 0x70, 0x5f, 0x61, 0x64, 0x64, 0x72, 0x65, 0x73, 0x73, 0x65, 0x73, 0x18, 0x05,
	0x20, 0x03, 0x28, 0x09, 0x52, 0x13, 0x6c, 0x6f, 0x6f, 0x70, 0x62, 0x61, 0x63, 0x6b, 0x49, 0x70,
	0x41, 0x64, 0x64, 0x72, 0x65, 0x73, 0x73, 0x65, 0x73, 0x1a, 0xa4, 0x02, 0x0a, 0x07, 0x42, 0x67,
	0x70, 0x50, 0x65, 0x65, 0x72, 0x12, 0x12, 0x0a, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x01, 0x20,
	0x01, 0x28, 0x09, 0x52, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x12, 0x1c, 0x0a, 0x09, 0x69, 0x6e, 0x74,
	0x65, 0x72, 0x66, 0x61, 0x63, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x52, 0x09, 0x69, 0x6e,
	0x74, 0x65, 0x72, 0x66, 0x61, 0x63, 0x65, 0x12, 0x2e, 0x0a, 0x13, 0x69, 0x6e, 0x74, 0x65, 0x72,
	0x66, 0x61, 0x63, 0x65, 0x5f, 0x69, 0x70, 0x76, 0x34, 0x5f, 0x63, 0x69, 0x64, 0x72, 0x18, 0x03,
	0x20, 0x01, 0x28, 0x09, 0x52, 0x11, 0x69, 0x6e, 0x74, 0x65, 0x72, 0x66, 0x61, 0x63, 0x65, 0x49,
	0x70, 0x76, 0x34, 0x43, 0x69, 0x64, 0x72, 0x12, 0x2e, 0x0a, 0x13, 0x69, 0x6e, 0x74, 0x65, 0x72,
	0x66, 0x61, 0x63, 0x65, 0x5f, 0x69, 0x70, 0x76, 0x36, 0x5f, 0x63, 0x69, 0x64, 0x72, 0x18, 0x07,
	0x20, 0x01, 0x28, 0x09, 0x52, 0x11, 0x69, 0x6e, 0x74, 0x65, 0x72, 0x66, 0x61, 0x63, 0x65, 0x49,
	0x70, 0x76, 0x36, 0x43, 0x69, 0x64, 0x72, 0x12, 0x24, 0x0a, 0x0e, 0x70, 0x65, 0x65, 0x72, 0x5f,
	0x69, 0x70, 0x76, 0x34, 0x5f, 0x63, 0x69, 0x64, 0x72, 0x18, 0x04, 0x20, 0x01, 0x28, 0x09, 0x52,
	0x0c, 0x70, 0x65, 0x65, 0x72, 0x49, 0x70, 0x76, 0x34, 0x43, 0x69, 0x64, 0x72, 0x12, 0x24, 0x0a,
	0x0e, 0x70, 0x65, 0x65, 0x72, 0x5f, 0x69, 0x70, 0x76, 0x36, 0x5f, 0x63, 0x69, 0x64, 0x72, 0x18,
	0x06, 0x20, 0x01, 0x28, 0x09, 0x52, 0x0c, 0x70, 0x65, 0x65, 0x72, 0x49, 0x70, 0x76, 0x36, 0x43,
	0x69, 0x64, 0x72, 0x12, 0x19, 0x0a, 0x08, 0x70, 0x65, 0x65, 0x72, 0x5f, 0x61, 0x73, 0x6e, 0x18,
	0x05, 0x20, 0x01, 0x28, 0x0d, 0x52, 0x07, 0x70, 0x65, 0x65, 0x72, 0x41, 0x73, 0x6e, 0x12, 0x20,
	0x0a, 0x09, 0x6c, 0x6f, 0x63, 0x61, 0x6c, 0x5f, 0x61, 0x73, 0x6e, 0x18, 0x08, 0x20, 0x01, 0x28,
	0x0d, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x52, 0x08, 0x6c, 0x6f, 0x63, 0x61, 0x6c, 0x41, 0x73, 0x6e,
	0x1a, 0x5a, 0x0a, 0x03, 0x42, 0x67, 0x70, 0x12, 0x10, 0x0a, 0x03, 0x61, 0x73, 0x6e, 0x18, 0x01,
	0x20, 0x01, 0x28, 0x0d, 0x52, 0x03, 0x61, 0x73, 0x6e, 0x12, 0x41, 0x0a, 0x1d, 0x6b, 0x65, 0x65,
	0x70, 0x61, 0x6c, 0x69, 0x76, 0x65, 0x5f, 0x69, 0x6e, 0x74, 0x65, 0x72, 0x76, 0x61, 0x6c, 0x5f,
	0x69, 0x6e, 0x5f, 0x73, 0x65, 0x63, 0x6f, 0x6e, 0x64, 0x73, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0d,
	0x52, 0x1a, 0x6b, 0x65, 0x65, 0x70, 0x61, 0x6c, 0x69, 0x76, 0x65, 0x49, 0x6e, 0x74, 0x65, 0x72,
	0x76, 0x61, 0x6c, 0x49, 0x6e, 0x53, 0x65, 0x63, 0x6f, 0x6e, 0x64, 0x73, 0x1a, 0x39, 0x0a, 0x0b,
	0x4c, 0x61, 0x62, 0x65, 0x6c, 0x73, 0x45, 0x6e, 0x74, 0x72, 0x79, 0x12, 0x10, 0x0a, 0x03, 0x6b,
	0x65, 0x79, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x03, 0x6b, 0x65, 0x79, 0x12, 0x14, 0x0a,
	0x05, 0x76, 0x61, 0x6c, 0x75, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x52, 0x05, 0x76, 0x61,
	0x6c, 0x75, 0x65, 0x3a, 0x02, 0x38, 0x01, 0x3a, 0x6d, 0xea, 0x41, 0x6a, 0x0a, 0x21, 0x65, 0x64,
	0x67, 0x65, 0x6e, 0x65, 0x74, 0x77, 0x6f, 0x72, 0x6b, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65,
	0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x52, 0x6f, 0x75, 0x74, 0x65, 0x72, 0x12,
	0x45, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x73, 0x2f, 0x7b, 0x70, 0x72, 0x6f, 0x6a, 0x65,
	0x63, 0x74, 0x7d, 0x2f, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x7b, 0x6c,
	0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x7d, 0x2f, 0x7a, 0x6f, 0x6e, 0x65, 0x73, 0x2f, 0x7b,
	0x7a, 0x6f, 0x6e, 0x65, 0x7d, 0x2f, 0x72, 0x6f, 0x75, 0x74, 0x65, 0x72, 0x73, 0x2f, 0x7b, 0x72,
	0x6f, 0x75, 0x74, 0x65, 0x72, 0x7d, 0x22, 0x52, 0x0a, 0x10, 0x4c, 0x69, 0x6e, 0x6b, 0x4c, 0x61,
	0x79, 0x65, 0x72, 0x41, 0x64, 0x64, 0x72, 0x65, 0x73, 0x73, 0x12, 0x1f, 0x0a, 0x0b, 0x6d, 0x61,
	0x63, 0x5f, 0x61, 0x64, 0x64, 0x72, 0x65, 0x73, 0x73, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52,
	0x0a, 0x6d, 0x61, 0x63, 0x41, 0x64, 0x64, 0x72, 0x65, 0x73, 0x73, 0x12, 0x1d, 0x0a, 0x0a, 0x69,
	0x70, 0x5f, 0x61, 0x64, 0x64, 0x72, 0x65, 0x73, 0x73, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x52,
	0x09, 0x69, 0x70, 0x41, 0x64, 0x64, 0x72, 0x65, 0x73, 0x73, 0x22, 0xa4, 0x01, 0x0a, 0x0c, 0x53,
	0x75, 0x62, 0x6e, 0x65, 0x74, 0x53, 0x74, 0x61, 0x74, 0x75, 0x73, 0x12, 0x12, 0x0a, 0x04, 0x6e,
	0x61, 0x6d, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x12,
	0x1f, 0x0a, 0x0b, 0x6d, 0x61, 0x63, 0x5f, 0x61, 0x64, 0x64, 0x72, 0x65, 0x73, 0x73, 0x18, 0x02,
	0x20, 0x01, 0x28, 0x09, 0x52, 0x0a, 0x6d, 0x61, 0x63, 0x41, 0x64, 0x64, 0x72, 0x65, 0x73, 0x73,
	0x12, 0x5f, 0x0a, 0x14, 0x6c, 0x69, 0x6e, 0x6b, 0x5f, 0x6c, 0x61, 0x79, 0x65, 0x72, 0x5f, 0x61,
	0x64, 0x64, 0x72, 0x65, 0x73, 0x73, 0x65, 0x73, 0x18, 0x03, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x2d,
	0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x65, 0x64,
	0x67, 0x65, 0x6e, 0x65, 0x74, 0x77, 0x6f, 0x72, 0x6b, 0x2e, 0x76, 0x31, 0x2e, 0x4c, 0x69, 0x6e,
	0x6b, 0x4c, 0x61, 0x79, 0x65, 0x72, 0x41, 0x64, 0x64, 0x72, 0x65, 0x73, 0x73, 0x52, 0x12, 0x6c,
	0x69, 0x6e, 0x6b, 0x4c, 0x61, 0x79, 0x65, 0x72, 0x41, 0x64, 0x64, 0x72, 0x65, 0x73, 0x73, 0x65,
	0x73, 0x22, 0xe4, 0x0b, 0x0a, 0x17, 0x49, 0x6e, 0x74, 0x65, 0x72, 0x63, 0x6f, 0x6e, 0x6e, 0x65,
	0x63, 0x74, 0x44, 0x69, 0x61, 0x67, 0x6e, 0x6f, 0x73, 0x74, 0x69, 0x63, 0x73, 0x12, 0x1f, 0x0a,
	0x0b, 0x6d, 0x61, 0x63, 0x5f, 0x61, 0x64, 0x64, 0x72, 0x65, 0x73, 0x73, 0x18, 0x01, 0x20, 0x01,
	0x28, 0x09, 0x52, 0x0a, 0x6d, 0x61, 0x63, 0x41, 0x64, 0x64, 0x72, 0x65, 0x73, 0x73, 0x12, 0x5f,
	0x0a, 0x14, 0x6c, 0x69, 0x6e, 0x6b, 0x5f, 0x6c, 0x61, 0x79, 0x65, 0x72, 0x5f, 0x61, 0x64, 0x64,
	0x72, 0x65, 0x73, 0x73, 0x65, 0x73, 0x18, 0x02, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x2d, 0x2e, 0x67,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x65, 0x64, 0x67, 0x65,
	0x6e, 0x65, 0x74, 0x77, 0x6f, 0x72, 0x6b, 0x2e, 0x76, 0x31, 0x2e, 0x4c, 0x69, 0x6e, 0x6b, 0x4c,
	0x61, 0x79, 0x65, 0x72, 0x41, 0x64, 0x64, 0x72, 0x65, 0x73, 0x73, 0x52, 0x12, 0x6c, 0x69, 0x6e,
	0x6b, 0x4c, 0x61, 0x79, 0x65, 0x72, 0x41, 0x64, 0x64, 0x72, 0x65, 0x73, 0x73, 0x65, 0x73, 0x12,
	0x55, 0x0a, 0x05, 0x6c, 0x69, 0x6e, 0x6b, 0x73, 0x18, 0x03, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x3f,
	0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x65, 0x64,
	0x67, 0x65, 0x6e, 0x65, 0x74, 0x77, 0x6f, 0x72, 0x6b, 0x2e, 0x76, 0x31, 0x2e, 0x49, 0x6e, 0x74,
	0x65, 0x72, 0x63, 0x6f, 0x6e, 0x6e, 0x65, 0x63, 0x74, 0x44, 0x69, 0x61, 0x67, 0x6e, 0x6f, 0x73,
	0x74, 0x69, 0x63, 0x73, 0x2e, 0x4c, 0x69, 0x6e, 0x6b, 0x53, 0x74, 0x61, 0x74, 0x75, 0x73, 0x52,
	0x05, 0x6c, 0x69, 0x6e, 0x6b, 0x73, 0x1a, 0xe3, 0x02, 0x0a, 0x0a, 0x4c, 0x69, 0x6e, 0x6b, 0x53,
	0x74, 0x61, 0x74, 0x75, 0x73, 0x12, 0x1d, 0x0a, 0x0a, 0x63, 0x69, 0x72, 0x63, 0x75, 0x69, 0x74,
	0x5f, 0x69, 0x64, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x09, 0x63, 0x69, 0x72, 0x63, 0x75,
	0x69, 0x74, 0x49, 0x64, 0x12, 0x64, 0x0a, 0x0b, 0x6c, 0x61, 0x63, 0x70, 0x5f, 0x73, 0x74, 0x61,
	0x74, 0x75, 0x73, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x43, 0x2e, 0x67, 0x6f, 0x6f, 0x67,
	0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x65, 0x64, 0x67, 0x65, 0x6e, 0x65, 0x74,
	0x77, 0x6f, 0x72, 0x6b, 0x2e, 0x76, 0x31, 0x2e, 0x49, 0x6e, 0x74, 0x65, 0x72, 0x63, 0x6f, 0x6e,
	0x6e, 0x65, 0x63, 0x74, 0x44, 0x69, 0x61, 0x67, 0x6e, 0x6f, 0x73, 0x74, 0x69, 0x63, 0x73, 0x2e,
	0x4c, 0x69, 0x6e, 0x6b, 0x4c, 0x41, 0x43, 0x50, 0x53, 0x74, 0x61, 0x74, 0x75, 0x73, 0x52, 0x0a,
	0x6c, 0x61, 0x63, 0x70, 0x53, 0x74, 0x61, 0x74, 0x75, 0x73, 0x12, 0x68, 0x0a, 0x0d, 0x6c, 0x6c,
	0x64, 0x70, 0x5f, 0x73, 0x74, 0x61, 0x74, 0x75, 0x73, 0x65, 0x73, 0x18, 0x03, 0x20, 0x03, 0x28,
	0x0b, 0x32, 0x43, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64,
	0x2e, 0x65, 0x64, 0x67, 0x65, 0x6e, 0x65, 0x74, 0x77, 0x6f, 0x72, 0x6b, 0x2e, 0x76, 0x31, 0x2e,
	0x49, 0x6e, 0x74, 0x65, 0x72, 0x63, 0x6f, 0x6e, 0x6e, 0x65, 0x63, 0x74, 0x44, 0x69, 0x61, 0x67,
	0x6e, 0x6f, 0x73, 0x74, 0x69, 0x63, 0x73, 0x2e, 0x4c, 0x69, 0x6e, 0x6b, 0x4c, 0x4c, 0x44, 0x50,
	0x53, 0x74, 0x61, 0x74, 0x75, 0x73, 0x52, 0x0c, 0x6c, 0x6c, 0x64, 0x70, 0x53, 0x74, 0x61, 0x74,
	0x75, 0x73, 0x65, 0x73, 0x12, 0x66, 0x0a, 0x0d, 0x70, 0x61, 0x63, 0x6b, 0x65, 0x74, 0x5f, 0x63,
	0x6f, 0x75, 0x6e, 0x74, 0x73, 0x18, 0x04, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x41, 0x2e, 0x67, 0x6f,
	0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x65, 0x64, 0x67, 0x65, 0x6e,
	0x65, 0x74, 0x77, 0x6f, 0x72, 0x6b, 0x2e, 0x76, 0x31, 0x2e, 0x49, 0x6e, 0x74, 0x65, 0x72, 0x63,
	0x6f, 0x6e, 0x6e, 0x65, 0x63, 0x74, 0x44, 0x69, 0x61, 0x67, 0x6e, 0x6f, 0x73, 0x74, 0x69, 0x63,
	0x73, 0x2e, 0x50, 0x61, 0x63, 0x6b, 0x65, 0x74, 0x43, 0x6f, 0x75, 0x6e, 0x74, 0x73, 0x52, 0x0c,
	0x70, 0x61, 0x63, 0x6b, 0x65, 0x74, 0x43, 0x6f, 0x75, 0x6e, 0x74, 0x73, 0x1a, 0x8a, 0x02, 0x0a,
	0x0c, 0x50, 0x61, 0x63, 0x6b, 0x65, 0x74, 0x43, 0x6f, 0x75, 0x6e, 0x74, 0x73, 0x12, 0x27, 0x0a,
	0x0f, 0x69, 0x6e, 0x62, 0x6f, 0x75, 0x6e, 0x64, 0x5f, 0x75, 0x6e, 0x69, 0x63, 0x61, 0x73, 0x74,
	0x18, 0x01, 0x20, 0x01, 0x28, 0x03, 0x52, 0x0e, 0x69, 0x6e, 0x62, 0x6f, 0x75, 0x6e, 0x64, 0x55,
	0x6e, 0x69, 0x63, 0x61, 0x73, 0x74, 0x12, 0x25, 0x0a, 0x0e, 0x69, 0x6e, 0x62, 0x6f, 0x75, 0x6e,
	0x64, 0x5f, 0x65, 0x72, 0x72, 0x6f, 0x72, 0x73, 0x18, 0x02, 0x20, 0x01, 0x28, 0x03, 0x52, 0x0d,
	0x69, 0x6e, 0x62, 0x6f, 0x75, 0x6e, 0x64, 0x45, 0x72, 0x72, 0x6f, 0x72, 0x73, 0x12, 0x29, 0x0a,
	0x10, 0x69, 0x6e, 0x62, 0x6f, 0x75, 0x6e, 0x64, 0x5f, 0x64, 0x69, 0x73, 0x63, 0x61, 0x72, 0x64,
	0x73, 0x18, 0x03, 0x20, 0x01, 0x28, 0x03, 0x52, 0x0f, 0x69, 0x6e, 0x62, 0x6f, 0x75, 0x6e, 0x64,
	0x44, 0x69, 0x73, 0x63, 0x61, 0x72, 0x64, 0x73, 0x12, 0x29, 0x0a, 0x10, 0x6f, 0x75, 0x74, 0x62,
	0x6f, 0x75, 0x6e, 0x64, 0x5f, 0x75, 0x6e, 0x69, 0x63, 0x61, 0x73, 0x74, 0x18, 0x04, 0x20, 0x01,
	0x28, 0x03, 0x52, 0x0f, 0x6f, 0x75, 0x74, 0x62, 0x6f, 0x75, 0x6e, 0x64, 0x55, 0x6e, 0x69, 0x63,
	0x61, 0x73, 0x74, 0x12, 0x27, 0x0a, 0x0f, 0x6f, 0x75, 0x74, 0x62, 0x6f, 0x75, 0x6e, 0x64, 0x5f,
	0x65, 0x72, 0x72, 0x6f, 0x72, 0x73, 0x18, 0x05, 0x20, 0x01, 0x28, 0x03, 0x52, 0x0e, 0x6f, 0x75,
	0x74, 0x62, 0x6f, 0x75, 0x6e, 0x64, 0x45, 0x72, 0x72, 0x6f, 0x72, 0x73, 0x12, 0x2b, 0x0a, 0x11,
	0x6f, 0x75, 0x74, 0x62, 0x6f, 0x75, 0x6e, 0x64, 0x5f, 0x64, 0x69, 0x73, 0x63, 0x61, 0x72, 0x64,
	0x73, 0x18, 0x06, 0x20, 0x01, 0x28, 0x03, 0x52, 0x10, 0x6f, 0x75, 0x74, 0x62, 0x6f, 0x75, 0x6e,
	0x64, 0x44, 0x69, 0x73, 0x63, 0x61, 0x72, 0x64, 0x73, 0x1a, 0xe1, 0x02, 0x0a, 0x0e, 0x4c, 0x69,
	0x6e, 0x6b, 0x4c, 0x41, 0x43, 0x50, 0x53, 0x74, 0x61, 0x74, 0x75, 0x73, 0x12, 0x5f, 0x0a, 0x05,
	0x73, 0x74, 0x61, 0x74, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0e, 0x32, 0x49, 0x2e, 0x67, 0x6f,
	0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x65, 0x64, 0x67, 0x65, 0x6e,
	0x65, 0x74, 0x77, 0x6f, 0x72, 0x6b, 0x2e, 0x76, 0x31, 0x2e, 0x49, 0x6e, 0x74, 0x65, 0x72, 0x63,
	0x6f, 0x6e, 0x6e, 0x65, 0x63, 0x74, 0x44, 0x69, 0x61, 0x67, 0x6e, 0x6f, 0x73, 0x74, 0x69, 0x63,
	0x73, 0x2e, 0x4c, 0x69, 0x6e, 0x6b, 0x4c, 0x41, 0x43, 0x50, 0x53, 0x74, 0x61, 0x74, 0x75, 0x73,
	0x2e, 0x53, 0x74, 0x61, 0x74, 0x65, 0x52, 0x05, 0x73, 0x74, 0x61, 0x74, 0x65, 0x12, 0x28, 0x0a,
	0x10, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x5f, 0x73, 0x79, 0x73, 0x74, 0x65, 0x6d, 0x5f, 0x69,
	0x64, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x52, 0x0e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x53,
	0x79, 0x73, 0x74, 0x65, 0x6d, 0x49, 0x64, 0x12, 0x2c, 0x0a, 0x12, 0x6e, 0x65, 0x69, 0x67, 0x68,
	0x62, 0x6f, 0x72, 0x5f, 0x73, 0x79, 0x73, 0x74, 0x65, 0x6d, 0x5f, 0x69, 0x64, 0x18, 0x03, 0x20,
	0x01, 0x28, 0x09, 0x52, 0x10, 0x6e, 0x65, 0x69, 0x67, 0x68, 0x62, 0x6f, 0x72, 0x53, 0x79, 0x73,
	0x74, 0x65, 0x6d, 0x49, 0x64, 0x12, 0x22, 0x0a, 0x0c, 0x61, 0x67, 0x67, 0x72, 0x65, 0x67, 0x61,
	0x74, 0x61, 0x62, 0x6c, 0x65, 0x18, 0x04, 0x20, 0x01, 0x28, 0x08, 0x52, 0x0c, 0x61, 0x67, 0x67,
	0x72, 0x65, 0x67, 0x61, 0x74, 0x61, 0x62, 0x6c, 0x65, 0x12, 0x1e, 0x0a, 0x0a, 0x63, 0x6f, 0x6c,
	0x6c, 0x65, 0x63, 0x74, 0x69, 0x6e, 0x67, 0x18, 0x05, 0x20, 0x01, 0x28, 0x08, 0x52, 0x0a, 0x63,
	0x6f, 0x6c, 0x6c, 0x65, 0x63, 0x74, 0x69, 0x6e, 0x67, 0x12, 0x22, 0x0a, 0x0c, 0x64, 0x69, 0x73,
	0x74, 0x72, 0x69, 0x62, 0x75, 0x74, 0x69, 0x6e, 0x67, 0x18, 0x06, 0x20, 0x01, 0x28, 0x08, 0x52,
	0x0c, 0x64, 0x69, 0x73, 0x74, 0x72, 0x69, 0x62, 0x75, 0x74, 0x69, 0x6e, 0x67, 0x22, 0x2e, 0x0a,
	0x05, 0x53, 0x74, 0x61, 0x74, 0x65, 0x12, 0x0b, 0x0a, 0x07, 0x55, 0x4e, 0x4b, 0x4e, 0x4f, 0x57,
	0x4e, 0x10, 0x00, 0x12, 0x0a, 0x0a, 0x06, 0x41, 0x43, 0x54, 0x49, 0x56, 0x45, 0x10, 0x01, 0x12,
	0x0c, 0x0a, 0x08, 0x44, 0x45, 0x54, 0x41, 0x43, 0x48, 0x45, 0x44, 0x10, 0x02, 0x1a, 0x98, 0x02,
	0x0a, 0x0e, 0x4c, 0x69, 0x6e, 0x6b, 0x4c, 0x4c, 0x44, 0x50, 0x53, 0x74, 0x61, 0x74, 0x75, 0x73,
	0x12, 0x28, 0x0a, 0x10, 0x70, 0x65, 0x65, 0x72, 0x5f, 0x73, 0x79, 0x73, 0x74, 0x65, 0x6d, 0x5f,
	0x6e, 0x61, 0x6d, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x0e, 0x70, 0x65, 0x65, 0x72,
	0x53, 0x79, 0x73, 0x74, 0x65, 0x6d, 0x4e, 0x61, 0x6d, 0x65, 0x12, 0x36, 0x0a, 0x17, 0x70, 0x65,
	0x65, 0x72, 0x5f, 0x73, 0x79, 0x73, 0x74, 0x65, 0x6d, 0x5f, 0x64, 0x65, 0x73, 0x63, 0x72, 0x69,
	0x70, 0x74, 0x69, 0x6f, 0x6e, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x52, 0x15, 0x70, 0x65, 0x65,
	0x72, 0x53, 0x79, 0x73, 0x74, 0x65, 0x6d, 0x44, 0x65, 0x73, 0x63, 0x72, 0x69, 0x70, 0x74, 0x69,
	0x6f, 0x6e, 0x12, 0x26, 0x0a, 0x0f, 0x70, 0x65, 0x65, 0x72, 0x5f, 0x63, 0x68, 0x61, 0x73, 0x73,
	0x69, 0x73, 0x5f, 0x69, 0x64, 0x18, 0x03, 0x20, 0x01, 0x28, 0x09, 0x52, 0x0d, 0x70, 0x65, 0x65,
	0x72, 0x43, 0x68, 0x61, 0x73, 0x73, 0x69, 0x73, 0x49, 0x64, 0x12, 0x2f, 0x0a, 0x14, 0x70, 0x65,
	0x65, 0x72, 0x5f, 0x63, 0x68, 0x61, 0x73, 0x73, 0x69, 0x73, 0x5f, 0x69, 0x64, 0x5f, 0x74, 0x79,
	0x70, 0x65, 0x18, 0x04, 0x20, 0x01, 0x28, 0x09, 0x52, 0x11, 0x70, 0x65, 0x65, 0x72, 0x43, 0x68,
	0x61, 0x73, 0x73, 0x69, 0x73, 0x49, 0x64, 0x54, 0x79, 0x70, 0x65, 0x12, 0x20, 0x0a, 0x0c, 0x70,
	0x65, 0x65, 0x72, 0x5f, 0x70, 0x6f, 0x72, 0x74, 0x5f, 0x69, 0x64, 0x18, 0x05, 0x20, 0x01, 0x28,
	0x09, 0x52, 0x0a, 0x70, 0x65, 0x65, 0x72, 0x50, 0x6f, 0x72, 0x74, 0x49, 0x64, 0x12, 0x29, 0x0a,
	0x11, 0x70, 0x65, 0x65, 0x72, 0x5f, 0x70, 0x6f, 0x72, 0x74, 0x5f, 0x69, 0x64, 0x5f, 0x74, 0x79,
	0x70, 0x65, 0x18, 0x06, 0x20, 0x01, 0x28, 0x09, 0x52, 0x0e, 0x70, 0x65, 0x65, 0x72, 0x50, 0x6f,
	0x72, 0x74, 0x49, 0x64, 0x54, 0x79, 0x70, 0x65, 0x22, 0x93, 0x06, 0x0a, 0x0c, 0x52, 0x6f, 0x75,
	0x74, 0x65, 0x72, 0x53, 0x74, 0x61, 0x74, 0x75, 0x73, 0x12, 0x41, 0x0a, 0x07, 0x6e, 0x65, 0x74,
	0x77, 0x6f, 0x72, 0x6b, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x27, 0xfa, 0x41, 0x24, 0x0a,
	0x22, 0x65, 0x64, 0x67, 0x65, 0x6e, 0x65, 0x74, 0x77, 0x6f, 0x72, 0x6b, 0x2e, 0x67, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x4e, 0x65, 0x74, 0x77,
	0x6f, 0x72, 0x6b, 0x52, 0x07, 0x6e, 0x65, 0x74, 0x77, 0x6f, 0x72, 0x6b, 0x12, 0x5f, 0x0a, 0x0f,
	0x62, 0x67, 0x70, 0x5f, 0x70, 0x65, 0x65, 0x72, 0x5f, 0x73, 0x74, 0x61, 0x74, 0x75, 0x73, 0x18,
	0x02, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x37, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63,
	0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x65, 0x64, 0x67, 0x65, 0x6e, 0x65, 0x74, 0x77, 0x6f, 0x72, 0x6b,
	0x2e, 0x76, 0x31, 0x2e, 0x52, 0x6f, 0x75, 0x74, 0x65, 0x72, 0x53, 0x74, 0x61, 0x74, 0x75, 0x73,
	0x2e, 0x42, 0x67, 0x70, 0x50, 0x65, 0x65, 0x72, 0x53, 0x74, 0x61, 0x74, 0x75, 0x73, 0x52, 0x0d,
	0x62, 0x67, 0x70, 0x50, 0x65, 0x65, 0x72, 0x53, 0x74, 0x61, 0x74, 0x75, 0x73, 0x1a, 0xa6, 0x03,
	0x0a, 0x0d, 0x42, 0x67, 0x70, 0x50, 0x65, 0x65, 0x72, 0x53, 0x74, 0x61, 0x74, 0x75, 0x73, 0x12,
	0x12, 0x0a, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x04, 0x6e,
	0x61, 0x6d, 0x65, 0x12, 0x1d, 0x0a, 0x0a, 0x69, 0x70, 0x5f, 0x61, 0x64, 0x64, 0x72, 0x65, 0x73,
	0x73, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x52, 0x09, 0x69, 0x70, 0x41, 0x64, 0x64, 0x72, 0x65,
	0x73, 0x73, 0x12, 0x26, 0x0a, 0x0f, 0x70, 0x65, 0x65, 0x72, 0x5f, 0x69, 0x70, 0x5f, 0x61, 0x64,
	0x64, 0x72, 0x65, 0x73, 0x73, 0x18, 0x03, 0x20, 0x01, 0x28, 0x09, 0x52, 0x0d, 0x70, 0x65, 0x65,
	0x72, 0x49, 0x70, 0x41, 0x64, 0x64, 0x72, 0x65, 0x73, 0x73, 0x12, 0x59, 0x0a, 0x06, 0x73, 0x74,
	0x61, 0x74, 0x75, 0x73, 0x18, 0x04, 0x20, 0x01, 0x28, 0x0e, 0x32, 0x41, 0x2e, 0x67, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x65, 0x64, 0x67, 0x65, 0x6e, 0x65,
	0x74, 0x77, 0x6f, 0x72, 0x6b, 0x2e, 0x76, 0x31, 0x2e, 0x52, 0x6f, 0x75, 0x74, 0x65, 0x72, 0x53,
	0x74, 0x61, 0x74, 0x75, 0x73, 0x2e, 0x42, 0x67, 0x70, 0x50, 0x65, 0x65, 0x72, 0x53, 0x74, 0x61,
	0x74, 0x75, 0x73, 0x2e, 0x42, 0x67, 0x70, 0x53, 0x74, 0x61, 0x74, 0x75, 0x73, 0x52, 0x06, 0x73,
	0x74, 0x61, 0x74, 0x75, 0x73, 0x12, 0x14, 0x0a, 0x05, 0x73, 0x74, 0x61, 0x74, 0x65, 0x18, 0x05,
	0x20, 0x01, 0x28, 0x09, 0x52, 0x05, 0x73, 0x74, 0x61, 0x74, 0x65, 0x12, 0x16, 0x0a, 0x06, 0x75,
	0x70, 0x74, 0x69, 0x6d, 0x65, 0x18, 0x06, 0x20, 0x01, 0x28, 0x09, 0x52, 0x06, 0x75, 0x70, 0x74,
	0x69, 0x6d, 0x65, 0x12, 0x25, 0x0a, 0x0e, 0x75, 0x70, 0x74, 0x69, 0x6d, 0x65, 0x5f, 0x73, 0x65,
	0x63, 0x6f, 0x6e, 0x64, 0x73, 0x18, 0x07, 0x20, 0x01, 0x28, 0x03, 0x52, 0x0d, 0x75, 0x70, 0x74,
	0x69, 0x6d, 0x65, 0x53, 0x65, 0x63, 0x6f, 0x6e, 0x64, 0x73, 0x12, 0x5e, 0x0a, 0x0e, 0x70, 0x72,
	0x65, 0x66, 0x69, 0x78, 0x5f, 0x63, 0x6f, 0x75, 0x6e, 0x74, 0x65, 0x72, 0x18, 0x08, 0x20, 0x01,
	0x28, 0x0b, 0x32, 0x37, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75,
	0x64, 0x2e, 0x65, 0x64, 0x67, 0x65, 0x6e, 0x65, 0x74, 0x77, 0x6f, 0x72, 0x6b, 0x2e, 0x76, 0x31,
	0x2e, 0x52, 0x6f, 0x75, 0x74, 0x65, 0x72, 0x53, 0x74, 0x61, 0x74, 0x75, 0x73, 0x2e, 0x50, 0x72,
	0x65, 0x66, 0x69, 0x78, 0x43, 0x6f, 0x75, 0x6e, 0x74, 0x65, 0x72, 0x52, 0x0d, 0x70, 0x72, 0x65,
	0x66, 0x69, 0x78, 0x43, 0x6f, 0x75, 0x6e, 0x74, 0x65, 0x72, 0x22, 0x2a, 0x0a, 0x09, 0x42, 0x67,
	0x70, 0x53, 0x74, 0x61, 0x74, 0x75, 0x73, 0x12, 0x0b, 0x0a, 0x07, 0x55, 0x4e, 0x4b, 0x4e, 0x4f,
	0x57, 0x4e, 0x10, 0x00, 0x12, 0x06, 0x0a, 0x02, 0x55, 0x50, 0x10, 0x01, 0x12, 0x08, 0x0a, 0x04,
	0x44, 0x4f, 0x57, 0x4e, 0x10, 0x02, 0x1a, 0xb5, 0x01, 0x0a, 0x0d, 0x50, 0x72, 0x65, 0x66, 0x69,
	0x78, 0x43, 0x6f, 0x75, 0x6e, 0x74, 0x65, 0x72, 0x12, 0x1e, 0x0a, 0x0a, 0x61, 0x64, 0x76, 0x65,
	0x72, 0x74, 0x69, 0x73, 0x65, 0x64, 0x18, 0x01, 0x20, 0x01, 0x28, 0x03, 0x52, 0x0a, 0x61, 0x64,
	0x76, 0x65, 0x72, 0x74, 0x69, 0x73, 0x65, 0x64, 0x12, 0x16, 0x0a, 0x06, 0x64, 0x65, 0x6e, 0x69,
	0x65, 0x64, 0x18, 0x02, 0x20, 0x01, 0x28, 0x03, 0x52, 0x06, 0x64, 0x65, 0x6e, 0x69, 0x65, 0x64,
	0x12, 0x1a, 0x0a, 0x08, 0x72, 0x65, 0x63, 0x65, 0x69, 0x76, 0x65, 0x64, 0x18, 0x03, 0x20, 0x01,
	0x28, 0x03, 0x52, 0x08, 0x72, 0x65, 0x63, 0x65, 0x69, 0x76, 0x65, 0x64, 0x12, 0x12, 0x0a, 0x04,
	0x73, 0x65, 0x6e, 0x74, 0x18, 0x04, 0x20, 0x01, 0x28, 0x03, 0x52, 0x04, 0x73, 0x65, 0x6e, 0x74,
	0x12, 0x1e, 0x0a, 0x0a, 0x73, 0x75, 0x70, 0x70, 0x72, 0x65, 0x73, 0x73, 0x65, 0x64, 0x18, 0x05,
	0x20, 0x01, 0x28, 0x03, 0x52, 0x0a, 0x73, 0x75, 0x70, 0x70, 0x72, 0x65, 0x73, 0x73, 0x65, 0x64,
	0x12, 0x1c, 0x0a, 0x09, 0x77, 0x69, 0x74, 0x68, 0x64, 0x72, 0x61, 0x77, 0x6e, 0x18, 0x06, 0x20,
	0x01, 0x28, 0x03, 0x52, 0x09, 0x77, 0x69, 0x74, 0x68, 0x64, 0x72, 0x61, 0x77, 0x6e, 0x2a, 0x89,
	0x01, 0x0a, 0x0d, 0x52, 0x65, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x53, 0x74, 0x61, 0x74, 0x65,
	0x12, 0x11, 0x0a, 0x0d, 0x53, 0x54, 0x41, 0x54, 0x45, 0x5f, 0x55, 0x4e, 0x4b, 0x4e, 0x4f, 0x57,
	0x4e, 0x10, 0x00, 0x12, 0x11, 0x0a, 0x0d, 0x53, 0x54, 0x41, 0x54, 0x45, 0x5f, 0x50, 0x45, 0x4e,
	0x44, 0x49, 0x4e, 0x47, 0x10, 0x01, 0x12, 0x16, 0x0a, 0x12, 0x53, 0x54, 0x41, 0x54, 0x45, 0x5f,
	0x50, 0x52, 0x4f, 0x56, 0x49, 0x53, 0x49, 0x4f, 0x4e, 0x49, 0x4e, 0x47, 0x10, 0x02, 0x12, 0x11,
	0x0a, 0x0d, 0x53, 0x54, 0x41, 0x54, 0x45, 0x5f, 0x52, 0x55, 0x4e, 0x4e, 0x49, 0x4e, 0x47, 0x10,
	0x03, 0x12, 0x13, 0x0a, 0x0f, 0x53, 0x54, 0x41, 0x54, 0x45, 0x5f, 0x53, 0x55, 0x53, 0x50, 0x45,
	0x4e, 0x44, 0x45, 0x44, 0x10, 0x04, 0x12, 0x12, 0x0a, 0x0e, 0x53, 0x54, 0x41, 0x54, 0x45, 0x5f,
	0x44, 0x45, 0x4c, 0x45, 0x54, 0x49, 0x4e, 0x47, 0x10, 0x05, 0x42, 0xd3, 0x01, 0x0a, 0x1f, 0x63,
	0x6f, 0x6d, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e,
	0x65, 0x64, 0x67, 0x65, 0x6e, 0x65, 0x74, 0x77, 0x6f, 0x72, 0x6b, 0x2e, 0x76, 0x31, 0x42, 0x0e,
	0x52, 0x65, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x73, 0x50, 0x72, 0x6f, 0x74, 0x6f, 0x50, 0x01,
	0x5a, 0x41, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63,
	0x6f, 0x6d, 0x2f, 0x67, 0x6f, 0x2f, 0x65, 0x64, 0x67, 0x65, 0x6e, 0x65, 0x74, 0x77, 0x6f, 0x72,
	0x6b, 0x2f, 0x61, 0x70, 0x69, 0x76, 0x31, 0x2f, 0x65, 0x64, 0x67, 0x65, 0x6e, 0x65, 0x74, 0x77,
	0x6f, 0x72, 0x6b, 0x70, 0x62, 0x3b, 0x65, 0x64, 0x67, 0x65, 0x6e, 0x65, 0x74, 0x77, 0x6f, 0x72,
	0x6b, 0x70, 0x62, 0xaa, 0x02, 0x1b, 0x47, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x43, 0x6c, 0x6f,
	0x75, 0x64, 0x2e, 0x45, 0x64, 0x67, 0x65, 0x4e, 0x65, 0x74, 0x77, 0x6f, 0x72, 0x6b, 0x2e, 0x56,
	0x31, 0xca, 0x02, 0x1b, 0x47, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x5c, 0x43, 0x6c, 0x6f, 0x75, 0x64,
	0x5c, 0x45, 0x64, 0x67, 0x65, 0x4e, 0x65, 0x74, 0x77, 0x6f, 0x72, 0x6b, 0x5c, 0x56, 0x31, 0xea,
	0x02, 0x1e, 0x47, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x3a, 0x3a, 0x43, 0x6c, 0x6f, 0x75, 0x64, 0x3a,
	0x3a, 0x45, 0x64, 0x67, 0x65, 0x4e, 0x65, 0x74, 0x77, 0x6f, 0x72, 0x6b, 0x3a, 0x3a, 0x56, 0x31,
	0x62, 0x06, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x33,
}

var (
	file_google_cloud_edgenetwork_v1_resources_proto_rawDescOnce sync.Once
	file_google_cloud_edgenetwork_v1_resources_proto_rawDescData = file_google_cloud_edgenetwork_v1_resources_proto_rawDesc
)

func file_google_cloud_edgenetwork_v1_resources_proto_rawDescGZIP() []byte {
	file_google_cloud_edgenetwork_v1_resources_proto_rawDescOnce.Do(func() {
		file_google_cloud_edgenetwork_v1_resources_proto_rawDescData = protoimpl.X.CompressGZIP(file_google_cloud_edgenetwork_v1_resources_proto_rawDescData)
	})
	return file_google_cloud_edgenetwork_v1_resources_proto_rawDescData
}

var file_google_cloud_edgenetwork_v1_resources_proto_enumTypes = make([]protoimpl.EnumInfo, 4)
var file_google_cloud_edgenetwork_v1_resources_proto_msgTypes = make([]protoimpl.MessageInfo, 25)
var file_google_cloud_edgenetwork_v1_resources_proto_goTypes = []interface{}{
	(ResourceState)(0),                                // 0: google.cloud.edgenetwork.v1.ResourceState
	(Interconnect_InterconnectType)(0),                // 1: google.cloud.edgenetwork.v1.Interconnect.InterconnectType
	(InterconnectDiagnostics_LinkLACPStatus_State)(0), // 2: google.cloud.edgenetwork.v1.InterconnectDiagnostics.LinkLACPStatus.State
	(RouterStatus_BgpPeerStatus_BgpStatus)(0),         // 3: google.cloud.edgenetwork.v1.RouterStatus.BgpPeerStatus.BgpStatus
	(*Zone)(nil),                    // 4: google.cloud.edgenetwork.v1.Zone
	(*Network)(nil),                 // 5: google.cloud.edgenetwork.v1.Network
	(*Subnet)(nil),                  // 6: google.cloud.edgenetwork.v1.Subnet
	(*Interconnect)(nil),            // 7: google.cloud.edgenetwork.v1.Interconnect
	(*InterconnectAttachment)(nil),  // 8: google.cloud.edgenetwork.v1.InterconnectAttachment
	(*Router)(nil),                  // 9: google.cloud.edgenetwork.v1.Router
	(*LinkLayerAddress)(nil),        // 10: google.cloud.edgenetwork.v1.LinkLayerAddress
	(*SubnetStatus)(nil),            // 11: google.cloud.edgenetwork.v1.SubnetStatus
	(*InterconnectDiagnostics)(nil), // 12: google.cloud.edgenetwork.v1.InterconnectDiagnostics
	(*RouterStatus)(nil),            // 13: google.cloud.edgenetwork.v1.RouterStatus
	nil,                             // 14: google.cloud.edgenetwork.v1.Zone.LabelsEntry
	nil,                             // 15: google.cloud.edgenetwork.v1.Network.LabelsEntry
	nil,                             // 16: google.cloud.edgenetwork.v1.Subnet.LabelsEntry
	nil,                             // 17: google.cloud.edgenetwork.v1.Interconnect.LabelsEntry
	nil,                             // 18: google.cloud.edgenetwork.v1.InterconnectAttachment.LabelsEntry
	(*Router_Interface)(nil),        // 19: google.cloud.edgenetwork.v1.Router.Interface
	(*Router_BgpPeer)(nil),          // 20: google.cloud.edgenetwork.v1.Router.BgpPeer
	(*Router_Bgp)(nil),              // 21: google.cloud.edgenetwork.v1.Router.Bgp
	nil,                             // 22: google.cloud.edgenetwork.v1.Router.LabelsEntry
	(*InterconnectDiagnostics_LinkStatus)(nil),     // 23: google.cloud.edgenetwork.v1.InterconnectDiagnostics.LinkStatus
	(*InterconnectDiagnostics_PacketCounts)(nil),   // 24: google.cloud.edgenetwork.v1.InterconnectDiagnostics.PacketCounts
	(*InterconnectDiagnostics_LinkLACPStatus)(nil), // 25: google.cloud.edgenetwork.v1.InterconnectDiagnostics.LinkLACPStatus
	(*InterconnectDiagnostics_LinkLLDPStatus)(nil), // 26: google.cloud.edgenetwork.v1.InterconnectDiagnostics.LinkLLDPStatus
	(*RouterStatus_BgpPeerStatus)(nil),             // 27: google.cloud.edgenetwork.v1.RouterStatus.BgpPeerStatus
	(*RouterStatus_PrefixCounter)(nil),             // 28: google.cloud.edgenetwork.v1.RouterStatus.PrefixCounter
	(*timestamppb.Timestamp)(nil),                  // 29: google.protobuf.Timestamp
}
var file_google_cloud_edgenetwork_v1_resources_proto_depIdxs = []int32{
	29, // 0: google.cloud.edgenetwork.v1.Zone.create_time:type_name -> google.protobuf.Timestamp
	29, // 1: google.cloud.edgenetwork.v1.Zone.update_time:type_name -> google.protobuf.Timestamp
	14, // 2: google.cloud.edgenetwork.v1.Zone.labels:type_name -> google.cloud.edgenetwork.v1.Zone.LabelsEntry
	29, // 3: google.cloud.edgenetwork.v1.Network.create_time:type_name -> google.protobuf.Timestamp
	29, // 4: google.cloud.edgenetwork.v1.Network.update_time:type_name -> google.protobuf.Timestamp
	15, // 5: google.cloud.edgenetwork.v1.Network.labels:type_name -> google.cloud.edgenetwork.v1.Network.LabelsEntry
	29, // 6: google.cloud.edgenetwork.v1.Subnet.create_time:type_name -> google.protobuf.Timestamp
	29, // 7: google.cloud.edgenetwork.v1.Subnet.update_time:type_name -> google.protobuf.Timestamp
	16, // 8: google.cloud.edgenetwork.v1.Subnet.labels:type_name -> google.cloud.edgenetwork.v1.Subnet.LabelsEntry
	0,  // 9: google.cloud.edgenetwork.v1.Subnet.state:type_name -> google.cloud.edgenetwork.v1.ResourceState
	29, // 10: google.cloud.edgenetwork.v1.Interconnect.create_time:type_name -> google.protobuf.Timestamp
	29, // 11: google.cloud.edgenetwork.v1.Interconnect.update_time:type_name -> google.protobuf.Timestamp
	17, // 12: google.cloud.edgenetwork.v1.Interconnect.labels:type_name -> google.cloud.edgenetwork.v1.Interconnect.LabelsEntry
	1,  // 13: google.cloud.edgenetwork.v1.Interconnect.interconnect_type:type_name -> google.cloud.edgenetwork.v1.Interconnect.InterconnectType
	29, // 14: google.cloud.edgenetwork.v1.InterconnectAttachment.create_time:type_name -> google.protobuf.Timestamp
	29, // 15: google.cloud.edgenetwork.v1.InterconnectAttachment.update_time:type_name -> google.protobuf.Timestamp
	18, // 16: google.cloud.edgenetwork.v1.InterconnectAttachment.labels:type_name -> google.cloud.edgenetwork.v1.InterconnectAttachment.LabelsEntry
	0,  // 17: google.cloud.edgenetwork.v1.InterconnectAttachment.state:type_name -> google.cloud.edgenetwork.v1.ResourceState
	29, // 18: google.cloud.edgenetwork.v1.Router.create_time:type_name -> google.protobuf.Timestamp
	29, // 19: google.cloud.edgenetwork.v1.Router.update_time:type_name -> google.protobuf.Timestamp
	22, // 20: google.cloud.edgenetwork.v1.Router.labels:type_name -> google.cloud.edgenetwork.v1.Router.LabelsEntry
	19, // 21: google.cloud.edgenetwork.v1.Router.interface:type_name -> google.cloud.edgenetwork.v1.Router.Interface
	20, // 22: google.cloud.edgenetwork.v1.Router.bgp_peer:type_name -> google.cloud.edgenetwork.v1.Router.BgpPeer
	21, // 23: google.cloud.edgenetwork.v1.Router.bgp:type_name -> google.cloud.edgenetwork.v1.Router.Bgp
	0,  // 24: google.cloud.edgenetwork.v1.Router.state:type_name -> google.cloud.edgenetwork.v1.ResourceState
	10, // 25: google.cloud.edgenetwork.v1.SubnetStatus.link_layer_addresses:type_name -> google.cloud.edgenetwork.v1.LinkLayerAddress
	10, // 26: google.cloud.edgenetwork.v1.InterconnectDiagnostics.link_layer_addresses:type_name -> google.cloud.edgenetwork.v1.LinkLayerAddress
	23, // 27: google.cloud.edgenetwork.v1.InterconnectDiagnostics.links:type_name -> google.cloud.edgenetwork.v1.InterconnectDiagnostics.LinkStatus
	27, // 28: google.cloud.edgenetwork.v1.RouterStatus.bgp_peer_status:type_name -> google.cloud.edgenetwork.v1.RouterStatus.BgpPeerStatus
	25, // 29: google.cloud.edgenetwork.v1.InterconnectDiagnostics.LinkStatus.lacp_status:type_name -> google.cloud.edgenetwork.v1.InterconnectDiagnostics.LinkLACPStatus
	26, // 30: google.cloud.edgenetwork.v1.InterconnectDiagnostics.LinkStatus.lldp_statuses:type_name -> google.cloud.edgenetwork.v1.InterconnectDiagnostics.LinkLLDPStatus
	24, // 31: google.cloud.edgenetwork.v1.InterconnectDiagnostics.LinkStatus.packet_counts:type_name -> google.cloud.edgenetwork.v1.InterconnectDiagnostics.PacketCounts
	2,  // 32: google.cloud.edgenetwork.v1.InterconnectDiagnostics.LinkLACPStatus.state:type_name -> google.cloud.edgenetwork.v1.InterconnectDiagnostics.LinkLACPStatus.State
	3,  // 33: google.cloud.edgenetwork.v1.RouterStatus.BgpPeerStatus.status:type_name -> google.cloud.edgenetwork.v1.RouterStatus.BgpPeerStatus.BgpStatus
	28, // 34: google.cloud.edgenetwork.v1.RouterStatus.BgpPeerStatus.prefix_counter:type_name -> google.cloud.edgenetwork.v1.RouterStatus.PrefixCounter
	35, // [35:35] is the sub-list for method output_type
	35, // [35:35] is the sub-list for method input_type
	35, // [35:35] is the sub-list for extension type_name
	35, // [35:35] is the sub-list for extension extendee
	0,  // [0:35] is the sub-list for field type_name
}

func init() { file_google_cloud_edgenetwork_v1_resources_proto_init() }
func file_google_cloud_edgenetwork_v1_resources_proto_init() {
	if File_google_cloud_edgenetwork_v1_resources_proto != nil {
		return
	}
	if !protoimpl.UnsafeEnabled {
		file_google_cloud_edgenetwork_v1_resources_proto_msgTypes[0].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*Zone); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_edgenetwork_v1_resources_proto_msgTypes[1].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*Network); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_edgenetwork_v1_resources_proto_msgTypes[2].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*Subnet); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_edgenetwork_v1_resources_proto_msgTypes[3].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*Interconnect); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_edgenetwork_v1_resources_proto_msgTypes[4].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*InterconnectAttachment); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_edgenetwork_v1_resources_proto_msgTypes[5].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*Router); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_edgenetwork_v1_resources_proto_msgTypes[6].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*LinkLayerAddress); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_edgenetwork_v1_resources_proto_msgTypes[7].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*SubnetStatus); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_edgenetwork_v1_resources_proto_msgTypes[8].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*InterconnectDiagnostics); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_edgenetwork_v1_resources_proto_msgTypes[9].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*RouterStatus); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_edgenetwork_v1_resources_proto_msgTypes[15].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*Router_Interface); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_edgenetwork_v1_resources_proto_msgTypes[16].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*Router_BgpPeer); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_edgenetwork_v1_resources_proto_msgTypes[17].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*Router_Bgp); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_edgenetwork_v1_resources_proto_msgTypes[19].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*InterconnectDiagnostics_LinkStatus); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_edgenetwork_v1_resources_proto_msgTypes[20].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*InterconnectDiagnostics_PacketCounts); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_edgenetwork_v1_resources_proto_msgTypes[21].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*InterconnectDiagnostics_LinkLACPStatus); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_edgenetwork_v1_resources_proto_msgTypes[22].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*InterconnectDiagnostics_LinkLLDPStatus); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_edgenetwork_v1_resources_proto_msgTypes[23].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*RouterStatus_BgpPeerStatus); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_edgenetwork_v1_resources_proto_msgTypes[24].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*RouterStatus_PrefixCounter); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
	}
	type x struct{}
	out := protoimpl.TypeBuilder{
		File: protoimpl.DescBuilder{
			GoPackagePath: reflect.TypeOf(x{}).PkgPath(),
			RawDescriptor: file_google_cloud_edgenetwork_v1_resources_proto_rawDesc,
			NumEnums:      4,
			NumMessages:   25,
			NumExtensions: 0,
			NumServices:   0,
		},
		GoTypes:           file_google_cloud_edgenetwork_v1_resources_proto_goTypes,
		DependencyIndexes: file_google_cloud_edgenetwork_v1_resources_proto_depIdxs,
		EnumInfos:         file_google_cloud_edgenetwork_v1_resources_proto_enumTypes,
		MessageInfos:      file_google_cloud_edgenetwork_v1_resources_proto_msgTypes,
	}.Build()
	File_google_cloud_edgenetwork_v1_resources_proto = out.File
	file_google_cloud_edgenetwork_v1_resources_proto_rawDesc = nil
	file_google_cloud_edgenetwork_v1_resources_proto_goTypes = nil
	file_google_cloud_edgenetwork_v1_resources_proto_depIdxs = nil
}
