;; Tests for f64x2 [pmin, pmax] operations on major boundary values and all special values.


(module
  (func (export "f64x2.pmin") (param v128 v128) (result v128) (f64x2.pmin (local.get 0) (local.get 1)))
  (func (export "f64x2.pmax") (param v128 v128) (result v128) (f64x2.pmax (local.get 0) (local.get 1)))
)

(assert_return (invoke "f64x2.pmin" (v128.const f64x2 0x0p+0 0x0p+0)
                                    (v128.const f64x2 0x0p+0 0x0p+0))
                                    (v128.const f64x2 0x0.0p+0 0x0.0p+0))
(assert_return (invoke "f64x2.pmin" (v128.const f64x2 0x0p+0 0x0p+0)
                                    (v128.const f64x2 -0x0p+0 -0x0p+0))
                                    (v128.const f64x2 0x0.0p+0 0x0.0p+0))
(assert_return (invoke "f64x2.pmin" (v128.const f64x2 0x0p+0 0x0p+0)
                                    (v128.const f64x2 0x1p-1022 0x1p-1022))
                                    (v128.const f64x2 0x0.0p+0 0x0.0p+0))
(assert_return (invoke "f64x2.pmin" (v128.const f64x2 0x0p+0 0x0p+0)
                                    (v128.const f64x2 -0x1p-1022 -0x1p-1022))
                                    (v128.const f64x2 -0x1.0000000000000p-1022 -0x1.0000000000000p-1022))
(assert_return (invoke "f64x2.pmin" (v128.const f64x2 0x0p+0 0x0p+0)
                                    (v128.const f64x2 0x1p-1 0x1p-1))
                                    (v128.const f64x2 0x0.0p+0 0x0.0p+0))
(assert_return (invoke "f64x2.pmin" (v128.const f64x2 0x0p+0 0x0p+0)
                                    (v128.const f64x2 -0x1p-1 -0x1p-1))
                                    (v128.const f64x2 -0x1.0000000000000p-1 -0x1.0000000000000p-1))
(assert_return (invoke "f64x2.pmin" (v128.const f64x2 0x0p+0 0x0p+0)
                                    (v128.const f64x2 0x1p+0 0x1p+0))
                                    (v128.const f64x2 0x0.0p+0 0x0.0p+0))
(assert_return (invoke "f64x2.pmin" (v128.const f64x2 0x0p+0 0x0p+0)
                                    (v128.const f64x2 -0x1p+0 -0x1p+0))
                                    (v128.const f64x2 -0x1.0000000000000p+0 -0x1.0000000000000p+0))
(assert_return (invoke "f64x2.pmin" (v128.const f64x2 0x0p+0 0x0p+0)
                                    (v128.const f64x2 0x1.921fb54442d18p+2 0x1.921fb54442d18p+2))
                                    (v128.const f64x2 0x0.0p+0 0x0.0p+0))
(assert_return (invoke "f64x2.pmin" (v128.const f64x2 0x0p+0 0x0p+0)
                                    (v128.const f64x2 -0x1.921fb54442d18p+2 -0x1.921fb54442d18p+2))
                                    (v128.const f64x2 -0x1.921fb54442d18p+2 -0x1.921fb54442d18p+2))
(assert_return (invoke "f64x2.pmin" (v128.const f64x2 0x0p+0 0x0p+0)
                                    (v128.const f64x2 0x1.fffffffffffffp+1023 0x1.fffffffffffffp+1023))
                                    (v128.const f64x2 0x0.0p+0 0x0.0p+0))
(assert_return (invoke "f64x2.pmin" (v128.const f64x2 0x0p+0 0x0p+0)
                                    (v128.const f64x2 -0x1.fffffffffffffp+1023 -0x1.fffffffffffffp+1023))
                                    (v128.const f64x2 -0x1.fffffffffffffp+1023 -0x1.fffffffffffffp+1023))
(assert_return (invoke "f64x2.pmin" (v128.const f64x2 0x0p+0 0x0p+0)
                                    (v128.const f64x2 0x0.0000000000001p-1022 0x0.0000000000001p-1022))
                                    (v128.const f64x2 0x0.0p+0 0x0.0p+0))
(assert_return (invoke "f64x2.pmin" (v128.const f64x2 0x0p+0 0x0p+0)
                                    (v128.const f64x2 0x0.0000000000001p-1022 0x0.0000000000001p-1022))
                                    (v128.const f64x2 0x0.0p+0 0x0.0p+0))
(assert_return (invoke "f64x2.pmin" (v128.const f64x2 0x0p+0 0x0p+0)
                                    (v128.const f64x2 inf inf))
                                    (v128.const f64x2 0x0.0p+0 0x0.0p+0))
(assert_return (invoke "f64x2.pmin" (v128.const f64x2 0x0p+0 0x0p+0)
                                    (v128.const f64x2 -inf -inf))
                                    (v128.const f64x2 -inf -inf))
(assert_return (invoke "f64x2.pmin" (v128.const f64x2 0x0p+0 0x0p+0)
                                    (v128.const f64x2 0123456789 0123456789))
                                    (v128.const f64x2 0x0.0p+0 0x0.0p+0))
(assert_return (invoke "f64x2.pmin" (v128.const f64x2 0x0p+0 0x0p+0)
                                    (v128.const f64x2 0123456789e019 0123456789e019))
                                    (v128.const f64x2 0x0.0p+0 0x0.0p+0))
(assert_return (invoke "f64x2.pmin" (v128.const f64x2 0x0p+0 0x0p+0)
                                    (v128.const f64x2 0123456789e+019 0123456789e+019))
                                    (v128.const f64x2 0x0.0p+0 0x0.0p+0))
(assert_return (invoke "f64x2.pmin" (v128.const f64x2 0x0p+0 0x0p+0)
                                    (v128.const f64x2 0123456789e-019 0123456789e-019))
                                    (v128.const f64x2 0x0.0p+0 0x0.0p+0))
(assert_return (invoke "f64x2.pmin" (v128.const f64x2 0x0p+0 0x0p+0)
                                    (v128.const f64x2 0123456789. 0123456789.))
                                    (v128.const f64x2 0x0.0p+0 0x0.0p+0))
(assert_return (invoke "f64x2.pmin" (v128.const f64x2 0x0p+0 0x0p+0)
                                    (v128.const f64x2 0123456789.e019 0123456789.e019))
                                    (v128.const f64x2 0x0.0p+0 0x0.0p+0))
(assert_return (invoke "f64x2.pmin" (v128.const f64x2 0x0p+0 0x0p+0)
                                    (v128.const f64x2 0123456789.e+019 0123456789.e+019))
                                    (v128.const f64x2 0x0.0p+0 0x0.0p+0))
(assert_return (invoke "f64x2.pmin" (v128.const f64x2 0x0p+0 0x0p+0)
                                    (v128.const f64x2 0123456789.e-019 0123456789.e-019))
                                    (v128.const f64x2 0x0.0p+0 0x0.0p+0))
(assert_return (invoke "f64x2.pmin" (v128.const f64x2 0x0p+0 0x0p+0)
                                    (v128.const f64x2 0123456789.0123456789 0123456789.0123456789))
                                    (v128.const f64x2 0x0.0p+0 0x0.0p+0))
(assert_return (invoke "f64x2.pmin" (v128.const f64x2 0x0p+0 0x0p+0)
                                    (v128.const f64x2 0123456789.0123456789e019 0123456789.0123456789e019))
                                    (v128.const f64x2 0x0.0p+0 0x0.0p+0))
(assert_return (invoke "f64x2.pmin" (v128.const f64x2 0x0p+0 0x0p+0)
                                    (v128.const f64x2 0123456789.0123456789e+019 0123456789.0123456789e+019))
                                    (v128.const f64x2 0x0.0p+0 0x0.0p+0))
(assert_return (invoke "f64x2.pmin" (v128.const f64x2 0x0p+0 0x0p+0)
                                    (v128.const f64x2 0123456789.0123456789e-019 0123456789.0123456789e-019))
                                    (v128.const f64x2 0x0.0p+0 0x0.0p+0))
(assert_return (invoke "f64x2.pmin" (v128.const f64x2 0x0p+0 0x0p+0)
                                    (v128.const f64x2 0x0123456789ABCDEFabcdef 0x0123456789ABCDEFabcdef))
                                    (v128.const f64x2 0x0.0p+0 0x0.0p+0))
(assert_return (invoke "f64x2.pmin" (v128.const f64x2 0x0p+0 0x0p+0)
                                    (v128.const f64x2 0x0123456789ABCDEFabcdefp019 0x0123456789ABCDEFabcdefp019))
                                    (v128.const f64x2 0x0.0p+0 0x0.0p+0))
(assert_return (invoke "f64x2.pmin" (v128.const f64x2 0x0p+0 0x0p+0)
                                    (v128.const f64x2 0x0123456789ABCDEFabcdefp+019 0x0123456789ABCDEFabcdefp+019))
                                    (v128.const f64x2 0x0.0p+0 0x0.0p+0))
(assert_return (invoke "f64x2.pmin" (v128.const f64x2 0x0p+0 0x0p+0)
                                    (v128.const f64x2 0x0123456789ABCDEFabcdefp-019 0x0123456789ABCDEFabcdefp-019))
                                    (v128.const f64x2 0x0.0p+0 0x0.0p+0))
(assert_return (invoke "f64x2.pmin" (v128.const f64x2 0x0p+0 0x0p+0)
                                    (v128.const f64x2 0x0123456789ABCDEFabcdef. 0x0123456789ABCDEFabcdef.))
                                    (v128.const f64x2 0x0.0p+0 0x0.0p+0))
(assert_return (invoke "f64x2.pmin" (v128.const f64x2 0x0p+0 0x0p+0)
                                    (v128.const f64x2 0x0123456789ABCDEFabcdef.p019 0x0123456789ABCDEFabcdef.p019))
                                    (v128.const f64x2 0x0.0p+0 0x0.0p+0))
(assert_return (invoke "f64x2.pmin" (v128.const f64x2 0x0p+0 0x0p+0)
                                    (v128.const f64x2 0x0123456789ABCDEFabcdef.p+019 0x0123456789ABCDEFabcdef.p+019))
                                    (v128.const f64x2 0x0.0p+0 0x0.0p+0))
(assert_return (invoke "f64x2.pmin" (v128.const f64x2 0x0p+0 0x0p+0)
                                    (v128.const f64x2 0x0123456789ABCDEFabcdef.p-019 0x0123456789ABCDEFabcdef.p-019))
                                    (v128.const f64x2 0x0.0p+0 0x0.0p+0))
(assert_return (invoke "f64x2.pmin" (v128.const f64x2 0x0p+0 0x0p+0)
                                    (v128.const f64x2 0x0123456789ABCDEFabcdef.0123456789ABCDEFabcdef 0x0123456789ABCDEFabcdef.0123456789ABCDEFabcdef))
                                    (v128.const f64x2 0x0.0p+0 0x0.0p+0))
(assert_return (invoke "f64x2.pmin" (v128.const f64x2 0x0p+0 0x0p+0)
                                    (v128.const f64x2 0x0123456789ABCDEFabcdef.0123456789ABCDEFabcdefp019 0x0123456789ABCDEFabcdef.0123456789ABCDEFabcdefp019))
                                    (v128.const f64x2 0x0.0p+0 0x0.0p+0))
(assert_return (invoke "f64x2.pmin" (v128.const f64x2 0x0p+0 0x0p+0)
                                    (v128.const f64x2 0x0123456789ABCDEFabcdef.0123456789ABCDEFabcdefp+019 0x0123456789ABCDEFabcdef.0123456789ABCDEFabcdefp+019))
                                    (v128.const f64x2 0x0.0p+0 0x0.0p+0))
(assert_return (invoke "f64x2.pmin" (v128.const f64x2 0x0p+0 0x0p+0)
                                    (v128.const f64x2 0x0123456789ABCDEFabcdef.0123456789ABCDEFabcdefp-019 0x0123456789ABCDEFabcdef.0123456789ABCDEFabcdefp-019))
                                    (v128.const f64x2 0x0.0p+0 0x0.0p+0))
(assert_return (invoke "f64x2.pmin" (v128.const f64x2 -0x0p+0 -0x0p+0)
                                    (v128.const f64x2 0x0p+0 0x0p+0))
                                    (v128.const f64x2 -0x0.0p+0 -0x0.0p+0))
(assert_return (invoke "f64x2.pmin" (v128.const f64x2 -0x0p+0 -0x0p+0)
                                    (v128.const f64x2 -0x0p+0 -0x0p+0))
                                    (v128.const f64x2 -0x0.0p+0 -0x0.0p+0))
(assert_return (invoke "f64x2.pmin" (v128.const f64x2 -0x0p+0 -0x0p+0)
                                    (v128.const f64x2 0x1p-1022 0x1p-1022))
                                    (v128.const f64x2 -0x0.0p+0 -0x0.0p+0))
(assert_return (invoke "f64x2.pmin" (v128.const f64x2 -0x0p+0 -0x0p+0)
                                    (v128.const f64x2 -0x1p-1022 -0x1p-1022))
                                    (v128.const f64x2 -0x1.0000000000000p-1022 -0x1.0000000000000p-1022))
(assert_return (invoke "f64x2.pmin" (v128.const f64x2 -0x0p+0 -0x0p+0)
                                    (v128.const f64x2 0x1p-1 0x1p-1))
                                    (v128.const f64x2 -0x0.0p+0 -0x0.0p+0))
(assert_return (invoke "f64x2.pmin" (v128.const f64x2 -0x0p+0 -0x0p+0)
                                    (v128.const f64x2 -0x1p-1 -0x1p-1))
                                    (v128.const f64x2 -0x1.0000000000000p-1 -0x1.0000000000000p-1))
(assert_return (invoke "f64x2.pmin" (v128.const f64x2 -0x0p+0 -0x0p+0)
                                    (v128.const f64x2 0x1p+0 0x1p+0))
                                    (v128.const f64x2 -0x0.0p+0 -0x0.0p+0))
(assert_return (invoke "f64x2.pmin" (v128.const f64x2 -0x0p+0 -0x0p+0)
                                    (v128.const f64x2 -0x1p+0 -0x1p+0))
                                    (v128.const f64x2 -0x1.0000000000000p+0 -0x1.0000000000000p+0))
(assert_return (invoke "f64x2.pmin" (v128.const f64x2 -0x0p+0 -0x0p+0)
                                    (v128.const f64x2 0x1.921fb54442d18p+2 0x1.921fb54442d18p+2))
                                    (v128.const f64x2 -0x0.0p+0 -0x0.0p+0))
(assert_return (invoke "f64x2.pmin" (v128.const f64x2 -0x0p+0 -0x0p+0)
                                    (v128.const f64x2 -0x1.921fb54442d18p+2 -0x1.921fb54442d18p+2))
                                    (v128.const f64x2 -0x1.921fb54442d18p+2 -0x1.921fb54442d18p+2))
(assert_return (invoke "f64x2.pmin" (v128.const f64x2 -0x0p+0 -0x0p+0)
                                    (v128.const f64x2 0x1.fffffffffffffp+1023 0x1.fffffffffffffp+1023))
                                    (v128.const f64x2 -0x0.0p+0 -0x0.0p+0))
(assert_return (invoke "f64x2.pmin" (v128.const f64x2 -0x0p+0 -0x0p+0)
                                    (v128.const f64x2 -0x1.fffffffffffffp+1023 -0x1.fffffffffffffp+1023))
                                    (v128.const f64x2 -0x1.fffffffffffffp+1023 -0x1.fffffffffffffp+1023))
(assert_return (invoke "f64x2.pmin" (v128.const f64x2 -0x0p+0 -0x0p+0)
                                    (v128.const f64x2 0x0.0000000000001p-1022 0x0.0000000000001p-1022))
                                    (v128.const f64x2 -0x0.0p+0 -0x0.0p+0))
(assert_return (invoke "f64x2.pmin" (v128.const f64x2 -0x0p+0 -0x0p+0)
                                    (v128.const f64x2 0x0.0000000000001p-1022 0x0.0000000000001p-1022))
                                    (v128.const f64x2 -0x0.0p+0 -0x0.0p+0))
(assert_return (invoke "f64x2.pmin" (v128.const f64x2 -0x0p+0 -0x0p+0)
                                    (v128.const f64x2 inf inf))
                                    (v128.const f64x2 -0x0.0p+0 -0x0.0p+0))
(assert_return (invoke "f64x2.pmin" (v128.const f64x2 -0x0p+0 -0x0p+0)
                                    (v128.const f64x2 -inf -inf))
                                    (v128.const f64x2 -inf -inf))
(assert_return (invoke "f64x2.pmin" (v128.const f64x2 -0x0p+0 -0x0p+0)
                                    (v128.const f64x2 0123456789 0123456789))
                                    (v128.const f64x2 -0x0.0p+0 -0x0.0p+0))
(assert_return (invoke "f64x2.pmin" (v128.const f64x2 -0x0p+0 -0x0p+0)
                                    (v128.const f64x2 0123456789e019 0123456789e019))
                                    (v128.const f64x2 -0x0.0p+0 -0x0.0p+0))
(assert_return (invoke "f64x2.pmin" (v128.const f64x2 -0x0p+0 -0x0p+0)
                                    (v128.const f64x2 0123456789e+019 0123456789e+019))
                                    (v128.const f64x2 -0x0.0p+0 -0x0.0p+0))
(assert_return (invoke "f64x2.pmin" (v128.const f64x2 -0x0p+0 -0x0p+0)
                                    (v128.const f64x2 0123456789e-019 0123456789e-019))
                                    (v128.const f64x2 -0x0.0p+0 -0x0.0p+0))
(assert_return (invoke "f64x2.pmin" (v128.const f64x2 -0x0p+0 -0x0p+0)
                                    (v128.const f64x2 0123456789. 0123456789.))
                                    (v128.const f64x2 -0x0.0p+0 -0x0.0p+0))
(assert_return (invoke "f64x2.pmin" (v128.const f64x2 -0x0p+0 -0x0p+0)
                                    (v128.const f64x2 0123456789.e019 0123456789.e019))
                                    (v128.const f64x2 -0x0.0p+0 -0x0.0p+0))
(assert_return (invoke "f64x2.pmin" (v128.const f64x2 -0x0p+0 -0x0p+0)
                                    (v128.const f64x2 0123456789.e+019 0123456789.e+019))
                                    (v128.const f64x2 -0x0.0p+0 -0x0.0p+0))
(assert_return (invoke "f64x2.pmin" (v128.const f64x2 -0x0p+0 -0x0p+0)
                                    (v128.const f64x2 0123456789.e-019 0123456789.e-019))
                                    (v128.const f64x2 -0x0.0p+0 -0x0.0p+0))
(assert_return (invoke "f64x2.pmin" (v128.const f64x2 -0x0p+0 -0x0p+0)
                                    (v128.const f64x2 0123456789.0123456789 0123456789.0123456789))
                                    (v128.const f64x2 -0x0.0p+0 -0x0.0p+0))
(assert_return (invoke "f64x2.pmin" (v128.const f64x2 -0x0p+0 -0x0p+0)
                                    (v128.const f64x2 0123456789.0123456789e019 0123456789.0123456789e019))
                                    (v128.const f64x2 -0x0.0p+0 -0x0.0p+0))
(assert_return (invoke "f64x2.pmin" (v128.const f64x2 -0x0p+0 -0x0p+0)
                                    (v128.const f64x2 0123456789.0123456789e+019 0123456789.0123456789e+019))
                                    (v128.const f64x2 -0x0.0p+0 -0x0.0p+0))
(assert_return (invoke "f64x2.pmin" (v128.const f64x2 -0x0p+0 -0x0p+0)
                                    (v128.const f64x2 0123456789.0123456789e-019 0123456789.0123456789e-019))
                                    (v128.const f64x2 -0x0.0p+0 -0x0.0p+0))
(assert_return (invoke "f64x2.pmin" (v128.const f64x2 -0x0p+0 -0x0p+0)
                                    (v128.const f64x2 0x0123456789ABCDEFabcdef 0x0123456789ABCDEFabcdef))
                                    (v128.const f64x2 -0x0.0p+0 -0x0.0p+0))
(assert_return (invoke "f64x2.pmin" (v128.const f64x2 -0x0p+0 -0x0p+0)
                                    (v128.const f64x2 0x0123456789ABCDEFabcdefp019 0x0123456789ABCDEFabcdefp019))
                                    (v128.const f64x2 -0x0.0p+0 -0x0.0p+0))
(assert_return (invoke "f64x2.pmin" (v128.const f64x2 -0x0p+0 -0x0p+0)
                                    (v128.const f64x2 0x0123456789ABCDEFabcdefp+019 0x0123456789ABCDEFabcdefp+019))
                                    (v128.const f64x2 -0x0.0p+0 -0x0.0p+0))
(assert_return (invoke "f64x2.pmin" (v128.const f64x2 -0x0p+0 -0x0p+0)
                                    (v128.const f64x2 0x0123456789ABCDEFabcdefp-019 0x0123456789ABCDEFabcdefp-019))
                                    (v128.const f64x2 -0x0.0p+0 -0x0.0p+0))
(assert_return (invoke "f64x2.pmin" (v128.const f64x2 -0x0p+0 -0x0p+0)
                                    (v128.const f64x2 0x0123456789ABCDEFabcdef. 0x0123456789ABCDEFabcdef.))
                                    (v128.const f64x2 -0x0.0p+0 -0x0.0p+0))
(assert_return (invoke "f64x2.pmin" (v128.const f64x2 -0x0p+0 -0x0p+0)
                                    (v128.const f64x2 0x0123456789ABCDEFabcdef.p019 0x0123456789ABCDEFabcdef.p019))
                                    (v128.const f64x2 -0x0.0p+0 -0x0.0p+0))
(assert_return (invoke "f64x2.pmin" (v128.const f64x2 -0x0p+0 -0x0p+0)
                                    (v128.const f64x2 0x0123456789ABCDEFabcdef.p+019 0x0123456789ABCDEFabcdef.p+019))
                                    (v128.const f64x2 -0x0.0p+0 -0x0.0p+0))
(assert_return (invoke "f64x2.pmin" (v128.const f64x2 -0x0p+0 -0x0p+0)
                                    (v128.const f64x2 0x0123456789ABCDEFabcdef.p-019 0x0123456789ABCDEFabcdef.p-019))
                                    (v128.const f64x2 -0x0.0p+0 -0x0.0p+0))
(assert_return (invoke "f64x2.pmin" (v128.const f64x2 -0x0p+0 -0x0p+0)
                                    (v128.const f64x2 0x0123456789ABCDEFabcdef.0123456789ABCDEFabcdef 0x0123456789ABCDEFabcdef.0123456789ABCDEFabcdef))
                                    (v128.const f64x2 -0x0.0p+0 -0x0.0p+0))
(assert_return (invoke "f64x2.pmin" (v128.const f64x2 -0x0p+0 -0x0p+0)
                                    (v128.const f64x2 0x0123456789ABCDEFabcdef.0123456789ABCDEFabcdefp019 0x0123456789ABCDEFabcdef.0123456789ABCDEFabcdefp019))
                                    (v128.const f64x2 -0x0.0p+0 -0x0.0p+0))
(assert_return (invoke "f64x2.pmin" (v128.const f64x2 -0x0p+0 -0x0p+0)
                                    (v128.const f64x2 0x0123456789ABCDEFabcdef.0123456789ABCDEFabcdefp+019 0x0123456789ABCDEFabcdef.0123456789ABCDEFabcdefp+019))
                                    (v128.const f64x2 -0x0.0p+0 -0x0.0p+0))
(assert_return (invoke "f64x2.pmin" (v128.const f64x2 -0x0p+0 -0x0p+0)
                                    (v128.const f64x2 0x0123456789ABCDEFabcdef.0123456789ABCDEFabcdefp-019 0x0123456789ABCDEFabcdef.0123456789ABCDEFabcdefp-019))
                                    (v128.const f64x2 -0x0.0p+0 -0x0.0p+0))
(assert_return (invoke "f64x2.pmin" (v128.const f64x2 0x1p-1022 0x1p-1022)
                                    (v128.const f64x2 0x0p+0 0x0p+0))
                                    (v128.const f64x2 0x0.0p+0 0x0.0p+0))
(assert_return (invoke "f64x2.pmin" (v128.const f64x2 0x1p-1022 0x1p-1022)
                                    (v128.const f64x2 -0x0p+0 -0x0p+0))
                                    (v128.const f64x2 -0x0.0p+0 -0x0.0p+0))
(assert_return (invoke "f64x2.pmin" (v128.const f64x2 0x1p-1022 0x1p-1022)
                                    (v128.const f64x2 0x1p-1022 0x1p-1022))
                                    (v128.const f64x2 0x1.0000000000000p-1022 0x1.0000000000000p-1022))
(assert_return (invoke "f64x2.pmin" (v128.const f64x2 0x1p-1022 0x1p-1022)
                                    (v128.const f64x2 -0x1p-1022 -0x1p-1022))
                                    (v128.const f64x2 -0x1.0000000000000p-1022 -0x1.0000000000000p-1022))
(assert_return (invoke "f64x2.pmin" (v128.const f64x2 0x1p-1022 0x1p-1022)
                                    (v128.const f64x2 0x1p-1 0x1p-1))
                                    (v128.const f64x2 0x1.0000000000000p-1022 0x1.0000000000000p-1022))
(assert_return (invoke "f64x2.pmin" (v128.const f64x2 0x1p-1022 0x1p-1022)
                                    (v128.const f64x2 -0x1p-1 -0x1p-1))
                                    (v128.const f64x2 -0x1.0000000000000p-1 -0x1.0000000000000p-1))
(assert_return (invoke "f64x2.pmin" (v128.const f64x2 0x1p-1022 0x1p-1022)
                                    (v128.const f64x2 0x1p+0 0x1p+0))
                                    (v128.const f64x2 0x1.0000000000000p-1022 0x1.0000000000000p-1022))
(assert_return (invoke "f64x2.pmin" (v128.const f64x2 0x1p-1022 0x1p-1022)
                                    (v128.const f64x2 -0x1p+0 -0x1p+0))
                                    (v128.const f64x2 -0x1.0000000000000p+0 -0x1.0000000000000p+0))
(assert_return (invoke "f64x2.pmin" (v128.const f64x2 0x1p-1022 0x1p-1022)
                                    (v128.const f64x2 0x1.921fb54442d18p+2 0x1.921fb54442d18p+2))
                                    (v128.const f64x2 0x1.0000000000000p-1022 0x1.0000000000000p-1022))
(assert_return (invoke "f64x2.pmin" (v128.const f64x2 0x1p-1022 0x1p-1022)
                                    (v128.const f64x2 -0x1.921fb54442d18p+2 -0x1.921fb54442d18p+2))
                                    (v128.const f64x2 -0x1.921fb54442d18p+2 -0x1.921fb54442d18p+2))
(assert_return (invoke "f64x2.pmin" (v128.const f64x2 0x1p-1022 0x1p-1022)
                                    (v128.const f64x2 0x1.fffffffffffffp+1023 0x1.fffffffffffffp+1023))
                                    (v128.const f64x2 0x1.0000000000000p-1022 0x1.0000000000000p-1022))
(assert_return (invoke "f64x2.pmin" (v128.const f64x2 0x1p-1022 0x1p-1022)
                                    (v128.const f64x2 -0x1.fffffffffffffp+1023 -0x1.fffffffffffffp+1023))
                                    (v128.const f64x2 -0x1.fffffffffffffp+1023 -0x1.fffffffffffffp+1023))
(assert_return (invoke "f64x2.pmin" (v128.const f64x2 0x1p-1022 0x1p-1022)
                                    (v128.const f64x2 0x0.0000000000001p-1022 0x0.0000000000001p-1022))
                                    (v128.const f64x2 0x0.0000000000001p-1022 0x0.0000000000001p-1022))
(assert_return (invoke "f64x2.pmin" (v128.const f64x2 0x1p-1022 0x1p-1022)
                                    (v128.const f64x2 0x0.0000000000001p-1022 0x0.0000000000001p-1022))
                                    (v128.const f64x2 0x0.0000000000001p-1022 0x0.0000000000001p-1022))
(assert_return (invoke "f64x2.pmin" (v128.const f64x2 0x1p-1022 0x1p-1022)
                                    (v128.const f64x2 inf inf))
                                    (v128.const f64x2 0x1.0000000000000p-1022 0x1.0000000000000p-1022))
(assert_return (invoke "f64x2.pmin" (v128.const f64x2 0x1p-1022 0x1p-1022)
                                    (v128.const f64x2 -inf -inf))
                                    (v128.const f64x2 -inf -inf))
(assert_return (invoke "f64x2.pmin" (v128.const f64x2 0x1p-1022 0x1p-1022)
                                    (v128.const f64x2 0123456789 0123456789))
                                    (v128.const f64x2 0x1.0000000000000p-1022 0x1.0000000000000p-1022))
(assert_return (invoke "f64x2.pmin" (v128.const f64x2 0x1p-1022 0x1p-1022)
                                    (v128.const f64x2 0123456789e019 0123456789e019))
                                    (v128.const f64x2 0x1.0000000000000p-1022 0x1.0000000000000p-1022))
(assert_return (invoke "f64x2.pmin" (v128.const f64x2 0x1p-1022 0x1p-1022)
                                    (v128.const f64x2 0123456789e+019 0123456789e+019))
                                    (v128.const f64x2 0x1.0000000000000p-1022 0x1.0000000000000p-1022))
(assert_return (invoke "f64x2.pmin" (v128.const f64x2 0x1p-1022 0x1p-1022)
                                    (v128.const f64x2 0123456789e-019 0123456789e-019))
                                    (v128.const f64x2 0x1.0000000000000p-1022 0x1.0000000000000p-1022))
(assert_return (invoke "f64x2.pmin" (v128.const f64x2 0x1p-1022 0x1p-1022)
                                    (v128.const f64x2 0123456789. 0123456789.))
                                    (v128.const f64x2 0x1.0000000000000p-1022 0x1.0000000000000p-1022))
(assert_return (invoke "f64x2.pmin" (v128.const f64x2 0x1p-1022 0x1p-1022)
                                    (v128.const f64x2 0123456789.e019 0123456789.e019))
                                    (v128.const f64x2 0x1.0000000000000p-1022 0x1.0000000000000p-1022))
(assert_return (invoke "f64x2.pmin" (v128.const f64x2 0x1p-1022 0x1p-1022)
                                    (v128.const f64x2 0123456789.e+019 0123456789.e+019))
                                    (v128.const f64x2 0x1.0000000000000p-1022 0x1.0000000000000p-1022))
(assert_return (invoke "f64x2.pmin" (v128.const f64x2 0x1p-1022 0x1p-1022)
                                    (v128.const f64x2 0123456789.e-019 0123456789.e-019))
                                    (v128.const f64x2 0x1.0000000000000p-1022 0x1.0000000000000p-1022))
(assert_return (invoke "f64x2.pmin" (v128.const f64x2 0x1p-1022 0x1p-1022)
                                    (v128.const f64x2 0123456789.0123456789 0123456789.0123456789))
                                    (v128.const f64x2 0x1.0000000000000p-1022 0x1.0000000000000p-1022))
(assert_return (invoke "f64x2.pmin" (v128.const f64x2 0x1p-1022 0x1p-1022)
                                    (v128.const f64x2 0123456789.0123456789e019 0123456789.0123456789e019))
                                    (v128.const f64x2 0x1.0000000000000p-1022 0x1.0000000000000p-1022))
(assert_return (invoke "f64x2.pmin" (v128.const f64x2 0x1p-1022 0x1p-1022)
                                    (v128.const f64x2 0123456789.0123456789e+019 0123456789.0123456789e+019))
                                    (v128.const f64x2 0x1.0000000000000p-1022 0x1.0000000000000p-1022))
(assert_return (invoke "f64x2.pmin" (v128.const f64x2 0x1p-1022 0x1p-1022)
                                    (v128.const f64x2 0123456789.0123456789e-019 0123456789.0123456789e-019))
                                    (v128.const f64x2 0x1.0000000000000p-1022 0x1.0000000000000p-1022))
(assert_return (invoke "f64x2.pmin" (v128.const f64x2 0x1p-1022 0x1p-1022)
                                    (v128.const f64x2 0x0123456789ABCDEFabcdef 0x0123456789ABCDEFabcdef))
                                    (v128.const f64x2 0x1.0000000000000p-1022 0x1.0000000000000p-1022))
(assert_return (invoke "f64x2.pmin" (v128.const f64x2 0x1p-1022 0x1p-1022)
                                    (v128.const f64x2 0x0123456789ABCDEFabcdefp019 0x0123456789ABCDEFabcdefp019))
                                    (v128.const f64x2 0x1.0000000000000p-1022 0x1.0000000000000p-1022))
(assert_return (invoke "f64x2.pmin" (v128.const f64x2 0x1p-1022 0x1p-1022)
                                    (v128.const f64x2 0x0123456789ABCDEFabcdefp+019 0x0123456789ABCDEFabcdefp+019))
                                    (v128.const f64x2 0x1.0000000000000p-1022 0x1.0000000000000p-1022))
(assert_return (invoke "f64x2.pmin" (v128.const f64x2 0x1p-1022 0x1p-1022)
                                    (v128.const f64x2 0x0123456789ABCDEFabcdefp-019 0x0123456789ABCDEFabcdefp-019))
                                    (v128.const f64x2 0x1.0000000000000p-1022 0x1.0000000000000p-1022))
(assert_return (invoke "f64x2.pmin" (v128.const f64x2 0x1p-1022 0x1p-1022)
                                    (v128.const f64x2 0x0123456789ABCDEFabcdef. 0x0123456789ABCDEFabcdef.))
                                    (v128.const f64x2 0x1.0000000000000p-1022 0x1.0000000000000p-1022))
(assert_return (invoke "f64x2.pmin" (v128.const f64x2 0x1p-1022 0x1p-1022)
                                    (v128.const f64x2 0x0123456789ABCDEFabcdef.p019 0x0123456789ABCDEFabcdef.p019))
                                    (v128.const f64x2 0x1.0000000000000p-1022 0x1.0000000000000p-1022))
(assert_return (invoke "f64x2.pmin" (v128.const f64x2 0x1p-1022 0x1p-1022)
                                    (v128.const f64x2 0x0123456789ABCDEFabcdef.p+019 0x0123456789ABCDEFabcdef.p+019))
                                    (v128.const f64x2 0x1.0000000000000p-1022 0x1.0000000000000p-1022))
(assert_return (invoke "f64x2.pmin" (v128.const f64x2 0x1p-1022 0x1p-1022)
                                    (v128.const f64x2 0x0123456789ABCDEFabcdef.p-019 0x0123456789ABCDEFabcdef.p-019))
                                    (v128.const f64x2 0x1.0000000000000p-1022 0x1.0000000000000p-1022))
(assert_return (invoke "f64x2.pmin" (v128.const f64x2 0x1p-1022 0x1p-1022)
                                    (v128.const f64x2 0x0123456789ABCDEFabcdef.0123456789ABCDEFabcdef 0x0123456789ABCDEFabcdef.0123456789ABCDEFabcdef))
                                    (v128.const f64x2 0x1.0000000000000p-1022 0x1.0000000000000p-1022))
(assert_return (invoke "f64x2.pmin" (v128.const f64x2 0x1p-1022 0x1p-1022)
                                    (v128.const f64x2 0x0123456789ABCDEFabcdef.0123456789ABCDEFabcdefp019 0x0123456789ABCDEFabcdef.0123456789ABCDEFabcdefp019))
                                    (v128.const f64x2 0x1.0000000000000p-1022 0x1.0000000000000p-1022))
(assert_return (invoke "f64x2.pmin" (v128.const f64x2 0x1p-1022 0x1p-1022)
                                    (v128.const f64x2 0x0123456789ABCDEFabcdef.0123456789ABCDEFabcdefp+019 0x0123456789ABCDEFabcdef.0123456789ABCDEFabcdefp+019))
                                    (v128.const f64x2 0x1.0000000000000p-1022 0x1.0000000000000p-1022))
(assert_return (invoke "f64x2.pmin" (v128.const f64x2 0x1p-1022 0x1p-1022)
                                    (v128.const f64x2 0x0123456789ABCDEFabcdef.0123456789ABCDEFabcdefp-019 0x0123456789ABCDEFabcdef.0123456789ABCDEFabcdefp-019))
                                    (v128.const f64x2 0x1.0000000000000p-1022 0x1.0000000000000p-1022))
(assert_return (invoke "f64x2.pmin" (v128.const f64x2 -0x1p-1022 -0x1p-1022)
                                    (v128.const f64x2 0x0p+0 0x0p+0))
                                    (v128.const f64x2 -0x1.0000000000000p-1022 -0x1.0000000000000p-1022))
(assert_return (invoke "f64x2.pmin" (v128.const f64x2 -0x1p-1022 -0x1p-1022)
                                    (v128.const f64x2 -0x0p+0 -0x0p+0))
                                    (v128.const f64x2 -0x1.0000000000000p-1022 -0x1.0000000000000p-1022))
(assert_return (invoke "f64x2.pmin" (v128.const f64x2 -0x1p-1022 -0x1p-1022)
                                    (v128.const f64x2 0x1p-1022 0x1p-1022))
                                    (v128.const f64x2 -0x1.0000000000000p-1022 -0x1.0000000000000p-1022))
(assert_return (invoke "f64x2.pmin" (v128.const f64x2 -0x1p-1022 -0x1p-1022)
                                    (v128.const f64x2 -0x1p-1022 -0x1p-1022))
                                    (v128.const f64x2 -0x1.0000000000000p-1022 -0x1.0000000000000p-1022))
(assert_return (invoke "f64x2.pmin" (v128.const f64x2 -0x1p-1022 -0x1p-1022)
                                    (v128.const f64x2 0x1p-1 0x1p-1))
                                    (v128.const f64x2 -0x1.0000000000000p-1022 -0x1.0000000000000p-1022))
(assert_return (invoke "f64x2.pmin" (v128.const f64x2 -0x1p-1022 -0x1p-1022)
                                    (v128.const f64x2 -0x1p-1 -0x1p-1))
                                    (v128.const f64x2 -0x1.0000000000000p-1 -0x1.0000000000000p-1))
(assert_return (invoke "f64x2.pmin" (v128.const f64x2 -0x1p-1022 -0x1p-1022)
                                    (v128.const f64x2 0x1p+0 0x1p+0))
                                    (v128.const f64x2 -0x1.0000000000000p-1022 -0x1.0000000000000p-1022))
(assert_return (invoke "f64x2.pmin" (v128.const f64x2 -0x1p-1022 -0x1p-1022)
                                    (v128.const f64x2 -0x1p+0 -0x1p+0))
                                    (v128.const f64x2 -0x1.0000000000000p+0 -0x1.0000000000000p+0))
(assert_return (invoke "f64x2.pmin" (v128.const f64x2 -0x1p-1022 -0x1p-1022)
                                    (v128.const f64x2 0x1.921fb54442d18p+2 0x1.921fb54442d18p+2))
                                    (v128.const f64x2 -0x1.0000000000000p-1022 -0x1.0000000000000p-1022))
(assert_return (invoke "f64x2.pmin" (v128.const f64x2 -0x1p-1022 -0x1p-1022)
                                    (v128.const f64x2 -0x1.921fb54442d18p+2 -0x1.921fb54442d18p+2))
                                    (v128.const f64x2 -0x1.921fb54442d18p+2 -0x1.921fb54442d18p+2))
(assert_return (invoke "f64x2.pmin" (v128.const f64x2 -0x1p-1022 -0x1p-1022)
                                    (v128.const f64x2 0x1.fffffffffffffp+1023 0x1.fffffffffffffp+1023))
                                    (v128.const f64x2 -0x1.0000000000000p-1022 -0x1.0000000000000p-1022))
(assert_return (invoke "f64x2.pmin" (v128.const f64x2 -0x1p-1022 -0x1p-1022)
                                    (v128.const f64x2 -0x1.fffffffffffffp+1023 -0x1.fffffffffffffp+1023))
                                    (v128.const f64x2 -0x1.fffffffffffffp+1023 -0x1.fffffffffffffp+1023))
(assert_return (invoke "f64x2.pmin" (v128.const f64x2 -0x1p-1022 -0x1p-1022)
                                    (v128.const f64x2 0x0.0000000000001p-1022 0x0.0000000000001p-1022))
                                    (v128.const f64x2 -0x1.0000000000000p-1022 -0x1.0000000000000p-1022))
(assert_return (invoke "f64x2.pmin" (v128.const f64x2 -0x1p-1022 -0x1p-1022)
                                    (v128.const f64x2 0x0.0000000000001p-1022 0x0.0000000000001p-1022))
                                    (v128.const f64x2 -0x1.0000000000000p-1022 -0x1.0000000000000p-1022))
(assert_return (invoke "f64x2.pmin" (v128.const f64x2 -0x1p-1022 -0x1p-1022)
                                    (v128.const f64x2 inf inf))
                                    (v128.const f64x2 -0x1.0000000000000p-1022 -0x1.0000000000000p-1022))
(assert_return (invoke "f64x2.pmin" (v128.const f64x2 -0x1p-1022 -0x1p-1022)
                                    (v128.const f64x2 -inf -inf))
                                    (v128.const f64x2 -inf -inf))
(assert_return (invoke "f64x2.pmin" (v128.const f64x2 -0x1p-1022 -0x1p-1022)
                                    (v128.const f64x2 0123456789 0123456789))
                                    (v128.const f64x2 -0x1.0000000000000p-1022 -0x1.0000000000000p-1022))
(assert_return (invoke "f64x2.pmin" (v128.const f64x2 -0x1p-1022 -0x1p-1022)
                                    (v128.const f64x2 0123456789e019 0123456789e019))
                                    (v128.const f64x2 -0x1.0000000000000p-1022 -0x1.0000000000000p-1022))
(assert_return (invoke "f64x2.pmin" (v128.const f64x2 -0x1p-1022 -0x1p-1022)
                                    (v128.const f64x2 0123456789e+019 0123456789e+019))
                                    (v128.const f64x2 -0x1.0000000000000p-1022 -0x1.0000000000000p-1022))
(assert_return (invoke "f64x2.pmin" (v128.const f64x2 -0x1p-1022 -0x1p-1022)
                                    (v128.const f64x2 0123456789e-019 0123456789e-019))
                                    (v128.const f64x2 -0x1.0000000000000p-1022 -0x1.0000000000000p-1022))
(assert_return (invoke "f64x2.pmin" (v128.const f64x2 -0x1p-1022 -0x1p-1022)
                                    (v128.const f64x2 0123456789. 0123456789.))
                                    (v128.const f64x2 -0x1.0000000000000p-1022 -0x1.0000000000000p-1022))
(assert_return (invoke "f64x2.pmin" (v128.const f64x2 -0x1p-1022 -0x1p-1022)
                                    (v128.const f64x2 0123456789.e019 0123456789.e019))
                                    (v128.const f64x2 -0x1.0000000000000p-1022 -0x1.0000000000000p-1022))
(assert_return (invoke "f64x2.pmin" (v128.const f64x2 -0x1p-1022 -0x1p-1022)
                                    (v128.const f64x2 0123456789.e+019 0123456789.e+019))
                                    (v128.const f64x2 -0x1.0000000000000p-1022 -0x1.0000000000000p-1022))
(assert_return (invoke "f64x2.pmin" (v128.const f64x2 -0x1p-1022 -0x1p-1022)
                                    (v128.const f64x2 0123456789.e-019 0123456789.e-019))
                                    (v128.const f64x2 -0x1.0000000000000p-1022 -0x1.0000000000000p-1022))
(assert_return (invoke "f64x2.pmin" (v128.const f64x2 -0x1p-1022 -0x1p-1022)
                                    (v128.const f64x2 0123456789.0123456789 0123456789.0123456789))
                                    (v128.const f64x2 -0x1.0000000000000p-1022 -0x1.0000000000000p-1022))
(assert_return (invoke "f64x2.pmin" (v128.const f64x2 -0x1p-1022 -0x1p-1022)
                                    (v128.const f64x2 0123456789.0123456789e019 0123456789.0123456789e019))
                                    (v128.const f64x2 -0x1.0000000000000p-1022 -0x1.0000000000000p-1022))
(assert_return (invoke "f64x2.pmin" (v128.const f64x2 -0x1p-1022 -0x1p-1022)
                                    (v128.const f64x2 0123456789.0123456789e+019 0123456789.0123456789e+019))
                                    (v128.const f64x2 -0x1.0000000000000p-1022 -0x1.0000000000000p-1022))
(assert_return (invoke "f64x2.pmin" (v128.const f64x2 -0x1p-1022 -0x1p-1022)
                                    (v128.const f64x2 0123456789.0123456789e-019 0123456789.0123456789e-019))
                                    (v128.const f64x2 -0x1.0000000000000p-1022 -0x1.0000000000000p-1022))
(assert_return (invoke "f64x2.pmin" (v128.const f64x2 -0x1p-1022 -0x1p-1022)
                                    (v128.const f64x2 0x0123456789ABCDEFabcdef 0x0123456789ABCDEFabcdef))
                                    (v128.const f64x2 -0x1.0000000000000p-1022 -0x1.0000000000000p-1022))
(assert_return (invoke "f64x2.pmin" (v128.const f64x2 -0x1p-1022 -0x1p-1022)
                                    (v128.const f64x2 0x0123456789ABCDEFabcdefp019 0x0123456789ABCDEFabcdefp019))
                                    (v128.const f64x2 -0x1.0000000000000p-1022 -0x1.0000000000000p-1022))
(assert_return (invoke "f64x2.pmin" (v128.const f64x2 -0x1p-1022 -0x1p-1022)
                                    (v128.const f64x2 0x0123456789ABCDEFabcdefp+019 0x0123456789ABCDEFabcdefp+019))
                                    (v128.const f64x2 -0x1.0000000000000p-1022 -0x1.0000000000000p-1022))
(assert_return (invoke "f64x2.pmin" (v128.const f64x2 -0x1p-1022 -0x1p-1022)
                                    (v128.const f64x2 0x0123456789ABCDEFabcdefp-019 0x0123456789ABCDEFabcdefp-019))
                                    (v128.const f64x2 -0x1.0000000000000p-1022 -0x1.0000000000000p-1022))
(assert_return (invoke "f64x2.pmin" (v128.const f64x2 -0x1p-1022 -0x1p-1022)
                                    (v128.const f64x2 0x0123456789ABCDEFabcdef. 0x0123456789ABCDEFabcdef.))
                                    (v128.const f64x2 -0x1.0000000000000p-1022 -0x1.0000000000000p-1022))
(assert_return (invoke "f64x2.pmin" (v128.const f64x2 -0x1p-1022 -0x1p-1022)
                                    (v128.const f64x2 0x0123456789ABCDEFabcdef.p019 0x0123456789ABCDEFabcdef.p019))
                                    (v128.const f64x2 -0x1.0000000000000p-1022 -0x1.0000000000000p-1022))
(assert_return (invoke "f64x2.pmin" (v128.const f64x2 -0x1p-1022 -0x1p-1022)
                                    (v128.const f64x2 0x0123456789ABCDEFabcdef.p+019 0x0123456789ABCDEFabcdef.p+019))
                                    (v128.const f64x2 -0x1.0000000000000p-1022 -0x1.0000000000000p-1022))
(assert_return (invoke "f64x2.pmin" (v128.const f64x2 -0x1p-1022 -0x1p-1022)
                                    (v128.const f64x2 0x0123456789ABCDEFabcdef.p-019 0x0123456789ABCDEFabcdef.p-019))
                                    (v128.const f64x2 -0x1.0000000000000p-1022 -0x1.0000000000000p-1022))
(assert_return (invoke "f64x2.pmin" (v128.const f64x2 -0x1p-1022 -0x1p-1022)
                                    (v128.const f64x2 0x0123456789ABCDEFabcdef.0123456789ABCDEFabcdef 0x0123456789ABCDEFabcdef.0123456789ABCDEFabcdef))
                                    (v128.const f64x2 -0x1.0000000000000p-1022 -0x1.0000000000000p-1022))
(assert_return (invoke "f64x2.pmin" (v128.const f64x2 -0x1p-1022 -0x1p-1022)
                                    (v128.const f64x2 0x0123456789ABCDEFabcdef.0123456789ABCDEFabcdefp019 0x0123456789ABCDEFabcdef.0123456789ABCDEFabcdefp019))
                                    (v128.const f64x2 -0x1.0000000000000p-1022 -0x1.0000000000000p-1022))
(assert_return (invoke "f64x2.pmin" (v128.const f64x2 -0x1p-1022 -0x1p-1022)
                                    (v128.const f64x2 0x0123456789ABCDEFabcdef.0123456789ABCDEFabcdefp+019 0x0123456789ABCDEFabcdef.0123456789ABCDEFabcdefp+019))
                                    (v128.const f64x2 -0x1.0000000000000p-1022 -0x1.0000000000000p-1022))
(assert_return (invoke "f64x2.pmin" (v128.const f64x2 -0x1p-1022 -0x1p-1022)
                                    (v128.const f64x2 0x0123456789ABCDEFabcdef.0123456789ABCDEFabcdefp-019 0x0123456789ABCDEFabcdef.0123456789ABCDEFabcdefp-019))
                                    (v128.const f64x2 -0x1.0000000000000p-1022 -0x1.0000000000000p-1022))
(assert_return (invoke "f64x2.pmin" (v128.const f64x2 0x1p-1 0x1p-1)
                                    (v128.const f64x2 0x0p+0 0x0p+0))
                                    (v128.const f64x2 0x0.0p+0 0x0.0p+0))
(assert_return (invoke "f64x2.pmin" (v128.const f64x2 0x1p-1 0x1p-1)
                                    (v128.const f64x2 -0x0p+0 -0x0p+0))
                                    (v128.const f64x2 -0x0.0p+0 -0x0.0p+0))
(assert_return (invoke "f64x2.pmin" (v128.const f64x2 0x1p-1 0x1p-1)
                                    (v128.const f64x2 0x1p-1022 0x1p-1022))
                                    (v128.const f64x2 0x1.0000000000000p-1022 0x1.0000000000000p-1022))
(assert_return (invoke "f64x2.pmin" (v128.const f64x2 0x1p-1 0x1p-1)
                                    (v128.const f64x2 -0x1p-1022 -0x1p-1022))
                                    (v128.const f64x2 -0x1.0000000000000p-1022 -0x1.0000000000000p-1022))
(assert_return (invoke "f64x2.pmin" (v128.const f64x2 0x1p-1 0x1p-1)
                                    (v128.const f64x2 0x1p-1 0x1p-1))
                                    (v128.const f64x2 0x1.0000000000000p-1 0x1.0000000000000p-1))
(assert_return (invoke "f64x2.pmin" (v128.const f64x2 0x1p-1 0x1p-1)
                                    (v128.const f64x2 -0x1p-1 -0x1p-1))
                                    (v128.const f64x2 -0x1.0000000000000p-1 -0x1.0000000000000p-1))
(assert_return (invoke "f64x2.pmin" (v128.const f64x2 0x1p-1 0x1p-1)
                                    (v128.const f64x2 0x1p+0 0x1p+0))
                                    (v128.const f64x2 0x1.0000000000000p-1 0x1.0000000000000p-1))
(assert_return (invoke "f64x2.pmin" (v128.const f64x2 0x1p-1 0x1p-1)
                                    (v128.const f64x2 -0x1p+0 -0x1p+0))
                                    (v128.const f64x2 -0x1.0000000000000p+0 -0x1.0000000000000p+0))
(assert_return (invoke "f64x2.pmin" (v128.const f64x2 0x1p-1 0x1p-1)
                                    (v128.const f64x2 0x1.921fb54442d18p+2 0x1.921fb54442d18p+2))
                                    (v128.const f64x2 0x1.0000000000000p-1 0x1.0000000000000p-1))
(assert_return (invoke "f64x2.pmin" (v128.const f64x2 0x1p-1 0x1p-1)
                                    (v128.const f64x2 -0x1.921fb54442d18p+2 -0x1.921fb54442d18p+2))
                                    (v128.const f64x2 -0x1.921fb54442d18p+2 -0x1.921fb54442d18p+2))
(assert_return (invoke "f64x2.pmin" (v128.const f64x2 0x1p-1 0x1p-1)
                                    (v128.const f64x2 0x1.fffffffffffffp+1023 0x1.fffffffffffffp+1023))
                                    (v128.const f64x2 0x1.0000000000000p-1 0x1.0000000000000p-1))
(assert_return (invoke "f64x2.pmin" (v128.const f64x2 0x1p-1 0x1p-1)
                                    (v128.const f64x2 -0x1.fffffffffffffp+1023 -0x1.fffffffffffffp+1023))
                                    (v128.const f64x2 -0x1.fffffffffffffp+1023 -0x1.fffffffffffffp+1023))
(assert_return (invoke "f64x2.pmin" (v128.const f64x2 0x1p-1 0x1p-1)
                                    (v128.const f64x2 0x0.0000000000001p-1022 0x0.0000000000001p-1022))
                                    (v128.const f64x2 0x0.0000000000001p-1022 0x0.0000000000001p-1022))
(assert_return (invoke "f64x2.pmin" (v128.const f64x2 0x1p-1 0x1p-1)
                                    (v128.const f64x2 0x0.0000000000001p-1022 0x0.0000000000001p-1022))
                                    (v128.const f64x2 0x0.0000000000001p-1022 0x0.0000000000001p-1022))
(assert_return (invoke "f64x2.pmin" (v128.const f64x2 0x1p-1 0x1p-1)
                                    (v128.const f64x2 inf inf))
                                    (v128.const f64x2 0x1.0000000000000p-1 0x1.0000000000000p-1))
(assert_return (invoke "f64x2.pmin" (v128.const f64x2 0x1p-1 0x1p-1)
                                    (v128.const f64x2 -inf -inf))
                                    (v128.const f64x2 -inf -inf))
(assert_return (invoke "f64x2.pmin" (v128.const f64x2 0x1p-1 0x1p-1)
                                    (v128.const f64x2 0123456789 0123456789))
                                    (v128.const f64x2 0x1.0000000000000p-1 0x1.0000000000000p-1))
(assert_return (invoke "f64x2.pmin" (v128.const f64x2 0x1p-1 0x1p-1)
                                    (v128.const f64x2 0123456789e019 0123456789e019))
                                    (v128.const f64x2 0x1.0000000000000p-1 0x1.0000000000000p-1))
(assert_return (invoke "f64x2.pmin" (v128.const f64x2 0x1p-1 0x1p-1)
                                    (v128.const f64x2 0123456789e+019 0123456789e+019))
                                    (v128.const f64x2 0x1.0000000000000p-1 0x1.0000000000000p-1))
(assert_return (invoke "f64x2.pmin" (v128.const f64x2 0x1p-1 0x1p-1)
                                    (v128.const f64x2 0123456789e-019 0123456789e-019))
                                    (v128.const f64x2 0x1.b25ffd62b4311p-37 0x1.b25ffd62b4311p-37))
(assert_return (invoke "f64x2.pmin" (v128.const f64x2 0x1p-1 0x1p-1)
                                    (v128.const f64x2 0123456789. 0123456789.))
                                    (v128.const f64x2 0x1.0000000000000p-1 0x1.0000000000000p-1))
(assert_return (invoke "f64x2.pmin" (v128.const f64x2 0x1p-1 0x1p-1)
                                    (v128.const f64x2 0123456789.e019 0123456789.e019))
                                    (v128.const f64x2 0x1.0000000000000p-1 0x1.0000000000000p-1))
(assert_return (invoke "f64x2.pmin" (v128.const f64x2 0x1p-1 0x1p-1)
                                    (v128.const f64x2 0123456789.e+019 0123456789.e+019))
                                    (v128.const f64x2 0x1.0000000000000p-1 0x1.0000000000000p-1))
(assert_return (invoke "f64x2.pmin" (v128.const f64x2 0x1p-1 0x1p-1)
                                    (v128.const f64x2 0123456789.e-019 0123456789.e-019))
                                    (v128.const f64x2 0x1.b25ffd62b4311p-37 0x1.b25ffd62b4311p-37))
(assert_return (invoke "f64x2.pmin" (v128.const f64x2 0x1p-1 0x1p-1)
                                    (v128.const f64x2 0123456789.0123456789 0123456789.0123456789))
                                    (v128.const f64x2 0x1.0000000000000p-1 0x1.0000000000000p-1))
(assert_return (invoke "f64x2.pmin" (v128.const f64x2 0x1p-1 0x1p-1)
                                    (v128.const f64x2 0123456789.0123456789e019 0123456789.0123456789e019))
                                    (v128.const f64x2 0x1.0000000000000p-1 0x1.0000000000000p-1))
(assert_return (invoke "f64x2.pmin" (v128.const f64x2 0x1p-1 0x1p-1)
                                    (v128.const f64x2 0123456789.0123456789e+019 0123456789.0123456789e+019))
                                    (v128.const f64x2 0x1.0000000000000p-1 0x1.0000000000000p-1))
(assert_return (invoke "f64x2.pmin" (v128.const f64x2 0x1p-1 0x1p-1)
                                    (v128.const f64x2 0123456789.0123456789e-019 0123456789.0123456789e-019))
                                    (v128.const f64x2 0x1.b25ffd636ec12p-37 0x1.b25ffd636ec12p-37))
(assert_return (invoke "f64x2.pmin" (v128.const f64x2 0x1p-1 0x1p-1)
                                    (v128.const f64x2 0x0123456789ABCDEFabcdef 0x0123456789ABCDEFabcdef))
                                    (v128.const f64x2 0x1.0000000000000p-1 0x1.0000000000000p-1))
(assert_return (invoke "f64x2.pmin" (v128.const f64x2 0x1p-1 0x1p-1)
                                    (v128.const f64x2 0x0123456789ABCDEFabcdefp019 0x0123456789ABCDEFabcdefp019))
                                    (v128.const f64x2 0x1.0000000000000p-1 0x1.0000000000000p-1))
(assert_return (invoke "f64x2.pmin" (v128.const f64x2 0x1p-1 0x1p-1)
                                    (v128.const f64x2 0x0123456789ABCDEFabcdefp+019 0x0123456789ABCDEFabcdefp+019))
                                    (v128.const f64x2 0x1.0000000000000p-1 0x1.0000000000000p-1))
(assert_return (invoke "f64x2.pmin" (v128.const f64x2 0x1p-1 0x1p-1)
                                    (v128.const f64x2 0x0123456789ABCDEFabcdefp-019 0x0123456789ABCDEFabcdefp-019))
                                    (v128.const f64x2 0x1.0000000000000p-1 0x1.0000000000000p-1))
(assert_return (invoke "f64x2.pmin" (v128.const f64x2 0x1p-1 0x1p-1)
                                    (v128.const f64x2 0x0123456789ABCDEFabcdef. 0x0123456789ABCDEFabcdef.))
                                    (v128.const f64x2 0x1.0000000000000p-1 0x1.0000000000000p-1))
(assert_return (invoke "f64x2.pmin" (v128.const f64x2 0x1p-1 0x1p-1)
                                    (v128.const f64x2 0x0123456789ABCDEFabcdef.p019 0x0123456789ABCDEFabcdef.p019))
                                    (v128.const f64x2 0x1.0000000000000p-1 0x1.0000000000000p-1))
(assert_return (invoke "f64x2.pmin" (v128.const f64x2 0x1p-1 0x1p-1)
                                    (v128.const f64x2 0x0123456789ABCDEFabcdef.p+019 0x0123456789ABCDEFabcdef.p+019))
                                    (v128.const f64x2 0x1.0000000000000p-1 0x1.0000000000000p-1))
(assert_return (invoke "f64x2.pmin" (v128.const f64x2 0x1p-1 0x1p-1)
                                    (v128.const f64x2 0x0123456789ABCDEFabcdef.p-019 0x0123456789ABCDEFabcdef.p-019))
                                    (v128.const f64x2 0x1.0000000000000p-1 0x1.0000000000000p-1))
(assert_return (invoke "f64x2.pmin" (v128.const f64x2 0x1p-1 0x1p-1)
                                    (v128.const f64x2 0x0123456789ABCDEFabcdef.0123456789ABCDEFabcdef 0x0123456789ABCDEFabcdef.0123456789ABCDEFabcdef))
                                    (v128.const f64x2 0x1.0000000000000p-1 0x1.0000000000000p-1))
(assert_return (invoke "f64x2.pmin" (v128.const f64x2 0x1p-1 0x1p-1)
                                    (v128.const f64x2 0x0123456789ABCDEFabcdef.0123456789ABCDEFabcdefp019 0x0123456789ABCDEFabcdef.0123456789ABCDEFabcdefp019))
                                    (v128.const f64x2 0x1.0000000000000p-1 0x1.0000000000000p-1))
(assert_return (invoke "f64x2.pmin" (v128.const f64x2 0x1p-1 0x1p-1)
                                    (v128.const f64x2 0x0123456789ABCDEFabcdef.0123456789ABCDEFabcdefp+019 0x0123456789ABCDEFabcdef.0123456789ABCDEFabcdefp+019))
                                    (v128.const f64x2 0x1.0000000000000p-1 0x1.0000000000000p-1))
(assert_return (invoke "f64x2.pmin" (v128.const f64x2 0x1p-1 0x1p-1)
                                    (v128.const f64x2 0x0123456789ABCDEFabcdef.0123456789ABCDEFabcdefp-019 0x0123456789ABCDEFabcdef.0123456789ABCDEFabcdefp-019))
                                    (v128.const f64x2 0x1.0000000000000p-1 0x1.0000000000000p-1))
(assert_return (invoke "f64x2.pmin" (v128.const f64x2 -0x1p-1 -0x1p-1)
                                    (v128.const f64x2 0x0p+0 0x0p+0))
                                    (v128.const f64x2 -0x1.0000000000000p-1 -0x1.0000000000000p-1))
(assert_return (invoke "f64x2.pmin" (v128.const f64x2 -0x1p-1 -0x1p-1)
                                    (v128.const f64x2 -0x0p+0 -0x0p+0))
                                    (v128.const f64x2 -0x1.0000000000000p-1 -0x1.0000000000000p-1))
(assert_return (invoke "f64x2.pmin" (v128.const f64x2 -0x1p-1 -0x1p-1)
                                    (v128.const f64x2 0x1p-1022 0x1p-1022))
                                    (v128.const f64x2 -0x1.0000000000000p-1 -0x1.0000000000000p-1))
(assert_return (invoke "f64x2.pmin" (v128.const f64x2 -0x1p-1 -0x1p-1)
                                    (v128.const f64x2 -0x1p-1022 -0x1p-1022))
                                    (v128.const f64x2 -0x1.0000000000000p-1 -0x1.0000000000000p-1))
(assert_return (invoke "f64x2.pmin" (v128.const f64x2 -0x1p-1 -0x1p-1)
                                    (v128.const f64x2 0x1p-1 0x1p-1))
                                    (v128.const f64x2 -0x1.0000000000000p-1 -0x1.0000000000000p-1))
(assert_return (invoke "f64x2.pmin" (v128.const f64x2 -0x1p-1 -0x1p-1)
                                    (v128.const f64x2 -0x1p-1 -0x1p-1))
                                    (v128.const f64x2 -0x1.0000000000000p-1 -0x1.0000000000000p-1))
(assert_return (invoke "f64x2.pmin" (v128.const f64x2 -0x1p-1 -0x1p-1)
                                    (v128.const f64x2 0x1p+0 0x1p+0))
                                    (v128.const f64x2 -0x1.0000000000000p-1 -0x1.0000000000000p-1))
(assert_return (invoke "f64x2.pmin" (v128.const f64x2 -0x1p-1 -0x1p-1)
                                    (v128.const f64x2 -0x1p+0 -0x1p+0))
                                    (v128.const f64x2 -0x1.0000000000000p+0 -0x1.0000000000000p+0))
(assert_return (invoke "f64x2.pmin" (v128.const f64x2 -0x1p-1 -0x1p-1)
                                    (v128.const f64x2 0x1.921fb54442d18p+2 0x1.921fb54442d18p+2))
                                    (v128.const f64x2 -0x1.0000000000000p-1 -0x1.0000000000000p-1))
(assert_return (invoke "f64x2.pmin" (v128.const f64x2 -0x1p-1 -0x1p-1)
                                    (v128.const f64x2 -0x1.921fb54442d18p+2 -0x1.921fb54442d18p+2))
                                    (v128.const f64x2 -0x1.921fb54442d18p+2 -0x1.921fb54442d18p+2))
(assert_return (invoke "f64x2.pmin" (v128.const f64x2 -0x1p-1 -0x1p-1)
                                    (v128.const f64x2 0x1.fffffffffffffp+1023 0x1.fffffffffffffp+1023))
                                    (v128.const f64x2 -0x1.0000000000000p-1 -0x1.0000000000000p-1))
(assert_return (invoke "f64x2.pmin" (v128.const f64x2 -0x1p-1 -0x1p-1)
                                    (v128.const f64x2 -0x1.fffffffffffffp+1023 -0x1.fffffffffffffp+1023))
                                    (v128.const f64x2 -0x1.fffffffffffffp+1023 -0x1.fffffffffffffp+1023))
(assert_return (invoke "f64x2.pmin" (v128.const f64x2 -0x1p-1 -0x1p-1)
                                    (v128.const f64x2 0x0.0000000000001p-1022 0x0.0000000000001p-1022))
                                    (v128.const f64x2 -0x1.0000000000000p-1 -0x1.0000000000000p-1))
(assert_return (invoke "f64x2.pmin" (v128.const f64x2 -0x1p-1 -0x1p-1)
                                    (v128.const f64x2 0x0.0000000000001p-1022 0x0.0000000000001p-1022))
                                    (v128.const f64x2 -0x1.0000000000000p-1 -0x1.0000000000000p-1))
(assert_return (invoke "f64x2.pmin" (v128.const f64x2 -0x1p-1 -0x1p-1)
                                    (v128.const f64x2 inf inf))
                                    (v128.const f64x2 -0x1.0000000000000p-1 -0x1.0000000000000p-1))
(assert_return (invoke "f64x2.pmin" (v128.const f64x2 -0x1p-1 -0x1p-1)
                                    (v128.const f64x2 -inf -inf))
                                    (v128.const f64x2 -inf -inf))
(assert_return (invoke "f64x2.pmin" (v128.const f64x2 -0x1p-1 -0x1p-1)
                                    (v128.const f64x2 0123456789 0123456789))
                                    (v128.const f64x2 -0x1.0000000000000p-1 -0x1.0000000000000p-1))
(assert_return (invoke "f64x2.pmin" (v128.const f64x2 -0x1p-1 -0x1p-1)
                                    (v128.const f64x2 0123456789e019 0123456789e019))
                                    (v128.const f64x2 -0x1.0000000000000p-1 -0x1.0000000000000p-1))
(assert_return (invoke "f64x2.pmin" (v128.const f64x2 -0x1p-1 -0x1p-1)
                                    (v128.const f64x2 0123456789e+019 0123456789e+019))
                                    (v128.const f64x2 -0x1.0000000000000p-1 -0x1.0000000000000p-1))
(assert_return (invoke "f64x2.pmin" (v128.const f64x2 -0x1p-1 -0x1p-1)
                                    (v128.const f64x2 0123456789e-019 0123456789e-019))
                                    (v128.const f64x2 -0x1.0000000000000p-1 -0x1.0000000000000p-1))
(assert_return (invoke "f64x2.pmin" (v128.const f64x2 -0x1p-1 -0x1p-1)
                                    (v128.const f64x2 0123456789. 0123456789.))
                                    (v128.const f64x2 -0x1.0000000000000p-1 -0x1.0000000000000p-1))
(assert_return (invoke "f64x2.pmin" (v128.const f64x2 -0x1p-1 -0x1p-1)
                                    (v128.const f64x2 0123456789.e019 0123456789.e019))
                                    (v128.const f64x2 -0x1.0000000000000p-1 -0x1.0000000000000p-1))
(assert_return (invoke "f64x2.pmin" (v128.const f64x2 -0x1p-1 -0x1p-1)
                                    (v128.const f64x2 0123456789.e+019 0123456789.e+019))
                                    (v128.const f64x2 -0x1.0000000000000p-1 -0x1.0000000000000p-1))
(assert_return (invoke "f64x2.pmin" (v128.const f64x2 -0x1p-1 -0x1p-1)
                                    (v128.const f64x2 0123456789.e-019 0123456789.e-019))
                                    (v128.const f64x2 -0x1.0000000000000p-1 -0x1.0000000000000p-1))
(assert_return (invoke "f64x2.pmin" (v128.const f64x2 -0x1p-1 -0x1p-1)
                                    (v128.const f64x2 0123456789.0123456789 0123456789.0123456789))
                                    (v128.const f64x2 -0x1.0000000000000p-1 -0x1.0000000000000p-1))
(assert_return (invoke "f64x2.pmin" (v128.const f64x2 -0x1p-1 -0x1p-1)
                                    (v128.const f64x2 0123456789.0123456789e019 0123456789.0123456789e019))
                                    (v128.const f64x2 -0x1.0000000000000p-1 -0x1.0000000000000p-1))
(assert_return (invoke "f64x2.pmin" (v128.const f64x2 -0x1p-1 -0x1p-1)
                                    (v128.const f64x2 0123456789.0123456789e+019 0123456789.0123456789e+019))
                                    (v128.const f64x2 -0x1.0000000000000p-1 -0x1.0000000000000p-1))
(assert_return (invoke "f64x2.pmin" (v128.const f64x2 -0x1p-1 -0x1p-1)
                                    (v128.const f64x2 0123456789.0123456789e-019 0123456789.0123456789e-019))
                                    (v128.const f64x2 -0x1.0000000000000p-1 -0x1.0000000000000p-1))
(assert_return (invoke "f64x2.pmin" (v128.const f64x2 -0x1p-1 -0x1p-1)
                                    (v128.const f64x2 0x0123456789ABCDEFabcdef 0x0123456789ABCDEFabcdef))
                                    (v128.const f64x2 -0x1.0000000000000p-1 -0x1.0000000000000p-1))
(assert_return (invoke "f64x2.pmin" (v128.const f64x2 -0x1p-1 -0x1p-1)
                                    (v128.const f64x2 0x0123456789ABCDEFabcdefp019 0x0123456789ABCDEFabcdefp019))
                                    (v128.const f64x2 -0x1.0000000000000p-1 -0x1.0000000000000p-1))
(assert_return (invoke "f64x2.pmin" (v128.const f64x2 -0x1p-1 -0x1p-1)
                                    (v128.const f64x2 0x0123456789ABCDEFabcdefp+019 0x0123456789ABCDEFabcdefp+019))
                                    (v128.const f64x2 -0x1.0000000000000p-1 -0x1.0000000000000p-1))
(assert_return (invoke "f64x2.pmin" (v128.const f64x2 -0x1p-1 -0x1p-1)
                                    (v128.const f64x2 0x0123456789ABCDEFabcdefp-019 0x0123456789ABCDEFabcdefp-019))
                                    (v128.const f64x2 -0x1.0000000000000p-1 -0x1.0000000000000p-1))
(assert_return (invoke "f64x2.pmin" (v128.const f64x2 -0x1p-1 -0x1p-1)
                                    (v128.const f64x2 0x0123456789ABCDEFabcdef. 0x0123456789ABCDEFabcdef.))
                                    (v128.const f64x2 -0x1.0000000000000p-1 -0x1.0000000000000p-1))
(assert_return (invoke "f64x2.pmin" (v128.const f64x2 -0x1p-1 -0x1p-1)
                                    (v128.const f64x2 0x0123456789ABCDEFabcdef.p019 0x0123456789ABCDEFabcdef.p019))
                                    (v128.const f64x2 -0x1.0000000000000p-1 -0x1.0000000000000p-1))
(assert_return (invoke "f64x2.pmin" (v128.const f64x2 -0x1p-1 -0x1p-1)
                                    (v128.const f64x2 0x0123456789ABCDEFabcdef.p+019 0x0123456789ABCDEFabcdef.p+019))
                                    (v128.const f64x2 -0x1.0000000000000p-1 -0x1.0000000000000p-1))
(assert_return (invoke "f64x2.pmin" (v128.const f64x2 -0x1p-1 -0x1p-1)
                                    (v128.const f64x2 0x0123456789ABCDEFabcdef.p-019 0x0123456789ABCDEFabcdef.p-019))
                                    (v128.const f64x2 -0x1.0000000000000p-1 -0x1.0000000000000p-1))
(assert_return (invoke "f64x2.pmin" (v128.const f64x2 -0x1p-1 -0x1p-1)
                                    (v128.const f64x2 0x0123456789ABCDEFabcdef.0123456789ABCDEFabcdef 0x0123456789ABCDEFabcdef.0123456789ABCDEFabcdef))
                                    (v128.const f64x2 -0x1.0000000000000p-1 -0x1.0000000000000p-1))
(assert_return (invoke "f64x2.pmin" (v128.const f64x2 -0x1p-1 -0x1p-1)
                                    (v128.const f64x2 0x0123456789ABCDEFabcdef.0123456789ABCDEFabcdefp019 0x0123456789ABCDEFabcdef.0123456789ABCDEFabcdefp019))
                                    (v128.const f64x2 -0x1.0000000000000p-1 -0x1.0000000000000p-1))
(assert_return (invoke "f64x2.pmin" (v128.const f64x2 -0x1p-1 -0x1p-1)
                                    (v128.const f64x2 0x0123456789ABCDEFabcdef.0123456789ABCDEFabcdefp+019 0x0123456789ABCDEFabcdef.0123456789ABCDEFabcdefp+019))
                                    (v128.const f64x2 -0x1.0000000000000p-1 -0x1.0000000000000p-1))
(assert_return (invoke "f64x2.pmin" (v128.const f64x2 -0x1p-1 -0x1p-1)
                                    (v128.const f64x2 0x0123456789ABCDEFabcdef.0123456789ABCDEFabcdefp-019 0x0123456789ABCDEFabcdef.0123456789ABCDEFabcdefp-019))
                                    (v128.const f64x2 -0x1.0000000000000p-1 -0x1.0000000000000p-1))
(assert_return (invoke "f64x2.pmin" (v128.const f64x2 0x1p+0 0x1p+0)
                                    (v128.const f64x2 0x0p+0 0x0p+0))
                                    (v128.const f64x2 0x0.0p+0 0x0.0p+0))
(assert_return (invoke "f64x2.pmin" (v128.const f64x2 0x1p+0 0x1p+0)
                                    (v128.const f64x2 -0x0p+0 -0x0p+0))
                                    (v128.const f64x2 -0x0.0p+0 -0x0.0p+0))
(assert_return (invoke "f64x2.pmin" (v128.const f64x2 0x1p+0 0x1p+0)
                                    (v128.const f64x2 0x1p-1022 0x1p-1022))
                                    (v128.const f64x2 0x1.0000000000000p-1022 0x1.0000000000000p-1022))
(assert_return (invoke "f64x2.pmin" (v128.const f64x2 0x1p+0 0x1p+0)
                                    (v128.const f64x2 -0x1p-1022 -0x1p-1022))
                                    (v128.const f64x2 -0x1.0000000000000p-1022 -0x1.0000000000000p-1022))
(assert_return (invoke "f64x2.pmin" (v128.const f64x2 0x1p+0 0x1p+0)
                                    (v128.const f64x2 0x1p-1 0x1p-1))
                                    (v128.const f64x2 0x1.0000000000000p-1 0x1.0000000000000p-1))
(assert_return (invoke "f64x2.pmin" (v128.const f64x2 0x1p+0 0x1p+0)
                                    (v128.const f64x2 -0x1p-1 -0x1p-1))
                                    (v128.const f64x2 -0x1.0000000000000p-1 -0x1.0000000000000p-1))
(assert_return (invoke "f64x2.pmin" (v128.const f64x2 0x1p+0 0x1p+0)
                                    (v128.const f64x2 0x1p+0 0x1p+0))
                                    (v128.const f64x2 0x1.0000000000000p+0 0x1.0000000000000p+0))
(assert_return (invoke "f64x2.pmin" (v128.const f64x2 0x1p+0 0x1p+0)
                                    (v128.const f64x2 -0x1p+0 -0x1p+0))
                                    (v128.const f64x2 -0x1.0000000000000p+0 -0x1.0000000000000p+0))
(assert_return (invoke "f64x2.pmin" (v128.const f64x2 0x1p+0 0x1p+0)
                                    (v128.const f64x2 0x1.921fb54442d18p+2 0x1.921fb54442d18p+2))
                                    (v128.const f64x2 0x1.0000000000000p+0 0x1.0000000000000p+0))
(assert_return (invoke "f64x2.pmin" (v128.const f64x2 0x1p+0 0x1p+0)
                                    (v128.const f64x2 -0x1.921fb54442d18p+2 -0x1.921fb54442d18p+2))
                                    (v128.const f64x2 -0x1.921fb54442d18p+2 -0x1.921fb54442d18p+2))
(assert_return (invoke "f64x2.pmin" (v128.const f64x2 0x1p+0 0x1p+0)
                                    (v128.const f64x2 0x1.fffffffffffffp+1023 0x1.fffffffffffffp+1023))
                                    (v128.const f64x2 0x1.0000000000000p+0 0x1.0000000000000p+0))
(assert_return (invoke "f64x2.pmin" (v128.const f64x2 0x1p+0 0x1p+0)
                                    (v128.const f64x2 -0x1.fffffffffffffp+1023 -0x1.fffffffffffffp+1023))
                                    (v128.const f64x2 -0x1.fffffffffffffp+1023 -0x1.fffffffffffffp+1023))
(assert_return (invoke "f64x2.pmin" (v128.const f64x2 0x1p+0 0x1p+0)
                                    (v128.const f64x2 0x0.0000000000001p-1022 0x0.0000000000001p-1022))
                                    (v128.const f64x2 0x0.0000000000001p-1022 0x0.0000000000001p-1022))
(assert_return (invoke "f64x2.pmin" (v128.const f64x2 0x1p+0 0x1p+0)
                                    (v128.const f64x2 0x0.0000000000001p-1022 0x0.0000000000001p-1022))
                                    (v128.const f64x2 0x0.0000000000001p-1022 0x0.0000000000001p-1022))
(assert_return (invoke "f64x2.pmin" (v128.const f64x2 0x1p+0 0x1p+0)
                                    (v128.const f64x2 inf inf))
                                    (v128.const f64x2 0x1.0000000000000p+0 0x1.0000000000000p+0))
(assert_return (invoke "f64x2.pmin" (v128.const f64x2 0x1p+0 0x1p+0)
                                    (v128.const f64x2 -inf -inf))
                                    (v128.const f64x2 -inf -inf))
(assert_return (invoke "f64x2.pmin" (v128.const f64x2 0x1p+0 0x1p+0)
                                    (v128.const f64x2 0123456789 0123456789))
                                    (v128.const f64x2 0x1.0000000000000p+0 0x1.0000000000000p+0))
(assert_return (invoke "f64x2.pmin" (v128.const f64x2 0x1p+0 0x1p+0)
                                    (v128.const f64x2 0123456789e019 0123456789e019))
                                    (v128.const f64x2 0x1.0000000000000p+0 0x1.0000000000000p+0))
(assert_return (invoke "f64x2.pmin" (v128.const f64x2 0x1p+0 0x1p+0)
                                    (v128.const f64x2 0123456789e+019 0123456789e+019))
                                    (v128.const f64x2 0x1.0000000000000p+0 0x1.0000000000000p+0))
(assert_return (invoke "f64x2.pmin" (v128.const f64x2 0x1p+0 0x1p+0)
                                    (v128.const f64x2 0123456789e-019 0123456789e-019))
                                    (v128.const f64x2 0x1.b25ffd62b4311p-37 0x1.b25ffd62b4311p-37))
(assert_return (invoke "f64x2.pmin" (v128.const f64x2 0x1p+0 0x1p+0)
                                    (v128.const f64x2 0123456789. 0123456789.))
                                    (v128.const f64x2 0x1.0000000000000p+0 0x1.0000000000000p+0))
(assert_return (invoke "f64x2.pmin" (v128.const f64x2 0x1p+0 0x1p+0)
                                    (v128.const f64x2 0123456789.e019 0123456789.e019))
                                    (v128.const f64x2 0x1.0000000000000p+0 0x1.0000000000000p+0))
(assert_return (invoke "f64x2.pmin" (v128.const f64x2 0x1p+0 0x1p+0)
                                    (v128.const f64x2 0123456789.e+019 0123456789.e+019))
                                    (v128.const f64x2 0x1.0000000000000p+0 0x1.0000000000000p+0))
(assert_return (invoke "f64x2.pmin" (v128.const f64x2 0x1p+0 0x1p+0)
                                    (v128.const f64x2 0123456789.e-019 0123456789.e-019))
                                    (v128.const f64x2 0x1.b25ffd62b4311p-37 0x1.b25ffd62b4311p-37))
(assert_return (invoke "f64x2.pmin" (v128.const f64x2 0x1p+0 0x1p+0)
                                    (v128.const f64x2 0123456789.0123456789 0123456789.0123456789))
                                    (v128.const f64x2 0x1.0000000000000p+0 0x1.0000000000000p+0))
(assert_return (invoke "f64x2.pmin" (v128.const f64x2 0x1p+0 0x1p+0)
                                    (v128.const f64x2 0123456789.0123456789e019 0123456789.0123456789e019))
                                    (v128.const f64x2 0x1.0000000000000p+0 0x1.0000000000000p+0))
(assert_return (invoke "f64x2.pmin" (v128.const f64x2 0x1p+0 0x1p+0)
                                    (v128.const f64x2 0123456789.0123456789e+019 0123456789.0123456789e+019))
                                    (v128.const f64x2 0x1.0000000000000p+0 0x1.0000000000000p+0))
(assert_return (invoke "f64x2.pmin" (v128.const f64x2 0x1p+0 0x1p+0)
                                    (v128.const f64x2 0123456789.0123456789e-019 0123456789.0123456789e-019))
                                    (v128.const f64x2 0x1.b25ffd636ec12p-37 0x1.b25ffd636ec12p-37))
(assert_return (invoke "f64x2.pmin" (v128.const f64x2 0x1p+0 0x1p+0)
                                    (v128.const f64x2 0x0123456789ABCDEFabcdef 0x0123456789ABCDEFabcdef))
                                    (v128.const f64x2 0x1.0000000000000p+0 0x1.0000000000000p+0))
(assert_return (invoke "f64x2.pmin" (v128.const f64x2 0x1p+0 0x1p+0)
                                    (v128.const f64x2 0x0123456789ABCDEFabcdefp019 0x0123456789ABCDEFabcdefp019))
                                    (v128.const f64x2 0x1.0000000000000p+0 0x1.0000000000000p+0))
(assert_return (invoke "f64x2.pmin" (v128.const f64x2 0x1p+0 0x1p+0)
                                    (v128.const f64x2 0x0123456789ABCDEFabcdefp+019 0x0123456789ABCDEFabcdefp+019))
                                    (v128.const f64x2 0x1.0000000000000p+0 0x1.0000000000000p+0))
(assert_return (invoke "f64x2.pmin" (v128.const f64x2 0x1p+0 0x1p+0)
                                    (v128.const f64x2 0x0123456789ABCDEFabcdefp-019 0x0123456789ABCDEFabcdefp-019))
                                    (v128.const f64x2 0x1.0000000000000p+0 0x1.0000000000000p+0))
(assert_return (invoke "f64x2.pmin" (v128.const f64x2 0x1p+0 0x1p+0)
                                    (v128.const f64x2 0x0123456789ABCDEFabcdef. 0x0123456789ABCDEFabcdef.))
                                    (v128.const f64x2 0x1.0000000000000p+0 0x1.0000000000000p+0))
(assert_return (invoke "f64x2.pmin" (v128.const f64x2 0x1p+0 0x1p+0)
                                    (v128.const f64x2 0x0123456789ABCDEFabcdef.p019 0x0123456789ABCDEFabcdef.p019))
                                    (v128.const f64x2 0x1.0000000000000p+0 0x1.0000000000000p+0))
(assert_return (invoke "f64x2.pmin" (v128.const f64x2 0x1p+0 0x1p+0)
                                    (v128.const f64x2 0x0123456789ABCDEFabcdef.p+019 0x0123456789ABCDEFabcdef.p+019))
                                    (v128.const f64x2 0x1.0000000000000p+0 0x1.0000000000000p+0))
(assert_return (invoke "f64x2.pmin" (v128.const f64x2 0x1p+0 0x1p+0)
                                    (v128.const f64x2 0x0123456789ABCDEFabcdef.p-019 0x0123456789ABCDEFabcdef.p-019))
                                    (v128.const f64x2 0x1.0000000000000p+0 0x1.0000000000000p+0))
(assert_return (invoke "f64x2.pmin" (v128.const f64x2 0x1p+0 0x1p+0)
                                    (v128.const f64x2 0x0123456789ABCDEFabcdef.0123456789ABCDEFabcdef 0x0123456789ABCDEFabcdef.0123456789ABCDEFabcdef))
                                    (v128.const f64x2 0x1.0000000000000p+0 0x1.0000000000000p+0))
(assert_return (invoke "f64x2.pmin" (v128.const f64x2 0x1p+0 0x1p+0)
                                    (v128.const f64x2 0x0123456789ABCDEFabcdef.0123456789ABCDEFabcdefp019 0x0123456789ABCDEFabcdef.0123456789ABCDEFabcdefp019))
                                    (v128.const f64x2 0x1.0000000000000p+0 0x1.0000000000000p+0))
(assert_return (invoke "f64x2.pmin" (v128.const f64x2 0x1p+0 0x1p+0)
                                    (v128.const f64x2 0x0123456789ABCDEFabcdef.0123456789ABCDEFabcdefp+019 0x0123456789ABCDEFabcdef.0123456789ABCDEFabcdefp+019))
                                    (v128.const f64x2 0x1.0000000000000p+0 0x1.0000000000000p+0))
(assert_return (invoke "f64x2.pmin" (v128.const f64x2 0x1p+0 0x1p+0)
                                    (v128.const f64x2 0x0123456789ABCDEFabcdef.0123456789ABCDEFabcdefp-019 0x0123456789ABCDEFabcdef.0123456789ABCDEFabcdefp-019))
                                    (v128.const f64x2 0x1.0000000000000p+0 0x1.0000000000000p+0))
(assert_return (invoke "f64x2.pmin" (v128.const f64x2 -0x1p+0 -0x1p+0)
                                    (v128.const f64x2 0x0p+0 0x0p+0))
                                    (v128.const f64x2 -0x1.0000000000000p+0 -0x1.0000000000000p+0))
(assert_return (invoke "f64x2.pmin" (v128.const f64x2 -0x1p+0 -0x1p+0)
                                    (v128.const f64x2 -0x0p+0 -0x0p+0))
                                    (v128.const f64x2 -0x1.0000000000000p+0 -0x1.0000000000000p+0))
(assert_return (invoke "f64x2.pmin" (v128.const f64x2 -0x1p+0 -0x1p+0)
                                    (v128.const f64x2 0x1p-1022 0x1p-1022))
                                    (v128.const f64x2 -0x1.0000000000000p+0 -0x1.0000000000000p+0))
(assert_return (invoke "f64x2.pmin" (v128.const f64x2 -0x1p+0 -0x1p+0)
                                    (v128.const f64x2 -0x1p-1022 -0x1p-1022))
                                    (v128.const f64x2 -0x1.0000000000000p+0 -0x1.0000000000000p+0))
(assert_return (invoke "f64x2.pmin" (v128.const f64x2 -0x1p+0 -0x1p+0)
                                    (v128.const f64x2 0x1p-1 0x1p-1))
                                    (v128.const f64x2 -0x1.0000000000000p+0 -0x1.0000000000000p+0))
(assert_return (invoke "f64x2.pmin" (v128.const f64x2 -0x1p+0 -0x1p+0)
                                    (v128.const f64x2 -0x1p-1 -0x1p-1))
                                    (v128.const f64x2 -0x1.0000000000000p+0 -0x1.0000000000000p+0))
(assert_return (invoke "f64x2.pmin" (v128.const f64x2 -0x1p+0 -0x1p+0)
                                    (v128.const f64x2 0x1p+0 0x1p+0))
                                    (v128.const f64x2 -0x1.0000000000000p+0 -0x1.0000000000000p+0))
(assert_return (invoke "f64x2.pmin" (v128.const f64x2 -0x1p+0 -0x1p+0)
                                    (v128.const f64x2 -0x1p+0 -0x1p+0))
                                    (v128.const f64x2 -0x1.0000000000000p+0 -0x1.0000000000000p+0))
(assert_return (invoke "f64x2.pmin" (v128.const f64x2 -0x1p+0 -0x1p+0)
                                    (v128.const f64x2 0x1.921fb54442d18p+2 0x1.921fb54442d18p+2))
                                    (v128.const f64x2 -0x1.0000000000000p+0 -0x1.0000000000000p+0))
(assert_return (invoke "f64x2.pmin" (v128.const f64x2 -0x1p+0 -0x1p+0)
                                    (v128.const f64x2 -0x1.921fb54442d18p+2 -0x1.921fb54442d18p+2))
                                    (v128.const f64x2 -0x1.921fb54442d18p+2 -0x1.921fb54442d18p+2))
(assert_return (invoke "f64x2.pmin" (v128.const f64x2 -0x1p+0 -0x1p+0)
                                    (v128.const f64x2 0x1.fffffffffffffp+1023 0x1.fffffffffffffp+1023))
                                    (v128.const f64x2 -0x1.0000000000000p+0 -0x1.0000000000000p+0))
(assert_return (invoke "f64x2.pmin" (v128.const f64x2 -0x1p+0 -0x1p+0)
                                    (v128.const f64x2 -0x1.fffffffffffffp+1023 -0x1.fffffffffffffp+1023))
                                    (v128.const f64x2 -0x1.fffffffffffffp+1023 -0x1.fffffffffffffp+1023))
(assert_return (invoke "f64x2.pmin" (v128.const f64x2 -0x1p+0 -0x1p+0)
                                    (v128.const f64x2 0x0.0000000000001p-1022 0x0.0000000000001p-1022))
                                    (v128.const f64x2 -0x1.0000000000000p+0 -0x1.0000000000000p+0))
(assert_return (invoke "f64x2.pmin" (v128.const f64x2 -0x1p+0 -0x1p+0)
                                    (v128.const f64x2 0x0.0000000000001p-1022 0x0.0000000000001p-1022))
                                    (v128.const f64x2 -0x1.0000000000000p+0 -0x1.0000000000000p+0))
(assert_return (invoke "f64x2.pmin" (v128.const f64x2 -0x1p+0 -0x1p+0)
                                    (v128.const f64x2 inf inf))
                                    (v128.const f64x2 -0x1.0000000000000p+0 -0x1.0000000000000p+0))
(assert_return (invoke "f64x2.pmin" (v128.const f64x2 -0x1p+0 -0x1p+0)
                                    (v128.const f64x2 -inf -inf))
                                    (v128.const f64x2 -inf -inf))
(assert_return (invoke "f64x2.pmin" (v128.const f64x2 -0x1p+0 -0x1p+0)
                                    (v128.const f64x2 0123456789 0123456789))
                                    (v128.const f64x2 -0x1.0000000000000p+0 -0x1.0000000000000p+0))
(assert_return (invoke "f64x2.pmin" (v128.const f64x2 -0x1p+0 -0x1p+0)
                                    (v128.const f64x2 0123456789e019 0123456789e019))
                                    (v128.const f64x2 -0x1.0000000000000p+0 -0x1.0000000000000p+0))
(assert_return (invoke "f64x2.pmin" (v128.const f64x2 -0x1p+0 -0x1p+0)
                                    (v128.const f64x2 0123456789e+019 0123456789e+019))
                                    (v128.const f64x2 -0x1.0000000000000p+0 -0x1.0000000000000p+0))
(assert_return (invoke "f64x2.pmin" (v128.const f64x2 -0x1p+0 -0x1p+0)
                                    (v128.const f64x2 0123456789e-019 0123456789e-019))
                                    (v128.const f64x2 -0x1.0000000000000p+0 -0x1.0000000000000p+0))
(assert_return (invoke "f64x2.pmin" (v128.const f64x2 -0x1p+0 -0x1p+0)
                                    (v128.const f64x2 0123456789. 0123456789.))
                                    (v128.const f64x2 -0x1.0000000000000p+0 -0x1.0000000000000p+0))
(assert_return (invoke "f64x2.pmin" (v128.const f64x2 -0x1p+0 -0x1p+0)
                                    (v128.const f64x2 0123456789.e019 0123456789.e019))
                                    (v128.const f64x2 -0x1.0000000000000p+0 -0x1.0000000000000p+0))
(assert_return (invoke "f64x2.pmin" (v128.const f64x2 -0x1p+0 -0x1p+0)
                                    (v128.const f64x2 0123456789.e+019 0123456789.e+019))
                                    (v128.const f64x2 -0x1.0000000000000p+0 -0x1.0000000000000p+0))
(assert_return (invoke "f64x2.pmin" (v128.const f64x2 -0x1p+0 -0x1p+0)
                                    (v128.const f64x2 0123456789.e-019 0123456789.e-019))
                                    (v128.const f64x2 -0x1.0000000000000p+0 -0x1.0000000000000p+0))
(assert_return (invoke "f64x2.pmin" (v128.const f64x2 -0x1p+0 -0x1p+0)
                                    (v128.const f64x2 0123456789.0123456789 0123456789.0123456789))
                                    (v128.const f64x2 -0x1.0000000000000p+0 -0x1.0000000000000p+0))
(assert_return (invoke "f64x2.pmin" (v128.const f64x2 -0x1p+0 -0x1p+0)
                                    (v128.const f64x2 0123456789.0123456789e019 0123456789.0123456789e019))
                                    (v128.const f64x2 -0x1.0000000000000p+0 -0x1.0000000000000p+0))
(assert_return (invoke "f64x2.pmin" (v128.const f64x2 -0x1p+0 -0x1p+0)
                                    (v128.const f64x2 0123456789.0123456789e+019 0123456789.0123456789e+019))
                                    (v128.const f64x2 -0x1.0000000000000p+0 -0x1.0000000000000p+0))
(assert_return (invoke "f64x2.pmin" (v128.const f64x2 -0x1p+0 -0x1p+0)
                                    (v128.const f64x2 0123456789.0123456789e-019 0123456789.0123456789e-019))
                                    (v128.const f64x2 -0x1.0000000000000p+0 -0x1.0000000000000p+0))
(assert_return (invoke "f64x2.pmin" (v128.const f64x2 -0x1p+0 -0x1p+0)
                                    (v128.const f64x2 0x0123456789ABCDEFabcdef 0x0123456789ABCDEFabcdef))
                                    (v128.const f64x2 -0x1.0000000000000p+0 -0x1.0000000000000p+0))
(assert_return (invoke "f64x2.pmin" (v128.const f64x2 -0x1p+0 -0x1p+0)
                                    (v128.const f64x2 0x0123456789ABCDEFabcdefp019 0x0123456789ABCDEFabcdefp019))
                                    (v128.const f64x2 -0x1.0000000000000p+0 -0x1.0000000000000p+0))
(assert_return (invoke "f64x2.pmin" (v128.const f64x2 -0x1p+0 -0x1p+0)
                                    (v128.const f64x2 0x0123456789ABCDEFabcdefp+019 0x0123456789ABCDEFabcdefp+019))
                                    (v128.const f64x2 -0x1.0000000000000p+0 -0x1.0000000000000p+0))
(assert_return (invoke "f64x2.pmin" (v128.const f64x2 -0x1p+0 -0x1p+0)
                                    (v128.const f64x2 0x0123456789ABCDEFabcdefp-019 0x0123456789ABCDEFabcdefp-019))
                                    (v128.const f64x2 -0x1.0000000000000p+0 -0x1.0000000000000p+0))
(assert_return (invoke "f64x2.pmin" (v128.const f64x2 -0x1p+0 -0x1p+0)
                                    (v128.const f64x2 0x0123456789ABCDEFabcdef. 0x0123456789ABCDEFabcdef.))
                                    (v128.const f64x2 -0x1.0000000000000p+0 -0x1.0000000000000p+0))
(assert_return (invoke "f64x2.pmin" (v128.const f64x2 -0x1p+0 -0x1p+0)
                                    (v128.const f64x2 0x0123456789ABCDEFabcdef.p019 0x0123456789ABCDEFabcdef.p019))
                                    (v128.const f64x2 -0x1.0000000000000p+0 -0x1.0000000000000p+0))
(assert_return (invoke "f64x2.pmin" (v128.const f64x2 -0x1p+0 -0x1p+0)
                                    (v128.const f64x2 0x0123456789ABCDEFabcdef.p+019 0x0123456789ABCDEFabcdef.p+019))
                                    (v128.const f64x2 -0x1.0000000000000p+0 -0x1.0000000000000p+0))
(assert_return (invoke "f64x2.pmin" (v128.const f64x2 -0x1p+0 -0x1p+0)
                                    (v128.const f64x2 0x0123456789ABCDEFabcdef.p-019 0x0123456789ABCDEFabcdef.p-019))
                                    (v128.const f64x2 -0x1.0000000000000p+0 -0x1.0000000000000p+0))
(assert_return (invoke "f64x2.pmin" (v128.const f64x2 -0x1p+0 -0x1p+0)
                                    (v128.const f64x2 0x0123456789ABCDEFabcdef.0123456789ABCDEFabcdef 0x0123456789ABCDEFabcdef.0123456789ABCDEFabcdef))
                                    (v128.const f64x2 -0x1.0000000000000p+0 -0x1.0000000000000p+0))
(assert_return (invoke "f64x2.pmin" (v128.const f64x2 -0x1p+0 -0x1p+0)
                                    (v128.const f64x2 0x0123456789ABCDEFabcdef.0123456789ABCDEFabcdefp019 0x0123456789ABCDEFabcdef.0123456789ABCDEFabcdefp019))
                                    (v128.const f64x2 -0x1.0000000000000p+0 -0x1.0000000000000p+0))
(assert_return (invoke "f64x2.pmin" (v128.const f64x2 -0x1p+0 -0x1p+0)
                                    (v128.const f64x2 0x0123456789ABCDEFabcdef.0123456789ABCDEFabcdefp+019 0x0123456789ABCDEFabcdef.0123456789ABCDEFabcdefp+019))
                                    (v128.const f64x2 -0x1.0000000000000p+0 -0x1.0000000000000p+0))
(assert_return (invoke "f64x2.pmin" (v128.const f64x2 -0x1p+0 -0x1p+0)
                                    (v128.const f64x2 0x0123456789ABCDEFabcdef.0123456789ABCDEFabcdefp-019 0x0123456789ABCDEFabcdef.0123456789ABCDEFabcdefp-019))
                                    (v128.const f64x2 -0x1.0000000000000p+0 -0x1.0000000000000p+0))
(assert_return (invoke "f64x2.pmin" (v128.const f64x2 0x1.921fb54442d18p+2 0x1.921fb54442d18p+2)
                                    (v128.const f64x2 0x0p+0 0x0p+0))
                                    (v128.const f64x2 0x0.0p+0 0x0.0p+0))
(assert_return (invoke "f64x2.pmin" (v128.const f64x2 0x1.921fb54442d18p+2 0x1.921fb54442d18p+2)
                                    (v128.const f64x2 -0x0p+0 -0x0p+0))
                                    (v128.const f64x2 -0x0.0p+0 -0x0.0p+0))
(assert_return (invoke "f64x2.pmin" (v128.const f64x2 0x1.921fb54442d18p+2 0x1.921fb54442d18p+2)
                                    (v128.const f64x2 0x1p-1022 0x1p-1022))
                                    (v128.const f64x2 0x1.0000000000000p-1022 0x1.0000000000000p-1022))
(assert_return (invoke "f64x2.pmin" (v128.const f64x2 0x1.921fb54442d18p+2 0x1.921fb54442d18p+2)
                                    (v128.const f64x2 -0x1p-1022 -0x1p-1022))
                                    (v128.const f64x2 -0x1.0000000000000p-1022 -0x1.0000000000000p-1022))
(assert_return (invoke "f64x2.pmin" (v128.const f64x2 0x1.921fb54442d18p+2 0x1.921fb54442d18p+2)
                                    (v128.const f64x2 0x1p-1 0x1p-1))
                                    (v128.const f64x2 0x1.0000000000000p-1 0x1.0000000000000p-1))
(assert_return (invoke "f64x2.pmin" (v128.const f64x2 0x1.921fb54442d18p+2 0x1.921fb54442d18p+2)
                                    (v128.const f64x2 -0x1p-1 -0x1p-1))
                                    (v128.const f64x2 -0x1.0000000000000p-1 -0x1.0000000000000p-1))
(assert_return (invoke "f64x2.pmin" (v128.const f64x2 0x1.921fb54442d18p+2 0x1.921fb54442d18p+2)
                                    (v128.const f64x2 0x1p+0 0x1p+0))
                                    (v128.const f64x2 0x1.0000000000000p+0 0x1.0000000000000p+0))
(assert_return (invoke "f64x2.pmin" (v128.const f64x2 0x1.921fb54442d18p+2 0x1.921fb54442d18p+2)
                                    (v128.const f64x2 -0x1p+0 -0x1p+0))
                                    (v128.const f64x2 -0x1.0000000000000p+0 -0x1.0000000000000p+0))
(assert_return (invoke "f64x2.pmin" (v128.const f64x2 0x1.921fb54442d18p+2 0x1.921fb54442d18p+2)
                                    (v128.const f64x2 0x1.921fb54442d18p+2 0x1.921fb54442d18p+2))
                                    (v128.const f64x2 0x1.921fb54442d18p+2 0x1.921fb54442d18p+2))
(assert_return (invoke "f64x2.pmin" (v128.const f64x2 0x1.921fb54442d18p+2 0x1.921fb54442d18p+2)
                                    (v128.const f64x2 -0x1.921fb54442d18p+2 -0x1.921fb54442d18p+2))
                                    (v128.const f64x2 -0x1.921fb54442d18p+2 -0x1.921fb54442d18p+2))
(assert_return (invoke "f64x2.pmin" (v128.const f64x2 0x1.921fb54442d18p+2 0x1.921fb54442d18p+2)
                                    (v128.const f64x2 0x1.fffffffffffffp+1023 0x1.fffffffffffffp+1023))
                                    (v128.const f64x2 0x1.921fb54442d18p+2 0x1.921fb54442d18p+2))
(assert_return (invoke "f64x2.pmin" (v128.const f64x2 0x1.921fb54442d18p+2 0x1.921fb54442d18p+2)
                                    (v128.const f64x2 -0x1.fffffffffffffp+1023 -0x1.fffffffffffffp+1023))
                                    (v128.const f64x2 -0x1.fffffffffffffp+1023 -0x1.fffffffffffffp+1023))
(assert_return (invoke "f64x2.pmin" (v128.const f64x2 0x1.921fb54442d18p+2 0x1.921fb54442d18p+2)
                                    (v128.const f64x2 0x0.0000000000001p-1022 0x0.0000000000001p-1022))
                                    (v128.const f64x2 0x0.0000000000001p-1022 0x0.0000000000001p-1022))
(assert_return (invoke "f64x2.pmin" (v128.const f64x2 0x1.921fb54442d18p+2 0x1.921fb54442d18p+2)
                                    (v128.const f64x2 0x0.0000000000001p-1022 0x0.0000000000001p-1022))
                                    (v128.const f64x2 0x0.0000000000001p-1022 0x0.0000000000001p-1022))
(assert_return (invoke "f64x2.pmin" (v128.const f64x2 0x1.921fb54442d18p+2 0x1.921fb54442d18p+2)
                                    (v128.const f64x2 inf inf))
                                    (v128.const f64x2 0x1.921fb54442d18p+2 0x1.921fb54442d18p+2))
(assert_return (invoke "f64x2.pmin" (v128.const f64x2 0x1.921fb54442d18p+2 0x1.921fb54442d18p+2)
                                    (v128.const f64x2 -inf -inf))
                                    (v128.const f64x2 -inf -inf))
(assert_return (invoke "f64x2.pmin" (v128.const f64x2 0x1.921fb54442d18p+2 0x1.921fb54442d18p+2)
                                    (v128.const f64x2 0123456789 0123456789))
                                    (v128.const f64x2 0x1.921fb54442d18p+2 0x1.921fb54442d18p+2))
(assert_return (invoke "f64x2.pmin" (v128.const f64x2 0x1.921fb54442d18p+2 0x1.921fb54442d18p+2)
                                    (v128.const f64x2 0123456789e019 0123456789e019))
                                    (v128.const f64x2 0x1.921fb54442d18p+2 0x1.921fb54442d18p+2))
(assert_return (invoke "f64x2.pmin" (v128.const f64x2 0x1.921fb54442d18p+2 0x1.921fb54442d18p+2)
                                    (v128.const f64x2 0123456789e+019 0123456789e+019))
                                    (v128.const f64x2 0x1.921fb54442d18p+2 0x1.921fb54442d18p+2))
(assert_return (invoke "f64x2.pmin" (v128.const f64x2 0x1.921fb54442d18p+2 0x1.921fb54442d18p+2)
                                    (v128.const f64x2 0123456789e-019 0123456789e-019))
                                    (v128.const f64x2 0x1.b25ffd62b4311p-37 0x1.b25ffd62b4311p-37))
(assert_return (invoke "f64x2.pmin" (v128.const f64x2 0x1.921fb54442d18p+2 0x1.921fb54442d18p+2)
                                    (v128.const f64x2 0123456789. 0123456789.))
                                    (v128.const f64x2 0x1.921fb54442d18p+2 0x1.921fb54442d18p+2))
(assert_return (invoke "f64x2.pmin" (v128.const f64x2 0x1.921fb54442d18p+2 0x1.921fb54442d18p+2)
                                    (v128.const f64x2 0123456789.e019 0123456789.e019))
                                    (v128.const f64x2 0x1.921fb54442d18p+2 0x1.921fb54442d18p+2))
(assert_return (invoke "f64x2.pmin" (v128.const f64x2 0x1.921fb54442d18p+2 0x1.921fb54442d18p+2)
                                    (v128.const f64x2 0123456789.e+019 0123456789.e+019))
                                    (v128.const f64x2 0x1.921fb54442d18p+2 0x1.921fb54442d18p+2))
(assert_return (invoke "f64x2.pmin" (v128.const f64x2 0x1.921fb54442d18p+2 0x1.921fb54442d18p+2)
                                    (v128.const f64x2 0123456789.e-019 0123456789.e-019))
                                    (v128.const f64x2 0x1.b25ffd62b4311p-37 0x1.b25ffd62b4311p-37))
(assert_return (invoke "f64x2.pmin" (v128.const f64x2 0x1.921fb54442d18p+2 0x1.921fb54442d18p+2)
                                    (v128.const f64x2 0123456789.0123456789 0123456789.0123456789))
                                    (v128.const f64x2 0x1.921fb54442d18p+2 0x1.921fb54442d18p+2))
(assert_return (invoke "f64x2.pmin" (v128.const f64x2 0x1.921fb54442d18p+2 0x1.921fb54442d18p+2)
                                    (v128.const f64x2 0123456789.0123456789e019 0123456789.0123456789e019))
                                    (v128.const f64x2 0x1.921fb54442d18p+2 0x1.921fb54442d18p+2))
(assert_return (invoke "f64x2.pmin" (v128.const f64x2 0x1.921fb54442d18p+2 0x1.921fb54442d18p+2)
                                    (v128.const f64x2 0123456789.0123456789e+019 0123456789.0123456789e+019))
                                    (v128.const f64x2 0x1.921fb54442d18p+2 0x1.921fb54442d18p+2))
(assert_return (invoke "f64x2.pmin" (v128.const f64x2 0x1.921fb54442d18p+2 0x1.921fb54442d18p+2)
                                    (v128.const f64x2 0123456789.0123456789e-019 0123456789.0123456789e-019))
                                    (v128.const f64x2 0x1.b25ffd636ec12p-37 0x1.b25ffd636ec12p-37))
(assert_return (invoke "f64x2.pmin" (v128.const f64x2 0x1.921fb54442d18p+2 0x1.921fb54442d18p+2)
                                    (v128.const f64x2 0x0123456789ABCDEFabcdef 0x0123456789ABCDEFabcdef))
                                    (v128.const f64x2 0x1.921fb54442d18p+2 0x1.921fb54442d18p+2))
(assert_return (invoke "f64x2.pmin" (v128.const f64x2 0x1.921fb54442d18p+2 0x1.921fb54442d18p+2)
                                    (v128.const f64x2 0x0123456789ABCDEFabcdefp019 0x0123456789ABCDEFabcdefp019))
                                    (v128.const f64x2 0x1.921fb54442d18p+2 0x1.921fb54442d18p+2))
(assert_return (invoke "f64x2.pmin" (v128.const f64x2 0x1.921fb54442d18p+2 0x1.921fb54442d18p+2)
                                    (v128.const f64x2 0x0123456789ABCDEFabcdefp+019 0x0123456789ABCDEFabcdefp+019))
                                    (v128.const f64x2 0x1.921fb54442d18p+2 0x1.921fb54442d18p+2))
(assert_return (invoke "f64x2.pmin" (v128.const f64x2 0x1.921fb54442d18p+2 0x1.921fb54442d18p+2)
                                    (v128.const f64x2 0x0123456789ABCDEFabcdefp-019 0x0123456789ABCDEFabcdefp-019))
                                    (v128.const f64x2 0x1.921fb54442d18p+2 0x1.921fb54442d18p+2))
(assert_return (invoke "f64x2.pmin" (v128.const f64x2 0x1.921fb54442d18p+2 0x1.921fb54442d18p+2)
                                    (v128.const f64x2 0x0123456789ABCDEFabcdef. 0x0123456789ABCDEFabcdef.))
                                    (v128.const f64x2 0x1.921fb54442d18p+2 0x1.921fb54442d18p+2))
(assert_return (invoke "f64x2.pmin" (v128.const f64x2 0x1.921fb54442d18p+2 0x1.921fb54442d18p+2)
                                    (v128.const f64x2 0x0123456789ABCDEFabcdef.p019 0x0123456789ABCDEFabcdef.p019))
                                    (v128.const f64x2 0x1.921fb54442d18p+2 0x1.921fb54442d18p+2))
(assert_return (invoke "f64x2.pmin" (v128.const f64x2 0x1.921fb54442d18p+2 0x1.921fb54442d18p+2)
                                    (v128.const f64x2 0x0123456789ABCDEFabcdef.p+019 0x0123456789ABCDEFabcdef.p+019))
                                    (v128.const f64x2 0x1.921fb54442d18p+2 0x1.921fb54442d18p+2))
(assert_return (invoke "f64x2.pmin" (v128.const f64x2 0x1.921fb54442d18p+2 0x1.921fb54442d18p+2)
                                    (v128.const f64x2 0x0123456789ABCDEFabcdef.p-019 0x0123456789ABCDEFabcdef.p-019))
                                    (v128.const f64x2 0x1.921fb54442d18p+2 0x1.921fb54442d18p+2))
(assert_return (invoke "f64x2.pmin" (v128.const f64x2 0x1.921fb54442d18p+2 0x1.921fb54442d18p+2)
                                    (v128.const f64x2 0x0123456789ABCDEFabcdef.0123456789ABCDEFabcdef 0x0123456789ABCDEFabcdef.0123456789ABCDEFabcdef))
                                    (v128.const f64x2 0x1.921fb54442d18p+2 0x1.921fb54442d18p+2))
(assert_return (invoke "f64x2.pmin" (v128.const f64x2 0x1.921fb54442d18p+2 0x1.921fb54442d18p+2)
                                    (v128.const f64x2 0x0123456789ABCDEFabcdef.0123456789ABCDEFabcdefp019 0x0123456789ABCDEFabcdef.0123456789ABCDEFabcdefp019))
                                    (v128.const f64x2 0x1.921fb54442d18p+2 0x1.921fb54442d18p+2))
(assert_return (invoke "f64x2.pmin" (v128.const f64x2 0x1.921fb54442d18p+2 0x1.921fb54442d18p+2)
                                    (v128.const f64x2 0x0123456789ABCDEFabcdef.0123456789ABCDEFabcdefp+019 0x0123456789ABCDEFabcdef.0123456789ABCDEFabcdefp+019))
                                    (v128.const f64x2 0x1.921fb54442d18p+2 0x1.921fb54442d18p+2))
(assert_return (invoke "f64x2.pmin" (v128.const f64x2 0x1.921fb54442d18p+2 0x1.921fb54442d18p+2)
                                    (v128.const f64x2 0x0123456789ABCDEFabcdef.0123456789ABCDEFabcdefp-019 0x0123456789ABCDEFabcdef.0123456789ABCDEFabcdefp-019))
                                    (v128.const f64x2 0x1.921fb54442d18p+2 0x1.921fb54442d18p+2))
(assert_return (invoke "f64x2.pmin" (v128.const f64x2 -0x1.921fb54442d18p+2 -0x1.921fb54442d18p+2)
                                    (v128.const f64x2 0x0p+0 0x0p+0))
                                    (v128.const f64x2 -0x1.921fb54442d18p+2 -0x1.921fb54442d18p+2))
(assert_return (invoke "f64x2.pmin" (v128.const f64x2 -0x1.921fb54442d18p+2 -0x1.921fb54442d18p+2)
                                    (v128.const f64x2 -0x0p+0 -0x0p+0))
                                    (v128.const f64x2 -0x1.921fb54442d18p+2 -0x1.921fb54442d18p+2))
(assert_return (invoke "f64x2.pmin" (v128.const f64x2 -0x1.921fb54442d18p+2 -0x1.921fb54442d18p+2)
                                    (v128.const f64x2 0x1p-1022 0x1p-1022))
                                    (v128.const f64x2 -0x1.921fb54442d18p+2 -0x1.921fb54442d18p+2))
(assert_return (invoke "f64x2.pmin" (v128.const f64x2 -0x1.921fb54442d18p+2 -0x1.921fb54442d18p+2)
                                    (v128.const f64x2 -0x1p-1022 -0x1p-1022))
                                    (v128.const f64x2 -0x1.921fb54442d18p+2 -0x1.921fb54442d18p+2))
(assert_return (invoke "f64x2.pmin" (v128.const f64x2 -0x1.921fb54442d18p+2 -0x1.921fb54442d18p+2)
                                    (v128.const f64x2 0x1p-1 0x1p-1))
                                    (v128.const f64x2 -0x1.921fb54442d18p+2 -0x1.921fb54442d18p+2))
(assert_return (invoke "f64x2.pmin" (v128.const f64x2 -0x1.921fb54442d18p+2 -0x1.921fb54442d18p+2)
                                    (v128.const f64x2 -0x1p-1 -0x1p-1))
                                    (v128.const f64x2 -0x1.921fb54442d18p+2 -0x1.921fb54442d18p+2))
(assert_return (invoke "f64x2.pmin" (v128.const f64x2 -0x1.921fb54442d18p+2 -0x1.921fb54442d18p+2)
                                    (v128.const f64x2 0x1p+0 0x1p+0))
                                    (v128.const f64x2 -0x1.921fb54442d18p+2 -0x1.921fb54442d18p+2))
(assert_return (invoke "f64x2.pmin" (v128.const f64x2 -0x1.921fb54442d18p+2 -0x1.921fb54442d18p+2)
                                    (v128.const f64x2 -0x1p+0 -0x1p+0))
                                    (v128.const f64x2 -0x1.921fb54442d18p+2 -0x1.921fb54442d18p+2))
(assert_return (invoke "f64x2.pmin" (v128.const f64x2 -0x1.921fb54442d18p+2 -0x1.921fb54442d18p+2)
                                    (v128.const f64x2 0x1.921fb54442d18p+2 0x1.921fb54442d18p+2))
                                    (v128.const f64x2 -0x1.921fb54442d18p+2 -0x1.921fb54442d18p+2))
(assert_return (invoke "f64x2.pmin" (v128.const f64x2 -0x1.921fb54442d18p+2 -0x1.921fb54442d18p+2)
                                    (v128.const f64x2 -0x1.921fb54442d18p+2 -0x1.921fb54442d18p+2))
                                    (v128.const f64x2 -0x1.921fb54442d18p+2 -0x1.921fb54442d18p+2))
(assert_return (invoke "f64x2.pmin" (v128.const f64x2 -0x1.921fb54442d18p+2 -0x1.921fb54442d18p+2)
                                    (v128.const f64x2 0x1.fffffffffffffp+1023 0x1.fffffffffffffp+1023))
                                    (v128.const f64x2 -0x1.921fb54442d18p+2 -0x1.921fb54442d18p+2))
(assert_return (invoke "f64x2.pmin" (v128.const f64x2 -0x1.921fb54442d18p+2 -0x1.921fb54442d18p+2)
                                    (v128.const f64x2 -0x1.fffffffffffffp+1023 -0x1.fffffffffffffp+1023))
                                    (v128.const f64x2 -0x1.fffffffffffffp+1023 -0x1.fffffffffffffp+1023))
(assert_return (invoke "f64x2.pmin" (v128.const f64x2 -0x1.921fb54442d18p+2 -0x1.921fb54442d18p+2)
                                    (v128.const f64x2 0x0.0000000000001p-1022 0x0.0000000000001p-1022))
                                    (v128.const f64x2 -0x1.921fb54442d18p+2 -0x1.921fb54442d18p+2))
(assert_return (invoke "f64x2.pmin" (v128.const f64x2 -0x1.921fb54442d18p+2 -0x1.921fb54442d18p+2)
                                    (v128.const f64x2 0x0.0000000000001p-1022 0x0.0000000000001p-1022))
                                    (v128.const f64x2 -0x1.921fb54442d18p+2 -0x1.921fb54442d18p+2))
(assert_return (invoke "f64x2.pmin" (v128.const f64x2 -0x1.921fb54442d18p+2 -0x1.921fb54442d18p+2)
                                    (v128.const f64x2 inf inf))
                                    (v128.const f64x2 -0x1.921fb54442d18p+2 -0x1.921fb54442d18p+2))
(assert_return (invoke "f64x2.pmin" (v128.const f64x2 -0x1.921fb54442d18p+2 -0x1.921fb54442d18p+2)
                                    (v128.const f64x2 -inf -inf))
                                    (v128.const f64x2 -inf -inf))
(assert_return (invoke "f64x2.pmin" (v128.const f64x2 -0x1.921fb54442d18p+2 -0x1.921fb54442d18p+2)
                                    (v128.const f64x2 0123456789 0123456789))
                                    (v128.const f64x2 -0x1.921fb54442d18p+2 -0x1.921fb54442d18p+2))
(assert_return (invoke "f64x2.pmin" (v128.const f64x2 -0x1.921fb54442d18p+2 -0x1.921fb54442d18p+2)
                                    (v128.const f64x2 0123456789e019 0123456789e019))
                                    (v128.const f64x2 -0x1.921fb54442d18p+2 -0x1.921fb54442d18p+2))
(assert_return (invoke "f64x2.pmin" (v128.const f64x2 -0x1.921fb54442d18p+2 -0x1.921fb54442d18p+2)
                                    (v128.const f64x2 0123456789e+019 0123456789e+019))
                                    (v128.const f64x2 -0x1.921fb54442d18p+2 -0x1.921fb54442d18p+2))
(assert_return (invoke "f64x2.pmin" (v128.const f64x2 -0x1.921fb54442d18p+2 -0x1.921fb54442d18p+2)
                                    (v128.const f64x2 0123456789e-019 0123456789e-019))
                                    (v128.const f64x2 -0x1.921fb54442d18p+2 -0x1.921fb54442d18p+2))
(assert_return (invoke "f64x2.pmin" (v128.const f64x2 -0x1.921fb54442d18p+2 -0x1.921fb54442d18p+2)
                                    (v128.const f64x2 0123456789. 0123456789.))
                                    (v128.const f64x2 -0x1.921fb54442d18p+2 -0x1.921fb54442d18p+2))
(assert_return (invoke "f64x2.pmin" (v128.const f64x2 -0x1.921fb54442d18p+2 -0x1.921fb54442d18p+2)
                                    (v128.const f64x2 0123456789.e019 0123456789.e019))
                                    (v128.const f64x2 -0x1.921fb54442d18p+2 -0x1.921fb54442d18p+2))
(assert_return (invoke "f64x2.pmin" (v128.const f64x2 -0x1.921fb54442d18p+2 -0x1.921fb54442d18p+2)
                                    (v128.const f64x2 0123456789.e+019 0123456789.e+019))
                                    (v128.const f64x2 -0x1.921fb54442d18p+2 -0x1.921fb54442d18p+2))
(assert_return (invoke "f64x2.pmin" (v128.const f64x2 -0x1.921fb54442d18p+2 -0x1.921fb54442d18p+2)
                                    (v128.const f64x2 0123456789.e-019 0123456789.e-019))
                                    (v128.const f64x2 -0x1.921fb54442d18p+2 -0x1.921fb54442d18p+2))
(assert_return (invoke "f64x2.pmin" (v128.const f64x2 -0x1.921fb54442d18p+2 -0x1.921fb54442d18p+2)
                                    (v128.const f64x2 0123456789.0123456789 0123456789.0123456789))
                                    (v128.const f64x2 -0x1.921fb54442d18p+2 -0x1.921fb54442d18p+2))
(assert_return (invoke "f64x2.pmin" (v128.const f64x2 -0x1.921fb54442d18p+2 -0x1.921fb54442d18p+2)
                                    (v128.const f64x2 0123456789.0123456789e019 0123456789.0123456789e019))
                                    (v128.const f64x2 -0x1.921fb54442d18p+2 -0x1.921fb54442d18p+2))
(assert_return (invoke "f64x2.pmin" (v128.const f64x2 -0x1.921fb54442d18p+2 -0x1.921fb54442d18p+2)
                                    (v128.const f64x2 0123456789.0123456789e+019 0123456789.0123456789e+019))
                                    (v128.const f64x2 -0x1.921fb54442d18p+2 -0x1.921fb54442d18p+2))
(assert_return (invoke "f64x2.pmin" (v128.const f64x2 -0x1.921fb54442d18p+2 -0x1.921fb54442d18p+2)
                                    (v128.const f64x2 0123456789.0123456789e-019 0123456789.0123456789e-019))
                                    (v128.const f64x2 -0x1.921fb54442d18p+2 -0x1.921fb54442d18p+2))
(assert_return (invoke "f64x2.pmin" (v128.const f64x2 -0x1.921fb54442d18p+2 -0x1.921fb54442d18p+2)
                                    (v128.const f64x2 0x0123456789ABCDEFabcdef 0x0123456789ABCDEFabcdef))
                                    (v128.const f64x2 -0x1.921fb54442d18p+2 -0x1.921fb54442d18p+2))
(assert_return (invoke "f64x2.pmin" (v128.const f64x2 -0x1.921fb54442d18p+2 -0x1.921fb54442d18p+2)
                                    (v128.const f64x2 0x0123456789ABCDEFabcdefp019 0x0123456789ABCDEFabcdefp019))
                                    (v128.const f64x2 -0x1.921fb54442d18p+2 -0x1.921fb54442d18p+2))
(assert_return (invoke "f64x2.pmin" (v128.const f64x2 -0x1.921fb54442d18p+2 -0x1.921fb54442d18p+2)
                                    (v128.const f64x2 0x0123456789ABCDEFabcdefp+019 0x0123456789ABCDEFabcdefp+019))
                                    (v128.const f64x2 -0x1.921fb54442d18p+2 -0x1.921fb54442d18p+2))
(assert_return (invoke "f64x2.pmin" (v128.const f64x2 -0x1.921fb54442d18p+2 -0x1.921fb54442d18p+2)
                                    (v128.const f64x2 0x0123456789ABCDEFabcdefp-019 0x0123456789ABCDEFabcdefp-019))
                                    (v128.const f64x2 -0x1.921fb54442d18p+2 -0x1.921fb54442d18p+2))
(assert_return (invoke "f64x2.pmin" (v128.const f64x2 -0x1.921fb54442d18p+2 -0x1.921fb54442d18p+2)
                                    (v128.const f64x2 0x0123456789ABCDEFabcdef. 0x0123456789ABCDEFabcdef.))
                                    (v128.const f64x2 -0x1.921fb54442d18p+2 -0x1.921fb54442d18p+2))
(assert_return (invoke "f64x2.pmin" (v128.const f64x2 -0x1.921fb54442d18p+2 -0x1.921fb54442d18p+2)
                                    (v128.const f64x2 0x0123456789ABCDEFabcdef.p019 0x0123456789ABCDEFabcdef.p019))
                                    (v128.const f64x2 -0x1.921fb54442d18p+2 -0x1.921fb54442d18p+2))
(assert_return (invoke "f64x2.pmin" (v128.const f64x2 -0x1.921fb54442d18p+2 -0x1.921fb54442d18p+2)
                                    (v128.const f64x2 0x0123456789ABCDEFabcdef.p+019 0x0123456789ABCDEFabcdef.p+019))
                                    (v128.const f64x2 -0x1.921fb54442d18p+2 -0x1.921fb54442d18p+2))
(assert_return (invoke "f64x2.pmin" (v128.const f64x2 -0x1.921fb54442d18p+2 -0x1.921fb54442d18p+2)
                                    (v128.const f64x2 0x0123456789ABCDEFabcdef.p-019 0x0123456789ABCDEFabcdef.p-019))
                                    (v128.const f64x2 -0x1.921fb54442d18p+2 -0x1.921fb54442d18p+2))
(assert_return (invoke "f64x2.pmin" (v128.const f64x2 -0x1.921fb54442d18p+2 -0x1.921fb54442d18p+2)
                                    (v128.const f64x2 0x0123456789ABCDEFabcdef.0123456789ABCDEFabcdef 0x0123456789ABCDEFabcdef.0123456789ABCDEFabcdef))
                                    (v128.const f64x2 -0x1.921fb54442d18p+2 -0x1.921fb54442d18p+2))
(assert_return (invoke "f64x2.pmin" (v128.const f64x2 -0x1.921fb54442d18p+2 -0x1.921fb54442d18p+2)
                                    (v128.const f64x2 0x0123456789ABCDEFabcdef.0123456789ABCDEFabcdefp019 0x0123456789ABCDEFabcdef.0123456789ABCDEFabcdefp019))
                                    (v128.const f64x2 -0x1.921fb54442d18p+2 -0x1.921fb54442d18p+2))
(assert_return (invoke "f64x2.pmin" (v128.const f64x2 -0x1.921fb54442d18p+2 -0x1.921fb54442d18p+2)
                                    (v128.const f64x2 0x0123456789ABCDEFabcdef.0123456789ABCDEFabcdefp+019 0x0123456789ABCDEFabcdef.0123456789ABCDEFabcdefp+019))
                                    (v128.const f64x2 -0x1.921fb54442d18p+2 -0x1.921fb54442d18p+2))
(assert_return (invoke "f64x2.pmin" (v128.const f64x2 -0x1.921fb54442d18p+2 -0x1.921fb54442d18p+2)
                                    (v128.const f64x2 0x0123456789ABCDEFabcdef.0123456789ABCDEFabcdefp-019 0x0123456789ABCDEFabcdef.0123456789ABCDEFabcdefp-019))
                                    (v128.const f64x2 -0x1.921fb54442d18p+2 -0x1.921fb54442d18p+2))
(assert_return (invoke "f64x2.pmin" (v128.const f64x2 0x1.fffffffffffffp+1023 0x1.fffffffffffffp+1023)
                                    (v128.const f64x2 0x0p+0 0x0p+0))
                                    (v128.const f64x2 0x0.0p+0 0x0.0p+0))
(assert_return (invoke "f64x2.pmin" (v128.const f64x2 0x1.fffffffffffffp+1023 0x1.fffffffffffffp+1023)
                                    (v128.const f64x2 -0x0p+0 -0x0p+0))
                                    (v128.const f64x2 -0x0.0p+0 -0x0.0p+0))
(assert_return (invoke "f64x2.pmin" (v128.const f64x2 0x1.fffffffffffffp+1023 0x1.fffffffffffffp+1023)
                                    (v128.const f64x2 0x1p-1022 0x1p-1022))
                                    (v128.const f64x2 0x1.0000000000000p-1022 0x1.0000000000000p-1022))
(assert_return (invoke "f64x2.pmin" (v128.const f64x2 0x1.fffffffffffffp+1023 0x1.fffffffffffffp+1023)
                                    (v128.const f64x2 -0x1p-1022 -0x1p-1022))
                                    (v128.const f64x2 -0x1.0000000000000p-1022 -0x1.0000000000000p-1022))
(assert_return (invoke "f64x2.pmin" (v128.const f64x2 0x1.fffffffffffffp+1023 0x1.fffffffffffffp+1023)
                                    (v128.const f64x2 0x1p-1 0x1p-1))
                                    (v128.const f64x2 0x1.0000000000000p-1 0x1.0000000000000p-1))
(assert_return (invoke "f64x2.pmin" (v128.const f64x2 0x1.fffffffffffffp+1023 0x1.fffffffffffffp+1023)
                                    (v128.const f64x2 -0x1p-1 -0x1p-1))
                                    (v128.const f64x2 -0x1.0000000000000p-1 -0x1.0000000000000p-1))
(assert_return (invoke "f64x2.pmin" (v128.const f64x2 0x1.fffffffffffffp+1023 0x1.fffffffffffffp+1023)
                                    (v128.const f64x2 0x1p+0 0x1p+0))
                                    (v128.const f64x2 0x1.0000000000000p+0 0x1.0000000000000p+0))
(assert_return (invoke "f64x2.pmin" (v128.const f64x2 0x1.fffffffffffffp+1023 0x1.fffffffffffffp+1023)
                                    (v128.const f64x2 -0x1p+0 -0x1p+0))
                                    (v128.const f64x2 -0x1.0000000000000p+0 -0x1.0000000000000p+0))
(assert_return (invoke "f64x2.pmin" (v128.const f64x2 0x1.fffffffffffffp+1023 0x1.fffffffffffffp+1023)
                                    (v128.const f64x2 0x1.921fb54442d18p+2 0x1.921fb54442d18p+2))
                                    (v128.const f64x2 0x1.921fb54442d18p+2 0x1.921fb54442d18p+2))
(assert_return (invoke "f64x2.pmin" (v128.const f64x2 0x1.fffffffffffffp+1023 0x1.fffffffffffffp+1023)
                                    (v128.const f64x2 -0x1.921fb54442d18p+2 -0x1.921fb54442d18p+2))
                                    (v128.const f64x2 -0x1.921fb54442d18p+2 -0x1.921fb54442d18p+2))
(assert_return (invoke "f64x2.pmin" (v128.const f64x2 0x1.fffffffffffffp+1023 0x1.fffffffffffffp+1023)
                                    (v128.const f64x2 0x1.fffffffffffffp+1023 0x1.fffffffffffffp+1023))
                                    (v128.const f64x2 0x1.fffffffffffffp+1023 0x1.fffffffffffffp+1023))
(assert_return (invoke "f64x2.pmin" (v128.const f64x2 0x1.fffffffffffffp+1023 0x1.fffffffffffffp+1023)
                                    (v128.const f64x2 -0x1.fffffffffffffp+1023 -0x1.fffffffffffffp+1023))
                                    (v128.const f64x2 -0x1.fffffffffffffp+1023 -0x1.fffffffffffffp+1023))
(assert_return (invoke "f64x2.pmin" (v128.const f64x2 0x1.fffffffffffffp+1023 0x1.fffffffffffffp+1023)
                                    (v128.const f64x2 0x0.0000000000001p-1022 0x0.0000000000001p-1022))
                                    (v128.const f64x2 0x0.0000000000001p-1022 0x0.0000000000001p-1022))
(assert_return (invoke "f64x2.pmin" (v128.const f64x2 0x1.fffffffffffffp+1023 0x1.fffffffffffffp+1023)
                                    (v128.const f64x2 0x0.0000000000001p-1022 0x0.0000000000001p-1022))
                                    (v128.const f64x2 0x0.0000000000001p-1022 0x0.0000000000001p-1022))
(assert_return (invoke "f64x2.pmin" (v128.const f64x2 0x1.fffffffffffffp+1023 0x1.fffffffffffffp+1023)
                                    (v128.const f64x2 inf inf))
                                    (v128.const f64x2 0x1.fffffffffffffp+1023 0x1.fffffffffffffp+1023))
(assert_return (invoke "f64x2.pmin" (v128.const f64x2 0x1.fffffffffffffp+1023 0x1.fffffffffffffp+1023)
                                    (v128.const f64x2 -inf -inf))
                                    (v128.const f64x2 -inf -inf))
(assert_return (invoke "f64x2.pmin" (v128.const f64x2 0x1.fffffffffffffp+1023 0x1.fffffffffffffp+1023)
                                    (v128.const f64x2 0123456789 0123456789))
                                    (v128.const f64x2 0x1.d6f3454000000p+26 0x1.d6f3454000000p+26))
(assert_return (invoke "f64x2.pmin" (v128.const f64x2 0x1.fffffffffffffp+1023 0x1.fffffffffffffp+1023)
                                    (v128.const f64x2 0123456789e019 0123456789e019))
                                    (v128.const f64x2 0x1.fe9af5b5e16fap+89 0x1.fe9af5b5e16fap+89))
(assert_return (invoke "f64x2.pmin" (v128.const f64x2 0x1.fffffffffffffp+1023 0x1.fffffffffffffp+1023)
                                    (v128.const f64x2 0123456789e+019 0123456789e+019))
                                    (v128.const f64x2 0x1.fe9af5b5e16fap+89 0x1.fe9af5b5e16fap+89))
(assert_return (invoke "f64x2.pmin" (v128.const f64x2 0x1.fffffffffffffp+1023 0x1.fffffffffffffp+1023)
                                    (v128.const f64x2 0123456789e-019 0123456789e-019))
                                    (v128.const f64x2 0x1.b25ffd62b4311p-37 0x1.b25ffd62b4311p-37))
(assert_return (invoke "f64x2.pmin" (v128.const f64x2 0x1.fffffffffffffp+1023 0x1.fffffffffffffp+1023)
                                    (v128.const f64x2 0123456789. 0123456789.))
                                    (v128.const f64x2 0x1.d6f3454000000p+26 0x1.d6f3454000000p+26))
(assert_return (invoke "f64x2.pmin" (v128.const f64x2 0x1.fffffffffffffp+1023 0x1.fffffffffffffp+1023)
                                    (v128.const f64x2 0123456789.e019 0123456789.e019))
                                    (v128.const f64x2 0x1.fe9af5b5e16fap+89 0x1.fe9af5b5e16fap+89))
(assert_return (invoke "f64x2.pmin" (v128.const f64x2 0x1.fffffffffffffp+1023 0x1.fffffffffffffp+1023)
                                    (v128.const f64x2 0123456789.e+019 0123456789.e+019))
                                    (v128.const f64x2 0x1.fe9af5b5e16fap+89 0x1.fe9af5b5e16fap+89))
(assert_return (invoke "f64x2.pmin" (v128.const f64x2 0x1.fffffffffffffp+1023 0x1.fffffffffffffp+1023)
                                    (v128.const f64x2 0123456789.e-019 0123456789.e-019))
                                    (v128.const f64x2 0x1.b25ffd62b4311p-37 0x1.b25ffd62b4311p-37))
(assert_return (invoke "f64x2.pmin" (v128.const f64x2 0x1.fffffffffffffp+1023 0x1.fffffffffffffp+1023)
                                    (v128.const f64x2 0123456789.0123456789 0123456789.0123456789))
                                    (v128.const f64x2 0x1.d6f34540ca458p+26 0x1.d6f34540ca458p+26))
(assert_return (invoke "f64x2.pmin" (v128.const f64x2 0x1.fffffffffffffp+1023 0x1.fffffffffffffp+1023)
                                    (v128.const f64x2 0123456789.0123456789e019 0123456789.0123456789e019))
                                    (v128.const f64x2 0x1.fe9af5b6bcbd5p+89 0x1.fe9af5b6bcbd5p+89))
(assert_return (invoke "f64x2.pmin" (v128.const f64x2 0x1.fffffffffffffp+1023 0x1.fffffffffffffp+1023)
                                    (v128.const f64x2 0123456789.0123456789e+019 0123456789.0123456789e+019))
                                    (v128.const f64x2 0x1.fe9af5b6bcbd5p+89 0x1.fe9af5b6bcbd5p+89))
(assert_return (invoke "f64x2.pmin" (v128.const f64x2 0x1.fffffffffffffp+1023 0x1.fffffffffffffp+1023)
                                    (v128.const f64x2 0123456789.0123456789e-019 0123456789.0123456789e-019))
                                    (v128.const f64x2 0x1.b25ffd636ec12p-37 0x1.b25ffd636ec12p-37))
(assert_return (invoke "f64x2.pmin" (v128.const f64x2 0x1.fffffffffffffp+1023 0x1.fffffffffffffp+1023)
                                    (v128.const f64x2 0x0123456789ABCDEFabcdef 0x0123456789ABCDEFabcdef))
                                    (v128.const f64x2 0x1.23456789abcdfp+80 0x1.23456789abcdfp+80))
(assert_return (invoke "f64x2.pmin" (v128.const f64x2 0x1.fffffffffffffp+1023 0x1.fffffffffffffp+1023)
                                    (v128.const f64x2 0x0123456789ABCDEFabcdefp019 0x0123456789ABCDEFabcdefp019))
                                    (v128.const f64x2 0x1.23456789abcdfp+99 0x1.23456789abcdfp+99))
(assert_return (invoke "f64x2.pmin" (v128.const f64x2 0x1.fffffffffffffp+1023 0x1.fffffffffffffp+1023)
                                    (v128.const f64x2 0x0123456789ABCDEFabcdefp+019 0x0123456789ABCDEFabcdefp+019))
                                    (v128.const f64x2 0x1.23456789abcdfp+99 0x1.23456789abcdfp+99))
(assert_return (invoke "f64x2.pmin" (v128.const f64x2 0x1.fffffffffffffp+1023 0x1.fffffffffffffp+1023)
                                    (v128.const f64x2 0x0123456789ABCDEFabcdefp-019 0x0123456789ABCDEFabcdefp-019))
                                    (v128.const f64x2 0x1.23456789abcdfp+61 0x1.23456789abcdfp+61))
(assert_return (invoke "f64x2.pmin" (v128.const f64x2 0x1.fffffffffffffp+1023 0x1.fffffffffffffp+1023)
                                    (v128.const f64x2 0x0123456789ABCDEFabcdef. 0x0123456789ABCDEFabcdef.))
                                    (v128.const f64x2 0x1.23456789abcdfp+80 0x1.23456789abcdfp+80))
(assert_return (invoke "f64x2.pmin" (v128.const f64x2 0x1.fffffffffffffp+1023 0x1.fffffffffffffp+1023)
                                    (v128.const f64x2 0x0123456789ABCDEFabcdef.p019 0x0123456789ABCDEFabcdef.p019))
                                    (v128.const f64x2 0x1.23456789abcdfp+99 0x1.23456789abcdfp+99))
(assert_return (invoke "f64x2.pmin" (v128.const f64x2 0x1.fffffffffffffp+1023 0x1.fffffffffffffp+1023)
                                    (v128.const f64x2 0x0123456789ABCDEFabcdef.p+019 0x0123456789ABCDEFabcdef.p+019))
                                    (v128.const f64x2 0x1.23456789abcdfp+99 0x1.23456789abcdfp+99))
(assert_return (invoke "f64x2.pmin" (v128.const f64x2 0x1.fffffffffffffp+1023 0x1.fffffffffffffp+1023)
                                    (v128.const f64x2 0x0123456789ABCDEFabcdef.p-019 0x0123456789ABCDEFabcdef.p-019))
                                    (v128.const f64x2 0x1.23456789abcdfp+61 0x1.23456789abcdfp+61))
(assert_return (invoke "f64x2.pmin" (v128.const f64x2 0x1.fffffffffffffp+1023 0x1.fffffffffffffp+1023)
                                    (v128.const f64x2 0x0123456789ABCDEFabcdef.0123456789ABCDEFabcdef 0x0123456789ABCDEFabcdef.0123456789ABCDEFabcdef))
                                    (v128.const f64x2 0x1.23456789abcdfp+80 0x1.23456789abcdfp+80))
(assert_return (invoke "f64x2.pmin" (v128.const f64x2 0x1.fffffffffffffp+1023 0x1.fffffffffffffp+1023)
                                    (v128.const f64x2 0x0123456789ABCDEFabcdef.0123456789ABCDEFabcdefp019 0x0123456789ABCDEFabcdef.0123456789ABCDEFabcdefp019))
                                    (v128.const f64x2 0x1.23456789abcdfp+99 0x1.23456789abcdfp+99))
(assert_return (invoke "f64x2.pmin" (v128.const f64x2 0x1.fffffffffffffp+1023 0x1.fffffffffffffp+1023)
                                    (v128.const f64x2 0x0123456789ABCDEFabcdef.0123456789ABCDEFabcdefp+019 0x0123456789ABCDEFabcdef.0123456789ABCDEFabcdefp+019))
                                    (v128.const f64x2 0x1.23456789abcdfp+99 0x1.23456789abcdfp+99))
(assert_return (invoke "f64x2.pmin" (v128.const f64x2 0x1.fffffffffffffp+1023 0x1.fffffffffffffp+1023)
                                    (v128.const f64x2 0x0123456789ABCDEFabcdef.0123456789ABCDEFabcdefp-019 0x0123456789ABCDEFabcdef.0123456789ABCDEFabcdefp-019))
                                    (v128.const f64x2 0x1.23456789abcdfp+61 0x1.23456789abcdfp+61))
(assert_return (invoke "f64x2.pmin" (v128.const f64x2 -0x1.fffffffffffffp+1023 -0x1.fffffffffffffp+1023)
                                    (v128.const f64x2 0x0p+0 0x0p+0))
                                    (v128.const f64x2 -0x1.fffffffffffffp+1023 -0x1.fffffffffffffp+1023))
(assert_return (invoke "f64x2.pmin" (v128.const f64x2 -0x1.fffffffffffffp+1023 -0x1.fffffffffffffp+1023)
                                    (v128.const f64x2 -0x0p+0 -0x0p+0))
                                    (v128.const f64x2 -0x1.fffffffffffffp+1023 -0x1.fffffffffffffp+1023))
(assert_return (invoke "f64x2.pmin" (v128.const f64x2 -0x1.fffffffffffffp+1023 -0x1.fffffffffffffp+1023)
                                    (v128.const f64x2 0x1p-1022 0x1p-1022))
                                    (v128.const f64x2 -0x1.fffffffffffffp+1023 -0x1.fffffffffffffp+1023))
(assert_return (invoke "f64x2.pmin" (v128.const f64x2 -0x1.fffffffffffffp+1023 -0x1.fffffffffffffp+1023)
                                    (v128.const f64x2 -0x1p-1022 -0x1p-1022))
                                    (v128.const f64x2 -0x1.fffffffffffffp+1023 -0x1.fffffffffffffp+1023))
(assert_return (invoke "f64x2.pmin" (v128.const f64x2 -0x1.fffffffffffffp+1023 -0x1.fffffffffffffp+1023)
                                    (v128.const f64x2 0x1p-1 0x1p-1))
                                    (v128.const f64x2 -0x1.fffffffffffffp+1023 -0x1.fffffffffffffp+1023))
(assert_return (invoke "f64x2.pmin" (v128.const f64x2 -0x1.fffffffffffffp+1023 -0x1.fffffffffffffp+1023)
                                    (v128.const f64x2 -0x1p-1 -0x1p-1))
                                    (v128.const f64x2 -0x1.fffffffffffffp+1023 -0x1.fffffffffffffp+1023))
(assert_return (invoke "f64x2.pmin" (v128.const f64x2 -0x1.fffffffffffffp+1023 -0x1.fffffffffffffp+1023)
                                    (v128.const f64x2 0x1p+0 0x1p+0))
                                    (v128.const f64x2 -0x1.fffffffffffffp+1023 -0x1.fffffffffffffp+1023))
(assert_return (invoke "f64x2.pmin" (v128.const f64x2 -0x1.fffffffffffffp+1023 -0x1.fffffffffffffp+1023)
                                    (v128.const f64x2 -0x1p+0 -0x1p+0))
                                    (v128.const f64x2 -0x1.fffffffffffffp+1023 -0x1.fffffffffffffp+1023))
(assert_return (invoke "f64x2.pmin" (v128.const f64x2 -0x1.fffffffffffffp+1023 -0x1.fffffffffffffp+1023)
                                    (v128.const f64x2 0x1.921fb54442d18p+2 0x1.921fb54442d18p+2))
                                    (v128.const f64x2 -0x1.fffffffffffffp+1023 -0x1.fffffffffffffp+1023))
(assert_return (invoke "f64x2.pmin" (v128.const f64x2 -0x1.fffffffffffffp+1023 -0x1.fffffffffffffp+1023)
                                    (v128.const f64x2 -0x1.921fb54442d18p+2 -0x1.921fb54442d18p+2))
                                    (v128.const f64x2 -0x1.fffffffffffffp+1023 -0x1.fffffffffffffp+1023))
(assert_return (invoke "f64x2.pmin" (v128.const f64x2 -0x1.fffffffffffffp+1023 -0x1.fffffffffffffp+1023)
                                    (v128.const f64x2 0x1.fffffffffffffp+1023 0x1.fffffffffffffp+1023))
                                    (v128.const f64x2 -0x1.fffffffffffffp+1023 -0x1.fffffffffffffp+1023))
(assert_return (invoke "f64x2.pmin" (v128.const f64x2 -0x1.fffffffffffffp+1023 -0x1.fffffffffffffp+1023)
                                    (v128.const f64x2 -0x1.fffffffffffffp+1023 -0x1.fffffffffffffp+1023))
                                    (v128.const f64x2 -0x1.fffffffffffffp+1023 -0x1.fffffffffffffp+1023))
(assert_return (invoke "f64x2.pmin" (v128.const f64x2 -0x1.fffffffffffffp+1023 -0x1.fffffffffffffp+1023)
                                    (v128.const f64x2 0x0.0000000000001p-1022 0x0.0000000000001p-1022))
                                    (v128.const f64x2 -0x1.fffffffffffffp+1023 -0x1.fffffffffffffp+1023))
(assert_return (invoke "f64x2.pmin" (v128.const f64x2 -0x1.fffffffffffffp+1023 -0x1.fffffffffffffp+1023)
                                    (v128.const f64x2 0x0.0000000000001p-1022 0x0.0000000000001p-1022))
                                    (v128.const f64x2 -0x1.fffffffffffffp+1023 -0x1.fffffffffffffp+1023))
(assert_return (invoke "f64x2.pmin" (v128.const f64x2 -0x1.fffffffffffffp+1023 -0x1.fffffffffffffp+1023)
                                    (v128.const f64x2 inf inf))
                                    (v128.const f64x2 -0x1.fffffffffffffp+1023 -0x1.fffffffffffffp+1023))
(assert_return (invoke "f64x2.pmin" (v128.const f64x2 -0x1.fffffffffffffp+1023 -0x1.fffffffffffffp+1023)
                                    (v128.const f64x2 -inf -inf))
                                    (v128.const f64x2 -inf -inf))
(assert_return (invoke "f64x2.pmin" (v128.const f64x2 -0x1.fffffffffffffp+1023 -0x1.fffffffffffffp+1023)
                                    (v128.const f64x2 0123456789 0123456789))
                                    (v128.const f64x2 -0x1.fffffffffffffp+1023 -0x1.fffffffffffffp+1023))
(assert_return (invoke "f64x2.pmin" (v128.const f64x2 -0x1.fffffffffffffp+1023 -0x1.fffffffffffffp+1023)
                                    (v128.const f64x2 0123456789e019 0123456789e019))
                                    (v128.const f64x2 -0x1.fffffffffffffp+1023 -0x1.fffffffffffffp+1023))
(assert_return (invoke "f64x2.pmin" (v128.const f64x2 -0x1.fffffffffffffp+1023 -0x1.fffffffffffffp+1023)
                                    (v128.const f64x2 0123456789e+019 0123456789e+019))
                                    (v128.const f64x2 -0x1.fffffffffffffp+1023 -0x1.fffffffffffffp+1023))
(assert_return (invoke "f64x2.pmin" (v128.const f64x2 -0x1.fffffffffffffp+1023 -0x1.fffffffffffffp+1023)
                                    (v128.const f64x2 0123456789e-019 0123456789e-019))
                                    (v128.const f64x2 -0x1.fffffffffffffp+1023 -0x1.fffffffffffffp+1023))
(assert_return (invoke "f64x2.pmin" (v128.const f64x2 -0x1.fffffffffffffp+1023 -0x1.fffffffffffffp+1023)
                                    (v128.const f64x2 0123456789. 0123456789.))
                                    (v128.const f64x2 -0x1.fffffffffffffp+1023 -0x1.fffffffffffffp+1023))
(assert_return (invoke "f64x2.pmin" (v128.const f64x2 -0x1.fffffffffffffp+1023 -0x1.fffffffffffffp+1023)
                                    (v128.const f64x2 0123456789.e019 0123456789.e019))
                                    (v128.const f64x2 -0x1.fffffffffffffp+1023 -0x1.fffffffffffffp+1023))
(assert_return (invoke "f64x2.pmin" (v128.const f64x2 -0x1.fffffffffffffp+1023 -0x1.fffffffffffffp+1023)
                                    (v128.const f64x2 0123456789.e+019 0123456789.e+019))
                                    (v128.const f64x2 -0x1.fffffffffffffp+1023 -0x1.fffffffffffffp+1023))
(assert_return (invoke "f64x2.pmin" (v128.const f64x2 -0x1.fffffffffffffp+1023 -0x1.fffffffffffffp+1023)
                                    (v128.const f64x2 0123456789.e-019 0123456789.e-019))
                                    (v128.const f64x2 -0x1.fffffffffffffp+1023 -0x1.fffffffffffffp+1023))
(assert_return (invoke "f64x2.pmin" (v128.const f64x2 -0x1.fffffffffffffp+1023 -0x1.fffffffffffffp+1023)
                                    (v128.const f64x2 0123456789.0123456789 0123456789.0123456789))
                                    (v128.const f64x2 -0x1.fffffffffffffp+1023 -0x1.fffffffffffffp+1023))
(assert_return (invoke "f64x2.pmin" (v128.const f64x2 -0x1.fffffffffffffp+1023 -0x1.fffffffffffffp+1023)
                                    (v128.const f64x2 0123456789.0123456789e019 0123456789.0123456789e019))
                                    (v128.const f64x2 -0x1.fffffffffffffp+1023 -0x1.fffffffffffffp+1023))
(assert_return (invoke "f64x2.pmin" (v128.const f64x2 -0x1.fffffffffffffp+1023 -0x1.fffffffffffffp+1023)
                                    (v128.const f64x2 0123456789.0123456789e+019 0123456789.0123456789e+019))
                                    (v128.const f64x2 -0x1.fffffffffffffp+1023 -0x1.fffffffffffffp+1023))
(assert_return (invoke "f64x2.pmin" (v128.const f64x2 -0x1.fffffffffffffp+1023 -0x1.fffffffffffffp+1023)
                                    (v128.const f64x2 0123456789.0123456789e-019 0123456789.0123456789e-019))
                                    (v128.const f64x2 -0x1.fffffffffffffp+1023 -0x1.fffffffffffffp+1023))
(assert_return (invoke "f64x2.pmin" (v128.const f64x2 -0x1.fffffffffffffp+1023 -0x1.fffffffffffffp+1023)
                                    (v128.const f64x2 0x0123456789ABCDEFabcdef 0x0123456789ABCDEFabcdef))
                                    (v128.const f64x2 -0x1.fffffffffffffp+1023 -0x1.fffffffffffffp+1023))
(assert_return (invoke "f64x2.pmin" (v128.const f64x2 -0x1.fffffffffffffp+1023 -0x1.fffffffffffffp+1023)
                                    (v128.const f64x2 0x0123456789ABCDEFabcdefp019 0x0123456789ABCDEFabcdefp019))
                                    (v128.const f64x2 -0x1.fffffffffffffp+1023 -0x1.fffffffffffffp+1023))
(assert_return (invoke "f64x2.pmin" (v128.const f64x2 -0x1.fffffffffffffp+1023 -0x1.fffffffffffffp+1023)
                                    (v128.const f64x2 0x0123456789ABCDEFabcdefp+019 0x0123456789ABCDEFabcdefp+019))
                                    (v128.const f64x2 -0x1.fffffffffffffp+1023 -0x1.fffffffffffffp+1023))
(assert_return (invoke "f64x2.pmin" (v128.const f64x2 -0x1.fffffffffffffp+1023 -0x1.fffffffffffffp+1023)
                                    (v128.const f64x2 0x0123456789ABCDEFabcdefp-019 0x0123456789ABCDEFabcdefp-019))
                                    (v128.const f64x2 -0x1.fffffffffffffp+1023 -0x1.fffffffffffffp+1023))
(assert_return (invoke "f64x2.pmin" (v128.const f64x2 -0x1.fffffffffffffp+1023 -0x1.fffffffffffffp+1023)
                                    (v128.const f64x2 0x0123456789ABCDEFabcdef. 0x0123456789ABCDEFabcdef.))
                                    (v128.const f64x2 -0x1.fffffffffffffp+1023 -0x1.fffffffffffffp+1023))
(assert_return (invoke "f64x2.pmin" (v128.const f64x2 -0x1.fffffffffffffp+1023 -0x1.fffffffffffffp+1023)
                                    (v128.const f64x2 0x0123456789ABCDEFabcdef.p019 0x0123456789ABCDEFabcdef.p019))
                                    (v128.const f64x2 -0x1.fffffffffffffp+1023 -0x1.fffffffffffffp+1023))
(assert_return (invoke "f64x2.pmin" (v128.const f64x2 -0x1.fffffffffffffp+1023 -0x1.fffffffffffffp+1023)
                                    (v128.const f64x2 0x0123456789ABCDEFabcdef.p+019 0x0123456789ABCDEFabcdef.p+019))
                                    (v128.const f64x2 -0x1.fffffffffffffp+1023 -0x1.fffffffffffffp+1023))
(assert_return (invoke "f64x2.pmin" (v128.const f64x2 -0x1.fffffffffffffp+1023 -0x1.fffffffffffffp+1023)
                                    (v128.const f64x2 0x0123456789ABCDEFabcdef.p-019 0x0123456789ABCDEFabcdef.p-019))
                                    (v128.const f64x2 -0x1.fffffffffffffp+1023 -0x1.fffffffffffffp+1023))
(assert_return (invoke "f64x2.pmin" (v128.const f64x2 -0x1.fffffffffffffp+1023 -0x1.fffffffffffffp+1023)
                                    (v128.const f64x2 0x0123456789ABCDEFabcdef.0123456789ABCDEFabcdef 0x0123456789ABCDEFabcdef.0123456789ABCDEFabcdef))
                                    (v128.const f64x2 -0x1.fffffffffffffp+1023 -0x1.fffffffffffffp+1023))
(assert_return (invoke "f64x2.pmin" (v128.const f64x2 -0x1.fffffffffffffp+1023 -0x1.fffffffffffffp+1023)
                                    (v128.const f64x2 0x0123456789ABCDEFabcdef.0123456789ABCDEFabcdefp019 0x0123456789ABCDEFabcdef.0123456789ABCDEFabcdefp019))
                                    (v128.const f64x2 -0x1.fffffffffffffp+1023 -0x1.fffffffffffffp+1023))
(assert_return (invoke "f64x2.pmin" (v128.const f64x2 -0x1.fffffffffffffp+1023 -0x1.fffffffffffffp+1023)
                                    (v128.const f64x2 0x0123456789ABCDEFabcdef.0123456789ABCDEFabcdefp+019 0x0123456789ABCDEFabcdef.0123456789ABCDEFabcdefp+019))
                                    (v128.const f64x2 -0x1.fffffffffffffp+1023 -0x1.fffffffffffffp+1023))
(assert_return (invoke "f64x2.pmin" (v128.const f64x2 -0x1.fffffffffffffp+1023 -0x1.fffffffffffffp+1023)
                                    (v128.const f64x2 0x0123456789ABCDEFabcdef.0123456789ABCDEFabcdefp-019 0x0123456789ABCDEFabcdef.0123456789ABCDEFabcdefp-019))
                                    (v128.const f64x2 -0x1.fffffffffffffp+1023 -0x1.fffffffffffffp+1023))
(assert_return (invoke "f64x2.pmin" (v128.const f64x2 0x0.0000000000001p-1022 0x0.0000000000001p-1022)
                                    (v128.const f64x2 0x0p+0 0x0p+0))
                                    (v128.const f64x2 0x0.0p+0 0x0.0p+0))
(assert_return (invoke "f64x2.pmin" (v128.const f64x2 0x0.0000000000001p-1022 0x0.0000000000001p-1022)
                                    (v128.const f64x2 -0x0p+0 -0x0p+0))
                                    (v128.const f64x2 -0x0.0p+0 -0x0.0p+0))
(assert_return (invoke "f64x2.pmin" (v128.const f64x2 0x0.0000000000001p-1022 0x0.0000000000001p-1022)
                                    (v128.const f64x2 0x1p-1022 0x1p-1022))
                                    (v128.const f64x2 0x0.0000000000001p-1022 0x0.0000000000001p-1022))
(assert_return (invoke "f64x2.pmin" (v128.const f64x2 0x0.0000000000001p-1022 0x0.0000000000001p-1022)
                                    (v128.const f64x2 -0x1p-1022 -0x1p-1022))
                                    (v128.const f64x2 -0x1.0000000000000p-1022 -0x1.0000000000000p-1022))
(assert_return (invoke "f64x2.pmin" (v128.const f64x2 0x0.0000000000001p-1022 0x0.0000000000001p-1022)
                                    (v128.const f64x2 0x1p-1 0x1p-1))
                                    (v128.const f64x2 0x0.0000000000001p-1022 0x0.0000000000001p-1022))
(assert_return (invoke "f64x2.pmin" (v128.const f64x2 0x0.0000000000001p-1022 0x0.0000000000001p-1022)
                                    (v128.const f64x2 -0x1p-1 -0x1p-1))
                                    (v128.const f64x2 -0x1.0000000000000p-1 -0x1.0000000000000p-1))
(assert_return (invoke "f64x2.pmin" (v128.const f64x2 0x0.0000000000001p-1022 0x0.0000000000001p-1022)
                                    (v128.const f64x2 0x1p+0 0x1p+0))
                                    (v128.const f64x2 0x0.0000000000001p-1022 0x0.0000000000001p-1022))
(assert_return (invoke "f64x2.pmin" (v128.const f64x2 0x0.0000000000001p-1022 0x0.0000000000001p-1022)
                                    (v128.const f64x2 -0x1p+0 -0x1p+0))
                                    (v128.const f64x2 -0x1.0000000000000p+0 -0x1.0000000000000p+0))
(assert_return (invoke "f64x2.pmin" (v128.const f64x2 0x0.0000000000001p-1022 0x0.0000000000001p-1022)
                                    (v128.const f64x2 0x1.921fb54442d18p+2 0x1.921fb54442d18p+2))
                                    (v128.const f64x2 0x0.0000000000001p-1022 0x0.0000000000001p-1022))
(assert_return (invoke "f64x2.pmin" (v128.const f64x2 0x0.0000000000001p-1022 0x0.0000000000001p-1022)
                                    (v128.const f64x2 -0x1.921fb54442d18p+2 -0x1.921fb54442d18p+2))
                                    (v128.const f64x2 -0x1.921fb54442d18p+2 -0x1.921fb54442d18p+2))
(assert_return (invoke "f64x2.pmin" (v128.const f64x2 0x0.0000000000001p-1022 0x0.0000000000001p-1022)
                                    (v128.const f64x2 0x1.fffffffffffffp+1023 0x1.fffffffffffffp+1023))
                                    (v128.const f64x2 0x0.0000000000001p-1022 0x0.0000000000001p-1022))
(assert_return (invoke "f64x2.pmin" (v128.const f64x2 0x0.0000000000001p-1022 0x0.0000000000001p-1022)
                                    (v128.const f64x2 -0x1.fffffffffffffp+1023 -0x1.fffffffffffffp+1023))
                                    (v128.const f64x2 -0x1.fffffffffffffp+1023 -0x1.fffffffffffffp+1023))
(assert_return (invoke "f64x2.pmin" (v128.const f64x2 0x0.0000000000001p-1022 0x0.0000000000001p-1022)
                                    (v128.const f64x2 0x0.0000000000001p-1022 0x0.0000000000001p-1022))
                                    (v128.const f64x2 0x0.0000000000001p-1022 0x0.0000000000001p-1022))
(assert_return (invoke "f64x2.pmin" (v128.const f64x2 0x0.0000000000001p-1022 0x0.0000000000001p-1022)
                                    (v128.const f64x2 0x0.0000000000001p-1022 0x0.0000000000001p-1022))
                                    (v128.const f64x2 0x0.0000000000001p-1022 0x0.0000000000001p-1022))
(assert_return (invoke "f64x2.pmin" (v128.const f64x2 0x0.0000000000001p-1022 0x0.0000000000001p-1022)
                                    (v128.const f64x2 inf inf))
                                    (v128.const f64x2 0x0.0000000000001p-1022 0x0.0000000000001p-1022))
(assert_return (invoke "f64x2.pmin" (v128.const f64x2 0x0.0000000000001p-1022 0x0.0000000000001p-1022)
                                    (v128.const f64x2 -inf -inf))
                                    (v128.const f64x2 -inf -inf))
(assert_return (invoke "f64x2.pmin" (v128.const f64x2 0x0.0000000000001p-1022 0x0.0000000000001p-1022)
                                    (v128.const f64x2 0123456789 0123456789))
                                    (v128.const f64x2 0x0.0000000000001p-1022 0x0.0000000000001p-1022))
(assert_return (invoke "f64x2.pmin" (v128.const f64x2 0x0.0000000000001p-1022 0x0.0000000000001p-1022)
                                    (v128.const f64x2 0123456789e019 0123456789e019))
                                    (v128.const f64x2 0x0.0000000000001p-1022 0x0.0000000000001p-1022))
(assert_return (invoke "f64x2.pmin" (v128.const f64x2 0x0.0000000000001p-1022 0x0.0000000000001p-1022)
                                    (v128.const f64x2 0123456789e+019 0123456789e+019))
                                    (v128.const f64x2 0x0.0000000000001p-1022 0x0.0000000000001p-1022))
(assert_return (invoke "f64x2.pmin" (v128.const f64x2 0x0.0000000000001p-1022 0x0.0000000000001p-1022)
                                    (v128.const f64x2 0123456789e-019 0123456789e-019))
                                    (v128.const f64x2 0x0.0000000000001p-1022 0x0.0000000000001p-1022))
(assert_return (invoke "f64x2.pmin" (v128.const f64x2 0x0.0000000000001p-1022 0x0.0000000000001p-1022)
                                    (v128.const f64x2 0123456789. 0123456789.))
                                    (v128.const f64x2 0x0.0000000000001p-1022 0x0.0000000000001p-1022))
(assert_return (invoke "f64x2.pmin" (v128.const f64x2 0x0.0000000000001p-1022 0x0.0000000000001p-1022)
                                    (v128.const f64x2 0123456789.e019 0123456789.e019))
                                    (v128.const f64x2 0x0.0000000000001p-1022 0x0.0000000000001p-1022))
(assert_return (invoke "f64x2.pmin" (v128.const f64x2 0x0.0000000000001p-1022 0x0.0000000000001p-1022)
                                    (v128.const f64x2 0123456789.e+019 0123456789.e+019))
                                    (v128.const f64x2 0x0.0000000000001p-1022 0x0.0000000000001p-1022))
(assert_return (invoke "f64x2.pmin" (v128.const f64x2 0x0.0000000000001p-1022 0x0.0000000000001p-1022)
                                    (v128.const f64x2 0123456789.e-019 0123456789.e-019))
                                    (v128.const f64x2 0x0.0000000000001p-1022 0x0.0000000000001p-1022))
(assert_return (invoke "f64x2.pmin" (v128.const f64x2 0x0.0000000000001p-1022 0x0.0000000000001p-1022)
                                    (v128.const f64x2 0123456789.0123456789 0123456789.0123456789))
                                    (v128.const f64x2 0x0.0000000000001p-1022 0x0.0000000000001p-1022))
(assert_return (invoke "f64x2.pmin" (v128.const f64x2 0x0.0000000000001p-1022 0x0.0000000000001p-1022)
                                    (v128.const f64x2 0123456789.0123456789e019 0123456789.0123456789e019))
                                    (v128.const f64x2 0x0.0000000000001p-1022 0x0.0000000000001p-1022))
(assert_return (invoke "f64x2.pmin" (v128.const f64x2 0x0.0000000000001p-1022 0x0.0000000000001p-1022)
                                    (v128.const f64x2 0123456789.0123456789e+019 0123456789.0123456789e+019))
                                    (v128.const f64x2 0x0.0000000000001p-1022 0x0.0000000000001p-1022))
(assert_return (invoke "f64x2.pmin" (v128.const f64x2 0x0.0000000000001p-1022 0x0.0000000000001p-1022)
                                    (v128.const f64x2 0123456789.0123456789e-019 0123456789.0123456789e-019))
                                    (v128.const f64x2 0x0.0000000000001p-1022 0x0.0000000000001p-1022))
(assert_return (invoke "f64x2.pmin" (v128.const f64x2 0x0.0000000000001p-1022 0x0.0000000000001p-1022)
                                    (v128.const f64x2 0x0123456789ABCDEFabcdef 0x0123456789ABCDEFabcdef))
                                    (v128.const f64x2 0x0.0000000000001p-1022 0x0.0000000000001p-1022))
(assert_return (invoke "f64x2.pmin" (v128.const f64x2 0x0.0000000000001p-1022 0x0.0000000000001p-1022)
                                    (v128.const f64x2 0x0123456789ABCDEFabcdefp019 0x0123456789ABCDEFabcdefp019))
                                    (v128.const f64x2 0x0.0000000000001p-1022 0x0.0000000000001p-1022))
(assert_return (invoke "f64x2.pmin" (v128.const f64x2 0x0.0000000000001p-1022 0x0.0000000000001p-1022)
                                    (v128.const f64x2 0x0123456789ABCDEFabcdefp+019 0x0123456789ABCDEFabcdefp+019))
                                    (v128.const f64x2 0x0.0000000000001p-1022 0x0.0000000000001p-1022))
(assert_return (invoke "f64x2.pmin" (v128.const f64x2 0x0.0000000000001p-1022 0x0.0000000000001p-1022)
                                    (v128.const f64x2 0x0123456789ABCDEFabcdefp-019 0x0123456789ABCDEFabcdefp-019))
                                    (v128.const f64x2 0x0.0000000000001p-1022 0x0.0000000000001p-1022))
(assert_return (invoke "f64x2.pmin" (v128.const f64x2 0x0.0000000000001p-1022 0x0.0000000000001p-1022)
                                    (v128.const f64x2 0x0123456789ABCDEFabcdef. 0x0123456789ABCDEFabcdef.))
                                    (v128.const f64x2 0x0.0000000000001p-1022 0x0.0000000000001p-1022))
(assert_return (invoke "f64x2.pmin" (v128.const f64x2 0x0.0000000000001p-1022 0x0.0000000000001p-1022)
                                    (v128.const f64x2 0x0123456789ABCDEFabcdef.p019 0x0123456789ABCDEFabcdef.p019))
                                    (v128.const f64x2 0x0.0000000000001p-1022 0x0.0000000000001p-1022))
(assert_return (invoke "f64x2.pmin" (v128.const f64x2 0x0.0000000000001p-1022 0x0.0000000000001p-1022)
                                    (v128.const f64x2 0x0123456789ABCDEFabcdef.p+019 0x0123456789ABCDEFabcdef.p+019))
                                    (v128.const f64x2 0x0.0000000000001p-1022 0x0.0000000000001p-1022))
(assert_return (invoke "f64x2.pmin" (v128.const f64x2 0x0.0000000000001p-1022 0x0.0000000000001p-1022)
                                    (v128.const f64x2 0x0123456789ABCDEFabcdef.p-019 0x0123456789ABCDEFabcdef.p-019))
                                    (v128.const f64x2 0x0.0000000000001p-1022 0x0.0000000000001p-1022))
(assert_return (invoke "f64x2.pmin" (v128.const f64x2 0x0.0000000000001p-1022 0x0.0000000000001p-1022)
                                    (v128.const f64x2 0x0123456789ABCDEFabcdef.0123456789ABCDEFabcdef 0x0123456789ABCDEFabcdef.0123456789ABCDEFabcdef))
                                    (v128.const f64x2 0x0.0000000000001p-1022 0x0.0000000000001p-1022))
(assert_return (invoke "f64x2.pmin" (v128.const f64x2 0x0.0000000000001p-1022 0x0.0000000000001p-1022)
                                    (v128.const f64x2 0x0123456789ABCDEFabcdef.0123456789ABCDEFabcdefp019 0x0123456789ABCDEFabcdef.0123456789ABCDEFabcdefp019))
                                    (v128.const f64x2 0x0.0000000000001p-1022 0x0.0000000000001p-1022))
(assert_return (invoke "f64x2.pmin" (v128.const f64x2 0x0.0000000000001p-1022 0x0.0000000000001p-1022)
                                    (v128.const f64x2 0x0123456789ABCDEFabcdef.0123456789ABCDEFabcdefp+019 0x0123456789ABCDEFabcdef.0123456789ABCDEFabcdefp+019))
                                    (v128.const f64x2 0x0.0000000000001p-1022 0x0.0000000000001p-1022))
(assert_return (invoke "f64x2.pmin" (v128.const f64x2 0x0.0000000000001p-1022 0x0.0000000000001p-1022)
                                    (v128.const f64x2 0x0123456789ABCDEFabcdef.0123456789ABCDEFabcdefp-019 0x0123456789ABCDEFabcdef.0123456789ABCDEFabcdefp-019))
                                    (v128.const f64x2 0x0.0000000000001p-1022 0x0.0000000000001p-1022))
(assert_return (invoke "f64x2.pmin" (v128.const f64x2 0x0.0000000000001p-1022 0x0.0000000000001p-1022)
                                    (v128.const f64x2 0x0p+0 0x0p+0))
                                    (v128.const f64x2 0x0.0p+0 0x0.0p+0))
(assert_return (invoke "f64x2.pmin" (v128.const f64x2 0x0.0000000000001p-1022 0x0.0000000000001p-1022)
                                    (v128.const f64x2 -0x0p+0 -0x0p+0))
                                    (v128.const f64x2 -0x0.0p+0 -0x0.0p+0))
(assert_return (invoke "f64x2.pmin" (v128.const f64x2 0x0.0000000000001p-1022 0x0.0000000000001p-1022)
                                    (v128.const f64x2 0x1p-1022 0x1p-1022))
                                    (v128.const f64x2 0x0.0000000000001p-1022 0x0.0000000000001p-1022))
(assert_return (invoke "f64x2.pmin" (v128.const f64x2 0x0.0000000000001p-1022 0x0.0000000000001p-1022)
                                    (v128.const f64x2 -0x1p-1022 -0x1p-1022))
                                    (v128.const f64x2 -0x1.0000000000000p-1022 -0x1.0000000000000p-1022))
(assert_return (invoke "f64x2.pmin" (v128.const f64x2 0x0.0000000000001p-1022 0x0.0000000000001p-1022)
                                    (v128.const f64x2 0x1p-1 0x1p-1))
                                    (v128.const f64x2 0x0.0000000000001p-1022 0x0.0000000000001p-1022))
(assert_return (invoke "f64x2.pmin" (v128.const f64x2 0x0.0000000000001p-1022 0x0.0000000000001p-1022)
                                    (v128.const f64x2 -0x1p-1 -0x1p-1))
                                    (v128.const f64x2 -0x1.0000000000000p-1 -0x1.0000000000000p-1))
(assert_return (invoke "f64x2.pmin" (v128.const f64x2 0x0.0000000000001p-1022 0x0.0000000000001p-1022)
                                    (v128.const f64x2 0x1p+0 0x1p+0))
                                    (v128.const f64x2 0x0.0000000000001p-1022 0x0.0000000000001p-1022))
(assert_return (invoke "f64x2.pmin" (v128.const f64x2 0x0.0000000000001p-1022 0x0.0000000000001p-1022)
                                    (v128.const f64x2 -0x1p+0 -0x1p+0))
                                    (v128.const f64x2 -0x1.0000000000000p+0 -0x1.0000000000000p+0))
(assert_return (invoke "f64x2.pmin" (v128.const f64x2 0x0.0000000000001p-1022 0x0.0000000000001p-1022)
                                    (v128.const f64x2 0x1.921fb54442d18p+2 0x1.921fb54442d18p+2))
                                    (v128.const f64x2 0x0.0000000000001p-1022 0x0.0000000000001p-1022))
(assert_return (invoke "f64x2.pmin" (v128.const f64x2 0x0.0000000000001p-1022 0x0.0000000000001p-1022)
                                    (v128.const f64x2 -0x1.921fb54442d18p+2 -0x1.921fb54442d18p+2))
                                    (v128.const f64x2 -0x1.921fb54442d18p+2 -0x1.921fb54442d18p+2))
(assert_return (invoke "f64x2.pmin" (v128.const f64x2 0x0.0000000000001p-1022 0x0.0000000000001p-1022)
                                    (v128.const f64x2 0x1.fffffffffffffp+1023 0x1.fffffffffffffp+1023))
                                    (v128.const f64x2 0x0.0000000000001p-1022 0x0.0000000000001p-1022))
(assert_return (invoke "f64x2.pmin" (v128.const f64x2 0x0.0000000000001p-1022 0x0.0000000000001p-1022)
                                    (v128.const f64x2 -0x1.fffffffffffffp+1023 -0x1.fffffffffffffp+1023))
                                    (v128.const f64x2 -0x1.fffffffffffffp+1023 -0x1.fffffffffffffp+1023))
(assert_return (invoke "f64x2.pmin" (v128.const f64x2 0x0.0000000000001p-1022 0x0.0000000000001p-1022)
                                    (v128.const f64x2 0x0.0000000000001p-1022 0x0.0000000000001p-1022))
                                    (v128.const f64x2 0x0.0000000000001p-1022 0x0.0000000000001p-1022))
(assert_return (invoke "f64x2.pmin" (v128.const f64x2 0x0.0000000000001p-1022 0x0.0000000000001p-1022)
                                    (v128.const f64x2 0x0.0000000000001p-1022 0x0.0000000000001p-1022))
                                    (v128.const f64x2 0x0.0000000000001p-1022 0x0.0000000000001p-1022))
(assert_return (invoke "f64x2.pmin" (v128.const f64x2 0x0.0000000000001p-1022 0x0.0000000000001p-1022)
                                    (v128.const f64x2 inf inf))
                                    (v128.const f64x2 0x0.0000000000001p-1022 0x0.0000000000001p-1022))
(assert_return (invoke "f64x2.pmin" (v128.const f64x2 0x0.0000000000001p-1022 0x0.0000000000001p-1022)
                                    (v128.const f64x2 -inf -inf))
                                    (v128.const f64x2 -inf -inf))
(assert_return (invoke "f64x2.pmin" (v128.const f64x2 0x0.0000000000001p-1022 0x0.0000000000001p-1022)
                                    (v128.const f64x2 0123456789 0123456789))
                                    (v128.const f64x2 0x0.0000000000001p-1022 0x0.0000000000001p-1022))
(assert_return (invoke "f64x2.pmin" (v128.const f64x2 0x0.0000000000001p-1022 0x0.0000000000001p-1022)
                                    (v128.const f64x2 0123456789e019 0123456789e019))
                                    (v128.const f64x2 0x0.0000000000001p-1022 0x0.0000000000001p-1022))
(assert_return (invoke "f64x2.pmin" (v128.const f64x2 0x0.0000000000001p-1022 0x0.0000000000001p-1022)
                                    (v128.const f64x2 0123456789e+019 0123456789e+019))
                                    (v128.const f64x2 0x0.0000000000001p-1022 0x0.0000000000001p-1022))
(assert_return (invoke "f64x2.pmin" (v128.const f64x2 0x0.0000000000001p-1022 0x0.0000000000001p-1022)
                                    (v128.const f64x2 0123456789e-019 0123456789e-019))
                                    (v128.const f64x2 0x0.0000000000001p-1022 0x0.0000000000001p-1022))
(assert_return (invoke "f64x2.pmin" (v128.const f64x2 0x0.0000000000001p-1022 0x0.0000000000001p-1022)
                                    (v128.const f64x2 0123456789. 0123456789.))
                                    (v128.const f64x2 0x0.0000000000001p-1022 0x0.0000000000001p-1022))
(assert_return (invoke "f64x2.pmin" (v128.const f64x2 0x0.0000000000001p-1022 0x0.0000000000001p-1022)
                                    (v128.const f64x2 0123456789.e019 0123456789.e019))
                                    (v128.const f64x2 0x0.0000000000001p-1022 0x0.0000000000001p-1022))
(assert_return (invoke "f64x2.pmin" (v128.const f64x2 0x0.0000000000001p-1022 0x0.0000000000001p-1022)
                                    (v128.const f64x2 0123456789.e+019 0123456789.e+019))
                                    (v128.const f64x2 0x0.0000000000001p-1022 0x0.0000000000001p-1022))
(assert_return (invoke "f64x2.pmin" (v128.const f64x2 0x0.0000000000001p-1022 0x0.0000000000001p-1022)
                                    (v128.const f64x2 0123456789.e-019 0123456789.e-019))
                                    (v128.const f64x2 0x0.0000000000001p-1022 0x0.0000000000001p-1022))
(assert_return (invoke "f64x2.pmin" (v128.const f64x2 0x0.0000000000001p-1022 0x0.0000000000001p-1022)
                                    (v128.const f64x2 0123456789.0123456789 0123456789.0123456789))
                                    (v128.const f64x2 0x0.0000000000001p-1022 0x0.0000000000001p-1022))
(assert_return (invoke "f64x2.pmin" (v128.const f64x2 0x0.0000000000001p-1022 0x0.0000000000001p-1022)
                                    (v128.const f64x2 0123456789.0123456789e019 0123456789.0123456789e019))
                                    (v128.const f64x2 0x0.0000000000001p-1022 0x0.0000000000001p-1022))
(assert_return (invoke "f64x2.pmin" (v128.const f64x2 0x0.0000000000001p-1022 0x0.0000000000001p-1022)
                                    (v128.const f64x2 0123456789.0123456789e+019 0123456789.0123456789e+019))
                                    (v128.const f64x2 0x0.0000000000001p-1022 0x0.0000000000001p-1022))
(assert_return (invoke "f64x2.pmin" (v128.const f64x2 0x0.0000000000001p-1022 0x0.0000000000001p-1022)
                                    (v128.const f64x2 0123456789.0123456789e-019 0123456789.0123456789e-019))
                                    (v128.const f64x2 0x0.0000000000001p-1022 0x0.0000000000001p-1022))
(assert_return (invoke "f64x2.pmin" (v128.const f64x2 0x0.0000000000001p-1022 0x0.0000000000001p-1022)
                                    (v128.const f64x2 0x0123456789ABCDEFabcdef 0x0123456789ABCDEFabcdef))
                                    (v128.const f64x2 0x0.0000000000001p-1022 0x0.0000000000001p-1022))
(assert_return (invoke "f64x2.pmin" (v128.const f64x2 0x0.0000000000001p-1022 0x0.0000000000001p-1022)
                                    (v128.const f64x2 0x0123456789ABCDEFabcdefp019 0x0123456789ABCDEFabcdefp019))
                                    (v128.const f64x2 0x0.0000000000001p-1022 0x0.0000000000001p-1022))
(assert_return (invoke "f64x2.pmin" (v128.const f64x2 0x0.0000000000001p-1022 0x0.0000000000001p-1022)
                                    (v128.const f64x2 0x0123456789ABCDEFabcdefp+019 0x0123456789ABCDEFabcdefp+019))
                                    (v128.const f64x2 0x0.0000000000001p-1022 0x0.0000000000001p-1022))
(assert_return (invoke "f64x2.pmin" (v128.const f64x2 0x0.0000000000001p-1022 0x0.0000000000001p-1022)
                                    (v128.const f64x2 0x0123456789ABCDEFabcdefp-019 0x0123456789ABCDEFabcdefp-019))
                                    (v128.const f64x2 0x0.0000000000001p-1022 0x0.0000000000001p-1022))
(assert_return (invoke "f64x2.pmin" (v128.const f64x2 0x0.0000000000001p-1022 0x0.0000000000001p-1022)
                                    (v128.const f64x2 0x0123456789ABCDEFabcdef. 0x0123456789ABCDEFabcdef.))
                                    (v128.const f64x2 0x0.0000000000001p-1022 0x0.0000000000001p-1022))
(assert_return (invoke "f64x2.pmin" (v128.const f64x2 0x0.0000000000001p-1022 0x0.0000000000001p-1022)
                                    (v128.const f64x2 0x0123456789ABCDEFabcdef.p019 0x0123456789ABCDEFabcdef.p019))
                                    (v128.const f64x2 0x0.0000000000001p-1022 0x0.0000000000001p-1022))
(assert_return (invoke "f64x2.pmin" (v128.const f64x2 0x0.0000000000001p-1022 0x0.0000000000001p-1022)
                                    (v128.const f64x2 0x0123456789ABCDEFabcdef.p+019 0x0123456789ABCDEFabcdef.p+019))
                                    (v128.const f64x2 0x0.0000000000001p-1022 0x0.0000000000001p-1022))
(assert_return (invoke "f64x2.pmin" (v128.const f64x2 0x0.0000000000001p-1022 0x0.0000000000001p-1022)
                                    (v128.const f64x2 0x0123456789ABCDEFabcdef.p-019 0x0123456789ABCDEFabcdef.p-019))
                                    (v128.const f64x2 0x0.0000000000001p-1022 0x0.0000000000001p-1022))
(assert_return (invoke "f64x2.pmin" (v128.const f64x2 0x0.0000000000001p-1022 0x0.0000000000001p-1022)
                                    (v128.const f64x2 0x0123456789ABCDEFabcdef.0123456789ABCDEFabcdef 0x0123456789ABCDEFabcdef.0123456789ABCDEFabcdef))
                                    (v128.const f64x2 0x0.0000000000001p-1022 0x0.0000000000001p-1022))
(assert_return (invoke "f64x2.pmin" (v128.const f64x2 0x0.0000000000001p-1022 0x0.0000000000001p-1022)
                                    (v128.const f64x2 0x0123456789ABCDEFabcdef.0123456789ABCDEFabcdefp019 0x0123456789ABCDEFabcdef.0123456789ABCDEFabcdefp019))
                                    (v128.const f64x2 0x0.0000000000001p-1022 0x0.0000000000001p-1022))
(assert_return (invoke "f64x2.pmin" (v128.const f64x2 0x0.0000000000001p-1022 0x0.0000000000001p-1022)
                                    (v128.const f64x2 0x0123456789ABCDEFabcdef.0123456789ABCDEFabcdefp+019 0x0123456789ABCDEFabcdef.0123456789ABCDEFabcdefp+019))
                                    (v128.const f64x2 0x0.0000000000001p-1022 0x0.0000000000001p-1022))
(assert_return (invoke "f64x2.pmin" (v128.const f64x2 0x0.0000000000001p-1022 0x0.0000000000001p-1022)
                                    (v128.const f64x2 0x0123456789ABCDEFabcdef.0123456789ABCDEFabcdefp-019 0x0123456789ABCDEFabcdef.0123456789ABCDEFabcdefp-019))
                                    (v128.const f64x2 0x0.0000000000001p-1022 0x0.0000000000001p-1022))
(assert_return (invoke "f64x2.pmin" (v128.const f64x2 inf inf)
                                    (v128.const f64x2 0x0p+0 0x0p+0))
                                    (v128.const f64x2 0x0.0p+0 0x0.0p+0))
(assert_return (invoke "f64x2.pmin" (v128.const f64x2 inf inf)
                                    (v128.const f64x2 -0x0p+0 -0x0p+0))
                                    (v128.const f64x2 -0x0.0p+0 -0x0.0p+0))
(assert_return (invoke "f64x2.pmin" (v128.const f64x2 inf inf)
                                    (v128.const f64x2 0x1p-1022 0x1p-1022))
                                    (v128.const f64x2 0x1.0000000000000p-1022 0x1.0000000000000p-1022))
(assert_return (invoke "f64x2.pmin" (v128.const f64x2 inf inf)
                                    (v128.const f64x2 -0x1p-1022 -0x1p-1022))
                                    (v128.const f64x2 -0x1.0000000000000p-1022 -0x1.0000000000000p-1022))
(assert_return (invoke "f64x2.pmin" (v128.const f64x2 inf inf)
                                    (v128.const f64x2 0x1p-1 0x1p-1))
                                    (v128.const f64x2 0x1.0000000000000p-1 0x1.0000000000000p-1))
(assert_return (invoke "f64x2.pmin" (v128.const f64x2 inf inf)
                                    (v128.const f64x2 -0x1p-1 -0x1p-1))
                                    (v128.const f64x2 -0x1.0000000000000p-1 -0x1.0000000000000p-1))
(assert_return (invoke "f64x2.pmin" (v128.const f64x2 inf inf)
                                    (v128.const f64x2 0x1p+0 0x1p+0))
                                    (v128.const f64x2 0x1.0000000000000p+0 0x1.0000000000000p+0))
(assert_return (invoke "f64x2.pmin" (v128.const f64x2 inf inf)
                                    (v128.const f64x2 -0x1p+0 -0x1p+0))
                                    (v128.const f64x2 -0x1.0000000000000p+0 -0x1.0000000000000p+0))
(assert_return (invoke "f64x2.pmin" (v128.const f64x2 inf inf)
                                    (v128.const f64x2 0x1.921fb54442d18p+2 0x1.921fb54442d18p+2))
                                    (v128.const f64x2 0x1.921fb54442d18p+2 0x1.921fb54442d18p+2))
(assert_return (invoke "f64x2.pmin" (v128.const f64x2 inf inf)
                                    (v128.const f64x2 -0x1.921fb54442d18p+2 -0x1.921fb54442d18p+2))
                                    (v128.const f64x2 -0x1.921fb54442d18p+2 -0x1.921fb54442d18p+2))
(assert_return (invoke "f64x2.pmin" (v128.const f64x2 inf inf)
                                    (v128.const f64x2 0x1.fffffffffffffp+1023 0x1.fffffffffffffp+1023))
                                    (v128.const f64x2 0x1.fffffffffffffp+1023 0x1.fffffffffffffp+1023))
(assert_return (invoke "f64x2.pmin" (v128.const f64x2 inf inf)
                                    (v128.const f64x2 -0x1.fffffffffffffp+1023 -0x1.fffffffffffffp+1023))
                                    (v128.const f64x2 -0x1.fffffffffffffp+1023 -0x1.fffffffffffffp+1023))
(assert_return (invoke "f64x2.pmin" (v128.const f64x2 inf inf)
                                    (v128.const f64x2 0x0.0000000000001p-1022 0x0.0000000000001p-1022))
                                    (v128.const f64x2 0x0.0000000000001p-1022 0x0.0000000000001p-1022))
(assert_return (invoke "f64x2.pmin" (v128.const f64x2 inf inf)
                                    (v128.const f64x2 0x0.0000000000001p-1022 0x0.0000000000001p-1022))
                                    (v128.const f64x2 0x0.0000000000001p-1022 0x0.0000000000001p-1022))
(assert_return (invoke "f64x2.pmin" (v128.const f64x2 inf inf)
                                    (v128.const f64x2 inf inf))
                                    (v128.const f64x2 inf inf))
(assert_return (invoke "f64x2.pmin" (v128.const f64x2 inf inf)
                                    (v128.const f64x2 -inf -inf))
                                    (v128.const f64x2 -inf -inf))
(assert_return (invoke "f64x2.pmin" (v128.const f64x2 inf inf)
                                    (v128.const f64x2 0123456789 0123456789))
                                    (v128.const f64x2 0x1.d6f3454000000p+26 0x1.d6f3454000000p+26))
(assert_return (invoke "f64x2.pmin" (v128.const f64x2 inf inf)
                                    (v128.const f64x2 0123456789e019 0123456789e019))
                                    (v128.const f64x2 0x1.fe9af5b5e16fap+89 0x1.fe9af5b5e16fap+89))
(assert_return (invoke "f64x2.pmin" (v128.const f64x2 inf inf)
                                    (v128.const f64x2 0123456789e+019 0123456789e+019))
                                    (v128.const f64x2 0x1.fe9af5b5e16fap+89 0x1.fe9af5b5e16fap+89))
(assert_return (invoke "f64x2.pmin" (v128.const f64x2 inf inf)
                                    (v128.const f64x2 0123456789e-019 0123456789e-019))
                                    (v128.const f64x2 0x1.b25ffd62b4311p-37 0x1.b25ffd62b4311p-37))
(assert_return (invoke "f64x2.pmin" (v128.const f64x2 inf inf)
                                    (v128.const f64x2 0123456789. 0123456789.))
                                    (v128.const f64x2 0x1.d6f3454000000p+26 0x1.d6f3454000000p+26))
(assert_return (invoke "f64x2.pmin" (v128.const f64x2 inf inf)
                                    (v128.const f64x2 0123456789.e019 0123456789.e019))
                                    (v128.const f64x2 0x1.fe9af5b5e16fap+89 0x1.fe9af5b5e16fap+89))
(assert_return (invoke "f64x2.pmin" (v128.const f64x2 inf inf)
                                    (v128.const f64x2 0123456789.e+019 0123456789.e+019))
                                    (v128.const f64x2 0x1.fe9af5b5e16fap+89 0x1.fe9af5b5e16fap+89))
(assert_return (invoke "f64x2.pmin" (v128.const f64x2 inf inf)
                                    (v128.const f64x2 0123456789.e-019 0123456789.e-019))
                                    (v128.const f64x2 0x1.b25ffd62b4311p-37 0x1.b25ffd62b4311p-37))
(assert_return (invoke "f64x2.pmin" (v128.const f64x2 inf inf)
                                    (v128.const f64x2 0123456789.0123456789 0123456789.0123456789))
                                    (v128.const f64x2 0x1.d6f34540ca458p+26 0x1.d6f34540ca458p+26))
(assert_return (invoke "f64x2.pmin" (v128.const f64x2 inf inf)
                                    (v128.const f64x2 0123456789.0123456789e019 0123456789.0123456789e019))
                                    (v128.const f64x2 0x1.fe9af5b6bcbd5p+89 0x1.fe9af5b6bcbd5p+89))
(assert_return (invoke "f64x2.pmin" (v128.const f64x2 inf inf)
                                    (v128.const f64x2 0123456789.0123456789e+019 0123456789.0123456789e+019))
                                    (v128.const f64x2 0x1.fe9af5b6bcbd5p+89 0x1.fe9af5b6bcbd5p+89))
(assert_return (invoke "f64x2.pmin" (v128.const f64x2 inf inf)
                                    (v128.const f64x2 0123456789.0123456789e-019 0123456789.0123456789e-019))
                                    (v128.const f64x2 0x1.b25ffd636ec12p-37 0x1.b25ffd636ec12p-37))
(assert_return (invoke "f64x2.pmin" (v128.const f64x2 inf inf)
                                    (v128.const f64x2 0x0123456789ABCDEFabcdef 0x0123456789ABCDEFabcdef))
                                    (v128.const f64x2 0x1.23456789abcdfp+80 0x1.23456789abcdfp+80))
(assert_return (invoke "f64x2.pmin" (v128.const f64x2 inf inf)
                                    (v128.const f64x2 0x0123456789ABCDEFabcdefp019 0x0123456789ABCDEFabcdefp019))
                                    (v128.const f64x2 0x1.23456789abcdfp+99 0x1.23456789abcdfp+99))
(assert_return (invoke "f64x2.pmin" (v128.const f64x2 inf inf)
                                    (v128.const f64x2 0x0123456789ABCDEFabcdefp+019 0x0123456789ABCDEFabcdefp+019))
                                    (v128.const f64x2 0x1.23456789abcdfp+99 0x1.23456789abcdfp+99))
(assert_return (invoke "f64x2.pmin" (v128.const f64x2 inf inf)
                                    (v128.const f64x2 0x0123456789ABCDEFabcdefp-019 0x0123456789ABCDEFabcdefp-019))
                                    (v128.const f64x2 0x1.23456789abcdfp+61 0x1.23456789abcdfp+61))
(assert_return (invoke "f64x2.pmin" (v128.const f64x2 inf inf)
                                    (v128.const f64x2 0x0123456789ABCDEFabcdef. 0x0123456789ABCDEFabcdef.))
                                    (v128.const f64x2 0x1.23456789abcdfp+80 0x1.23456789abcdfp+80))
(assert_return (invoke "f64x2.pmin" (v128.const f64x2 inf inf)
                                    (v128.const f64x2 0x0123456789ABCDEFabcdef.p019 0x0123456789ABCDEFabcdef.p019))
                                    (v128.const f64x2 0x1.23456789abcdfp+99 0x1.23456789abcdfp+99))
(assert_return (invoke "f64x2.pmin" (v128.const f64x2 inf inf)
                                    (v128.const f64x2 0x0123456789ABCDEFabcdef.p+019 0x0123456789ABCDEFabcdef.p+019))
                                    (v128.const f64x2 0x1.23456789abcdfp+99 0x1.23456789abcdfp+99))
(assert_return (invoke "f64x2.pmin" (v128.const f64x2 inf inf)
                                    (v128.const f64x2 0x0123456789ABCDEFabcdef.p-019 0x0123456789ABCDEFabcdef.p-019))
                                    (v128.const f64x2 0x1.23456789abcdfp+61 0x1.23456789abcdfp+61))
(assert_return (invoke "f64x2.pmin" (v128.const f64x2 inf inf)
                                    (v128.const f64x2 0x0123456789ABCDEFabcdef.0123456789ABCDEFabcdef 0x0123456789ABCDEFabcdef.0123456789ABCDEFabcdef))
                                    (v128.const f64x2 0x1.23456789abcdfp+80 0x1.23456789abcdfp+80))
(assert_return (invoke "f64x2.pmin" (v128.const f64x2 inf inf)
                                    (v128.const f64x2 0x0123456789ABCDEFabcdef.0123456789ABCDEFabcdefp019 0x0123456789ABCDEFabcdef.0123456789ABCDEFabcdefp019))
                                    (v128.const f64x2 0x1.23456789abcdfp+99 0x1.23456789abcdfp+99))
(assert_return (invoke "f64x2.pmin" (v128.const f64x2 inf inf)
                                    (v128.const f64x2 0x0123456789ABCDEFabcdef.0123456789ABCDEFabcdefp+019 0x0123456789ABCDEFabcdef.0123456789ABCDEFabcdefp+019))
                                    (v128.const f64x2 0x1.23456789abcdfp+99 0x1.23456789abcdfp+99))
(assert_return (invoke "f64x2.pmin" (v128.const f64x2 inf inf)
                                    (v128.const f64x2 0x0123456789ABCDEFabcdef.0123456789ABCDEFabcdefp-019 0x0123456789ABCDEFabcdef.0123456789ABCDEFabcdefp-019))
                                    (v128.const f64x2 0x1.23456789abcdfp+61 0x1.23456789abcdfp+61))
(assert_return (invoke "f64x2.pmin" (v128.const f64x2 -inf -inf)
                                    (v128.const f64x2 0x0p+0 0x0p+0))
                                    (v128.const f64x2 -inf -inf))
(assert_return (invoke "f64x2.pmin" (v128.const f64x2 -inf -inf)
                                    (v128.const f64x2 -0x0p+0 -0x0p+0))
                                    (v128.const f64x2 -inf -inf))
(assert_return (invoke "f64x2.pmin" (v128.const f64x2 -inf -inf)
                                    (v128.const f64x2 0x1p-1022 0x1p-1022))
                                    (v128.const f64x2 -inf -inf))
(assert_return (invoke "f64x2.pmin" (v128.const f64x2 -inf -inf)
                                    (v128.const f64x2 -0x1p-1022 -0x1p-1022))
                                    (v128.const f64x2 -inf -inf))
(assert_return (invoke "f64x2.pmin" (v128.const f64x2 -inf -inf)
                                    (v128.const f64x2 0x1p-1 0x1p-1))
                                    (v128.const f64x2 -inf -inf))
(assert_return (invoke "f64x2.pmin" (v128.const f64x2 -inf -inf)
                                    (v128.const f64x2 -0x1p-1 -0x1p-1))
                                    (v128.const f64x2 -inf -inf))
(assert_return (invoke "f64x2.pmin" (v128.const f64x2 -inf -inf)
                                    (v128.const f64x2 0x1p+0 0x1p+0))
                                    (v128.const f64x2 -inf -inf))
(assert_return (invoke "f64x2.pmin" (v128.const f64x2 -inf -inf)
                                    (v128.const f64x2 -0x1p+0 -0x1p+0))
                                    (v128.const f64x2 -inf -inf))
(assert_return (invoke "f64x2.pmin" (v128.const f64x2 -inf -inf)
                                    (v128.const f64x2 0x1.921fb54442d18p+2 0x1.921fb54442d18p+2))
                                    (v128.const f64x2 -inf -inf))
(assert_return (invoke "f64x2.pmin" (v128.const f64x2 -inf -inf)
                                    (v128.const f64x2 -0x1.921fb54442d18p+2 -0x1.921fb54442d18p+2))
                                    (v128.const f64x2 -inf -inf))
(assert_return (invoke "f64x2.pmin" (v128.const f64x2 -inf -inf)
                                    (v128.const f64x2 0x1.fffffffffffffp+1023 0x1.fffffffffffffp+1023))
                                    (v128.const f64x2 -inf -inf))
(assert_return (invoke "f64x2.pmin" (v128.const f64x2 -inf -inf)
                                    (v128.const f64x2 -0x1.fffffffffffffp+1023 -0x1.fffffffffffffp+1023))
                                    (v128.const f64x2 -inf -inf))
(assert_return (invoke "f64x2.pmin" (v128.const f64x2 -inf -inf)
                                    (v128.const f64x2 0x0.0000000000001p-1022 0x0.0000000000001p-1022))
                                    (v128.const f64x2 -inf -inf))
(assert_return (invoke "f64x2.pmin" (v128.const f64x2 -inf -inf)
                                    (v128.const f64x2 0x0.0000000000001p-1022 0x0.0000000000001p-1022))
                                    (v128.const f64x2 -inf -inf))
(assert_return (invoke "f64x2.pmin" (v128.const f64x2 -inf -inf)
                                    (v128.const f64x2 inf inf))
                                    (v128.const f64x2 -inf -inf))
(assert_return (invoke "f64x2.pmin" (v128.const f64x2 -inf -inf)
                                    (v128.const f64x2 -inf -inf))
                                    (v128.const f64x2 -inf -inf))
(assert_return (invoke "f64x2.pmin" (v128.const f64x2 -inf -inf)
                                    (v128.const f64x2 0123456789 0123456789))
                                    (v128.const f64x2 -inf -inf))
(assert_return (invoke "f64x2.pmin" (v128.const f64x2 -inf -inf)
                                    (v128.const f64x2 0123456789e019 0123456789e019))
                                    (v128.const f64x2 -inf -inf))
(assert_return (invoke "f64x2.pmin" (v128.const f64x2 -inf -inf)
                                    (v128.const f64x2 0123456789e+019 0123456789e+019))
                                    (v128.const f64x2 -inf -inf))
(assert_return (invoke "f64x2.pmin" (v128.const f64x2 -inf -inf)
                                    (v128.const f64x2 0123456789e-019 0123456789e-019))
                                    (v128.const f64x2 -inf -inf))
(assert_return (invoke "f64x2.pmin" (v128.const f64x2 -inf -inf)
                                    (v128.const f64x2 0123456789. 0123456789.))
                                    (v128.const f64x2 -inf -inf))
(assert_return (invoke "f64x2.pmin" (v128.const f64x2 -inf -inf)
                                    (v128.const f64x2 0123456789.e019 0123456789.e019))
                                    (v128.const f64x2 -inf -inf))
(assert_return (invoke "f64x2.pmin" (v128.const f64x2 -inf -inf)
                                    (v128.const f64x2 0123456789.e+019 0123456789.e+019))
                                    (v128.const f64x2 -inf -inf))
(assert_return (invoke "f64x2.pmin" (v128.const f64x2 -inf -inf)
                                    (v128.const f64x2 0123456789.e-019 0123456789.e-019))
                                    (v128.const f64x2 -inf -inf))
(assert_return (invoke "f64x2.pmin" (v128.const f64x2 -inf -inf)
                                    (v128.const f64x2 0123456789.0123456789 0123456789.0123456789))
                                    (v128.const f64x2 -inf -inf))
(assert_return (invoke "f64x2.pmin" (v128.const f64x2 -inf -inf)
                                    (v128.const f64x2 0123456789.0123456789e019 0123456789.0123456789e019))
                                    (v128.const f64x2 -inf -inf))
(assert_return (invoke "f64x2.pmin" (v128.const f64x2 -inf -inf)
                                    (v128.const f64x2 0123456789.0123456789e+019 0123456789.0123456789e+019))
                                    (v128.const f64x2 -inf -inf))
(assert_return (invoke "f64x2.pmin" (v128.const f64x2 -inf -inf)
                                    (v128.const f64x2 0123456789.0123456789e-019 0123456789.0123456789e-019))
                                    (v128.const f64x2 -inf -inf))
(assert_return (invoke "f64x2.pmin" (v128.const f64x2 -inf -inf)
                                    (v128.const f64x2 0x0123456789ABCDEFabcdef 0x0123456789ABCDEFabcdef))
                                    (v128.const f64x2 -inf -inf))
(assert_return (invoke "f64x2.pmin" (v128.const f64x2 -inf -inf)
                                    (v128.const f64x2 0x0123456789ABCDEFabcdefp019 0x0123456789ABCDEFabcdefp019))
                                    (v128.const f64x2 -inf -inf))
(assert_return (invoke "f64x2.pmin" (v128.const f64x2 -inf -inf)
                                    (v128.const f64x2 0x0123456789ABCDEFabcdefp+019 0x0123456789ABCDEFabcdefp+019))
                                    (v128.const f64x2 -inf -inf))
(assert_return (invoke "f64x2.pmin" (v128.const f64x2 -inf -inf)
                                    (v128.const f64x2 0x0123456789ABCDEFabcdefp-019 0x0123456789ABCDEFabcdefp-019))
                                    (v128.const f64x2 -inf -inf))
(assert_return (invoke "f64x2.pmin" (v128.const f64x2 -inf -inf)
                                    (v128.const f64x2 0x0123456789ABCDEFabcdef. 0x0123456789ABCDEFabcdef.))
                                    (v128.const f64x2 -inf -inf))
(assert_return (invoke "f64x2.pmin" (v128.const f64x2 -inf -inf)
                                    (v128.const f64x2 0x0123456789ABCDEFabcdef.p019 0x0123456789ABCDEFabcdef.p019))
                                    (v128.const f64x2 -inf -inf))
(assert_return (invoke "f64x2.pmin" (v128.const f64x2 -inf -inf)
                                    (v128.const f64x2 0x0123456789ABCDEFabcdef.p+019 0x0123456789ABCDEFabcdef.p+019))
                                    (v128.const f64x2 -inf -inf))
(assert_return (invoke "f64x2.pmin" (v128.const f64x2 -inf -inf)
                                    (v128.const f64x2 0x0123456789ABCDEFabcdef.p-019 0x0123456789ABCDEFabcdef.p-019))
                                    (v128.const f64x2 -inf -inf))
(assert_return (invoke "f64x2.pmin" (v128.const f64x2 -inf -inf)
                                    (v128.const f64x2 0x0123456789ABCDEFabcdef.0123456789ABCDEFabcdef 0x0123456789ABCDEFabcdef.0123456789ABCDEFabcdef))
                                    (v128.const f64x2 -inf -inf))
(assert_return (invoke "f64x2.pmin" (v128.const f64x2 -inf -inf)
                                    (v128.const f64x2 0x0123456789ABCDEFabcdef.0123456789ABCDEFabcdefp019 0x0123456789ABCDEFabcdef.0123456789ABCDEFabcdefp019))
                                    (v128.const f64x2 -inf -inf))
(assert_return (invoke "f64x2.pmin" (v128.const f64x2 -inf -inf)
                                    (v128.const f64x2 0x0123456789ABCDEFabcdef.0123456789ABCDEFabcdefp+019 0x0123456789ABCDEFabcdef.0123456789ABCDEFabcdefp+019))
                                    (v128.const f64x2 -inf -inf))
(assert_return (invoke "f64x2.pmin" (v128.const f64x2 -inf -inf)
                                    (v128.const f64x2 0x0123456789ABCDEFabcdef.0123456789ABCDEFabcdefp-019 0x0123456789ABCDEFabcdef.0123456789ABCDEFabcdefp-019))
                                    (v128.const f64x2 -inf -inf))
(assert_return (invoke "f64x2.pmin" (v128.const f64x2 0123456789 0123456789)
                                    (v128.const f64x2 0x0p+0 0x0p+0))
                                    (v128.const f64x2 0x0.0p+0 0x0.0p+0))
(assert_return (invoke "f64x2.pmin" (v128.const f64x2 0123456789 0123456789)
                                    (v128.const f64x2 -0x0p+0 -0x0p+0))
                                    (v128.const f64x2 -0x0.0p+0 -0x0.0p+0))
(assert_return (invoke "f64x2.pmin" (v128.const f64x2 0123456789 0123456789)
                                    (v128.const f64x2 0x1p-1022 0x1p-1022))
                                    (v128.const f64x2 0x1.0000000000000p-1022 0x1.0000000000000p-1022))
(assert_return (invoke "f64x2.pmin" (v128.const f64x2 0123456789 0123456789)
                                    (v128.const f64x2 -0x1p-1022 -0x1p-1022))
                                    (v128.const f64x2 -0x1.0000000000000p-1022 -0x1.0000000000000p-1022))
(assert_return (invoke "f64x2.pmin" (v128.const f64x2 0123456789 0123456789)
                                    (v128.const f64x2 0x1p-1 0x1p-1))
                                    (v128.const f64x2 0x1.0000000000000p-1 0x1.0000000000000p-1))
(assert_return (invoke "f64x2.pmin" (v128.const f64x2 0123456789 0123456789)
                                    (v128.const f64x2 -0x1p-1 -0x1p-1))
                                    (v128.const f64x2 -0x1.0000000000000p-1 -0x1.0000000000000p-1))
(assert_return (invoke "f64x2.pmin" (v128.const f64x2 0123456789 0123456789)
                                    (v128.const f64x2 0x1p+0 0x1p+0))
                                    (v128.const f64x2 0x1.0000000000000p+0 0x1.0000000000000p+0))
(assert_return (invoke "f64x2.pmin" (v128.const f64x2 0123456789 0123456789)
                                    (v128.const f64x2 -0x1p+0 -0x1p+0))
                                    (v128.const f64x2 -0x1.0000000000000p+0 -0x1.0000000000000p+0))
(assert_return (invoke "f64x2.pmin" (v128.const f64x2 0123456789 0123456789)
                                    (v128.const f64x2 0x1.921fb54442d18p+2 0x1.921fb54442d18p+2))
                                    (v128.const f64x2 0x1.921fb54442d18p+2 0x1.921fb54442d18p+2))
(assert_return (invoke "f64x2.pmin" (v128.const f64x2 0123456789 0123456789)
                                    (v128.const f64x2 -0x1.921fb54442d18p+2 -0x1.921fb54442d18p+2))
                                    (v128.const f64x2 -0x1.921fb54442d18p+2 -0x1.921fb54442d18p+2))
(assert_return (invoke "f64x2.pmin" (v128.const f64x2 0123456789 0123456789)
                                    (v128.const f64x2 0x1.fffffffffffffp+1023 0x1.fffffffffffffp+1023))
                                    (v128.const f64x2 0x1.d6f3454000000p+26 0x1.d6f3454000000p+26))
(assert_return (invoke "f64x2.pmin" (v128.const f64x2 0123456789 0123456789)
                                    (v128.const f64x2 -0x1.fffffffffffffp+1023 -0x1.fffffffffffffp+1023))
                                    (v128.const f64x2 -0x1.fffffffffffffp+1023 -0x1.fffffffffffffp+1023))
(assert_return (invoke "f64x2.pmin" (v128.const f64x2 0123456789 0123456789)
                                    (v128.const f64x2 0x0.0000000000001p-1022 0x0.0000000000001p-1022))
                                    (v128.const f64x2 0x0.0000000000001p-1022 0x0.0000000000001p-1022))
(assert_return (invoke "f64x2.pmin" (v128.const f64x2 0123456789 0123456789)
                                    (v128.const f64x2 0x0.0000000000001p-1022 0x0.0000000000001p-1022))
                                    (v128.const f64x2 0x0.0000000000001p-1022 0x0.0000000000001p-1022))
(assert_return (invoke "f64x2.pmin" (v128.const f64x2 0123456789 0123456789)
                                    (v128.const f64x2 inf inf))
                                    (v128.const f64x2 0x1.d6f3454000000p+26 0x1.d6f3454000000p+26))
(assert_return (invoke "f64x2.pmin" (v128.const f64x2 0123456789 0123456789)
                                    (v128.const f64x2 -inf -inf))
                                    (v128.const f64x2 -inf -inf))
(assert_return (invoke "f64x2.pmin" (v128.const f64x2 0123456789 0123456789)
                                    (v128.const f64x2 0123456789 0123456789))
                                    (v128.const f64x2 0x1.d6f3454000000p+26 0x1.d6f3454000000p+26))
(assert_return (invoke "f64x2.pmin" (v128.const f64x2 0123456789 0123456789)
                                    (v128.const f64x2 0123456789e019 0123456789e019))
                                    (v128.const f64x2 0x1.d6f3454000000p+26 0x1.d6f3454000000p+26))
(assert_return (invoke "f64x2.pmin" (v128.const f64x2 0123456789 0123456789)
                                    (v128.const f64x2 0123456789e+019 0123456789e+019))
                                    (v128.const f64x2 0x1.d6f3454000000p+26 0x1.d6f3454000000p+26))
(assert_return (invoke "f64x2.pmin" (v128.const f64x2 0123456789 0123456789)
                                    (v128.const f64x2 0123456789e-019 0123456789e-019))
                                    (v128.const f64x2 0x1.b25ffd62b4311p-37 0x1.b25ffd62b4311p-37))
(assert_return (invoke "f64x2.pmin" (v128.const f64x2 0123456789 0123456789)
                                    (v128.const f64x2 0123456789. 0123456789.))
                                    (v128.const f64x2 0x1.d6f3454000000p+26 0x1.d6f3454000000p+26))
(assert_return (invoke "f64x2.pmin" (v128.const f64x2 0123456789 0123456789)
                                    (v128.const f64x2 0123456789.e019 0123456789.e019))
                                    (v128.const f64x2 0x1.d6f3454000000p+26 0x1.d6f3454000000p+26))
(assert_return (invoke "f64x2.pmin" (v128.const f64x2 0123456789 0123456789)
                                    (v128.const f64x2 0123456789.e+019 0123456789.e+019))
                                    (v128.const f64x2 0x1.d6f3454000000p+26 0x1.d6f3454000000p+26))
(assert_return (invoke "f64x2.pmin" (v128.const f64x2 0123456789 0123456789)
                                    (v128.const f64x2 0123456789.e-019 0123456789.e-019))
                                    (v128.const f64x2 0x1.b25ffd62b4311p-37 0x1.b25ffd62b4311p-37))
(assert_return (invoke "f64x2.pmin" (v128.const f64x2 0123456789 0123456789)
                                    (v128.const f64x2 0123456789.0123456789 0123456789.0123456789))
                                    (v128.const f64x2 0x1.d6f3454000000p+26 0x1.d6f3454000000p+26))
(assert_return (invoke "f64x2.pmin" (v128.const f64x2 0123456789 0123456789)
                                    (v128.const f64x2 0123456789.0123456789e019 0123456789.0123456789e019))
                                    (v128.const f64x2 0x1.d6f3454000000p+26 0x1.d6f3454000000p+26))
(assert_return (invoke "f64x2.pmin" (v128.const f64x2 0123456789 0123456789)
                                    (v128.const f64x2 0123456789.0123456789e+019 0123456789.0123456789e+019))
                                    (v128.const f64x2 0x1.d6f3454000000p+26 0x1.d6f3454000000p+26))
(assert_return (invoke "f64x2.pmin" (v128.const f64x2 0123456789 0123456789)
                                    (v128.const f64x2 0123456789.0123456789e-019 0123456789.0123456789e-019))
                                    (v128.const f64x2 0x1.b25ffd636ec12p-37 0x1.b25ffd636ec12p-37))
(assert_return (invoke "f64x2.pmin" (v128.const f64x2 0123456789 0123456789)
                                    (v128.const f64x2 0x0123456789ABCDEFabcdef 0x0123456789ABCDEFabcdef))
                                    (v128.const f64x2 0x1.d6f3454000000p+26 0x1.d6f3454000000p+26))
(assert_return (invoke "f64x2.pmin" (v128.const f64x2 0123456789 0123456789)
                                    (v128.const f64x2 0x0123456789ABCDEFabcdefp019 0x0123456789ABCDEFabcdefp019))
                                    (v128.const f64x2 0x1.d6f3454000000p+26 0x1.d6f3454000000p+26))
(assert_return (invoke "f64x2.pmin" (v128.const f64x2 0123456789 0123456789)
                                    (v128.const f64x2 0x0123456789ABCDEFabcdefp+019 0x0123456789ABCDEFabcdefp+019))
                                    (v128.const f64x2 0x1.d6f3454000000p+26 0x1.d6f3454000000p+26))
(assert_return (invoke "f64x2.pmin" (v128.const f64x2 0123456789 0123456789)
                                    (v128.const f64x2 0x0123456789ABCDEFabcdefp-019 0x0123456789ABCDEFabcdefp-019))
                                    (v128.const f64x2 0x1.d6f3454000000p+26 0x1.d6f3454000000p+26))
(assert_return (invoke "f64x2.pmin" (v128.const f64x2 0123456789 0123456789)
                                    (v128.const f64x2 0x0123456789ABCDEFabcdef. 0x0123456789ABCDEFabcdef.))
                                    (v128.const f64x2 0x1.d6f3454000000p+26 0x1.d6f3454000000p+26))
(assert_return (invoke "f64x2.pmin" (v128.const f64x2 0123456789 0123456789)
                                    (v128.const f64x2 0x0123456789ABCDEFabcdef.p019 0x0123456789ABCDEFabcdef.p019))
                                    (v128.const f64x2 0x1.d6f3454000000p+26 0x1.d6f3454000000p+26))
(assert_return (invoke "f64x2.pmin" (v128.const f64x2 0123456789 0123456789)
                                    (v128.const f64x2 0x0123456789ABCDEFabcdef.p+019 0x0123456789ABCDEFabcdef.p+019))
                                    (v128.const f64x2 0x1.d6f3454000000p+26 0x1.d6f3454000000p+26))
(assert_return (invoke "f64x2.pmin" (v128.const f64x2 0123456789 0123456789)
                                    (v128.const f64x2 0x0123456789ABCDEFabcdef.p-019 0x0123456789ABCDEFabcdef.p-019))
                                    (v128.const f64x2 0x1.d6f3454000000p+26 0x1.d6f3454000000p+26))
(assert_return (invoke "f64x2.pmin" (v128.const f64x2 0123456789 0123456789)
                                    (v128.const f64x2 0x0123456789ABCDEFabcdef.0123456789ABCDEFabcdef 0x0123456789ABCDEFabcdef.0123456789ABCDEFabcdef))
                                    (v128.const f64x2 0x1.d6f3454000000p+26 0x1.d6f3454000000p+26))
(assert_return (invoke "f64x2.pmin" (v128.const f64x2 0123456789 0123456789)
                                    (v128.const f64x2 0x0123456789ABCDEFabcdef.0123456789ABCDEFabcdefp019 0x0123456789ABCDEFabcdef.0123456789ABCDEFabcdefp019))
                                    (v128.const f64x2 0x1.d6f3454000000p+26 0x1.d6f3454000000p+26))
(assert_return (invoke "f64x2.pmin" (v128.const f64x2 0123456789 0123456789)
                                    (v128.const f64x2 0x0123456789ABCDEFabcdef.0123456789ABCDEFabcdefp+019 0x0123456789ABCDEFabcdef.0123456789ABCDEFabcdefp+019))
                                    (v128.const f64x2 0x1.d6f3454000000p+26 0x1.d6f3454000000p+26))
(assert_return (invoke "f64x2.pmin" (v128.const f64x2 0123456789 0123456789)
                                    (v128.const f64x2 0x0123456789ABCDEFabcdef.0123456789ABCDEFabcdefp-019 0x0123456789ABCDEFabcdef.0123456789ABCDEFabcdefp-019))
                                    (v128.const f64x2 0x1.d6f3454000000p+26 0x1.d6f3454000000p+26))
(assert_return (invoke "f64x2.pmin" (v128.const f64x2 0123456789e019 0123456789e019)
                                    (v128.const f64x2 0x0p+0 0x0p+0))
                                    (v128.const f64x2 0x0.0p+0 0x0.0p+0))
(assert_return (invoke "f64x2.pmin" (v128.const f64x2 0123456789e019 0123456789e019)
                                    (v128.const f64x2 -0x0p+0 -0x0p+0))
                                    (v128.const f64x2 -0x0.0p+0 -0x0.0p+0))
(assert_return (invoke "f64x2.pmin" (v128.const f64x2 0123456789e019 0123456789e019)
                                    (v128.const f64x2 0x1p-1022 0x1p-1022))
                                    (v128.const f64x2 0x1.0000000000000p-1022 0x1.0000000000000p-1022))
(assert_return (invoke "f64x2.pmin" (v128.const f64x2 0123456789e019 0123456789e019)
                                    (v128.const f64x2 -0x1p-1022 -0x1p-1022))
                                    (v128.const f64x2 -0x1.0000000000000p-1022 -0x1.0000000000000p-1022))
(assert_return (invoke "f64x2.pmin" (v128.const f64x2 0123456789e019 0123456789e019)
                                    (v128.const f64x2 0x1p-1 0x1p-1))
                                    (v128.const f64x2 0x1.0000000000000p-1 0x1.0000000000000p-1))
(assert_return (invoke "f64x2.pmin" (v128.const f64x2 0123456789e019 0123456789e019)
                                    (v128.const f64x2 -0x1p-1 -0x1p-1))
                                    (v128.const f64x2 -0x1.0000000000000p-1 -0x1.0000000000000p-1))
(assert_return (invoke "f64x2.pmin" (v128.const f64x2 0123456789e019 0123456789e019)
                                    (v128.const f64x2 0x1p+0 0x1p+0))
                                    (v128.const f64x2 0x1.0000000000000p+0 0x1.0000000000000p+0))
(assert_return (invoke "f64x2.pmin" (v128.const f64x2 0123456789e019 0123456789e019)
                                    (v128.const f64x2 -0x1p+0 -0x1p+0))
                                    (v128.const f64x2 -0x1.0000000000000p+0 -0x1.0000000000000p+0))
(assert_return (invoke "f64x2.pmin" (v128.const f64x2 0123456789e019 0123456789e019)
                                    (v128.const f64x2 0x1.921fb54442d18p+2 0x1.921fb54442d18p+2))
                                    (v128.const f64x2 0x1.921fb54442d18p+2 0x1.921fb54442d18p+2))
(assert_return (invoke "f64x2.pmin" (v128.const f64x2 0123456789e019 0123456789e019)
                                    (v128.const f64x2 -0x1.921fb54442d18p+2 -0x1.921fb54442d18p+2))
                                    (v128.const f64x2 -0x1.921fb54442d18p+2 -0x1.921fb54442d18p+2))
(assert_return (invoke "f64x2.pmin" (v128.const f64x2 0123456789e019 0123456789e019)
                                    (v128.const f64x2 0x1.fffffffffffffp+1023 0x1.fffffffffffffp+1023))
                                    (v128.const f64x2 0x1.fe9af5b5e16fap+89 0x1.fe9af5b5e16fap+89))
(assert_return (invoke "f64x2.pmin" (v128.const f64x2 0123456789e019 0123456789e019)
                                    (v128.const f64x2 -0x1.fffffffffffffp+1023 -0x1.fffffffffffffp+1023))
                                    (v128.const f64x2 -0x1.fffffffffffffp+1023 -0x1.fffffffffffffp+1023))
(assert_return (invoke "f64x2.pmin" (v128.const f64x2 0123456789e019 0123456789e019)
                                    (v128.const f64x2 0x0.0000000000001p-1022 0x0.0000000000001p-1022))
                                    (v128.const f64x2 0x0.0000000000001p-1022 0x0.0000000000001p-1022))
(assert_return (invoke "f64x2.pmin" (v128.const f64x2 0123456789e019 0123456789e019)
                                    (v128.const f64x2 0x0.0000000000001p-1022 0x0.0000000000001p-1022))
                                    (v128.const f64x2 0x0.0000000000001p-1022 0x0.0000000000001p-1022))
(assert_return (invoke "f64x2.pmin" (v128.const f64x2 0123456789e019 0123456789e019)
                                    (v128.const f64x2 inf inf))
                                    (v128.const f64x2 0x1.fe9af5b5e16fap+89 0x1.fe9af5b5e16fap+89))
(assert_return (invoke "f64x2.pmin" (v128.const f64x2 0123456789e019 0123456789e019)
                                    (v128.const f64x2 -inf -inf))
                                    (v128.const f64x2 -inf -inf))
(assert_return (invoke "f64x2.pmin" (v128.const f64x2 0123456789e019 0123456789e019)
                                    (v128.const f64x2 0123456789 0123456789))
                                    (v128.const f64x2 0x1.d6f3454000000p+26 0x1.d6f3454000000p+26))
(assert_return (invoke "f64x2.pmin" (v128.const f64x2 0123456789e019 0123456789e019)
                                    (v128.const f64x2 0123456789e019 0123456789e019))
                                    (v128.const f64x2 0x1.fe9af5b5e16fap+89 0x1.fe9af5b5e16fap+89))
(assert_return (invoke "f64x2.pmin" (v128.const f64x2 0123456789e019 0123456789e019)
                                    (v128.const f64x2 0123456789e+019 0123456789e+019))
                                    (v128.const f64x2 0x1.fe9af5b5e16fap+89 0x1.fe9af5b5e16fap+89))
(assert_return (invoke "f64x2.pmin" (v128.const f64x2 0123456789e019 0123456789e019)
                                    (v128.const f64x2 0123456789e-019 0123456789e-019))
                                    (v128.const f64x2 0x1.b25ffd62b4311p-37 0x1.b25ffd62b4311p-37))
(assert_return (invoke "f64x2.pmin" (v128.const f64x2 0123456789e019 0123456789e019)
                                    (v128.const f64x2 0123456789. 0123456789.))
                                    (v128.const f64x2 0x1.d6f3454000000p+26 0x1.d6f3454000000p+26))
(assert_return (invoke "f64x2.pmin" (v128.const f64x2 0123456789e019 0123456789e019)
                                    (v128.const f64x2 0123456789.e019 0123456789.e019))
                                    (v128.const f64x2 0x1.fe9af5b5e16fap+89 0x1.fe9af5b5e16fap+89))
(assert_return (invoke "f64x2.pmin" (v128.const f64x2 0123456789e019 0123456789e019)
                                    (v128.const f64x2 0123456789.e+019 0123456789.e+019))
                                    (v128.const f64x2 0x1.fe9af5b5e16fap+89 0x1.fe9af5b5e16fap+89))
(assert_return (invoke "f64x2.pmin" (v128.const f64x2 0123456789e019 0123456789e019)
                                    (v128.const f64x2 0123456789.e-019 0123456789.e-019))
                                    (v128.const f64x2 0x1.b25ffd62b4311p-37 0x1.b25ffd62b4311p-37))
(assert_return (invoke "f64x2.pmin" (v128.const f64x2 0123456789e019 0123456789e019)
                                    (v128.const f64x2 0123456789.0123456789 0123456789.0123456789))
                                    (v128.const f64x2 0x1.d6f34540ca458p+26 0x1.d6f34540ca458p+26))
(assert_return (invoke "f64x2.pmin" (v128.const f64x2 0123456789e019 0123456789e019)
                                    (v128.const f64x2 0123456789.0123456789e019 0123456789.0123456789e019))
                                    (v128.const f64x2 0x1.fe9af5b5e16fap+89 0x1.fe9af5b5e16fap+89))
(assert_return (invoke "f64x2.pmin" (v128.const f64x2 0123456789e019 0123456789e019)
                                    (v128.const f64x2 0123456789.0123456789e+019 0123456789.0123456789e+019))
                                    (v128.const f64x2 0x1.fe9af5b5e16fap+89 0x1.fe9af5b5e16fap+89))
(assert_return (invoke "f64x2.pmin" (v128.const f64x2 0123456789e019 0123456789e019)
                                    (v128.const f64x2 0123456789.0123456789e-019 0123456789.0123456789e-019))
                                    (v128.const f64x2 0x1.b25ffd636ec12p-37 0x1.b25ffd636ec12p-37))
(assert_return (invoke "f64x2.pmin" (v128.const f64x2 0123456789e019 0123456789e019)
                                    (v128.const f64x2 0x0123456789ABCDEFabcdef 0x0123456789ABCDEFabcdef))
                                    (v128.const f64x2 0x1.23456789abcdfp+80 0x1.23456789abcdfp+80))
(assert_return (invoke "f64x2.pmin" (v128.const f64x2 0123456789e019 0123456789e019)
                                    (v128.const f64x2 0x0123456789ABCDEFabcdefp019 0x0123456789ABCDEFabcdefp019))
                                    (v128.const f64x2 0x1.fe9af5b5e16fap+89 0x1.fe9af5b5e16fap+89))
(assert_return (invoke "f64x2.pmin" (v128.const f64x2 0123456789e019 0123456789e019)
                                    (v128.const f64x2 0x0123456789ABCDEFabcdefp+019 0x0123456789ABCDEFabcdefp+019))
                                    (v128.const f64x2 0x1.fe9af5b5e16fap+89 0x1.fe9af5b5e16fap+89))
(assert_return (invoke "f64x2.pmin" (v128.const f64x2 0123456789e019 0123456789e019)
                                    (v128.const f64x2 0x0123456789ABCDEFabcdefp-019 0x0123456789ABCDEFabcdefp-019))
                                    (v128.const f64x2 0x1.23456789abcdfp+61 0x1.23456789abcdfp+61))
(assert_return (invoke "f64x2.pmin" (v128.const f64x2 0123456789e019 0123456789e019)
                                    (v128.const f64x2 0x0123456789ABCDEFabcdef. 0x0123456789ABCDEFabcdef.))
                                    (v128.const f64x2 0x1.23456789abcdfp+80 0x1.23456789abcdfp+80))
(assert_return (invoke "f64x2.pmin" (v128.const f64x2 0123456789e019 0123456789e019)
                                    (v128.const f64x2 0x0123456789ABCDEFabcdef.p019 0x0123456789ABCDEFabcdef.p019))
                                    (v128.const f64x2 0x1.fe9af5b5e16fap+89 0x1.fe9af5b5e16fap+89))
(assert_return (invoke "f64x2.pmin" (v128.const f64x2 0123456789e019 0123456789e019)
                                    (v128.const f64x2 0x0123456789ABCDEFabcdef.p+019 0x0123456789ABCDEFabcdef.p+019))
                                    (v128.const f64x2 0x1.fe9af5b5e16fap+89 0x1.fe9af5b5e16fap+89))
(assert_return (invoke "f64x2.pmin" (v128.const f64x2 0123456789e019 0123456789e019)
                                    (v128.const f64x2 0x0123456789ABCDEFabcdef.p-019 0x0123456789ABCDEFabcdef.p-019))
                                    (v128.const f64x2 0x1.23456789abcdfp+61 0x1.23456789abcdfp+61))
(assert_return (invoke "f64x2.pmin" (v128.const f64x2 0123456789e019 0123456789e019)
                                    (v128.const f64x2 0x0123456789ABCDEFabcdef.0123456789ABCDEFabcdef 0x0123456789ABCDEFabcdef.0123456789ABCDEFabcdef))
                                    (v128.const f64x2 0x1.23456789abcdfp+80 0x1.23456789abcdfp+80))
(assert_return (invoke "f64x2.pmin" (v128.const f64x2 0123456789e019 0123456789e019)
                                    (v128.const f64x2 0x0123456789ABCDEFabcdef.0123456789ABCDEFabcdefp019 0x0123456789ABCDEFabcdef.0123456789ABCDEFabcdefp019))
                                    (v128.const f64x2 0x1.fe9af5b5e16fap+89 0x1.fe9af5b5e16fap+89))
(assert_return (invoke "f64x2.pmin" (v128.const f64x2 0123456789e019 0123456789e019)
                                    (v128.const f64x2 0x0123456789ABCDEFabcdef.0123456789ABCDEFabcdefp+019 0x0123456789ABCDEFabcdef.0123456789ABCDEFabcdefp+019))
                                    (v128.const f64x2 0x1.fe9af5b5e16fap+89 0x1.fe9af5b5e16fap+89))
(assert_return (invoke "f64x2.pmin" (v128.const f64x2 0123456789e019 0123456789e019)
                                    (v128.const f64x2 0x0123456789ABCDEFabcdef.0123456789ABCDEFabcdefp-019 0x0123456789ABCDEFabcdef.0123456789ABCDEFabcdefp-019))
                                    (v128.const f64x2 0x1.23456789abcdfp+61 0x1.23456789abcdfp+61))
(assert_return (invoke "f64x2.pmin" (v128.const f64x2 0123456789e+019 0123456789e+019)
                                    (v128.const f64x2 0x0p+0 0x0p+0))
                                    (v128.const f64x2 0x0.0p+0 0x0.0p+0))
(assert_return (invoke "f64x2.pmin" (v128.const f64x2 0123456789e+019 0123456789e+019)
                                    (v128.const f64x2 -0x0p+0 -0x0p+0))
                                    (v128.const f64x2 -0x0.0p+0 -0x0.0p+0))
(assert_return (invoke "f64x2.pmin" (v128.const f64x2 0123456789e+019 0123456789e+019)
                                    (v128.const f64x2 0x1p-1022 0x1p-1022))
                                    (v128.const f64x2 0x1.0000000000000p-1022 0x1.0000000000000p-1022))
(assert_return (invoke "f64x2.pmin" (v128.const f64x2 0123456789e+019 0123456789e+019)
                                    (v128.const f64x2 -0x1p-1022 -0x1p-1022))
                                    (v128.const f64x2 -0x1.0000000000000p-1022 -0x1.0000000000000p-1022))
(assert_return (invoke "f64x2.pmin" (v128.const f64x2 0123456789e+019 0123456789e+019)
                                    (v128.const f64x2 0x1p-1 0x1p-1))
                                    (v128.const f64x2 0x1.0000000000000p-1 0x1.0000000000000p-1))
(assert_return (invoke "f64x2.pmin" (v128.const f64x2 0123456789e+019 0123456789e+019)
                                    (v128.const f64x2 -0x1p-1 -0x1p-1))
                                    (v128.const f64x2 -0x1.0000000000000p-1 -0x1.0000000000000p-1))
(assert_return (invoke "f64x2.pmin" (v128.const f64x2 0123456789e+019 0123456789e+019)
                                    (v128.const f64x2 0x1p+0 0x1p+0))
                                    (v128.const f64x2 0x1.0000000000000p+0 0x1.0000000000000p+0))
(assert_return (invoke "f64x2.pmin" (v128.const f64x2 0123456789e+019 0123456789e+019)
                                    (v128.const f64x2 -0x1p+0 -0x1p+0))
                                    (v128.const f64x2 -0x1.0000000000000p+0 -0x1.0000000000000p+0))
(assert_return (invoke "f64x2.pmin" (v128.const f64x2 0123456789e+019 0123456789e+019)
                                    (v128.const f64x2 0x1.921fb54442d18p+2 0x1.921fb54442d18p+2))
                                    (v128.const f64x2 0x1.921fb54442d18p+2 0x1.921fb54442d18p+2))
(assert_return (invoke "f64x2.pmin" (v128.const f64x2 0123456789e+019 0123456789e+019)
                                    (v128.const f64x2 -0x1.921fb54442d18p+2 -0x1.921fb54442d18p+2))
                                    (v128.const f64x2 -0x1.921fb54442d18p+2 -0x1.921fb54442d18p+2))
(assert_return (invoke "f64x2.pmin" (v128.const f64x2 0123456789e+019 0123456789e+019)
                                    (v128.const f64x2 0x1.fffffffffffffp+1023 0x1.fffffffffffffp+1023))
                                    (v128.const f64x2 0x1.fe9af5b5e16fap+89 0x1.fe9af5b5e16fap+89))
(assert_return (invoke "f64x2.pmin" (v128.const f64x2 0123456789e+019 0123456789e+019)
                                    (v128.const f64x2 -0x1.fffffffffffffp+1023 -0x1.fffffffffffffp+1023))
                                    (v128.const f64x2 -0x1.fffffffffffffp+1023 -0x1.fffffffffffffp+1023))
(assert_return (invoke "f64x2.pmin" (v128.const f64x2 0123456789e+019 0123456789e+019)
                                    (v128.const f64x2 0x0.0000000000001p-1022 0x0.0000000000001p-1022))
                                    (v128.const f64x2 0x0.0000000000001p-1022 0x0.0000000000001p-1022))
(assert_return (invoke "f64x2.pmin" (v128.const f64x2 0123456789e+019 0123456789e+019)
                                    (v128.const f64x2 0x0.0000000000001p-1022 0x0.0000000000001p-1022))
                                    (v128.const f64x2 0x0.0000000000001p-1022 0x0.0000000000001p-1022))
(assert_return (invoke "f64x2.pmin" (v128.const f64x2 0123456789e+019 0123456789e+019)
                                    (v128.const f64x2 inf inf))
                                    (v128.const f64x2 0x1.fe9af5b5e16fap+89 0x1.fe9af5b5e16fap+89))
(assert_return (invoke "f64x2.pmin" (v128.const f64x2 0123456789e+019 0123456789e+019)
                                    (v128.const f64x2 -inf -inf))
                                    (v128.const f64x2 -inf -inf))
(assert_return (invoke "f64x2.pmin" (v128.const f64x2 0123456789e+019 0123456789e+019)
                                    (v128.const f64x2 0123456789 0123456789))
                                    (v128.const f64x2 0x1.d6f3454000000p+26 0x1.d6f3454000000p+26))
(assert_return (invoke "f64x2.pmin" (v128.const f64x2 0123456789e+019 0123456789e+019)
                                    (v128.const f64x2 0123456789e019 0123456789e019))
                                    (v128.const f64x2 0x1.fe9af5b5e16fap+89 0x1.fe9af5b5e16fap+89))
(assert_return (invoke "f64x2.pmin" (v128.const f64x2 0123456789e+019 0123456789e+019)
                                    (v128.const f64x2 0123456789e+019 0123456789e+019))
                                    (v128.const f64x2 0x1.fe9af5b5e16fap+89 0x1.fe9af5b5e16fap+89))
(assert_return (invoke "f64x2.pmin" (v128.const f64x2 0123456789e+019 0123456789e+019)
                                    (v128.const f64x2 0123456789e-019 0123456789e-019))
                                    (v128.const f64x2 0x1.b25ffd62b4311p-37 0x1.b25ffd62b4311p-37))
(assert_return (invoke "f64x2.pmin" (v128.const f64x2 0123456789e+019 0123456789e+019)
                                    (v128.const f64x2 0123456789. 0123456789.))
                                    (v128.const f64x2 0x1.d6f3454000000p+26 0x1.d6f3454000000p+26))
(assert_return (invoke "f64x2.pmin" (v128.const f64x2 0123456789e+019 0123456789e+019)
                                    (v128.const f64x2 0123456789.e019 0123456789.e019))
                                    (v128.const f64x2 0x1.fe9af5b5e16fap+89 0x1.fe9af5b5e16fap+89))
(assert_return (invoke "f64x2.pmin" (v128.const f64x2 0123456789e+019 0123456789e+019)
                                    (v128.const f64x2 0123456789.e+019 0123456789.e+019))
                                    (v128.const f64x2 0x1.fe9af5b5e16fap+89 0x1.fe9af5b5e16fap+89))
(assert_return (invoke "f64x2.pmin" (v128.const f64x2 0123456789e+019 0123456789e+019)
                                    (v128.const f64x2 0123456789.e-019 0123456789.e-019))
                                    (v128.const f64x2 0x1.b25ffd62b4311p-37 0x1.b25ffd62b4311p-37))
(assert_return (invoke "f64x2.pmin" (v128.const f64x2 0123456789e+019 0123456789e+019)
                                    (v128.const f64x2 0123456789.0123456789 0123456789.0123456789))
                                    (v128.const f64x2 0x1.d6f34540ca458p+26 0x1.d6f34540ca458p+26))
(assert_return (invoke "f64x2.pmin" (v128.const f64x2 0123456789e+019 0123456789e+019)
                                    (v128.const f64x2 0123456789.0123456789e019 0123456789.0123456789e019))
                                    (v128.const f64x2 0x1.fe9af5b5e16fap+89 0x1.fe9af5b5e16fap+89))
(assert_return (invoke "f64x2.pmin" (v128.const f64x2 0123456789e+019 0123456789e+019)
                                    (v128.const f64x2 0123456789.0123456789e+019 0123456789.0123456789e+019))
                                    (v128.const f64x2 0x1.fe9af5b5e16fap+89 0x1.fe9af5b5e16fap+89))
(assert_return (invoke "f64x2.pmin" (v128.const f64x2 0123456789e+019 0123456789e+019)
                                    (v128.const f64x2 0123456789.0123456789e-019 0123456789.0123456789e-019))
                                    (v128.const f64x2 0x1.b25ffd636ec12p-37 0x1.b25ffd636ec12p-37))
(assert_return (invoke "f64x2.pmin" (v128.const f64x2 0123456789e+019 0123456789e+019)
                                    (v128.const f64x2 0x0123456789ABCDEFabcdef 0x0123456789ABCDEFabcdef))
                                    (v128.const f64x2 0x1.23456789abcdfp+80 0x1.23456789abcdfp+80))
(assert_return (invoke "f64x2.pmin" (v128.const f64x2 0123456789e+019 0123456789e+019)
                                    (v128.const f64x2 0x0123456789ABCDEFabcdefp019 0x0123456789ABCDEFabcdefp019))
                                    (v128.const f64x2 0x1.fe9af5b5e16fap+89 0x1.fe9af5b5e16fap+89))
(assert_return (invoke "f64x2.pmin" (v128.const f64x2 0123456789e+019 0123456789e+019)
                                    (v128.const f64x2 0x0123456789ABCDEFabcdefp+019 0x0123456789ABCDEFabcdefp+019))
                                    (v128.const f64x2 0x1.fe9af5b5e16fap+89 0x1.fe9af5b5e16fap+89))
(assert_return (invoke "f64x2.pmin" (v128.const f64x2 0123456789e+019 0123456789e+019)
                                    (v128.const f64x2 0x0123456789ABCDEFabcdefp-019 0x0123456789ABCDEFabcdefp-019))
                                    (v128.const f64x2 0x1.23456789abcdfp+61 0x1.23456789abcdfp+61))
(assert_return (invoke "f64x2.pmin" (v128.const f64x2 0123456789e+019 0123456789e+019)
                                    (v128.const f64x2 0x0123456789ABCDEFabcdef. 0x0123456789ABCDEFabcdef.))
                                    (v128.const f64x2 0x1.23456789abcdfp+80 0x1.23456789abcdfp+80))
(assert_return (invoke "f64x2.pmin" (v128.const f64x2 0123456789e+019 0123456789e+019)
                                    (v128.const f64x2 0x0123456789ABCDEFabcdef.p019 0x0123456789ABCDEFabcdef.p019))
                                    (v128.const f64x2 0x1.fe9af5b5e16fap+89 0x1.fe9af5b5e16fap+89))
(assert_return (invoke "f64x2.pmin" (v128.const f64x2 0123456789e+019 0123456789e+019)
                                    (v128.const f64x2 0x0123456789ABCDEFabcdef.p+019 0x0123456789ABCDEFabcdef.p+019))
                                    (v128.const f64x2 0x1.fe9af5b5e16fap+89 0x1.fe9af5b5e16fap+89))
(assert_return (invoke "f64x2.pmin" (v128.const f64x2 0123456789e+019 0123456789e+019)
                                    (v128.const f64x2 0x0123456789ABCDEFabcdef.p-019 0x0123456789ABCDEFabcdef.p-019))
                                    (v128.const f64x2 0x1.23456789abcdfp+61 0x1.23456789abcdfp+61))
(assert_return (invoke "f64x2.pmin" (v128.const f64x2 0123456789e+019 0123456789e+019)
                                    (v128.const f64x2 0x0123456789ABCDEFabcdef.0123456789ABCDEFabcdef 0x0123456789ABCDEFabcdef.0123456789ABCDEFabcdef))
                                    (v128.const f64x2 0x1.23456789abcdfp+80 0x1.23456789abcdfp+80))
(assert_return (invoke "f64x2.pmin" (v128.const f64x2 0123456789e+019 0123456789e+019)
                                    (v128.const f64x2 0x0123456789ABCDEFabcdef.0123456789ABCDEFabcdefp019 0x0123456789ABCDEFabcdef.0123456789ABCDEFabcdefp019))
                                    (v128.const f64x2 0x1.fe9af5b5e16fap+89 0x1.fe9af5b5e16fap+89))
(assert_return (invoke "f64x2.pmin" (v128.const f64x2 0123456789e+019 0123456789e+019)
                                    (v128.const f64x2 0x0123456789ABCDEFabcdef.0123456789ABCDEFabcdefp+019 0x0123456789ABCDEFabcdef.0123456789ABCDEFabcdefp+019))
                                    (v128.const f64x2 0x1.fe9af5b5e16fap+89 0x1.fe9af5b5e16fap+89))
(assert_return (invoke "f64x2.pmin" (v128.const f64x2 0123456789e+019 0123456789e+019)
                                    (v128.const f64x2 0x0123456789ABCDEFabcdef.0123456789ABCDEFabcdefp-019 0x0123456789ABCDEFabcdef.0123456789ABCDEFabcdefp-019))
                                    (v128.const f64x2 0x1.23456789abcdfp+61 0x1.23456789abcdfp+61))
(assert_return (invoke "f64x2.pmin" (v128.const f64x2 0123456789e-019 0123456789e-019)
                                    (v128.const f64x2 0x0p+0 0x0p+0))
                                    (v128.const f64x2 0x0.0p+0 0x0.0p+0))
(assert_return (invoke "f64x2.pmin" (v128.const f64x2 0123456789e-019 0123456789e-019)
                                    (v128.const f64x2 -0x0p+0 -0x0p+0))
                                    (v128.const f64x2 -0x0.0p+0 -0x0.0p+0))
(assert_return (invoke "f64x2.pmin" (v128.const f64x2 0123456789e-019 0123456789e-019)
                                    (v128.const f64x2 0x1p-1022 0x1p-1022))
                                    (v128.const f64x2 0x1.0000000000000p-1022 0x1.0000000000000p-1022))
(assert_return (invoke "f64x2.pmin" (v128.const f64x2 0123456789e-019 0123456789e-019)
                                    (v128.const f64x2 -0x1p-1022 -0x1p-1022))
                                    (v128.const f64x2 -0x1.0000000000000p-1022 -0x1.0000000000000p-1022))
(assert_return (invoke "f64x2.pmin" (v128.const f64x2 0123456789e-019 0123456789e-019)
                                    (v128.const f64x2 0x1p-1 0x1p-1))
                                    (v128.const f64x2 0x1.b25ffd62b4311p-37 0x1.b25ffd62b4311p-37))
(assert_return (invoke "f64x2.pmin" (v128.const f64x2 0123456789e-019 0123456789e-019)
                                    (v128.const f64x2 -0x1p-1 -0x1p-1))
                                    (v128.const f64x2 -0x1.0000000000000p-1 -0x1.0000000000000p-1))
(assert_return (invoke "f64x2.pmin" (v128.const f64x2 0123456789e-019 0123456789e-019)
                                    (v128.const f64x2 0x1p+0 0x1p+0))
                                    (v128.const f64x2 0x1.b25ffd62b4311p-37 0x1.b25ffd62b4311p-37))
(assert_return (invoke "f64x2.pmin" (v128.const f64x2 0123456789e-019 0123456789e-019)
                                    (v128.const f64x2 -0x1p+0 -0x1p+0))
                                    (v128.const f64x2 -0x1.0000000000000p+0 -0x1.0000000000000p+0))
(assert_return (invoke "f64x2.pmin" (v128.const f64x2 0123456789e-019 0123456789e-019)
                                    (v128.const f64x2 0x1.921fb54442d18p+2 0x1.921fb54442d18p+2))
                                    (v128.const f64x2 0x1.b25ffd62b4311p-37 0x1.b25ffd62b4311p-37))
(assert_return (invoke "f64x2.pmin" (v128.const f64x2 0123456789e-019 0123456789e-019)
                                    (v128.const f64x2 -0x1.921fb54442d18p+2 -0x1.921fb54442d18p+2))
                                    (v128.const f64x2 -0x1.921fb54442d18p+2 -0x1.921fb54442d18p+2))
(assert_return (invoke "f64x2.pmin" (v128.const f64x2 0123456789e-019 0123456789e-019)
                                    (v128.const f64x2 0x1.fffffffffffffp+1023 0x1.fffffffffffffp+1023))
                                    (v128.const f64x2 0x1.b25ffd62b4311p-37 0x1.b25ffd62b4311p-37))
(assert_return (invoke "f64x2.pmin" (v128.const f64x2 0123456789e-019 0123456789e-019)
                                    (v128.const f64x2 -0x1.fffffffffffffp+1023 -0x1.fffffffffffffp+1023))
                                    (v128.const f64x2 -0x1.fffffffffffffp+1023 -0x1.fffffffffffffp+1023))
(assert_return (invoke "f64x2.pmin" (v128.const f64x2 0123456789e-019 0123456789e-019)
                                    (v128.const f64x2 0x0.0000000000001p-1022 0x0.0000000000001p-1022))
                                    (v128.const f64x2 0x0.0000000000001p-1022 0x0.0000000000001p-1022))
(assert_return (invoke "f64x2.pmin" (v128.const f64x2 0123456789e-019 0123456789e-019)
                                    (v128.const f64x2 0x0.0000000000001p-1022 0x0.0000000000001p-1022))
                                    (v128.const f64x2 0x0.0000000000001p-1022 0x0.0000000000001p-1022))
(assert_return (invoke "f64x2.pmin" (v128.const f64x2 0123456789e-019 0123456789e-019)
                                    (v128.const f64x2 inf inf))
                                    (v128.const f64x2 0x1.b25ffd62b4311p-37 0x1.b25ffd62b4311p-37))
(assert_return (invoke "f64x2.pmin" (v128.const f64x2 0123456789e-019 0123456789e-019)
                                    (v128.const f64x2 -inf -inf))
                                    (v128.const f64x2 -inf -inf))
(assert_return (invoke "f64x2.pmin" (v128.const f64x2 0123456789e-019 0123456789e-019)
                                    (v128.const f64x2 0123456789 0123456789))
                                    (v128.const f64x2 0x1.b25ffd62b4311p-37 0x1.b25ffd62b4311p-37))
(assert_return (invoke "f64x2.pmin" (v128.const f64x2 0123456789e-019 0123456789e-019)
                                    (v128.const f64x2 0123456789e019 0123456789e019))
                                    (v128.const f64x2 0x1.b25ffd62b4311p-37 0x1.b25ffd62b4311p-37))
(assert_return (invoke "f64x2.pmin" (v128.const f64x2 0123456789e-019 0123456789e-019)
                                    (v128.const f64x2 0123456789e+019 0123456789e+019))
                                    (v128.const f64x2 0x1.b25ffd62b4311p-37 0x1.b25ffd62b4311p-37))
(assert_return (invoke "f64x2.pmin" (v128.const f64x2 0123456789e-019 0123456789e-019)
                                    (v128.const f64x2 0123456789e-019 0123456789e-019))
                                    (v128.const f64x2 0x1.b25ffd62b4311p-37 0x1.b25ffd62b4311p-37))
(assert_return (invoke "f64x2.pmin" (v128.const f64x2 0123456789e-019 0123456789e-019)
                                    (v128.const f64x2 0123456789. 0123456789.))
                                    (v128.const f64x2 0x1.b25ffd62b4311p-37 0x1.b25ffd62b4311p-37))
(assert_return (invoke "f64x2.pmin" (v128.const f64x2 0123456789e-019 0123456789e-019)
                                    (v128.const f64x2 0123456789.e019 0123456789.e019))
                                    (v128.const f64x2 0x1.b25ffd62b4311p-37 0x1.b25ffd62b4311p-37))
(assert_return (invoke "f64x2.pmin" (v128.const f64x2 0123456789e-019 0123456789e-019)
                                    (v128.const f64x2 0123456789.e+019 0123456789.e+019))
                                    (v128.const f64x2 0x1.b25ffd62b4311p-37 0x1.b25ffd62b4311p-37))
(assert_return (invoke "f64x2.pmin" (v128.const f64x2 0123456789e-019 0123456789e-019)
                                    (v128.const f64x2 0123456789.e-019 0123456789.e-019))
                                    (v128.const f64x2 0x1.b25ffd62b4311p-37 0x1.b25ffd62b4311p-37))
(assert_return (invoke "f64x2.pmin" (v128.const f64x2 0123456789e-019 0123456789e-019)
                                    (v128.const f64x2 0123456789.0123456789 0123456789.0123456789))
                                    (v128.const f64x2 0x1.b25ffd62b4311p-37 0x1.b25ffd62b4311p-37))
(assert_return (invoke "f64x2.pmin" (v128.const f64x2 0123456789e-019 0123456789e-019)
                                    (v128.const f64x2 0123456789.0123456789e019 0123456789.0123456789e019))
                                    (v128.const f64x2 0x1.b25ffd62b4311p-37 0x1.b25ffd62b4311p-37))
(assert_return (invoke "f64x2.pmin" (v128.const f64x2 0123456789e-019 0123456789e-019)
                                    (v128.const f64x2 0123456789.0123456789e+019 0123456789.0123456789e+019))
                                    (v128.const f64x2 0x1.b25ffd62b4311p-37 0x1.b25ffd62b4311p-37))
(assert_return (invoke "f64x2.pmin" (v128.const f64x2 0123456789e-019 0123456789e-019)
                                    (v128.const f64x2 0123456789.0123456789e-019 0123456789.0123456789e-019))
                                    (v128.const f64x2 0x1.b25ffd62b4311p-37 0x1.b25ffd62b4311p-37))
(assert_return (invoke "f64x2.pmin" (v128.const f64x2 0123456789e-019 0123456789e-019)
                                    (v128.const f64x2 0x0123456789ABCDEFabcdef 0x0123456789ABCDEFabcdef))
                                    (v128.const f64x2 0x1.b25ffd62b4311p-37 0x1.b25ffd62b4311p-37))
(assert_return (invoke "f64x2.pmin" (v128.const f64x2 0123456789e-019 0123456789e-019)
                                    (v128.const f64x2 0x0123456789ABCDEFabcdefp019 0x0123456789ABCDEFabcdefp019))
                                    (v128.const f64x2 0x1.b25ffd62b4311p-37 0x1.b25ffd62b4311p-37))
(assert_return (invoke "f64x2.pmin" (v128.const f64x2 0123456789e-019 0123456789e-019)
                                    (v128.const f64x2 0x0123456789ABCDEFabcdefp+019 0x0123456789ABCDEFabcdefp+019))
                                    (v128.const f64x2 0x1.b25ffd62b4311p-37 0x1.b25ffd62b4311p-37))
(assert_return (invoke "f64x2.pmin" (v128.const f64x2 0123456789e-019 0123456789e-019)
                                    (v128.const f64x2 0x0123456789ABCDEFabcdefp-019 0x0123456789ABCDEFabcdefp-019))
                                    (v128.const f64x2 0x1.b25ffd62b4311p-37 0x1.b25ffd62b4311p-37))
(assert_return (invoke "f64x2.pmin" (v128.const f64x2 0123456789e-019 0123456789e-019)
                                    (v128.const f64x2 0x0123456789ABCDEFabcdef. 0x0123456789ABCDEFabcdef.))
                                    (v128.const f64x2 0x1.b25ffd62b4311p-37 0x1.b25ffd62b4311p-37))
(assert_return (invoke "f64x2.pmin" (v128.const f64x2 0123456789e-019 0123456789e-019)
                                    (v128.const f64x2 0x0123456789ABCDEFabcdef.p019 0x0123456789ABCDEFabcdef.p019))
                                    (v128.const f64x2 0x1.b25ffd62b4311p-37 0x1.b25ffd62b4311p-37))
(assert_return (invoke "f64x2.pmin" (v128.const f64x2 0123456789e-019 0123456789e-019)
                                    (v128.const f64x2 0x0123456789ABCDEFabcdef.p+019 0x0123456789ABCDEFabcdef.p+019))
                                    (v128.const f64x2 0x1.b25ffd62b4311p-37 0x1.b25ffd62b4311p-37))
(assert_return (invoke "f64x2.pmin" (v128.const f64x2 0123456789e-019 0123456789e-019)
                                    (v128.const f64x2 0x0123456789ABCDEFabcdef.p-019 0x0123456789ABCDEFabcdef.p-019))
                                    (v128.const f64x2 0x1.b25ffd62b4311p-37 0x1.b25ffd62b4311p-37))
(assert_return (invoke "f64x2.pmin" (v128.const f64x2 0123456789e-019 0123456789e-019)
                                    (v128.const f64x2 0x0123456789ABCDEFabcdef.0123456789ABCDEFabcdef 0x0123456789ABCDEFabcdef.0123456789ABCDEFabcdef))
                                    (v128.const f64x2 0x1.b25ffd62b4311p-37 0x1.b25ffd62b4311p-37))
(assert_return (invoke "f64x2.pmin" (v128.const f64x2 0123456789e-019 0123456789e-019)
                                    (v128.const f64x2 0x0123456789ABCDEFabcdef.0123456789ABCDEFabcdefp019 0x0123456789ABCDEFabcdef.0123456789ABCDEFabcdefp019))
                                    (v128.const f64x2 0x1.b25ffd62b4311p-37 0x1.b25ffd62b4311p-37))
(assert_return (invoke "f64x2.pmin" (v128.const f64x2 0123456789e-019 0123456789e-019)
                                    (v128.const f64x2 0x0123456789ABCDEFabcdef.0123456789ABCDEFabcdefp+019 0x0123456789ABCDEFabcdef.0123456789ABCDEFabcdefp+019))
                                    (v128.const f64x2 0x1.b25ffd62b4311p-37 0x1.b25ffd62b4311p-37))
(assert_return (invoke "f64x2.pmin" (v128.const f64x2 0123456789e-019 0123456789e-019)
                                    (v128.const f64x2 0x0123456789ABCDEFabcdef.0123456789ABCDEFabcdefp-019 0x0123456789ABCDEFabcdef.0123456789ABCDEFabcdefp-019))
                                    (v128.const f64x2 0x1.b25ffd62b4311p-37 0x1.b25ffd62b4311p-37))
(assert_return (invoke "f64x2.pmin" (v128.const f64x2 0123456789. 0123456789.)
                                    (v128.const f64x2 0x0p+0 0x0p+0))
                                    (v128.const f64x2 0x0.0p+0 0x0.0p+0))
(assert_return (invoke "f64x2.pmin" (v128.const f64x2 0123456789. 0123456789.)
                                    (v128.const f64x2 -0x0p+0 -0x0p+0))
                                    (v128.const f64x2 -0x0.0p+0 -0x0.0p+0))
(assert_return (invoke "f64x2.pmin" (v128.const f64x2 0123456789. 0123456789.)
                                    (v128.const f64x2 0x1p-1022 0x1p-1022))
                                    (v128.const f64x2 0x1.0000000000000p-1022 0x1.0000000000000p-1022))
(assert_return (invoke "f64x2.pmin" (v128.const f64x2 0123456789. 0123456789.)
                                    (v128.const f64x2 -0x1p-1022 -0x1p-1022))
                                    (v128.const f64x2 -0x1.0000000000000p-1022 -0x1.0000000000000p-1022))
(assert_return (invoke "f64x2.pmin" (v128.const f64x2 0123456789. 0123456789.)
                                    (v128.const f64x2 0x1p-1 0x1p-1))
                                    (v128.const f64x2 0x1.0000000000000p-1 0x1.0000000000000p-1))
(assert_return (invoke "f64x2.pmin" (v128.const f64x2 0123456789. 0123456789.)
                                    (v128.const f64x2 -0x1p-1 -0x1p-1))
                                    (v128.const f64x2 -0x1.0000000000000p-1 -0x1.0000000000000p-1))
(assert_return (invoke "f64x2.pmin" (v128.const f64x2 0123456789. 0123456789.)
                                    (v128.const f64x2 0x1p+0 0x1p+0))
                                    (v128.const f64x2 0x1.0000000000000p+0 0x1.0000000000000p+0))
(assert_return (invoke "f64x2.pmin" (v128.const f64x2 0123456789. 0123456789.)
                                    (v128.const f64x2 -0x1p+0 -0x1p+0))
                                    (v128.const f64x2 -0x1.0000000000000p+0 -0x1.0000000000000p+0))
(assert_return (invoke "f64x2.pmin" (v128.const f64x2 0123456789. 0123456789.)
                                    (v128.const f64x2 0x1.921fb54442d18p+2 0x1.921fb54442d18p+2))
                                    (v128.const f64x2 0x1.921fb54442d18p+2 0x1.921fb54442d18p+2))
(assert_return (invoke "f64x2.pmin" (v128.const f64x2 0123456789. 0123456789.)
                                    (v128.const f64x2 -0x1.921fb54442d18p+2 -0x1.921fb54442d18p+2))
                                    (v128.const f64x2 -0x1.921fb54442d18p+2 -0x1.921fb54442d18p+2))
(assert_return (invoke "f64x2.pmin" (v128.const f64x2 0123456789. 0123456789.)
                                    (v128.const f64x2 0x1.fffffffffffffp+1023 0x1.fffffffffffffp+1023))
                                    (v128.const f64x2 0x1.d6f3454000000p+26 0x1.d6f3454000000p+26))
(assert_return (invoke "f64x2.pmin" (v128.const f64x2 0123456789. 0123456789.)
                                    (v128.const f64x2 -0x1.fffffffffffffp+1023 -0x1.fffffffffffffp+1023))
                                    (v128.const f64x2 -0x1.fffffffffffffp+1023 -0x1.fffffffffffffp+1023))
(assert_return (invoke "f64x2.pmin" (v128.const f64x2 0123456789. 0123456789.)
                                    (v128.const f64x2 0x0.0000000000001p-1022 0x0.0000000000001p-1022))
                                    (v128.const f64x2 0x0.0000000000001p-1022 0x0.0000000000001p-1022))
(assert_return (invoke "f64x2.pmin" (v128.const f64x2 0123456789. 0123456789.)
                                    (v128.const f64x2 0x0.0000000000001p-1022 0x0.0000000000001p-1022))
                                    (v128.const f64x2 0x0.0000000000001p-1022 0x0.0000000000001p-1022))
(assert_return (invoke "f64x2.pmin" (v128.const f64x2 0123456789. 0123456789.)
                                    (v128.const f64x2 inf inf))
                                    (v128.const f64x2 0x1.d6f3454000000p+26 0x1.d6f3454000000p+26))
(assert_return (invoke "f64x2.pmin" (v128.const f64x2 0123456789. 0123456789.)
                                    (v128.const f64x2 -inf -inf))
                                    (v128.const f64x2 -inf -inf))
(assert_return (invoke "f64x2.pmin" (v128.const f64x2 0123456789. 0123456789.)
                                    (v128.const f64x2 0123456789 0123456789))
                                    (v128.const f64x2 0x1.d6f3454000000p+26 0x1.d6f3454000000p+26))
(assert_return (invoke "f64x2.pmin" (v128.const f64x2 0123456789. 0123456789.)
                                    (v128.const f64x2 0123456789e019 0123456789e019))
                                    (v128.const f64x2 0x1.d6f3454000000p+26 0x1.d6f3454000000p+26))
(assert_return (invoke "f64x2.pmin" (v128.const f64x2 0123456789. 0123456789.)
                                    (v128.const f64x2 0123456789e+019 0123456789e+019))
                                    (v128.const f64x2 0x1.d6f3454000000p+26 0x1.d6f3454000000p+26))
(assert_return (invoke "f64x2.pmin" (v128.const f64x2 0123456789. 0123456789.)
                                    (v128.const f64x2 0123456789e-019 0123456789e-019))
                                    (v128.const f64x2 0x1.b25ffd62b4311p-37 0x1.b25ffd62b4311p-37))
(assert_return (invoke "f64x2.pmin" (v128.const f64x2 0123456789. 0123456789.)
                                    (v128.const f64x2 0123456789. 0123456789.))
                                    (v128.const f64x2 0x1.d6f3454000000p+26 0x1.d6f3454000000p+26))
(assert_return (invoke "f64x2.pmin" (v128.const f64x2 0123456789. 0123456789.)
                                    (v128.const f64x2 0123456789.e019 0123456789.e019))
                                    (v128.const f64x2 0x1.d6f3454000000p+26 0x1.d6f3454000000p+26))
(assert_return (invoke "f64x2.pmin" (v128.const f64x2 0123456789. 0123456789.)
                                    (v128.const f64x2 0123456789.e+019 0123456789.e+019))
                                    (v128.const f64x2 0x1.d6f3454000000p+26 0x1.d6f3454000000p+26))
(assert_return (invoke "f64x2.pmin" (v128.const f64x2 0123456789. 0123456789.)
                                    (v128.const f64x2 0123456789.e-019 0123456789.e-019))
                                    (v128.const f64x2 0x1.b25ffd62b4311p-37 0x1.b25ffd62b4311p-37))
(assert_return (invoke "f64x2.pmin" (v128.const f64x2 0123456789. 0123456789.)
                                    (v128.const f64x2 0123456789.0123456789 0123456789.0123456789))
                                    (v128.const f64x2 0x1.d6f3454000000p+26 0x1.d6f3454000000p+26))
(assert_return (invoke "f64x2.pmin" (v128.const f64x2 0123456789. 0123456789.)
                                    (v128.const f64x2 0123456789.0123456789e019 0123456789.0123456789e019))
                                    (v128.const f64x2 0x1.d6f3454000000p+26 0x1.d6f3454000000p+26))
(assert_return (invoke "f64x2.pmin" (v128.const f64x2 0123456789. 0123456789.)
                                    (v128.const f64x2 0123456789.0123456789e+019 0123456789.0123456789e+019))
                                    (v128.const f64x2 0x1.d6f3454000000p+26 0x1.d6f3454000000p+26))
(assert_return (invoke "f64x2.pmin" (v128.const f64x2 0123456789. 0123456789.)
                                    (v128.const f64x2 0123456789.0123456789e-019 0123456789.0123456789e-019))
                                    (v128.const f64x2 0x1.b25ffd636ec12p-37 0x1.b25ffd636ec12p-37))
(assert_return (invoke "f64x2.pmin" (v128.const f64x2 0123456789. 0123456789.)
                                    (v128.const f64x2 0x0123456789ABCDEFabcdef 0x0123456789ABCDEFabcdef))
                                    (v128.const f64x2 0x1.d6f3454000000p+26 0x1.d6f3454000000p+26))
(assert_return (invoke "f64x2.pmin" (v128.const f64x2 0123456789. 0123456789.)
                                    (v128.const f64x2 0x0123456789ABCDEFabcdefp019 0x0123456789ABCDEFabcdefp019))
                                    (v128.const f64x2 0x1.d6f3454000000p+26 0x1.d6f3454000000p+26))
(assert_return (invoke "f64x2.pmin" (v128.const f64x2 0123456789. 0123456789.)
                                    (v128.const f64x2 0x0123456789ABCDEFabcdefp+019 0x0123456789ABCDEFabcdefp+019))
                                    (v128.const f64x2 0x1.d6f3454000000p+26 0x1.d6f3454000000p+26))
(assert_return (invoke "f64x2.pmin" (v128.const f64x2 0123456789. 0123456789.)
                                    (v128.const f64x2 0x0123456789ABCDEFabcdefp-019 0x0123456789ABCDEFabcdefp-019))
                                    (v128.const f64x2 0x1.d6f3454000000p+26 0x1.d6f3454000000p+26))
(assert_return (invoke "f64x2.pmin" (v128.const f64x2 0123456789. 0123456789.)
                                    (v128.const f64x2 0x0123456789ABCDEFabcdef. 0x0123456789ABCDEFabcdef.))
                                    (v128.const f64x2 0x1.d6f3454000000p+26 0x1.d6f3454000000p+26))
(assert_return (invoke "f64x2.pmin" (v128.const f64x2 0123456789. 0123456789.)
                                    (v128.const f64x2 0x0123456789ABCDEFabcdef.p019 0x0123456789ABCDEFabcdef.p019))
                                    (v128.const f64x2 0x1.d6f3454000000p+26 0x1.d6f3454000000p+26))
(assert_return (invoke "f64x2.pmin" (v128.const f64x2 0123456789. 0123456789.)
                                    (v128.const f64x2 0x0123456789ABCDEFabcdef.p+019 0x0123456789ABCDEFabcdef.p+019))
                                    (v128.const f64x2 0x1.d6f3454000000p+26 0x1.d6f3454000000p+26))
(assert_return (invoke "f64x2.pmin" (v128.const f64x2 0123456789. 0123456789.)
                                    (v128.const f64x2 0x0123456789ABCDEFabcdef.p-019 0x0123456789ABCDEFabcdef.p-019))
                                    (v128.const f64x2 0x1.d6f3454000000p+26 0x1.d6f3454000000p+26))
(assert_return (invoke "f64x2.pmin" (v128.const f64x2 0123456789. 0123456789.)
                                    (v128.const f64x2 0x0123456789ABCDEFabcdef.0123456789ABCDEFabcdef 0x0123456789ABCDEFabcdef.0123456789ABCDEFabcdef))
                                    (v128.const f64x2 0x1.d6f3454000000p+26 0x1.d6f3454000000p+26))
(assert_return (invoke "f64x2.pmin" (v128.const f64x2 0123456789. 0123456789.)
                                    (v128.const f64x2 0x0123456789ABCDEFabcdef.0123456789ABCDEFabcdefp019 0x0123456789ABCDEFabcdef.0123456789ABCDEFabcdefp019))
                                    (v128.const f64x2 0x1.d6f3454000000p+26 0x1.d6f3454000000p+26))
(assert_return (invoke "f64x2.pmin" (v128.const f64x2 0123456789. 0123456789.)
                                    (v128.const f64x2 0x0123456789ABCDEFabcdef.0123456789ABCDEFabcdefp+019 0x0123456789ABCDEFabcdef.0123456789ABCDEFabcdefp+019))
                                    (v128.const f64x2 0x1.d6f3454000000p+26 0x1.d6f3454000000p+26))
(assert_return (invoke "f64x2.pmin" (v128.const f64x2 0123456789. 0123456789.)
                                    (v128.const f64x2 0x0123456789ABCDEFabcdef.0123456789ABCDEFabcdefp-019 0x0123456789ABCDEFabcdef.0123456789ABCDEFabcdefp-019))
                                    (v128.const f64x2 0x1.d6f3454000000p+26 0x1.d6f3454000000p+26))
(assert_return (invoke "f64x2.pmin" (v128.const f64x2 0123456789.e019 0123456789.e019)
                                    (v128.const f64x2 0x0p+0 0x0p+0))
                                    (v128.const f64x2 0x0.0p+0 0x0.0p+0))
(assert_return (invoke "f64x2.pmin" (v128.const f64x2 0123456789.e019 0123456789.e019)
                                    (v128.const f64x2 -0x0p+0 -0x0p+0))
                                    (v128.const f64x2 -0x0.0p+0 -0x0.0p+0))
(assert_return (invoke "f64x2.pmin" (v128.const f64x2 0123456789.e019 0123456789.e019)
                                    (v128.const f64x2 0x1p-1022 0x1p-1022))
                                    (v128.const f64x2 0x1.0000000000000p-1022 0x1.0000000000000p-1022))
(assert_return (invoke "f64x2.pmin" (v128.const f64x2 0123456789.e019 0123456789.e019)
                                    (v128.const f64x2 -0x1p-1022 -0x1p-1022))
                                    (v128.const f64x2 -0x1.0000000000000p-1022 -0x1.0000000000000p-1022))
(assert_return (invoke "f64x2.pmin" (v128.const f64x2 0123456789.e019 0123456789.e019)
                                    (v128.const f64x2 0x1p-1 0x1p-1))
                                    (v128.const f64x2 0x1.0000000000000p-1 0x1.0000000000000p-1))
(assert_return (invoke "f64x2.pmin" (v128.const f64x2 0123456789.e019 0123456789.e019)
                                    (v128.const f64x2 -0x1p-1 -0x1p-1))
                                    (v128.const f64x2 -0x1.0000000000000p-1 -0x1.0000000000000p-1))
(assert_return (invoke "f64x2.pmin" (v128.const f64x2 0123456789.e019 0123456789.e019)
                                    (v128.const f64x2 0x1p+0 0x1p+0))
                                    (v128.const f64x2 0x1.0000000000000p+0 0x1.0000000000000p+0))
(assert_return (invoke "f64x2.pmin" (v128.const f64x2 0123456789.e019 0123456789.e019)
                                    (v128.const f64x2 -0x1p+0 -0x1p+0))
                                    (v128.const f64x2 -0x1.0000000000000p+0 -0x1.0000000000000p+0))
(assert_return (invoke "f64x2.pmin" (v128.const f64x2 0123456789.e019 0123456789.e019)
                                    (v128.const f64x2 0x1.921fb54442d18p+2 0x1.921fb54442d18p+2))
                                    (v128.const f64x2 0x1.921fb54442d18p+2 0x1.921fb54442d18p+2))
(assert_return (invoke "f64x2.pmin" (v128.const f64x2 0123456789.e019 0123456789.e019)
                                    (v128.const f64x2 -0x1.921fb54442d18p+2 -0x1.921fb54442d18p+2))
                                    (v128.const f64x2 -0x1.921fb54442d18p+2 -0x1.921fb54442d18p+2))
(assert_return (invoke "f64x2.pmin" (v128.const f64x2 0123456789.e019 0123456789.e019)
                                    (v128.const f64x2 0x1.fffffffffffffp+1023 0x1.fffffffffffffp+1023))
                                    (v128.const f64x2 0x1.fe9af5b5e16fap+89 0x1.fe9af5b5e16fap+89))
(assert_return (invoke "f64x2.pmin" (v128.const f64x2 0123456789.e019 0123456789.e019)
                                    (v128.const f64x2 -0x1.fffffffffffffp+1023 -0x1.fffffffffffffp+1023))
                                    (v128.const f64x2 -0x1.fffffffffffffp+1023 -0x1.fffffffffffffp+1023))
(assert_return (invoke "f64x2.pmin" (v128.const f64x2 0123456789.e019 0123456789.e019)
                                    (v128.const f64x2 0x0.0000000000001p-1022 0x0.0000000000001p-1022))
                                    (v128.const f64x2 0x0.0000000000001p-1022 0x0.0000000000001p-1022))
(assert_return (invoke "f64x2.pmin" (v128.const f64x2 0123456789.e019 0123456789.e019)
                                    (v128.const f64x2 0x0.0000000000001p-1022 0x0.0000000000001p-1022))
                                    (v128.const f64x2 0x0.0000000000001p-1022 0x0.0000000000001p-1022))
(assert_return (invoke "f64x2.pmin" (v128.const f64x2 0123456789.e019 0123456789.e019)
                                    (v128.const f64x2 inf inf))
                                    (v128.const f64x2 0x1.fe9af5b5e16fap+89 0x1.fe9af5b5e16fap+89))
(assert_return (invoke "f64x2.pmin" (v128.const f64x2 0123456789.e019 0123456789.e019)
                                    (v128.const f64x2 -inf -inf))
                                    (v128.const f64x2 -inf -inf))
(assert_return (invoke "f64x2.pmin" (v128.const f64x2 0123456789.e019 0123456789.e019)
                                    (v128.const f64x2 0123456789 0123456789))
                                    (v128.const f64x2 0x1.d6f3454000000p+26 0x1.d6f3454000000p+26))
(assert_return (invoke "f64x2.pmin" (v128.const f64x2 0123456789.e019 0123456789.e019)
                                    (v128.const f64x2 0123456789e019 0123456789e019))
                                    (v128.const f64x2 0x1.fe9af5b5e16fap+89 0x1.fe9af5b5e16fap+89))
(assert_return (invoke "f64x2.pmin" (v128.const f64x2 0123456789.e019 0123456789.e019)
                                    (v128.const f64x2 0123456789e+019 0123456789e+019))
                                    (v128.const f64x2 0x1.fe9af5b5e16fap+89 0x1.fe9af5b5e16fap+89))
(assert_return (invoke "f64x2.pmin" (v128.const f64x2 0123456789.e019 0123456789.e019)
                                    (v128.const f64x2 0123456789e-019 0123456789e-019))
                                    (v128.const f64x2 0x1.b25ffd62b4311p-37 0x1.b25ffd62b4311p-37))
(assert_return (invoke "f64x2.pmin" (v128.const f64x2 0123456789.e019 0123456789.e019)
                                    (v128.const f64x2 0123456789. 0123456789.))
                                    (v128.const f64x2 0x1.d6f3454000000p+26 0x1.d6f3454000000p+26))
(assert_return (invoke "f64x2.pmin" (v128.const f64x2 0123456789.e019 0123456789.e019)
                                    (v128.const f64x2 0123456789.e019 0123456789.e019))
                                    (v128.const f64x2 0x1.fe9af5b5e16fap+89 0x1.fe9af5b5e16fap+89))
(assert_return (invoke "f64x2.pmin" (v128.const f64x2 0123456789.e019 0123456789.e019)
                                    (v128.const f64x2 0123456789.e+019 0123456789.e+019))
                                    (v128.const f64x2 0x1.fe9af5b5e16fap+89 0x1.fe9af5b5e16fap+89))
(assert_return (invoke "f64x2.pmin" (v128.const f64x2 0123456789.e019 0123456789.e019)
                                    (v128.const f64x2 0123456789.e-019 0123456789.e-019))
                                    (v128.const f64x2 0x1.b25ffd62b4311p-37 0x1.b25ffd62b4311p-37))
(assert_return (invoke "f64x2.pmin" (v128.const f64x2 0123456789.e019 0123456789.e019)
                                    (v128.const f64x2 0123456789.0123456789 0123456789.0123456789))
                                    (v128.const f64x2 0x1.d6f34540ca458p+26 0x1.d6f34540ca458p+26))
(assert_return (invoke "f64x2.pmin" (v128.const f64x2 0123456789.e019 0123456789.e019)
                                    (v128.const f64x2 0123456789.0123456789e019 0123456789.0123456789e019))
                                    (v128.const f64x2 0x1.fe9af5b5e16fap+89 0x1.fe9af5b5e16fap+89))
(assert_return (invoke "f64x2.pmin" (v128.const f64x2 0123456789.e019 0123456789.e019)
                                    (v128.const f64x2 0123456789.0123456789e+019 0123456789.0123456789e+019))
                                    (v128.const f64x2 0x1.fe9af5b5e16fap+89 0x1.fe9af5b5e16fap+89))
(assert_return (invoke "f64x2.pmin" (v128.const f64x2 0123456789.e019 0123456789.e019)
                                    (v128.const f64x2 0123456789.0123456789e-019 0123456789.0123456789e-019))
                                    (v128.const f64x2 0x1.b25ffd636ec12p-37 0x1.b25ffd636ec12p-37))
(assert_return (invoke "f64x2.pmin" (v128.const f64x2 0123456789.e019 0123456789.e019)
                                    (v128.const f64x2 0x0123456789ABCDEFabcdef 0x0123456789ABCDEFabcdef))
                                    (v128.const f64x2 0x1.23456789abcdfp+80 0x1.23456789abcdfp+80))
(assert_return (invoke "f64x2.pmin" (v128.const f64x2 0123456789.e019 0123456789.e019)
                                    (v128.const f64x2 0x0123456789ABCDEFabcdefp019 0x0123456789ABCDEFabcdefp019))
                                    (v128.const f64x2 0x1.fe9af5b5e16fap+89 0x1.fe9af5b5e16fap+89))
(assert_return (invoke "f64x2.pmin" (v128.const f64x2 0123456789.e019 0123456789.e019)
                                    (v128.const f64x2 0x0123456789ABCDEFabcdefp+019 0x0123456789ABCDEFabcdefp+019))
                                    (v128.const f64x2 0x1.fe9af5b5e16fap+89 0x1.fe9af5b5e16fap+89))
(assert_return (invoke "f64x2.pmin" (v128.const f64x2 0123456789.e019 0123456789.e019)
                                    (v128.const f64x2 0x0123456789ABCDEFabcdefp-019 0x0123456789ABCDEFabcdefp-019))
                                    (v128.const f64x2 0x1.23456789abcdfp+61 0x1.23456789abcdfp+61))
(assert_return (invoke "f64x2.pmin" (v128.const f64x2 0123456789.e019 0123456789.e019)
                                    (v128.const f64x2 0x0123456789ABCDEFabcdef. 0x0123456789ABCDEFabcdef.))
                                    (v128.const f64x2 0x1.23456789abcdfp+80 0x1.23456789abcdfp+80))
(assert_return (invoke "f64x2.pmin" (v128.const f64x2 0123456789.e019 0123456789.e019)
                                    (v128.const f64x2 0x0123456789ABCDEFabcdef.p019 0x0123456789ABCDEFabcdef.p019))
                                    (v128.const f64x2 0x1.fe9af5b5e16fap+89 0x1.fe9af5b5e16fap+89))
(assert_return (invoke "f64x2.pmin" (v128.const f64x2 0123456789.e019 0123456789.e019)
                                    (v128.const f64x2 0x0123456789ABCDEFabcdef.p+019 0x0123456789ABCDEFabcdef.p+019))
                                    (v128.const f64x2 0x1.fe9af5b5e16fap+89 0x1.fe9af5b5e16fap+89))
(assert_return (invoke "f64x2.pmin" (v128.const f64x2 0123456789.e019 0123456789.e019)
                                    (v128.const f64x2 0x0123456789ABCDEFabcdef.p-019 0x0123456789ABCDEFabcdef.p-019))
                                    (v128.const f64x2 0x1.23456789abcdfp+61 0x1.23456789abcdfp+61))
(assert_return (invoke "f64x2.pmin" (v128.const f64x2 0123456789.e019 0123456789.e019)
                                    (v128.const f64x2 0x0123456789ABCDEFabcdef.0123456789ABCDEFabcdef 0x0123456789ABCDEFabcdef.0123456789ABCDEFabcdef))
                                    (v128.const f64x2 0x1.23456789abcdfp+80 0x1.23456789abcdfp+80))
(assert_return (invoke "f64x2.pmin" (v128.const f64x2 0123456789.e019 0123456789.e019)
                                    (v128.const f64x2 0x0123456789ABCDEFabcdef.0123456789ABCDEFabcdefp019 0x0123456789ABCDEFabcdef.0123456789ABCDEFabcdefp019))
                                    (v128.const f64x2 0x1.fe9af5b5e16fap+89 0x1.fe9af5b5e16fap+89))
(assert_return (invoke "f64x2.pmin" (v128.const f64x2 0123456789.e019 0123456789.e019)
                                    (v128.const f64x2 0x0123456789ABCDEFabcdef.0123456789ABCDEFabcdefp+019 0x0123456789ABCDEFabcdef.0123456789ABCDEFabcdefp+019))
                                    (v128.const f64x2 0x1.fe9af5b5e16fap+89 0x1.fe9af5b5e16fap+89))
(assert_return (invoke "f64x2.pmin" (v128.const f64x2 0123456789.e019 0123456789.e019)
                                    (v128.const f64x2 0x0123456789ABCDEFabcdef.0123456789ABCDEFabcdefp-019 0x0123456789ABCDEFabcdef.0123456789ABCDEFabcdefp-019))
                                    (v128.const f64x2 0x1.23456789abcdfp+61 0x1.23456789abcdfp+61))
(assert_return (invoke "f64x2.pmin" (v128.const f64x2 0123456789.e+019 0123456789.e+019)
                                    (v128.const f64x2 0x0p+0 0x0p+0))
                                    (v128.const f64x2 0x0.0p+0 0x0.0p+0))
(assert_return (invoke "f64x2.pmin" (v128.const f64x2 0123456789.e+019 0123456789.e+019)
                                    (v128.const f64x2 -0x0p+0 -0x0p+0))
                                    (v128.const f64x2 -0x0.0p+0 -0x0.0p+0))
(assert_return (invoke "f64x2.pmin" (v128.const f64x2 0123456789.e+019 0123456789.e+019)
                                    (v128.const f64x2 0x1p-1022 0x1p-1022))
                                    (v128.const f64x2 0x1.0000000000000p-1022 0x1.0000000000000p-1022))
(assert_return (invoke "f64x2.pmin" (v128.const f64x2 0123456789.e+019 0123456789.e+019)
                                    (v128.const f64x2 -0x1p-1022 -0x1p-1022))
                                    (v128.const f64x2 -0x1.0000000000000p-1022 -0x1.0000000000000p-1022))
(assert_return (invoke "f64x2.pmin" (v128.const f64x2 0123456789.e+019 0123456789.e+019)
                                    (v128.const f64x2 0x1p-1 0x1p-1))
                                    (v128.const f64x2 0x1.0000000000000p-1 0x1.0000000000000p-1))
(assert_return (invoke "f64x2.pmin" (v128.const f64x2 0123456789.e+019 0123456789.e+019)
                                    (v128.const f64x2 -0x1p-1 -0x1p-1))
                                    (v128.const f64x2 -0x1.0000000000000p-1 -0x1.0000000000000p-1))
(assert_return (invoke "f64x2.pmin" (v128.const f64x2 0123456789.e+019 0123456789.e+019)
                                    (v128.const f64x2 0x1p+0 0x1p+0))
                                    (v128.const f64x2 0x1.0000000000000p+0 0x1.0000000000000p+0))
(assert_return (invoke "f64x2.pmin" (v128.const f64x2 0123456789.e+019 0123456789.e+019)
                                    (v128.const f64x2 -0x1p+0 -0x1p+0))
                                    (v128.const f64x2 -0x1.0000000000000p+0 -0x1.0000000000000p+0))
(assert_return (invoke "f64x2.pmin" (v128.const f64x2 0123456789.e+019 0123456789.e+019)
                                    (v128.const f64x2 0x1.921fb54442d18p+2 0x1.921fb54442d18p+2))
                                    (v128.const f64x2 0x1.921fb54442d18p+2 0x1.921fb54442d18p+2))
(assert_return (invoke "f64x2.pmin" (v128.const f64x2 0123456789.e+019 0123456789.e+019)
                                    (v128.const f64x2 -0x1.921fb54442d18p+2 -0x1.921fb54442d18p+2))
                                    (v128.const f64x2 -0x1.921fb54442d18p+2 -0x1.921fb54442d18p+2))
(assert_return (invoke "f64x2.pmin" (v128.const f64x2 0123456789.e+019 0123456789.e+019)
                                    (v128.const f64x2 0x1.fffffffffffffp+1023 0x1.fffffffffffffp+1023))
                                    (v128.const f64x2 0x1.fe9af5b5e16fap+89 0x1.fe9af5b5e16fap+89))
(assert_return (invoke "f64x2.pmin" (v128.const f64x2 0123456789.e+019 0123456789.e+019)
                                    (v128.const f64x2 -0x1.fffffffffffffp+1023 -0x1.fffffffffffffp+1023))
                                    (v128.const f64x2 -0x1.fffffffffffffp+1023 -0x1.fffffffffffffp+1023))
(assert_return (invoke "f64x2.pmin" (v128.const f64x2 0123456789.e+019 0123456789.e+019)
                                    (v128.const f64x2 0x0.0000000000001p-1022 0x0.0000000000001p-1022))
                                    (v128.const f64x2 0x0.0000000000001p-1022 0x0.0000000000001p-1022))
(assert_return (invoke "f64x2.pmin" (v128.const f64x2 0123456789.e+019 0123456789.e+019)
                                    (v128.const f64x2 0x0.0000000000001p-1022 0x0.0000000000001p-1022))
                                    (v128.const f64x2 0x0.0000000000001p-1022 0x0.0000000000001p-1022))
(assert_return (invoke "f64x2.pmin" (v128.const f64x2 0123456789.e+019 0123456789.e+019)
                                    (v128.const f64x2 inf inf))
                                    (v128.const f64x2 0x1.fe9af5b5e16fap+89 0x1.fe9af5b5e16fap+89))
(assert_return (invoke "f64x2.pmin" (v128.const f64x2 0123456789.e+019 0123456789.e+019)
                                    (v128.const f64x2 -inf -inf))
                                    (v128.const f64x2 -inf -inf))
(assert_return (invoke "f64x2.pmin" (v128.const f64x2 0123456789.e+019 0123456789.e+019)
                                    (v128.const f64x2 0123456789 0123456789))
                                    (v128.const f64x2 0x1.d6f3454000000p+26 0x1.d6f3454000000p+26))
(assert_return (invoke "f64x2.pmin" (v128.const f64x2 0123456789.e+019 0123456789.e+019)
                                    (v128.const f64x2 0123456789e019 0123456789e019))
                                    (v128.const f64x2 0x1.fe9af5b5e16fap+89 0x1.fe9af5b5e16fap+89))
(assert_return (invoke "f64x2.pmin" (v128.const f64x2 0123456789.e+019 0123456789.e+019)
                                    (v128.const f64x2 0123456789e+019 0123456789e+019))
                                    (v128.const f64x2 0x1.fe9af5b5e16fap+89 0x1.fe9af5b5e16fap+89))
(assert_return (invoke "f64x2.pmin" (v128.const f64x2 0123456789.e+019 0123456789.e+019)
                                    (v128.const f64x2 0123456789e-019 0123456789e-019))
                                    (v128.const f64x2 0x1.b25ffd62b4311p-37 0x1.b25ffd62b4311p-37))
(assert_return (invoke "f64x2.pmin" (v128.const f64x2 0123456789.e+019 0123456789.e+019)
                                    (v128.const f64x2 0123456789. 0123456789.))
                                    (v128.const f64x2 0x1.d6f3454000000p+26 0x1.d6f3454000000p+26))
(assert_return (invoke "f64x2.pmin" (v128.const f64x2 0123456789.e+019 0123456789.e+019)
                                    (v128.const f64x2 0123456789.e019 0123456789.e019))
                                    (v128.const f64x2 0x1.fe9af5b5e16fap+89 0x1.fe9af5b5e16fap+89))
(assert_return (invoke "f64x2.pmin" (v128.const f64x2 0123456789.e+019 0123456789.e+019)
                                    (v128.const f64x2 0123456789.e+019 0123456789.e+019))
                                    (v128.const f64x2 0x1.fe9af5b5e16fap+89 0x1.fe9af5b5e16fap+89))
(assert_return (invoke "f64x2.pmin" (v128.const f64x2 0123456789.e+019 0123456789.e+019)
                                    (v128.const f64x2 0123456789.e-019 0123456789.e-019))
                                    (v128.const f64x2 0x1.b25ffd62b4311p-37 0x1.b25ffd62b4311p-37))
(assert_return (invoke "f64x2.pmin" (v128.const f64x2 0123456789.e+019 0123456789.e+019)
                                    (v128.const f64x2 0123456789.0123456789 0123456789.0123456789))
                                    (v128.const f64x2 0x1.d6f34540ca458p+26 0x1.d6f34540ca458p+26))
(assert_return (invoke "f64x2.pmin" (v128.const f64x2 0123456789.e+019 0123456789.e+019)
                                    (v128.const f64x2 0123456789.0123456789e019 0123456789.0123456789e019))
                                    (v128.const f64x2 0x1.fe9af5b5e16fap+89 0x1.fe9af5b5e16fap+89))
(assert_return (invoke "f64x2.pmin" (v128.const f64x2 0123456789.e+019 0123456789.e+019)
                                    (v128.const f64x2 0123456789.0123456789e+019 0123456789.0123456789e+019))
                                    (v128.const f64x2 0x1.fe9af5b5e16fap+89 0x1.fe9af5b5e16fap+89))
(assert_return (invoke "f64x2.pmin" (v128.const f64x2 0123456789.e+019 0123456789.e+019)
                                    (v128.const f64x2 0123456789.0123456789e-019 0123456789.0123456789e-019))
                                    (v128.const f64x2 0x1.b25ffd636ec12p-37 0x1.b25ffd636ec12p-37))
(assert_return (invoke "f64x2.pmin" (v128.const f64x2 0123456789.e+019 0123456789.e+019)
                                    (v128.const f64x2 0x0123456789ABCDEFabcdef 0x0123456789ABCDEFabcdef))
                                    (v128.const f64x2 0x1.23456789abcdfp+80 0x1.23456789abcdfp+80))
(assert_return (invoke "f64x2.pmin" (v128.const f64x2 0123456789.e+019 0123456789.e+019)
                                    (v128.const f64x2 0x0123456789ABCDEFabcdefp019 0x0123456789ABCDEFabcdefp019))
                                    (v128.const f64x2 0x1.fe9af5b5e16fap+89 0x1.fe9af5b5e16fap+89))
(assert_return (invoke "f64x2.pmin" (v128.const f64x2 0123456789.e+019 0123456789.e+019)
                                    (v128.const f64x2 0x0123456789ABCDEFabcdefp+019 0x0123456789ABCDEFabcdefp+019))
                                    (v128.const f64x2 0x1.fe9af5b5e16fap+89 0x1.fe9af5b5e16fap+89))
(assert_return (invoke "f64x2.pmin" (v128.const f64x2 0123456789.e+019 0123456789.e+019)
                                    (v128.const f64x2 0x0123456789ABCDEFabcdefp-019 0x0123456789ABCDEFabcdefp-019))
                                    (v128.const f64x2 0x1.23456789abcdfp+61 0x1.23456789abcdfp+61))
(assert_return (invoke "f64x2.pmin" (v128.const f64x2 0123456789.e+019 0123456789.e+019)
                                    (v128.const f64x2 0x0123456789ABCDEFabcdef. 0x0123456789ABCDEFabcdef.))
                                    (v128.const f64x2 0x1.23456789abcdfp+80 0x1.23456789abcdfp+80))
(assert_return (invoke "f64x2.pmin" (v128.const f64x2 0123456789.e+019 0123456789.e+019)
                                    (v128.const f64x2 0x0123456789ABCDEFabcdef.p019 0x0123456789ABCDEFabcdef.p019))
                                    (v128.const f64x2 0x1.fe9af5b5e16fap+89 0x1.fe9af5b5e16fap+89))
(assert_return (invoke "f64x2.pmin" (v128.const f64x2 0123456789.e+019 0123456789.e+019)
                                    (v128.const f64x2 0x0123456789ABCDEFabcdef.p+019 0x0123456789ABCDEFabcdef.p+019))
                                    (v128.const f64x2 0x1.fe9af5b5e16fap+89 0x1.fe9af5b5e16fap+89))
(assert_return (invoke "f64x2.pmin" (v128.const f64x2 0123456789.e+019 0123456789.e+019)
                                    (v128.const f64x2 0x0123456789ABCDEFabcdef.p-019 0x0123456789ABCDEFabcdef.p-019))
                                    (v128.const f64x2 0x1.23456789abcdfp+61 0x1.23456789abcdfp+61))
(assert_return (invoke "f64x2.pmin" (v128.const f64x2 0123456789.e+019 0123456789.e+019)
                                    (v128.const f64x2 0x0123456789ABCDEFabcdef.0123456789ABCDEFabcdef 0x0123456789ABCDEFabcdef.0123456789ABCDEFabcdef))
                                    (v128.const f64x2 0x1.23456789abcdfp+80 0x1.23456789abcdfp+80))
(assert_return (invoke "f64x2.pmin" (v128.const f64x2 0123456789.e+019 0123456789.e+019)
                                    (v128.const f64x2 0x0123456789ABCDEFabcdef.0123456789ABCDEFabcdefp019 0x0123456789ABCDEFabcdef.0123456789ABCDEFabcdefp019))
                                    (v128.const f64x2 0x1.fe9af5b5e16fap+89 0x1.fe9af5b5e16fap+89))
(assert_return (invoke "f64x2.pmin" (v128.const f64x2 0123456789.e+019 0123456789.e+019)
                                    (v128.const f64x2 0x0123456789ABCDEFabcdef.0123456789ABCDEFabcdefp+019 0x0123456789ABCDEFabcdef.0123456789ABCDEFabcdefp+019))
                                    (v128.const f64x2 0x1.fe9af5b5e16fap+89 0x1.fe9af5b5e16fap+89))
(assert_return (invoke "f64x2.pmin" (v128.const f64x2 0123456789.e+019 0123456789.e+019)
                                    (v128.const f64x2 0x0123456789ABCDEFabcdef.0123456789ABCDEFabcdefp-019 0x0123456789ABCDEFabcdef.0123456789ABCDEFabcdefp-019))
                                    (v128.const f64x2 0x1.23456789abcdfp+61 0x1.23456789abcdfp+61))
(assert_return (invoke "f64x2.pmin" (v128.const f64x2 0123456789.e-019 0123456789.e-019)
                                    (v128.const f64x2 0x0p+0 0x0p+0))
                                    (v128.const f64x2 0x0.0p+0 0x0.0p+0))
(assert_return (invoke "f64x2.pmin" (v128.const f64x2 0123456789.e-019 0123456789.e-019)
                                    (v128.const f64x2 -0x0p+0 -0x0p+0))
                                    (v128.const f64x2 -0x0.0p+0 -0x0.0p+0))
(assert_return (invoke "f64x2.pmin" (v128.const f64x2 0123456789.e-019 0123456789.e-019)
                                    (v128.const f64x2 0x1p-1022 0x1p-1022))
                                    (v128.const f64x2 0x1.0000000000000p-1022 0x1.0000000000000p-1022))
(assert_return (invoke "f64x2.pmin" (v128.const f64x2 0123456789.e-019 0123456789.e-019)
                                    (v128.const f64x2 -0x1p-1022 -0x1p-1022))
                                    (v128.const f64x2 -0x1.0000000000000p-1022 -0x1.0000000000000p-1022))
(assert_return (invoke "f64x2.pmin" (v128.const f64x2 0123456789.e-019 0123456789.e-019)
                                    (v128.const f64x2 0x1p-1 0x1p-1))
                                    (v128.const f64x2 0x1.b25ffd62b4311p-37 0x1.b25ffd62b4311p-37))
(assert_return (invoke "f64x2.pmin" (v128.const f64x2 0123456789.e-019 0123456789.e-019)
                                    (v128.const f64x2 -0x1p-1 -0x1p-1))
                                    (v128.const f64x2 -0x1.0000000000000p-1 -0x1.0000000000000p-1))
(assert_return (invoke "f64x2.pmin" (v128.const f64x2 0123456789.e-019 0123456789.e-019)
                                    (v128.const f64x2 0x1p+0 0x1p+0))
                                    (v128.const f64x2 0x1.b25ffd62b4311p-37 0x1.b25ffd62b4311p-37))
(assert_return (invoke "f64x2.pmin" (v128.const f64x2 0123456789.e-019 0123456789.e-019)
                                    (v128.const f64x2 -0x1p+0 -0x1p+0))
                                    (v128.const f64x2 -0x1.0000000000000p+0 -0x1.0000000000000p+0))
(assert_return (invoke "f64x2.pmin" (v128.const f64x2 0123456789.e-019 0123456789.e-019)
                                    (v128.const f64x2 0x1.921fb54442d18p+2 0x1.921fb54442d18p+2))
                                    (v128.const f64x2 0x1.b25ffd62b4311p-37 0x1.b25ffd62b4311p-37))
(assert_return (invoke "f64x2.pmin" (v128.const f64x2 0123456789.e-019 0123456789.e-019)
                                    (v128.const f64x2 -0x1.921fb54442d18p+2 -0x1.921fb54442d18p+2))
                                    (v128.const f64x2 -0x1.921fb54442d18p+2 -0x1.921fb54442d18p+2))
(assert_return (invoke "f64x2.pmin" (v128.const f64x2 0123456789.e-019 0123456789.e-019)
                                    (v128.const f64x2 0x1.fffffffffffffp+1023 0x1.fffffffffffffp+1023))
                                    (v128.const f64x2 0x1.b25ffd62b4311p-37 0x1.b25ffd62b4311p-37))
(assert_return (invoke "f64x2.pmin" (v128.const f64x2 0123456789.e-019 0123456789.e-019)
                                    (v128.const f64x2 -0x1.fffffffffffffp+1023 -0x1.fffffffffffffp+1023))
                                    (v128.const f64x2 -0x1.fffffffffffffp+1023 -0x1.fffffffffffffp+1023))
(assert_return (invoke "f64x2.pmin" (v128.const f64x2 0123456789.e-019 0123456789.e-019)
                                    (v128.const f64x2 0x0.0000000000001p-1022 0x0.0000000000001p-1022))
                                    (v128.const f64x2 0x0.0000000000001p-1022 0x0.0000000000001p-1022))
(assert_return (invoke "f64x2.pmin" (v128.const f64x2 0123456789.e-019 0123456789.e-019)
                                    (v128.const f64x2 0x0.0000000000001p-1022 0x0.0000000000001p-1022))
                                    (v128.const f64x2 0x0.0000000000001p-1022 0x0.0000000000001p-1022))
(assert_return (invoke "f64x2.pmin" (v128.const f64x2 0123456789.e-019 0123456789.e-019)
                                    (v128.const f64x2 inf inf))
                                    (v128.const f64x2 0x1.b25ffd62b4311p-37 0x1.b25ffd62b4311p-37))
(assert_return (invoke "f64x2.pmin" (v128.const f64x2 0123456789.e-019 0123456789.e-019)
                                    (v128.const f64x2 -inf -inf))
                                    (v128.const f64x2 -inf -inf))
(assert_return (invoke "f64x2.pmin" (v128.const f64x2 0123456789.e-019 0123456789.e-019)
                                    (v128.const f64x2 0123456789 0123456789))
                                    (v128.const f64x2 0x1.b25ffd62b4311p-37 0x1.b25ffd62b4311p-37))
(assert_return (invoke "f64x2.pmin" (v128.const f64x2 0123456789.e-019 0123456789.e-019)
                                    (v128.const f64x2 0123456789e019 0123456789e019))
                                    (v128.const f64x2 0x1.b25ffd62b4311p-37 0x1.b25ffd62b4311p-37))
(assert_return (invoke "f64x2.pmin" (v128.const f64x2 0123456789.e-019 0123456789.e-019)
                                    (v128.const f64x2 0123456789e+019 0123456789e+019))
                                    (v128.const f64x2 0x1.b25ffd62b4311p-37 0x1.b25ffd62b4311p-37))
(assert_return (invoke "f64x2.pmin" (v128.const f64x2 0123456789.e-019 0123456789.e-019)
                                    (v128.const f64x2 0123456789e-019 0123456789e-019))
                                    (v128.const f64x2 0x1.b25ffd62b4311p-37 0x1.b25ffd62b4311p-37))
(assert_return (invoke "f64x2.pmin" (v128.const f64x2 0123456789.e-019 0123456789.e-019)
                                    (v128.const f64x2 0123456789. 0123456789.))
                                    (v128.const f64x2 0x1.b25ffd62b4311p-37 0x1.b25ffd62b4311p-37))
(assert_return (invoke "f64x2.pmin" (v128.const f64x2 0123456789.e-019 0123456789.e-019)
                                    (v128.const f64x2 0123456789.e019 0123456789.e019))
                                    (v128.const f64x2 0x1.b25ffd62b4311p-37 0x1.b25ffd62b4311p-37))
(assert_return (invoke "f64x2.pmin" (v128.const f64x2 0123456789.e-019 0123456789.e-019)
                                    (v128.const f64x2 0123456789.e+019 0123456789.e+019))
                                    (v128.const f64x2 0x1.b25ffd62b4311p-37 0x1.b25ffd62b4311p-37))
(assert_return (invoke "f64x2.pmin" (v128.const f64x2 0123456789.e-019 0123456789.e-019)
                                    (v128.const f64x2 0123456789.e-019 0123456789.e-019))
                                    (v128.const f64x2 0x1.b25ffd62b4311p-37 0x1.b25ffd62b4311p-37))
(assert_return (invoke "f64x2.pmin" (v128.const f64x2 0123456789.e-019 0123456789.e-019)
                                    (v128.const f64x2 0123456789.0123456789 0123456789.0123456789))
                                    (v128.const f64x2 0x1.b25ffd62b4311p-37 0x1.b25ffd62b4311p-37))
(assert_return (invoke "f64x2.pmin" (v128.const f64x2 0123456789.e-019 0123456789.e-019)
                                    (v128.const f64x2 0123456789.0123456789e019 0123456789.0123456789e019))
                                    (v128.const f64x2 0x1.b25ffd62b4311p-37 0x1.b25ffd62b4311p-37))
(assert_return (invoke "f64x2.pmin" (v128.const f64x2 0123456789.e-019 0123456789.e-019)
                                    (v128.const f64x2 0123456789.0123456789e+019 0123456789.0123456789e+019))
                                    (v128.const f64x2 0x1.b25ffd62b4311p-37 0x1.b25ffd62b4311p-37))
(assert_return (invoke "f64x2.pmin" (v128.const f64x2 0123456789.e-019 0123456789.e-019)
                                    (v128.const f64x2 0123456789.0123456789e-019 0123456789.0123456789e-019))
                                    (v128.const f64x2 0x1.b25ffd62b4311p-37 0x1.b25ffd62b4311p-37))
(assert_return (invoke "f64x2.pmin" (v128.const f64x2 0123456789.e-019 0123456789.e-019)
                                    (v128.const f64x2 0x0123456789ABCDEFabcdef 0x0123456789ABCDEFabcdef))
                                    (v128.const f64x2 0x1.b25ffd62b4311p-37 0x1.b25ffd62b4311p-37))
(assert_return (invoke "f64x2.pmin" (v128.const f64x2 0123456789.e-019 0123456789.e-019)
                                    (v128.const f64x2 0x0123456789ABCDEFabcdefp019 0x0123456789ABCDEFabcdefp019))
                                    (v128.const f64x2 0x1.b25ffd62b4311p-37 0x1.b25ffd62b4311p-37))
(assert_return (invoke "f64x2.pmin" (v128.const f64x2 0123456789.e-019 0123456789.e-019)
                                    (v128.const f64x2 0x0123456789ABCDEFabcdefp+019 0x0123456789ABCDEFabcdefp+019))
                                    (v128.const f64x2 0x1.b25ffd62b4311p-37 0x1.b25ffd62b4311p-37))
(assert_return (invoke "f64x2.pmin" (v128.const f64x2 0123456789.e-019 0123456789.e-019)
                                    (v128.const f64x2 0x0123456789ABCDEFabcdefp-019 0x0123456789ABCDEFabcdefp-019))
                                    (v128.const f64x2 0x1.b25ffd62b4311p-37 0x1.b25ffd62b4311p-37))
(assert_return (invoke "f64x2.pmin" (v128.const f64x2 0123456789.e-019 0123456789.e-019)
                                    (v128.const f64x2 0x0123456789ABCDEFabcdef. 0x0123456789ABCDEFabcdef.))
                                    (v128.const f64x2 0x1.b25ffd62b4311p-37 0x1.b25ffd62b4311p-37))
(assert_return (invoke "f64x2.pmin" (v128.const f64x2 0123456789.e-019 0123456789.e-019)
                                    (v128.const f64x2 0x0123456789ABCDEFabcdef.p019 0x0123456789ABCDEFabcdef.p019))
                                    (v128.const f64x2 0x1.b25ffd62b4311p-37 0x1.b25ffd62b4311p-37))
(assert_return (invoke "f64x2.pmin" (v128.const f64x2 0123456789.e-019 0123456789.e-019)
                                    (v128.const f64x2 0x0123456789ABCDEFabcdef.p+019 0x0123456789ABCDEFabcdef.p+019))
                                    (v128.const f64x2 0x1.b25ffd62b4311p-37 0x1.b25ffd62b4311p-37))
(assert_return (invoke "f64x2.pmin" (v128.const f64x2 0123456789.e-019 0123456789.e-019)
                                    (v128.const f64x2 0x0123456789ABCDEFabcdef.p-019 0x0123456789ABCDEFabcdef.p-019))
                                    (v128.const f64x2 0x1.b25ffd62b4311p-37 0x1.b25ffd62b4311p-37))
(assert_return (invoke "f64x2.pmin" (v128.const f64x2 0123456789.e-019 0123456789.e-019)
                                    (v128.const f64x2 0x0123456789ABCDEFabcdef.0123456789ABCDEFabcdef 0x0123456789ABCDEFabcdef.0123456789ABCDEFabcdef))
                                    (v128.const f64x2 0x1.b25ffd62b4311p-37 0x1.b25ffd62b4311p-37))
(assert_return (invoke "f64x2.pmin" (v128.const f64x2 0123456789.e-019 0123456789.e-019)
                                    (v128.const f64x2 0x0123456789ABCDEFabcdef.0123456789ABCDEFabcdefp019 0x0123456789ABCDEFabcdef.0123456789ABCDEFabcdefp019))
                                    (v128.const f64x2 0x1.b25ffd62b4311p-37 0x1.b25ffd62b4311p-37))
(assert_return (invoke "f64x2.pmin" (v128.const f64x2 0123456789.e-019 0123456789.e-019)
                                    (v128.const f64x2 0x0123456789ABCDEFabcdef.0123456789ABCDEFabcdefp+019 0x0123456789ABCDEFabcdef.0123456789ABCDEFabcdefp+019))
                                    (v128.const f64x2 0x1.b25ffd62b4311p-37 0x1.b25ffd62b4311p-37))
(assert_return (invoke "f64x2.pmin" (v128.const f64x2 0123456789.e-019 0123456789.e-019)
                                    (v128.const f64x2 0x0123456789ABCDEFabcdef.0123456789ABCDEFabcdefp-019 0x0123456789ABCDEFabcdef.0123456789ABCDEFabcdefp-019))
                                    (v128.const f64x2 0x1.b25ffd62b4311p-37 0x1.b25ffd62b4311p-37))
(assert_return (invoke "f64x2.pmin" (v128.const f64x2 0123456789.0123456789 0123456789.0123456789)
                                    (v128.const f64x2 0x0p+0 0x0p+0))
                                    (v128.const f64x2 0x0.0p+0 0x0.0p+0))
(assert_return (invoke "f64x2.pmin" (v128.const f64x2 0123456789.0123456789 0123456789.0123456789)
                                    (v128.const f64x2 -0x0p+0 -0x0p+0))
                                    (v128.const f64x2 -0x0.0p+0 -0x0.0p+0))
(assert_return (invoke "f64x2.pmin" (v128.const f64x2 0123456789.0123456789 0123456789.0123456789)
                                    (v128.const f64x2 0x1p-1022 0x1p-1022))
                                    (v128.const f64x2 0x1.0000000000000p-1022 0x1.0000000000000p-1022))
(assert_return (invoke "f64x2.pmin" (v128.const f64x2 0123456789.0123456789 0123456789.0123456789)
                                    (v128.const f64x2 -0x1p-1022 -0x1p-1022))
                                    (v128.const f64x2 -0x1.0000000000000p-1022 -0x1.0000000000000p-1022))
(assert_return (invoke "f64x2.pmin" (v128.const f64x2 0123456789.0123456789 0123456789.0123456789)
                                    (v128.const f64x2 0x1p-1 0x1p-1))
                                    (v128.const f64x2 0x1.0000000000000p-1 0x1.0000000000000p-1))
(assert_return (invoke "f64x2.pmin" (v128.const f64x2 0123456789.0123456789 0123456789.0123456789)
                                    (v128.const f64x2 -0x1p-1 -0x1p-1))
                                    (v128.const f64x2 -0x1.0000000000000p-1 -0x1.0000000000000p-1))
(assert_return (invoke "f64x2.pmin" (v128.const f64x2 0123456789.0123456789 0123456789.0123456789)
                                    (v128.const f64x2 0x1p+0 0x1p+0))
                                    (v128.const f64x2 0x1.0000000000000p+0 0x1.0000000000000p+0))
(assert_return (invoke "f64x2.pmin" (v128.const f64x2 0123456789.0123456789 0123456789.0123456789)
                                    (v128.const f64x2 -0x1p+0 -0x1p+0))
                                    (v128.const f64x2 -0x1.0000000000000p+0 -0x1.0000000000000p+0))
(assert_return (invoke "f64x2.pmin" (v128.const f64x2 0123456789.0123456789 0123456789.0123456789)
                                    (v128.const f64x2 0x1.921fb54442d18p+2 0x1.921fb54442d18p+2))
                                    (v128.const f64x2 0x1.921fb54442d18p+2 0x1.921fb54442d18p+2))
(assert_return (invoke "f64x2.pmin" (v128.const f64x2 0123456789.0123456789 0123456789.0123456789)
                                    (v128.const f64x2 -0x1.921fb54442d18p+2 -0x1.921fb54442d18p+2))
                                    (v128.const f64x2 -0x1.921fb54442d18p+2 -0x1.921fb54442d18p+2))
(assert_return (invoke "f64x2.pmin" (v128.const f64x2 0123456789.0123456789 0123456789.0123456789)
                                    (v128.const f64x2 0x1.fffffffffffffp+1023 0x1.fffffffffffffp+1023))
                                    (v128.const f64x2 0x1.d6f34540ca458p+26 0x1.d6f34540ca458p+26))
(assert_return (invoke "f64x2.pmin" (v128.const f64x2 0123456789.0123456789 0123456789.0123456789)
                                    (v128.const f64x2 -0x1.fffffffffffffp+1023 -0x1.fffffffffffffp+1023))
                                    (v128.const f64x2 -0x1.fffffffffffffp+1023 -0x1.fffffffffffffp+1023))
(assert_return (invoke "f64x2.pmin" (v128.const f64x2 0123456789.0123456789 0123456789.0123456789)
                                    (v128.const f64x2 0x0.0000000000001p-1022 0x0.0000000000001p-1022))
                                    (v128.const f64x2 0x0.0000000000001p-1022 0x0.0000000000001p-1022))
(assert_return (invoke "f64x2.pmin" (v128.const f64x2 0123456789.0123456789 0123456789.0123456789)
                                    (v128.const f64x2 0x0.0000000000001p-1022 0x0.0000000000001p-1022))
                                    (v128.const f64x2 0x0.0000000000001p-1022 0x0.0000000000001p-1022))
(assert_return (invoke "f64x2.pmin" (v128.const f64x2 0123456789.0123456789 0123456789.0123456789)
                                    (v128.const f64x2 inf inf))
                                    (v128.const f64x2 0x1.d6f34540ca458p+26 0x1.d6f34540ca458p+26))
(assert_return (invoke "f64x2.pmin" (v128.const f64x2 0123456789.0123456789 0123456789.0123456789)
                                    (v128.const f64x2 -inf -inf))
                                    (v128.const f64x2 -inf -inf))
(assert_return (invoke "f64x2.pmin" (v128.const f64x2 0123456789.0123456789 0123456789.0123456789)
                                    (v128.const f64x2 0123456789 0123456789))
                                    (v128.const f64x2 0x1.d6f3454000000p+26 0x1.d6f3454000000p+26))
(assert_return (invoke "f64x2.pmin" (v128.const f64x2 0123456789.0123456789 0123456789.0123456789)
                                    (v128.const f64x2 0123456789e019 0123456789e019))
                                    (v128.const f64x2 0x1.d6f34540ca458p+26 0x1.d6f34540ca458p+26))
(assert_return (invoke "f64x2.pmin" (v128.const f64x2 0123456789.0123456789 0123456789.0123456789)
                                    (v128.const f64x2 0123456789e+019 0123456789e+019))
                                    (v128.const f64x2 0x1.d6f34540ca458p+26 0x1.d6f34540ca458p+26))
(assert_return (invoke "f64x2.pmin" (v128.const f64x2 0123456789.0123456789 0123456789.0123456789)
                                    (v128.const f64x2 0123456789e-019 0123456789e-019))
                                    (v128.const f64x2 0x1.b25ffd62b4311p-37 0x1.b25ffd62b4311p-37))
(assert_return (invoke "f64x2.pmin" (v128.const f64x2 0123456789.0123456789 0123456789.0123456789)
                                    (v128.const f64x2 0123456789. 0123456789.))
                                    (v128.const f64x2 0x1.d6f3454000000p+26 0x1.d6f3454000000p+26))
(assert_return (invoke "f64x2.pmin" (v128.const f64x2 0123456789.0123456789 0123456789.0123456789)
                                    (v128.const f64x2 0123456789.e019 0123456789.e019))
                                    (v128.const f64x2 0x1.d6f34540ca458p+26 0x1.d6f34540ca458p+26))
(assert_return (invoke "f64x2.pmin" (v128.const f64x2 0123456789.0123456789 0123456789.0123456789)
                                    (v128.const f64x2 0123456789.e+019 0123456789.e+019))
                                    (v128.const f64x2 0x1.d6f34540ca458p+26 0x1.d6f34540ca458p+26))
(assert_return (invoke "f64x2.pmin" (v128.const f64x2 0123456789.0123456789 0123456789.0123456789)
                                    (v128.const f64x2 0123456789.e-019 0123456789.e-019))
                                    (v128.const f64x2 0x1.b25ffd62b4311p-37 0x1.b25ffd62b4311p-37))
(assert_return (invoke "f64x2.pmin" (v128.const f64x2 0123456789.0123456789 0123456789.0123456789)
                                    (v128.const f64x2 0123456789.0123456789 0123456789.0123456789))
                                    (v128.const f64x2 0x1.d6f34540ca458p+26 0x1.d6f34540ca458p+26))
(assert_return (invoke "f64x2.pmin" (v128.const f64x2 0123456789.0123456789 0123456789.0123456789)
                                    (v128.const f64x2 0123456789.0123456789e019 0123456789.0123456789e019))
                                    (v128.const f64x2 0x1.d6f34540ca458p+26 0x1.d6f34540ca458p+26))
(assert_return (invoke "f64x2.pmin" (v128.const f64x2 0123456789.0123456789 0123456789.0123456789)
                                    (v128.const f64x2 0123456789.0123456789e+019 0123456789.0123456789e+019))
                                    (v128.const f64x2 0x1.d6f34540ca458p+26 0x1.d6f34540ca458p+26))
(assert_return (invoke "f64x2.pmin" (v128.const f64x2 0123456789.0123456789 0123456789.0123456789)
                                    (v128.const f64x2 0123456789.0123456789e-019 0123456789.0123456789e-019))
                                    (v128.const f64x2 0x1.b25ffd636ec12p-37 0x1.b25ffd636ec12p-37))
(assert_return (invoke "f64x2.pmin" (v128.const f64x2 0123456789.0123456789 0123456789.0123456789)
                                    (v128.const f64x2 0x0123456789ABCDEFabcdef 0x0123456789ABCDEFabcdef))
                                    (v128.const f64x2 0x1.d6f34540ca458p+26 0x1.d6f34540ca458p+26))
(assert_return (invoke "f64x2.pmin" (v128.const f64x2 0123456789.0123456789 0123456789.0123456789)
                                    (v128.const f64x2 0x0123456789ABCDEFabcdefp019 0x0123456789ABCDEFabcdefp019))
                                    (v128.const f64x2 0x1.d6f34540ca458p+26 0x1.d6f34540ca458p+26))
(assert_return (invoke "f64x2.pmin" (v128.const f64x2 0123456789.0123456789 0123456789.0123456789)
                                    (v128.const f64x2 0x0123456789ABCDEFabcdefp+019 0x0123456789ABCDEFabcdefp+019))
                                    (v128.const f64x2 0x1.d6f34540ca458p+26 0x1.d6f34540ca458p+26))
(assert_return (invoke "f64x2.pmin" (v128.const f64x2 0123456789.0123456789 0123456789.0123456789)
                                    (v128.const f64x2 0x0123456789ABCDEFabcdefp-019 0x0123456789ABCDEFabcdefp-019))
                                    (v128.const f64x2 0x1.d6f34540ca458p+26 0x1.d6f34540ca458p+26))
(assert_return (invoke "f64x2.pmin" (v128.const f64x2 0123456789.0123456789 0123456789.0123456789)
                                    (v128.const f64x2 0x0123456789ABCDEFabcdef. 0x0123456789ABCDEFabcdef.))
                                    (v128.const f64x2 0x1.d6f34540ca458p+26 0x1.d6f34540ca458p+26))
(assert_return (invoke "f64x2.pmin" (v128.const f64x2 0123456789.0123456789 0123456789.0123456789)
                                    (v128.const f64x2 0x0123456789ABCDEFabcdef.p019 0x0123456789ABCDEFabcdef.p019))
                                    (v128.const f64x2 0x1.d6f34540ca458p+26 0x1.d6f34540ca458p+26))
(assert_return (invoke "f64x2.pmin" (v128.const f64x2 0123456789.0123456789 0123456789.0123456789)
                                    (v128.const f64x2 0x0123456789ABCDEFabcdef.p+019 0x0123456789ABCDEFabcdef.p+019))
                                    (v128.const f64x2 0x1.d6f34540ca458p+26 0x1.d6f34540ca458p+26))
(assert_return (invoke "f64x2.pmin" (v128.const f64x2 0123456789.0123456789 0123456789.0123456789)
                                    (v128.const f64x2 0x0123456789ABCDEFabcdef.p-019 0x0123456789ABCDEFabcdef.p-019))
                                    (v128.const f64x2 0x1.d6f34540ca458p+26 0x1.d6f34540ca458p+26))
(assert_return (invoke "f64x2.pmin" (v128.const f64x2 0123456789.0123456789 0123456789.0123456789)
                                    (v128.const f64x2 0x0123456789ABCDEFabcdef.0123456789ABCDEFabcdef 0x0123456789ABCDEFabcdef.0123456789ABCDEFabcdef))
                                    (v128.const f64x2 0x1.d6f34540ca458p+26 0x1.d6f34540ca458p+26))
(assert_return (invoke "f64x2.pmin" (v128.const f64x2 0123456789.0123456789 0123456789.0123456789)
                                    (v128.const f64x2 0x0123456789ABCDEFabcdef.0123456789ABCDEFabcdefp019 0x0123456789ABCDEFabcdef.0123456789ABCDEFabcdefp019))
                                    (v128.const f64x2 0x1.d6f34540ca458p+26 0x1.d6f34540ca458p+26))
(assert_return (invoke "f64x2.pmin" (v128.const f64x2 0123456789.0123456789 0123456789.0123456789)
                                    (v128.const f64x2 0x0123456789ABCDEFabcdef.0123456789ABCDEFabcdefp+019 0x0123456789ABCDEFabcdef.0123456789ABCDEFabcdefp+019))
                                    (v128.const f64x2 0x1.d6f34540ca458p+26 0x1.d6f34540ca458p+26))
(assert_return (invoke "f64x2.pmin" (v128.const f64x2 0123456789.0123456789 0123456789.0123456789)
                                    (v128.const f64x2 0x0123456789ABCDEFabcdef.0123456789ABCDEFabcdefp-019 0x0123456789ABCDEFabcdef.0123456789ABCDEFabcdefp-019))
                                    (v128.const f64x2 0x1.d6f34540ca458p+26 0x1.d6f34540ca458p+26))
(assert_return (invoke "f64x2.pmin" (v128.const f64x2 0123456789.0123456789e019 0123456789.0123456789e019)
                                    (v128.const f64x2 0x0p+0 0x0p+0))
                                    (v128.const f64x2 0x0.0p+0 0x0.0p+0))
(assert_return (invoke "f64x2.pmin" (v128.const f64x2 0123456789.0123456789e019 0123456789.0123456789e019)
                                    (v128.const f64x2 -0x0p+0 -0x0p+0))
                                    (v128.const f64x2 -0x0.0p+0 -0x0.0p+0))
(assert_return (invoke "f64x2.pmin" (v128.const f64x2 0123456789.0123456789e019 0123456789.0123456789e019)
                                    (v128.const f64x2 0x1p-1022 0x1p-1022))
                                    (v128.const f64x2 0x1.0000000000000p-1022 0x1.0000000000000p-1022))
(assert_return (invoke "f64x2.pmin" (v128.const f64x2 0123456789.0123456789e019 0123456789.0123456789e019)
                                    (v128.const f64x2 -0x1p-1022 -0x1p-1022))
                                    (v128.const f64x2 -0x1.0000000000000p-1022 -0x1.0000000000000p-1022))
(assert_return (invoke "f64x2.pmin" (v128.const f64x2 0123456789.0123456789e019 0123456789.0123456789e019)
                                    (v128.const f64x2 0x1p-1 0x1p-1))
                                    (v128.const f64x2 0x1.0000000000000p-1 0x1.0000000000000p-1))
(assert_return (invoke "f64x2.pmin" (v128.const f64x2 0123456789.0123456789e019 0123456789.0123456789e019)
                                    (v128.const f64x2 -0x1p-1 -0x1p-1))
                                    (v128.const f64x2 -0x1.0000000000000p-1 -0x1.0000000000000p-1))
(assert_return (invoke "f64x2.pmin" (v128.const f64x2 0123456789.0123456789e019 0123456789.0123456789e019)
                                    (v128.const f64x2 0x1p+0 0x1p+0))
                                    (v128.const f64x2 0x1.0000000000000p+0 0x1.0000000000000p+0))
(assert_return (invoke "f64x2.pmin" (v128.const f64x2 0123456789.0123456789e019 0123456789.0123456789e019)
                                    (v128.const f64x2 -0x1p+0 -0x1p+0))
                                    (v128.const f64x2 -0x1.0000000000000p+0 -0x1.0000000000000p+0))
(assert_return (invoke "f64x2.pmin" (v128.const f64x2 0123456789.0123456789e019 0123456789.0123456789e019)
                                    (v128.const f64x2 0x1.921fb54442d18p+2 0x1.921fb54442d18p+2))
                                    (v128.const f64x2 0x1.921fb54442d18p+2 0x1.921fb54442d18p+2))
(assert_return (invoke "f64x2.pmin" (v128.const f64x2 0123456789.0123456789e019 0123456789.0123456789e019)
                                    (v128.const f64x2 -0x1.921fb54442d18p+2 -0x1.921fb54442d18p+2))
                                    (v128.const f64x2 -0x1.921fb54442d18p+2 -0x1.921fb54442d18p+2))
(assert_return (invoke "f64x2.pmin" (v128.const f64x2 0123456789.0123456789e019 0123456789.0123456789e019)
                                    (v128.const f64x2 0x1.fffffffffffffp+1023 0x1.fffffffffffffp+1023))
                                    (v128.const f64x2 0x1.fe9af5b6bcbd5p+89 0x1.fe9af5b6bcbd5p+89))
(assert_return (invoke "f64x2.pmin" (v128.const f64x2 0123456789.0123456789e019 0123456789.0123456789e019)
                                    (v128.const f64x2 -0x1.fffffffffffffp+1023 -0x1.fffffffffffffp+1023))
                                    (v128.const f64x2 -0x1.fffffffffffffp+1023 -0x1.fffffffffffffp+1023))
(assert_return (invoke "f64x2.pmin" (v128.const f64x2 0123456789.0123456789e019 0123456789.0123456789e019)
                                    (v128.const f64x2 0x0.0000000000001p-1022 0x0.0000000000001p-1022))
                                    (v128.const f64x2 0x0.0000000000001p-1022 0x0.0000000000001p-1022))
(assert_return (invoke "f64x2.pmin" (v128.const f64x2 0123456789.0123456789e019 0123456789.0123456789e019)
                                    (v128.const f64x2 0x0.0000000000001p-1022 0x0.0000000000001p-1022))
                                    (v128.const f64x2 0x0.0000000000001p-1022 0x0.0000000000001p-1022))
(assert_return (invoke "f64x2.pmin" (v128.const f64x2 0123456789.0123456789e019 0123456789.0123456789e019)
                                    (v128.const f64x2 inf inf))
                                    (v128.const f64x2 0x1.fe9af5b6bcbd5p+89 0x1.fe9af5b6bcbd5p+89))
(assert_return (invoke "f64x2.pmin" (v128.const f64x2 0123456789.0123456789e019 0123456789.0123456789e019)
                                    (v128.const f64x2 -inf -inf))
                                    (v128.const f64x2 -inf -inf))
(assert_return (invoke "f64x2.pmin" (v128.const f64x2 0123456789.0123456789e019 0123456789.0123456789e019)
                                    (v128.const f64x2 0123456789 0123456789))
                                    (v128.const f64x2 0x1.d6f3454000000p+26 0x1.d6f3454000000p+26))
(assert_return (invoke "f64x2.pmin" (v128.const f64x2 0123456789.0123456789e019 0123456789.0123456789e019)
                                    (v128.const f64x2 0123456789e019 0123456789e019))
                                    (v128.const f64x2 0x1.fe9af5b5e16fap+89 0x1.fe9af5b5e16fap+89))
(assert_return (invoke "f64x2.pmin" (v128.const f64x2 0123456789.0123456789e019 0123456789.0123456789e019)
                                    (v128.const f64x2 0123456789e+019 0123456789e+019))
                                    (v128.const f64x2 0x1.fe9af5b5e16fap+89 0x1.fe9af5b5e16fap+89))
(assert_return (invoke "f64x2.pmin" (v128.const f64x2 0123456789.0123456789e019 0123456789.0123456789e019)
                                    (v128.const f64x2 0123456789e-019 0123456789e-019))
                                    (v128.const f64x2 0x1.b25ffd62b4311p-37 0x1.b25ffd62b4311p-37))
(assert_return (invoke "f64x2.pmin" (v128.const f64x2 0123456789.0123456789e019 0123456789.0123456789e019)
                                    (v128.const f64x2 0123456789. 0123456789.))
                                    (v128.const f64x2 0x1.d6f3454000000p+26 0x1.d6f3454000000p+26))
(assert_return (invoke "f64x2.pmin" (v128.const f64x2 0123456789.0123456789e019 0123456789.0123456789e019)
                                    (v128.const f64x2 0123456789.e019 0123456789.e019))
                                    (v128.const f64x2 0x1.fe9af5b5e16fap+89 0x1.fe9af5b5e16fap+89))
(assert_return (invoke "f64x2.pmin" (v128.const f64x2 0123456789.0123456789e019 0123456789.0123456789e019)
                                    (v128.const f64x2 0123456789.e+019 0123456789.e+019))
                                    (v128.const f64x2 0x1.fe9af5b5e16fap+89 0x1.fe9af5b5e16fap+89))
(assert_return (invoke "f64x2.pmin" (v128.const f64x2 0123456789.0123456789e019 0123456789.0123456789e019)
                                    (v128.const f64x2 0123456789.e-019 0123456789.e-019))
                                    (v128.const f64x2 0x1.b25ffd62b4311p-37 0x1.b25ffd62b4311p-37))
(assert_return (invoke "f64x2.pmin" (v128.const f64x2 0123456789.0123456789e019 0123456789.0123456789e019)
                                    (v128.const f64x2 0123456789.0123456789 0123456789.0123456789))
                                    (v128.const f64x2 0x1.d6f34540ca458p+26 0x1.d6f34540ca458p+26))
(assert_return (invoke "f64x2.pmin" (v128.const f64x2 0123456789.0123456789e019 0123456789.0123456789e019)
                                    (v128.const f64x2 0123456789.0123456789e019 0123456789.0123456789e019))
                                    (v128.const f64x2 0x1.fe9af5b6bcbd5p+89 0x1.fe9af5b6bcbd5p+89))
(assert_return (invoke "f64x2.pmin" (v128.const f64x2 0123456789.0123456789e019 0123456789.0123456789e019)
                                    (v128.const f64x2 0123456789.0123456789e+019 0123456789.0123456789e+019))
                                    (v128.const f64x2 0x1.fe9af5b6bcbd5p+89 0x1.fe9af5b6bcbd5p+89))
(assert_return (invoke "f64x2.pmin" (v128.const f64x2 0123456789.0123456789e019 0123456789.0123456789e019)
                                    (v128.const f64x2 0123456789.0123456789e-019 0123456789.0123456789e-019))
                                    (v128.const f64x2 0x1.b25ffd636ec12p-37 0x1.b25ffd636ec12p-37))
(assert_return (invoke "f64x2.pmin" (v128.const f64x2 0123456789.0123456789e019 0123456789.0123456789e019)
                                    (v128.const f64x2 0x0123456789ABCDEFabcdef 0x0123456789ABCDEFabcdef))
                                    (v128.const f64x2 0x1.23456789abcdfp+80 0x1.23456789abcdfp+80))
(assert_return (invoke "f64x2.pmin" (v128.const f64x2 0123456789.0123456789e019 0123456789.0123456789e019)
                                    (v128.const f64x2 0x0123456789ABCDEFabcdefp019 0x0123456789ABCDEFabcdefp019))
                                    (v128.const f64x2 0x1.fe9af5b6bcbd5p+89 0x1.fe9af5b6bcbd5p+89))
(assert_return (invoke "f64x2.pmin" (v128.const f64x2 0123456789.0123456789e019 0123456789.0123456789e019)
                                    (v128.const f64x2 0x0123456789ABCDEFabcdefp+019 0x0123456789ABCDEFabcdefp+019))
                                    (v128.const f64x2 0x1.fe9af5b6bcbd5p+89 0x1.fe9af5b6bcbd5p+89))
(assert_return (invoke "f64x2.pmin" (v128.const f64x2 0123456789.0123456789e019 0123456789.0123456789e019)
                                    (v128.const f64x2 0x0123456789ABCDEFabcdefp-019 0x0123456789ABCDEFabcdefp-019))
                                    (v128.const f64x2 0x1.23456789abcdfp+61 0x1.23456789abcdfp+61))
(assert_return (invoke "f64x2.pmin" (v128.const f64x2 0123456789.0123456789e019 0123456789.0123456789e019)
                                    (v128.const f64x2 0x0123456789ABCDEFabcdef. 0x0123456789ABCDEFabcdef.))
                                    (v128.const f64x2 0x1.23456789abcdfp+80 0x1.23456789abcdfp+80))
(assert_return (invoke "f64x2.pmin" (v128.const f64x2 0123456789.0123456789e019 0123456789.0123456789e019)
                                    (v128.const f64x2 0x0123456789ABCDEFabcdef.p019 0x0123456789ABCDEFabcdef.p019))
                                    (v128.const f64x2 0x1.fe9af5b6bcbd5p+89 0x1.fe9af5b6bcbd5p+89))
(assert_return (invoke "f64x2.pmin" (v128.const f64x2 0123456789.0123456789e019 0123456789.0123456789e019)
                                    (v128.const f64x2 0x0123456789ABCDEFabcdef.p+019 0x0123456789ABCDEFabcdef.p+019))
                                    (v128.const f64x2 0x1.fe9af5b6bcbd5p+89 0x1.fe9af5b6bcbd5p+89))
(assert_return (invoke "f64x2.pmin" (v128.const f64x2 0123456789.0123456789e019 0123456789.0123456789e019)
                                    (v128.const f64x2 0x0123456789ABCDEFabcdef.p-019 0x0123456789ABCDEFabcdef.p-019))
                                    (v128.const f64x2 0x1.23456789abcdfp+61 0x1.23456789abcdfp+61))
(assert_return (invoke "f64x2.pmin" (v128.const f64x2 0123456789.0123456789e019 0123456789.0123456789e019)
                                    (v128.const f64x2 0x0123456789ABCDEFabcdef.0123456789ABCDEFabcdef 0x0123456789ABCDEFabcdef.0123456789ABCDEFabcdef))
                                    (v128.const f64x2 0x1.23456789abcdfp+80 0x1.23456789abcdfp+80))
(assert_return (invoke "f64x2.pmin" (v128.const f64x2 0123456789.0123456789e019 0123456789.0123456789e019)
                                    (v128.const f64x2 0x0123456789ABCDEFabcdef.0123456789ABCDEFabcdefp019 0x0123456789ABCDEFabcdef.0123456789ABCDEFabcdefp019))
                                    (v128.const f64x2 0x1.fe9af5b6bcbd5p+89 0x1.fe9af5b6bcbd5p+89))
(assert_return (invoke "f64x2.pmin" (v128.const f64x2 0123456789.0123456789e019 0123456789.0123456789e019)
                                    (v128.const f64x2 0x0123456789ABCDEFabcdef.0123456789ABCDEFabcdefp+019 0x0123456789ABCDEFabcdef.0123456789ABCDEFabcdefp+019))
                                    (v128.const f64x2 0x1.fe9af5b6bcbd5p+89 0x1.fe9af5b6bcbd5p+89))
(assert_return (invoke "f64x2.pmin" (v128.const f64x2 0123456789.0123456789e019 0123456789.0123456789e019)
                                    (v128.const f64x2 0x0123456789ABCDEFabcdef.0123456789ABCDEFabcdefp-019 0x0123456789ABCDEFabcdef.0123456789ABCDEFabcdefp-019))
                                    (v128.const f64x2 0x1.23456789abcdfp+61 0x1.23456789abcdfp+61))
(assert_return (invoke "f64x2.pmin" (v128.const f64x2 0123456789.0123456789e+019 0123456789.0123456789e+019)
                                    (v128.const f64x2 0x0p+0 0x0p+0))
                                    (v128.const f64x2 0x0.0p+0 0x0.0p+0))
(assert_return (invoke "f64x2.pmin" (v128.const f64x2 0123456789.0123456789e+019 0123456789.0123456789e+019)
                                    (v128.const f64x2 -0x0p+0 -0x0p+0))
                                    (v128.const f64x2 -0x0.0p+0 -0x0.0p+0))
(assert_return (invoke "f64x2.pmin" (v128.const f64x2 0123456789.0123456789e+019 0123456789.0123456789e+019)
                                    (v128.const f64x2 0x1p-1022 0x1p-1022))
                                    (v128.const f64x2 0x1.0000000000000p-1022 0x1.0000000000000p-1022))
(assert_return (invoke "f64x2.pmin" (v128.const f64x2 0123456789.0123456789e+019 0123456789.0123456789e+019)
                                    (v128.const f64x2 -0x1p-1022 -0x1p-1022))
                                    (v128.const f64x2 -0x1.0000000000000p-1022 -0x1.0000000000000p-1022))
(assert_return (invoke "f64x2.pmin" (v128.const f64x2 0123456789.0123456789e+019 0123456789.0123456789e+019)
                                    (v128.const f64x2 0x1p-1 0x1p-1))
                                    (v128.const f64x2 0x1.0000000000000p-1 0x1.0000000000000p-1))
(assert_return (invoke "f64x2.pmin" (v128.const f64x2 0123456789.0123456789e+019 0123456789.0123456789e+019)
                                    (v128.const f64x2 -0x1p-1 -0x1p-1))
                                    (v128.const f64x2 -0x1.0000000000000p-1 -0x1.0000000000000p-1))
(assert_return (invoke "f64x2.pmin" (v128.const f64x2 0123456789.0123456789e+019 0123456789.0123456789e+019)
                                    (v128.const f64x2 0x1p+0 0x1p+0))
                                    (v128.const f64x2 0x1.0000000000000p+0 0x1.0000000000000p+0))
(assert_return (invoke "f64x2.pmin" (v128.const f64x2 0123456789.0123456789e+019 0123456789.0123456789e+019)
                                    (v128.const f64x2 -0x1p+0 -0x1p+0))
                                    (v128.const f64x2 -0x1.0000000000000p+0 -0x1.0000000000000p+0))
(assert_return (invoke "f64x2.pmin" (v128.const f64x2 0123456789.0123456789e+019 0123456789.0123456789e+019)
                                    (v128.const f64x2 0x1.921fb54442d18p+2 0x1.921fb54442d18p+2))
                                    (v128.const f64x2 0x1.921fb54442d18p+2 0x1.921fb54442d18p+2))
(assert_return (invoke "f64x2.pmin" (v128.const f64x2 0123456789.0123456789e+019 0123456789.0123456789e+019)
                                    (v128.const f64x2 -0x1.921fb54442d18p+2 -0x1.921fb54442d18p+2))
                                    (v128.const f64x2 -0x1.921fb54442d18p+2 -0x1.921fb54442d18p+2))
(assert_return (invoke "f64x2.pmin" (v128.const f64x2 0123456789.0123456789e+019 0123456789.0123456789e+019)
                                    (v128.const f64x2 0x1.fffffffffffffp+1023 0x1.fffffffffffffp+1023))
                                    (v128.const f64x2 0x1.fe9af5b6bcbd5p+89 0x1.fe9af5b6bcbd5p+89))
(assert_return (invoke "f64x2.pmin" (v128.const f64x2 0123456789.0123456789e+019 0123456789.0123456789e+019)
                                    (v128.const f64x2 -0x1.fffffffffffffp+1023 -0x1.fffffffffffffp+1023))
                                    (v128.const f64x2 -0x1.fffffffffffffp+1023 -0x1.fffffffffffffp+1023))
(assert_return (invoke "f64x2.pmin" (v128.const f64x2 0123456789.0123456789e+019 0123456789.0123456789e+019)
                                    (v128.const f64x2 0x0.0000000000001p-1022 0x0.0000000000001p-1022))
                                    (v128.const f64x2 0x0.0000000000001p-1022 0x0.0000000000001p-1022))
(assert_return (invoke "f64x2.pmin" (v128.const f64x2 0123456789.0123456789e+019 0123456789.0123456789e+019)
                                    (v128.const f64x2 0x0.0000000000001p-1022 0x0.0000000000001p-1022))
                                    (v128.const f64x2 0x0.0000000000001p-1022 0x0.0000000000001p-1022))
(assert_return (invoke "f64x2.pmin" (v128.const f64x2 0123456789.0123456789e+019 0123456789.0123456789e+019)
                                    (v128.const f64x2 inf inf))
                                    (v128.const f64x2 0x1.fe9af5b6bcbd5p+89 0x1.fe9af5b6bcbd5p+89))
(assert_return (invoke "f64x2.pmin" (v128.const f64x2 0123456789.0123456789e+019 0123456789.0123456789e+019)
                                    (v128.const f64x2 -inf -inf))
                                    (v128.const f64x2 -inf -inf))
(assert_return (invoke "f64x2.pmin" (v128.const f64x2 0123456789.0123456789e+019 0123456789.0123456789e+019)
                                    (v128.const f64x2 0123456789 0123456789))
                                    (v128.const f64x2 0x1.d6f3454000000p+26 0x1.d6f3454000000p+26))
(assert_return (invoke "f64x2.pmin" (v128.const f64x2 0123456789.0123456789e+019 0123456789.0123456789e+019)
                                    (v128.const f64x2 0123456789e019 0123456789e019))
                                    (v128.const f64x2 0x1.fe9af5b5e16fap+89 0x1.fe9af5b5e16fap+89))
(assert_return (invoke "f64x2.pmin" (v128.const f64x2 0123456789.0123456789e+019 0123456789.0123456789e+019)
                                    (v128.const f64x2 0123456789e+019 0123456789e+019))
                                    (v128.const f64x2 0x1.fe9af5b5e16fap+89 0x1.fe9af5b5e16fap+89))
(assert_return (invoke "f64x2.pmin" (v128.const f64x2 0123456789.0123456789e+019 0123456789.0123456789e+019)
                                    (v128.const f64x2 0123456789e-019 0123456789e-019))
                                    (v128.const f64x2 0x1.b25ffd62b4311p-37 0x1.b25ffd62b4311p-37))
(assert_return (invoke "f64x2.pmin" (v128.const f64x2 0123456789.0123456789e+019 0123456789.0123456789e+019)
                                    (v128.const f64x2 0123456789. 0123456789.))
                                    (v128.const f64x2 0x1.d6f3454000000p+26 0x1.d6f3454000000p+26))
(assert_return (invoke "f64x2.pmin" (v128.const f64x2 0123456789.0123456789e+019 0123456789.0123456789e+019)
                                    (v128.const f64x2 0123456789.e019 0123456789.e019))
                                    (v128.const f64x2 0x1.fe9af5b5e16fap+89 0x1.fe9af5b5e16fap+89))
(assert_return (invoke "f64x2.pmin" (v128.const f64x2 0123456789.0123456789e+019 0123456789.0123456789e+019)
                                    (v128.const f64x2 0123456789.e+019 0123456789.e+019))
                                    (v128.const f64x2 0x1.fe9af5b5e16fap+89 0x1.fe9af5b5e16fap+89))
(assert_return (invoke "f64x2.pmin" (v128.const f64x2 0123456789.0123456789e+019 0123456789.0123456789e+019)
                                    (v128.const f64x2 0123456789.e-019 0123456789.e-019))
                                    (v128.const f64x2 0x1.b25ffd62b4311p-37 0x1.b25ffd62b4311p-37))
(assert_return (invoke "f64x2.pmin" (v128.const f64x2 0123456789.0123456789e+019 0123456789.0123456789e+019)
                                    (v128.const f64x2 0123456789.0123456789 0123456789.0123456789))
                                    (v128.const f64x2 0x1.d6f34540ca458p+26 0x1.d6f34540ca458p+26))
(assert_return (invoke "f64x2.pmin" (v128.const f64x2 0123456789.0123456789e+019 0123456789.0123456789e+019)
                                    (v128.const f64x2 0123456789.0123456789e019 0123456789.0123456789e019))
                                    (v128.const f64x2 0x1.fe9af5b6bcbd5p+89 0x1.fe9af5b6bcbd5p+89))
(assert_return (invoke "f64x2.pmin" (v128.const f64x2 0123456789.0123456789e+019 0123456789.0123456789e+019)
                                    (v128.const f64x2 0123456789.0123456789e+019 0123456789.0123456789e+019))
                                    (v128.const f64x2 0x1.fe9af5b6bcbd5p+89 0x1.fe9af5b6bcbd5p+89))
(assert_return (invoke "f64x2.pmin" (v128.const f64x2 0123456789.0123456789e+019 0123456789.0123456789e+019)
                                    (v128.const f64x2 0123456789.0123456789e-019 0123456789.0123456789e-019))
                                    (v128.const f64x2 0x1.b25ffd636ec12p-37 0x1.b25ffd636ec12p-37))
(assert_return (invoke "f64x2.pmin" (v128.const f64x2 0123456789.0123456789e+019 0123456789.0123456789e+019)
                                    (v128.const f64x2 0x0123456789ABCDEFabcdef 0x0123456789ABCDEFabcdef))
                                    (v128.const f64x2 0x1.23456789abcdfp+80 0x1.23456789abcdfp+80))
(assert_return (invoke "f64x2.pmin" (v128.const f64x2 0123456789.0123456789e+019 0123456789.0123456789e+019)
                                    (v128.const f64x2 0x0123456789ABCDEFabcdefp019 0x0123456789ABCDEFabcdefp019))
                                    (v128.const f64x2 0x1.fe9af5b6bcbd5p+89 0x1.fe9af5b6bcbd5p+89))
(assert_return (invoke "f64x2.pmin" (v128.const f64x2 0123456789.0123456789e+019 0123456789.0123456789e+019)
                                    (v128.const f64x2 0x0123456789ABCDEFabcdefp+019 0x0123456789ABCDEFabcdefp+019))
                                    (v128.const f64x2 0x1.fe9af5b6bcbd5p+89 0x1.fe9af5b6bcbd5p+89))
(assert_return (invoke "f64x2.pmin" (v128.const f64x2 0123456789.0123456789e+019 0123456789.0123456789e+019)
                                    (v128.const f64x2 0x0123456789ABCDEFabcdefp-019 0x0123456789ABCDEFabcdefp-019))
                                    (v128.const f64x2 0x1.23456789abcdfp+61 0x1.23456789abcdfp+61))
(assert_return (invoke "f64x2.pmin" (v128.const f64x2 0123456789.0123456789e+019 0123456789.0123456789e+019)
                                    (v128.const f64x2 0x0123456789ABCDEFabcdef. 0x0123456789ABCDEFabcdef.))
                                    (v128.const f64x2 0x1.23456789abcdfp+80 0x1.23456789abcdfp+80))
(assert_return (invoke "f64x2.pmin" (v128.const f64x2 0123456789.0123456789e+019 0123456789.0123456789e+019)
                                    (v128.const f64x2 0x0123456789ABCDEFabcdef.p019 0x0123456789ABCDEFabcdef.p019))
                                    (v128.const f64x2 0x1.fe9af5b6bcbd5p+89 0x1.fe9af5b6bcbd5p+89))
(assert_return (invoke "f64x2.pmin" (v128.const f64x2 0123456789.0123456789e+019 0123456789.0123456789e+019)
                                    (v128.const f64x2 0x0123456789ABCDEFabcdef.p+019 0x0123456789ABCDEFabcdef.p+019))
                                    (v128.const f64x2 0x1.fe9af5b6bcbd5p+89 0x1.fe9af5b6bcbd5p+89))
(assert_return (invoke "f64x2.pmin" (v128.const f64x2 0123456789.0123456789e+019 0123456789.0123456789e+019)
                                    (v128.const f64x2 0x0123456789ABCDEFabcdef.p-019 0x0123456789ABCDEFabcdef.p-019))
                                    (v128.const f64x2 0x1.23456789abcdfp+61 0x1.23456789abcdfp+61))
(assert_return (invoke "f64x2.pmin" (v128.const f64x2 0123456789.0123456789e+019 0123456789.0123456789e+019)
                                    (v128.const f64x2 0x0123456789ABCDEFabcdef.0123456789ABCDEFabcdef 0x0123456789ABCDEFabcdef.0123456789ABCDEFabcdef))
                                    (v128.const f64x2 0x1.23456789abcdfp+80 0x1.23456789abcdfp+80))
(assert_return (invoke "f64x2.pmin" (v128.const f64x2 0123456789.0123456789e+019 0123456789.0123456789e+019)
                                    (v128.const f64x2 0x0123456789ABCDEFabcdef.0123456789ABCDEFabcdefp019 0x0123456789ABCDEFabcdef.0123456789ABCDEFabcdefp019))
                                    (v128.const f64x2 0x1.fe9af5b6bcbd5p+89 0x1.fe9af5b6bcbd5p+89))
(assert_return (invoke "f64x2.pmin" (v128.const f64x2 0123456789.0123456789e+019 0123456789.0123456789e+019)
                                    (v128.const f64x2 0x0123456789ABCDEFabcdef.0123456789ABCDEFabcdefp+019 0x0123456789ABCDEFabcdef.0123456789ABCDEFabcdefp+019))
                                    (v128.const f64x2 0x1.fe9af5b6bcbd5p+89 0x1.fe9af5b6bcbd5p+89))
(assert_return (invoke "f64x2.pmin" (v128.const f64x2 0123456789.0123456789e+019 0123456789.0123456789e+019)
                                    (v128.const f64x2 0x0123456789ABCDEFabcdef.0123456789ABCDEFabcdefp-019 0x0123456789ABCDEFabcdef.0123456789ABCDEFabcdefp-019))
                                    (v128.const f64x2 0x1.23456789abcdfp+61 0x1.23456789abcdfp+61))
(assert_return (invoke "f64x2.pmin" (v128.const f64x2 0123456789.0123456789e-019 0123456789.0123456789e-019)
                                    (v128.const f64x2 0x0p+0 0x0p+0))
                                    (v128.const f64x2 0x0.0p+0 0x0.0p+0))
(assert_return (invoke "f64x2.pmin" (v128.const f64x2 0123456789.0123456789e-019 0123456789.0123456789e-019)
                                    (v128.const f64x2 -0x0p+0 -0x0p+0))
                                    (v128.const f64x2 -0x0.0p+0 -0x0.0p+0))
(assert_return (invoke "f64x2.pmin" (v128.const f64x2 0123456789.0123456789e-019 0123456789.0123456789e-019)
                                    (v128.const f64x2 0x1p-1022 0x1p-1022))
                                    (v128.const f64x2 0x1.0000000000000p-1022 0x1.0000000000000p-1022))
(assert_return (invoke "f64x2.pmin" (v128.const f64x2 0123456789.0123456789e-019 0123456789.0123456789e-019)
                                    (v128.const f64x2 -0x1p-1022 -0x1p-1022))
                                    (v128.const f64x2 -0x1.0000000000000p-1022 -0x1.0000000000000p-1022))
(assert_return (invoke "f64x2.pmin" (v128.const f64x2 0123456789.0123456789e-019 0123456789.0123456789e-019)
                                    (v128.const f64x2 0x1p-1 0x1p-1))
                                    (v128.const f64x2 0x1.b25ffd636ec12p-37 0x1.b25ffd636ec12p-37))
(assert_return (invoke "f64x2.pmin" (v128.const f64x2 0123456789.0123456789e-019 0123456789.0123456789e-019)
                                    (v128.const f64x2 -0x1p-1 -0x1p-1))
                                    (v128.const f64x2 -0x1.0000000000000p-1 -0x1.0000000000000p-1))
(assert_return (invoke "f64x2.pmin" (v128.const f64x2 0123456789.0123456789e-019 0123456789.0123456789e-019)
                                    (v128.const f64x2 0x1p+0 0x1p+0))
                                    (v128.const f64x2 0x1.b25ffd636ec12p-37 0x1.b25ffd636ec12p-37))
(assert_return (invoke "f64x2.pmin" (v128.const f64x2 0123456789.0123456789e-019 0123456789.0123456789e-019)
                                    (v128.const f64x2 -0x1p+0 -0x1p+0))
                                    (v128.const f64x2 -0x1.0000000000000p+0 -0x1.0000000000000p+0))
(assert_return (invoke "f64x2.pmin" (v128.const f64x2 0123456789.0123456789e-019 0123456789.0123456789e-019)
                                    (v128.const f64x2 0x1.921fb54442d18p+2 0x1.921fb54442d18p+2))
                                    (v128.const f64x2 0x1.b25ffd636ec12p-37 0x1.b25ffd636ec12p-37))
(assert_return (invoke "f64x2.pmin" (v128.const f64x2 0123456789.0123456789e-019 0123456789.0123456789e-019)
                                    (v128.const f64x2 -0x1.921fb54442d18p+2 -0x1.921fb54442d18p+2))
                                    (v128.const f64x2 -0x1.921fb54442d18p+2 -0x1.921fb54442d18p+2))
(assert_return (invoke "f64x2.pmin" (v128.const f64x2 0123456789.0123456789e-019 0123456789.0123456789e-019)
                                    (v128.const f64x2 0x1.fffffffffffffp+1023 0x1.fffffffffffffp+1023))
                                    (v128.const f64x2 0x1.b25ffd636ec12p-37 0x1.b25ffd636ec12p-37))
(assert_return (invoke "f64x2.pmin" (v128.const f64x2 0123456789.0123456789e-019 0123456789.0123456789e-019)
                                    (v128.const f64x2 -0x1.fffffffffffffp+1023 -0x1.fffffffffffffp+1023))
                                    (v128.const f64x2 -0x1.fffffffffffffp+1023 -0x1.fffffffffffffp+1023))
(assert_return (invoke "f64x2.pmin" (v128.const f64x2 0123456789.0123456789e-019 0123456789.0123456789e-019)
                                    (v128.const f64x2 0x0.0000000000001p-1022 0x0.0000000000001p-1022))
                                    (v128.const f64x2 0x0.0000000000001p-1022 0x0.0000000000001p-1022))
(assert_return (invoke "f64x2.pmin" (v128.const f64x2 0123456789.0123456789e-019 0123456789.0123456789e-019)
                                    (v128.const f64x2 0x0.0000000000001p-1022 0x0.0000000000001p-1022))
                                    (v128.const f64x2 0x0.0000000000001p-1022 0x0.0000000000001p-1022))
(assert_return (invoke "f64x2.pmin" (v128.const f64x2 0123456789.0123456789e-019 0123456789.0123456789e-019)
                                    (v128.const f64x2 inf inf))
                                    (v128.const f64x2 0x1.b25ffd636ec12p-37 0x1.b25ffd636ec12p-37))
(assert_return (invoke "f64x2.pmin" (v128.const f64x2 0123456789.0123456789e-019 0123456789.0123456789e-019)
                                    (v128.const f64x2 -inf -inf))
                                    (v128.const f64x2 -inf -inf))
(assert_return (invoke "f64x2.pmin" (v128.const f64x2 0123456789.0123456789e-019 0123456789.0123456789e-019)
                                    (v128.const f64x2 0123456789 0123456789))
                                    (v128.const f64x2 0x1.b25ffd636ec12p-37 0x1.b25ffd636ec12p-37))
(assert_return (invoke "f64x2.pmin" (v128.const f64x2 0123456789.0123456789e-019 0123456789.0123456789e-019)
                                    (v128.const f64x2 0123456789e019 0123456789e019))
                                    (v128.const f64x2 0x1.b25ffd636ec12p-37 0x1.b25ffd636ec12p-37))
(assert_return (invoke "f64x2.pmin" (v128.const f64x2 0123456789.0123456789e-019 0123456789.0123456789e-019)
                                    (v128.const f64x2 0123456789e+019 0123456789e+019))
                                    (v128.const f64x2 0x1.b25ffd636ec12p-37 0x1.b25ffd636ec12p-37))
(assert_return (invoke "f64x2.pmin" (v128.const f64x2 0123456789.0123456789e-019 0123456789.0123456789e-019)
                                    (v128.const f64x2 0123456789e-019 0123456789e-019))
                                    (v128.const f64x2 0x1.b25ffd62b4311p-37 0x1.b25ffd62b4311p-37))
(assert_return (invoke "f64x2.pmin" (v128.const f64x2 0123456789.0123456789e-019 0123456789.0123456789e-019)
                                    (v128.const f64x2 0123456789. 0123456789.))
                                    (v128.const f64x2 0x1.b25ffd636ec12p-37 0x1.b25ffd636ec12p-37))
(assert_return (invoke "f64x2.pmin" (v128.const f64x2 0123456789.0123456789e-019 0123456789.0123456789e-019)
                                    (v128.const f64x2 0123456789.e019 0123456789.e019))
                                    (v128.const f64x2 0x1.b25ffd636ec12p-37 0x1.b25ffd636ec12p-37))
(assert_return (invoke "f64x2.pmin" (v128.const f64x2 0123456789.0123456789e-019 0123456789.0123456789e-019)
                                    (v128.const f64x2 0123456789.e+019 0123456789.e+019))
                                    (v128.const f64x2 0x1.b25ffd636ec12p-37 0x1.b25ffd636ec12p-37))
(assert_return (invoke "f64x2.pmin" (v128.const f64x2 0123456789.0123456789e-019 0123456789.0123456789e-019)
                                    (v128.const f64x2 0123456789.e-019 0123456789.e-019))
                                    (v128.const f64x2 0x1.b25ffd62b4311p-37 0x1.b25ffd62b4311p-37))
(assert_return (invoke "f64x2.pmin" (v128.const f64x2 0123456789.0123456789e-019 0123456789.0123456789e-019)
                                    (v128.const f64x2 0123456789.0123456789 0123456789.0123456789))
                                    (v128.const f64x2 0x1.b25ffd636ec12p-37 0x1.b25ffd636ec12p-37))
(assert_return (invoke "f64x2.pmin" (v128.const f64x2 0123456789.0123456789e-019 0123456789.0123456789e-019)
                                    (v128.const f64x2 0123456789.0123456789e019 0123456789.0123456789e019))
                                    (v128.const f64x2 0x1.b25ffd636ec12p-37 0x1.b25ffd636ec12p-37))
(assert_return (invoke "f64x2.pmin" (v128.const f64x2 0123456789.0123456789e-019 0123456789.0123456789e-019)
                                    (v128.const f64x2 0123456789.0123456789e+019 0123456789.0123456789e+019))
                                    (v128.const f64x2 0x1.b25ffd636ec12p-37 0x1.b25ffd636ec12p-37))
(assert_return (invoke "f64x2.pmin" (v128.const f64x2 0123456789.0123456789e-019 0123456789.0123456789e-019)
                                    (v128.const f64x2 0123456789.0123456789e-019 0123456789.0123456789e-019))
                                    (v128.const f64x2 0x1.b25ffd636ec12p-37 0x1.b25ffd636ec12p-37))
(assert_return (invoke "f64x2.pmin" (v128.const f64x2 0123456789.0123456789e-019 0123456789.0123456789e-019)
                                    (v128.const f64x2 0x0123456789ABCDEFabcdef 0x0123456789ABCDEFabcdef))
                                    (v128.const f64x2 0x1.b25ffd636ec12p-37 0x1.b25ffd636ec12p-37))
(assert_return (invoke "f64x2.pmin" (v128.const f64x2 0123456789.0123456789e-019 0123456789.0123456789e-019)
                                    (v128.const f64x2 0x0123456789ABCDEFabcdefp019 0x0123456789ABCDEFabcdefp019))
                                    (v128.const f64x2 0x1.b25ffd636ec12p-37 0x1.b25ffd636ec12p-37))
(assert_return (invoke "f64x2.pmin" (v128.const f64x2 0123456789.0123456789e-019 0123456789.0123456789e-019)
                                    (v128.const f64x2 0x0123456789ABCDEFabcdefp+019 0x0123456789ABCDEFabcdefp+019))
                                    (v128.const f64x2 0x1.b25ffd636ec12p-37 0x1.b25ffd636ec12p-37))
(assert_return (invoke "f64x2.pmin" (v128.const f64x2 0123456789.0123456789e-019 0123456789.0123456789e-019)
                                    (v128.const f64x2 0x0123456789ABCDEFabcdefp-019 0x0123456789ABCDEFabcdefp-019))
                                    (v128.const f64x2 0x1.b25ffd636ec12p-37 0x1.b25ffd636ec12p-37))
(assert_return (invoke "f64x2.pmin" (v128.const f64x2 0123456789.0123456789e-019 0123456789.0123456789e-019)
                                    (v128.const f64x2 0x0123456789ABCDEFabcdef. 0x0123456789ABCDEFabcdef.))
                                    (v128.const f64x2 0x1.b25ffd636ec12p-37 0x1.b25ffd636ec12p-37))
(assert_return (invoke "f64x2.pmin" (v128.const f64x2 0123456789.0123456789e-019 0123456789.0123456789e-019)
                                    (v128.const f64x2 0x0123456789ABCDEFabcdef.p019 0x0123456789ABCDEFabcdef.p019))
                                    (v128.const f64x2 0x1.b25ffd636ec12p-37 0x1.b25ffd636ec12p-37))
(assert_return (invoke "f64x2.pmin" (v128.const f64x2 0123456789.0123456789e-019 0123456789.0123456789e-019)
                                    (v128.const f64x2 0x0123456789ABCDEFabcdef.p+019 0x0123456789ABCDEFabcdef.p+019))
                                    (v128.const f64x2 0x1.b25ffd636ec12p-37 0x1.b25ffd636ec12p-37))
(assert_return (invoke "f64x2.pmin" (v128.const f64x2 0123456789.0123456789e-019 0123456789.0123456789e-019)
                                    (v128.const f64x2 0x0123456789ABCDEFabcdef.p-019 0x0123456789ABCDEFabcdef.p-019))
                                    (v128.const f64x2 0x1.b25ffd636ec12p-37 0x1.b25ffd636ec12p-37))
(assert_return (invoke "f64x2.pmin" (v128.const f64x2 0123456789.0123456789e-019 0123456789.0123456789e-019)
                                    (v128.const f64x2 0x0123456789ABCDEFabcdef.0123456789ABCDEFabcdef 0x0123456789ABCDEFabcdef.0123456789ABCDEFabcdef))
                                    (v128.const f64x2 0x1.b25ffd636ec12p-37 0x1.b25ffd636ec12p-37))
(assert_return (invoke "f64x2.pmin" (v128.const f64x2 0123456789.0123456789e-019 0123456789.0123456789e-019)
                                    (v128.const f64x2 0x0123456789ABCDEFabcdef.0123456789ABCDEFabcdefp019 0x0123456789ABCDEFabcdef.0123456789ABCDEFabcdefp019))
                                    (v128.const f64x2 0x1.b25ffd636ec12p-37 0x1.b25ffd636ec12p-37))
(assert_return (invoke "f64x2.pmin" (v128.const f64x2 0123456789.0123456789e-019 0123456789.0123456789e-019)
                                    (v128.const f64x2 0x0123456789ABCDEFabcdef.0123456789ABCDEFabcdefp+019 0x0123456789ABCDEFabcdef.0123456789ABCDEFabcdefp+019))
                                    (v128.const f64x2 0x1.b25ffd636ec12p-37 0x1.b25ffd636ec12p-37))
(assert_return (invoke "f64x2.pmin" (v128.const f64x2 0123456789.0123456789e-019 0123456789.0123456789e-019)
                                    (v128.const f64x2 0x0123456789ABCDEFabcdef.0123456789ABCDEFabcdefp-019 0x0123456789ABCDEFabcdef.0123456789ABCDEFabcdefp-019))
                                    (v128.const f64x2 0x1.b25ffd636ec12p-37 0x1.b25ffd636ec12p-37))
(assert_return (invoke "f64x2.pmin" (v128.const f64x2 0x0123456789ABCDEFabcdef 0x0123456789ABCDEFabcdef)
                                    (v128.const f64x2 0x0p+0 0x0p+0))
                                    (v128.const f64x2 0x0.0p+0 0x0.0p+0))
(assert_return (invoke "f64x2.pmin" (v128.const f64x2 0x0123456789ABCDEFabcdef 0x0123456789ABCDEFabcdef)
                                    (v128.const f64x2 -0x0p+0 -0x0p+0))
                                    (v128.const f64x2 -0x0.0p+0 -0x0.0p+0))
(assert_return (invoke "f64x2.pmin" (v128.const f64x2 0x0123456789ABCDEFabcdef 0x0123456789ABCDEFabcdef)
                                    (v128.const f64x2 0x1p-1022 0x1p-1022))
                                    (v128.const f64x2 0x1.0000000000000p-1022 0x1.0000000000000p-1022))
(assert_return (invoke "f64x2.pmin" (v128.const f64x2 0x0123456789ABCDEFabcdef 0x0123456789ABCDEFabcdef)
                                    (v128.const f64x2 -0x1p-1022 -0x1p-1022))
                                    (v128.const f64x2 -0x1.0000000000000p-1022 -0x1.0000000000000p-1022))
(assert_return (invoke "f64x2.pmin" (v128.const f64x2 0x0123456789ABCDEFabcdef 0x0123456789ABCDEFabcdef)
                                    (v128.const f64x2 0x1p-1 0x1p-1))
                                    (v128.const f64x2 0x1.0000000000000p-1 0x1.0000000000000p-1))
(assert_return (invoke "f64x2.pmin" (v128.const f64x2 0x0123456789ABCDEFabcdef 0x0123456789ABCDEFabcdef)
                                    (v128.const f64x2 -0x1p-1 -0x1p-1))
                                    (v128.const f64x2 -0x1.0000000000000p-1 -0x1.0000000000000p-1))
(assert_return (invoke "f64x2.pmin" (v128.const f64x2 0x0123456789ABCDEFabcdef 0x0123456789ABCDEFabcdef)
                                    (v128.const f64x2 0x1p+0 0x1p+0))
                                    (v128.const f64x2 0x1.0000000000000p+0 0x1.0000000000000p+0))
(assert_return (invoke "f64x2.pmin" (v128.const f64x2 0x0123456789ABCDEFabcdef 0x0123456789ABCDEFabcdef)
                                    (v128.const f64x2 -0x1p+0 -0x1p+0))
                                    (v128.const f64x2 -0x1.0000000000000p+0 -0x1.0000000000000p+0))
(assert_return (invoke "f64x2.pmin" (v128.const f64x2 0x0123456789ABCDEFabcdef 0x0123456789ABCDEFabcdef)
                                    (v128.const f64x2 0x1.921fb54442d18p+2 0x1.921fb54442d18p+2))
                                    (v128.const f64x2 0x1.921fb54442d18p+2 0x1.921fb54442d18p+2))
(assert_return (invoke "f64x2.pmin" (v128.const f64x2 0x0123456789ABCDEFabcdef 0x0123456789ABCDEFabcdef)
                                    (v128.const f64x2 -0x1.921fb54442d18p+2 -0x1.921fb54442d18p+2))
                                    (v128.const f64x2 -0x1.921fb54442d18p+2 -0x1.921fb54442d18p+2))
(assert_return (invoke "f64x2.pmin" (v128.const f64x2 0x0123456789ABCDEFabcdef 0x0123456789ABCDEFabcdef)
                                    (v128.const f64x2 0x1.fffffffffffffp+1023 0x1.fffffffffffffp+1023))
                                    (v128.const f64x2 0x1.23456789abcdfp+80 0x1.23456789abcdfp+80))
(assert_return (invoke "f64x2.pmin" (v128.const f64x2 0x0123456789ABCDEFabcdef 0x0123456789ABCDEFabcdef)
                                    (v128.const f64x2 -0x1.fffffffffffffp+1023 -0x1.fffffffffffffp+1023))
                                    (v128.const f64x2 -0x1.fffffffffffffp+1023 -0x1.fffffffffffffp+1023))
(assert_return (invoke "f64x2.pmin" (v128.const f64x2 0x0123456789ABCDEFabcdef 0x0123456789ABCDEFabcdef)
                                    (v128.const f64x2 0x0.0000000000001p-1022 0x0.0000000000001p-1022))
                                    (v128.const f64x2 0x0.0000000000001p-1022 0x0.0000000000001p-1022))
(assert_return (invoke "f64x2.pmin" (v128.const f64x2 0x0123456789ABCDEFabcdef 0x0123456789ABCDEFabcdef)
                                    (v128.const f64x2 0x0.0000000000001p-1022 0x0.0000000000001p-1022))
                                    (v128.const f64x2 0x0.0000000000001p-1022 0x0.0000000000001p-1022))
(assert_return (invoke "f64x2.pmin" (v128.const f64x2 0x0123456789ABCDEFabcdef 0x0123456789ABCDEFabcdef)
                                    (v128.const f64x2 inf inf))
                                    (v128.const f64x2 0x1.23456789abcdfp+80 0x1.23456789abcdfp+80))
(assert_return (invoke "f64x2.pmin" (v128.const f64x2 0x0123456789ABCDEFabcdef 0x0123456789ABCDEFabcdef)
                                    (v128.const f64x2 -inf -inf))
                                    (v128.const f64x2 -inf -inf))
(assert_return (invoke "f64x2.pmin" (v128.const f64x2 0x0123456789ABCDEFabcdef 0x0123456789ABCDEFabcdef)
                                    (v128.const f64x2 0123456789 0123456789))
                                    (v128.const f64x2 0x1.d6f3454000000p+26 0x1.d6f3454000000p+26))
(assert_return (invoke "f64x2.pmin" (v128.const f64x2 0x0123456789ABCDEFabcdef 0x0123456789ABCDEFabcdef)
                                    (v128.const f64x2 0123456789e019 0123456789e019))
                                    (v128.const f64x2 0x1.23456789abcdfp+80 0x1.23456789abcdfp+80))
(assert_return (invoke "f64x2.pmin" (v128.const f64x2 0x0123456789ABCDEFabcdef 0x0123456789ABCDEFabcdef)
                                    (v128.const f64x2 0123456789e+019 0123456789e+019))
                                    (v128.const f64x2 0x1.23456789abcdfp+80 0x1.23456789abcdfp+80))
(assert_return (invoke "f64x2.pmin" (v128.const f64x2 0x0123456789ABCDEFabcdef 0x0123456789ABCDEFabcdef)
                                    (v128.const f64x2 0123456789e-019 0123456789e-019))
                                    (v128.const f64x2 0x1.b25ffd62b4311p-37 0x1.b25ffd62b4311p-37))
(assert_return (invoke "f64x2.pmin" (v128.const f64x2 0x0123456789ABCDEFabcdef 0x0123456789ABCDEFabcdef)
                                    (v128.const f64x2 0123456789. 0123456789.))
                                    (v128.const f64x2 0x1.d6f3454000000p+26 0x1.d6f3454000000p+26))
(assert_return (invoke "f64x2.pmin" (v128.const f64x2 0x0123456789ABCDEFabcdef 0x0123456789ABCDEFabcdef)
                                    (v128.const f64x2 0123456789.e019 0123456789.e019))
                                    (v128.const f64x2 0x1.23456789abcdfp+80 0x1.23456789abcdfp+80))
(assert_return (invoke "f64x2.pmin" (v128.const f64x2 0x0123456789ABCDEFabcdef 0x0123456789ABCDEFabcdef)
                                    (v128.const f64x2 0123456789.e+019 0123456789.e+019))
                                    (v128.const f64x2 0x1.23456789abcdfp+80 0x1.23456789abcdfp+80))
(assert_return (invoke "f64x2.pmin" (v128.const f64x2 0x0123456789ABCDEFabcdef 0x0123456789ABCDEFabcdef)
                                    (v128.const f64x2 0123456789.e-019 0123456789.e-019))
                                    (v128.const f64x2 0x1.b25ffd62b4311p-37 0x1.b25ffd62b4311p-37))
(assert_return (invoke "f64x2.pmin" (v128.const f64x2 0x0123456789ABCDEFabcdef 0x0123456789ABCDEFabcdef)
                                    (v128.const f64x2 0123456789.0123456789 0123456789.0123456789))
                                    (v128.const f64x2 0x1.d6f34540ca458p+26 0x1.d6f34540ca458p+26))
(assert_return (invoke "f64x2.pmin" (v128.const f64x2 0x0123456789ABCDEFabcdef 0x0123456789ABCDEFabcdef)
                                    (v128.const f64x2 0123456789.0123456789e019 0123456789.0123456789e019))
                                    (v128.const f64x2 0x1.23456789abcdfp+80 0x1.23456789abcdfp+80))
(assert_return (invoke "f64x2.pmin" (v128.const f64x2 0x0123456789ABCDEFabcdef 0x0123456789ABCDEFabcdef)
                                    (v128.const f64x2 0123456789.0123456789e+019 0123456789.0123456789e+019))
                                    (v128.const f64x2 0x1.23456789abcdfp+80 0x1.23456789abcdfp+80))
(assert_return (invoke "f64x2.pmin" (v128.const f64x2 0x0123456789ABCDEFabcdef 0x0123456789ABCDEFabcdef)
                                    (v128.const f64x2 0123456789.0123456789e-019 0123456789.0123456789e-019))
                                    (v128.const f64x2 0x1.b25ffd636ec12p-37 0x1.b25ffd636ec12p-37))
(assert_return (invoke "f64x2.pmin" (v128.const f64x2 0x0123456789ABCDEFabcdef 0x0123456789ABCDEFabcdef)
                                    (v128.const f64x2 0x0123456789ABCDEFabcdef 0x0123456789ABCDEFabcdef))
                                    (v128.const f64x2 0x1.23456789abcdfp+80 0x1.23456789abcdfp+80))
(assert_return (invoke "f64x2.pmin" (v128.const f64x2 0x0123456789ABCDEFabcdef 0x0123456789ABCDEFabcdef)
                                    (v128.const f64x2 0x0123456789ABCDEFabcdefp019 0x0123456789ABCDEFabcdefp019))
                                    (v128.const f64x2 0x1.23456789abcdfp+80 0x1.23456789abcdfp+80))
(assert_return (invoke "f64x2.pmin" (v128.const f64x2 0x0123456789ABCDEFabcdef 0x0123456789ABCDEFabcdef)
                                    (v128.const f64x2 0x0123456789ABCDEFabcdefp+019 0x0123456789ABCDEFabcdefp+019))
                                    (v128.const f64x2 0x1.23456789abcdfp+80 0x1.23456789abcdfp+80))
(assert_return (invoke "f64x2.pmin" (v128.const f64x2 0x0123456789ABCDEFabcdef 0x0123456789ABCDEFabcdef)
                                    (v128.const f64x2 0x0123456789ABCDEFabcdefp-019 0x0123456789ABCDEFabcdefp-019))
                                    (v128.const f64x2 0x1.23456789abcdfp+61 0x1.23456789abcdfp+61))
(assert_return (invoke "f64x2.pmin" (v128.const f64x2 0x0123456789ABCDEFabcdef 0x0123456789ABCDEFabcdef)
                                    (v128.const f64x2 0x0123456789ABCDEFabcdef. 0x0123456789ABCDEFabcdef.))
                                    (v128.const f64x2 0x1.23456789abcdfp+80 0x1.23456789abcdfp+80))
(assert_return (invoke "f64x2.pmin" (v128.const f64x2 0x0123456789ABCDEFabcdef 0x0123456789ABCDEFabcdef)
                                    (v128.const f64x2 0x0123456789ABCDEFabcdef.p019 0x0123456789ABCDEFabcdef.p019))
                                    (v128.const f64x2 0x1.23456789abcdfp+80 0x1.23456789abcdfp+80))
(assert_return (invoke "f64x2.pmin" (v128.const f64x2 0x0123456789ABCDEFabcdef 0x0123456789ABCDEFabcdef)
                                    (v128.const f64x2 0x0123456789ABCDEFabcdef.p+019 0x0123456789ABCDEFabcdef.p+019))
                                    (v128.const f64x2 0x1.23456789abcdfp+80 0x1.23456789abcdfp+80))
(assert_return (invoke "f64x2.pmin" (v128.const f64x2 0x0123456789ABCDEFabcdef 0x0123456789ABCDEFabcdef)
                                    (v128.const f64x2 0x0123456789ABCDEFabcdef.p-019 0x0123456789ABCDEFabcdef.p-019))
                                    (v128.const f64x2 0x1.23456789abcdfp+61 0x1.23456789abcdfp+61))
(assert_return (invoke "f64x2.pmin" (v128.const f64x2 0x0123456789ABCDEFabcdef 0x0123456789ABCDEFabcdef)
                                    (v128.const f64x2 0x0123456789ABCDEFabcdef.0123456789ABCDEFabcdef 0x0123456789ABCDEFabcdef.0123456789ABCDEFabcdef))
                                    (v128.const f64x2 0x1.23456789abcdfp+80 0x1.23456789abcdfp+80))
(assert_return (invoke "f64x2.pmin" (v128.const f64x2 0x0123456789ABCDEFabcdef 0x0123456789ABCDEFabcdef)
                                    (v128.const f64x2 0x0123456789ABCDEFabcdef.0123456789ABCDEFabcdefp019 0x0123456789ABCDEFabcdef.0123456789ABCDEFabcdefp019))
                                    (v128.const f64x2 0x1.23456789abcdfp+80 0x1.23456789abcdfp+80))
(assert_return (invoke "f64x2.pmin" (v128.const f64x2 0x0123456789ABCDEFabcdef 0x0123456789ABCDEFabcdef)
                                    (v128.const f64x2 0x0123456789ABCDEFabcdef.0123456789ABCDEFabcdefp+019 0x0123456789ABCDEFabcdef.0123456789ABCDEFabcdefp+019))
                                    (v128.const f64x2 0x1.23456789abcdfp+80 0x1.23456789abcdfp+80))
(assert_return (invoke "f64x2.pmin" (v128.const f64x2 0x0123456789ABCDEFabcdef 0x0123456789ABCDEFabcdef)
                                    (v128.const f64x2 0x0123456789ABCDEFabcdef.0123456789ABCDEFabcdefp-019 0x0123456789ABCDEFabcdef.0123456789ABCDEFabcdefp-019))
                                    (v128.const f64x2 0x1.23456789abcdfp+61 0x1.23456789abcdfp+61))
(assert_return (invoke "f64x2.pmin" (v128.const f64x2 0x0123456789ABCDEFabcdefp019 0x0123456789ABCDEFabcdefp019)
                                    (v128.const f64x2 0x0p+0 0x0p+0))
                                    (v128.const f64x2 0x0.0p+0 0x0.0p+0))
(assert_return (invoke "f64x2.pmin" (v128.const f64x2 0x0123456789ABCDEFabcdefp019 0x0123456789ABCDEFabcdefp019)
                                    (v128.const f64x2 -0x0p+0 -0x0p+0))
                                    (v128.const f64x2 -0x0.0p+0 -0x0.0p+0))
(assert_return (invoke "f64x2.pmin" (v128.const f64x2 0x0123456789ABCDEFabcdefp019 0x0123456789ABCDEFabcdefp019)
                                    (v128.const f64x2 0x1p-1022 0x1p-1022))
                                    (v128.const f64x2 0x1.0000000000000p-1022 0x1.0000000000000p-1022))
(assert_return (invoke "f64x2.pmin" (v128.const f64x2 0x0123456789ABCDEFabcdefp019 0x0123456789ABCDEFabcdefp019)
                                    (v128.const f64x2 -0x1p-1022 -0x1p-1022))
                                    (v128.const f64x2 -0x1.0000000000000p-1022 -0x1.0000000000000p-1022))
(assert_return (invoke "f64x2.pmin" (v128.const f64x2 0x0123456789ABCDEFabcdefp019 0x0123456789ABCDEFabcdefp019)
                                    (v128.const f64x2 0x1p-1 0x1p-1))
                                    (v128.const f64x2 0x1.0000000000000p-1 0x1.0000000000000p-1))
(assert_return (invoke "f64x2.pmin" (v128.const f64x2 0x0123456789ABCDEFabcdefp019 0x0123456789ABCDEFabcdefp019)
                                    (v128.const f64x2 -0x1p-1 -0x1p-1))
                                    (v128.const f64x2 -0x1.0000000000000p-1 -0x1.0000000000000p-1))
(assert_return (invoke "f64x2.pmin" (v128.const f64x2 0x0123456789ABCDEFabcdefp019 0x0123456789ABCDEFabcdefp019)
                                    (v128.const f64x2 0x1p+0 0x1p+0))
                                    (v128.const f64x2 0x1.0000000000000p+0 0x1.0000000000000p+0))
(assert_return (invoke "f64x2.pmin" (v128.const f64x2 0x0123456789ABCDEFabcdefp019 0x0123456789ABCDEFabcdefp019)
                                    (v128.const f64x2 -0x1p+0 -0x1p+0))
                                    (v128.const f64x2 -0x1.0000000000000p+0 -0x1.0000000000000p+0))
(assert_return (invoke "f64x2.pmin" (v128.const f64x2 0x0123456789ABCDEFabcdefp019 0x0123456789ABCDEFabcdefp019)
                                    (v128.const f64x2 0x1.921fb54442d18p+2 0x1.921fb54442d18p+2))
                                    (v128.const f64x2 0x1.921fb54442d18p+2 0x1.921fb54442d18p+2))
(assert_return (invoke "f64x2.pmin" (v128.const f64x2 0x0123456789ABCDEFabcdefp019 0x0123456789ABCDEFabcdefp019)
                                    (v128.const f64x2 -0x1.921fb54442d18p+2 -0x1.921fb54442d18p+2))
                                    (v128.const f64x2 -0x1.921fb54442d18p+2 -0x1.921fb54442d18p+2))
(assert_return (invoke "f64x2.pmin" (v128.const f64x2 0x0123456789ABCDEFabcdefp019 0x0123456789ABCDEFabcdefp019)
                                    (v128.const f64x2 0x1.fffffffffffffp+1023 0x1.fffffffffffffp+1023))
                                    (v128.const f64x2 0x1.23456789abcdfp+99 0x1.23456789abcdfp+99))
(assert_return (invoke "f64x2.pmin" (v128.const f64x2 0x0123456789ABCDEFabcdefp019 0x0123456789ABCDEFabcdefp019)
                                    (v128.const f64x2 -0x1.fffffffffffffp+1023 -0x1.fffffffffffffp+1023))
                                    (v128.const f64x2 -0x1.fffffffffffffp+1023 -0x1.fffffffffffffp+1023))
(assert_return (invoke "f64x2.pmin" (v128.const f64x2 0x0123456789ABCDEFabcdefp019 0x0123456789ABCDEFabcdefp019)
                                    (v128.const f64x2 0x0.0000000000001p-1022 0x0.0000000000001p-1022))
                                    (v128.const f64x2 0x0.0000000000001p-1022 0x0.0000000000001p-1022))
(assert_return (invoke "f64x2.pmin" (v128.const f64x2 0x0123456789ABCDEFabcdefp019 0x0123456789ABCDEFabcdefp019)
                                    (v128.const f64x2 0x0.0000000000001p-1022 0x0.0000000000001p-1022))
                                    (v128.const f64x2 0x0.0000000000001p-1022 0x0.0000000000001p-1022))
(assert_return (invoke "f64x2.pmin" (v128.const f64x2 0x0123456789ABCDEFabcdefp019 0x0123456789ABCDEFabcdefp019)
                                    (v128.const f64x2 inf inf))
                                    (v128.const f64x2 0x1.23456789abcdfp+99 0x1.23456789abcdfp+99))
(assert_return (invoke "f64x2.pmin" (v128.const f64x2 0x0123456789ABCDEFabcdefp019 0x0123456789ABCDEFabcdefp019)
                                    (v128.const f64x2 -inf -inf))
                                    (v128.const f64x2 -inf -inf))
(assert_return (invoke "f64x2.pmin" (v128.const f64x2 0x0123456789ABCDEFabcdefp019 0x0123456789ABCDEFabcdefp019)
                                    (v128.const f64x2 0123456789 0123456789))
                                    (v128.const f64x2 0x1.d6f3454000000p+26 0x1.d6f3454000000p+26))
(assert_return (invoke "f64x2.pmin" (v128.const f64x2 0x0123456789ABCDEFabcdefp019 0x0123456789ABCDEFabcdefp019)
                                    (v128.const f64x2 0123456789e019 0123456789e019))
                                    (v128.const f64x2 0x1.fe9af5b5e16fap+89 0x1.fe9af5b5e16fap+89))
(assert_return (invoke "f64x2.pmin" (v128.const f64x2 0x0123456789ABCDEFabcdefp019 0x0123456789ABCDEFabcdefp019)
                                    (v128.const f64x2 0123456789e+019 0123456789e+019))
                                    (v128.const f64x2 0x1.fe9af5b5e16fap+89 0x1.fe9af5b5e16fap+89))
(assert_return (invoke "f64x2.pmin" (v128.const f64x2 0x0123456789ABCDEFabcdefp019 0x0123456789ABCDEFabcdefp019)
                                    (v128.const f64x2 0123456789e-019 0123456789e-019))
                                    (v128.const f64x2 0x1.b25ffd62b4311p-37 0x1.b25ffd62b4311p-37))
(assert_return (invoke "f64x2.pmin" (v128.const f64x2 0x0123456789ABCDEFabcdefp019 0x0123456789ABCDEFabcdefp019)
                                    (v128.const f64x2 0123456789. 0123456789.))
                                    (v128.const f64x2 0x1.d6f3454000000p+26 0x1.d6f3454000000p+26))
(assert_return (invoke "f64x2.pmin" (v128.const f64x2 0x0123456789ABCDEFabcdefp019 0x0123456789ABCDEFabcdefp019)
                                    (v128.const f64x2 0123456789.e019 0123456789.e019))
                                    (v128.const f64x2 0x1.fe9af5b5e16fap+89 0x1.fe9af5b5e16fap+89))
(assert_return (invoke "f64x2.pmin" (v128.const f64x2 0x0123456789ABCDEFabcdefp019 0x0123456789ABCDEFabcdefp019)
                                    (v128.const f64x2 0123456789.e+019 0123456789.e+019))
                                    (v128.const f64x2 0x1.fe9af5b5e16fap+89 0x1.fe9af5b5e16fap+89))
(assert_return (invoke "f64x2.pmin" (v128.const f64x2 0x0123456789ABCDEFabcdefp019 0x0123456789ABCDEFabcdefp019)
                                    (v128.const f64x2 0123456789.e-019 0123456789.e-019))
                                    (v128.const f64x2 0x1.b25ffd62b4311p-37 0x1.b25ffd62b4311p-37))
(assert_return (invoke "f64x2.pmin" (v128.const f64x2 0x0123456789ABCDEFabcdefp019 0x0123456789ABCDEFabcdefp019)
                                    (v128.const f64x2 0123456789.0123456789 0123456789.0123456789))
                                    (v128.const f64x2 0x1.d6f34540ca458p+26 0x1.d6f34540ca458p+26))
(assert_return (invoke "f64x2.pmin" (v128.const f64x2 0x0123456789ABCDEFabcdefp019 0x0123456789ABCDEFabcdefp019)
                                    (v128.const f64x2 0123456789.0123456789e019 0123456789.0123456789e019))
                                    (v128.const f64x2 0x1.fe9af5b6bcbd5p+89 0x1.fe9af5b6bcbd5p+89))
(assert_return (invoke "f64x2.pmin" (v128.const f64x2 0x0123456789ABCDEFabcdefp019 0x0123456789ABCDEFabcdefp019)
                                    (v128.const f64x2 0123456789.0123456789e+019 0123456789.0123456789e+019))
                                    (v128.const f64x2 0x1.fe9af5b6bcbd5p+89 0x1.fe9af5b6bcbd5p+89))
(assert_return (invoke "f64x2.pmin" (v128.const f64x2 0x0123456789ABCDEFabcdefp019 0x0123456789ABCDEFabcdefp019)
                                    (v128.const f64x2 0123456789.0123456789e-019 0123456789.0123456789e-019))
                                    (v128.const f64x2 0x1.b25ffd636ec12p-37 0x1.b25ffd636ec12p-37))
(assert_return (invoke "f64x2.pmin" (v128.const f64x2 0x0123456789ABCDEFabcdefp019 0x0123456789ABCDEFabcdefp019)
                                    (v128.const f64x2 0x0123456789ABCDEFabcdef 0x0123456789ABCDEFabcdef))
                                    (v128.const f64x2 0x1.23456789abcdfp+80 0x1.23456789abcdfp+80))
(assert_return (invoke "f64x2.pmin" (v128.const f64x2 0x0123456789ABCDEFabcdefp019 0x0123456789ABCDEFabcdefp019)
                                    (v128.const f64x2 0x0123456789ABCDEFabcdefp019 0x0123456789ABCDEFabcdefp019))
                                    (v128.const f64x2 0x1.23456789abcdfp+99 0x1.23456789abcdfp+99))
(assert_return (invoke "f64x2.pmin" (v128.const f64x2 0x0123456789ABCDEFabcdefp019 0x0123456789ABCDEFabcdefp019)
                                    (v128.const f64x2 0x0123456789ABCDEFabcdefp+019 0x0123456789ABCDEFabcdefp+019))
                                    (v128.const f64x2 0x1.23456789abcdfp+99 0x1.23456789abcdfp+99))
(assert_return (invoke "f64x2.pmin" (v128.const f64x2 0x0123456789ABCDEFabcdefp019 0x0123456789ABCDEFabcdefp019)
                                    (v128.const f64x2 0x0123456789ABCDEFabcdefp-019 0x0123456789ABCDEFabcdefp-019))
                                    (v128.const f64x2 0x1.23456789abcdfp+61 0x1.23456789abcdfp+61))
(assert_return (invoke "f64x2.pmin" (v128.const f64x2 0x0123456789ABCDEFabcdefp019 0x0123456789ABCDEFabcdefp019)
                                    (v128.const f64x2 0x0123456789ABCDEFabcdef. 0x0123456789ABCDEFabcdef.))
                                    (v128.const f64x2 0x1.23456789abcdfp+80 0x1.23456789abcdfp+80))
(assert_return (invoke "f64x2.pmin" (v128.const f64x2 0x0123456789ABCDEFabcdefp019 0x0123456789ABCDEFabcdefp019)
                                    (v128.const f64x2 0x0123456789ABCDEFabcdef.p019 0x0123456789ABCDEFabcdef.p019))
                                    (v128.const f64x2 0x1.23456789abcdfp+99 0x1.23456789abcdfp+99))
(assert_return (invoke "f64x2.pmin" (v128.const f64x2 0x0123456789ABCDEFabcdefp019 0x0123456789ABCDEFabcdefp019)
                                    (v128.const f64x2 0x0123456789ABCDEFabcdef.p+019 0x0123456789ABCDEFabcdef.p+019))
                                    (v128.const f64x2 0x1.23456789abcdfp+99 0x1.23456789abcdfp+99))
(assert_return (invoke "f64x2.pmin" (v128.const f64x2 0x0123456789ABCDEFabcdefp019 0x0123456789ABCDEFabcdefp019)
                                    (v128.const f64x2 0x0123456789ABCDEFabcdef.p-019 0x0123456789ABCDEFabcdef.p-019))
                                    (v128.const f64x2 0x1.23456789abcdfp+61 0x1.23456789abcdfp+61))
(assert_return (invoke "f64x2.pmin" (v128.const f64x2 0x0123456789ABCDEFabcdefp019 0x0123456789ABCDEFabcdefp019)
                                    (v128.const f64x2 0x0123456789ABCDEFabcdef.0123456789ABCDEFabcdef 0x0123456789ABCDEFabcdef.0123456789ABCDEFabcdef))
                                    (v128.const f64x2 0x1.23456789abcdfp+80 0x1.23456789abcdfp+80))
(assert_return (invoke "f64x2.pmin" (v128.const f64x2 0x0123456789ABCDEFabcdefp019 0x0123456789ABCDEFabcdefp019)
                                    (v128.const f64x2 0x0123456789ABCDEFabcdef.0123456789ABCDEFabcdefp019 0x0123456789ABCDEFabcdef.0123456789ABCDEFabcdefp019))
                                    (v128.const f64x2 0x1.23456789abcdfp+99 0x1.23456789abcdfp+99))
(assert_return (invoke "f64x2.pmin" (v128.const f64x2 0x0123456789ABCDEFabcdefp019 0x0123456789ABCDEFabcdefp019)
                                    (v128.const f64x2 0x0123456789ABCDEFabcdef.0123456789ABCDEFabcdefp+019 0x0123456789ABCDEFabcdef.0123456789ABCDEFabcdefp+019))
                                    (v128.const f64x2 0x1.23456789abcdfp+99 0x1.23456789abcdfp+99))
(assert_return (invoke "f64x2.pmin" (v128.const f64x2 0x0123456789ABCDEFabcdefp019 0x0123456789ABCDEFabcdefp019)
                                    (v128.const f64x2 0x0123456789ABCDEFabcdef.0123456789ABCDEFabcdefp-019 0x0123456789ABCDEFabcdef.0123456789ABCDEFabcdefp-019))
                                    (v128.const f64x2 0x1.23456789abcdfp+61 0x1.23456789abcdfp+61))
(assert_return (invoke "f64x2.pmin" (v128.const f64x2 0x0123456789ABCDEFabcdefp+019 0x0123456789ABCDEFabcdefp+019)
                                    (v128.const f64x2 0x0p+0 0x0p+0))
                                    (v128.const f64x2 0x0.0p+0 0x0.0p+0))
(assert_return (invoke "f64x2.pmin" (v128.const f64x2 0x0123456789ABCDEFabcdefp+019 0x0123456789ABCDEFabcdefp+019)
                                    (v128.const f64x2 -0x0p+0 -0x0p+0))
                                    (v128.const f64x2 -0x0.0p+0 -0x0.0p+0))
(assert_return (invoke "f64x2.pmin" (v128.const f64x2 0x0123456789ABCDEFabcdefp+019 0x0123456789ABCDEFabcdefp+019)
                                    (v128.const f64x2 0x1p-1022 0x1p-1022))
                                    (v128.const f64x2 0x1.0000000000000p-1022 0x1.0000000000000p-1022))
(assert_return (invoke "f64x2.pmin" (v128.const f64x2 0x0123456789ABCDEFabcdefp+019 0x0123456789ABCDEFabcdefp+019)
                                    (v128.const f64x2 -0x1p-1022 -0x1p-1022))
                                    (v128.const f64x2 -0x1.0000000000000p-1022 -0x1.0000000000000p-1022))
(assert_return (invoke "f64x2.pmin" (v128.const f64x2 0x0123456789ABCDEFabcdefp+019 0x0123456789ABCDEFabcdefp+019)
                                    (v128.const f64x2 0x1p-1 0x1p-1))
                                    (v128.const f64x2 0x1.0000000000000p-1 0x1.0000000000000p-1))
(assert_return (invoke "f64x2.pmin" (v128.const f64x2 0x0123456789ABCDEFabcdefp+019 0x0123456789ABCDEFabcdefp+019)
                                    (v128.const f64x2 -0x1p-1 -0x1p-1))
                                    (v128.const f64x2 -0x1.0000000000000p-1 -0x1.0000000000000p-1))
(assert_return (invoke "f64x2.pmin" (v128.const f64x2 0x0123456789ABCDEFabcdefp+019 0x0123456789ABCDEFabcdefp+019)
                                    (v128.const f64x2 0x1p+0 0x1p+0))
                                    (v128.const f64x2 0x1.0000000000000p+0 0x1.0000000000000p+0))
(assert_return (invoke "f64x2.pmin" (v128.const f64x2 0x0123456789ABCDEFabcdefp+019 0x0123456789ABCDEFabcdefp+019)
                                    (v128.const f64x2 -0x1p+0 -0x1p+0))
                                    (v128.const f64x2 -0x1.0000000000000p+0 -0x1.0000000000000p+0))
(assert_return (invoke "f64x2.pmin" (v128.const f64x2 0x0123456789ABCDEFabcdefp+019 0x0123456789ABCDEFabcdefp+019)
                                    (v128.const f64x2 0x1.921fb54442d18p+2 0x1.921fb54442d18p+2))
                                    (v128.const f64x2 0x1.921fb54442d18p+2 0x1.921fb54442d18p+2))
(assert_return (invoke "f64x2.pmin" (v128.const f64x2 0x0123456789ABCDEFabcdefp+019 0x0123456789ABCDEFabcdefp+019)
                                    (v128.const f64x2 -0x1.921fb54442d18p+2 -0x1.921fb54442d18p+2))
                                    (v128.const f64x2 -0x1.921fb54442d18p+2 -0x1.921fb54442d18p+2))
(assert_return (invoke "f64x2.pmin" (v128.const f64x2 0x0123456789ABCDEFabcdefp+019 0x0123456789ABCDEFabcdefp+019)
                                    (v128.const f64x2 0x1.fffffffffffffp+1023 0x1.fffffffffffffp+1023))
                                    (v128.const f64x2 0x1.23456789abcdfp+99 0x1.23456789abcdfp+99))
(assert_return (invoke "f64x2.pmin" (v128.const f64x2 0x0123456789ABCDEFabcdefp+019 0x0123456789ABCDEFabcdefp+019)
                                    (v128.const f64x2 -0x1.fffffffffffffp+1023 -0x1.fffffffffffffp+1023))
                                    (v128.const f64x2 -0x1.fffffffffffffp+1023 -0x1.fffffffffffffp+1023))
(assert_return (invoke "f64x2.pmin" (v128.const f64x2 0x0123456789ABCDEFabcdefp+019 0x0123456789ABCDEFabcdefp+019)
                                    (v128.const f64x2 0x0.0000000000001p-1022 0x0.0000000000001p-1022))
                                    (v128.const f64x2 0x0.0000000000001p-1022 0x0.0000000000001p-1022))
(assert_return (invoke "f64x2.pmin" (v128.const f64x2 0x0123456789ABCDEFabcdefp+019 0x0123456789ABCDEFabcdefp+019)
                                    (v128.const f64x2 0x0.0000000000001p-1022 0x0.0000000000001p-1022))
                                    (v128.const f64x2 0x0.0000000000001p-1022 0x0.0000000000001p-1022))
(assert_return (invoke "f64x2.pmin" (v128.const f64x2 0x0123456789ABCDEFabcdefp+019 0x0123456789ABCDEFabcdefp+019)
                                    (v128.const f64x2 inf inf))
                                    (v128.const f64x2 0x1.23456789abcdfp+99 0x1.23456789abcdfp+99))
(assert_return (invoke "f64x2.pmin" (v128.const f64x2 0x0123456789ABCDEFabcdefp+019 0x0123456789ABCDEFabcdefp+019)
                                    (v128.const f64x2 -inf -inf))
                                    (v128.const f64x2 -inf -inf))
(assert_return (invoke "f64x2.pmin" (v128.const f64x2 0x0123456789ABCDEFabcdefp+019 0x0123456789ABCDEFabcdefp+019)
                                    (v128.const f64x2 0123456789 0123456789))
                                    (v128.const f64x2 0x1.d6f3454000000p+26 0x1.d6f3454000000p+26))
(assert_return (invoke "f64x2.pmin" (v128.const f64x2 0x0123456789ABCDEFabcdefp+019 0x0123456789ABCDEFabcdefp+019)
                                    (v128.const f64x2 0123456789e019 0123456789e019))
                                    (v128.const f64x2 0x1.fe9af5b5e16fap+89 0x1.fe9af5b5e16fap+89))
(assert_return (invoke "f64x2.pmin" (v128.const f64x2 0x0123456789ABCDEFabcdefp+019 0x0123456789ABCDEFabcdefp+019)
                                    (v128.const f64x2 0123456789e+019 0123456789e+019))
                                    (v128.const f64x2 0x1.fe9af5b5e16fap+89 0x1.fe9af5b5e16fap+89))
(assert_return (invoke "f64x2.pmin" (v128.const f64x2 0x0123456789ABCDEFabcdefp+019 0x0123456789ABCDEFabcdefp+019)
                                    (v128.const f64x2 0123456789e-019 0123456789e-019))
                                    (v128.const f64x2 0x1.b25ffd62b4311p-37 0x1.b25ffd62b4311p-37))
(assert_return (invoke "f64x2.pmin" (v128.const f64x2 0x0123456789ABCDEFabcdefp+019 0x0123456789ABCDEFabcdefp+019)
                                    (v128.const f64x2 0123456789. 0123456789.))
                                    (v128.const f64x2 0x1.d6f3454000000p+26 0x1.d6f3454000000p+26))
(assert_return (invoke "f64x2.pmin" (v128.const f64x2 0x0123456789ABCDEFabcdefp+019 0x0123456789ABCDEFabcdefp+019)
                                    (v128.const f64x2 0123456789.e019 0123456789.e019))
                                    (v128.const f64x2 0x1.fe9af5b5e16fap+89 0x1.fe9af5b5e16fap+89))
(assert_return (invoke "f64x2.pmin" (v128.const f64x2 0x0123456789ABCDEFabcdefp+019 0x0123456789ABCDEFabcdefp+019)
                                    (v128.const f64x2 0123456789.e+019 0123456789.e+019))
                                    (v128.const f64x2 0x1.fe9af5b5e16fap+89 0x1.fe9af5b5e16fap+89))
(assert_return (invoke "f64x2.pmin" (v128.const f64x2 0x0123456789ABCDEFabcdefp+019 0x0123456789ABCDEFabcdefp+019)
                                    (v128.const f64x2 0123456789.e-019 0123456789.e-019))
                                    (v128.const f64x2 0x1.b25ffd62b4311p-37 0x1.b25ffd62b4311p-37))
(assert_return (invoke "f64x2.pmin" (v128.const f64x2 0x0123456789ABCDEFabcdefp+019 0x0123456789ABCDEFabcdefp+019)
                                    (v128.const f64x2 0123456789.0123456789 0123456789.0123456789))
                                    (v128.const f64x2 0x1.d6f34540ca458p+26 0x1.d6f34540ca458p+26))
(assert_return (invoke "f64x2.pmin" (v128.const f64x2 0x0123456789ABCDEFabcdefp+019 0x0123456789ABCDEFabcdefp+019)
                                    (v128.const f64x2 0123456789.0123456789e019 0123456789.0123456789e019))
                                    (v128.const f64x2 0x1.fe9af5b6bcbd5p+89 0x1.fe9af5b6bcbd5p+89))
(assert_return (invoke "f64x2.pmin" (v128.const f64x2 0x0123456789ABCDEFabcdefp+019 0x0123456789ABCDEFabcdefp+019)
                                    (v128.const f64x2 0123456789.0123456789e+019 0123456789.0123456789e+019))
                                    (v128.const f64x2 0x1.fe9af5b6bcbd5p+89 0x1.fe9af5b6bcbd5p+89))
(assert_return (invoke "f64x2.pmin" (v128.const f64x2 0x0123456789ABCDEFabcdefp+019 0x0123456789ABCDEFabcdefp+019)
                                    (v128.const f64x2 0123456789.0123456789e-019 0123456789.0123456789e-019))
                                    (v128.const f64x2 0x1.b25ffd636ec12p-37 0x1.b25ffd636ec12p-37))
(assert_return (invoke "f64x2.pmin" (v128.const f64x2 0x0123456789ABCDEFabcdefp+019 0x0123456789ABCDEFabcdefp+019)
                                    (v128.const f64x2 0x0123456789ABCDEFabcdef 0x0123456789ABCDEFabcdef))
                                    (v128.const f64x2 0x1.23456789abcdfp+80 0x1.23456789abcdfp+80))
(assert_return (invoke "f64x2.pmin" (v128.const f64x2 0x0123456789ABCDEFabcdefp+019 0x0123456789ABCDEFabcdefp+019)
                                    (v128.const f64x2 0x0123456789ABCDEFabcdefp019 0x0123456789ABCDEFabcdefp019))
                                    (v128.const f64x2 0x1.23456789abcdfp+99 0x1.23456789abcdfp+99))
(assert_return (invoke "f64x2.pmin" (v128.const f64x2 0x0123456789ABCDEFabcdefp+019 0x0123456789ABCDEFabcdefp+019)
                                    (v128.const f64x2 0x0123456789ABCDEFabcdefp+019 0x0123456789ABCDEFabcdefp+019))
                                    (v128.const f64x2 0x1.23456789abcdfp+99 0x1.23456789abcdfp+99))
(assert_return (invoke "f64x2.pmin" (v128.const f64x2 0x0123456789ABCDEFabcdefp+019 0x0123456789ABCDEFabcdefp+019)
                                    (v128.const f64x2 0x0123456789ABCDEFabcdefp-019 0x0123456789ABCDEFabcdefp-019))
                                    (v128.const f64x2 0x1.23456789abcdfp+61 0x1.23456789abcdfp+61))
(assert_return (invoke "f64x2.pmin" (v128.const f64x2 0x0123456789ABCDEFabcdefp+019 0x0123456789ABCDEFabcdefp+019)
                                    (v128.const f64x2 0x0123456789ABCDEFabcdef. 0x0123456789ABCDEFabcdef.))
                                    (v128.const f64x2 0x1.23456789abcdfp+80 0x1.23456789abcdfp+80))
(assert_return (invoke "f64x2.pmin" (v128.const f64x2 0x0123456789ABCDEFabcdefp+019 0x0123456789ABCDEFabcdefp+019)
                                    (v128.const f64x2 0x0123456789ABCDEFabcdef.p019 0x0123456789ABCDEFabcdef.p019))
                                    (v128.const f64x2 0x1.23456789abcdfp+99 0x1.23456789abcdfp+99))
(assert_return (invoke "f64x2.pmin" (v128.const f64x2 0x0123456789ABCDEFabcdefp+019 0x0123456789ABCDEFabcdefp+019)
                                    (v128.const f64x2 0x0123456789ABCDEFabcdef.p+019 0x0123456789ABCDEFabcdef.p+019))
                                    (v128.const f64x2 0x1.23456789abcdfp+99 0x1.23456789abcdfp+99))
(assert_return (invoke "f64x2.pmin" (v128.const f64x2 0x0123456789ABCDEFabcdefp+019 0x0123456789ABCDEFabcdefp+019)
                                    (v128.const f64x2 0x0123456789ABCDEFabcdef.p-019 0x0123456789ABCDEFabcdef.p-019))
                                    (v128.const f64x2 0x1.23456789abcdfp+61 0x1.23456789abcdfp+61))
(assert_return (invoke "f64x2.pmin" (v128.const f64x2 0x0123456789ABCDEFabcdefp+019 0x0123456789ABCDEFabcdefp+019)
                                    (v128.const f64x2 0x0123456789ABCDEFabcdef.0123456789ABCDEFabcdef 0x0123456789ABCDEFabcdef.0123456789ABCDEFabcdef))
                                    (v128.const f64x2 0x1.23456789abcdfp+80 0x1.23456789abcdfp+80))
(assert_return (invoke "f64x2.pmin" (v128.const f64x2 0x0123456789ABCDEFabcdefp+019 0x0123456789ABCDEFabcdefp+019)
                                    (v128.const f64x2 0x0123456789ABCDEFabcdef.0123456789ABCDEFabcdefp019 0x0123456789ABCDEFabcdef.0123456789ABCDEFabcdefp019))
                                    (v128.const f64x2 0x1.23456789abcdfp+99 0x1.23456789abcdfp+99))
(assert_return (invoke "f64x2.pmin" (v128.const f64x2 0x0123456789ABCDEFabcdefp+019 0x0123456789ABCDEFabcdefp+019)
                                    (v128.const f64x2 0x0123456789ABCDEFabcdef.0123456789ABCDEFabcdefp+019 0x0123456789ABCDEFabcdef.0123456789ABCDEFabcdefp+019))
                                    (v128.const f64x2 0x1.23456789abcdfp+99 0x1.23456789abcdfp+99))
(assert_return (invoke "f64x2.pmin" (v128.const f64x2 0x0123456789ABCDEFabcdefp+019 0x0123456789ABCDEFabcdefp+019)
                                    (v128.const f64x2 0x0123456789ABCDEFabcdef.0123456789ABCDEFabcdefp-019 0x0123456789ABCDEFabcdef.0123456789ABCDEFabcdefp-019))
                                    (v128.const f64x2 0x1.23456789abcdfp+61 0x1.23456789abcdfp+61))
(assert_return (invoke "f64x2.pmin" (v128.const f64x2 0x0123456789ABCDEFabcdefp-019 0x0123456789ABCDEFabcdefp-019)
                                    (v128.const f64x2 0x0p+0 0x0p+0))
                                    (v128.const f64x2 0x0.0p+0 0x0.0p+0))
(assert_return (invoke "f64x2.pmin" (v128.const f64x2 0x0123456789ABCDEFabcdefp-019 0x0123456789ABCDEFabcdefp-019)
                                    (v128.const f64x2 -0x0p+0 -0x0p+0))
                                    (v128.const f64x2 -0x0.0p+0 -0x0.0p+0))
(assert_return (invoke "f64x2.pmin" (v128.const f64x2 0x0123456789ABCDEFabcdefp-019 0x0123456789ABCDEFabcdefp-019)
                                    (v128.const f64x2 0x1p-1022 0x1p-1022))
                                    (v128.const f64x2 0x1.0000000000000p-1022 0x1.0000000000000p-1022))
(assert_return (invoke "f64x2.pmin" (v128.const f64x2 0x0123456789ABCDEFabcdefp-019 0x0123456789ABCDEFabcdefp-019)
                                    (v128.const f64x2 -0x1p-1022 -0x1p-1022))
                                    (v128.const f64x2 -0x1.0000000000000p-1022 -0x1.0000000000000p-1022))
(assert_return (invoke "f64x2.pmin" (v128.const f64x2 0x0123456789ABCDEFabcdefp-019 0x0123456789ABCDEFabcdefp-019)
                                    (v128.const f64x2 0x1p-1 0x1p-1))
                                    (v128.const f64x2 0x1.0000000000000p-1 0x1.0000000000000p-1))
(assert_return (invoke "f64x2.pmin" (v128.const f64x2 0x0123456789ABCDEFabcdefp-019 0x0123456789ABCDEFabcdefp-019)
                                    (v128.const f64x2 -0x1p-1 -0x1p-1))
                                    (v128.const f64x2 -0x1.0000000000000p-1 -0x1.0000000000000p-1))
(assert_return (invoke "f64x2.pmin" (v128.const f64x2 0x0123456789ABCDEFabcdefp-019 0x0123456789ABCDEFabcdefp-019)
                                    (v128.const f64x2 0x1p+0 0x1p+0))
                                    (v128.const f64x2 0x1.0000000000000p+0 0x1.0000000000000p+0))
(assert_return (invoke "f64x2.pmin" (v128.const f64x2 0x0123456789ABCDEFabcdefp-019 0x0123456789ABCDEFabcdefp-019)
                                    (v128.const f64x2 -0x1p+0 -0x1p+0))
                                    (v128.const f64x2 -0x1.0000000000000p+0 -0x1.0000000000000p+0))
(assert_return (invoke "f64x2.pmin" (v128.const f64x2 0x0123456789ABCDEFabcdefp-019 0x0123456789ABCDEFabcdefp-019)
                                    (v128.const f64x2 0x1.921fb54442d18p+2 0x1.921fb54442d18p+2))
                                    (v128.const f64x2 0x1.921fb54442d18p+2 0x1.921fb54442d18p+2))
(assert_return (invoke "f64x2.pmin" (v128.const f64x2 0x0123456789ABCDEFabcdefp-019 0x0123456789ABCDEFabcdefp-019)
                                    (v128.const f64x2 -0x1.921fb54442d18p+2 -0x1.921fb54442d18p+2))
                                    (v128.const f64x2 -0x1.921fb54442d18p+2 -0x1.921fb54442d18p+2))
(assert_return (invoke "f64x2.pmin" (v128.const f64x2 0x0123456789ABCDEFabcdefp-019 0x0123456789ABCDEFabcdefp-019)
                                    (v128.const f64x2 0x1.fffffffffffffp+1023 0x1.fffffffffffffp+1023))
                                    (v128.const f64x2 0x1.23456789abcdfp+61 0x1.23456789abcdfp+61))
(assert_return (invoke "f64x2.pmin" (v128.const f64x2 0x0123456789ABCDEFabcdefp-019 0x0123456789ABCDEFabcdefp-019)
                                    (v128.const f64x2 -0x1.fffffffffffffp+1023 -0x1.fffffffffffffp+1023))
                                    (v128.const f64x2 -0x1.fffffffffffffp+1023 -0x1.fffffffffffffp+1023))
(assert_return (invoke "f64x2.pmin" (v128.const f64x2 0x0123456789ABCDEFabcdefp-019 0x0123456789ABCDEFabcdefp-019)
                                    (v128.const f64x2 0x0.0000000000001p-1022 0x0.0000000000001p-1022))
                                    (v128.const f64x2 0x0.0000000000001p-1022 0x0.0000000000001p-1022))
(assert_return (invoke "f64x2.pmin" (v128.const f64x2 0x0123456789ABCDEFabcdefp-019 0x0123456789ABCDEFabcdefp-019)
                                    (v128.const f64x2 0x0.0000000000001p-1022 0x0.0000000000001p-1022))
                                    (v128.const f64x2 0x0.0000000000001p-1022 0x0.0000000000001p-1022))
(assert_return (invoke "f64x2.pmin" (v128.const f64x2 0x0123456789ABCDEFabcdefp-019 0x0123456789ABCDEFabcdefp-019)
                                    (v128.const f64x2 inf inf))
                                    (v128.const f64x2 0x1.23456789abcdfp+61 0x1.23456789abcdfp+61))
(assert_return (invoke "f64x2.pmin" (v128.const f64x2 0x0123456789ABCDEFabcdefp-019 0x0123456789ABCDEFabcdefp-019)
                                    (v128.const f64x2 -inf -inf))
                                    (v128.const f64x2 -inf -inf))
(assert_return (invoke "f64x2.pmin" (v128.const f64x2 0x0123456789ABCDEFabcdefp-019 0x0123456789ABCDEFabcdefp-019)
                                    (v128.const f64x2 0123456789 0123456789))
                                    (v128.const f64x2 0x1.d6f3454000000p+26 0x1.d6f3454000000p+26))
(assert_return (invoke "f64x2.pmin" (v128.const f64x2 0x0123456789ABCDEFabcdefp-019 0x0123456789ABCDEFabcdefp-019)
                                    (v128.const f64x2 0123456789e019 0123456789e019))
                                    (v128.const f64x2 0x1.23456789abcdfp+61 0x1.23456789abcdfp+61))
(assert_return (invoke "f64x2.pmin" (v128.const f64x2 0x0123456789ABCDEFabcdefp-019 0x0123456789ABCDEFabcdefp-019)
                                    (v128.const f64x2 0123456789e+019 0123456789e+019))
                                    (v128.const f64x2 0x1.23456789abcdfp+61 0x1.23456789abcdfp+61))
(assert_return (invoke "f64x2.pmin" (v128.const f64x2 0x0123456789ABCDEFabcdefp-019 0x0123456789ABCDEFabcdefp-019)
                                    (v128.const f64x2 0123456789e-019 0123456789e-019))
                                    (v128.const f64x2 0x1.b25ffd62b4311p-37 0x1.b25ffd62b4311p-37))
(assert_return (invoke "f64x2.pmin" (v128.const f64x2 0x0123456789ABCDEFabcdefp-019 0x0123456789ABCDEFabcdefp-019)
                                    (v128.const f64x2 0123456789. 0123456789.))
                                    (v128.const f64x2 0x1.d6f3454000000p+26 0x1.d6f3454000000p+26))
(assert_return (invoke "f64x2.pmin" (v128.const f64x2 0x0123456789ABCDEFabcdefp-019 0x0123456789ABCDEFabcdefp-019)
                                    (v128.const f64x2 0123456789.e019 0123456789.e019))
                                    (v128.const f64x2 0x1.23456789abcdfp+61 0x1.23456789abcdfp+61))
(assert_return (invoke "f64x2.pmin" (v128.const f64x2 0x0123456789ABCDEFabcdefp-019 0x0123456789ABCDEFabcdefp-019)
                                    (v128.const f64x2 0123456789.e+019 0123456789.e+019))
                                    (v128.const f64x2 0x1.23456789abcdfp+61 0x1.23456789abcdfp+61))
(assert_return (invoke "f64x2.pmin" (v128.const f64x2 0x0123456789ABCDEFabcdefp-019 0x0123456789ABCDEFabcdefp-019)
                                    (v128.const f64x2 0123456789.e-019 0123456789.e-019))
                                    (v128.const f64x2 0x1.b25ffd62b4311p-37 0x1.b25ffd62b4311p-37))
(assert_return (invoke "f64x2.pmin" (v128.const f64x2 0x0123456789ABCDEFabcdefp-019 0x0123456789ABCDEFabcdefp-019)
                                    (v128.const f64x2 0123456789.0123456789 0123456789.0123456789))
                                    (v128.const f64x2 0x1.d6f34540ca458p+26 0x1.d6f34540ca458p+26))
(assert_return (invoke "f64x2.pmin" (v128.const f64x2 0x0123456789ABCDEFabcdefp-019 0x0123456789ABCDEFabcdefp-019)
                                    (v128.const f64x2 0123456789.0123456789e019 0123456789.0123456789e019))
                                    (v128.const f64x2 0x1.23456789abcdfp+61 0x1.23456789abcdfp+61))
(assert_return (invoke "f64x2.pmin" (v128.const f64x2 0x0123456789ABCDEFabcdefp-019 0x0123456789ABCDEFabcdefp-019)
                                    (v128.const f64x2 0123456789.0123456789e+019 0123456789.0123456789e+019))
                                    (v128.const f64x2 0x1.23456789abcdfp+61 0x1.23456789abcdfp+61))
(assert_return (invoke "f64x2.pmin" (v128.const f64x2 0x0123456789ABCDEFabcdefp-019 0x0123456789ABCDEFabcdefp-019)
                                    (v128.const f64x2 0123456789.0123456789e-019 0123456789.0123456789e-019))
                                    (v128.const f64x2 0x1.b25ffd636ec12p-37 0x1.b25ffd636ec12p-37))
(assert_return (invoke "f64x2.pmin" (v128.const f64x2 0x0123456789ABCDEFabcdefp-019 0x0123456789ABCDEFabcdefp-019)
                                    (v128.const f64x2 0x0123456789ABCDEFabcdef 0x0123456789ABCDEFabcdef))
                                    (v128.const f64x2 0x1.23456789abcdfp+61 0x1.23456789abcdfp+61))
(assert_return (invoke "f64x2.pmin" (v128.const f64x2 0x0123456789ABCDEFabcdefp-019 0x0123456789ABCDEFabcdefp-019)
                                    (v128.const f64x2 0x0123456789ABCDEFabcdefp019 0x0123456789ABCDEFabcdefp019))
                                    (v128.const f64x2 0x1.23456789abcdfp+61 0x1.23456789abcdfp+61))
(assert_return (invoke "f64x2.pmin" (v128.const f64x2 0x0123456789ABCDEFabcdefp-019 0x0123456789ABCDEFabcdefp-019)
                                    (v128.const f64x2 0x0123456789ABCDEFabcdefp+019 0x0123456789ABCDEFabcdefp+019))
                                    (v128.const f64x2 0x1.23456789abcdfp+61 0x1.23456789abcdfp+61))
(assert_return (invoke "f64x2.pmin" (v128.const f64x2 0x0123456789ABCDEFabcdefp-019 0x0123456789ABCDEFabcdefp-019)
                                    (v128.const f64x2 0x0123456789ABCDEFabcdefp-019 0x0123456789ABCDEFabcdefp-019))
                                    (v128.const f64x2 0x1.23456789abcdfp+61 0x1.23456789abcdfp+61))
(assert_return (invoke "f64x2.pmin" (v128.const f64x2 0x0123456789ABCDEFabcdefp-019 0x0123456789ABCDEFabcdefp-019)
                                    (v128.const f64x2 0x0123456789ABCDEFabcdef. 0x0123456789ABCDEFabcdef.))
                                    (v128.const f64x2 0x1.23456789abcdfp+61 0x1.23456789abcdfp+61))
(assert_return (invoke "f64x2.pmin" (v128.const f64x2 0x0123456789ABCDEFabcdefp-019 0x0123456789ABCDEFabcdefp-019)
                                    (v128.const f64x2 0x0123456789ABCDEFabcdef.p019 0x0123456789ABCDEFabcdef.p019))
                                    (v128.const f64x2 0x1.23456789abcdfp+61 0x1.23456789abcdfp+61))
(assert_return (invoke "f64x2.pmin" (v128.const f64x2 0x0123456789ABCDEFabcdefp-019 0x0123456789ABCDEFabcdefp-019)
                                    (v128.const f64x2 0x0123456789ABCDEFabcdef.p+019 0x0123456789ABCDEFabcdef.p+019))
                                    (v128.const f64x2 0x1.23456789abcdfp+61 0x1.23456789abcdfp+61))
(assert_return (invoke "f64x2.pmin" (v128.const f64x2 0x0123456789ABCDEFabcdefp-019 0x0123456789ABCDEFabcdefp-019)
                                    (v128.const f64x2 0x0123456789ABCDEFabcdef.p-019 0x0123456789ABCDEFabcdef.p-019))
                                    (v128.const f64x2 0x1.23456789abcdfp+61 0x1.23456789abcdfp+61))
(assert_return (invoke "f64x2.pmin" (v128.const f64x2 0x0123456789ABCDEFabcdefp-019 0x0123456789ABCDEFabcdefp-019)
                                    (v128.const f64x2 0x0123456789ABCDEFabcdef.0123456789ABCDEFabcdef 0x0123456789ABCDEFabcdef.0123456789ABCDEFabcdef))
                                    (v128.const f64x2 0x1.23456789abcdfp+61 0x1.23456789abcdfp+61))
(assert_return (invoke "f64x2.pmin" (v128.const f64x2 0x0123456789ABCDEFabcdefp-019 0x0123456789ABCDEFabcdefp-019)
                                    (v128.const f64x2 0x0123456789ABCDEFabcdef.0123456789ABCDEFabcdefp019 0x0123456789ABCDEFabcdef.0123456789ABCDEFabcdefp019))
                                    (v128.const f64x2 0x1.23456789abcdfp+61 0x1.23456789abcdfp+61))
(assert_return (invoke "f64x2.pmin" (v128.const f64x2 0x0123456789ABCDEFabcdefp-019 0x0123456789ABCDEFabcdefp-019)
                                    (v128.const f64x2 0x0123456789ABCDEFabcdef.0123456789ABCDEFabcdefp+019 0x0123456789ABCDEFabcdef.0123456789ABCDEFabcdefp+019))
                                    (v128.const f64x2 0x1.23456789abcdfp+61 0x1.23456789abcdfp+61))
(assert_return (invoke "f64x2.pmin" (v128.const f64x2 0x0123456789ABCDEFabcdefp-019 0x0123456789ABCDEFabcdefp-019)
                                    (v128.const f64x2 0x0123456789ABCDEFabcdef.0123456789ABCDEFabcdefp-019 0x0123456789ABCDEFabcdef.0123456789ABCDEFabcdefp-019))
                                    (v128.const f64x2 0x1.23456789abcdfp+61 0x1.23456789abcdfp+61))
(assert_return (invoke "f64x2.pmin" (v128.const f64x2 0x0123456789ABCDEFabcdef. 0x0123456789ABCDEFabcdef.)
                                    (v128.const f64x2 0x0p+0 0x0p+0))
                                    (v128.const f64x2 0x0.0p+0 0x0.0p+0))
(assert_return (invoke "f64x2.pmin" (v128.const f64x2 0x0123456789ABCDEFabcdef. 0x0123456789ABCDEFabcdef.)
                                    (v128.const f64x2 -0x0p+0 -0x0p+0))
                                    (v128.const f64x2 -0x0.0p+0 -0x0.0p+0))
(assert_return (invoke "f64x2.pmin" (v128.const f64x2 0x0123456789ABCDEFabcdef. 0x0123456789ABCDEFabcdef.)
                                    (v128.const f64x2 0x1p-1022 0x1p-1022))
                                    (v128.const f64x2 0x1.0000000000000p-1022 0x1.0000000000000p-1022))
(assert_return (invoke "f64x2.pmin" (v128.const f64x2 0x0123456789ABCDEFabcdef. 0x0123456789ABCDEFabcdef.)
                                    (v128.const f64x2 -0x1p-1022 -0x1p-1022))
                                    (v128.const f64x2 -0x1.0000000000000p-1022 -0x1.0000000000000p-1022))
(assert_return (invoke "f64x2.pmin" (v128.const f64x2 0x0123456789ABCDEFabcdef. 0x0123456789ABCDEFabcdef.)
                                    (v128.const f64x2 0x1p-1 0x1p-1))
                                    (v128.const f64x2 0x1.0000000000000p-1 0x1.0000000000000p-1))
(assert_return (invoke "f64x2.pmin" (v128.const f64x2 0x0123456789ABCDEFabcdef. 0x0123456789ABCDEFabcdef.)
                                    (v128.const f64x2 -0x1p-1 -0x1p-1))
                                    (v128.const f64x2 -0x1.0000000000000p-1 -0x1.0000000000000p-1))
(assert_return (invoke "f64x2.pmin" (v128.const f64x2 0x0123456789ABCDEFabcdef. 0x0123456789ABCDEFabcdef.)
                                    (v128.const f64x2 0x1p+0 0x1p+0))
                                    (v128.const f64x2 0x1.0000000000000p+0 0x1.0000000000000p+0))
(assert_return (invoke "f64x2.pmin" (v128.const f64x2 0x0123456789ABCDEFabcdef. 0x0123456789ABCDEFabcdef.)
                                    (v128.const f64x2 -0x1p+0 -0x1p+0))
                                    (v128.const f64x2 -0x1.0000000000000p+0 -0x1.0000000000000p+0))
(assert_return (invoke "f64x2.pmin" (v128.const f64x2 0x0123456789ABCDEFabcdef. 0x0123456789ABCDEFabcdef.)
                                    (v128.const f64x2 0x1.921fb54442d18p+2 0x1.921fb54442d18p+2))
                                    (v128.const f64x2 0x1.921fb54442d18p+2 0x1.921fb54442d18p+2))
(assert_return (invoke "f64x2.pmin" (v128.const f64x2 0x0123456789ABCDEFabcdef. 0x0123456789ABCDEFabcdef.)
                                    (v128.const f64x2 -0x1.921fb54442d18p+2 -0x1.921fb54442d18p+2))
                                    (v128.const f64x2 -0x1.921fb54442d18p+2 -0x1.921fb54442d18p+2))
(assert_return (invoke "f64x2.pmin" (v128.const f64x2 0x0123456789ABCDEFabcdef. 0x0123456789ABCDEFabcdef.)
                                    (v128.const f64x2 0x1.fffffffffffffp+1023 0x1.fffffffffffffp+1023))
                                    (v128.const f64x2 0x1.23456789abcdfp+80 0x1.23456789abcdfp+80))
(assert_return (invoke "f64x2.pmin" (v128.const f64x2 0x0123456789ABCDEFabcdef. 0x0123456789ABCDEFabcdef.)
                                    (v128.const f64x2 -0x1.fffffffffffffp+1023 -0x1.fffffffffffffp+1023))
                                    (v128.const f64x2 -0x1.fffffffffffffp+1023 -0x1.fffffffffffffp+1023))
(assert_return (invoke "f64x2.pmin" (v128.const f64x2 0x0123456789ABCDEFabcdef. 0x0123456789ABCDEFabcdef.)
                                    (v128.const f64x2 0x0.0000000000001p-1022 0x0.0000000000001p-1022))
                                    (v128.const f64x2 0x0.0000000000001p-1022 0x0.0000000000001p-1022))
(assert_return (invoke "f64x2.pmin" (v128.const f64x2 0x0123456789ABCDEFabcdef. 0x0123456789ABCDEFabcdef.)
                                    (v128.const f64x2 0x0.0000000000001p-1022 0x0.0000000000001p-1022))
                                    (v128.const f64x2 0x0.0000000000001p-1022 0x0.0000000000001p-1022))
(assert_return (invoke "f64x2.pmin" (v128.const f64x2 0x0123456789ABCDEFabcdef. 0x0123456789ABCDEFabcdef.)
                                    (v128.const f64x2 inf inf))
                                    (v128.const f64x2 0x1.23456789abcdfp+80 0x1.23456789abcdfp+80))
(assert_return (invoke "f64x2.pmin" (v128.const f64x2 0x0123456789ABCDEFabcdef. 0x0123456789ABCDEFabcdef.)
                                    (v128.const f64x2 -inf -inf))
                                    (v128.const f64x2 -inf -inf))
(assert_return (invoke "f64x2.pmin" (v128.const f64x2 0x0123456789ABCDEFabcdef. 0x0123456789ABCDEFabcdef.)
                                    (v128.const f64x2 0123456789 0123456789))
                                    (v128.const f64x2 0x1.d6f3454000000p+26 0x1.d6f3454000000p+26))
(assert_return (invoke "f64x2.pmin" (v128.const f64x2 0x0123456789ABCDEFabcdef. 0x0123456789ABCDEFabcdef.)
                                    (v128.const f64x2 0123456789e019 0123456789e019))
                                    (v128.const f64x2 0x1.23456789abcdfp+80 0x1.23456789abcdfp+80))
(assert_return (invoke "f64x2.pmin" (v128.const f64x2 0x0123456789ABCDEFabcdef. 0x0123456789ABCDEFabcdef.)
                                    (v128.const f64x2 0123456789e+019 0123456789e+019))
                                    (v128.const f64x2 0x1.23456789abcdfp+80 0x1.23456789abcdfp+80))
(assert_return (invoke "f64x2.pmin" (v128.const f64x2 0x0123456789ABCDEFabcdef. 0x0123456789ABCDEFabcdef.)
                                    (v128.const f64x2 0123456789e-019 0123456789e-019))
                                    (v128.const f64x2 0x1.b25ffd62b4311p-37 0x1.b25ffd62b4311p-37))
(assert_return (invoke "f64x2.pmin" (v128.const f64x2 0x0123456789ABCDEFabcdef. 0x0123456789ABCDEFabcdef.)
                                    (v128.const f64x2 0123456789. 0123456789.))
                                    (v128.const f64x2 0x1.d6f3454000000p+26 0x1.d6f3454000000p+26))
(assert_return (invoke "f64x2.pmin" (v128.const f64x2 0x0123456789ABCDEFabcdef. 0x0123456789ABCDEFabcdef.)
                                    (v128.const f64x2 0123456789.e019 0123456789.e019))
                                    (v128.const f64x2 0x1.23456789abcdfp+80 0x1.23456789abcdfp+80))
(assert_return (invoke "f64x2.pmin" (v128.const f64x2 0x0123456789ABCDEFabcdef. 0x0123456789ABCDEFabcdef.)
                                    (v128.const f64x2 0123456789.e+019 0123456789.e+019))
                                    (v128.const f64x2 0x1.23456789abcdfp+80 0x1.23456789abcdfp+80))
(assert_return (invoke "f64x2.pmin" (v128.const f64x2 0x0123456789ABCDEFabcdef. 0x0123456789ABCDEFabcdef.)
                                    (v128.const f64x2 0123456789.e-019 0123456789.e-019))
                                    (v128.const f64x2 0x1.b25ffd62b4311p-37 0x1.b25ffd62b4311p-37))
(assert_return (invoke "f64x2.pmin" (v128.const f64x2 0x0123456789ABCDEFabcdef. 0x0123456789ABCDEFabcdef.)
                                    (v128.const f64x2 0123456789.0123456789 0123456789.0123456789))
                                    (v128.const f64x2 0x1.d6f34540ca458p+26 0x1.d6f34540ca458p+26))
(assert_return (invoke "f64x2.pmin" (v128.const f64x2 0x0123456789ABCDEFabcdef. 0x0123456789ABCDEFabcdef.)
                                    (v128.const f64x2 0123456789.0123456789e019 0123456789.0123456789e019))
                                    (v128.const f64x2 0x1.23456789abcdfp+80 0x1.23456789abcdfp+80))
(assert_return (invoke "f64x2.pmin" (v128.const f64x2 0x0123456789ABCDEFabcdef. 0x0123456789ABCDEFabcdef.)
                                    (v128.const f64x2 0123456789.0123456789e+019 0123456789.0123456789e+019))
                                    (v128.const f64x2 0x1.23456789abcdfp+80 0x1.23456789abcdfp+80))
(assert_return (invoke "f64x2.pmin" (v128.const f64x2 0x0123456789ABCDEFabcdef. 0x0123456789ABCDEFabcdef.)
                                    (v128.const f64x2 0123456789.0123456789e-019 0123456789.0123456789e-019))
                                    (v128.const f64x2 0x1.b25ffd636ec12p-37 0x1.b25ffd636ec12p-37))
(assert_return (invoke "f64x2.pmin" (v128.const f64x2 0x0123456789ABCDEFabcdef. 0x0123456789ABCDEFabcdef.)
                                    (v128.const f64x2 0x0123456789ABCDEFabcdef 0x0123456789ABCDEFabcdef))
                                    (v128.const f64x2 0x1.23456789abcdfp+80 0x1.23456789abcdfp+80))
(assert_return (invoke "f64x2.pmin" (v128.const f64x2 0x0123456789ABCDEFabcdef. 0x0123456789ABCDEFabcdef.)
                                    (v128.const f64x2 0x0123456789ABCDEFabcdefp019 0x0123456789ABCDEFabcdefp019))
                                    (v128.const f64x2 0x1.23456789abcdfp+80 0x1.23456789abcdfp+80))
(assert_return (invoke "f64x2.pmin" (v128.const f64x2 0x0123456789ABCDEFabcdef. 0x0123456789ABCDEFabcdef.)
                                    (v128.const f64x2 0x0123456789ABCDEFabcdefp+019 0x0123456789ABCDEFabcdefp+019))
                                    (v128.const f64x2 0x1.23456789abcdfp+80 0x1.23456789abcdfp+80))
(assert_return (invoke "f64x2.pmin" (v128.const f64x2 0x0123456789ABCDEFabcdef. 0x0123456789ABCDEFabcdef.)
                                    (v128.const f64x2 0x0123456789ABCDEFabcdefp-019 0x0123456789ABCDEFabcdefp-019))
                                    (v128.const f64x2 0x1.23456789abcdfp+61 0x1.23456789abcdfp+61))
(assert_return (invoke "f64x2.pmin" (v128.const f64x2 0x0123456789ABCDEFabcdef. 0x0123456789ABCDEFabcdef.)
                                    (v128.const f64x2 0x0123456789ABCDEFabcdef. 0x0123456789ABCDEFabcdef.))
                                    (v128.const f64x2 0x1.23456789abcdfp+80 0x1.23456789abcdfp+80))
(assert_return (invoke "f64x2.pmin" (v128.const f64x2 0x0123456789ABCDEFabcdef. 0x0123456789ABCDEFabcdef.)
                                    (v128.const f64x2 0x0123456789ABCDEFabcdef.p019 0x0123456789ABCDEFabcdef.p019))
                                    (v128.const f64x2 0x1.23456789abcdfp+80 0x1.23456789abcdfp+80))
(assert_return (invoke "f64x2.pmin" (v128.const f64x2 0x0123456789ABCDEFabcdef. 0x0123456789ABCDEFabcdef.)
                                    (v128.const f64x2 0x0123456789ABCDEFabcdef.p+019 0x0123456789ABCDEFabcdef.p+019))
                                    (v128.const f64x2 0x1.23456789abcdfp+80 0x1.23456789abcdfp+80))
(assert_return (invoke "f64x2.pmin" (v128.const f64x2 0x0123456789ABCDEFabcdef. 0x0123456789ABCDEFabcdef.)
                                    (v128.const f64x2 0x0123456789ABCDEFabcdef.p-019 0x0123456789ABCDEFabcdef.p-019))
                                    (v128.const f64x2 0x1.23456789abcdfp+61 0x1.23456789abcdfp+61))
(assert_return (invoke "f64x2.pmin" (v128.const f64x2 0x0123456789ABCDEFabcdef. 0x0123456789ABCDEFabcdef.)
                                    (v128.const f64x2 0x0123456789ABCDEFabcdef.0123456789ABCDEFabcdef 0x0123456789ABCDEFabcdef.0123456789ABCDEFabcdef))
                                    (v128.const f64x2 0x1.23456789abcdfp+80 0x1.23456789abcdfp+80))
(assert_return (invoke "f64x2.pmin" (v128.const f64x2 0x0123456789ABCDEFabcdef. 0x0123456789ABCDEFabcdef.)
                                    (v128.const f64x2 0x0123456789ABCDEFabcdef.0123456789ABCDEFabcdefp019 0x0123456789ABCDEFabcdef.0123456789ABCDEFabcdefp019))
                                    (v128.const f64x2 0x1.23456789abcdfp+80 0x1.23456789abcdfp+80))
(assert_return (invoke "f64x2.pmin" (v128.const f64x2 0x0123456789ABCDEFabcdef. 0x0123456789ABCDEFabcdef.)
                                    (v128.const f64x2 0x0123456789ABCDEFabcdef.0123456789ABCDEFabcdefp+019 0x0123456789ABCDEFabcdef.0123456789ABCDEFabcdefp+019))
                                    (v128.const f64x2 0x1.23456789abcdfp+80 0x1.23456789abcdfp+80))
(assert_return (invoke "f64x2.pmin" (v128.const f64x2 0x0123456789ABCDEFabcdef. 0x0123456789ABCDEFabcdef.)
                                    (v128.const f64x2 0x0123456789ABCDEFabcdef.0123456789ABCDEFabcdefp-019 0x0123456789ABCDEFabcdef.0123456789ABCDEFabcdefp-019))
                                    (v128.const f64x2 0x1.23456789abcdfp+61 0x1.23456789abcdfp+61))
(assert_return (invoke "f64x2.pmin" (v128.const f64x2 0x0123456789ABCDEFabcdef.p019 0x0123456789ABCDEFabcdef.p019)
                                    (v128.const f64x2 0x0p+0 0x0p+0))
                                    (v128.const f64x2 0x0.0p+0 0x0.0p+0))
(assert_return (invoke "f64x2.pmin" (v128.const f64x2 0x0123456789ABCDEFabcdef.p019 0x0123456789ABCDEFabcdef.p019)
                                    (v128.const f64x2 -0x0p+0 -0x0p+0))
                                    (v128.const f64x2 -0x0.0p+0 -0x0.0p+0))
(assert_return (invoke "f64x2.pmin" (v128.const f64x2 0x0123456789ABCDEFabcdef.p019 0x0123456789ABCDEFabcdef.p019)
                                    (v128.const f64x2 0x1p-1022 0x1p-1022))
                                    (v128.const f64x2 0x1.0000000000000p-1022 0x1.0000000000000p-1022))
(assert_return (invoke "f64x2.pmin" (v128.const f64x2 0x0123456789ABCDEFabcdef.p019 0x0123456789ABCDEFabcdef.p019)
                                    (v128.const f64x2 -0x1p-1022 -0x1p-1022))
                                    (v128.const f64x2 -0x1.0000000000000p-1022 -0x1.0000000000000p-1022))
(assert_return (invoke "f64x2.pmin" (v128.const f64x2 0x0123456789ABCDEFabcdef.p019 0x0123456789ABCDEFabcdef.p019)
                                    (v128.const f64x2 0x1p-1 0x1p-1))
                                    (v128.const f64x2 0x1.0000000000000p-1 0x1.0000000000000p-1))
(assert_return (invoke "f64x2.pmin" (v128.const f64x2 0x0123456789ABCDEFabcdef.p019 0x0123456789ABCDEFabcdef.p019)
                                    (v128.const f64x2 -0x1p-1 -0x1p-1))
                                    (v128.const f64x2 -0x1.0000000000000p-1 -0x1.0000000000000p-1))
(assert_return (invoke "f64x2.pmin" (v128.const f64x2 0x0123456789ABCDEFabcdef.p019 0x0123456789ABCDEFabcdef.p019)
                                    (v128.const f64x2 0x1p+0 0x1p+0))
                                    (v128.const f64x2 0x1.0000000000000p+0 0x1.0000000000000p+0))
(assert_return (invoke "f64x2.pmin" (v128.const f64x2 0x0123456789ABCDEFabcdef.p019 0x0123456789ABCDEFabcdef.p019)
                                    (v128.const f64x2 -0x1p+0 -0x1p+0))
                                    (v128.const f64x2 -0x1.0000000000000p+0 -0x1.0000000000000p+0))
(assert_return (invoke "f64x2.pmin" (v128.const f64x2 0x0123456789ABCDEFabcdef.p019 0x0123456789ABCDEFabcdef.p019)
                                    (v128.const f64x2 0x1.921fb54442d18p+2 0x1.921fb54442d18p+2))
                                    (v128.const f64x2 0x1.921fb54442d18p+2 0x1.921fb54442d18p+2))
(assert_return (invoke "f64x2.pmin" (v128.const f64x2 0x0123456789ABCDEFabcdef.p019 0x0123456789ABCDEFabcdef.p019)
                                    (v128.const f64x2 -0x1.921fb54442d18p+2 -0x1.921fb54442d18p+2))
                                    (v128.const f64x2 -0x1.921fb54442d18p+2 -0x1.921fb54442d18p+2))
(assert_return (invoke "f64x2.pmin" (v128.const f64x2 0x0123456789ABCDEFabcdef.p019 0x0123456789ABCDEFabcdef.p019)
                                    (v128.const f64x2 0x1.fffffffffffffp+1023 0x1.fffffffffffffp+1023))
                                    (v128.const f64x2 0x1.23456789abcdfp+99 0x1.23456789abcdfp+99))
(assert_return (invoke "f64x2.pmin" (v128.const f64x2 0x0123456789ABCDEFabcdef.p019 0x0123456789ABCDEFabcdef.p019)
                                    (v128.const f64x2 -0x1.fffffffffffffp+1023 -0x1.fffffffffffffp+1023))
                                    (v128.const f64x2 -0x1.fffffffffffffp+1023 -0x1.fffffffffffffp+1023))
(assert_return (invoke "f64x2.pmin" (v128.const f64x2 0x0123456789ABCDEFabcdef.p019 0x0123456789ABCDEFabcdef.p019)
                                    (v128.const f64x2 0x0.0000000000001p-1022 0x0.0000000000001p-1022))
                                    (v128.const f64x2 0x0.0000000000001p-1022 0x0.0000000000001p-1022))
(assert_return (invoke "f64x2.pmin" (v128.const f64x2 0x0123456789ABCDEFabcdef.p019 0x0123456789ABCDEFabcdef.p019)
                                    (v128.const f64x2 0x0.0000000000001p-1022 0x0.0000000000001p-1022))
                                    (v128.const f64x2 0x0.0000000000001p-1022 0x0.0000000000001p-1022))
(assert_return (invoke "f64x2.pmin" (v128.const f64x2 0x0123456789ABCDEFabcdef.p019 0x0123456789ABCDEFabcdef.p019)
                                    (v128.const f64x2 inf inf))
                                    (v128.const f64x2 0x1.23456789abcdfp+99 0x1.23456789abcdfp+99))
(assert_return (invoke "f64x2.pmin" (v128.const f64x2 0x0123456789ABCDEFabcdef.p019 0x0123456789ABCDEFabcdef.p019)
                                    (v128.const f64x2 -inf -inf))
                                    (v128.const f64x2 -inf -inf))
(assert_return (invoke "f64x2.pmin" (v128.const f64x2 0x0123456789ABCDEFabcdef.p019 0x0123456789ABCDEFabcdef.p019)
                                    (v128.const f64x2 0123456789 0123456789))
                                    (v128.const f64x2 0x1.d6f3454000000p+26 0x1.d6f3454000000p+26))
(assert_return (invoke "f64x2.pmin" (v128.const f64x2 0x0123456789ABCDEFabcdef.p019 0x0123456789ABCDEFabcdef.p019)
                                    (v128.const f64x2 0123456789e019 0123456789e019))
                                    (v128.const f64x2 0x1.fe9af5b5e16fap+89 0x1.fe9af5b5e16fap+89))
(assert_return (invoke "f64x2.pmin" (v128.const f64x2 0x0123456789ABCDEFabcdef.p019 0x0123456789ABCDEFabcdef.p019)
                                    (v128.const f64x2 0123456789e+019 0123456789e+019))
                                    (v128.const f64x2 0x1.fe9af5b5e16fap+89 0x1.fe9af5b5e16fap+89))
(assert_return (invoke "f64x2.pmin" (v128.const f64x2 0x0123456789ABCDEFabcdef.p019 0x0123456789ABCDEFabcdef.p019)
                                    (v128.const f64x2 0123456789e-019 0123456789e-019))
                                    (v128.const f64x2 0x1.b25ffd62b4311p-37 0x1.b25ffd62b4311p-37))
(assert_return (invoke "f64x2.pmin" (v128.const f64x2 0x0123456789ABCDEFabcdef.p019 0x0123456789ABCDEFabcdef.p019)
                                    (v128.const f64x2 0123456789. 0123456789.))
                                    (v128.const f64x2 0x1.d6f3454000000p+26 0x1.d6f3454000000p+26))
(assert_return (invoke "f64x2.pmin" (v128.const f64x2 0x0123456789ABCDEFabcdef.p019 0x0123456789ABCDEFabcdef.p019)
                                    (v128.const f64x2 0123456789.e019 0123456789.e019))
                                    (v128.const f64x2 0x1.fe9af5b5e16fap+89 0x1.fe9af5b5e16fap+89))
(assert_return (invoke "f64x2.pmin" (v128.const f64x2 0x0123456789ABCDEFabcdef.p019 0x0123456789ABCDEFabcdef.p019)
                                    (v128.const f64x2 0123456789.e+019 0123456789.e+019))
                                    (v128.const f64x2 0x1.fe9af5b5e16fap+89 0x1.fe9af5b5e16fap+89))
(assert_return (invoke "f64x2.pmin" (v128.const f64x2 0x0123456789ABCDEFabcdef.p019 0x0123456789ABCDEFabcdef.p019)
                                    (v128.const f64x2 0123456789.e-019 0123456789.e-019))
                                    (v128.const f64x2 0x1.b25ffd62b4311p-37 0x1.b25ffd62b4311p-37))
(assert_return (invoke "f64x2.pmin" (v128.const f64x2 0x0123456789ABCDEFabcdef.p019 0x0123456789ABCDEFabcdef.p019)
                                    (v128.const f64x2 0123456789.0123456789 0123456789.0123456789))
                                    (v128.const f64x2 0x1.d6f34540ca458p+26 0x1.d6f34540ca458p+26))
(assert_return (invoke "f64x2.pmin" (v128.const f64x2 0x0123456789ABCDEFabcdef.p019 0x0123456789ABCDEFabcdef.p019)
                                    (v128.const f64x2 0123456789.0123456789e019 0123456789.0123456789e019))
                                    (v128.const f64x2 0x1.fe9af5b6bcbd5p+89 0x1.fe9af5b6bcbd5p+89))
(assert_return (invoke "f64x2.pmin" (v128.const f64x2 0x0123456789ABCDEFabcdef.p019 0x0123456789ABCDEFabcdef.p019)
                                    (v128.const f64x2 0123456789.0123456789e+019 0123456789.0123456789e+019))
                                    (v128.const f64x2 0x1.fe9af5b6bcbd5p+89 0x1.fe9af5b6bcbd5p+89))
(assert_return (invoke "f64x2.pmin" (v128.const f64x2 0x0123456789ABCDEFabcdef.p019 0x0123456789ABCDEFabcdef.p019)
                                    (v128.const f64x2 0123456789.0123456789e-019 0123456789.0123456789e-019))
                                    (v128.const f64x2 0x1.b25ffd636ec12p-37 0x1.b25ffd636ec12p-37))
(assert_return (invoke "f64x2.pmin" (v128.const f64x2 0x0123456789ABCDEFabcdef.p019 0x0123456789ABCDEFabcdef.p019)
                                    (v128.const f64x2 0x0123456789ABCDEFabcdef 0x0123456789ABCDEFabcdef))
                                    (v128.const f64x2 0x1.23456789abcdfp+80 0x1.23456789abcdfp+80))
(assert_return (invoke "f64x2.pmin" (v128.const f64x2 0x0123456789ABCDEFabcdef.p019 0x0123456789ABCDEFabcdef.p019)
                                    (v128.const f64x2 0x0123456789ABCDEFabcdefp019 0x0123456789ABCDEFabcdefp019))
                                    (v128.const f64x2 0x1.23456789abcdfp+99 0x1.23456789abcdfp+99))
(assert_return (invoke "f64x2.pmin" (v128.const f64x2 0x0123456789ABCDEFabcdef.p019 0x0123456789ABCDEFabcdef.p019)
                                    (v128.const f64x2 0x0123456789ABCDEFabcdefp+019 0x0123456789ABCDEFabcdefp+019))
                                    (v128.const f64x2 0x1.23456789abcdfp+99 0x1.23456789abcdfp+99))
(assert_return (invoke "f64x2.pmin" (v128.const f64x2 0x0123456789ABCDEFabcdef.p019 0x0123456789ABCDEFabcdef.p019)
                                    (v128.const f64x2 0x0123456789ABCDEFabcdefp-019 0x0123456789ABCDEFabcdefp-019))
                                    (v128.const f64x2 0x1.23456789abcdfp+61 0x1.23456789abcdfp+61))
(assert_return (invoke "f64x2.pmin" (v128.const f64x2 0x0123456789ABCDEFabcdef.p019 0x0123456789ABCDEFabcdef.p019)
                                    (v128.const f64x2 0x0123456789ABCDEFabcdef. 0x0123456789ABCDEFabcdef.))
                                    (v128.const f64x2 0x1.23456789abcdfp+80 0x1.23456789abcdfp+80))
(assert_return (invoke "f64x2.pmin" (v128.const f64x2 0x0123456789ABCDEFabcdef.p019 0x0123456789ABCDEFabcdef.p019)
                                    (v128.const f64x2 0x0123456789ABCDEFabcdef.p019 0x0123456789ABCDEFabcdef.p019))
                                    (v128.const f64x2 0x1.23456789abcdfp+99 0x1.23456789abcdfp+99))
(assert_return (invoke "f64x2.pmin" (v128.const f64x2 0x0123456789ABCDEFabcdef.p019 0x0123456789ABCDEFabcdef.p019)
                                    (v128.const f64x2 0x0123456789ABCDEFabcdef.p+019 0x0123456789ABCDEFabcdef.p+019))
                                    (v128.const f64x2 0x1.23456789abcdfp+99 0x1.23456789abcdfp+99))
(assert_return (invoke "f64x2.pmin" (v128.const f64x2 0x0123456789ABCDEFabcdef.p019 0x0123456789ABCDEFabcdef.p019)
                                    (v128.const f64x2 0x0123456789ABCDEFabcdef.p-019 0x0123456789ABCDEFabcdef.p-019))
                                    (v128.const f64x2 0x1.23456789abcdfp+61 0x1.23456789abcdfp+61))
(assert_return (invoke "f64x2.pmin" (v128.const f64x2 0x0123456789ABCDEFabcdef.p019 0x0123456789ABCDEFabcdef.p019)
                                    (v128.const f64x2 0x0123456789ABCDEFabcdef.0123456789ABCDEFabcdef 0x0123456789ABCDEFabcdef.0123456789ABCDEFabcdef))
                                    (v128.const f64x2 0x1.23456789abcdfp+80 0x1.23456789abcdfp+80))
(assert_return (invoke "f64x2.pmin" (v128.const f64x2 0x0123456789ABCDEFabcdef.p019 0x0123456789ABCDEFabcdef.p019)
                                    (v128.const f64x2 0x0123456789ABCDEFabcdef.0123456789ABCDEFabcdefp019 0x0123456789ABCDEFabcdef.0123456789ABCDEFabcdefp019))
                                    (v128.const f64x2 0x1.23456789abcdfp+99 0x1.23456789abcdfp+99))
(assert_return (invoke "f64x2.pmin" (v128.const f64x2 0x0123456789ABCDEFabcdef.p019 0x0123456789ABCDEFabcdef.p019)
                                    (v128.const f64x2 0x0123456789ABCDEFabcdef.0123456789ABCDEFabcdefp+019 0x0123456789ABCDEFabcdef.0123456789ABCDEFabcdefp+019))
                                    (v128.const f64x2 0x1.23456789abcdfp+99 0x1.23456789abcdfp+99))
(assert_return (invoke "f64x2.pmin" (v128.const f64x2 0x0123456789ABCDEFabcdef.p019 0x0123456789ABCDEFabcdef.p019)
                                    (v128.const f64x2 0x0123456789ABCDEFabcdef.0123456789ABCDEFabcdefp-019 0x0123456789ABCDEFabcdef.0123456789ABCDEFabcdefp-019))
                                    (v128.const f64x2 0x1.23456789abcdfp+61 0x1.23456789abcdfp+61))
(assert_return (invoke "f64x2.pmin" (v128.const f64x2 0x0123456789ABCDEFabcdef.p+019 0x0123456789ABCDEFabcdef.p+019)
                                    (v128.const f64x2 0x0p+0 0x0p+0))
                                    (v128.const f64x2 0x0.0p+0 0x0.0p+0))
(assert_return (invoke "f64x2.pmin" (v128.const f64x2 0x0123456789ABCDEFabcdef.p+019 0x0123456789ABCDEFabcdef.p+019)
                                    (v128.const f64x2 -0x0p+0 -0x0p+0))
                                    (v128.const f64x2 -0x0.0p+0 -0x0.0p+0))
(assert_return (invoke "f64x2.pmin" (v128.const f64x2 0x0123456789ABCDEFabcdef.p+019 0x0123456789ABCDEFabcdef.p+019)
                                    (v128.const f64x2 0x1p-1022 0x1p-1022))
                                    (v128.const f64x2 0x1.0000000000000p-1022 0x1.0000000000000p-1022))
(assert_return (invoke "f64x2.pmin" (v128.const f64x2 0x0123456789ABCDEFabcdef.p+019 0x0123456789ABCDEFabcdef.p+019)
                                    (v128.const f64x2 -0x1p-1022 -0x1p-1022))
                                    (v128.const f64x2 -0x1.0000000000000p-1022 -0x1.0000000000000p-1022))
(assert_return (invoke "f64x2.pmin" (v128.const f64x2 0x0123456789ABCDEFabcdef.p+019 0x0123456789ABCDEFabcdef.p+019)
                                    (v128.const f64x2 0x1p-1 0x1p-1))
                                    (v128.const f64x2 0x1.0000000000000p-1 0x1.0000000000000p-1))
(assert_return (invoke "f64x2.pmin" (v128.const f64x2 0x0123456789ABCDEFabcdef.p+019 0x0123456789ABCDEFabcdef.p+019)
                                    (v128.const f64x2 -0x1p-1 -0x1p-1))
                                    (v128.const f64x2 -0x1.0000000000000p-1 -0x1.0000000000000p-1))
(assert_return (invoke "f64x2.pmin" (v128.const f64x2 0x0123456789ABCDEFabcdef.p+019 0x0123456789ABCDEFabcdef.p+019)
                                    (v128.const f64x2 0x1p+0 0x1p+0))
                                    (v128.const f64x2 0x1.0000000000000p+0 0x1.0000000000000p+0))
(assert_return (invoke "f64x2.pmin" (v128.const f64x2 0x0123456789ABCDEFabcdef.p+019 0x0123456789ABCDEFabcdef.p+019)
                                    (v128.const f64x2 -0x1p+0 -0x1p+0))
                                    (v128.const f64x2 -0x1.0000000000000p+0 -0x1.0000000000000p+0))
(assert_return (invoke "f64x2.pmin" (v128.const f64x2 0x0123456789ABCDEFabcdef.p+019 0x0123456789ABCDEFabcdef.p+019)
                                    (v128.const f64x2 0x1.921fb54442d18p+2 0x1.921fb54442d18p+2))
                                    (v128.const f64x2 0x1.921fb54442d18p+2 0x1.921fb54442d18p+2))
(assert_return (invoke "f64x2.pmin" (v128.const f64x2 0x0123456789ABCDEFabcdef.p+019 0x0123456789ABCDEFabcdef.p+019)
                                    (v128.const f64x2 -0x1.921fb54442d18p+2 -0x1.921fb54442d18p+2))
                                    (v128.const f64x2 -0x1.921fb54442d18p+2 -0x1.921fb54442d18p+2))
(assert_return (invoke "f64x2.pmin" (v128.const f64x2 0x0123456789ABCDEFabcdef.p+019 0x0123456789ABCDEFabcdef.p+019)
                                    (v128.const f64x2 0x1.fffffffffffffp+1023 0x1.fffffffffffffp+1023))
                                    (v128.const f64x2 0x1.23456789abcdfp+99 0x1.23456789abcdfp+99))
(assert_return (invoke "f64x2.pmin" (v128.const f64x2 0x0123456789ABCDEFabcdef.p+019 0x0123456789ABCDEFabcdef.p+019)
                                    (v128.const f64x2 -0x1.fffffffffffffp+1023 -0x1.fffffffffffffp+1023))
                                    (v128.const f64x2 -0x1.fffffffffffffp+1023 -0x1.fffffffffffffp+1023))
(assert_return (invoke "f64x2.pmin" (v128.const f64x2 0x0123456789ABCDEFabcdef.p+019 0x0123456789ABCDEFabcdef.p+019)
                                    (v128.const f64x2 0x0.0000000000001p-1022 0x0.0000000000001p-1022))
                                    (v128.const f64x2 0x0.0000000000001p-1022 0x0.0000000000001p-1022))
(assert_return (invoke "f64x2.pmin" (v128.const f64x2 0x0123456789ABCDEFabcdef.p+019 0x0123456789ABCDEFabcdef.p+019)
                                    (v128.const f64x2 0x0.0000000000001p-1022 0x0.0000000000001p-1022))
                                    (v128.const f64x2 0x0.0000000000001p-1022 0x0.0000000000001p-1022))
(assert_return (invoke "f64x2.pmin" (v128.const f64x2 0x0123456789ABCDEFabcdef.p+019 0x0123456789ABCDEFabcdef.p+019)
                                    (v128.const f64x2 inf inf))
                                    (v128.const f64x2 0x1.23456789abcdfp+99 0x1.23456789abcdfp+99))
(assert_return (invoke "f64x2.pmin" (v128.const f64x2 0x0123456789ABCDEFabcdef.p+019 0x0123456789ABCDEFabcdef.p+019)
                                    (v128.const f64x2 -inf -inf))
                                    (v128.const f64x2 -inf -inf))
(assert_return (invoke "f64x2.pmin" (v128.const f64x2 0x0123456789ABCDEFabcdef.p+019 0x0123456789ABCDEFabcdef.p+019)
                                    (v128.const f64x2 0123456789 0123456789))
                                    (v128.const f64x2 0x1.d6f3454000000p+26 0x1.d6f3454000000p+26))
(assert_return (invoke "f64x2.pmin" (v128.const f64x2 0x0123456789ABCDEFabcdef.p+019 0x0123456789ABCDEFabcdef.p+019)
                                    (v128.const f64x2 0123456789e019 0123456789e019))
                                    (v128.const f64x2 0x1.fe9af5b5e16fap+89 0x1.fe9af5b5e16fap+89))
(assert_return (invoke "f64x2.pmin" (v128.const f64x2 0x0123456789ABCDEFabcdef.p+019 0x0123456789ABCDEFabcdef.p+019)
                                    (v128.const f64x2 0123456789e+019 0123456789e+019))
                                    (v128.const f64x2 0x1.fe9af5b5e16fap+89 0x1.fe9af5b5e16fap+89))
(assert_return (invoke "f64x2.pmin" (v128.const f64x2 0x0123456789ABCDEFabcdef.p+019 0x0123456789ABCDEFabcdef.p+019)
                                    (v128.const f64x2 0123456789e-019 0123456789e-019))
                                    (v128.const f64x2 0x1.b25ffd62b4311p-37 0x1.b25ffd62b4311p-37))
(assert_return (invoke "f64x2.pmin" (v128.const f64x2 0x0123456789ABCDEFabcdef.p+019 0x0123456789ABCDEFabcdef.p+019)
                                    (v128.const f64x2 0123456789. 0123456789.))
                                    (v128.const f64x2 0x1.d6f3454000000p+26 0x1.d6f3454000000p+26))
(assert_return (invoke "f64x2.pmin" (v128.const f64x2 0x0123456789ABCDEFabcdef.p+019 0x0123456789ABCDEFabcdef.p+019)
                                    (v128.const f64x2 0123456789.e019 0123456789.e019))
                                    (v128.const f64x2 0x1.fe9af5b5e16fap+89 0x1.fe9af5b5e16fap+89))
(assert_return (invoke "f64x2.pmin" (v128.const f64x2 0x0123456789ABCDEFabcdef.p+019 0x0123456789ABCDEFabcdef.p+019)
                                    (v128.const f64x2 0123456789.e+019 0123456789.e+019))
                                    (v128.const f64x2 0x1.fe9af5b5e16fap+89 0x1.fe9af5b5e16fap+89))
(assert_return (invoke "f64x2.pmin" (v128.const f64x2 0x0123456789ABCDEFabcdef.p+019 0x0123456789ABCDEFabcdef.p+019)
                                    (v128.const f64x2 0123456789.e-019 0123456789.e-019))
                                    (v128.const f64x2 0x1.b25ffd62b4311p-37 0x1.b25ffd62b4311p-37))
(assert_return (invoke "f64x2.pmin" (v128.const f64x2 0x0123456789ABCDEFabcdef.p+019 0x0123456789ABCDEFabcdef.p+019)
                                    (v128.const f64x2 0123456789.0123456789 0123456789.0123456789))
                                    (v128.const f64x2 0x1.d6f34540ca458p+26 0x1.d6f34540ca458p+26))
(assert_return (invoke "f64x2.pmin" (v128.const f64x2 0x0123456789ABCDEFabcdef.p+019 0x0123456789ABCDEFabcdef.p+019)
                                    (v128.const f64x2 0123456789.0123456789e019 0123456789.0123456789e019))
                                    (v128.const f64x2 0x1.fe9af5b6bcbd5p+89 0x1.fe9af5b6bcbd5p+89))
(assert_return (invoke "f64x2.pmin" (v128.const f64x2 0x0123456789ABCDEFabcdef.p+019 0x0123456789ABCDEFabcdef.p+019)
                                    (v128.const f64x2 0123456789.0123456789e+019 0123456789.0123456789e+019))
                                    (v128.const f64x2 0x1.fe9af5b6bcbd5p+89 0x1.fe9af5b6bcbd5p+89))
(assert_return (invoke "f64x2.pmin" (v128.const f64x2 0x0123456789ABCDEFabcdef.p+019 0x0123456789ABCDEFabcdef.p+019)
                                    (v128.const f64x2 0123456789.0123456789e-019 0123456789.0123456789e-019))
                                    (v128.const f64x2 0x1.b25ffd636ec12p-37 0x1.b25ffd636ec12p-37))
(assert_return (invoke "f64x2.pmin" (v128.const f64x2 0x0123456789ABCDEFabcdef.p+019 0x0123456789ABCDEFabcdef.p+019)
                                    (v128.const f64x2 0x0123456789ABCDEFabcdef 0x0123456789ABCDEFabcdef))
                                    (v128.const f64x2 0x1.23456789abcdfp+80 0x1.23456789abcdfp+80))
(assert_return (invoke "f64x2.pmin" (v128.const f64x2 0x0123456789ABCDEFabcdef.p+019 0x0123456789ABCDEFabcdef.p+019)
                                    (v128.const f64x2 0x0123456789ABCDEFabcdefp019 0x0123456789ABCDEFabcdefp019))
                                    (v128.const f64x2 0x1.23456789abcdfp+99 0x1.23456789abcdfp+99))
(assert_return (invoke "f64x2.pmin" (v128.const f64x2 0x0123456789ABCDEFabcdef.p+019 0x0123456789ABCDEFabcdef.p+019)
                                    (v128.const f64x2 0x0123456789ABCDEFabcdefp+019 0x0123456789ABCDEFabcdefp+019))
                                    (v128.const f64x2 0x1.23456789abcdfp+99 0x1.23456789abcdfp+99))
(assert_return (invoke "f64x2.pmin" (v128.const f64x2 0x0123456789ABCDEFabcdef.p+019 0x0123456789ABCDEFabcdef.p+019)
                                    (v128.const f64x2 0x0123456789ABCDEFabcdefp-019 0x0123456789ABCDEFabcdefp-019))
                                    (v128.const f64x2 0x1.23456789abcdfp+61 0x1.23456789abcdfp+61))
(assert_return (invoke "f64x2.pmin" (v128.const f64x2 0x0123456789ABCDEFabcdef.p+019 0x0123456789ABCDEFabcdef.p+019)
                                    (v128.const f64x2 0x0123456789ABCDEFabcdef. 0x0123456789ABCDEFabcdef.))
                                    (v128.const f64x2 0x1.23456789abcdfp+80 0x1.23456789abcdfp+80))
(assert_return (invoke "f64x2.pmin" (v128.const f64x2 0x0123456789ABCDEFabcdef.p+019 0x0123456789ABCDEFabcdef.p+019)
                                    (v128.const f64x2 0x0123456789ABCDEFabcdef.p019 0x0123456789ABCDEFabcdef.p019))
                                    (v128.const f64x2 0x1.23456789abcdfp+99 0x1.23456789abcdfp+99))
(assert_return (invoke "f64x2.pmin" (v128.const f64x2 0x0123456789ABCDEFabcdef.p+019 0x0123456789ABCDEFabcdef.p+019)
                                    (v128.const f64x2 0x0123456789ABCDEFabcdef.p+019 0x0123456789ABCDEFabcdef.p+019))
                                    (v128.const f64x2 0x1.23456789abcdfp+99 0x1.23456789abcdfp+99))
(assert_return (invoke "f64x2.pmin" (v128.const f64x2 0x0123456789ABCDEFabcdef.p+019 0x0123456789ABCDEFabcdef.p+019)
                                    (v128.const f64x2 0x0123456789ABCDEFabcdef.p-019 0x0123456789ABCDEFabcdef.p-019))
                                    (v128.const f64x2 0x1.23456789abcdfp+61 0x1.23456789abcdfp+61))
(assert_return (invoke "f64x2.pmin" (v128.const f64x2 0x0123456789ABCDEFabcdef.p+019 0x0123456789ABCDEFabcdef.p+019)
                                    (v128.const f64x2 0x0123456789ABCDEFabcdef.0123456789ABCDEFabcdef 0x0123456789ABCDEFabcdef.0123456789ABCDEFabcdef))
                                    (v128.const f64x2 0x1.23456789abcdfp+80 0x1.23456789abcdfp+80))
(assert_return (invoke "f64x2.pmin" (v128.const f64x2 0x0123456789ABCDEFabcdef.p+019 0x0123456789ABCDEFabcdef.p+019)
                                    (v128.const f64x2 0x0123456789ABCDEFabcdef.0123456789ABCDEFabcdefp019 0x0123456789ABCDEFabcdef.0123456789ABCDEFabcdefp019))
                                    (v128.const f64x2 0x1.23456789abcdfp+99 0x1.23456789abcdfp+99))
(assert_return (invoke "f64x2.pmin" (v128.const f64x2 0x0123456789ABCDEFabcdef.p+019 0x0123456789ABCDEFabcdef.p+019)
                                    (v128.const f64x2 0x0123456789ABCDEFabcdef.0123456789ABCDEFabcdefp+019 0x0123456789ABCDEFabcdef.0123456789ABCDEFabcdefp+019))
                                    (v128.const f64x2 0x1.23456789abcdfp+99 0x1.23456789abcdfp+99))
(assert_return (invoke "f64x2.pmin" (v128.const f64x2 0x0123456789ABCDEFabcdef.p+019 0x0123456789ABCDEFabcdef.p+019)
                                    (v128.const f64x2 0x0123456789ABCDEFabcdef.0123456789ABCDEFabcdefp-019 0x0123456789ABCDEFabcdef.0123456789ABCDEFabcdefp-019))
                                    (v128.const f64x2 0x1.23456789abcdfp+61 0x1.23456789abcdfp+61))
(assert_return (invoke "f64x2.pmin" (v128.const f64x2 0x0123456789ABCDEFabcdef.p-019 0x0123456789ABCDEFabcdef.p-019)
                                    (v128.const f64x2 0x0p+0 0x0p+0))
                                    (v128.const f64x2 0x0.0p+0 0x0.0p+0))
(assert_return (invoke "f64x2.pmin" (v128.const f64x2 0x0123456789ABCDEFabcdef.p-019 0x0123456789ABCDEFabcdef.p-019)
                                    (v128.const f64x2 -0x0p+0 -0x0p+0))
                                    (v128.const f64x2 -0x0.0p+0 -0x0.0p+0))
(assert_return (invoke "f64x2.pmin" (v128.const f64x2 0x0123456789ABCDEFabcdef.p-019 0x0123456789ABCDEFabcdef.p-019)
                                    (v128.const f64x2 0x1p-1022 0x1p-1022))
                                    (v128.const f64x2 0x1.0000000000000p-1022 0x1.0000000000000p-1022))
(assert_return (invoke "f64x2.pmin" (v128.const f64x2 0x0123456789ABCDEFabcdef.p-019 0x0123456789ABCDEFabcdef.p-019)
                                    (v128.const f64x2 -0x1p-1022 -0x1p-1022))
                                    (v128.const f64x2 -0x1.0000000000000p-1022 -0x1.0000000000000p-1022))
(assert_return (invoke "f64x2.pmin" (v128.const f64x2 0x0123456789ABCDEFabcdef.p-019 0x0123456789ABCDEFabcdef.p-019)
                                    (v128.const f64x2 0x1p-1 0x1p-1))
                                    (v128.const f64x2 0x1.0000000000000p-1 0x1.0000000000000p-1))
(assert_return (invoke "f64x2.pmin" (v128.const f64x2 0x0123456789ABCDEFabcdef.p-019 0x0123456789ABCDEFabcdef.p-019)
                                    (v128.const f64x2 -0x1p-1 -0x1p-1))
                                    (v128.const f64x2 -0x1.0000000000000p-1 -0x1.0000000000000p-1))
(assert_return (invoke "f64x2.pmin" (v128.const f64x2 0x0123456789ABCDEFabcdef.p-019 0x0123456789ABCDEFabcdef.p-019)
                                    (v128.const f64x2 0x1p+0 0x1p+0))
                                    (v128.const f64x2 0x1.0000000000000p+0 0x1.0000000000000p+0))
(assert_return (invoke "f64x2.pmin" (v128.const f64x2 0x0123456789ABCDEFabcdef.p-019 0x0123456789ABCDEFabcdef.p-019)
                                    (v128.const f64x2 -0x1p+0 -0x1p+0))
                                    (v128.const f64x2 -0x1.0000000000000p+0 -0x1.0000000000000p+0))
(assert_return (invoke "f64x2.pmin" (v128.const f64x2 0x0123456789ABCDEFabcdef.p-019 0x0123456789ABCDEFabcdef.p-019)
                                    (v128.const f64x2 0x1.921fb54442d18p+2 0x1.921fb54442d18p+2))
                                    (v128.const f64x2 0x1.921fb54442d18p+2 0x1.921fb54442d18p+2))
(assert_return (invoke "f64x2.pmin" (v128.const f64x2 0x0123456789ABCDEFabcdef.p-019 0x0123456789ABCDEFabcdef.p-019)
                                    (v128.const f64x2 -0x1.921fb54442d18p+2 -0x1.921fb54442d18p+2))
                                    (v128.const f64x2 -0x1.921fb54442d18p+2 -0x1.921fb54442d18p+2))
(assert_return (invoke "f64x2.pmin" (v128.const f64x2 0x0123456789ABCDEFabcdef.p-019 0x0123456789ABCDEFabcdef.p-019)
                                    (v128.const f64x2 0x1.fffffffffffffp+1023 0x1.fffffffffffffp+1023))
                                    (v128.const f64x2 0x1.23456789abcdfp+61 0x1.23456789abcdfp+61))
(assert_return (invoke "f64x2.pmin" (v128.const f64x2 0x0123456789ABCDEFabcdef.p-019 0x0123456789ABCDEFabcdef.p-019)
                                    (v128.const f64x2 -0x1.fffffffffffffp+1023 -0x1.fffffffffffffp+1023))
                                    (v128.const f64x2 -0x1.fffffffffffffp+1023 -0x1.fffffffffffffp+1023))
(assert_return (invoke "f64x2.pmin" (v128.const f64x2 0x0123456789ABCDEFabcdef.p-019 0x0123456789ABCDEFabcdef.p-019)
                                    (v128.const f64x2 0x0.0000000000001p-1022 0x0.0000000000001p-1022))
                                    (v128.const f64x2 0x0.0000000000001p-1022 0x0.0000000000001p-1022))
(assert_return (invoke "f64x2.pmin" (v128.const f64x2 0x0123456789ABCDEFabcdef.p-019 0x0123456789ABCDEFabcdef.p-019)
                                    (v128.const f64x2 0x0.0000000000001p-1022 0x0.0000000000001p-1022))
                                    (v128.const f64x2 0x0.0000000000001p-1022 0x0.0000000000001p-1022))
(assert_return (invoke "f64x2.pmin" (v128.const f64x2 0x0123456789ABCDEFabcdef.p-019 0x0123456789ABCDEFabcdef.p-019)
                                    (v128.const f64x2 inf inf))
                                    (v128.const f64x2 0x1.23456789abcdfp+61 0x1.23456789abcdfp+61))
(assert_return (invoke "f64x2.pmin" (v128.const f64x2 0x0123456789ABCDEFabcdef.p-019 0x0123456789ABCDEFabcdef.p-019)
                                    (v128.const f64x2 -inf -inf))
                                    (v128.const f64x2 -inf -inf))
(assert_return (invoke "f64x2.pmin" (v128.const f64x2 0x0123456789ABCDEFabcdef.p-019 0x0123456789ABCDEFabcdef.p-019)
                                    (v128.const f64x2 0123456789 0123456789))
                                    (v128.const f64x2 0x1.d6f3454000000p+26 0x1.d6f3454000000p+26))
(assert_return (invoke "f64x2.pmin" (v128.const f64x2 0x0123456789ABCDEFabcdef.p-019 0x0123456789ABCDEFabcdef.p-019)
                                    (v128.const f64x2 0123456789e019 0123456789e019))
                                    (v128.const f64x2 0x1.23456789abcdfp+61 0x1.23456789abcdfp+61))
(assert_return (invoke "f64x2.pmin" (v128.const f64x2 0x0123456789ABCDEFabcdef.p-019 0x0123456789ABCDEFabcdef.p-019)
                                    (v128.const f64x2 0123456789e+019 0123456789e+019))
                                    (v128.const f64x2 0x1.23456789abcdfp+61 0x1.23456789abcdfp+61))
(assert_return (invoke "f64x2.pmin" (v128.const f64x2 0x0123456789ABCDEFabcdef.p-019 0x0123456789ABCDEFabcdef.p-019)
                                    (v128.const f64x2 0123456789e-019 0123456789e-019))
                                    (v128.const f64x2 0x1.b25ffd62b4311p-37 0x1.b25ffd62b4311p-37))
(assert_return (invoke "f64x2.pmin" (v128.const f64x2 0x0123456789ABCDEFabcdef.p-019 0x0123456789ABCDEFabcdef.p-019)
                                    (v128.const f64x2 0123456789. 0123456789.))
                                    (v128.const f64x2 0x1.d6f3454000000p+26 0x1.d6f3454000000p+26))
(assert_return (invoke "f64x2.pmin" (v128.const f64x2 0x0123456789ABCDEFabcdef.p-019 0x0123456789ABCDEFabcdef.p-019)
                                    (v128.const f64x2 0123456789.e019 0123456789.e019))
                                    (v128.const f64x2 0x1.23456789abcdfp+61 0x1.23456789abcdfp+61))
(assert_return (invoke "f64x2.pmin" (v128.const f64x2 0x0123456789ABCDEFabcdef.p-019 0x0123456789ABCDEFabcdef.p-019)
                                    (v128.const f64x2 0123456789.e+019 0123456789.e+019))
                                    (v128.const f64x2 0x1.23456789abcdfp+61 0x1.23456789abcdfp+61))
(assert_return (invoke "f64x2.pmin" (v128.const f64x2 0x0123456789ABCDEFabcdef.p-019 0x0123456789ABCDEFabcdef.p-019)
                                    (v128.const f64x2 0123456789.e-019 0123456789.e-019))
                                    (v128.const f64x2 0x1.b25ffd62b4311p-37 0x1.b25ffd62b4311p-37))
(assert_return (invoke "f64x2.pmin" (v128.const f64x2 0x0123456789ABCDEFabcdef.p-019 0x0123456789ABCDEFabcdef.p-019)
                                    (v128.const f64x2 0123456789.0123456789 0123456789.0123456789))
                                    (v128.const f64x2 0x1.d6f34540ca458p+26 0x1.d6f34540ca458p+26))
(assert_return (invoke "f64x2.pmin" (v128.const f64x2 0x0123456789ABCDEFabcdef.p-019 0x0123456789ABCDEFabcdef.p-019)
                                    (v128.const f64x2 0123456789.0123456789e019 0123456789.0123456789e019))
                                    (v128.const f64x2 0x1.23456789abcdfp+61 0x1.23456789abcdfp+61))
(assert_return (invoke "f64x2.pmin" (v128.const f64x2 0x0123456789ABCDEFabcdef.p-019 0x0123456789ABCDEFabcdef.p-019)
                                    (v128.const f64x2 0123456789.0123456789e+019 0123456789.0123456789e+019))
                                    (v128.const f64x2 0x1.23456789abcdfp+61 0x1.23456789abcdfp+61))
(assert_return (invoke "f64x2.pmin" (v128.const f64x2 0x0123456789ABCDEFabcdef.p-019 0x0123456789ABCDEFabcdef.p-019)
                                    (v128.const f64x2 0123456789.0123456789e-019 0123456789.0123456789e-019))
                                    (v128.const f64x2 0x1.b25ffd636ec12p-37 0x1.b25ffd636ec12p-37))
(assert_return (invoke "f64x2.pmin" (v128.const f64x2 0x0123456789ABCDEFabcdef.p-019 0x0123456789ABCDEFabcdef.p-019)
                                    (v128.const f64x2 0x0123456789ABCDEFabcdef 0x0123456789ABCDEFabcdef))
                                    (v128.const f64x2 0x1.23456789abcdfp+61 0x1.23456789abcdfp+61))
(assert_return (invoke "f64x2.pmin" (v128.const f64x2 0x0123456789ABCDEFabcdef.p-019 0x0123456789ABCDEFabcdef.p-019)
                                    (v128.const f64x2 0x0123456789ABCDEFabcdefp019 0x0123456789ABCDEFabcdefp019))
                                    (v128.const f64x2 0x1.23456789abcdfp+61 0x1.23456789abcdfp+61))
(assert_return (invoke "f64x2.pmin" (v128.const f64x2 0x0123456789ABCDEFabcdef.p-019 0x0123456789ABCDEFabcdef.p-019)
                                    (v128.const f64x2 0x0123456789ABCDEFabcdefp+019 0x0123456789ABCDEFabcdefp+019))
                                    (v128.const f64x2 0x1.23456789abcdfp+61 0x1.23456789abcdfp+61))
(assert_return (invoke "f64x2.pmin" (v128.const f64x2 0x0123456789ABCDEFabcdef.p-019 0x0123456789ABCDEFabcdef.p-019)
                                    (v128.const f64x2 0x0123456789ABCDEFabcdefp-019 0x0123456789ABCDEFabcdefp-019))
                                    (v128.const f64x2 0x1.23456789abcdfp+61 0x1.23456789abcdfp+61))
(assert_return (invoke "f64x2.pmin" (v128.const f64x2 0x0123456789ABCDEFabcdef.p-019 0x0123456789ABCDEFabcdef.p-019)
                                    (v128.const f64x2 0x0123456789ABCDEFabcdef. 0x0123456789ABCDEFabcdef.))
                                    (v128.const f64x2 0x1.23456789abcdfp+61 0x1.23456789abcdfp+61))
(assert_return (invoke "f64x2.pmin" (v128.const f64x2 0x0123456789ABCDEFabcdef.p-019 0x0123456789ABCDEFabcdef.p-019)
                                    (v128.const f64x2 0x0123456789ABCDEFabcdef.p019 0x0123456789ABCDEFabcdef.p019))
                                    (v128.const f64x2 0x1.23456789abcdfp+61 0x1.23456789abcdfp+61))
(assert_return (invoke "f64x2.pmin" (v128.const f64x2 0x0123456789ABCDEFabcdef.p-019 0x0123456789ABCDEFabcdef.p-019)
                                    (v128.const f64x2 0x0123456789ABCDEFabcdef.p+019 0x0123456789ABCDEFabcdef.p+019))
                                    (v128.const f64x2 0x1.23456789abcdfp+61 0x1.23456789abcdfp+61))
(assert_return (invoke "f64x2.pmin" (v128.const f64x2 0x0123456789ABCDEFabcdef.p-019 0x0123456789ABCDEFabcdef.p-019)
                                    (v128.const f64x2 0x0123456789ABCDEFabcdef.p-019 0x0123456789ABCDEFabcdef.p-019))
                                    (v128.const f64x2 0x1.23456789abcdfp+61 0x1.23456789abcdfp+61))
(assert_return (invoke "f64x2.pmin" (v128.const f64x2 0x0123456789ABCDEFabcdef.p-019 0x0123456789ABCDEFabcdef.p-019)
                                    (v128.const f64x2 0x0123456789ABCDEFabcdef.0123456789ABCDEFabcdef 0x0123456789ABCDEFabcdef.0123456789ABCDEFabcdef))
                                    (v128.const f64x2 0x1.23456789abcdfp+61 0x1.23456789abcdfp+61))
(assert_return (invoke "f64x2.pmin" (v128.const f64x2 0x0123456789ABCDEFabcdef.p-019 0x0123456789ABCDEFabcdef.p-019)
                                    (v128.const f64x2 0x0123456789ABCDEFabcdef.0123456789ABCDEFabcdefp019 0x0123456789ABCDEFabcdef.0123456789ABCDEFabcdefp019))
                                    (v128.const f64x2 0x1.23456789abcdfp+61 0x1.23456789abcdfp+61))
(assert_return (invoke "f64x2.pmin" (v128.const f64x2 0x0123456789ABCDEFabcdef.p-019 0x0123456789ABCDEFabcdef.p-019)
                                    (v128.const f64x2 0x0123456789ABCDEFabcdef.0123456789ABCDEFabcdefp+019 0x0123456789ABCDEFabcdef.0123456789ABCDEFabcdefp+019))
                                    (v128.const f64x2 0x1.23456789abcdfp+61 0x1.23456789abcdfp+61))
(assert_return (invoke "f64x2.pmin" (v128.const f64x2 0x0123456789ABCDEFabcdef.p-019 0x0123456789ABCDEFabcdef.p-019)
                                    (v128.const f64x2 0x0123456789ABCDEFabcdef.0123456789ABCDEFabcdefp-019 0x0123456789ABCDEFabcdef.0123456789ABCDEFabcdefp-019))
                                    (v128.const f64x2 0x1.23456789abcdfp+61 0x1.23456789abcdfp+61))
(assert_return (invoke "f64x2.pmin" (v128.const f64x2 0x0123456789ABCDEFabcdef.0123456789ABCDEFabcdef 0x0123456789ABCDEFabcdef.0123456789ABCDEFabcdef)
                                    (v128.const f64x2 0x0p+0 0x0p+0))
                                    (v128.const f64x2 0x0.0p+0 0x0.0p+0))
(assert_return (invoke "f64x2.pmin" (v128.const f64x2 0x0123456789ABCDEFabcdef.0123456789ABCDEFabcdef 0x0123456789ABCDEFabcdef.0123456789ABCDEFabcdef)
                                    (v128.const f64x2 -0x0p+0 -0x0p+0))
                                    (v128.const f64x2 -0x0.0p+0 -0x0.0p+0))
(assert_return (invoke "f64x2.pmin" (v128.const f64x2 0x0123456789ABCDEFabcdef.0123456789ABCDEFabcdef 0x0123456789ABCDEFabcdef.0123456789ABCDEFabcdef)
                                    (v128.const f64x2 0x1p-1022 0x1p-1022))
                                    (v128.const f64x2 0x1.0000000000000p-1022 0x1.0000000000000p-1022))
(assert_return (invoke "f64x2.pmin" (v128.const f64x2 0x0123456789ABCDEFabcdef.0123456789ABCDEFabcdef 0x0123456789ABCDEFabcdef.0123456789ABCDEFabcdef)
                                    (v128.const f64x2 -0x1p-1022 -0x1p-1022))
                                    (v128.const f64x2 -0x1.0000000000000p-1022 -0x1.0000000000000p-1022))
(assert_return (invoke "f64x2.pmin" (v128.const f64x2 0x0123456789ABCDEFabcdef.0123456789ABCDEFabcdef 0x0123456789ABCDEFabcdef.0123456789ABCDEFabcdef)
                                    (v128.const f64x2 0x1p-1 0x1p-1))
                                    (v128.const f64x2 0x1.0000000000000p-1 0x1.0000000000000p-1))
(assert_return (invoke "f64x2.pmin" (v128.const f64x2 0x0123456789ABCDEFabcdef.0123456789ABCDEFabcdef 0x0123456789ABCDEFabcdef.0123456789ABCDEFabcdef)
                                    (v128.const f64x2 -0x1p-1 -0x1p-1))
                                    (v128.const f64x2 -0x1.0000000000000p-1 -0x1.0000000000000p-1))
(assert_return (invoke "f64x2.pmin" (v128.const f64x2 0x0123456789ABCDEFabcdef.0123456789ABCDEFabcdef 0x0123456789ABCDEFabcdef.0123456789ABCDEFabcdef)
                                    (v128.const f64x2 0x1p+0 0x1p+0))
                                    (v128.const f64x2 0x1.0000000000000p+0 0x1.0000000000000p+0))
(assert_return (invoke "f64x2.pmin" (v128.const f64x2 0x0123456789ABCDEFabcdef.0123456789ABCDEFabcdef 0x0123456789ABCDEFabcdef.0123456789ABCDEFabcdef)
                                    (v128.const f64x2 -0x1p+0 -0x1p+0))
                                    (v128.const f64x2 -0x1.0000000000000p+0 -0x1.0000000000000p+0))
(assert_return (invoke "f64x2.pmin" (v128.const f64x2 0x0123456789ABCDEFabcdef.0123456789ABCDEFabcdef 0x0123456789ABCDEFabcdef.0123456789ABCDEFabcdef)
                                    (v128.const f64x2 0x1.921fb54442d18p+2 0x1.921fb54442d18p+2))
                                    (v128.const f64x2 0x1.921fb54442d18p+2 0x1.921fb54442d18p+2))
(assert_return (invoke "f64x2.pmin" (v128.const f64x2 0x0123456789ABCDEFabcdef.0123456789ABCDEFabcdef 0x0123456789ABCDEFabcdef.0123456789ABCDEFabcdef)
                                    (v128.const f64x2 -0x1.921fb54442d18p+2 -0x1.921fb54442d18p+2))
                                    (v128.const f64x2 -0x1.921fb54442d18p+2 -0x1.921fb54442d18p+2))
(assert_return (invoke "f64x2.pmin" (v128.const f64x2 0x0123456789ABCDEFabcdef.0123456789ABCDEFabcdef 0x0123456789ABCDEFabcdef.0123456789ABCDEFabcdef)
                                    (v128.const f64x2 0x1.fffffffffffffp+1023 0x1.fffffffffffffp+1023))
                                    (v128.const f64x2 0x1.23456789abcdfp+80 0x1.23456789abcdfp+80))
(assert_return (invoke "f64x2.pmin" (v128.const f64x2 0x0123456789ABCDEFabcdef.0123456789ABCDEFabcdef 0x0123456789ABCDEFabcdef.0123456789ABCDEFabcdef)
                                    (v128.const f64x2 -0x1.fffffffffffffp+1023 -0x1.fffffffffffffp+1023))
                                    (v128.const f64x2 -0x1.fffffffffffffp+1023 -0x1.fffffffffffffp+1023))
(assert_return (invoke "f64x2.pmin" (v128.const f64x2 0x0123456789ABCDEFabcdef.0123456789ABCDEFabcdef 0x0123456789ABCDEFabcdef.0123456789ABCDEFabcdef)
                                    (v128.const f64x2 0x0.0000000000001p-1022 0x0.0000000000001p-1022))
                                    (v128.const f64x2 0x0.0000000000001p-1022 0x0.0000000000001p-1022))
(assert_return (invoke "f64x2.pmin" (v128.const f64x2 0x0123456789ABCDEFabcdef.0123456789ABCDEFabcdef 0x0123456789ABCDEFabcdef.0123456789ABCDEFabcdef)
                                    (v128.const f64x2 0x0.0000000000001p-1022 0x0.0000000000001p-1022))
                                    (v128.const f64x2 0x0.0000000000001p-1022 0x0.0000000000001p-1022))
(assert_return (invoke "f64x2.pmin" (v128.const f64x2 0x0123456789ABCDEFabcdef.0123456789ABCDEFabcdef 0x0123456789ABCDEFabcdef.0123456789ABCDEFabcdef)
                                    (v128.const f64x2 inf inf))
                                    (v128.const f64x2 0x1.23456789abcdfp+80 0x1.23456789abcdfp+80))
(assert_return (invoke "f64x2.pmin" (v128.const f64x2 0x0123456789ABCDEFabcdef.0123456789ABCDEFabcdef 0x0123456789ABCDEFabcdef.0123456789ABCDEFabcdef)
                                    (v128.const f64x2 -inf -inf))
                                    (v128.const f64x2 -inf -inf))
(assert_return (invoke "f64x2.pmin" (v128.const f64x2 0x0123456789ABCDEFabcdef.0123456789ABCDEFabcdef 0x0123456789ABCDEFabcdef.0123456789ABCDEFabcdef)
                                    (v128.const f64x2 0123456789 0123456789))
                                    (v128.const f64x2 0x1.d6f3454000000p+26 0x1.d6f3454000000p+26))
(assert_return (invoke "f64x2.pmin" (v128.const f64x2 0x0123456789ABCDEFabcdef.0123456789ABCDEFabcdef 0x0123456789ABCDEFabcdef.0123456789ABCDEFabcdef)
                                    (v128.const f64x2 0123456789e019 0123456789e019))
                                    (v128.const f64x2 0x1.23456789abcdfp+80 0x1.23456789abcdfp+80))
(assert_return (invoke "f64x2.pmin" (v128.const f64x2 0x0123456789ABCDEFabcdef.0123456789ABCDEFabcdef 0x0123456789ABCDEFabcdef.0123456789ABCDEFabcdef)
                                    (v128.const f64x2 0123456789e+019 0123456789e+019))
                                    (v128.const f64x2 0x1.23456789abcdfp+80 0x1.23456789abcdfp+80))
(assert_return (invoke "f64x2.pmin" (v128.const f64x2 0x0123456789ABCDEFabcdef.0123456789ABCDEFabcdef 0x0123456789ABCDEFabcdef.0123456789ABCDEFabcdef)
                                    (v128.const f64x2 0123456789e-019 0123456789e-019))
                                    (v128.const f64x2 0x1.b25ffd62b4311p-37 0x1.b25ffd62b4311p-37))
(assert_return (invoke "f64x2.pmin" (v128.const f64x2 0x0123456789ABCDEFabcdef.0123456789ABCDEFabcdef 0x0123456789ABCDEFabcdef.0123456789ABCDEFabcdef)
                                    (v128.const f64x2 0123456789. 0123456789.))
                                    (v128.const f64x2 0x1.d6f3454000000p+26 0x1.d6f3454000000p+26))
(assert_return (invoke "f64x2.pmin" (v128.const f64x2 0x0123456789ABCDEFabcdef.0123456789ABCDEFabcdef 0x0123456789ABCDEFabcdef.0123456789ABCDEFabcdef)
                                    (v128.const f64x2 0123456789.e019 0123456789.e019))
                                    (v128.const f64x2 0x1.23456789abcdfp+80 0x1.23456789abcdfp+80))
(assert_return (invoke "f64x2.pmin" (v128.const f64x2 0x0123456789ABCDEFabcdef.0123456789ABCDEFabcdef 0x0123456789ABCDEFabcdef.0123456789ABCDEFabcdef)
                                    (v128.const f64x2 0123456789.e+019 0123456789.e+019))
                                    (v128.const f64x2 0x1.23456789abcdfp+80 0x1.23456789abcdfp+80))
(assert_return (invoke "f64x2.pmin" (v128.const f64x2 0x0123456789ABCDEFabcdef.0123456789ABCDEFabcdef 0x0123456789ABCDEFabcdef.0123456789ABCDEFabcdef)
                                    (v128.const f64x2 0123456789.e-019 0123456789.e-019))
                                    (v128.const f64x2 0x1.b25ffd62b4311p-37 0x1.b25ffd62b4311p-37))
(assert_return (invoke "f64x2.pmin" (v128.const f64x2 0x0123456789ABCDEFabcdef.0123456789ABCDEFabcdef 0x0123456789ABCDEFabcdef.0123456789ABCDEFabcdef)
                                    (v128.const f64x2 0123456789.0123456789 0123456789.0123456789))
                                    (v128.const f64x2 0x1.d6f34540ca458p+26 0x1.d6f34540ca458p+26))
(assert_return (invoke "f64x2.pmin" (v128.const f64x2 0x0123456789ABCDEFabcdef.0123456789ABCDEFabcdef 0x0123456789ABCDEFabcdef.0123456789ABCDEFabcdef)
                                    (v128.const f64x2 0123456789.0123456789e019 0123456789.0123456789e019))
                                    (v128.const f64x2 0x1.23456789abcdfp+80 0x1.23456789abcdfp+80))
(assert_return (invoke "f64x2.pmin" (v128.const f64x2 0x0123456789ABCDEFabcdef.0123456789ABCDEFabcdef 0x0123456789ABCDEFabcdef.0123456789ABCDEFabcdef)
                                    (v128.const f64x2 0123456789.0123456789e+019 0123456789.0123456789e+019))
                                    (v128.const f64x2 0x1.23456789abcdfp+80 0x1.23456789abcdfp+80))
(assert_return (invoke "f64x2.pmin" (v128.const f64x2 0x0123456789ABCDEFabcdef.0123456789ABCDEFabcdef 0x0123456789ABCDEFabcdef.0123456789ABCDEFabcdef)
                                    (v128.const f64x2 0123456789.0123456789e-019 0123456789.0123456789e-019))
                                    (v128.const f64x2 0x1.b25ffd636ec12p-37 0x1.b25ffd636ec12p-37))
(assert_return (invoke "f64x2.pmin" (v128.const f64x2 0x0123456789ABCDEFabcdef.0123456789ABCDEFabcdef 0x0123456789ABCDEFabcdef.0123456789ABCDEFabcdef)
                                    (v128.const f64x2 0x0123456789ABCDEFabcdef 0x0123456789ABCDEFabcdef))
                                    (v128.const f64x2 0x1.23456789abcdfp+80 0x1.23456789abcdfp+80))
(assert_return (invoke "f64x2.pmin" (v128.const f64x2 0x0123456789ABCDEFabcdef.0123456789ABCDEFabcdef 0x0123456789ABCDEFabcdef.0123456789ABCDEFabcdef)
                                    (v128.const f64x2 0x0123456789ABCDEFabcdefp019 0x0123456789ABCDEFabcdefp019))
                                    (v128.const f64x2 0x1.23456789abcdfp+80 0x1.23456789abcdfp+80))
(assert_return (invoke "f64x2.pmin" (v128.const f64x2 0x0123456789ABCDEFabcdef.0123456789ABCDEFabcdef 0x0123456789ABCDEFabcdef.0123456789ABCDEFabcdef)
                                    (v128.const f64x2 0x0123456789ABCDEFabcdefp+019 0x0123456789ABCDEFabcdefp+019))
                                    (v128.const f64x2 0x1.23456789abcdfp+80 0x1.23456789abcdfp+80))
(assert_return (invoke "f64x2.pmin" (v128.const f64x2 0x0123456789ABCDEFabcdef.0123456789ABCDEFabcdef 0x0123456789ABCDEFabcdef.0123456789ABCDEFabcdef)
                                    (v128.const f64x2 0x0123456789ABCDEFabcdefp-019 0x0123456789ABCDEFabcdefp-019))
                                    (v128.const f64x2 0x1.23456789abcdfp+61 0x1.23456789abcdfp+61))
(assert_return (invoke "f64x2.pmin" (v128.const f64x2 0x0123456789ABCDEFabcdef.0123456789ABCDEFabcdef 0x0123456789ABCDEFabcdef.0123456789ABCDEFabcdef)
                                    (v128.const f64x2 0x0123456789ABCDEFabcdef. 0x0123456789ABCDEFabcdef.))
                                    (v128.const f64x2 0x1.23456789abcdfp+80 0x1.23456789abcdfp+80))
(assert_return (invoke "f64x2.pmin" (v128.const f64x2 0x0123456789ABCDEFabcdef.0123456789ABCDEFabcdef 0x0123456789ABCDEFabcdef.0123456789ABCDEFabcdef)
                                    (v128.const f64x2 0x0123456789ABCDEFabcdef.p019 0x0123456789ABCDEFabcdef.p019))
                                    (v128.const f64x2 0x1.23456789abcdfp+80 0x1.23456789abcdfp+80))
(assert_return (invoke "f64x2.pmin" (v128.const f64x2 0x0123456789ABCDEFabcdef.0123456789ABCDEFabcdef 0x0123456789ABCDEFabcdef.0123456789ABCDEFabcdef)
                                    (v128.const f64x2 0x0123456789ABCDEFabcdef.p+019 0x0123456789ABCDEFabcdef.p+019))
                                    (v128.const f64x2 0x1.23456789abcdfp+80 0x1.23456789abcdfp+80))
(assert_return (invoke "f64x2.pmin" (v128.const f64x2 0x0123456789ABCDEFabcdef.0123456789ABCDEFabcdef 0x0123456789ABCDEFabcdef.0123456789ABCDEFabcdef)
                                    (v128.const f64x2 0x0123456789ABCDEFabcdef.p-019 0x0123456789ABCDEFabcdef.p-019))
                                    (v128.const f64x2 0x1.23456789abcdfp+61 0x1.23456789abcdfp+61))
(assert_return (invoke "f64x2.pmin" (v128.const f64x2 0x0123456789ABCDEFabcdef.0123456789ABCDEFabcdef 0x0123456789ABCDEFabcdef.0123456789ABCDEFabcdef)
                                    (v128.const f64x2 0x0123456789ABCDEFabcdef.0123456789ABCDEFabcdef 0x0123456789ABCDEFabcdef.0123456789ABCDEFabcdef))
                                    (v128.const f64x2 0x1.23456789abcdfp+80 0x1.23456789abcdfp+80))
(assert_return (invoke "f64x2.pmin" (v128.const f64x2 0x0123456789ABCDEFabcdef.0123456789ABCDEFabcdef 0x0123456789ABCDEFabcdef.0123456789ABCDEFabcdef)
                                    (v128.const f64x2 0x0123456789ABCDEFabcdef.0123456789ABCDEFabcdefp019 0x0123456789ABCDEFabcdef.0123456789ABCDEFabcdefp019))
                                    (v128.const f64x2 0x1.23456789abcdfp+80 0x1.23456789abcdfp+80))
(assert_return (invoke "f64x2.pmin" (v128.const f64x2 0x0123456789ABCDEFabcdef.0123456789ABCDEFabcdef 0x0123456789ABCDEFabcdef.0123456789ABCDEFabcdef)
                                    (v128.const f64x2 0x0123456789ABCDEFabcdef.0123456789ABCDEFabcdefp+019 0x0123456789ABCDEFabcdef.0123456789ABCDEFabcdefp+019))
                                    (v128.const f64x2 0x1.23456789abcdfp+80 0x1.23456789abcdfp+80))
(assert_return (invoke "f64x2.pmin" (v128.const f64x2 0x0123456789ABCDEFabcdef.0123456789ABCDEFabcdef 0x0123456789ABCDEFabcdef.0123456789ABCDEFabcdef)
                                    (v128.const f64x2 0x0123456789ABCDEFabcdef.0123456789ABCDEFabcdefp-019 0x0123456789ABCDEFabcdef.0123456789ABCDEFabcdefp-019))
                                    (v128.const f64x2 0x1.23456789abcdfp+61 0x1.23456789abcdfp+61))
(assert_return (invoke "f64x2.pmin" (v128.const f64x2 0x0123456789ABCDEFabcdef.0123456789ABCDEFabcdefp019 0x0123456789ABCDEFabcdef.0123456789ABCDEFabcdefp019)
                                    (v128.const f64x2 0x0p+0 0x0p+0))
                                    (v128.const f64x2 0x0.0p+0 0x0.0p+0))
(assert_return (invoke "f64x2.pmin" (v128.const f64x2 0x0123456789ABCDEFabcdef.0123456789ABCDEFabcdefp019 0x0123456789ABCDEFabcdef.0123456789ABCDEFabcdefp019)
                                    (v128.const f64x2 -0x0p+0 -0x0p+0))
                                    (v128.const f64x2 -0x0.0p+0 -0x0.0p+0))
(assert_return (invoke "f64x2.pmin" (v128.const f64x2 0x0123456789ABCDEFabcdef.0123456789ABCDEFabcdefp019 0x0123456789ABCDEFabcdef.0123456789ABCDEFabcdefp019)
                                    (v128.const f64x2 0x1p-1022 0x1p-1022))
                                    (v128.const f64x2 0x1.0000000000000p-1022 0x1.0000000000000p-1022))
(assert_return (invoke "f64x2.pmin" (v128.const f64x2 0x0123456789ABCDEFabcdef.0123456789ABCDEFabcdefp019 0x0123456789ABCDEFabcdef.0123456789ABCDEFabcdefp019)
                                    (v128.const f64x2 -0x1p-1022 -0x1p-1022))
                                    (v128.const f64x2 -0x1.0000000000000p-1022 -0x1.0000000000000p-1022))
(assert_return (invoke "f64x2.pmin" (v128.const f64x2 0x0123456789ABCDEFabcdef.0123456789ABCDEFabcdefp019 0x0123456789ABCDEFabcdef.0123456789ABCDEFabcdefp019)
                                    (v128.const f64x2 0x1p-1 0x1p-1))
                                    (v128.const f64x2 0x1.0000000000000p-1 0x1.0000000000000p-1))
(assert_return (invoke "f64x2.pmin" (v128.const f64x2 0x0123456789ABCDEFabcdef.0123456789ABCDEFabcdefp019 0x0123456789ABCDEFabcdef.0123456789ABCDEFabcdefp019)
                                    (v128.const f64x2 -0x1p-1 -0x1p-1))
                                    (v128.const f64x2 -0x1.0000000000000p-1 -0x1.0000000000000p-1))
(assert_return (invoke "f64x2.pmin" (v128.const f64x2 0x0123456789ABCDEFabcdef.0123456789ABCDEFabcdefp019 0x0123456789ABCDEFabcdef.0123456789ABCDEFabcdefp019)
                                    (v128.const f64x2 0x1p+0 0x1p+0))
                                    (v128.const f64x2 0x1.0000000000000p+0 0x1.0000000000000p+0))
(assert_return (invoke "f64x2.pmin" (v128.const f64x2 0x0123456789ABCDEFabcdef.0123456789ABCDEFabcdefp019 0x0123456789ABCDEFabcdef.0123456789ABCDEFabcdefp019)
                                    (v128.const f64x2 -0x1p+0 -0x1p+0))
                                    (v128.const f64x2 -0x1.0000000000000p+0 -0x1.0000000000000p+0))
(assert_return (invoke "f64x2.pmin" (v128.const f64x2 0x0123456789ABCDEFabcdef.0123456789ABCDEFabcdefp019 0x0123456789ABCDEFabcdef.0123456789ABCDEFabcdefp019)
                                    (v128.const f64x2 0x1.921fb54442d18p+2 0x1.921fb54442d18p+2))
                                    (v128.const f64x2 0x1.921fb54442d18p+2 0x1.921fb54442d18p+2))
(assert_return (invoke "f64x2.pmin" (v128.const f64x2 0x0123456789ABCDEFabcdef.0123456789ABCDEFabcdefp019 0x0123456789ABCDEFabcdef.0123456789ABCDEFabcdefp019)
                                    (v128.const f64x2 -0x1.921fb54442d18p+2 -0x1.921fb54442d18p+2))
                                    (v128.const f64x2 -0x1.921fb54442d18p+2 -0x1.921fb54442d18p+2))
(assert_return (invoke "f64x2.pmin" (v128.const f64x2 0x0123456789ABCDEFabcdef.0123456789ABCDEFabcdefp019 0x0123456789ABCDEFabcdef.0123456789ABCDEFabcdefp019)
                                    (v128.const f64x2 0x1.fffffffffffffp+1023 0x1.fffffffffffffp+1023))
                                    (v128.const f64x2 0x1.23456789abcdfp+99 0x1.23456789abcdfp+99))
(assert_return (invoke "f64x2.pmin" (v128.const f64x2 0x0123456789ABCDEFabcdef.0123456789ABCDEFabcdefp019 0x0123456789ABCDEFabcdef.0123456789ABCDEFabcdefp019)
                                    (v128.const f64x2 -0x1.fffffffffffffp+1023 -0x1.fffffffffffffp+1023))
                                    (v128.const f64x2 -0x1.fffffffffffffp+1023 -0x1.fffffffffffffp+1023))
(assert_return (invoke "f64x2.pmin" (v128.const f64x2 0x0123456789ABCDEFabcdef.0123456789ABCDEFabcdefp019 0x0123456789ABCDEFabcdef.0123456789ABCDEFabcdefp019)
                                    (v128.const f64x2 0x0.0000000000001p-1022 0x0.0000000000001p-1022))
                                    (v128.const f64x2 0x0.0000000000001p-1022 0x0.0000000000001p-1022))
(assert_return (invoke "f64x2.pmin" (v128.const f64x2 0x0123456789ABCDEFabcdef.0123456789ABCDEFabcdefp019 0x0123456789ABCDEFabcdef.0123456789ABCDEFabcdefp019)
                                    (v128.const f64x2 0x0.0000000000001p-1022 0x0.0000000000001p-1022))
                                    (v128.const f64x2 0x0.0000000000001p-1022 0x0.0000000000001p-1022))
(assert_return (invoke "f64x2.pmin" (v128.const f64x2 0x0123456789ABCDEFabcdef.0123456789ABCDEFabcdefp019 0x0123456789ABCDEFabcdef.0123456789ABCDEFabcdefp019)
                                    (v128.const f64x2 inf inf))
                                    (v128.const f64x2 0x1.23456789abcdfp+99 0x1.23456789abcdfp+99))
(assert_return (invoke "f64x2.pmin" (v128.const f64x2 0x0123456789ABCDEFabcdef.0123456789ABCDEFabcdefp019 0x0123456789ABCDEFabcdef.0123456789ABCDEFabcdefp019)
                                    (v128.const f64x2 -inf -inf))
                                    (v128.const f64x2 -inf -inf))
(assert_return (invoke "f64x2.pmin" (v128.const f64x2 0x0123456789ABCDEFabcdef.0123456789ABCDEFabcdefp019 0x0123456789ABCDEFabcdef.0123456789ABCDEFabcdefp019)
                                    (v128.const f64x2 0123456789 0123456789))
                                    (v128.const f64x2 0x1.d6f3454000000p+26 0x1.d6f3454000000p+26))
(assert_return (invoke "f64x2.pmin" (v128.const f64x2 0x0123456789ABCDEFabcdef.0123456789ABCDEFabcdefp019 0x0123456789ABCDEFabcdef.0123456789ABCDEFabcdefp019)
                                    (v128.const f64x2 0123456789e019 0123456789e019))
                                    (v128.const f64x2 0x1.fe9af5b5e16fap+89 0x1.fe9af5b5e16fap+89))
(assert_return (invoke "f64x2.pmin" (v128.const f64x2 0x0123456789ABCDEFabcdef.0123456789ABCDEFabcdefp019 0x0123456789ABCDEFabcdef.0123456789ABCDEFabcdefp019)
                                    (v128.const f64x2 0123456789e+019 0123456789e+019))
                                    (v128.const f64x2 0x1.fe9af5b5e16fap+89 0x1.fe9af5b5e16fap+89))
(assert_return (invoke "f64x2.pmin" (v128.const f64x2 0x0123456789ABCDEFabcdef.0123456789ABCDEFabcdefp019 0x0123456789ABCDEFabcdef.0123456789ABCDEFabcdefp019)
                                    (v128.const f64x2 0123456789e-019 0123456789e-019))
                                    (v128.const f64x2 0x1.b25ffd62b4311p-37 0x1.b25ffd62b4311p-37))
(assert_return (invoke "f64x2.pmin" (v128.const f64x2 0x0123456789ABCDEFabcdef.0123456789ABCDEFabcdefp019 0x0123456789ABCDEFabcdef.0123456789ABCDEFabcdefp019)
                                    (v128.const f64x2 0123456789. 0123456789.))
                                    (v128.const f64x2 0x1.d6f3454000000p+26 0x1.d6f3454000000p+26))
(assert_return (invoke "f64x2.pmin" (v128.const f64x2 0x0123456789ABCDEFabcdef.0123456789ABCDEFabcdefp019 0x0123456789ABCDEFabcdef.0123456789ABCDEFabcdefp019)
                                    (v128.const f64x2 0123456789.e019 0123456789.e019))
                                    (v128.const f64x2 0x1.fe9af5b5e16fap+89 0x1.fe9af5b5e16fap+89))
(assert_return (invoke "f64x2.pmin" (v128.const f64x2 0x0123456789ABCDEFabcdef.0123456789ABCDEFabcdefp019 0x0123456789ABCDEFabcdef.0123456789ABCDEFabcdefp019)
                                    (v128.const f64x2 0123456789.e+019 0123456789.e+019))
                                    (v128.const f64x2 0x1.fe9af5b5e16fap+89 0x1.fe9af5b5e16fap+89))
(assert_return (invoke "f64x2.pmin" (v128.const f64x2 0x0123456789ABCDEFabcdef.0123456789ABCDEFabcdefp019 0x0123456789ABCDEFabcdef.0123456789ABCDEFabcdefp019)
                                    (v128.const f64x2 0123456789.e-019 0123456789.e-019))
                                    (v128.const f64x2 0x1.b25ffd62b4311p-37 0x1.b25ffd62b4311p-37))
(assert_return (invoke "f64x2.pmin" (v128.const f64x2 0x0123456789ABCDEFabcdef.0123456789ABCDEFabcdefp019 0x0123456789ABCDEFabcdef.0123456789ABCDEFabcdefp019)
                                    (v128.const f64x2 0123456789.0123456789 0123456789.0123456789))
                                    (v128.const f64x2 0x1.d6f34540ca458p+26 0x1.d6f34540ca458p+26))
(assert_return (invoke "f64x2.pmin" (v128.const f64x2 0x0123456789ABCDEFabcdef.0123456789ABCDEFabcdefp019 0x0123456789ABCDEFabcdef.0123456789ABCDEFabcdefp019)
                                    (v128.const f64x2 0123456789.0123456789e019 0123456789.0123456789e019))
                                    (v128.const f64x2 0x1.fe9af5b6bcbd5p+89 0x1.fe9af5b6bcbd5p+89))
(assert_return (invoke "f64x2.pmin" (v128.const f64x2 0x0123456789ABCDEFabcdef.0123456789ABCDEFabcdefp019 0x0123456789ABCDEFabcdef.0123456789ABCDEFabcdefp019)
                                    (v128.const f64x2 0123456789.0123456789e+019 0123456789.0123456789e+019))
                                    (v128.const f64x2 0x1.fe9af5b6bcbd5p+89 0x1.fe9af5b6bcbd5p+89))
(assert_return (invoke "f64x2.pmin" (v128.const f64x2 0x0123456789ABCDEFabcdef.0123456789ABCDEFabcdefp019 0x0123456789ABCDEFabcdef.0123456789ABCDEFabcdefp019)
                                    (v128.const f64x2 0123456789.0123456789e-019 0123456789.0123456789e-019))
                                    (v128.const f64x2 0x1.b25ffd636ec12p-37 0x1.b25ffd636ec12p-37))
(assert_return (invoke "f64x2.pmin" (v128.const f64x2 0x0123456789ABCDEFabcdef.0123456789ABCDEFabcdefp019 0x0123456789ABCDEFabcdef.0123456789ABCDEFabcdefp019)
                                    (v128.const f64x2 0x0123456789ABCDEFabcdef 0x0123456789ABCDEFabcdef))
                                    (v128.const f64x2 0x1.23456789abcdfp+80 0x1.23456789abcdfp+80))
(assert_return (invoke "f64x2.pmin" (v128.const f64x2 0x0123456789ABCDEFabcdef.0123456789ABCDEFabcdefp019 0x0123456789ABCDEFabcdef.0123456789ABCDEFabcdefp019)
                                    (v128.const f64x2 0x0123456789ABCDEFabcdefp019 0x0123456789ABCDEFabcdefp019))
                                    (v128.const f64x2 0x1.23456789abcdfp+99 0x1.23456789abcdfp+99))
(assert_return (invoke "f64x2.pmin" (v128.const f64x2 0x0123456789ABCDEFabcdef.0123456789ABCDEFabcdefp019 0x0123456789ABCDEFabcdef.0123456789ABCDEFabcdefp019)
                                    (v128.const f64x2 0x0123456789ABCDEFabcdefp+019 0x0123456789ABCDEFabcdefp+019))
                                    (v128.const f64x2 0x1.23456789abcdfp+99 0x1.23456789abcdfp+99))
(assert_return (invoke "f64x2.pmin" (v128.const f64x2 0x0123456789ABCDEFabcdef.0123456789ABCDEFabcdefp019 0x0123456789ABCDEFabcdef.0123456789ABCDEFabcdefp019)
                                    (v128.const f64x2 0x0123456789ABCDEFabcdefp-019 0x0123456789ABCDEFabcdefp-019))
                                    (v128.const f64x2 0x1.23456789abcdfp+61 0x1.23456789abcdfp+61))
(assert_return (invoke "f64x2.pmin" (v128.const f64x2 0x0123456789ABCDEFabcdef.0123456789ABCDEFabcdefp019 0x0123456789ABCDEFabcdef.0123456789ABCDEFabcdefp019)
                                    (v128.const f64x2 0x0123456789ABCDEFabcdef. 0x0123456789ABCDEFabcdef.))
                                    (v128.const f64x2 0x1.23456789abcdfp+80 0x1.23456789abcdfp+80))
(assert_return (invoke "f64x2.pmin" (v128.const f64x2 0x0123456789ABCDEFabcdef.0123456789ABCDEFabcdefp019 0x0123456789ABCDEFabcdef.0123456789ABCDEFabcdefp019)
                                    (v128.const f64x2 0x0123456789ABCDEFabcdef.p019 0x0123456789ABCDEFabcdef.p019))
                                    (v128.const f64x2 0x1.23456789abcdfp+99 0x1.23456789abcdfp+99))
(assert_return (invoke "f64x2.pmin" (v128.const f64x2 0x0123456789ABCDEFabcdef.0123456789ABCDEFabcdefp019 0x0123456789ABCDEFabcdef.0123456789ABCDEFabcdefp019)
                                    (v128.const f64x2 0x0123456789ABCDEFabcdef.p+019 0x0123456789ABCDEFabcdef.p+019))
                                    (v128.const f64x2 0x1.23456789abcdfp+99 0x1.23456789abcdfp+99))
(assert_return (invoke "f64x2.pmin" (v128.const f64x2 0x0123456789ABCDEFabcdef.0123456789ABCDEFabcdefp019 0x0123456789ABCDEFabcdef.0123456789ABCDEFabcdefp019)
                                    (v128.const f64x2 0x0123456789ABCDEFabcdef.p-019 0x0123456789ABCDEFabcdef.p-019))
                                    (v128.const f64x2 0x1.23456789abcdfp+61 0x1.23456789abcdfp+61))
(assert_return (invoke "f64x2.pmin" (v128.const f64x2 0x0123456789ABCDEFabcdef.0123456789ABCDEFabcdefp019 0x0123456789ABCDEFabcdef.0123456789ABCDEFabcdefp019)
                                    (v128.const f64x2 0x0123456789ABCDEFabcdef.0123456789ABCDEFabcdef 0x0123456789ABCDEFabcdef.0123456789ABCDEFabcdef))
                                    (v128.const f64x2 0x1.23456789abcdfp+80 0x1.23456789abcdfp+80))
(assert_return (invoke "f64x2.pmin" (v128.const f64x2 0x0123456789ABCDEFabcdef.0123456789ABCDEFabcdefp019 0x0123456789ABCDEFabcdef.0123456789ABCDEFabcdefp019)
                                    (v128.const f64x2 0x0123456789ABCDEFabcdef.0123456789ABCDEFabcdefp019 0x0123456789ABCDEFabcdef.0123456789ABCDEFabcdefp019))
                                    (v128.const f64x2 0x1.23456789abcdfp+99 0x1.23456789abcdfp+99))
(assert_return (invoke "f64x2.pmin" (v128.const f64x2 0x0123456789ABCDEFabcdef.0123456789ABCDEFabcdefp019 0x0123456789ABCDEFabcdef.0123456789ABCDEFabcdefp019)
                                    (v128.const f64x2 0x0123456789ABCDEFabcdef.0123456789ABCDEFabcdefp+019 0x0123456789ABCDEFabcdef.0123456789ABCDEFabcdefp+019))
                                    (v128.const f64x2 0x1.23456789abcdfp+99 0x1.23456789abcdfp+99))
(assert_return (invoke "f64x2.pmin" (v128.const f64x2 0x0123456789ABCDEFabcdef.0123456789ABCDEFabcdefp019 0x0123456789ABCDEFabcdef.0123456789ABCDEFabcdefp019)
                                    (v128.const f64x2 0x0123456789ABCDEFabcdef.0123456789ABCDEFabcdefp-019 0x0123456789ABCDEFabcdef.0123456789ABCDEFabcdefp-019))
                                    (v128.const f64x2 0x1.23456789abcdfp+61 0x1.23456789abcdfp+61))
(assert_return (invoke "f64x2.pmin" (v128.const f64x2 0x0123456789ABCDEFabcdef.0123456789ABCDEFabcdefp+019 0x0123456789ABCDEFabcdef.0123456789ABCDEFabcdefp+019)
                                    (v128.const f64x2 0x0p+0 0x0p+0))
                                    (v128.const f64x2 0x0.0p+0 0x0.0p+0))
(assert_return (invoke "f64x2.pmin" (v128.const f64x2 0x0123456789ABCDEFabcdef.0123456789ABCDEFabcdefp+019 0x0123456789ABCDEFabcdef.0123456789ABCDEFabcdefp+019)
                                    (v128.const f64x2 -0x0p+0 -0x0p+0))
                                    (v128.const f64x2 -0x0.0p+0 -0x0.0p+0))
(assert_return (invoke "f64x2.pmin" (v128.const f64x2 0x0123456789ABCDEFabcdef.0123456789ABCDEFabcdefp+019 0x0123456789ABCDEFabcdef.0123456789ABCDEFabcdefp+019)
                                    (v128.const f64x2 0x1p-1022 0x1p-1022))
                                    (v128.const f64x2 0x1.0000000000000p-1022 0x1.0000000000000p-1022))
(assert_return (invoke "f64x2.pmin" (v128.const f64x2 0x0123456789ABCDEFabcdef.0123456789ABCDEFabcdefp+019 0x0123456789ABCDEFabcdef.0123456789ABCDEFabcdefp+019)
                                    (v128.const f64x2 -0x1p-1022 -0x1p-1022))
                                    (v128.const f64x2 -0x1.0000000000000p-1022 -0x1.0000000000000p-1022))
(assert_return (invoke "f64x2.pmin" (v128.const f64x2 0x0123456789ABCDEFabcdef.0123456789ABCDEFabcdefp+019 0x0123456789ABCDEFabcdef.0123456789ABCDEFabcdefp+019)
                                    (v128.const f64x2 0x1p-1 0x1p-1))
                                    (v128.const f64x2 0x1.0000000000000p-1 0x1.0000000000000p-1))
(assert_return (invoke "f64x2.pmin" (v128.const f64x2 0x0123456789ABCDEFabcdef.0123456789ABCDEFabcdefp+019 0x0123456789ABCDEFabcdef.0123456789ABCDEFabcdefp+019)
                                    (v128.const f64x2 -0x1p-1 -0x1p-1))
                                    (v128.const f64x2 -0x1.0000000000000p-1 -0x1.0000000000000p-1))
(assert_return (invoke "f64x2.pmin" (v128.const f64x2 0x0123456789ABCDEFabcdef.0123456789ABCDEFabcdefp+019 0x0123456789ABCDEFabcdef.0123456789ABCDEFabcdefp+019)
                                    (v128.const f64x2 0x1p+0 0x1p+0))
                                    (v128.const f64x2 0x1.0000000000000p+0 0x1.0000000000000p+0))
(assert_return (invoke "f64x2.pmin" (v128.const f64x2 0x0123456789ABCDEFabcdef.0123456789ABCDEFabcdefp+019 0x0123456789ABCDEFabcdef.0123456789ABCDEFabcdefp+019)
                                    (v128.const f64x2 -0x1p+0 -0x1p+0))
                                    (v128.const f64x2 -0x1.0000000000000p+0 -0x1.0000000000000p+0))
(assert_return (invoke "f64x2.pmin" (v128.const f64x2 0x0123456789ABCDEFabcdef.0123456789ABCDEFabcdefp+019 0x0123456789ABCDEFabcdef.0123456789ABCDEFabcdefp+019)
                                    (v128.const f64x2 0x1.921fb54442d18p+2 0x1.921fb54442d18p+2))
                                    (v128.const f64x2 0x1.921fb54442d18p+2 0x1.921fb54442d18p+2))
(assert_return (invoke "f64x2.pmin" (v128.const f64x2 0x0123456789ABCDEFabcdef.0123456789ABCDEFabcdefp+019 0x0123456789ABCDEFabcdef.0123456789ABCDEFabcdefp+019)
                                    (v128.const f64x2 -0x1.921fb54442d18p+2 -0x1.921fb54442d18p+2))
                                    (v128.const f64x2 -0x1.921fb54442d18p+2 -0x1.921fb54442d18p+2))
(assert_return (invoke "f64x2.pmin" (v128.const f64x2 0x0123456789ABCDEFabcdef.0123456789ABCDEFabcdefp+019 0x0123456789ABCDEFabcdef.0123456789ABCDEFabcdefp+019)
                                    (v128.const f64x2 0x1.fffffffffffffp+1023 0x1.fffffffffffffp+1023))
                                    (v128.const f64x2 0x1.23456789abcdfp+99 0x1.23456789abcdfp+99))
(assert_return (invoke "f64x2.pmin" (v128.const f64x2 0x0123456789ABCDEFabcdef.0123456789ABCDEFabcdefp+019 0x0123456789ABCDEFabcdef.0123456789ABCDEFabcdefp+019)
                                    (v128.const f64x2 -0x1.fffffffffffffp+1023 -0x1.fffffffffffffp+1023))
                                    (v128.const f64x2 -0x1.fffffffffffffp+1023 -0x1.fffffffffffffp+1023))
(assert_return (invoke "f64x2.pmin" (v128.const f64x2 0x0123456789ABCDEFabcdef.0123456789ABCDEFabcdefp+019 0x0123456789ABCDEFabcdef.0123456789ABCDEFabcdefp+019)
                                    (v128.const f64x2 0x0.0000000000001p-1022 0x0.0000000000001p-1022))
                                    (v128.const f64x2 0x0.0000000000001p-1022 0x0.0000000000001p-1022))
(assert_return (invoke "f64x2.pmin" (v128.const f64x2 0x0123456789ABCDEFabcdef.0123456789ABCDEFabcdefp+019 0x0123456789ABCDEFabcdef.0123456789ABCDEFabcdefp+019)
                                    (v128.const f64x2 0x0.0000000000001p-1022 0x0.0000000000001p-1022))
                                    (v128.const f64x2 0x0.0000000000001p-1022 0x0.0000000000001p-1022))
(assert_return (invoke "f64x2.pmin" (v128.const f64x2 0x0123456789ABCDEFabcdef.0123456789ABCDEFabcdefp+019 0x0123456789ABCDEFabcdef.0123456789ABCDEFabcdefp+019)
                                    (v128.const f64x2 inf inf))
                                    (v128.const f64x2 0x1.23456789abcdfp+99 0x1.23456789abcdfp+99))
(assert_return (invoke "f64x2.pmin" (v128.const f64x2 0x0123456789ABCDEFabcdef.0123456789ABCDEFabcdefp+019 0x0123456789ABCDEFabcdef.0123456789ABCDEFabcdefp+019)
                                    (v128.const f64x2 -inf -inf))
                                    (v128.const f64x2 -inf -inf))
(assert_return (invoke "f64x2.pmin" (v128.const f64x2 0x0123456789ABCDEFabcdef.0123456789ABCDEFabcdefp+019 0x0123456789ABCDEFabcdef.0123456789ABCDEFabcdefp+019)
                                    (v128.const f64x2 0123456789 0123456789))
                                    (v128.const f64x2 0x1.d6f3454000000p+26 0x1.d6f3454000000p+26))
(assert_return (invoke "f64x2.pmin" (v128.const f64x2 0x0123456789ABCDEFabcdef.0123456789ABCDEFabcdefp+019 0x0123456789ABCDEFabcdef.0123456789ABCDEFabcdefp+019)
                                    (v128.const f64x2 0123456789e019 0123456789e019))
                                    (v128.const f64x2 0x1.fe9af5b5e16fap+89 0x1.fe9af5b5e16fap+89))
(assert_return (invoke "f64x2.pmin" (v128.const f64x2 0x0123456789ABCDEFabcdef.0123456789ABCDEFabcdefp+019 0x0123456789ABCDEFabcdef.0123456789ABCDEFabcdefp+019)
                                    (v128.const f64x2 0123456789e+019 0123456789e+019))
                                    (v128.const f64x2 0x1.fe9af5b5e16fap+89 0x1.fe9af5b5e16fap+89))
(assert_return (invoke "f64x2.pmin" (v128.const f64x2 0x0123456789ABCDEFabcdef.0123456789ABCDEFabcdefp+019 0x0123456789ABCDEFabcdef.0123456789ABCDEFabcdefp+019)
                                    (v128.const f64x2 0123456789e-019 0123456789e-019))
                                    (v128.const f64x2 0x1.b25ffd62b4311p-37 0x1.b25ffd62b4311p-37))
(assert_return (invoke "f64x2.pmin" (v128.const f64x2 0x0123456789ABCDEFabcdef.0123456789ABCDEFabcdefp+019 0x0123456789ABCDEFabcdef.0123456789ABCDEFabcdefp+019)
                                    (v128.const f64x2 0123456789. 0123456789.))
                                    (v128.const f64x2 0x1.d6f3454000000p+26 0x1.d6f3454000000p+26))
(assert_return (invoke "f64x2.pmin" (v128.const f64x2 0x0123456789ABCDEFabcdef.0123456789ABCDEFabcdefp+019 0x0123456789ABCDEFabcdef.0123456789ABCDEFabcdefp+019)
                                    (v128.const f64x2 0123456789.e019 0123456789.e019))
                                    (v128.const f64x2 0x1.fe9af5b5e16fap+89 0x1.fe9af5b5e16fap+89))
(assert_return (invoke "f64x2.pmin" (v128.const f64x2 0x0123456789ABCDEFabcdef.0123456789ABCDEFabcdefp+019 0x0123456789ABCDEFabcdef.0123456789ABCDEFabcdefp+019)
                                    (v128.const f64x2 0123456789.e+019 0123456789.e+019))
                                    (v128.const f64x2 0x1.fe9af5b5e16fap+89 0x1.fe9af5b5e16fap+89))
(assert_return (invoke "f64x2.pmin" (v128.const f64x2 0x0123456789ABCDEFabcdef.0123456789ABCDEFabcdefp+019 0x0123456789ABCDEFabcdef.0123456789ABCDEFabcdefp+019)
                                    (v128.const f64x2 0123456789.e-019 0123456789.e-019))
                                    (v128.const f64x2 0x1.b25ffd62b4311p-37 0x1.b25ffd62b4311p-37))
(assert_return (invoke "f64x2.pmin" (v128.const f64x2 0x0123456789ABCDEFabcdef.0123456789ABCDEFabcdefp+019 0x0123456789ABCDEFabcdef.0123456789ABCDEFabcdefp+019)
                                    (v128.const f64x2 0123456789.0123456789 0123456789.0123456789))
                                    (v128.const f64x2 0x1.d6f34540ca458p+26 0x1.d6f34540ca458p+26))
(assert_return (invoke "f64x2.pmin" (v128.const f64x2 0x0123456789ABCDEFabcdef.0123456789ABCDEFabcdefp+019 0x0123456789ABCDEFabcdef.0123456789ABCDEFabcdefp+019)
                                    (v128.const f64x2 0123456789.0123456789e019 0123456789.0123456789e019))
                                    (v128.const f64x2 0x1.fe9af5b6bcbd5p+89 0x1.fe9af5b6bcbd5p+89))
(assert_return (invoke "f64x2.pmin" (v128.const f64x2 0x0123456789ABCDEFabcdef.0123456789ABCDEFabcdefp+019 0x0123456789ABCDEFabcdef.0123456789ABCDEFabcdefp+019)
                                    (v128.const f64x2 0123456789.0123456789e+019 0123456789.0123456789e+019))
                                    (v128.const f64x2 0x1.fe9af5b6bcbd5p+89 0x1.fe9af5b6bcbd5p+89))
(assert_return (invoke "f64x2.pmin" (v128.const f64x2 0x0123456789ABCDEFabcdef.0123456789ABCDEFabcdefp+019 0x0123456789ABCDEFabcdef.0123456789ABCDEFabcdefp+019)
                                    (v128.const f64x2 0123456789.0123456789e-019 0123456789.0123456789e-019))
                                    (v128.const f64x2 0x1.b25ffd636ec12p-37 0x1.b25ffd636ec12p-37))
(assert_return (invoke "f64x2.pmin" (v128.const f64x2 0x0123456789ABCDEFabcdef.0123456789ABCDEFabcdefp+019 0x0123456789ABCDEFabcdef.0123456789ABCDEFabcdefp+019)
                                    (v128.const f64x2 0x0123456789ABCDEFabcdef 0x0123456789ABCDEFabcdef))
                                    (v128.const f64x2 0x1.23456789abcdfp+80 0x1.23456789abcdfp+80))
(assert_return (invoke "f64x2.pmin" (v128.const f64x2 0x0123456789ABCDEFabcdef.0123456789ABCDEFabcdefp+019 0x0123456789ABCDEFabcdef.0123456789ABCDEFabcdefp+019)
                                    (v128.const f64x2 0x0123456789ABCDEFabcdefp019 0x0123456789ABCDEFabcdefp019))
                                    (v128.const f64x2 0x1.23456789abcdfp+99 0x1.23456789abcdfp+99))
(assert_return (invoke "f64x2.pmin" (v128.const f64x2 0x0123456789ABCDEFabcdef.0123456789ABCDEFabcdefp+019 0x0123456789ABCDEFabcdef.0123456789ABCDEFabcdefp+019)
                                    (v128.const f64x2 0x0123456789ABCDEFabcdefp+019 0x0123456789ABCDEFabcdefp+019))
                                    (v128.const f64x2 0x1.23456789abcdfp+99 0x1.23456789abcdfp+99))
(assert_return (invoke "f64x2.pmin" (v128.const f64x2 0x0123456789ABCDEFabcdef.0123456789ABCDEFabcdefp+019 0x0123456789ABCDEFabcdef.0123456789ABCDEFabcdefp+019)
                                    (v128.const f64x2 0x0123456789ABCDEFabcdefp-019 0x0123456789ABCDEFabcdefp-019))
                                    (v128.const f64x2 0x1.23456789abcdfp+61 0x1.23456789abcdfp+61))
(assert_return (invoke "f64x2.pmin" (v128.const f64x2 0x0123456789ABCDEFabcdef.0123456789ABCDEFabcdefp+019 0x0123456789ABCDEFabcdef.0123456789ABCDEFabcdefp+019)
                                    (v128.const f64x2 0x0123456789ABCDEFabcdef. 0x0123456789ABCDEFabcdef.))
                                    (v128.const f64x2 0x1.23456789abcdfp+80 0x1.23456789abcdfp+80))
(assert_return (invoke "f64x2.pmin" (v128.const f64x2 0x0123456789ABCDEFabcdef.0123456789ABCDEFabcdefp+019 0x0123456789ABCDEFabcdef.0123456789ABCDEFabcdefp+019)
                                    (v128.const f64x2 0x0123456789ABCDEFabcdef.p019 0x0123456789ABCDEFabcdef.p019))
                                    (v128.const f64x2 0x1.23456789abcdfp+99 0x1.23456789abcdfp+99))
(assert_return (invoke "f64x2.pmin" (v128.const f64x2 0x0123456789ABCDEFabcdef.0123456789ABCDEFabcdefp+019 0x0123456789ABCDEFabcdef.0123456789ABCDEFabcdefp+019)
                                    (v128.const f64x2 0x0123456789ABCDEFabcdef.p+019 0x0123456789ABCDEFabcdef.p+019))
                                    (v128.const f64x2 0x1.23456789abcdfp+99 0x1.23456789abcdfp+99))
(assert_return (invoke "f64x2.pmin" (v128.const f64x2 0x0123456789ABCDEFabcdef.0123456789ABCDEFabcdefp+019 0x0123456789ABCDEFabcdef.0123456789ABCDEFabcdefp+019)
                                    (v128.const f64x2 0x0123456789ABCDEFabcdef.p-019 0x0123456789ABCDEFabcdef.p-019))
                                    (v128.const f64x2 0x1.23456789abcdfp+61 0x1.23456789abcdfp+61))
(assert_return (invoke "f64x2.pmin" (v128.const f64x2 0x0123456789ABCDEFabcdef.0123456789ABCDEFabcdefp+019 0x0123456789ABCDEFabcdef.0123456789ABCDEFabcdefp+019)
                                    (v128.const f64x2 0x0123456789ABCDEFabcdef.0123456789ABCDEFabcdef 0x0123456789ABCDEFabcdef.0123456789ABCDEFabcdef))
                                    (v128.const f64x2 0x1.23456789abcdfp+80 0x1.23456789abcdfp+80))
(assert_return (invoke "f64x2.pmin" (v128.const f64x2 0x0123456789ABCDEFabcdef.0123456789ABCDEFabcdefp+019 0x0123456789ABCDEFabcdef.0123456789ABCDEFabcdefp+019)
                                    (v128.const f64x2 0x0123456789ABCDEFabcdef.0123456789ABCDEFabcdefp019 0x0123456789ABCDEFabcdef.0123456789ABCDEFabcdefp019))
                                    (v128.const f64x2 0x1.23456789abcdfp+99 0x1.23456789abcdfp+99))
(assert_return (invoke "f64x2.pmin" (v128.const f64x2 0x0123456789ABCDEFabcdef.0123456789ABCDEFabcdefp+019 0x0123456789ABCDEFabcdef.0123456789ABCDEFabcdefp+019)
                                    (v128.const f64x2 0x0123456789ABCDEFabcdef.0123456789ABCDEFabcdefp+019 0x0123456789ABCDEFabcdef.0123456789ABCDEFabcdefp+019))
                                    (v128.const f64x2 0x1.23456789abcdfp+99 0x1.23456789abcdfp+99))
(assert_return (invoke "f64x2.pmin" (v128.const f64x2 0x0123456789ABCDEFabcdef.0123456789ABCDEFabcdefp+019 0x0123456789ABCDEFabcdef.0123456789ABCDEFabcdefp+019)
                                    (v128.const f64x2 0x0123456789ABCDEFabcdef.0123456789ABCDEFabcdefp-019 0x0123456789ABCDEFabcdef.0123456789ABCDEFabcdefp-019))
                                    (v128.const f64x2 0x1.23456789abcdfp+61 0x1.23456789abcdfp+61))
(assert_return (invoke "f64x2.pmin" (v128.const f64x2 0x0123456789ABCDEFabcdef.0123456789ABCDEFabcdefp-019 0x0123456789ABCDEFabcdef.0123456789ABCDEFabcdefp-019)
                                    (v128.const f64x2 0x0p+0 0x0p+0))
                                    (v128.const f64x2 0x0.0p+0 0x0.0p+0))
(assert_return (invoke "f64x2.pmin" (v128.const f64x2 0x0123456789ABCDEFabcdef.0123456789ABCDEFabcdefp-019 0x0123456789ABCDEFabcdef.0123456789ABCDEFabcdefp-019)
                                    (v128.const f64x2 -0x0p+0 -0x0p+0))
                                    (v128.const f64x2 -0x0.0p+0 -0x0.0p+0))
(assert_return (invoke "f64x2.pmin" (v128.const f64x2 0x0123456789ABCDEFabcdef.0123456789ABCDEFabcdefp-019 0x0123456789ABCDEFabcdef.0123456789ABCDEFabcdefp-019)
                                    (v128.const f64x2 0x1p-1022 0x1p-1022))
                                    (v128.const f64x2 0x1.0000000000000p-1022 0x1.0000000000000p-1022))
(assert_return (invoke "f64x2.pmin" (v128.const f64x2 0x0123456789ABCDEFabcdef.0123456789ABCDEFabcdefp-019 0x0123456789ABCDEFabcdef.0123456789ABCDEFabcdefp-019)
                                    (v128.const f64x2 -0x1p-1022 -0x1p-1022))
                                    (v128.const f64x2 -0x1.0000000000000p-1022 -0x1.0000000000000p-1022))
(assert_return (invoke "f64x2.pmin" (v128.const f64x2 0x0123456789ABCDEFabcdef.0123456789ABCDEFabcdefp-019 0x0123456789ABCDEFabcdef.0123456789ABCDEFabcdefp-019)
                                    (v128.const f64x2 0x1p-1 0x1p-1))
                                    (v128.const f64x2 0x1.0000000000000p-1 0x1.0000000000000p-1))
(assert_return (invoke "f64x2.pmin" (v128.const f64x2 0x0123456789ABCDEFabcdef.0123456789ABCDEFabcdefp-019 0x0123456789ABCDEFabcdef.0123456789ABCDEFabcdefp-019)
                                    (v128.const f64x2 -0x1p-1 -0x1p-1))
                                    (v128.const f64x2 -0x1.0000000000000p-1 -0x1.0000000000000p-1))
(assert_return (invoke "f64x2.pmin" (v128.const f64x2 0x0123456789ABCDEFabcdef.0123456789ABCDEFabcdefp-019 0x0123456789ABCDEFabcdef.0123456789ABCDEFabcdefp-019)
                                    (v128.const f64x2 0x1p+0 0x1p+0))
                                    (v128.const f64x2 0x1.0000000000000p+0 0x1.0000000000000p+0))
(assert_return (invoke "f64x2.pmin" (v128.const f64x2 0x0123456789ABCDEFabcdef.0123456789ABCDEFabcdefp-019 0x0123456789ABCDEFabcdef.0123456789ABCDEFabcdefp-019)
                                    (v128.const f64x2 -0x1p+0 -0x1p+0))
                                    (v128.const f64x2 -0x1.0000000000000p+0 -0x1.0000000000000p+0))
(assert_return (invoke "f64x2.pmin" (v128.const f64x2 0x0123456789ABCDEFabcdef.0123456789ABCDEFabcdefp-019 0x0123456789ABCDEFabcdef.0123456789ABCDEFabcdefp-019)
                                    (v128.const f64x2 0x1.921fb54442d18p+2 0x1.921fb54442d18p+2))
                                    (v128.const f64x2 0x1.921fb54442d18p+2 0x1.921fb54442d18p+2))
(assert_return (invoke "f64x2.pmin" (v128.const f64x2 0x0123456789ABCDEFabcdef.0123456789ABCDEFabcdefp-019 0x0123456789ABCDEFabcdef.0123456789ABCDEFabcdefp-019)
                                    (v128.const f64x2 -0x1.921fb54442d18p+2 -0x1.921fb54442d18p+2))
                                    (v128.const f64x2 -0x1.921fb54442d18p+2 -0x1.921fb54442d18p+2))
(assert_return (invoke "f64x2.pmin" (v128.const f64x2 0x0123456789ABCDEFabcdef.0123456789ABCDEFabcdefp-019 0x0123456789ABCDEFabcdef.0123456789ABCDEFabcdefp-019)
                                    (v128.const f64x2 0x1.fffffffffffffp+1023 0x1.fffffffffffffp+1023))
                                    (v128.const f64x2 0x1.23456789abcdfp+61 0x1.23456789abcdfp+61))
(assert_return (invoke "f64x2.pmin" (v128.const f64x2 0x0123456789ABCDEFabcdef.0123456789ABCDEFabcdefp-019 0x0123456789ABCDEFabcdef.0123456789ABCDEFabcdefp-019)
                                    (v128.const f64x2 -0x1.fffffffffffffp+1023 -0x1.fffffffffffffp+1023))
                                    (v128.const f64x2 -0x1.fffffffffffffp+1023 -0x1.fffffffffffffp+1023))
(assert_return (invoke "f64x2.pmin" (v128.const f64x2 0x0123456789ABCDEFabcdef.0123456789ABCDEFabcdefp-019 0x0123456789ABCDEFabcdef.0123456789ABCDEFabcdefp-019)
                                    (v128.const f64x2 0x0.0000000000001p-1022 0x0.0000000000001p-1022))
                                    (v128.const f64x2 0x0.0000000000001p-1022 0x0.0000000000001p-1022))
(assert_return (invoke "f64x2.pmin" (v128.const f64x2 0x0123456789ABCDEFabcdef.0123456789ABCDEFabcdefp-019 0x0123456789ABCDEFabcdef.0123456789ABCDEFabcdefp-019)
                                    (v128.const f64x2 0x0.0000000000001p-1022 0x0.0000000000001p-1022))
                                    (v128.const f64x2 0x0.0000000000001p-1022 0x0.0000000000001p-1022))
(assert_return (invoke "f64x2.pmin" (v128.const f64x2 0x0123456789ABCDEFabcdef.0123456789ABCDEFabcdefp-019 0x0123456789ABCDEFabcdef.0123456789ABCDEFabcdefp-019)
                                    (v128.const f64x2 inf inf))
                                    (v128.const f64x2 0x1.23456789abcdfp+61 0x1.23456789abcdfp+61))
(assert_return (invoke "f64x2.pmin" (v128.const f64x2 0x0123456789ABCDEFabcdef.0123456789ABCDEFabcdefp-019 0x0123456789ABCDEFabcdef.0123456789ABCDEFabcdefp-019)
                                    (v128.const f64x2 -inf -inf))
                                    (v128.const f64x2 -inf -inf))
(assert_return (invoke "f64x2.pmin" (v128.const f64x2 0x0123456789ABCDEFabcdef.0123456789ABCDEFabcdefp-019 0x0123456789ABCDEFabcdef.0123456789ABCDEFabcdefp-019)
                                    (v128.const f64x2 0123456789 0123456789))
                                    (v128.const f64x2 0x1.d6f3454000000p+26 0x1.d6f3454000000p+26))
(assert_return (invoke "f64x2.pmin" (v128.const f64x2 0x0123456789ABCDEFabcdef.0123456789ABCDEFabcdefp-019 0x0123456789ABCDEFabcdef.0123456789ABCDEFabcdefp-019)
                                    (v128.const f64x2 0123456789e019 0123456789e019))
                                    (v128.const f64x2 0x1.23456789abcdfp+61 0x1.23456789abcdfp+61))
(assert_return (invoke "f64x2.pmin" (v128.const f64x2 0x0123456789ABCDEFabcdef.0123456789ABCDEFabcdefp-019 0x0123456789ABCDEFabcdef.0123456789ABCDEFabcdefp-019)
                                    (v128.const f64x2 0123456789e+019 0123456789e+019))
                                    (v128.const f64x2 0x1.23456789abcdfp+61 0x1.23456789abcdfp+61))
(assert_return (invoke "f64x2.pmin" (v128.const f64x2 0x0123456789ABCDEFabcdef.0123456789ABCDEFabcdefp-019 0x0123456789ABCDEFabcdef.0123456789ABCDEFabcdefp-019)
                                    (v128.const f64x2 0123456789e-019 0123456789e-019))
                                    (v128.const f64x2 0x1.b25ffd62b4311p-37 0x1.b25ffd62b4311p-37))
(assert_return (invoke "f64x2.pmin" (v128.const f64x2 0x0123456789ABCDEFabcdef.0123456789ABCDEFabcdefp-019 0x0123456789ABCDEFabcdef.0123456789ABCDEFabcdefp-019)
                                    (v128.const f64x2 0123456789. 0123456789.))
                                    (v128.const f64x2 0x1.d6f3454000000p+26 0x1.d6f3454000000p+26))
(assert_return (invoke "f64x2.pmin" (v128.const f64x2 0x0123456789ABCDEFabcdef.0123456789ABCDEFabcdefp-019 0x0123456789ABCDEFabcdef.0123456789ABCDEFabcdefp-019)
                                    (v128.const f64x2 0123456789.e019 0123456789.e019))
                                    (v128.const f64x2 0x1.23456789abcdfp+61 0x1.23456789abcdfp+61))
(assert_return (invoke "f64x2.pmin" (v128.const f64x2 0x0123456789ABCDEFabcdef.0123456789ABCDEFabcdefp-019 0x0123456789ABCDEFabcdef.0123456789ABCDEFabcdefp-019)
                                    (v128.const f64x2 0123456789.e+019 0123456789.e+019))
                                    (v128.const f64x2 0x1.23456789abcdfp+61 0x1.23456789abcdfp+61))
(assert_return (invoke "f64x2.pmin" (v128.const f64x2 0x0123456789ABCDEFabcdef.0123456789ABCDEFabcdefp-019 0x0123456789ABCDEFabcdef.0123456789ABCDEFabcdefp-019)
                                    (v128.const f64x2 0123456789.e-019 0123456789.e-019))
                                    (v128.const f64x2 0x1.b25ffd62b4311p-37 0x1.b25ffd62b4311p-37))
(assert_return (invoke "f64x2.pmin" (v128.const f64x2 0x0123456789ABCDEFabcdef.0123456789ABCDEFabcdefp-019 0x0123456789ABCDEFabcdef.0123456789ABCDEFabcdefp-019)
                                    (v128.const f64x2 0123456789.0123456789 0123456789.0123456789))
                                    (v128.const f64x2 0x1.d6f34540ca458p+26 0x1.d6f34540ca458p+26))
(assert_return (invoke "f64x2.pmin" (v128.const f64x2 0x0123456789ABCDEFabcdef.0123456789ABCDEFabcdefp-019 0x0123456789ABCDEFabcdef.0123456789ABCDEFabcdefp-019)
                                    (v128.const f64x2 0123456789.0123456789e019 0123456789.0123456789e019))
                                    (v128.const f64x2 0x1.23456789abcdfp+61 0x1.23456789abcdfp+61))
(assert_return (invoke "f64x2.pmin" (v128.const f64x2 0x0123456789ABCDEFabcdef.0123456789ABCDEFabcdefp-019 0x0123456789ABCDEFabcdef.0123456789ABCDEFabcdefp-019)
                                    (v128.const f64x2 0123456789.0123456789e+019 0123456789.0123456789e+019))
                                    (v128.const f64x2 0x1.23456789abcdfp+61 0x1.23456789abcdfp+61))
(assert_return (invoke "f64x2.pmin" (v128.const f64x2 0x0123456789ABCDEFabcdef.0123456789ABCDEFabcdefp-019 0x0123456789ABCDEFabcdef.0123456789ABCDEFabcdefp-019)
                                    (v128.const f64x2 0123456789.0123456789e-019 0123456789.0123456789e-019))
                                    (v128.const f64x2 0x1.b25ffd636ec12p-37 0x1.b25ffd636ec12p-37))
(assert_return (invoke "f64x2.pmin" (v128.const f64x2 0x0123456789ABCDEFabcdef.0123456789ABCDEFabcdefp-019 0x0123456789ABCDEFabcdef.0123456789ABCDEFabcdefp-019)
                                    (v128.const f64x2 0x0123456789ABCDEFabcdef 0x0123456789ABCDEFabcdef))
                                    (v128.const f64x2 0x1.23456789abcdfp+61 0x1.23456789abcdfp+61))
(assert_return (invoke "f64x2.pmin" (v128.const f64x2 0x0123456789ABCDEFabcdef.0123456789ABCDEFabcdefp-019 0x0123456789ABCDEFabcdef.0123456789ABCDEFabcdefp-019)
                                    (v128.const f64x2 0x0123456789ABCDEFabcdefp019 0x0123456789ABCDEFabcdefp019))
                                    (v128.const f64x2 0x1.23456789abcdfp+61 0x1.23456789abcdfp+61))
(assert_return (invoke "f64x2.pmin" (v128.const f64x2 0x0123456789ABCDEFabcdef.0123456789ABCDEFabcdefp-019 0x0123456789ABCDEFabcdef.0123456789ABCDEFabcdefp-019)
                                    (v128.const f64x2 0x0123456789ABCDEFabcdefp+019 0x0123456789ABCDEFabcdefp+019))
                                    (v128.const f64x2 0x1.23456789abcdfp+61 0x1.23456789abcdfp+61))
(assert_return (invoke "f64x2.pmin" (v128.const f64x2 0x0123456789ABCDEFabcdef.0123456789ABCDEFabcdefp-019 0x0123456789ABCDEFabcdef.0123456789ABCDEFabcdefp-019)
                                    (v128.const f64x2 0x0123456789ABCDEFabcdefp-019 0x0123456789ABCDEFabcdefp-019))
                                    (v128.const f64x2 0x1.23456789abcdfp+61 0x1.23456789abcdfp+61))
(assert_return (invoke "f64x2.pmin" (v128.const f64x2 0x0123456789ABCDEFabcdef.0123456789ABCDEFabcdefp-019 0x0123456789ABCDEFabcdef.0123456789ABCDEFabcdefp-019)
                                    (v128.const f64x2 0x0123456789ABCDEFabcdef. 0x0123456789ABCDEFabcdef.))
                                    (v128.const f64x2 0x1.23456789abcdfp+61 0x1.23456789abcdfp+61))
(assert_return (invoke "f64x2.pmin" (v128.const f64x2 0x0123456789ABCDEFabcdef.0123456789ABCDEFabcdefp-019 0x0123456789ABCDEFabcdef.0123456789ABCDEFabcdefp-019)
                                    (v128.const f64x2 0x0123456789ABCDEFabcdef.p019 0x0123456789ABCDEFabcdef.p019))
                                    (v128.const f64x2 0x1.23456789abcdfp+61 0x1.23456789abcdfp+61))
(assert_return (invoke "f64x2.pmin" (v128.const f64x2 0x0123456789ABCDEFabcdef.0123456789ABCDEFabcdefp-019 0x0123456789ABCDEFabcdef.0123456789ABCDEFabcdefp-019)
                                    (v128.const f64x2 0x0123456789ABCDEFabcdef.p+019 0x0123456789ABCDEFabcdef.p+019))
                                    (v128.const f64x2 0x1.23456789abcdfp+61 0x1.23456789abcdfp+61))
(assert_return (invoke "f64x2.pmin" (v128.const f64x2 0x0123456789ABCDEFabcdef.0123456789ABCDEFabcdefp-019 0x0123456789ABCDEFabcdef.0123456789ABCDEFabcdefp-019)
                                    (v128.const f64x2 0x0123456789ABCDEFabcdef.p-019 0x0123456789ABCDEFabcdef.p-019))
                                    (v128.const f64x2 0x1.23456789abcdfp+61 0x1.23456789abcdfp+61))
(assert_return (invoke "f64x2.pmin" (v128.const f64x2 0x0123456789ABCDEFabcdef.0123456789ABCDEFabcdefp-019 0x0123456789ABCDEFabcdef.0123456789ABCDEFabcdefp-019)
                                    (v128.const f64x2 0x0123456789ABCDEFabcdef.0123456789ABCDEFabcdef 0x0123456789ABCDEFabcdef.0123456789ABCDEFabcdef))
                                    (v128.const f64x2 0x1.23456789abcdfp+61 0x1.23456789abcdfp+61))
(assert_return (invoke "f64x2.pmin" (v128.const f64x2 0x0123456789ABCDEFabcdef.0123456789ABCDEFabcdefp-019 0x0123456789ABCDEFabcdef.0123456789ABCDEFabcdefp-019)
                                    (v128.const f64x2 0x0123456789ABCDEFabcdef.0123456789ABCDEFabcdefp019 0x0123456789ABCDEFabcdef.0123456789ABCDEFabcdefp019))
                                    (v128.const f64x2 0x1.23456789abcdfp+61 0x1.23456789abcdfp+61))
(assert_return (invoke "f64x2.pmin" (v128.const f64x2 0x0123456789ABCDEFabcdef.0123456789ABCDEFabcdefp-019 0x0123456789ABCDEFabcdef.0123456789ABCDEFabcdefp-019)
                                    (v128.const f64x2 0x0123456789ABCDEFabcdef.0123456789ABCDEFabcdefp+019 0x0123456789ABCDEFabcdef.0123456789ABCDEFabcdefp+019))
                                    (v128.const f64x2 0x1.23456789abcdfp+61 0x1.23456789abcdfp+61))
(assert_return (invoke "f64x2.pmin" (v128.const f64x2 0x0123456789ABCDEFabcdef.0123456789ABCDEFabcdefp-019 0x0123456789ABCDEFabcdef.0123456789ABCDEFabcdefp-019)
                                    (v128.const f64x2 0x0123456789ABCDEFabcdef.0123456789ABCDEFabcdefp-019 0x0123456789ABCDEFabcdef.0123456789ABCDEFabcdefp-019))
                                    (v128.const f64x2 0x1.23456789abcdfp+61 0x1.23456789abcdfp+61))
(assert_return (invoke "f64x2.pmin" (v128.const f64x2 nan nan)
                                    (v128.const f64x2 0x0p+0 0x0p+0))
                                    (v128.const f64x2 nan nan))
(assert_return (invoke "f64x2.pmin" (v128.const f64x2 nan nan)
                                    (v128.const f64x2 -0x0p+0 -0x0p+0))
                                    (v128.const f64x2 nan nan))
(assert_return (invoke "f64x2.pmin" (v128.const f64x2 nan nan)
                                    (v128.const f64x2 0x1p-1022 0x1p-1022))
                                    (v128.const f64x2 nan nan))
(assert_return (invoke "f64x2.pmin" (v128.const f64x2 nan nan)
                                    (v128.const f64x2 -0x1p-1022 -0x1p-1022))
                                    (v128.const f64x2 nan nan))
(assert_return (invoke "f64x2.pmin" (v128.const f64x2 nan nan)
                                    (v128.const f64x2 0x1p-1 0x1p-1))
                                    (v128.const f64x2 nan nan))
(assert_return (invoke "f64x2.pmin" (v128.const f64x2 nan nan)
                                    (v128.const f64x2 -0x1p-1 -0x1p-1))
                                    (v128.const f64x2 nan nan))
(assert_return (invoke "f64x2.pmin" (v128.const f64x2 nan nan)
                                    (v128.const f64x2 0x1p+0 0x1p+0))
                                    (v128.const f64x2 nan nan))
(assert_return (invoke "f64x2.pmin" (v128.const f64x2 nan nan)
                                    (v128.const f64x2 -0x1p+0 -0x1p+0))
                                    (v128.const f64x2 nan nan))
(assert_return (invoke "f64x2.pmin" (v128.const f64x2 nan nan)
                                    (v128.const f64x2 0x1.921fb54442d18p+2 0x1.921fb54442d18p+2))
                                    (v128.const f64x2 nan nan))
(assert_return (invoke "f64x2.pmin" (v128.const f64x2 nan nan)
                                    (v128.const f64x2 -0x1.921fb54442d18p+2 -0x1.921fb54442d18p+2))
                                    (v128.const f64x2 nan nan))
(assert_return (invoke "f64x2.pmin" (v128.const f64x2 nan nan)
                                    (v128.const f64x2 0x1.fffffffffffffp+1023 0x1.fffffffffffffp+1023))
                                    (v128.const f64x2 nan nan))
(assert_return (invoke "f64x2.pmin" (v128.const f64x2 nan nan)
                                    (v128.const f64x2 -0x1.fffffffffffffp+1023 -0x1.fffffffffffffp+1023))
                                    (v128.const f64x2 nan nan))
(assert_return (invoke "f64x2.pmin" (v128.const f64x2 nan nan)
                                    (v128.const f64x2 0x0.0000000000001p-1022 0x0.0000000000001p-1022))
                                    (v128.const f64x2 nan nan))
(assert_return (invoke "f64x2.pmin" (v128.const f64x2 nan nan)
                                    (v128.const f64x2 0x0.0000000000001p-1022 0x0.0000000000001p-1022))
                                    (v128.const f64x2 nan nan))
(assert_return (invoke "f64x2.pmin" (v128.const f64x2 nan nan)
                                    (v128.const f64x2 inf inf))
                                    (v128.const f64x2 nan nan))
(assert_return (invoke "f64x2.pmin" (v128.const f64x2 nan nan)
                                    (v128.const f64x2 -inf -inf))
                                    (v128.const f64x2 nan nan))
(assert_return (invoke "f64x2.pmin" (v128.const f64x2 nan nan)
                                    (v128.const f64x2 0123456789 0123456789))
                                    (v128.const f64x2 nan nan))
(assert_return (invoke "f64x2.pmin" (v128.const f64x2 nan nan)
                                    (v128.const f64x2 0123456789e019 0123456789e019))
                                    (v128.const f64x2 nan nan))
(assert_return (invoke "f64x2.pmin" (v128.const f64x2 nan nan)
                                    (v128.const f64x2 0123456789e+019 0123456789e+019))
                                    (v128.const f64x2 nan nan))
(assert_return (invoke "f64x2.pmin" (v128.const f64x2 nan nan)
                                    (v128.const f64x2 0123456789e-019 0123456789e-019))
                                    (v128.const f64x2 nan nan))
(assert_return (invoke "f64x2.pmin" (v128.const f64x2 nan nan)
                                    (v128.const f64x2 0123456789. 0123456789.))
                                    (v128.const f64x2 nan nan))
(assert_return (invoke "f64x2.pmin" (v128.const f64x2 nan nan)
                                    (v128.const f64x2 0123456789.e019 0123456789.e019))
                                    (v128.const f64x2 nan nan))
(assert_return (invoke "f64x2.pmin" (v128.const f64x2 nan nan)
                                    (v128.const f64x2 0123456789.e+019 0123456789.e+019))
                                    (v128.const f64x2 nan nan))
(assert_return (invoke "f64x2.pmin" (v128.const f64x2 nan nan)
                                    (v128.const f64x2 0123456789.e-019 0123456789.e-019))
                                    (v128.const f64x2 nan nan))
(assert_return (invoke "f64x2.pmin" (v128.const f64x2 nan nan)
                                    (v128.const f64x2 0123456789.0123456789 0123456789.0123456789))
                                    (v128.const f64x2 nan nan))
(assert_return (invoke "f64x2.pmin" (v128.const f64x2 nan nan)
                                    (v128.const f64x2 0123456789.0123456789e019 0123456789.0123456789e019))
                                    (v128.const f64x2 nan nan))
(assert_return (invoke "f64x2.pmin" (v128.const f64x2 nan nan)
                                    (v128.const f64x2 0123456789.0123456789e+019 0123456789.0123456789e+019))
                                    (v128.const f64x2 nan nan))
(assert_return (invoke "f64x2.pmin" (v128.const f64x2 nan nan)
                                    (v128.const f64x2 0123456789.0123456789e-019 0123456789.0123456789e-019))
                                    (v128.const f64x2 nan nan))
(assert_return (invoke "f64x2.pmin" (v128.const f64x2 nan nan)
                                    (v128.const f64x2 0x0123456789ABCDEFabcdef 0x0123456789ABCDEFabcdef))
                                    (v128.const f64x2 nan nan))
(assert_return (invoke "f64x2.pmin" (v128.const f64x2 nan nan)
                                    (v128.const f64x2 0x0123456789ABCDEFabcdefp019 0x0123456789ABCDEFabcdefp019))
                                    (v128.const f64x2 nan nan))
(assert_return (invoke "f64x2.pmin" (v128.const f64x2 nan nan)
                                    (v128.const f64x2 0x0123456789ABCDEFabcdefp+019 0x0123456789ABCDEFabcdefp+019))
                                    (v128.const f64x2 nan nan))
(assert_return (invoke "f64x2.pmin" (v128.const f64x2 nan nan)
                                    (v128.const f64x2 0x0123456789ABCDEFabcdefp-019 0x0123456789ABCDEFabcdefp-019))
                                    (v128.const f64x2 nan nan))
(assert_return (invoke "f64x2.pmin" (v128.const f64x2 nan nan)
                                    (v128.const f64x2 0x0123456789ABCDEFabcdef. 0x0123456789ABCDEFabcdef.))
                                    (v128.const f64x2 nan nan))
(assert_return (invoke "f64x2.pmin" (v128.const f64x2 nan nan)
                                    (v128.const f64x2 0x0123456789ABCDEFabcdef.p019 0x0123456789ABCDEFabcdef.p019))
                                    (v128.const f64x2 nan nan))
(assert_return (invoke "f64x2.pmin" (v128.const f64x2 nan nan)
                                    (v128.const f64x2 0x0123456789ABCDEFabcdef.p+019 0x0123456789ABCDEFabcdef.p+019))
                                    (v128.const f64x2 nan nan))
(assert_return (invoke "f64x2.pmin" (v128.const f64x2 nan nan)
                                    (v128.const f64x2 0x0123456789ABCDEFabcdef.p-019 0x0123456789ABCDEFabcdef.p-019))
                                    (v128.const f64x2 nan nan))
(assert_return (invoke "f64x2.pmin" (v128.const f64x2 nan nan)
                                    (v128.const f64x2 0x0123456789ABCDEFabcdef.0123456789ABCDEFabcdef 0x0123456789ABCDEFabcdef.0123456789ABCDEFabcdef))
                                    (v128.const f64x2 nan nan))
(assert_return (invoke "f64x2.pmin" (v128.const f64x2 nan nan)
                                    (v128.const f64x2 0x0123456789ABCDEFabcdef.0123456789ABCDEFabcdefp019 0x0123456789ABCDEFabcdef.0123456789ABCDEFabcdefp019))
                                    (v128.const f64x2 nan nan))
(assert_return (invoke "f64x2.pmin" (v128.const f64x2 nan nan)
                                    (v128.const f64x2 0x0123456789ABCDEFabcdef.0123456789ABCDEFabcdefp+019 0x0123456789ABCDEFabcdef.0123456789ABCDEFabcdefp+019))
                                    (v128.const f64x2 nan nan))
(assert_return (invoke "f64x2.pmin" (v128.const f64x2 nan nan)
                                    (v128.const f64x2 0x0123456789ABCDEFabcdef.0123456789ABCDEFabcdefp-019 0x0123456789ABCDEFabcdef.0123456789ABCDEFabcdefp-019))
                                    (v128.const f64x2 nan nan))
(assert_return (invoke "f64x2.pmin" (v128.const f64x2 nan nan)
                                    (v128.const f64x2 nan nan))
                                    (v128.const f64x2 nan nan))
(assert_return (invoke "f64x2.pmin" (v128.const f64x2 nan nan)
                                    (v128.const f64x2 -nan -nan))
                                    (v128.const f64x2 nan nan))
(assert_return (invoke "f64x2.pmin" (v128.const f64x2 nan nan)
                                    (v128.const f64x2 nan:0x4000000000000 nan:0x4000000000000))
                                    (v128.const f64x2 nan nan))
(assert_return (invoke "f64x2.pmin" (v128.const f64x2 nan nan)
                                    (v128.const f64x2 -nan:0x4000000000000 -nan:0x4000000000000))
                                    (v128.const f64x2 nan nan))
(assert_return (invoke "f64x2.pmin" (v128.const f64x2 -nan -nan)
                                    (v128.const f64x2 0x0p+0 0x0p+0))
                                    (v128.const f64x2 -nan -nan))
(assert_return (invoke "f64x2.pmin" (v128.const f64x2 -nan -nan)
                                    (v128.const f64x2 -0x0p+0 -0x0p+0))
                                    (v128.const f64x2 -nan -nan))
(assert_return (invoke "f64x2.pmin" (v128.const f64x2 -nan -nan)
                                    (v128.const f64x2 0x1p-1022 0x1p-1022))
                                    (v128.const f64x2 -nan -nan))
(assert_return (invoke "f64x2.pmin" (v128.const f64x2 -nan -nan)
                                    (v128.const f64x2 -0x1p-1022 -0x1p-1022))
                                    (v128.const f64x2 -nan -nan))
(assert_return (invoke "f64x2.pmin" (v128.const f64x2 -nan -nan)
                                    (v128.const f64x2 0x1p-1 0x1p-1))
                                    (v128.const f64x2 -nan -nan))
(assert_return (invoke "f64x2.pmin" (v128.const f64x2 -nan -nan)
                                    (v128.const f64x2 -0x1p-1 -0x1p-1))
                                    (v128.const f64x2 -nan -nan))
(assert_return (invoke "f64x2.pmin" (v128.const f64x2 -nan -nan)
                                    (v128.const f64x2 0x1p+0 0x1p+0))
                                    (v128.const f64x2 -nan -nan))
(assert_return (invoke "f64x2.pmin" (v128.const f64x2 -nan -nan)
                                    (v128.const f64x2 -0x1p+0 -0x1p+0))
                                    (v128.const f64x2 -nan -nan))
(assert_return (invoke "f64x2.pmin" (v128.const f64x2 -nan -nan)
                                    (v128.const f64x2 0x1.921fb54442d18p+2 0x1.921fb54442d18p+2))
                                    (v128.const f64x2 -nan -nan))
(assert_return (invoke "f64x2.pmin" (v128.const f64x2 -nan -nan)
                                    (v128.const f64x2 -0x1.921fb54442d18p+2 -0x1.921fb54442d18p+2))
                                    (v128.const f64x2 -nan -nan))
(assert_return (invoke "f64x2.pmin" (v128.const f64x2 -nan -nan)
                                    (v128.const f64x2 0x1.fffffffffffffp+1023 0x1.fffffffffffffp+1023))
                                    (v128.const f64x2 -nan -nan))
(assert_return (invoke "f64x2.pmin" (v128.const f64x2 -nan -nan)
                                    (v128.const f64x2 -0x1.fffffffffffffp+1023 -0x1.fffffffffffffp+1023))
                                    (v128.const f64x2 -nan -nan))
(assert_return (invoke "f64x2.pmin" (v128.const f64x2 -nan -nan)
                                    (v128.const f64x2 0x0.0000000000001p-1022 0x0.0000000000001p-1022))
                                    (v128.const f64x2 -nan -nan))
(assert_return (invoke "f64x2.pmin" (v128.const f64x2 -nan -nan)
                                    (v128.const f64x2 0x0.0000000000001p-1022 0x0.0000000000001p-1022))
                                    (v128.const f64x2 -nan -nan))
(assert_return (invoke "f64x2.pmin" (v128.const f64x2 -nan -nan)
                                    (v128.const f64x2 inf inf))
                                    (v128.const f64x2 -nan -nan))
(assert_return (invoke "f64x2.pmin" (v128.const f64x2 -nan -nan)
                                    (v128.const f64x2 -inf -inf))
                                    (v128.const f64x2 -nan -nan))
(assert_return (invoke "f64x2.pmin" (v128.const f64x2 -nan -nan)
                                    (v128.const f64x2 0123456789 0123456789))
                                    (v128.const f64x2 -nan -nan))
(assert_return (invoke "f64x2.pmin" (v128.const f64x2 -nan -nan)
                                    (v128.const f64x2 0123456789e019 0123456789e019))
                                    (v128.const f64x2 -nan -nan))
(assert_return (invoke "f64x2.pmin" (v128.const f64x2 -nan -nan)
                                    (v128.const f64x2 0123456789e+019 0123456789e+019))
                                    (v128.const f64x2 -nan -nan))
(assert_return (invoke "f64x2.pmin" (v128.const f64x2 -nan -nan)
                                    (v128.const f64x2 0123456789e-019 0123456789e-019))
                                    (v128.const f64x2 -nan -nan))
(assert_return (invoke "f64x2.pmin" (v128.const f64x2 -nan -nan)
                                    (v128.const f64x2 0123456789. 0123456789.))
                                    (v128.const f64x2 -nan -nan))
(assert_return (invoke "f64x2.pmin" (v128.const f64x2 -nan -nan)
                                    (v128.const f64x2 0123456789.e019 0123456789.e019))
                                    (v128.const f64x2 -nan -nan))
(assert_return (invoke "f64x2.pmin" (v128.const f64x2 -nan -nan)
                                    (v128.const f64x2 0123456789.e+019 0123456789.e+019))
                                    (v128.const f64x2 -nan -nan))
(assert_return (invoke "f64x2.pmin" (v128.const f64x2 -nan -nan)
                                    (v128.const f64x2 0123456789.e-019 0123456789.e-019))
                                    (v128.const f64x2 -nan -nan))
(assert_return (invoke "f64x2.pmin" (v128.const f64x2 -nan -nan)
                                    (v128.const f64x2 0123456789.0123456789 0123456789.0123456789))
                                    (v128.const f64x2 -nan -nan))
(assert_return (invoke "f64x2.pmin" (v128.const f64x2 -nan -nan)
                                    (v128.const f64x2 0123456789.0123456789e019 0123456789.0123456789e019))
                                    (v128.const f64x2 -nan -nan))
(assert_return (invoke "f64x2.pmin" (v128.const f64x2 -nan -nan)
                                    (v128.const f64x2 0123456789.0123456789e+019 0123456789.0123456789e+019))
                                    (v128.const f64x2 -nan -nan))
(assert_return (invoke "f64x2.pmin" (v128.const f64x2 -nan -nan)
                                    (v128.const f64x2 0123456789.0123456789e-019 0123456789.0123456789e-019))
                                    (v128.const f64x2 -nan -nan))
(assert_return (invoke "f64x2.pmin" (v128.const f64x2 -nan -nan)
                                    (v128.const f64x2 0x0123456789ABCDEFabcdef 0x0123456789ABCDEFabcdef))
                                    (v128.const f64x2 -nan -nan))
(assert_return (invoke "f64x2.pmin" (v128.const f64x2 -nan -nan)
                                    (v128.const f64x2 0x0123456789ABCDEFabcdefp019 0x0123456789ABCDEFabcdefp019))
                                    (v128.const f64x2 -nan -nan))
(assert_return (invoke "f64x2.pmin" (v128.const f64x2 -nan -nan)
                                    (v128.const f64x2 0x0123456789ABCDEFabcdefp+019 0x0123456789ABCDEFabcdefp+019))
                                    (v128.const f64x2 -nan -nan))
(assert_return (invoke "f64x2.pmin" (v128.const f64x2 -nan -nan)
                                    (v128.const f64x2 0x0123456789ABCDEFabcdefp-019 0x0123456789ABCDEFabcdefp-019))
                                    (v128.const f64x2 -nan -nan))
(assert_return (invoke "f64x2.pmin" (v128.const f64x2 -nan -nan)
                                    (v128.const f64x2 0x0123456789ABCDEFabcdef. 0x0123456789ABCDEFabcdef.))
                                    (v128.const f64x2 -nan -nan))
(assert_return (invoke "f64x2.pmin" (v128.const f64x2 -nan -nan)
                                    (v128.const f64x2 0x0123456789ABCDEFabcdef.p019 0x0123456789ABCDEFabcdef.p019))
                                    (v128.const f64x2 -nan -nan))
(assert_return (invoke "f64x2.pmin" (v128.const f64x2 -nan -nan)
                                    (v128.const f64x2 0x0123456789ABCDEFabcdef.p+019 0x0123456789ABCDEFabcdef.p+019))
                                    (v128.const f64x2 -nan -nan))
(assert_return (invoke "f64x2.pmin" (v128.const f64x2 -nan -nan)
                                    (v128.const f64x2 0x0123456789ABCDEFabcdef.p-019 0x0123456789ABCDEFabcdef.p-019))
                                    (v128.const f64x2 -nan -nan))
(assert_return (invoke "f64x2.pmin" (v128.const f64x2 -nan -nan)
                                    (v128.const f64x2 0x0123456789ABCDEFabcdef.0123456789ABCDEFabcdef 0x0123456789ABCDEFabcdef.0123456789ABCDEFabcdef))
                                    (v128.const f64x2 -nan -nan))
(assert_return (invoke "f64x2.pmin" (v128.const f64x2 -nan -nan)
                                    (v128.const f64x2 0x0123456789ABCDEFabcdef.0123456789ABCDEFabcdefp019 0x0123456789ABCDEFabcdef.0123456789ABCDEFabcdefp019))
                                    (v128.const f64x2 -nan -nan))
(assert_return (invoke "f64x2.pmin" (v128.const f64x2 -nan -nan)
                                    (v128.const f64x2 0x0123456789ABCDEFabcdef.0123456789ABCDEFabcdefp+019 0x0123456789ABCDEFabcdef.0123456789ABCDEFabcdefp+019))
                                    (v128.const f64x2 -nan -nan))
(assert_return (invoke "f64x2.pmin" (v128.const f64x2 -nan -nan)
                                    (v128.const f64x2 0x0123456789ABCDEFabcdef.0123456789ABCDEFabcdefp-019 0x0123456789ABCDEFabcdef.0123456789ABCDEFabcdefp-019))
                                    (v128.const f64x2 -nan -nan))
(assert_return (invoke "f64x2.pmin" (v128.const f64x2 -nan -nan)
                                    (v128.const f64x2 nan nan))
                                    (v128.const f64x2 -nan -nan))
(assert_return (invoke "f64x2.pmin" (v128.const f64x2 -nan -nan)
                                    (v128.const f64x2 -nan -nan))
                                    (v128.const f64x2 -nan -nan))
(assert_return (invoke "f64x2.pmin" (v128.const f64x2 -nan -nan)
                                    (v128.const f64x2 nan:0x4000000000000 nan:0x4000000000000))
                                    (v128.const f64x2 -nan -nan))
(assert_return (invoke "f64x2.pmin" (v128.const f64x2 -nan -nan)
                                    (v128.const f64x2 -nan:0x4000000000000 -nan:0x4000000000000))
                                    (v128.const f64x2 -nan -nan))
(assert_return (invoke "f64x2.pmin" (v128.const f64x2 nan:0x4000000000000 nan:0x4000000000000)
                                    (v128.const f64x2 0x0p+0 0x0p+0))
                                    (v128.const f64x2 nan:0x4000000000000 nan:0x4000000000000))
(assert_return (invoke "f64x2.pmin" (v128.const f64x2 nan:0x4000000000000 nan:0x4000000000000)
                                    (v128.const f64x2 -0x0p+0 -0x0p+0))
                                    (v128.const f64x2 nan:0x4000000000000 nan:0x4000000000000))
(assert_return (invoke "f64x2.pmin" (v128.const f64x2 nan:0x4000000000000 nan:0x4000000000000)
                                    (v128.const f64x2 0x1p-1022 0x1p-1022))
                                    (v128.const f64x2 nan:0x4000000000000 nan:0x4000000000000))
(assert_return (invoke "f64x2.pmin" (v128.const f64x2 nan:0x4000000000000 nan:0x4000000000000)
                                    (v128.const f64x2 -0x1p-1022 -0x1p-1022))
                                    (v128.const f64x2 nan:0x4000000000000 nan:0x4000000000000))
(assert_return (invoke "f64x2.pmin" (v128.const f64x2 nan:0x4000000000000 nan:0x4000000000000)
                                    (v128.const f64x2 0x1p-1 0x1p-1))
                                    (v128.const f64x2 nan:0x4000000000000 nan:0x4000000000000))
(assert_return (invoke "f64x2.pmin" (v128.const f64x2 nan:0x4000000000000 nan:0x4000000000000)
                                    (v128.const f64x2 -0x1p-1 -0x1p-1))
                                    (v128.const f64x2 nan:0x4000000000000 nan:0x4000000000000))
(assert_return (invoke "f64x2.pmin" (v128.const f64x2 nan:0x4000000000000 nan:0x4000000000000)
                                    (v128.const f64x2 0x1p+0 0x1p+0))
                                    (v128.const f64x2 nan:0x4000000000000 nan:0x4000000000000))
(assert_return (invoke "f64x2.pmin" (v128.const f64x2 nan:0x4000000000000 nan:0x4000000000000)
                                    (v128.const f64x2 -0x1p+0 -0x1p+0))
                                    (v128.const f64x2 nan:0x4000000000000 nan:0x4000000000000))
(assert_return (invoke "f64x2.pmin" (v128.const f64x2 nan:0x4000000000000 nan:0x4000000000000)
                                    (v128.const f64x2 0x1.921fb54442d18p+2 0x1.921fb54442d18p+2))
                                    (v128.const f64x2 nan:0x4000000000000 nan:0x4000000000000))
(assert_return (invoke "f64x2.pmin" (v128.const f64x2 nan:0x4000000000000 nan:0x4000000000000)
                                    (v128.const f64x2 -0x1.921fb54442d18p+2 -0x1.921fb54442d18p+2))
                                    (v128.const f64x2 nan:0x4000000000000 nan:0x4000000000000))
(assert_return (invoke "f64x2.pmin" (v128.const f64x2 nan:0x4000000000000 nan:0x4000000000000)
                                    (v128.const f64x2 0x1.fffffffffffffp+1023 0x1.fffffffffffffp+1023))
                                    (v128.const f64x2 nan:0x4000000000000 nan:0x4000000000000))
(assert_return (invoke "f64x2.pmin" (v128.const f64x2 nan:0x4000000000000 nan:0x4000000000000)
                                    (v128.const f64x2 -0x1.fffffffffffffp+1023 -0x1.fffffffffffffp+1023))
                                    (v128.const f64x2 nan:0x4000000000000 nan:0x4000000000000))
(assert_return (invoke "f64x2.pmin" (v128.const f64x2 nan:0x4000000000000 nan:0x4000000000000)
                                    (v128.const f64x2 0x0.0000000000001p-1022 0x0.0000000000001p-1022))
                                    (v128.const f64x2 nan:0x4000000000000 nan:0x4000000000000))
(assert_return (invoke "f64x2.pmin" (v128.const f64x2 nan:0x4000000000000 nan:0x4000000000000)
                                    (v128.const f64x2 0x0.0000000000001p-1022 0x0.0000000000001p-1022))
                                    (v128.const f64x2 nan:0x4000000000000 nan:0x4000000000000))
(assert_return (invoke "f64x2.pmin" (v128.const f64x2 nan:0x4000000000000 nan:0x4000000000000)
                                    (v128.const f64x2 inf inf))
                                    (v128.const f64x2 nan:0x4000000000000 nan:0x4000000000000))
(assert_return (invoke "f64x2.pmin" (v128.const f64x2 nan:0x4000000000000 nan:0x4000000000000)
                                    (v128.const f64x2 -inf -inf))
                                    (v128.const f64x2 nan:0x4000000000000 nan:0x4000000000000))
(assert_return (invoke "f64x2.pmin" (v128.const f64x2 nan:0x4000000000000 nan:0x4000000000000)
                                    (v128.const f64x2 0123456789 0123456789))
                                    (v128.const f64x2 nan:0x4000000000000 nan:0x4000000000000))
(assert_return (invoke "f64x2.pmin" (v128.const f64x2 nan:0x4000000000000 nan:0x4000000000000)
                                    (v128.const f64x2 0123456789e019 0123456789e019))
                                    (v128.const f64x2 nan:0x4000000000000 nan:0x4000000000000))
(assert_return (invoke "f64x2.pmin" (v128.const f64x2 nan:0x4000000000000 nan:0x4000000000000)
                                    (v128.const f64x2 0123456789e+019 0123456789e+019))
                                    (v128.const f64x2 nan:0x4000000000000 nan:0x4000000000000))
(assert_return (invoke "f64x2.pmin" (v128.const f64x2 nan:0x4000000000000 nan:0x4000000000000)
                                    (v128.const f64x2 0123456789e-019 0123456789e-019))
                                    (v128.const f64x2 nan:0x4000000000000 nan:0x4000000000000))
(assert_return (invoke "f64x2.pmin" (v128.const f64x2 nan:0x4000000000000 nan:0x4000000000000)
                                    (v128.const f64x2 0123456789. 0123456789.))
                                    (v128.const f64x2 nan:0x4000000000000 nan:0x4000000000000))
(assert_return (invoke "f64x2.pmin" (v128.const f64x2 nan:0x4000000000000 nan:0x4000000000000)
                                    (v128.const f64x2 0123456789.e019 0123456789.e019))
                                    (v128.const f64x2 nan:0x4000000000000 nan:0x4000000000000))
(assert_return (invoke "f64x2.pmin" (v128.const f64x2 nan:0x4000000000000 nan:0x4000000000000)
                                    (v128.const f64x2 0123456789.e+019 0123456789.e+019))
                                    (v128.const f64x2 nan:0x4000000000000 nan:0x4000000000000))
(assert_return (invoke "f64x2.pmin" (v128.const f64x2 nan:0x4000000000000 nan:0x4000000000000)
                                    (v128.const f64x2 0123456789.e-019 0123456789.e-019))
                                    (v128.const f64x2 nan:0x4000000000000 nan:0x4000000000000))
(assert_return (invoke "f64x2.pmin" (v128.const f64x2 nan:0x4000000000000 nan:0x4000000000000)
                                    (v128.const f64x2 0123456789.0123456789 0123456789.0123456789))
                                    (v128.const f64x2 nan:0x4000000000000 nan:0x4000000000000))
(assert_return (invoke "f64x2.pmin" (v128.const f64x2 nan:0x4000000000000 nan:0x4000000000000)
                                    (v128.const f64x2 0123456789.0123456789e019 0123456789.0123456789e019))
                                    (v128.const f64x2 nan:0x4000000000000 nan:0x4000000000000))
(assert_return (invoke "f64x2.pmin" (v128.const f64x2 nan:0x4000000000000 nan:0x4000000000000)
                                    (v128.const f64x2 0123456789.0123456789e+019 0123456789.0123456789e+019))
                                    (v128.const f64x2 nan:0x4000000000000 nan:0x4000000000000))
(assert_return (invoke "f64x2.pmin" (v128.const f64x2 nan:0x4000000000000 nan:0x4000000000000)
                                    (v128.const f64x2 0123456789.0123456789e-019 0123456789.0123456789e-019))
                                    (v128.const f64x2 nan:0x4000000000000 nan:0x4000000000000))
(assert_return (invoke "f64x2.pmin" (v128.const f64x2 nan:0x4000000000000 nan:0x4000000000000)
                                    (v128.const f64x2 0x0123456789ABCDEFabcdef 0x0123456789ABCDEFabcdef))
                                    (v128.const f64x2 nan:0x4000000000000 nan:0x4000000000000))
(assert_return (invoke "f64x2.pmin" (v128.const f64x2 nan:0x4000000000000 nan:0x4000000000000)
                                    (v128.const f64x2 0x0123456789ABCDEFabcdefp019 0x0123456789ABCDEFabcdefp019))
                                    (v128.const f64x2 nan:0x4000000000000 nan:0x4000000000000))
(assert_return (invoke "f64x2.pmin" (v128.const f64x2 nan:0x4000000000000 nan:0x4000000000000)
                                    (v128.const f64x2 0x0123456789ABCDEFabcdefp+019 0x0123456789ABCDEFabcdefp+019))
                                    (v128.const f64x2 nan:0x4000000000000 nan:0x4000000000000))
(assert_return (invoke "f64x2.pmin" (v128.const f64x2 nan:0x4000000000000 nan:0x4000000000000)
                                    (v128.const f64x2 0x0123456789ABCDEFabcdefp-019 0x0123456789ABCDEFabcdefp-019))
                                    (v128.const f64x2 nan:0x4000000000000 nan:0x4000000000000))
(assert_return (invoke "f64x2.pmin" (v128.const f64x2 nan:0x4000000000000 nan:0x4000000000000)
                                    (v128.const f64x2 0x0123456789ABCDEFabcdef. 0x0123456789ABCDEFabcdef.))
                                    (v128.const f64x2 nan:0x4000000000000 nan:0x4000000000000))
(assert_return (invoke "f64x2.pmin" (v128.const f64x2 nan:0x4000000000000 nan:0x4000000000000)
                                    (v128.const f64x2 0x0123456789ABCDEFabcdef.p019 0x0123456789ABCDEFabcdef.p019))
                                    (v128.const f64x2 nan:0x4000000000000 nan:0x4000000000000))
(assert_return (invoke "f64x2.pmin" (v128.const f64x2 nan:0x4000000000000 nan:0x4000000000000)
                                    (v128.const f64x2 0x0123456789ABCDEFabcdef.p+019 0x0123456789ABCDEFabcdef.p+019))
                                    (v128.const f64x2 nan:0x4000000000000 nan:0x4000000000000))
(assert_return (invoke "f64x2.pmin" (v128.const f64x2 nan:0x4000000000000 nan:0x4000000000000)
                                    (v128.const f64x2 0x0123456789ABCDEFabcdef.p-019 0x0123456789ABCDEFabcdef.p-019))
                                    (v128.const f64x2 nan:0x4000000000000 nan:0x4000000000000))
(assert_return (invoke "f64x2.pmin" (v128.const f64x2 nan:0x4000000000000 nan:0x4000000000000)
                                    (v128.const f64x2 0x0123456789ABCDEFabcdef.0123456789ABCDEFabcdef 0x0123456789ABCDEFabcdef.0123456789ABCDEFabcdef))
                                    (v128.const f64x2 nan:0x4000000000000 nan:0x4000000000000))
(assert_return (invoke "f64x2.pmin" (v128.const f64x2 nan:0x4000000000000 nan:0x4000000000000)
                                    (v128.const f64x2 0x0123456789ABCDEFabcdef.0123456789ABCDEFabcdefp019 0x0123456789ABCDEFabcdef.0123456789ABCDEFabcdefp019))
                                    (v128.const f64x2 nan:0x4000000000000 nan:0x4000000000000))
(assert_return (invoke "f64x2.pmin" (v128.const f64x2 nan:0x4000000000000 nan:0x4000000000000)
                                    (v128.const f64x2 0x0123456789ABCDEFabcdef.0123456789ABCDEFabcdefp+019 0x0123456789ABCDEFabcdef.0123456789ABCDEFabcdefp+019))
                                    (v128.const f64x2 nan:0x4000000000000 nan:0x4000000000000))
(assert_return (invoke "f64x2.pmin" (v128.const f64x2 nan:0x4000000000000 nan:0x4000000000000)
                                    (v128.const f64x2 0x0123456789ABCDEFabcdef.0123456789ABCDEFabcdefp-019 0x0123456789ABCDEFabcdef.0123456789ABCDEFabcdefp-019))
                                    (v128.const f64x2 nan:0x4000000000000 nan:0x4000000000000))
(assert_return (invoke "f64x2.pmin" (v128.const f64x2 nan:0x4000000000000 nan:0x4000000000000)
                                    (v128.const f64x2 nan nan))
                                    (v128.const f64x2 nan:0x4000000000000 nan:0x4000000000000))
(assert_return (invoke "f64x2.pmin" (v128.const f64x2 nan:0x4000000000000 nan:0x4000000000000)
                                    (v128.const f64x2 -nan -nan))
                                    (v128.const f64x2 nan:0x4000000000000 nan:0x4000000000000))
(assert_return (invoke "f64x2.pmin" (v128.const f64x2 nan:0x4000000000000 nan:0x4000000000000)
                                    (v128.const f64x2 nan:0x4000000000000 nan:0x4000000000000))
                                    (v128.const f64x2 nan:0x4000000000000 nan:0x4000000000000))
(assert_return (invoke "f64x2.pmin" (v128.const f64x2 nan:0x4000000000000 nan:0x4000000000000)
                                    (v128.const f64x2 -nan:0x4000000000000 -nan:0x4000000000000))
                                    (v128.const f64x2 nan:0x4000000000000 nan:0x4000000000000))
(assert_return (invoke "f64x2.pmin" (v128.const f64x2 -nan:0x4000000000000 -nan:0x4000000000000)
                                    (v128.const f64x2 0x0p+0 0x0p+0))
                                    (v128.const f64x2 -nan:0x4000000000000 -nan:0x4000000000000))
(assert_return (invoke "f64x2.pmin" (v128.const f64x2 -nan:0x4000000000000 -nan:0x4000000000000)
                                    (v128.const f64x2 -0x0p+0 -0x0p+0))
                                    (v128.const f64x2 -nan:0x4000000000000 -nan:0x4000000000000))
(assert_return (invoke "f64x2.pmin" (v128.const f64x2 -nan:0x4000000000000 -nan:0x4000000000000)
                                    (v128.const f64x2 0x1p-1022 0x1p-1022))
                                    (v128.const f64x2 -nan:0x4000000000000 -nan:0x4000000000000))
(assert_return (invoke "f64x2.pmin" (v128.const f64x2 -nan:0x4000000000000 -nan:0x4000000000000)
                                    (v128.const f64x2 -0x1p-1022 -0x1p-1022))
                                    (v128.const f64x2 -nan:0x4000000000000 -nan:0x4000000000000))
(assert_return (invoke "f64x2.pmin" (v128.const f64x2 -nan:0x4000000000000 -nan:0x4000000000000)
                                    (v128.const f64x2 0x1p-1 0x1p-1))
                                    (v128.const f64x2 -nan:0x4000000000000 -nan:0x4000000000000))
(assert_return (invoke "f64x2.pmin" (v128.const f64x2 -nan:0x4000000000000 -nan:0x4000000000000)
                                    (v128.const f64x2 -0x1p-1 -0x1p-1))
                                    (v128.const f64x2 -nan:0x4000000000000 -nan:0x4000000000000))
(assert_return (invoke "f64x2.pmin" (v128.const f64x2 -nan:0x4000000000000 -nan:0x4000000000000)
                                    (v128.const f64x2 0x1p+0 0x1p+0))
                                    (v128.const f64x2 -nan:0x4000000000000 -nan:0x4000000000000))
(assert_return (invoke "f64x2.pmin" (v128.const f64x2 -nan:0x4000000000000 -nan:0x4000000000000)
                                    (v128.const f64x2 -0x1p+0 -0x1p+0))
                                    (v128.const f64x2 -nan:0x4000000000000 -nan:0x4000000000000))
(assert_return (invoke "f64x2.pmin" (v128.const f64x2 -nan:0x4000000000000 -nan:0x4000000000000)
                                    (v128.const f64x2 0x1.921fb54442d18p+2 0x1.921fb54442d18p+2))
                                    (v128.const f64x2 -nan:0x4000000000000 -nan:0x4000000000000))
(assert_return (invoke "f64x2.pmin" (v128.const f64x2 -nan:0x4000000000000 -nan:0x4000000000000)
                                    (v128.const f64x2 -0x1.921fb54442d18p+2 -0x1.921fb54442d18p+2))
                                    (v128.const f64x2 -nan:0x4000000000000 -nan:0x4000000000000))
(assert_return (invoke "f64x2.pmin" (v128.const f64x2 -nan:0x4000000000000 -nan:0x4000000000000)
                                    (v128.const f64x2 0x1.fffffffffffffp+1023 0x1.fffffffffffffp+1023))
                                    (v128.const f64x2 -nan:0x4000000000000 -nan:0x4000000000000))
(assert_return (invoke "f64x2.pmin" (v128.const f64x2 -nan:0x4000000000000 -nan:0x4000000000000)
                                    (v128.const f64x2 -0x1.fffffffffffffp+1023 -0x1.fffffffffffffp+1023))
                                    (v128.const f64x2 -nan:0x4000000000000 -nan:0x4000000000000))
(assert_return (invoke "f64x2.pmin" (v128.const f64x2 -nan:0x4000000000000 -nan:0x4000000000000)
                                    (v128.const f64x2 0x0.0000000000001p-1022 0x0.0000000000001p-1022))
                                    (v128.const f64x2 -nan:0x4000000000000 -nan:0x4000000000000))
(assert_return (invoke "f64x2.pmin" (v128.const f64x2 -nan:0x4000000000000 -nan:0x4000000000000)
                                    (v128.const f64x2 0x0.0000000000001p-1022 0x0.0000000000001p-1022))
                                    (v128.const f64x2 -nan:0x4000000000000 -nan:0x4000000000000))
(assert_return (invoke "f64x2.pmin" (v128.const f64x2 -nan:0x4000000000000 -nan:0x4000000000000)
                                    (v128.const f64x2 inf inf))
                                    (v128.const f64x2 -nan:0x4000000000000 -nan:0x4000000000000))
(assert_return (invoke "f64x2.pmin" (v128.const f64x2 -nan:0x4000000000000 -nan:0x4000000000000)
                                    (v128.const f64x2 -inf -inf))
                                    (v128.const f64x2 -nan:0x4000000000000 -nan:0x4000000000000))
(assert_return (invoke "f64x2.pmin" (v128.const f64x2 -nan:0x4000000000000 -nan:0x4000000000000)
                                    (v128.const f64x2 0123456789 0123456789))
                                    (v128.const f64x2 -nan:0x4000000000000 -nan:0x4000000000000))
(assert_return (invoke "f64x2.pmin" (v128.const f64x2 -nan:0x4000000000000 -nan:0x4000000000000)
                                    (v128.const f64x2 0123456789e019 0123456789e019))
                                    (v128.const f64x2 -nan:0x4000000000000 -nan:0x4000000000000))
(assert_return (invoke "f64x2.pmin" (v128.const f64x2 -nan:0x4000000000000 -nan:0x4000000000000)
                                    (v128.const f64x2 0123456789e+019 0123456789e+019))
                                    (v128.const f64x2 -nan:0x4000000000000 -nan:0x4000000000000))
(assert_return (invoke "f64x2.pmin" (v128.const f64x2 -nan:0x4000000000000 -nan:0x4000000000000)
                                    (v128.const f64x2 0123456789e-019 0123456789e-019))
                                    (v128.const f64x2 -nan:0x4000000000000 -nan:0x4000000000000))
(assert_return (invoke "f64x2.pmin" (v128.const f64x2 -nan:0x4000000000000 -nan:0x4000000000000)
                                    (v128.const f64x2 0123456789. 0123456789.))
                                    (v128.const f64x2 -nan:0x4000000000000 -nan:0x4000000000000))
(assert_return (invoke "f64x2.pmin" (v128.const f64x2 -nan:0x4000000000000 -nan:0x4000000000000)
                                    (v128.const f64x2 0123456789.e019 0123456789.e019))
                                    (v128.const f64x2 -nan:0x4000000000000 -nan:0x4000000000000))
(assert_return (invoke "f64x2.pmin" (v128.const f64x2 -nan:0x4000000000000 -nan:0x4000000000000)
                                    (v128.const f64x2 0123456789.e+019 0123456789.e+019))
                                    (v128.const f64x2 -nan:0x4000000000000 -nan:0x4000000000000))
(assert_return (invoke "f64x2.pmin" (v128.const f64x2 -nan:0x4000000000000 -nan:0x4000000000000)
                                    (v128.const f64x2 0123456789.e-019 0123456789.e-019))
                                    (v128.const f64x2 -nan:0x4000000000000 -nan:0x4000000000000))
(assert_return (invoke "f64x2.pmin" (v128.const f64x2 -nan:0x4000000000000 -nan:0x4000000000000)
                                    (v128.const f64x2 0123456789.0123456789 0123456789.0123456789))
                                    (v128.const f64x2 -nan:0x4000000000000 -nan:0x4000000000000))
(assert_return (invoke "f64x2.pmin" (v128.const f64x2 -nan:0x4000000000000 -nan:0x4000000000000)
                                    (v128.const f64x2 0123456789.0123456789e019 0123456789.0123456789e019))
                                    (v128.const f64x2 -nan:0x4000000000000 -nan:0x4000000000000))
(assert_return (invoke "f64x2.pmin" (v128.const f64x2 -nan:0x4000000000000 -nan:0x4000000000000)
                                    (v128.const f64x2 0123456789.0123456789e+019 0123456789.0123456789e+019))
                                    (v128.const f64x2 -nan:0x4000000000000 -nan:0x4000000000000))
(assert_return (invoke "f64x2.pmin" (v128.const f64x2 -nan:0x4000000000000 -nan:0x4000000000000)
                                    (v128.const f64x2 0123456789.0123456789e-019 0123456789.0123456789e-019))
                                    (v128.const f64x2 -nan:0x4000000000000 -nan:0x4000000000000))
(assert_return (invoke "f64x2.pmin" (v128.const f64x2 -nan:0x4000000000000 -nan:0x4000000000000)
                                    (v128.const f64x2 0x0123456789ABCDEFabcdef 0x0123456789ABCDEFabcdef))
                                    (v128.const f64x2 -nan:0x4000000000000 -nan:0x4000000000000))
(assert_return (invoke "f64x2.pmin" (v128.const f64x2 -nan:0x4000000000000 -nan:0x4000000000000)
                                    (v128.const f64x2 0x0123456789ABCDEFabcdefp019 0x0123456789ABCDEFabcdefp019))
                                    (v128.const f64x2 -nan:0x4000000000000 -nan:0x4000000000000))
(assert_return (invoke "f64x2.pmin" (v128.const f64x2 -nan:0x4000000000000 -nan:0x4000000000000)
                                    (v128.const f64x2 0x0123456789ABCDEFabcdefp+019 0x0123456789ABCDEFabcdefp+019))
                                    (v128.const f64x2 -nan:0x4000000000000 -nan:0x4000000000000))
(assert_return (invoke "f64x2.pmin" (v128.const f64x2 -nan:0x4000000000000 -nan:0x4000000000000)
                                    (v128.const f64x2 0x0123456789ABCDEFabcdefp-019 0x0123456789ABCDEFabcdefp-019))
                                    (v128.const f64x2 -nan:0x4000000000000 -nan:0x4000000000000))
(assert_return (invoke "f64x2.pmin" (v128.const f64x2 -nan:0x4000000000000 -nan:0x4000000000000)
                                    (v128.const f64x2 0x0123456789ABCDEFabcdef. 0x0123456789ABCDEFabcdef.))
                                    (v128.const f64x2 -nan:0x4000000000000 -nan:0x4000000000000))
(assert_return (invoke "f64x2.pmin" (v128.const f64x2 -nan:0x4000000000000 -nan:0x4000000000000)
                                    (v128.const f64x2 0x0123456789ABCDEFabcdef.p019 0x0123456789ABCDEFabcdef.p019))
                                    (v128.const f64x2 -nan:0x4000000000000 -nan:0x4000000000000))
(assert_return (invoke "f64x2.pmin" (v128.const f64x2 -nan:0x4000000000000 -nan:0x4000000000000)
                                    (v128.const f64x2 0x0123456789ABCDEFabcdef.p+019 0x0123456789ABCDEFabcdef.p+019))
                                    (v128.const f64x2 -nan:0x4000000000000 -nan:0x4000000000000))
(assert_return (invoke "f64x2.pmin" (v128.const f64x2 -nan:0x4000000000000 -nan:0x4000000000000)
                                    (v128.const f64x2 0x0123456789ABCDEFabcdef.p-019 0x0123456789ABCDEFabcdef.p-019))
                                    (v128.const f64x2 -nan:0x4000000000000 -nan:0x4000000000000))
(assert_return (invoke "f64x2.pmin" (v128.const f64x2 -nan:0x4000000000000 -nan:0x4000000000000)
                                    (v128.const f64x2 0x0123456789ABCDEFabcdef.0123456789ABCDEFabcdef 0x0123456789ABCDEFabcdef.0123456789ABCDEFabcdef))
                                    (v128.const f64x2 -nan:0x4000000000000 -nan:0x4000000000000))
(assert_return (invoke "f64x2.pmin" (v128.const f64x2 -nan:0x4000000000000 -nan:0x4000000000000)
                                    (v128.const f64x2 0x0123456789ABCDEFabcdef.0123456789ABCDEFabcdefp019 0x0123456789ABCDEFabcdef.0123456789ABCDEFabcdefp019))
                                    (v128.const f64x2 -nan:0x4000000000000 -nan:0x4000000000000))
(assert_return (invoke "f64x2.pmin" (v128.const f64x2 -nan:0x4000000000000 -nan:0x4000000000000)
                                    (v128.const f64x2 0x0123456789ABCDEFabcdef.0123456789ABCDEFabcdefp+019 0x0123456789ABCDEFabcdef.0123456789ABCDEFabcdefp+019))
                                    (v128.const f64x2 -nan:0x4000000000000 -nan:0x4000000000000))
(assert_return (invoke "f64x2.pmin" (v128.const f64x2 -nan:0x4000000000000 -nan:0x4000000000000)
                                    (v128.const f64x2 0x0123456789ABCDEFabcdef.0123456789ABCDEFabcdefp-019 0x0123456789ABCDEFabcdef.0123456789ABCDEFabcdefp-019))
                                    (v128.const f64x2 -nan:0x4000000000000 -nan:0x4000000000000))
(assert_return (invoke "f64x2.pmin" (v128.const f64x2 -nan:0x4000000000000 -nan:0x4000000000000)
                                    (v128.const f64x2 nan nan))
                                    (v128.const f64x2 -nan:0x4000000000000 -nan:0x4000000000000))
(assert_return (invoke "f64x2.pmin" (v128.const f64x2 -nan:0x4000000000000 -nan:0x4000000000000)
                                    (v128.const f64x2 -nan -nan))
                                    (v128.const f64x2 -nan:0x4000000000000 -nan:0x4000000000000))
(assert_return (invoke "f64x2.pmin" (v128.const f64x2 -nan:0x4000000000000 -nan:0x4000000000000)
                                    (v128.const f64x2 nan:0x4000000000000 nan:0x4000000000000))
                                    (v128.const f64x2 -nan:0x4000000000000 -nan:0x4000000000000))
(assert_return (invoke "f64x2.pmin" (v128.const f64x2 -nan:0x4000000000000 -nan:0x4000000000000)
                                    (v128.const f64x2 -nan:0x4000000000000 -nan:0x4000000000000))
                                    (v128.const f64x2 -nan:0x4000000000000 -nan:0x4000000000000))
(assert_return (invoke "f64x2.pmin" (v128.const f64x2 0x0p+0 0x0p+0)
                                    (v128.const f64x2 nan nan))
                                    (v128.const f64x2 0x0p+0 0x0p+0))
(assert_return (invoke "f64x2.pmin" (v128.const f64x2 -0x0p+0 -0x0p+0)
                                    (v128.const f64x2 nan nan))
                                    (v128.const f64x2 -0x0p+0 -0x0p+0))
(assert_return (invoke "f64x2.pmin" (v128.const f64x2 0x1p-1022 0x1p-1022)
                                    (v128.const f64x2 nan nan))
                                    (v128.const f64x2 0x1p-1022 0x1p-1022))
(assert_return (invoke "f64x2.pmin" (v128.const f64x2 -0x1p-1022 -0x1p-1022)
                                    (v128.const f64x2 nan nan))
                                    (v128.const f64x2 -0x1p-1022 -0x1p-1022))
(assert_return (invoke "f64x2.pmin" (v128.const f64x2 0x1p-1 0x1p-1)
                                    (v128.const f64x2 nan nan))
                                    (v128.const f64x2 0x1p-1 0x1p-1))
(assert_return (invoke "f64x2.pmin" (v128.const f64x2 -0x1p-1 -0x1p-1)
                                    (v128.const f64x2 nan nan))
                                    (v128.const f64x2 -0x1p-1 -0x1p-1))
(assert_return (invoke "f64x2.pmin" (v128.const f64x2 0x1p+0 0x1p+0)
                                    (v128.const f64x2 nan nan))
                                    (v128.const f64x2 0x1p+0 0x1p+0))
(assert_return (invoke "f64x2.pmin" (v128.const f64x2 -0x1p+0 -0x1p+0)
                                    (v128.const f64x2 nan nan))
                                    (v128.const f64x2 -0x1p+0 -0x1p+0))
(assert_return (invoke "f64x2.pmin" (v128.const f64x2 0x1.921fb54442d18p+2 0x1.921fb54442d18p+2)
                                    (v128.const f64x2 nan nan))
                                    (v128.const f64x2 0x1.921fb54442d18p+2 0x1.921fb54442d18p+2))
(assert_return (invoke "f64x2.pmin" (v128.const f64x2 -0x1.921fb54442d18p+2 -0x1.921fb54442d18p+2)
                                    (v128.const f64x2 nan nan))
                                    (v128.const f64x2 -0x1.921fb54442d18p+2 -0x1.921fb54442d18p+2))
(assert_return (invoke "f64x2.pmin" (v128.const f64x2 0x1.fffffffffffffp+1023 0x1.fffffffffffffp+1023)
                                    (v128.const f64x2 nan nan))
                                    (v128.const f64x2 0x1.fffffffffffffp+1023 0x1.fffffffffffffp+1023))
(assert_return (invoke "f64x2.pmin" (v128.const f64x2 -0x1.fffffffffffffp+1023 -0x1.fffffffffffffp+1023)
                                    (v128.const f64x2 nan nan))
                                    (v128.const f64x2 -0x1.fffffffffffffp+1023 -0x1.fffffffffffffp+1023))
(assert_return (invoke "f64x2.pmin" (v128.const f64x2 0x0.0000000000001p-1022 0x0.0000000000001p-1022)
                                    (v128.const f64x2 nan nan))
                                    (v128.const f64x2 0x0.0000000000001p-1022 0x0.0000000000001p-1022))
(assert_return (invoke "f64x2.pmin" (v128.const f64x2 0x0.0000000000001p-1022 0x0.0000000000001p-1022)
                                    (v128.const f64x2 nan nan))
                                    (v128.const f64x2 0x0.0000000000001p-1022 0x0.0000000000001p-1022))
(assert_return (invoke "f64x2.pmin" (v128.const f64x2 inf inf)
                                    (v128.const f64x2 nan nan))
                                    (v128.const f64x2 inf inf))
(assert_return (invoke "f64x2.pmin" (v128.const f64x2 -inf -inf)
                                    (v128.const f64x2 nan nan))
                                    (v128.const f64x2 -inf -inf))
(assert_return (invoke "f64x2.pmin" (v128.const f64x2 0123456789 0123456789)
                                    (v128.const f64x2 nan nan))
                                    (v128.const f64x2 0123456789 0123456789))
(assert_return (invoke "f64x2.pmin" (v128.const f64x2 0123456789e019 0123456789e019)
                                    (v128.const f64x2 nan nan))
                                    (v128.const f64x2 0123456789e019 0123456789e019))
(assert_return (invoke "f64x2.pmin" (v128.const f64x2 0123456789e+019 0123456789e+019)
                                    (v128.const f64x2 nan nan))
                                    (v128.const f64x2 0123456789e+019 0123456789e+019))
(assert_return (invoke "f64x2.pmin" (v128.const f64x2 0123456789e-019 0123456789e-019)
                                    (v128.const f64x2 nan nan))
                                    (v128.const f64x2 0123456789e-019 0123456789e-019))
(assert_return (invoke "f64x2.pmin" (v128.const f64x2 0123456789. 0123456789.)
                                    (v128.const f64x2 nan nan))
                                    (v128.const f64x2 0123456789. 0123456789.))
(assert_return (invoke "f64x2.pmin" (v128.const f64x2 0123456789.e019 0123456789.e019)
                                    (v128.const f64x2 nan nan))
                                    (v128.const f64x2 0123456789.e019 0123456789.e019))
(assert_return (invoke "f64x2.pmin" (v128.const f64x2 0123456789.e+019 0123456789.e+019)
                                    (v128.const f64x2 nan nan))
                                    (v128.const f64x2 0123456789.e+019 0123456789.e+019))
(assert_return (invoke "f64x2.pmin" (v128.const f64x2 0123456789.e-019 0123456789.e-019)
                                    (v128.const f64x2 nan nan))
                                    (v128.const f64x2 0123456789.e-019 0123456789.e-019))
(assert_return (invoke "f64x2.pmin" (v128.const f64x2 0123456789.0123456789 0123456789.0123456789)
                                    (v128.const f64x2 nan nan))
                                    (v128.const f64x2 0123456789.0123456789 0123456789.0123456789))
(assert_return (invoke "f64x2.pmin" (v128.const f64x2 0123456789.0123456789e019 0123456789.0123456789e019)
                                    (v128.const f64x2 nan nan))
                                    (v128.const f64x2 0123456789.0123456789e019 0123456789.0123456789e019))
(assert_return (invoke "f64x2.pmin" (v128.const f64x2 0123456789.0123456789e+019 0123456789.0123456789e+019)
                                    (v128.const f64x2 nan nan))
                                    (v128.const f64x2 0123456789.0123456789e+019 0123456789.0123456789e+019))
(assert_return (invoke "f64x2.pmin" (v128.const f64x2 0123456789.0123456789e-019 0123456789.0123456789e-019)
                                    (v128.const f64x2 nan nan))
                                    (v128.const f64x2 0123456789.0123456789e-019 0123456789.0123456789e-019))
(assert_return (invoke "f64x2.pmin" (v128.const f64x2 0x0123456789ABCDEFabcdef 0x0123456789ABCDEFabcdef)
                                    (v128.const f64x2 nan nan))
                                    (v128.const f64x2 0x0123456789ABCDEFabcdef 0x0123456789ABCDEFabcdef))
(assert_return (invoke "f64x2.pmin" (v128.const f64x2 0x0123456789ABCDEFabcdefp019 0x0123456789ABCDEFabcdefp019)
                                    (v128.const f64x2 nan nan))
                                    (v128.const f64x2 0x0123456789ABCDEFabcdefp019 0x0123456789ABCDEFabcdefp019))
(assert_return (invoke "f64x2.pmin" (v128.const f64x2 0x0123456789ABCDEFabcdefp+019 0x0123456789ABCDEFabcdefp+019)
                                    (v128.const f64x2 nan nan))
                                    (v128.const f64x2 0x0123456789ABCDEFabcdefp+019 0x0123456789ABCDEFabcdefp+019))
(assert_return (invoke "f64x2.pmin" (v128.const f64x2 0x0123456789ABCDEFabcdefp-019 0x0123456789ABCDEFabcdefp-019)
                                    (v128.const f64x2 nan nan))
                                    (v128.const f64x2 0x0123456789ABCDEFabcdefp-019 0x0123456789ABCDEFabcdefp-019))
(assert_return (invoke "f64x2.pmin" (v128.const f64x2 0x0123456789ABCDEFabcdef. 0x0123456789ABCDEFabcdef.)
                                    (v128.const f64x2 nan nan))
                                    (v128.const f64x2 0x0123456789ABCDEFabcdef. 0x0123456789ABCDEFabcdef.))
(assert_return (invoke "f64x2.pmin" (v128.const f64x2 0x0123456789ABCDEFabcdef.p019 0x0123456789ABCDEFabcdef.p019)
                                    (v128.const f64x2 nan nan))
                                    (v128.const f64x2 0x0123456789ABCDEFabcdef.p019 0x0123456789ABCDEFabcdef.p019))
(assert_return (invoke "f64x2.pmin" (v128.const f64x2 0x0123456789ABCDEFabcdef.p+019 0x0123456789ABCDEFabcdef.p+019)
                                    (v128.const f64x2 nan nan))
                                    (v128.const f64x2 0x0123456789ABCDEFabcdef.p+019 0x0123456789ABCDEFabcdef.p+019))
(assert_return (invoke "f64x2.pmin" (v128.const f64x2 0x0123456789ABCDEFabcdef.p-019 0x0123456789ABCDEFabcdef.p-019)
                                    (v128.const f64x2 nan nan))
                                    (v128.const f64x2 0x0123456789ABCDEFabcdef.p-019 0x0123456789ABCDEFabcdef.p-019))
(assert_return (invoke "f64x2.pmin" (v128.const f64x2 0x0123456789ABCDEFabcdef.0123456789ABCDEFabcdef 0x0123456789ABCDEFabcdef.0123456789ABCDEFabcdef)
                                    (v128.const f64x2 nan nan))
                                    (v128.const f64x2 0x0123456789ABCDEFabcdef.0123456789ABCDEFabcdef 0x0123456789ABCDEFabcdef.0123456789ABCDEFabcdef))
(assert_return (invoke "f64x2.pmin" (v128.const f64x2 0x0123456789ABCDEFabcdef.0123456789ABCDEFabcdefp019 0x0123456789ABCDEFabcdef.0123456789ABCDEFabcdefp019)
                                    (v128.const f64x2 nan nan))
                                    (v128.const f64x2 0x0123456789ABCDEFabcdef.0123456789ABCDEFabcdefp019 0x0123456789ABCDEFabcdef.0123456789ABCDEFabcdefp019))
(assert_return (invoke "f64x2.pmin" (v128.const f64x2 0x0123456789ABCDEFabcdef.0123456789ABCDEFabcdefp+019 0x0123456789ABCDEFabcdef.0123456789ABCDEFabcdefp+019)
                                    (v128.const f64x2 nan nan))
                                    (v128.const f64x2 0x0123456789ABCDEFabcdef.0123456789ABCDEFabcdefp+019 0x0123456789ABCDEFabcdef.0123456789ABCDEFabcdefp+019))
(assert_return (invoke "f64x2.pmin" (v128.const f64x2 0x0123456789ABCDEFabcdef.0123456789ABCDEFabcdefp-019 0x0123456789ABCDEFabcdef.0123456789ABCDEFabcdefp-019)
                                    (v128.const f64x2 nan nan))
                                    (v128.const f64x2 0x0123456789ABCDEFabcdef.0123456789ABCDEFabcdefp-019 0x0123456789ABCDEFabcdef.0123456789ABCDEFabcdefp-019))
(assert_return (invoke "f64x2.pmin" (v128.const f64x2 0x0p+0 0x0p+0)
                                    (v128.const f64x2 -nan -nan))
                                    (v128.const f64x2 0x0p+0 0x0p+0))
(assert_return (invoke "f64x2.pmin" (v128.const f64x2 -0x0p+0 -0x0p+0)
                                    (v128.const f64x2 -nan -nan))
                                    (v128.const f64x2 -0x0p+0 -0x0p+0))
(assert_return (invoke "f64x2.pmin" (v128.const f64x2 0x1p-1022 0x1p-1022)
                                    (v128.const f64x2 -nan -nan))
                                    (v128.const f64x2 0x1p-1022 0x1p-1022))
(assert_return (invoke "f64x2.pmin" (v128.const f64x2 -0x1p-1022 -0x1p-1022)
                                    (v128.const f64x2 -nan -nan))
                                    (v128.const f64x2 -0x1p-1022 -0x1p-1022))
(assert_return (invoke "f64x2.pmin" (v128.const f64x2 0x1p-1 0x1p-1)
                                    (v128.const f64x2 -nan -nan))
                                    (v128.const f64x2 0x1p-1 0x1p-1))
(assert_return (invoke "f64x2.pmin" (v128.const f64x2 -0x1p-1 -0x1p-1)
                                    (v128.const f64x2 -nan -nan))
                                    (v128.const f64x2 -0x1p-1 -0x1p-1))
(assert_return (invoke "f64x2.pmin" (v128.const f64x2 0x1p+0 0x1p+0)
                                    (v128.const f64x2 -nan -nan))
                                    (v128.const f64x2 0x1p+0 0x1p+0))
(assert_return (invoke "f64x2.pmin" (v128.const f64x2 -0x1p+0 -0x1p+0)
                                    (v128.const f64x2 -nan -nan))
                                    (v128.const f64x2 -0x1p+0 -0x1p+0))
(assert_return (invoke "f64x2.pmin" (v128.const f64x2 0x1.921fb54442d18p+2 0x1.921fb54442d18p+2)
                                    (v128.const f64x2 -nan -nan))
                                    (v128.const f64x2 0x1.921fb54442d18p+2 0x1.921fb54442d18p+2))
(assert_return (invoke "f64x2.pmin" (v128.const f64x2 -0x1.921fb54442d18p+2 -0x1.921fb54442d18p+2)
                                    (v128.const f64x2 -nan -nan))
                                    (v128.const f64x2 -0x1.921fb54442d18p+2 -0x1.921fb54442d18p+2))
(assert_return (invoke "f64x2.pmin" (v128.const f64x2 0x1.fffffffffffffp+1023 0x1.fffffffffffffp+1023)
                                    (v128.const f64x2 -nan -nan))
                                    (v128.const f64x2 0x1.fffffffffffffp+1023 0x1.fffffffffffffp+1023))
(assert_return (invoke "f64x2.pmin" (v128.const f64x2 -0x1.fffffffffffffp+1023 -0x1.fffffffffffffp+1023)
                                    (v128.const f64x2 -nan -nan))
                                    (v128.const f64x2 -0x1.fffffffffffffp+1023 -0x1.fffffffffffffp+1023))
(assert_return (invoke "f64x2.pmin" (v128.const f64x2 0x0.0000000000001p-1022 0x0.0000000000001p-1022)
                                    (v128.const f64x2 -nan -nan))
                                    (v128.const f64x2 0x0.0000000000001p-1022 0x0.0000000000001p-1022))
(assert_return (invoke "f64x2.pmin" (v128.const f64x2 0x0.0000000000001p-1022 0x0.0000000000001p-1022)
                                    (v128.const f64x2 -nan -nan))
                                    (v128.const f64x2 0x0.0000000000001p-1022 0x0.0000000000001p-1022))
(assert_return (invoke "f64x2.pmin" (v128.const f64x2 inf inf)
                                    (v128.const f64x2 -nan -nan))
                                    (v128.const f64x2 inf inf))
(assert_return (invoke "f64x2.pmin" (v128.const f64x2 -inf -inf)
                                    (v128.const f64x2 -nan -nan))
                                    (v128.const f64x2 -inf -inf))
(assert_return (invoke "f64x2.pmin" (v128.const f64x2 0123456789 0123456789)
                                    (v128.const f64x2 -nan -nan))
                                    (v128.const f64x2 0123456789 0123456789))
(assert_return (invoke "f64x2.pmin" (v128.const f64x2 0123456789e019 0123456789e019)
                                    (v128.const f64x2 -nan -nan))
                                    (v128.const f64x2 0123456789e019 0123456789e019))
(assert_return (invoke "f64x2.pmin" (v128.const f64x2 0123456789e+019 0123456789e+019)
                                    (v128.const f64x2 -nan -nan))
                                    (v128.const f64x2 0123456789e+019 0123456789e+019))
(assert_return (invoke "f64x2.pmin" (v128.const f64x2 0123456789e-019 0123456789e-019)
                                    (v128.const f64x2 -nan -nan))
                                    (v128.const f64x2 0123456789e-019 0123456789e-019))
(assert_return (invoke "f64x2.pmin" (v128.const f64x2 0123456789. 0123456789.)
                                    (v128.const f64x2 -nan -nan))
                                    (v128.const f64x2 0123456789. 0123456789.))
(assert_return (invoke "f64x2.pmin" (v128.const f64x2 0123456789.e019 0123456789.e019)
                                    (v128.const f64x2 -nan -nan))
                                    (v128.const f64x2 0123456789.e019 0123456789.e019))
(assert_return (invoke "f64x2.pmin" (v128.const f64x2 0123456789.e+019 0123456789.e+019)
                                    (v128.const f64x2 -nan -nan))
                                    (v128.const f64x2 0123456789.e+019 0123456789.e+019))
(assert_return (invoke "f64x2.pmin" (v128.const f64x2 0123456789.e-019 0123456789.e-019)
                                    (v128.const f64x2 -nan -nan))
                                    (v128.const f64x2 0123456789.e-019 0123456789.e-019))
(assert_return (invoke "f64x2.pmin" (v128.const f64x2 0123456789.0123456789 0123456789.0123456789)
                                    (v128.const f64x2 -nan -nan))
                                    (v128.const f64x2 0123456789.0123456789 0123456789.0123456789))
(assert_return (invoke "f64x2.pmin" (v128.const f64x2 0123456789.0123456789e019 0123456789.0123456789e019)
                                    (v128.const f64x2 -nan -nan))
                                    (v128.const f64x2 0123456789.0123456789e019 0123456789.0123456789e019))
(assert_return (invoke "f64x2.pmin" (v128.const f64x2 0123456789.0123456789e+019 0123456789.0123456789e+019)
                                    (v128.const f64x2 -nan -nan))
                                    (v128.const f64x2 0123456789.0123456789e+019 0123456789.0123456789e+019))
(assert_return (invoke "f64x2.pmin" (v128.const f64x2 0123456789.0123456789e-019 0123456789.0123456789e-019)
                                    (v128.const f64x2 -nan -nan))
                                    (v128.const f64x2 0123456789.0123456789e-019 0123456789.0123456789e-019))
(assert_return (invoke "f64x2.pmin" (v128.const f64x2 0x0123456789ABCDEFabcdef 0x0123456789ABCDEFabcdef)
                                    (v128.const f64x2 -nan -nan))
                                    (v128.const f64x2 0x0123456789ABCDEFabcdef 0x0123456789ABCDEFabcdef))
(assert_return (invoke "f64x2.pmin" (v128.const f64x2 0x0123456789ABCDEFabcdefp019 0x0123456789ABCDEFabcdefp019)
                                    (v128.const f64x2 -nan -nan))
                                    (v128.const f64x2 0x0123456789ABCDEFabcdefp019 0x0123456789ABCDEFabcdefp019))
(assert_return (invoke "f64x2.pmin" (v128.const f64x2 0x0123456789ABCDEFabcdefp+019 0x0123456789ABCDEFabcdefp+019)
                                    (v128.const f64x2 -nan -nan))
                                    (v128.const f64x2 0x0123456789ABCDEFabcdefp+019 0x0123456789ABCDEFabcdefp+019))
(assert_return (invoke "f64x2.pmin" (v128.const f64x2 0x0123456789ABCDEFabcdefp-019 0x0123456789ABCDEFabcdefp-019)
                                    (v128.const f64x2 -nan -nan))
                                    (v128.const f64x2 0x0123456789ABCDEFabcdefp-019 0x0123456789ABCDEFabcdefp-019))
(assert_return (invoke "f64x2.pmin" (v128.const f64x2 0x0123456789ABCDEFabcdef. 0x0123456789ABCDEFabcdef.)
                                    (v128.const f64x2 -nan -nan))
                                    (v128.const f64x2 0x0123456789ABCDEFabcdef. 0x0123456789ABCDEFabcdef.))
(assert_return (invoke "f64x2.pmin" (v128.const f64x2 0x0123456789ABCDEFabcdef.p019 0x0123456789ABCDEFabcdef.p019)
                                    (v128.const f64x2 -nan -nan))
                                    (v128.const f64x2 0x0123456789ABCDEFabcdef.p019 0x0123456789ABCDEFabcdef.p019))
(assert_return (invoke "f64x2.pmin" (v128.const f64x2 0x0123456789ABCDEFabcdef.p+019 0x0123456789ABCDEFabcdef.p+019)
                                    (v128.const f64x2 -nan -nan))
                                    (v128.const f64x2 0x0123456789ABCDEFabcdef.p+019 0x0123456789ABCDEFabcdef.p+019))
(assert_return (invoke "f64x2.pmin" (v128.const f64x2 0x0123456789ABCDEFabcdef.p-019 0x0123456789ABCDEFabcdef.p-019)
                                    (v128.const f64x2 -nan -nan))
                                    (v128.const f64x2 0x0123456789ABCDEFabcdef.p-019 0x0123456789ABCDEFabcdef.p-019))
(assert_return (invoke "f64x2.pmin" (v128.const f64x2 0x0123456789ABCDEFabcdef.0123456789ABCDEFabcdef 0x0123456789ABCDEFabcdef.0123456789ABCDEFabcdef)
                                    (v128.const f64x2 -nan -nan))
                                    (v128.const f64x2 0x0123456789ABCDEFabcdef.0123456789ABCDEFabcdef 0x0123456789ABCDEFabcdef.0123456789ABCDEFabcdef))
(assert_return (invoke "f64x2.pmin" (v128.const f64x2 0x0123456789ABCDEFabcdef.0123456789ABCDEFabcdefp019 0x0123456789ABCDEFabcdef.0123456789ABCDEFabcdefp019)
                                    (v128.const f64x2 -nan -nan))
                                    (v128.const f64x2 0x0123456789ABCDEFabcdef.0123456789ABCDEFabcdefp019 0x0123456789ABCDEFabcdef.0123456789ABCDEFabcdefp019))
(assert_return (invoke "f64x2.pmin" (v128.const f64x2 0x0123456789ABCDEFabcdef.0123456789ABCDEFabcdefp+019 0x0123456789ABCDEFabcdef.0123456789ABCDEFabcdefp+019)
                                    (v128.const f64x2 -nan -nan))
                                    (v128.const f64x2 0x0123456789ABCDEFabcdef.0123456789ABCDEFabcdefp+019 0x0123456789ABCDEFabcdef.0123456789ABCDEFabcdefp+019))
(assert_return (invoke "f64x2.pmin" (v128.const f64x2 0x0123456789ABCDEFabcdef.0123456789ABCDEFabcdefp-019 0x0123456789ABCDEFabcdef.0123456789ABCDEFabcdefp-019)
                                    (v128.const f64x2 -nan -nan))
                                    (v128.const f64x2 0x0123456789ABCDEFabcdef.0123456789ABCDEFabcdefp-019 0x0123456789ABCDEFabcdef.0123456789ABCDEFabcdefp-019))
(assert_return (invoke "f64x2.pmin" (v128.const f64x2 0x0p+0 0x0p+0)
                                    (v128.const f64x2 nan:0x4000000000000 nan:0x4000000000000))
                                    (v128.const f64x2 0x0p+0 0x0p+0))
(assert_return (invoke "f64x2.pmin" (v128.const f64x2 -0x0p+0 -0x0p+0)
                                    (v128.const f64x2 nan:0x4000000000000 nan:0x4000000000000))
                                    (v128.const f64x2 -0x0p+0 -0x0p+0))
(assert_return (invoke "f64x2.pmin" (v128.const f64x2 0x1p-1022 0x1p-1022)
                                    (v128.const f64x2 nan:0x4000000000000 nan:0x4000000000000))
                                    (v128.const f64x2 0x1p-1022 0x1p-1022))
(assert_return (invoke "f64x2.pmin" (v128.const f64x2 -0x1p-1022 -0x1p-1022)
                                    (v128.const f64x2 nan:0x4000000000000 nan:0x4000000000000))
                                    (v128.const f64x2 -0x1p-1022 -0x1p-1022))
(assert_return (invoke "f64x2.pmin" (v128.const f64x2 0x1p-1 0x1p-1)
                                    (v128.const f64x2 nan:0x4000000000000 nan:0x4000000000000))
                                    (v128.const f64x2 0x1p-1 0x1p-1))
(assert_return (invoke "f64x2.pmin" (v128.const f64x2 -0x1p-1 -0x1p-1)
                                    (v128.const f64x2 nan:0x4000000000000 nan:0x4000000000000))
                                    (v128.const f64x2 -0x1p-1 -0x1p-1))
(assert_return (invoke "f64x2.pmin" (v128.const f64x2 0x1p+0 0x1p+0)
                                    (v128.const f64x2 nan:0x4000000000000 nan:0x4000000000000))
                                    (v128.const f64x2 0x1p+0 0x1p+0))
(assert_return (invoke "f64x2.pmin" (v128.const f64x2 -0x1p+0 -0x1p+0)
                                    (v128.const f64x2 nan:0x4000000000000 nan:0x4000000000000))
                                    (v128.const f64x2 -0x1p+0 -0x1p+0))
(assert_return (invoke "f64x2.pmin" (v128.const f64x2 0x1.921fb54442d18p+2 0x1.921fb54442d18p+2)
                                    (v128.const f64x2 nan:0x4000000000000 nan:0x4000000000000))
                                    (v128.const f64x2 0x1.921fb54442d18p+2 0x1.921fb54442d18p+2))
(assert_return (invoke "f64x2.pmin" (v128.const f64x2 -0x1.921fb54442d18p+2 -0x1.921fb54442d18p+2)
                                    (v128.const f64x2 nan:0x4000000000000 nan:0x4000000000000))
                                    (v128.const f64x2 -0x1.921fb54442d18p+2 -0x1.921fb54442d18p+2))
(assert_return (invoke "f64x2.pmin" (v128.const f64x2 0x1.fffffffffffffp+1023 0x1.fffffffffffffp+1023)
                                    (v128.const f64x2 nan:0x4000000000000 nan:0x4000000000000))
                                    (v128.const f64x2 0x1.fffffffffffffp+1023 0x1.fffffffffffffp+1023))
(assert_return (invoke "f64x2.pmin" (v128.const f64x2 -0x1.fffffffffffffp+1023 -0x1.fffffffffffffp+1023)
                                    (v128.const f64x2 nan:0x4000000000000 nan:0x4000000000000))
                                    (v128.const f64x2 -0x1.fffffffffffffp+1023 -0x1.fffffffffffffp+1023))
(assert_return (invoke "f64x2.pmin" (v128.const f64x2 0x0.0000000000001p-1022 0x0.0000000000001p-1022)
                                    (v128.const f64x2 nan:0x4000000000000 nan:0x4000000000000))
                                    (v128.const f64x2 0x0.0000000000001p-1022 0x0.0000000000001p-1022))
(assert_return (invoke "f64x2.pmin" (v128.const f64x2 0x0.0000000000001p-1022 0x0.0000000000001p-1022)
                                    (v128.const f64x2 nan:0x4000000000000 nan:0x4000000000000))
                                    (v128.const f64x2 0x0.0000000000001p-1022 0x0.0000000000001p-1022))
(assert_return (invoke "f64x2.pmin" (v128.const f64x2 inf inf)
                                    (v128.const f64x2 nan:0x4000000000000 nan:0x4000000000000))
                                    (v128.const f64x2 inf inf))
(assert_return (invoke "f64x2.pmin" (v128.const f64x2 -inf -inf)
                                    (v128.const f64x2 nan:0x4000000000000 nan:0x4000000000000))
                                    (v128.const f64x2 -inf -inf))
(assert_return (invoke "f64x2.pmin" (v128.const f64x2 0123456789 0123456789)
                                    (v128.const f64x2 nan:0x4000000000000 nan:0x4000000000000))
                                    (v128.const f64x2 0123456789 0123456789))
(assert_return (invoke "f64x2.pmin" (v128.const f64x2 0123456789e019 0123456789e019)
                                    (v128.const f64x2 nan:0x4000000000000 nan:0x4000000000000))
                                    (v128.const f64x2 0123456789e019 0123456789e019))
(assert_return (invoke "f64x2.pmin" (v128.const f64x2 0123456789e+019 0123456789e+019)
                                    (v128.const f64x2 nan:0x4000000000000 nan:0x4000000000000))
                                    (v128.const f64x2 0123456789e+019 0123456789e+019))
(assert_return (invoke "f64x2.pmin" (v128.const f64x2 0123456789e-019 0123456789e-019)
                                    (v128.const f64x2 nan:0x4000000000000 nan:0x4000000000000))
                                    (v128.const f64x2 0123456789e-019 0123456789e-019))
(assert_return (invoke "f64x2.pmin" (v128.const f64x2 0123456789. 0123456789.)
                                    (v128.const f64x2 nan:0x4000000000000 nan:0x4000000000000))
                                    (v128.const f64x2 0123456789. 0123456789.))
(assert_return (invoke "f64x2.pmin" (v128.const f64x2 0123456789.e019 0123456789.e019)
                                    (v128.const f64x2 nan:0x4000000000000 nan:0x4000000000000))
                                    (v128.const f64x2 0123456789.e019 0123456789.e019))
(assert_return (invoke "f64x2.pmin" (v128.const f64x2 0123456789.e+019 0123456789.e+019)
                                    (v128.const f64x2 nan:0x4000000000000 nan:0x4000000000000))
                                    (v128.const f64x2 0123456789.e+019 0123456789.e+019))
(assert_return (invoke "f64x2.pmin" (v128.const f64x2 0123456789.e-019 0123456789.e-019)
                                    (v128.const f64x2 nan:0x4000000000000 nan:0x4000000000000))
                                    (v128.const f64x2 0123456789.e-019 0123456789.e-019))
(assert_return (invoke "f64x2.pmin" (v128.const f64x2 0123456789.0123456789 0123456789.0123456789)
                                    (v128.const f64x2 nan:0x4000000000000 nan:0x4000000000000))
                                    (v128.const f64x2 0123456789.0123456789 0123456789.0123456789))
(assert_return (invoke "f64x2.pmin" (v128.const f64x2 0123456789.0123456789e019 0123456789.0123456789e019)
                                    (v128.const f64x2 nan:0x4000000000000 nan:0x4000000000000))
                                    (v128.const f64x2 0123456789.0123456789e019 0123456789.0123456789e019))
(assert_return (invoke "f64x2.pmin" (v128.const f64x2 0123456789.0123456789e+019 0123456789.0123456789e+019)
                                    (v128.const f64x2 nan:0x4000000000000 nan:0x4000000000000))
                                    (v128.const f64x2 0123456789.0123456789e+019 0123456789.0123456789e+019))
(assert_return (invoke "f64x2.pmin" (v128.const f64x2 0123456789.0123456789e-019 0123456789.0123456789e-019)
                                    (v128.const f64x2 nan:0x4000000000000 nan:0x4000000000000))
                                    (v128.const f64x2 0123456789.0123456789e-019 0123456789.0123456789e-019))
(assert_return (invoke "f64x2.pmin" (v128.const f64x2 0x0123456789ABCDEFabcdef 0x0123456789ABCDEFabcdef)
                                    (v128.const f64x2 nan:0x4000000000000 nan:0x4000000000000))
                                    (v128.const f64x2 0x0123456789ABCDEFabcdef 0x0123456789ABCDEFabcdef))
(assert_return (invoke "f64x2.pmin" (v128.const f64x2 0x0123456789ABCDEFabcdefp019 0x0123456789ABCDEFabcdefp019)
                                    (v128.const f64x2 nan:0x4000000000000 nan:0x4000000000000))
                                    (v128.const f64x2 0x0123456789ABCDEFabcdefp019 0x0123456789ABCDEFabcdefp019))
(assert_return (invoke "f64x2.pmin" (v128.const f64x2 0x0123456789ABCDEFabcdefp+019 0x0123456789ABCDEFabcdefp+019)
                                    (v128.const f64x2 nan:0x4000000000000 nan:0x4000000000000))
                                    (v128.const f64x2 0x0123456789ABCDEFabcdefp+019 0x0123456789ABCDEFabcdefp+019))
(assert_return (invoke "f64x2.pmin" (v128.const f64x2 0x0123456789ABCDEFabcdefp-019 0x0123456789ABCDEFabcdefp-019)
                                    (v128.const f64x2 nan:0x4000000000000 nan:0x4000000000000))
                                    (v128.const f64x2 0x0123456789ABCDEFabcdefp-019 0x0123456789ABCDEFabcdefp-019))
(assert_return (invoke "f64x2.pmin" (v128.const f64x2 0x0123456789ABCDEFabcdef. 0x0123456789ABCDEFabcdef.)
                                    (v128.const f64x2 nan:0x4000000000000 nan:0x4000000000000))
                                    (v128.const f64x2 0x0123456789ABCDEFabcdef. 0x0123456789ABCDEFabcdef.))
(assert_return (invoke "f64x2.pmin" (v128.const f64x2 0x0123456789ABCDEFabcdef.p019 0x0123456789ABCDEFabcdef.p019)
                                    (v128.const f64x2 nan:0x4000000000000 nan:0x4000000000000))
                                    (v128.const f64x2 0x0123456789ABCDEFabcdef.p019 0x0123456789ABCDEFabcdef.p019))
(assert_return (invoke "f64x2.pmin" (v128.const f64x2 0x0123456789ABCDEFabcdef.p+019 0x0123456789ABCDEFabcdef.p+019)
                                    (v128.const f64x2 nan:0x4000000000000 nan:0x4000000000000))
                                    (v128.const f64x2 0x0123456789ABCDEFabcdef.p+019 0x0123456789ABCDEFabcdef.p+019))
(assert_return (invoke "f64x2.pmin" (v128.const f64x2 0x0123456789ABCDEFabcdef.p-019 0x0123456789ABCDEFabcdef.p-019)
                                    (v128.const f64x2 nan:0x4000000000000 nan:0x4000000000000))
                                    (v128.const f64x2 0x0123456789ABCDEFabcdef.p-019 0x0123456789ABCDEFabcdef.p-019))
(assert_return (invoke "f64x2.pmin" (v128.const f64x2 0x0123456789ABCDEFabcdef.0123456789ABCDEFabcdef 0x0123456789ABCDEFabcdef.0123456789ABCDEFabcdef)
                                    (v128.const f64x2 nan:0x4000000000000 nan:0x4000000000000))
                                    (v128.const f64x2 0x0123456789ABCDEFabcdef.0123456789ABCDEFabcdef 0x0123456789ABCDEFabcdef.0123456789ABCDEFabcdef))
(assert_return (invoke "f64x2.pmin" (v128.const f64x2 0x0123456789ABCDEFabcdef.0123456789ABCDEFabcdefp019 0x0123456789ABCDEFabcdef.0123456789ABCDEFabcdefp019)
                                    (v128.const f64x2 nan:0x4000000000000 nan:0x4000000000000))
                                    (v128.const f64x2 0x0123456789ABCDEFabcdef.0123456789ABCDEFabcdefp019 0x0123456789ABCDEFabcdef.0123456789ABCDEFabcdefp019))
(assert_return (invoke "f64x2.pmin" (v128.const f64x2 0x0123456789ABCDEFabcdef.0123456789ABCDEFabcdefp+019 0x0123456789ABCDEFabcdef.0123456789ABCDEFabcdefp+019)
                                    (v128.const f64x2 nan:0x4000000000000 nan:0x4000000000000))
                                    (v128.const f64x2 0x0123456789ABCDEFabcdef.0123456789ABCDEFabcdefp+019 0x0123456789ABCDEFabcdef.0123456789ABCDEFabcdefp+019))
(assert_return (invoke "f64x2.pmin" (v128.const f64x2 0x0123456789ABCDEFabcdef.0123456789ABCDEFabcdefp-019 0x0123456789ABCDEFabcdef.0123456789ABCDEFabcdefp-019)
                                    (v128.const f64x2 nan:0x4000000000000 nan:0x4000000000000))
                                    (v128.const f64x2 0x0123456789ABCDEFabcdef.0123456789ABCDEFabcdefp-019 0x0123456789ABCDEFabcdef.0123456789ABCDEFabcdefp-019))
(assert_return (invoke "f64x2.pmin" (v128.const f64x2 0x0p+0 0x0p+0)
                                    (v128.const f64x2 -nan:0x4000000000000 -nan:0x4000000000000))
                                    (v128.const f64x2 0x0p+0 0x0p+0))
(assert_return (invoke "f64x2.pmin" (v128.const f64x2 -0x0p+0 -0x0p+0)
                                    (v128.const f64x2 -nan:0x4000000000000 -nan:0x4000000000000))
                                    (v128.const f64x2 -0x0p+0 -0x0p+0))
(assert_return (invoke "f64x2.pmin" (v128.const f64x2 0x1p-1022 0x1p-1022)
                                    (v128.const f64x2 -nan:0x4000000000000 -nan:0x4000000000000))
                                    (v128.const f64x2 0x1p-1022 0x1p-1022))
(assert_return (invoke "f64x2.pmin" (v128.const f64x2 -0x1p-1022 -0x1p-1022)
                                    (v128.const f64x2 -nan:0x4000000000000 -nan:0x4000000000000))
                                    (v128.const f64x2 -0x1p-1022 -0x1p-1022))
(assert_return (invoke "f64x2.pmin" (v128.const f64x2 0x1p-1 0x1p-1)
                                    (v128.const f64x2 -nan:0x4000000000000 -nan:0x4000000000000))
                                    (v128.const f64x2 0x1p-1 0x1p-1))
(assert_return (invoke "f64x2.pmin" (v128.const f64x2 -0x1p-1 -0x1p-1)
                                    (v128.const f64x2 -nan:0x4000000000000 -nan:0x4000000000000))
                                    (v128.const f64x2 -0x1p-1 -0x1p-1))
(assert_return (invoke "f64x2.pmin" (v128.const f64x2 0x1p+0 0x1p+0)
                                    (v128.const f64x2 -nan:0x4000000000000 -nan:0x4000000000000))
                                    (v128.const f64x2 0x1p+0 0x1p+0))
(assert_return (invoke "f64x2.pmin" (v128.const f64x2 -0x1p+0 -0x1p+0)
                                    (v128.const f64x2 -nan:0x4000000000000 -nan:0x4000000000000))
                                    (v128.const f64x2 -0x1p+0 -0x1p+0))
(assert_return (invoke "f64x2.pmin" (v128.const f64x2 0x1.921fb54442d18p+2 0x1.921fb54442d18p+2)
                                    (v128.const f64x2 -nan:0x4000000000000 -nan:0x4000000000000))
                                    (v128.const f64x2 0x1.921fb54442d18p+2 0x1.921fb54442d18p+2))
(assert_return (invoke "f64x2.pmin" (v128.const f64x2 -0x1.921fb54442d18p+2 -0x1.921fb54442d18p+2)
                                    (v128.const f64x2 -nan:0x4000000000000 -nan:0x4000000000000))
                                    (v128.const f64x2 -0x1.921fb54442d18p+2 -0x1.921fb54442d18p+2))
(assert_return (invoke "f64x2.pmin" (v128.const f64x2 0x1.fffffffffffffp+1023 0x1.fffffffffffffp+1023)
                                    (v128.const f64x2 -nan:0x4000000000000 -nan:0x4000000000000))
                                    (v128.const f64x2 0x1.fffffffffffffp+1023 0x1.fffffffffffffp+1023))
(assert_return (invoke "f64x2.pmin" (v128.const f64x2 -0x1.fffffffffffffp+1023 -0x1.fffffffffffffp+1023)
                                    (v128.const f64x2 -nan:0x4000000000000 -nan:0x4000000000000))
                                    (v128.const f64x2 -0x1.fffffffffffffp+1023 -0x1.fffffffffffffp+1023))
(assert_return (invoke "f64x2.pmin" (v128.const f64x2 0x0.0000000000001p-1022 0x0.0000000000001p-1022)
                                    (v128.const f64x2 -nan:0x4000000000000 -nan:0x4000000000000))
                                    (v128.const f64x2 0x0.0000000000001p-1022 0x0.0000000000001p-1022))
(assert_return (invoke "f64x2.pmin" (v128.const f64x2 0x0.0000000000001p-1022 0x0.0000000000001p-1022)
                                    (v128.const f64x2 -nan:0x4000000000000 -nan:0x4000000000000))
                                    (v128.const f64x2 0x0.0000000000001p-1022 0x0.0000000000001p-1022))
(assert_return (invoke "f64x2.pmin" (v128.const f64x2 inf inf)
                                    (v128.const f64x2 -nan:0x4000000000000 -nan:0x4000000000000))
                                    (v128.const f64x2 inf inf))
(assert_return (invoke "f64x2.pmin" (v128.const f64x2 -inf -inf)
                                    (v128.const f64x2 -nan:0x4000000000000 -nan:0x4000000000000))
                                    (v128.const f64x2 -inf -inf))
(assert_return (invoke "f64x2.pmin" (v128.const f64x2 0123456789 0123456789)
                                    (v128.const f64x2 -nan:0x4000000000000 -nan:0x4000000000000))
                                    (v128.const f64x2 0123456789 0123456789))
(assert_return (invoke "f64x2.pmin" (v128.const f64x2 0123456789e019 0123456789e019)
                                    (v128.const f64x2 -nan:0x4000000000000 -nan:0x4000000000000))
                                    (v128.const f64x2 0123456789e019 0123456789e019))
(assert_return (invoke "f64x2.pmin" (v128.const f64x2 0123456789e+019 0123456789e+019)
                                    (v128.const f64x2 -nan:0x4000000000000 -nan:0x4000000000000))
                                    (v128.const f64x2 0123456789e+019 0123456789e+019))
(assert_return (invoke "f64x2.pmin" (v128.const f64x2 0123456789e-019 0123456789e-019)
                                    (v128.const f64x2 -nan:0x4000000000000 -nan:0x4000000000000))
                                    (v128.const f64x2 0123456789e-019 0123456789e-019))
(assert_return (invoke "f64x2.pmin" (v128.const f64x2 0123456789. 0123456789.)
                                    (v128.const f64x2 -nan:0x4000000000000 -nan:0x4000000000000))
                                    (v128.const f64x2 0123456789. 0123456789.))
(assert_return (invoke "f64x2.pmin" (v128.const f64x2 0123456789.e019 0123456789.e019)
                                    (v128.const f64x2 -nan:0x4000000000000 -nan:0x4000000000000))
                                    (v128.const f64x2 0123456789.e019 0123456789.e019))
(assert_return (invoke "f64x2.pmin" (v128.const f64x2 0123456789.e+019 0123456789.e+019)
                                    (v128.const f64x2 -nan:0x4000000000000 -nan:0x4000000000000))
                                    (v128.const f64x2 0123456789.e+019 0123456789.e+019))
(assert_return (invoke "f64x2.pmin" (v128.const f64x2 0123456789.e-019 0123456789.e-019)
                                    (v128.const f64x2 -nan:0x4000000000000 -nan:0x4000000000000))
                                    (v128.const f64x2 0123456789.e-019 0123456789.e-019))
(assert_return (invoke "f64x2.pmin" (v128.const f64x2 0123456789.0123456789 0123456789.0123456789)
                                    (v128.const f64x2 -nan:0x4000000000000 -nan:0x4000000000000))
                                    (v128.const f64x2 0123456789.0123456789 0123456789.0123456789))
(assert_return (invoke "f64x2.pmin" (v128.const f64x2 0123456789.0123456789e019 0123456789.0123456789e019)
                                    (v128.const f64x2 -nan:0x4000000000000 -nan:0x4000000000000))
                                    (v128.const f64x2 0123456789.0123456789e019 0123456789.0123456789e019))
(assert_return (invoke "f64x2.pmin" (v128.const f64x2 0123456789.0123456789e+019 0123456789.0123456789e+019)
                                    (v128.const f64x2 -nan:0x4000000000000 -nan:0x4000000000000))
                                    (v128.const f64x2 0123456789.0123456789e+019 0123456789.0123456789e+019))
(assert_return (invoke "f64x2.pmin" (v128.const f64x2 0123456789.0123456789e-019 0123456789.0123456789e-019)
                                    (v128.const f64x2 -nan:0x4000000000000 -nan:0x4000000000000))
                                    (v128.const f64x2 0123456789.0123456789e-019 0123456789.0123456789e-019))
(assert_return (invoke "f64x2.pmin" (v128.const f64x2 0x0123456789ABCDEFabcdef 0x0123456789ABCDEFabcdef)
                                    (v128.const f64x2 -nan:0x4000000000000 -nan:0x4000000000000))
                                    (v128.const f64x2 0x0123456789ABCDEFabcdef 0x0123456789ABCDEFabcdef))
(assert_return (invoke "f64x2.pmin" (v128.const f64x2 0x0123456789ABCDEFabcdefp019 0x0123456789ABCDEFabcdefp019)
                                    (v128.const f64x2 -nan:0x4000000000000 -nan:0x4000000000000))
                                    (v128.const f64x2 0x0123456789ABCDEFabcdefp019 0x0123456789ABCDEFabcdefp019))
(assert_return (invoke "f64x2.pmin" (v128.const f64x2 0x0123456789ABCDEFabcdefp+019 0x0123456789ABCDEFabcdefp+019)
                                    (v128.const f64x2 -nan:0x4000000000000 -nan:0x4000000000000))
                                    (v128.const f64x2 0x0123456789ABCDEFabcdefp+019 0x0123456789ABCDEFabcdefp+019))
(assert_return (invoke "f64x2.pmin" (v128.const f64x2 0x0123456789ABCDEFabcdefp-019 0x0123456789ABCDEFabcdefp-019)
                                    (v128.const f64x2 -nan:0x4000000000000 -nan:0x4000000000000))
                                    (v128.const f64x2 0x0123456789ABCDEFabcdefp-019 0x0123456789ABCDEFabcdefp-019))
(assert_return (invoke "f64x2.pmin" (v128.const f64x2 0x0123456789ABCDEFabcdef. 0x0123456789ABCDEFabcdef.)
                                    (v128.const f64x2 -nan:0x4000000000000 -nan:0x4000000000000))
                                    (v128.const f64x2 0x0123456789ABCDEFabcdef. 0x0123456789ABCDEFabcdef.))
(assert_return (invoke "f64x2.pmin" (v128.const f64x2 0x0123456789ABCDEFabcdef.p019 0x0123456789ABCDEFabcdef.p019)
                                    (v128.const f64x2 -nan:0x4000000000000 -nan:0x4000000000000))
                                    (v128.const f64x2 0x0123456789ABCDEFabcdef.p019 0x0123456789ABCDEFabcdef.p019))
(assert_return (invoke "f64x2.pmin" (v128.const f64x2 0x0123456789ABCDEFabcdef.p+019 0x0123456789ABCDEFabcdef.p+019)
                                    (v128.const f64x2 -nan:0x4000000000000 -nan:0x4000000000000))
                                    (v128.const f64x2 0x0123456789ABCDEFabcdef.p+019 0x0123456789ABCDEFabcdef.p+019))
(assert_return (invoke "f64x2.pmin" (v128.const f64x2 0x0123456789ABCDEFabcdef.p-019 0x0123456789ABCDEFabcdef.p-019)
                                    (v128.const f64x2 -nan:0x4000000000000 -nan:0x4000000000000))
                                    (v128.const f64x2 0x0123456789ABCDEFabcdef.p-019 0x0123456789ABCDEFabcdef.p-019))
(assert_return (invoke "f64x2.pmin" (v128.const f64x2 0x0123456789ABCDEFabcdef.0123456789ABCDEFabcdef 0x0123456789ABCDEFabcdef.0123456789ABCDEFabcdef)
                                    (v128.const f64x2 -nan:0x4000000000000 -nan:0x4000000000000))
                                    (v128.const f64x2 0x0123456789ABCDEFabcdef.0123456789ABCDEFabcdef 0x0123456789ABCDEFabcdef.0123456789ABCDEFabcdef))
(assert_return (invoke "f64x2.pmin" (v128.const f64x2 0x0123456789ABCDEFabcdef.0123456789ABCDEFabcdefp019 0x0123456789ABCDEFabcdef.0123456789ABCDEFabcdefp019)
                                    (v128.const f64x2 -nan:0x4000000000000 -nan:0x4000000000000))
                                    (v128.const f64x2 0x0123456789ABCDEFabcdef.0123456789ABCDEFabcdefp019 0x0123456789ABCDEFabcdef.0123456789ABCDEFabcdefp019))
(assert_return (invoke "f64x2.pmin" (v128.const f64x2 0x0123456789ABCDEFabcdef.0123456789ABCDEFabcdefp+019 0x0123456789ABCDEFabcdef.0123456789ABCDEFabcdefp+019)
                                    (v128.const f64x2 -nan:0x4000000000000 -nan:0x4000000000000))
                                    (v128.const f64x2 0x0123456789ABCDEFabcdef.0123456789ABCDEFabcdefp+019 0x0123456789ABCDEFabcdef.0123456789ABCDEFabcdefp+019))
(assert_return (invoke "f64x2.pmin" (v128.const f64x2 0x0123456789ABCDEFabcdef.0123456789ABCDEFabcdefp-019 0x0123456789ABCDEFabcdef.0123456789ABCDEFabcdefp-019)
                                    (v128.const f64x2 -nan:0x4000000000000 -nan:0x4000000000000))
                                    (v128.const f64x2 0x0123456789ABCDEFabcdef.0123456789ABCDEFabcdefp-019 0x0123456789ABCDEFabcdef.0123456789ABCDEFabcdefp-019))
(assert_return (invoke "f64x2.pmax" (v128.const f64x2 0x0p+0 0x0p+0)
                                    (v128.const f64x2 0x0p+0 0x0p+0))
                                    (v128.const f64x2 0x0.0p+0 0x0.0p+0))
(assert_return (invoke "f64x2.pmax" (v128.const f64x2 0x0p+0 0x0p+0)
                                    (v128.const f64x2 -0x0p+0 -0x0p+0))
                                    (v128.const f64x2 0x0.0p+0 0x0.0p+0))
(assert_return (invoke "f64x2.pmax" (v128.const f64x2 0x0p+0 0x0p+0)
                                    (v128.const f64x2 0x1p-1022 0x1p-1022))
                                    (v128.const f64x2 0x1.0000000000000p-1022 0x1.0000000000000p-1022))
(assert_return (invoke "f64x2.pmax" (v128.const f64x2 0x0p+0 0x0p+0)
                                    (v128.const f64x2 -0x1p-1022 -0x1p-1022))
                                    (v128.const f64x2 0x0.0p+0 0x0.0p+0))
(assert_return (invoke "f64x2.pmax" (v128.const f64x2 0x0p+0 0x0p+0)
                                    (v128.const f64x2 0x1p-1 0x1p-1))
                                    (v128.const f64x2 0x1.0000000000000p-1 0x1.0000000000000p-1))
(assert_return (invoke "f64x2.pmax" (v128.const f64x2 0x0p+0 0x0p+0)
                                    (v128.const f64x2 -0x1p-1 -0x1p-1))
                                    (v128.const f64x2 0x0.0p+0 0x0.0p+0))
(assert_return (invoke "f64x2.pmax" (v128.const f64x2 0x0p+0 0x0p+0)
                                    (v128.const f64x2 0x1p+0 0x1p+0))
                                    (v128.const f64x2 0x1.0000000000000p+0 0x1.0000000000000p+0))
(assert_return (invoke "f64x2.pmax" (v128.const f64x2 0x0p+0 0x0p+0)
                                    (v128.const f64x2 -0x1p+0 -0x1p+0))
                                    (v128.const f64x2 0x0.0p+0 0x0.0p+0))
(assert_return (invoke "f64x2.pmax" (v128.const f64x2 0x0p+0 0x0p+0)
                                    (v128.const f64x2 0x1.921fb54442d18p+2 0x1.921fb54442d18p+2))
                                    (v128.const f64x2 0x1.921fb54442d18p+2 0x1.921fb54442d18p+2))
(assert_return (invoke "f64x2.pmax" (v128.const f64x2 0x0p+0 0x0p+0)
                                    (v128.const f64x2 -0x1.921fb54442d18p+2 -0x1.921fb54442d18p+2))
                                    (v128.const f64x2 0x0.0p+0 0x0.0p+0))
(assert_return (invoke "f64x2.pmax" (v128.const f64x2 0x0p+0 0x0p+0)
                                    (v128.const f64x2 0x1.fffffffffffffp+1023 0x1.fffffffffffffp+1023))
                                    (v128.const f64x2 0x1.fffffffffffffp+1023 0x1.fffffffffffffp+1023))
(assert_return (invoke "f64x2.pmax" (v128.const f64x2 0x0p+0 0x0p+0)
                                    (v128.const f64x2 -0x1.fffffffffffffp+1023 -0x1.fffffffffffffp+1023))
                                    (v128.const f64x2 0x0.0p+0 0x0.0p+0))
(assert_return (invoke "f64x2.pmax" (v128.const f64x2 0x0p+0 0x0p+0)
                                    (v128.const f64x2 0x0.0000000000001p-1022 0x0.0000000000001p-1022))
                                    (v128.const f64x2 0x0.0000000000001p-1022 0x0.0000000000001p-1022))
(assert_return (invoke "f64x2.pmax" (v128.const f64x2 0x0p+0 0x0p+0)
                                    (v128.const f64x2 0x0.0000000000001p-1022 0x0.0000000000001p-1022))
                                    (v128.const f64x2 0x0.0000000000001p-1022 0x0.0000000000001p-1022))
(assert_return (invoke "f64x2.pmax" (v128.const f64x2 0x0p+0 0x0p+0)
                                    (v128.const f64x2 inf inf))
                                    (v128.const f64x2 inf inf))
(assert_return (invoke "f64x2.pmax" (v128.const f64x2 0x0p+0 0x0p+0)
                                    (v128.const f64x2 -inf -inf))
                                    (v128.const f64x2 0x0.0p+0 0x0.0p+0))
(assert_return (invoke "f64x2.pmax" (v128.const f64x2 0x0p+0 0x0p+0)
                                    (v128.const f64x2 0123456789 0123456789))
                                    (v128.const f64x2 0x1.d6f3454000000p+26 0x1.d6f3454000000p+26))
(assert_return (invoke "f64x2.pmax" (v128.const f64x2 0x0p+0 0x0p+0)
                                    (v128.const f64x2 0123456789e019 0123456789e019))
                                    (v128.const f64x2 0x1.fe9af5b5e16fap+89 0x1.fe9af5b5e16fap+89))
(assert_return (invoke "f64x2.pmax" (v128.const f64x2 0x0p+0 0x0p+0)
                                    (v128.const f64x2 0123456789e+019 0123456789e+019))
                                    (v128.const f64x2 0x1.fe9af5b5e16fap+89 0x1.fe9af5b5e16fap+89))
(assert_return (invoke "f64x2.pmax" (v128.const f64x2 0x0p+0 0x0p+0)
                                    (v128.const f64x2 0123456789e-019 0123456789e-019))
                                    (v128.const f64x2 0x1.b25ffd62b4311p-37 0x1.b25ffd62b4311p-37))
(assert_return (invoke "f64x2.pmax" (v128.const f64x2 0x0p+0 0x0p+0)
                                    (v128.const f64x2 0123456789. 0123456789.))
                                    (v128.const f64x2 0x1.d6f3454000000p+26 0x1.d6f3454000000p+26))
(assert_return (invoke "f64x2.pmax" (v128.const f64x2 0x0p+0 0x0p+0)
                                    (v128.const f64x2 0123456789.e019 0123456789.e019))
                                    (v128.const f64x2 0x1.fe9af5b5e16fap+89 0x1.fe9af5b5e16fap+89))
(assert_return (invoke "f64x2.pmax" (v128.const f64x2 0x0p+0 0x0p+0)
                                    (v128.const f64x2 0123456789.e+019 0123456789.e+019))
                                    (v128.const f64x2 0x1.fe9af5b5e16fap+89 0x1.fe9af5b5e16fap+89))
(assert_return (invoke "f64x2.pmax" (v128.const f64x2 0x0p+0 0x0p+0)
                                    (v128.const f64x2 0123456789.e-019 0123456789.e-019))
                                    (v128.const f64x2 0x1.b25ffd62b4311p-37 0x1.b25ffd62b4311p-37))
(assert_return (invoke "f64x2.pmax" (v128.const f64x2 0x0p+0 0x0p+0)
                                    (v128.const f64x2 0123456789.0123456789 0123456789.0123456789))
                                    (v128.const f64x2 0x1.d6f34540ca458p+26 0x1.d6f34540ca458p+26))
(assert_return (invoke "f64x2.pmax" (v128.const f64x2 0x0p+0 0x0p+0)
                                    (v128.const f64x2 0123456789.0123456789e019 0123456789.0123456789e019))
                                    (v128.const f64x2 0x1.fe9af5b6bcbd5p+89 0x1.fe9af5b6bcbd5p+89))
(assert_return (invoke "f64x2.pmax" (v128.const f64x2 0x0p+0 0x0p+0)
                                    (v128.const f64x2 0123456789.0123456789e+019 0123456789.0123456789e+019))
                                    (v128.const f64x2 0x1.fe9af5b6bcbd5p+89 0x1.fe9af5b6bcbd5p+89))
(assert_return (invoke "f64x2.pmax" (v128.const f64x2 0x0p+0 0x0p+0)
                                    (v128.const f64x2 0123456789.0123456789e-019 0123456789.0123456789e-019))
                                    (v128.const f64x2 0x1.b25ffd636ec12p-37 0x1.b25ffd636ec12p-37))
(assert_return (invoke "f64x2.pmax" (v128.const f64x2 0x0p+0 0x0p+0)
                                    (v128.const f64x2 0x0123456789ABCDEFabcdef 0x0123456789ABCDEFabcdef))
                                    (v128.const f64x2 0x1.23456789abcdfp+80 0x1.23456789abcdfp+80))
(assert_return (invoke "f64x2.pmax" (v128.const f64x2 0x0p+0 0x0p+0)
                                    (v128.const f64x2 0x0123456789ABCDEFabcdefp019 0x0123456789ABCDEFabcdefp019))
                                    (v128.const f64x2 0x1.23456789abcdfp+99 0x1.23456789abcdfp+99))
(assert_return (invoke "f64x2.pmax" (v128.const f64x2 0x0p+0 0x0p+0)
                                    (v128.const f64x2 0x0123456789ABCDEFabcdefp+019 0x0123456789ABCDEFabcdefp+019))
                                    (v128.const f64x2 0x1.23456789abcdfp+99 0x1.23456789abcdfp+99))
(assert_return (invoke "f64x2.pmax" (v128.const f64x2 0x0p+0 0x0p+0)
                                    (v128.const f64x2 0x0123456789ABCDEFabcdefp-019 0x0123456789ABCDEFabcdefp-019))
                                    (v128.const f64x2 0x1.23456789abcdfp+61 0x1.23456789abcdfp+61))
(assert_return (invoke "f64x2.pmax" (v128.const f64x2 0x0p+0 0x0p+0)
                                    (v128.const f64x2 0x0123456789ABCDEFabcdef. 0x0123456789ABCDEFabcdef.))
                                    (v128.const f64x2 0x1.23456789abcdfp+80 0x1.23456789abcdfp+80))
(assert_return (invoke "f64x2.pmax" (v128.const f64x2 0x0p+0 0x0p+0)
                                    (v128.const f64x2 0x0123456789ABCDEFabcdef.p019 0x0123456789ABCDEFabcdef.p019))
                                    (v128.const f64x2 0x1.23456789abcdfp+99 0x1.23456789abcdfp+99))
(assert_return (invoke "f64x2.pmax" (v128.const f64x2 0x0p+0 0x0p+0)
                                    (v128.const f64x2 0x0123456789ABCDEFabcdef.p+019 0x0123456789ABCDEFabcdef.p+019))
                                    (v128.const f64x2 0x1.23456789abcdfp+99 0x1.23456789abcdfp+99))
(assert_return (invoke "f64x2.pmax" (v128.const f64x2 0x0p+0 0x0p+0)
                                    (v128.const f64x2 0x0123456789ABCDEFabcdef.p-019 0x0123456789ABCDEFabcdef.p-019))
                                    (v128.const f64x2 0x1.23456789abcdfp+61 0x1.23456789abcdfp+61))
(assert_return (invoke "f64x2.pmax" (v128.const f64x2 0x0p+0 0x0p+0)
                                    (v128.const f64x2 0x0123456789ABCDEFabcdef.0123456789ABCDEFabcdef 0x0123456789ABCDEFabcdef.0123456789ABCDEFabcdef))
                                    (v128.const f64x2 0x1.23456789abcdfp+80 0x1.23456789abcdfp+80))
(assert_return (invoke "f64x2.pmax" (v128.const f64x2 0x0p+0 0x0p+0)
                                    (v128.const f64x2 0x0123456789ABCDEFabcdef.0123456789ABCDEFabcdefp019 0x0123456789ABCDEFabcdef.0123456789ABCDEFabcdefp019))
                                    (v128.const f64x2 0x1.23456789abcdfp+99 0x1.23456789abcdfp+99))
(assert_return (invoke "f64x2.pmax" (v128.const f64x2 0x0p+0 0x0p+0)
                                    (v128.const f64x2 0x0123456789ABCDEFabcdef.0123456789ABCDEFabcdefp+019 0x0123456789ABCDEFabcdef.0123456789ABCDEFabcdefp+019))
                                    (v128.const f64x2 0x1.23456789abcdfp+99 0x1.23456789abcdfp+99))
(assert_return (invoke "f64x2.pmax" (v128.const f64x2 0x0p+0 0x0p+0)
                                    (v128.const f64x2 0x0123456789ABCDEFabcdef.0123456789ABCDEFabcdefp-019 0x0123456789ABCDEFabcdef.0123456789ABCDEFabcdefp-019))
                                    (v128.const f64x2 0x1.23456789abcdfp+61 0x1.23456789abcdfp+61))
(assert_return (invoke "f64x2.pmax" (v128.const f64x2 -0x0p+0 -0x0p+0)
                                    (v128.const f64x2 0x0p+0 0x0p+0))
                                    (v128.const f64x2 -0x0.0p+0 -0x0.0p+0))
(assert_return (invoke "f64x2.pmax" (v128.const f64x2 -0x0p+0 -0x0p+0)
                                    (v128.const f64x2 -0x0p+0 -0x0p+0))
                                    (v128.const f64x2 -0x0.0p+0 -0x0.0p+0))
(assert_return (invoke "f64x2.pmax" (v128.const f64x2 -0x0p+0 -0x0p+0)
                                    (v128.const f64x2 0x1p-1022 0x1p-1022))
                                    (v128.const f64x2 0x1.0000000000000p-1022 0x1.0000000000000p-1022))
(assert_return (invoke "f64x2.pmax" (v128.const f64x2 -0x0p+0 -0x0p+0)
                                    (v128.const f64x2 -0x1p-1022 -0x1p-1022))
                                    (v128.const f64x2 -0x0.0p+0 -0x0.0p+0))
(assert_return (invoke "f64x2.pmax" (v128.const f64x2 -0x0p+0 -0x0p+0)
                                    (v128.const f64x2 0x1p-1 0x1p-1))
                                    (v128.const f64x2 0x1.0000000000000p-1 0x1.0000000000000p-1))
(assert_return (invoke "f64x2.pmax" (v128.const f64x2 -0x0p+0 -0x0p+0)
                                    (v128.const f64x2 -0x1p-1 -0x1p-1))
                                    (v128.const f64x2 -0x0.0p+0 -0x0.0p+0))
(assert_return (invoke "f64x2.pmax" (v128.const f64x2 -0x0p+0 -0x0p+0)
                                    (v128.const f64x2 0x1p+0 0x1p+0))
                                    (v128.const f64x2 0x1.0000000000000p+0 0x1.0000000000000p+0))
(assert_return (invoke "f64x2.pmax" (v128.const f64x2 -0x0p+0 -0x0p+0)
                                    (v128.const f64x2 -0x1p+0 -0x1p+0))
                                    (v128.const f64x2 -0x0.0p+0 -0x0.0p+0))
(assert_return (invoke "f64x2.pmax" (v128.const f64x2 -0x0p+0 -0x0p+0)
                                    (v128.const f64x2 0x1.921fb54442d18p+2 0x1.921fb54442d18p+2))
                                    (v128.const f64x2 0x1.921fb54442d18p+2 0x1.921fb54442d18p+2))
(assert_return (invoke "f64x2.pmax" (v128.const f64x2 -0x0p+0 -0x0p+0)
                                    (v128.const f64x2 -0x1.921fb54442d18p+2 -0x1.921fb54442d18p+2))
                                    (v128.const f64x2 -0x0.0p+0 -0x0.0p+0))
(assert_return (invoke "f64x2.pmax" (v128.const f64x2 -0x0p+0 -0x0p+0)
                                    (v128.const f64x2 0x1.fffffffffffffp+1023 0x1.fffffffffffffp+1023))
                                    (v128.const f64x2 0x1.fffffffffffffp+1023 0x1.fffffffffffffp+1023))
(assert_return (invoke "f64x2.pmax" (v128.const f64x2 -0x0p+0 -0x0p+0)
                                    (v128.const f64x2 -0x1.fffffffffffffp+1023 -0x1.fffffffffffffp+1023))
                                    (v128.const f64x2 -0x0.0p+0 -0x0.0p+0))
(assert_return (invoke "f64x2.pmax" (v128.const f64x2 -0x0p+0 -0x0p+0)
                                    (v128.const f64x2 0x0.0000000000001p-1022 0x0.0000000000001p-1022))
                                    (v128.const f64x2 0x0.0000000000001p-1022 0x0.0000000000001p-1022))
(assert_return (invoke "f64x2.pmax" (v128.const f64x2 -0x0p+0 -0x0p+0)
                                    (v128.const f64x2 0x0.0000000000001p-1022 0x0.0000000000001p-1022))
                                    (v128.const f64x2 0x0.0000000000001p-1022 0x0.0000000000001p-1022))
(assert_return (invoke "f64x2.pmax" (v128.const f64x2 -0x0p+0 -0x0p+0)
                                    (v128.const f64x2 inf inf))
                                    (v128.const f64x2 inf inf))
(assert_return (invoke "f64x2.pmax" (v128.const f64x2 -0x0p+0 -0x0p+0)
                                    (v128.const f64x2 -inf -inf))
                                    (v128.const f64x2 -0x0.0p+0 -0x0.0p+0))
(assert_return (invoke "f64x2.pmax" (v128.const f64x2 -0x0p+0 -0x0p+0)
                                    (v128.const f64x2 0123456789 0123456789))
                                    (v128.const f64x2 0x1.d6f3454000000p+26 0x1.d6f3454000000p+26))
(assert_return (invoke "f64x2.pmax" (v128.const f64x2 -0x0p+0 -0x0p+0)
                                    (v128.const f64x2 0123456789e019 0123456789e019))
                                    (v128.const f64x2 0x1.fe9af5b5e16fap+89 0x1.fe9af5b5e16fap+89))
(assert_return (invoke "f64x2.pmax" (v128.const f64x2 -0x0p+0 -0x0p+0)
                                    (v128.const f64x2 0123456789e+019 0123456789e+019))
                                    (v128.const f64x2 0x1.fe9af5b5e16fap+89 0x1.fe9af5b5e16fap+89))
(assert_return (invoke "f64x2.pmax" (v128.const f64x2 -0x0p+0 -0x0p+0)
                                    (v128.const f64x2 0123456789e-019 0123456789e-019))
                                    (v128.const f64x2 0x1.b25ffd62b4311p-37 0x1.b25ffd62b4311p-37))
(assert_return (invoke "f64x2.pmax" (v128.const f64x2 -0x0p+0 -0x0p+0)
                                    (v128.const f64x2 0123456789. 0123456789.))
                                    (v128.const f64x2 0x1.d6f3454000000p+26 0x1.d6f3454000000p+26))
(assert_return (invoke "f64x2.pmax" (v128.const f64x2 -0x0p+0 -0x0p+0)
                                    (v128.const f64x2 0123456789.e019 0123456789.e019))
                                    (v128.const f64x2 0x1.fe9af5b5e16fap+89 0x1.fe9af5b5e16fap+89))
(assert_return (invoke "f64x2.pmax" (v128.const f64x2 -0x0p+0 -0x0p+0)
                                    (v128.const f64x2 0123456789.e+019 0123456789.e+019))
                                    (v128.const f64x2 0x1.fe9af5b5e16fap+89 0x1.fe9af5b5e16fap+89))
(assert_return (invoke "f64x2.pmax" (v128.const f64x2 -0x0p+0 -0x0p+0)
                                    (v128.const f64x2 0123456789.e-019 0123456789.e-019))
                                    (v128.const f64x2 0x1.b25ffd62b4311p-37 0x1.b25ffd62b4311p-37))
(assert_return (invoke "f64x2.pmax" (v128.const f64x2 -0x0p+0 -0x0p+0)
                                    (v128.const f64x2 0123456789.0123456789 0123456789.0123456789))
                                    (v128.const f64x2 0x1.d6f34540ca458p+26 0x1.d6f34540ca458p+26))
(assert_return (invoke "f64x2.pmax" (v128.const f64x2 -0x0p+0 -0x0p+0)
                                    (v128.const f64x2 0123456789.0123456789e019 0123456789.0123456789e019))
                                    (v128.const f64x2 0x1.fe9af5b6bcbd5p+89 0x1.fe9af5b6bcbd5p+89))
(assert_return (invoke "f64x2.pmax" (v128.const f64x2 -0x0p+0 -0x0p+0)
                                    (v128.const f64x2 0123456789.0123456789e+019 0123456789.0123456789e+019))
                                    (v128.const f64x2 0x1.fe9af5b6bcbd5p+89 0x1.fe9af5b6bcbd5p+89))
(assert_return (invoke "f64x2.pmax" (v128.const f64x2 -0x0p+0 -0x0p+0)
                                    (v128.const f64x2 0123456789.0123456789e-019 0123456789.0123456789e-019))
                                    (v128.const f64x2 0x1.b25ffd636ec12p-37 0x1.b25ffd636ec12p-37))
(assert_return (invoke "f64x2.pmax" (v128.const f64x2 -0x0p+0 -0x0p+0)
                                    (v128.const f64x2 0x0123456789ABCDEFabcdef 0x0123456789ABCDEFabcdef))
                                    (v128.const f64x2 0x1.23456789abcdfp+80 0x1.23456789abcdfp+80))
(assert_return (invoke "f64x2.pmax" (v128.const f64x2 -0x0p+0 -0x0p+0)
                                    (v128.const f64x2 0x0123456789ABCDEFabcdefp019 0x0123456789ABCDEFabcdefp019))
                                    (v128.const f64x2 0x1.23456789abcdfp+99 0x1.23456789abcdfp+99))
(assert_return (invoke "f64x2.pmax" (v128.const f64x2 -0x0p+0 -0x0p+0)
                                    (v128.const f64x2 0x0123456789ABCDEFabcdefp+019 0x0123456789ABCDEFabcdefp+019))
                                    (v128.const f64x2 0x1.23456789abcdfp+99 0x1.23456789abcdfp+99))
(assert_return (invoke "f64x2.pmax" (v128.const f64x2 -0x0p+0 -0x0p+0)
                                    (v128.const f64x2 0x0123456789ABCDEFabcdefp-019 0x0123456789ABCDEFabcdefp-019))
                                    (v128.const f64x2 0x1.23456789abcdfp+61 0x1.23456789abcdfp+61))
(assert_return (invoke "f64x2.pmax" (v128.const f64x2 -0x0p+0 -0x0p+0)
                                    (v128.const f64x2 0x0123456789ABCDEFabcdef. 0x0123456789ABCDEFabcdef.))
                                    (v128.const f64x2 0x1.23456789abcdfp+80 0x1.23456789abcdfp+80))
(assert_return (invoke "f64x2.pmax" (v128.const f64x2 -0x0p+0 -0x0p+0)
                                    (v128.const f64x2 0x0123456789ABCDEFabcdef.p019 0x0123456789ABCDEFabcdef.p019))
                                    (v128.const f64x2 0x1.23456789abcdfp+99 0x1.23456789abcdfp+99))
(assert_return (invoke "f64x2.pmax" (v128.const f64x2 -0x0p+0 -0x0p+0)
                                    (v128.const f64x2 0x0123456789ABCDEFabcdef.p+019 0x0123456789ABCDEFabcdef.p+019))
                                    (v128.const f64x2 0x1.23456789abcdfp+99 0x1.23456789abcdfp+99))
(assert_return (invoke "f64x2.pmax" (v128.const f64x2 -0x0p+0 -0x0p+0)
                                    (v128.const f64x2 0x0123456789ABCDEFabcdef.p-019 0x0123456789ABCDEFabcdef.p-019))
                                    (v128.const f64x2 0x1.23456789abcdfp+61 0x1.23456789abcdfp+61))
(assert_return (invoke "f64x2.pmax" (v128.const f64x2 -0x0p+0 -0x0p+0)
                                    (v128.const f64x2 0x0123456789ABCDEFabcdef.0123456789ABCDEFabcdef 0x0123456789ABCDEFabcdef.0123456789ABCDEFabcdef))
                                    (v128.const f64x2 0x1.23456789abcdfp+80 0x1.23456789abcdfp+80))
(assert_return (invoke "f64x2.pmax" (v128.const f64x2 -0x0p+0 -0x0p+0)
                                    (v128.const f64x2 0x0123456789ABCDEFabcdef.0123456789ABCDEFabcdefp019 0x0123456789ABCDEFabcdef.0123456789ABCDEFabcdefp019))
                                    (v128.const f64x2 0x1.23456789abcdfp+99 0x1.23456789abcdfp+99))
(assert_return (invoke "f64x2.pmax" (v128.const f64x2 -0x0p+0 -0x0p+0)
                                    (v128.const f64x2 0x0123456789ABCDEFabcdef.0123456789ABCDEFabcdefp+019 0x0123456789ABCDEFabcdef.0123456789ABCDEFabcdefp+019))
                                    (v128.const f64x2 0x1.23456789abcdfp+99 0x1.23456789abcdfp+99))
(assert_return (invoke "f64x2.pmax" (v128.const f64x2 -0x0p+0 -0x0p+0)
                                    (v128.const f64x2 0x0123456789ABCDEFabcdef.0123456789ABCDEFabcdefp-019 0x0123456789ABCDEFabcdef.0123456789ABCDEFabcdefp-019))
                                    (v128.const f64x2 0x1.23456789abcdfp+61 0x1.23456789abcdfp+61))
(assert_return (invoke "f64x2.pmax" (v128.const f64x2 0x1p-1022 0x1p-1022)
                                    (v128.const f64x2 0x0p+0 0x0p+0))
                                    (v128.const f64x2 0x1.0000000000000p-1022 0x1.0000000000000p-1022))
(assert_return (invoke "f64x2.pmax" (v128.const f64x2 0x1p-1022 0x1p-1022)
                                    (v128.const f64x2 -0x0p+0 -0x0p+0))
                                    (v128.const f64x2 0x1.0000000000000p-1022 0x1.0000000000000p-1022))
(assert_return (invoke "f64x2.pmax" (v128.const f64x2 0x1p-1022 0x1p-1022)
                                    (v128.const f64x2 0x1p-1022 0x1p-1022))
                                    (v128.const f64x2 0x1.0000000000000p-1022 0x1.0000000000000p-1022))
(assert_return (invoke "f64x2.pmax" (v128.const f64x2 0x1p-1022 0x1p-1022)
                                    (v128.const f64x2 -0x1p-1022 -0x1p-1022))
                                    (v128.const f64x2 0x1.0000000000000p-1022 0x1.0000000000000p-1022))
(assert_return (invoke "f64x2.pmax" (v128.const f64x2 0x1p-1022 0x1p-1022)
                                    (v128.const f64x2 0x1p-1 0x1p-1))
                                    (v128.const f64x2 0x1.0000000000000p-1 0x1.0000000000000p-1))
(assert_return (invoke "f64x2.pmax" (v128.const f64x2 0x1p-1022 0x1p-1022)
                                    (v128.const f64x2 -0x1p-1 -0x1p-1))
                                    (v128.const f64x2 0x1.0000000000000p-1022 0x1.0000000000000p-1022))
(assert_return (invoke "f64x2.pmax" (v128.const f64x2 0x1p-1022 0x1p-1022)
                                    (v128.const f64x2 0x1p+0 0x1p+0))
                                    (v128.const f64x2 0x1.0000000000000p+0 0x1.0000000000000p+0))
(assert_return (invoke "f64x2.pmax" (v128.const f64x2 0x1p-1022 0x1p-1022)
                                    (v128.const f64x2 -0x1p+0 -0x1p+0))
                                    (v128.const f64x2 0x1.0000000000000p-1022 0x1.0000000000000p-1022))
(assert_return (invoke "f64x2.pmax" (v128.const f64x2 0x1p-1022 0x1p-1022)
                                    (v128.const f64x2 0x1.921fb54442d18p+2 0x1.921fb54442d18p+2))
                                    (v128.const f64x2 0x1.921fb54442d18p+2 0x1.921fb54442d18p+2))
(assert_return (invoke "f64x2.pmax" (v128.const f64x2 0x1p-1022 0x1p-1022)
                                    (v128.const f64x2 -0x1.921fb54442d18p+2 -0x1.921fb54442d18p+2))
                                    (v128.const f64x2 0x1.0000000000000p-1022 0x1.0000000000000p-1022))
(assert_return (invoke "f64x2.pmax" (v128.const f64x2 0x1p-1022 0x1p-1022)
                                    (v128.const f64x2 0x1.fffffffffffffp+1023 0x1.fffffffffffffp+1023))
                                    (v128.const f64x2 0x1.fffffffffffffp+1023 0x1.fffffffffffffp+1023))
(assert_return (invoke "f64x2.pmax" (v128.const f64x2 0x1p-1022 0x1p-1022)
                                    (v128.const f64x2 -0x1.fffffffffffffp+1023 -0x1.fffffffffffffp+1023))
                                    (v128.const f64x2 0x1.0000000000000p-1022 0x1.0000000000000p-1022))
(assert_return (invoke "f64x2.pmax" (v128.const f64x2 0x1p-1022 0x1p-1022)
                                    (v128.const f64x2 0x0.0000000000001p-1022 0x0.0000000000001p-1022))
                                    (v128.const f64x2 0x1.0000000000000p-1022 0x1.0000000000000p-1022))
(assert_return (invoke "f64x2.pmax" (v128.const f64x2 0x1p-1022 0x1p-1022)
                                    (v128.const f64x2 0x0.0000000000001p-1022 0x0.0000000000001p-1022))
                                    (v128.const f64x2 0x1.0000000000000p-1022 0x1.0000000000000p-1022))
(assert_return (invoke "f64x2.pmax" (v128.const f64x2 0x1p-1022 0x1p-1022)
                                    (v128.const f64x2 inf inf))
                                    (v128.const f64x2 inf inf))
(assert_return (invoke "f64x2.pmax" (v128.const f64x2 0x1p-1022 0x1p-1022)
                                    (v128.const f64x2 -inf -inf))
                                    (v128.const f64x2 0x1.0000000000000p-1022 0x1.0000000000000p-1022))
(assert_return (invoke "f64x2.pmax" (v128.const f64x2 0x1p-1022 0x1p-1022)
                                    (v128.const f64x2 0123456789 0123456789))
                                    (v128.const f64x2 0x1.d6f3454000000p+26 0x1.d6f3454000000p+26))
(assert_return (invoke "f64x2.pmax" (v128.const f64x2 0x1p-1022 0x1p-1022)
                                    (v128.const f64x2 0123456789e019 0123456789e019))
                                    (v128.const f64x2 0x1.fe9af5b5e16fap+89 0x1.fe9af5b5e16fap+89))
(assert_return (invoke "f64x2.pmax" (v128.const f64x2 0x1p-1022 0x1p-1022)
                                    (v128.const f64x2 0123456789e+019 0123456789e+019))
                                    (v128.const f64x2 0x1.fe9af5b5e16fap+89 0x1.fe9af5b5e16fap+89))
(assert_return (invoke "f64x2.pmax" (v128.const f64x2 0x1p-1022 0x1p-1022)
                                    (v128.const f64x2 0123456789e-019 0123456789e-019))
                                    (v128.const f64x2 0x1.b25ffd62b4311p-37 0x1.b25ffd62b4311p-37))
(assert_return (invoke "f64x2.pmax" (v128.const f64x2 0x1p-1022 0x1p-1022)
                                    (v128.const f64x2 0123456789. 0123456789.))
                                    (v128.const f64x2 0x1.d6f3454000000p+26 0x1.d6f3454000000p+26))
(assert_return (invoke "f64x2.pmax" (v128.const f64x2 0x1p-1022 0x1p-1022)
                                    (v128.const f64x2 0123456789.e019 0123456789.e019))
                                    (v128.const f64x2 0x1.fe9af5b5e16fap+89 0x1.fe9af5b5e16fap+89))
(assert_return (invoke "f64x2.pmax" (v128.const f64x2 0x1p-1022 0x1p-1022)
                                    (v128.const f64x2 0123456789.e+019 0123456789.e+019))
                                    (v128.const f64x2 0x1.fe9af5b5e16fap+89 0x1.fe9af5b5e16fap+89))
(assert_return (invoke "f64x2.pmax" (v128.const f64x2 0x1p-1022 0x1p-1022)
                                    (v128.const f64x2 0123456789.e-019 0123456789.e-019))
                                    (v128.const f64x2 0x1.b25ffd62b4311p-37 0x1.b25ffd62b4311p-37))
(assert_return (invoke "f64x2.pmax" (v128.const f64x2 0x1p-1022 0x1p-1022)
                                    (v128.const f64x2 0123456789.0123456789 0123456789.0123456789))
                                    (v128.const f64x2 0x1.d6f34540ca458p+26 0x1.d6f34540ca458p+26))
(assert_return (invoke "f64x2.pmax" (v128.const f64x2 0x1p-1022 0x1p-1022)
                                    (v128.const f64x2 0123456789.0123456789e019 0123456789.0123456789e019))
                                    (v128.const f64x2 0x1.fe9af5b6bcbd5p+89 0x1.fe9af5b6bcbd5p+89))
(assert_return (invoke "f64x2.pmax" (v128.const f64x2 0x1p-1022 0x1p-1022)
                                    (v128.const f64x2 0123456789.0123456789e+019 0123456789.0123456789e+019))
                                    (v128.const f64x2 0x1.fe9af5b6bcbd5p+89 0x1.fe9af5b6bcbd5p+89))
(assert_return (invoke "f64x2.pmax" (v128.const f64x2 0x1p-1022 0x1p-1022)
                                    (v128.const f64x2 0123456789.0123456789e-019 0123456789.0123456789e-019))
                                    (v128.const f64x2 0x1.b25ffd636ec12p-37 0x1.b25ffd636ec12p-37))
(assert_return (invoke "f64x2.pmax" (v128.const f64x2 0x1p-1022 0x1p-1022)
                                    (v128.const f64x2 0x0123456789ABCDEFabcdef 0x0123456789ABCDEFabcdef))
                                    (v128.const f64x2 0x1.23456789abcdfp+80 0x1.23456789abcdfp+80))
(assert_return (invoke "f64x2.pmax" (v128.const f64x2 0x1p-1022 0x1p-1022)
                                    (v128.const f64x2 0x0123456789ABCDEFabcdefp019 0x0123456789ABCDEFabcdefp019))
                                    (v128.const f64x2 0x1.23456789abcdfp+99 0x1.23456789abcdfp+99))
(assert_return (invoke "f64x2.pmax" (v128.const f64x2 0x1p-1022 0x1p-1022)
                                    (v128.const f64x2 0x0123456789ABCDEFabcdefp+019 0x0123456789ABCDEFabcdefp+019))
                                    (v128.const f64x2 0x1.23456789abcdfp+99 0x1.23456789abcdfp+99))
(assert_return (invoke "f64x2.pmax" (v128.const f64x2 0x1p-1022 0x1p-1022)
                                    (v128.const f64x2 0x0123456789ABCDEFabcdefp-019 0x0123456789ABCDEFabcdefp-019))
                                    (v128.const f64x2 0x1.23456789abcdfp+61 0x1.23456789abcdfp+61))
(assert_return (invoke "f64x2.pmax" (v128.const f64x2 0x1p-1022 0x1p-1022)
                                    (v128.const f64x2 0x0123456789ABCDEFabcdef. 0x0123456789ABCDEFabcdef.))
                                    (v128.const f64x2 0x1.23456789abcdfp+80 0x1.23456789abcdfp+80))
(assert_return (invoke "f64x2.pmax" (v128.const f64x2 0x1p-1022 0x1p-1022)
                                    (v128.const f64x2 0x0123456789ABCDEFabcdef.p019 0x0123456789ABCDEFabcdef.p019))
                                    (v128.const f64x2 0x1.23456789abcdfp+99 0x1.23456789abcdfp+99))
(assert_return (invoke "f64x2.pmax" (v128.const f64x2 0x1p-1022 0x1p-1022)
                                    (v128.const f64x2 0x0123456789ABCDEFabcdef.p+019 0x0123456789ABCDEFabcdef.p+019))
                                    (v128.const f64x2 0x1.23456789abcdfp+99 0x1.23456789abcdfp+99))
(assert_return (invoke "f64x2.pmax" (v128.const f64x2 0x1p-1022 0x1p-1022)
                                    (v128.const f64x2 0x0123456789ABCDEFabcdef.p-019 0x0123456789ABCDEFabcdef.p-019))
                                    (v128.const f64x2 0x1.23456789abcdfp+61 0x1.23456789abcdfp+61))
(assert_return (invoke "f64x2.pmax" (v128.const f64x2 0x1p-1022 0x1p-1022)
                                    (v128.const f64x2 0x0123456789ABCDEFabcdef.0123456789ABCDEFabcdef 0x0123456789ABCDEFabcdef.0123456789ABCDEFabcdef))
                                    (v128.const f64x2 0x1.23456789abcdfp+80 0x1.23456789abcdfp+80))
(assert_return (invoke "f64x2.pmax" (v128.const f64x2 0x1p-1022 0x1p-1022)
                                    (v128.const f64x2 0x0123456789ABCDEFabcdef.0123456789ABCDEFabcdefp019 0x0123456789ABCDEFabcdef.0123456789ABCDEFabcdefp019))
                                    (v128.const f64x2 0x1.23456789abcdfp+99 0x1.23456789abcdfp+99))
(assert_return (invoke "f64x2.pmax" (v128.const f64x2 0x1p-1022 0x1p-1022)
                                    (v128.const f64x2 0x0123456789ABCDEFabcdef.0123456789ABCDEFabcdefp+019 0x0123456789ABCDEFabcdef.0123456789ABCDEFabcdefp+019))
                                    (v128.const f64x2 0x1.23456789abcdfp+99 0x1.23456789abcdfp+99))
(assert_return (invoke "f64x2.pmax" (v128.const f64x2 0x1p-1022 0x1p-1022)
                                    (v128.const f64x2 0x0123456789ABCDEFabcdef.0123456789ABCDEFabcdefp-019 0x0123456789ABCDEFabcdef.0123456789ABCDEFabcdefp-019))
                                    (v128.const f64x2 0x1.23456789abcdfp+61 0x1.23456789abcdfp+61))
(assert_return (invoke "f64x2.pmax" (v128.const f64x2 -0x1p-1022 -0x1p-1022)
                                    (v128.const f64x2 0x0p+0 0x0p+0))
                                    (v128.const f64x2 0x0.0p+0 0x0.0p+0))
(assert_return (invoke "f64x2.pmax" (v128.const f64x2 -0x1p-1022 -0x1p-1022)
                                    (v128.const f64x2 -0x0p+0 -0x0p+0))
                                    (v128.const f64x2 -0x0.0p+0 -0x0.0p+0))
(assert_return (invoke "f64x2.pmax" (v128.const f64x2 -0x1p-1022 -0x1p-1022)
                                    (v128.const f64x2 0x1p-1022 0x1p-1022))
                                    (v128.const f64x2 0x1.0000000000000p-1022 0x1.0000000000000p-1022))
(assert_return (invoke "f64x2.pmax" (v128.const f64x2 -0x1p-1022 -0x1p-1022)
                                    (v128.const f64x2 -0x1p-1022 -0x1p-1022))
                                    (v128.const f64x2 -0x1.0000000000000p-1022 -0x1.0000000000000p-1022))
(assert_return (invoke "f64x2.pmax" (v128.const f64x2 -0x1p-1022 -0x1p-1022)
                                    (v128.const f64x2 0x1p-1 0x1p-1))
                                    (v128.const f64x2 0x1.0000000000000p-1 0x1.0000000000000p-1))
(assert_return (invoke "f64x2.pmax" (v128.const f64x2 -0x1p-1022 -0x1p-1022)
                                    (v128.const f64x2 -0x1p-1 -0x1p-1))
                                    (v128.const f64x2 -0x1.0000000000000p-1022 -0x1.0000000000000p-1022))
(assert_return (invoke "f64x2.pmax" (v128.const f64x2 -0x1p-1022 -0x1p-1022)
                                    (v128.const f64x2 0x1p+0 0x1p+0))
                                    (v128.const f64x2 0x1.0000000000000p+0 0x1.0000000000000p+0))
(assert_return (invoke "f64x2.pmax" (v128.const f64x2 -0x1p-1022 -0x1p-1022)
                                    (v128.const f64x2 -0x1p+0 -0x1p+0))
                                    (v128.const f64x2 -0x1.0000000000000p-1022 -0x1.0000000000000p-1022))
(assert_return (invoke "f64x2.pmax" (v128.const f64x2 -0x1p-1022 -0x1p-1022)
                                    (v128.const f64x2 0x1.921fb54442d18p+2 0x1.921fb54442d18p+2))
                                    (v128.const f64x2 0x1.921fb54442d18p+2 0x1.921fb54442d18p+2))
(assert_return (invoke "f64x2.pmax" (v128.const f64x2 -0x1p-1022 -0x1p-1022)
                                    (v128.const f64x2 -0x1.921fb54442d18p+2 -0x1.921fb54442d18p+2))
                                    (v128.const f64x2 -0x1.0000000000000p-1022 -0x1.0000000000000p-1022))
(assert_return (invoke "f64x2.pmax" (v128.const f64x2 -0x1p-1022 -0x1p-1022)
                                    (v128.const f64x2 0x1.fffffffffffffp+1023 0x1.fffffffffffffp+1023))
                                    (v128.const f64x2 0x1.fffffffffffffp+1023 0x1.fffffffffffffp+1023))
(assert_return (invoke "f64x2.pmax" (v128.const f64x2 -0x1p-1022 -0x1p-1022)
                                    (v128.const f64x2 -0x1.fffffffffffffp+1023 -0x1.fffffffffffffp+1023))
                                    (v128.const f64x2 -0x1.0000000000000p-1022 -0x1.0000000000000p-1022))
(assert_return (invoke "f64x2.pmax" (v128.const f64x2 -0x1p-1022 -0x1p-1022)
                                    (v128.const f64x2 0x0.0000000000001p-1022 0x0.0000000000001p-1022))
                                    (v128.const f64x2 0x0.0000000000001p-1022 0x0.0000000000001p-1022))
(assert_return (invoke "f64x2.pmax" (v128.const f64x2 -0x1p-1022 -0x1p-1022)
                                    (v128.const f64x2 0x0.0000000000001p-1022 0x0.0000000000001p-1022))
                                    (v128.const f64x2 0x0.0000000000001p-1022 0x0.0000000000001p-1022))
(assert_return (invoke "f64x2.pmax" (v128.const f64x2 -0x1p-1022 -0x1p-1022)
                                    (v128.const f64x2 inf inf))
                                    (v128.const f64x2 inf inf))
(assert_return (invoke "f64x2.pmax" (v128.const f64x2 -0x1p-1022 -0x1p-1022)
                                    (v128.const f64x2 -inf -inf))
                                    (v128.const f64x2 -0x1.0000000000000p-1022 -0x1.0000000000000p-1022))
(assert_return (invoke "f64x2.pmax" (v128.const f64x2 -0x1p-1022 -0x1p-1022)
                                    (v128.const f64x2 0123456789 0123456789))
                                    (v128.const f64x2 0x1.d6f3454000000p+26 0x1.d6f3454000000p+26))
(assert_return (invoke "f64x2.pmax" (v128.const f64x2 -0x1p-1022 -0x1p-1022)
                                    (v128.const f64x2 0123456789e019 0123456789e019))
                                    (v128.const f64x2 0x1.fe9af5b5e16fap+89 0x1.fe9af5b5e16fap+89))
(assert_return (invoke "f64x2.pmax" (v128.const f64x2 -0x1p-1022 -0x1p-1022)
                                    (v128.const f64x2 0123456789e+019 0123456789e+019))
                                    (v128.const f64x2 0x1.fe9af5b5e16fap+89 0x1.fe9af5b5e16fap+89))
(assert_return (invoke "f64x2.pmax" (v128.const f64x2 -0x1p-1022 -0x1p-1022)
                                    (v128.const f64x2 0123456789e-019 0123456789e-019))
                                    (v128.const f64x2 0x1.b25ffd62b4311p-37 0x1.b25ffd62b4311p-37))
(assert_return (invoke "f64x2.pmax" (v128.const f64x2 -0x1p-1022 -0x1p-1022)
                                    (v128.const f64x2 0123456789. 0123456789.))
                                    (v128.const f64x2 0x1.d6f3454000000p+26 0x1.d6f3454000000p+26))
(assert_return (invoke "f64x2.pmax" (v128.const f64x2 -0x1p-1022 -0x1p-1022)
                                    (v128.const f64x2 0123456789.e019 0123456789.e019))
                                    (v128.const f64x2 0x1.fe9af5b5e16fap+89 0x1.fe9af5b5e16fap+89))
(assert_return (invoke "f64x2.pmax" (v128.const f64x2 -0x1p-1022 -0x1p-1022)
                                    (v128.const f64x2 0123456789.e+019 0123456789.e+019))
                                    (v128.const f64x2 0x1.fe9af5b5e16fap+89 0x1.fe9af5b5e16fap+89))
(assert_return (invoke "f64x2.pmax" (v128.const f64x2 -0x1p-1022 -0x1p-1022)
                                    (v128.const f64x2 0123456789.e-019 0123456789.e-019))
                                    (v128.const f64x2 0x1.b25ffd62b4311p-37 0x1.b25ffd62b4311p-37))
(assert_return (invoke "f64x2.pmax" (v128.const f64x2 -0x1p-1022 -0x1p-1022)
                                    (v128.const f64x2 0123456789.0123456789 0123456789.0123456789))
                                    (v128.const f64x2 0x1.d6f34540ca458p+26 0x1.d6f34540ca458p+26))
(assert_return (invoke "f64x2.pmax" (v128.const f64x2 -0x1p-1022 -0x1p-1022)
                                    (v128.const f64x2 0123456789.0123456789e019 0123456789.0123456789e019))
                                    (v128.const f64x2 0x1.fe9af5b6bcbd5p+89 0x1.fe9af5b6bcbd5p+89))
(assert_return (invoke "f64x2.pmax" (v128.const f64x2 -0x1p-1022 -0x1p-1022)
                                    (v128.const f64x2 0123456789.0123456789e+019 0123456789.0123456789e+019))
                                    (v128.const f64x2 0x1.fe9af5b6bcbd5p+89 0x1.fe9af5b6bcbd5p+89))
(assert_return (invoke "f64x2.pmax" (v128.const f64x2 -0x1p-1022 -0x1p-1022)
                                    (v128.const f64x2 0123456789.0123456789e-019 0123456789.0123456789e-019))
                                    (v128.const f64x2 0x1.b25ffd636ec12p-37 0x1.b25ffd636ec12p-37))
(assert_return (invoke "f64x2.pmax" (v128.const f64x2 -0x1p-1022 -0x1p-1022)
                                    (v128.const f64x2 0x0123456789ABCDEFabcdef 0x0123456789ABCDEFabcdef))
                                    (v128.const f64x2 0x1.23456789abcdfp+80 0x1.23456789abcdfp+80))
(assert_return (invoke "f64x2.pmax" (v128.const f64x2 -0x1p-1022 -0x1p-1022)
                                    (v128.const f64x2 0x0123456789ABCDEFabcdefp019 0x0123456789ABCDEFabcdefp019))
                                    (v128.const f64x2 0x1.23456789abcdfp+99 0x1.23456789abcdfp+99))
(assert_return (invoke "f64x2.pmax" (v128.const f64x2 -0x1p-1022 -0x1p-1022)
                                    (v128.const f64x2 0x0123456789ABCDEFabcdefp+019 0x0123456789ABCDEFabcdefp+019))
                                    (v128.const f64x2 0x1.23456789abcdfp+99 0x1.23456789abcdfp+99))
(assert_return (invoke "f64x2.pmax" (v128.const f64x2 -0x1p-1022 -0x1p-1022)
                                    (v128.const f64x2 0x0123456789ABCDEFabcdefp-019 0x0123456789ABCDEFabcdefp-019))
                                    (v128.const f64x2 0x1.23456789abcdfp+61 0x1.23456789abcdfp+61))
(assert_return (invoke "f64x2.pmax" (v128.const f64x2 -0x1p-1022 -0x1p-1022)
                                    (v128.const f64x2 0x0123456789ABCDEFabcdef. 0x0123456789ABCDEFabcdef.))
                                    (v128.const f64x2 0x1.23456789abcdfp+80 0x1.23456789abcdfp+80))
(assert_return (invoke "f64x2.pmax" (v128.const f64x2 -0x1p-1022 -0x1p-1022)
                                    (v128.const f64x2 0x0123456789ABCDEFabcdef.p019 0x0123456789ABCDEFabcdef.p019))
                                    (v128.const f64x2 0x1.23456789abcdfp+99 0x1.23456789abcdfp+99))
(assert_return (invoke "f64x2.pmax" (v128.const f64x2 -0x1p-1022 -0x1p-1022)
                                    (v128.const f64x2 0x0123456789ABCDEFabcdef.p+019 0x0123456789ABCDEFabcdef.p+019))
                                    (v128.const f64x2 0x1.23456789abcdfp+99 0x1.23456789abcdfp+99))
(assert_return (invoke "f64x2.pmax" (v128.const f64x2 -0x1p-1022 -0x1p-1022)
                                    (v128.const f64x2 0x0123456789ABCDEFabcdef.p-019 0x0123456789ABCDEFabcdef.p-019))
                                    (v128.const f64x2 0x1.23456789abcdfp+61 0x1.23456789abcdfp+61))
(assert_return (invoke "f64x2.pmax" (v128.const f64x2 -0x1p-1022 -0x1p-1022)
                                    (v128.const f64x2 0x0123456789ABCDEFabcdef.0123456789ABCDEFabcdef 0x0123456789ABCDEFabcdef.0123456789ABCDEFabcdef))
                                    (v128.const f64x2 0x1.23456789abcdfp+80 0x1.23456789abcdfp+80))
(assert_return (invoke "f64x2.pmax" (v128.const f64x2 -0x1p-1022 -0x1p-1022)
                                    (v128.const f64x2 0x0123456789ABCDEFabcdef.0123456789ABCDEFabcdefp019 0x0123456789ABCDEFabcdef.0123456789ABCDEFabcdefp019))
                                    (v128.const f64x2 0x1.23456789abcdfp+99 0x1.23456789abcdfp+99))
(assert_return (invoke "f64x2.pmax" (v128.const f64x2 -0x1p-1022 -0x1p-1022)
                                    (v128.const f64x2 0x0123456789ABCDEFabcdef.0123456789ABCDEFabcdefp+019 0x0123456789ABCDEFabcdef.0123456789ABCDEFabcdefp+019))
                                    (v128.const f64x2 0x1.23456789abcdfp+99 0x1.23456789abcdfp+99))
(assert_return (invoke "f64x2.pmax" (v128.const f64x2 -0x1p-1022 -0x1p-1022)
                                    (v128.const f64x2 0x0123456789ABCDEFabcdef.0123456789ABCDEFabcdefp-019 0x0123456789ABCDEFabcdef.0123456789ABCDEFabcdefp-019))
                                    (v128.const f64x2 0x1.23456789abcdfp+61 0x1.23456789abcdfp+61))
(assert_return (invoke "f64x2.pmax" (v128.const f64x2 0x1p-1 0x1p-1)
                                    (v128.const f64x2 0x0p+0 0x0p+0))
                                    (v128.const f64x2 0x1.0000000000000p-1 0x1.0000000000000p-1))
(assert_return (invoke "f64x2.pmax" (v128.const f64x2 0x1p-1 0x1p-1)
                                    (v128.const f64x2 -0x0p+0 -0x0p+0))
                                    (v128.const f64x2 0x1.0000000000000p-1 0x1.0000000000000p-1))
(assert_return (invoke "f64x2.pmax" (v128.const f64x2 0x1p-1 0x1p-1)
                                    (v128.const f64x2 0x1p-1022 0x1p-1022))
                                    (v128.const f64x2 0x1.0000000000000p-1 0x1.0000000000000p-1))
(assert_return (invoke "f64x2.pmax" (v128.const f64x2 0x1p-1 0x1p-1)
                                    (v128.const f64x2 -0x1p-1022 -0x1p-1022))
                                    (v128.const f64x2 0x1.0000000000000p-1 0x1.0000000000000p-1))
(assert_return (invoke "f64x2.pmax" (v128.const f64x2 0x1p-1 0x1p-1)
                                    (v128.const f64x2 0x1p-1 0x1p-1))
                                    (v128.const f64x2 0x1.0000000000000p-1 0x1.0000000000000p-1))
(assert_return (invoke "f64x2.pmax" (v128.const f64x2 0x1p-1 0x1p-1)
                                    (v128.const f64x2 -0x1p-1 -0x1p-1))
                                    (v128.const f64x2 0x1.0000000000000p-1 0x1.0000000000000p-1))
(assert_return (invoke "f64x2.pmax" (v128.const f64x2 0x1p-1 0x1p-1)
                                    (v128.const f64x2 0x1p+0 0x1p+0))
                                    (v128.const f64x2 0x1.0000000000000p+0 0x1.0000000000000p+0))
(assert_return (invoke "f64x2.pmax" (v128.const f64x2 0x1p-1 0x1p-1)
                                    (v128.const f64x2 -0x1p+0 -0x1p+0))
                                    (v128.const f64x2 0x1.0000000000000p-1 0x1.0000000000000p-1))
(assert_return (invoke "f64x2.pmax" (v128.const f64x2 0x1p-1 0x1p-1)
                                    (v128.const f64x2 0x1.921fb54442d18p+2 0x1.921fb54442d18p+2))
                                    (v128.const f64x2 0x1.921fb54442d18p+2 0x1.921fb54442d18p+2))
(assert_return (invoke "f64x2.pmax" (v128.const f64x2 0x1p-1 0x1p-1)
                                    (v128.const f64x2 -0x1.921fb54442d18p+2 -0x1.921fb54442d18p+2))
                                    (v128.const f64x2 0x1.0000000000000p-1 0x1.0000000000000p-1))
(assert_return (invoke "f64x2.pmax" (v128.const f64x2 0x1p-1 0x1p-1)
                                    (v128.const f64x2 0x1.fffffffffffffp+1023 0x1.fffffffffffffp+1023))
                                    (v128.const f64x2 0x1.fffffffffffffp+1023 0x1.fffffffffffffp+1023))
(assert_return (invoke "f64x2.pmax" (v128.const f64x2 0x1p-1 0x1p-1)
                                    (v128.const f64x2 -0x1.fffffffffffffp+1023 -0x1.fffffffffffffp+1023))
                                    (v128.const f64x2 0x1.0000000000000p-1 0x1.0000000000000p-1))
(assert_return (invoke "f64x2.pmax" (v128.const f64x2 0x1p-1 0x1p-1)
                                    (v128.const f64x2 0x0.0000000000001p-1022 0x0.0000000000001p-1022))
                                    (v128.const f64x2 0x1.0000000000000p-1 0x1.0000000000000p-1))
(assert_return (invoke "f64x2.pmax" (v128.const f64x2 0x1p-1 0x1p-1)
                                    (v128.const f64x2 0x0.0000000000001p-1022 0x0.0000000000001p-1022))
                                    (v128.const f64x2 0x1.0000000000000p-1 0x1.0000000000000p-1))
(assert_return (invoke "f64x2.pmax" (v128.const f64x2 0x1p-1 0x1p-1)
                                    (v128.const f64x2 inf inf))
                                    (v128.const f64x2 inf inf))
(assert_return (invoke "f64x2.pmax" (v128.const f64x2 0x1p-1 0x1p-1)
                                    (v128.const f64x2 -inf -inf))
                                    (v128.const f64x2 0x1.0000000000000p-1 0x1.0000000000000p-1))
(assert_return (invoke "f64x2.pmax" (v128.const f64x2 0x1p-1 0x1p-1)
                                    (v128.const f64x2 0123456789 0123456789))
                                    (v128.const f64x2 0x1.d6f3454000000p+26 0x1.d6f3454000000p+26))
(assert_return (invoke "f64x2.pmax" (v128.const f64x2 0x1p-1 0x1p-1)
                                    (v128.const f64x2 0123456789e019 0123456789e019))
                                    (v128.const f64x2 0x1.fe9af5b5e16fap+89 0x1.fe9af5b5e16fap+89))
(assert_return (invoke "f64x2.pmax" (v128.const f64x2 0x1p-1 0x1p-1)
                                    (v128.const f64x2 0123456789e+019 0123456789e+019))
                                    (v128.const f64x2 0x1.fe9af5b5e16fap+89 0x1.fe9af5b5e16fap+89))
(assert_return (invoke "f64x2.pmax" (v128.const f64x2 0x1p-1 0x1p-1)
                                    (v128.const f64x2 0123456789e-019 0123456789e-019))
                                    (v128.const f64x2 0x1.0000000000000p-1 0x1.0000000000000p-1))
(assert_return (invoke "f64x2.pmax" (v128.const f64x2 0x1p-1 0x1p-1)
                                    (v128.const f64x2 0123456789. 0123456789.))
                                    (v128.const f64x2 0x1.d6f3454000000p+26 0x1.d6f3454000000p+26))
(assert_return (invoke "f64x2.pmax" (v128.const f64x2 0x1p-1 0x1p-1)
                                    (v128.const f64x2 0123456789.e019 0123456789.e019))
                                    (v128.const f64x2 0x1.fe9af5b5e16fap+89 0x1.fe9af5b5e16fap+89))
(assert_return (invoke "f64x2.pmax" (v128.const f64x2 0x1p-1 0x1p-1)
                                    (v128.const f64x2 0123456789.e+019 0123456789.e+019))
                                    (v128.const f64x2 0x1.fe9af5b5e16fap+89 0x1.fe9af5b5e16fap+89))
(assert_return (invoke "f64x2.pmax" (v128.const f64x2 0x1p-1 0x1p-1)
                                    (v128.const f64x2 0123456789.e-019 0123456789.e-019))
                                    (v128.const f64x2 0x1.0000000000000p-1 0x1.0000000000000p-1))
(assert_return (invoke "f64x2.pmax" (v128.const f64x2 0x1p-1 0x1p-1)
                                    (v128.const f64x2 0123456789.0123456789 0123456789.0123456789))
                                    (v128.const f64x2 0x1.d6f34540ca458p+26 0x1.d6f34540ca458p+26))
(assert_return (invoke "f64x2.pmax" (v128.const f64x2 0x1p-1 0x1p-1)
                                    (v128.const f64x2 0123456789.0123456789e019 0123456789.0123456789e019))
                                    (v128.const f64x2 0x1.fe9af5b6bcbd5p+89 0x1.fe9af5b6bcbd5p+89))
(assert_return (invoke "f64x2.pmax" (v128.const f64x2 0x1p-1 0x1p-1)
                                    (v128.const f64x2 0123456789.0123456789e+019 0123456789.0123456789e+019))
                                    (v128.const f64x2 0x1.fe9af5b6bcbd5p+89 0x1.fe9af5b6bcbd5p+89))
(assert_return (invoke "f64x2.pmax" (v128.const f64x2 0x1p-1 0x1p-1)
                                    (v128.const f64x2 0123456789.0123456789e-019 0123456789.0123456789e-019))
                                    (v128.const f64x2 0x1.0000000000000p-1 0x1.0000000000000p-1))
(assert_return (invoke "f64x2.pmax" (v128.const f64x2 0x1p-1 0x1p-1)
                                    (v128.const f64x2 0x0123456789ABCDEFabcdef 0x0123456789ABCDEFabcdef))
                                    (v128.const f64x2 0x1.23456789abcdfp+80 0x1.23456789abcdfp+80))
(assert_return (invoke "f64x2.pmax" (v128.const f64x2 0x1p-1 0x1p-1)
                                    (v128.const f64x2 0x0123456789ABCDEFabcdefp019 0x0123456789ABCDEFabcdefp019))
                                    (v128.const f64x2 0x1.23456789abcdfp+99 0x1.23456789abcdfp+99))
(assert_return (invoke "f64x2.pmax" (v128.const f64x2 0x1p-1 0x1p-1)
                                    (v128.const f64x2 0x0123456789ABCDEFabcdefp+019 0x0123456789ABCDEFabcdefp+019))
                                    (v128.const f64x2 0x1.23456789abcdfp+99 0x1.23456789abcdfp+99))
(assert_return (invoke "f64x2.pmax" (v128.const f64x2 0x1p-1 0x1p-1)
                                    (v128.const f64x2 0x0123456789ABCDEFabcdefp-019 0x0123456789ABCDEFabcdefp-019))
                                    (v128.const f64x2 0x1.23456789abcdfp+61 0x1.23456789abcdfp+61))
(assert_return (invoke "f64x2.pmax" (v128.const f64x2 0x1p-1 0x1p-1)
                                    (v128.const f64x2 0x0123456789ABCDEFabcdef. 0x0123456789ABCDEFabcdef.))
                                    (v128.const f64x2 0x1.23456789abcdfp+80 0x1.23456789abcdfp+80))
(assert_return (invoke "f64x2.pmax" (v128.const f64x2 0x1p-1 0x1p-1)
                                    (v128.const f64x2 0x0123456789ABCDEFabcdef.p019 0x0123456789ABCDEFabcdef.p019))
                                    (v128.const f64x2 0x1.23456789abcdfp+99 0x1.23456789abcdfp+99))
(assert_return (invoke "f64x2.pmax" (v128.const f64x2 0x1p-1 0x1p-1)
                                    (v128.const f64x2 0x0123456789ABCDEFabcdef.p+019 0x0123456789ABCDEFabcdef.p+019))
                                    (v128.const f64x2 0x1.23456789abcdfp+99 0x1.23456789abcdfp+99))
(assert_return (invoke "f64x2.pmax" (v128.const f64x2 0x1p-1 0x1p-1)
                                    (v128.const f64x2 0x0123456789ABCDEFabcdef.p-019 0x0123456789ABCDEFabcdef.p-019))
                                    (v128.const f64x2 0x1.23456789abcdfp+61 0x1.23456789abcdfp+61))
(assert_return (invoke "f64x2.pmax" (v128.const f64x2 0x1p-1 0x1p-1)
                                    (v128.const f64x2 0x0123456789ABCDEFabcdef.0123456789ABCDEFabcdef 0x0123456789ABCDEFabcdef.0123456789ABCDEFabcdef))
                                    (v128.const f64x2 0x1.23456789abcdfp+80 0x1.23456789abcdfp+80))
(assert_return (invoke "f64x2.pmax" (v128.const f64x2 0x1p-1 0x1p-1)
                                    (v128.const f64x2 0x0123456789ABCDEFabcdef.0123456789ABCDEFabcdefp019 0x0123456789ABCDEFabcdef.0123456789ABCDEFabcdefp019))
                                    (v128.const f64x2 0x1.23456789abcdfp+99 0x1.23456789abcdfp+99))
(assert_return (invoke "f64x2.pmax" (v128.const f64x2 0x1p-1 0x1p-1)
                                    (v128.const f64x2 0x0123456789ABCDEFabcdef.0123456789ABCDEFabcdefp+019 0x0123456789ABCDEFabcdef.0123456789ABCDEFabcdefp+019))
                                    (v128.const f64x2 0x1.23456789abcdfp+99 0x1.23456789abcdfp+99))
(assert_return (invoke "f64x2.pmax" (v128.const f64x2 0x1p-1 0x1p-1)
                                    (v128.const f64x2 0x0123456789ABCDEFabcdef.0123456789ABCDEFabcdefp-019 0x0123456789ABCDEFabcdef.0123456789ABCDEFabcdefp-019))
                                    (v128.const f64x2 0x1.23456789abcdfp+61 0x1.23456789abcdfp+61))
(assert_return (invoke "f64x2.pmax" (v128.const f64x2 -0x1p-1 -0x1p-1)
                                    (v128.const f64x2 0x0p+0 0x0p+0))
                                    (v128.const f64x2 0x0.0p+0 0x0.0p+0))
(assert_return (invoke "f64x2.pmax" (v128.const f64x2 -0x1p-1 -0x1p-1)
                                    (v128.const f64x2 -0x0p+0 -0x0p+0))
                                    (v128.const f64x2 -0x0.0p+0 -0x0.0p+0))
(assert_return (invoke "f64x2.pmax" (v128.const f64x2 -0x1p-1 -0x1p-1)
                                    (v128.const f64x2 0x1p-1022 0x1p-1022))
                                    (v128.const f64x2 0x1.0000000000000p-1022 0x1.0000000000000p-1022))
(assert_return (invoke "f64x2.pmax" (v128.const f64x2 -0x1p-1 -0x1p-1)
                                    (v128.const f64x2 -0x1p-1022 -0x1p-1022))
                                    (v128.const f64x2 -0x1.0000000000000p-1022 -0x1.0000000000000p-1022))
(assert_return (invoke "f64x2.pmax" (v128.const f64x2 -0x1p-1 -0x1p-1)
                                    (v128.const f64x2 0x1p-1 0x1p-1))
                                    (v128.const f64x2 0x1.0000000000000p-1 0x1.0000000000000p-1))
(assert_return (invoke "f64x2.pmax" (v128.const f64x2 -0x1p-1 -0x1p-1)
                                    (v128.const f64x2 -0x1p-1 -0x1p-1))
                                    (v128.const f64x2 -0x1.0000000000000p-1 -0x1.0000000000000p-1))
(assert_return (invoke "f64x2.pmax" (v128.const f64x2 -0x1p-1 -0x1p-1)
                                    (v128.const f64x2 0x1p+0 0x1p+0))
                                    (v128.const f64x2 0x1.0000000000000p+0 0x1.0000000000000p+0))
(assert_return (invoke "f64x2.pmax" (v128.const f64x2 -0x1p-1 -0x1p-1)
                                    (v128.const f64x2 -0x1p+0 -0x1p+0))
                                    (v128.const f64x2 -0x1.0000000000000p-1 -0x1.0000000000000p-1))
(assert_return (invoke "f64x2.pmax" (v128.const f64x2 -0x1p-1 -0x1p-1)
                                    (v128.const f64x2 0x1.921fb54442d18p+2 0x1.921fb54442d18p+2))
                                    (v128.const f64x2 0x1.921fb54442d18p+2 0x1.921fb54442d18p+2))
(assert_return (invoke "f64x2.pmax" (v128.const f64x2 -0x1p-1 -0x1p-1)
                                    (v128.const f64x2 -0x1.921fb54442d18p+2 -0x1.921fb54442d18p+2))
                                    (v128.const f64x2 -0x1.0000000000000p-1 -0x1.0000000000000p-1))
(assert_return (invoke "f64x2.pmax" (v128.const f64x2 -0x1p-1 -0x1p-1)
                                    (v128.const f64x2 0x1.fffffffffffffp+1023 0x1.fffffffffffffp+1023))
                                    (v128.const f64x2 0x1.fffffffffffffp+1023 0x1.fffffffffffffp+1023))
(assert_return (invoke "f64x2.pmax" (v128.const f64x2 -0x1p-1 -0x1p-1)
                                    (v128.const f64x2 -0x1.fffffffffffffp+1023 -0x1.fffffffffffffp+1023))
                                    (v128.const f64x2 -0x1.0000000000000p-1 -0x1.0000000000000p-1))
(assert_return (invoke "f64x2.pmax" (v128.const f64x2 -0x1p-1 -0x1p-1)
                                    (v128.const f64x2 0x0.0000000000001p-1022 0x0.0000000000001p-1022))
                                    (v128.const f64x2 0x0.0000000000001p-1022 0x0.0000000000001p-1022))
(assert_return (invoke "f64x2.pmax" (v128.const f64x2 -0x1p-1 -0x1p-1)
                                    (v128.const f64x2 0x0.0000000000001p-1022 0x0.0000000000001p-1022))
                                    (v128.const f64x2 0x0.0000000000001p-1022 0x0.0000000000001p-1022))
(assert_return (invoke "f64x2.pmax" (v128.const f64x2 -0x1p-1 -0x1p-1)
                                    (v128.const f64x2 inf inf))
                                    (v128.const f64x2 inf inf))
(assert_return (invoke "f64x2.pmax" (v128.const f64x2 -0x1p-1 -0x1p-1)
                                    (v128.const f64x2 -inf -inf))
                                    (v128.const f64x2 -0x1.0000000000000p-1 -0x1.0000000000000p-1))
(assert_return (invoke "f64x2.pmax" (v128.const f64x2 -0x1p-1 -0x1p-1)
                                    (v128.const f64x2 0123456789 0123456789))
                                    (v128.const f64x2 0x1.d6f3454000000p+26 0x1.d6f3454000000p+26))
(assert_return (invoke "f64x2.pmax" (v128.const f64x2 -0x1p-1 -0x1p-1)
                                    (v128.const f64x2 0123456789e019 0123456789e019))
                                    (v128.const f64x2 0x1.fe9af5b5e16fap+89 0x1.fe9af5b5e16fap+89))
(assert_return (invoke "f64x2.pmax" (v128.const f64x2 -0x1p-1 -0x1p-1)
                                    (v128.const f64x2 0123456789e+019 0123456789e+019))
                                    (v128.const f64x2 0x1.fe9af5b5e16fap+89 0x1.fe9af5b5e16fap+89))
(assert_return (invoke "f64x2.pmax" (v128.const f64x2 -0x1p-1 -0x1p-1)
                                    (v128.const f64x2 0123456789e-019 0123456789e-019))
                                    (v128.const f64x2 0x1.b25ffd62b4311p-37 0x1.b25ffd62b4311p-37))
(assert_return (invoke "f64x2.pmax" (v128.const f64x2 -0x1p-1 -0x1p-1)
                                    (v128.const f64x2 0123456789. 0123456789.))
                                    (v128.const f64x2 0x1.d6f3454000000p+26 0x1.d6f3454000000p+26))
(assert_return (invoke "f64x2.pmax" (v128.const f64x2 -0x1p-1 -0x1p-1)
                                    (v128.const f64x2 0123456789.e019 0123456789.e019))
                                    (v128.const f64x2 0x1.fe9af5b5e16fap+89 0x1.fe9af5b5e16fap+89))
(assert_return (invoke "f64x2.pmax" (v128.const f64x2 -0x1p-1 -0x1p-1)
                                    (v128.const f64x2 0123456789.e+019 0123456789.e+019))
                                    (v128.const f64x2 0x1.fe9af5b5e16fap+89 0x1.fe9af5b5e16fap+89))
(assert_return (invoke "f64x2.pmax" (v128.const f64x2 -0x1p-1 -0x1p-1)
                                    (v128.const f64x2 0123456789.e-019 0123456789.e-019))
                                    (v128.const f64x2 0x1.b25ffd62b4311p-37 0x1.b25ffd62b4311p-37))
(assert_return (invoke "f64x2.pmax" (v128.const f64x2 -0x1p-1 -0x1p-1)
                                    (v128.const f64x2 0123456789.0123456789 0123456789.0123456789))
                                    (v128.const f64x2 0x1.d6f34540ca458p+26 0x1.d6f34540ca458p+26))
(assert_return (invoke "f64x2.pmax" (v128.const f64x2 -0x1p-1 -0x1p-1)
                                    (v128.const f64x2 0123456789.0123456789e019 0123456789.0123456789e019))
                                    (v128.const f64x2 0x1.fe9af5b6bcbd5p+89 0x1.fe9af5b6bcbd5p+89))
(assert_return (invoke "f64x2.pmax" (v128.const f64x2 -0x1p-1 -0x1p-1)
                                    (v128.const f64x2 0123456789.0123456789e+019 0123456789.0123456789e+019))
                                    (v128.const f64x2 0x1.fe9af5b6bcbd5p+89 0x1.fe9af5b6bcbd5p+89))
(assert_return (invoke "f64x2.pmax" (v128.const f64x2 -0x1p-1 -0x1p-1)
                                    (v128.const f64x2 0123456789.0123456789e-019 0123456789.0123456789e-019))
                                    (v128.const f64x2 0x1.b25ffd636ec12p-37 0x1.b25ffd636ec12p-37))
(assert_return (invoke "f64x2.pmax" (v128.const f64x2 -0x1p-1 -0x1p-1)
                                    (v128.const f64x2 0x0123456789ABCDEFabcdef 0x0123456789ABCDEFabcdef))
                                    (v128.const f64x2 0x1.23456789abcdfp+80 0x1.23456789abcdfp+80))
(assert_return (invoke "f64x2.pmax" (v128.const f64x2 -0x1p-1 -0x1p-1)
                                    (v128.const f64x2 0x0123456789ABCDEFabcdefp019 0x0123456789ABCDEFabcdefp019))
                                    (v128.const f64x2 0x1.23456789abcdfp+99 0x1.23456789abcdfp+99))
(assert_return (invoke "f64x2.pmax" (v128.const f64x2 -0x1p-1 -0x1p-1)
                                    (v128.const f64x2 0x0123456789ABCDEFabcdefp+019 0x0123456789ABCDEFabcdefp+019))
                                    (v128.const f64x2 0x1.23456789abcdfp+99 0x1.23456789abcdfp+99))
(assert_return (invoke "f64x2.pmax" (v128.const f64x2 -0x1p-1 -0x1p-1)
                                    (v128.const f64x2 0x0123456789ABCDEFabcdefp-019 0x0123456789ABCDEFabcdefp-019))
                                    (v128.const f64x2 0x1.23456789abcdfp+61 0x1.23456789abcdfp+61))
(assert_return (invoke "f64x2.pmax" (v128.const f64x2 -0x1p-1 -0x1p-1)
                                    (v128.const f64x2 0x0123456789ABCDEFabcdef. 0x0123456789ABCDEFabcdef.))
                                    (v128.const f64x2 0x1.23456789abcdfp+80 0x1.23456789abcdfp+80))
(assert_return (invoke "f64x2.pmax" (v128.const f64x2 -0x1p-1 -0x1p-1)
                                    (v128.const f64x2 0x0123456789ABCDEFabcdef.p019 0x0123456789ABCDEFabcdef.p019))
                                    (v128.const f64x2 0x1.23456789abcdfp+99 0x1.23456789abcdfp+99))
(assert_return (invoke "f64x2.pmax" (v128.const f64x2 -0x1p-1 -0x1p-1)
                                    (v128.const f64x2 0x0123456789ABCDEFabcdef.p+019 0x0123456789ABCDEFabcdef.p+019))
                                    (v128.const f64x2 0x1.23456789abcdfp+99 0x1.23456789abcdfp+99))
(assert_return (invoke "f64x2.pmax" (v128.const f64x2 -0x1p-1 -0x1p-1)
                                    (v128.const f64x2 0x0123456789ABCDEFabcdef.p-019 0x0123456789ABCDEFabcdef.p-019))
                                    (v128.const f64x2 0x1.23456789abcdfp+61 0x1.23456789abcdfp+61))
(assert_return (invoke "f64x2.pmax" (v128.const f64x2 -0x1p-1 -0x1p-1)
                                    (v128.const f64x2 0x0123456789ABCDEFabcdef.0123456789ABCDEFabcdef 0x0123456789ABCDEFabcdef.0123456789ABCDEFabcdef))
                                    (v128.const f64x2 0x1.23456789abcdfp+80 0x1.23456789abcdfp+80))
(assert_return (invoke "f64x2.pmax" (v128.const f64x2 -0x1p-1 -0x1p-1)
                                    (v128.const f64x2 0x0123456789ABCDEFabcdef.0123456789ABCDEFabcdefp019 0x0123456789ABCDEFabcdef.0123456789ABCDEFabcdefp019))
                                    (v128.const f64x2 0x1.23456789abcdfp+99 0x1.23456789abcdfp+99))
(assert_return (invoke "f64x2.pmax" (v128.const f64x2 -0x1p-1 -0x1p-1)
                                    (v128.const f64x2 0x0123456789ABCDEFabcdef.0123456789ABCDEFabcdefp+019 0x0123456789ABCDEFabcdef.0123456789ABCDEFabcdefp+019))
                                    (v128.const f64x2 0x1.23456789abcdfp+99 0x1.23456789abcdfp+99))
(assert_return (invoke "f64x2.pmax" (v128.const f64x2 -0x1p-1 -0x1p-1)
                                    (v128.const f64x2 0x0123456789ABCDEFabcdef.0123456789ABCDEFabcdefp-019 0x0123456789ABCDEFabcdef.0123456789ABCDEFabcdefp-019))
                                    (v128.const f64x2 0x1.23456789abcdfp+61 0x1.23456789abcdfp+61))
(assert_return (invoke "f64x2.pmax" (v128.const f64x2 0x1p+0 0x1p+0)
                                    (v128.const f64x2 0x0p+0 0x0p+0))
                                    (v128.const f64x2 0x1.0000000000000p+0 0x1.0000000000000p+0))
(assert_return (invoke "f64x2.pmax" (v128.const f64x2 0x1p+0 0x1p+0)
                                    (v128.const f64x2 -0x0p+0 -0x0p+0))
                                    (v128.const f64x2 0x1.0000000000000p+0 0x1.0000000000000p+0))
(assert_return (invoke "f64x2.pmax" (v128.const f64x2 0x1p+0 0x1p+0)
                                    (v128.const f64x2 0x1p-1022 0x1p-1022))
                                    (v128.const f64x2 0x1.0000000000000p+0 0x1.0000000000000p+0))
(assert_return (invoke "f64x2.pmax" (v128.const f64x2 0x1p+0 0x1p+0)
                                    (v128.const f64x2 -0x1p-1022 -0x1p-1022))
                                    (v128.const f64x2 0x1.0000000000000p+0 0x1.0000000000000p+0))
(assert_return (invoke "f64x2.pmax" (v128.const f64x2 0x1p+0 0x1p+0)
                                    (v128.const f64x2 0x1p-1 0x1p-1))
                                    (v128.const f64x2 0x1.0000000000000p+0 0x1.0000000000000p+0))
(assert_return (invoke "f64x2.pmax" (v128.const f64x2 0x1p+0 0x1p+0)
                                    (v128.const f64x2 -0x1p-1 -0x1p-1))
                                    (v128.const f64x2 0x1.0000000000000p+0 0x1.0000000000000p+0))
(assert_return (invoke "f64x2.pmax" (v128.const f64x2 0x1p+0 0x1p+0)
                                    (v128.const f64x2 0x1p+0 0x1p+0))
                                    (v128.const f64x2 0x1.0000000000000p+0 0x1.0000000000000p+0))
(assert_return (invoke "f64x2.pmax" (v128.const f64x2 0x1p+0 0x1p+0)
                                    (v128.const f64x2 -0x1p+0 -0x1p+0))
                                    (v128.const f64x2 0x1.0000000000000p+0 0x1.0000000000000p+0))
(assert_return (invoke "f64x2.pmax" (v128.const f64x2 0x1p+0 0x1p+0)
                                    (v128.const f64x2 0x1.921fb54442d18p+2 0x1.921fb54442d18p+2))
                                    (v128.const f64x2 0x1.921fb54442d18p+2 0x1.921fb54442d18p+2))
(assert_return (invoke "f64x2.pmax" (v128.const f64x2 0x1p+0 0x1p+0)
                                    (v128.const f64x2 -0x1.921fb54442d18p+2 -0x1.921fb54442d18p+2))
                                    (v128.const f64x2 0x1.0000000000000p+0 0x1.0000000000000p+0))
(assert_return (invoke "f64x2.pmax" (v128.const f64x2 0x1p+0 0x1p+0)
                                    (v128.const f64x2 0x1.fffffffffffffp+1023 0x1.fffffffffffffp+1023))
                                    (v128.const f64x2 0x1.fffffffffffffp+1023 0x1.fffffffffffffp+1023))
(assert_return (invoke "f64x2.pmax" (v128.const f64x2 0x1p+0 0x1p+0)
                                    (v128.const f64x2 -0x1.fffffffffffffp+1023 -0x1.fffffffffffffp+1023))
                                    (v128.const f64x2 0x1.0000000000000p+0 0x1.0000000000000p+0))
(assert_return (invoke "f64x2.pmax" (v128.const f64x2 0x1p+0 0x1p+0)
                                    (v128.const f64x2 0x0.0000000000001p-1022 0x0.0000000000001p-1022))
                                    (v128.const f64x2 0x1.0000000000000p+0 0x1.0000000000000p+0))
(assert_return (invoke "f64x2.pmax" (v128.const f64x2 0x1p+0 0x1p+0)
                                    (v128.const f64x2 0x0.0000000000001p-1022 0x0.0000000000001p-1022))
                                    (v128.const f64x2 0x1.0000000000000p+0 0x1.0000000000000p+0))
(assert_return (invoke "f64x2.pmax" (v128.const f64x2 0x1p+0 0x1p+0)
                                    (v128.const f64x2 inf inf))
                                    (v128.const f64x2 inf inf))
(assert_return (invoke "f64x2.pmax" (v128.const f64x2 0x1p+0 0x1p+0)
                                    (v128.const f64x2 -inf -inf))
                                    (v128.const f64x2 0x1.0000000000000p+0 0x1.0000000000000p+0))
(assert_return (invoke "f64x2.pmax" (v128.const f64x2 0x1p+0 0x1p+0)
                                    (v128.const f64x2 0123456789 0123456789))
                                    (v128.const f64x2 0x1.d6f3454000000p+26 0x1.d6f3454000000p+26))
(assert_return (invoke "f64x2.pmax" (v128.const f64x2 0x1p+0 0x1p+0)
                                    (v128.const f64x2 0123456789e019 0123456789e019))
                                    (v128.const f64x2 0x1.fe9af5b5e16fap+89 0x1.fe9af5b5e16fap+89))
(assert_return (invoke "f64x2.pmax" (v128.const f64x2 0x1p+0 0x1p+0)
                                    (v128.const f64x2 0123456789e+019 0123456789e+019))
                                    (v128.const f64x2 0x1.fe9af5b5e16fap+89 0x1.fe9af5b5e16fap+89))
(assert_return (invoke "f64x2.pmax" (v128.const f64x2 0x1p+0 0x1p+0)
                                    (v128.const f64x2 0123456789e-019 0123456789e-019))
                                    (v128.const f64x2 0x1.0000000000000p+0 0x1.0000000000000p+0))
(assert_return (invoke "f64x2.pmax" (v128.const f64x2 0x1p+0 0x1p+0)
                                    (v128.const f64x2 0123456789. 0123456789.))
                                    (v128.const f64x2 0x1.d6f3454000000p+26 0x1.d6f3454000000p+26))
(assert_return (invoke "f64x2.pmax" (v128.const f64x2 0x1p+0 0x1p+0)
                                    (v128.const f64x2 0123456789.e019 0123456789.e019))
                                    (v128.const f64x2 0x1.fe9af5b5e16fap+89 0x1.fe9af5b5e16fap+89))
(assert_return (invoke "f64x2.pmax" (v128.const f64x2 0x1p+0 0x1p+0)
                                    (v128.const f64x2 0123456789.e+019 0123456789.e+019))
                                    (v128.const f64x2 0x1.fe9af5b5e16fap+89 0x1.fe9af5b5e16fap+89))
(assert_return (invoke "f64x2.pmax" (v128.const f64x2 0x1p+0 0x1p+0)
                                    (v128.const f64x2 0123456789.e-019 0123456789.e-019))
                                    (v128.const f64x2 0x1.0000000000000p+0 0x1.0000000000000p+0))
(assert_return (invoke "f64x2.pmax" (v128.const f64x2 0x1p+0 0x1p+0)
                                    (v128.const f64x2 0123456789.0123456789 0123456789.0123456789))
                                    (v128.const f64x2 0x1.d6f34540ca458p+26 0x1.d6f34540ca458p+26))
(assert_return (invoke "f64x2.pmax" (v128.const f64x2 0x1p+0 0x1p+0)
                                    (v128.const f64x2 0123456789.0123456789e019 0123456789.0123456789e019))
                                    (v128.const f64x2 0x1.fe9af5b6bcbd5p+89 0x1.fe9af5b6bcbd5p+89))
(assert_return (invoke "f64x2.pmax" (v128.const f64x2 0x1p+0 0x1p+0)
                                    (v128.const f64x2 0123456789.0123456789e+019 0123456789.0123456789e+019))
                                    (v128.const f64x2 0x1.fe9af5b6bcbd5p+89 0x1.fe9af5b6bcbd5p+89))
(assert_return (invoke "f64x2.pmax" (v128.const f64x2 0x1p+0 0x1p+0)
                                    (v128.const f64x2 0123456789.0123456789e-019 0123456789.0123456789e-019))
                                    (v128.const f64x2 0x1.0000000000000p+0 0x1.0000000000000p+0))
(assert_return (invoke "f64x2.pmax" (v128.const f64x2 0x1p+0 0x1p+0)
                                    (v128.const f64x2 0x0123456789ABCDEFabcdef 0x0123456789ABCDEFabcdef))
                                    (v128.const f64x2 0x1.23456789abcdfp+80 0x1.23456789abcdfp+80))
(assert_return (invoke "f64x2.pmax" (v128.const f64x2 0x1p+0 0x1p+0)
                                    (v128.const f64x2 0x0123456789ABCDEFabcdefp019 0x0123456789ABCDEFabcdefp019))
                                    (v128.const f64x2 0x1.23456789abcdfp+99 0x1.23456789abcdfp+99))
(assert_return (invoke "f64x2.pmax" (v128.const f64x2 0x1p+0 0x1p+0)
                                    (v128.const f64x2 0x0123456789ABCDEFabcdefp+019 0x0123456789ABCDEFabcdefp+019))
                                    (v128.const f64x2 0x1.23456789abcdfp+99 0x1.23456789abcdfp+99))
(assert_return (invoke "f64x2.pmax" (v128.const f64x2 0x1p+0 0x1p+0)
                                    (v128.const f64x2 0x0123456789ABCDEFabcdefp-019 0x0123456789ABCDEFabcdefp-019))
                                    (v128.const f64x2 0x1.23456789abcdfp+61 0x1.23456789abcdfp+61))
(assert_return (invoke "f64x2.pmax" (v128.const f64x2 0x1p+0 0x1p+0)
                                    (v128.const f64x2 0x0123456789ABCDEFabcdef. 0x0123456789ABCDEFabcdef.))
                                    (v128.const f64x2 0x1.23456789abcdfp+80 0x1.23456789abcdfp+80))
(assert_return (invoke "f64x2.pmax" (v128.const f64x2 0x1p+0 0x1p+0)
                                    (v128.const f64x2 0x0123456789ABCDEFabcdef.p019 0x0123456789ABCDEFabcdef.p019))
                                    (v128.const f64x2 0x1.23456789abcdfp+99 0x1.23456789abcdfp+99))
(assert_return (invoke "f64x2.pmax" (v128.const f64x2 0x1p+0 0x1p+0)
                                    (v128.const f64x2 0x0123456789ABCDEFabcdef.p+019 0x0123456789ABCDEFabcdef.p+019))
                                    (v128.const f64x2 0x1.23456789abcdfp+99 0x1.23456789abcdfp+99))
(assert_return (invoke "f64x2.pmax" (v128.const f64x2 0x1p+0 0x1p+0)
                                    (v128.const f64x2 0x0123456789ABCDEFabcdef.p-019 0x0123456789ABCDEFabcdef.p-019))
                                    (v128.const f64x2 0x1.23456789abcdfp+61 0x1.23456789abcdfp+61))
(assert_return (invoke "f64x2.pmax" (v128.const f64x2 0x1p+0 0x1p+0)
                                    (v128.const f64x2 0x0123456789ABCDEFabcdef.0123456789ABCDEFabcdef 0x0123456789ABCDEFabcdef.0123456789ABCDEFabcdef))
                                    (v128.const f64x2 0x1.23456789abcdfp+80 0x1.23456789abcdfp+80))
(assert_return (invoke "f64x2.pmax" (v128.const f64x2 0x1p+0 0x1p+0)
                                    (v128.const f64x2 0x0123456789ABCDEFabcdef.0123456789ABCDEFabcdefp019 0x0123456789ABCDEFabcdef.0123456789ABCDEFabcdefp019))
                                    (v128.const f64x2 0x1.23456789abcdfp+99 0x1.23456789abcdfp+99))
(assert_return (invoke "f64x2.pmax" (v128.const f64x2 0x1p+0 0x1p+0)
                                    (v128.const f64x2 0x0123456789ABCDEFabcdef.0123456789ABCDEFabcdefp+019 0x0123456789ABCDEFabcdef.0123456789ABCDEFabcdefp+019))
                                    (v128.const f64x2 0x1.23456789abcdfp+99 0x1.23456789abcdfp+99))
(assert_return (invoke "f64x2.pmax" (v128.const f64x2 0x1p+0 0x1p+0)
                                    (v128.const f64x2 0x0123456789ABCDEFabcdef.0123456789ABCDEFabcdefp-019 0x0123456789ABCDEFabcdef.0123456789ABCDEFabcdefp-019))
                                    (v128.const f64x2 0x1.23456789abcdfp+61 0x1.23456789abcdfp+61))
(assert_return (invoke "f64x2.pmax" (v128.const f64x2 -0x1p+0 -0x1p+0)
                                    (v128.const f64x2 0x0p+0 0x0p+0))
                                    (v128.const f64x2 0x0.0p+0 0x0.0p+0))
(assert_return (invoke "f64x2.pmax" (v128.const f64x2 -0x1p+0 -0x1p+0)
                                    (v128.const f64x2 -0x0p+0 -0x0p+0))
                                    (v128.const f64x2 -0x0.0p+0 -0x0.0p+0))
(assert_return (invoke "f64x2.pmax" (v128.const f64x2 -0x1p+0 -0x1p+0)
                                    (v128.const f64x2 0x1p-1022 0x1p-1022))
                                    (v128.const f64x2 0x1.0000000000000p-1022 0x1.0000000000000p-1022))
(assert_return (invoke "f64x2.pmax" (v128.const f64x2 -0x1p+0 -0x1p+0)
                                    (v128.const f64x2 -0x1p-1022 -0x1p-1022))
                                    (v128.const f64x2 -0x1.0000000000000p-1022 -0x1.0000000000000p-1022))
(assert_return (invoke "f64x2.pmax" (v128.const f64x2 -0x1p+0 -0x1p+0)
                                    (v128.const f64x2 0x1p-1 0x1p-1))
                                    (v128.const f64x2 0x1.0000000000000p-1 0x1.0000000000000p-1))
(assert_return (invoke "f64x2.pmax" (v128.const f64x2 -0x1p+0 -0x1p+0)
                                    (v128.const f64x2 -0x1p-1 -0x1p-1))
                                    (v128.const f64x2 -0x1.0000000000000p-1 -0x1.0000000000000p-1))
(assert_return (invoke "f64x2.pmax" (v128.const f64x2 -0x1p+0 -0x1p+0)
                                    (v128.const f64x2 0x1p+0 0x1p+0))
                                    (v128.const f64x2 0x1.0000000000000p+0 0x1.0000000000000p+0))
(assert_return (invoke "f64x2.pmax" (v128.const f64x2 -0x1p+0 -0x1p+0)
                                    (v128.const f64x2 -0x1p+0 -0x1p+0))
                                    (v128.const f64x2 -0x1.0000000000000p+0 -0x1.0000000000000p+0))
(assert_return (invoke "f64x2.pmax" (v128.const f64x2 -0x1p+0 -0x1p+0)
                                    (v128.const f64x2 0x1.921fb54442d18p+2 0x1.921fb54442d18p+2))
                                    (v128.const f64x2 0x1.921fb54442d18p+2 0x1.921fb54442d18p+2))
(assert_return (invoke "f64x2.pmax" (v128.const f64x2 -0x1p+0 -0x1p+0)
                                    (v128.const f64x2 -0x1.921fb54442d18p+2 -0x1.921fb54442d18p+2))
                                    (v128.const f64x2 -0x1.0000000000000p+0 -0x1.0000000000000p+0))
(assert_return (invoke "f64x2.pmax" (v128.const f64x2 -0x1p+0 -0x1p+0)
                                    (v128.const f64x2 0x1.fffffffffffffp+1023 0x1.fffffffffffffp+1023))
                                    (v128.const f64x2 0x1.fffffffffffffp+1023 0x1.fffffffffffffp+1023))
(assert_return (invoke "f64x2.pmax" (v128.const f64x2 -0x1p+0 -0x1p+0)
                                    (v128.const f64x2 -0x1.fffffffffffffp+1023 -0x1.fffffffffffffp+1023))
                                    (v128.const f64x2 -0x1.0000000000000p+0 -0x1.0000000000000p+0))
(assert_return (invoke "f64x2.pmax" (v128.const f64x2 -0x1p+0 -0x1p+0)
                                    (v128.const f64x2 0x0.0000000000001p-1022 0x0.0000000000001p-1022))
                                    (v128.const f64x2 0x0.0000000000001p-1022 0x0.0000000000001p-1022))
(assert_return (invoke "f64x2.pmax" (v128.const f64x2 -0x1p+0 -0x1p+0)
                                    (v128.const f64x2 0x0.0000000000001p-1022 0x0.0000000000001p-1022))
                                    (v128.const f64x2 0x0.0000000000001p-1022 0x0.0000000000001p-1022))
(assert_return (invoke "f64x2.pmax" (v128.const f64x2 -0x1p+0 -0x1p+0)
                                    (v128.const f64x2 inf inf))
                                    (v128.const f64x2 inf inf))
(assert_return (invoke "f64x2.pmax" (v128.const f64x2 -0x1p+0 -0x1p+0)
                                    (v128.const f64x2 -inf -inf))
                                    (v128.const f64x2 -0x1.0000000000000p+0 -0x1.0000000000000p+0))
(assert_return (invoke "f64x2.pmax" (v128.const f64x2 -0x1p+0 -0x1p+0)
                                    (v128.const f64x2 0123456789 0123456789))
                                    (v128.const f64x2 0x1.d6f3454000000p+26 0x1.d6f3454000000p+26))
(assert_return (invoke "f64x2.pmax" (v128.const f64x2 -0x1p+0 -0x1p+0)
                                    (v128.const f64x2 0123456789e019 0123456789e019))
                                    (v128.const f64x2 0x1.fe9af5b5e16fap+89 0x1.fe9af5b5e16fap+89))
(assert_return (invoke "f64x2.pmax" (v128.const f64x2 -0x1p+0 -0x1p+0)
                                    (v128.const f64x2 0123456789e+019 0123456789e+019))
                                    (v128.const f64x2 0x1.fe9af5b5e16fap+89 0x1.fe9af5b5e16fap+89))
(assert_return (invoke "f64x2.pmax" (v128.const f64x2 -0x1p+0 -0x1p+0)
                                    (v128.const f64x2 0123456789e-019 0123456789e-019))
                                    (v128.const f64x2 0x1.b25ffd62b4311p-37 0x1.b25ffd62b4311p-37))
(assert_return (invoke "f64x2.pmax" (v128.const f64x2 -0x1p+0 -0x1p+0)
                                    (v128.const f64x2 0123456789. 0123456789.))
                                    (v128.const f64x2 0x1.d6f3454000000p+26 0x1.d6f3454000000p+26))
(assert_return (invoke "f64x2.pmax" (v128.const f64x2 -0x1p+0 -0x1p+0)
                                    (v128.const f64x2 0123456789.e019 0123456789.e019))
                                    (v128.const f64x2 0x1.fe9af5b5e16fap+89 0x1.fe9af5b5e16fap+89))
(assert_return (invoke "f64x2.pmax" (v128.const f64x2 -0x1p+0 -0x1p+0)
                                    (v128.const f64x2 0123456789.e+019 0123456789.e+019))
                                    (v128.const f64x2 0x1.fe9af5b5e16fap+89 0x1.fe9af5b5e16fap+89))
(assert_return (invoke "f64x2.pmax" (v128.const f64x2 -0x1p+0 -0x1p+0)
                                    (v128.const f64x2 0123456789.e-019 0123456789.e-019))
                                    (v128.const f64x2 0x1.b25ffd62b4311p-37 0x1.b25ffd62b4311p-37))
(assert_return (invoke "f64x2.pmax" (v128.const f64x2 -0x1p+0 -0x1p+0)
                                    (v128.const f64x2 0123456789.0123456789 0123456789.0123456789))
                                    (v128.const f64x2 0x1.d6f34540ca458p+26 0x1.d6f34540ca458p+26))
(assert_return (invoke "f64x2.pmax" (v128.const f64x2 -0x1p+0 -0x1p+0)
                                    (v128.const f64x2 0123456789.0123456789e019 0123456789.0123456789e019))
                                    (v128.const f64x2 0x1.fe9af5b6bcbd5p+89 0x1.fe9af5b6bcbd5p+89))
(assert_return (invoke "f64x2.pmax" (v128.const f64x2 -0x1p+0 -0x1p+0)
                                    (v128.const f64x2 0123456789.0123456789e+019 0123456789.0123456789e+019))
                                    (v128.const f64x2 0x1.fe9af5b6bcbd5p+89 0x1.fe9af5b6bcbd5p+89))
(assert_return (invoke "f64x2.pmax" (v128.const f64x2 -0x1p+0 -0x1p+0)
                                    (v128.const f64x2 0123456789.0123456789e-019 0123456789.0123456789e-019))
                                    (v128.const f64x2 0x1.b25ffd636ec12p-37 0x1.b25ffd636ec12p-37))
(assert_return (invoke "f64x2.pmax" (v128.const f64x2 -0x1p+0 -0x1p+0)
                                    (v128.const f64x2 0x0123456789ABCDEFabcdef 0x0123456789ABCDEFabcdef))
                                    (v128.const f64x2 0x1.23456789abcdfp+80 0x1.23456789abcdfp+80))
(assert_return (invoke "f64x2.pmax" (v128.const f64x2 -0x1p+0 -0x1p+0)
                                    (v128.const f64x2 0x0123456789ABCDEFabcdefp019 0x0123456789ABCDEFabcdefp019))
                                    (v128.const f64x2 0x1.23456789abcdfp+99 0x1.23456789abcdfp+99))
(assert_return (invoke "f64x2.pmax" (v128.const f64x2 -0x1p+0 -0x1p+0)
                                    (v128.const f64x2 0x0123456789ABCDEFabcdefp+019 0x0123456789ABCDEFabcdefp+019))
                                    (v128.const f64x2 0x1.23456789abcdfp+99 0x1.23456789abcdfp+99))
(assert_return (invoke "f64x2.pmax" (v128.const f64x2 -0x1p+0 -0x1p+0)
                                    (v128.const f64x2 0x0123456789ABCDEFabcdefp-019 0x0123456789ABCDEFabcdefp-019))
                                    (v128.const f64x2 0x1.23456789abcdfp+61 0x1.23456789abcdfp+61))
(assert_return (invoke "f64x2.pmax" (v128.const f64x2 -0x1p+0 -0x1p+0)
                                    (v128.const f64x2 0x0123456789ABCDEFabcdef. 0x0123456789ABCDEFabcdef.))
                                    (v128.const f64x2 0x1.23456789abcdfp+80 0x1.23456789abcdfp+80))
(assert_return (invoke "f64x2.pmax" (v128.const f64x2 -0x1p+0 -0x1p+0)
                                    (v128.const f64x2 0x0123456789ABCDEFabcdef.p019 0x0123456789ABCDEFabcdef.p019))
                                    (v128.const f64x2 0x1.23456789abcdfp+99 0x1.23456789abcdfp+99))
(assert_return (invoke "f64x2.pmax" (v128.const f64x2 -0x1p+0 -0x1p+0)
                                    (v128.const f64x2 0x0123456789ABCDEFabcdef.p+019 0x0123456789ABCDEFabcdef.p+019))
                                    (v128.const f64x2 0x1.23456789abcdfp+99 0x1.23456789abcdfp+99))
(assert_return (invoke "f64x2.pmax" (v128.const f64x2 -0x1p+0 -0x1p+0)
                                    (v128.const f64x2 0x0123456789ABCDEFabcdef.p-019 0x0123456789ABCDEFabcdef.p-019))
                                    (v128.const f64x2 0x1.23456789abcdfp+61 0x1.23456789abcdfp+61))
(assert_return (invoke "f64x2.pmax" (v128.const f64x2 -0x1p+0 -0x1p+0)
                                    (v128.const f64x2 0x0123456789ABCDEFabcdef.0123456789ABCDEFabcdef 0x0123456789ABCDEFabcdef.0123456789ABCDEFabcdef))
                                    (v128.const f64x2 0x1.23456789abcdfp+80 0x1.23456789abcdfp+80))
(assert_return (invoke "f64x2.pmax" (v128.const f64x2 -0x1p+0 -0x1p+0)
                                    (v128.const f64x2 0x0123456789ABCDEFabcdef.0123456789ABCDEFabcdefp019 0x0123456789ABCDEFabcdef.0123456789ABCDEFabcdefp019))
                                    (v128.const f64x2 0x1.23456789abcdfp+99 0x1.23456789abcdfp+99))
(assert_return (invoke "f64x2.pmax" (v128.const f64x2 -0x1p+0 -0x1p+0)
                                    (v128.const f64x2 0x0123456789ABCDEFabcdef.0123456789ABCDEFabcdefp+019 0x0123456789ABCDEFabcdef.0123456789ABCDEFabcdefp+019))
                                    (v128.const f64x2 0x1.23456789abcdfp+99 0x1.23456789abcdfp+99))
(assert_return (invoke "f64x2.pmax" (v128.const f64x2 -0x1p+0 -0x1p+0)
                                    (v128.const f64x2 0x0123456789ABCDEFabcdef.0123456789ABCDEFabcdefp-019 0x0123456789ABCDEFabcdef.0123456789ABCDEFabcdefp-019))
                                    (v128.const f64x2 0x1.23456789abcdfp+61 0x1.23456789abcdfp+61))
(assert_return (invoke "f64x2.pmax" (v128.const f64x2 0x1.921fb54442d18p+2 0x1.921fb54442d18p+2)
                                    (v128.const f64x2 0x0p+0 0x0p+0))
                                    (v128.const f64x2 0x1.921fb54442d18p+2 0x1.921fb54442d18p+2))
(assert_return (invoke "f64x2.pmax" (v128.const f64x2 0x1.921fb54442d18p+2 0x1.921fb54442d18p+2)
                                    (v128.const f64x2 -0x0p+0 -0x0p+0))
                                    (v128.const f64x2 0x1.921fb54442d18p+2 0x1.921fb54442d18p+2))
(assert_return (invoke "f64x2.pmax" (v128.const f64x2 0x1.921fb54442d18p+2 0x1.921fb54442d18p+2)
                                    (v128.const f64x2 0x1p-1022 0x1p-1022))
                                    (v128.const f64x2 0x1.921fb54442d18p+2 0x1.921fb54442d18p+2))
(assert_return (invoke "f64x2.pmax" (v128.const f64x2 0x1.921fb54442d18p+2 0x1.921fb54442d18p+2)
                                    (v128.const f64x2 -0x1p-1022 -0x1p-1022))
                                    (v128.const f64x2 0x1.921fb54442d18p+2 0x1.921fb54442d18p+2))
(assert_return (invoke "f64x2.pmax" (v128.const f64x2 0x1.921fb54442d18p+2 0x1.921fb54442d18p+2)
                                    (v128.const f64x2 0x1p-1 0x1p-1))
                                    (v128.const f64x2 0x1.921fb54442d18p+2 0x1.921fb54442d18p+2))
(assert_return (invoke "f64x2.pmax" (v128.const f64x2 0x1.921fb54442d18p+2 0x1.921fb54442d18p+2)
                                    (v128.const f64x2 -0x1p-1 -0x1p-1))
                                    (v128.const f64x2 0x1.921fb54442d18p+2 0x1.921fb54442d18p+2))
(assert_return (invoke "f64x2.pmax" (v128.const f64x2 0x1.921fb54442d18p+2 0x1.921fb54442d18p+2)
                                    (v128.const f64x2 0x1p+0 0x1p+0))
                                    (v128.const f64x2 0x1.921fb54442d18p+2 0x1.921fb54442d18p+2))
(assert_return (invoke "f64x2.pmax" (v128.const f64x2 0x1.921fb54442d18p+2 0x1.921fb54442d18p+2)
                                    (v128.const f64x2 -0x1p+0 -0x1p+0))
                                    (v128.const f64x2 0x1.921fb54442d18p+2 0x1.921fb54442d18p+2))
(assert_return (invoke "f64x2.pmax" (v128.const f64x2 0x1.921fb54442d18p+2 0x1.921fb54442d18p+2)
                                    (v128.const f64x2 0x1.921fb54442d18p+2 0x1.921fb54442d18p+2))
                                    (v128.const f64x2 0x1.921fb54442d18p+2 0x1.921fb54442d18p+2))
(assert_return (invoke "f64x2.pmax" (v128.const f64x2 0x1.921fb54442d18p+2 0x1.921fb54442d18p+2)
                                    (v128.const f64x2 -0x1.921fb54442d18p+2 -0x1.921fb54442d18p+2))
                                    (v128.const f64x2 0x1.921fb54442d18p+2 0x1.921fb54442d18p+2))
(assert_return (invoke "f64x2.pmax" (v128.const f64x2 0x1.921fb54442d18p+2 0x1.921fb54442d18p+2)
                                    (v128.const f64x2 0x1.fffffffffffffp+1023 0x1.fffffffffffffp+1023))
                                    (v128.const f64x2 0x1.fffffffffffffp+1023 0x1.fffffffffffffp+1023))
(assert_return (invoke "f64x2.pmax" (v128.const f64x2 0x1.921fb54442d18p+2 0x1.921fb54442d18p+2)
                                    (v128.const f64x2 -0x1.fffffffffffffp+1023 -0x1.fffffffffffffp+1023))
                                    (v128.const f64x2 0x1.921fb54442d18p+2 0x1.921fb54442d18p+2))
(assert_return (invoke "f64x2.pmax" (v128.const f64x2 0x1.921fb54442d18p+2 0x1.921fb54442d18p+2)
                                    (v128.const f64x2 0x0.0000000000001p-1022 0x0.0000000000001p-1022))
                                    (v128.const f64x2 0x1.921fb54442d18p+2 0x1.921fb54442d18p+2))
(assert_return (invoke "f64x2.pmax" (v128.const f64x2 0x1.921fb54442d18p+2 0x1.921fb54442d18p+2)
                                    (v128.const f64x2 0x0.0000000000001p-1022 0x0.0000000000001p-1022))
                                    (v128.const f64x2 0x1.921fb54442d18p+2 0x1.921fb54442d18p+2))
(assert_return (invoke "f64x2.pmax" (v128.const f64x2 0x1.921fb54442d18p+2 0x1.921fb54442d18p+2)
                                    (v128.const f64x2 inf inf))
                                    (v128.const f64x2 inf inf))
(assert_return (invoke "f64x2.pmax" (v128.const f64x2 0x1.921fb54442d18p+2 0x1.921fb54442d18p+2)
                                    (v128.const f64x2 -inf -inf))
                                    (v128.const f64x2 0x1.921fb54442d18p+2 0x1.921fb54442d18p+2))
(assert_return (invoke "f64x2.pmax" (v128.const f64x2 0x1.921fb54442d18p+2 0x1.921fb54442d18p+2)
                                    (v128.const f64x2 0123456789 0123456789))
                                    (v128.const f64x2 0x1.d6f3454000000p+26 0x1.d6f3454000000p+26))
(assert_return (invoke "f64x2.pmax" (v128.const f64x2 0x1.921fb54442d18p+2 0x1.921fb54442d18p+2)
                                    (v128.const f64x2 0123456789e019 0123456789e019))
                                    (v128.const f64x2 0x1.fe9af5b5e16fap+89 0x1.fe9af5b5e16fap+89))
(assert_return (invoke "f64x2.pmax" (v128.const f64x2 0x1.921fb54442d18p+2 0x1.921fb54442d18p+2)
                                    (v128.const f64x2 0123456789e+019 0123456789e+019))
                                    (v128.const f64x2 0x1.fe9af5b5e16fap+89 0x1.fe9af5b5e16fap+89))
(assert_return (invoke "f64x2.pmax" (v128.const f64x2 0x1.921fb54442d18p+2 0x1.921fb54442d18p+2)
                                    (v128.const f64x2 0123456789e-019 0123456789e-019))
                                    (v128.const f64x2 0x1.921fb54442d18p+2 0x1.921fb54442d18p+2))
(assert_return (invoke "f64x2.pmax" (v128.const f64x2 0x1.921fb54442d18p+2 0x1.921fb54442d18p+2)
                                    (v128.const f64x2 0123456789. 0123456789.))
                                    (v128.const f64x2 0x1.d6f3454000000p+26 0x1.d6f3454000000p+26))
(assert_return (invoke "f64x2.pmax" (v128.const f64x2 0x1.921fb54442d18p+2 0x1.921fb54442d18p+2)
                                    (v128.const f64x2 0123456789.e019 0123456789.e019))
                                    (v128.const f64x2 0x1.fe9af5b5e16fap+89 0x1.fe9af5b5e16fap+89))
(assert_return (invoke "f64x2.pmax" (v128.const f64x2 0x1.921fb54442d18p+2 0x1.921fb54442d18p+2)
                                    (v128.const f64x2 0123456789.e+019 0123456789.e+019))
                                    (v128.const f64x2 0x1.fe9af5b5e16fap+89 0x1.fe9af5b5e16fap+89))
(assert_return (invoke "f64x2.pmax" (v128.const f64x2 0x1.921fb54442d18p+2 0x1.921fb54442d18p+2)
                                    (v128.const f64x2 0123456789.e-019 0123456789.e-019))
                                    (v128.const f64x2 0x1.921fb54442d18p+2 0x1.921fb54442d18p+2))
(assert_return (invoke "f64x2.pmax" (v128.const f64x2 0x1.921fb54442d18p+2 0x1.921fb54442d18p+2)
                                    (v128.const f64x2 0123456789.0123456789 0123456789.0123456789))
                                    (v128.const f64x2 0x1.d6f34540ca458p+26 0x1.d6f34540ca458p+26))
(assert_return (invoke "f64x2.pmax" (v128.const f64x2 0x1.921fb54442d18p+2 0x1.921fb54442d18p+2)
                                    (v128.const f64x2 0123456789.0123456789e019 0123456789.0123456789e019))
                                    (v128.const f64x2 0x1.fe9af5b6bcbd5p+89 0x1.fe9af5b6bcbd5p+89))
(assert_return (invoke "f64x2.pmax" (v128.const f64x2 0x1.921fb54442d18p+2 0x1.921fb54442d18p+2)
                                    (v128.const f64x2 0123456789.0123456789e+019 0123456789.0123456789e+019))
                                    (v128.const f64x2 0x1.fe9af5b6bcbd5p+89 0x1.fe9af5b6bcbd5p+89))
(assert_return (invoke "f64x2.pmax" (v128.const f64x2 0x1.921fb54442d18p+2 0x1.921fb54442d18p+2)
                                    (v128.const f64x2 0123456789.0123456789e-019 0123456789.0123456789e-019))
                                    (v128.const f64x2 0x1.921fb54442d18p+2 0x1.921fb54442d18p+2))
(assert_return (invoke "f64x2.pmax" (v128.const f64x2 0x1.921fb54442d18p+2 0x1.921fb54442d18p+2)
                                    (v128.const f64x2 0x0123456789ABCDEFabcdef 0x0123456789ABCDEFabcdef))
                                    (v128.const f64x2 0x1.23456789abcdfp+80 0x1.23456789abcdfp+80))
(assert_return (invoke "f64x2.pmax" (v128.const f64x2 0x1.921fb54442d18p+2 0x1.921fb54442d18p+2)
                                    (v128.const f64x2 0x0123456789ABCDEFabcdefp019 0x0123456789ABCDEFabcdefp019))
                                    (v128.const f64x2 0x1.23456789abcdfp+99 0x1.23456789abcdfp+99))
(assert_return (invoke "f64x2.pmax" (v128.const f64x2 0x1.921fb54442d18p+2 0x1.921fb54442d18p+2)
                                    (v128.const f64x2 0x0123456789ABCDEFabcdefp+019 0x0123456789ABCDEFabcdefp+019))
                                    (v128.const f64x2 0x1.23456789abcdfp+99 0x1.23456789abcdfp+99))
(assert_return (invoke "f64x2.pmax" (v128.const f64x2 0x1.921fb54442d18p+2 0x1.921fb54442d18p+2)
                                    (v128.const f64x2 0x0123456789ABCDEFabcdefp-019 0x0123456789ABCDEFabcdefp-019))
                                    (v128.const f64x2 0x1.23456789abcdfp+61 0x1.23456789abcdfp+61))
(assert_return (invoke "f64x2.pmax" (v128.const f64x2 0x1.921fb54442d18p+2 0x1.921fb54442d18p+2)
                                    (v128.const f64x2 0x0123456789ABCDEFabcdef. 0x0123456789ABCDEFabcdef.))
                                    (v128.const f64x2 0x1.23456789abcdfp+80 0x1.23456789abcdfp+80))
(assert_return (invoke "f64x2.pmax" (v128.const f64x2 0x1.921fb54442d18p+2 0x1.921fb54442d18p+2)
                                    (v128.const f64x2 0x0123456789ABCDEFabcdef.p019 0x0123456789ABCDEFabcdef.p019))
                                    (v128.const f64x2 0x1.23456789abcdfp+99 0x1.23456789abcdfp+99))
(assert_return (invoke "f64x2.pmax" (v128.const f64x2 0x1.921fb54442d18p+2 0x1.921fb54442d18p+2)
                                    (v128.const f64x2 0x0123456789ABCDEFabcdef.p+019 0x0123456789ABCDEFabcdef.p+019))
                                    (v128.const f64x2 0x1.23456789abcdfp+99 0x1.23456789abcdfp+99))
(assert_return (invoke "f64x2.pmax" (v128.const f64x2 0x1.921fb54442d18p+2 0x1.921fb54442d18p+2)
                                    (v128.const f64x2 0x0123456789ABCDEFabcdef.p-019 0x0123456789ABCDEFabcdef.p-019))
                                    (v128.const f64x2 0x1.23456789abcdfp+61 0x1.23456789abcdfp+61))
(assert_return (invoke "f64x2.pmax" (v128.const f64x2 0x1.921fb54442d18p+2 0x1.921fb54442d18p+2)
                                    (v128.const f64x2 0x0123456789ABCDEFabcdef.0123456789ABCDEFabcdef 0x0123456789ABCDEFabcdef.0123456789ABCDEFabcdef))
                                    (v128.const f64x2 0x1.23456789abcdfp+80 0x1.23456789abcdfp+80))
(assert_return (invoke "f64x2.pmax" (v128.const f64x2 0x1.921fb54442d18p+2 0x1.921fb54442d18p+2)
                                    (v128.const f64x2 0x0123456789ABCDEFabcdef.0123456789ABCDEFabcdefp019 0x0123456789ABCDEFabcdef.0123456789ABCDEFabcdefp019))
                                    (v128.const f64x2 0x1.23456789abcdfp+99 0x1.23456789abcdfp+99))
(assert_return (invoke "f64x2.pmax" (v128.const f64x2 0x1.921fb54442d18p+2 0x1.921fb54442d18p+2)
                                    (v128.const f64x2 0x0123456789ABCDEFabcdef.0123456789ABCDEFabcdefp+019 0x0123456789ABCDEFabcdef.0123456789ABCDEFabcdefp+019))
                                    (v128.const f64x2 0x1.23456789abcdfp+99 0x1.23456789abcdfp+99))
(assert_return (invoke "f64x2.pmax" (v128.const f64x2 0x1.921fb54442d18p+2 0x1.921fb54442d18p+2)
                                    (v128.const f64x2 0x0123456789ABCDEFabcdef.0123456789ABCDEFabcdefp-019 0x0123456789ABCDEFabcdef.0123456789ABCDEFabcdefp-019))
                                    (v128.const f64x2 0x1.23456789abcdfp+61 0x1.23456789abcdfp+61))
(assert_return (invoke "f64x2.pmax" (v128.const f64x2 -0x1.921fb54442d18p+2 -0x1.921fb54442d18p+2)
                                    (v128.const f64x2 0x0p+0 0x0p+0))
                                    (v128.const f64x2 0x0.0p+0 0x0.0p+0))
(assert_return (invoke "f64x2.pmax" (v128.const f64x2 -0x1.921fb54442d18p+2 -0x1.921fb54442d18p+2)
                                    (v128.const f64x2 -0x0p+0 -0x0p+0))
                                    (v128.const f64x2 -0x0.0p+0 -0x0.0p+0))
(assert_return (invoke "f64x2.pmax" (v128.const f64x2 -0x1.921fb54442d18p+2 -0x1.921fb54442d18p+2)
                                    (v128.const f64x2 0x1p-1022 0x1p-1022))
                                    (v128.const f64x2 0x1.0000000000000p-1022 0x1.0000000000000p-1022))
(assert_return (invoke "f64x2.pmax" (v128.const f64x2 -0x1.921fb54442d18p+2 -0x1.921fb54442d18p+2)
                                    (v128.const f64x2 -0x1p-1022 -0x1p-1022))
                                    (v128.const f64x2 -0x1.0000000000000p-1022 -0x1.0000000000000p-1022))
(assert_return (invoke "f64x2.pmax" (v128.const f64x2 -0x1.921fb54442d18p+2 -0x1.921fb54442d18p+2)
                                    (v128.const f64x2 0x1p-1 0x1p-1))
                                    (v128.const f64x2 0x1.0000000000000p-1 0x1.0000000000000p-1))
(assert_return (invoke "f64x2.pmax" (v128.const f64x2 -0x1.921fb54442d18p+2 -0x1.921fb54442d18p+2)
                                    (v128.const f64x2 -0x1p-1 -0x1p-1))
                                    (v128.const f64x2 -0x1.0000000000000p-1 -0x1.0000000000000p-1))
(assert_return (invoke "f64x2.pmax" (v128.const f64x2 -0x1.921fb54442d18p+2 -0x1.921fb54442d18p+2)
                                    (v128.const f64x2 0x1p+0 0x1p+0))
                                    (v128.const f64x2 0x1.0000000000000p+0 0x1.0000000000000p+0))
(assert_return (invoke "f64x2.pmax" (v128.const f64x2 -0x1.921fb54442d18p+2 -0x1.921fb54442d18p+2)
                                    (v128.const f64x2 -0x1p+0 -0x1p+0))
                                    (v128.const f64x2 -0x1.0000000000000p+0 -0x1.0000000000000p+0))
(assert_return (invoke "f64x2.pmax" (v128.const f64x2 -0x1.921fb54442d18p+2 -0x1.921fb54442d18p+2)
                                    (v128.const f64x2 0x1.921fb54442d18p+2 0x1.921fb54442d18p+2))
                                    (v128.const f64x2 0x1.921fb54442d18p+2 0x1.921fb54442d18p+2))
(assert_return (invoke "f64x2.pmax" (v128.const f64x2 -0x1.921fb54442d18p+2 -0x1.921fb54442d18p+2)
                                    (v128.const f64x2 -0x1.921fb54442d18p+2 -0x1.921fb54442d18p+2))
                                    (v128.const f64x2 -0x1.921fb54442d18p+2 -0x1.921fb54442d18p+2))
(assert_return (invoke "f64x2.pmax" (v128.const f64x2 -0x1.921fb54442d18p+2 -0x1.921fb54442d18p+2)
                                    (v128.const f64x2 0x1.fffffffffffffp+1023 0x1.fffffffffffffp+1023))
                                    (v128.const f64x2 0x1.fffffffffffffp+1023 0x1.fffffffffffffp+1023))
(assert_return (invoke "f64x2.pmax" (v128.const f64x2 -0x1.921fb54442d18p+2 -0x1.921fb54442d18p+2)
                                    (v128.const f64x2 -0x1.fffffffffffffp+1023 -0x1.fffffffffffffp+1023))
                                    (v128.const f64x2 -0x1.921fb54442d18p+2 -0x1.921fb54442d18p+2))
(assert_return (invoke "f64x2.pmax" (v128.const f64x2 -0x1.921fb54442d18p+2 -0x1.921fb54442d18p+2)
                                    (v128.const f64x2 0x0.0000000000001p-1022 0x0.0000000000001p-1022))
                                    (v128.const f64x2 0x0.0000000000001p-1022 0x0.0000000000001p-1022))
(assert_return (invoke "f64x2.pmax" (v128.const f64x2 -0x1.921fb54442d18p+2 -0x1.921fb54442d18p+2)
                                    (v128.const f64x2 0x0.0000000000001p-1022 0x0.0000000000001p-1022))
                                    (v128.const f64x2 0x0.0000000000001p-1022 0x0.0000000000001p-1022))
(assert_return (invoke "f64x2.pmax" (v128.const f64x2 -0x1.921fb54442d18p+2 -0x1.921fb54442d18p+2)
                                    (v128.const f64x2 inf inf))
                                    (v128.const f64x2 inf inf))
(assert_return (invoke "f64x2.pmax" (v128.const f64x2 -0x1.921fb54442d18p+2 -0x1.921fb54442d18p+2)
                                    (v128.const f64x2 -inf -inf))
                                    (v128.const f64x2 -0x1.921fb54442d18p+2 -0x1.921fb54442d18p+2))
(assert_return (invoke "f64x2.pmax" (v128.const f64x2 -0x1.921fb54442d18p+2 -0x1.921fb54442d18p+2)
                                    (v128.const f64x2 0123456789 0123456789))
                                    (v128.const f64x2 0x1.d6f3454000000p+26 0x1.d6f3454000000p+26))
(assert_return (invoke "f64x2.pmax" (v128.const f64x2 -0x1.921fb54442d18p+2 -0x1.921fb54442d18p+2)
                                    (v128.const f64x2 0123456789e019 0123456789e019))
                                    (v128.const f64x2 0x1.fe9af5b5e16fap+89 0x1.fe9af5b5e16fap+89))
(assert_return (invoke "f64x2.pmax" (v128.const f64x2 -0x1.921fb54442d18p+2 -0x1.921fb54442d18p+2)
                                    (v128.const f64x2 0123456789e+019 0123456789e+019))
                                    (v128.const f64x2 0x1.fe9af5b5e16fap+89 0x1.fe9af5b5e16fap+89))
(assert_return (invoke "f64x2.pmax" (v128.const f64x2 -0x1.921fb54442d18p+2 -0x1.921fb54442d18p+2)
                                    (v128.const f64x2 0123456789e-019 0123456789e-019))
                                    (v128.const f64x2 0x1.b25ffd62b4311p-37 0x1.b25ffd62b4311p-37))
(assert_return (invoke "f64x2.pmax" (v128.const f64x2 -0x1.921fb54442d18p+2 -0x1.921fb54442d18p+2)
                                    (v128.const f64x2 0123456789. 0123456789.))
                                    (v128.const f64x2 0x1.d6f3454000000p+26 0x1.d6f3454000000p+26))
(assert_return (invoke "f64x2.pmax" (v128.const f64x2 -0x1.921fb54442d18p+2 -0x1.921fb54442d18p+2)
                                    (v128.const f64x2 0123456789.e019 0123456789.e019))
                                    (v128.const f64x2 0x1.fe9af5b5e16fap+89 0x1.fe9af5b5e16fap+89))
(assert_return (invoke "f64x2.pmax" (v128.const f64x2 -0x1.921fb54442d18p+2 -0x1.921fb54442d18p+2)
                                    (v128.const f64x2 0123456789.e+019 0123456789.e+019))
                                    (v128.const f64x2 0x1.fe9af5b5e16fap+89 0x1.fe9af5b5e16fap+89))
(assert_return (invoke "f64x2.pmax" (v128.const f64x2 -0x1.921fb54442d18p+2 -0x1.921fb54442d18p+2)
                                    (v128.const f64x2 0123456789.e-019 0123456789.e-019))
                                    (v128.const f64x2 0x1.b25ffd62b4311p-37 0x1.b25ffd62b4311p-37))
(assert_return (invoke "f64x2.pmax" (v128.const f64x2 -0x1.921fb54442d18p+2 -0x1.921fb54442d18p+2)
                                    (v128.const f64x2 0123456789.0123456789 0123456789.0123456789))
                                    (v128.const f64x2 0x1.d6f34540ca458p+26 0x1.d6f34540ca458p+26))
(assert_return (invoke "f64x2.pmax" (v128.const f64x2 -0x1.921fb54442d18p+2 -0x1.921fb54442d18p+2)
                                    (v128.const f64x2 0123456789.0123456789e019 0123456789.0123456789e019))
                                    (v128.const f64x2 0x1.fe9af5b6bcbd5p+89 0x1.fe9af5b6bcbd5p+89))
(assert_return (invoke "f64x2.pmax" (v128.const f64x2 -0x1.921fb54442d18p+2 -0x1.921fb54442d18p+2)
                                    (v128.const f64x2 0123456789.0123456789e+019 0123456789.0123456789e+019))
                                    (v128.const f64x2 0x1.fe9af5b6bcbd5p+89 0x1.fe9af5b6bcbd5p+89))
(assert_return (invoke "f64x2.pmax" (v128.const f64x2 -0x1.921fb54442d18p+2 -0x1.921fb54442d18p+2)
                                    (v128.const f64x2 0123456789.0123456789e-019 0123456789.0123456789e-019))
                                    (v128.const f64x2 0x1.b25ffd636ec12p-37 0x1.b25ffd636ec12p-37))
(assert_return (invoke "f64x2.pmax" (v128.const f64x2 -0x1.921fb54442d18p+2 -0x1.921fb54442d18p+2)
                                    (v128.const f64x2 0x0123456789ABCDEFabcdef 0x0123456789ABCDEFabcdef))
                                    (v128.const f64x2 0x1.23456789abcdfp+80 0x1.23456789abcdfp+80))
(assert_return (invoke "f64x2.pmax" (v128.const f64x2 -0x1.921fb54442d18p+2 -0x1.921fb54442d18p+2)
                                    (v128.const f64x2 0x0123456789ABCDEFabcdefp019 0x0123456789ABCDEFabcdefp019))
                                    (v128.const f64x2 0x1.23456789abcdfp+99 0x1.23456789abcdfp+99))
(assert_return (invoke "f64x2.pmax" (v128.const f64x2 -0x1.921fb54442d18p+2 -0x1.921fb54442d18p+2)
                                    (v128.const f64x2 0x0123456789ABCDEFabcdefp+019 0x0123456789ABCDEFabcdefp+019))
                                    (v128.const f64x2 0x1.23456789abcdfp+99 0x1.23456789abcdfp+99))
(assert_return (invoke "f64x2.pmax" (v128.const f64x2 -0x1.921fb54442d18p+2 -0x1.921fb54442d18p+2)
                                    (v128.const f64x2 0x0123456789ABCDEFabcdefp-019 0x0123456789ABCDEFabcdefp-019))
                                    (v128.const f64x2 0x1.23456789abcdfp+61 0x1.23456789abcdfp+61))
(assert_return (invoke "f64x2.pmax" (v128.const f64x2 -0x1.921fb54442d18p+2 -0x1.921fb54442d18p+2)
                                    (v128.const f64x2 0x0123456789ABCDEFabcdef. 0x0123456789ABCDEFabcdef.))
                                    (v128.const f64x2 0x1.23456789abcdfp+80 0x1.23456789abcdfp+80))
(assert_return (invoke "f64x2.pmax" (v128.const f64x2 -0x1.921fb54442d18p+2 -0x1.921fb54442d18p+2)
                                    (v128.const f64x2 0x0123456789ABCDEFabcdef.p019 0x0123456789ABCDEFabcdef.p019))
                                    (v128.const f64x2 0x1.23456789abcdfp+99 0x1.23456789abcdfp+99))
(assert_return (invoke "f64x2.pmax" (v128.const f64x2 -0x1.921fb54442d18p+2 -0x1.921fb54442d18p+2)
                                    (v128.const f64x2 0x0123456789ABCDEFabcdef.p+019 0x0123456789ABCDEFabcdef.p+019))
                                    (v128.const f64x2 0x1.23456789abcdfp+99 0x1.23456789abcdfp+99))
(assert_return (invoke "f64x2.pmax" (v128.const f64x2 -0x1.921fb54442d18p+2 -0x1.921fb54442d18p+2)
                                    (v128.const f64x2 0x0123456789ABCDEFabcdef.p-019 0x0123456789ABCDEFabcdef.p-019))
                                    (v128.const f64x2 0x1.23456789abcdfp+61 0x1.23456789abcdfp+61))
(assert_return (invoke "f64x2.pmax" (v128.const f64x2 -0x1.921fb54442d18p+2 -0x1.921fb54442d18p+2)
                                    (v128.const f64x2 0x0123456789ABCDEFabcdef.0123456789ABCDEFabcdef 0x0123456789ABCDEFabcdef.0123456789ABCDEFabcdef))
                                    (v128.const f64x2 0x1.23456789abcdfp+80 0x1.23456789abcdfp+80))
(assert_return (invoke "f64x2.pmax" (v128.const f64x2 -0x1.921fb54442d18p+2 -0x1.921fb54442d18p+2)
                                    (v128.const f64x2 0x0123456789ABCDEFabcdef.0123456789ABCDEFabcdefp019 0x0123456789ABCDEFabcdef.0123456789ABCDEFabcdefp019))
                                    (v128.const f64x2 0x1.23456789abcdfp+99 0x1.23456789abcdfp+99))
(assert_return (invoke "f64x2.pmax" (v128.const f64x2 -0x1.921fb54442d18p+2 -0x1.921fb54442d18p+2)
                                    (v128.const f64x2 0x0123456789ABCDEFabcdef.0123456789ABCDEFabcdefp+019 0x0123456789ABCDEFabcdef.0123456789ABCDEFabcdefp+019))
                                    (v128.const f64x2 0x1.23456789abcdfp+99 0x1.23456789abcdfp+99))
(assert_return (invoke "f64x2.pmax" (v128.const f64x2 -0x1.921fb54442d18p+2 -0x1.921fb54442d18p+2)
                                    (v128.const f64x2 0x0123456789ABCDEFabcdef.0123456789ABCDEFabcdefp-019 0x0123456789ABCDEFabcdef.0123456789ABCDEFabcdefp-019))
                                    (v128.const f64x2 0x1.23456789abcdfp+61 0x1.23456789abcdfp+61))
(assert_return (invoke "f64x2.pmax" (v128.const f64x2 0x1.fffffffffffffp+1023 0x1.fffffffffffffp+1023)
                                    (v128.const f64x2 0x0p+0 0x0p+0))
                                    (v128.const f64x2 0x1.fffffffffffffp+1023 0x1.fffffffffffffp+1023))
(assert_return (invoke "f64x2.pmax" (v128.const f64x2 0x1.fffffffffffffp+1023 0x1.fffffffffffffp+1023)
                                    (v128.const f64x2 -0x0p+0 -0x0p+0))
                                    (v128.const f64x2 0x1.fffffffffffffp+1023 0x1.fffffffffffffp+1023))
(assert_return (invoke "f64x2.pmax" (v128.const f64x2 0x1.fffffffffffffp+1023 0x1.fffffffffffffp+1023)
                                    (v128.const f64x2 0x1p-1022 0x1p-1022))
                                    (v128.const f64x2 0x1.fffffffffffffp+1023 0x1.fffffffffffffp+1023))
(assert_return (invoke "f64x2.pmax" (v128.const f64x2 0x1.fffffffffffffp+1023 0x1.fffffffffffffp+1023)
                                    (v128.const f64x2 -0x1p-1022 -0x1p-1022))
                                    (v128.const f64x2 0x1.fffffffffffffp+1023 0x1.fffffffffffffp+1023))
(assert_return (invoke "f64x2.pmax" (v128.const f64x2 0x1.fffffffffffffp+1023 0x1.fffffffffffffp+1023)
                                    (v128.const f64x2 0x1p-1 0x1p-1))
                                    (v128.const f64x2 0x1.fffffffffffffp+1023 0x1.fffffffffffffp+1023))
(assert_return (invoke "f64x2.pmax" (v128.const f64x2 0x1.fffffffffffffp+1023 0x1.fffffffffffffp+1023)
                                    (v128.const f64x2 -0x1p-1 -0x1p-1))
                                    (v128.const f64x2 0x1.fffffffffffffp+1023 0x1.fffffffffffffp+1023))
(assert_return (invoke "f64x2.pmax" (v128.const f64x2 0x1.fffffffffffffp+1023 0x1.fffffffffffffp+1023)
                                    (v128.const f64x2 0x1p+0 0x1p+0))
                                    (v128.const f64x2 0x1.fffffffffffffp+1023 0x1.fffffffffffffp+1023))
(assert_return (invoke "f64x2.pmax" (v128.const f64x2 0x1.fffffffffffffp+1023 0x1.fffffffffffffp+1023)
                                    (v128.const f64x2 -0x1p+0 -0x1p+0))
                                    (v128.const f64x2 0x1.fffffffffffffp+1023 0x1.fffffffffffffp+1023))
(assert_return (invoke "f64x2.pmax" (v128.const f64x2 0x1.fffffffffffffp+1023 0x1.fffffffffffffp+1023)
                                    (v128.const f64x2 0x1.921fb54442d18p+2 0x1.921fb54442d18p+2))
                                    (v128.const f64x2 0x1.fffffffffffffp+1023 0x1.fffffffffffffp+1023))
(assert_return (invoke "f64x2.pmax" (v128.const f64x2 0x1.fffffffffffffp+1023 0x1.fffffffffffffp+1023)
                                    (v128.const f64x2 -0x1.921fb54442d18p+2 -0x1.921fb54442d18p+2))
                                    (v128.const f64x2 0x1.fffffffffffffp+1023 0x1.fffffffffffffp+1023))
(assert_return (invoke "f64x2.pmax" (v128.const f64x2 0x1.fffffffffffffp+1023 0x1.fffffffffffffp+1023)
                                    (v128.const f64x2 0x1.fffffffffffffp+1023 0x1.fffffffffffffp+1023))
                                    (v128.const f64x2 0x1.fffffffffffffp+1023 0x1.fffffffffffffp+1023))
(assert_return (invoke "f64x2.pmax" (v128.const f64x2 0x1.fffffffffffffp+1023 0x1.fffffffffffffp+1023)
                                    (v128.const f64x2 -0x1.fffffffffffffp+1023 -0x1.fffffffffffffp+1023))
                                    (v128.const f64x2 0x1.fffffffffffffp+1023 0x1.fffffffffffffp+1023))
(assert_return (invoke "f64x2.pmax" (v128.const f64x2 0x1.fffffffffffffp+1023 0x1.fffffffffffffp+1023)
                                    (v128.const f64x2 0x0.0000000000001p-1022 0x0.0000000000001p-1022))
                                    (v128.const f64x2 0x1.fffffffffffffp+1023 0x1.fffffffffffffp+1023))
(assert_return (invoke "f64x2.pmax" (v128.const f64x2 0x1.fffffffffffffp+1023 0x1.fffffffffffffp+1023)
                                    (v128.const f64x2 0x0.0000000000001p-1022 0x0.0000000000001p-1022))
                                    (v128.const f64x2 0x1.fffffffffffffp+1023 0x1.fffffffffffffp+1023))
(assert_return (invoke "f64x2.pmax" (v128.const f64x2 0x1.fffffffffffffp+1023 0x1.fffffffffffffp+1023)
                                    (v128.const f64x2 inf inf))
                                    (v128.const f64x2 inf inf))
(assert_return (invoke "f64x2.pmax" (v128.const f64x2 0x1.fffffffffffffp+1023 0x1.fffffffffffffp+1023)
                                    (v128.const f64x2 -inf -inf))
                                    (v128.const f64x2 0x1.fffffffffffffp+1023 0x1.fffffffffffffp+1023))
(assert_return (invoke "f64x2.pmax" (v128.const f64x2 0x1.fffffffffffffp+1023 0x1.fffffffffffffp+1023)
                                    (v128.const f64x2 0123456789 0123456789))
                                    (v128.const f64x2 0x1.fffffffffffffp+1023 0x1.fffffffffffffp+1023))
(assert_return (invoke "f64x2.pmax" (v128.const f64x2 0x1.fffffffffffffp+1023 0x1.fffffffffffffp+1023)
                                    (v128.const f64x2 0123456789e019 0123456789e019))
                                    (v128.const f64x2 0x1.fffffffffffffp+1023 0x1.fffffffffffffp+1023))
(assert_return (invoke "f64x2.pmax" (v128.const f64x2 0x1.fffffffffffffp+1023 0x1.fffffffffffffp+1023)
                                    (v128.const f64x2 0123456789e+019 0123456789e+019))
                                    (v128.const f64x2 0x1.fffffffffffffp+1023 0x1.fffffffffffffp+1023))
(assert_return (invoke "f64x2.pmax" (v128.const f64x2 0x1.fffffffffffffp+1023 0x1.fffffffffffffp+1023)
                                    (v128.const f64x2 0123456789e-019 0123456789e-019))
                                    (v128.const f64x2 0x1.fffffffffffffp+1023 0x1.fffffffffffffp+1023))
(assert_return (invoke "f64x2.pmax" (v128.const f64x2 0x1.fffffffffffffp+1023 0x1.fffffffffffffp+1023)
                                    (v128.const f64x2 0123456789. 0123456789.))
                                    (v128.const f64x2 0x1.fffffffffffffp+1023 0x1.fffffffffffffp+1023))
(assert_return (invoke "f64x2.pmax" (v128.const f64x2 0x1.fffffffffffffp+1023 0x1.fffffffffffffp+1023)
                                    (v128.const f64x2 0123456789.e019 0123456789.e019))
                                    (v128.const f64x2 0x1.fffffffffffffp+1023 0x1.fffffffffffffp+1023))
(assert_return (invoke "f64x2.pmax" (v128.const f64x2 0x1.fffffffffffffp+1023 0x1.fffffffffffffp+1023)
                                    (v128.const f64x2 0123456789.e+019 0123456789.e+019))
                                    (v128.const f64x2 0x1.fffffffffffffp+1023 0x1.fffffffffffffp+1023))
(assert_return (invoke "f64x2.pmax" (v128.const f64x2 0x1.fffffffffffffp+1023 0x1.fffffffffffffp+1023)
                                    (v128.const f64x2 0123456789.e-019 0123456789.e-019))
                                    (v128.const f64x2 0x1.fffffffffffffp+1023 0x1.fffffffffffffp+1023))
(assert_return (invoke "f64x2.pmax" (v128.const f64x2 0x1.fffffffffffffp+1023 0x1.fffffffffffffp+1023)
                                    (v128.const f64x2 0123456789.0123456789 0123456789.0123456789))
                                    (v128.const f64x2 0x1.fffffffffffffp+1023 0x1.fffffffffffffp+1023))
(assert_return (invoke "f64x2.pmax" (v128.const f64x2 0x1.fffffffffffffp+1023 0x1.fffffffffffffp+1023)
                                    (v128.const f64x2 0123456789.0123456789e019 0123456789.0123456789e019))
                                    (v128.const f64x2 0x1.fffffffffffffp+1023 0x1.fffffffffffffp+1023))
(assert_return (invoke "f64x2.pmax" (v128.const f64x2 0x1.fffffffffffffp+1023 0x1.fffffffffffffp+1023)
                                    (v128.const f64x2 0123456789.0123456789e+019 0123456789.0123456789e+019))
                                    (v128.const f64x2 0x1.fffffffffffffp+1023 0x1.fffffffffffffp+1023))
(assert_return (invoke "f64x2.pmax" (v128.const f64x2 0x1.fffffffffffffp+1023 0x1.fffffffffffffp+1023)
                                    (v128.const f64x2 0123456789.0123456789e-019 0123456789.0123456789e-019))
                                    (v128.const f64x2 0x1.fffffffffffffp+1023 0x1.fffffffffffffp+1023))
(assert_return (invoke "f64x2.pmax" (v128.const f64x2 0x1.fffffffffffffp+1023 0x1.fffffffffffffp+1023)
                                    (v128.const f64x2 0x0123456789ABCDEFabcdef 0x0123456789ABCDEFabcdef))
                                    (v128.const f64x2 0x1.fffffffffffffp+1023 0x1.fffffffffffffp+1023))
(assert_return (invoke "f64x2.pmax" (v128.const f64x2 0x1.fffffffffffffp+1023 0x1.fffffffffffffp+1023)
                                    (v128.const f64x2 0x0123456789ABCDEFabcdefp019 0x0123456789ABCDEFabcdefp019))
                                    (v128.const f64x2 0x1.fffffffffffffp+1023 0x1.fffffffffffffp+1023))
(assert_return (invoke "f64x2.pmax" (v128.const f64x2 0x1.fffffffffffffp+1023 0x1.fffffffffffffp+1023)
                                    (v128.const f64x2 0x0123456789ABCDEFabcdefp+019 0x0123456789ABCDEFabcdefp+019))
                                    (v128.const f64x2 0x1.fffffffffffffp+1023 0x1.fffffffffffffp+1023))
(assert_return (invoke "f64x2.pmax" (v128.const f64x2 0x1.fffffffffffffp+1023 0x1.fffffffffffffp+1023)
                                    (v128.const f64x2 0x0123456789ABCDEFabcdefp-019 0x0123456789ABCDEFabcdefp-019))
                                    (v128.const f64x2 0x1.fffffffffffffp+1023 0x1.fffffffffffffp+1023))
(assert_return (invoke "f64x2.pmax" (v128.const f64x2 0x1.fffffffffffffp+1023 0x1.fffffffffffffp+1023)
                                    (v128.const f64x2 0x0123456789ABCDEFabcdef. 0x0123456789ABCDEFabcdef.))
                                    (v128.const f64x2 0x1.fffffffffffffp+1023 0x1.fffffffffffffp+1023))
(assert_return (invoke "f64x2.pmax" (v128.const f64x2 0x1.fffffffffffffp+1023 0x1.fffffffffffffp+1023)
                                    (v128.const f64x2 0x0123456789ABCDEFabcdef.p019 0x0123456789ABCDEFabcdef.p019))
                                    (v128.const f64x2 0x1.fffffffffffffp+1023 0x1.fffffffffffffp+1023))
(assert_return (invoke "f64x2.pmax" (v128.const f64x2 0x1.fffffffffffffp+1023 0x1.fffffffffffffp+1023)
                                    (v128.const f64x2 0x0123456789ABCDEFabcdef.p+019 0x0123456789ABCDEFabcdef.p+019))
                                    (v128.const f64x2 0x1.fffffffffffffp+1023 0x1.fffffffffffffp+1023))
(assert_return (invoke "f64x2.pmax" (v128.const f64x2 0x1.fffffffffffffp+1023 0x1.fffffffffffffp+1023)
                                    (v128.const f64x2 0x0123456789ABCDEFabcdef.p-019 0x0123456789ABCDEFabcdef.p-019))
                                    (v128.const f64x2 0x1.fffffffffffffp+1023 0x1.fffffffffffffp+1023))
(assert_return (invoke "f64x2.pmax" (v128.const f64x2 0x1.fffffffffffffp+1023 0x1.fffffffffffffp+1023)
                                    (v128.const f64x2 0x0123456789ABCDEFabcdef.0123456789ABCDEFabcdef 0x0123456789ABCDEFabcdef.0123456789ABCDEFabcdef))
                                    (v128.const f64x2 0x1.fffffffffffffp+1023 0x1.fffffffffffffp+1023))
(assert_return (invoke "f64x2.pmax" (v128.const f64x2 0x1.fffffffffffffp+1023 0x1.fffffffffffffp+1023)
                                    (v128.const f64x2 0x0123456789ABCDEFabcdef.0123456789ABCDEFabcdefp019 0x0123456789ABCDEFabcdef.0123456789ABCDEFabcdefp019))
                                    (v128.const f64x2 0x1.fffffffffffffp+1023 0x1.fffffffffffffp+1023))
(assert_return (invoke "f64x2.pmax" (v128.const f64x2 0x1.fffffffffffffp+1023 0x1.fffffffffffffp+1023)
                                    (v128.const f64x2 0x0123456789ABCDEFabcdef.0123456789ABCDEFabcdefp+019 0x0123456789ABCDEFabcdef.0123456789ABCDEFabcdefp+019))
                                    (v128.const f64x2 0x1.fffffffffffffp+1023 0x1.fffffffffffffp+1023))
(assert_return (invoke "f64x2.pmax" (v128.const f64x2 0x1.fffffffffffffp+1023 0x1.fffffffffffffp+1023)
                                    (v128.const f64x2 0x0123456789ABCDEFabcdef.0123456789ABCDEFabcdefp-019 0x0123456789ABCDEFabcdef.0123456789ABCDEFabcdefp-019))
                                    (v128.const f64x2 0x1.fffffffffffffp+1023 0x1.fffffffffffffp+1023))
(assert_return (invoke "f64x2.pmax" (v128.const f64x2 -0x1.fffffffffffffp+1023 -0x1.fffffffffffffp+1023)
                                    (v128.const f64x2 0x0p+0 0x0p+0))
                                    (v128.const f64x2 0x0.0p+0 0x0.0p+0))
(assert_return (invoke "f64x2.pmax" (v128.const f64x2 -0x1.fffffffffffffp+1023 -0x1.fffffffffffffp+1023)
                                    (v128.const f64x2 -0x0p+0 -0x0p+0))
                                    (v128.const f64x2 -0x0.0p+0 -0x0.0p+0))
(assert_return (invoke "f64x2.pmax" (v128.const f64x2 -0x1.fffffffffffffp+1023 -0x1.fffffffffffffp+1023)
                                    (v128.const f64x2 0x1p-1022 0x1p-1022))
                                    (v128.const f64x2 0x1.0000000000000p-1022 0x1.0000000000000p-1022))
(assert_return (invoke "f64x2.pmax" (v128.const f64x2 -0x1.fffffffffffffp+1023 -0x1.fffffffffffffp+1023)
                                    (v128.const f64x2 -0x1p-1022 -0x1p-1022))
                                    (v128.const f64x2 -0x1.0000000000000p-1022 -0x1.0000000000000p-1022))
(assert_return (invoke "f64x2.pmax" (v128.const f64x2 -0x1.fffffffffffffp+1023 -0x1.fffffffffffffp+1023)
                                    (v128.const f64x2 0x1p-1 0x1p-1))
                                    (v128.const f64x2 0x1.0000000000000p-1 0x1.0000000000000p-1))
(assert_return (invoke "f64x2.pmax" (v128.const f64x2 -0x1.fffffffffffffp+1023 -0x1.fffffffffffffp+1023)
                                    (v128.const f64x2 -0x1p-1 -0x1p-1))
                                    (v128.const f64x2 -0x1.0000000000000p-1 -0x1.0000000000000p-1))
(assert_return (invoke "f64x2.pmax" (v128.const f64x2 -0x1.fffffffffffffp+1023 -0x1.fffffffffffffp+1023)
                                    (v128.const f64x2 0x1p+0 0x1p+0))
                                    (v128.const f64x2 0x1.0000000000000p+0 0x1.0000000000000p+0))
(assert_return (invoke "f64x2.pmax" (v128.const f64x2 -0x1.fffffffffffffp+1023 -0x1.fffffffffffffp+1023)
                                    (v128.const f64x2 -0x1p+0 -0x1p+0))
                                    (v128.const f64x2 -0x1.0000000000000p+0 -0x1.0000000000000p+0))
(assert_return (invoke "f64x2.pmax" (v128.const f64x2 -0x1.fffffffffffffp+1023 -0x1.fffffffffffffp+1023)
                                    (v128.const f64x2 0x1.921fb54442d18p+2 0x1.921fb54442d18p+2))
                                    (v128.const f64x2 0x1.921fb54442d18p+2 0x1.921fb54442d18p+2))
(assert_return (invoke "f64x2.pmax" (v128.const f64x2 -0x1.fffffffffffffp+1023 -0x1.fffffffffffffp+1023)
                                    (v128.const f64x2 -0x1.921fb54442d18p+2 -0x1.921fb54442d18p+2))
                                    (v128.const f64x2 -0x1.921fb54442d18p+2 -0x1.921fb54442d18p+2))
(assert_return (invoke "f64x2.pmax" (v128.const f64x2 -0x1.fffffffffffffp+1023 -0x1.fffffffffffffp+1023)
                                    (v128.const f64x2 0x1.fffffffffffffp+1023 0x1.fffffffffffffp+1023))
                                    (v128.const f64x2 0x1.fffffffffffffp+1023 0x1.fffffffffffffp+1023))
(assert_return (invoke "f64x2.pmax" (v128.const f64x2 -0x1.fffffffffffffp+1023 -0x1.fffffffffffffp+1023)
                                    (v128.const f64x2 -0x1.fffffffffffffp+1023 -0x1.fffffffffffffp+1023))
                                    (v128.const f64x2 -0x1.fffffffffffffp+1023 -0x1.fffffffffffffp+1023))
(assert_return (invoke "f64x2.pmax" (v128.const f64x2 -0x1.fffffffffffffp+1023 -0x1.fffffffffffffp+1023)
                                    (v128.const f64x2 0x0.0000000000001p-1022 0x0.0000000000001p-1022))
                                    (v128.const f64x2 0x0.0000000000001p-1022 0x0.0000000000001p-1022))
(assert_return (invoke "f64x2.pmax" (v128.const f64x2 -0x1.fffffffffffffp+1023 -0x1.fffffffffffffp+1023)
                                    (v128.const f64x2 0x0.0000000000001p-1022 0x0.0000000000001p-1022))
                                    (v128.const f64x2 0x0.0000000000001p-1022 0x0.0000000000001p-1022))
(assert_return (invoke "f64x2.pmax" (v128.const f64x2 -0x1.fffffffffffffp+1023 -0x1.fffffffffffffp+1023)
                                    (v128.const f64x2 inf inf))
                                    (v128.const f64x2 inf inf))
(assert_return (invoke "f64x2.pmax" (v128.const f64x2 -0x1.fffffffffffffp+1023 -0x1.fffffffffffffp+1023)
                                    (v128.const f64x2 -inf -inf))
                                    (v128.const f64x2 -0x1.fffffffffffffp+1023 -0x1.fffffffffffffp+1023))
(assert_return (invoke "f64x2.pmax" (v128.const f64x2 -0x1.fffffffffffffp+1023 -0x1.fffffffffffffp+1023)
                                    (v128.const f64x2 0123456789 0123456789))
                                    (v128.const f64x2 0x1.d6f3454000000p+26 0x1.d6f3454000000p+26))
(assert_return (invoke "f64x2.pmax" (v128.const f64x2 -0x1.fffffffffffffp+1023 -0x1.fffffffffffffp+1023)
                                    (v128.const f64x2 0123456789e019 0123456789e019))
                                    (v128.const f64x2 0x1.fe9af5b5e16fap+89 0x1.fe9af5b5e16fap+89))
(assert_return (invoke "f64x2.pmax" (v128.const f64x2 -0x1.fffffffffffffp+1023 -0x1.fffffffffffffp+1023)
                                    (v128.const f64x2 0123456789e+019 0123456789e+019))
                                    (v128.const f64x2 0x1.fe9af5b5e16fap+89 0x1.fe9af5b5e16fap+89))
(assert_return (invoke "f64x2.pmax" (v128.const f64x2 -0x1.fffffffffffffp+1023 -0x1.fffffffffffffp+1023)
                                    (v128.const f64x2 0123456789e-019 0123456789e-019))
                                    (v128.const f64x2 0x1.b25ffd62b4311p-37 0x1.b25ffd62b4311p-37))
(assert_return (invoke "f64x2.pmax" (v128.const f64x2 -0x1.fffffffffffffp+1023 -0x1.fffffffffffffp+1023)
                                    (v128.const f64x2 0123456789. 0123456789.))
                                    (v128.const f64x2 0x1.d6f3454000000p+26 0x1.d6f3454000000p+26))
(assert_return (invoke "f64x2.pmax" (v128.const f64x2 -0x1.fffffffffffffp+1023 -0x1.fffffffffffffp+1023)
                                    (v128.const f64x2 0123456789.e019 0123456789.e019))
                                    (v128.const f64x2 0x1.fe9af5b5e16fap+89 0x1.fe9af5b5e16fap+89))
(assert_return (invoke "f64x2.pmax" (v128.const f64x2 -0x1.fffffffffffffp+1023 -0x1.fffffffffffffp+1023)
                                    (v128.const f64x2 0123456789.e+019 0123456789.e+019))
                                    (v128.const f64x2 0x1.fe9af5b5e16fap+89 0x1.fe9af5b5e16fap+89))
(assert_return (invoke "f64x2.pmax" (v128.const f64x2 -0x1.fffffffffffffp+1023 -0x1.fffffffffffffp+1023)
                                    (v128.const f64x2 0123456789.e-019 0123456789.e-019))
                                    (v128.const f64x2 0x1.b25ffd62b4311p-37 0x1.b25ffd62b4311p-37))
(assert_return (invoke "f64x2.pmax" (v128.const f64x2 -0x1.fffffffffffffp+1023 -0x1.fffffffffffffp+1023)
                                    (v128.const f64x2 0123456789.0123456789 0123456789.0123456789))
                                    (v128.const f64x2 0x1.d6f34540ca458p+26 0x1.d6f34540ca458p+26))
(assert_return (invoke "f64x2.pmax" (v128.const f64x2 -0x1.fffffffffffffp+1023 -0x1.fffffffffffffp+1023)
                                    (v128.const f64x2 0123456789.0123456789e019 0123456789.0123456789e019))
                                    (v128.const f64x2 0x1.fe9af5b6bcbd5p+89 0x1.fe9af5b6bcbd5p+89))
(assert_return (invoke "f64x2.pmax" (v128.const f64x2 -0x1.fffffffffffffp+1023 -0x1.fffffffffffffp+1023)
                                    (v128.const f64x2 0123456789.0123456789e+019 0123456789.0123456789e+019))
                                    (v128.const f64x2 0x1.fe9af5b6bcbd5p+89 0x1.fe9af5b6bcbd5p+89))
(assert_return (invoke "f64x2.pmax" (v128.const f64x2 -0x1.fffffffffffffp+1023 -0x1.fffffffffffffp+1023)
                                    (v128.const f64x2 0123456789.0123456789e-019 0123456789.0123456789e-019))
                                    (v128.const f64x2 0x1.b25ffd636ec12p-37 0x1.b25ffd636ec12p-37))
(assert_return (invoke "f64x2.pmax" (v128.const f64x2 -0x1.fffffffffffffp+1023 -0x1.fffffffffffffp+1023)
                                    (v128.const f64x2 0x0123456789ABCDEFabcdef 0x0123456789ABCDEFabcdef))
                                    (v128.const f64x2 0x1.23456789abcdfp+80 0x1.23456789abcdfp+80))
(assert_return (invoke "f64x2.pmax" (v128.const f64x2 -0x1.fffffffffffffp+1023 -0x1.fffffffffffffp+1023)
                                    (v128.const f64x2 0x0123456789ABCDEFabcdefp019 0x0123456789ABCDEFabcdefp019))
                                    (v128.const f64x2 0x1.23456789abcdfp+99 0x1.23456789abcdfp+99))
(assert_return (invoke "f64x2.pmax" (v128.const f64x2 -0x1.fffffffffffffp+1023 -0x1.fffffffffffffp+1023)
                                    (v128.const f64x2 0x0123456789ABCDEFabcdefp+019 0x0123456789ABCDEFabcdefp+019))
                                    (v128.const f64x2 0x1.23456789abcdfp+99 0x1.23456789abcdfp+99))
(assert_return (invoke "f64x2.pmax" (v128.const f64x2 -0x1.fffffffffffffp+1023 -0x1.fffffffffffffp+1023)
                                    (v128.const f64x2 0x0123456789ABCDEFabcdefp-019 0x0123456789ABCDEFabcdefp-019))
                                    (v128.const f64x2 0x1.23456789abcdfp+61 0x1.23456789abcdfp+61))
(assert_return (invoke "f64x2.pmax" (v128.const f64x2 -0x1.fffffffffffffp+1023 -0x1.fffffffffffffp+1023)
                                    (v128.const f64x2 0x0123456789ABCDEFabcdef. 0x0123456789ABCDEFabcdef.))
                                    (v128.const f64x2 0x1.23456789abcdfp+80 0x1.23456789abcdfp+80))
(assert_return (invoke "f64x2.pmax" (v128.const f64x2 -0x1.fffffffffffffp+1023 -0x1.fffffffffffffp+1023)
                                    (v128.const f64x2 0x0123456789ABCDEFabcdef.p019 0x0123456789ABCDEFabcdef.p019))
                                    (v128.const f64x2 0x1.23456789abcdfp+99 0x1.23456789abcdfp+99))
(assert_return (invoke "f64x2.pmax" (v128.const f64x2 -0x1.fffffffffffffp+1023 -0x1.fffffffffffffp+1023)
                                    (v128.const f64x2 0x0123456789ABCDEFabcdef.p+019 0x0123456789ABCDEFabcdef.p+019))
                                    (v128.const f64x2 0x1.23456789abcdfp+99 0x1.23456789abcdfp+99))
(assert_return (invoke "f64x2.pmax" (v128.const f64x2 -0x1.fffffffffffffp+1023 -0x1.fffffffffffffp+1023)
                                    (v128.const f64x2 0x0123456789ABCDEFabcdef.p-019 0x0123456789ABCDEFabcdef.p-019))
                                    (v128.const f64x2 0x1.23456789abcdfp+61 0x1.23456789abcdfp+61))
(assert_return (invoke "f64x2.pmax" (v128.const f64x2 -0x1.fffffffffffffp+1023 -0x1.fffffffffffffp+1023)
                                    (v128.const f64x2 0x0123456789ABCDEFabcdef.0123456789ABCDEFabcdef 0x0123456789ABCDEFabcdef.0123456789ABCDEFabcdef))
                                    (v128.const f64x2 0x1.23456789abcdfp+80 0x1.23456789abcdfp+80))
(assert_return (invoke "f64x2.pmax" (v128.const f64x2 -0x1.fffffffffffffp+1023 -0x1.fffffffffffffp+1023)
                                    (v128.const f64x2 0x0123456789ABCDEFabcdef.0123456789ABCDEFabcdefp019 0x0123456789ABCDEFabcdef.0123456789ABCDEFabcdefp019))
                                    (v128.const f64x2 0x1.23456789abcdfp+99 0x1.23456789abcdfp+99))
(assert_return (invoke "f64x2.pmax" (v128.const f64x2 -0x1.fffffffffffffp+1023 -0x1.fffffffffffffp+1023)
                                    (v128.const f64x2 0x0123456789ABCDEFabcdef.0123456789ABCDEFabcdefp+019 0x0123456789ABCDEFabcdef.0123456789ABCDEFabcdefp+019))
                                    (v128.const f64x2 0x1.23456789abcdfp+99 0x1.23456789abcdfp+99))
(assert_return (invoke "f64x2.pmax" (v128.const f64x2 -0x1.fffffffffffffp+1023 -0x1.fffffffffffffp+1023)
                                    (v128.const f64x2 0x0123456789ABCDEFabcdef.0123456789ABCDEFabcdefp-019 0x0123456789ABCDEFabcdef.0123456789ABCDEFabcdefp-019))
                                    (v128.const f64x2 0x1.23456789abcdfp+61 0x1.23456789abcdfp+61))
(assert_return (invoke "f64x2.pmax" (v128.const f64x2 0x0.0000000000001p-1022 0x0.0000000000001p-1022)
                                    (v128.const f64x2 0x0p+0 0x0p+0))
                                    (v128.const f64x2 0x0.0000000000001p-1022 0x0.0000000000001p-1022))
(assert_return (invoke "f64x2.pmax" (v128.const f64x2 0x0.0000000000001p-1022 0x0.0000000000001p-1022)
                                    (v128.const f64x2 -0x0p+0 -0x0p+0))
                                    (v128.const f64x2 0x0.0000000000001p-1022 0x0.0000000000001p-1022))
(assert_return (invoke "f64x2.pmax" (v128.const f64x2 0x0.0000000000001p-1022 0x0.0000000000001p-1022)
                                    (v128.const f64x2 0x1p-1022 0x1p-1022))
                                    (v128.const f64x2 0x1.0000000000000p-1022 0x1.0000000000000p-1022))
(assert_return (invoke "f64x2.pmax" (v128.const f64x2 0x0.0000000000001p-1022 0x0.0000000000001p-1022)
                                    (v128.const f64x2 -0x1p-1022 -0x1p-1022))
                                    (v128.const f64x2 0x0.0000000000001p-1022 0x0.0000000000001p-1022))
(assert_return (invoke "f64x2.pmax" (v128.const f64x2 0x0.0000000000001p-1022 0x0.0000000000001p-1022)
                                    (v128.const f64x2 0x1p-1 0x1p-1))
                                    (v128.const f64x2 0x1.0000000000000p-1 0x1.0000000000000p-1))
(assert_return (invoke "f64x2.pmax" (v128.const f64x2 0x0.0000000000001p-1022 0x0.0000000000001p-1022)
                                    (v128.const f64x2 -0x1p-1 -0x1p-1))
                                    (v128.const f64x2 0x0.0000000000001p-1022 0x0.0000000000001p-1022))
(assert_return (invoke "f64x2.pmax" (v128.const f64x2 0x0.0000000000001p-1022 0x0.0000000000001p-1022)
                                    (v128.const f64x2 0x1p+0 0x1p+0))
                                    (v128.const f64x2 0x1.0000000000000p+0 0x1.0000000000000p+0))
(assert_return (invoke "f64x2.pmax" (v128.const f64x2 0x0.0000000000001p-1022 0x0.0000000000001p-1022)
                                    (v128.const f64x2 -0x1p+0 -0x1p+0))
                                    (v128.const f64x2 0x0.0000000000001p-1022 0x0.0000000000001p-1022))
(assert_return (invoke "f64x2.pmax" (v128.const f64x2 0x0.0000000000001p-1022 0x0.0000000000001p-1022)
                                    (v128.const f64x2 0x1.921fb54442d18p+2 0x1.921fb54442d18p+2))
                                    (v128.const f64x2 0x1.921fb54442d18p+2 0x1.921fb54442d18p+2))
(assert_return (invoke "f64x2.pmax" (v128.const f64x2 0x0.0000000000001p-1022 0x0.0000000000001p-1022)
                                    (v128.const f64x2 -0x1.921fb54442d18p+2 -0x1.921fb54442d18p+2))
                                    (v128.const f64x2 0x0.0000000000001p-1022 0x0.0000000000001p-1022))
(assert_return (invoke "f64x2.pmax" (v128.const f64x2 0x0.0000000000001p-1022 0x0.0000000000001p-1022)
                                    (v128.const f64x2 0x1.fffffffffffffp+1023 0x1.fffffffffffffp+1023))
                                    (v128.const f64x2 0x1.fffffffffffffp+1023 0x1.fffffffffffffp+1023))
(assert_return (invoke "f64x2.pmax" (v128.const f64x2 0x0.0000000000001p-1022 0x0.0000000000001p-1022)
                                    (v128.const f64x2 -0x1.fffffffffffffp+1023 -0x1.fffffffffffffp+1023))
                                    (v128.const f64x2 0x0.0000000000001p-1022 0x0.0000000000001p-1022))
(assert_return (invoke "f64x2.pmax" (v128.const f64x2 0x0.0000000000001p-1022 0x0.0000000000001p-1022)
                                    (v128.const f64x2 0x0.0000000000001p-1022 0x0.0000000000001p-1022))
                                    (v128.const f64x2 0x0.0000000000001p-1022 0x0.0000000000001p-1022))
(assert_return (invoke "f64x2.pmax" (v128.const f64x2 0x0.0000000000001p-1022 0x0.0000000000001p-1022)
                                    (v128.const f64x2 0x0.0000000000001p-1022 0x0.0000000000001p-1022))
                                    (v128.const f64x2 0x0.0000000000001p-1022 0x0.0000000000001p-1022))
(assert_return (invoke "f64x2.pmax" (v128.const f64x2 0x0.0000000000001p-1022 0x0.0000000000001p-1022)
                                    (v128.const f64x2 inf inf))
                                    (v128.const f64x2 inf inf))
(assert_return (invoke "f64x2.pmax" (v128.const f64x2 0x0.0000000000001p-1022 0x0.0000000000001p-1022)
                                    (v128.const f64x2 -inf -inf))
                                    (v128.const f64x2 0x0.0000000000001p-1022 0x0.0000000000001p-1022))
(assert_return (invoke "f64x2.pmax" (v128.const f64x2 0x0.0000000000001p-1022 0x0.0000000000001p-1022)
                                    (v128.const f64x2 0123456789 0123456789))
                                    (v128.const f64x2 0x1.d6f3454000000p+26 0x1.d6f3454000000p+26))
(assert_return (invoke "f64x2.pmax" (v128.const f64x2 0x0.0000000000001p-1022 0x0.0000000000001p-1022)
                                    (v128.const f64x2 0123456789e019 0123456789e019))
                                    (v128.const f64x2 0x1.fe9af5b5e16fap+89 0x1.fe9af5b5e16fap+89))
(assert_return (invoke "f64x2.pmax" (v128.const f64x2 0x0.0000000000001p-1022 0x0.0000000000001p-1022)
                                    (v128.const f64x2 0123456789e+019 0123456789e+019))
                                    (v128.const f64x2 0x1.fe9af5b5e16fap+89 0x1.fe9af5b5e16fap+89))
(assert_return (invoke "f64x2.pmax" (v128.const f64x2 0x0.0000000000001p-1022 0x0.0000000000001p-1022)
                                    (v128.const f64x2 0123456789e-019 0123456789e-019))
                                    (v128.const f64x2 0x1.b25ffd62b4311p-37 0x1.b25ffd62b4311p-37))
(assert_return (invoke "f64x2.pmax" (v128.const f64x2 0x0.0000000000001p-1022 0x0.0000000000001p-1022)
                                    (v128.const f64x2 0123456789. 0123456789.))
                                    (v128.const f64x2 0x1.d6f3454000000p+26 0x1.d6f3454000000p+26))
(assert_return (invoke "f64x2.pmax" (v128.const f64x2 0x0.0000000000001p-1022 0x0.0000000000001p-1022)
                                    (v128.const f64x2 0123456789.e019 0123456789.e019))
                                    (v128.const f64x2 0x1.fe9af5b5e16fap+89 0x1.fe9af5b5e16fap+89))
(assert_return (invoke "f64x2.pmax" (v128.const f64x2 0x0.0000000000001p-1022 0x0.0000000000001p-1022)
                                    (v128.const f64x2 0123456789.e+019 0123456789.e+019))
                                    (v128.const f64x2 0x1.fe9af5b5e16fap+89 0x1.fe9af5b5e16fap+89))
(assert_return (invoke "f64x2.pmax" (v128.const f64x2 0x0.0000000000001p-1022 0x0.0000000000001p-1022)
                                    (v128.const f64x2 0123456789.e-019 0123456789.e-019))
                                    (v128.const f64x2 0x1.b25ffd62b4311p-37 0x1.b25ffd62b4311p-37))
(assert_return (invoke "f64x2.pmax" (v128.const f64x2 0x0.0000000000001p-1022 0x0.0000000000001p-1022)
                                    (v128.const f64x2 0123456789.0123456789 0123456789.0123456789))
                                    (v128.const f64x2 0x1.d6f34540ca458p+26 0x1.d6f34540ca458p+26))
(assert_return (invoke "f64x2.pmax" (v128.const f64x2 0x0.0000000000001p-1022 0x0.0000000000001p-1022)
                                    (v128.const f64x2 0123456789.0123456789e019 0123456789.0123456789e019))
                                    (v128.const f64x2 0x1.fe9af5b6bcbd5p+89 0x1.fe9af5b6bcbd5p+89))
(assert_return (invoke "f64x2.pmax" (v128.const f64x2 0x0.0000000000001p-1022 0x0.0000000000001p-1022)
                                    (v128.const f64x2 0123456789.0123456789e+019 0123456789.0123456789e+019))
                                    (v128.const f64x2 0x1.fe9af5b6bcbd5p+89 0x1.fe9af5b6bcbd5p+89))
(assert_return (invoke "f64x2.pmax" (v128.const f64x2 0x0.0000000000001p-1022 0x0.0000000000001p-1022)
                                    (v128.const f64x2 0123456789.0123456789e-019 0123456789.0123456789e-019))
                                    (v128.const f64x2 0x1.b25ffd636ec12p-37 0x1.b25ffd636ec12p-37))
(assert_return (invoke "f64x2.pmax" (v128.const f64x2 0x0.0000000000001p-1022 0x0.0000000000001p-1022)
                                    (v128.const f64x2 0x0123456789ABCDEFabcdef 0x0123456789ABCDEFabcdef))
                                    (v128.const f64x2 0x1.23456789abcdfp+80 0x1.23456789abcdfp+80))
(assert_return (invoke "f64x2.pmax" (v128.const f64x2 0x0.0000000000001p-1022 0x0.0000000000001p-1022)
                                    (v128.const f64x2 0x0123456789ABCDEFabcdefp019 0x0123456789ABCDEFabcdefp019))
                                    (v128.const f64x2 0x1.23456789abcdfp+99 0x1.23456789abcdfp+99))
(assert_return (invoke "f64x2.pmax" (v128.const f64x2 0x0.0000000000001p-1022 0x0.0000000000001p-1022)
                                    (v128.const f64x2 0x0123456789ABCDEFabcdefp+019 0x0123456789ABCDEFabcdefp+019))
                                    (v128.const f64x2 0x1.23456789abcdfp+99 0x1.23456789abcdfp+99))
(assert_return (invoke "f64x2.pmax" (v128.const f64x2 0x0.0000000000001p-1022 0x0.0000000000001p-1022)
                                    (v128.const f64x2 0x0123456789ABCDEFabcdefp-019 0x0123456789ABCDEFabcdefp-019))
                                    (v128.const f64x2 0x1.23456789abcdfp+61 0x1.23456789abcdfp+61))
(assert_return (invoke "f64x2.pmax" (v128.const f64x2 0x0.0000000000001p-1022 0x0.0000000000001p-1022)
                                    (v128.const f64x2 0x0123456789ABCDEFabcdef. 0x0123456789ABCDEFabcdef.))
                                    (v128.const f64x2 0x1.23456789abcdfp+80 0x1.23456789abcdfp+80))
(assert_return (invoke "f64x2.pmax" (v128.const f64x2 0x0.0000000000001p-1022 0x0.0000000000001p-1022)
                                    (v128.const f64x2 0x0123456789ABCDEFabcdef.p019 0x0123456789ABCDEFabcdef.p019))
                                    (v128.const f64x2 0x1.23456789abcdfp+99 0x1.23456789abcdfp+99))
(assert_return (invoke "f64x2.pmax" (v128.const f64x2 0x0.0000000000001p-1022 0x0.0000000000001p-1022)
                                    (v128.const f64x2 0x0123456789ABCDEFabcdef.p+019 0x0123456789ABCDEFabcdef.p+019))
                                    (v128.const f64x2 0x1.23456789abcdfp+99 0x1.23456789abcdfp+99))
(assert_return (invoke "f64x2.pmax" (v128.const f64x2 0x0.0000000000001p-1022 0x0.0000000000001p-1022)
                                    (v128.const f64x2 0x0123456789ABCDEFabcdef.p-019 0x0123456789ABCDEFabcdef.p-019))
                                    (v128.const f64x2 0x1.23456789abcdfp+61 0x1.23456789abcdfp+61))
(assert_return (invoke "f64x2.pmax" (v128.const f64x2 0x0.0000000000001p-1022 0x0.0000000000001p-1022)
                                    (v128.const f64x2 0x0123456789ABCDEFabcdef.0123456789ABCDEFabcdef 0x0123456789ABCDEFabcdef.0123456789ABCDEFabcdef))
                                    (v128.const f64x2 0x1.23456789abcdfp+80 0x1.23456789abcdfp+80))
(assert_return (invoke "f64x2.pmax" (v128.const f64x2 0x0.0000000000001p-1022 0x0.0000000000001p-1022)
                                    (v128.const f64x2 0x0123456789ABCDEFabcdef.0123456789ABCDEFabcdefp019 0x0123456789ABCDEFabcdef.0123456789ABCDEFabcdefp019))
                                    (v128.const f64x2 0x1.23456789abcdfp+99 0x1.23456789abcdfp+99))
(assert_return (invoke "f64x2.pmax" (v128.const f64x2 0x0.0000000000001p-1022 0x0.0000000000001p-1022)
                                    (v128.const f64x2 0x0123456789ABCDEFabcdef.0123456789ABCDEFabcdefp+019 0x0123456789ABCDEFabcdef.0123456789ABCDEFabcdefp+019))
                                    (v128.const f64x2 0x1.23456789abcdfp+99 0x1.23456789abcdfp+99))
(assert_return (invoke "f64x2.pmax" (v128.const f64x2 0x0.0000000000001p-1022 0x0.0000000000001p-1022)
                                    (v128.const f64x2 0x0123456789ABCDEFabcdef.0123456789ABCDEFabcdefp-019 0x0123456789ABCDEFabcdef.0123456789ABCDEFabcdefp-019))
                                    (v128.const f64x2 0x1.23456789abcdfp+61 0x1.23456789abcdfp+61))
(assert_return (invoke "f64x2.pmax" (v128.const f64x2 0x0.0000000000001p-1022 0x0.0000000000001p-1022)
                                    (v128.const f64x2 0x0p+0 0x0p+0))
                                    (v128.const f64x2 0x0.0000000000001p-1022 0x0.0000000000001p-1022))
(assert_return (invoke "f64x2.pmax" (v128.const f64x2 0x0.0000000000001p-1022 0x0.0000000000001p-1022)
                                    (v128.const f64x2 -0x0p+0 -0x0p+0))
                                    (v128.const f64x2 0x0.0000000000001p-1022 0x0.0000000000001p-1022))
(assert_return (invoke "f64x2.pmax" (v128.const f64x2 0x0.0000000000001p-1022 0x0.0000000000001p-1022)
                                    (v128.const f64x2 0x1p-1022 0x1p-1022))
                                    (v128.const f64x2 0x1.0000000000000p-1022 0x1.0000000000000p-1022))
(assert_return (invoke "f64x2.pmax" (v128.const f64x2 0x0.0000000000001p-1022 0x0.0000000000001p-1022)
                                    (v128.const f64x2 -0x1p-1022 -0x1p-1022))
                                    (v128.const f64x2 0x0.0000000000001p-1022 0x0.0000000000001p-1022))
(assert_return (invoke "f64x2.pmax" (v128.const f64x2 0x0.0000000000001p-1022 0x0.0000000000001p-1022)
                                    (v128.const f64x2 0x1p-1 0x1p-1))
                                    (v128.const f64x2 0x1.0000000000000p-1 0x1.0000000000000p-1))
(assert_return (invoke "f64x2.pmax" (v128.const f64x2 0x0.0000000000001p-1022 0x0.0000000000001p-1022)
                                    (v128.const f64x2 -0x1p-1 -0x1p-1))
                                    (v128.const f64x2 0x0.0000000000001p-1022 0x0.0000000000001p-1022))
(assert_return (invoke "f64x2.pmax" (v128.const f64x2 0x0.0000000000001p-1022 0x0.0000000000001p-1022)
                                    (v128.const f64x2 0x1p+0 0x1p+0))
                                    (v128.const f64x2 0x1.0000000000000p+0 0x1.0000000000000p+0))
(assert_return (invoke "f64x2.pmax" (v128.const f64x2 0x0.0000000000001p-1022 0x0.0000000000001p-1022)
                                    (v128.const f64x2 -0x1p+0 -0x1p+0))
                                    (v128.const f64x2 0x0.0000000000001p-1022 0x0.0000000000001p-1022))
(assert_return (invoke "f64x2.pmax" (v128.const f64x2 0x0.0000000000001p-1022 0x0.0000000000001p-1022)
                                    (v128.const f64x2 0x1.921fb54442d18p+2 0x1.921fb54442d18p+2))
                                    (v128.const f64x2 0x1.921fb54442d18p+2 0x1.921fb54442d18p+2))
(assert_return (invoke "f64x2.pmax" (v128.const f64x2 0x0.0000000000001p-1022 0x0.0000000000001p-1022)
                                    (v128.const f64x2 -0x1.921fb54442d18p+2 -0x1.921fb54442d18p+2))
                                    (v128.const f64x2 0x0.0000000000001p-1022 0x0.0000000000001p-1022))
(assert_return (invoke "f64x2.pmax" (v128.const f64x2 0x0.0000000000001p-1022 0x0.0000000000001p-1022)
                                    (v128.const f64x2 0x1.fffffffffffffp+1023 0x1.fffffffffffffp+1023))
                                    (v128.const f64x2 0x1.fffffffffffffp+1023 0x1.fffffffffffffp+1023))
(assert_return (invoke "f64x2.pmax" (v128.const f64x2 0x0.0000000000001p-1022 0x0.0000000000001p-1022)
                                    (v128.const f64x2 -0x1.fffffffffffffp+1023 -0x1.fffffffffffffp+1023))
                                    (v128.const f64x2 0x0.0000000000001p-1022 0x0.0000000000001p-1022))
(assert_return (invoke "f64x2.pmax" (v128.const f64x2 0x0.0000000000001p-1022 0x0.0000000000001p-1022)
                                    (v128.const f64x2 0x0.0000000000001p-1022 0x0.0000000000001p-1022))
                                    (v128.const f64x2 0x0.0000000000001p-1022 0x0.0000000000001p-1022))
(assert_return (invoke "f64x2.pmax" (v128.const f64x2 0x0.0000000000001p-1022 0x0.0000000000001p-1022)
                                    (v128.const f64x2 0x0.0000000000001p-1022 0x0.0000000000001p-1022))
                                    (v128.const f64x2 0x0.0000000000001p-1022 0x0.0000000000001p-1022))
(assert_return (invoke "f64x2.pmax" (v128.const f64x2 0x0.0000000000001p-1022 0x0.0000000000001p-1022)
                                    (v128.const f64x2 inf inf))
                                    (v128.const f64x2 inf inf))
(assert_return (invoke "f64x2.pmax" (v128.const f64x2 0x0.0000000000001p-1022 0x0.0000000000001p-1022)
                                    (v128.const f64x2 -inf -inf))
                                    (v128.const f64x2 0x0.0000000000001p-1022 0x0.0000000000001p-1022))
(assert_return (invoke "f64x2.pmax" (v128.const f64x2 0x0.0000000000001p-1022 0x0.0000000000001p-1022)
                                    (v128.const f64x2 0123456789 0123456789))
                                    (v128.const f64x2 0x1.d6f3454000000p+26 0x1.d6f3454000000p+26))
(assert_return (invoke "f64x2.pmax" (v128.const f64x2 0x0.0000000000001p-1022 0x0.0000000000001p-1022)
                                    (v128.const f64x2 0123456789e019 0123456789e019))
                                    (v128.const f64x2 0x1.fe9af5b5e16fap+89 0x1.fe9af5b5e16fap+89))
(assert_return (invoke "f64x2.pmax" (v128.const f64x2 0x0.0000000000001p-1022 0x0.0000000000001p-1022)
                                    (v128.const f64x2 0123456789e+019 0123456789e+019))
                                    (v128.const f64x2 0x1.fe9af5b5e16fap+89 0x1.fe9af5b5e16fap+89))
(assert_return (invoke "f64x2.pmax" (v128.const f64x2 0x0.0000000000001p-1022 0x0.0000000000001p-1022)
                                    (v128.const f64x2 0123456789e-019 0123456789e-019))
                                    (v128.const f64x2 0x1.b25ffd62b4311p-37 0x1.b25ffd62b4311p-37))
(assert_return (invoke "f64x2.pmax" (v128.const f64x2 0x0.0000000000001p-1022 0x0.0000000000001p-1022)
                                    (v128.const f64x2 0123456789. 0123456789.))
                                    (v128.const f64x2 0x1.d6f3454000000p+26 0x1.d6f3454000000p+26))
(assert_return (invoke "f64x2.pmax" (v128.const f64x2 0x0.0000000000001p-1022 0x0.0000000000001p-1022)
                                    (v128.const f64x2 0123456789.e019 0123456789.e019))
                                    (v128.const f64x2 0x1.fe9af5b5e16fap+89 0x1.fe9af5b5e16fap+89))
(assert_return (invoke "f64x2.pmax" (v128.const f64x2 0x0.0000000000001p-1022 0x0.0000000000001p-1022)
                                    (v128.const f64x2 0123456789.e+019 0123456789.e+019))
                                    (v128.const f64x2 0x1.fe9af5b5e16fap+89 0x1.fe9af5b5e16fap+89))
(assert_return (invoke "f64x2.pmax" (v128.const f64x2 0x0.0000000000001p-1022 0x0.0000000000001p-1022)
                                    (v128.const f64x2 0123456789.e-019 0123456789.e-019))
                                    (v128.const f64x2 0x1.b25ffd62b4311p-37 0x1.b25ffd62b4311p-37))
(assert_return (invoke "f64x2.pmax" (v128.const f64x2 0x0.0000000000001p-1022 0x0.0000000000001p-1022)
                                    (v128.const f64x2 0123456789.0123456789 0123456789.0123456789))
                                    (v128.const f64x2 0x1.d6f34540ca458p+26 0x1.d6f34540ca458p+26))
(assert_return (invoke "f64x2.pmax" (v128.const f64x2 0x0.0000000000001p-1022 0x0.0000000000001p-1022)
                                    (v128.const f64x2 0123456789.0123456789e019 0123456789.0123456789e019))
                                    (v128.const f64x2 0x1.fe9af5b6bcbd5p+89 0x1.fe9af5b6bcbd5p+89))
(assert_return (invoke "f64x2.pmax" (v128.const f64x2 0x0.0000000000001p-1022 0x0.0000000000001p-1022)
                                    (v128.const f64x2 0123456789.0123456789e+019 0123456789.0123456789e+019))
                                    (v128.const f64x2 0x1.fe9af5b6bcbd5p+89 0x1.fe9af5b6bcbd5p+89))
(assert_return (invoke "f64x2.pmax" (v128.const f64x2 0x0.0000000000001p-1022 0x0.0000000000001p-1022)
                                    (v128.const f64x2 0123456789.0123456789e-019 0123456789.0123456789e-019))
                                    (v128.const f64x2 0x1.b25ffd636ec12p-37 0x1.b25ffd636ec12p-37))
(assert_return (invoke "f64x2.pmax" (v128.const f64x2 0x0.0000000000001p-1022 0x0.0000000000001p-1022)
                                    (v128.const f64x2 0x0123456789ABCDEFabcdef 0x0123456789ABCDEFabcdef))
                                    (v128.const f64x2 0x1.23456789abcdfp+80 0x1.23456789abcdfp+80))
(assert_return (invoke "f64x2.pmax" (v128.const f64x2 0x0.0000000000001p-1022 0x0.0000000000001p-1022)
                                    (v128.const f64x2 0x0123456789ABCDEFabcdefp019 0x0123456789ABCDEFabcdefp019))
                                    (v128.const f64x2 0x1.23456789abcdfp+99 0x1.23456789abcdfp+99))
(assert_return (invoke "f64x2.pmax" (v128.const f64x2 0x0.0000000000001p-1022 0x0.0000000000001p-1022)
                                    (v128.const f64x2 0x0123456789ABCDEFabcdefp+019 0x0123456789ABCDEFabcdefp+019))
                                    (v128.const f64x2 0x1.23456789abcdfp+99 0x1.23456789abcdfp+99))
(assert_return (invoke "f64x2.pmax" (v128.const f64x2 0x0.0000000000001p-1022 0x0.0000000000001p-1022)
                                    (v128.const f64x2 0x0123456789ABCDEFabcdefp-019 0x0123456789ABCDEFabcdefp-019))
                                    (v128.const f64x2 0x1.23456789abcdfp+61 0x1.23456789abcdfp+61))
(assert_return (invoke "f64x2.pmax" (v128.const f64x2 0x0.0000000000001p-1022 0x0.0000000000001p-1022)
                                    (v128.const f64x2 0x0123456789ABCDEFabcdef. 0x0123456789ABCDEFabcdef.))
                                    (v128.const f64x2 0x1.23456789abcdfp+80 0x1.23456789abcdfp+80))
(assert_return (invoke "f64x2.pmax" (v128.const f64x2 0x0.0000000000001p-1022 0x0.0000000000001p-1022)
                                    (v128.const f64x2 0x0123456789ABCDEFabcdef.p019 0x0123456789ABCDEFabcdef.p019))
                                    (v128.const f64x2 0x1.23456789abcdfp+99 0x1.23456789abcdfp+99))
(assert_return (invoke "f64x2.pmax" (v128.const f64x2 0x0.0000000000001p-1022 0x0.0000000000001p-1022)
                                    (v128.const f64x2 0x0123456789ABCDEFabcdef.p+019 0x0123456789ABCDEFabcdef.p+019))
                                    (v128.const f64x2 0x1.23456789abcdfp+99 0x1.23456789abcdfp+99))
(assert_return (invoke "f64x2.pmax" (v128.const f64x2 0x0.0000000000001p-1022 0x0.0000000000001p-1022)
                                    (v128.const f64x2 0x0123456789ABCDEFabcdef.p-019 0x0123456789ABCDEFabcdef.p-019))
                                    (v128.const f64x2 0x1.23456789abcdfp+61 0x1.23456789abcdfp+61))
(assert_return (invoke "f64x2.pmax" (v128.const f64x2 0x0.0000000000001p-1022 0x0.0000000000001p-1022)
                                    (v128.const f64x2 0x0123456789ABCDEFabcdef.0123456789ABCDEFabcdef 0x0123456789ABCDEFabcdef.0123456789ABCDEFabcdef))
                                    (v128.const f64x2 0x1.23456789abcdfp+80 0x1.23456789abcdfp+80))
(assert_return (invoke "f64x2.pmax" (v128.const f64x2 0x0.0000000000001p-1022 0x0.0000000000001p-1022)
                                    (v128.const f64x2 0x0123456789ABCDEFabcdef.0123456789ABCDEFabcdefp019 0x0123456789ABCDEFabcdef.0123456789ABCDEFabcdefp019))
                                    (v128.const f64x2 0x1.23456789abcdfp+99 0x1.23456789abcdfp+99))
(assert_return (invoke "f64x2.pmax" (v128.const f64x2 0x0.0000000000001p-1022 0x0.0000000000001p-1022)
                                    (v128.const f64x2 0x0123456789ABCDEFabcdef.0123456789ABCDEFabcdefp+019 0x0123456789ABCDEFabcdef.0123456789ABCDEFabcdefp+019))
                                    (v128.const f64x2 0x1.23456789abcdfp+99 0x1.23456789abcdfp+99))
(assert_return (invoke "f64x2.pmax" (v128.const f64x2 0x0.0000000000001p-1022 0x0.0000000000001p-1022)
                                    (v128.const f64x2 0x0123456789ABCDEFabcdef.0123456789ABCDEFabcdefp-019 0x0123456789ABCDEFabcdef.0123456789ABCDEFabcdefp-019))
                                    (v128.const f64x2 0x1.23456789abcdfp+61 0x1.23456789abcdfp+61))
(assert_return (invoke "f64x2.pmax" (v128.const f64x2 inf inf)
                                    (v128.const f64x2 0x0p+0 0x0p+0))
                                    (v128.const f64x2 inf inf))
(assert_return (invoke "f64x2.pmax" (v128.const f64x2 inf inf)
                                    (v128.const f64x2 -0x0p+0 -0x0p+0))
                                    (v128.const f64x2 inf inf))
(assert_return (invoke "f64x2.pmax" (v128.const f64x2 inf inf)
                                    (v128.const f64x2 0x1p-1022 0x1p-1022))
                                    (v128.const f64x2 inf inf))
(assert_return (invoke "f64x2.pmax" (v128.const f64x2 inf inf)
                                    (v128.const f64x2 -0x1p-1022 -0x1p-1022))
                                    (v128.const f64x2 inf inf))
(assert_return (invoke "f64x2.pmax" (v128.const f64x2 inf inf)
                                    (v128.const f64x2 0x1p-1 0x1p-1))
                                    (v128.const f64x2 inf inf))
(assert_return (invoke "f64x2.pmax" (v128.const f64x2 inf inf)
                                    (v128.const f64x2 -0x1p-1 -0x1p-1))
                                    (v128.const f64x2 inf inf))
(assert_return (invoke "f64x2.pmax" (v128.const f64x2 inf inf)
                                    (v128.const f64x2 0x1p+0 0x1p+0))
                                    (v128.const f64x2 inf inf))
(assert_return (invoke "f64x2.pmax" (v128.const f64x2 inf inf)
                                    (v128.const f64x2 -0x1p+0 -0x1p+0))
                                    (v128.const f64x2 inf inf))
(assert_return (invoke "f64x2.pmax" (v128.const f64x2 inf inf)
                                    (v128.const f64x2 0x1.921fb54442d18p+2 0x1.921fb54442d18p+2))
                                    (v128.const f64x2 inf inf))
(assert_return (invoke "f64x2.pmax" (v128.const f64x2 inf inf)
                                    (v128.const f64x2 -0x1.921fb54442d18p+2 -0x1.921fb54442d18p+2))
                                    (v128.const f64x2 inf inf))
(assert_return (invoke "f64x2.pmax" (v128.const f64x2 inf inf)
                                    (v128.const f64x2 0x1.fffffffffffffp+1023 0x1.fffffffffffffp+1023))
                                    (v128.const f64x2 inf inf))
(assert_return (invoke "f64x2.pmax" (v128.const f64x2 inf inf)
                                    (v128.const f64x2 -0x1.fffffffffffffp+1023 -0x1.fffffffffffffp+1023))
                                    (v128.const f64x2 inf inf))
(assert_return (invoke "f64x2.pmax" (v128.const f64x2 inf inf)
                                    (v128.const f64x2 0x0.0000000000001p-1022 0x0.0000000000001p-1022))
                                    (v128.const f64x2 inf inf))
(assert_return (invoke "f64x2.pmax" (v128.const f64x2 inf inf)
                                    (v128.const f64x2 0x0.0000000000001p-1022 0x0.0000000000001p-1022))
                                    (v128.const f64x2 inf inf))
(assert_return (invoke "f64x2.pmax" (v128.const f64x2 inf inf)
                                    (v128.const f64x2 inf inf))
                                    (v128.const f64x2 inf inf))
(assert_return (invoke "f64x2.pmax" (v128.const f64x2 inf inf)
                                    (v128.const f64x2 -inf -inf))
                                    (v128.const f64x2 inf inf))
(assert_return (invoke "f64x2.pmax" (v128.const f64x2 inf inf)
                                    (v128.const f64x2 0123456789 0123456789))
                                    (v128.const f64x2 inf inf))
(assert_return (invoke "f64x2.pmax" (v128.const f64x2 inf inf)
                                    (v128.const f64x2 0123456789e019 0123456789e019))
                                    (v128.const f64x2 inf inf))
(assert_return (invoke "f64x2.pmax" (v128.const f64x2 inf inf)
                                    (v128.const f64x2 0123456789e+019 0123456789e+019))
                                    (v128.const f64x2 inf inf))
(assert_return (invoke "f64x2.pmax" (v128.const f64x2 inf inf)
                                    (v128.const f64x2 0123456789e-019 0123456789e-019))
                                    (v128.const f64x2 inf inf))
(assert_return (invoke "f64x2.pmax" (v128.const f64x2 inf inf)
                                    (v128.const f64x2 0123456789. 0123456789.))
                                    (v128.const f64x2 inf inf))
(assert_return (invoke "f64x2.pmax" (v128.const f64x2 inf inf)
                                    (v128.const f64x2 0123456789.e019 0123456789.e019))
                                    (v128.const f64x2 inf inf))
(assert_return (invoke "f64x2.pmax" (v128.const f64x2 inf inf)
                                    (v128.const f64x2 0123456789.e+019 0123456789.e+019))
                                    (v128.const f64x2 inf inf))
(assert_return (invoke "f64x2.pmax" (v128.const f64x2 inf inf)
                                    (v128.const f64x2 0123456789.e-019 0123456789.e-019))
                                    (v128.const f64x2 inf inf))
(assert_return (invoke "f64x2.pmax" (v128.const f64x2 inf inf)
                                    (v128.const f64x2 0123456789.0123456789 0123456789.0123456789))
                                    (v128.const f64x2 inf inf))
(assert_return (invoke "f64x2.pmax" (v128.const f64x2 inf inf)
                                    (v128.const f64x2 0123456789.0123456789e019 0123456789.0123456789e019))
                                    (v128.const f64x2 inf inf))
(assert_return (invoke "f64x2.pmax" (v128.const f64x2 inf inf)
                                    (v128.const f64x2 0123456789.0123456789e+019 0123456789.0123456789e+019))
                                    (v128.const f64x2 inf inf))
(assert_return (invoke "f64x2.pmax" (v128.const f64x2 inf inf)
                                    (v128.const f64x2 0123456789.0123456789e-019 0123456789.0123456789e-019))
                                    (v128.const f64x2 inf inf))
(assert_return (invoke "f64x2.pmax" (v128.const f64x2 inf inf)
                                    (v128.const f64x2 0x0123456789ABCDEFabcdef 0x0123456789ABCDEFabcdef))
                                    (v128.const f64x2 inf inf))
(assert_return (invoke "f64x2.pmax" (v128.const f64x2 inf inf)
                                    (v128.const f64x2 0x0123456789ABCDEFabcdefp019 0x0123456789ABCDEFabcdefp019))
                                    (v128.const f64x2 inf inf))
(assert_return (invoke "f64x2.pmax" (v128.const f64x2 inf inf)
                                    (v128.const f64x2 0x0123456789ABCDEFabcdefp+019 0x0123456789ABCDEFabcdefp+019))
                                    (v128.const f64x2 inf inf))
(assert_return (invoke "f64x2.pmax" (v128.const f64x2 inf inf)
                                    (v128.const f64x2 0x0123456789ABCDEFabcdefp-019 0x0123456789ABCDEFabcdefp-019))
                                    (v128.const f64x2 inf inf))
(assert_return (invoke "f64x2.pmax" (v128.const f64x2 inf inf)
                                    (v128.const f64x2 0x0123456789ABCDEFabcdef. 0x0123456789ABCDEFabcdef.))
                                    (v128.const f64x2 inf inf))
(assert_return (invoke "f64x2.pmax" (v128.const f64x2 inf inf)
                                    (v128.const f64x2 0x0123456789ABCDEFabcdef.p019 0x0123456789ABCDEFabcdef.p019))
                                    (v128.const f64x2 inf inf))
(assert_return (invoke "f64x2.pmax" (v128.const f64x2 inf inf)
                                    (v128.const f64x2 0x0123456789ABCDEFabcdef.p+019 0x0123456789ABCDEFabcdef.p+019))
                                    (v128.const f64x2 inf inf))
(assert_return (invoke "f64x2.pmax" (v128.const f64x2 inf inf)
                                    (v128.const f64x2 0x0123456789ABCDEFabcdef.p-019 0x0123456789ABCDEFabcdef.p-019))
                                    (v128.const f64x2 inf inf))
(assert_return (invoke "f64x2.pmax" (v128.const f64x2 inf inf)
                                    (v128.const f64x2 0x0123456789ABCDEFabcdef.0123456789ABCDEFabcdef 0x0123456789ABCDEFabcdef.0123456789ABCDEFabcdef))
                                    (v128.const f64x2 inf inf))
(assert_return (invoke "f64x2.pmax" (v128.const f64x2 inf inf)
                                    (v128.const f64x2 0x0123456789ABCDEFabcdef.0123456789ABCDEFabcdefp019 0x0123456789ABCDEFabcdef.0123456789ABCDEFabcdefp019))
                                    (v128.const f64x2 inf inf))
(assert_return (invoke "f64x2.pmax" (v128.const f64x2 inf inf)
                                    (v128.const f64x2 0x0123456789ABCDEFabcdef.0123456789ABCDEFabcdefp+019 0x0123456789ABCDEFabcdef.0123456789ABCDEFabcdefp+019))
                                    (v128.const f64x2 inf inf))
(assert_return (invoke "f64x2.pmax" (v128.const f64x2 inf inf)
                                    (v128.const f64x2 0x0123456789ABCDEFabcdef.0123456789ABCDEFabcdefp-019 0x0123456789ABCDEFabcdef.0123456789ABCDEFabcdefp-019))
                                    (v128.const f64x2 inf inf))
(assert_return (invoke "f64x2.pmax" (v128.const f64x2 -inf -inf)
                                    (v128.const f64x2 0x0p+0 0x0p+0))
                                    (v128.const f64x2 0x0.0p+0 0x0.0p+0))
(assert_return (invoke "f64x2.pmax" (v128.const f64x2 -inf -inf)
                                    (v128.const f64x2 -0x0p+0 -0x0p+0))
                                    (v128.const f64x2 -0x0.0p+0 -0x0.0p+0))
(assert_return (invoke "f64x2.pmax" (v128.const f64x2 -inf -inf)
                                    (v128.const f64x2 0x1p-1022 0x1p-1022))
                                    (v128.const f64x2 0x1.0000000000000p-1022 0x1.0000000000000p-1022))
(assert_return (invoke "f64x2.pmax" (v128.const f64x2 -inf -inf)
                                    (v128.const f64x2 -0x1p-1022 -0x1p-1022))
                                    (v128.const f64x2 -0x1.0000000000000p-1022 -0x1.0000000000000p-1022))
(assert_return (invoke "f64x2.pmax" (v128.const f64x2 -inf -inf)
                                    (v128.const f64x2 0x1p-1 0x1p-1))
                                    (v128.const f64x2 0x1.0000000000000p-1 0x1.0000000000000p-1))
(assert_return (invoke "f64x2.pmax" (v128.const f64x2 -inf -inf)
                                    (v128.const f64x2 -0x1p-1 -0x1p-1))
                                    (v128.const f64x2 -0x1.0000000000000p-1 -0x1.0000000000000p-1))
(assert_return (invoke "f64x2.pmax" (v128.const f64x2 -inf -inf)
                                    (v128.const f64x2 0x1p+0 0x1p+0))
                                    (v128.const f64x2 0x1.0000000000000p+0 0x1.0000000000000p+0))
(assert_return (invoke "f64x2.pmax" (v128.const f64x2 -inf -inf)
                                    (v128.const f64x2 -0x1p+0 -0x1p+0))
                                    (v128.const f64x2 -0x1.0000000000000p+0 -0x1.0000000000000p+0))
(assert_return (invoke "f64x2.pmax" (v128.const f64x2 -inf -inf)
                                    (v128.const f64x2 0x1.921fb54442d18p+2 0x1.921fb54442d18p+2))
                                    (v128.const f64x2 0x1.921fb54442d18p+2 0x1.921fb54442d18p+2))
(assert_return (invoke "f64x2.pmax" (v128.const f64x2 -inf -inf)
                                    (v128.const f64x2 -0x1.921fb54442d18p+2 -0x1.921fb54442d18p+2))
                                    (v128.const f64x2 -0x1.921fb54442d18p+2 -0x1.921fb54442d18p+2))
(assert_return (invoke "f64x2.pmax" (v128.const f64x2 -inf -inf)
                                    (v128.const f64x2 0x1.fffffffffffffp+1023 0x1.fffffffffffffp+1023))
                                    (v128.const f64x2 0x1.fffffffffffffp+1023 0x1.fffffffffffffp+1023))
(assert_return (invoke "f64x2.pmax" (v128.const f64x2 -inf -inf)
                                    (v128.const f64x2 -0x1.fffffffffffffp+1023 -0x1.fffffffffffffp+1023))
                                    (v128.const f64x2 -0x1.fffffffffffffp+1023 -0x1.fffffffffffffp+1023))
(assert_return (invoke "f64x2.pmax" (v128.const f64x2 -inf -inf)
                                    (v128.const f64x2 0x0.0000000000001p-1022 0x0.0000000000001p-1022))
                                    (v128.const f64x2 0x0.0000000000001p-1022 0x0.0000000000001p-1022))
(assert_return (invoke "f64x2.pmax" (v128.const f64x2 -inf -inf)
                                    (v128.const f64x2 0x0.0000000000001p-1022 0x0.0000000000001p-1022))
                                    (v128.const f64x2 0x0.0000000000001p-1022 0x0.0000000000001p-1022))
(assert_return (invoke "f64x2.pmax" (v128.const f64x2 -inf -inf)
                                    (v128.const f64x2 inf inf))
                                    (v128.const f64x2 inf inf))
(assert_return (invoke "f64x2.pmax" (v128.const f64x2 -inf -inf)
                                    (v128.const f64x2 -inf -inf))
                                    (v128.const f64x2 -inf -inf))
(assert_return (invoke "f64x2.pmax" (v128.const f64x2 -inf -inf)
                                    (v128.const f64x2 0123456789 0123456789))
                                    (v128.const f64x2 0x1.d6f3454000000p+26 0x1.d6f3454000000p+26))
(assert_return (invoke "f64x2.pmax" (v128.const f64x2 -inf -inf)
                                    (v128.const f64x2 0123456789e019 0123456789e019))
                                    (v128.const f64x2 0x1.fe9af5b5e16fap+89 0x1.fe9af5b5e16fap+89))
(assert_return (invoke "f64x2.pmax" (v128.const f64x2 -inf -inf)
                                    (v128.const f64x2 0123456789e+019 0123456789e+019))
                                    (v128.const f64x2 0x1.fe9af5b5e16fap+89 0x1.fe9af5b5e16fap+89))
(assert_return (invoke "f64x2.pmax" (v128.const f64x2 -inf -inf)
                                    (v128.const f64x2 0123456789e-019 0123456789e-019))
                                    (v128.const f64x2 0x1.b25ffd62b4311p-37 0x1.b25ffd62b4311p-37))
(assert_return (invoke "f64x2.pmax" (v128.const f64x2 -inf -inf)
                                    (v128.const f64x2 0123456789. 0123456789.))
                                    (v128.const f64x2 0x1.d6f3454000000p+26 0x1.d6f3454000000p+26))
(assert_return (invoke "f64x2.pmax" (v128.const f64x2 -inf -inf)
                                    (v128.const f64x2 0123456789.e019 0123456789.e019))
                                    (v128.const f64x2 0x1.fe9af5b5e16fap+89 0x1.fe9af5b5e16fap+89))
(assert_return (invoke "f64x2.pmax" (v128.const f64x2 -inf -inf)
                                    (v128.const f64x2 0123456789.e+019 0123456789.e+019))
                                    (v128.const f64x2 0x1.fe9af5b5e16fap+89 0x1.fe9af5b5e16fap+89))
(assert_return (invoke "f64x2.pmax" (v128.const f64x2 -inf -inf)
                                    (v128.const f64x2 0123456789.e-019 0123456789.e-019))
                                    (v128.const f64x2 0x1.b25ffd62b4311p-37 0x1.b25ffd62b4311p-37))
(assert_return (invoke "f64x2.pmax" (v128.const f64x2 -inf -inf)
                                    (v128.const f64x2 0123456789.0123456789 0123456789.0123456789))
                                    (v128.const f64x2 0x1.d6f34540ca458p+26 0x1.d6f34540ca458p+26))
(assert_return (invoke "f64x2.pmax" (v128.const f64x2 -inf -inf)
                                    (v128.const f64x2 0123456789.0123456789e019 0123456789.0123456789e019))
                                    (v128.const f64x2 0x1.fe9af5b6bcbd5p+89 0x1.fe9af5b6bcbd5p+89))
(assert_return (invoke "f64x2.pmax" (v128.const f64x2 -inf -inf)
                                    (v128.const f64x2 0123456789.0123456789e+019 0123456789.0123456789e+019))
                                    (v128.const f64x2 0x1.fe9af5b6bcbd5p+89 0x1.fe9af5b6bcbd5p+89))
(assert_return (invoke "f64x2.pmax" (v128.const f64x2 -inf -inf)
                                    (v128.const f64x2 0123456789.0123456789e-019 0123456789.0123456789e-019))
                                    (v128.const f64x2 0x1.b25ffd636ec12p-37 0x1.b25ffd636ec12p-37))
(assert_return (invoke "f64x2.pmax" (v128.const f64x2 -inf -inf)
                                    (v128.const f64x2 0x0123456789ABCDEFabcdef 0x0123456789ABCDEFabcdef))
                                    (v128.const f64x2 0x1.23456789abcdfp+80 0x1.23456789abcdfp+80))
(assert_return (invoke "f64x2.pmax" (v128.const f64x2 -inf -inf)
                                    (v128.const f64x2 0x0123456789ABCDEFabcdefp019 0x0123456789ABCDEFabcdefp019))
                                    (v128.const f64x2 0x1.23456789abcdfp+99 0x1.23456789abcdfp+99))
(assert_return (invoke "f64x2.pmax" (v128.const f64x2 -inf -inf)
                                    (v128.const f64x2 0x0123456789ABCDEFabcdefp+019 0x0123456789ABCDEFabcdefp+019))
                                    (v128.const f64x2 0x1.23456789abcdfp+99 0x1.23456789abcdfp+99))
(assert_return (invoke "f64x2.pmax" (v128.const f64x2 -inf -inf)
                                    (v128.const f64x2 0x0123456789ABCDEFabcdefp-019 0x0123456789ABCDEFabcdefp-019))
                                    (v128.const f64x2 0x1.23456789abcdfp+61 0x1.23456789abcdfp+61))
(assert_return (invoke "f64x2.pmax" (v128.const f64x2 -inf -inf)
                                    (v128.const f64x2 0x0123456789ABCDEFabcdef. 0x0123456789ABCDEFabcdef.))
                                    (v128.const f64x2 0x1.23456789abcdfp+80 0x1.23456789abcdfp+80))
(assert_return (invoke "f64x2.pmax" (v128.const f64x2 -inf -inf)
                                    (v128.const f64x2 0x0123456789ABCDEFabcdef.p019 0x0123456789ABCDEFabcdef.p019))
                                    (v128.const f64x2 0x1.23456789abcdfp+99 0x1.23456789abcdfp+99))
(assert_return (invoke "f64x2.pmax" (v128.const f64x2 -inf -inf)
                                    (v128.const f64x2 0x0123456789ABCDEFabcdef.p+019 0x0123456789ABCDEFabcdef.p+019))
                                    (v128.const f64x2 0x1.23456789abcdfp+99 0x1.23456789abcdfp+99))
(assert_return (invoke "f64x2.pmax" (v128.const f64x2 -inf -inf)
                                    (v128.const f64x2 0x0123456789ABCDEFabcdef.p-019 0x0123456789ABCDEFabcdef.p-019))
                                    (v128.const f64x2 0x1.23456789abcdfp+61 0x1.23456789abcdfp+61))
(assert_return (invoke "f64x2.pmax" (v128.const f64x2 -inf -inf)
                                    (v128.const f64x2 0x0123456789ABCDEFabcdef.0123456789ABCDEFabcdef 0x0123456789ABCDEFabcdef.0123456789ABCDEFabcdef))
                                    (v128.const f64x2 0x1.23456789abcdfp+80 0x1.23456789abcdfp+80))
(assert_return (invoke "f64x2.pmax" (v128.const f64x2 -inf -inf)
                                    (v128.const f64x2 0x0123456789ABCDEFabcdef.0123456789ABCDEFabcdefp019 0x0123456789ABCDEFabcdef.0123456789ABCDEFabcdefp019))
                                    (v128.const f64x2 0x1.23456789abcdfp+99 0x1.23456789abcdfp+99))
(assert_return (invoke "f64x2.pmax" (v128.const f64x2 -inf -inf)
                                    (v128.const f64x2 0x0123456789ABCDEFabcdef.0123456789ABCDEFabcdefp+019 0x0123456789ABCDEFabcdef.0123456789ABCDEFabcdefp+019))
                                    (v128.const f64x2 0x1.23456789abcdfp+99 0x1.23456789abcdfp+99))
(assert_return (invoke "f64x2.pmax" (v128.const f64x2 -inf -inf)
                                    (v128.const f64x2 0x0123456789ABCDEFabcdef.0123456789ABCDEFabcdefp-019 0x0123456789ABCDEFabcdef.0123456789ABCDEFabcdefp-019))
                                    (v128.const f64x2 0x1.23456789abcdfp+61 0x1.23456789abcdfp+61))
(assert_return (invoke "f64x2.pmax" (v128.const f64x2 0123456789 0123456789)
                                    (v128.const f64x2 0x0p+0 0x0p+0))
                                    (v128.const f64x2 0x1.d6f3454000000p+26 0x1.d6f3454000000p+26))
(assert_return (invoke "f64x2.pmax" (v128.const f64x2 0123456789 0123456789)
                                    (v128.const f64x2 -0x0p+0 -0x0p+0))
                                    (v128.const f64x2 0x1.d6f3454000000p+26 0x1.d6f3454000000p+26))
(assert_return (invoke "f64x2.pmax" (v128.const f64x2 0123456789 0123456789)
                                    (v128.const f64x2 0x1p-1022 0x1p-1022))
                                    (v128.const f64x2 0x1.d6f3454000000p+26 0x1.d6f3454000000p+26))
(assert_return (invoke "f64x2.pmax" (v128.const f64x2 0123456789 0123456789)
                                    (v128.const f64x2 -0x1p-1022 -0x1p-1022))
                                    (v128.const f64x2 0x1.d6f3454000000p+26 0x1.d6f3454000000p+26))
(assert_return (invoke "f64x2.pmax" (v128.const f64x2 0123456789 0123456789)
                                    (v128.const f64x2 0x1p-1 0x1p-1))
                                    (v128.const f64x2 0x1.d6f3454000000p+26 0x1.d6f3454000000p+26))
(assert_return (invoke "f64x2.pmax" (v128.const f64x2 0123456789 0123456789)
                                    (v128.const f64x2 -0x1p-1 -0x1p-1))
                                    (v128.const f64x2 0x1.d6f3454000000p+26 0x1.d6f3454000000p+26))
(assert_return (invoke "f64x2.pmax" (v128.const f64x2 0123456789 0123456789)
                                    (v128.const f64x2 0x1p+0 0x1p+0))
                                    (v128.const f64x2 0x1.d6f3454000000p+26 0x1.d6f3454000000p+26))
(assert_return (invoke "f64x2.pmax" (v128.const f64x2 0123456789 0123456789)
                                    (v128.const f64x2 -0x1p+0 -0x1p+0))
                                    (v128.const f64x2 0x1.d6f3454000000p+26 0x1.d6f3454000000p+26))
(assert_return (invoke "f64x2.pmax" (v128.const f64x2 0123456789 0123456789)
                                    (v128.const f64x2 0x1.921fb54442d18p+2 0x1.921fb54442d18p+2))
                                    (v128.const f64x2 0x1.d6f3454000000p+26 0x1.d6f3454000000p+26))
(assert_return (invoke "f64x2.pmax" (v128.const f64x2 0123456789 0123456789)
                                    (v128.const f64x2 -0x1.921fb54442d18p+2 -0x1.921fb54442d18p+2))
                                    (v128.const f64x2 0x1.d6f3454000000p+26 0x1.d6f3454000000p+26))
(assert_return (invoke "f64x2.pmax" (v128.const f64x2 0123456789 0123456789)
                                    (v128.const f64x2 0x1.fffffffffffffp+1023 0x1.fffffffffffffp+1023))
                                    (v128.const f64x2 0x1.fffffffffffffp+1023 0x1.fffffffffffffp+1023))
(assert_return (invoke "f64x2.pmax" (v128.const f64x2 0123456789 0123456789)
                                    (v128.const f64x2 -0x1.fffffffffffffp+1023 -0x1.fffffffffffffp+1023))
                                    (v128.const f64x2 0x1.d6f3454000000p+26 0x1.d6f3454000000p+26))
(assert_return (invoke "f64x2.pmax" (v128.const f64x2 0123456789 0123456789)
                                    (v128.const f64x2 0x0.0000000000001p-1022 0x0.0000000000001p-1022))
                                    (v128.const f64x2 0x1.d6f3454000000p+26 0x1.d6f3454000000p+26))
(assert_return (invoke "f64x2.pmax" (v128.const f64x2 0123456789 0123456789)
                                    (v128.const f64x2 0x0.0000000000001p-1022 0x0.0000000000001p-1022))
                                    (v128.const f64x2 0x1.d6f3454000000p+26 0x1.d6f3454000000p+26))
(assert_return (invoke "f64x2.pmax" (v128.const f64x2 0123456789 0123456789)
                                    (v128.const f64x2 inf inf))
                                    (v128.const f64x2 inf inf))
(assert_return (invoke "f64x2.pmax" (v128.const f64x2 0123456789 0123456789)
                                    (v128.const f64x2 -inf -inf))
                                    (v128.const f64x2 0x1.d6f3454000000p+26 0x1.d6f3454000000p+26))
(assert_return (invoke "f64x2.pmax" (v128.const f64x2 0123456789 0123456789)
                                    (v128.const f64x2 0123456789 0123456789))
                                    (v128.const f64x2 0x1.d6f3454000000p+26 0x1.d6f3454000000p+26))
(assert_return (invoke "f64x2.pmax" (v128.const f64x2 0123456789 0123456789)
                                    (v128.const f64x2 0123456789e019 0123456789e019))
                                    (v128.const f64x2 0x1.fe9af5b5e16fap+89 0x1.fe9af5b5e16fap+89))
(assert_return (invoke "f64x2.pmax" (v128.const f64x2 0123456789 0123456789)
                                    (v128.const f64x2 0123456789e+019 0123456789e+019))
                                    (v128.const f64x2 0x1.fe9af5b5e16fap+89 0x1.fe9af5b5e16fap+89))
(assert_return (invoke "f64x2.pmax" (v128.const f64x2 0123456789 0123456789)
                                    (v128.const f64x2 0123456789e-019 0123456789e-019))
                                    (v128.const f64x2 0x1.d6f3454000000p+26 0x1.d6f3454000000p+26))
(assert_return (invoke "f64x2.pmax" (v128.const f64x2 0123456789 0123456789)
                                    (v128.const f64x2 0123456789. 0123456789.))
                                    (v128.const f64x2 0x1.d6f3454000000p+26 0x1.d6f3454000000p+26))
(assert_return (invoke "f64x2.pmax" (v128.const f64x2 0123456789 0123456789)
                                    (v128.const f64x2 0123456789.e019 0123456789.e019))
                                    (v128.const f64x2 0x1.fe9af5b5e16fap+89 0x1.fe9af5b5e16fap+89))
(assert_return (invoke "f64x2.pmax" (v128.const f64x2 0123456789 0123456789)
                                    (v128.const f64x2 0123456789.e+019 0123456789.e+019))
                                    (v128.const f64x2 0x1.fe9af5b5e16fap+89 0x1.fe9af5b5e16fap+89))
(assert_return (invoke "f64x2.pmax" (v128.const f64x2 0123456789 0123456789)
                                    (v128.const f64x2 0123456789.e-019 0123456789.e-019))
                                    (v128.const f64x2 0x1.d6f3454000000p+26 0x1.d6f3454000000p+26))
(assert_return (invoke "f64x2.pmax" (v128.const f64x2 0123456789 0123456789)
                                    (v128.const f64x2 0123456789.0123456789 0123456789.0123456789))
                                    (v128.const f64x2 0x1.d6f34540ca458p+26 0x1.d6f34540ca458p+26))
(assert_return (invoke "f64x2.pmax" (v128.const f64x2 0123456789 0123456789)
                                    (v128.const f64x2 0123456789.0123456789e019 0123456789.0123456789e019))
                                    (v128.const f64x2 0x1.fe9af5b6bcbd5p+89 0x1.fe9af5b6bcbd5p+89))
(assert_return (invoke "f64x2.pmax" (v128.const f64x2 0123456789 0123456789)
                                    (v128.const f64x2 0123456789.0123456789e+019 0123456789.0123456789e+019))
                                    (v128.const f64x2 0x1.fe9af5b6bcbd5p+89 0x1.fe9af5b6bcbd5p+89))
(assert_return (invoke "f64x2.pmax" (v128.const f64x2 0123456789 0123456789)
                                    (v128.const f64x2 0123456789.0123456789e-019 0123456789.0123456789e-019))
                                    (v128.const f64x2 0x1.d6f3454000000p+26 0x1.d6f3454000000p+26))
(assert_return (invoke "f64x2.pmax" (v128.const f64x2 0123456789 0123456789)
                                    (v128.const f64x2 0x0123456789ABCDEFabcdef 0x0123456789ABCDEFabcdef))
                                    (v128.const f64x2 0x1.23456789abcdfp+80 0x1.23456789abcdfp+80))
(assert_return (invoke "f64x2.pmax" (v128.const f64x2 0123456789 0123456789)
                                    (v128.const f64x2 0x0123456789ABCDEFabcdefp019 0x0123456789ABCDEFabcdefp019))
                                    (v128.const f64x2 0x1.23456789abcdfp+99 0x1.23456789abcdfp+99))
(assert_return (invoke "f64x2.pmax" (v128.const f64x2 0123456789 0123456789)
                                    (v128.const f64x2 0x0123456789ABCDEFabcdefp+019 0x0123456789ABCDEFabcdefp+019))
                                    (v128.const f64x2 0x1.23456789abcdfp+99 0x1.23456789abcdfp+99))
(assert_return (invoke "f64x2.pmax" (v128.const f64x2 0123456789 0123456789)
                                    (v128.const f64x2 0x0123456789ABCDEFabcdefp-019 0x0123456789ABCDEFabcdefp-019))
                                    (v128.const f64x2 0x1.23456789abcdfp+61 0x1.23456789abcdfp+61))
(assert_return (invoke "f64x2.pmax" (v128.const f64x2 0123456789 0123456789)
                                    (v128.const f64x2 0x0123456789ABCDEFabcdef. 0x0123456789ABCDEFabcdef.))
                                    (v128.const f64x2 0x1.23456789abcdfp+80 0x1.23456789abcdfp+80))
(assert_return (invoke "f64x2.pmax" (v128.const f64x2 0123456789 0123456789)
                                    (v128.const f64x2 0x0123456789ABCDEFabcdef.p019 0x0123456789ABCDEFabcdef.p019))
                                    (v128.const f64x2 0x1.23456789abcdfp+99 0x1.23456789abcdfp+99))
(assert_return (invoke "f64x2.pmax" (v128.const f64x2 0123456789 0123456789)
                                    (v128.const f64x2 0x0123456789ABCDEFabcdef.p+019 0x0123456789ABCDEFabcdef.p+019))
                                    (v128.const f64x2 0x1.23456789abcdfp+99 0x1.23456789abcdfp+99))
(assert_return (invoke "f64x2.pmax" (v128.const f64x2 0123456789 0123456789)
                                    (v128.const f64x2 0x0123456789ABCDEFabcdef.p-019 0x0123456789ABCDEFabcdef.p-019))
                                    (v128.const f64x2 0x1.23456789abcdfp+61 0x1.23456789abcdfp+61))
(assert_return (invoke "f64x2.pmax" (v128.const f64x2 0123456789 0123456789)
                                    (v128.const f64x2 0x0123456789ABCDEFabcdef.0123456789ABCDEFabcdef 0x0123456789ABCDEFabcdef.0123456789ABCDEFabcdef))
                                    (v128.const f64x2 0x1.23456789abcdfp+80 0x1.23456789abcdfp+80))
(assert_return (invoke "f64x2.pmax" (v128.const f64x2 0123456789 0123456789)
                                    (v128.const f64x2 0x0123456789ABCDEFabcdef.0123456789ABCDEFabcdefp019 0x0123456789ABCDEFabcdef.0123456789ABCDEFabcdefp019))
                                    (v128.const f64x2 0x1.23456789abcdfp+99 0x1.23456789abcdfp+99))
(assert_return (invoke "f64x2.pmax" (v128.const f64x2 0123456789 0123456789)
                                    (v128.const f64x2 0x0123456789ABCDEFabcdef.0123456789ABCDEFabcdefp+019 0x0123456789ABCDEFabcdef.0123456789ABCDEFabcdefp+019))
                                    (v128.const f64x2 0x1.23456789abcdfp+99 0x1.23456789abcdfp+99))
(assert_return (invoke "f64x2.pmax" (v128.const f64x2 0123456789 0123456789)
                                    (v128.const f64x2 0x0123456789ABCDEFabcdef.0123456789ABCDEFabcdefp-019 0x0123456789ABCDEFabcdef.0123456789ABCDEFabcdefp-019))
                                    (v128.const f64x2 0x1.23456789abcdfp+61 0x1.23456789abcdfp+61))
(assert_return (invoke "f64x2.pmax" (v128.const f64x2 0123456789e019 0123456789e019)
                                    (v128.const f64x2 0x0p+0 0x0p+0))
                                    (v128.const f64x2 0x1.fe9af5b5e16fap+89 0x1.fe9af5b5e16fap+89))
(assert_return (invoke "f64x2.pmax" (v128.const f64x2 0123456789e019 0123456789e019)
                                    (v128.const f64x2 -0x0p+0 -0x0p+0))
                                    (v128.const f64x2 0x1.fe9af5b5e16fap+89 0x1.fe9af5b5e16fap+89))
(assert_return (invoke "f64x2.pmax" (v128.const f64x2 0123456789e019 0123456789e019)
                                    (v128.const f64x2 0x1p-1022 0x1p-1022))
                                    (v128.const f64x2 0x1.fe9af5b5e16fap+89 0x1.fe9af5b5e16fap+89))
(assert_return (invoke "f64x2.pmax" (v128.const f64x2 0123456789e019 0123456789e019)
                                    (v128.const f64x2 -0x1p-1022 -0x1p-1022))
                                    (v128.const f64x2 0x1.fe9af5b5e16fap+89 0x1.fe9af5b5e16fap+89))
(assert_return (invoke "f64x2.pmax" (v128.const f64x2 0123456789e019 0123456789e019)
                                    (v128.const f64x2 0x1p-1 0x1p-1))
                                    (v128.const f64x2 0x1.fe9af5b5e16fap+89 0x1.fe9af5b5e16fap+89))
(assert_return (invoke "f64x2.pmax" (v128.const f64x2 0123456789e019 0123456789e019)
                                    (v128.const f64x2 -0x1p-1 -0x1p-1))
                                    (v128.const f64x2 0x1.fe9af5b5e16fap+89 0x1.fe9af5b5e16fap+89))
(assert_return (invoke "f64x2.pmax" (v128.const f64x2 0123456789e019 0123456789e019)
                                    (v128.const f64x2 0x1p+0 0x1p+0))
                                    (v128.const f64x2 0x1.fe9af5b5e16fap+89 0x1.fe9af5b5e16fap+89))
(assert_return (invoke "f64x2.pmax" (v128.const f64x2 0123456789e019 0123456789e019)
                                    (v128.const f64x2 -0x1p+0 -0x1p+0))
                                    (v128.const f64x2 0x1.fe9af5b5e16fap+89 0x1.fe9af5b5e16fap+89))
(assert_return (invoke "f64x2.pmax" (v128.const f64x2 0123456789e019 0123456789e019)
                                    (v128.const f64x2 0x1.921fb54442d18p+2 0x1.921fb54442d18p+2))
                                    (v128.const f64x2 0x1.fe9af5b5e16fap+89 0x1.fe9af5b5e16fap+89))
(assert_return (invoke "f64x2.pmax" (v128.const f64x2 0123456789e019 0123456789e019)
                                    (v128.const f64x2 -0x1.921fb54442d18p+2 -0x1.921fb54442d18p+2))
                                    (v128.const f64x2 0x1.fe9af5b5e16fap+89 0x1.fe9af5b5e16fap+89))
(assert_return (invoke "f64x2.pmax" (v128.const f64x2 0123456789e019 0123456789e019)
                                    (v128.const f64x2 0x1.fffffffffffffp+1023 0x1.fffffffffffffp+1023))
                                    (v128.const f64x2 0x1.fffffffffffffp+1023 0x1.fffffffffffffp+1023))
(assert_return (invoke "f64x2.pmax" (v128.const f64x2 0123456789e019 0123456789e019)
                                    (v128.const f64x2 -0x1.fffffffffffffp+1023 -0x1.fffffffffffffp+1023))
                                    (v128.const f64x2 0x1.fe9af5b5e16fap+89 0x1.fe9af5b5e16fap+89))
(assert_return (invoke "f64x2.pmax" (v128.const f64x2 0123456789e019 0123456789e019)
                                    (v128.const f64x2 0x0.0000000000001p-1022 0x0.0000000000001p-1022))
                                    (v128.const f64x2 0x1.fe9af5b5e16fap+89 0x1.fe9af5b5e16fap+89))
(assert_return (invoke "f64x2.pmax" (v128.const f64x2 0123456789e019 0123456789e019)
                                    (v128.const f64x2 0x0.0000000000001p-1022 0x0.0000000000001p-1022))
                                    (v128.const f64x2 0x1.fe9af5b5e16fap+89 0x1.fe9af5b5e16fap+89))
(assert_return (invoke "f64x2.pmax" (v128.const f64x2 0123456789e019 0123456789e019)
                                    (v128.const f64x2 inf inf))
                                    (v128.const f64x2 inf inf))
(assert_return (invoke "f64x2.pmax" (v128.const f64x2 0123456789e019 0123456789e019)
                                    (v128.const f64x2 -inf -inf))
                                    (v128.const f64x2 0x1.fe9af5b5e16fap+89 0x1.fe9af5b5e16fap+89))
(assert_return (invoke "f64x2.pmax" (v128.const f64x2 0123456789e019 0123456789e019)
                                    (v128.const f64x2 0123456789 0123456789))
                                    (v128.const f64x2 0x1.fe9af5b5e16fap+89 0x1.fe9af5b5e16fap+89))
(assert_return (invoke "f64x2.pmax" (v128.const f64x2 0123456789e019 0123456789e019)
                                    (v128.const f64x2 0123456789e019 0123456789e019))
                                    (v128.const f64x2 0x1.fe9af5b5e16fap+89 0x1.fe9af5b5e16fap+89))
(assert_return (invoke "f64x2.pmax" (v128.const f64x2 0123456789e019 0123456789e019)
                                    (v128.const f64x2 0123456789e+019 0123456789e+019))
                                    (v128.const f64x2 0x1.fe9af5b5e16fap+89 0x1.fe9af5b5e16fap+89))
(assert_return (invoke "f64x2.pmax" (v128.const f64x2 0123456789e019 0123456789e019)
                                    (v128.const f64x2 0123456789e-019 0123456789e-019))
                                    (v128.const f64x2 0x1.fe9af5b5e16fap+89 0x1.fe9af5b5e16fap+89))
(assert_return (invoke "f64x2.pmax" (v128.const f64x2 0123456789e019 0123456789e019)
                                    (v128.const f64x2 0123456789. 0123456789.))
                                    (v128.const f64x2 0x1.fe9af5b5e16fap+89 0x1.fe9af5b5e16fap+89))
(assert_return (invoke "f64x2.pmax" (v128.const f64x2 0123456789e019 0123456789e019)
                                    (v128.const f64x2 0123456789.e019 0123456789.e019))
                                    (v128.const f64x2 0x1.fe9af5b5e16fap+89 0x1.fe9af5b5e16fap+89))
(assert_return (invoke "f64x2.pmax" (v128.const f64x2 0123456789e019 0123456789e019)
                                    (v128.const f64x2 0123456789.e+019 0123456789.e+019))
                                    (v128.const f64x2 0x1.fe9af5b5e16fap+89 0x1.fe9af5b5e16fap+89))
(assert_return (invoke "f64x2.pmax" (v128.const f64x2 0123456789e019 0123456789e019)
                                    (v128.const f64x2 0123456789.e-019 0123456789.e-019))
                                    (v128.const f64x2 0x1.fe9af5b5e16fap+89 0x1.fe9af5b5e16fap+89))
(assert_return (invoke "f64x2.pmax" (v128.const f64x2 0123456789e019 0123456789e019)
                                    (v128.const f64x2 0123456789.0123456789 0123456789.0123456789))
                                    (v128.const f64x2 0x1.fe9af5b5e16fap+89 0x1.fe9af5b5e16fap+89))
(assert_return (invoke "f64x2.pmax" (v128.const f64x2 0123456789e019 0123456789e019)
                                    (v128.const f64x2 0123456789.0123456789e019 0123456789.0123456789e019))
                                    (v128.const f64x2 0x1.fe9af5b6bcbd5p+89 0x1.fe9af5b6bcbd5p+89))
(assert_return (invoke "f64x2.pmax" (v128.const f64x2 0123456789e019 0123456789e019)
                                    (v128.const f64x2 0123456789.0123456789e+019 0123456789.0123456789e+019))
                                    (v128.const f64x2 0x1.fe9af5b6bcbd5p+89 0x1.fe9af5b6bcbd5p+89))
(assert_return (invoke "f64x2.pmax" (v128.const f64x2 0123456789e019 0123456789e019)
                                    (v128.const f64x2 0123456789.0123456789e-019 0123456789.0123456789e-019))
                                    (v128.const f64x2 0x1.fe9af5b5e16fap+89 0x1.fe9af5b5e16fap+89))
(assert_return (invoke "f64x2.pmax" (v128.const f64x2 0123456789e019 0123456789e019)
                                    (v128.const f64x2 0x0123456789ABCDEFabcdef 0x0123456789ABCDEFabcdef))
                                    (v128.const f64x2 0x1.fe9af5b5e16fap+89 0x1.fe9af5b5e16fap+89))
(assert_return (invoke "f64x2.pmax" (v128.const f64x2 0123456789e019 0123456789e019)
                                    (v128.const f64x2 0x0123456789ABCDEFabcdefp019 0x0123456789ABCDEFabcdefp019))
                                    (v128.const f64x2 0x1.23456789abcdfp+99 0x1.23456789abcdfp+99))
(assert_return (invoke "f64x2.pmax" (v128.const f64x2 0123456789e019 0123456789e019)
                                    (v128.const f64x2 0x0123456789ABCDEFabcdefp+019 0x0123456789ABCDEFabcdefp+019))
                                    (v128.const f64x2 0x1.23456789abcdfp+99 0x1.23456789abcdfp+99))
(assert_return (invoke "f64x2.pmax" (v128.const f64x2 0123456789e019 0123456789e019)
                                    (v128.const f64x2 0x0123456789ABCDEFabcdefp-019 0x0123456789ABCDEFabcdefp-019))
                                    (v128.const f64x2 0x1.fe9af5b5e16fap+89 0x1.fe9af5b5e16fap+89))
(assert_return (invoke "f64x2.pmax" (v128.const f64x2 0123456789e019 0123456789e019)
                                    (v128.const f64x2 0x0123456789ABCDEFabcdef. 0x0123456789ABCDEFabcdef.))
                                    (v128.const f64x2 0x1.fe9af5b5e16fap+89 0x1.fe9af5b5e16fap+89))
(assert_return (invoke "f64x2.pmax" (v128.const f64x2 0123456789e019 0123456789e019)
                                    (v128.const f64x2 0x0123456789ABCDEFabcdef.p019 0x0123456789ABCDEFabcdef.p019))
                                    (v128.const f64x2 0x1.23456789abcdfp+99 0x1.23456789abcdfp+99))
(assert_return (invoke "f64x2.pmax" (v128.const f64x2 0123456789e019 0123456789e019)
                                    (v128.const f64x2 0x0123456789ABCDEFabcdef.p+019 0x0123456789ABCDEFabcdef.p+019))
                                    (v128.const f64x2 0x1.23456789abcdfp+99 0x1.23456789abcdfp+99))
(assert_return (invoke "f64x2.pmax" (v128.const f64x2 0123456789e019 0123456789e019)
                                    (v128.const f64x2 0x0123456789ABCDEFabcdef.p-019 0x0123456789ABCDEFabcdef.p-019))
                                    (v128.const f64x2 0x1.fe9af5b5e16fap+89 0x1.fe9af5b5e16fap+89))
(assert_return (invoke "f64x2.pmax" (v128.const f64x2 0123456789e019 0123456789e019)
                                    (v128.const f64x2 0x0123456789ABCDEFabcdef.0123456789ABCDEFabcdef 0x0123456789ABCDEFabcdef.0123456789ABCDEFabcdef))
                                    (v128.const f64x2 0x1.fe9af5b5e16fap+89 0x1.fe9af5b5e16fap+89))
(assert_return (invoke "f64x2.pmax" (v128.const f64x2 0123456789e019 0123456789e019)
                                    (v128.const f64x2 0x0123456789ABCDEFabcdef.0123456789ABCDEFabcdefp019 0x0123456789ABCDEFabcdef.0123456789ABCDEFabcdefp019))
                                    (v128.const f64x2 0x1.23456789abcdfp+99 0x1.23456789abcdfp+99))
(assert_return (invoke "f64x2.pmax" (v128.const f64x2 0123456789e019 0123456789e019)
                                    (v128.const f64x2 0x0123456789ABCDEFabcdef.0123456789ABCDEFabcdefp+019 0x0123456789ABCDEFabcdef.0123456789ABCDEFabcdefp+019))
                                    (v128.const f64x2 0x1.23456789abcdfp+99 0x1.23456789abcdfp+99))
(assert_return (invoke "f64x2.pmax" (v128.const f64x2 0123456789e019 0123456789e019)
                                    (v128.const f64x2 0x0123456789ABCDEFabcdef.0123456789ABCDEFabcdefp-019 0x0123456789ABCDEFabcdef.0123456789ABCDEFabcdefp-019))
                                    (v128.const f64x2 0x1.fe9af5b5e16fap+89 0x1.fe9af5b5e16fap+89))
(assert_return (invoke "f64x2.pmax" (v128.const f64x2 0123456789e+019 0123456789e+019)
                                    (v128.const f64x2 0x0p+0 0x0p+0))
                                    (v128.const f64x2 0x1.fe9af5b5e16fap+89 0x1.fe9af5b5e16fap+89))
(assert_return (invoke "f64x2.pmax" (v128.const f64x2 0123456789e+019 0123456789e+019)
                                    (v128.const f64x2 -0x0p+0 -0x0p+0))
                                    (v128.const f64x2 0x1.fe9af5b5e16fap+89 0x1.fe9af5b5e16fap+89))
(assert_return (invoke "f64x2.pmax" (v128.const f64x2 0123456789e+019 0123456789e+019)
                                    (v128.const f64x2 0x1p-1022 0x1p-1022))
                                    (v128.const f64x2 0x1.fe9af5b5e16fap+89 0x1.fe9af5b5e16fap+89))
(assert_return (invoke "f64x2.pmax" (v128.const f64x2 0123456789e+019 0123456789e+019)
                                    (v128.const f64x2 -0x1p-1022 -0x1p-1022))
                                    (v128.const f64x2 0x1.fe9af5b5e16fap+89 0x1.fe9af5b5e16fap+89))
(assert_return (invoke "f64x2.pmax" (v128.const f64x2 0123456789e+019 0123456789e+019)
                                    (v128.const f64x2 0x1p-1 0x1p-1))
                                    (v128.const f64x2 0x1.fe9af5b5e16fap+89 0x1.fe9af5b5e16fap+89))
(assert_return (invoke "f64x2.pmax" (v128.const f64x2 0123456789e+019 0123456789e+019)
                                    (v128.const f64x2 -0x1p-1 -0x1p-1))
                                    (v128.const f64x2 0x1.fe9af5b5e16fap+89 0x1.fe9af5b5e16fap+89))
(assert_return (invoke "f64x2.pmax" (v128.const f64x2 0123456789e+019 0123456789e+019)
                                    (v128.const f64x2 0x1p+0 0x1p+0))
                                    (v128.const f64x2 0x1.fe9af5b5e16fap+89 0x1.fe9af5b5e16fap+89))
(assert_return (invoke "f64x2.pmax" (v128.const f64x2 0123456789e+019 0123456789e+019)
                                    (v128.const f64x2 -0x1p+0 -0x1p+0))
                                    (v128.const f64x2 0x1.fe9af5b5e16fap+89 0x1.fe9af5b5e16fap+89))
(assert_return (invoke "f64x2.pmax" (v128.const f64x2 0123456789e+019 0123456789e+019)
                                    (v128.const f64x2 0x1.921fb54442d18p+2 0x1.921fb54442d18p+2))
                                    (v128.const f64x2 0x1.fe9af5b5e16fap+89 0x1.fe9af5b5e16fap+89))
(assert_return (invoke "f64x2.pmax" (v128.const f64x2 0123456789e+019 0123456789e+019)
                                    (v128.const f64x2 -0x1.921fb54442d18p+2 -0x1.921fb54442d18p+2))
                                    (v128.const f64x2 0x1.fe9af5b5e16fap+89 0x1.fe9af5b5e16fap+89))
(assert_return (invoke "f64x2.pmax" (v128.const f64x2 0123456789e+019 0123456789e+019)
                                    (v128.const f64x2 0x1.fffffffffffffp+1023 0x1.fffffffffffffp+1023))
                                    (v128.const f64x2 0x1.fffffffffffffp+1023 0x1.fffffffffffffp+1023))
(assert_return (invoke "f64x2.pmax" (v128.const f64x2 0123456789e+019 0123456789e+019)
                                    (v128.const f64x2 -0x1.fffffffffffffp+1023 -0x1.fffffffffffffp+1023))
                                    (v128.const f64x2 0x1.fe9af5b5e16fap+89 0x1.fe9af5b5e16fap+89))
(assert_return (invoke "f64x2.pmax" (v128.const f64x2 0123456789e+019 0123456789e+019)
                                    (v128.const f64x2 0x0.0000000000001p-1022 0x0.0000000000001p-1022))
                                    (v128.const f64x2 0x1.fe9af5b5e16fap+89 0x1.fe9af5b5e16fap+89))
(assert_return (invoke "f64x2.pmax" (v128.const f64x2 0123456789e+019 0123456789e+019)
                                    (v128.const f64x2 0x0.0000000000001p-1022 0x0.0000000000001p-1022))
                                    (v128.const f64x2 0x1.fe9af5b5e16fap+89 0x1.fe9af5b5e16fap+89))
(assert_return (invoke "f64x2.pmax" (v128.const f64x2 0123456789e+019 0123456789e+019)
                                    (v128.const f64x2 inf inf))
                                    (v128.const f64x2 inf inf))
(assert_return (invoke "f64x2.pmax" (v128.const f64x2 0123456789e+019 0123456789e+019)
                                    (v128.const f64x2 -inf -inf))
                                    (v128.const f64x2 0x1.fe9af5b5e16fap+89 0x1.fe9af5b5e16fap+89))
(assert_return (invoke "f64x2.pmax" (v128.const f64x2 0123456789e+019 0123456789e+019)
                                    (v128.const f64x2 0123456789 0123456789))
                                    (v128.const f64x2 0x1.fe9af5b5e16fap+89 0x1.fe9af5b5e16fap+89))
(assert_return (invoke "f64x2.pmax" (v128.const f64x2 0123456789e+019 0123456789e+019)
                                    (v128.const f64x2 0123456789e019 0123456789e019))
                                    (v128.const f64x2 0x1.fe9af5b5e16fap+89 0x1.fe9af5b5e16fap+89))
(assert_return (invoke "f64x2.pmax" (v128.const f64x2 0123456789e+019 0123456789e+019)
                                    (v128.const f64x2 0123456789e+019 0123456789e+019))
                                    (v128.const f64x2 0x1.fe9af5b5e16fap+89 0x1.fe9af5b5e16fap+89))
(assert_return (invoke "f64x2.pmax" (v128.const f64x2 0123456789e+019 0123456789e+019)
                                    (v128.const f64x2 0123456789e-019 0123456789e-019))
                                    (v128.const f64x2 0x1.fe9af5b5e16fap+89 0x1.fe9af5b5e16fap+89))
(assert_return (invoke "f64x2.pmax" (v128.const f64x2 0123456789e+019 0123456789e+019)
                                    (v128.const f64x2 0123456789. 0123456789.))
                                    (v128.const f64x2 0x1.fe9af5b5e16fap+89 0x1.fe9af5b5e16fap+89))
(assert_return (invoke "f64x2.pmax" (v128.const f64x2 0123456789e+019 0123456789e+019)
                                    (v128.const f64x2 0123456789.e019 0123456789.e019))
                                    (v128.const f64x2 0x1.fe9af5b5e16fap+89 0x1.fe9af5b5e16fap+89))
(assert_return (invoke "f64x2.pmax" (v128.const f64x2 0123456789e+019 0123456789e+019)
                                    (v128.const f64x2 0123456789.e+019 0123456789.e+019))
                                    (v128.const f64x2 0x1.fe9af5b5e16fap+89 0x1.fe9af5b5e16fap+89))
(assert_return (invoke "f64x2.pmax" (v128.const f64x2 0123456789e+019 0123456789e+019)
                                    (v128.const f64x2 0123456789.e-019 0123456789.e-019))
                                    (v128.const f64x2 0x1.fe9af5b5e16fap+89 0x1.fe9af5b5e16fap+89))
(assert_return (invoke "f64x2.pmax" (v128.const f64x2 0123456789e+019 0123456789e+019)
                                    (v128.const f64x2 0123456789.0123456789 0123456789.0123456789))
                                    (v128.const f64x2 0x1.fe9af5b5e16fap+89 0x1.fe9af5b5e16fap+89))
(assert_return (invoke "f64x2.pmax" (v128.const f64x2 0123456789e+019 0123456789e+019)
                                    (v128.const f64x2 0123456789.0123456789e019 0123456789.0123456789e019))
                                    (v128.const f64x2 0x1.fe9af5b6bcbd5p+89 0x1.fe9af5b6bcbd5p+89))
(assert_return (invoke "f64x2.pmax" (v128.const f64x2 0123456789e+019 0123456789e+019)
                                    (v128.const f64x2 0123456789.0123456789e+019 0123456789.0123456789e+019))
                                    (v128.const f64x2 0x1.fe9af5b6bcbd5p+89 0x1.fe9af5b6bcbd5p+89))
(assert_return (invoke "f64x2.pmax" (v128.const f64x2 0123456789e+019 0123456789e+019)
                                    (v128.const f64x2 0123456789.0123456789e-019 0123456789.0123456789e-019))
                                    (v128.const f64x2 0x1.fe9af5b5e16fap+89 0x1.fe9af5b5e16fap+89))
(assert_return (invoke "f64x2.pmax" (v128.const f64x2 0123456789e+019 0123456789e+019)
                                    (v128.const f64x2 0x0123456789ABCDEFabcdef 0x0123456789ABCDEFabcdef))
                                    (v128.const f64x2 0x1.fe9af5b5e16fap+89 0x1.fe9af5b5e16fap+89))
(assert_return (invoke "f64x2.pmax" (v128.const f64x2 0123456789e+019 0123456789e+019)
                                    (v128.const f64x2 0x0123456789ABCDEFabcdefp019 0x0123456789ABCDEFabcdefp019))
                                    (v128.const f64x2 0x1.23456789abcdfp+99 0x1.23456789abcdfp+99))
(assert_return (invoke "f64x2.pmax" (v128.const f64x2 0123456789e+019 0123456789e+019)
                                    (v128.const f64x2 0x0123456789ABCDEFabcdefp+019 0x0123456789ABCDEFabcdefp+019))
                                    (v128.const f64x2 0x1.23456789abcdfp+99 0x1.23456789abcdfp+99))
(assert_return (invoke "f64x2.pmax" (v128.const f64x2 0123456789e+019 0123456789e+019)
                                    (v128.const f64x2 0x0123456789ABCDEFabcdefp-019 0x0123456789ABCDEFabcdefp-019))
                                    (v128.const f64x2 0x1.fe9af5b5e16fap+89 0x1.fe9af5b5e16fap+89))
(assert_return (invoke "f64x2.pmax" (v128.const f64x2 0123456789e+019 0123456789e+019)
                                    (v128.const f64x2 0x0123456789ABCDEFabcdef. 0x0123456789ABCDEFabcdef.))
                                    (v128.const f64x2 0x1.fe9af5b5e16fap+89 0x1.fe9af5b5e16fap+89))
(assert_return (invoke "f64x2.pmax" (v128.const f64x2 0123456789e+019 0123456789e+019)
                                    (v128.const f64x2 0x0123456789ABCDEFabcdef.p019 0x0123456789ABCDEFabcdef.p019))
                                    (v128.const f64x2 0x1.23456789abcdfp+99 0x1.23456789abcdfp+99))
(assert_return (invoke "f64x2.pmax" (v128.const f64x2 0123456789e+019 0123456789e+019)
                                    (v128.const f64x2 0x0123456789ABCDEFabcdef.p+019 0x0123456789ABCDEFabcdef.p+019))
                                    (v128.const f64x2 0x1.23456789abcdfp+99 0x1.23456789abcdfp+99))
(assert_return (invoke "f64x2.pmax" (v128.const f64x2 0123456789e+019 0123456789e+019)
                                    (v128.const f64x2 0x0123456789ABCDEFabcdef.p-019 0x0123456789ABCDEFabcdef.p-019))
                                    (v128.const f64x2 0x1.fe9af5b5e16fap+89 0x1.fe9af5b5e16fap+89))
(assert_return (invoke "f64x2.pmax" (v128.const f64x2 0123456789e+019 0123456789e+019)
                                    (v128.const f64x2 0x0123456789ABCDEFabcdef.0123456789ABCDEFabcdef 0x0123456789ABCDEFabcdef.0123456789ABCDEFabcdef))
                                    (v128.const f64x2 0x1.fe9af5b5e16fap+89 0x1.fe9af5b5e16fap+89))
(assert_return (invoke "f64x2.pmax" (v128.const f64x2 0123456789e+019 0123456789e+019)
                                    (v128.const f64x2 0x0123456789ABCDEFabcdef.0123456789ABCDEFabcdefp019 0x0123456789ABCDEFabcdef.0123456789ABCDEFabcdefp019))
                                    (v128.const f64x2 0x1.23456789abcdfp+99 0x1.23456789abcdfp+99))
(assert_return (invoke "f64x2.pmax" (v128.const f64x2 0123456789e+019 0123456789e+019)
                                    (v128.const f64x2 0x0123456789ABCDEFabcdef.0123456789ABCDEFabcdefp+019 0x0123456789ABCDEFabcdef.0123456789ABCDEFabcdefp+019))
                                    (v128.const f64x2 0x1.23456789abcdfp+99 0x1.23456789abcdfp+99))
(assert_return (invoke "f64x2.pmax" (v128.const f64x2 0123456789e+019 0123456789e+019)
                                    (v128.const f64x2 0x0123456789ABCDEFabcdef.0123456789ABCDEFabcdefp-019 0x0123456789ABCDEFabcdef.0123456789ABCDEFabcdefp-019))
                                    (v128.const f64x2 0x1.fe9af5b5e16fap+89 0x1.fe9af5b5e16fap+89))
(assert_return (invoke "f64x2.pmax" (v128.const f64x2 0123456789e-019 0123456789e-019)
                                    (v128.const f64x2 0x0p+0 0x0p+0))
                                    (v128.const f64x2 0x1.b25ffd62b4311p-37 0x1.b25ffd62b4311p-37))
(assert_return (invoke "f64x2.pmax" (v128.const f64x2 0123456789e-019 0123456789e-019)
                                    (v128.const f64x2 -0x0p+0 -0x0p+0))
                                    (v128.const f64x2 0x1.b25ffd62b4311p-37 0x1.b25ffd62b4311p-37))
(assert_return (invoke "f64x2.pmax" (v128.const f64x2 0123456789e-019 0123456789e-019)
                                    (v128.const f64x2 0x1p-1022 0x1p-1022))
                                    (v128.const f64x2 0x1.b25ffd62b4311p-37 0x1.b25ffd62b4311p-37))
(assert_return (invoke "f64x2.pmax" (v128.const f64x2 0123456789e-019 0123456789e-019)
                                    (v128.const f64x2 -0x1p-1022 -0x1p-1022))
                                    (v128.const f64x2 0x1.b25ffd62b4311p-37 0x1.b25ffd62b4311p-37))
(assert_return (invoke "f64x2.pmax" (v128.const f64x2 0123456789e-019 0123456789e-019)
                                    (v128.const f64x2 0x1p-1 0x1p-1))
                                    (v128.const f64x2 0x1.0000000000000p-1 0x1.0000000000000p-1))
(assert_return (invoke "f64x2.pmax" (v128.const f64x2 0123456789e-019 0123456789e-019)
                                    (v128.const f64x2 -0x1p-1 -0x1p-1))
                                    (v128.const f64x2 0x1.b25ffd62b4311p-37 0x1.b25ffd62b4311p-37))
(assert_return (invoke "f64x2.pmax" (v128.const f64x2 0123456789e-019 0123456789e-019)
                                    (v128.const f64x2 0x1p+0 0x1p+0))
                                    (v128.const f64x2 0x1.0000000000000p+0 0x1.0000000000000p+0))
(assert_return (invoke "f64x2.pmax" (v128.const f64x2 0123456789e-019 0123456789e-019)
                                    (v128.const f64x2 -0x1p+0 -0x1p+0))
                                    (v128.const f64x2 0x1.b25ffd62b4311p-37 0x1.b25ffd62b4311p-37))
(assert_return (invoke "f64x2.pmax" (v128.const f64x2 0123456789e-019 0123456789e-019)
                                    (v128.const f64x2 0x1.921fb54442d18p+2 0x1.921fb54442d18p+2))
                                    (v128.const f64x2 0x1.921fb54442d18p+2 0x1.921fb54442d18p+2))
(assert_return (invoke "f64x2.pmax" (v128.const f64x2 0123456789e-019 0123456789e-019)
                                    (v128.const f64x2 -0x1.921fb54442d18p+2 -0x1.921fb54442d18p+2))
                                    (v128.const f64x2 0x1.b25ffd62b4311p-37 0x1.b25ffd62b4311p-37))
(assert_return (invoke "f64x2.pmax" (v128.const f64x2 0123456789e-019 0123456789e-019)
                                    (v128.const f64x2 0x1.fffffffffffffp+1023 0x1.fffffffffffffp+1023))
                                    (v128.const f64x2 0x1.fffffffffffffp+1023 0x1.fffffffffffffp+1023))
(assert_return (invoke "f64x2.pmax" (v128.const f64x2 0123456789e-019 0123456789e-019)
                                    (v128.const f64x2 -0x1.fffffffffffffp+1023 -0x1.fffffffffffffp+1023))
                                    (v128.const f64x2 0x1.b25ffd62b4311p-37 0x1.b25ffd62b4311p-37))
(assert_return (invoke "f64x2.pmax" (v128.const f64x2 0123456789e-019 0123456789e-019)
                                    (v128.const f64x2 0x0.0000000000001p-1022 0x0.0000000000001p-1022))
                                    (v128.const f64x2 0x1.b25ffd62b4311p-37 0x1.b25ffd62b4311p-37))
(assert_return (invoke "f64x2.pmax" (v128.const f64x2 0123456789e-019 0123456789e-019)
                                    (v128.const f64x2 0x0.0000000000001p-1022 0x0.0000000000001p-1022))
                                    (v128.const f64x2 0x1.b25ffd62b4311p-37 0x1.b25ffd62b4311p-37))
(assert_return (invoke "f64x2.pmax" (v128.const f64x2 0123456789e-019 0123456789e-019)
                                    (v128.const f64x2 inf inf))
                                    (v128.const f64x2 inf inf))
(assert_return (invoke "f64x2.pmax" (v128.const f64x2 0123456789e-019 0123456789e-019)
                                    (v128.const f64x2 -inf -inf))
                                    (v128.const f64x2 0x1.b25ffd62b4311p-37 0x1.b25ffd62b4311p-37))
(assert_return (invoke "f64x2.pmax" (v128.const f64x2 0123456789e-019 0123456789e-019)
                                    (v128.const f64x2 0123456789 0123456789))
                                    (v128.const f64x2 0x1.d6f3454000000p+26 0x1.d6f3454000000p+26))
(assert_return (invoke "f64x2.pmax" (v128.const f64x2 0123456789e-019 0123456789e-019)
                                    (v128.const f64x2 0123456789e019 0123456789e019))
                                    (v128.const f64x2 0x1.fe9af5b5e16fap+89 0x1.fe9af5b5e16fap+89))
(assert_return (invoke "f64x2.pmax" (v128.const f64x2 0123456789e-019 0123456789e-019)
                                    (v128.const f64x2 0123456789e+019 0123456789e+019))
                                    (v128.const f64x2 0x1.fe9af5b5e16fap+89 0x1.fe9af5b5e16fap+89))
(assert_return (invoke "f64x2.pmax" (v128.const f64x2 0123456789e-019 0123456789e-019)
                                    (v128.const f64x2 0123456789e-019 0123456789e-019))
                                    (v128.const f64x2 0x1.b25ffd62b4311p-37 0x1.b25ffd62b4311p-37))
(assert_return (invoke "f64x2.pmax" (v128.const f64x2 0123456789e-019 0123456789e-019)
                                    (v128.const f64x2 0123456789. 0123456789.))
                                    (v128.const f64x2 0x1.d6f3454000000p+26 0x1.d6f3454000000p+26))
(assert_return (invoke "f64x2.pmax" (v128.const f64x2 0123456789e-019 0123456789e-019)
                                    (v128.const f64x2 0123456789.e019 0123456789.e019))
                                    (v128.const f64x2 0x1.fe9af5b5e16fap+89 0x1.fe9af5b5e16fap+89))
(assert_return (invoke "f64x2.pmax" (v128.const f64x2 0123456789e-019 0123456789e-019)
                                    (v128.const f64x2 0123456789.e+019 0123456789.e+019))
                                    (v128.const f64x2 0x1.fe9af5b5e16fap+89 0x1.fe9af5b5e16fap+89))
(assert_return (invoke "f64x2.pmax" (v128.const f64x2 0123456789e-019 0123456789e-019)
                                    (v128.const f64x2 0123456789.e-019 0123456789.e-019))
                                    (v128.const f64x2 0x1.b25ffd62b4311p-37 0x1.b25ffd62b4311p-37))
(assert_return (invoke "f64x2.pmax" (v128.const f64x2 0123456789e-019 0123456789e-019)
                                    (v128.const f64x2 0123456789.0123456789 0123456789.0123456789))
                                    (v128.const f64x2 0x1.d6f34540ca458p+26 0x1.d6f34540ca458p+26))
(assert_return (invoke "f64x2.pmax" (v128.const f64x2 0123456789e-019 0123456789e-019)
                                    (v128.const f64x2 0123456789.0123456789e019 0123456789.0123456789e019))
                                    (v128.const f64x2 0x1.fe9af5b6bcbd5p+89 0x1.fe9af5b6bcbd5p+89))
(assert_return (invoke "f64x2.pmax" (v128.const f64x2 0123456789e-019 0123456789e-019)
                                    (v128.const f64x2 0123456789.0123456789e+019 0123456789.0123456789e+019))
                                    (v128.const f64x2 0x1.fe9af5b6bcbd5p+89 0x1.fe9af5b6bcbd5p+89))
(assert_return (invoke "f64x2.pmax" (v128.const f64x2 0123456789e-019 0123456789e-019)
                                    (v128.const f64x2 0123456789.0123456789e-019 0123456789.0123456789e-019))
                                    (v128.const f64x2 0x1.b25ffd636ec12p-37 0x1.b25ffd636ec12p-37))
(assert_return (invoke "f64x2.pmax" (v128.const f64x2 0123456789e-019 0123456789e-019)
                                    (v128.const f64x2 0x0123456789ABCDEFabcdef 0x0123456789ABCDEFabcdef))
                                    (v128.const f64x2 0x1.23456789abcdfp+80 0x1.23456789abcdfp+80))
(assert_return (invoke "f64x2.pmax" (v128.const f64x2 0123456789e-019 0123456789e-019)
                                    (v128.const f64x2 0x0123456789ABCDEFabcdefp019 0x0123456789ABCDEFabcdefp019))
                                    (v128.const f64x2 0x1.23456789abcdfp+99 0x1.23456789abcdfp+99))
(assert_return (invoke "f64x2.pmax" (v128.const f64x2 0123456789e-019 0123456789e-019)
                                    (v128.const f64x2 0x0123456789ABCDEFabcdefp+019 0x0123456789ABCDEFabcdefp+019))
                                    (v128.const f64x2 0x1.23456789abcdfp+99 0x1.23456789abcdfp+99))
(assert_return (invoke "f64x2.pmax" (v128.const f64x2 0123456789e-019 0123456789e-019)
                                    (v128.const f64x2 0x0123456789ABCDEFabcdefp-019 0x0123456789ABCDEFabcdefp-019))
                                    (v128.const f64x2 0x1.23456789abcdfp+61 0x1.23456789abcdfp+61))
(assert_return (invoke "f64x2.pmax" (v128.const f64x2 0123456789e-019 0123456789e-019)
                                    (v128.const f64x2 0x0123456789ABCDEFabcdef. 0x0123456789ABCDEFabcdef.))
                                    (v128.const f64x2 0x1.23456789abcdfp+80 0x1.23456789abcdfp+80))
(assert_return (invoke "f64x2.pmax" (v128.const f64x2 0123456789e-019 0123456789e-019)
                                    (v128.const f64x2 0x0123456789ABCDEFabcdef.p019 0x0123456789ABCDEFabcdef.p019))
                                    (v128.const f64x2 0x1.23456789abcdfp+99 0x1.23456789abcdfp+99))
(assert_return (invoke "f64x2.pmax" (v128.const f64x2 0123456789e-019 0123456789e-019)
                                    (v128.const f64x2 0x0123456789ABCDEFabcdef.p+019 0x0123456789ABCDEFabcdef.p+019))
                                    (v128.const f64x2 0x1.23456789abcdfp+99 0x1.23456789abcdfp+99))
(assert_return (invoke "f64x2.pmax" (v128.const f64x2 0123456789e-019 0123456789e-019)
                                    (v128.const f64x2 0x0123456789ABCDEFabcdef.p-019 0x0123456789ABCDEFabcdef.p-019))
                                    (v128.const f64x2 0x1.23456789abcdfp+61 0x1.23456789abcdfp+61))
(assert_return (invoke "f64x2.pmax" (v128.const f64x2 0123456789e-019 0123456789e-019)
                                    (v128.const f64x2 0x0123456789ABCDEFabcdef.0123456789ABCDEFabcdef 0x0123456789ABCDEFabcdef.0123456789ABCDEFabcdef))
                                    (v128.const f64x2 0x1.23456789abcdfp+80 0x1.23456789abcdfp+80))
(assert_return (invoke "f64x2.pmax" (v128.const f64x2 0123456789e-019 0123456789e-019)
                                    (v128.const f64x2 0x0123456789ABCDEFabcdef.0123456789ABCDEFabcdefp019 0x0123456789ABCDEFabcdef.0123456789ABCDEFabcdefp019))
                                    (v128.const f64x2 0x1.23456789abcdfp+99 0x1.23456789abcdfp+99))
(assert_return (invoke "f64x2.pmax" (v128.const f64x2 0123456789e-019 0123456789e-019)
                                    (v128.const f64x2 0x0123456789ABCDEFabcdef.0123456789ABCDEFabcdefp+019 0x0123456789ABCDEFabcdef.0123456789ABCDEFabcdefp+019))
                                    (v128.const f64x2 0x1.23456789abcdfp+99 0x1.23456789abcdfp+99))
(assert_return (invoke "f64x2.pmax" (v128.const f64x2 0123456789e-019 0123456789e-019)
                                    (v128.const f64x2 0x0123456789ABCDEFabcdef.0123456789ABCDEFabcdefp-019 0x0123456789ABCDEFabcdef.0123456789ABCDEFabcdefp-019))
                                    (v128.const f64x2 0x1.23456789abcdfp+61 0x1.23456789abcdfp+61))
(assert_return (invoke "f64x2.pmax" (v128.const f64x2 0123456789. 0123456789.)
                                    (v128.const f64x2 0x0p+0 0x0p+0))
                                    (v128.const f64x2 0x1.d6f3454000000p+26 0x1.d6f3454000000p+26))
(assert_return (invoke "f64x2.pmax" (v128.const f64x2 0123456789. 0123456789.)
                                    (v128.const f64x2 -0x0p+0 -0x0p+0))
                                    (v128.const f64x2 0x1.d6f3454000000p+26 0x1.d6f3454000000p+26))
(assert_return (invoke "f64x2.pmax" (v128.const f64x2 0123456789. 0123456789.)
                                    (v128.const f64x2 0x1p-1022 0x1p-1022))
                                    (v128.const f64x2 0x1.d6f3454000000p+26 0x1.d6f3454000000p+26))
(assert_return (invoke "f64x2.pmax" (v128.const f64x2 0123456789. 0123456789.)
                                    (v128.const f64x2 -0x1p-1022 -0x1p-1022))
                                    (v128.const f64x2 0x1.d6f3454000000p+26 0x1.d6f3454000000p+26))
(assert_return (invoke "f64x2.pmax" (v128.const f64x2 0123456789. 0123456789.)
                                    (v128.const f64x2 0x1p-1 0x1p-1))
                                    (v128.const f64x2 0x1.d6f3454000000p+26 0x1.d6f3454000000p+26))
(assert_return (invoke "f64x2.pmax" (v128.const f64x2 0123456789. 0123456789.)
                                    (v128.const f64x2 -0x1p-1 -0x1p-1))
                                    (v128.const f64x2 0x1.d6f3454000000p+26 0x1.d6f3454000000p+26))
(assert_return (invoke "f64x2.pmax" (v128.const f64x2 0123456789. 0123456789.)
                                    (v128.const f64x2 0x1p+0 0x1p+0))
                                    (v128.const f64x2 0x1.d6f3454000000p+26 0x1.d6f3454000000p+26))
(assert_return (invoke "f64x2.pmax" (v128.const f64x2 0123456789. 0123456789.)
                                    (v128.const f64x2 -0x1p+0 -0x1p+0))
                                    (v128.const f64x2 0x1.d6f3454000000p+26 0x1.d6f3454000000p+26))
(assert_return (invoke "f64x2.pmax" (v128.const f64x2 0123456789. 0123456789.)
                                    (v128.const f64x2 0x1.921fb54442d18p+2 0x1.921fb54442d18p+2))
                                    (v128.const f64x2 0x1.d6f3454000000p+26 0x1.d6f3454000000p+26))
(assert_return (invoke "f64x2.pmax" (v128.const f64x2 0123456789. 0123456789.)
                                    (v128.const f64x2 -0x1.921fb54442d18p+2 -0x1.921fb54442d18p+2))
                                    (v128.const f64x2 0x1.d6f3454000000p+26 0x1.d6f3454000000p+26))
(assert_return (invoke "f64x2.pmax" (v128.const f64x2 0123456789. 0123456789.)
                                    (v128.const f64x2 0x1.fffffffffffffp+1023 0x1.fffffffffffffp+1023))
                                    (v128.const f64x2 0x1.fffffffffffffp+1023 0x1.fffffffffffffp+1023))
(assert_return (invoke "f64x2.pmax" (v128.const f64x2 0123456789. 0123456789.)
                                    (v128.const f64x2 -0x1.fffffffffffffp+1023 -0x1.fffffffffffffp+1023))
                                    (v128.const f64x2 0x1.d6f3454000000p+26 0x1.d6f3454000000p+26))
(assert_return (invoke "f64x2.pmax" (v128.const f64x2 0123456789. 0123456789.)
                                    (v128.const f64x2 0x0.0000000000001p-1022 0x0.0000000000001p-1022))
                                    (v128.const f64x2 0x1.d6f3454000000p+26 0x1.d6f3454000000p+26))
(assert_return (invoke "f64x2.pmax" (v128.const f64x2 0123456789. 0123456789.)
                                    (v128.const f64x2 0x0.0000000000001p-1022 0x0.0000000000001p-1022))
                                    (v128.const f64x2 0x1.d6f3454000000p+26 0x1.d6f3454000000p+26))
(assert_return (invoke "f64x2.pmax" (v128.const f64x2 0123456789. 0123456789.)
                                    (v128.const f64x2 inf inf))
                                    (v128.const f64x2 inf inf))
(assert_return (invoke "f64x2.pmax" (v128.const f64x2 0123456789. 0123456789.)
                                    (v128.const f64x2 -inf -inf))
                                    (v128.const f64x2 0x1.d6f3454000000p+26 0x1.d6f3454000000p+26))
(assert_return (invoke "f64x2.pmax" (v128.const f64x2 0123456789. 0123456789.)
                                    (v128.const f64x2 0123456789 0123456789))
                                    (v128.const f64x2 0x1.d6f3454000000p+26 0x1.d6f3454000000p+26))
(assert_return (invoke "f64x2.pmax" (v128.const f64x2 0123456789. 0123456789.)
                                    (v128.const f64x2 0123456789e019 0123456789e019))
                                    (v128.const f64x2 0x1.fe9af5b5e16fap+89 0x1.fe9af5b5e16fap+89))
(assert_return (invoke "f64x2.pmax" (v128.const f64x2 0123456789. 0123456789.)
                                    (v128.const f64x2 0123456789e+019 0123456789e+019))
                                    (v128.const f64x2 0x1.fe9af5b5e16fap+89 0x1.fe9af5b5e16fap+89))
(assert_return (invoke "f64x2.pmax" (v128.const f64x2 0123456789. 0123456789.)
                                    (v128.const f64x2 0123456789e-019 0123456789e-019))
                                    (v128.const f64x2 0x1.d6f3454000000p+26 0x1.d6f3454000000p+26))
(assert_return (invoke "f64x2.pmax" (v128.const f64x2 0123456789. 0123456789.)
                                    (v128.const f64x2 0123456789. 0123456789.))
                                    (v128.const f64x2 0x1.d6f3454000000p+26 0x1.d6f3454000000p+26))
(assert_return (invoke "f64x2.pmax" (v128.const f64x2 0123456789. 0123456789.)
                                    (v128.const f64x2 0123456789.e019 0123456789.e019))
                                    (v128.const f64x2 0x1.fe9af5b5e16fap+89 0x1.fe9af5b5e16fap+89))
(assert_return (invoke "f64x2.pmax" (v128.const f64x2 0123456789. 0123456789.)
                                    (v128.const f64x2 0123456789.e+019 0123456789.e+019))
                                    (v128.const f64x2 0x1.fe9af5b5e16fap+89 0x1.fe9af5b5e16fap+89))
(assert_return (invoke "f64x2.pmax" (v128.const f64x2 0123456789. 0123456789.)
                                    (v128.const f64x2 0123456789.e-019 0123456789.e-019))
                                    (v128.const f64x2 0x1.d6f3454000000p+26 0x1.d6f3454000000p+26))
(assert_return (invoke "f64x2.pmax" (v128.const f64x2 0123456789. 0123456789.)
                                    (v128.const f64x2 0123456789.0123456789 0123456789.0123456789))
                                    (v128.const f64x2 0x1.d6f34540ca458p+26 0x1.d6f34540ca458p+26))
(assert_return (invoke "f64x2.pmax" (v128.const f64x2 0123456789. 0123456789.)
                                    (v128.const f64x2 0123456789.0123456789e019 0123456789.0123456789e019))
                                    (v128.const f64x2 0x1.fe9af5b6bcbd5p+89 0x1.fe9af5b6bcbd5p+89))
(assert_return (invoke "f64x2.pmax" (v128.const f64x2 0123456789. 0123456789.)
                                    (v128.const f64x2 0123456789.0123456789e+019 0123456789.0123456789e+019))
                                    (v128.const f64x2 0x1.fe9af5b6bcbd5p+89 0x1.fe9af5b6bcbd5p+89))
(assert_return (invoke "f64x2.pmax" (v128.const f64x2 0123456789. 0123456789.)
                                    (v128.const f64x2 0123456789.0123456789e-019 0123456789.0123456789e-019))
                                    (v128.const f64x2 0x1.d6f3454000000p+26 0x1.d6f3454000000p+26))
(assert_return (invoke "f64x2.pmax" (v128.const f64x2 0123456789. 0123456789.)
                                    (v128.const f64x2 0x0123456789ABCDEFabcdef 0x0123456789ABCDEFabcdef))
                                    (v128.const f64x2 0x1.23456789abcdfp+80 0x1.23456789abcdfp+80))
(assert_return (invoke "f64x2.pmax" (v128.const f64x2 0123456789. 0123456789.)
                                    (v128.const f64x2 0x0123456789ABCDEFabcdefp019 0x0123456789ABCDEFabcdefp019))
                                    (v128.const f64x2 0x1.23456789abcdfp+99 0x1.23456789abcdfp+99))
(assert_return (invoke "f64x2.pmax" (v128.const f64x2 0123456789. 0123456789.)
                                    (v128.const f64x2 0x0123456789ABCDEFabcdefp+019 0x0123456789ABCDEFabcdefp+019))
                                    (v128.const f64x2 0x1.23456789abcdfp+99 0x1.23456789abcdfp+99))
(assert_return (invoke "f64x2.pmax" (v128.const f64x2 0123456789. 0123456789.)
                                    (v128.const f64x2 0x0123456789ABCDEFabcdefp-019 0x0123456789ABCDEFabcdefp-019))
                                    (v128.const f64x2 0x1.23456789abcdfp+61 0x1.23456789abcdfp+61))
(assert_return (invoke "f64x2.pmax" (v128.const f64x2 0123456789. 0123456789.)
                                    (v128.const f64x2 0x0123456789ABCDEFabcdef. 0x0123456789ABCDEFabcdef.))
                                    (v128.const f64x2 0x1.23456789abcdfp+80 0x1.23456789abcdfp+80))
(assert_return (invoke "f64x2.pmax" (v128.const f64x2 0123456789. 0123456789.)
                                    (v128.const f64x2 0x0123456789ABCDEFabcdef.p019 0x0123456789ABCDEFabcdef.p019))
                                    (v128.const f64x2 0x1.23456789abcdfp+99 0x1.23456789abcdfp+99))
(assert_return (invoke "f64x2.pmax" (v128.const f64x2 0123456789. 0123456789.)
                                    (v128.const f64x2 0x0123456789ABCDEFabcdef.p+019 0x0123456789ABCDEFabcdef.p+019))
                                    (v128.const f64x2 0x1.23456789abcdfp+99 0x1.23456789abcdfp+99))
(assert_return (invoke "f64x2.pmax" (v128.const f64x2 0123456789. 0123456789.)
                                    (v128.const f64x2 0x0123456789ABCDEFabcdef.p-019 0x0123456789ABCDEFabcdef.p-019))
                                    (v128.const f64x2 0x1.23456789abcdfp+61 0x1.23456789abcdfp+61))
(assert_return (invoke "f64x2.pmax" (v128.const f64x2 0123456789. 0123456789.)
                                    (v128.const f64x2 0x0123456789ABCDEFabcdef.0123456789ABCDEFabcdef 0x0123456789ABCDEFabcdef.0123456789ABCDEFabcdef))
                                    (v128.const f64x2 0x1.23456789abcdfp+80 0x1.23456789abcdfp+80))
(assert_return (invoke "f64x2.pmax" (v128.const f64x2 0123456789. 0123456789.)
                                    (v128.const f64x2 0x0123456789ABCDEFabcdef.0123456789ABCDEFabcdefp019 0x0123456789ABCDEFabcdef.0123456789ABCDEFabcdefp019))
                                    (v128.const f64x2 0x1.23456789abcdfp+99 0x1.23456789abcdfp+99))
(assert_return (invoke "f64x2.pmax" (v128.const f64x2 0123456789. 0123456789.)
                                    (v128.const f64x2 0x0123456789ABCDEFabcdef.0123456789ABCDEFabcdefp+019 0x0123456789ABCDEFabcdef.0123456789ABCDEFabcdefp+019))
                                    (v128.const f64x2 0x1.23456789abcdfp+99 0x1.23456789abcdfp+99))
(assert_return (invoke "f64x2.pmax" (v128.const f64x2 0123456789. 0123456789.)
                                    (v128.const f64x2 0x0123456789ABCDEFabcdef.0123456789ABCDEFabcdefp-019 0x0123456789ABCDEFabcdef.0123456789ABCDEFabcdefp-019))
                                    (v128.const f64x2 0x1.23456789abcdfp+61 0x1.23456789abcdfp+61))
(assert_return (invoke "f64x2.pmax" (v128.const f64x2 0123456789.e019 0123456789.e019)
                                    (v128.const f64x2 0x0p+0 0x0p+0))
                                    (v128.const f64x2 0x1.fe9af5b5e16fap+89 0x1.fe9af5b5e16fap+89))
(assert_return (invoke "f64x2.pmax" (v128.const f64x2 0123456789.e019 0123456789.e019)
                                    (v128.const f64x2 -0x0p+0 -0x0p+0))
                                    (v128.const f64x2 0x1.fe9af5b5e16fap+89 0x1.fe9af5b5e16fap+89))
(assert_return (invoke "f64x2.pmax" (v128.const f64x2 0123456789.e019 0123456789.e019)
                                    (v128.const f64x2 0x1p-1022 0x1p-1022))
                                    (v128.const f64x2 0x1.fe9af5b5e16fap+89 0x1.fe9af5b5e16fap+89))
(assert_return (invoke "f64x2.pmax" (v128.const f64x2 0123456789.e019 0123456789.e019)
                                    (v128.const f64x2 -0x1p-1022 -0x1p-1022))
                                    (v128.const f64x2 0x1.fe9af5b5e16fap+89 0x1.fe9af5b5e16fap+89))
(assert_return (invoke "f64x2.pmax" (v128.const f64x2 0123456789.e019 0123456789.e019)
                                    (v128.const f64x2 0x1p-1 0x1p-1))
                                    (v128.const f64x2 0x1.fe9af5b5e16fap+89 0x1.fe9af5b5e16fap+89))
(assert_return (invoke "f64x2.pmax" (v128.const f64x2 0123456789.e019 0123456789.e019)
                                    (v128.const f64x2 -0x1p-1 -0x1p-1))
                                    (v128.const f64x2 0x1.fe9af5b5e16fap+89 0x1.fe9af5b5e16fap+89))
(assert_return (invoke "f64x2.pmax" (v128.const f64x2 0123456789.e019 0123456789.e019)
                                    (v128.const f64x2 0x1p+0 0x1p+0))
                                    (v128.const f64x2 0x1.fe9af5b5e16fap+89 0x1.fe9af5b5e16fap+89))
(assert_return (invoke "f64x2.pmax" (v128.const f64x2 0123456789.e019 0123456789.e019)
                                    (v128.const f64x2 -0x1p+0 -0x1p+0))
                                    (v128.const f64x2 0x1.fe9af5b5e16fap+89 0x1.fe9af5b5e16fap+89))
(assert_return (invoke "f64x2.pmax" (v128.const f64x2 0123456789.e019 0123456789.e019)
                                    (v128.const f64x2 0x1.921fb54442d18p+2 0x1.921fb54442d18p+2))
                                    (v128.const f64x2 0x1.fe9af5b5e16fap+89 0x1.fe9af5b5e16fap+89))
(assert_return (invoke "f64x2.pmax" (v128.const f64x2 0123456789.e019 0123456789.e019)
                                    (v128.const f64x2 -0x1.921fb54442d18p+2 -0x1.921fb54442d18p+2))
                                    (v128.const f64x2 0x1.fe9af5b5e16fap+89 0x1.fe9af5b5e16fap+89))
(assert_return (invoke "f64x2.pmax" (v128.const f64x2 0123456789.e019 0123456789.e019)
                                    (v128.const f64x2 0x1.fffffffffffffp+1023 0x1.fffffffffffffp+1023))
                                    (v128.const f64x2 0x1.fffffffffffffp+1023 0x1.fffffffffffffp+1023))
(assert_return (invoke "f64x2.pmax" (v128.const f64x2 0123456789.e019 0123456789.e019)
                                    (v128.const f64x2 -0x1.fffffffffffffp+1023 -0x1.fffffffffffffp+1023))
                                    (v128.const f64x2 0x1.fe9af5b5e16fap+89 0x1.fe9af5b5e16fap+89))
(assert_return (invoke "f64x2.pmax" (v128.const f64x2 0123456789.e019 0123456789.e019)
                                    (v128.const f64x2 0x0.0000000000001p-1022 0x0.0000000000001p-1022))
                                    (v128.const f64x2 0x1.fe9af5b5e16fap+89 0x1.fe9af5b5e16fap+89))
(assert_return (invoke "f64x2.pmax" (v128.const f64x2 0123456789.e019 0123456789.e019)
                                    (v128.const f64x2 0x0.0000000000001p-1022 0x0.0000000000001p-1022))
                                    (v128.const f64x2 0x1.fe9af5b5e16fap+89 0x1.fe9af5b5e16fap+89))
(assert_return (invoke "f64x2.pmax" (v128.const f64x2 0123456789.e019 0123456789.e019)
                                    (v128.const f64x2 inf inf))
                                    (v128.const f64x2 inf inf))
(assert_return (invoke "f64x2.pmax" (v128.const f64x2 0123456789.e019 0123456789.e019)
                                    (v128.const f64x2 -inf -inf))
                                    (v128.const f64x2 0x1.fe9af5b5e16fap+89 0x1.fe9af5b5e16fap+89))
(assert_return (invoke "f64x2.pmax" (v128.const f64x2 0123456789.e019 0123456789.e019)
                                    (v128.const f64x2 0123456789 0123456789))
                                    (v128.const f64x2 0x1.fe9af5b5e16fap+89 0x1.fe9af5b5e16fap+89))
(assert_return (invoke "f64x2.pmax" (v128.const f64x2 0123456789.e019 0123456789.e019)
                                    (v128.const f64x2 0123456789e019 0123456789e019))
                                    (v128.const f64x2 0x1.fe9af5b5e16fap+89 0x1.fe9af5b5e16fap+89))
(assert_return (invoke "f64x2.pmax" (v128.const f64x2 0123456789.e019 0123456789.e019)
                                    (v128.const f64x2 0123456789e+019 0123456789e+019))
                                    (v128.const f64x2 0x1.fe9af5b5e16fap+89 0x1.fe9af5b5e16fap+89))
(assert_return (invoke "f64x2.pmax" (v128.const f64x2 0123456789.e019 0123456789.e019)
                                    (v128.const f64x2 0123456789e-019 0123456789e-019))
                                    (v128.const f64x2 0x1.fe9af5b5e16fap+89 0x1.fe9af5b5e16fap+89))
(assert_return (invoke "f64x2.pmax" (v128.const f64x2 0123456789.e019 0123456789.e019)
                                    (v128.const f64x2 0123456789. 0123456789.))
                                    (v128.const f64x2 0x1.fe9af5b5e16fap+89 0x1.fe9af5b5e16fap+89))
(assert_return (invoke "f64x2.pmax" (v128.const f64x2 0123456789.e019 0123456789.e019)
                                    (v128.const f64x2 0123456789.e019 0123456789.e019))
                                    (v128.const f64x2 0x1.fe9af5b5e16fap+89 0x1.fe9af5b5e16fap+89))
(assert_return (invoke "f64x2.pmax" (v128.const f64x2 0123456789.e019 0123456789.e019)
                                    (v128.const f64x2 0123456789.e+019 0123456789.e+019))
                                    (v128.const f64x2 0x1.fe9af5b5e16fap+89 0x1.fe9af5b5e16fap+89))
(assert_return (invoke "f64x2.pmax" (v128.const f64x2 0123456789.e019 0123456789.e019)
                                    (v128.const f64x2 0123456789.e-019 0123456789.e-019))
                                    (v128.const f64x2 0x1.fe9af5b5e16fap+89 0x1.fe9af5b5e16fap+89))
(assert_return (invoke "f64x2.pmax" (v128.const f64x2 0123456789.e019 0123456789.e019)
                                    (v128.const f64x2 0123456789.0123456789 0123456789.0123456789))
                                    (v128.const f64x2 0x1.fe9af5b5e16fap+89 0x1.fe9af5b5e16fap+89))
(assert_return (invoke "f64x2.pmax" (v128.const f64x2 0123456789.e019 0123456789.e019)
                                    (v128.const f64x2 0123456789.0123456789e019 0123456789.0123456789e019))
                                    (v128.const f64x2 0x1.fe9af5b6bcbd5p+89 0x1.fe9af5b6bcbd5p+89))
(assert_return (invoke "f64x2.pmax" (v128.const f64x2 0123456789.e019 0123456789.e019)
                                    (v128.const f64x2 0123456789.0123456789e+019 0123456789.0123456789e+019))
                                    (v128.const f64x2 0x1.fe9af5b6bcbd5p+89 0x1.fe9af5b6bcbd5p+89))
(assert_return (invoke "f64x2.pmax" (v128.const f64x2 0123456789.e019 0123456789.e019)
                                    (v128.const f64x2 0123456789.0123456789e-019 0123456789.0123456789e-019))
                                    (v128.const f64x2 0x1.fe9af5b5e16fap+89 0x1.fe9af5b5e16fap+89))
(assert_return (invoke "f64x2.pmax" (v128.const f64x2 0123456789.e019 0123456789.e019)
                                    (v128.const f64x2 0x0123456789ABCDEFabcdef 0x0123456789ABCDEFabcdef))
                                    (v128.const f64x2 0x1.fe9af5b5e16fap+89 0x1.fe9af5b5e16fap+89))
(assert_return (invoke "f64x2.pmax" (v128.const f64x2 0123456789.e019 0123456789.e019)
                                    (v128.const f64x2 0x0123456789ABCDEFabcdefp019 0x0123456789ABCDEFabcdefp019))
                                    (v128.const f64x2 0x1.23456789abcdfp+99 0x1.23456789abcdfp+99))
(assert_return (invoke "f64x2.pmax" (v128.const f64x2 0123456789.e019 0123456789.e019)
                                    (v128.const f64x2 0x0123456789ABCDEFabcdefp+019 0x0123456789ABCDEFabcdefp+019))
                                    (v128.const f64x2 0x1.23456789abcdfp+99 0x1.23456789abcdfp+99))
(assert_return (invoke "f64x2.pmax" (v128.const f64x2 0123456789.e019 0123456789.e019)
                                    (v128.const f64x2 0x0123456789ABCDEFabcdefp-019 0x0123456789ABCDEFabcdefp-019))
                                    (v128.const f64x2 0x1.fe9af5b5e16fap+89 0x1.fe9af5b5e16fap+89))
(assert_return (invoke "f64x2.pmax" (v128.const f64x2 0123456789.e019 0123456789.e019)
                                    (v128.const f64x2 0x0123456789ABCDEFabcdef. 0x0123456789ABCDEFabcdef.))
                                    (v128.const f64x2 0x1.fe9af5b5e16fap+89 0x1.fe9af5b5e16fap+89))
(assert_return (invoke "f64x2.pmax" (v128.const f64x2 0123456789.e019 0123456789.e019)
                                    (v128.const f64x2 0x0123456789ABCDEFabcdef.p019 0x0123456789ABCDEFabcdef.p019))
                                    (v128.const f64x2 0x1.23456789abcdfp+99 0x1.23456789abcdfp+99))
(assert_return (invoke "f64x2.pmax" (v128.const f64x2 0123456789.e019 0123456789.e019)
                                    (v128.const f64x2 0x0123456789ABCDEFabcdef.p+019 0x0123456789ABCDEFabcdef.p+019))
                                    (v128.const f64x2 0x1.23456789abcdfp+99 0x1.23456789abcdfp+99))
(assert_return (invoke "f64x2.pmax" (v128.const f64x2 0123456789.e019 0123456789.e019)
                                    (v128.const f64x2 0x0123456789ABCDEFabcdef.p-019 0x0123456789ABCDEFabcdef.p-019))
                                    (v128.const f64x2 0x1.fe9af5b5e16fap+89 0x1.fe9af5b5e16fap+89))
(assert_return (invoke "f64x2.pmax" (v128.const f64x2 0123456789.e019 0123456789.e019)
                                    (v128.const f64x2 0x0123456789ABCDEFabcdef.0123456789ABCDEFabcdef 0x0123456789ABCDEFabcdef.0123456789ABCDEFabcdef))
                                    (v128.const f64x2 0x1.fe9af5b5e16fap+89 0x1.fe9af5b5e16fap+89))
(assert_return (invoke "f64x2.pmax" (v128.const f64x2 0123456789.e019 0123456789.e019)
                                    (v128.const f64x2 0x0123456789ABCDEFabcdef.0123456789ABCDEFabcdefp019 0x0123456789ABCDEFabcdef.0123456789ABCDEFabcdefp019))
                                    (v128.const f64x2 0x1.23456789abcdfp+99 0x1.23456789abcdfp+99))
(assert_return (invoke "f64x2.pmax" (v128.const f64x2 0123456789.e019 0123456789.e019)
                                    (v128.const f64x2 0x0123456789ABCDEFabcdef.0123456789ABCDEFabcdefp+019 0x0123456789ABCDEFabcdef.0123456789ABCDEFabcdefp+019))
                                    (v128.const f64x2 0x1.23456789abcdfp+99 0x1.23456789abcdfp+99))
(assert_return (invoke "f64x2.pmax" (v128.const f64x2 0123456789.e019 0123456789.e019)
                                    (v128.const f64x2 0x0123456789ABCDEFabcdef.0123456789ABCDEFabcdefp-019 0x0123456789ABCDEFabcdef.0123456789ABCDEFabcdefp-019))
                                    (v128.const f64x2 0x1.fe9af5b5e16fap+89 0x1.fe9af5b5e16fap+89))
(assert_return (invoke "f64x2.pmax" (v128.const f64x2 0123456789.e+019 0123456789.e+019)
                                    (v128.const f64x2 0x0p+0 0x0p+0))
                                    (v128.const f64x2 0x1.fe9af5b5e16fap+89 0x1.fe9af5b5e16fap+89))
(assert_return (invoke "f64x2.pmax" (v128.const f64x2 0123456789.e+019 0123456789.e+019)
                                    (v128.const f64x2 -0x0p+0 -0x0p+0))
                                    (v128.const f64x2 0x1.fe9af5b5e16fap+89 0x1.fe9af5b5e16fap+89))
(assert_return (invoke "f64x2.pmax" (v128.const f64x2 0123456789.e+019 0123456789.e+019)
                                    (v128.const f64x2 0x1p-1022 0x1p-1022))
                                    (v128.const f64x2 0x1.fe9af5b5e16fap+89 0x1.fe9af5b5e16fap+89))
(assert_return (invoke "f64x2.pmax" (v128.const f64x2 0123456789.e+019 0123456789.e+019)
                                    (v128.const f64x2 -0x1p-1022 -0x1p-1022))
                                    (v128.const f64x2 0x1.fe9af5b5e16fap+89 0x1.fe9af5b5e16fap+89))
(assert_return (invoke "f64x2.pmax" (v128.const f64x2 0123456789.e+019 0123456789.e+019)
                                    (v128.const f64x2 0x1p-1 0x1p-1))
                                    (v128.const f64x2 0x1.fe9af5b5e16fap+89 0x1.fe9af5b5e16fap+89))
(assert_return (invoke "f64x2.pmax" (v128.const f64x2 0123456789.e+019 0123456789.e+019)
                                    (v128.const f64x2 -0x1p-1 -0x1p-1))
                                    (v128.const f64x2 0x1.fe9af5b5e16fap+89 0x1.fe9af5b5e16fap+89))
(assert_return (invoke "f64x2.pmax" (v128.const f64x2 0123456789.e+019 0123456789.e+019)
                                    (v128.const f64x2 0x1p+0 0x1p+0))
                                    (v128.const f64x2 0x1.fe9af5b5e16fap+89 0x1.fe9af5b5e16fap+89))
(assert_return (invoke "f64x2.pmax" (v128.const f64x2 0123456789.e+019 0123456789.e+019)
                                    (v128.const f64x2 -0x1p+0 -0x1p+0))
                                    (v128.const f64x2 0x1.fe9af5b5e16fap+89 0x1.fe9af5b5e16fap+89))
(assert_return (invoke "f64x2.pmax" (v128.const f64x2 0123456789.e+019 0123456789.e+019)
                                    (v128.const f64x2 0x1.921fb54442d18p+2 0x1.921fb54442d18p+2))
                                    (v128.const f64x2 0x1.fe9af5b5e16fap+89 0x1.fe9af5b5e16fap+89))
(assert_return (invoke "f64x2.pmax" (v128.const f64x2 0123456789.e+019 0123456789.e+019)
                                    (v128.const f64x2 -0x1.921fb54442d18p+2 -0x1.921fb54442d18p+2))
                                    (v128.const f64x2 0x1.fe9af5b5e16fap+89 0x1.fe9af5b5e16fap+89))
(assert_return (invoke "f64x2.pmax" (v128.const f64x2 0123456789.e+019 0123456789.e+019)
                                    (v128.const f64x2 0x1.fffffffffffffp+1023 0x1.fffffffffffffp+1023))
                                    (v128.const f64x2 0x1.fffffffffffffp+1023 0x1.fffffffffffffp+1023))
(assert_return (invoke "f64x2.pmax" (v128.const f64x2 0123456789.e+019 0123456789.e+019)
                                    (v128.const f64x2 -0x1.fffffffffffffp+1023 -0x1.fffffffffffffp+1023))
                                    (v128.const f64x2 0x1.fe9af5b5e16fap+89 0x1.fe9af5b5e16fap+89))
(assert_return (invoke "f64x2.pmax" (v128.const f64x2 0123456789.e+019 0123456789.e+019)
                                    (v128.const f64x2 0x0.0000000000001p-1022 0x0.0000000000001p-1022))
                                    (v128.const f64x2 0x1.fe9af5b5e16fap+89 0x1.fe9af5b5e16fap+89))
(assert_return (invoke "f64x2.pmax" (v128.const f64x2 0123456789.e+019 0123456789.e+019)
                                    (v128.const f64x2 0x0.0000000000001p-1022 0x0.0000000000001p-1022))
                                    (v128.const f64x2 0x1.fe9af5b5e16fap+89 0x1.fe9af5b5e16fap+89))
(assert_return (invoke "f64x2.pmax" (v128.const f64x2 0123456789.e+019 0123456789.e+019)
                                    (v128.const f64x2 inf inf))
                                    (v128.const f64x2 inf inf))
(assert_return (invoke "f64x2.pmax" (v128.const f64x2 0123456789.e+019 0123456789.e+019)
                                    (v128.const f64x2 -inf -inf))
                                    (v128.const f64x2 0x1.fe9af5b5e16fap+89 0x1.fe9af5b5e16fap+89))
(assert_return (invoke "f64x2.pmax" (v128.const f64x2 0123456789.e+019 0123456789.e+019)
                                    (v128.const f64x2 0123456789 0123456789))
                                    (v128.const f64x2 0x1.fe9af5b5e16fap+89 0x1.fe9af5b5e16fap+89))
(assert_return (invoke "f64x2.pmax" (v128.const f64x2 0123456789.e+019 0123456789.e+019)
                                    (v128.const f64x2 0123456789e019 0123456789e019))
                                    (v128.const f64x2 0x1.fe9af5b5e16fap+89 0x1.fe9af5b5e16fap+89))
(assert_return (invoke "f64x2.pmax" (v128.const f64x2 0123456789.e+019 0123456789.e+019)
                                    (v128.const f64x2 0123456789e+019 0123456789e+019))
                                    (v128.const f64x2 0x1.fe9af5b5e16fap+89 0x1.fe9af5b5e16fap+89))
(assert_return (invoke "f64x2.pmax" (v128.const f64x2 0123456789.e+019 0123456789.e+019)
                                    (v128.const f64x2 0123456789e-019 0123456789e-019))
                                    (v128.const f64x2 0x1.fe9af5b5e16fap+89 0x1.fe9af5b5e16fap+89))
(assert_return (invoke "f64x2.pmax" (v128.const f64x2 0123456789.e+019 0123456789.e+019)
                                    (v128.const f64x2 0123456789. 0123456789.))
                                    (v128.const f64x2 0x1.fe9af5b5e16fap+89 0x1.fe9af5b5e16fap+89))
(assert_return (invoke "f64x2.pmax" (v128.const f64x2 0123456789.e+019 0123456789.e+019)
                                    (v128.const f64x2 0123456789.e019 0123456789.e019))
                                    (v128.const f64x2 0x1.fe9af5b5e16fap+89 0x1.fe9af5b5e16fap+89))
(assert_return (invoke "f64x2.pmax" (v128.const f64x2 0123456789.e+019 0123456789.e+019)
                                    (v128.const f64x2 0123456789.e+019 0123456789.e+019))
                                    (v128.const f64x2 0x1.fe9af5b5e16fap+89 0x1.fe9af5b5e16fap+89))
(assert_return (invoke "f64x2.pmax" (v128.const f64x2 0123456789.e+019 0123456789.e+019)
                                    (v128.const f64x2 0123456789.e-019 0123456789.e-019))
                                    (v128.const f64x2 0x1.fe9af5b5e16fap+89 0x1.fe9af5b5e16fap+89))
(assert_return (invoke "f64x2.pmax" (v128.const f64x2 0123456789.e+019 0123456789.e+019)
                                    (v128.const f64x2 0123456789.0123456789 0123456789.0123456789))
                                    (v128.const f64x2 0x1.fe9af5b5e16fap+89 0x1.fe9af5b5e16fap+89))
(assert_return (invoke "f64x2.pmax" (v128.const f64x2 0123456789.e+019 0123456789.e+019)
                                    (v128.const f64x2 0123456789.0123456789e019 0123456789.0123456789e019))
                                    (v128.const f64x2 0x1.fe9af5b6bcbd5p+89 0x1.fe9af5b6bcbd5p+89))
(assert_return (invoke "f64x2.pmax" (v128.const f64x2 0123456789.e+019 0123456789.e+019)
                                    (v128.const f64x2 0123456789.0123456789e+019 0123456789.0123456789e+019))
                                    (v128.const f64x2 0x1.fe9af5b6bcbd5p+89 0x1.fe9af5b6bcbd5p+89))
(assert_return (invoke "f64x2.pmax" (v128.const f64x2 0123456789.e+019 0123456789.e+019)
                                    (v128.const f64x2 0123456789.0123456789e-019 0123456789.0123456789e-019))
                                    (v128.const f64x2 0x1.fe9af5b5e16fap+89 0x1.fe9af5b5e16fap+89))
(assert_return (invoke "f64x2.pmax" (v128.const f64x2 0123456789.e+019 0123456789.e+019)
                                    (v128.const f64x2 0x0123456789ABCDEFabcdef 0x0123456789ABCDEFabcdef))
                                    (v128.const f64x2 0x1.fe9af5b5e16fap+89 0x1.fe9af5b5e16fap+89))
(assert_return (invoke "f64x2.pmax" (v128.const f64x2 0123456789.e+019 0123456789.e+019)
                                    (v128.const f64x2 0x0123456789ABCDEFabcdefp019 0x0123456789ABCDEFabcdefp019))
                                    (v128.const f64x2 0x1.23456789abcdfp+99 0x1.23456789abcdfp+99))
(assert_return (invoke "f64x2.pmax" (v128.const f64x2 0123456789.e+019 0123456789.e+019)
                                    (v128.const f64x2 0x0123456789ABCDEFabcdefp+019 0x0123456789ABCDEFabcdefp+019))
                                    (v128.const f64x2 0x1.23456789abcdfp+99 0x1.23456789abcdfp+99))
(assert_return (invoke "f64x2.pmax" (v128.const f64x2 0123456789.e+019 0123456789.e+019)
                                    (v128.const f64x2 0x0123456789ABCDEFabcdefp-019 0x0123456789ABCDEFabcdefp-019))
                                    (v128.const f64x2 0x1.fe9af5b5e16fap+89 0x1.fe9af5b5e16fap+89))
(assert_return (invoke "f64x2.pmax" (v128.const f64x2 0123456789.e+019 0123456789.e+019)
                                    (v128.const f64x2 0x0123456789ABCDEFabcdef. 0x0123456789ABCDEFabcdef.))
                                    (v128.const f64x2 0x1.fe9af5b5e16fap+89 0x1.fe9af5b5e16fap+89))
(assert_return (invoke "f64x2.pmax" (v128.const f64x2 0123456789.e+019 0123456789.e+019)
                                    (v128.const f64x2 0x0123456789ABCDEFabcdef.p019 0x0123456789ABCDEFabcdef.p019))
                                    (v128.const f64x2 0x1.23456789abcdfp+99 0x1.23456789abcdfp+99))
(assert_return (invoke "f64x2.pmax" (v128.const f64x2 0123456789.e+019 0123456789.e+019)
                                    (v128.const f64x2 0x0123456789ABCDEFabcdef.p+019 0x0123456789ABCDEFabcdef.p+019))
                                    (v128.const f64x2 0x1.23456789abcdfp+99 0x1.23456789abcdfp+99))
(assert_return (invoke "f64x2.pmax" (v128.const f64x2 0123456789.e+019 0123456789.e+019)
                                    (v128.const f64x2 0x0123456789ABCDEFabcdef.p-019 0x0123456789ABCDEFabcdef.p-019))
                                    (v128.const f64x2 0x1.fe9af5b5e16fap+89 0x1.fe9af5b5e16fap+89))
(assert_return (invoke "f64x2.pmax" (v128.const f64x2 0123456789.e+019 0123456789.e+019)
                                    (v128.const f64x2 0x0123456789ABCDEFabcdef.0123456789ABCDEFabcdef 0x0123456789ABCDEFabcdef.0123456789ABCDEFabcdef))
                                    (v128.const f64x2 0x1.fe9af5b5e16fap+89 0x1.fe9af5b5e16fap+89))
(assert_return (invoke "f64x2.pmax" (v128.const f64x2 0123456789.e+019 0123456789.e+019)
                                    (v128.const f64x2 0x0123456789ABCDEFabcdef.0123456789ABCDEFabcdefp019 0x0123456789ABCDEFabcdef.0123456789ABCDEFabcdefp019))
                                    (v128.const f64x2 0x1.23456789abcdfp+99 0x1.23456789abcdfp+99))
(assert_return (invoke "f64x2.pmax" (v128.const f64x2 0123456789.e+019 0123456789.e+019)
                                    (v128.const f64x2 0x0123456789ABCDEFabcdef.0123456789ABCDEFabcdefp+019 0x0123456789ABCDEFabcdef.0123456789ABCDEFabcdefp+019))
                                    (v128.const f64x2 0x1.23456789abcdfp+99 0x1.23456789abcdfp+99))
(assert_return (invoke "f64x2.pmax" (v128.const f64x2 0123456789.e+019 0123456789.e+019)
                                    (v128.const f64x2 0x0123456789ABCDEFabcdef.0123456789ABCDEFabcdefp-019 0x0123456789ABCDEFabcdef.0123456789ABCDEFabcdefp-019))
                                    (v128.const f64x2 0x1.fe9af5b5e16fap+89 0x1.fe9af5b5e16fap+89))
(assert_return (invoke "f64x2.pmax" (v128.const f64x2 0123456789.e-019 0123456789.e-019)
                                    (v128.const f64x2 0x0p+0 0x0p+0))
                                    (v128.const f64x2 0x1.b25ffd62b4311p-37 0x1.b25ffd62b4311p-37))
(assert_return (invoke "f64x2.pmax" (v128.const f64x2 0123456789.e-019 0123456789.e-019)
                                    (v128.const f64x2 -0x0p+0 -0x0p+0))
                                    (v128.const f64x2 0x1.b25ffd62b4311p-37 0x1.b25ffd62b4311p-37))
(assert_return (invoke "f64x2.pmax" (v128.const f64x2 0123456789.e-019 0123456789.e-019)
                                    (v128.const f64x2 0x1p-1022 0x1p-1022))
                                    (v128.const f64x2 0x1.b25ffd62b4311p-37 0x1.b25ffd62b4311p-37))
(assert_return (invoke "f64x2.pmax" (v128.const f64x2 0123456789.e-019 0123456789.e-019)
                                    (v128.const f64x2 -0x1p-1022 -0x1p-1022))
                                    (v128.const f64x2 0x1.b25ffd62b4311p-37 0x1.b25ffd62b4311p-37))
(assert_return (invoke "f64x2.pmax" (v128.const f64x2 0123456789.e-019 0123456789.e-019)
                                    (v128.const f64x2 0x1p-1 0x1p-1))
                                    (v128.const f64x2 0x1.0000000000000p-1 0x1.0000000000000p-1))
(assert_return (invoke "f64x2.pmax" (v128.const f64x2 0123456789.e-019 0123456789.e-019)
                                    (v128.const f64x2 -0x1p-1 -0x1p-1))
                                    (v128.const f64x2 0x1.b25ffd62b4311p-37 0x1.b25ffd62b4311p-37))
(assert_return (invoke "f64x2.pmax" (v128.const f64x2 0123456789.e-019 0123456789.e-019)
                                    (v128.const f64x2 0x1p+0 0x1p+0))
                                    (v128.const f64x2 0x1.0000000000000p+0 0x1.0000000000000p+0))
(assert_return (invoke "f64x2.pmax" (v128.const f64x2 0123456789.e-019 0123456789.e-019)
                                    (v128.const f64x2 -0x1p+0 -0x1p+0))
                                    (v128.const f64x2 0x1.b25ffd62b4311p-37 0x1.b25ffd62b4311p-37))
(assert_return (invoke "f64x2.pmax" (v128.const f64x2 0123456789.e-019 0123456789.e-019)
                                    (v128.const f64x2 0x1.921fb54442d18p+2 0x1.921fb54442d18p+2))
                                    (v128.const f64x2 0x1.921fb54442d18p+2 0x1.921fb54442d18p+2))
(assert_return (invoke "f64x2.pmax" (v128.const f64x2 0123456789.e-019 0123456789.e-019)
                                    (v128.const f64x2 -0x1.921fb54442d18p+2 -0x1.921fb54442d18p+2))
                                    (v128.const f64x2 0x1.b25ffd62b4311p-37 0x1.b25ffd62b4311p-37))
(assert_return (invoke "f64x2.pmax" (v128.const f64x2 0123456789.e-019 0123456789.e-019)
                                    (v128.const f64x2 0x1.fffffffffffffp+1023 0x1.fffffffffffffp+1023))
                                    (v128.const f64x2 0x1.fffffffffffffp+1023 0x1.fffffffffffffp+1023))
(assert_return (invoke "f64x2.pmax" (v128.const f64x2 0123456789.e-019 0123456789.e-019)
                                    (v128.const f64x2 -0x1.fffffffffffffp+1023 -0x1.fffffffffffffp+1023))
                                    (v128.const f64x2 0x1.b25ffd62b4311p-37 0x1.b25ffd62b4311p-37))
(assert_return (invoke "f64x2.pmax" (v128.const f64x2 0123456789.e-019 0123456789.e-019)
                                    (v128.const f64x2 0x0.0000000000001p-1022 0x0.0000000000001p-1022))
                                    (v128.const f64x2 0x1.b25ffd62b4311p-37 0x1.b25ffd62b4311p-37))
(assert_return (invoke "f64x2.pmax" (v128.const f64x2 0123456789.e-019 0123456789.e-019)
                                    (v128.const f64x2 0x0.0000000000001p-1022 0x0.0000000000001p-1022))
                                    (v128.const f64x2 0x1.b25ffd62b4311p-37 0x1.b25ffd62b4311p-37))
(assert_return (invoke "f64x2.pmax" (v128.const f64x2 0123456789.e-019 0123456789.e-019)
                                    (v128.const f64x2 inf inf))
                                    (v128.const f64x2 inf inf))
(assert_return (invoke "f64x2.pmax" (v128.const f64x2 0123456789.e-019 0123456789.e-019)
                                    (v128.const f64x2 -inf -inf))
                                    (v128.const f64x2 0x1.b25ffd62b4311p-37 0x1.b25ffd62b4311p-37))
(assert_return (invoke "f64x2.pmax" (v128.const f64x2 0123456789.e-019 0123456789.e-019)
                                    (v128.const f64x2 0123456789 0123456789))
                                    (v128.const f64x2 0x1.d6f3454000000p+26 0x1.d6f3454000000p+26))
(assert_return (invoke "f64x2.pmax" (v128.const f64x2 0123456789.e-019 0123456789.e-019)
                                    (v128.const f64x2 0123456789e019 0123456789e019))
                                    (v128.const f64x2 0x1.fe9af5b5e16fap+89 0x1.fe9af5b5e16fap+89))
(assert_return (invoke "f64x2.pmax" (v128.const f64x2 0123456789.e-019 0123456789.e-019)
                                    (v128.const f64x2 0123456789e+019 0123456789e+019))
                                    (v128.const f64x2 0x1.fe9af5b5e16fap+89 0x1.fe9af5b5e16fap+89))
(assert_return (invoke "f64x2.pmax" (v128.const f64x2 0123456789.e-019 0123456789.e-019)
                                    (v128.const f64x2 0123456789e-019 0123456789e-019))
                                    (v128.const f64x2 0x1.b25ffd62b4311p-37 0x1.b25ffd62b4311p-37))
(assert_return (invoke "f64x2.pmax" (v128.const f64x2 0123456789.e-019 0123456789.e-019)
                                    (v128.const f64x2 0123456789. 0123456789.))
                                    (v128.const f64x2 0x1.d6f3454000000p+26 0x1.d6f3454000000p+26))
(assert_return (invoke "f64x2.pmax" (v128.const f64x2 0123456789.e-019 0123456789.e-019)
                                    (v128.const f64x2 0123456789.e019 0123456789.e019))
                                    (v128.const f64x2 0x1.fe9af5b5e16fap+89 0x1.fe9af5b5e16fap+89))
(assert_return (invoke "f64x2.pmax" (v128.const f64x2 0123456789.e-019 0123456789.e-019)
                                    (v128.const f64x2 0123456789.e+019 0123456789.e+019))
                                    (v128.const f64x2 0x1.fe9af5b5e16fap+89 0x1.fe9af5b5e16fap+89))
(assert_return (invoke "f64x2.pmax" (v128.const f64x2 0123456789.e-019 0123456789.e-019)
                                    (v128.const f64x2 0123456789.e-019 0123456789.e-019))
                                    (v128.const f64x2 0x1.b25ffd62b4311p-37 0x1.b25ffd62b4311p-37))
(assert_return (invoke "f64x2.pmax" (v128.const f64x2 0123456789.e-019 0123456789.e-019)
                                    (v128.const f64x2 0123456789.0123456789 0123456789.0123456789))
                                    (v128.const f64x2 0x1.d6f34540ca458p+26 0x1.d6f34540ca458p+26))
(assert_return (invoke "f64x2.pmax" (v128.const f64x2 0123456789.e-019 0123456789.e-019)
                                    (v128.const f64x2 0123456789.0123456789e019 0123456789.0123456789e019))
                                    (v128.const f64x2 0x1.fe9af5b6bcbd5p+89 0x1.fe9af5b6bcbd5p+89))
(assert_return (invoke "f64x2.pmax" (v128.const f64x2 0123456789.e-019 0123456789.e-019)
                                    (v128.const f64x2 0123456789.0123456789e+019 0123456789.0123456789e+019))
                                    (v128.const f64x2 0x1.fe9af5b6bcbd5p+89 0x1.fe9af5b6bcbd5p+89))
(assert_return (invoke "f64x2.pmax" (v128.const f64x2 0123456789.e-019 0123456789.e-019)
                                    (v128.const f64x2 0123456789.0123456789e-019 0123456789.0123456789e-019))
                                    (v128.const f64x2 0x1.b25ffd636ec12p-37 0x1.b25ffd636ec12p-37))
(assert_return (invoke "f64x2.pmax" (v128.const f64x2 0123456789.e-019 0123456789.e-019)
                                    (v128.const f64x2 0x0123456789ABCDEFabcdef 0x0123456789ABCDEFabcdef))
                                    (v128.const f64x2 0x1.23456789abcdfp+80 0x1.23456789abcdfp+80))
(assert_return (invoke "f64x2.pmax" (v128.const f64x2 0123456789.e-019 0123456789.e-019)
                                    (v128.const f64x2 0x0123456789ABCDEFabcdefp019 0x0123456789ABCDEFabcdefp019))
                                    (v128.const f64x2 0x1.23456789abcdfp+99 0x1.23456789abcdfp+99))
(assert_return (invoke "f64x2.pmax" (v128.const f64x2 0123456789.e-019 0123456789.e-019)
                                    (v128.const f64x2 0x0123456789ABCDEFabcdefp+019 0x0123456789ABCDEFabcdefp+019))
                                    (v128.const f64x2 0x1.23456789abcdfp+99 0x1.23456789abcdfp+99))
(assert_return (invoke "f64x2.pmax" (v128.const f64x2 0123456789.e-019 0123456789.e-019)
                                    (v128.const f64x2 0x0123456789ABCDEFabcdefp-019 0x0123456789ABCDEFabcdefp-019))
                                    (v128.const f64x2 0x1.23456789abcdfp+61 0x1.23456789abcdfp+61))
(assert_return (invoke "f64x2.pmax" (v128.const f64x2 0123456789.e-019 0123456789.e-019)
                                    (v128.const f64x2 0x0123456789ABCDEFabcdef. 0x0123456789ABCDEFabcdef.))
                                    (v128.const f64x2 0x1.23456789abcdfp+80 0x1.23456789abcdfp+80))
(assert_return (invoke "f64x2.pmax" (v128.const f64x2 0123456789.e-019 0123456789.e-019)
                                    (v128.const f64x2 0x0123456789ABCDEFabcdef.p019 0x0123456789ABCDEFabcdef.p019))
                                    (v128.const f64x2 0x1.23456789abcdfp+99 0x1.23456789abcdfp+99))
(assert_return (invoke "f64x2.pmax" (v128.const f64x2 0123456789.e-019 0123456789.e-019)
                                    (v128.const f64x2 0x0123456789ABCDEFabcdef.p+019 0x0123456789ABCDEFabcdef.p+019))
                                    (v128.const f64x2 0x1.23456789abcdfp+99 0x1.23456789abcdfp+99))
(assert_return (invoke "f64x2.pmax" (v128.const f64x2 0123456789.e-019 0123456789.e-019)
                                    (v128.const f64x2 0x0123456789ABCDEFabcdef.p-019 0x0123456789ABCDEFabcdef.p-019))
                                    (v128.const f64x2 0x1.23456789abcdfp+61 0x1.23456789abcdfp+61))
(assert_return (invoke "f64x2.pmax" (v128.const f64x2 0123456789.e-019 0123456789.e-019)
                                    (v128.const f64x2 0x0123456789ABCDEFabcdef.0123456789ABCDEFabcdef 0x0123456789ABCDEFabcdef.0123456789ABCDEFabcdef))
                                    (v128.const f64x2 0x1.23456789abcdfp+80 0x1.23456789abcdfp+80))
(assert_return (invoke "f64x2.pmax" (v128.const f64x2 0123456789.e-019 0123456789.e-019)
                                    (v128.const f64x2 0x0123456789ABCDEFabcdef.0123456789ABCDEFabcdefp019 0x0123456789ABCDEFabcdef.0123456789ABCDEFabcdefp019))
                                    (v128.const f64x2 0x1.23456789abcdfp+99 0x1.23456789abcdfp+99))
(assert_return (invoke "f64x2.pmax" (v128.const f64x2 0123456789.e-019 0123456789.e-019)
                                    (v128.const f64x2 0x0123456789ABCDEFabcdef.0123456789ABCDEFabcdefp+019 0x0123456789ABCDEFabcdef.0123456789ABCDEFabcdefp+019))
                                    (v128.const f64x2 0x1.23456789abcdfp+99 0x1.23456789abcdfp+99))
(assert_return (invoke "f64x2.pmax" (v128.const f64x2 0123456789.e-019 0123456789.e-019)
                                    (v128.const f64x2 0x0123456789ABCDEFabcdef.0123456789ABCDEFabcdefp-019 0x0123456789ABCDEFabcdef.0123456789ABCDEFabcdefp-019))
                                    (v128.const f64x2 0x1.23456789abcdfp+61 0x1.23456789abcdfp+61))
(assert_return (invoke "f64x2.pmax" (v128.const f64x2 0123456789.0123456789 0123456789.0123456789)
                                    (v128.const f64x2 0x0p+0 0x0p+0))
                                    (v128.const f64x2 0x1.d6f34540ca458p+26 0x1.d6f34540ca458p+26))
(assert_return (invoke "f64x2.pmax" (v128.const f64x2 0123456789.0123456789 0123456789.0123456789)
                                    (v128.const f64x2 -0x0p+0 -0x0p+0))
                                    (v128.const f64x2 0x1.d6f34540ca458p+26 0x1.d6f34540ca458p+26))
(assert_return (invoke "f64x2.pmax" (v128.const f64x2 0123456789.0123456789 0123456789.0123456789)
                                    (v128.const f64x2 0x1p-1022 0x1p-1022))
                                    (v128.const f64x2 0x1.d6f34540ca458p+26 0x1.d6f34540ca458p+26))
(assert_return (invoke "f64x2.pmax" (v128.const f64x2 0123456789.0123456789 0123456789.0123456789)
                                    (v128.const f64x2 -0x1p-1022 -0x1p-1022))
                                    (v128.const f64x2 0x1.d6f34540ca458p+26 0x1.d6f34540ca458p+26))
(assert_return (invoke "f64x2.pmax" (v128.const f64x2 0123456789.0123456789 0123456789.0123456789)
                                    (v128.const f64x2 0x1p-1 0x1p-1))
                                    (v128.const f64x2 0x1.d6f34540ca458p+26 0x1.d6f34540ca458p+26))
(assert_return (invoke "f64x2.pmax" (v128.const f64x2 0123456789.0123456789 0123456789.0123456789)
                                    (v128.const f64x2 -0x1p-1 -0x1p-1))
                                    (v128.const f64x2 0x1.d6f34540ca458p+26 0x1.d6f34540ca458p+26))
(assert_return (invoke "f64x2.pmax" (v128.const f64x2 0123456789.0123456789 0123456789.0123456789)
                                    (v128.const f64x2 0x1p+0 0x1p+0))
                                    (v128.const f64x2 0x1.d6f34540ca458p+26 0x1.d6f34540ca458p+26))
(assert_return (invoke "f64x2.pmax" (v128.const f64x2 0123456789.0123456789 0123456789.0123456789)
                                    (v128.const f64x2 -0x1p+0 -0x1p+0))
                                    (v128.const f64x2 0x1.d6f34540ca458p+26 0x1.d6f34540ca458p+26))
(assert_return (invoke "f64x2.pmax" (v128.const f64x2 0123456789.0123456789 0123456789.0123456789)
                                    (v128.const f64x2 0x1.921fb54442d18p+2 0x1.921fb54442d18p+2))
                                    (v128.const f64x2 0x1.d6f34540ca458p+26 0x1.d6f34540ca458p+26))
(assert_return (invoke "f64x2.pmax" (v128.const f64x2 0123456789.0123456789 0123456789.0123456789)
                                    (v128.const f64x2 -0x1.921fb54442d18p+2 -0x1.921fb54442d18p+2))
                                    (v128.const f64x2 0x1.d6f34540ca458p+26 0x1.d6f34540ca458p+26))
(assert_return (invoke "f64x2.pmax" (v128.const f64x2 0123456789.0123456789 0123456789.0123456789)
                                    (v128.const f64x2 0x1.fffffffffffffp+1023 0x1.fffffffffffffp+1023))
                                    (v128.const f64x2 0x1.fffffffffffffp+1023 0x1.fffffffffffffp+1023))
(assert_return (invoke "f64x2.pmax" (v128.const f64x2 0123456789.0123456789 0123456789.0123456789)
                                    (v128.const f64x2 -0x1.fffffffffffffp+1023 -0x1.fffffffffffffp+1023))
                                    (v128.const f64x2 0x1.d6f34540ca458p+26 0x1.d6f34540ca458p+26))
(assert_return (invoke "f64x2.pmax" (v128.const f64x2 0123456789.0123456789 0123456789.0123456789)
                                    (v128.const f64x2 0x0.0000000000001p-1022 0x0.0000000000001p-1022))
                                    (v128.const f64x2 0x1.d6f34540ca458p+26 0x1.d6f34540ca458p+26))
(assert_return (invoke "f64x2.pmax" (v128.const f64x2 0123456789.0123456789 0123456789.0123456789)
                                    (v128.const f64x2 0x0.0000000000001p-1022 0x0.0000000000001p-1022))
                                    (v128.const f64x2 0x1.d6f34540ca458p+26 0x1.d6f34540ca458p+26))
(assert_return (invoke "f64x2.pmax" (v128.const f64x2 0123456789.0123456789 0123456789.0123456789)
                                    (v128.const f64x2 inf inf))
                                    (v128.const f64x2 inf inf))
(assert_return (invoke "f64x2.pmax" (v128.const f64x2 0123456789.0123456789 0123456789.0123456789)
                                    (v128.const f64x2 -inf -inf))
                                    (v128.const f64x2 0x1.d6f34540ca458p+26 0x1.d6f34540ca458p+26))
(assert_return (invoke "f64x2.pmax" (v128.const f64x2 0123456789.0123456789 0123456789.0123456789)
                                    (v128.const f64x2 0123456789 0123456789))
                                    (v128.const f64x2 0x1.d6f34540ca458p+26 0x1.d6f34540ca458p+26))
(assert_return (invoke "f64x2.pmax" (v128.const f64x2 0123456789.0123456789 0123456789.0123456789)
                                    (v128.const f64x2 0123456789e019 0123456789e019))
                                    (v128.const f64x2 0x1.fe9af5b5e16fap+89 0x1.fe9af5b5e16fap+89))
(assert_return (invoke "f64x2.pmax" (v128.const f64x2 0123456789.0123456789 0123456789.0123456789)
                                    (v128.const f64x2 0123456789e+019 0123456789e+019))
                                    (v128.const f64x2 0x1.fe9af5b5e16fap+89 0x1.fe9af5b5e16fap+89))
(assert_return (invoke "f64x2.pmax" (v128.const f64x2 0123456789.0123456789 0123456789.0123456789)
                                    (v128.const f64x2 0123456789e-019 0123456789e-019))
                                    (v128.const f64x2 0x1.d6f34540ca458p+26 0x1.d6f34540ca458p+26))
(assert_return (invoke "f64x2.pmax" (v128.const f64x2 0123456789.0123456789 0123456789.0123456789)
                                    (v128.const f64x2 0123456789. 0123456789.))
                                    (v128.const f64x2 0x1.d6f34540ca458p+26 0x1.d6f34540ca458p+26))
(assert_return (invoke "f64x2.pmax" (v128.const f64x2 0123456789.0123456789 0123456789.0123456789)
                                    (v128.const f64x2 0123456789.e019 0123456789.e019))
                                    (v128.const f64x2 0x1.fe9af5b5e16fap+89 0x1.fe9af5b5e16fap+89))
(assert_return (invoke "f64x2.pmax" (v128.const f64x2 0123456789.0123456789 0123456789.0123456789)
                                    (v128.const f64x2 0123456789.e+019 0123456789.e+019))
                                    (v128.const f64x2 0x1.fe9af5b5e16fap+89 0x1.fe9af5b5e16fap+89))
(assert_return (invoke "f64x2.pmax" (v128.const f64x2 0123456789.0123456789 0123456789.0123456789)
                                    (v128.const f64x2 0123456789.e-019 0123456789.e-019))
                                    (v128.const f64x2 0x1.d6f34540ca458p+26 0x1.d6f34540ca458p+26))
(assert_return (invoke "f64x2.pmax" (v128.const f64x2 0123456789.0123456789 0123456789.0123456789)
                                    (v128.const f64x2 0123456789.0123456789 0123456789.0123456789))
                                    (v128.const f64x2 0x1.d6f34540ca458p+26 0x1.d6f34540ca458p+26))
(assert_return (invoke "f64x2.pmax" (v128.const f64x2 0123456789.0123456789 0123456789.0123456789)
                                    (v128.const f64x2 0123456789.0123456789e019 0123456789.0123456789e019))
                                    (v128.const f64x2 0x1.fe9af5b6bcbd5p+89 0x1.fe9af5b6bcbd5p+89))
(assert_return (invoke "f64x2.pmax" (v128.const f64x2 0123456789.0123456789 0123456789.0123456789)
                                    (v128.const f64x2 0123456789.0123456789e+019 0123456789.0123456789e+019))
                                    (v128.const f64x2 0x1.fe9af5b6bcbd5p+89 0x1.fe9af5b6bcbd5p+89))
(assert_return (invoke "f64x2.pmax" (v128.const f64x2 0123456789.0123456789 0123456789.0123456789)
                                    (v128.const f64x2 0123456789.0123456789e-019 0123456789.0123456789e-019))
                                    (v128.const f64x2 0x1.d6f34540ca458p+26 0x1.d6f34540ca458p+26))
(assert_return (invoke "f64x2.pmax" (v128.const f64x2 0123456789.0123456789 0123456789.0123456789)
                                    (v128.const f64x2 0x0123456789ABCDEFabcdef 0x0123456789ABCDEFabcdef))
                                    (v128.const f64x2 0x1.23456789abcdfp+80 0x1.23456789abcdfp+80))
(assert_return (invoke "f64x2.pmax" (v128.const f64x2 0123456789.0123456789 0123456789.0123456789)
                                    (v128.const f64x2 0x0123456789ABCDEFabcdefp019 0x0123456789ABCDEFabcdefp019))
                                    (v128.const f64x2 0x1.23456789abcdfp+99 0x1.23456789abcdfp+99))
(assert_return (invoke "f64x2.pmax" (v128.const f64x2 0123456789.0123456789 0123456789.0123456789)
                                    (v128.const f64x2 0x0123456789ABCDEFabcdefp+019 0x0123456789ABCDEFabcdefp+019))
                                    (v128.const f64x2 0x1.23456789abcdfp+99 0x1.23456789abcdfp+99))
(assert_return (invoke "f64x2.pmax" (v128.const f64x2 0123456789.0123456789 0123456789.0123456789)
                                    (v128.const f64x2 0x0123456789ABCDEFabcdefp-019 0x0123456789ABCDEFabcdefp-019))
                                    (v128.const f64x2 0x1.23456789abcdfp+61 0x1.23456789abcdfp+61))
(assert_return (invoke "f64x2.pmax" (v128.const f64x2 0123456789.0123456789 0123456789.0123456789)
                                    (v128.const f64x2 0x0123456789ABCDEFabcdef. 0x0123456789ABCDEFabcdef.))
                                    (v128.const f64x2 0x1.23456789abcdfp+80 0x1.23456789abcdfp+80))
(assert_return (invoke "f64x2.pmax" (v128.const f64x2 0123456789.0123456789 0123456789.0123456789)
                                    (v128.const f64x2 0x0123456789ABCDEFabcdef.p019 0x0123456789ABCDEFabcdef.p019))
                                    (v128.const f64x2 0x1.23456789abcdfp+99 0x1.23456789abcdfp+99))
(assert_return (invoke "f64x2.pmax" (v128.const f64x2 0123456789.0123456789 0123456789.0123456789)
                                    (v128.const f64x2 0x0123456789ABCDEFabcdef.p+019 0x0123456789ABCDEFabcdef.p+019))
                                    (v128.const f64x2 0x1.23456789abcdfp+99 0x1.23456789abcdfp+99))
(assert_return (invoke "f64x2.pmax" (v128.const f64x2 0123456789.0123456789 0123456789.0123456789)
                                    (v128.const f64x2 0x0123456789ABCDEFabcdef.p-019 0x0123456789ABCDEFabcdef.p-019))
                                    (v128.const f64x2 0x1.23456789abcdfp+61 0x1.23456789abcdfp+61))
(assert_return (invoke "f64x2.pmax" (v128.const f64x2 0123456789.0123456789 0123456789.0123456789)
                                    (v128.const f64x2 0x0123456789ABCDEFabcdef.0123456789ABCDEFabcdef 0x0123456789ABCDEFabcdef.0123456789ABCDEFabcdef))
                                    (v128.const f64x2 0x1.23456789abcdfp+80 0x1.23456789abcdfp+80))
(assert_return (invoke "f64x2.pmax" (v128.const f64x2 0123456789.0123456789 0123456789.0123456789)
                                    (v128.const f64x2 0x0123456789ABCDEFabcdef.0123456789ABCDEFabcdefp019 0x0123456789ABCDEFabcdef.0123456789ABCDEFabcdefp019))
                                    (v128.const f64x2 0x1.23456789abcdfp+99 0x1.23456789abcdfp+99))
(assert_return (invoke "f64x2.pmax" (v128.const f64x2 0123456789.0123456789 0123456789.0123456789)
                                    (v128.const f64x2 0x0123456789ABCDEFabcdef.0123456789ABCDEFabcdefp+019 0x0123456789ABCDEFabcdef.0123456789ABCDEFabcdefp+019))
                                    (v128.const f64x2 0x1.23456789abcdfp+99 0x1.23456789abcdfp+99))
(assert_return (invoke "f64x2.pmax" (v128.const f64x2 0123456789.0123456789 0123456789.0123456789)
                                    (v128.const f64x2 0x0123456789ABCDEFabcdef.0123456789ABCDEFabcdefp-019 0x0123456789ABCDEFabcdef.0123456789ABCDEFabcdefp-019))
                                    (v128.const f64x2 0x1.23456789abcdfp+61 0x1.23456789abcdfp+61))
(assert_return (invoke "f64x2.pmax" (v128.const f64x2 0123456789.0123456789e019 0123456789.0123456789e019)
                                    (v128.const f64x2 0x0p+0 0x0p+0))
                                    (v128.const f64x2 0x1.fe9af5b6bcbd5p+89 0x1.fe9af5b6bcbd5p+89))
(assert_return (invoke "f64x2.pmax" (v128.const f64x2 0123456789.0123456789e019 0123456789.0123456789e019)
                                    (v128.const f64x2 -0x0p+0 -0x0p+0))
                                    (v128.const f64x2 0x1.fe9af5b6bcbd5p+89 0x1.fe9af5b6bcbd5p+89))
(assert_return (invoke "f64x2.pmax" (v128.const f64x2 0123456789.0123456789e019 0123456789.0123456789e019)
                                    (v128.const f64x2 0x1p-1022 0x1p-1022))
                                    (v128.const f64x2 0x1.fe9af5b6bcbd5p+89 0x1.fe9af5b6bcbd5p+89))
(assert_return (invoke "f64x2.pmax" (v128.const f64x2 0123456789.0123456789e019 0123456789.0123456789e019)
                                    (v128.const f64x2 -0x1p-1022 -0x1p-1022))
                                    (v128.const f64x2 0x1.fe9af5b6bcbd5p+89 0x1.fe9af5b6bcbd5p+89))
(assert_return (invoke "f64x2.pmax" (v128.const f64x2 0123456789.0123456789e019 0123456789.0123456789e019)
                                    (v128.const f64x2 0x1p-1 0x1p-1))
                                    (v128.const f64x2 0x1.fe9af5b6bcbd5p+89 0x1.fe9af5b6bcbd5p+89))
(assert_return (invoke "f64x2.pmax" (v128.const f64x2 0123456789.0123456789e019 0123456789.0123456789e019)
                                    (v128.const f64x2 -0x1p-1 -0x1p-1))
                                    (v128.const f64x2 0x1.fe9af5b6bcbd5p+89 0x1.fe9af5b6bcbd5p+89))
(assert_return (invoke "f64x2.pmax" (v128.const f64x2 0123456789.0123456789e019 0123456789.0123456789e019)
                                    (v128.const f64x2 0x1p+0 0x1p+0))
                                    (v128.const f64x2 0x1.fe9af5b6bcbd5p+89 0x1.fe9af5b6bcbd5p+89))
(assert_return (invoke "f64x2.pmax" (v128.const f64x2 0123456789.0123456789e019 0123456789.0123456789e019)
                                    (v128.const f64x2 -0x1p+0 -0x1p+0))
                                    (v128.const f64x2 0x1.fe9af5b6bcbd5p+89 0x1.fe9af5b6bcbd5p+89))
(assert_return (invoke "f64x2.pmax" (v128.const f64x2 0123456789.0123456789e019 0123456789.0123456789e019)
                                    (v128.const f64x2 0x1.921fb54442d18p+2 0x1.921fb54442d18p+2))
                                    (v128.const f64x2 0x1.fe9af5b6bcbd5p+89 0x1.fe9af5b6bcbd5p+89))
(assert_return (invoke "f64x2.pmax" (v128.const f64x2 0123456789.0123456789e019 0123456789.0123456789e019)
                                    (v128.const f64x2 -0x1.921fb54442d18p+2 -0x1.921fb54442d18p+2))
                                    (v128.const f64x2 0x1.fe9af5b6bcbd5p+89 0x1.fe9af5b6bcbd5p+89))
(assert_return (invoke "f64x2.pmax" (v128.const f64x2 0123456789.0123456789e019 0123456789.0123456789e019)
                                    (v128.const f64x2 0x1.fffffffffffffp+1023 0x1.fffffffffffffp+1023))
                                    (v128.const f64x2 0x1.fffffffffffffp+1023 0x1.fffffffffffffp+1023))
(assert_return (invoke "f64x2.pmax" (v128.const f64x2 0123456789.0123456789e019 0123456789.0123456789e019)
                                    (v128.const f64x2 -0x1.fffffffffffffp+1023 -0x1.fffffffffffffp+1023))
                                    (v128.const f64x2 0x1.fe9af5b6bcbd5p+89 0x1.fe9af5b6bcbd5p+89))
(assert_return (invoke "f64x2.pmax" (v128.const f64x2 0123456789.0123456789e019 0123456789.0123456789e019)
                                    (v128.const f64x2 0x0.0000000000001p-1022 0x0.0000000000001p-1022))
                                    (v128.const f64x2 0x1.fe9af5b6bcbd5p+89 0x1.fe9af5b6bcbd5p+89))
(assert_return (invoke "f64x2.pmax" (v128.const f64x2 0123456789.0123456789e019 0123456789.0123456789e019)
                                    (v128.const f64x2 0x0.0000000000001p-1022 0x0.0000000000001p-1022))
                                    (v128.const f64x2 0x1.fe9af5b6bcbd5p+89 0x1.fe9af5b6bcbd5p+89))
(assert_return (invoke "f64x2.pmax" (v128.const f64x2 0123456789.0123456789e019 0123456789.0123456789e019)
                                    (v128.const f64x2 inf inf))
                                    (v128.const f64x2 inf inf))
(assert_return (invoke "f64x2.pmax" (v128.const f64x2 0123456789.0123456789e019 0123456789.0123456789e019)
                                    (v128.const f64x2 -inf -inf))
                                    (v128.const f64x2 0x1.fe9af5b6bcbd5p+89 0x1.fe9af5b6bcbd5p+89))
(assert_return (invoke "f64x2.pmax" (v128.const f64x2 0123456789.0123456789e019 0123456789.0123456789e019)
                                    (v128.const f64x2 0123456789 0123456789))
                                    (v128.const f64x2 0x1.fe9af5b6bcbd5p+89 0x1.fe9af5b6bcbd5p+89))
(assert_return (invoke "f64x2.pmax" (v128.const f64x2 0123456789.0123456789e019 0123456789.0123456789e019)
                                    (v128.const f64x2 0123456789e019 0123456789e019))
                                    (v128.const f64x2 0x1.fe9af5b6bcbd5p+89 0x1.fe9af5b6bcbd5p+89))
(assert_return (invoke "f64x2.pmax" (v128.const f64x2 0123456789.0123456789e019 0123456789.0123456789e019)
                                    (v128.const f64x2 0123456789e+019 0123456789e+019))
                                    (v128.const f64x2 0x1.fe9af5b6bcbd5p+89 0x1.fe9af5b6bcbd5p+89))
(assert_return (invoke "f64x2.pmax" (v128.const f64x2 0123456789.0123456789e019 0123456789.0123456789e019)
                                    (v128.const f64x2 0123456789e-019 0123456789e-019))
                                    (v128.const f64x2 0x1.fe9af5b6bcbd5p+89 0x1.fe9af5b6bcbd5p+89))
(assert_return (invoke "f64x2.pmax" (v128.const f64x2 0123456789.0123456789e019 0123456789.0123456789e019)
                                    (v128.const f64x2 0123456789. 0123456789.))
                                    (v128.const f64x2 0x1.fe9af5b6bcbd5p+89 0x1.fe9af5b6bcbd5p+89))
(assert_return (invoke "f64x2.pmax" (v128.const f64x2 0123456789.0123456789e019 0123456789.0123456789e019)
                                    (v128.const f64x2 0123456789.e019 0123456789.e019))
                                    (v128.const f64x2 0x1.fe9af5b6bcbd5p+89 0x1.fe9af5b6bcbd5p+89))
(assert_return (invoke "f64x2.pmax" (v128.const f64x2 0123456789.0123456789e019 0123456789.0123456789e019)
                                    (v128.const f64x2 0123456789.e+019 0123456789.e+019))
                                    (v128.const f64x2 0x1.fe9af5b6bcbd5p+89 0x1.fe9af5b6bcbd5p+89))
(assert_return (invoke "f64x2.pmax" (v128.const f64x2 0123456789.0123456789e019 0123456789.0123456789e019)
                                    (v128.const f64x2 0123456789.e-019 0123456789.e-019))
                                    (v128.const f64x2 0x1.fe9af5b6bcbd5p+89 0x1.fe9af5b6bcbd5p+89))
(assert_return (invoke "f64x2.pmax" (v128.const f64x2 0123456789.0123456789e019 0123456789.0123456789e019)
                                    (v128.const f64x2 0123456789.0123456789 0123456789.0123456789))
                                    (v128.const f64x2 0x1.fe9af5b6bcbd5p+89 0x1.fe9af5b6bcbd5p+89))
(assert_return (invoke "f64x2.pmax" (v128.const f64x2 0123456789.0123456789e019 0123456789.0123456789e019)
                                    (v128.const f64x2 0123456789.0123456789e019 0123456789.0123456789e019))
                                    (v128.const f64x2 0x1.fe9af5b6bcbd5p+89 0x1.fe9af5b6bcbd5p+89))
(assert_return (invoke "f64x2.pmax" (v128.const f64x2 0123456789.0123456789e019 0123456789.0123456789e019)
                                    (v128.const f64x2 0123456789.0123456789e+019 0123456789.0123456789e+019))
                                    (v128.const f64x2 0x1.fe9af5b6bcbd5p+89 0x1.fe9af5b6bcbd5p+89))
(assert_return (invoke "f64x2.pmax" (v128.const f64x2 0123456789.0123456789e019 0123456789.0123456789e019)
                                    (v128.const f64x2 0123456789.0123456789e-019 0123456789.0123456789e-019))
                                    (v128.const f64x2 0x1.fe9af5b6bcbd5p+89 0x1.fe9af5b6bcbd5p+89))
(assert_return (invoke "f64x2.pmax" (v128.const f64x2 0123456789.0123456789e019 0123456789.0123456789e019)
                                    (v128.const f64x2 0x0123456789ABCDEFabcdef 0x0123456789ABCDEFabcdef))
                                    (v128.const f64x2 0x1.fe9af5b6bcbd5p+89 0x1.fe9af5b6bcbd5p+89))
(assert_return (invoke "f64x2.pmax" (v128.const f64x2 0123456789.0123456789e019 0123456789.0123456789e019)
                                    (v128.const f64x2 0x0123456789ABCDEFabcdefp019 0x0123456789ABCDEFabcdefp019))
                                    (v128.const f64x2 0x1.23456789abcdfp+99 0x1.23456789abcdfp+99))
(assert_return (invoke "f64x2.pmax" (v128.const f64x2 0123456789.0123456789e019 0123456789.0123456789e019)
                                    (v128.const f64x2 0x0123456789ABCDEFabcdefp+019 0x0123456789ABCDEFabcdefp+019))
                                    (v128.const f64x2 0x1.23456789abcdfp+99 0x1.23456789abcdfp+99))
(assert_return (invoke "f64x2.pmax" (v128.const f64x2 0123456789.0123456789e019 0123456789.0123456789e019)
                                    (v128.const f64x2 0x0123456789ABCDEFabcdefp-019 0x0123456789ABCDEFabcdefp-019))
                                    (v128.const f64x2 0x1.fe9af5b6bcbd5p+89 0x1.fe9af5b6bcbd5p+89))
(assert_return (invoke "f64x2.pmax" (v128.const f64x2 0123456789.0123456789e019 0123456789.0123456789e019)
                                    (v128.const f64x2 0x0123456789ABCDEFabcdef. 0x0123456789ABCDEFabcdef.))
                                    (v128.const f64x2 0x1.fe9af5b6bcbd5p+89 0x1.fe9af5b6bcbd5p+89))
(assert_return (invoke "f64x2.pmax" (v128.const f64x2 0123456789.0123456789e019 0123456789.0123456789e019)
                                    (v128.const f64x2 0x0123456789ABCDEFabcdef.p019 0x0123456789ABCDEFabcdef.p019))
                                    (v128.const f64x2 0x1.23456789abcdfp+99 0x1.23456789abcdfp+99))
(assert_return (invoke "f64x2.pmax" (v128.const f64x2 0123456789.0123456789e019 0123456789.0123456789e019)
                                    (v128.const f64x2 0x0123456789ABCDEFabcdef.p+019 0x0123456789ABCDEFabcdef.p+019))
                                    (v128.const f64x2 0x1.23456789abcdfp+99 0x1.23456789abcdfp+99))
(assert_return (invoke "f64x2.pmax" (v128.const f64x2 0123456789.0123456789e019 0123456789.0123456789e019)
                                    (v128.const f64x2 0x0123456789ABCDEFabcdef.p-019 0x0123456789ABCDEFabcdef.p-019))
                                    (v128.const f64x2 0x1.fe9af5b6bcbd5p+89 0x1.fe9af5b6bcbd5p+89))
(assert_return (invoke "f64x2.pmax" (v128.const f64x2 0123456789.0123456789e019 0123456789.0123456789e019)
                                    (v128.const f64x2 0x0123456789ABCDEFabcdef.0123456789ABCDEFabcdef 0x0123456789ABCDEFabcdef.0123456789ABCDEFabcdef))
                                    (v128.const f64x2 0x1.fe9af5b6bcbd5p+89 0x1.fe9af5b6bcbd5p+89))
(assert_return (invoke "f64x2.pmax" (v128.const f64x2 0123456789.0123456789e019 0123456789.0123456789e019)
                                    (v128.const f64x2 0x0123456789ABCDEFabcdef.0123456789ABCDEFabcdefp019 0x0123456789ABCDEFabcdef.0123456789ABCDEFabcdefp019))
                                    (v128.const f64x2 0x1.23456789abcdfp+99 0x1.23456789abcdfp+99))
(assert_return (invoke "f64x2.pmax" (v128.const f64x2 0123456789.0123456789e019 0123456789.0123456789e019)
                                    (v128.const f64x2 0x0123456789ABCDEFabcdef.0123456789ABCDEFabcdefp+019 0x0123456789ABCDEFabcdef.0123456789ABCDEFabcdefp+019))
                                    (v128.const f64x2 0x1.23456789abcdfp+99 0x1.23456789abcdfp+99))
(assert_return (invoke "f64x2.pmax" (v128.const f64x2 0123456789.0123456789e019 0123456789.0123456789e019)
                                    (v128.const f64x2 0x0123456789ABCDEFabcdef.0123456789ABCDEFabcdefp-019 0x0123456789ABCDEFabcdef.0123456789ABCDEFabcdefp-019))
                                    (v128.const f64x2 0x1.fe9af5b6bcbd5p+89 0x1.fe9af5b6bcbd5p+89))
(assert_return (invoke "f64x2.pmax" (v128.const f64x2 0123456789.0123456789e+019 0123456789.0123456789e+019)
                                    (v128.const f64x2 0x0p+0 0x0p+0))
                                    (v128.const f64x2 0x1.fe9af5b6bcbd5p+89 0x1.fe9af5b6bcbd5p+89))
(assert_return (invoke "f64x2.pmax" (v128.const f64x2 0123456789.0123456789e+019 0123456789.0123456789e+019)
                                    (v128.const f64x2 -0x0p+0 -0x0p+0))
                                    (v128.const f64x2 0x1.fe9af5b6bcbd5p+89 0x1.fe9af5b6bcbd5p+89))
(assert_return (invoke "f64x2.pmax" (v128.const f64x2 0123456789.0123456789e+019 0123456789.0123456789e+019)
                                    (v128.const f64x2 0x1p-1022 0x1p-1022))
                                    (v128.const f64x2 0x1.fe9af5b6bcbd5p+89 0x1.fe9af5b6bcbd5p+89))
(assert_return (invoke "f64x2.pmax" (v128.const f64x2 0123456789.0123456789e+019 0123456789.0123456789e+019)
                                    (v128.const f64x2 -0x1p-1022 -0x1p-1022))
                                    (v128.const f64x2 0x1.fe9af5b6bcbd5p+89 0x1.fe9af5b6bcbd5p+89))
(assert_return (invoke "f64x2.pmax" (v128.const f64x2 0123456789.0123456789e+019 0123456789.0123456789e+019)
                                    (v128.const f64x2 0x1p-1 0x1p-1))
                                    (v128.const f64x2 0x1.fe9af5b6bcbd5p+89 0x1.fe9af5b6bcbd5p+89))
(assert_return (invoke "f64x2.pmax" (v128.const f64x2 0123456789.0123456789e+019 0123456789.0123456789e+019)
                                    (v128.const f64x2 -0x1p-1 -0x1p-1))
                                    (v128.const f64x2 0x1.fe9af5b6bcbd5p+89 0x1.fe9af5b6bcbd5p+89))
(assert_return (invoke "f64x2.pmax" (v128.const f64x2 0123456789.0123456789e+019 0123456789.0123456789e+019)
                                    (v128.const f64x2 0x1p+0 0x1p+0))
                                    (v128.const f64x2 0x1.fe9af5b6bcbd5p+89 0x1.fe9af5b6bcbd5p+89))
(assert_return (invoke "f64x2.pmax" (v128.const f64x2 0123456789.0123456789e+019 0123456789.0123456789e+019)
                                    (v128.const f64x2 -0x1p+0 -0x1p+0))
                                    (v128.const f64x2 0x1.fe9af5b6bcbd5p+89 0x1.fe9af5b6bcbd5p+89))
(assert_return (invoke "f64x2.pmax" (v128.const f64x2 0123456789.0123456789e+019 0123456789.0123456789e+019)
                                    (v128.const f64x2 0x1.921fb54442d18p+2 0x1.921fb54442d18p+2))
                                    (v128.const f64x2 0x1.fe9af5b6bcbd5p+89 0x1.fe9af5b6bcbd5p+89))
(assert_return (invoke "f64x2.pmax" (v128.const f64x2 0123456789.0123456789e+019 0123456789.0123456789e+019)
                                    (v128.const f64x2 -0x1.921fb54442d18p+2 -0x1.921fb54442d18p+2))
                                    (v128.const f64x2 0x1.fe9af5b6bcbd5p+89 0x1.fe9af5b6bcbd5p+89))
(assert_return (invoke "f64x2.pmax" (v128.const f64x2 0123456789.0123456789e+019 0123456789.0123456789e+019)
                                    (v128.const f64x2 0x1.fffffffffffffp+1023 0x1.fffffffffffffp+1023))
                                    (v128.const f64x2 0x1.fffffffffffffp+1023 0x1.fffffffffffffp+1023))
(assert_return (invoke "f64x2.pmax" (v128.const f64x2 0123456789.0123456789e+019 0123456789.0123456789e+019)
                                    (v128.const f64x2 -0x1.fffffffffffffp+1023 -0x1.fffffffffffffp+1023))
                                    (v128.const f64x2 0x1.fe9af5b6bcbd5p+89 0x1.fe9af5b6bcbd5p+89))
(assert_return (invoke "f64x2.pmax" (v128.const f64x2 0123456789.0123456789e+019 0123456789.0123456789e+019)
                                    (v128.const f64x2 0x0.0000000000001p-1022 0x0.0000000000001p-1022))
                                    (v128.const f64x2 0x1.fe9af5b6bcbd5p+89 0x1.fe9af5b6bcbd5p+89))
(assert_return (invoke "f64x2.pmax" (v128.const f64x2 0123456789.0123456789e+019 0123456789.0123456789e+019)
                                    (v128.const f64x2 0x0.0000000000001p-1022 0x0.0000000000001p-1022))
                                    (v128.const f64x2 0x1.fe9af5b6bcbd5p+89 0x1.fe9af5b6bcbd5p+89))
(assert_return (invoke "f64x2.pmax" (v128.const f64x2 0123456789.0123456789e+019 0123456789.0123456789e+019)
                                    (v128.const f64x2 inf inf))
                                    (v128.const f64x2 inf inf))
(assert_return (invoke "f64x2.pmax" (v128.const f64x2 0123456789.0123456789e+019 0123456789.0123456789e+019)
                                    (v128.const f64x2 -inf -inf))
                                    (v128.const f64x2 0x1.fe9af5b6bcbd5p+89 0x1.fe9af5b6bcbd5p+89))
(assert_return (invoke "f64x2.pmax" (v128.const f64x2 0123456789.0123456789e+019 0123456789.0123456789e+019)
                                    (v128.const f64x2 0123456789 0123456789))
                                    (v128.const f64x2 0x1.fe9af5b6bcbd5p+89 0x1.fe9af5b6bcbd5p+89))
(assert_return (invoke "f64x2.pmax" (v128.const f64x2 0123456789.0123456789e+019 0123456789.0123456789e+019)
                                    (v128.const f64x2 0123456789e019 0123456789e019))
                                    (v128.const f64x2 0x1.fe9af5b6bcbd5p+89 0x1.fe9af5b6bcbd5p+89))
(assert_return (invoke "f64x2.pmax" (v128.const f64x2 0123456789.0123456789e+019 0123456789.0123456789e+019)
                                    (v128.const f64x2 0123456789e+019 0123456789e+019))
                                    (v128.const f64x2 0x1.fe9af5b6bcbd5p+89 0x1.fe9af5b6bcbd5p+89))
(assert_return (invoke "f64x2.pmax" (v128.const f64x2 0123456789.0123456789e+019 0123456789.0123456789e+019)
                                    (v128.const f64x2 0123456789e-019 0123456789e-019))
                                    (v128.const f64x2 0x1.fe9af5b6bcbd5p+89 0x1.fe9af5b6bcbd5p+89))
(assert_return (invoke "f64x2.pmax" (v128.const f64x2 0123456789.0123456789e+019 0123456789.0123456789e+019)
                                    (v128.const f64x2 0123456789. 0123456789.))
                                    (v128.const f64x2 0x1.fe9af5b6bcbd5p+89 0x1.fe9af5b6bcbd5p+89))
(assert_return (invoke "f64x2.pmax" (v128.const f64x2 0123456789.0123456789e+019 0123456789.0123456789e+019)
                                    (v128.const f64x2 0123456789.e019 0123456789.e019))
                                    (v128.const f64x2 0x1.fe9af5b6bcbd5p+89 0x1.fe9af5b6bcbd5p+89))
(assert_return (invoke "f64x2.pmax" (v128.const f64x2 0123456789.0123456789e+019 0123456789.0123456789e+019)
                                    (v128.const f64x2 0123456789.e+019 0123456789.e+019))
                                    (v128.const f64x2 0x1.fe9af5b6bcbd5p+89 0x1.fe9af5b6bcbd5p+89))
(assert_return (invoke "f64x2.pmax" (v128.const f64x2 0123456789.0123456789e+019 0123456789.0123456789e+019)
                                    (v128.const f64x2 0123456789.e-019 0123456789.e-019))
                                    (v128.const f64x2 0x1.fe9af5b6bcbd5p+89 0x1.fe9af5b6bcbd5p+89))
(assert_return (invoke "f64x2.pmax" (v128.const f64x2 0123456789.0123456789e+019 0123456789.0123456789e+019)
                                    (v128.const f64x2 0123456789.0123456789 0123456789.0123456789))
                                    (v128.const f64x2 0x1.fe9af5b6bcbd5p+89 0x1.fe9af5b6bcbd5p+89))
(assert_return (invoke "f64x2.pmax" (v128.const f64x2 0123456789.0123456789e+019 0123456789.0123456789e+019)
                                    (v128.const f64x2 0123456789.0123456789e019 0123456789.0123456789e019))
                                    (v128.const f64x2 0x1.fe9af5b6bcbd5p+89 0x1.fe9af5b6bcbd5p+89))
(assert_return (invoke "f64x2.pmax" (v128.const f64x2 0123456789.0123456789e+019 0123456789.0123456789e+019)
                                    (v128.const f64x2 0123456789.0123456789e+019 0123456789.0123456789e+019))
                                    (v128.const f64x2 0x1.fe9af5b6bcbd5p+89 0x1.fe9af5b6bcbd5p+89))
(assert_return (invoke "f64x2.pmax" (v128.const f64x2 0123456789.0123456789e+019 0123456789.0123456789e+019)
                                    (v128.const f64x2 0123456789.0123456789e-019 0123456789.0123456789e-019))
                                    (v128.const f64x2 0x1.fe9af5b6bcbd5p+89 0x1.fe9af5b6bcbd5p+89))
(assert_return (invoke "f64x2.pmax" (v128.const f64x2 0123456789.0123456789e+019 0123456789.0123456789e+019)
                                    (v128.const f64x2 0x0123456789ABCDEFabcdef 0x0123456789ABCDEFabcdef))
                                    (v128.const f64x2 0x1.fe9af5b6bcbd5p+89 0x1.fe9af5b6bcbd5p+89))
(assert_return (invoke "f64x2.pmax" (v128.const f64x2 0123456789.0123456789e+019 0123456789.0123456789e+019)
                                    (v128.const f64x2 0x0123456789ABCDEFabcdefp019 0x0123456789ABCDEFabcdefp019))
                                    (v128.const f64x2 0x1.23456789abcdfp+99 0x1.23456789abcdfp+99))
(assert_return (invoke "f64x2.pmax" (v128.const f64x2 0123456789.0123456789e+019 0123456789.0123456789e+019)
                                    (v128.const f64x2 0x0123456789ABCDEFabcdefp+019 0x0123456789ABCDEFabcdefp+019))
                                    (v128.const f64x2 0x1.23456789abcdfp+99 0x1.23456789abcdfp+99))
(assert_return (invoke "f64x2.pmax" (v128.const f64x2 0123456789.0123456789e+019 0123456789.0123456789e+019)
                                    (v128.const f64x2 0x0123456789ABCDEFabcdefp-019 0x0123456789ABCDEFabcdefp-019))
                                    (v128.const f64x2 0x1.fe9af5b6bcbd5p+89 0x1.fe9af5b6bcbd5p+89))
(assert_return (invoke "f64x2.pmax" (v128.const f64x2 0123456789.0123456789e+019 0123456789.0123456789e+019)
                                    (v128.const f64x2 0x0123456789ABCDEFabcdef. 0x0123456789ABCDEFabcdef.))
                                    (v128.const f64x2 0x1.fe9af5b6bcbd5p+89 0x1.fe9af5b6bcbd5p+89))
(assert_return (invoke "f64x2.pmax" (v128.const f64x2 0123456789.0123456789e+019 0123456789.0123456789e+019)
                                    (v128.const f64x2 0x0123456789ABCDEFabcdef.p019 0x0123456789ABCDEFabcdef.p019))
                                    (v128.const f64x2 0x1.23456789abcdfp+99 0x1.23456789abcdfp+99))
(assert_return (invoke "f64x2.pmax" (v128.const f64x2 0123456789.0123456789e+019 0123456789.0123456789e+019)
                                    (v128.const f64x2 0x0123456789ABCDEFabcdef.p+019 0x0123456789ABCDEFabcdef.p+019))
                                    (v128.const f64x2 0x1.23456789abcdfp+99 0x1.23456789abcdfp+99))
(assert_return (invoke "f64x2.pmax" (v128.const f64x2 0123456789.0123456789e+019 0123456789.0123456789e+019)
                                    (v128.const f64x2 0x0123456789ABCDEFabcdef.p-019 0x0123456789ABCDEFabcdef.p-019))
                                    (v128.const f64x2 0x1.fe9af5b6bcbd5p+89 0x1.fe9af5b6bcbd5p+89))
(assert_return (invoke "f64x2.pmax" (v128.const f64x2 0123456789.0123456789e+019 0123456789.0123456789e+019)
                                    (v128.const f64x2 0x0123456789ABCDEFabcdef.0123456789ABCDEFabcdef 0x0123456789ABCDEFabcdef.0123456789ABCDEFabcdef))
                                    (v128.const f64x2 0x1.fe9af5b6bcbd5p+89 0x1.fe9af5b6bcbd5p+89))
(assert_return (invoke "f64x2.pmax" (v128.const f64x2 0123456789.0123456789e+019 0123456789.0123456789e+019)
                                    (v128.const f64x2 0x0123456789ABCDEFabcdef.0123456789ABCDEFabcdefp019 0x0123456789ABCDEFabcdef.0123456789ABCDEFabcdefp019))
                                    (v128.const f64x2 0x1.23456789abcdfp+99 0x1.23456789abcdfp+99))
(assert_return (invoke "f64x2.pmax" (v128.const f64x2 0123456789.0123456789e+019 0123456789.0123456789e+019)
                                    (v128.const f64x2 0x0123456789ABCDEFabcdef.0123456789ABCDEFabcdefp+019 0x0123456789ABCDEFabcdef.0123456789ABCDEFabcdefp+019))
                                    (v128.const f64x2 0x1.23456789abcdfp+99 0x1.23456789abcdfp+99))
(assert_return (invoke "f64x2.pmax" (v128.const f64x2 0123456789.0123456789e+019 0123456789.0123456789e+019)
                                    (v128.const f64x2 0x0123456789ABCDEFabcdef.0123456789ABCDEFabcdefp-019 0x0123456789ABCDEFabcdef.0123456789ABCDEFabcdefp-019))
                                    (v128.const f64x2 0x1.fe9af5b6bcbd5p+89 0x1.fe9af5b6bcbd5p+89))
(assert_return (invoke "f64x2.pmax" (v128.const f64x2 0123456789.0123456789e-019 0123456789.0123456789e-019)
                                    (v128.const f64x2 0x0p+0 0x0p+0))
                                    (v128.const f64x2 0x1.b25ffd636ec12p-37 0x1.b25ffd636ec12p-37))
(assert_return (invoke "f64x2.pmax" (v128.const f64x2 0123456789.0123456789e-019 0123456789.0123456789e-019)
                                    (v128.const f64x2 -0x0p+0 -0x0p+0))
                                    (v128.const f64x2 0x1.b25ffd636ec12p-37 0x1.b25ffd636ec12p-37))
(assert_return (invoke "f64x2.pmax" (v128.const f64x2 0123456789.0123456789e-019 0123456789.0123456789e-019)
                                    (v128.const f64x2 0x1p-1022 0x1p-1022))
                                    (v128.const f64x2 0x1.b25ffd636ec12p-37 0x1.b25ffd636ec12p-37))
(assert_return (invoke "f64x2.pmax" (v128.const f64x2 0123456789.0123456789e-019 0123456789.0123456789e-019)
                                    (v128.const f64x2 -0x1p-1022 -0x1p-1022))
                                    (v128.const f64x2 0x1.b25ffd636ec12p-37 0x1.b25ffd636ec12p-37))
(assert_return (invoke "f64x2.pmax" (v128.const f64x2 0123456789.0123456789e-019 0123456789.0123456789e-019)
                                    (v128.const f64x2 0x1p-1 0x1p-1))
                                    (v128.const f64x2 0x1.0000000000000p-1 0x1.0000000000000p-1))
(assert_return (invoke "f64x2.pmax" (v128.const f64x2 0123456789.0123456789e-019 0123456789.0123456789e-019)
                                    (v128.const f64x2 -0x1p-1 -0x1p-1))
                                    (v128.const f64x2 0x1.b25ffd636ec12p-37 0x1.b25ffd636ec12p-37))
(assert_return (invoke "f64x2.pmax" (v128.const f64x2 0123456789.0123456789e-019 0123456789.0123456789e-019)
                                    (v128.const f64x2 0x1p+0 0x1p+0))
                                    (v128.const f64x2 0x1.0000000000000p+0 0x1.0000000000000p+0))
(assert_return (invoke "f64x2.pmax" (v128.const f64x2 0123456789.0123456789e-019 0123456789.0123456789e-019)
                                    (v128.const f64x2 -0x1p+0 -0x1p+0))
                                    (v128.const f64x2 0x1.b25ffd636ec12p-37 0x1.b25ffd636ec12p-37))
(assert_return (invoke "f64x2.pmax" (v128.const f64x2 0123456789.0123456789e-019 0123456789.0123456789e-019)
                                    (v128.const f64x2 0x1.921fb54442d18p+2 0x1.921fb54442d18p+2))
                                    (v128.const f64x2 0x1.921fb54442d18p+2 0x1.921fb54442d18p+2))
(assert_return (invoke "f64x2.pmax" (v128.const f64x2 0123456789.0123456789e-019 0123456789.0123456789e-019)
                                    (v128.const f64x2 -0x1.921fb54442d18p+2 -0x1.921fb54442d18p+2))
                                    (v128.const f64x2 0x1.b25ffd636ec12p-37 0x1.b25ffd636ec12p-37))
(assert_return (invoke "f64x2.pmax" (v128.const f64x2 0123456789.0123456789e-019 0123456789.0123456789e-019)
                                    (v128.const f64x2 0x1.fffffffffffffp+1023 0x1.fffffffffffffp+1023))
                                    (v128.const f64x2 0x1.fffffffffffffp+1023 0x1.fffffffffffffp+1023))
(assert_return (invoke "f64x2.pmax" (v128.const f64x2 0123456789.0123456789e-019 0123456789.0123456789e-019)
                                    (v128.const f64x2 -0x1.fffffffffffffp+1023 -0x1.fffffffffffffp+1023))
                                    (v128.const f64x2 0x1.b25ffd636ec12p-37 0x1.b25ffd636ec12p-37))
(assert_return (invoke "f64x2.pmax" (v128.const f64x2 0123456789.0123456789e-019 0123456789.0123456789e-019)
                                    (v128.const f64x2 0x0.0000000000001p-1022 0x0.0000000000001p-1022))
                                    (v128.const f64x2 0x1.b25ffd636ec12p-37 0x1.b25ffd636ec12p-37))
(assert_return (invoke "f64x2.pmax" (v128.const f64x2 0123456789.0123456789e-019 0123456789.0123456789e-019)
                                    (v128.const f64x2 0x0.0000000000001p-1022 0x0.0000000000001p-1022))
                                    (v128.const f64x2 0x1.b25ffd636ec12p-37 0x1.b25ffd636ec12p-37))
(assert_return (invoke "f64x2.pmax" (v128.const f64x2 0123456789.0123456789e-019 0123456789.0123456789e-019)
                                    (v128.const f64x2 inf inf))
                                    (v128.const f64x2 inf inf))
(assert_return (invoke "f64x2.pmax" (v128.const f64x2 0123456789.0123456789e-019 0123456789.0123456789e-019)
                                    (v128.const f64x2 -inf -inf))
                                    (v128.const f64x2 0x1.b25ffd636ec12p-37 0x1.b25ffd636ec12p-37))
(assert_return (invoke "f64x2.pmax" (v128.const f64x2 0123456789.0123456789e-019 0123456789.0123456789e-019)
                                    (v128.const f64x2 0123456789 0123456789))
                                    (v128.const f64x2 0x1.d6f3454000000p+26 0x1.d6f3454000000p+26))
(assert_return (invoke "f64x2.pmax" (v128.const f64x2 0123456789.0123456789e-019 0123456789.0123456789e-019)
                                    (v128.const f64x2 0123456789e019 0123456789e019))
                                    (v128.const f64x2 0x1.fe9af5b5e16fap+89 0x1.fe9af5b5e16fap+89))
(assert_return (invoke "f64x2.pmax" (v128.const f64x2 0123456789.0123456789e-019 0123456789.0123456789e-019)
                                    (v128.const f64x2 0123456789e+019 0123456789e+019))
                                    (v128.const f64x2 0x1.fe9af5b5e16fap+89 0x1.fe9af5b5e16fap+89))
(assert_return (invoke "f64x2.pmax" (v128.const f64x2 0123456789.0123456789e-019 0123456789.0123456789e-019)
                                    (v128.const f64x2 0123456789e-019 0123456789e-019))
                                    (v128.const f64x2 0x1.b25ffd636ec12p-37 0x1.b25ffd636ec12p-37))
(assert_return (invoke "f64x2.pmax" (v128.const f64x2 0123456789.0123456789e-019 0123456789.0123456789e-019)
                                    (v128.const f64x2 0123456789. 0123456789.))
                                    (v128.const f64x2 0x1.d6f3454000000p+26 0x1.d6f3454000000p+26))
(assert_return (invoke "f64x2.pmax" (v128.const f64x2 0123456789.0123456789e-019 0123456789.0123456789e-019)
                                    (v128.const f64x2 0123456789.e019 0123456789.e019))
                                    (v128.const f64x2 0x1.fe9af5b5e16fap+89 0x1.fe9af5b5e16fap+89))
(assert_return (invoke "f64x2.pmax" (v128.const f64x2 0123456789.0123456789e-019 0123456789.0123456789e-019)
                                    (v128.const f64x2 0123456789.e+019 0123456789.e+019))
                                    (v128.const f64x2 0x1.fe9af5b5e16fap+89 0x1.fe9af5b5e16fap+89))
(assert_return (invoke "f64x2.pmax" (v128.const f64x2 0123456789.0123456789e-019 0123456789.0123456789e-019)
                                    (v128.const f64x2 0123456789.e-019 0123456789.e-019))
                                    (v128.const f64x2 0x1.b25ffd636ec12p-37 0x1.b25ffd636ec12p-37))
(assert_return (invoke "f64x2.pmax" (v128.const f64x2 0123456789.0123456789e-019 0123456789.0123456789e-019)
                                    (v128.const f64x2 0123456789.0123456789 0123456789.0123456789))
                                    (v128.const f64x2 0x1.d6f34540ca458p+26 0x1.d6f34540ca458p+26))
(assert_return (invoke "f64x2.pmax" (v128.const f64x2 0123456789.0123456789e-019 0123456789.0123456789e-019)
                                    (v128.const f64x2 0123456789.0123456789e019 0123456789.0123456789e019))
                                    (v128.const f64x2 0x1.fe9af5b6bcbd5p+89 0x1.fe9af5b6bcbd5p+89))
(assert_return (invoke "f64x2.pmax" (v128.const f64x2 0123456789.0123456789e-019 0123456789.0123456789e-019)
                                    (v128.const f64x2 0123456789.0123456789e+019 0123456789.0123456789e+019))
                                    (v128.const f64x2 0x1.fe9af5b6bcbd5p+89 0x1.fe9af5b6bcbd5p+89))
(assert_return (invoke "f64x2.pmax" (v128.const f64x2 0123456789.0123456789e-019 0123456789.0123456789e-019)
                                    (v128.const f64x2 0123456789.0123456789e-019 0123456789.0123456789e-019))
                                    (v128.const f64x2 0x1.b25ffd636ec12p-37 0x1.b25ffd636ec12p-37))
(assert_return (invoke "f64x2.pmax" (v128.const f64x2 0123456789.0123456789e-019 0123456789.0123456789e-019)
                                    (v128.const f64x2 0x0123456789ABCDEFabcdef 0x0123456789ABCDEFabcdef))
                                    (v128.const f64x2 0x1.23456789abcdfp+80 0x1.23456789abcdfp+80))
(assert_return (invoke "f64x2.pmax" (v128.const f64x2 0123456789.0123456789e-019 0123456789.0123456789e-019)
                                    (v128.const f64x2 0x0123456789ABCDEFabcdefp019 0x0123456789ABCDEFabcdefp019))
                                    (v128.const f64x2 0x1.23456789abcdfp+99 0x1.23456789abcdfp+99))
(assert_return (invoke "f64x2.pmax" (v128.const f64x2 0123456789.0123456789e-019 0123456789.0123456789e-019)
                                    (v128.const f64x2 0x0123456789ABCDEFabcdefp+019 0x0123456789ABCDEFabcdefp+019))
                                    (v128.const f64x2 0x1.23456789abcdfp+99 0x1.23456789abcdfp+99))
(assert_return (invoke "f64x2.pmax" (v128.const f64x2 0123456789.0123456789e-019 0123456789.0123456789e-019)
                                    (v128.const f64x2 0x0123456789ABCDEFabcdefp-019 0x0123456789ABCDEFabcdefp-019))
                                    (v128.const f64x2 0x1.23456789abcdfp+61 0x1.23456789abcdfp+61))
(assert_return (invoke "f64x2.pmax" (v128.const f64x2 0123456789.0123456789e-019 0123456789.0123456789e-019)
                                    (v128.const f64x2 0x0123456789ABCDEFabcdef. 0x0123456789ABCDEFabcdef.))
                                    (v128.const f64x2 0x1.23456789abcdfp+80 0x1.23456789abcdfp+80))
(assert_return (invoke "f64x2.pmax" (v128.const f64x2 0123456789.0123456789e-019 0123456789.0123456789e-019)
                                    (v128.const f64x2 0x0123456789ABCDEFabcdef.p019 0x0123456789ABCDEFabcdef.p019))
                                    (v128.const f64x2 0x1.23456789abcdfp+99 0x1.23456789abcdfp+99))
(assert_return (invoke "f64x2.pmax" (v128.const f64x2 0123456789.0123456789e-019 0123456789.0123456789e-019)
                                    (v128.const f64x2 0x0123456789ABCDEFabcdef.p+019 0x0123456789ABCDEFabcdef.p+019))
                                    (v128.const f64x2 0x1.23456789abcdfp+99 0x1.23456789abcdfp+99))
(assert_return (invoke "f64x2.pmax" (v128.const f64x2 0123456789.0123456789e-019 0123456789.0123456789e-019)
                                    (v128.const f64x2 0x0123456789ABCDEFabcdef.p-019 0x0123456789ABCDEFabcdef.p-019))
                                    (v128.const f64x2 0x1.23456789abcdfp+61 0x1.23456789abcdfp+61))
(assert_return (invoke "f64x2.pmax" (v128.const f64x2 0123456789.0123456789e-019 0123456789.0123456789e-019)
                                    (v128.const f64x2 0x0123456789ABCDEFabcdef.0123456789ABCDEFabcdef 0x0123456789ABCDEFabcdef.0123456789ABCDEFabcdef))
                                    (v128.const f64x2 0x1.23456789abcdfp+80 0x1.23456789abcdfp+80))
(assert_return (invoke "f64x2.pmax" (v128.const f64x2 0123456789.0123456789e-019 0123456789.0123456789e-019)
                                    (v128.const f64x2 0x0123456789ABCDEFabcdef.0123456789ABCDEFabcdefp019 0x0123456789ABCDEFabcdef.0123456789ABCDEFabcdefp019))
                                    (v128.const f64x2 0x1.23456789abcdfp+99 0x1.23456789abcdfp+99))
(assert_return (invoke "f64x2.pmax" (v128.const f64x2 0123456789.0123456789e-019 0123456789.0123456789e-019)
                                    (v128.const f64x2 0x0123456789ABCDEFabcdef.0123456789ABCDEFabcdefp+019 0x0123456789ABCDEFabcdef.0123456789ABCDEFabcdefp+019))
                                    (v128.const f64x2 0x1.23456789abcdfp+99 0x1.23456789abcdfp+99))
(assert_return (invoke "f64x2.pmax" (v128.const f64x2 0123456789.0123456789e-019 0123456789.0123456789e-019)
                                    (v128.const f64x2 0x0123456789ABCDEFabcdef.0123456789ABCDEFabcdefp-019 0x0123456789ABCDEFabcdef.0123456789ABCDEFabcdefp-019))
                                    (v128.const f64x2 0x1.23456789abcdfp+61 0x1.23456789abcdfp+61))
(assert_return (invoke "f64x2.pmax" (v128.const f64x2 0x0123456789ABCDEFabcdef 0x0123456789ABCDEFabcdef)
                                    (v128.const f64x2 0x0p+0 0x0p+0))
                                    (v128.const f64x2 0x1.23456789abcdfp+80 0x1.23456789abcdfp+80))
(assert_return (invoke "f64x2.pmax" (v128.const f64x2 0x0123456789ABCDEFabcdef 0x0123456789ABCDEFabcdef)
                                    (v128.const f64x2 -0x0p+0 -0x0p+0))
                                    (v128.const f64x2 0x1.23456789abcdfp+80 0x1.23456789abcdfp+80))
(assert_return (invoke "f64x2.pmax" (v128.const f64x2 0x0123456789ABCDEFabcdef 0x0123456789ABCDEFabcdef)
                                    (v128.const f64x2 0x1p-1022 0x1p-1022))
                                    (v128.const f64x2 0x1.23456789abcdfp+80 0x1.23456789abcdfp+80))
(assert_return (invoke "f64x2.pmax" (v128.const f64x2 0x0123456789ABCDEFabcdef 0x0123456789ABCDEFabcdef)
                                    (v128.const f64x2 -0x1p-1022 -0x1p-1022))
                                    (v128.const f64x2 0x1.23456789abcdfp+80 0x1.23456789abcdfp+80))
(assert_return (invoke "f64x2.pmax" (v128.const f64x2 0x0123456789ABCDEFabcdef 0x0123456789ABCDEFabcdef)
                                    (v128.const f64x2 0x1p-1 0x1p-1))
                                    (v128.const f64x2 0x1.23456789abcdfp+80 0x1.23456789abcdfp+80))
(assert_return (invoke "f64x2.pmax" (v128.const f64x2 0x0123456789ABCDEFabcdef 0x0123456789ABCDEFabcdef)
                                    (v128.const f64x2 -0x1p-1 -0x1p-1))
                                    (v128.const f64x2 0x1.23456789abcdfp+80 0x1.23456789abcdfp+80))
(assert_return (invoke "f64x2.pmax" (v128.const f64x2 0x0123456789ABCDEFabcdef 0x0123456789ABCDEFabcdef)
                                    (v128.const f64x2 0x1p+0 0x1p+0))
                                    (v128.const f64x2 0x1.23456789abcdfp+80 0x1.23456789abcdfp+80))
(assert_return (invoke "f64x2.pmax" (v128.const f64x2 0x0123456789ABCDEFabcdef 0x0123456789ABCDEFabcdef)
                                    (v128.const f64x2 -0x1p+0 -0x1p+0))
                                    (v128.const f64x2 0x1.23456789abcdfp+80 0x1.23456789abcdfp+80))
(assert_return (invoke "f64x2.pmax" (v128.const f64x2 0x0123456789ABCDEFabcdef 0x0123456789ABCDEFabcdef)
                                    (v128.const f64x2 0x1.921fb54442d18p+2 0x1.921fb54442d18p+2))
                                    (v128.const f64x2 0x1.23456789abcdfp+80 0x1.23456789abcdfp+80))
(assert_return (invoke "f64x2.pmax" (v128.const f64x2 0x0123456789ABCDEFabcdef 0x0123456789ABCDEFabcdef)
                                    (v128.const f64x2 -0x1.921fb54442d18p+2 -0x1.921fb54442d18p+2))
                                    (v128.const f64x2 0x1.23456789abcdfp+80 0x1.23456789abcdfp+80))
(assert_return (invoke "f64x2.pmax" (v128.const f64x2 0x0123456789ABCDEFabcdef 0x0123456789ABCDEFabcdef)
                                    (v128.const f64x2 0x1.fffffffffffffp+1023 0x1.fffffffffffffp+1023))
                                    (v128.const f64x2 0x1.fffffffffffffp+1023 0x1.fffffffffffffp+1023))
(assert_return (invoke "f64x2.pmax" (v128.const f64x2 0x0123456789ABCDEFabcdef 0x0123456789ABCDEFabcdef)
                                    (v128.const f64x2 -0x1.fffffffffffffp+1023 -0x1.fffffffffffffp+1023))
                                    (v128.const f64x2 0x1.23456789abcdfp+80 0x1.23456789abcdfp+80))
(assert_return (invoke "f64x2.pmax" (v128.const f64x2 0x0123456789ABCDEFabcdef 0x0123456789ABCDEFabcdef)
                                    (v128.const f64x2 0x0.0000000000001p-1022 0x0.0000000000001p-1022))
                                    (v128.const f64x2 0x1.23456789abcdfp+80 0x1.23456789abcdfp+80))
(assert_return (invoke "f64x2.pmax" (v128.const f64x2 0x0123456789ABCDEFabcdef 0x0123456789ABCDEFabcdef)
                                    (v128.const f64x2 0x0.0000000000001p-1022 0x0.0000000000001p-1022))
                                    (v128.const f64x2 0x1.23456789abcdfp+80 0x1.23456789abcdfp+80))
(assert_return (invoke "f64x2.pmax" (v128.const f64x2 0x0123456789ABCDEFabcdef 0x0123456789ABCDEFabcdef)
                                    (v128.const f64x2 inf inf))
                                    (v128.const f64x2 inf inf))
(assert_return (invoke "f64x2.pmax" (v128.const f64x2 0x0123456789ABCDEFabcdef 0x0123456789ABCDEFabcdef)
                                    (v128.const f64x2 -inf -inf))
                                    (v128.const f64x2 0x1.23456789abcdfp+80 0x1.23456789abcdfp+80))
(assert_return (invoke "f64x2.pmax" (v128.const f64x2 0x0123456789ABCDEFabcdef 0x0123456789ABCDEFabcdef)
                                    (v128.const f64x2 0123456789 0123456789))
                                    (v128.const f64x2 0x1.23456789abcdfp+80 0x1.23456789abcdfp+80))
(assert_return (invoke "f64x2.pmax" (v128.const f64x2 0x0123456789ABCDEFabcdef 0x0123456789ABCDEFabcdef)
                                    (v128.const f64x2 0123456789e019 0123456789e019))
                                    (v128.const f64x2 0x1.fe9af5b5e16fap+89 0x1.fe9af5b5e16fap+89))
(assert_return (invoke "f64x2.pmax" (v128.const f64x2 0x0123456789ABCDEFabcdef 0x0123456789ABCDEFabcdef)
                                    (v128.const f64x2 0123456789e+019 0123456789e+019))
                                    (v128.const f64x2 0x1.fe9af5b5e16fap+89 0x1.fe9af5b5e16fap+89))
(assert_return (invoke "f64x2.pmax" (v128.const f64x2 0x0123456789ABCDEFabcdef 0x0123456789ABCDEFabcdef)
                                    (v128.const f64x2 0123456789e-019 0123456789e-019))
                                    (v128.const f64x2 0x1.23456789abcdfp+80 0x1.23456789abcdfp+80))
(assert_return (invoke "f64x2.pmax" (v128.const f64x2 0x0123456789ABCDEFabcdef 0x0123456789ABCDEFabcdef)
                                    (v128.const f64x2 0123456789. 0123456789.))
                                    (v128.const f64x2 0x1.23456789abcdfp+80 0x1.23456789abcdfp+80))
(assert_return (invoke "f64x2.pmax" (v128.const f64x2 0x0123456789ABCDEFabcdef 0x0123456789ABCDEFabcdef)
                                    (v128.const f64x2 0123456789.e019 0123456789.e019))
                                    (v128.const f64x2 0x1.fe9af5b5e16fap+89 0x1.fe9af5b5e16fap+89))
(assert_return (invoke "f64x2.pmax" (v128.const f64x2 0x0123456789ABCDEFabcdef 0x0123456789ABCDEFabcdef)
                                    (v128.const f64x2 0123456789.e+019 0123456789.e+019))
                                    (v128.const f64x2 0x1.fe9af5b5e16fap+89 0x1.fe9af5b5e16fap+89))
(assert_return (invoke "f64x2.pmax" (v128.const f64x2 0x0123456789ABCDEFabcdef 0x0123456789ABCDEFabcdef)
                                    (v128.const f64x2 0123456789.e-019 0123456789.e-019))
                                    (v128.const f64x2 0x1.23456789abcdfp+80 0x1.23456789abcdfp+80))
(assert_return (invoke "f64x2.pmax" (v128.const f64x2 0x0123456789ABCDEFabcdef 0x0123456789ABCDEFabcdef)
                                    (v128.const f64x2 0123456789.0123456789 0123456789.0123456789))
                                    (v128.const f64x2 0x1.23456789abcdfp+80 0x1.23456789abcdfp+80))
(assert_return (invoke "f64x2.pmax" (v128.const f64x2 0x0123456789ABCDEFabcdef 0x0123456789ABCDEFabcdef)
                                    (v128.const f64x2 0123456789.0123456789e019 0123456789.0123456789e019))
                                    (v128.const f64x2 0x1.fe9af5b6bcbd5p+89 0x1.fe9af5b6bcbd5p+89))
(assert_return (invoke "f64x2.pmax" (v128.const f64x2 0x0123456789ABCDEFabcdef 0x0123456789ABCDEFabcdef)
                                    (v128.const f64x2 0123456789.0123456789e+019 0123456789.0123456789e+019))
                                    (v128.const f64x2 0x1.fe9af5b6bcbd5p+89 0x1.fe9af5b6bcbd5p+89))
(assert_return (invoke "f64x2.pmax" (v128.const f64x2 0x0123456789ABCDEFabcdef 0x0123456789ABCDEFabcdef)
                                    (v128.const f64x2 0123456789.0123456789e-019 0123456789.0123456789e-019))
                                    (v128.const f64x2 0x1.23456789abcdfp+80 0x1.23456789abcdfp+80))
(assert_return (invoke "f64x2.pmax" (v128.const f64x2 0x0123456789ABCDEFabcdef 0x0123456789ABCDEFabcdef)
                                    (v128.const f64x2 0x0123456789ABCDEFabcdef 0x0123456789ABCDEFabcdef))
                                    (v128.const f64x2 0x1.23456789abcdfp+80 0x1.23456789abcdfp+80))
(assert_return (invoke "f64x2.pmax" (v128.const f64x2 0x0123456789ABCDEFabcdef 0x0123456789ABCDEFabcdef)
                                    (v128.const f64x2 0x0123456789ABCDEFabcdefp019 0x0123456789ABCDEFabcdefp019))
                                    (v128.const f64x2 0x1.23456789abcdfp+99 0x1.23456789abcdfp+99))
(assert_return (invoke "f64x2.pmax" (v128.const f64x2 0x0123456789ABCDEFabcdef 0x0123456789ABCDEFabcdef)
                                    (v128.const f64x2 0x0123456789ABCDEFabcdefp+019 0x0123456789ABCDEFabcdefp+019))
                                    (v128.const f64x2 0x1.23456789abcdfp+99 0x1.23456789abcdfp+99))
(assert_return (invoke "f64x2.pmax" (v128.const f64x2 0x0123456789ABCDEFabcdef 0x0123456789ABCDEFabcdef)
                                    (v128.const f64x2 0x0123456789ABCDEFabcdefp-019 0x0123456789ABCDEFabcdefp-019))
                                    (v128.const f64x2 0x1.23456789abcdfp+80 0x1.23456789abcdfp+80))
(assert_return (invoke "f64x2.pmax" (v128.const f64x2 0x0123456789ABCDEFabcdef 0x0123456789ABCDEFabcdef)
                                    (v128.const f64x2 0x0123456789ABCDEFabcdef. 0x0123456789ABCDEFabcdef.))
                                    (v128.const f64x2 0x1.23456789abcdfp+80 0x1.23456789abcdfp+80))
(assert_return (invoke "f64x2.pmax" (v128.const f64x2 0x0123456789ABCDEFabcdef 0x0123456789ABCDEFabcdef)
                                    (v128.const f64x2 0x0123456789ABCDEFabcdef.p019 0x0123456789ABCDEFabcdef.p019))
                                    (v128.const f64x2 0x1.23456789abcdfp+99 0x1.23456789abcdfp+99))
(assert_return (invoke "f64x2.pmax" (v128.const f64x2 0x0123456789ABCDEFabcdef 0x0123456789ABCDEFabcdef)
                                    (v128.const f64x2 0x0123456789ABCDEFabcdef.p+019 0x0123456789ABCDEFabcdef.p+019))
                                    (v128.const f64x2 0x1.23456789abcdfp+99 0x1.23456789abcdfp+99))
(assert_return (invoke "f64x2.pmax" (v128.const f64x2 0x0123456789ABCDEFabcdef 0x0123456789ABCDEFabcdef)
                                    (v128.const f64x2 0x0123456789ABCDEFabcdef.p-019 0x0123456789ABCDEFabcdef.p-019))
                                    (v128.const f64x2 0x1.23456789abcdfp+80 0x1.23456789abcdfp+80))
(assert_return (invoke "f64x2.pmax" (v128.const f64x2 0x0123456789ABCDEFabcdef 0x0123456789ABCDEFabcdef)
                                    (v128.const f64x2 0x0123456789ABCDEFabcdef.0123456789ABCDEFabcdef 0x0123456789ABCDEFabcdef.0123456789ABCDEFabcdef))
                                    (v128.const f64x2 0x1.23456789abcdfp+80 0x1.23456789abcdfp+80))
(assert_return (invoke "f64x2.pmax" (v128.const f64x2 0x0123456789ABCDEFabcdef 0x0123456789ABCDEFabcdef)
                                    (v128.const f64x2 0x0123456789ABCDEFabcdef.0123456789ABCDEFabcdefp019 0x0123456789ABCDEFabcdef.0123456789ABCDEFabcdefp019))
                                    (v128.const f64x2 0x1.23456789abcdfp+99 0x1.23456789abcdfp+99))
(assert_return (invoke "f64x2.pmax" (v128.const f64x2 0x0123456789ABCDEFabcdef 0x0123456789ABCDEFabcdef)
                                    (v128.const f64x2 0x0123456789ABCDEFabcdef.0123456789ABCDEFabcdefp+019 0x0123456789ABCDEFabcdef.0123456789ABCDEFabcdefp+019))
                                    (v128.const f64x2 0x1.23456789abcdfp+99 0x1.23456789abcdfp+99))
(assert_return (invoke "f64x2.pmax" (v128.const f64x2 0x0123456789ABCDEFabcdef 0x0123456789ABCDEFabcdef)
                                    (v128.const f64x2 0x0123456789ABCDEFabcdef.0123456789ABCDEFabcdefp-019 0x0123456789ABCDEFabcdef.0123456789ABCDEFabcdefp-019))
                                    (v128.const f64x2 0x1.23456789abcdfp+80 0x1.23456789abcdfp+80))
(assert_return (invoke "f64x2.pmax" (v128.const f64x2 0x0123456789ABCDEFabcdefp019 0x0123456789ABCDEFabcdefp019)
                                    (v128.const f64x2 0x0p+0 0x0p+0))
                                    (v128.const f64x2 0x1.23456789abcdfp+99 0x1.23456789abcdfp+99))
(assert_return (invoke "f64x2.pmax" (v128.const f64x2 0x0123456789ABCDEFabcdefp019 0x0123456789ABCDEFabcdefp019)
                                    (v128.const f64x2 -0x0p+0 -0x0p+0))
                                    (v128.const f64x2 0x1.23456789abcdfp+99 0x1.23456789abcdfp+99))
(assert_return (invoke "f64x2.pmax" (v128.const f64x2 0x0123456789ABCDEFabcdefp019 0x0123456789ABCDEFabcdefp019)
                                    (v128.const f64x2 0x1p-1022 0x1p-1022))
                                    (v128.const f64x2 0x1.23456789abcdfp+99 0x1.23456789abcdfp+99))
(assert_return (invoke "f64x2.pmax" (v128.const f64x2 0x0123456789ABCDEFabcdefp019 0x0123456789ABCDEFabcdefp019)
                                    (v128.const f64x2 -0x1p-1022 -0x1p-1022))
                                    (v128.const f64x2 0x1.23456789abcdfp+99 0x1.23456789abcdfp+99))
(assert_return (invoke "f64x2.pmax" (v128.const f64x2 0x0123456789ABCDEFabcdefp019 0x0123456789ABCDEFabcdefp019)
                                    (v128.const f64x2 0x1p-1 0x1p-1))
                                    (v128.const f64x2 0x1.23456789abcdfp+99 0x1.23456789abcdfp+99))
(assert_return (invoke "f64x2.pmax" (v128.const f64x2 0x0123456789ABCDEFabcdefp019 0x0123456789ABCDEFabcdefp019)
                                    (v128.const f64x2 -0x1p-1 -0x1p-1))
                                    (v128.const f64x2 0x1.23456789abcdfp+99 0x1.23456789abcdfp+99))
(assert_return (invoke "f64x2.pmax" (v128.const f64x2 0x0123456789ABCDEFabcdefp019 0x0123456789ABCDEFabcdefp019)
                                    (v128.const f64x2 0x1p+0 0x1p+0))
                                    (v128.const f64x2 0x1.23456789abcdfp+99 0x1.23456789abcdfp+99))
(assert_return (invoke "f64x2.pmax" (v128.const f64x2 0x0123456789ABCDEFabcdefp019 0x0123456789ABCDEFabcdefp019)
                                    (v128.const f64x2 -0x1p+0 -0x1p+0))
                                    (v128.const f64x2 0x1.23456789abcdfp+99 0x1.23456789abcdfp+99))
(assert_return (invoke "f64x2.pmax" (v128.const f64x2 0x0123456789ABCDEFabcdefp019 0x0123456789ABCDEFabcdefp019)
                                    (v128.const f64x2 0x1.921fb54442d18p+2 0x1.921fb54442d18p+2))
                                    (v128.const f64x2 0x1.23456789abcdfp+99 0x1.23456789abcdfp+99))
(assert_return (invoke "f64x2.pmax" (v128.const f64x2 0x0123456789ABCDEFabcdefp019 0x0123456789ABCDEFabcdefp019)
                                    (v128.const f64x2 -0x1.921fb54442d18p+2 -0x1.921fb54442d18p+2))
                                    (v128.const f64x2 0x1.23456789abcdfp+99 0x1.23456789abcdfp+99))
(assert_return (invoke "f64x2.pmax" (v128.const f64x2 0x0123456789ABCDEFabcdefp019 0x0123456789ABCDEFabcdefp019)
                                    (v128.const f64x2 0x1.fffffffffffffp+1023 0x1.fffffffffffffp+1023))
                                    (v128.const f64x2 0x1.fffffffffffffp+1023 0x1.fffffffffffffp+1023))
(assert_return (invoke "f64x2.pmax" (v128.const f64x2 0x0123456789ABCDEFabcdefp019 0x0123456789ABCDEFabcdefp019)
                                    (v128.const f64x2 -0x1.fffffffffffffp+1023 -0x1.fffffffffffffp+1023))
                                    (v128.const f64x2 0x1.23456789abcdfp+99 0x1.23456789abcdfp+99))
(assert_return (invoke "f64x2.pmax" (v128.const f64x2 0x0123456789ABCDEFabcdefp019 0x0123456789ABCDEFabcdefp019)
                                    (v128.const f64x2 0x0.0000000000001p-1022 0x0.0000000000001p-1022))
                                    (v128.const f64x2 0x1.23456789abcdfp+99 0x1.23456789abcdfp+99))
(assert_return (invoke "f64x2.pmax" (v128.const f64x2 0x0123456789ABCDEFabcdefp019 0x0123456789ABCDEFabcdefp019)
                                    (v128.const f64x2 0x0.0000000000001p-1022 0x0.0000000000001p-1022))
                                    (v128.const f64x2 0x1.23456789abcdfp+99 0x1.23456789abcdfp+99))
(assert_return (invoke "f64x2.pmax" (v128.const f64x2 0x0123456789ABCDEFabcdefp019 0x0123456789ABCDEFabcdefp019)
                                    (v128.const f64x2 inf inf))
                                    (v128.const f64x2 inf inf))
(assert_return (invoke "f64x2.pmax" (v128.const f64x2 0x0123456789ABCDEFabcdefp019 0x0123456789ABCDEFabcdefp019)
                                    (v128.const f64x2 -inf -inf))
                                    (v128.const f64x2 0x1.23456789abcdfp+99 0x1.23456789abcdfp+99))
(assert_return (invoke "f64x2.pmax" (v128.const f64x2 0x0123456789ABCDEFabcdefp019 0x0123456789ABCDEFabcdefp019)
                                    (v128.const f64x2 0123456789 0123456789))
                                    (v128.const f64x2 0x1.23456789abcdfp+99 0x1.23456789abcdfp+99))
(assert_return (invoke "f64x2.pmax" (v128.const f64x2 0x0123456789ABCDEFabcdefp019 0x0123456789ABCDEFabcdefp019)
                                    (v128.const f64x2 0123456789e019 0123456789e019))
                                    (v128.const f64x2 0x1.23456789abcdfp+99 0x1.23456789abcdfp+99))
(assert_return (invoke "f64x2.pmax" (v128.const f64x2 0x0123456789ABCDEFabcdefp019 0x0123456789ABCDEFabcdefp019)
                                    (v128.const f64x2 0123456789e+019 0123456789e+019))
                                    (v128.const f64x2 0x1.23456789abcdfp+99 0x1.23456789abcdfp+99))
(assert_return (invoke "f64x2.pmax" (v128.const f64x2 0x0123456789ABCDEFabcdefp019 0x0123456789ABCDEFabcdefp019)
                                    (v128.const f64x2 0123456789e-019 0123456789e-019))
                                    (v128.const f64x2 0x1.23456789abcdfp+99 0x1.23456789abcdfp+99))
(assert_return (invoke "f64x2.pmax" (v128.const f64x2 0x0123456789ABCDEFabcdefp019 0x0123456789ABCDEFabcdefp019)
                                    (v128.const f64x2 0123456789. 0123456789.))
                                    (v128.const f64x2 0x1.23456789abcdfp+99 0x1.23456789abcdfp+99))
(assert_return (invoke "f64x2.pmax" (v128.const f64x2 0x0123456789ABCDEFabcdefp019 0x0123456789ABCDEFabcdefp019)
                                    (v128.const f64x2 0123456789.e019 0123456789.e019))
                                    (v128.const f64x2 0x1.23456789abcdfp+99 0x1.23456789abcdfp+99))
(assert_return (invoke "f64x2.pmax" (v128.const f64x2 0x0123456789ABCDEFabcdefp019 0x0123456789ABCDEFabcdefp019)
                                    (v128.const f64x2 0123456789.e+019 0123456789.e+019))
                                    (v128.const f64x2 0x1.23456789abcdfp+99 0x1.23456789abcdfp+99))
(assert_return (invoke "f64x2.pmax" (v128.const f64x2 0x0123456789ABCDEFabcdefp019 0x0123456789ABCDEFabcdefp019)
                                    (v128.const f64x2 0123456789.e-019 0123456789.e-019))
                                    (v128.const f64x2 0x1.23456789abcdfp+99 0x1.23456789abcdfp+99))
(assert_return (invoke "f64x2.pmax" (v128.const f64x2 0x0123456789ABCDEFabcdefp019 0x0123456789ABCDEFabcdefp019)
                                    (v128.const f64x2 0123456789.0123456789 0123456789.0123456789))
                                    (v128.const f64x2 0x1.23456789abcdfp+99 0x1.23456789abcdfp+99))
(assert_return (invoke "f64x2.pmax" (v128.const f64x2 0x0123456789ABCDEFabcdefp019 0x0123456789ABCDEFabcdefp019)
                                    (v128.const f64x2 0123456789.0123456789e019 0123456789.0123456789e019))
                                    (v128.const f64x2 0x1.23456789abcdfp+99 0x1.23456789abcdfp+99))
(assert_return (invoke "f64x2.pmax" (v128.const f64x2 0x0123456789ABCDEFabcdefp019 0x0123456789ABCDEFabcdefp019)
                                    (v128.const f64x2 0123456789.0123456789e+019 0123456789.0123456789e+019))
                                    (v128.const f64x2 0x1.23456789abcdfp+99 0x1.23456789abcdfp+99))
(assert_return (invoke "f64x2.pmax" (v128.const f64x2 0x0123456789ABCDEFabcdefp019 0x0123456789ABCDEFabcdefp019)
                                    (v128.const f64x2 0123456789.0123456789e-019 0123456789.0123456789e-019))
                                    (v128.const f64x2 0x1.23456789abcdfp+99 0x1.23456789abcdfp+99))
(assert_return (invoke "f64x2.pmax" (v128.const f64x2 0x0123456789ABCDEFabcdefp019 0x0123456789ABCDEFabcdefp019)
                                    (v128.const f64x2 0x0123456789ABCDEFabcdef 0x0123456789ABCDEFabcdef))
                                    (v128.const f64x2 0x1.23456789abcdfp+99 0x1.23456789abcdfp+99))
(assert_return (invoke "f64x2.pmax" (v128.const f64x2 0x0123456789ABCDEFabcdefp019 0x0123456789ABCDEFabcdefp019)
                                    (v128.const f64x2 0x0123456789ABCDEFabcdefp019 0x0123456789ABCDEFabcdefp019))
                                    (v128.const f64x2 0x1.23456789abcdfp+99 0x1.23456789abcdfp+99))
(assert_return (invoke "f64x2.pmax" (v128.const f64x2 0x0123456789ABCDEFabcdefp019 0x0123456789ABCDEFabcdefp019)
                                    (v128.const f64x2 0x0123456789ABCDEFabcdefp+019 0x0123456789ABCDEFabcdefp+019))
                                    (v128.const f64x2 0x1.23456789abcdfp+99 0x1.23456789abcdfp+99))
(assert_return (invoke "f64x2.pmax" (v128.const f64x2 0x0123456789ABCDEFabcdefp019 0x0123456789ABCDEFabcdefp019)
                                    (v128.const f64x2 0x0123456789ABCDEFabcdefp-019 0x0123456789ABCDEFabcdefp-019))
                                    (v128.const f64x2 0x1.23456789abcdfp+99 0x1.23456789abcdfp+99))
(assert_return (invoke "f64x2.pmax" (v128.const f64x2 0x0123456789ABCDEFabcdefp019 0x0123456789ABCDEFabcdefp019)
                                    (v128.const f64x2 0x0123456789ABCDEFabcdef. 0x0123456789ABCDEFabcdef.))
                                    (v128.const f64x2 0x1.23456789abcdfp+99 0x1.23456789abcdfp+99))
(assert_return (invoke "f64x2.pmax" (v128.const f64x2 0x0123456789ABCDEFabcdefp019 0x0123456789ABCDEFabcdefp019)
                                    (v128.const f64x2 0x0123456789ABCDEFabcdef.p019 0x0123456789ABCDEFabcdef.p019))
                                    (v128.const f64x2 0x1.23456789abcdfp+99 0x1.23456789abcdfp+99))
(assert_return (invoke "f64x2.pmax" (v128.const f64x2 0x0123456789ABCDEFabcdefp019 0x0123456789ABCDEFabcdefp019)
                                    (v128.const f64x2 0x0123456789ABCDEFabcdef.p+019 0x0123456789ABCDEFabcdef.p+019))
                                    (v128.const f64x2 0x1.23456789abcdfp+99 0x1.23456789abcdfp+99))
(assert_return (invoke "f64x2.pmax" (v128.const f64x2 0x0123456789ABCDEFabcdefp019 0x0123456789ABCDEFabcdefp019)
                                    (v128.const f64x2 0x0123456789ABCDEFabcdef.p-019 0x0123456789ABCDEFabcdef.p-019))
                                    (v128.const f64x2 0x1.23456789abcdfp+99 0x1.23456789abcdfp+99))
(assert_return (invoke "f64x2.pmax" (v128.const f64x2 0x0123456789ABCDEFabcdefp019 0x0123456789ABCDEFabcdefp019)
                                    (v128.const f64x2 0x0123456789ABCDEFabcdef.0123456789ABCDEFabcdef 0x0123456789ABCDEFabcdef.0123456789ABCDEFabcdef))
                                    (v128.const f64x2 0x1.23456789abcdfp+99 0x1.23456789abcdfp+99))
(assert_return (invoke "f64x2.pmax" (v128.const f64x2 0x0123456789ABCDEFabcdefp019 0x0123456789ABCDEFabcdefp019)
                                    (v128.const f64x2 0x0123456789ABCDEFabcdef.0123456789ABCDEFabcdefp019 0x0123456789ABCDEFabcdef.0123456789ABCDEFabcdefp019))
                                    (v128.const f64x2 0x1.23456789abcdfp+99 0x1.23456789abcdfp+99))
(assert_return (invoke "f64x2.pmax" (v128.const f64x2 0x0123456789ABCDEFabcdefp019 0x0123456789ABCDEFabcdefp019)
                                    (v128.const f64x2 0x0123456789ABCDEFabcdef.0123456789ABCDEFabcdefp+019 0x0123456789ABCDEFabcdef.0123456789ABCDEFabcdefp+019))
                                    (v128.const f64x2 0x1.23456789abcdfp+99 0x1.23456789abcdfp+99))
(assert_return (invoke "f64x2.pmax" (v128.const f64x2 0x0123456789ABCDEFabcdefp019 0x0123456789ABCDEFabcdefp019)
                                    (v128.const f64x2 0x0123456789ABCDEFabcdef.0123456789ABCDEFabcdefp-019 0x0123456789ABCDEFabcdef.0123456789ABCDEFabcdefp-019))
                                    (v128.const f64x2 0x1.23456789abcdfp+99 0x1.23456789abcdfp+99))
(assert_return (invoke "f64x2.pmax" (v128.const f64x2 0x0123456789ABCDEFabcdefp+019 0x0123456789ABCDEFabcdefp+019)
                                    (v128.const f64x2 0x0p+0 0x0p+0))
                                    (v128.const f64x2 0x1.23456789abcdfp+99 0x1.23456789abcdfp+99))
(assert_return (invoke "f64x2.pmax" (v128.const f64x2 0x0123456789ABCDEFabcdefp+019 0x0123456789ABCDEFabcdefp+019)
                                    (v128.const f64x2 -0x0p+0 -0x0p+0))
                                    (v128.const f64x2 0x1.23456789abcdfp+99 0x1.23456789abcdfp+99))
(assert_return (invoke "f64x2.pmax" (v128.const f64x2 0x0123456789ABCDEFabcdefp+019 0x0123456789ABCDEFabcdefp+019)
                                    (v128.const f64x2 0x1p-1022 0x1p-1022))
                                    (v128.const f64x2 0x1.23456789abcdfp+99 0x1.23456789abcdfp+99))
(assert_return (invoke "f64x2.pmax" (v128.const f64x2 0x0123456789ABCDEFabcdefp+019 0x0123456789ABCDEFabcdefp+019)
                                    (v128.const f64x2 -0x1p-1022 -0x1p-1022))
                                    (v128.const f64x2 0x1.23456789abcdfp+99 0x1.23456789abcdfp+99))
(assert_return (invoke "f64x2.pmax" (v128.const f64x2 0x0123456789ABCDEFabcdefp+019 0x0123456789ABCDEFabcdefp+019)
                                    (v128.const f64x2 0x1p-1 0x1p-1))
                                    (v128.const f64x2 0x1.23456789abcdfp+99 0x1.23456789abcdfp+99))
(assert_return (invoke "f64x2.pmax" (v128.const f64x2 0x0123456789ABCDEFabcdefp+019 0x0123456789ABCDEFabcdefp+019)
                                    (v128.const f64x2 -0x1p-1 -0x1p-1))
                                    (v128.const f64x2 0x1.23456789abcdfp+99 0x1.23456789abcdfp+99))
(assert_return (invoke "f64x2.pmax" (v128.const f64x2 0x0123456789ABCDEFabcdefp+019 0x0123456789ABCDEFabcdefp+019)
                                    (v128.const f64x2 0x1p+0 0x1p+0))
                                    (v128.const f64x2 0x1.23456789abcdfp+99 0x1.23456789abcdfp+99))
(assert_return (invoke "f64x2.pmax" (v128.const f64x2 0x0123456789ABCDEFabcdefp+019 0x0123456789ABCDEFabcdefp+019)
                                    (v128.const f64x2 -0x1p+0 -0x1p+0))
                                    (v128.const f64x2 0x1.23456789abcdfp+99 0x1.23456789abcdfp+99))
(assert_return (invoke "f64x2.pmax" (v128.const f64x2 0x0123456789ABCDEFabcdefp+019 0x0123456789ABCDEFabcdefp+019)
                                    (v128.const f64x2 0x1.921fb54442d18p+2 0x1.921fb54442d18p+2))
                                    (v128.const f64x2 0x1.23456789abcdfp+99 0x1.23456789abcdfp+99))
(assert_return (invoke "f64x2.pmax" (v128.const f64x2 0x0123456789ABCDEFabcdefp+019 0x0123456789ABCDEFabcdefp+019)
                                    (v128.const f64x2 -0x1.921fb54442d18p+2 -0x1.921fb54442d18p+2))
                                    (v128.const f64x2 0x1.23456789abcdfp+99 0x1.23456789abcdfp+99))
(assert_return (invoke "f64x2.pmax" (v128.const f64x2 0x0123456789ABCDEFabcdefp+019 0x0123456789ABCDEFabcdefp+019)
                                    (v128.const f64x2 0x1.fffffffffffffp+1023 0x1.fffffffffffffp+1023))
                                    (v128.const f64x2 0x1.fffffffffffffp+1023 0x1.fffffffffffffp+1023))
(assert_return (invoke "f64x2.pmax" (v128.const f64x2 0x0123456789ABCDEFabcdefp+019 0x0123456789ABCDEFabcdefp+019)
                                    (v128.const f64x2 -0x1.fffffffffffffp+1023 -0x1.fffffffffffffp+1023))
                                    (v128.const f64x2 0x1.23456789abcdfp+99 0x1.23456789abcdfp+99))
(assert_return (invoke "f64x2.pmax" (v128.const f64x2 0x0123456789ABCDEFabcdefp+019 0x0123456789ABCDEFabcdefp+019)
                                    (v128.const f64x2 0x0.0000000000001p-1022 0x0.0000000000001p-1022))
                                    (v128.const f64x2 0x1.23456789abcdfp+99 0x1.23456789abcdfp+99))
(assert_return (invoke "f64x2.pmax" (v128.const f64x2 0x0123456789ABCDEFabcdefp+019 0x0123456789ABCDEFabcdefp+019)
                                    (v128.const f64x2 0x0.0000000000001p-1022 0x0.0000000000001p-1022))
                                    (v128.const f64x2 0x1.23456789abcdfp+99 0x1.23456789abcdfp+99))
(assert_return (invoke "f64x2.pmax" (v128.const f64x2 0x0123456789ABCDEFabcdefp+019 0x0123456789ABCDEFabcdefp+019)
                                    (v128.const f64x2 inf inf))
                                    (v128.const f64x2 inf inf))
(assert_return (invoke "f64x2.pmax" (v128.const f64x2 0x0123456789ABCDEFabcdefp+019 0x0123456789ABCDEFabcdefp+019)
                                    (v128.const f64x2 -inf -inf))
                                    (v128.const f64x2 0x1.23456789abcdfp+99 0x1.23456789abcdfp+99))
(assert_return (invoke "f64x2.pmax" (v128.const f64x2 0x0123456789ABCDEFabcdefp+019 0x0123456789ABCDEFabcdefp+019)
                                    (v128.const f64x2 0123456789 0123456789))
                                    (v128.const f64x2 0x1.23456789abcdfp+99 0x1.23456789abcdfp+99))
(assert_return (invoke "f64x2.pmax" (v128.const f64x2 0x0123456789ABCDEFabcdefp+019 0x0123456789ABCDEFabcdefp+019)
                                    (v128.const f64x2 0123456789e019 0123456789e019))
                                    (v128.const f64x2 0x1.23456789abcdfp+99 0x1.23456789abcdfp+99))
(assert_return (invoke "f64x2.pmax" (v128.const f64x2 0x0123456789ABCDEFabcdefp+019 0x0123456789ABCDEFabcdefp+019)
                                    (v128.const f64x2 0123456789e+019 0123456789e+019))
                                    (v128.const f64x2 0x1.23456789abcdfp+99 0x1.23456789abcdfp+99))
(assert_return (invoke "f64x2.pmax" (v128.const f64x2 0x0123456789ABCDEFabcdefp+019 0x0123456789ABCDEFabcdefp+019)
                                    (v128.const f64x2 0123456789e-019 0123456789e-019))
                                    (v128.const f64x2 0x1.23456789abcdfp+99 0x1.23456789abcdfp+99))
(assert_return (invoke "f64x2.pmax" (v128.const f64x2 0x0123456789ABCDEFabcdefp+019 0x0123456789ABCDEFabcdefp+019)
                                    (v128.const f64x2 0123456789. 0123456789.))
                                    (v128.const f64x2 0x1.23456789abcdfp+99 0x1.23456789abcdfp+99))
(assert_return (invoke "f64x2.pmax" (v128.const f64x2 0x0123456789ABCDEFabcdefp+019 0x0123456789ABCDEFabcdefp+019)
                                    (v128.const f64x2 0123456789.e019 0123456789.e019))
                                    (v128.const f64x2 0x1.23456789abcdfp+99 0x1.23456789abcdfp+99))
(assert_return (invoke "f64x2.pmax" (v128.const f64x2 0x0123456789ABCDEFabcdefp+019 0x0123456789ABCDEFabcdefp+019)
                                    (v128.const f64x2 0123456789.e+019 0123456789.e+019))
                                    (v128.const f64x2 0x1.23456789abcdfp+99 0x1.23456789abcdfp+99))
(assert_return (invoke "f64x2.pmax" (v128.const f64x2 0x0123456789ABCDEFabcdefp+019 0x0123456789ABCDEFabcdefp+019)
                                    (v128.const f64x2 0123456789.e-019 0123456789.e-019))
                                    (v128.const f64x2 0x1.23456789abcdfp+99 0x1.23456789abcdfp+99))
(assert_return (invoke "f64x2.pmax" (v128.const f64x2 0x0123456789ABCDEFabcdefp+019 0x0123456789ABCDEFabcdefp+019)
                                    (v128.const f64x2 0123456789.0123456789 0123456789.0123456789))
                                    (v128.const f64x2 0x1.23456789abcdfp+99 0x1.23456789abcdfp+99))
(assert_return (invoke "f64x2.pmax" (v128.const f64x2 0x0123456789ABCDEFabcdefp+019 0x0123456789ABCDEFabcdefp+019)
                                    (v128.const f64x2 0123456789.0123456789e019 0123456789.0123456789e019))
                                    (v128.const f64x2 0x1.23456789abcdfp+99 0x1.23456789abcdfp+99))
(assert_return (invoke "f64x2.pmax" (v128.const f64x2 0x0123456789ABCDEFabcdefp+019 0x0123456789ABCDEFabcdefp+019)
                                    (v128.const f64x2 0123456789.0123456789e+019 0123456789.0123456789e+019))
                                    (v128.const f64x2 0x1.23456789abcdfp+99 0x1.23456789abcdfp+99))
(assert_return (invoke "f64x2.pmax" (v128.const f64x2 0x0123456789ABCDEFabcdefp+019 0x0123456789ABCDEFabcdefp+019)
                                    (v128.const f64x2 0123456789.0123456789e-019 0123456789.0123456789e-019))
                                    (v128.const f64x2 0x1.23456789abcdfp+99 0x1.23456789abcdfp+99))
(assert_return (invoke "f64x2.pmax" (v128.const f64x2 0x0123456789ABCDEFabcdefp+019 0x0123456789ABCDEFabcdefp+019)
                                    (v128.const f64x2 0x0123456789ABCDEFabcdef 0x0123456789ABCDEFabcdef))
                                    (v128.const f64x2 0x1.23456789abcdfp+99 0x1.23456789abcdfp+99))
(assert_return (invoke "f64x2.pmax" (v128.const f64x2 0x0123456789ABCDEFabcdefp+019 0x0123456789ABCDEFabcdefp+019)
                                    (v128.const f64x2 0x0123456789ABCDEFabcdefp019 0x0123456789ABCDEFabcdefp019))
                                    (v128.const f64x2 0x1.23456789abcdfp+99 0x1.23456789abcdfp+99))
(assert_return (invoke "f64x2.pmax" (v128.const f64x2 0x0123456789ABCDEFabcdefp+019 0x0123456789ABCDEFabcdefp+019)
                                    (v128.const f64x2 0x0123456789ABCDEFabcdefp+019 0x0123456789ABCDEFabcdefp+019))
                                    (v128.const f64x2 0x1.23456789abcdfp+99 0x1.23456789abcdfp+99))
(assert_return (invoke "f64x2.pmax" (v128.const f64x2 0x0123456789ABCDEFabcdefp+019 0x0123456789ABCDEFabcdefp+019)
                                    (v128.const f64x2 0x0123456789ABCDEFabcdefp-019 0x0123456789ABCDEFabcdefp-019))
                                    (v128.const f64x2 0x1.23456789abcdfp+99 0x1.23456789abcdfp+99))
(assert_return (invoke "f64x2.pmax" (v128.const f64x2 0x0123456789ABCDEFabcdefp+019 0x0123456789ABCDEFabcdefp+019)
                                    (v128.const f64x2 0x0123456789ABCDEFabcdef. 0x0123456789ABCDEFabcdef.))
                                    (v128.const f64x2 0x1.23456789abcdfp+99 0x1.23456789abcdfp+99))
(assert_return (invoke "f64x2.pmax" (v128.const f64x2 0x0123456789ABCDEFabcdefp+019 0x0123456789ABCDEFabcdefp+019)
                                    (v128.const f64x2 0x0123456789ABCDEFabcdef.p019 0x0123456789ABCDEFabcdef.p019))
                                    (v128.const f64x2 0x1.23456789abcdfp+99 0x1.23456789abcdfp+99))
(assert_return (invoke "f64x2.pmax" (v128.const f64x2 0x0123456789ABCDEFabcdefp+019 0x0123456789ABCDEFabcdefp+019)
                                    (v128.const f64x2 0x0123456789ABCDEFabcdef.p+019 0x0123456789ABCDEFabcdef.p+019))
                                    (v128.const f64x2 0x1.23456789abcdfp+99 0x1.23456789abcdfp+99))
(assert_return (invoke "f64x2.pmax" (v128.const f64x2 0x0123456789ABCDEFabcdefp+019 0x0123456789ABCDEFabcdefp+019)
                                    (v128.const f64x2 0x0123456789ABCDEFabcdef.p-019 0x0123456789ABCDEFabcdef.p-019))
                                    (v128.const f64x2 0x1.23456789abcdfp+99 0x1.23456789abcdfp+99))
(assert_return (invoke "f64x2.pmax" (v128.const f64x2 0x0123456789ABCDEFabcdefp+019 0x0123456789ABCDEFabcdefp+019)
                                    (v128.const f64x2 0x0123456789ABCDEFabcdef.0123456789ABCDEFabcdef 0x0123456789ABCDEFabcdef.0123456789ABCDEFabcdef))
                                    (v128.const f64x2 0x1.23456789abcdfp+99 0x1.23456789abcdfp+99))
(assert_return (invoke "f64x2.pmax" (v128.const f64x2 0x0123456789ABCDEFabcdefp+019 0x0123456789ABCDEFabcdefp+019)
                                    (v128.const f64x2 0x0123456789ABCDEFabcdef.0123456789ABCDEFabcdefp019 0x0123456789ABCDEFabcdef.0123456789ABCDEFabcdefp019))
                                    (v128.const f64x2 0x1.23456789abcdfp+99 0x1.23456789abcdfp+99))
(assert_return (invoke "f64x2.pmax" (v128.const f64x2 0x0123456789ABCDEFabcdefp+019 0x0123456789ABCDEFabcdefp+019)
                                    (v128.const f64x2 0x0123456789ABCDEFabcdef.0123456789ABCDEFabcdefp+019 0x0123456789ABCDEFabcdef.0123456789ABCDEFabcdefp+019))
                                    (v128.const f64x2 0x1.23456789abcdfp+99 0x1.23456789abcdfp+99))
(assert_return (invoke "f64x2.pmax" (v128.const f64x2 0x0123456789ABCDEFabcdefp+019 0x0123456789ABCDEFabcdefp+019)
                                    (v128.const f64x2 0x0123456789ABCDEFabcdef.0123456789ABCDEFabcdefp-019 0x0123456789ABCDEFabcdef.0123456789ABCDEFabcdefp-019))
                                    (v128.const f64x2 0x1.23456789abcdfp+99 0x1.23456789abcdfp+99))
(assert_return (invoke "f64x2.pmax" (v128.const f64x2 0x0123456789ABCDEFabcdefp-019 0x0123456789ABCDEFabcdefp-019)
                                    (v128.const f64x2 0x0p+0 0x0p+0))
                                    (v128.const f64x2 0x1.23456789abcdfp+61 0x1.23456789abcdfp+61))
(assert_return (invoke "f64x2.pmax" (v128.const f64x2 0x0123456789ABCDEFabcdefp-019 0x0123456789ABCDEFabcdefp-019)
                                    (v128.const f64x2 -0x0p+0 -0x0p+0))
                                    (v128.const f64x2 0x1.23456789abcdfp+61 0x1.23456789abcdfp+61))
(assert_return (invoke "f64x2.pmax" (v128.const f64x2 0x0123456789ABCDEFabcdefp-019 0x0123456789ABCDEFabcdefp-019)
                                    (v128.const f64x2 0x1p-1022 0x1p-1022))
                                    (v128.const f64x2 0x1.23456789abcdfp+61 0x1.23456789abcdfp+61))
(assert_return (invoke "f64x2.pmax" (v128.const f64x2 0x0123456789ABCDEFabcdefp-019 0x0123456789ABCDEFabcdefp-019)
                                    (v128.const f64x2 -0x1p-1022 -0x1p-1022))
                                    (v128.const f64x2 0x1.23456789abcdfp+61 0x1.23456789abcdfp+61))
(assert_return (invoke "f64x2.pmax" (v128.const f64x2 0x0123456789ABCDEFabcdefp-019 0x0123456789ABCDEFabcdefp-019)
                                    (v128.const f64x2 0x1p-1 0x1p-1))
                                    (v128.const f64x2 0x1.23456789abcdfp+61 0x1.23456789abcdfp+61))
(assert_return (invoke "f64x2.pmax" (v128.const f64x2 0x0123456789ABCDEFabcdefp-019 0x0123456789ABCDEFabcdefp-019)
                                    (v128.const f64x2 -0x1p-1 -0x1p-1))
                                    (v128.const f64x2 0x1.23456789abcdfp+61 0x1.23456789abcdfp+61))
(assert_return (invoke "f64x2.pmax" (v128.const f64x2 0x0123456789ABCDEFabcdefp-019 0x0123456789ABCDEFabcdefp-019)
                                    (v128.const f64x2 0x1p+0 0x1p+0))
                                    (v128.const f64x2 0x1.23456789abcdfp+61 0x1.23456789abcdfp+61))
(assert_return (invoke "f64x2.pmax" (v128.const f64x2 0x0123456789ABCDEFabcdefp-019 0x0123456789ABCDEFabcdefp-019)
                                    (v128.const f64x2 -0x1p+0 -0x1p+0))
                                    (v128.const f64x2 0x1.23456789abcdfp+61 0x1.23456789abcdfp+61))
(assert_return (invoke "f64x2.pmax" (v128.const f64x2 0x0123456789ABCDEFabcdefp-019 0x0123456789ABCDEFabcdefp-019)
                                    (v128.const f64x2 0x1.921fb54442d18p+2 0x1.921fb54442d18p+2))
                                    (v128.const f64x2 0x1.23456789abcdfp+61 0x1.23456789abcdfp+61))
(assert_return (invoke "f64x2.pmax" (v128.const f64x2 0x0123456789ABCDEFabcdefp-019 0x0123456789ABCDEFabcdefp-019)
                                    (v128.const f64x2 -0x1.921fb54442d18p+2 -0x1.921fb54442d18p+2))
                                    (v128.const f64x2 0x1.23456789abcdfp+61 0x1.23456789abcdfp+61))
(assert_return (invoke "f64x2.pmax" (v128.const f64x2 0x0123456789ABCDEFabcdefp-019 0x0123456789ABCDEFabcdefp-019)
                                    (v128.const f64x2 0x1.fffffffffffffp+1023 0x1.fffffffffffffp+1023))
                                    (v128.const f64x2 0x1.fffffffffffffp+1023 0x1.fffffffffffffp+1023))
(assert_return (invoke "f64x2.pmax" (v128.const f64x2 0x0123456789ABCDEFabcdefp-019 0x0123456789ABCDEFabcdefp-019)
                                    (v128.const f64x2 -0x1.fffffffffffffp+1023 -0x1.fffffffffffffp+1023))
                                    (v128.const f64x2 0x1.23456789abcdfp+61 0x1.23456789abcdfp+61))
(assert_return (invoke "f64x2.pmax" (v128.const f64x2 0x0123456789ABCDEFabcdefp-019 0x0123456789ABCDEFabcdefp-019)
                                    (v128.const f64x2 0x0.0000000000001p-1022 0x0.0000000000001p-1022))
                                    (v128.const f64x2 0x1.23456789abcdfp+61 0x1.23456789abcdfp+61))
(assert_return (invoke "f64x2.pmax" (v128.const f64x2 0x0123456789ABCDEFabcdefp-019 0x0123456789ABCDEFabcdefp-019)
                                    (v128.const f64x2 0x0.0000000000001p-1022 0x0.0000000000001p-1022))
                                    (v128.const f64x2 0x1.23456789abcdfp+61 0x1.23456789abcdfp+61))
(assert_return (invoke "f64x2.pmax" (v128.const f64x2 0x0123456789ABCDEFabcdefp-019 0x0123456789ABCDEFabcdefp-019)
                                    (v128.const f64x2 inf inf))
                                    (v128.const f64x2 inf inf))
(assert_return (invoke "f64x2.pmax" (v128.const f64x2 0x0123456789ABCDEFabcdefp-019 0x0123456789ABCDEFabcdefp-019)
                                    (v128.const f64x2 -inf -inf))
                                    (v128.const f64x2 0x1.23456789abcdfp+61 0x1.23456789abcdfp+61))
(assert_return (invoke "f64x2.pmax" (v128.const f64x2 0x0123456789ABCDEFabcdefp-019 0x0123456789ABCDEFabcdefp-019)
                                    (v128.const f64x2 0123456789 0123456789))
                                    (v128.const f64x2 0x1.23456789abcdfp+61 0x1.23456789abcdfp+61))
(assert_return (invoke "f64x2.pmax" (v128.const f64x2 0x0123456789ABCDEFabcdefp-019 0x0123456789ABCDEFabcdefp-019)
                                    (v128.const f64x2 0123456789e019 0123456789e019))
                                    (v128.const f64x2 0x1.fe9af5b5e16fap+89 0x1.fe9af5b5e16fap+89))
(assert_return (invoke "f64x2.pmax" (v128.const f64x2 0x0123456789ABCDEFabcdefp-019 0x0123456789ABCDEFabcdefp-019)
                                    (v128.const f64x2 0123456789e+019 0123456789e+019))
                                    (v128.const f64x2 0x1.fe9af5b5e16fap+89 0x1.fe9af5b5e16fap+89))
(assert_return (invoke "f64x2.pmax" (v128.const f64x2 0x0123456789ABCDEFabcdefp-019 0x0123456789ABCDEFabcdefp-019)
                                    (v128.const f64x2 0123456789e-019 0123456789e-019))
                                    (v128.const f64x2 0x1.23456789abcdfp+61 0x1.23456789abcdfp+61))
(assert_return (invoke "f64x2.pmax" (v128.const f64x2 0x0123456789ABCDEFabcdefp-019 0x0123456789ABCDEFabcdefp-019)
                                    (v128.const f64x2 0123456789. 0123456789.))
                                    (v128.const f64x2 0x1.23456789abcdfp+61 0x1.23456789abcdfp+61))
(assert_return (invoke "f64x2.pmax" (v128.const f64x2 0x0123456789ABCDEFabcdefp-019 0x0123456789ABCDEFabcdefp-019)
                                    (v128.const f64x2 0123456789.e019 0123456789.e019))
                                    (v128.const f64x2 0x1.fe9af5b5e16fap+89 0x1.fe9af5b5e16fap+89))
(assert_return (invoke "f64x2.pmax" (v128.const f64x2 0x0123456789ABCDEFabcdefp-019 0x0123456789ABCDEFabcdefp-019)
                                    (v128.const f64x2 0123456789.e+019 0123456789.e+019))
                                    (v128.const f64x2 0x1.fe9af5b5e16fap+89 0x1.fe9af5b5e16fap+89))
(assert_return (invoke "f64x2.pmax" (v128.const f64x2 0x0123456789ABCDEFabcdefp-019 0x0123456789ABCDEFabcdefp-019)
                                    (v128.const f64x2 0123456789.e-019 0123456789.e-019))
                                    (v128.const f64x2 0x1.23456789abcdfp+61 0x1.23456789abcdfp+61))
(assert_return (invoke "f64x2.pmax" (v128.const f64x2 0x0123456789ABCDEFabcdefp-019 0x0123456789ABCDEFabcdefp-019)
                                    (v128.const f64x2 0123456789.0123456789 0123456789.0123456789))
                                    (v128.const f64x2 0x1.23456789abcdfp+61 0x1.23456789abcdfp+61))
(assert_return (invoke "f64x2.pmax" (v128.const f64x2 0x0123456789ABCDEFabcdefp-019 0x0123456789ABCDEFabcdefp-019)
                                    (v128.const f64x2 0123456789.0123456789e019 0123456789.0123456789e019))
                                    (v128.const f64x2 0x1.fe9af5b6bcbd5p+89 0x1.fe9af5b6bcbd5p+89))
(assert_return (invoke "f64x2.pmax" (v128.const f64x2 0x0123456789ABCDEFabcdefp-019 0x0123456789ABCDEFabcdefp-019)
                                    (v128.const f64x2 0123456789.0123456789e+019 0123456789.0123456789e+019))
                                    (v128.const f64x2 0x1.fe9af5b6bcbd5p+89 0x1.fe9af5b6bcbd5p+89))
(assert_return (invoke "f64x2.pmax" (v128.const f64x2 0x0123456789ABCDEFabcdefp-019 0x0123456789ABCDEFabcdefp-019)
                                    (v128.const f64x2 0123456789.0123456789e-019 0123456789.0123456789e-019))
                                    (v128.const f64x2 0x1.23456789abcdfp+61 0x1.23456789abcdfp+61))
(assert_return (invoke "f64x2.pmax" (v128.const f64x2 0x0123456789ABCDEFabcdefp-019 0x0123456789ABCDEFabcdefp-019)
                                    (v128.const f64x2 0x0123456789ABCDEFabcdef 0x0123456789ABCDEFabcdef))
                                    (v128.const f64x2 0x1.23456789abcdfp+80 0x1.23456789abcdfp+80))
(assert_return (invoke "f64x2.pmax" (v128.const f64x2 0x0123456789ABCDEFabcdefp-019 0x0123456789ABCDEFabcdefp-019)
                                    (v128.const f64x2 0x0123456789ABCDEFabcdefp019 0x0123456789ABCDEFabcdefp019))
                                    (v128.const f64x2 0x1.23456789abcdfp+99 0x1.23456789abcdfp+99))
(assert_return (invoke "f64x2.pmax" (v128.const f64x2 0x0123456789ABCDEFabcdefp-019 0x0123456789ABCDEFabcdefp-019)
                                    (v128.const f64x2 0x0123456789ABCDEFabcdefp+019 0x0123456789ABCDEFabcdefp+019))
                                    (v128.const f64x2 0x1.23456789abcdfp+99 0x1.23456789abcdfp+99))
(assert_return (invoke "f64x2.pmax" (v128.const f64x2 0x0123456789ABCDEFabcdefp-019 0x0123456789ABCDEFabcdefp-019)
                                    (v128.const f64x2 0x0123456789ABCDEFabcdefp-019 0x0123456789ABCDEFabcdefp-019))
                                    (v128.const f64x2 0x1.23456789abcdfp+61 0x1.23456789abcdfp+61))
(assert_return (invoke "f64x2.pmax" (v128.const f64x2 0x0123456789ABCDEFabcdefp-019 0x0123456789ABCDEFabcdefp-019)
                                    (v128.const f64x2 0x0123456789ABCDEFabcdef. 0x0123456789ABCDEFabcdef.))
                                    (v128.const f64x2 0x1.23456789abcdfp+80 0x1.23456789abcdfp+80))
(assert_return (invoke "f64x2.pmax" (v128.const f64x2 0x0123456789ABCDEFabcdefp-019 0x0123456789ABCDEFabcdefp-019)
                                    (v128.const f64x2 0x0123456789ABCDEFabcdef.p019 0x0123456789ABCDEFabcdef.p019))
                                    (v128.const f64x2 0x1.23456789abcdfp+99 0x1.23456789abcdfp+99))
(assert_return (invoke "f64x2.pmax" (v128.const f64x2 0x0123456789ABCDEFabcdefp-019 0x0123456789ABCDEFabcdefp-019)
                                    (v128.const f64x2 0x0123456789ABCDEFabcdef.p+019 0x0123456789ABCDEFabcdef.p+019))
                                    (v128.const f64x2 0x1.23456789abcdfp+99 0x1.23456789abcdfp+99))
(assert_return (invoke "f64x2.pmax" (v128.const f64x2 0x0123456789ABCDEFabcdefp-019 0x0123456789ABCDEFabcdefp-019)
                                    (v128.const f64x2 0x0123456789ABCDEFabcdef.p-019 0x0123456789ABCDEFabcdef.p-019))
                                    (v128.const f64x2 0x1.23456789abcdfp+61 0x1.23456789abcdfp+61))
(assert_return (invoke "f64x2.pmax" (v128.const f64x2 0x0123456789ABCDEFabcdefp-019 0x0123456789ABCDEFabcdefp-019)
                                    (v128.const f64x2 0x0123456789ABCDEFabcdef.0123456789ABCDEFabcdef 0x0123456789ABCDEFabcdef.0123456789ABCDEFabcdef))
                                    (v128.const f64x2 0x1.23456789abcdfp+80 0x1.23456789abcdfp+80))
(assert_return (invoke "f64x2.pmax" (v128.const f64x2 0x0123456789ABCDEFabcdefp-019 0x0123456789ABCDEFabcdefp-019)
                                    (v128.const f64x2 0x0123456789ABCDEFabcdef.0123456789ABCDEFabcdefp019 0x0123456789ABCDEFabcdef.0123456789ABCDEFabcdefp019))
                                    (v128.const f64x2 0x1.23456789abcdfp+99 0x1.23456789abcdfp+99))
(assert_return (invoke "f64x2.pmax" (v128.const f64x2 0x0123456789ABCDEFabcdefp-019 0x0123456789ABCDEFabcdefp-019)
                                    (v128.const f64x2 0x0123456789ABCDEFabcdef.0123456789ABCDEFabcdefp+019 0x0123456789ABCDEFabcdef.0123456789ABCDEFabcdefp+019))
                                    (v128.const f64x2 0x1.23456789abcdfp+99 0x1.23456789abcdfp+99))
(assert_return (invoke "f64x2.pmax" (v128.const f64x2 0x0123456789ABCDEFabcdefp-019 0x0123456789ABCDEFabcdefp-019)
                                    (v128.const f64x2 0x0123456789ABCDEFabcdef.0123456789ABCDEFabcdefp-019 0x0123456789ABCDEFabcdef.0123456789ABCDEFabcdefp-019))
                                    (v128.const f64x2 0x1.23456789abcdfp+61 0x1.23456789abcdfp+61))
(assert_return (invoke "f64x2.pmax" (v128.const f64x2 0x0123456789ABCDEFabcdef. 0x0123456789ABCDEFabcdef.)
                                    (v128.const f64x2 0x0p+0 0x0p+0))
                                    (v128.const f64x2 0x1.23456789abcdfp+80 0x1.23456789abcdfp+80))
(assert_return (invoke "f64x2.pmax" (v128.const f64x2 0x0123456789ABCDEFabcdef. 0x0123456789ABCDEFabcdef.)
                                    (v128.const f64x2 -0x0p+0 -0x0p+0))
                                    (v128.const f64x2 0x1.23456789abcdfp+80 0x1.23456789abcdfp+80))
(assert_return (invoke "f64x2.pmax" (v128.const f64x2 0x0123456789ABCDEFabcdef. 0x0123456789ABCDEFabcdef.)
                                    (v128.const f64x2 0x1p-1022 0x1p-1022))
                                    (v128.const f64x2 0x1.23456789abcdfp+80 0x1.23456789abcdfp+80))
(assert_return (invoke "f64x2.pmax" (v128.const f64x2 0x0123456789ABCDEFabcdef. 0x0123456789ABCDEFabcdef.)
                                    (v128.const f64x2 -0x1p-1022 -0x1p-1022))
                                    (v128.const f64x2 0x1.23456789abcdfp+80 0x1.23456789abcdfp+80))
(assert_return (invoke "f64x2.pmax" (v128.const f64x2 0x0123456789ABCDEFabcdef. 0x0123456789ABCDEFabcdef.)
                                    (v128.const f64x2 0x1p-1 0x1p-1))
                                    (v128.const f64x2 0x1.23456789abcdfp+80 0x1.23456789abcdfp+80))
(assert_return (invoke "f64x2.pmax" (v128.const f64x2 0x0123456789ABCDEFabcdef. 0x0123456789ABCDEFabcdef.)
                                    (v128.const f64x2 -0x1p-1 -0x1p-1))
                                    (v128.const f64x2 0x1.23456789abcdfp+80 0x1.23456789abcdfp+80))
(assert_return (invoke "f64x2.pmax" (v128.const f64x2 0x0123456789ABCDEFabcdef. 0x0123456789ABCDEFabcdef.)
                                    (v128.const f64x2 0x1p+0 0x1p+0))
                                    (v128.const f64x2 0x1.23456789abcdfp+80 0x1.23456789abcdfp+80))
(assert_return (invoke "f64x2.pmax" (v128.const f64x2 0x0123456789ABCDEFabcdef. 0x0123456789ABCDEFabcdef.)
                                    (v128.const f64x2 -0x1p+0 -0x1p+0))
                                    (v128.const f64x2 0x1.23456789abcdfp+80 0x1.23456789abcdfp+80))
(assert_return (invoke "f64x2.pmax" (v128.const f64x2 0x0123456789ABCDEFabcdef. 0x0123456789ABCDEFabcdef.)
                                    (v128.const f64x2 0x1.921fb54442d18p+2 0x1.921fb54442d18p+2))
                                    (v128.const f64x2 0x1.23456789abcdfp+80 0x1.23456789abcdfp+80))
(assert_return (invoke "f64x2.pmax" (v128.const f64x2 0x0123456789ABCDEFabcdef. 0x0123456789ABCDEFabcdef.)
                                    (v128.const f64x2 -0x1.921fb54442d18p+2 -0x1.921fb54442d18p+2))
                                    (v128.const f64x2 0x1.23456789abcdfp+80 0x1.23456789abcdfp+80))
(assert_return (invoke "f64x2.pmax" (v128.const f64x2 0x0123456789ABCDEFabcdef. 0x0123456789ABCDEFabcdef.)
                                    (v128.const f64x2 0x1.fffffffffffffp+1023 0x1.fffffffffffffp+1023))
                                    (v128.const f64x2 0x1.fffffffffffffp+1023 0x1.fffffffffffffp+1023))
(assert_return (invoke "f64x2.pmax" (v128.const f64x2 0x0123456789ABCDEFabcdef. 0x0123456789ABCDEFabcdef.)
                                    (v128.const f64x2 -0x1.fffffffffffffp+1023 -0x1.fffffffffffffp+1023))
                                    (v128.const f64x2 0x1.23456789abcdfp+80 0x1.23456789abcdfp+80))
(assert_return (invoke "f64x2.pmax" (v128.const f64x2 0x0123456789ABCDEFabcdef. 0x0123456789ABCDEFabcdef.)
                                    (v128.const f64x2 0x0.0000000000001p-1022 0x0.0000000000001p-1022))
                                    (v128.const f64x2 0x1.23456789abcdfp+80 0x1.23456789abcdfp+80))
(assert_return (invoke "f64x2.pmax" (v128.const f64x2 0x0123456789ABCDEFabcdef. 0x0123456789ABCDEFabcdef.)
                                    (v128.const f64x2 0x0.0000000000001p-1022 0x0.0000000000001p-1022))
                                    (v128.const f64x2 0x1.23456789abcdfp+80 0x1.23456789abcdfp+80))
(assert_return (invoke "f64x2.pmax" (v128.const f64x2 0x0123456789ABCDEFabcdef. 0x0123456789ABCDEFabcdef.)
                                    (v128.const f64x2 inf inf))
                                    (v128.const f64x2 inf inf))
(assert_return (invoke "f64x2.pmax" (v128.const f64x2 0x0123456789ABCDEFabcdef. 0x0123456789ABCDEFabcdef.)
                                    (v128.const f64x2 -inf -inf))
                                    (v128.const f64x2 0x1.23456789abcdfp+80 0x1.23456789abcdfp+80))
(assert_return (invoke "f64x2.pmax" (v128.const f64x2 0x0123456789ABCDEFabcdef. 0x0123456789ABCDEFabcdef.)
                                    (v128.const f64x2 0123456789 0123456789))
                                    (v128.const f64x2 0x1.23456789abcdfp+80 0x1.23456789abcdfp+80))
(assert_return (invoke "f64x2.pmax" (v128.const f64x2 0x0123456789ABCDEFabcdef. 0x0123456789ABCDEFabcdef.)
                                    (v128.const f64x2 0123456789e019 0123456789e019))
                                    (v128.const f64x2 0x1.fe9af5b5e16fap+89 0x1.fe9af5b5e16fap+89))
(assert_return (invoke "f64x2.pmax" (v128.const f64x2 0x0123456789ABCDEFabcdef. 0x0123456789ABCDEFabcdef.)
                                    (v128.const f64x2 0123456789e+019 0123456789e+019))
                                    (v128.const f64x2 0x1.fe9af5b5e16fap+89 0x1.fe9af5b5e16fap+89))
(assert_return (invoke "f64x2.pmax" (v128.const f64x2 0x0123456789ABCDEFabcdef. 0x0123456789ABCDEFabcdef.)
                                    (v128.const f64x2 0123456789e-019 0123456789e-019))
                                    (v128.const f64x2 0x1.23456789abcdfp+80 0x1.23456789abcdfp+80))
(assert_return (invoke "f64x2.pmax" (v128.const f64x2 0x0123456789ABCDEFabcdef. 0x0123456789ABCDEFabcdef.)
                                    (v128.const f64x2 0123456789. 0123456789.))
                                    (v128.const f64x2 0x1.23456789abcdfp+80 0x1.23456789abcdfp+80))
(assert_return (invoke "f64x2.pmax" (v128.const f64x2 0x0123456789ABCDEFabcdef. 0x0123456789ABCDEFabcdef.)
                                    (v128.const f64x2 0123456789.e019 0123456789.e019))
                                    (v128.const f64x2 0x1.fe9af5b5e16fap+89 0x1.fe9af5b5e16fap+89))
(assert_return (invoke "f64x2.pmax" (v128.const f64x2 0x0123456789ABCDEFabcdef. 0x0123456789ABCDEFabcdef.)
                                    (v128.const f64x2 0123456789.e+019 0123456789.e+019))
                                    (v128.const f64x2 0x1.fe9af5b5e16fap+89 0x1.fe9af5b5e16fap+89))
(assert_return (invoke "f64x2.pmax" (v128.const f64x2 0x0123456789ABCDEFabcdef. 0x0123456789ABCDEFabcdef.)
                                    (v128.const f64x2 0123456789.e-019 0123456789.e-019))
                                    (v128.const f64x2 0x1.23456789abcdfp+80 0x1.23456789abcdfp+80))
(assert_return (invoke "f64x2.pmax" (v128.const f64x2 0x0123456789ABCDEFabcdef. 0x0123456789ABCDEFabcdef.)
                                    (v128.const f64x2 0123456789.0123456789 0123456789.0123456789))
                                    (v128.const f64x2 0x1.23456789abcdfp+80 0x1.23456789abcdfp+80))
(assert_return (invoke "f64x2.pmax" (v128.const f64x2 0x0123456789ABCDEFabcdef. 0x0123456789ABCDEFabcdef.)
                                    (v128.const f64x2 0123456789.0123456789e019 0123456789.0123456789e019))
                                    (v128.const f64x2 0x1.fe9af5b6bcbd5p+89 0x1.fe9af5b6bcbd5p+89))
(assert_return (invoke "f64x2.pmax" (v128.const f64x2 0x0123456789ABCDEFabcdef. 0x0123456789ABCDEFabcdef.)
                                    (v128.const f64x2 0123456789.0123456789e+019 0123456789.0123456789e+019))
                                    (v128.const f64x2 0x1.fe9af5b6bcbd5p+89 0x1.fe9af5b6bcbd5p+89))
(assert_return (invoke "f64x2.pmax" (v128.const f64x2 0x0123456789ABCDEFabcdef. 0x0123456789ABCDEFabcdef.)
                                    (v128.const f64x2 0123456789.0123456789e-019 0123456789.0123456789e-019))
                                    (v128.const f64x2 0x1.23456789abcdfp+80 0x1.23456789abcdfp+80))
(assert_return (invoke "f64x2.pmax" (v128.const f64x2 0x0123456789ABCDEFabcdef. 0x0123456789ABCDEFabcdef.)
                                    (v128.const f64x2 0x0123456789ABCDEFabcdef 0x0123456789ABCDEFabcdef))
                                    (v128.const f64x2 0x1.23456789abcdfp+80 0x1.23456789abcdfp+80))
(assert_return (invoke "f64x2.pmax" (v128.const f64x2 0x0123456789ABCDEFabcdef. 0x0123456789ABCDEFabcdef.)
                                    (v128.const f64x2 0x0123456789ABCDEFabcdefp019 0x0123456789ABCDEFabcdefp019))
                                    (v128.const f64x2 0x1.23456789abcdfp+99 0x1.23456789abcdfp+99))
(assert_return (invoke "f64x2.pmax" (v128.const f64x2 0x0123456789ABCDEFabcdef. 0x0123456789ABCDEFabcdef.)
                                    (v128.const f64x2 0x0123456789ABCDEFabcdefp+019 0x0123456789ABCDEFabcdefp+019))
                                    (v128.const f64x2 0x1.23456789abcdfp+99 0x1.23456789abcdfp+99))
(assert_return (invoke "f64x2.pmax" (v128.const f64x2 0x0123456789ABCDEFabcdef. 0x0123456789ABCDEFabcdef.)
                                    (v128.const f64x2 0x0123456789ABCDEFabcdefp-019 0x0123456789ABCDEFabcdefp-019))
                                    (v128.const f64x2 0x1.23456789abcdfp+80 0x1.23456789abcdfp+80))
(assert_return (invoke "f64x2.pmax" (v128.const f64x2 0x0123456789ABCDEFabcdef. 0x0123456789ABCDEFabcdef.)
                                    (v128.const f64x2 0x0123456789ABCDEFabcdef. 0x0123456789ABCDEFabcdef.))
                                    (v128.const f64x2 0x1.23456789abcdfp+80 0x1.23456789abcdfp+80))
(assert_return (invoke "f64x2.pmax" (v128.const f64x2 0x0123456789ABCDEFabcdef. 0x0123456789ABCDEFabcdef.)
                                    (v128.const f64x2 0x0123456789ABCDEFabcdef.p019 0x0123456789ABCDEFabcdef.p019))
                                    (v128.const f64x2 0x1.23456789abcdfp+99 0x1.23456789abcdfp+99))
(assert_return (invoke "f64x2.pmax" (v128.const f64x2 0x0123456789ABCDEFabcdef. 0x0123456789ABCDEFabcdef.)
                                    (v128.const f64x2 0x0123456789ABCDEFabcdef.p+019 0x0123456789ABCDEFabcdef.p+019))
                                    (v128.const f64x2 0x1.23456789abcdfp+99 0x1.23456789abcdfp+99))
(assert_return (invoke "f64x2.pmax" (v128.const f64x2 0x0123456789ABCDEFabcdef. 0x0123456789ABCDEFabcdef.)
                                    (v128.const f64x2 0x0123456789ABCDEFabcdef.p-019 0x0123456789ABCDEFabcdef.p-019))
                                    (v128.const f64x2 0x1.23456789abcdfp+80 0x1.23456789abcdfp+80))
(assert_return (invoke "f64x2.pmax" (v128.const f64x2 0x0123456789ABCDEFabcdef. 0x0123456789ABCDEFabcdef.)
                                    (v128.const f64x2 0x0123456789ABCDEFabcdef.0123456789ABCDEFabcdef 0x0123456789ABCDEFabcdef.0123456789ABCDEFabcdef))
                                    (v128.const f64x2 0x1.23456789abcdfp+80 0x1.23456789abcdfp+80))
(assert_return (invoke "f64x2.pmax" (v128.const f64x2 0x0123456789ABCDEFabcdef. 0x0123456789ABCDEFabcdef.)
                                    (v128.const f64x2 0x0123456789ABCDEFabcdef.0123456789ABCDEFabcdefp019 0x0123456789ABCDEFabcdef.0123456789ABCDEFabcdefp019))
                                    (v128.const f64x2 0x1.23456789abcdfp+99 0x1.23456789abcdfp+99))
(assert_return (invoke "f64x2.pmax" (v128.const f64x2 0x0123456789ABCDEFabcdef. 0x0123456789ABCDEFabcdef.)
                                    (v128.const f64x2 0x0123456789ABCDEFabcdef.0123456789ABCDEFabcdefp+019 0x0123456789ABCDEFabcdef.0123456789ABCDEFabcdefp+019))
                                    (v128.const f64x2 0x1.23456789abcdfp+99 0x1.23456789abcdfp+99))
(assert_return (invoke "f64x2.pmax" (v128.const f64x2 0x0123456789ABCDEFabcdef. 0x0123456789ABCDEFabcdef.)
                                    (v128.const f64x2 0x0123456789ABCDEFabcdef.0123456789ABCDEFabcdefp-019 0x0123456789ABCDEFabcdef.0123456789ABCDEFabcdefp-019))
                                    (v128.const f64x2 0x1.23456789abcdfp+80 0x1.23456789abcdfp+80))
(assert_return (invoke "f64x2.pmax" (v128.const f64x2 0x0123456789ABCDEFabcdef.p019 0x0123456789ABCDEFabcdef.p019)
                                    (v128.const f64x2 0x0p+0 0x0p+0))
                                    (v128.const f64x2 0x1.23456789abcdfp+99 0x1.23456789abcdfp+99))
(assert_return (invoke "f64x2.pmax" (v128.const f64x2 0x0123456789ABCDEFabcdef.p019 0x0123456789ABCDEFabcdef.p019)
                                    (v128.const f64x2 -0x0p+0 -0x0p+0))
                                    (v128.const f64x2 0x1.23456789abcdfp+99 0x1.23456789abcdfp+99))
(assert_return (invoke "f64x2.pmax" (v128.const f64x2 0x0123456789ABCDEFabcdef.p019 0x0123456789ABCDEFabcdef.p019)
                                    (v128.const f64x2 0x1p-1022 0x1p-1022))
                                    (v128.const f64x2 0x1.23456789abcdfp+99 0x1.23456789abcdfp+99))
(assert_return (invoke "f64x2.pmax" (v128.const f64x2 0x0123456789ABCDEFabcdef.p019 0x0123456789ABCDEFabcdef.p019)
                                    (v128.const f64x2 -0x1p-1022 -0x1p-1022))
                                    (v128.const f64x2 0x1.23456789abcdfp+99 0x1.23456789abcdfp+99))
(assert_return (invoke "f64x2.pmax" (v128.const f64x2 0x0123456789ABCDEFabcdef.p019 0x0123456789ABCDEFabcdef.p019)
                                    (v128.const f64x2 0x1p-1 0x1p-1))
                                    (v128.const f64x2 0x1.23456789abcdfp+99 0x1.23456789abcdfp+99))
(assert_return (invoke "f64x2.pmax" (v128.const f64x2 0x0123456789ABCDEFabcdef.p019 0x0123456789ABCDEFabcdef.p019)
                                    (v128.const f64x2 -0x1p-1 -0x1p-1))
                                    (v128.const f64x2 0x1.23456789abcdfp+99 0x1.23456789abcdfp+99))
(assert_return (invoke "f64x2.pmax" (v128.const f64x2 0x0123456789ABCDEFabcdef.p019 0x0123456789ABCDEFabcdef.p019)
                                    (v128.const f64x2 0x1p+0 0x1p+0))
                                    (v128.const f64x2 0x1.23456789abcdfp+99 0x1.23456789abcdfp+99))
(assert_return (invoke "f64x2.pmax" (v128.const f64x2 0x0123456789ABCDEFabcdef.p019 0x0123456789ABCDEFabcdef.p019)
                                    (v128.const f64x2 -0x1p+0 -0x1p+0))
                                    (v128.const f64x2 0x1.23456789abcdfp+99 0x1.23456789abcdfp+99))
(assert_return (invoke "f64x2.pmax" (v128.const f64x2 0x0123456789ABCDEFabcdef.p019 0x0123456789ABCDEFabcdef.p019)
                                    (v128.const f64x2 0x1.921fb54442d18p+2 0x1.921fb54442d18p+2))
                                    (v128.const f64x2 0x1.23456789abcdfp+99 0x1.23456789abcdfp+99))
(assert_return (invoke "f64x2.pmax" (v128.const f64x2 0x0123456789ABCDEFabcdef.p019 0x0123456789ABCDEFabcdef.p019)
                                    (v128.const f64x2 -0x1.921fb54442d18p+2 -0x1.921fb54442d18p+2))
                                    (v128.const f64x2 0x1.23456789abcdfp+99 0x1.23456789abcdfp+99))
(assert_return (invoke "f64x2.pmax" (v128.const f64x2 0x0123456789ABCDEFabcdef.p019 0x0123456789ABCDEFabcdef.p019)
                                    (v128.const f64x2 0x1.fffffffffffffp+1023 0x1.fffffffffffffp+1023))
                                    (v128.const f64x2 0x1.fffffffffffffp+1023 0x1.fffffffffffffp+1023))
(assert_return (invoke "f64x2.pmax" (v128.const f64x2 0x0123456789ABCDEFabcdef.p019 0x0123456789ABCDEFabcdef.p019)
                                    (v128.const f64x2 -0x1.fffffffffffffp+1023 -0x1.fffffffffffffp+1023))
                                    (v128.const f64x2 0x1.23456789abcdfp+99 0x1.23456789abcdfp+99))
(assert_return (invoke "f64x2.pmax" (v128.const f64x2 0x0123456789ABCDEFabcdef.p019 0x0123456789ABCDEFabcdef.p019)
                                    (v128.const f64x2 0x0.0000000000001p-1022 0x0.0000000000001p-1022))
                                    (v128.const f64x2 0x1.23456789abcdfp+99 0x1.23456789abcdfp+99))
(assert_return (invoke "f64x2.pmax" (v128.const f64x2 0x0123456789ABCDEFabcdef.p019 0x0123456789ABCDEFabcdef.p019)
                                    (v128.const f64x2 0x0.0000000000001p-1022 0x0.0000000000001p-1022))
                                    (v128.const f64x2 0x1.23456789abcdfp+99 0x1.23456789abcdfp+99))
(assert_return (invoke "f64x2.pmax" (v128.const f64x2 0x0123456789ABCDEFabcdef.p019 0x0123456789ABCDEFabcdef.p019)
                                    (v128.const f64x2 inf inf))
                                    (v128.const f64x2 inf inf))
(assert_return (invoke "f64x2.pmax" (v128.const f64x2 0x0123456789ABCDEFabcdef.p019 0x0123456789ABCDEFabcdef.p019)
                                    (v128.const f64x2 -inf -inf))
                                    (v128.const f64x2 0x1.23456789abcdfp+99 0x1.23456789abcdfp+99))
(assert_return (invoke "f64x2.pmax" (v128.const f64x2 0x0123456789ABCDEFabcdef.p019 0x0123456789ABCDEFabcdef.p019)
                                    (v128.const f64x2 0123456789 0123456789))
                                    (v128.const f64x2 0x1.23456789abcdfp+99 0x1.23456789abcdfp+99))
(assert_return (invoke "f64x2.pmax" (v128.const f64x2 0x0123456789ABCDEFabcdef.p019 0x0123456789ABCDEFabcdef.p019)
                                    (v128.const f64x2 0123456789e019 0123456789e019))
                                    (v128.const f64x2 0x1.23456789abcdfp+99 0x1.23456789abcdfp+99))
(assert_return (invoke "f64x2.pmax" (v128.const f64x2 0x0123456789ABCDEFabcdef.p019 0x0123456789ABCDEFabcdef.p019)
                                    (v128.const f64x2 0123456789e+019 0123456789e+019))
                                    (v128.const f64x2 0x1.23456789abcdfp+99 0x1.23456789abcdfp+99))
(assert_return (invoke "f64x2.pmax" (v128.const f64x2 0x0123456789ABCDEFabcdef.p019 0x0123456789ABCDEFabcdef.p019)
                                    (v128.const f64x2 0123456789e-019 0123456789e-019))
                                    (v128.const f64x2 0x1.23456789abcdfp+99 0x1.23456789abcdfp+99))
(assert_return (invoke "f64x2.pmax" (v128.const f64x2 0x0123456789ABCDEFabcdef.p019 0x0123456789ABCDEFabcdef.p019)
                                    (v128.const f64x2 0123456789. 0123456789.))
                                    (v128.const f64x2 0x1.23456789abcdfp+99 0x1.23456789abcdfp+99))
(assert_return (invoke "f64x2.pmax" (v128.const f64x2 0x0123456789ABCDEFabcdef.p019 0x0123456789ABCDEFabcdef.p019)
                                    (v128.const f64x2 0123456789.e019 0123456789.e019))
                                    (v128.const f64x2 0x1.23456789abcdfp+99 0x1.23456789abcdfp+99))
(assert_return (invoke "f64x2.pmax" (v128.const f64x2 0x0123456789ABCDEFabcdef.p019 0x0123456789ABCDEFabcdef.p019)
                                    (v128.const f64x2 0123456789.e+019 0123456789.e+019))
                                    (v128.const f64x2 0x1.23456789abcdfp+99 0x1.23456789abcdfp+99))
(assert_return (invoke "f64x2.pmax" (v128.const f64x2 0x0123456789ABCDEFabcdef.p019 0x0123456789ABCDEFabcdef.p019)
                                    (v128.const f64x2 0123456789.e-019 0123456789.e-019))
                                    (v128.const f64x2 0x1.23456789abcdfp+99 0x1.23456789abcdfp+99))
(assert_return (invoke "f64x2.pmax" (v128.const f64x2 0x0123456789ABCDEFabcdef.p019 0x0123456789ABCDEFabcdef.p019)
                                    (v128.const f64x2 0123456789.0123456789 0123456789.0123456789))
                                    (v128.const f64x2 0x1.23456789abcdfp+99 0x1.23456789abcdfp+99))
(assert_return (invoke "f64x2.pmax" (v128.const f64x2 0x0123456789ABCDEFabcdef.p019 0x0123456789ABCDEFabcdef.p019)
                                    (v128.const f64x2 0123456789.0123456789e019 0123456789.0123456789e019))
                                    (v128.const f64x2 0x1.23456789abcdfp+99 0x1.23456789abcdfp+99))
(assert_return (invoke "f64x2.pmax" (v128.const f64x2 0x0123456789ABCDEFabcdef.p019 0x0123456789ABCDEFabcdef.p019)
                                    (v128.const f64x2 0123456789.0123456789e+019 0123456789.0123456789e+019))
                                    (v128.const f64x2 0x1.23456789abcdfp+99 0x1.23456789abcdfp+99))
(assert_return (invoke "f64x2.pmax" (v128.const f64x2 0x0123456789ABCDEFabcdef.p019 0x0123456789ABCDEFabcdef.p019)
                                    (v128.const f64x2 0123456789.0123456789e-019 0123456789.0123456789e-019))
                                    (v128.const f64x2 0x1.23456789abcdfp+99 0x1.23456789abcdfp+99))
(assert_return (invoke "f64x2.pmax" (v128.const f64x2 0x0123456789ABCDEFabcdef.p019 0x0123456789ABCDEFabcdef.p019)
                                    (v128.const f64x2 0x0123456789ABCDEFabcdef 0x0123456789ABCDEFabcdef))
                                    (v128.const f64x2 0x1.23456789abcdfp+99 0x1.23456789abcdfp+99))
(assert_return (invoke "f64x2.pmax" (v128.const f64x2 0x0123456789ABCDEFabcdef.p019 0x0123456789ABCDEFabcdef.p019)
                                    (v128.const f64x2 0x0123456789ABCDEFabcdefp019 0x0123456789ABCDEFabcdefp019))
                                    (v128.const f64x2 0x1.23456789abcdfp+99 0x1.23456789abcdfp+99))
(assert_return (invoke "f64x2.pmax" (v128.const f64x2 0x0123456789ABCDEFabcdef.p019 0x0123456789ABCDEFabcdef.p019)
                                    (v128.const f64x2 0x0123456789ABCDEFabcdefp+019 0x0123456789ABCDEFabcdefp+019))
                                    (v128.const f64x2 0x1.23456789abcdfp+99 0x1.23456789abcdfp+99))
(assert_return (invoke "f64x2.pmax" (v128.const f64x2 0x0123456789ABCDEFabcdef.p019 0x0123456789ABCDEFabcdef.p019)
                                    (v128.const f64x2 0x0123456789ABCDEFabcdefp-019 0x0123456789ABCDEFabcdefp-019))
                                    (v128.const f64x2 0x1.23456789abcdfp+99 0x1.23456789abcdfp+99))
(assert_return (invoke "f64x2.pmax" (v128.const f64x2 0x0123456789ABCDEFabcdef.p019 0x0123456789ABCDEFabcdef.p019)
                                    (v128.const f64x2 0x0123456789ABCDEFabcdef. 0x0123456789ABCDEFabcdef.))
                                    (v128.const f64x2 0x1.23456789abcdfp+99 0x1.23456789abcdfp+99))
(assert_return (invoke "f64x2.pmax" (v128.const f64x2 0x0123456789ABCDEFabcdef.p019 0x0123456789ABCDEFabcdef.p019)
                                    (v128.const f64x2 0x0123456789ABCDEFabcdef.p019 0x0123456789ABCDEFabcdef.p019))
                                    (v128.const f64x2 0x1.23456789abcdfp+99 0x1.23456789abcdfp+99))
(assert_return (invoke "f64x2.pmax" (v128.const f64x2 0x0123456789ABCDEFabcdef.p019 0x0123456789ABCDEFabcdef.p019)
                                    (v128.const f64x2 0x0123456789ABCDEFabcdef.p+019 0x0123456789ABCDEFabcdef.p+019))
                                    (v128.const f64x2 0x1.23456789abcdfp+99 0x1.23456789abcdfp+99))
(assert_return (invoke "f64x2.pmax" (v128.const f64x2 0x0123456789ABCDEFabcdef.p019 0x0123456789ABCDEFabcdef.p019)
                                    (v128.const f64x2 0x0123456789ABCDEFabcdef.p-019 0x0123456789ABCDEFabcdef.p-019))
                                    (v128.const f64x2 0x1.23456789abcdfp+99 0x1.23456789abcdfp+99))
(assert_return (invoke "f64x2.pmax" (v128.const f64x2 0x0123456789ABCDEFabcdef.p019 0x0123456789ABCDEFabcdef.p019)
                                    (v128.const f64x2 0x0123456789ABCDEFabcdef.0123456789ABCDEFabcdef 0x0123456789ABCDEFabcdef.0123456789ABCDEFabcdef))
                                    (v128.const f64x2 0x1.23456789abcdfp+99 0x1.23456789abcdfp+99))
(assert_return (invoke "f64x2.pmax" (v128.const f64x2 0x0123456789ABCDEFabcdef.p019 0x0123456789ABCDEFabcdef.p019)
                                    (v128.const f64x2 0x0123456789ABCDEFabcdef.0123456789ABCDEFabcdefp019 0x0123456789ABCDEFabcdef.0123456789ABCDEFabcdefp019))
                                    (v128.const f64x2 0x1.23456789abcdfp+99 0x1.23456789abcdfp+99))
(assert_return (invoke "f64x2.pmax" (v128.const f64x2 0x0123456789ABCDEFabcdef.p019 0x0123456789ABCDEFabcdef.p019)
                                    (v128.const f64x2 0x0123456789ABCDEFabcdef.0123456789ABCDEFabcdefp+019 0x0123456789ABCDEFabcdef.0123456789ABCDEFabcdefp+019))
                                    (v128.const f64x2 0x1.23456789abcdfp+99 0x1.23456789abcdfp+99))
(assert_return (invoke "f64x2.pmax" (v128.const f64x2 0x0123456789ABCDEFabcdef.p019 0x0123456789ABCDEFabcdef.p019)
                                    (v128.const f64x2 0x0123456789ABCDEFabcdef.0123456789ABCDEFabcdefp-019 0x0123456789ABCDEFabcdef.0123456789ABCDEFabcdefp-019))
                                    (v128.const f64x2 0x1.23456789abcdfp+99 0x1.23456789abcdfp+99))
(assert_return (invoke "f64x2.pmax" (v128.const f64x2 0x0123456789ABCDEFabcdef.p+019 0x0123456789ABCDEFabcdef.p+019)
                                    (v128.const f64x2 0x0p+0 0x0p+0))
                                    (v128.const f64x2 0x1.23456789abcdfp+99 0x1.23456789abcdfp+99))
(assert_return (invoke "f64x2.pmax" (v128.const f64x2 0x0123456789ABCDEFabcdef.p+019 0x0123456789ABCDEFabcdef.p+019)
                                    (v128.const f64x2 -0x0p+0 -0x0p+0))
                                    (v128.const f64x2 0x1.23456789abcdfp+99 0x1.23456789abcdfp+99))
(assert_return (invoke "f64x2.pmax" (v128.const f64x2 0x0123456789ABCDEFabcdef.p+019 0x0123456789ABCDEFabcdef.p+019)
                                    (v128.const f64x2 0x1p-1022 0x1p-1022))
                                    (v128.const f64x2 0x1.23456789abcdfp+99 0x1.23456789abcdfp+99))
(assert_return (invoke "f64x2.pmax" (v128.const f64x2 0x0123456789ABCDEFabcdef.p+019 0x0123456789ABCDEFabcdef.p+019)
                                    (v128.const f64x2 -0x1p-1022 -0x1p-1022))
                                    (v128.const f64x2 0x1.23456789abcdfp+99 0x1.23456789abcdfp+99))
(assert_return (invoke "f64x2.pmax" (v128.const f64x2 0x0123456789ABCDEFabcdef.p+019 0x0123456789ABCDEFabcdef.p+019)
                                    (v128.const f64x2 0x1p-1 0x1p-1))
                                    (v128.const f64x2 0x1.23456789abcdfp+99 0x1.23456789abcdfp+99))
(assert_return (invoke "f64x2.pmax" (v128.const f64x2 0x0123456789ABCDEFabcdef.p+019 0x0123456789ABCDEFabcdef.p+019)
                                    (v128.const f64x2 -0x1p-1 -0x1p-1))
                                    (v128.const f64x2 0x1.23456789abcdfp+99 0x1.23456789abcdfp+99))
(assert_return (invoke "f64x2.pmax" (v128.const f64x2 0x0123456789ABCDEFabcdef.p+019 0x0123456789ABCDEFabcdef.p+019)
                                    (v128.const f64x2 0x1p+0 0x1p+0))
                                    (v128.const f64x2 0x1.23456789abcdfp+99 0x1.23456789abcdfp+99))
(assert_return (invoke "f64x2.pmax" (v128.const f64x2 0x0123456789ABCDEFabcdef.p+019 0x0123456789ABCDEFabcdef.p+019)
                                    (v128.const f64x2 -0x1p+0 -0x1p+0))
                                    (v128.const f64x2 0x1.23456789abcdfp+99 0x1.23456789abcdfp+99))
(assert_return (invoke "f64x2.pmax" (v128.const f64x2 0x0123456789ABCDEFabcdef.p+019 0x0123456789ABCDEFabcdef.p+019)
                                    (v128.const f64x2 0x1.921fb54442d18p+2 0x1.921fb54442d18p+2))
                                    (v128.const f64x2 0x1.23456789abcdfp+99 0x1.23456789abcdfp+99))
(assert_return (invoke "f64x2.pmax" (v128.const f64x2 0x0123456789ABCDEFabcdef.p+019 0x0123456789ABCDEFabcdef.p+019)
                                    (v128.const f64x2 -0x1.921fb54442d18p+2 -0x1.921fb54442d18p+2))
                                    (v128.const f64x2 0x1.23456789abcdfp+99 0x1.23456789abcdfp+99))
(assert_return (invoke "f64x2.pmax" (v128.const f64x2 0x0123456789ABCDEFabcdef.p+019 0x0123456789ABCDEFabcdef.p+019)
                                    (v128.const f64x2 0x1.fffffffffffffp+1023 0x1.fffffffffffffp+1023))
                                    (v128.const f64x2 0x1.fffffffffffffp+1023 0x1.fffffffffffffp+1023))
(assert_return (invoke "f64x2.pmax" (v128.const f64x2 0x0123456789ABCDEFabcdef.p+019 0x0123456789ABCDEFabcdef.p+019)
                                    (v128.const f64x2 -0x1.fffffffffffffp+1023 -0x1.fffffffffffffp+1023))
                                    (v128.const f64x2 0x1.23456789abcdfp+99 0x1.23456789abcdfp+99))
(assert_return (invoke "f64x2.pmax" (v128.const f64x2 0x0123456789ABCDEFabcdef.p+019 0x0123456789ABCDEFabcdef.p+019)
                                    (v128.const f64x2 0x0.0000000000001p-1022 0x0.0000000000001p-1022))
                                    (v128.const f64x2 0x1.23456789abcdfp+99 0x1.23456789abcdfp+99))
(assert_return (invoke "f64x2.pmax" (v128.const f64x2 0x0123456789ABCDEFabcdef.p+019 0x0123456789ABCDEFabcdef.p+019)
                                    (v128.const f64x2 0x0.0000000000001p-1022 0x0.0000000000001p-1022))
                                    (v128.const f64x2 0x1.23456789abcdfp+99 0x1.23456789abcdfp+99))
(assert_return (invoke "f64x2.pmax" (v128.const f64x2 0x0123456789ABCDEFabcdef.p+019 0x0123456789ABCDEFabcdef.p+019)
                                    (v128.const f64x2 inf inf))
                                    (v128.const f64x2 inf inf))
(assert_return (invoke "f64x2.pmax" (v128.const f64x2 0x0123456789ABCDEFabcdef.p+019 0x0123456789ABCDEFabcdef.p+019)
                                    (v128.const f64x2 -inf -inf))
                                    (v128.const f64x2 0x1.23456789abcdfp+99 0x1.23456789abcdfp+99))
(assert_return (invoke "f64x2.pmax" (v128.const f64x2 0x0123456789ABCDEFabcdef.p+019 0x0123456789ABCDEFabcdef.p+019)
                                    (v128.const f64x2 0123456789 0123456789))
                                    (v128.const f64x2 0x1.23456789abcdfp+99 0x1.23456789abcdfp+99))
(assert_return (invoke "f64x2.pmax" (v128.const f64x2 0x0123456789ABCDEFabcdef.p+019 0x0123456789ABCDEFabcdef.p+019)
                                    (v128.const f64x2 0123456789e019 0123456789e019))
                                    (v128.const f64x2 0x1.23456789abcdfp+99 0x1.23456789abcdfp+99))
(assert_return (invoke "f64x2.pmax" (v128.const f64x2 0x0123456789ABCDEFabcdef.p+019 0x0123456789ABCDEFabcdef.p+019)
                                    (v128.const f64x2 0123456789e+019 0123456789e+019))
                                    (v128.const f64x2 0x1.23456789abcdfp+99 0x1.23456789abcdfp+99))
(assert_return (invoke "f64x2.pmax" (v128.const f64x2 0x0123456789ABCDEFabcdef.p+019 0x0123456789ABCDEFabcdef.p+019)
                                    (v128.const f64x2 0123456789e-019 0123456789e-019))
                                    (v128.const f64x2 0x1.23456789abcdfp+99 0x1.23456789abcdfp+99))
(assert_return (invoke "f64x2.pmax" (v128.const f64x2 0x0123456789ABCDEFabcdef.p+019 0x0123456789ABCDEFabcdef.p+019)
                                    (v128.const f64x2 0123456789. 0123456789.))
                                    (v128.const f64x2 0x1.23456789abcdfp+99 0x1.23456789abcdfp+99))
(assert_return (invoke "f64x2.pmax" (v128.const f64x2 0x0123456789ABCDEFabcdef.p+019 0x0123456789ABCDEFabcdef.p+019)
                                    (v128.const f64x2 0123456789.e019 0123456789.e019))
                                    (v128.const f64x2 0x1.23456789abcdfp+99 0x1.23456789abcdfp+99))
(assert_return (invoke "f64x2.pmax" (v128.const f64x2 0x0123456789ABCDEFabcdef.p+019 0x0123456789ABCDEFabcdef.p+019)
                                    (v128.const f64x2 0123456789.e+019 0123456789.e+019))
                                    (v128.const f64x2 0x1.23456789abcdfp+99 0x1.23456789abcdfp+99))
(assert_return (invoke "f64x2.pmax" (v128.const f64x2 0x0123456789ABCDEFabcdef.p+019 0x0123456789ABCDEFabcdef.p+019)
                                    (v128.const f64x2 0123456789.e-019 0123456789.e-019))
                                    (v128.const f64x2 0x1.23456789abcdfp+99 0x1.23456789abcdfp+99))
(assert_return (invoke "f64x2.pmax" (v128.const f64x2 0x0123456789ABCDEFabcdef.p+019 0x0123456789ABCDEFabcdef.p+019)
                                    (v128.const f64x2 0123456789.0123456789 0123456789.0123456789))
                                    (v128.const f64x2 0x1.23456789abcdfp+99 0x1.23456789abcdfp+99))
(assert_return (invoke "f64x2.pmax" (v128.const f64x2 0x0123456789ABCDEFabcdef.p+019 0x0123456789ABCDEFabcdef.p+019)
                                    (v128.const f64x2 0123456789.0123456789e019 0123456789.0123456789e019))
                                    (v128.const f64x2 0x1.23456789abcdfp+99 0x1.23456789abcdfp+99))
(assert_return (invoke "f64x2.pmax" (v128.const f64x2 0x0123456789ABCDEFabcdef.p+019 0x0123456789ABCDEFabcdef.p+019)
                                    (v128.const f64x2 0123456789.0123456789e+019 0123456789.0123456789e+019))
                                    (v128.const f64x2 0x1.23456789abcdfp+99 0x1.23456789abcdfp+99))
(assert_return (invoke "f64x2.pmax" (v128.const f64x2 0x0123456789ABCDEFabcdef.p+019 0x0123456789ABCDEFabcdef.p+019)
                                    (v128.const f64x2 0123456789.0123456789e-019 0123456789.0123456789e-019))
                                    (v128.const f64x2 0x1.23456789abcdfp+99 0x1.23456789abcdfp+99))
(assert_return (invoke "f64x2.pmax" (v128.const f64x2 0x0123456789ABCDEFabcdef.p+019 0x0123456789ABCDEFabcdef.p+019)
                                    (v128.const f64x2 0x0123456789ABCDEFabcdef 0x0123456789ABCDEFabcdef))
                                    (v128.const f64x2 0x1.23456789abcdfp+99 0x1.23456789abcdfp+99))
(assert_return (invoke "f64x2.pmax" (v128.const f64x2 0x0123456789ABCDEFabcdef.p+019 0x0123456789ABCDEFabcdef.p+019)
                                    (v128.const f64x2 0x0123456789ABCDEFabcdefp019 0x0123456789ABCDEFabcdefp019))
                                    (v128.const f64x2 0x1.23456789abcdfp+99 0x1.23456789abcdfp+99))
(assert_return (invoke "f64x2.pmax" (v128.const f64x2 0x0123456789ABCDEFabcdef.p+019 0x0123456789ABCDEFabcdef.p+019)
                                    (v128.const f64x2 0x0123456789ABCDEFabcdefp+019 0x0123456789ABCDEFabcdefp+019))
                                    (v128.const f64x2 0x1.23456789abcdfp+99 0x1.23456789abcdfp+99))
(assert_return (invoke "f64x2.pmax" (v128.const f64x2 0x0123456789ABCDEFabcdef.p+019 0x0123456789ABCDEFabcdef.p+019)
                                    (v128.const f64x2 0x0123456789ABCDEFabcdefp-019 0x0123456789ABCDEFabcdefp-019))
                                    (v128.const f64x2 0x1.23456789abcdfp+99 0x1.23456789abcdfp+99))
(assert_return (invoke "f64x2.pmax" (v128.const f64x2 0x0123456789ABCDEFabcdef.p+019 0x0123456789ABCDEFabcdef.p+019)
                                    (v128.const f64x2 0x0123456789ABCDEFabcdef. 0x0123456789ABCDEFabcdef.))
                                    (v128.const f64x2 0x1.23456789abcdfp+99 0x1.23456789abcdfp+99))
(assert_return (invoke "f64x2.pmax" (v128.const f64x2 0x0123456789ABCDEFabcdef.p+019 0x0123456789ABCDEFabcdef.p+019)
                                    (v128.const f64x2 0x0123456789ABCDEFabcdef.p019 0x0123456789ABCDEFabcdef.p019))
                                    (v128.const f64x2 0x1.23456789abcdfp+99 0x1.23456789abcdfp+99))
(assert_return (invoke "f64x2.pmax" (v128.const f64x2 0x0123456789ABCDEFabcdef.p+019 0x0123456789ABCDEFabcdef.p+019)
                                    (v128.const f64x2 0x0123456789ABCDEFabcdef.p+019 0x0123456789ABCDEFabcdef.p+019))
                                    (v128.const f64x2 0x1.23456789abcdfp+99 0x1.23456789abcdfp+99))
(assert_return (invoke "f64x2.pmax" (v128.const f64x2 0x0123456789ABCDEFabcdef.p+019 0x0123456789ABCDEFabcdef.p+019)
                                    (v128.const f64x2 0x0123456789ABCDEFabcdef.p-019 0x0123456789ABCDEFabcdef.p-019))
                                    (v128.const f64x2 0x1.23456789abcdfp+99 0x1.23456789abcdfp+99))
(assert_return (invoke "f64x2.pmax" (v128.const f64x2 0x0123456789ABCDEFabcdef.p+019 0x0123456789ABCDEFabcdef.p+019)
                                    (v128.const f64x2 0x0123456789ABCDEFabcdef.0123456789ABCDEFabcdef 0x0123456789ABCDEFabcdef.0123456789ABCDEFabcdef))
                                    (v128.const f64x2 0x1.23456789abcdfp+99 0x1.23456789abcdfp+99))
(assert_return (invoke "f64x2.pmax" (v128.const f64x2 0x0123456789ABCDEFabcdef.p+019 0x0123456789ABCDEFabcdef.p+019)
                                    (v128.const f64x2 0x0123456789ABCDEFabcdef.0123456789ABCDEFabcdefp019 0x0123456789ABCDEFabcdef.0123456789ABCDEFabcdefp019))
                                    (v128.const f64x2 0x1.23456789abcdfp+99 0x1.23456789abcdfp+99))
(assert_return (invoke "f64x2.pmax" (v128.const f64x2 0x0123456789ABCDEFabcdef.p+019 0x0123456789ABCDEFabcdef.p+019)
                                    (v128.const f64x2 0x0123456789ABCDEFabcdef.0123456789ABCDEFabcdefp+019 0x0123456789ABCDEFabcdef.0123456789ABCDEFabcdefp+019))
                                    (v128.const f64x2 0x1.23456789abcdfp+99 0x1.23456789abcdfp+99))
(assert_return (invoke "f64x2.pmax" (v128.const f64x2 0x0123456789ABCDEFabcdef.p+019 0x0123456789ABCDEFabcdef.p+019)
                                    (v128.const f64x2 0x0123456789ABCDEFabcdef.0123456789ABCDEFabcdefp-019 0x0123456789ABCDEFabcdef.0123456789ABCDEFabcdefp-019))
                                    (v128.const f64x2 0x1.23456789abcdfp+99 0x1.23456789abcdfp+99))
(assert_return (invoke "f64x2.pmax" (v128.const f64x2 0x0123456789ABCDEFabcdef.p-019 0x0123456789ABCDEFabcdef.p-019)
                                    (v128.const f64x2 0x0p+0 0x0p+0))
                                    (v128.const f64x2 0x1.23456789abcdfp+61 0x1.23456789abcdfp+61))
(assert_return (invoke "f64x2.pmax" (v128.const f64x2 0x0123456789ABCDEFabcdef.p-019 0x0123456789ABCDEFabcdef.p-019)
                                    (v128.const f64x2 -0x0p+0 -0x0p+0))
                                    (v128.const f64x2 0x1.23456789abcdfp+61 0x1.23456789abcdfp+61))
(assert_return (invoke "f64x2.pmax" (v128.const f64x2 0x0123456789ABCDEFabcdef.p-019 0x0123456789ABCDEFabcdef.p-019)
                                    (v128.const f64x2 0x1p-1022 0x1p-1022))
                                    (v128.const f64x2 0x1.23456789abcdfp+61 0x1.23456789abcdfp+61))
(assert_return (invoke "f64x2.pmax" (v128.const f64x2 0x0123456789ABCDEFabcdef.p-019 0x0123456789ABCDEFabcdef.p-019)
                                    (v128.const f64x2 -0x1p-1022 -0x1p-1022))
                                    (v128.const f64x2 0x1.23456789abcdfp+61 0x1.23456789abcdfp+61))
(assert_return (invoke "f64x2.pmax" (v128.const f64x2 0x0123456789ABCDEFabcdef.p-019 0x0123456789ABCDEFabcdef.p-019)
                                    (v128.const f64x2 0x1p-1 0x1p-1))
                                    (v128.const f64x2 0x1.23456789abcdfp+61 0x1.23456789abcdfp+61))
(assert_return (invoke "f64x2.pmax" (v128.const f64x2 0x0123456789ABCDEFabcdef.p-019 0x0123456789ABCDEFabcdef.p-019)
                                    (v128.const f64x2 -0x1p-1 -0x1p-1))
                                    (v128.const f64x2 0x1.23456789abcdfp+61 0x1.23456789abcdfp+61))
(assert_return (invoke "f64x2.pmax" (v128.const f64x2 0x0123456789ABCDEFabcdef.p-019 0x0123456789ABCDEFabcdef.p-019)
                                    (v128.const f64x2 0x1p+0 0x1p+0))
                                    (v128.const f64x2 0x1.23456789abcdfp+61 0x1.23456789abcdfp+61))
(assert_return (invoke "f64x2.pmax" (v128.const f64x2 0x0123456789ABCDEFabcdef.p-019 0x0123456789ABCDEFabcdef.p-019)
                                    (v128.const f64x2 -0x1p+0 -0x1p+0))
                                    (v128.const f64x2 0x1.23456789abcdfp+61 0x1.23456789abcdfp+61))
(assert_return (invoke "f64x2.pmax" (v128.const f64x2 0x0123456789ABCDEFabcdef.p-019 0x0123456789ABCDEFabcdef.p-019)
                                    (v128.const f64x2 0x1.921fb54442d18p+2 0x1.921fb54442d18p+2))
                                    (v128.const f64x2 0x1.23456789abcdfp+61 0x1.23456789abcdfp+61))
(assert_return (invoke "f64x2.pmax" (v128.const f64x2 0x0123456789ABCDEFabcdef.p-019 0x0123456789ABCDEFabcdef.p-019)
                                    (v128.const f64x2 -0x1.921fb54442d18p+2 -0x1.921fb54442d18p+2))
                                    (v128.const f64x2 0x1.23456789abcdfp+61 0x1.23456789abcdfp+61))
(assert_return (invoke "f64x2.pmax" (v128.const f64x2 0x0123456789ABCDEFabcdef.p-019 0x0123456789ABCDEFabcdef.p-019)
                                    (v128.const f64x2 0x1.fffffffffffffp+1023 0x1.fffffffffffffp+1023))
                                    (v128.const f64x2 0x1.fffffffffffffp+1023 0x1.fffffffffffffp+1023))
(assert_return (invoke "f64x2.pmax" (v128.const f64x2 0x0123456789ABCDEFabcdef.p-019 0x0123456789ABCDEFabcdef.p-019)
                                    (v128.const f64x2 -0x1.fffffffffffffp+1023 -0x1.fffffffffffffp+1023))
                                    (v128.const f64x2 0x1.23456789abcdfp+61 0x1.23456789abcdfp+61))
(assert_return (invoke "f64x2.pmax" (v128.const f64x2 0x0123456789ABCDEFabcdef.p-019 0x0123456789ABCDEFabcdef.p-019)
                                    (v128.const f64x2 0x0.0000000000001p-1022 0x0.0000000000001p-1022))
                                    (v128.const f64x2 0x1.23456789abcdfp+61 0x1.23456789abcdfp+61))
(assert_return (invoke "f64x2.pmax" (v128.const f64x2 0x0123456789ABCDEFabcdef.p-019 0x0123456789ABCDEFabcdef.p-019)
                                    (v128.const f64x2 0x0.0000000000001p-1022 0x0.0000000000001p-1022))
                                    (v128.const f64x2 0x1.23456789abcdfp+61 0x1.23456789abcdfp+61))
(assert_return (invoke "f64x2.pmax" (v128.const f64x2 0x0123456789ABCDEFabcdef.p-019 0x0123456789ABCDEFabcdef.p-019)
                                    (v128.const f64x2 inf inf))
                                    (v128.const f64x2 inf inf))
(assert_return (invoke "f64x2.pmax" (v128.const f64x2 0x0123456789ABCDEFabcdef.p-019 0x0123456789ABCDEFabcdef.p-019)
                                    (v128.const f64x2 -inf -inf))
                                    (v128.const f64x2 0x1.23456789abcdfp+61 0x1.23456789abcdfp+61))
(assert_return (invoke "f64x2.pmax" (v128.const f64x2 0x0123456789ABCDEFabcdef.p-019 0x0123456789ABCDEFabcdef.p-019)
                                    (v128.const f64x2 0123456789 0123456789))
                                    (v128.const f64x2 0x1.23456789abcdfp+61 0x1.23456789abcdfp+61))
(assert_return (invoke "f64x2.pmax" (v128.const f64x2 0x0123456789ABCDEFabcdef.p-019 0x0123456789ABCDEFabcdef.p-019)
                                    (v128.const f64x2 0123456789e019 0123456789e019))
                                    (v128.const f64x2 0x1.fe9af5b5e16fap+89 0x1.fe9af5b5e16fap+89))
(assert_return (invoke "f64x2.pmax" (v128.const f64x2 0x0123456789ABCDEFabcdef.p-019 0x0123456789ABCDEFabcdef.p-019)
                                    (v128.const f64x2 0123456789e+019 0123456789e+019))
                                    (v128.const f64x2 0x1.fe9af5b5e16fap+89 0x1.fe9af5b5e16fap+89))
(assert_return (invoke "f64x2.pmax" (v128.const f64x2 0x0123456789ABCDEFabcdef.p-019 0x0123456789ABCDEFabcdef.p-019)
                                    (v128.const f64x2 0123456789e-019 0123456789e-019))
                                    (v128.const f64x2 0x1.23456789abcdfp+61 0x1.23456789abcdfp+61))
(assert_return (invoke "f64x2.pmax" (v128.const f64x2 0x0123456789ABCDEFabcdef.p-019 0x0123456789ABCDEFabcdef.p-019)
                                    (v128.const f64x2 0123456789. 0123456789.))
                                    (v128.const f64x2 0x1.23456789abcdfp+61 0x1.23456789abcdfp+61))
(assert_return (invoke "f64x2.pmax" (v128.const f64x2 0x0123456789ABCDEFabcdef.p-019 0x0123456789ABCDEFabcdef.p-019)
                                    (v128.const f64x2 0123456789.e019 0123456789.e019))
                                    (v128.const f64x2 0x1.fe9af5b5e16fap+89 0x1.fe9af5b5e16fap+89))
(assert_return (invoke "f64x2.pmax" (v128.const f64x2 0x0123456789ABCDEFabcdef.p-019 0x0123456789ABCDEFabcdef.p-019)
                                    (v128.const f64x2 0123456789.e+019 0123456789.e+019))
                                    (v128.const f64x2 0x1.fe9af5b5e16fap+89 0x1.fe9af5b5e16fap+89))
(assert_return (invoke "f64x2.pmax" (v128.const f64x2 0x0123456789ABCDEFabcdef.p-019 0x0123456789ABCDEFabcdef.p-019)
                                    (v128.const f64x2 0123456789.e-019 0123456789.e-019))
                                    (v128.const f64x2 0x1.23456789abcdfp+61 0x1.23456789abcdfp+61))
(assert_return (invoke "f64x2.pmax" (v128.const f64x2 0x0123456789ABCDEFabcdef.p-019 0x0123456789ABCDEFabcdef.p-019)
                                    (v128.const f64x2 0123456789.0123456789 0123456789.0123456789))
                                    (v128.const f64x2 0x1.23456789abcdfp+61 0x1.23456789abcdfp+61))
(assert_return (invoke "f64x2.pmax" (v128.const f64x2 0x0123456789ABCDEFabcdef.p-019 0x0123456789ABCDEFabcdef.p-019)
                                    (v128.const f64x2 0123456789.0123456789e019 0123456789.0123456789e019))
                                    (v128.const f64x2 0x1.fe9af5b6bcbd5p+89 0x1.fe9af5b6bcbd5p+89))
(assert_return (invoke "f64x2.pmax" (v128.const f64x2 0x0123456789ABCDEFabcdef.p-019 0x0123456789ABCDEFabcdef.p-019)
                                    (v128.const f64x2 0123456789.0123456789e+019 0123456789.0123456789e+019))
                                    (v128.const f64x2 0x1.fe9af5b6bcbd5p+89 0x1.fe9af5b6bcbd5p+89))
(assert_return (invoke "f64x2.pmax" (v128.const f64x2 0x0123456789ABCDEFabcdef.p-019 0x0123456789ABCDEFabcdef.p-019)
                                    (v128.const f64x2 0123456789.0123456789e-019 0123456789.0123456789e-019))
                                    (v128.const f64x2 0x1.23456789abcdfp+61 0x1.23456789abcdfp+61))
(assert_return (invoke "f64x2.pmax" (v128.const f64x2 0x0123456789ABCDEFabcdef.p-019 0x0123456789ABCDEFabcdef.p-019)
                                    (v128.const f64x2 0x0123456789ABCDEFabcdef 0x0123456789ABCDEFabcdef))
                                    (v128.const f64x2 0x1.23456789abcdfp+80 0x1.23456789abcdfp+80))
(assert_return (invoke "f64x2.pmax" (v128.const f64x2 0x0123456789ABCDEFabcdef.p-019 0x0123456789ABCDEFabcdef.p-019)
                                    (v128.const f64x2 0x0123456789ABCDEFabcdefp019 0x0123456789ABCDEFabcdefp019))
                                    (v128.const f64x2 0x1.23456789abcdfp+99 0x1.23456789abcdfp+99))
(assert_return (invoke "f64x2.pmax" (v128.const f64x2 0x0123456789ABCDEFabcdef.p-019 0x0123456789ABCDEFabcdef.p-019)
                                    (v128.const f64x2 0x0123456789ABCDEFabcdefp+019 0x0123456789ABCDEFabcdefp+019))
                                    (v128.const f64x2 0x1.23456789abcdfp+99 0x1.23456789abcdfp+99))
(assert_return (invoke "f64x2.pmax" (v128.const f64x2 0x0123456789ABCDEFabcdef.p-019 0x0123456789ABCDEFabcdef.p-019)
                                    (v128.const f64x2 0x0123456789ABCDEFabcdefp-019 0x0123456789ABCDEFabcdefp-019))
                                    (v128.const f64x2 0x1.23456789abcdfp+61 0x1.23456789abcdfp+61))
(assert_return (invoke "f64x2.pmax" (v128.const f64x2 0x0123456789ABCDEFabcdef.p-019 0x0123456789ABCDEFabcdef.p-019)
                                    (v128.const f64x2 0x0123456789ABCDEFabcdef. 0x0123456789ABCDEFabcdef.))
                                    (v128.const f64x2 0x1.23456789abcdfp+80 0x1.23456789abcdfp+80))
(assert_return (invoke "f64x2.pmax" (v128.const f64x2 0x0123456789ABCDEFabcdef.p-019 0x0123456789ABCDEFabcdef.p-019)
                                    (v128.const f64x2 0x0123456789ABCDEFabcdef.p019 0x0123456789ABCDEFabcdef.p019))
                                    (v128.const f64x2 0x1.23456789abcdfp+99 0x1.23456789abcdfp+99))
(assert_return (invoke "f64x2.pmax" (v128.const f64x2 0x0123456789ABCDEFabcdef.p-019 0x0123456789ABCDEFabcdef.p-019)
                                    (v128.const f64x2 0x0123456789ABCDEFabcdef.p+019 0x0123456789ABCDEFabcdef.p+019))
                                    (v128.const f64x2 0x1.23456789abcdfp+99 0x1.23456789abcdfp+99))
(assert_return (invoke "f64x2.pmax" (v128.const f64x2 0x0123456789ABCDEFabcdef.p-019 0x0123456789ABCDEFabcdef.p-019)
                                    (v128.const f64x2 0x0123456789ABCDEFabcdef.p-019 0x0123456789ABCDEFabcdef.p-019))
                                    (v128.const f64x2 0x1.23456789abcdfp+61 0x1.23456789abcdfp+61))
(assert_return (invoke "f64x2.pmax" (v128.const f64x2 0x0123456789ABCDEFabcdef.p-019 0x0123456789ABCDEFabcdef.p-019)
                                    (v128.const f64x2 0x0123456789ABCDEFabcdef.0123456789ABCDEFabcdef 0x0123456789ABCDEFabcdef.0123456789ABCDEFabcdef))
                                    (v128.const f64x2 0x1.23456789abcdfp+80 0x1.23456789abcdfp+80))
(assert_return (invoke "f64x2.pmax" (v128.const f64x2 0x0123456789ABCDEFabcdef.p-019 0x0123456789ABCDEFabcdef.p-019)
                                    (v128.const f64x2 0x0123456789ABCDEFabcdef.0123456789ABCDEFabcdefp019 0x0123456789ABCDEFabcdef.0123456789ABCDEFabcdefp019))
                                    (v128.const f64x2 0x1.23456789abcdfp+99 0x1.23456789abcdfp+99))
(assert_return (invoke "f64x2.pmax" (v128.const f64x2 0x0123456789ABCDEFabcdef.p-019 0x0123456789ABCDEFabcdef.p-019)
                                    (v128.const f64x2 0x0123456789ABCDEFabcdef.0123456789ABCDEFabcdefp+019 0x0123456789ABCDEFabcdef.0123456789ABCDEFabcdefp+019))
                                    (v128.const f64x2 0x1.23456789abcdfp+99 0x1.23456789abcdfp+99))
(assert_return (invoke "f64x2.pmax" (v128.const f64x2 0x0123456789ABCDEFabcdef.p-019 0x0123456789ABCDEFabcdef.p-019)
                                    (v128.const f64x2 0x0123456789ABCDEFabcdef.0123456789ABCDEFabcdefp-019 0x0123456789ABCDEFabcdef.0123456789ABCDEFabcdefp-019))
                                    (v128.const f64x2 0x1.23456789abcdfp+61 0x1.23456789abcdfp+61))
(assert_return (invoke "f64x2.pmax" (v128.const f64x2 0x0123456789ABCDEFabcdef.0123456789ABCDEFabcdef 0x0123456789ABCDEFabcdef.0123456789ABCDEFabcdef)
                                    (v128.const f64x2 0x0p+0 0x0p+0))
                                    (v128.const f64x2 0x1.23456789abcdfp+80 0x1.23456789abcdfp+80))
(assert_return (invoke "f64x2.pmax" (v128.const f64x2 0x0123456789ABCDEFabcdef.0123456789ABCDEFabcdef 0x0123456789ABCDEFabcdef.0123456789ABCDEFabcdef)
                                    (v128.const f64x2 -0x0p+0 -0x0p+0))
                                    (v128.const f64x2 0x1.23456789abcdfp+80 0x1.23456789abcdfp+80))
(assert_return (invoke "f64x2.pmax" (v128.const f64x2 0x0123456789ABCDEFabcdef.0123456789ABCDEFabcdef 0x0123456789ABCDEFabcdef.0123456789ABCDEFabcdef)
                                    (v128.const f64x2 0x1p-1022 0x1p-1022))
                                    (v128.const f64x2 0x1.23456789abcdfp+80 0x1.23456789abcdfp+80))
(assert_return (invoke "f64x2.pmax" (v128.const f64x2 0x0123456789ABCDEFabcdef.0123456789ABCDEFabcdef 0x0123456789ABCDEFabcdef.0123456789ABCDEFabcdef)
                                    (v128.const f64x2 -0x1p-1022 -0x1p-1022))
                                    (v128.const f64x2 0x1.23456789abcdfp+80 0x1.23456789abcdfp+80))
(assert_return (invoke "f64x2.pmax" (v128.const f64x2 0x0123456789ABCDEFabcdef.0123456789ABCDEFabcdef 0x0123456789ABCDEFabcdef.0123456789ABCDEFabcdef)
                                    (v128.const f64x2 0x1p-1 0x1p-1))
                                    (v128.const f64x2 0x1.23456789abcdfp+80 0x1.23456789abcdfp+80))
(assert_return (invoke "f64x2.pmax" (v128.const f64x2 0x0123456789ABCDEFabcdef.0123456789ABCDEFabcdef 0x0123456789ABCDEFabcdef.0123456789ABCDEFabcdef)
                                    (v128.const f64x2 -0x1p-1 -0x1p-1))
                                    (v128.const f64x2 0x1.23456789abcdfp+80 0x1.23456789abcdfp+80))
(assert_return (invoke "f64x2.pmax" (v128.const f64x2 0x0123456789ABCDEFabcdef.0123456789ABCDEFabcdef 0x0123456789ABCDEFabcdef.0123456789ABCDEFabcdef)
                                    (v128.const f64x2 0x1p+0 0x1p+0))
                                    (v128.const f64x2 0x1.23456789abcdfp+80 0x1.23456789abcdfp+80))
(assert_return (invoke "f64x2.pmax" (v128.const f64x2 0x0123456789ABCDEFabcdef.0123456789ABCDEFabcdef 0x0123456789ABCDEFabcdef.0123456789ABCDEFabcdef)
                                    (v128.const f64x2 -0x1p+0 -0x1p+0))
                                    (v128.const f64x2 0x1.23456789abcdfp+80 0x1.23456789abcdfp+80))
(assert_return (invoke "f64x2.pmax" (v128.const f64x2 0x0123456789ABCDEFabcdef.0123456789ABCDEFabcdef 0x0123456789ABCDEFabcdef.0123456789ABCDEFabcdef)
                                    (v128.const f64x2 0x1.921fb54442d18p+2 0x1.921fb54442d18p+2))
                                    (v128.const f64x2 0x1.23456789abcdfp+80 0x1.23456789abcdfp+80))
(assert_return (invoke "f64x2.pmax" (v128.const f64x2 0x0123456789ABCDEFabcdef.0123456789ABCDEFabcdef 0x0123456789ABCDEFabcdef.0123456789ABCDEFabcdef)
                                    (v128.const f64x2 -0x1.921fb54442d18p+2 -0x1.921fb54442d18p+2))
                                    (v128.const f64x2 0x1.23456789abcdfp+80 0x1.23456789abcdfp+80))
(assert_return (invoke "f64x2.pmax" (v128.const f64x2 0x0123456789ABCDEFabcdef.0123456789ABCDEFabcdef 0x0123456789ABCDEFabcdef.0123456789ABCDEFabcdef)
                                    (v128.const f64x2 0x1.fffffffffffffp+1023 0x1.fffffffffffffp+1023))
                                    (v128.const f64x2 0x1.fffffffffffffp+1023 0x1.fffffffffffffp+1023))
(assert_return (invoke "f64x2.pmax" (v128.const f64x2 0x0123456789ABCDEFabcdef.0123456789ABCDEFabcdef 0x0123456789ABCDEFabcdef.0123456789ABCDEFabcdef)
                                    (v128.const f64x2 -0x1.fffffffffffffp+1023 -0x1.fffffffffffffp+1023))
                                    (v128.const f64x2 0x1.23456789abcdfp+80 0x1.23456789abcdfp+80))
(assert_return (invoke "f64x2.pmax" (v128.const f64x2 0x0123456789ABCDEFabcdef.0123456789ABCDEFabcdef 0x0123456789ABCDEFabcdef.0123456789ABCDEFabcdef)
                                    (v128.const f64x2 0x0.0000000000001p-1022 0x0.0000000000001p-1022))
                                    (v128.const f64x2 0x1.23456789abcdfp+80 0x1.23456789abcdfp+80))
(assert_return (invoke "f64x2.pmax" (v128.const f64x2 0x0123456789ABCDEFabcdef.0123456789ABCDEFabcdef 0x0123456789ABCDEFabcdef.0123456789ABCDEFabcdef)
                                    (v128.const f64x2 0x0.0000000000001p-1022 0x0.0000000000001p-1022))
                                    (v128.const f64x2 0x1.23456789abcdfp+80 0x1.23456789abcdfp+80))
(assert_return (invoke "f64x2.pmax" (v128.const f64x2 0x0123456789ABCDEFabcdef.0123456789ABCDEFabcdef 0x0123456789ABCDEFabcdef.0123456789ABCDEFabcdef)
                                    (v128.const f64x2 inf inf))
                                    (v128.const f64x2 inf inf))
(assert_return (invoke "f64x2.pmax" (v128.const f64x2 0x0123456789ABCDEFabcdef.0123456789ABCDEFabcdef 0x0123456789ABCDEFabcdef.0123456789ABCDEFabcdef)
                                    (v128.const f64x2 -inf -inf))
                                    (v128.const f64x2 0x1.23456789abcdfp+80 0x1.23456789abcdfp+80))
(assert_return (invoke "f64x2.pmax" (v128.const f64x2 0x0123456789ABCDEFabcdef.0123456789ABCDEFabcdef 0x0123456789ABCDEFabcdef.0123456789ABCDEFabcdef)
                                    (v128.const f64x2 0123456789 0123456789))
                                    (v128.const f64x2 0x1.23456789abcdfp+80 0x1.23456789abcdfp+80))
(assert_return (invoke "f64x2.pmax" (v128.const f64x2 0x0123456789ABCDEFabcdef.0123456789ABCDEFabcdef 0x0123456789ABCDEFabcdef.0123456789ABCDEFabcdef)
                                    (v128.const f64x2 0123456789e019 0123456789e019))
                                    (v128.const f64x2 0x1.fe9af5b5e16fap+89 0x1.fe9af5b5e16fap+89))
(assert_return (invoke "f64x2.pmax" (v128.const f64x2 0x0123456789ABCDEFabcdef.0123456789ABCDEFabcdef 0x0123456789ABCDEFabcdef.0123456789ABCDEFabcdef)
                                    (v128.const f64x2 0123456789e+019 0123456789e+019))
                                    (v128.const f64x2 0x1.fe9af5b5e16fap+89 0x1.fe9af5b5e16fap+89))
(assert_return (invoke "f64x2.pmax" (v128.const f64x2 0x0123456789ABCDEFabcdef.0123456789ABCDEFabcdef 0x0123456789ABCDEFabcdef.0123456789ABCDEFabcdef)
                                    (v128.const f64x2 0123456789e-019 0123456789e-019))
                                    (v128.const f64x2 0x1.23456789abcdfp+80 0x1.23456789abcdfp+80))
(assert_return (invoke "f64x2.pmax" (v128.const f64x2 0x0123456789ABCDEFabcdef.0123456789ABCDEFabcdef 0x0123456789ABCDEFabcdef.0123456789ABCDEFabcdef)
                                    (v128.const f64x2 0123456789. 0123456789.))
                                    (v128.const f64x2 0x1.23456789abcdfp+80 0x1.23456789abcdfp+80))
(assert_return (invoke "f64x2.pmax" (v128.const f64x2 0x0123456789ABCDEFabcdef.0123456789ABCDEFabcdef 0x0123456789ABCDEFabcdef.0123456789ABCDEFabcdef)
                                    (v128.const f64x2 0123456789.e019 0123456789.e019))
                                    (v128.const f64x2 0x1.fe9af5b5e16fap+89 0x1.fe9af5b5e16fap+89))
(assert_return (invoke "f64x2.pmax" (v128.const f64x2 0x0123456789ABCDEFabcdef.0123456789ABCDEFabcdef 0x0123456789ABCDEFabcdef.0123456789ABCDEFabcdef)
                                    (v128.const f64x2 0123456789.e+019 0123456789.e+019))
                                    (v128.const f64x2 0x1.fe9af5b5e16fap+89 0x1.fe9af5b5e16fap+89))
(assert_return (invoke "f64x2.pmax" (v128.const f64x2 0x0123456789ABCDEFabcdef.0123456789ABCDEFabcdef 0x0123456789ABCDEFabcdef.0123456789ABCDEFabcdef)
                                    (v128.const f64x2 0123456789.e-019 0123456789.e-019))
                                    (v128.const f64x2 0x1.23456789abcdfp+80 0x1.23456789abcdfp+80))
(assert_return (invoke "f64x2.pmax" (v128.const f64x2 0x0123456789ABCDEFabcdef.0123456789ABCDEFabcdef 0x0123456789ABCDEFabcdef.0123456789ABCDEFabcdef)
                                    (v128.const f64x2 0123456789.0123456789 0123456789.0123456789))
                                    (v128.const f64x2 0x1.23456789abcdfp+80 0x1.23456789abcdfp+80))
(assert_return (invoke "f64x2.pmax" (v128.const f64x2 0x0123456789ABCDEFabcdef.0123456789ABCDEFabcdef 0x0123456789ABCDEFabcdef.0123456789ABCDEFabcdef)
                                    (v128.const f64x2 0123456789.0123456789e019 0123456789.0123456789e019))
                                    (v128.const f64x2 0x1.fe9af5b6bcbd5p+89 0x1.fe9af5b6bcbd5p+89))
(assert_return (invoke "f64x2.pmax" (v128.const f64x2 0x0123456789ABCDEFabcdef.0123456789ABCDEFabcdef 0x0123456789ABCDEFabcdef.0123456789ABCDEFabcdef)
                                    (v128.const f64x2 0123456789.0123456789e+019 0123456789.0123456789e+019))
                                    (v128.const f64x2 0x1.fe9af5b6bcbd5p+89 0x1.fe9af5b6bcbd5p+89))
(assert_return (invoke "f64x2.pmax" (v128.const f64x2 0x0123456789ABCDEFabcdef.0123456789ABCDEFabcdef 0x0123456789ABCDEFabcdef.0123456789ABCDEFabcdef)
                                    (v128.const f64x2 0123456789.0123456789e-019 0123456789.0123456789e-019))
                                    (v128.const f64x2 0x1.23456789abcdfp+80 0x1.23456789abcdfp+80))
(assert_return (invoke "f64x2.pmax" (v128.const f64x2 0x0123456789ABCDEFabcdef.0123456789ABCDEFabcdef 0x0123456789ABCDEFabcdef.0123456789ABCDEFabcdef)
                                    (v128.const f64x2 0x0123456789ABCDEFabcdef 0x0123456789ABCDEFabcdef))
                                    (v128.const f64x2 0x1.23456789abcdfp+80 0x1.23456789abcdfp+80))
(assert_return (invoke "f64x2.pmax" (v128.const f64x2 0x0123456789ABCDEFabcdef.0123456789ABCDEFabcdef 0x0123456789ABCDEFabcdef.0123456789ABCDEFabcdef)
                                    (v128.const f64x2 0x0123456789ABCDEFabcdefp019 0x0123456789ABCDEFabcdefp019))
                                    (v128.const f64x2 0x1.23456789abcdfp+99 0x1.23456789abcdfp+99))
(assert_return (invoke "f64x2.pmax" (v128.const f64x2 0x0123456789ABCDEFabcdef.0123456789ABCDEFabcdef 0x0123456789ABCDEFabcdef.0123456789ABCDEFabcdef)
                                    (v128.const f64x2 0x0123456789ABCDEFabcdefp+019 0x0123456789ABCDEFabcdefp+019))
                                    (v128.const f64x2 0x1.23456789abcdfp+99 0x1.23456789abcdfp+99))
(assert_return (invoke "f64x2.pmax" (v128.const f64x2 0x0123456789ABCDEFabcdef.0123456789ABCDEFabcdef 0x0123456789ABCDEFabcdef.0123456789ABCDEFabcdef)
                                    (v128.const f64x2 0x0123456789ABCDEFabcdefp-019 0x0123456789ABCDEFabcdefp-019))
                                    (v128.const f64x2 0x1.23456789abcdfp+80 0x1.23456789abcdfp+80))
(assert_return (invoke "f64x2.pmax" (v128.const f64x2 0x0123456789ABCDEFabcdef.0123456789ABCDEFabcdef 0x0123456789ABCDEFabcdef.0123456789ABCDEFabcdef)
                                    (v128.const f64x2 0x0123456789ABCDEFabcdef. 0x0123456789ABCDEFabcdef.))
                                    (v128.const f64x2 0x1.23456789abcdfp+80 0x1.23456789abcdfp+80))
(assert_return (invoke "f64x2.pmax" (v128.const f64x2 0x0123456789ABCDEFabcdef.0123456789ABCDEFabcdef 0x0123456789ABCDEFabcdef.0123456789ABCDEFabcdef)
                                    (v128.const f64x2 0x0123456789ABCDEFabcdef.p019 0x0123456789ABCDEFabcdef.p019))
                                    (v128.const f64x2 0x1.23456789abcdfp+99 0x1.23456789abcdfp+99))
(assert_return (invoke "f64x2.pmax" (v128.const f64x2 0x0123456789ABCDEFabcdef.0123456789ABCDEFabcdef 0x0123456789ABCDEFabcdef.0123456789ABCDEFabcdef)
                                    (v128.const f64x2 0x0123456789ABCDEFabcdef.p+019 0x0123456789ABCDEFabcdef.p+019))
                                    (v128.const f64x2 0x1.23456789abcdfp+99 0x1.23456789abcdfp+99))
(assert_return (invoke "f64x2.pmax" (v128.const f64x2 0x0123456789ABCDEFabcdef.0123456789ABCDEFabcdef 0x0123456789ABCDEFabcdef.0123456789ABCDEFabcdef)
                                    (v128.const f64x2 0x0123456789ABCDEFabcdef.p-019 0x0123456789ABCDEFabcdef.p-019))
                                    (v128.const f64x2 0x1.23456789abcdfp+80 0x1.23456789abcdfp+80))
(assert_return (invoke "f64x2.pmax" (v128.const f64x2 0x0123456789ABCDEFabcdef.0123456789ABCDEFabcdef 0x0123456789ABCDEFabcdef.0123456789ABCDEFabcdef)
                                    (v128.const f64x2 0x0123456789ABCDEFabcdef.0123456789ABCDEFabcdef 0x0123456789ABCDEFabcdef.0123456789ABCDEFabcdef))
                                    (v128.const f64x2 0x1.23456789abcdfp+80 0x1.23456789abcdfp+80))
(assert_return (invoke "f64x2.pmax" (v128.const f64x2 0x0123456789ABCDEFabcdef.0123456789ABCDEFabcdef 0x0123456789ABCDEFabcdef.0123456789ABCDEFabcdef)
                                    (v128.const f64x2 0x0123456789ABCDEFabcdef.0123456789ABCDEFabcdefp019 0x0123456789ABCDEFabcdef.0123456789ABCDEFabcdefp019))
                                    (v128.const f64x2 0x1.23456789abcdfp+99 0x1.23456789abcdfp+99))
(assert_return (invoke "f64x2.pmax" (v128.const f64x2 0x0123456789ABCDEFabcdef.0123456789ABCDEFabcdef 0x0123456789ABCDEFabcdef.0123456789ABCDEFabcdef)
                                    (v128.const f64x2 0x0123456789ABCDEFabcdef.0123456789ABCDEFabcdefp+019 0x0123456789ABCDEFabcdef.0123456789ABCDEFabcdefp+019))
                                    (v128.const f64x2 0x1.23456789abcdfp+99 0x1.23456789abcdfp+99))
(assert_return (invoke "f64x2.pmax" (v128.const f64x2 0x0123456789ABCDEFabcdef.0123456789ABCDEFabcdef 0x0123456789ABCDEFabcdef.0123456789ABCDEFabcdef)
                                    (v128.const f64x2 0x0123456789ABCDEFabcdef.0123456789ABCDEFabcdefp-019 0x0123456789ABCDEFabcdef.0123456789ABCDEFabcdefp-019))
                                    (v128.const f64x2 0x1.23456789abcdfp+80 0x1.23456789abcdfp+80))
(assert_return (invoke "f64x2.pmax" (v128.const f64x2 0x0123456789ABCDEFabcdef.0123456789ABCDEFabcdefp019 0x0123456789ABCDEFabcdef.0123456789ABCDEFabcdefp019)
                                    (v128.const f64x2 0x0p+0 0x0p+0))
                                    (v128.const f64x2 0x1.23456789abcdfp+99 0x1.23456789abcdfp+99))
(assert_return (invoke "f64x2.pmax" (v128.const f64x2 0x0123456789ABCDEFabcdef.0123456789ABCDEFabcdefp019 0x0123456789ABCDEFabcdef.0123456789ABCDEFabcdefp019)
                                    (v128.const f64x2 -0x0p+0 -0x0p+0))
                                    (v128.const f64x2 0x1.23456789abcdfp+99 0x1.23456789abcdfp+99))
(assert_return (invoke "f64x2.pmax" (v128.const f64x2 0x0123456789ABCDEFabcdef.0123456789ABCDEFabcdefp019 0x0123456789ABCDEFabcdef.0123456789ABCDEFabcdefp019)
                                    (v128.const f64x2 0x1p-1022 0x1p-1022))
                                    (v128.const f64x2 0x1.23456789abcdfp+99 0x1.23456789abcdfp+99))
(assert_return (invoke "f64x2.pmax" (v128.const f64x2 0x0123456789ABCDEFabcdef.0123456789ABCDEFabcdefp019 0x0123456789ABCDEFabcdef.0123456789ABCDEFabcdefp019)
                                    (v128.const f64x2 -0x1p-1022 -0x1p-1022))
                                    (v128.const f64x2 0x1.23456789abcdfp+99 0x1.23456789abcdfp+99))
(assert_return (invoke "f64x2.pmax" (v128.const f64x2 0x0123456789ABCDEFabcdef.0123456789ABCDEFabcdefp019 0x0123456789ABCDEFabcdef.0123456789ABCDEFabcdefp019)
                                    (v128.const f64x2 0x1p-1 0x1p-1))
                                    (v128.const f64x2 0x1.23456789abcdfp+99 0x1.23456789abcdfp+99))
(assert_return (invoke "f64x2.pmax" (v128.const f64x2 0x0123456789ABCDEFabcdef.0123456789ABCDEFabcdefp019 0x0123456789ABCDEFabcdef.0123456789ABCDEFabcdefp019)
                                    (v128.const f64x2 -0x1p-1 -0x1p-1))
                                    (v128.const f64x2 0x1.23456789abcdfp+99 0x1.23456789abcdfp+99))
(assert_return (invoke "f64x2.pmax" (v128.const f64x2 0x0123456789ABCDEFabcdef.0123456789ABCDEFabcdefp019 0x0123456789ABCDEFabcdef.0123456789ABCDEFabcdefp019)
                                    (v128.const f64x2 0x1p+0 0x1p+0))
                                    (v128.const f64x2 0x1.23456789abcdfp+99 0x1.23456789abcdfp+99))
(assert_return (invoke "f64x2.pmax" (v128.const f64x2 0x0123456789ABCDEFabcdef.0123456789ABCDEFabcdefp019 0x0123456789ABCDEFabcdef.0123456789ABCDEFabcdefp019)
                                    (v128.const f64x2 -0x1p+0 -0x1p+0))
                                    (v128.const f64x2 0x1.23456789abcdfp+99 0x1.23456789abcdfp+99))
(assert_return (invoke "f64x2.pmax" (v128.const f64x2 0x0123456789ABCDEFabcdef.0123456789ABCDEFabcdefp019 0x0123456789ABCDEFabcdef.0123456789ABCDEFabcdefp019)
                                    (v128.const f64x2 0x1.921fb54442d18p+2 0x1.921fb54442d18p+2))
                                    (v128.const f64x2 0x1.23456789abcdfp+99 0x1.23456789abcdfp+99))
(assert_return (invoke "f64x2.pmax" (v128.const f64x2 0x0123456789ABCDEFabcdef.0123456789ABCDEFabcdefp019 0x0123456789ABCDEFabcdef.0123456789ABCDEFabcdefp019)
                                    (v128.const f64x2 -0x1.921fb54442d18p+2 -0x1.921fb54442d18p+2))
                                    (v128.const f64x2 0x1.23456789abcdfp+99 0x1.23456789abcdfp+99))
(assert_return (invoke "f64x2.pmax" (v128.const f64x2 0x0123456789ABCDEFabcdef.0123456789ABCDEFabcdefp019 0x0123456789ABCDEFabcdef.0123456789ABCDEFabcdefp019)
                                    (v128.const f64x2 0x1.fffffffffffffp+1023 0x1.fffffffffffffp+1023))
                                    (v128.const f64x2 0x1.fffffffffffffp+1023 0x1.fffffffffffffp+1023))
(assert_return (invoke "f64x2.pmax" (v128.const f64x2 0x0123456789ABCDEFabcdef.0123456789ABCDEFabcdefp019 0x0123456789ABCDEFabcdef.0123456789ABCDEFabcdefp019)
                                    (v128.const f64x2 -0x1.fffffffffffffp+1023 -0x1.fffffffffffffp+1023))
                                    (v128.const f64x2 0x1.23456789abcdfp+99 0x1.23456789abcdfp+99))
(assert_return (invoke "f64x2.pmax" (v128.const f64x2 0x0123456789ABCDEFabcdef.0123456789ABCDEFabcdefp019 0x0123456789ABCDEFabcdef.0123456789ABCDEFabcdefp019)
                                    (v128.const f64x2 0x0.0000000000001p-1022 0x0.0000000000001p-1022))
                                    (v128.const f64x2 0x1.23456789abcdfp+99 0x1.23456789abcdfp+99))
(assert_return (invoke "f64x2.pmax" (v128.const f64x2 0x0123456789ABCDEFabcdef.0123456789ABCDEFabcdefp019 0x0123456789ABCDEFabcdef.0123456789ABCDEFabcdefp019)
                                    (v128.const f64x2 0x0.0000000000001p-1022 0x0.0000000000001p-1022))
                                    (v128.const f64x2 0x1.23456789abcdfp+99 0x1.23456789abcdfp+99))
(assert_return (invoke "f64x2.pmax" (v128.const f64x2 0x0123456789ABCDEFabcdef.0123456789ABCDEFabcdefp019 0x0123456789ABCDEFabcdef.0123456789ABCDEFabcdefp019)
                                    (v128.const f64x2 inf inf))
                                    (v128.const f64x2 inf inf))
(assert_return (