//go:build go1.18
// +build go1.18

// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License. See License.txt in the project root for license information.
// Code generated by Microsoft (R) AutoRest Code Generator. DO NOT EDIT.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

package armsecuritydevops

import (
	"context"
	"errors"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore/arm"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore/policy"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore/runtime"
	"net/http"
	"net/url"
	"strings"
)

// GitHubRepoClient contains the methods for the GitHubRepo group.
// Don't use this type directly, use NewGitHubRepoClient() instead.
type GitHubRepoClient struct {
	internal       *arm.Client
	subscriptionID string
}

// NewGitHubRepoClient creates a new instance of GitHubRepoClient with the specified values.
//   - subscriptionID - The ID of the target subscription.
//   - credential - used to authorize requests. Usually a credential from azidentity.
//   - options - pass nil to accept the default values.
func NewGitHubRepoClient(subscriptionID string, credential azcore.TokenCredential, options *arm.ClientOptions) (*GitHubRepoClient, error) {
	cl, err := arm.NewClient(moduleName, moduleVersion, credential, options)
	if err != nil {
		return nil, err
	}
	client := &GitHubRepoClient{
		subscriptionID: subscriptionID,
		internal:       cl,
	}
	return client, nil
}

// BeginCreateOrUpdate - Create or update a monitored GitHub repository.
// If the operation fails it returns an *azcore.ResponseError type.
//
// Generated from API version 2022-09-01-preview
//   - resourceGroupName - The name of the resource group. The name is case insensitive.
//   - gitHubConnectorName - Name of the GitHub Connector.
//   - gitHubOwnerName - Name of the GitHub Owner.
//   - gitHubRepoName - Name of the GitHub Repo.
//   - gitHubRepo - Github repo.
//   - options - GitHubRepoClientBeginCreateOrUpdateOptions contains the optional parameters for the GitHubRepoClient.BeginCreateOrUpdate
//     method.
func (client *GitHubRepoClient) BeginCreateOrUpdate(ctx context.Context, resourceGroupName string, gitHubConnectorName string, gitHubOwnerName string, gitHubRepoName string, gitHubRepo GitHubRepo, options *GitHubRepoClientBeginCreateOrUpdateOptions) (*runtime.Poller[GitHubRepoClientCreateOrUpdateResponse], error) {
	if options == nil || options.ResumeToken == "" {
		resp, err := client.createOrUpdate(ctx, resourceGroupName, gitHubConnectorName, gitHubOwnerName, gitHubRepoName, gitHubRepo, options)
		if err != nil {
			return nil, err
		}
		poller, err := runtime.NewPoller(resp, client.internal.Pipeline(), &runtime.NewPollerOptions[GitHubRepoClientCreateOrUpdateResponse]{
			FinalStateVia: runtime.FinalStateViaAzureAsyncOp,
			Tracer:        client.internal.Tracer(),
		})
		return poller, err
	} else {
		return runtime.NewPollerFromResumeToken(options.ResumeToken, client.internal.Pipeline(), &runtime.NewPollerFromResumeTokenOptions[GitHubRepoClientCreateOrUpdateResponse]{
			Tracer: client.internal.Tracer(),
		})
	}
}

// CreateOrUpdate - Create or update a monitored GitHub repository.
// If the operation fails it returns an *azcore.ResponseError type.
//
// Generated from API version 2022-09-01-preview
func (client *GitHubRepoClient) createOrUpdate(ctx context.Context, resourceGroupName string, gitHubConnectorName string, gitHubOwnerName string, gitHubRepoName string, gitHubRepo GitHubRepo, options *GitHubRepoClientBeginCreateOrUpdateOptions) (*http.Response, error) {
	var err error
	const operationName = "GitHubRepoClient.BeginCreateOrUpdate"
	ctx = context.WithValue(ctx, runtime.CtxAPINameKey{}, operationName)
	ctx, endSpan := runtime.StartSpan(ctx, operationName, client.internal.Tracer(), nil)
	defer func() { endSpan(err) }()
	req, err := client.createOrUpdateCreateRequest(ctx, resourceGroupName, gitHubConnectorName, gitHubOwnerName, gitHubRepoName, gitHubRepo, options)
	if err != nil {
		return nil, err
	}
	httpResp, err := client.internal.Pipeline().Do(req)
	if err != nil {
		return nil, err
	}
	if !runtime.HasStatusCode(httpResp, http.StatusOK, http.StatusCreated) {
		err = runtime.NewResponseError(httpResp)
		return nil, err
	}
	return httpResp, nil
}

// createOrUpdateCreateRequest creates the CreateOrUpdate request.
func (client *GitHubRepoClient) createOrUpdateCreateRequest(ctx context.Context, resourceGroupName string, gitHubConnectorName string, gitHubOwnerName string, gitHubRepoName string, gitHubRepo GitHubRepo, options *GitHubRepoClientBeginCreateOrUpdateOptions) (*policy.Request, error) {
	urlPath := "/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.SecurityDevOps/gitHubConnectors/{gitHubConnectorName}/owners/{gitHubOwnerName}/repos/{gitHubRepoName}"
	if client.subscriptionID == "" {
		return nil, errors.New("parameter client.subscriptionID cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{subscriptionId}", url.PathEscape(client.subscriptionID))
	if resourceGroupName == "" {
		return nil, errors.New("parameter resourceGroupName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{resourceGroupName}", url.PathEscape(resourceGroupName))
	if gitHubConnectorName == "" {
		return nil, errors.New("parameter gitHubConnectorName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{gitHubConnectorName}", url.PathEscape(gitHubConnectorName))
	if gitHubOwnerName == "" {
		return nil, errors.New("parameter gitHubOwnerName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{gitHubOwnerName}", url.PathEscape(gitHubOwnerName))
	if gitHubRepoName == "" {
		return nil, errors.New("parameter gitHubRepoName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{gitHubRepoName}", url.PathEscape(gitHubRepoName))
	req, err := runtime.NewRequest(ctx, http.MethodPut, runtime.JoinPaths(client.internal.Endpoint(), urlPath))
	if err != nil {
		return nil, err
	}
	reqQP := req.Raw().URL.Query()
	reqQP.Set("api-version", "2022-09-01-preview")
	req.Raw().URL.RawQuery = reqQP.Encode()
	req.Raw().Header["Accept"] = []string{"application/json"}
	if err := runtime.MarshalAsJSON(req, gitHubRepo); err != nil {
		return nil, err
	}
	return req, nil
}

// Get - Returns a monitored GitHub repository.
// If the operation fails it returns an *azcore.ResponseError type.
//
// Generated from API version 2022-09-01-preview
//   - resourceGroupName - The name of the resource group. The name is case insensitive.
//   - gitHubConnectorName - Name of the GitHub Connector.
//   - gitHubOwnerName - Name of the GitHub Owner.
//   - gitHubRepoName - Name of the GitHub Repo.
//   - options - GitHubRepoClientGetOptions contains the optional parameters for the GitHubRepoClient.Get method.
func (client *GitHubRepoClient) Get(ctx context.Context, resourceGroupName string, gitHubConnectorName string, gitHubOwnerName string, gitHubRepoName string, options *GitHubRepoClientGetOptions) (GitHubRepoClientGetResponse, error) {
	var err error
	const operationName = "GitHubRepoClient.Get"
	ctx = context.WithValue(ctx, runtime.CtxAPINameKey{}, operationName)
	ctx, endSpan := runtime.StartSpan(ctx, operationName, client.internal.Tracer(), nil)
	defer func() { endSpan(err) }()
	req, err := client.getCreateRequest(ctx, resourceGroupName, gitHubConnectorName, gitHubOwnerName, gitHubRepoName, options)
	if err != nil {
		return GitHubRepoClientGetResponse{}, err
	}
	httpResp, err := client.internal.Pipeline().Do(req)
	if err != nil {
		return GitHubRepoClientGetResponse{}, err
	}
	if !runtime.HasStatusCode(httpResp, http.StatusOK) {
		err = runtime.NewResponseError(httpResp)
		return GitHubRepoClientGetResponse{}, err
	}
	resp, err := client.getHandleResponse(httpResp)
	return resp, err
}

// getCreateRequest creates the Get request.
func (client *GitHubRepoClient) getCreateRequest(ctx context.Context, resourceGroupName string, gitHubConnectorName string, gitHubOwnerName string, gitHubRepoName string, options *GitHubRepoClientGetOptions) (*policy.Request, error) {
	urlPath := "/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.SecurityDevOps/gitHubConnectors/{gitHubConnectorName}/owners/{gitHubOwnerName}/repos/{gitHubRepoName}"
	if client.subscriptionID == "" {
		return nil, errors.New("parameter client.subscriptionID cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{subscriptionId}", url.PathEscape(client.subscriptionID))
	if resourceGroupName == "" {
		return nil, errors.New("parameter resourceGroupName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{resourceGroupName}", url.PathEscape(resourceGroupName))
	if gitHubConnectorName == "" {
		return nil, errors.New("parameter gitHubConnectorName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{gitHubConnectorName}", url.PathEscape(gitHubConnectorName))
	if gitHubOwnerName == "" {
		return nil, errors.New("parameter gitHubOwnerName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{gitHubOwnerName}", url.PathEscape(gitHubOwnerName))
	if gitHubRepoName == "" {
		return nil, errors.New("parameter gitHubRepoName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{gitHubRepoName}", url.PathEscape(gitHubRepoName))
	req, err := runtime.NewRequest(ctx, http.MethodGet, runtime.JoinPaths(client.internal.Endpoint(), urlPath))
	if err != nil {
		return nil, err
	}
	reqQP := req.Raw().URL.Query()
	reqQP.Set("api-version", "2022-09-01-preview")
	req.Raw().URL.RawQuery = reqQP.Encode()
	req.Raw().Header["Accept"] = []string{"application/json"}
	return req, nil
}

// getHandleResponse handles the Get response.
func (client *GitHubRepoClient) getHandleResponse(resp *http.Response) (GitHubRepoClientGetResponse, error) {
	result := GitHubRepoClientGetResponse{}
	if err := runtime.UnmarshalAsJSON(resp, &result.GitHubRepo); err != nil {
		return GitHubRepoClientGetResponse{}, err
	}
	return result, nil
}

// NewListPager - Returns a list of monitored GitHub repositories.
//
// Generated from API version 2022-09-01-preview
//   - resourceGroupName - The name of the resource group. The name is case insensitive.
//   - gitHubConnectorName - Name of the GitHub Connector.
//   - gitHubOwnerName - Name of the GitHub Owner.
//   - options - GitHubRepoClientListOptions contains the optional parameters for the GitHubRepoClient.NewListPager method.
func (client *GitHubRepoClient) NewListPager(resourceGroupName string, gitHubConnectorName string, gitHubOwnerName string, options *GitHubRepoClientListOptions) *runtime.Pager[GitHubRepoClientListResponse] {
	return runtime.NewPager(runtime.PagingHandler[GitHubRepoClientListResponse]{
		More: func(page GitHubRepoClientListResponse) bool {
			return page.NextLink != nil && len(*page.NextLink) > 0
		},
		Fetcher: func(ctx context.Context, page *GitHubRepoClientListResponse) (GitHubRepoClientListResponse, error) {
			ctx = context.WithValue(ctx, runtime.CtxAPINameKey{}, "GitHubRepoClient.NewListPager")
			nextLink := ""
			if page != nil {
				nextLink = *page.NextLink
			}
			resp, err := runtime.FetcherForNextLink(ctx, client.internal.Pipeline(), nextLink, func(ctx context.Context) (*policy.Request, error) {
				return client.listCreateRequest(ctx, resourceGroupName, gitHubConnectorName, gitHubOwnerName, options)
			}, nil)
			if err != nil {
				return GitHubRepoClientListResponse{}, err
			}
			return client.listHandleResponse(resp)
		},
		Tracer: client.internal.Tracer(),
	})
}

// listCreateRequest creates the List request.
func (client *GitHubRepoClient) listCreateRequest(ctx context.Context, resourceGroupName string, gitHubConnectorName string, gitHubOwnerName string, options *GitHubRepoClientListOptions) (*policy.Request, error) {
	urlPath := "/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.SecurityDevOps/gitHubConnectors/{gitHubConnectorName}/owners/{gitHubOwnerName}/repos"
	if client.subscriptionID == "" {
		return nil, errors.New("parameter client.subscriptionID cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{subscriptionId}", url.PathEscape(client.subscriptionID))
	if resourceGroupName == "" {
		return nil, errors.New("parameter resourceGroupName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{resourceGroupName}", url.PathEscape(resourceGroupName))
	if gitHubConnectorName == "" {
		return nil, errors.New("parameter gitHubConnectorName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{gitHubConnectorName}", url.PathEscape(gitHubConnectorName))
	if gitHubOwnerName == "" {
		return nil, errors.New("parameter gitHubOwnerName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{gitHubOwnerName}", url.PathEscape(gitHubOwnerName))
	req, err := runtime.NewRequest(ctx, http.MethodGet, runtime.JoinPaths(client.internal.Endpoint(), urlPath))
	if err != nil {
		return nil, err
	}
	reqQP := req.Raw().URL.Query()
	reqQP.Set("api-version", "2022-09-01-preview")
	req.Raw().URL.RawQuery = reqQP.Encode()
	req.Raw().Header["Accept"] = []string{"application/json"}
	return req, nil
}

// listHandleResponse handles the List response.
func (client *GitHubRepoClient) listHandleResponse(resp *http.Response) (GitHubRepoClientListResponse, error) {
	result := GitHubRepoClientListResponse{}
	if err := runtime.UnmarshalAsJSON(resp, &result.GitHubRepoListResponse); err != nil {
		return GitHubRepoClientListResponse{}, err
	}
	return result, nil
}

// NewListByConnectorPager - Returns a list of monitored GitHub repositories.
//
// Generated from API version 2022-09-01-preview
//   - resourceGroupName - The name of the resource group. The name is case insensitive.
//   - gitHubConnectorName - Name of the GitHub Connector.
//   - options - GitHubRepoClientListByConnectorOptions contains the optional parameters for the GitHubRepoClient.NewListByConnectorPager
//     method.
func (client *GitHubRepoClient) NewListByConnectorPager(resourceGroupName string, gitHubConnectorName string, options *GitHubRepoClientListByConnectorOptions) *runtime.Pager[GitHubRepoClientListByConnectorResponse] {
	return runtime.NewPager(runtime.PagingHandler[GitHubRepoClientListByConnectorResponse]{
		More: func(page GitHubRepoClientListByConnectorResponse) bool {
			return page.NextLink != nil && len(*page.NextLink) > 0
		},
		Fetcher: func(ctx context.Context, page *GitHubRepoClientListByConnectorResponse) (GitHubRepoClientListByConnectorResponse, error) {
			ctx = context.WithValue(ctx, runtime.CtxAPINameKey{}, "GitHubRepoClient.NewListByConnectorPager")
			nextLink := ""
			if page != nil {
				nextLink = *page.NextLink
			}
			resp, err := runtime.FetcherForNextLink(ctx, client.internal.Pipeline(), nextLink, func(ctx context.Context) (*policy.Request, error) {
				return client.listByConnectorCreateRequest(ctx, resourceGroupName, gitHubConnectorName, options)
			}, nil)
			if err != nil {
				return GitHubRepoClientListByConnectorResponse{}, err
			}
			return client.listByConnectorHandleResponse(resp)
		},
		Tracer: client.internal.Tracer(),
	})
}

// listByConnectorCreateRequest creates the ListByConnector request.
func (client *GitHubRepoClient) listByConnectorCreateRequest(ctx context.Context, resourceGroupName string, gitHubConnectorName string, options *GitHubRepoClientListByConnectorOptions) (*policy.Request, error) {
	urlPath := "/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.SecurityDevOps/gitHubConnectors/{gitHubConnectorName}/repos"
	if client.subscriptionID == "" {
		return nil, errors.New("parameter client.subscriptionID cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{subscriptionId}", url.PathEscape(client.subscriptionID))
	if resourceGroupName == "" {
		return nil, errors.New("parameter resourceGroupName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{resourceGroupName}", url.PathEscape(resourceGroupName))
	if gitHubConnectorName == "" {
		return nil, errors.New("parameter gitHubConnectorName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{gitHubConnectorName}", url.PathEscape(gitHubConnectorName))
	req, err := runtime.NewRequest(ctx, http.MethodGet, runtime.JoinPaths(client.internal.Endpoint(), urlPath))
	if err != nil {
		return nil, err
	}
	reqQP := req.Raw().URL.Query()
	reqQP.Set("api-version", "2022-09-01-preview")
	req.Raw().URL.RawQuery = reqQP.Encode()
	req.Raw().Header["Accept"] = []string{"application/json"}
	return req, nil
}

// listByConnectorHandleResponse handles the ListByConnector response.
func (client *GitHubRepoClient) listByConnectorHandleResponse(resp *http.Response) (GitHubRepoClientListByConnectorResponse, error) {
	result := GitHubRepoClientListByConnectorResponse{}
	if err := runtime.UnmarshalAsJSON(resp, &result.GitHubRepoListResponse); err != nil {
		return GitHubRepoClientListByConnectorResponse{}, err
	}
	return result, nil
}

// BeginUpdate - Patch a monitored GitHub repository.
// If the operation fails it returns an *azcore.ResponseError type.
//
// Generated from API version 2022-09-01-preview
//   - resourceGroupName - The name of the resource group. The name is case insensitive.
//   - gitHubConnectorName - Name of the GitHub Connector.
//   - gitHubOwnerName - Name of the GitHub Owner.
//   - gitHubRepoName - Name of the GitHub Repo.
//   - gitHubRepo - Github repo.
//   - options - GitHubRepoClientBeginUpdateOptions contains the optional parameters for the GitHubRepoClient.BeginUpdate method.
func (client *GitHubRepoClient) BeginUpdate(ctx context.Context, resourceGroupName string, gitHubConnectorName string, gitHubOwnerName string, gitHubRepoName string, gitHubRepo GitHubRepo, options *GitHubRepoClientBeginUpdateOptions) (*runtime.Poller[GitHubRepoClientUpdateResponse], error) {
	if options == nil || options.ResumeToken == "" {
		resp, err := client.update(ctx, resourceGroupName, gitHubConnectorName, gitHubOwnerName, gitHubRepoName, gitHubRepo, options)
		if err != nil {
			return nil, err
		}
		poller, err := runtime.NewPoller(resp, client.internal.Pipeline(), &runtime.NewPollerOptions[GitHubRepoClientUpdateResponse]{
			Tracer: client.internal.Tracer(),
		})
		return poller, err
	} else {
		return runtime.NewPollerFromResumeToken(options.ResumeToken, client.internal.Pipeline(), &runtime.NewPollerFromResumeTokenOptions[GitHubRepoClientUpdateResponse]{
			Tracer: client.internal.Tracer(),
		})
	}
}

// Update - Patch a monitored GitHub repository.
// If the operation fails it returns an *azcore.ResponseError type.
//
// Generated from API version 2022-09-01-preview
func (client *GitHubRepoClient) update(ctx context.Context, resourceGroupName string, gitHubConnectorName string, gitHubOwnerName string, gitHubRepoName string, gitHubRepo GitHubRepo, options *GitHubRepoClientBeginUpdateOptions) (*http.Response, error) {
	var err error
	const operationName = "GitHubRepoClient.BeginUpdate"
	ctx = context.WithValue(ctx, runtime.CtxAPINameKey{}, operationName)
	ctx, endSpan := runtime.StartSpan(ctx, operationName, client.internal.Tracer(), nil)
	defer func() { endSpan(err) }()
	req, err := client.updateCreateRequest(ctx, resourceGroupName, gitHubConnectorName, gitHubOwnerName, gitHubRepoName, gitHubRepo, options)
	if err != nil {
		return nil, err
	}
	httpResp, err := client.internal.Pipeline().Do(req)
	if err != nil {
		return nil, err
	}
	if !runtime.HasStatusCode(httpResp, http.StatusAccepted) {
		err = runtime.NewResponseError(httpResp)
		return nil, err
	}
	return httpResp, nil
}

// updateCreateRequest creates the Update request.
func (client *GitHubRepoClient) updateCreateRequest(ctx context.Context, resourceGroupName string, gitHubConnectorName string, gitHubOwnerName string, gitHubRepoName string, gitHubRepo GitHubRepo, options *GitHubRepoClientBeginUpdateOptions) (*policy.Request, error) {
	urlPath := "/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.SecurityDevOps/gitHubConnectors/{gitHubConnectorName}/owners/{gitHubOwnerName}/repos/{gitHubRepoName}"
	if client.subscriptionID == "" {
		return nil, errors.New("parameter client.subscriptionID cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{subscriptionId}", url.PathEscape(client.subscriptionID))
	if resourceGroupName == "" {
		return nil, errors.New("parameter resourceGroupName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{resourceGroupName}", url.PathEscape(resourceGroupName))
	if gitHubConnectorName == "" {
		return nil, errors.New("parameter gitHubConnectorName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{gitHubConnectorName}", url.PathEscape(gitHubConnectorName))
	if gitHubOwnerName == "" {
		return nil, errors.New("parameter gitHubOwnerName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{gitHubOwnerName}", url.PathEscape(gitHubOwnerName))
	if gitHubRepoName == "" {
		return nil, errors.New("parameter gitHubRepoName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{gitHubRepoName}", url.PathEscape(gitHubRepoName))
	req, err := runtime.NewRequest(ctx, http.MethodPatch, runtime.JoinPaths(client.internal.Endpoint(), urlPath))
	if err != nil {
		return nil, err
	}
	reqQP := req.Raw().URL.Query()
	reqQP.Set("api-version", "2022-09-01-preview")
	req.Raw().URL.RawQuery = reqQP.Encode()
	req.Raw().Header["Accept"] = []string{"application/json"}
	if err := runtime.MarshalAsJSON(req, gitHubRepo); err != nil {
		return nil, err
	}
	return req, nil
}
