//go:build go1.18
// +build go1.18

// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License. See License.txt in the project root for license information.
// Code generated by Microsoft (R) AutoRest Code Generator. DO NOT EDIT.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

package armsecurity

import (
	"context"
	"errors"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore/arm"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore/policy"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore/runtime"
	"net/http"
	"net/url"
	"strings"
)

// ComplianceResultsClient contains the methods for the ComplianceResults group.
// Don't use this type directly, use NewComplianceResultsClient() instead.
type ComplianceResultsClient struct {
	internal *arm.Client
}

// NewComplianceResultsClient creates a new instance of ComplianceResultsClient with the specified values.
//   - credential - used to authorize requests. Usually a credential from azidentity.
//   - options - pass nil to accept the default values.
func NewComplianceResultsClient(credential azcore.TokenCredential, options *arm.ClientOptions) (*ComplianceResultsClient, error) {
	cl, err := arm.NewClient(moduleName, moduleVersion, credential, options)
	if err != nil {
		return nil, err
	}
	client := &ComplianceResultsClient{
		internal: cl,
	}
	return client, nil
}

// Get - Security Compliance Result
// If the operation fails it returns an *azcore.ResponseError type.
//
// Generated from API version 2017-08-01
//   - resourceID - The identifier of the resource.
//   - complianceResultName - name of the desired assessment compliance result
//   - options - ComplianceResultsClientGetOptions contains the optional parameters for the ComplianceResultsClient.Get method.
func (client *ComplianceResultsClient) Get(ctx context.Context, resourceID string, complianceResultName string, options *ComplianceResultsClientGetOptions) (ComplianceResultsClientGetResponse, error) {
	var err error
	const operationName = "ComplianceResultsClient.Get"
	ctx = context.WithValue(ctx, runtime.CtxAPINameKey{}, operationName)
	ctx, endSpan := runtime.StartSpan(ctx, operationName, client.internal.Tracer(), nil)
	defer func() { endSpan(err) }()
	req, err := client.getCreateRequest(ctx, resourceID, complianceResultName, options)
	if err != nil {
		return ComplianceResultsClientGetResponse{}, err
	}
	httpResp, err := client.internal.Pipeline().Do(req)
	if err != nil {
		return ComplianceResultsClientGetResponse{}, err
	}
	if !runtime.HasStatusCode(httpResp, http.StatusOK) {
		err = runtime.NewResponseError(httpResp)
		return ComplianceResultsClientGetResponse{}, err
	}
	resp, err := client.getHandleResponse(httpResp)
	return resp, err
}

// getCreateRequest creates the Get request.
func (client *ComplianceResultsClient) getCreateRequest(ctx context.Context, resourceID string, complianceResultName string, options *ComplianceResultsClientGetOptions) (*policy.Request, error) {
	urlPath := "/{resourceId}/providers/Microsoft.Security/complianceResults/{complianceResultName}"
	urlPath = strings.ReplaceAll(urlPath, "{resourceId}", resourceID)
	if complianceResultName == "" {
		return nil, errors.New("parameter complianceResultName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{complianceResultName}", url.PathEscape(complianceResultName))
	req, err := runtime.NewRequest(ctx, http.MethodGet, runtime.JoinPaths(client.internal.Endpoint(), urlPath))
	if err != nil {
		return nil, err
	}
	reqQP := req.Raw().URL.Query()
	reqQP.Set("api-version", "2017-08-01")
	req.Raw().URL.RawQuery = reqQP.Encode()
	req.Raw().Header["Accept"] = []string{"application/json"}
	return req, nil
}

// getHandleResponse handles the Get response.
func (client *ComplianceResultsClient) getHandleResponse(resp *http.Response) (ComplianceResultsClientGetResponse, error) {
	result := ComplianceResultsClientGetResponse{}
	if err := runtime.UnmarshalAsJSON(resp, &result.ComplianceResult); err != nil {
		return ComplianceResultsClientGetResponse{}, err
	}
	return result, nil
}

// NewListPager - Security compliance results in the subscription
//
// Generated from API version 2017-08-01
//   - scope - Scope of the query, can be subscription (/subscriptions/0b06d9ea-afe6-4779-bd59-30e5c2d9d13f) or management group
//     (/providers/Microsoft.Management/managementGroups/mgName).
//   - options - ComplianceResultsClientListOptions contains the optional parameters for the ComplianceResultsClient.NewListPager
//     method.
func (client *ComplianceResultsClient) NewListPager(scope string, options *ComplianceResultsClientListOptions) *runtime.Pager[ComplianceResultsClientListResponse] {
	return runtime.NewPager(runtime.PagingHandler[ComplianceResultsClientListResponse]{
		More: func(page ComplianceResultsClientListResponse) bool {
			return page.NextLink != nil && len(*page.NextLink) > 0
		},
		Fetcher: func(ctx context.Context, page *ComplianceResultsClientListResponse) (ComplianceResultsClientListResponse, error) {
			ctx = context.WithValue(ctx, runtime.CtxAPINameKey{}, "ComplianceResultsClient.NewListPager")
			nextLink := ""
			if page != nil {
				nextLink = *page.NextLink
			}
			resp, err := runtime.FetcherForNextLink(ctx, client.internal.Pipeline(), nextLink, func(ctx context.Context) (*policy.Request, error) {
				return client.listCreateRequest(ctx, scope, options)
			}, nil)
			if err != nil {
				return ComplianceResultsClientListResponse{}, err
			}
			return client.listHandleResponse(resp)
		},
		Tracer: client.internal.Tracer(),
	})
}

// listCreateRequest creates the List request.
func (client *ComplianceResultsClient) listCreateRequest(ctx context.Context, scope string, options *ComplianceResultsClientListOptions) (*policy.Request, error) {
	urlPath := "/{scope}/providers/Microsoft.Security/complianceResults"
	urlPath = strings.ReplaceAll(urlPath, "{scope}", scope)
	req, err := runtime.NewRequest(ctx, http.MethodGet, runtime.JoinPaths(client.internal.Endpoint(), urlPath))
	if err != nil {
		return nil, err
	}
	reqQP := req.Raw().URL.Query()
	reqQP.Set("api-version", "2017-08-01")
	req.Raw().URL.RawQuery = reqQP.Encode()
	req.Raw().Header["Accept"] = []string{"application/json"}
	return req, nil
}

// listHandleResponse handles the List response.
func (client *ComplianceResultsClient) listHandleResponse(resp *http.Response) (ComplianceResultsClientListResponse, error) {
	result := ComplianceResultsClientListResponse{}
	if err := runtime.UnmarshalAsJSON(resp, &result.ComplianceResultList); err != nil {
		return ComplianceResultsClientListResponse{}, err
	}
	return result, nil
}
