//go:build go1.18
// +build go1.18

// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License. See License.txt in the project root for license information.
// Code generated by Microsoft (R) AutoRest Code Generator. DO NOT EDIT.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

package armpowerbiembedded

type AzureSKU struct {
	// REQUIRED; SKU name
	Name *AzureSKUName

	// REQUIRED; SKU tier
	Tier *AzureSKUTier
}

type CheckNameRequest struct {
	// Workspace collection name
	Name *string

	// Resource type
	Type *string
}

type CheckNameResponse struct {
	// Message indicating an unavailable name due to a conflict, or a description of the naming rules that are violated.
	Message *string

	// Specifies a Boolean value that indicates whether the specified Power BI Workspace Collection name is available to use.
	NameAvailable *bool

	// Reason why the workspace collection name cannot be used.
	Reason *CheckNameReason
}

type CreateWorkspaceCollectionRequest struct {
	// Azure location
	Location *string
	SKU      *AzureSKU

	// Dictionary of
	Tags map[string]*string
}

type Display struct {
	// The localized friendly description for the operation as shown to the user. This description should be thorough, yet concise.
	// It will be used in tool-tips and detailed views.
	Description *string

	// The localized friendly name for the operation as shown to the user. This name should be concise (to fit in drop downs),
	// but clear (self-documenting). Use Title Casing and include the entity/resource
	// to which it applies.
	Operation *string

	// The intended executor of the operation; governs the display of the operation in the RBAC UX and the audit logs UX. Default
	// value is 'user,system'
	Origin *string

	// The localized friendly form of the resource provider name. This form is also expected to include the publisher/company
	// responsible. Use Title Casing. Begin with "Microsoft" for 1st party services.
	Provider *string

	// The localized friendly form of the resource type related to this action/operation. This form should match the public documentation
	// for the resource provider. Use Title Casing. For examples, refer to
	// the "name" section.
	Resource *string
}

type Error struct {
	Code    *string
	Details []*ErrorDetail
	Message *string
	Target  *string
}

type ErrorDetail struct {
	Code    *string
	Message *string
	Target  *string
}

type MigrateWorkspaceCollectionRequest struct {
	Resources []*string

	// Name of the resource group the Power BI workspace collections will be migrated to.
	TargetResourceGroup *string
}

type Operation struct {
	Display *Display

	// The name of the operation being performed on this particular object. This name should match the action name that appears
	// in RBAC / the event service.
	Name *string
}

type OperationList struct {
	Value []*Operation
}

type UpdateWorkspaceCollectionRequest struct {
	SKU *AzureSKU

	// Dictionary of
	Tags map[string]*string
}

type Workspace struct {
	// Workspace id
	ID *string

	// Workspace name
	Name *string

	// Property bag
	Properties any

	// Resource type
	Type *string
}

type WorkspaceCollection struct {
	// Resource id
	ID *string

	// Azure location
	Location *string

	// Workspace collection name
	Name *string

	// Properties
	Properties any
	SKU        *AzureSKU

	// Dictionary of
	Tags map[string]*string

	// Resource type
	Type *string
}

type WorkspaceCollectionAccessKey struct {
	// Key name
	KeyName *AccessKeyName
}

type WorkspaceCollectionAccessKeys struct {
	// Access key 1
	Key1 *string

	// Access key 2
	Key2 *string
}

type WorkspaceCollectionList struct {
	Value []*WorkspaceCollection
}

type WorkspaceList struct {
	Value []*Workspace
}
