//go:build go1.18
// +build go1.18

// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License. See License.txt in the project root for license information.
// Code generated by Microsoft (R) AutoRest Code Generator. DO NOT EDIT.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

package fake

import (
	"context"
	"errors"
	"fmt"
	azfake "github.com/Azure/azure-sdk-for-go/sdk/azcore/fake"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore/fake/server"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore/runtime"
	"github.com/Azure/azure-sdk-for-go/sdk/resourcemanager/managementpartner/armmanagementpartner"
	"net/http"
)

// PartnersServer is a fake server for instances of the armmanagementpartner.PartnersClient type.
type PartnersServer struct {
	// Get is the fake for method PartnersClient.Get
	// HTTP status codes to indicate success: http.StatusOK
	Get func(ctx context.Context, options *armmanagementpartner.PartnersClientGetOptions) (resp azfake.Responder[armmanagementpartner.PartnersClientGetResponse], errResp azfake.ErrorResponder)
}

// NewPartnersServerTransport creates a new instance of PartnersServerTransport with the provided implementation.
// The returned PartnersServerTransport instance is connected to an instance of armmanagementpartner.PartnersClient via the
// azcore.ClientOptions.Transporter field in the client's constructor parameters.
func NewPartnersServerTransport(srv *PartnersServer) *PartnersServerTransport {
	return &PartnersServerTransport{srv: srv}
}

// PartnersServerTransport connects instances of armmanagementpartner.PartnersClient to instances of PartnersServer.
// Don't use this type directly, use NewPartnersServerTransport instead.
type PartnersServerTransport struct {
	srv *PartnersServer
}

// Do implements the policy.Transporter interface for PartnersServerTransport.
func (p *PartnersServerTransport) Do(req *http.Request) (*http.Response, error) {
	rawMethod := req.Context().Value(runtime.CtxAPINameKey{})
	method, ok := rawMethod.(string)
	if !ok {
		return nil, nonRetriableError{errors.New("unable to dispatch request, missing value for CtxAPINameKey")}
	}

	var resp *http.Response
	var err error

	switch method {
	case "PartnersClient.Get":
		resp, err = p.dispatchGet(req)
	default:
		err = fmt.Errorf("unhandled API %s", method)
	}

	if err != nil {
		return nil, err
	}

	return resp, nil
}

func (p *PartnersServerTransport) dispatchGet(req *http.Request) (*http.Response, error) {
	if p.srv.Get == nil {
		return nil, &nonRetriableError{errors.New("fake for method Get not implemented")}
	}
	respr, errRespr := p.srv.Get(req.Context(), nil)
	if respErr := server.GetError(errRespr, req); respErr != nil {
		return nil, respErr
	}
	respContent := server.GetResponseContent(respr)
	if !contains([]int{http.StatusOK}, respContent.HTTPStatus) {
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK", respContent.HTTPStatus)}
	}
	resp, err := server.MarshalResponseAsJSON(respContent, server.GetResponse(respr).PartnerResponse, req)
	if err != nil {
		return nil, err
	}
	return resp, nil
}
