//go:build go1.18
// +build go1.18

// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License. See License.txt in the project root for license information.
// Code generated by Microsoft (R) AutoRest Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.
// DO NOT EDIT.

package armengagementfabric_test

import (
	"context"
	"log"

	"github.com/Azure/azure-sdk-for-go/sdk/azcore/to"
	"github.com/Azure/azure-sdk-for-go/sdk/azidentity"
	"github.com/Azure/azure-sdk-for-go/sdk/resourcemanager/engagementfabric/armengagementfabric"
)

// Generated from example definition: https://github.com/Azure/azure-rest-api-specs/blob/163e27c0ca7570bc39e00a46f255740d9b3ba3cb/specification/engagementfabric/resource-manager/Microsoft.EngagementFabric/preview/2018-09-01/examples/AccountsGetExample.json
func ExampleAccountsClient_Get() {
	cred, err := azidentity.NewDefaultAzureCredential(nil)
	if err != nil {
		log.Fatalf("failed to obtain a credential: %v", err)
	}
	ctx := context.Background()
	clientFactory, err := armengagementfabric.NewClientFactory("<subscription-id>", cred, nil)
	if err != nil {
		log.Fatalf("failed to create client: %v", err)
	}
	res, err := clientFactory.NewAccountsClient().Get(ctx, "ExampleRg", "ExampleAccount", nil)
	if err != nil {
		log.Fatalf("failed to finish the request: %v", err)
	}
	// You could use response here. We use blank identifier for just demo purposes.
	_ = res
	// If the HTTP response code is 200 as defined in example definition, your response structure would look as follows. Please pay attention that all the values in the output are fake values for just demo purposes.
	// res.Account = armengagementfabric.Account{
	// 	Name: to.Ptr("ExampleAccount"),
	// 	Type: to.Ptr("Microsoft.EngagementFabric/Accounts"),
	// 	ID: to.Ptr("subscriptions/EDBF0095-A524-4A84-95FB-F72DA41AA6A1/resourceGroups/ExampleRg/providers/Microsoft.EngagementFabric/Accounts/ExampleAccount"),
	// 	Location: to.Ptr("WestUS"),
	// 	SKU: &armengagementfabric.SKU{
	// 		Name: to.Ptr("B1"),
	// 		Tier: to.Ptr("Basic"),
	// 	},
	// }
}

// Generated from example definition: https://github.com/Azure/azure-rest-api-specs/blob/163e27c0ca7570bc39e00a46f255740d9b3ba3cb/specification/engagementfabric/resource-manager/Microsoft.EngagementFabric/preview/2018-09-01/examples/AccountsCreateOrUpdateExample.json
func ExampleAccountsClient_CreateOrUpdate() {
	cred, err := azidentity.NewDefaultAzureCredential(nil)
	if err != nil {
		log.Fatalf("failed to obtain a credential: %v", err)
	}
	ctx := context.Background()
	clientFactory, err := armengagementfabric.NewClientFactory("<subscription-id>", cred, nil)
	if err != nil {
		log.Fatalf("failed to create client: %v", err)
	}
	res, err := clientFactory.NewAccountsClient().CreateOrUpdate(ctx, "ExampleRg", "ExampleAccount", armengagementfabric.Account{
		Location: to.Ptr("WestUS"),
		SKU: &armengagementfabric.SKU{
			Name: to.Ptr("B1"),
		},
	}, nil)
	if err != nil {
		log.Fatalf("failed to finish the request: %v", err)
	}
	// You could use response here. We use blank identifier for just demo purposes.
	_ = res
	// If the HTTP response code is 200 as defined in example definition, your response structure would look as follows. Please pay attention that all the values in the output are fake values for just demo purposes.
	// res.Account = armengagementfabric.Account{
	// 	Name: to.Ptr("ExampleAccount"),
	// 	Type: to.Ptr("Microsoft.EngagementFabric/Accounts"),
	// 	ID: to.Ptr("subscriptions/EDBF0095-A524-4A84-95FB-F72DA41AA6A1/resourceGroups/ExampleRg/providers/Microsoft.EngagementFabric/Accounts/ExampleAccount"),
	// 	Location: to.Ptr("WestUS"),
	// 	SKU: &armengagementfabric.SKU{
	// 		Name: to.Ptr("B1"),
	// 		Tier: to.Ptr("Basic"),
	// 	},
	// }
}

// Generated from example definition: https://github.com/Azure/azure-rest-api-specs/blob/163e27c0ca7570bc39e00a46f255740d9b3ba3cb/specification/engagementfabric/resource-manager/Microsoft.EngagementFabric/preview/2018-09-01/examples/AccountsDeleteExample.json
func ExampleAccountsClient_Delete() {
	cred, err := azidentity.NewDefaultAzureCredential(nil)
	if err != nil {
		log.Fatalf("failed to obtain a credential: %v", err)
	}
	ctx := context.Background()
	clientFactory, err := armengagementfabric.NewClientFactory("<subscription-id>", cred, nil)
	if err != nil {
		log.Fatalf("failed to create client: %v", err)
	}
	_, err = clientFactory.NewAccountsClient().Delete(ctx, "ExampleRg", "ExampleAccount", nil)
	if err != nil {
		log.Fatalf("failed to finish the request: %v", err)
	}
}

// Generated from example definition: https://github.com/Azure/azure-rest-api-specs/blob/163e27c0ca7570bc39e00a46f255740d9b3ba3cb/specification/engagementfabric/resource-manager/Microsoft.EngagementFabric/preview/2018-09-01/examples/AccountsUpdateExample.json
func ExampleAccountsClient_Update() {
	cred, err := azidentity.NewDefaultAzureCredential(nil)
	if err != nil {
		log.Fatalf("failed to obtain a credential: %v", err)
	}
	ctx := context.Background()
	clientFactory, err := armengagementfabric.NewClientFactory("<subscription-id>", cred, nil)
	if err != nil {
		log.Fatalf("failed to create client: %v", err)
	}
	res, err := clientFactory.NewAccountsClient().Update(ctx, "ExampleRg", "ExampleAccount", armengagementfabric.AccountPatch{
		Tags: map[string]*string{
			"tagName": to.Ptr("tagValue"),
		},
	}, nil)
	if err != nil {
		log.Fatalf("failed to finish the request: %v", err)
	}
	// You could use response here. We use blank identifier for just demo purposes.
	_ = res
	// If the HTTP response code is 200 as defined in example definition, your response structure would look as follows. Please pay attention that all the values in the output are fake values for just demo purposes.
	// res.Account = armengagementfabric.Account{
	// 	Name: to.Ptr("ExampleAccount"),
	// 	Type: to.Ptr("Microsoft.EngagementFabric/Accounts"),
	// 	ID: to.Ptr("subscriptions/EDBF0095-A524-4A84-95FB-F72DA41AA6A1/resourceGroups/ExampleRg/providers/Microsoft.EngagementFabric/Accounts/ExampleAccount"),
	// 	Location: to.Ptr("WestUS"),
	// 	SKU: &armengagementfabric.SKU{
	// 		Name: to.Ptr("B1"),
	// 		Tier: to.Ptr("Basic"),
	// 	},
	// 	Tags: map[string]*string{
	// 		"tagName": to.Ptr("tagValue"),
	// 	},
	// }
}

// Generated from example definition: https://github.com/Azure/azure-rest-api-specs/blob/163e27c0ca7570bc39e00a46f255740d9b3ba3cb/specification/engagementfabric/resource-manager/Microsoft.EngagementFabric/preview/2018-09-01/examples/AccountsListExample.json
func ExampleAccountsClient_NewListPager() {
	cred, err := azidentity.NewDefaultAzureCredential(nil)
	if err != nil {
		log.Fatalf("failed to obtain a credential: %v", err)
	}
	ctx := context.Background()
	clientFactory, err := armengagementfabric.NewClientFactory("<subscription-id>", cred, nil)
	if err != nil {
		log.Fatalf("failed to create client: %v", err)
	}
	pager := clientFactory.NewAccountsClient().NewListPager(nil)
	for pager.More() {
		page, err := pager.NextPage(ctx)
		if err != nil {
			log.Fatalf("failed to advance page: %v", err)
		}
		for _, v := range page.Value {
			// You could use page here. We use blank identifier for just demo purposes.
			_ = v
		}
		// If the HTTP response code is 200 as defined in example definition, your page structure would look as follows. Please pay attention that all the values in the output are fake values for just demo purposes.
		// page.AccountList = armengagementfabric.AccountList{
		// 	Value: []*armengagementfabric.Account{
		// 		{
		// 			Name: to.Ptr("ExampleAccount"),
		// 			Type: to.Ptr("Microsoft.EngagementFabric/Accounts"),
		// 			ID: to.Ptr("subscriptions/EDBF0095-A524-4A84-95FB-F72DA41AA6A1/resourceGroups/ExampleRg/providers/Microsoft.EngagementFabric/Accounts/ExampleAccount"),
		// 			Location: to.Ptr("WestUS"),
		// 			SKU: &armengagementfabric.SKU{
		// 				Name: to.Ptr("B1"),
		// 				Tier: to.Ptr("Basic"),
		// 			},
		// 		},
		// 		{
		// 			Name: to.Ptr("ExampleAccount2"),
		// 			Type: to.Ptr("Microsoft.EngagementFabric/Accounts"),
		// 			ID: to.Ptr("subscriptions/EDBF0095-A524-4A84-95FB-F72DA41AA6A1/resourceGroups/ExampleRg/providers/Microsoft.EngagementFabric/Accounts/ExampleAccount2"),
		// 			Location: to.Ptr("WestUS"),
		// 			SKU: &armengagementfabric.SKU{
		// 				Name: to.Ptr("S1"),
		// 				Tier: to.Ptr("Standard"),
		// 			},
		// 		},
		// 		{
		// 			Name: to.Ptr("ExampleAccount3"),
		// 			Type: to.Ptr("Microsoft.EngagementFabric/Accounts"),
		// 			ID: to.Ptr("subscriptions/EDBF0095-A524-4A84-95FB-F72DA41AA6A1/resourceGroups/ExampleRg/providers/Microsoft.EngagementFabric/Accounts/ExampleAccount3"),
		// 			Location: to.Ptr("WestUS"),
		// 			SKU: &armengagementfabric.SKU{
		// 				Name: to.Ptr("P1"),
		// 				Tier: to.Ptr("Premium"),
		// 			},
		// 	}},
		// }
	}
}

// Generated from example definition: https://github.com/Azure/azure-rest-api-specs/blob/163e27c0ca7570bc39e00a46f255740d9b3ba3cb/specification/engagementfabric/resource-manager/Microsoft.EngagementFabric/preview/2018-09-01/examples/AccountsListByResourceGroupExample.json
func ExampleAccountsClient_NewListByResourceGroupPager() {
	cred, err := azidentity.NewDefaultAzureCredential(nil)
	if err != nil {
		log.Fatalf("failed to obtain a credential: %v", err)
	}
	ctx := context.Background()
	clientFactory, err := armengagementfabric.NewClientFactory("<subscription-id>", cred, nil)
	if err != nil {
		log.Fatalf("failed to create client: %v", err)
	}
	pager := clientFactory.NewAccountsClient().NewListByResourceGroupPager("ExampleRg", nil)
	for pager.More() {
		page, err := pager.NextPage(ctx)
		if err != nil {
			log.Fatalf("failed to advance page: %v", err)
		}
		for _, v := range page.Value {
			// You could use page here. We use blank identifier for just demo purposes.
			_ = v
		}
		// If the HTTP response code is 200 as defined in example definition, your page structure would look as follows. Please pay attention that all the values in the output are fake values for just demo purposes.
		// page.AccountList = armengagementfabric.AccountList{
		// 	Value: []*armengagementfabric.Account{
		// 		{
		// 			Name: to.Ptr("ExampleAccount"),
		// 			Type: to.Ptr("Microsoft.EngagementFabric/Accounts"),
		// 			ID: to.Ptr("subscriptions/EDBF0095-A524-4A84-95FB-F72DA41AA6A1/resourceGroups/ExampleRg/providers/Microsoft.EngagementFabric/Accounts/ExampleAccount"),
		// 			Location: to.Ptr("WestUS"),
		// 			SKU: &armengagementfabric.SKU{
		// 				Name: to.Ptr("B1"),
		// 				Tier: to.Ptr("Basic"),
		// 			},
		// 		},
		// 		{
		// 			Name: to.Ptr("ExampleAccount2"),
		// 			Type: to.Ptr("Microsoft.EngagementFabric/Accounts"),
		// 			ID: to.Ptr("subscriptions/EDBF0095-A524-4A84-95FB-F72DA41AA6A1/resourceGroups/ExampleRg/providers/Microsoft.EngagementFabric/Accounts/ExampleAccount2"),
		// 			Location: to.Ptr("WestUS"),
		// 			SKU: &armengagementfabric.SKU{
		// 				Name: to.Ptr("S1"),
		// 				Tier: to.Ptr("Standard"),
		// 			},
		// 		},
		// 		{
		// 			Name: to.Ptr("ExampleAccount3"),
		// 			Type: to.Ptr("Microsoft.EngagementFabric/Accounts"),
		// 			ID: to.Ptr("subscriptions/EDBF0095-A524-4A84-95FB-F72DA41AA6A1/resourceGroups/ExampleRg/providers/Microsoft.EngagementFabric/Accounts/ExampleAccount3"),
		// 			Location: to.Ptr("WestUS"),
		// 			SKU: &armengagementfabric.SKU{
		// 				Name: to.Ptr("P1"),
		// 				Tier: to.Ptr("Premium"),
		// 			},
		// 	}},
		// }
	}
}

// Generated from example definition: https://github.com/Azure/azure-rest-api-specs/blob/163e27c0ca7570bc39e00a46f255740d9b3ba3cb/specification/engagementfabric/resource-manager/Microsoft.EngagementFabric/preview/2018-09-01/examples/AccountsListKeysExample.json
func ExampleAccountsClient_NewListKeysPager() {
	cred, err := azidentity.NewDefaultAzureCredential(nil)
	if err != nil {
		log.Fatalf("failed to obtain a credential: %v", err)
	}
	ctx := context.Background()
	clientFactory, err := armengagementfabric.NewClientFactory("<subscription-id>", cred, nil)
	if err != nil {
		log.Fatalf("failed to create client: %v", err)
	}
	pager := clientFactory.NewAccountsClient().NewListKeysPager("ExampleRg", "ExampleAccount", nil)
	for pager.More() {
		page, err := pager.NextPage(ctx)
		if err != nil {
			log.Fatalf("failed to advance page: %v", err)
		}
		for _, v := range page.Value {
			// You could use page here. We use blank identifier for just demo purposes.
			_ = v
		}
		// If the HTTP response code is 200 as defined in example definition, your page structure would look as follows. Please pay attention that all the values in the output are fake values for just demo purposes.
		// page.KeyDescriptionList = armengagementfabric.KeyDescriptionList{
		// 	Value: []*armengagementfabric.KeyDescription{
		// 		{
		// 			Name: to.Ptr("Full"),
		// 			Rank: to.Ptr(armengagementfabric.KeyRankPrimaryKey),
		// 			Value: to.Ptr("<ExampleFullPrimaryKeyValue>"),
		// 		},
		// 		{
		// 			Name: to.Ptr("Full"),
		// 			Rank: to.Ptr(armengagementfabric.KeyRankSecondaryKey),
		// 			Value: to.Ptr("<ExampleFullSecondaryKeyValue>"),
		// 		},
		// 		{
		// 			Name: to.Ptr("Device"),
		// 			Rank: to.Ptr(armengagementfabric.KeyRankPrimaryKey),
		// 			Value: to.Ptr("<ExampleDevicePrimaryKeyValue>"),
		// 		},
		// 		{
		// 			Name: to.Ptr("Device"),
		// 			Rank: to.Ptr(armengagementfabric.KeyRankSecondaryKey),
		// 			Value: to.Ptr("<ExampleDeviceSecondaryKeyValue>"),
		// 	}},
		// }
	}
}

// Generated from example definition: https://github.com/Azure/azure-rest-api-specs/blob/163e27c0ca7570bc39e00a46f255740d9b3ba3cb/specification/engagementfabric/resource-manager/Microsoft.EngagementFabric/preview/2018-09-01/examples/AccountsRegenerateKeyExample.json
func ExampleAccountsClient_RegenerateKey() {
	cred, err := azidentity.NewDefaultAzureCredential(nil)
	if err != nil {
		log.Fatalf("failed to obtain a credential: %v", err)
	}
	ctx := context.Background()
	clientFactory, err := armengagementfabric.NewClientFactory("<subscription-id>", cred, nil)
	if err != nil {
		log.Fatalf("failed to create client: %v", err)
	}
	res, err := clientFactory.NewAccountsClient().RegenerateKey(ctx, "ExampleRg", "ExampleAccount", armengagementfabric.RegenerateKeyParameter{}, nil)
	if err != nil {
		log.Fatalf("failed to finish the request: %v", err)
	}
	// You could use response here. We use blank identifier for just demo purposes.
	_ = res
	// If the HTTP response code is 200 as defined in example definition, your response structure would look as follows. Please pay attention that all the values in the output are fake values for just demo purposes.
	// res.KeyDescription = armengagementfabric.KeyDescription{
	// 	Name: to.Ptr("Full"),
	// 	Rank: to.Ptr(armengagementfabric.KeyRankPrimaryKey),
	// 	Value: to.Ptr("<ExampleFullPrimaryKeyValue>"),
	// }
}

// Generated from example definition: https://github.com/Azure/azure-rest-api-specs/blob/163e27c0ca7570bc39e00a46f255740d9b3ba3cb/specification/engagementfabric/resource-manager/Microsoft.EngagementFabric/preview/2018-09-01/examples/AccountsListChannelTypesExample.json
func ExampleAccountsClient_ListChannelTypes() {
	cred, err := azidentity.NewDefaultAzureCredential(nil)
	if err != nil {
		log.Fatalf("failed to obtain a credential: %v", err)
	}
	ctx := context.Background()
	clientFactory, err := armengagementfabric.NewClientFactory("<subscription-id>", cred, nil)
	if err != nil {
		log.Fatalf("failed to create client: %v", err)
	}
	res, err := clientFactory.NewAccountsClient().ListChannelTypes(ctx, "ExampleRg", "ExampleAccount", nil)
	if err != nil {
		log.Fatalf("failed to finish the request: %v", err)
	}
	// You could use response here. We use blank identifier for just demo purposes.
	_ = res
	// If the HTTP response code is 200 as defined in example definition, your response structure would look as follows. Please pay attention that all the values in the output are fake values for just demo purposes.
	// res.ChannelTypeDescriptionList = armengagementfabric.ChannelTypeDescriptionList{
	// 	Value: []*armengagementfabric.ChannelTypeDescription{
	// 		{
	// 			ChannelDescription: to.Ptr("Description of mockChannel1"),
	// 			ChannelFunctions: []*string{
	// 				to.Ptr("MockFunction1"),
	// 				to.Ptr("MockFunction2")},
	// 				ChannelType: to.Ptr("MockChannel1"),
	// 			},
	// 			{
	// 				ChannelDescription: to.Ptr("Description of mockChannel2"),
	// 				ChannelFunctions: []*string{
	// 					to.Ptr("MockFunction1"),
	// 					to.Ptr("MockFunction3")},
	// 					ChannelType: to.Ptr("MockChannel2"),
	// 				},
	// 				{
	// 					ChannelDescription: to.Ptr("Description of mockChannel3"),
	// 					ChannelFunctions: []*string{
	// 						to.Ptr("MockFunction1"),
	// 						to.Ptr("MockFunction2"),
	// 						to.Ptr("MockFunction3")},
	// 						ChannelType: to.Ptr("MockChannel3"),
	// 				}},
	// 			}
}
