//go:build go1.18
// +build go1.18

// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License. See License.txt in the project root for license information.
// Code generated by Microsoft (R) AutoRest Code Generator. DO NOT EDIT.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

package fake

import (
	"errors"
	"fmt"
	azfake "github.com/Azure/azure-sdk-for-go/sdk/azcore/fake"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore/fake/server"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore/runtime"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore/to"
	"github.com/Azure/azure-sdk-for-go/sdk/resourcemanager/datafactory/armdatafactory/v4"
	"net/http"
	"net/url"
	"regexp"
)

// PrivateEndPointConnectionsServer is a fake server for instances of the armdatafactory.PrivateEndPointConnectionsClient type.
type PrivateEndPointConnectionsServer struct {
	// NewListByFactoryPager is the fake for method PrivateEndPointConnectionsClient.NewListByFactoryPager
	// HTTP status codes to indicate success: http.StatusOK
	NewListByFactoryPager func(resourceGroupName string, factoryName string, options *armdatafactory.PrivateEndPointConnectionsClientListByFactoryOptions) (resp azfake.PagerResponder[armdatafactory.PrivateEndPointConnectionsClientListByFactoryResponse])
}

// NewPrivateEndPointConnectionsServerTransport creates a new instance of PrivateEndPointConnectionsServerTransport with the provided implementation.
// The returned PrivateEndPointConnectionsServerTransport instance is connected to an instance of armdatafactory.PrivateEndPointConnectionsClient via the
// azcore.ClientOptions.Transporter field in the client's constructor parameters.
func NewPrivateEndPointConnectionsServerTransport(srv *PrivateEndPointConnectionsServer) *PrivateEndPointConnectionsServerTransport {
	return &PrivateEndPointConnectionsServerTransport{
		srv:                   srv,
		newListByFactoryPager: newTracker[azfake.PagerResponder[armdatafactory.PrivateEndPointConnectionsClientListByFactoryResponse]](),
	}
}

// PrivateEndPointConnectionsServerTransport connects instances of armdatafactory.PrivateEndPointConnectionsClient to instances of PrivateEndPointConnectionsServer.
// Don't use this type directly, use NewPrivateEndPointConnectionsServerTransport instead.
type PrivateEndPointConnectionsServerTransport struct {
	srv                   *PrivateEndPointConnectionsServer
	newListByFactoryPager *tracker[azfake.PagerResponder[armdatafactory.PrivateEndPointConnectionsClientListByFactoryResponse]]
}

// Do implements the policy.Transporter interface for PrivateEndPointConnectionsServerTransport.
func (p *PrivateEndPointConnectionsServerTransport) Do(req *http.Request) (*http.Response, error) {
	rawMethod := req.Context().Value(runtime.CtxAPINameKey{})
	method, ok := rawMethod.(string)
	if !ok {
		return nil, nonRetriableError{errors.New("unable to dispatch request, missing value for CtxAPINameKey")}
	}

	var resp *http.Response
	var err error

	switch method {
	case "PrivateEndPointConnectionsClient.NewListByFactoryPager":
		resp, err = p.dispatchNewListByFactoryPager(req)
	default:
		err = fmt.Errorf("unhandled API %s", method)
	}

	if err != nil {
		return nil, err
	}

	return resp, nil
}

func (p *PrivateEndPointConnectionsServerTransport) dispatchNewListByFactoryPager(req *http.Request) (*http.Response, error) {
	if p.srv.NewListByFactoryPager == nil {
		return nil, &nonRetriableError{errors.New("fake for method NewListByFactoryPager not implemented")}
	}
	newListByFactoryPager := p.newListByFactoryPager.get(req)
	if newListByFactoryPager == nil {
		const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/resourceGroups/(?P<resourceGroupName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.DataFactory/factories/(?P<factoryName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/privateEndPointConnections`
		regex := regexp.MustCompile(regexStr)
		matches := regex.FindStringSubmatch(req.URL.EscapedPath())
		if matches == nil || len(matches) < 3 {
			return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
		}
		resourceGroupNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("resourceGroupName")])
		if err != nil {
			return nil, err
		}
		factoryNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("factoryName")])
		if err != nil {
			return nil, err
		}
		resp := p.srv.NewListByFactoryPager(resourceGroupNameParam, factoryNameParam, nil)
		newListByFactoryPager = &resp
		p.newListByFactoryPager.add(req, newListByFactoryPager)
		server.PagerResponderInjectNextLinks(newListByFactoryPager, req, func(page *armdatafactory.PrivateEndPointConnectionsClientListByFactoryResponse, createLink func() string) {
			page.NextLink = to.Ptr(createLink())
		})
	}
	resp, err := server.PagerResponderNext(newListByFactoryPager, req)
	if err != nil {
		return nil, err
	}
	if !contains([]int{http.StatusOK}, resp.StatusCode) {
		p.newListByFactoryPager.remove(req)
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK", resp.StatusCode)}
	}
	if !server.PagerResponderMore(newListByFactoryPager) {
		p.newListByFactoryPager.remove(req)
	}
	return resp, nil
}
