//go:build go1.18
// +build go1.18

// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License. See License.txt in the project root for license information.
// Code generated by Microsoft (R) AutoRest Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.
// DO NOT EDIT.

package armcommunication_test

import (
	"context"
	"log"

	"github.com/Azure/azure-sdk-for-go/sdk/azcore/to"
	"github.com/Azure/azure-sdk-for-go/sdk/azidentity"
	"github.com/Azure/azure-sdk-for-go/sdk/resourcemanager/communication/armcommunication/v2"
)

// Generated from example definition: https://github.com/Azure/azure-rest-api-specs/blob/bf204aab860f2eb58a9d346b00d44760f2a9b0a2/specification/communication/resource-manager/Microsoft.Communication/preview/2023-06-01-preview/examples/suppressionLists/getAddresses.json
func ExampleSuppressionListAddressesClient_NewListPager() {
	cred, err := azidentity.NewDefaultAzureCredential(nil)
	if err != nil {
		log.Fatalf("failed to obtain a credential: %v", err)
	}
	ctx := context.Background()
	clientFactory, err := armcommunication.NewClientFactory("<subscription-id>", cred, nil)
	if err != nil {
		log.Fatalf("failed to create client: %v", err)
	}
	pager := clientFactory.NewSuppressionListAddressesClient().NewListPager("contosoResourceGroup", "contosoEmailService", "contoso.com", "aaaa1111-bbbb-2222-3333-aaaa11112222", nil)
	for pager.More() {
		page, err := pager.NextPage(ctx)
		if err != nil {
			log.Fatalf("failed to advance page: %v", err)
		}
		for _, v := range page.Value {
			// You could use page here. We use blank identifier for just demo purposes.
			_ = v
		}
		// If the HTTP response code is 200 as defined in example definition, your page structure would look as follows. Please pay attention that all the values in the output are fake values for just demo purposes.
		// page.SuppressionListAddressResourceCollection = armcommunication.SuppressionListAddressResourceCollection{
		// 	Value: []*armcommunication.SuppressionListAddressResource{
		// 		{
		// 			Name: to.Ptr("11112222-3333-4444-5555-aaaabbbbcccc"),
		// 			Type: to.Ptr("Microsoft.Communication/EmailServices/Domains/SuppressionLists/SuppressionListAddresses"),
		// 			ID: to.Ptr("/subscriptions/11112222-3333-4444-5555-666677778888/resourceGroups/contosoResourceGroup/providers/Microsoft.Communication/EmailServices/contosoEmailService/Domains/contoso.com/suppressionLists/aaaa1111-bbbb-2222-3333-aaaa11112222/suppressionListAddresses/11112222-3333-4444-5555-aaaabbbbcccc"),
		// 			Properties: &armcommunication.SuppressionListAddressProperties{
		// 				Email: to.Ptr("abc@fabrikam.com"),
		// 				FirstName: to.Ptr("firstName"),
		// 				LastModified: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2023-06-24T01:06:26.100Z"); return t}()),
		// 				LastName: to.Ptr("lastName"),
		// 				Notes: to.Ptr("This user was added as a test."),
		// 			},
		// 		},
		// 		{
		// 			Name: to.Ptr("abababab-3333-4444-5555-aaaabbbbcccc"),
		// 			Type: to.Ptr("Microsoft.Communication/EmailServices/Domains/SuppressionLists/SuppressionListAddresses"),
		// 			ID: to.Ptr("/subscriptions/11112222-3333-4444-5555-666677778888/resourceGroups/contosoResourceGroup/providers/Microsoft.Communication/EmailServices/contosoEmailService/Domains/contoso.com/suppressionLists/aaaa1111-bbbb-2222-3333-aaaa11112222/suppressionListAddresses/abababab-3333-4444-5555-aaaabbbbcccc"),
		// 			Properties: &armcommunication.SuppressionListAddressProperties{
		// 				Email: to.Ptr("user@contoso.com"),
		// 				FirstName: to.Ptr("firstName"),
		// 				LastModified: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2023-06-24T01:06:26.100Z"); return t}()),
		// 				LastName: to.Ptr("lastName"),
		// 				Notes: to.Ptr("This user was added as a test."),
		// 			},
		// 	}},
		// }
	}
}

// Generated from example definition: https://github.com/Azure/azure-rest-api-specs/blob/bf204aab860f2eb58a9d346b00d44760f2a9b0a2/specification/communication/resource-manager/Microsoft.Communication/preview/2023-06-01-preview/examples/suppressionLists/getAddress.json
func ExampleSuppressionListAddressesClient_Get() {
	cred, err := azidentity.NewDefaultAzureCredential(nil)
	if err != nil {
		log.Fatalf("failed to obtain a credential: %v", err)
	}
	ctx := context.Background()
	clientFactory, err := armcommunication.NewClientFactory("<subscription-id>", cred, nil)
	if err != nil {
		log.Fatalf("failed to create client: %v", err)
	}
	res, err := clientFactory.NewSuppressionListAddressesClient().Get(ctx, "contosoResourceGroup", "contosoEmailService", "contoso.com", "aaaa1111-bbbb-2222-3333-aaaa11112222", "11112222-3333-4444-5555-aaaabbbbcccc", nil)
	if err != nil {
		log.Fatalf("failed to finish the request: %v", err)
	}
	// You could use response here. We use blank identifier for just demo purposes.
	_ = res
	// If the HTTP response code is 200 as defined in example definition, your response structure would look as follows. Please pay attention that all the values in the output are fake values for just demo purposes.
	// res.SuppressionListAddressResource = armcommunication.SuppressionListAddressResource{
	// 	Name: to.Ptr("11112222-3333-4444-5555-aaaabbbbcccc"),
	// 	Type: to.Ptr("Microsoft.Communication/EmailServices/Domains/SuppressionLists/SuppressionListAddresses"),
	// 	ID: to.Ptr("/subscriptions/11112222-3333-4444-5555-666677778888/resourceGroups/contosoResourceGroup/providers/Microsoft.Communication/EmailServices/contosoEmailService/Domains/contoso.com/suppressionLists/aaaa1111-bbbb-2222-3333-aaaa11112222/suppressionListAddresses/11112222-3333-4444-5555-aaaabbbbcccc"),
	// 	Properties: &armcommunication.SuppressionListAddressProperties{
	// 		Email: to.Ptr("newuser1@fabrikam.com"),
	// 		FirstName: to.Ptr("updatedFirstName"),
	// 		LastModified: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2023-06-24T01:06:26.100Z"); return t}()),
	// 		LastName: to.Ptr("lastName"),
	// 		Notes: to.Ptr("This user was added as a test."),
	// 	},
	// }
}

// Generated from example definition: https://github.com/Azure/azure-rest-api-specs/blob/bf204aab860f2eb58a9d346b00d44760f2a9b0a2/specification/communication/resource-manager/Microsoft.Communication/preview/2023-06-01-preview/examples/suppressionLists/createOrUpdateAddress.json
func ExampleSuppressionListAddressesClient_CreateOrUpdate() {
	cred, err := azidentity.NewDefaultAzureCredential(nil)
	if err != nil {
		log.Fatalf("failed to obtain a credential: %v", err)
	}
	ctx := context.Background()
	clientFactory, err := armcommunication.NewClientFactory("<subscription-id>", cred, nil)
	if err != nil {
		log.Fatalf("failed to create client: %v", err)
	}
	res, err := clientFactory.NewSuppressionListAddressesClient().CreateOrUpdate(ctx, "contosoResourceGroup", "contosoEmailService", "contoso.com", "aaaa1111-bbbb-2222-3333-aaaa11112222", "11112222-3333-4444-5555-aaaabbbbcccc", armcommunication.SuppressionListAddressResource{
		Properties: &armcommunication.SuppressionListAddressProperties{
			Email:     to.Ptr("newuser1@fabrikam.com"),
			FirstName: to.Ptr("updatedFirstName"),
		},
	}, nil)
	if err != nil {
		log.Fatalf("failed to finish the request: %v", err)
	}
	// You could use response here. We use blank identifier for just demo purposes.
	_ = res
	// If the HTTP response code is 200 as defined in example definition, your response structure would look as follows. Please pay attention that all the values in the output are fake values for just demo purposes.
	// res.SuppressionListAddressResource = armcommunication.SuppressionListAddressResource{
	// 	Name: to.Ptr("11112222-3333-4444-5555-aaaabbbbcccc"),
	// 	Type: to.Ptr("Microsoft.Communication/EmailServices/Domains/SuppressionLists/SuppressionListAddresses"),
	// 	ID: to.Ptr("/subscriptions/11112222-3333-4444-5555-666677778888/resourceGroups/contosoResourceGroup/providers/Microsoft.Communication/EmailServices/contosoEmailService/Domains/contoso.com/suppressionLists/aaaa1111-bbbb-2222-3333-aaaa11112222/suppressionListAddresses/11112222-3333-4444-5555-aaaabbbbcccc"),
	// 	Properties: &armcommunication.SuppressionListAddressProperties{
	// 		Email: to.Ptr("newuser1@fabrikam.com"),
	// 		FirstName: to.Ptr("updatedFirstName"),
	// 		LastModified: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2023-06-24T01:06:26.100Z"); return t}()),
	// 		LastName: to.Ptr("lastName"),
	// 		Notes: to.Ptr("This user was added as a test."),
	// 	},
	// }
}

// Generated from example definition: https://github.com/Azure/azure-rest-api-specs/blob/bf204aab860f2eb58a9d346b00d44760f2a9b0a2/specification/communication/resource-manager/Microsoft.Communication/preview/2023-06-01-preview/examples/suppressionLists/deleteAddress.json
func ExampleSuppressionListAddressesClient_Delete() {
	cred, err := azidentity.NewDefaultAzureCredential(nil)
	if err != nil {
		log.Fatalf("failed to obtain a credential: %v", err)
	}
	ctx := context.Background()
	clientFactory, err := armcommunication.NewClientFactory("<subscription-id>", cred, nil)
	if err != nil {
		log.Fatalf("failed to create client: %v", err)
	}
	_, err = clientFactory.NewSuppressionListAddressesClient().Delete(ctx, "MyResourceGroup", "MyEmailServiceResource", "mydomain.com", "aaaa1111-bbbb-2222-3333-aaaa11112222", "11112222-3333-4444-5555-999999999999", nil)
	if err != nil {
		log.Fatalf("failed to finish the request: %v", err)
	}
}
