# Contributing to stdarch

The `stdarch` crate is more than willing to accept contributions! First you'll
probably want to check out the repository and make sure that tests pass for you:

```
$ git clone https://github.com/rust-lang/stdarch
$ cd stdarch
$ cargo +nightly test
```

To run codegen tests, run in release mode:

```
$ cargo +nightly test --release -p coresimd
```

Remember that this repository requires the nightly channel of Rust! If any of
the above steps don't work, [please let us know][new]!

Next up you can [find an issue][issues] to help out on, we've selected a few
with the [`help wanted`][help] and [`impl-period`][impl] tags which could
particularly use some help. You may be most interested in [#40][vendor],
implementing all vendor intrinsics on x86. That issue's got some good pointers
about where to get started!

If you've got general questions feel free to [join us on gitter][gitter] and ask
around! Feel free to ping either @BurntSushi or @alexcrichton with questions.

[gitter]: https://gitter.im/rust-impl-period/WG-libs-simd

# How to write examples for stdarch intrinsics

There are a few features that must be enabled for the given intrinsic to work
properly and the example must only be run by `cargo test --doc` when the feature
is supported by the CPU. As a result, the default `fn main` that is generated by
`rustdoc` will not work (in most cases). Consider using the following as a guide
to ensure your example works as expected.

```rust
/// # // We need cfg_target_feature to ensure the example is only
/// # // run by `cargo test --doc` when the CPU supports the feature
/// # #![feature(cfg_target_feature)]
/// # // We need target_feature for the intrinsic to work
/// # #![feature(target_feature)]
/// #
/// # // rustdoc by default uses `extern crate stdarch`, but we need the
/// # // `#[macro_use]`
/// # #[macro_use] extern crate stdarch;
/// #
/// # // The real main function
/// # fn main() {
/// #     // Only run this if `<target feature>` is supported
/// #     if cfg_feature_enabled!("<target feature>") {
/// #         // Create a `worker` function that will only be run if the target feature
/// #         // is supported and ensure that `target_feature` is enabled for your worker
/// #         // function
/// #         #[target_feature(enable = "<target feature>")]
/// #         unsafe fn worker() {
///
/// // Write your example here. Feature specific intrinsics will work here! Go wild!
///
/// #         }
/// #         unsafe { worker(); }
/// #     }
/// # }
```

If some of the above syntax does not look familiar, the [Documentation as tests] section
of the [Rust Book] describes the `rustdoc` syntax quite well. As always, feel free
to [join us on gitter][gitter] and ask us if you hit any snags, and thank you for helping
to improve the documentation of `stdarch`!

[new]: https://github.com/rust-lang/stdarch/issues/new
[issues]: https://github.com/rust-lang/stdarch/issues
[help]: https://github.com/rust-lang/stdarch/issues?q=is%3Aissue+is%3Aopen+label%3A%22help+wanted%22
[impl]: https://github.com/rust-lang/stdarch/issues?q=is%3Aissue+is%3Aopen+label%3Aimpl-period
[vendor]: https://github.com/rust-lang/stdarch/issues/40
[Documentation as tests]: https://doc.rust-lang.org/book/first-edition/documentation.html#documentation-as-tests
[Rust Book]: https://doc.rust-lang.org/book/first-edition
