import { OtGlyph } from "@ot-builder/ot-glyphs";
import { Data } from "@ot-builder/prelude";
export declare class GlyphClassifier {
    private gOrd;
    constructor(gOrd: Data.Order<OtGlyph>);
    cache: WeakMap<OtGlyph, SpaceGlyph>;
    private classifyImpl;
    classify(g: OtGlyph): SpaceGlyph;
}
export declare class SpaceGlyph {
    protected gid: number;
    hm: OtGlyph.Metric;
    vm: OtGlyph.Metric;
    constructor(gid: number, hm: OtGlyph.Metric, vm: OtGlyph.Metric);
    getStatData(): OtGlyph.Stat.ComplexGlyphStat;
    stat(sink: OtGlyph.Stat.Sink): void;
}
export declare class SimpleGlyph extends SpaceGlyph {
    outlines: OtGlyph.ContourSet[];
    instructions: Buffer;
    constructor(gid: number, hm: OtGlyph.Metric, vm: OtGlyph.Metric, outlines: OtGlyph.ContourSet[], instructions: Buffer);
    private st;
    getStatData(): OtGlyph.Stat.ComplexGlyphStat;
    stat(sink: OtGlyph.Stat.Sink): void;
}
export declare class CompositeGlyph extends SpaceGlyph {
    references: OtGlyph.TtReference[];
    instructions: Buffer;
    constructor(classifier: GlyphClassifier, gid: number, hm: OtGlyph.Metric, vm: OtGlyph.Metric, references: OtGlyph.TtReference[], instructions: Buffer);
    private st;
    getStatData(): OtGlyph.Stat.ComplexGlyphStat;
    stat(sink: OtGlyph.Stat.Sink): void;
}
//# sourceMappingURL=classifier.d.ts.map