/***************************************************************************
 *                                  _   _ ____  _
 *  Project                     ___| | | |  _ \| |
 *                             / __| | | | |_) | |
 *                            | (__| |_| |  _ <| |___
 *                             \___|\___/|_| \_\_____|
 *
 * Copyright (C) Daniel Stenberg, <daniel@haxx.se>, et al.
 *
 * This software is licensed as described in the file COPYING, which
 * you should have received as part of this distribution. The terms
 * are also available at https://curl.se/docs/copyright.html.
 *
 * You may opt to use, copy, modify, merge, publish, distribute and/or sell
 * copies of the Software, and permit persons to whom the Software is
 * furnished to do so, under the terms of the COPYING file.
 *
 * This software is distributed on an "AS IS" basis, WITHOUT WARRANTY OF ANY
 * KIND, either express or implied.
 *
 * SPDX-License-Identifier: curl
 *
 ***************************************************************************/
#include "first.h"

struct t667_WriteThis {
  const char *readptr;
  curl_off_t sizeleft;
};

static size_t t667_read_cb(char *ptr, size_t size, size_t nmemb, void *userp)
{
  struct t667_WriteThis *pooh = (struct t667_WriteThis *)userp;
  int eof;

  if(size * nmemb < 1)
    return 0;

  eof = pooh->sizeleft <= 0;
  if(!eof)
    pooh->sizeleft--;

  if(!eof) {
    *ptr = *pooh->readptr;           /* copy one single byte */
    pooh->readptr++;                 /* advance pointer */
    return 1;                        /* we return 1 byte at a time! */
  }

  return 0;                         /* no more data left to deliver */
}

static CURLcode test_lib667(const char *URL)
{
  static const char testdata[] = "dummy";

  CURL *curl = NULL;
  curl_mime *mime = NULL;
  curl_mimepart *part;
  CURLcode res = TEST_ERR_FAILURE;
  struct t667_WriteThis pooh;

  /*
   * Check proper handling of mime encoder feature when the part read callback
   * delivers data bytes one at a time. Use chunked encoding for accurate test.
   */

  if(curl_global_init(CURL_GLOBAL_ALL) != CURLE_OK) {
    curl_mfprintf(stderr, "curl_global_init() failed\n");
    return TEST_ERR_MAJOR_BAD;
  }

  curl = curl_easy_init();

  /* First set the URL that is about to receive our POST. */
  test_setopt(curl, CURLOPT_URL, URL);

  /* get verbose debug output please */
  test_setopt(curl, CURLOPT_VERBOSE, 1L);

  /* include headers in the output */
  test_setopt(curl, CURLOPT_HEADER, 1L);

  /* Prepare the callback structure. */
  pooh.readptr = testdata;
  pooh.sizeleft = (curl_off_t)strlen(testdata);

  /* Build the mime tree. */
  mime = curl_mime_init(curl);
  part = curl_mime_addpart(mime);
  curl_mime_name(part, "field");
  curl_mime_encoder(part, "base64");
  /* Using an undefined length forces chunked transfer. */
  curl_mime_data_cb(part, (curl_off_t)-1, t667_read_cb, NULL, NULL, &pooh);

  /* Bind mime data to its easy handle. */
  test_setopt(curl, CURLOPT_MIMEPOST, mime);

  /* Send data. */
  res = curl_easy_perform(curl);
  if(res != CURLE_OK) {
    curl_mfprintf(stderr, "curl_easy_perform() failed\n");
  }

test_cleanup:
  curl_easy_cleanup(curl);
  curl_mime_free(mime);
  curl_global_cleanup();
  return res;
}
