int StreamBuf::overflow(int ch)     // writing
{
    size_t offs = getOffset();

    if (offs >= maxend)           // at maxend: no more space
        return EOF;
                                    // define the writing buffer
    setp(allData + bufbeg, allData + bufend);
    pbump(offs - bufbeg);       // go to the pos. to write the next ch

    *pptr() = ch;                   // write ch to the buffere
    pbump(1);
    ++offset;
                                    // maybe enlarge getend
    getend = max(getend, bufbeg + (pptr() - pbase()));

    d_last = WRITE;                 // change to writing mode
                                    // return the last written char
    return static_cast<unsigned char>(ch);
}
