# Changelog

All notable changes to this project will be documented in this file.

The format is based on [Keep a Changelog](https://keepachangelog.com/en/1.1.0/),
and this project adheres to [Semantic Versioning](https://semver.org/spec/v2.0.0.html).

## [2.5] - 2025-12-22

### Added

- The weaving plan can now be checked for violations against #pragma acxx affect rules. A test program has been added. More code cleanup needed.

- Implemented #pragma acxx filter, which affects matching of joinpoints in the next advice that follows in the source code: Only joinpoints with shadows that are located in the matched file names are woven

- Added --gen_deps option to create an aspect dependency from '#pragma acxx affect <pattern>' directives in aspect headers; Updated the compiler manual on the --gen_deps option and the new pragmas "affect" and "filter"

- Error message are now being printed with Clang's DiagnosticEngine class. Therefore, the messages contain more information.

- Improved layout of manuals in PDF and HTML variants including syntax hightlighting for AspectC++ code in HTML

- Integrated fix for tricore target: all sizes and alignments of built-in datatypes should now be consistent with the back-end compiler; asm(...) is being skipped as clang doesn't know the correct register names; Added section on tricore compiler support in the compiler manual

- Better handling of paths with whitespace in the example makefile

- Ported to Clang 20.1.2 and 21.1.6

- Add documentation of ac++ code transformation patterns in the compile manual

- Added relation 'refs' to ACM_Pointcut in the project model; it refers to the elements returned by name lookup while parsing the pointcut expression; thereby the expression tree can be reconstructed easily after loading the model

- Added experimental feature: for get/set joinpoints the joinpoint-API now contains a static constexpr member function named 'variable()' if the backend compiler supports C++17. For get/set on global variables it returns a pointer to this variable as a compile-time constant that can be used as a template parameter, which has various
useful applications. For member variables the function returns 'nullptr'.

- Improved weaving pattern for mixed C/C++ projects: (1) Friend declarations are only inserted into classes that are not C-like; they don't need it, because nothing is private; (2) Inserted forward declarations are encapsulated in #ifdef __cplusplus and extern "C++".

- Added phase 1 support for C++ 11 inline namespaces

- Extended phase 1 parser to support namespace aliases and named pointcuts in unnamed namespace, thereby also fixing bug 796

- Created new test program that uses advice for builtin operator / to detect and handle division by zero errors

- Added support for C++17 annotations that are start with 'using <namespace>:' and extended the reference manual accordingly

### Changed

- Changed two tests so that results with clang++ and g++ as back-end compilers are identical

- Project model changes: now contains project paths with ids; filenames in the project tree are relative to a project path; the 'filename' utility function can now return the canonical path; source locations have been improved by omitting registration in the introducer

- ACProject now determines the support backend C++ standards and provides a function for checking it

### Fixed

- Made ac++ ignore 'preferred names' of standard library templates such as std::string

- Fixed/simplified handling of statement attributes in clang 20 and above

- Various fixes needed for MacOS version: (1) Fixed internal lexing function in ClangIntroducer, becaused the old implementation segfaulted on MacOS; There must have been changes in Clang's preprocessor interface; (2) Now we handle attributes in namespace '_Clang' correctly; (3) Relaxed diagnostic of attributed parameter of built-in attributes as they can be arbitrary identifiers; (4) Fixed definition of built-in macros in ACProject class; (5) Class for sorting aspects no longer inherits from binary_function; (6) Makefile and manual improvements

- Fixed filename delimiter handling on Windows, which caused tests to fail

- Fixed race condition when creating a repository file: Two processes might have found simultaneously that no model file exists and then create one. In this situation information might be overwritten by the second process. We now use a separate lock file for the repository to avoid problems with the latest libxml2 versions that release the lock during normal operations

- Improved ResultBuffer implementation to fix bug 801

- Fixed bug #800 and thereby test 'STLString': reverted changes of revision 1650 and added a new fix for the problem that caused the implementation of revision 1650.

- Fixed bug #777 (problems with rvalue references in argument lists) and bug #799 (handling of advice for out of line functions in anonymous namespaces)

- Fixed bug #798: attributes can now be attached to aspects -- not only to classes

- Fixed handling of possible types in semantic analysis of pointcut expressions; this fixes the bug 'derived' could not match aspects.

- Fixed wrong handling of anonymous structs that are preceeded by 'static'; Improved handling of command line options

- Fixed problem with g++ 12.x and older as back-end compiler; AC::_FloatN was not defined in this case, which cause the definition of __float80 on x86 to be invalid

- Workaround to support gcc's datatype __float80 on x86

- Fixed ACModel CFLAGS; debugging did not work as expected

- Fixed insertion position for includes that are needed in case of introductions; if the outmost class definition is embedded in a typedef, the insertion position must be the start position of the typedef and *not* the class keyword

- Fixed signature generation for template argument packs in template argument lists
